﻿(function () {
    'use strict';
    newERP.service('ValidarFormularioService', ['$q', function ($q) {
        var validarFormularioFactory = {};

        var _listaFormularioInvalido = function (formulario, listaValidacao) {
            var defer = $q.defer();
            var listaFormularioInvalido = [];
            var mensagemFormularioInvalido = 'Antes de salvar verifique o erro:';
            angular.forEach(formulario, function (form) {
                if (typeof form === "object") {
                    if (!!form.$name) {
                        var emBranco = false;
                        if (!!form.$error.required == true) {
                            angular.forEach(listaValidacao, function (lista) {
                                if (lista.nome === form.$name && lista.obrigatorio != '') {
                                    listaFormularioInvalido.push({ nome: lista.nome, mensagem: lista.obrigatorio });
                                    emBranco = true;
                                }
                            });
                        }
                        if (!form.$valid && !emBranco) {
                            angular.forEach(listaValidacao, function (lista) {
                                if (lista.nome === form.$name && lista.invalido != '') {
                                    listaFormularioInvalido.push({ nome: lista.nome, mensagem: lista.invalido });
                                }
                            });
                        }
                    }
                }
            });

            if (listaFormularioInvalido.length > 1)
                mensagemFormularioInvalido = 'Antes de salvar verifique os erros:';

            defer.resolve({
                lista: listaFormularioInvalido,
                mensagem: mensagemFormularioInvalido
            });

            return defer.promise;
        };

        validarFormularioFactory.listaFormularioInvalido = _listaFormularioInvalido;

        return validarFormularioFactory;
    }]);
})();