﻿(function () {
    'use strict';
    newERP.service('RelatorioService', function () {
        var relatorioFactory = {};
        var nomeRelatorio = null;
        var _exibirRelatorio = function (idRelatorio, parametrosRelatorio, parametrosFiltroInterno) {
            try {
                var estruturaRelatorio = JSON.parse(relatorioAppService.retornaRelatorio(idRelatorio));
                nomeRelatorio = estruturaRelatorio.nome;

                var listaFiltros = [];
                var dadosFiltroInterno = [];
                angular.forEach(estruturaRelatorio.dataSources, function (dataSource) {
                    angular.forEach(JSON.parse(dataSource.parametros), function (parametro) {
                        if ((!!parametro.utilizar == true) && (!!parametro.interno == false)) {
                            parametro.idDataSource = dataSource.id;
                            parametro.relacionamento = dataSource.relacionamento;
                            angular.forEach(parametrosRelatorio, function (parRel) {
                                if (parRel.nome === parametro.nome) {
                                    parametro.model = parRel.valor;
                                    if (!!parRel.modelDataParametro) parametro.modelDataParametro = parRel.modelDataParametro;
                                }
                            })

                            listaFiltros.push(parametro);
                        }
                    })

                    if (!!dataSource.parametrosInternos) {
                        angular.forEach(JSON.parse(dataSource.parametrosInternos), function (parametroInterno) {
                            if ((!!parametroInterno.utilizar == true) && (!!parametroInterno.interno == false)) {
                                parametroInterno.idDataSource = dataSource.id;
                                parametroInterno.relacionamento = dataSource.relacionamento;

                                listaFiltros.push(parametroInterno);
                            }
                        })
                    }
                })

                var dadosRelatorio = JSON.parse(relatorioAppService.retornaDadosRelatorio(idRelatorio, listaFiltros));

                var atributosSquema = [];
                angular.forEach(estruturaRelatorio.dataSources, function (dataSource) {
                    angular.forEach(JSON.parse(dataSource.atributos), function (atributo) {
                        var possuiEsteAtributo = atributosSquema.find(function (atr) {
                            return (atr.name === atributo.nomeExibir) ? true : false;
                        });
                        if (!possuiEsteAtributo) atributosSquema.push({ name: atributo.nomeExibir, type: atributo.tipo });
                    })
                })

                for (var i = 0; i < listaFiltros.length; i++) {
                    if (listaFiltros[i].tipo != "select") {
                        if (listaFiltros[i].model == undefined || listaFiltros[i].model == false) {
                            listaFiltros[i].model = null;
                        }
                        var nome = listaFiltros[i].nome;
                        var parametroInterno = nome.substring(nome.length - 7, nome.length);
                        if (parametroInterno != "Interno") {
                            var nomeSemInicias = nome.substring(4, nome.length);
                            nome = nomeSemInicias;
                        }
                        dadosFiltroInterno.push({ [nome]: listaFiltros[i].model });
                        if (listaFiltros[i].tipo == "date") {
                            if (listaFiltros[i].modelDataParametro == undefined) listaFiltros[i].modelDataParametro = null;
                            nome += "Final";
                            dadosFiltroInterno.push({ [nome]: listaFiltros[i].modelDataParametro });
                        }
                    }
                }

                angular.forEach(parametrosFiltroInterno, function (filtroInterno) {
                    for (var i = 0; i < dadosFiltroInterno.length; i++) {
                        var nome = filtroInterno.nome;
                        if (nome in dadosFiltroInterno[i]) {
                            dadosFiltroInterno.splice(i, 1);
                            dadosFiltroInterno.push({ [nome]: filtroInterno.valor });
                        }
                    }
                })

                var montaDataSource = {
                    id: "Relatorio",
                    name: "Relatorio",
                    data: dadosRelatorio,
                    schema: {
                        fields: atributosSquema
                    }
                };

                var dataSource = [];
                dataSource.push(montaDataSource);


                jsreports.export({
                    report_def: estruturaRelatorio.jsonRelatorio,
                    datasets: dataSource,
                    format: 'pdf',
                    outputHandler: function (dados) {
                        window.open(URL.createObjectURL(dados), '_blank');
                    }
                });
            } catch (e) {
                console.error(e.message);
                var titulo = (!!nomeRelatorio) ? "Ops!! Não foi possível gerar o relatório " + nomeRelatorio : "Ops!! Não foi possível gerar o relatório!";
                swal({
                    title: titulo,
                    text: "",
                    type: "warning",
                    showCancelButton: true,
                    cancelButtonText: "Não",
                    confirmButtonClass: "btn-primary",
                    confirmButtonText: "Tentar novamente",
                    closeOnConfirm: false
                }, function (tentarNovamente) {
                    if (!!tentarNovamente)
                        _exibirRelatorio(idRelatorio, parametrosRelatorio);
                });
            }
        };
        var _exibirRelatorioJasper = function (idRelatorio, parametrosRelatorio) {
            try {
                var estruturaRelatorio = JSON.parse(relatorioAppService.retornaRelatorioJasper(idRelatorio));
                console.log('estruturaRelatorio', estruturaRelatorio);
                var params = [];
                angular.forEach(estruturaRelatorio.listaParametros, function (param) {
                    if (parametrosRelatorio[param.rpj_nomeelemento]) {
                        if (param.rpj_obrigatorio == true) {
                            return;
                        }
                    } else {
                        var elemento = parametrosRelatorio.find(element => element.nome == param.rpj_nomeelemento)
                        params.push({ "nome": param.rpj_nomeelemento, "valor": elemento.valor });
                    }
                })
                var dadosRelatorio = JSON.parse(relatorioAppService.retornaDadosRelatorioJasper(idRelatorio, JSON.stringify(params), estruturaRelatorio.rel_nomearquivo, estruturaRelatorio.rel_nome));
                var byteCharacters = atob(dadosRelatorio.fileContents);
                var byteNumbers = new Array(byteCharacters.length);
                for (let i = 0; i < byteCharacters.length; i++) {
                    byteNumbers[i] = byteCharacters.charCodeAt(i);
                }
                var byteArray = new Uint8Array(byteNumbers);
                var file = new Blob([byteArray], { type: 'application/pdf;base64' });
                var fileURL = URL.createObjectURL(file);
                window.open(fileURL,'_blank');
            } catch (e) {
                console.log(e);
            }
        };

        relatorioFactory.exibirRelatorio = _exibirRelatorio;
        relatorioFactory.exibirRelatorioJasper = _exibirRelatorioJasper;

        return relatorioFactory;
    });
})();