﻿newERP.filter('trustedHtml', ['$sce', function ($sce) {
    return function (text) {
        return $sce.trustAsHtml(text);
    };
}]);

newERP.filter('cpfCnpj', function () {
    return function (input) {
        if (!!input)
            if (input.length > 11) {
                var str = input + '';
                str = str.replace(/\D/g, '');
                str = str.replace(/^(\d{2})(\d)/, '$1.$2');
                str = str.replace(/^(\d{2})\.(\d{3})(\d)/, '$1.$2.$3');
                str = str.replace(/\.(\d{3})(\d)/, '.$1/$2');
                str = str.replace(/(\d{4})(\d)/, '$1-$2');
            } else {
                var str = input + '';
                str = str.replace(/\D/g, '');
                str = str.replace(/(\d{3})(\d)/, "$1.$2");
                str = str.replace(/(\d{3})(\d)/, "$1.$2");
                str = str.replace(/(\d{3})(\d{1,2})$/, "$1-$2");
            }
        return str;
    };
});

newERP.filter('cnpj', function () {
    return function (input) {
        if (!!input) {
            var str = input + '';
            str = str.replace(/\D/g, '');
            str = str.replace(/^(\d{2})(\d)/, '$1.$2');
            str = str.replace(/^(\d{2})\.(\d{3})(\d)/, '$1.$2.$3');
            str = str.replace(/\.(\d{3})(\d)/, '.$1/$2');
            str = str.replace(/(\d{4})(\d)/, '$1-$2');
        }
        return str;
    };
});

newERP.filter('cpf', function () {
    return function (input) {
        if (!!input) {
            var str = input + '';
            str = str.replace(/\D/g, '');
            str = str.replace(/(\d{3})(\d)/, "$1.$2");
            str = str.replace(/(\d{3})(\d)/, "$1.$2");
            str = str.replace(/(\d{3})(\d{1,2})$/, "$1-$2");
        }
        return str;
    };
});

newERP.filter('cep', function () {
    return function (input) {
        if (!!input) {
            var str = input + '';
            str = str.replace(/\D/g, '');
            str = str.replace(/(\d{5})(\d)/, "$1-$2");
        }
        return str;
    };
});

newERP.filter('telefone', function () {
    return function (input) {
        if (!!input) {
            var str = input + '';
            str = str.replace(/\D/g, '');
            if (str.length === 11) {
                str = str.replace(/^(\d{2})(\d{5})(\d{4})/, '($1) $2-$3');
            } else {
                str = str.replace(/^(\d{2})(\d{4})(\d{4})/, '($1) $2-$3');
            }
        }
        return str;
    };
});

newERP.filter('ie', function () {
    return function (input, uf) {
        if (!!input) {
            var str = input + '';
            switch (uf) {
                case 'AC':// 00.000.000/000-00
                    str = str.replace(/\D/g, '');
                    str = str.replace(/(\d{2})(\d)/, "$1.$2");
                    str = str.replace(/(\d{3})(\d)/, "$1.$2");
                    str = str.replace(/(\d{3})(\d)/, "$1/$2");
                    str = str.replace(/(\d{3})(\d)/, "$1-$2");
                    return str;
                case 'AL':// 000000000
                    str = str.replace(/\D/g, '');
                    return str;
                case 'AM':// 00.000.000-0
                    str = str.replace(/\D/g, '');
                    str = str.replace(/(\d{2})(\d)/, "$1.$2");
                    str = str.replace(/(\d{3})(\d)/, "$1.$2");
                    str = str.replace(/(\d{3})(\d)/, "$1-$2");
                    return str;
                case 'AP':// 000000000
                    str = str.replace(/\D/g, '');
                    return str;
                case 'BA':// 000000-00 // 0000000-00
                    str = str.replace(/\D/g, '');
                    if (str.length == 8) {
                        str = str.replace(/(\d{6})(\d)/, "$1-$2");
                    } else {
                        str = str.replace(/(\d{6})(\d)/, "$1-$2");
                    }
                    return str;
                case 'CE':// 00000000-0
                    str = str.replace(/\D/g, '');
                    str = str.replace(/(\d{8})(\d)/, "$1-$2");
                    return str;
                case 'DF':// 00000000000-00
                    str = str.replace(/\D/g, '');
                    str = str.replace(/(\d{11})(\d)/, "$1-$2");
                    return str;
                case 'ES':// 00000000-0
                    str = str.replace(/\D/g, '');
                    str = str.replace(/(\d{8})(\d)/, "$1-$2");
                    return str;
                case 'GO':// 00.000.000-0
                    str = str.replace(/\D/g, '');
                    str = str.replace(/(\d{2})(\d)/, "$1.$2");
                    str = str.replace(/(\d{3})(\d)/, "$1.$2");
                    str = str.replace(/(\d{3})(\d)/, "$1-$2");
                    return str;
                case 'MA':// 000000000
                    str = str.replace(/\D/g, '');
                    return str;
                case 'MG':// 000.000.000/0000
                    str = str.replace(/\D/g, '');
                    str = str.replace(/(\d{3})(\d)/, "$1.$2");
                    str = str.replace(/(\d{3})(\d)/, "$1.$2");
                    str = str.replace(/(\d{3})(\d)/, "$1/$2");
                    return str;
                case 'MS':// 000000000
                    str = str.replace(/\D/g, '');
                    return str;
                case 'MT':// 0000000000-0
                    str = str.replace(/\D/g, '');
                    str = str.replace(/(\d{10})(\d)/, "$1-$2");
                    return str;
                case 'PA':// 00-000000-0
                    str = str.replace(/\D/g, '');
                    str = str.replace(/(\d{2})(\d)/, "$1-$2");
                    str = str.replace(/(\d{6})(\d)/, "$1-$2");
                    return str;
                case 'PB':// 00000000-0
                    str = str.replace(/\D/g, '');
                    str = str.replace(/(\d{8})(\d)/, "$1-$2");
                    return str;
                case 'PE':// 0000000-00 // 00.0.000.0000000-0
                    str = str.replace(/\D/g, '');
                    if (str.length == 9) {
                        str = str.replace(/(\d{7})(\d)/, "$1-$2");
                    } else {
                        str = str.replace(/(\d{2})(\d)/, "$1.$2");
                        str = str.replace(/(\d{1})(\d)/, "$1.$2");
                        str = str.replace(/(\d{3})(\d)/, "$1.$2");
                        str = str.replace(/(\d{7})(\d)/, "$1-$2");
                    }
                    return str;
                case 'PI':// 000000000
                    str = str.replace(/\D/g, '');
                    return str;
                case 'PR':// 000.00000-00
                    str = str.replace(/\D/g, '');
                    str = str.replace(/(\d{3})(\d)/, "$1.$2");
                    str = str.replace(/(\d{5})(\d)/, "$1-$2");
                    return str;
                case 'RJ':// 00.000.00-0
                    str = str.replace(/\D/g, '');
                    str = str.replace(/(\d{2})(\d)/, "$1.$2");
                    str = str.replace(/(\d{3})(\d)/, "$1.$2");
                    str = str.replace(/(\d{2})(\d)/, "$1-$2");
                    return str;
                case 'RN':// 00.000.000-0 // 00.0.000.000-0
                    str = str.replace(/\D/g, '');
                    if (str.length == 9) {
                        str = str.replace(/(\d{2})(\d)/, "$1.$2");
                        str = str.replace(/(\d{3})(\d)/, "$1.$2");
                        str = str.replace(/(\d{3})(\d)/, "$1-$2");
                    } else {
                        str = str.replace(/(\d{2})(\d)/, "$1.$2");
                        str = str.replace(/(\d{1})(\d)/, "$1.$2");
                        str = str.replace(/(\d{3})(\d)/, "$1.$2");
                        str = str.replace(/(\d{3})(\d)/, "$1-$2");
                    }
                    return str;
                case 'RO':// 0000000000000-0
                    str = str.replace(/\D/g, '');
                    str = str.replace(/(\d{13})(\d)/, "$1-$2");
                    return str;
                case 'RR':// 00000000-0
                    str = str.replace(/\D/g, '');
                    str = str.replace(/(\d{8})(\d)/, "$1-$2");
                    return str;
                case 'RS':// 000/0000000
                    str = str.replace(/\D/g, '');
                    str = str.replace(/(\d{3})(\d)/, "$1/$2");
                    return str;
                case 'SC':// 000.000.000
                    str = str.replace(/\D/g, '');
                    str = str.replace(/(\d{3})(\d)/, "$1.$2");
                    str = str.replace(/(\d{3})(\d)/, "$1.$2");
                    str = str.replace(/(\d{3})(\d)/, "$1.$2");
                    return str;
                case 'SE':// 00000000-0
                    str = str.replace(/\D/g, '');
                    str = str.replace(/(\d{8})(\d)/, "$1-$2");
                    return str;
                case 'SP':// 000.000.000.000 // P-00000000.0/000
                    if (str.indexOf('P') != -1) {
                        str = str.replace(/\D/g, '');
                        str = str.replace(/(\d{8})(\d)/, "$1.$2");
                        str = str.replace(/(\d{1})(\d)/, "$1/$2");
                        str = 'P-' + str;
                    } else {
                        str = str.replace(/\D/g, '');
                        str = str.replace(/(\d{3})(\d)/, "$1.$2");
                        str = str.replace(/(\d{3})(\d)/, "$1.$2");
                        str = str.replace(/(\d{3})(\d)/, "$1.$2");
                        str = str.replace(/(\d{3})(\d)/, "$1.$2");
                    }
                    return str;
                case 'TO':// 00000000000
                    str = str.replace(/\D/g, '');
                    return str;
                default:
                    return str;
            }
        }
    };
});

newERP.filter('hora', function () {
    return function (input) {
        if (!!input) {
            var hora = input;
            hora = hora.replace(":", "");
            var hh = hora.substring(0, 2);
            var mm = hora.substring(2, 4);
            hora = hh + ":" + mm;
        }
        return hora;
    };
});

newERP.filter('trustAsResourceUrl', ['$sce', function ($sce) {
    return function (val) {
        return $sce.trustAsResourceUrl(val);
    };
}]);

newERP.filter('quantidade', ['$locale', function ($locale) {
    return function (quantidade, casasDecimais) {
        if (!!quantidade) {
            if (isNaN(casasDecimais)) {
                casasDecimais = 2;
            }
            var decimalDelimiter = $locale.NUMBER_FORMATS.DECIMAL_SEP,
                thousandsDelimiter = $locale.NUMBER_FORMATS.GROUP_SEP;

            var viewMask = numberViewMask(casasDecimais, decimalDelimiter, thousandsDelimiter),
                modelMask = numberModelMask(casasDecimais);

            var valueToFormat = prepareNumberToFormatter(quantidade, casasDecimais);
            quantidade = viewMask.apply(valueToFormat);
        }
        return quantidade;
    };
}]);

function numberViewMask(decimals, decimalDelimiter, thousandsDelimiter) {
    var mask = '#' + thousandsDelimiter + '##0';

    if (decimals > 0) {
        mask += decimalDelimiter;
        for (var i = 0; i < decimals; i++) {
            mask += '0';
        }
    }

    return new StringMask(mask, {
        reverse: true
    });
}

function numberModelMask(decimals) {
    var mask = '###0';

    if (decimals > 0) {
        mask += '.';
        for (var i = 0; i < decimals; i++) {
            mask += '0';
        }
    }

    return new StringMask(mask, {
        reverse: true
    });
}

function prepareNumberToFormatter(value, decimals) {
    return clearDelimitersAndLeadingZeros((parseFloat(value)).toFixed(decimals));
}

function clearDelimitersAndLeadingZeros(value) {
    var cleanValue = value.replace(/^0*/, '');
    cleanValue = cleanValue.replace(/[^0-9]/g, '');
    return cleanValue;
}

var StringMask = (function () {
    var tokens = {
        '0': { pattern: /\d/, default: '0' },
        '9': { pattern: /\d/, optional: true },
        '#': { pattern: /\d/, optional: true, recursive: true },
        'S': { pattern: /[a-zA-Z]/ },
        '$': { escape: true }
    };
    var isEscaped = function (pattern, pos) {
        var count = 0;
        var i = pos - 1;
        var token = { escape: true };
        while (i >= 0 && token && token.escape) {
            token = tokens[pattern.charAt(i)];
            count += token && token.escape ? 1 : 0;
            i--;
        }
        return count > 0 && count % 2 === 1;
    };
    var calcOptionalNumbersToUse = function (pattern, value) {
        var numbersInP = pattern.replace(/[^0]/g, '').length;
        var numbersInV = value.replace(/[^\d]/g, '').length;
        return numbersInV - numbersInP;
    };
    var concatChar = function (text, character, options) {
        if (options.reverse) return character + text;
        return text + character;
    };
    var hasMoreTokens = function (pattern, pos, inc) {
        var pc = pattern.charAt(pos);
        var token = tokens[pc];
        if (pc === '') return false;
        return token && !token.escape ? true : hasMoreTokens(pattern, pos + inc, inc);
    };
    var insertChar = function (text, char, position) {
        var t = text.split('');
        t.splice(position >= 0 ? position : 0, 0, char);
        return t.join('');
    };
    var StringMask = function (pattern, opt) {
        this.options = opt || {};
        this.options = {
            reverse: this.options.reverse || false,
            usedefaults: this.options.usedefaults || this.options.reverse
        };
        this.pattern = pattern;

        StringMask.prototype.process = function proccess(value) {
            if (!value) return '';
            value = value + '';
            var pattern2 = this.pattern;
            var valid = true;
            var formatted = '';
            var valuePos = this.options.reverse ? value.length - 1 : 0;
            var optionalNumbersToUse = calcOptionalNumbersToUse(pattern2, value);
            var escapeNext = false;
            var recursive = [];
            var inRecursiveMode = false;

            var steps = {
                start: this.options.reverse ? pattern2.length - 1 : 0,
                end: this.options.reverse ? -1 : pattern2.length,
                inc: this.options.reverse ? -1 : 1
            };

            var continueCondition = function (options) {
                if (!inRecursiveMode && hasMoreTokens(pattern2, i, steps.inc)) {
                    return true;
                } else if (!inRecursiveMode) {
                    inRecursiveMode = recursive.length > 0;
                }

                if (inRecursiveMode) {
                    var pc = recursive.shift();
                    recursive.push(pc);
                    if (options.reverse && valuePos >= 0) {
                        i++;
                        pattern2 = insertChar(pattern2, pc, i);
                        return true;
                    } else if (!options.reverse && valuePos < value.length) {
                        pattern2 = insertChar(pattern2, pc, i);
                        return true;
                    }
                }
                return i < pattern2.length && i >= 0;
            };

            for (var i = steps.start; continueCondition(this.options); i = i + steps.inc) {
                var pc = pattern2.charAt(i);
                var vc = value.charAt(valuePos);
                var token = tokens[pc];
                if (!inRecursiveMode || vc) {
                    if (this.options.reverse && isEscaped(pattern2, i)) {
                        formatted = concatChar(formatted, pc, this.options);
                        i = i + steps.inc;
                        continue;
                    } else if (!this.options.reverse && escapeNext) {
                        formatted = concatChar(formatted, pc, this.options);
                        escapeNext = false;
                        continue;
                    } else if (!this.options.reverse && token && token.escape) {
                        escapeNext = true;
                        continue;
                    }
                }

                if (!inRecursiveMode && token && token.recursive) {
                    recursive.push(pc);
                } else if (inRecursiveMode && !vc) {
                    if (!token || !token.recursive) formatted = concatChar(formatted, pc, this.options);
                    continue;
                } else if (recursive.length > 0 && token && !token.recursive) {
                    valid = false;
                    continue;
                } else if (!inRecursiveMode && recursive.length > 0 && !vc) {
                    continue;
                }

                if (!token) {
                    formatted = concatChar(formatted, pc, this.options);
                    if (!inRecursiveMode && recursive.length) {
                        recursive.push(pc);
                    }
                } else if (token.optional) {
                    if (token.pattern.test(vc) && optionalNumbersToUse) {
                        formatted = concatChar(formatted, vc, this.options);
                        valuePos = valuePos + steps.inc;
                        optionalNumbersToUse--;
                    } else if (recursive.length > 0 && vc) {
                        valid = false;
                        break;
                    }
                } else if (token.pattern.test(vc)) {
                    formatted = concatChar(formatted, vc, this.options);
                    valuePos = valuePos + steps.inc;
                } else if (!vc && token.default && this.options.usedefaults) {
                    formatted = concatChar(formatted, token.default, this.options);
                } else {
                    valid = false;
                    break;
                }
            }

            return { result: formatted, valid: valid };
        };

        StringMask.prototype.apply = function (value) {
            return this.process(value).result;
        };

        StringMask.prototype.validate = function (value) {
            return this.process(value).valid;
        };
    };

    StringMask.process = function (value, pattern, options) {
        return new StringMask(pattern, options).process(value);
    };

    StringMask.apply = function (value, pattern, options) {
        return new StringMask(pattern, options).apply(value);
    };

    StringMask.validate = function (value, pattern, options) {
        return new StringMask(pattern, options).validate(value);
    };

    return StringMask;
}());