﻿(function () {
    'use strict';
    newERP.directive('newInputCalculadora', ['hotkeys', function (hotkeys) {
        return {
            restrict: 'E',
            templateUrl: 'js/directives/newInputCalculadora/newInputCalculadora.html',
            scope: {
                placeHolder: '@placeHolder',
                ngModel: '=ngModel',
                campoObrigatorio: '=campoObrigatorio',
                nomeElemento: '@nomeElemento',
                ngBlur: "&",
            },
            link: function (scope, element, attrs) {
                scope.nomeElemento = (!!scope.nomeElemento) ? scope.nomeElemento : 'inputCalculadora';
                scope.placeHolder = (!!scope.placeHolder) ? scope.placeHolder : 'Informe o valor (R$)';
                scope.valorCalculado = 0; 

                hotkeys.bindTo(scope);

                scope.keyUm = function () {
                    efeitoClick('keyUm');
                    expressaoCalculo('1');
                };
                scope.keyDois = function () {
                    efeitoClick('keyDois');
                    expressaoCalculo('2');
                };
                scope.keyTres = function () {
                    efeitoClick('keyTres');
                    expressaoCalculo('3');
                };
                scope.keyQuatro = function () {
                    efeitoClick('keyQuatro');
                    expressaoCalculo('4');
                };
                scope.keyCinco = function () {
                    efeitoClick('keyCinco');
                    expressaoCalculo('5');
                };
                scope.keySeis = function () {
                    efeitoClick('keySeis');
                    expressaoCalculo('6');
                };
                scope.keySete = function () {
                    efeitoClick('keySete');
                    expressaoCalculo('7');
                };
                scope.keyOito = function () {
                    efeitoClick('keyOito');
                    expressaoCalculo('8');
                };
                scope.keyNove = function () {
                    efeitoClick('keyNove');
                    expressaoCalculo('9');
                };
                scope.keyZero = function () {
                    efeitoClick('keyZero');
                    expressaoCalculo('0');
                };
                scope.keyMais = function () {
                    efeitoClick('keyMais');
                    operadorCalculo('+');
                };
                scope.keyMenos = function () {
                    efeitoClick('keyMenos');
                    operadorCalculo('-');
                };
                scope.keyMultiplicacao = function () {
                    efeitoClick('keyMultiplicacao');
                    operadorCalculo('*');
                };
                scope.keyDivisao = function () {
                    efeitoClick('keyDivisao');
                    operadorCalculo('/');
                };
                scope.keyVirgula = function () {
                    efeitoClick('keyVirgula');
                    expressaoCalculo('.');
                };
                scope.KeyFechar = function () {
                    efeitoClick('KeyFechar');
                    scope.limparHistorico();
                    scope.exibirCalculadora = false;
                };
                scope.keyBackspace = function () {
                    efeitoClick('keyBackspace');
                    var ultimoNumero = (scope.ultimoNumero).toString();
                    if (ultimoNumero.length > 0) {
                        scope.ultimoNumero = ultimoNumero.substring(0, (ultimoNumero.length - 1));
                    } else {
                        scope.ultimoNumero = '';
                    }
                };
                scope.keyDelete = function () {
                    efeitoClick('keyDelete');
                    scope.ultimoNumero = '';
                };
                scope.keyEnter = function () {
                    efeitoClick('keyEnter');
                    var valorFinal = realizarCalculo();
                    if (scope.historicoCalculo.length == 0)
                        valorFinal = ((scope.ultimoNumero).toString().length > 0) ? parseFloat(scope.ultimoNumero) : 0;
                    scope.limparHistorico();
                    scope.valorCalculado = valorFinal;
                    scope.exibirCalculadora = false;
                };

                scope.ultimoNumero = '';
                scope.valorSubTotal = 0;
                scope.historicoCalculo = [];
                function expressaoCalculo(valor) {
                    scope.ultimoNumero = scope.ultimoNumero + '' + valor;
                };

                function operadorCalculo(operacao) {
                    if ((scope.ultimoNumero).toString().length > 0) {
                        if (scope.historicoCalculo.length == 0) {
                            scope.historicoCalculo.push({
                                valor: parseFloat(scope.ultimoNumero),
                                operacao: ''
                            })
                            scope.historicoCalculo.push({
                                valor: '',
                                operacao: operacao
                            })
                        } else {
                            if (!!scope.historicoCalculo[(scope.historicoCalculo.length - 1)].valor) {
                                scope.historicoCalculo.push({
                                    valor: parseFloat(scope.ultimoNumero),
                                    operacao: operacao
                                })
                            } else {
                                scope.historicoCalculo[(scope.historicoCalculo.length - 1)].valor = parseFloat(scope.ultimoNumero);
                            }
                        }
                    } else {
                        if (scope.historicoCalculo.length == 0) {
                            scope.historicoCalculo.push({
                                valor: 0,
                                operacao: operacao
                            })
                        } else {
                            scope.historicoCalculo[(scope.historicoCalculo.length - 1)].operacao = operacao;
                        }
                    }

                    scope.valorSubTotal = realizarCalculo();
                    scope.ultimoNumero = '';
                    setarScroll();
                };

                function setarScroll() {
                    setTimeout(function () {
                        var divLhistorico = document.getElementById("lhistorico");
                        divLhistorico.scrollTop = divLhistorico.scrollHeight;
                    }, 100);
                }

                scope.limparHistorico = function () {
                    scope.historicoCalculo = [];
                    scope.valorCalculado = 0;
                    scope.ultimoNumero = '';
                    scope.valorSubTotal = 0;
                };

                function realizarCalculo() {
                    var valorCalculado = 0;
                    scope.historicoCalculo.map(function (h) {
                        if (!!h.operacao) {
                            if (!!h.valor)
                                valorCalculado = parseFloat(eval(valorCalculado + '' + h.operacao + '' + h.valor));
                        } else {
                            valorCalculado = h.valor;
                        }
                    })
                    return valorCalculado;
                };

                scope.retornaUltimoNumero = function () {
                    scope.ultimoNumero = (!!scope.ultimoNumero) ? scope.ultimoNumero : 0;
                    return parseFloat(scope.ultimoNumero);
                };

                function efeitoClick(idElemento) {
                    document.getElementById(idElemento).classList.remove('b-c-formula');
                    document.getElementById(idElemento).classList.add('b-c-formula');
                    setTimeout(function () {
                        document.getElementById(idElemento).classList.remove('b-c-formula');
                    }, 450)
                }

                scope.$watchCollection('valorCalculado', function (novoValorCalculado, antigoValorCalculado) {
                    scope.ngModel = novoValorCalculado;
                    scope.ngBlur({ valorInterno: novoValorCalculado })
                }, true);
            }
        }
    }]);
})();