﻿(function () {
    newERP.directive('formataData', ['growlService', function (growlService) {
        return {
            restrict: 'A',
            require: '?ngModel',
            replace: false,
            link: function (scope, element, attrs, ngModel) {
                var delay = (function () {
                    var timer = 0;
                    return function (callback, ms) {
                        clearTimeout(timer);
                        timer = setTimeout(callback, ms);
                    };
                })();

                element.on('keyup', function (key) {
                    if (key.keyCode == 8) {
                        delay(function () {
                            var dataHoje = new Date();
                            var anoDataHoje = dataHoje.getFullYear().toString();
                            var mesDataHoje = (dataHoje.getMonth() + 1).toString();
                            if (mesDataHoje.length < 2) mesDataHoje = '0' + mesDataHoje;

                            var campo = (!!document.forms[ngModel.$$parentForm.$name][ngModel.$name].length) ? document.forms[ngModel.$$parentForm.$name][ngModel.$name][0].value : document.forms[ngModel.$$parentForm.$name][ngModel.$name].value;
                            var dt = campo.split('/');
                            var dia = apenasNumeros((dt[0]).toString());
                            if (dia.length < 2) dia = '0' + dia;

                            if (!!!dt[1]) {
                                dt.push("");
                            }
                            var mes = apenasNumeros((dt[1]).toString());
                            if (!!!mes || mes.length == 1) {
                                mes = mesDataHoje;
                            }

                            if (!!!dt[2]) {
                                dt.push("");
                            }
                            var ano = apenasNumeros((dt[2]).toString());
                            if (ano.length == 0 || ano.length == 3) {
                                ano = anoDataHoje;
                            } else if (ano.length == 2) {
                                if (anoDataHoje.substring(2, 4) == ano) {
                                    ano = anoDataHoje;
                                }
                            }

                            document.forms[ngModel.$$parentForm.$name][ngModel.$name].value = dt;
                            if (!!document.forms[ngModel.$$parentForm.$name][ngModel.$name].length) {
                                document.forms[ngModel.$$parentForm.$name][ngModel.$name][0].value = dt;
                            }
                            ngModel.$setViewValue(dt);

                            formatarDataCadaNumero();
                        }, 1500);
                    } else {
                        delay(function () {
                            formatarDataCadaNumero();
                        }, 500);
                    }
                });

                var formatarDataCadaNumero = function () {
                    if (ngModel.$viewValue != '')
                        if (ngModel.$viewValue.length <= 10) {
                            var dt = apenasNumeros(ngModel.$viewValue);

                            if (apenasNumeros(dt.substring(0, 1)))
                                if (dt.substring(0, 1) > 3)
                                    dt = 3 + '' + dt.charAt(1) + '' + dt.charAt(2) + '' + dt.charAt(3) + '' + dt.substring(4, 8);

                            if (apenasNumeros(dt.substring(1, 2)))
                                if (dt.substring(1, 2) >= 2 && dt.substring(0, 1) > 2)
                                    dt = dt.charAt(0) + '' + 1 + '' + dt.charAt(2) + '' + dt.charAt(3) + '' + dt.substring(4, 8);

                            if (apenasNumeros(dt.substring(2, 3)))
                                if (dt.substring(2, 3) > 1)
                                    dt = dt.charAt(0) + '' + dt.charAt(1) + '' + 1 + '' + dt.charAt(3) + '' + dt.substring(4, 8);

                            if (apenasNumeros(dt.substring(3, 4)))
                                if (dt.substring(3, 4) > 2 && dt.substring(2, 3) > 0)
                                    dt = dt.charAt(0) + '' + dt.charAt(1) + '' + dt.charAt(2) + '' + 2 + '' + dt.substring(4, 8);

                            if (apenasNumeros(dt.substring(4, 5)))
                                if (dt.substring(2, 3) == 0 && dt.substring(3, 4) == 0)
                                    dt = dt.charAt(0) + '' + dt.charAt(1) + '01' + dt.substring(4, 8);


                            var dataFormatada = '';
                            angular.forEach(dt, function (data) {
                                dataFormatada += data;
                                if (dataFormatada.length == 2) {
                                    dataFormatada = dataFormatada + '/';
                                } else if (dataFormatada.length == 5) {
                                    dataFormatada = dataFormatada + '/';
                                }
                            });
                            dt = dataFormatada;
                            document.forms[ngModel.$$parentForm.$name][ngModel.$name].value = dt;
                            if (!!document.forms[ngModel.$$parentForm.$name][ngModel.$name].length) {
                                document.forms[ngModel.$$parentForm.$name][ngModel.$name][0].value = dt;
                            }
                            ngModel.$setViewValue(dt);
                        } else {
                            var dt = apenasNumeros(ngModel.$viewValue);
                            var dataFormatada = '';
                            angular.forEach(dt.substring(0, 8), function (data) {
                                dataFormatada += data;
                                if (dataFormatada.length == 2) {
                                    dataFormatada = dataFormatada + '/';
                                } else if (dataFormatada.length == 5) {
                                    dataFormatada = dataFormatada + '/';
                                }
                            });

                            dt = dataFormatada;
                            document.forms[ngModel.$$parentForm.$name][ngModel.$name].value = dt;
                            if (!!document.forms[ngModel.$$parentForm.$name][ngModel.$name].length) {
                                document.forms[ngModel.$$parentForm.$name][ngModel.$name][0].value = dt;
                            }
                            ngModel.$setViewValue(dt);
                        }
                };

                element.on('blur', function () {
                    if (!!ngModel.$viewValue) {
                        var dataHoje = new Date();
                        var anoDataHoje = dataHoje.getFullYear().toString();
                        var mesDataHoje = (dataHoje.getMonth() + 1).toString();
                        if (mesDataHoje.length < 2) mesDataHoje = '0' + mesDataHoje;

                        var campo = (!!document.forms[ngModel.$$parentForm.$name][ngModel.$name].length) ? document.forms[ngModel.$$parentForm.$name][ngModel.$name][0].value : document.forms[ngModel.$$parentForm.$name][ngModel.$name].value;
                        var dt = campo.split('/');
                        if (dt.length == 1) {
                            if (dt[0].length > 2) {
                                var numeroDt = dt[0];
                                dt[0] = numeroDt.substring(0, 2);
                                dt.push(numeroDt.substring(2, numeroDt.length));
                            }
                            if (!!dt[1])
                                if (dt[1].length > 2) {
                                    var numeroDt = dt[1];
                                    dt[1] = numeroDt.substring(0, 2);
                                    dt.push(numeroDt.substring(2, numeroDt.length));
                                }
                            if (!!dt[2])
                                if (dt[2].length > 4) {
                                    var numeroDt = dt[2];
                                    dt[2] = numeroDt.substring(0, 4);
                                }
                        }

                        var dia = apenasNumeros((dt[0]).toString());
                        if (dia.length < 2) dia = '0' + dia;

                        if (!!!dt[1]) {
                            dt.push("");
                        }
                        var mes = apenasNumeros((dt[1]).toString());
                        if (!!!mes || mes.length == 1) {
                            mes = mesDataHoje;
                        }

                        if (!!!dt[2]) {
                            dt.push("");
                        }
                        var ano = apenasNumeros((dt[2]).toString());
                        if (ano.length == 0 || ano.length == 3) {
                            ano = anoDataHoje;
                        } else if (ano.length == 2) {
                            if (anoDataHoje.substring(2, 4) == ano) {
                                ano = anoDataHoje;
                            }
                        }

                        dt = new Date(mes + '/' + dia + '/' + ano);

                        if (!!!validarData(dt)) {
                            document.forms[ngModel.$$parentForm.$name][ngModel.$name].value = '';
                            ngModel.$setViewValue('');
                            if (!!document.forms[ngModel.$$parentForm.$name][ngModel.$name].length) {
                                document.forms[ngModel.$$parentForm.$name][ngModel.$name][0].value = '';
                                document.forms[ngModel.$$parentForm.$name][ngModel.$name][0].focus();
                            } else {
                                document.forms[ngModel.$$parentForm.$name][ngModel.$name].focus();
                            }

                        } else {
                            var atributos = (!!document.forms[ngModel.$$parentForm.$name][ngModel.$name].length) ? document.forms[ngModel.$$parentForm.$name][ngModel.$name][0] : document.forms[ngModel.$$parentForm.$name][ngModel.$name];

                            var maxDate = angular.element('[ng-model="' + atributos.getAttribute("max-date") + '"]');
                            if (atributos.getAttribute("max-date") == 'maxDate') {
                                if (compararDatas(dt) == 1) {
                                    growlService.growl('A data não pode ser superior a ' + formataData(new Date()) + '!', 'inverse');
                                    if (atributos.getAttribute("required") == 'required') {
                                        dt = new Date();
                                    } else {
                                        dt = '';
                                    }
                                }
                            } else {
                                if (!!maxDate[0]) {
                                    var dataMaxima = maxDate[0].value;
                                    for (var i = 0; i < maxDate.length; i++) {
                                        if ((maxDate[i].name) == '_' + ngModel.$name) {
                                            dataMaxima = maxDate[i].value;
                                            break;
                                        }
                                    }
                                    var dataMax = new Date(formataDataInvertida(dataMaxima));

                                    if (compararDatas(dt, dataMax) == 1) {
                                        growlService.growl('A data não pode ser superior a ' + dataMaxima + '!', 'inverse');
                                        if (atributos.getAttribute("required") == 'required') {
                                            dt = dataMax;
                                        } else {
                                            dt = '';
                                        }
                                    }
                                } else {
                                    for (var i = 0; i < maxDate.context.forms[0].length; i++) {
                                        if (maxDate.context.forms[0][i].name === ngModel.$name) {
                                            for (var x = 0; x < maxDate.context.forms[0][i].attributes.length; x++) {
                                                if (maxDate.context.forms[0][i].attributes[x].name === "max-date") {
                                                    var dataMaxima = maxDate.context.forms[0][i].attributes[x].value;
                                                    break;
                                                }
                                            }
                                        }
                                    }

                                    var dataMax = new Date(formataDataInvertida(dataMaxima));

                                    if (compararDatas(dt, dataMax) == 1) {
                                        growlService.growl('A data não pode ser superior a ' + dataMaxima + '!', 'inverse');
                                        if (atributos.getAttribute("required") == 'required') {
                                            dt = dataMax;
                                        } else {
                                            dt = '';
                                        }
                                    }
                                }
                            }

                            var minDate = angular.element('[ng-model="' + atributos.getAttribute("min-date") + '"]');
                            if (!!minDate[0]) {
                                var dataMinima = minDate[0].value;
                                var dataMin = new Date(formataDataInvertida(dataMinima));

                                if (compararDatas(dt, dataMin) == -1) {
                                    growlService.growl('A data não pode ser inferior a ' + dataMinima + '!', 'inverse');
                                    if (atributos.getAttribute("required") == 'required') {
                                        dt = dataMin;
                                    } else {
                                        dt = '';
                                    }
                                }
                            } else {
                                if (atributos.getAttribute("min-date") == 'minDate') {
                                    if (compararDatas(dt) == -1) {
                                        growlService.growl('A data não pode ser inferior a ' + formataData(new Date()) + '!', 'inverse');
                                        if (atributos.getAttribute("required") == 'required') {
                                            dt = new Date();
                                        } else {
                                            dt = '';
                                        }
                                    }
                                }
                            }

                            dt = (!!dt) ? formataData(dt) : '';
                            document.forms[ngModel.$$parentForm.$name][ngModel.$name].value = dt;
                            if (!!document.forms[ngModel.$$parentForm.$name][ngModel.$name].length) {
                                document.forms[ngModel.$$parentForm.$name][ngModel.$name][0].value = dt;
                            }
                            ngModel.$setViewValue(dt);
                        }
                    }
                });

                function validarData(data) {
                    if (Object.prototype.toString.call(data) === "[object Date]") {
                        if (isNaN(data.getTime())) {
                            return false
                        }
                        else {
                            return true
                        }
                    }
                    else {
                        return false;
                    }
                }

                function formataDataInvertida(data) {
                    var dia = data.substring(0, 2);
                    var mes = data.substring(3, 5);
                    var ano = data.substring(6, 10);

                    if (mes.length < 2) mes = '0' + mes;
                    if (dia.length < 2) dia = '0' + dia;

                    return ([ano, mes, dia].join('-')).concat('T12:00:00');
                };

                function apenasNumeros(string) {
                    var numsStr = (!!string) ? string.toString().replace(/[\D]+/g, '') : '';
                    return numsStr;
                }

                function formataData(date) {
                    var d = new Date(date || Date.now()),
                        dia = '' + d.getDate(),
                        mes = '' + (d.getMonth() + 1),
                        ano = d.getFullYear();

                    if (mes.length < 2) mes = '0' + mes;
                    if (dia.length < 2) dia = '0' + dia;

                    return [dia, mes, ano].join('/');
                }

                function compararDatas(data1, data2) {
                    var a = new Date(data1);
                    var b = (!!data2) ? new Date(data2) : new Date();

                    var msDateA = Date.UTC(a.getFullYear(), a.getMonth() + 1, a.getDate());
                    var msDateB = Date.UTC(b.getFullYear(), b.getMonth() + 1, b.getDate());

                    if (parseFloat(msDateA) < parseFloat(msDateB))
                        return -1;
                    else if (parseFloat(msDateA) == parseFloat(msDateB))
                        return 0;
                    else if (parseFloat(msDateA) > parseFloat(msDateB))
                        return 1;
                    else
                        return null;
                }
            }
        };
    }]);
})();