﻿newERP.controller('HomeController', ['$scope', 'ModalService', 'FuncaoService', '$state', 'hotkeys', function ($scope, ModalService, FuncaoService, $state, hotkeys) {

    $scope.listaProdutos = {
        maisVendidos: [],
        menosVendidos: [],
        dataInicial: new Date(),
        dataFinal: new Date()
    };

    $scope.model = {
        ordemCrescente: [
            {
                descricao: 'Por Valor', ordem: '+valor', mostrarValor: true
            },
            {
                descricao: 'Por Quantidade', ordem: '+quantidade', mostrarValor: false
            }
        ],
        ordemDecrescente: [
            {
                descricao: 'Por Valor', ordem: '-valor', mostrarValor: true
            },
            {
                descricao: 'Por Quantidade', ordem: '-quantidade', mostrarValor: false
            }
        ],
        ordenarMaisVendidos: [{
            descricao: 'Por Valor', ordem: '+valor', mostrarValor: true
        }][0],
        ordenarMenosVendidos: [{
            descricao: 'Por Valor', ordem: '-valor', mostrarValor: true
        }][0]
    };

    $scope.buscarProdutosMaisVendidos = function (ordem, dataInicial, dataFinal) {
        $scope.listaProdutos.dataInicial = (!!dataInicial) ? dataInicial : $scope.listaProdutos.dataInicial;
        $scope.listaProdutos.dataFinal = (!!dataFinal) ? dataFinal : $scope.listaProdutos.dataFinal;
        $scope.listaProdutos.maisVendidos = JSON.parse(produtoAppService.retornaProdutosMaisMenosVendidos(ordem, $scope.listaProdutos.dataInicial, $scope.listaProdutos.dataFinal));
    };

    $scope.buscarProdutosMenosVendidos = function (ordem, dataInicial, dataFinal) {
        $scope.listaProdutos.dataInicial = (!!dataInicial) ? dataInicial : $scope.listaProdutos.dataInicial;
        $scope.listaProdutos.dataFinal = (!!dataFinal) ? dataFinal : $scope.listaProdutos.dataFinal;
        $scope.listaProdutos.menosVendidos = JSON.parse(produtoAppService.retornaProdutosMaisMenosVendidos(ordem, $scope.listaProdutos.dataInicial, $scope.listaProdutos.dataFinal));
    };

    $scope.enumTicketMedio = {
        hoje: 0,
        semana: 1,
        mes: 2,
        outroPeriodo: 3
    };

    var dataAtual = new Date();
    $scope.filtro = {
        dataInicial: new Date(dataAtual.getFullYear(), dataAtual.getMonth(), 1),
        dataFinal: new Date(dataAtual.getFullYear(), dataAtual.getMonth() + 1, 0),
        exibirOutroPeriodo: false
    };

    $scope.enumTicketMedioSelecionado = $scope.enumTicketMedio.hoje;
    $scope.buscarTicketMedio = function (enumTicketMedio) {
        $scope.enumTicketMedioSelecionado = enumTicketMedio;
        switch (enumTicketMedio) {
            case 0:
                var dataHoje = FuncaoService.formataDataInvertida();
                $scope.dadosTicketMedio = JSON.parse(notaFiscalAppService.retornaTicketMedio(dataHoje, dataHoje));
                $scope.buscarProdutosMaisVendidos($scope.model.ordenarMaisVendidos.ordem, dataHoje, dataHoje);
                $scope.buscarProdutosMenosVendidos($scope.model.ordenarMenosVendidos.ordem, dataHoje, dataHoje);
                break;
            case 1:
                var diasSemana = FuncaoService.retornarDiaInicioDiaFimSemana();
                var dataInicial = FuncaoService.formataDataInvertida(diasSemana.inicio);
                var dataFinal = FuncaoService.formataDataInvertida(diasSemana.fim);
                $scope.dadosTicketMedio = JSON.parse(notaFiscalAppService.retornaTicketMedio(dataInicial, dataFinal));
                $scope.buscarProdutosMaisVendidos($scope.model.ordenarMaisVendidos.ordem, dataInicial, dataFinal);
                $scope.buscarProdutosMenosVendidos($scope.model.ordenarMenosVendidos.ordem, dataInicial, dataFinal);
                break;
            case 2:
                var date = new Date();
                var primeiroDia = new Date(date.getFullYear(), date.getMonth(), 1);
                var ultimoDia = new Date(date.getFullYear(), date.getMonth() + 1, 0);
                var dataInicial = FuncaoService.formataDataInvertida(primeiroDia);
                var dataFinal = FuncaoService.formataDataInvertida(ultimoDia);
                $scope.dadosTicketMedio = JSON.parse(notaFiscalAppService.retornaTicketMedio(dataInicial, dataFinal));
                $scope.buscarProdutosMaisVendidos($scope.model.ordenarMaisVendidos.ordem, dataInicial, dataFinal);
                $scope.buscarProdutosMenosVendidos($scope.model.ordenarMenosVendidos.ordem, dataInicial, dataFinal);
                break;
            case 3:
                var dataInicial = FuncaoService.formataDataInvertida((!!$scope.filtro.dataInicial) ? $scope.filtro.dataInicial : new Date());
                var dataFinal = FuncaoService.formataDataInvertida((!!$scope.filtro.dataFinal) ? $scope.filtro.dataFinal : new Date());
                $scope.dadosTicketMedio = JSON.parse(notaFiscalAppService.retornaTicketMedio(dataInicial, dataFinal));
                $scope.buscarProdutosMaisVendidos($scope.model.ordenarMaisVendidos.ordem, dataInicial, dataFinal);
                $scope.buscarProdutosMenosVendidos($scope.model.ordenarMenosVendidos.ordem, dataInicial, dataFinal);
                break;
        }
    };

    $scope.buscarTicketMedio($scope.enumTicketMedio.hoje);

    $scope.listaOpcoesCaixa = [];

    // Captura eventos de tecla
    //$(document).on('keydown', function (event) {
    //    // Verifica se a tecla pressionada é PageDown para fechar o caixa
    //    if (event.key === 'PageDown') {
    //        event.preventDefault();
    //        $scope.$apply(function () {
    //            // Função para fechar o caixa
    //            $scope.fecharCaixa();
    //        });
    //    }
    //});

    function verificarCaixa() {
        $scope.listaOpcoesCaixa = [];
        $scope.caixaAberto = JSON.parse(controleCaixaAppService.listaControleCaixaAberto());
        if (!(!!$scope.caixaAberto)) {
            $scope.listaOpcoesCaixa.push({
                descricao: 'Abrir Caixa',
                icone: 'fa fa-angle-double-right',
                funcao: 'abrirCaixa'
            });
        } else {
            $scope.listaOpcoesCaixa.push({
                descricao: 'Suprimento de Caixa',
                icone: 'fa fa-angle-double-right',
                funcao: 'suprimentoCaixa'
            });
            $scope.listaOpcoesCaixa.push({
                descricao: 'Sangria',
                icone: 'fa fa-angle-double-right',
                funcao: 'sangriaCaixa'
            });
            $scope.listaOpcoesCaixa.push({
                descricao: 'Lançamento de Despesa',
                icone: 'fa fa-angle-double-right',
                funcao: 'lancamentoDespesa'
            });
            $scope.listaOpcoesCaixa.push({
                descricao: 'Realizar Transferência',
                icone: 'fa fa-angle-double-right',
                funcao: 'transferencia'
            });
            $scope.listaOpcoesCaixa.push({
                descricao: 'Lista de Caixas',
                icone: 'fa fa-angle-double-right',
                funcao: 'listaCaixa'
            });
            $scope.listaOpcoesCaixa.push({
                descricao: 'Fechar Caixa',
                icone: 'fa fa-angle-double-right',
                funcao: 'fecharCaixa'
            });
        }
    }
    verificarCaixa();

    $scope.abrirCaixa = function () {
        $scope.modalAberturaCaixa = ModalService.model($scope, 'views/pdv/controle_caixa/modalAberturaCaixa.html', 'lg', true, 'static', true);
        $scope.modalAberturaCaixa.result.then(function () {
            verificarCaixa();
        });
    };

    $scope.transferencia = function () {
        $scope.modalTransferencia = ModalService.model($scope, 'views/pdv/controle_caixa/modalTransferencia.html', 'lg', true, 'static', true);
    };

    var numeroTentativas = 0;
    var verificarNfceEmContingencia = function () {
        if (numeroTentativas <= 10) {
            var possuiNfceEmContigencia = notaFiscalAppService.possuiNfceEmContingencia();
            if (!!possuiNfceEmContigencia) {
                setTimeout(function () {
                    verificarNfceEmContingencia();
                    numeroTentativas++;
                }, 500);
            } else {
                numeroTentativas = 0;
                abrirModalFechamentoCaixa();
            }
        } else {
            numeroTentativas = 0;
            $scope.fecharCaixa();
        }
    };

    $scope.fecharCaixa = function () {
        var possuiNfceEmContigencia = notaFiscalAppService.possuiNfceEmContingencia();
        if (!!possuiNfceEmContigencia) {
            var titulo = "Foi encontrado uma NFC-e em Contingência. Deseja tentar aprová-la agora?";
            if (possuiNfceEmContigencia > 1) titulo = "Foi encontrado " + possuiNfceEmContigencia + " NFC-e em Contingência. Deseja tentar aprová-las agora?";
            swal({
                title: titulo,
                text: "Obs: O PDV Envia automático NFC-e em Contingência a cada 15 min!",
                type: "warning",
                showCancelButton: true,
                cancelButtonText: "Agora não",
                cancelButtonClass: "btn-danger",
                confirmButtonClass: "btn-primary",
                confirmButtonText: "Sim, tentar",
                closeOnConfirm: true
            },
                function (isConfirm) {
                    if (isConfirm) {

                        async.waterfall([
                            function (callback) {
                                $.growl({
                                    message: 'Aguarde o PDV está tentando aprovar as NFC-e em Contingência'
                                }, {
                                    type: 'inverse',
                                    allow_dismiss: false,
                                    label: 'Cancel',
                                    className: 'btn-xs btn-inverse',
                                    placement: {
                                        from: 'top',
                                        align: 'right'
                                    },
                                    delay: 2500,
                                    animate: {
                                        enter: 'animated bounceIn',
                                        exit: 'animated bounceOut'
                                    },
                                    offset: {
                                        x: 20,
                                        y: 85
                                    }
                                });
                                setTimeout(function () {
                                    callback(null);
                                }, 100);
                            },
                            function (callback) {
                                notaFiscalAppService.enviarNfceEmContingencia();
                                callback(null);
                            },
                            function (callback) {
                                setTimeout(function () {
                                    verificarNfceEmContingencia();
                                }, 200);
                            }
                        ]);
                    } else {
                        abrirModalFechamentoCaixa();
                    }
                })
        } else {
            abrirModalFechamentoCaixa();
        }
    };

    var abrirModalFechamentoCaixa = function () {
        $scope.modalFechamentoCaixa = ModalService.model($scope, 'views/pdv/controle_caixa/modalFechamentoCaixa.html', 'xg', true, 'static', true);
        $scope.modalFechamentoCaixa.result.then(function () {
            verificarCaixa();
        });
    };

    $scope.suprimentoCaixa = function () {
        $scope.modalSuprimentoCaixa = ModalService.model($scope, 'views/pdv/suprimento_sangria_caixa/modalSuprimentoCaixa.html', 'lg', true, 'static', true);
    };

    $scope.sangriaCaixa = function () {
        $scope.modalSangriaCaixa = ModalService.model($scope, 'views/pdv/suprimento_sangria_caixa/modalSangriaCaixa.html', 'lg', true, 'static', true);
    };

    $scope.lancamentoDespesa = function () {
        $scope.modalLancamentoDespesa = ModalService.model($scope, 'views/pdv/controle_caixa/modalLancamentoDespesa.html', 'lg', true, 'static', true);
    };

    $scope.listaCaixa = function () {
        $scope.modalListaControleCaixa = ModalService.model($scope, 'views/pdv/controle_caixa/modalListaControleCaixa.html', 'lg', true, 'static', true);
    };

    $scope.ListarVendasPorVendedor = function (periodo) {
        $scope.enumTicketMedioSelecionado = periodo;
        switch (periodo) {
            case 0:
                var dataHoje = FuncaoService.formataDataInvertida();
                var dataFinal = dataHoje;
                break;
            case 1:
                var diasSemana = FuncaoService.retornarDiaInicioDiaFimSemana();
                var dataInicial = FuncaoService.formataDataInvertida(diasSemana.inicio);
                var dataFinal = FuncaoService.formataDataInvertida(diasSemana.fim);
                break;
            case 2:
                var date = new Date();
                var primeiroDia = new Date(date.getFullYear(), date.getMonth(), 1);
                var ultimoDia = new Date(date.getFullYear(), date.getMonth() + 1, 0);
                var dataInicial = FuncaoService.formataDataInvertida(primeiroDia);
                var dataFinal = FuncaoService.formataDataInvertida(ultimoDia);
                break;
            case 3:
                var dataInicial = FuncaoService.formataDataInvertida((!!$scope.filtro.dataInicial) ? $scope.filtro.dataInicial : new Date());
                var dataFinal = FuncaoService.formataDataInvertida((!!$scope.filtro.dataFinal) ? $scope.filtro.dataFinal : new Date());
                break;
        }
        $scope.ListaVendasVendedor = JSON.parse(vendedorAppService.listarVendasPorVendedor(dataInicial, dataFinal));
    };
    $scope.ListarVendasPorVendedor($scope.enumTicketMedio.hoje);

    $scope.toggleClassRight = function () {
        $('body').toggleClass('theme_color_dark');
    }


}]);