﻿newERP.controller('FechamentoCaixaController', ['$scope', 'FuncaoService', '$q', '$filter', '$localStorage', 'RelatorioService', 'ModalService', '$state', 'hotkeys', function ($scope, FuncaoService, $q, $filter, $localStorage, RelatorioService, ModalService, $state, hotkeys) {
    var operacaoMovimento = {
        Venda: 1,
        RecebimentoParcela: 2,
        SangriaSuprimento: 3,
        Abertura: 4,
        Fechamento: 5
    };

    var tipoMovimento = {
        Entrada: 1,
        Saida: 2
    };

    var tipoFormaPagamento = {
        fpDinheiro: 1,
        fpCheque: 2,
        fpCartaoCredito: 3,
        fpCartaoDebito: 4,
        fpCreditoLoja: 5,
        fpValeAlimentacao: 10,
        fpValeRefeicao: 11,
        fpValePresente: 12,
        fpValeCombustivel: 13,
        fpDuplicataMercantil: 14,
        fpBoletoBancario: 15,
        fpDepositoBancario: 16,
        fpPixDinamico: 17,
        fpTransferenciaBancaria: 18,
        fpCashback: 19,
        fpPixEstatico: 20,
        fpCreditoEmLoja: 21,
        fpFalhaDeHardware: 22,
        fpSemPagamento: 90,
        fpOutro: 99
    };

    $scope.dadosFechamento = {
        operador: '',
        ctx_datahorafechamento: new Date(),
        ctx_valorfechamento: '',
        valorAposTransferencia: null,
        codigoPdv: null,
        usu_id: null,
        ctx_id: null,
        ctx_quebracaixa: null,
        ctx_observacao: ''
    };

    $scope.enumPaginaCartao = {
        resumido: 0,
        detalhado: 1
    }

    $scope.model = {
        movimentacoesSemFiltro: [],
        movimentacoes: [],
        cuponsCancelados: [],
        formasPagamento: [],
        valoresCaixa: {
            abertura: 0,
            suprimento: 0,
            sangria: 0,
            venda: 0
        },
        dataAbertura: null,
        abaSelecionada: null,
        filtro: null,
        resumoRecebimentoCartao: [],
        detalhamentoRecebimentoCartao: [],
        enumPaginaCartaoSelecionado: $scope.enumPaginaCartao.resumido,
        contaCorrentePDV: null
    };

    $scope.keyEscFechamentoCaixa = function () {
        $scope.modalFechamentoCaixa.close();
    };

    $(document).on('keydown', function (event) {
        if (event.keyCode === 27) {
            event.preventDefault();
            $scope.$apply(function () {
                $scope.keyEscFechamentoCaixa();
            })
        }
    });

    $scope.retornaOperacaoMovimento = function (operacao, tipo) {
        switch (operacao.toString()) {
            case '1':
                return 'Venda';
            case '2':
                return 'Recebimento de Parcela';
            case '3':
                if (tipo === tipoMovimento.Entrada) return 'Suprimento';
                if (tipo === tipoMovimento.Saida) return 'Sangria';
                break;
            case '4':
                return 'Abertura do Caixa';
            case '5':
                return 'Fechamento do Caixa';
            case '6':
                return 'Transferência';
            case '7':
                return 'Despesa';
        }
    };

    $scope.retornaTipoMovimento = function (tipo) {
        switch (tipo.toString()) {
            case '1':
                return 'Entrada';
            case '2':
                return 'Saída';
        }
    };

    $scope.listaOperacaoMovimento = [
        { key: 4, value: 'Abertura' }, { key: 3, value: 'Sangria/Suprimento' }, { key: 1, value: 'Venda' }, { key: 2, value: 'Recebimento de parcela' }, { key: 7, value: 'Despesa' }
    ];
    $scope.model.filtro = $scope.listaOperacaoMovimento;

    var ultimaConfigTransferencia = (!!$localStorage.ultimaConfigTransferencia) ? $localStorage.ultimaConfigTransferencia : [];

    var dadosCaixaAberto = JSON.parse(controleCaixaAppService.listaControleCaixa())[0];
    $scope.model.dataHoraAbertura = dadosCaixaAberto.ctx_datahoraabertura;
    $scope.dadosFechamento.codigoPdv = dadosCaixaAberto.pdv_id;
    $scope.dadosFechamento.ctx_id = dadosCaixaAberto.Id;

    $scope.model.contaCorrentePDV = JSON.parse(pdvAppService.retornaContaCorrentePdv());

    var atualizouMovimentosCaixa = movimentoCaixaAppService.atualizarMovimentoCaixa();

    $scope.model.valoresCaixa = JSON.parse(movimentoCaixaAppService.retornaValoresCaixa());
    $scope.model.movimentacoes = JSON.parse(movimentoCaixaAppService.resumoMovimentacaoCaixa());
    $scope.model.movimentacoesSemFiltro = JSON.parse(JSON.stringify($scope.model.movimentacoes));
    $scope.model.cuponsCancelados = JSON.parse(notaFiscalAppService.retornaCuponsCancelados());

    $scope.model.possuiFiliais = JSON.parse(localAppService.possuiFiliais());

    $scope.model.local = JSON.parse(localAppService.retornaLocalPDV());

    var dadosUsuario = JSON.parse(usuarioAppService.dadosUsuarioLogado());
    $scope.dadosFechamento.operador = dadosUsuario.nome;
    $scope.dadosFechamento.usu_id = dadosUsuario.codigo;

    $scope.filtrarMovimentacao = function () {
        if (!!$scope.model.filtro.length) {
            $scope.model.movimentacoes = [];
            for (var i = 0; i < $scope.model.filtro.length; i++) {
                var retorno = $filter('filter')($scope.model.movimentacoesSemFiltro, { mvx_operacaomovimento: $scope.model.filtro[i].key });
                angular.forEach(retorno, function (movimento) {
                    $scope.model.movimentacoes.push(movimento);
                })
            }
        } else {
            $scope.model.filtro = $scope.listaOperacaoMovimento;
            $scope.model.movimentacoes = $scope.model.movimentacoesSemFiltro;
        }
    };

    function listarFormasPagamento() {
        $scope.model.formasPagamento = [];
        var valorEmDinheiro = parseFloat((($scope.model.valoresCaixa.abertura + $scope.model.valoresCaixa.suprimento) - $scope.model.valoresCaixa.sangria) - $scope.model.valoresCaixa.despesa - $scope.model.valoresCaixa.transferencia);

        $scope.model.formasPagamento.push({
            fpg_descricao: 'DINHEIRO',
            valorMovimento: valorEmDinheiro,
            valorInformado: 0,
            aba: 0,
            transferir: false,
            contaCorrenteTransferir: null,
            localTransferencia: $scope.model.local,
            valorTransferir: 0
        });

        var formasPagamentoMovimento = JSON.parse(movimentoCaixaAppService.retornaFormasPagamentoCaixa());

        for (var i = 0; i < formasPagamentoMovimento.length; i++) {
            if (formasPagamentoMovimento[i].fpg_tipopagamento == tipoFormaPagamento.fpDinheiro) {
                $scope.model.formasPagamento[0].valorMovimento += parseFloat(formasPagamentoMovimento[i].valorMovimento);
            }
            else {
                formasPagamentoMovimento[i].aba = $scope.model.formasPagamento.length;
                formasPagamentoMovimento[i].valorInformado = 0;
                formasPagamentoMovimento[i].transferir = false;
                formasPagamentoMovimento[i].contaCorrenteTransferir = null;
                formasPagamentoMovimento[i].localTransferencia = $scope.model.local;
                formasPagamentoMovimento[i].valorTransferir = 0;

                if (!!ultimaConfigTransferencia.length) {
                    var configFormaPag = $filter('filter')(ultimaConfigTransferencia, { idFormaPagamento: formasPagamentoMovimento[i].fpg_id });
                    if (!!configFormaPag.length) {
                        formasPagamentoMovimento[i].transferir = configFormaPag[0].transferir;
                        formasPagamentoMovimento[i].contaCorrenteTransferir = configFormaPag[0].contaCorrenteTransferir;
                        formasPagamentoMovimento[i].localTransferencia = configFormaPag[0].localTransferencia;
                    }
                }
                $scope.model.formasPagamento.push(angular.copy(formasPagamentoMovimento[i]));
            }
        }
        console.log('$scope.model.formasPagamento', $scope.model.formasPagamento);
        $scope.model.abaSelecionada = null;
    }
    listarFormasPagamento();

    function listarDadosRecebimentoCartao() {
        $scope.model.resumoRecebimentoCartao = JSON.parse(recebimentoCartaoAppService.retornaResumoRecebimentoCartaoCaixa());
        $scope.model.detalhamentoRecebimentoCartao = JSON.parse(recebimentoCartaoAppService.retornaDetalhamentoRecebimentoCartaoCaixa());
    }
    listarDadosRecebimentoCartao();

    function calcularValoresFechamento() {
        var defer = $q.defer();
        var valorMovimento = 0;
        var valorfechamento = 0;
        var valorTransferido = 0;
        $scope.model.formasPagamento.map(function (forma) {
            if (forma.fpg_tipopagamento != 16 && forma.fpg_tipopagamento != 17 && forma.fpg_tipopagamento != 18 && forma.fpg_tipopagamento != 20) {
                if (!!forma.transferir)
                    if ((!!forma.contaCorrenteTransferir) && (!!forma.valorTransferir))
                        valorTransferido += forma.valorTransferir;

                valorfechamento += parseFloat(forma.valorInformado);
                valorMovimento += parseFloat(forma.valorMovimento);
            }
        })
        quebracaixa = ((valorfechamento - valorTransferido) - (valorMovimento - valorTransferido));
        defer.resolve({
            ctx_valorfechamento: valorfechamento,
            ctx_quebracaixa: quebracaixa,
            valorAposTransferencia: (valorMovimento - valorTransferido)
        });
        return defer.promise;
    };

    $scope.validarTransferencias = function () {
        var possuiInconsistencia = false;
        var corpoMensagem = "";
        var descricaoFormaPagamento = "";
        var abaComInconsistencia = null;
        for (var i = 0; i < $scope.model.formasPagamento.length; i++) {
            if (!!$scope.model.formasPagamento[i].transferir)
                if (!(!!$scope.model.formasPagamento[i].contaCorrenteTransferir) || !(!!$scope.model.formasPagamento[i].valorTransferir)) {
                    possuiInconsistencia = true;
                    descricaoFormaPagamento = $scope.model.formasPagamento[i].fpg_descricao;
                    if (!(!!$scope.model.formasPagamento[i].contaCorrenteTransferir)) corpoMensagem = " * É necessário informar uma conta corrente de destino; ";
                    if (!(!!$scope.model.formasPagamento[i].valorTransferir)) {
                        corpoMensagem += (!!corpoMensagem.length) ? "\n\r" : "";
                        corpoMensagem += " * É necessário informar o valor a ser informado; ";
                    }
                    abaComInconsistencia = $scope.model.formasPagamento[i].aba;
                    break;
                }
        }

        if (!!possuiInconsistencia) {
            swal({
                title: "Verifique... você deve ter HABILITADO para realizar transferência automática em " + descricaoFormaPagamento,
                text: corpoMensagem,
                type: "warning",
                showCancelButton: true,
                cancelButtonClass: "btn-danger",
                cancelButtonText: "Vou ajustar",
                confirmButtonClass: "btn-default",
                confirmButtonText: "Continuar assim mesmo",
                closeOnConfirm: false,
                showLoaderOnConfirm: true
            },
                function (continuar) {
                    if (!!continuar) {
                        $scope.realizarFechametoCaixa();
                    } else {
                        $scope.model.abaSelecionada = abaComInconsistencia;
                        $scope.$digest();
                    }
                })
        } else {
            $scope.realizarFechametoCaixa();
        }
    };

    $scope.clicouPraFechar = false;
    $scope.realizarFechametoCaixa = function () {
        swal({
            title: "Fechar este caixa agora?",
            text: "",
            type: "warning",
            showCancelButton: true,
            cancelButtonClass: "btn-danger",
            cancelButtonText: "Não",
            confirmButtonClass: "btn-default",
            confirmButtonText: "Sim, quero fechar o caixa",
            closeOnConfirm: false,
            showLoaderOnConfirm: true
        },
            function (continuar) {
                setTimeout(function () {
                    if (continuar && !(!!$scope.clicouPraFechar)) {
                        $scope.clicouPraFechar = true;
                        calcularValoresFechamento().then(function (retornoValores) {
                            $scope.dadosFechamento.ctx_valorfechamento = retornoValores.ctx_valorfechamento;
                            $scope.dadosFechamento.ctx_quebracaixa = retornoValores.ctx_quebracaixa;
                            $scope.dadosFechamento.valorAposTransferencia = retornoValores.valorAposTransferencia;
                            if ($scope.dadosFechamento.ctx_valorfechamento == 0) {
                                swal({
                                    title: "Fechar este caixa com o valor R$ 0,00?",
                                    text: "",
                                    type: "warning",
                                    showCancelButton: true,
                                    cancelButtonClass: "btn-danger",
                                    cancelButtonText: "Não",
                                    confirmButtonClass: "btn-default",
                                    confirmButtonText: "Sim, quero assim mesmo",
                                    closeOnConfirm: false,
                                    showLoaderOnConfirm: true
                                },
                                    function (continuar) {
                                        if (continuar)
                                            fecharCaixa();
                                    });
                            } else {
                                fecharCaixa();
                            }
                        });
                    }
                }, concluiProcessoFechamentoCaixa());
            });
    };

    var concluiProcessoFechamentoCaixa = function () {
        if (!!$scope.clicouPraFechar)
            return 1;
        return 0;
    };

    function fecharCaixa() {
        $scope.dadosFechamento.ctx_datahorafechamento = new Date();

        realizarTransferencia().then(function (transferencia) {
            var fechouCaixa = controleCaixaAppService.editar(JSON.stringify($scope.dadosFechamento));
            if (!!fechouCaixa) {
                setTimeout(function () {
                    swal({
                        title: 'Caixa fechado!',
                        html: true,
                        text: 'Deseja imprimir o detalhamento da movimentação do caixa? Escolha um modelo! <div class="btn-close btn-close-swal a-link" onclick="swal.close(); return false;"> <i class="zmdi zmdi-close zmdi-hc-fw"></i></div>',
                        type: "success",
                        showCancelButton: true,
                        showConfirmButton: true,
                        confirmButtonClass: "btn-defult",
                        confirmButtonText: "Modelo PDF",
                        cancelButtonClass: "btn-defult",
                        cancelButtonText: "Modelo Não Fiscal",
                        closeOnConfirm: true,
                        closeOnCancel: true
                    },
                        function (isConfirm) {
                            if (isConfirm) {
                                detalhamentoPDF();
                            } else {
                                detalhamentoNaoFiscal();
                                swal.close();
                            }
                        });
                }, 100)
                $scope.modalFechamentoCaixa.close();
            } else {
                $scope.modalFechamentoCaixa.close();
                swal("Atenção", "Não foi possível realizar o fechamento do caixa, Possíveis dados pendentes para sincronização, vá até o menu disponível no perfil do usuário e clique em Enviar dados pendentes!", "warning");
            }
            $scope.clicouPraFechar = false;
        });
    }

    var realizarTransferencia = function () {
        var defer = $q.defer();

        ultimaConfigTransferencia = [];
        angular.forEach($scope.model.formasPagamento, function (forma, index) {
            if (!!forma.transferir)
                if ((!!forma.contaCorrenteTransferir) && (!!forma.valorTransferir)) {
                    ultimaConfigTransferencia.push({
                        "idFormaPagamento": forma.fpg_id,
                        "transferir": true,
                        "contaCorrenteTransferir": {
                            "ctc_id": forma.contaCorrenteTransferir.ctc_id,
                            "ctc_descricao": forma.contaCorrenteTransferir.ctc_descricao
                        },
                        "localTransferencia": {
                            "loc_id": forma.localTransferencia.loc_id,
                            "loc_descricao": forma.localTransferencia.loc_descricao
                        }
                    });
                    movimentoCaixaAppService.transferir(JSON.stringify({
                        ctx_id: $scope.dadosFechamento.ctx_id,
                        ctcIdDestino: forma.contaCorrenteTransferir.ctc_id,
                        ctcDescricaoDestino: forma.contaCorrenteTransferir.ctc_descricao,
                        valor: forma.valorTransferir,
                        locIdDestino: forma.localTransferencia.loc_id,
                        locDescricaoDestino: forma.localTransferencia.loc_descricao
                    }));
                }

            if ($scope.model.formasPagamento.length == (index + 1))
                defer.resolve();
        })
        $localStorage.ultimaConfigTransferencia = ultimaConfigTransferencia;

        if (!!!$scope.model.formasPagamento.length)
            defer.resolve();

        return defer.promise;
    }

    $scope.imprimirDetalhamento = function () {
        swal({
            title: '',
            html: true,
            text: 'Escolha um Modelo para Imprimir o detalhamento da movimentação do caixa até o presente momento! <div class="btn-close btn-close-swal a-link" onclick="swal.close(); return false;"> <i class="zmdi zmdi-close zmdi-hc-fw"></i> </div>',
            type: "warning",
            showCancelButton: true,
            confirmButtonClass: "btn-defult",
            confirmButtonText: "Modelo PDF",
            cancelButtonClass: "btn-defult",
            cancelButtonText: "Modelo Não Fiscal",
            closeOnConfirm: true,
            closeOnCancel: true,
            showConfirmButton: true
        },
            function (isConfirm) {
                if (isConfirm) {
                    detalhamentoPDF();
                } else {
                    detalhamentoNaoFiscal();
                    swal.close();
                }
            });
    };

    var detalhamentoNaoFiscal = function () {
        controleCaixaAppService.imprimirDetalhamento(JSON.stringify($scope.dadosFechamento));
    };

    var detalhamentoPDF = function () {
        if (navigator.onLine) {
            var ctc_id = JSON.stringify({
                'ctc_id': $scope.model.contaCorrentePDV
            })
            var filtros = [
                {
                    'nome': 'mcc_datahorainicial',
                    'valor': FuncaoService.formataDataInvertida($scope.model.dataHoraAbertura)
                },
                {
                    'nome': 'mcc_datahorafinal',
                    'valor': FuncaoService.formataDataInvertida($scope.dadosFechamento.ctx_datahorafechamento)
                },
                {
                    'nome': 'contaCorrenteInterno',
                    'valor': true
                },
                {
                    'nome': 'ctc_id',
                    'valor': JSON.parse(ctc_id)
                }
            ];
            RelatorioService.exibirRelatorio('a882af6f-becf-4dcf-a7cc-0d00b41b71a1', filtros);
        }
    };

}]);