﻿newERP.controller('DadosPendentesController', ['$scope', 'ModalService', 'ValidarFormularioService', '$timeout', '$state', 'DadosFormularioService', 'FuncaoService', 'growlService', function ($scope, ModalService, ValidarFormularioService, $timeout, $state, DadosFormularioService, FuncaoService, growlService) {

    $scope.filtro = {
        entidade: {
            Key: 0,
            Value: 'Sincroniza Dados Pendentes'
        },
        pesquisa: '',
        dataInicial: new Date(),
        dataFinal: new Date(),
    };


    $scope.listaEntidades = [
        {
            Key: 0,
            Value: 'Sincroniza Dados Pendentes'
        },
        {
            Key: 1,
            Value: 'Erro Gravacao Dados'
        }
    ];

    $scope.ListarDadosPendentes = function () {
        $scope.ListaDadosErro = [];
        $scope.ListaDadosPendentes = [];
        console.log($scope.filtro);
        if ($scope.filtro.entidade.Key == 0) {
            $scope.ListaDadosPendentes = JSON.parse(sincronizaDadosService.listarDadosPendentes($scope.filtro.dataInicial, $scope.filtro.dataFinal, $scope.filtro.pesquisa));
        } else {
            $scope.ListaDadosErro = JSON.parse(erroGravacaoDadosAppService.listaErroGravacaoDados($scope.filtro.dataInicial, $scope.filtro.dataFinal, $scope.filtro.pesquisa));
        }
    };

    $scope.VerDetalhes = function (dados) {
        $scope.dados = dados;
        $scope.modalDetalhes = ModalService.model($scope, 'views/pdv/varejo/dados_pendentes/modalDetalhes.html', 'lg', true, true, true);
    };

    $scope.EnviarDados = function (id) {
        var retorno = sincronizaDadosService.desbloqueioDadosSinronizacao(id);

        $timeout(function () {
            growlService.growl("Dados Enviados!", 'inverse', null, 2500);
            $scope.ListarDadosPendentes();
        }, 300)
    };
    $scope.AlterarStatus = function (id) {
        var retorno = sincronizaDadosService.alterarStatus(id);
        if (retorno) {
            $timeout(function () {
                growlService.growl("Status Alterado!", 'inverse', null, 2500);
                $scope.ListarDadosPendentes();
            }, 300)
        } else {
            $timeout(function () {
                growlService.growl("Erro na alteração de status!", 'inverse', null, 2500);
                $scope.ListarDadosPendentes();
            }, 300)
        }
    };
}]);