﻿newERP.controller('AberturaCaixaController', ['$scope', '$state', '$localStorage', 'ModalService', 'hotkeys', 'FuncaoService', 'DadosFormularioService', function ($scope, $state, $localStorage, ModalService, hotkeys, FuncaoService, DadosFormularioService) {

    $scope.dadosAbertura = {
        operador: '',
        ctx_datahoraabertura: new Date(),
        ctx_valorabertura: 0,
        pdv_id: null,
        usu_id: null,
        podeAlterar: true
    };
    //alterado para buscar somente local, pois quando não sincroniza algum dado pela a API estar fora o saldo fica errado.
    //var saldoContaCorrente = JSON.parse(contaCorrenteAppService.consultarSaldoAPI());
    //if (!!saldoContaCorrente && saldoContaCorrente.length > 0) {
    //    if (saldoContaCorrente[0].saldo > 0) {
    //        $scope.dadosAbertura.ctx_valorabertura = saldoContaCorrente[0].saldo;
    //        $scope.dadosAbertura.podeAlterar = false;
    //    } else {
    //        $scope.dadosAbertura.ctx_valorabertura = 0;
    //        $scope.dadosAbertura.podeAlterar = true;
    //    }
    //} else {
    var saldoUltimoFechamento = JSON.parse(controleCaixaAppService.saldoUltimoFechamento());
    $scope.dadosAbertura.ctx_valorabertura = saldoUltimoFechamento;
    $scope.dadosAbertura.podeAlterar = true;
    //}


    var dadosUsuario = JSON.parse(usuarioAppService.dadosUsuarioLogado());

    var buscarDadosPdv = pdvAppService.retornaDadosPdv();
    if (!!buscarDadosPdv) {
        $scope.dadosAbertura.pdv_id = buscarDadosPdv.pdv_id;
        $scope.dadosAbertura.operador = dadosUsuario.nome;
        $scope.dadosAbertura.usu_id = dadosUsuario.codigo;
    }

    hotkeys.bindTo($scope)

    $scope.keyEnterAberturaCaixa = function () {
        $scope.salvar($scope.dadosAbertura);
    };
    $scope.keyEscAberturaCaixa = function () {
        $scope.modalAberturaCaixa.close();
        $state.go('newpdv.home-pdv');
    };

    var operacaoMovimento = {
        Venda: 1,
        RecebimentoParcela: 2,
        SangriaSuprimento: 3,
        Abertura: 4,
        Fechamento: 5
    };

    var tipoMovimento = {
        Entrada: 1,
        Saida: 2
    };

    $scope.clicouPraAbrir = false;
    $scope.salvar = function (dados) {
        console.log("Dados da abertura do caixa... ", dados);
        if (!!dados) {
            if (!!dados.ctx_valorabertura) {
                $scope.clicouPraAbrir = true;
                $scope.dadosAberturaCaixa = controleCaixaAppService.incluir(JSON.stringify(dados));
                setTimeout(function () {
                    swal("Caixa aberto!", "", "success");
                }, 100)
                $scope.modalAberturaCaixa.close();
            } else {
                $scope.clicouPraAbrir = false;
                setTimeout(function () {
                    swal("Informe um valor para abrir o Caixa.", "", "warning");
                }, 100);
                $scope.setarFocus('ctxValorAbertura');
            }
        };
    };

    function montarListaCedulas() {
        $scope.totalCedulasPapel = 0;
        $scope.totalCedulasMoeda = 0;
        $scope.listaCedulasPapel = [];
        $scope.listaCedulasPapel.push({
            descricao: 'R$ 100,00',
            valor: 100,
            quantidade: 0
        });
        $scope.listaCedulasPapel.push({
            descricao: 'R$ 50,00',
            valor: 50,
            quantidade: 0
        });
        $scope.listaCedulasPapel.push({
            descricao: 'R$ 20,00',
            valor: 20,
            quantidade: 0
        });
        $scope.listaCedulasPapel.push({
            descricao: 'R$ 10,00',
            valor: 10,
            quantidade: 0
        });
        $scope.listaCedulasPapel.push({
            descricao: 'R$ 5,00',
            valor: 5,
            quantidade: 0
        });
        $scope.listaCedulasPapel.push({
            descricao: 'R$ 2,00',
            valor: 2,
            quantidade: 0
        });

        $scope.listaCedulasMoeda = [];
        $scope.listaCedulasMoeda.push({
            descricao: 'R$ 1,00',
            valor: 1,
            quantidade: 0
        });
        $scope.listaCedulasMoeda.push({
            descricao: 'R$ 0,50',
            valor: 0.50,
            quantidade: 0
        });
        $scope.listaCedulasMoeda.push({
            descricao: 'R$ 0,25',
            valor: 0.25,
            quantidade: 0
        });
        $scope.listaCedulasMoeda.push({
            descricao: 'R$ 0,10',
            valor: 0.10,
            quantidade: 0
        });
        $scope.listaCedulasMoeda.push({
            descricao: 'R$ 0,05',
            valor: 0.05,
            quantidade: 0
        });
        $scope.listaCedulasMoeda.push({
            descricao: 'R$ 0,01',
            valor: 0.01,
            quantidade: 0
        });
    }
    montarListaCedulas();

    $scope.calcularValorAbertura = function () {
        $scope.totalCedulasPapel = 0;
        $scope.listaCedulasPapel.forEach(function (cedula) {
            $scope.totalCedulasPapel += (cedula.valor * cedula.quantidade);
        })

        $scope.totalCedulasMoeda = 0;
        $scope.listaCedulasMoeda.forEach(function (moeda) {
            $scope.totalCedulasMoeda += (moeda.valor * moeda.quantidade);
        })

        $scope.dadosAbertura.ctx_valorabertura = $scope.totalCedulasPapel + $scope.totalCedulasMoeda;
    }

    $scope.setarFocus = function (nomeElemento) {
        FuncaoService.setarFocus(nomeElemento, 300);
    }

    $scope.fecharModalAberturaCaixa = function () {
        $scope.modalAberturaCaixa.close();
        $state.go('newpdv.home-pdv');
    }
}]);