﻿(function () {
    'use strict';
    newERP.service('ModalService', ['$uibModal', '$q', function ($uibModal, $q) {
        var modalFactory = {};

        var _model = function (scope, url, size, animation, backdrop, keyboard) {
            return $uibModal.open({
                animation: animation,
                templateUrl: url,
                scope: scope,
                size: size,
                backdrop: backdrop,
                keyboard: keyboard
            });
        };

        var _abrir = function (url, size, animation, backdrop, keyboard, controllerModal, parametros) {
            return $uibModal.open({
                animation: animation,
                templateUrl: url,
                controller: controllerModal,
                size: size,
                backdrop: backdrop,
                keyboard: keyboard,
                resolve: {
                    param: function () {
                        return {
                            'dados': parametros
                        };
                    }
                }
            });
        };

        var service = this,
        WINDOW_CLASS_PREFIX = 'modal-window-interceptor-',
        openedWindows = {};

        var _abrirModel = function (options) {
            var windowClass = WINDOW_CLASS_PREFIX;

            if (options.windowClass) {
                options.windowClass += ' ' + windowClass;
            } else {
                options.windowClass = windowClass;
            }

            var instance = $uibModal.open(options);

            var removedDeferred = $q.defer();
            instance.removed = removedDeferred.promise;

            openedWindows[windowClass] = {
                instance: instance,
                removedDeferred: removedDeferred
            };

            return instance;
        };

        var _abrirModal = function (options) {
            var windowClass = WINDOW_CLASS_PREFIX;

            if (options.windowClass) {
                options.windowClass += ' ' + windowClass;
            } else {
                options.windowClass = windowClass;
            }

            var instance = $uibModal.open(options);

            var removedDeferred = $q.defer();
            instance.removed = removedDeferred.promise;

            openedWindows[windowClass] = {
                instance: instance,
                removedDeferred: removedDeferred
            };

            return instance;
        };

        var _removerModal = function (modalElement) {
            var windowClass = openedWindows;
            if (!windowClass || !openedWindows[windowClass]) {
                return;
            }

            var removedDeferred = openedWindows[windowClass].removedDeferred;
            removedDeferred.resolve();
            delete openedWindows[windowClass];
        };

        var _removerModel = function (modalElement) {
            var windowClass = openedWindows;
            if (!windowClass || !openedWindows[windowClass]) {
                return;
            }

            var removedDeferred = openedWindows[windowClass].removedDeferred;
            removedDeferred.resolve();
            delete openedWindows[windowClass];
        };

        modalFactory.model = _model;
        modalFactory.abrir = _abrir;
        modalFactory.abrirModal = _abrirModal;
        modalFactory.abrirModel = _abrirModel;
        modalFactory.removerModal = _removerModel;
        modalFactory.removerModel = _removerModel;

        return modalFactory;
    }]);
})();