﻿(function () {
    'use strict';
    newERP.service('DadosFormularioService', ['$localStorage', function ($localStorage) {
        var dadosFormularioFactory = {};

        var _armazenarDados = function (nomeFormulario, dados) {
            var registroFormulario = -1;
            if ($localStorage.dadosFormularios) {
                $localStorage.dadosFormularios.forEach(function (currentValue, index, arr) {
                    if (currentValue.formulario == nomeFormulario)
                        registroFormulario = index;
                });
            } else {
                $localStorage.dadosFormularios = [];
            }

            if (registroFormulario >= 0 && $localStorage.dadosFormularios.length > 0) {
                $localStorage.dadosFormularios.splice(registroFormulario, 1, { 'formulario': nomeFormulario, 'dados': dados });
            }
            else {
                $localStorage.dadosFormularios.push({ 'formulario': nomeFormulario, 'dados': dados });
            }
        };

        var _limparDados = function (nomeFormulario) {
            $localStorage.dadosFormularios.forEach(function (currentValue, index, arr) {
                if (currentValue.formulario == nomeFormulario)
                    $localStorage.dadosFormularios.splice(index);
            });
        };

        var _retornaDados = function (nomeFormulario, dados) {
            var retorno;
            if ($localStorage.dadosFormularios) {
                $localStorage.dadosFormularios.forEach(function (currentValue, index, arr) {
                    if (currentValue.formulario == nomeFormulario)
                        retorno = currentValue;
                });
            } else {
                _armazenarDados(nomeFormulario, dados);
            }

            if (retorno == undefined) {
                _armazenarDados(nomeFormulario, dados);
                retorno = { 'formulario': nomeFormulario, 'dados': dados };
            }
            return retorno;
        };

        dadosFormularioFactory.armazenarDados = _armazenarDados;
        dadosFormularioFactory.limparDados = _limparDados;
        dadosFormularioFactory.retornaDados = _retornaDados;

        return dadosFormularioFactory;
    }]);
})();