﻿newERP.controller('ImpressoraController', ['$scope', 'ModalService', 'ValidarFormularioService', '$timeout', '$state', 'DadosFormularioService', 'FuncaoService', function ($scope, ModalService, ValidarFormularioService, $timeout, $state, DadosFormularioService, FuncaoService) {

    $scope.filtro = {
        pesquisa: ''
    };

    $scope.linguagens = ['ZPL', 'EPL2', 'PPLA', 'HTML'];
    $scope.marcas = ['ZEBRA', 'ARGOX', 'DYMO']

    $scope.dadosImpressora = {};

    $scope.IniciarDadosListaImpressora = function () {
        $scope.ListarImpressoras();
    };

    $scope.ListarImpressoras = function () {
        $scope.ListaImpressoras = JSON.parse(impressoraAppService.listarTodas($scope.filtro.pesquisa));
    };

    $scope.abrirManutencaoImpressora = function (dadosImpressora) {
        if (dadosImpressora !== null) {
            DadosFormularioService.armazenarDados('impressora-manutencao', dadosImpressora);
        } else {
            var objImpressora = DadosFormularioService.retornaDados('impressora-manutencao', {}).dados;
            DadosFormularioService.armazenarDados('impressora-manutencao', objImpressora);
        }
        $state.go('newpdv.impressora-manutencao');
    };

    $scope.voltarListaImpressora = function () {
        DadosFormularioService.limparDados('impressora-manutencao');
        $state.go('newpdv.impressora-lista');
    };

    $scope.lerDadosManutencao = function () {
        $scope.dadosImpressora = DadosFormularioService.retornaDados('impressora-manutencao', '').dados;
    };

    $scope.listaValidacaoFormulario = [
        { nome: 'imp_descricao', obrigatorio: '* A descrição do modelo é obrigatório!', invalido: '' },
        { nome: 'imp_nomerede', obrigatorio: '* O nome da Impressora na Rede é obrigatória!', invalido: '' },
        { nome: 'imp_alturaetiqueta', obrigatorio: '* A altura é obrigatória!', invalido: '' },
        { nome: 'imp_larguraetiqueta', obrigatorio: '* A largura é obrigatória!', invalido: '' },
        { nome: 'imp_larguraetiqueta', obrigatorio: '* O DPI é obrigatório!', invalido: '' }
    ];

    $scope.validarFormulario = function (formulario) {
        $scope.listaFormularioInvalido = [];
        ValidarFormularioService.listaFormularioInvalido(formulario, $scope.listaValidacaoFormulario).then(function (retorno) {
            $scope.listaFormularioInvalido = retorno.lista;
            $scope.mensagemFormularioInvalido = retorno.mensagem;

            if ($scope.listaFormularioInvalido.length == 0) {
                $scope.SalvarImpressora();
            }
        });
    };

    $scope.SalvarImpressora = function () {
        if (!!$scope.dadosImpressora.Id) {
            var retornoEdicao = JSON.parse(impressoraAppService.editar(JSON.stringify($scope.dadosImpressora)));
            if (retornoEdicao) {
                DadosFormularioService.limparDados('impressora-manutencao');
                swal("Impressora Alterada com sucesso!", "", "success");
                $scope.voltarListaImpressora();
            }
        } else {
            var retornoInclusao = JSON.parse(impressoraAppService.inserir(JSON.stringify($scope.dadosImpressora)));
            if (retornoInclusao) {
                DadosFormularioService.limparDados('impressora-manutencao');
                swal("Impressora Adicionada com sucesso!", "", "success");
                $scope.voltarListaImpressora();
            }
        }
    };

    $scope.ExcluirImpressora = function (impressora) {
        swal({
            title: 'Deseja Excluir o Registro!',
            text: "",
            type: "warning",
            confirmButtonClass: "btn-danger",
            confirmButtonText: "Sim, quero excluir",
            closeOnConfirm: false,
            cancelButtonText: "NAO",
            showCancelButton: true
        }, function (acao) {
            if (acao) {
                var retornoExclusao = JSON.parse(impressoraAppService.excluir(impressora.Id));
                if (retornoExclusao) {
                    swal("Impressora Excluida com Sucesso!", "", "success");
                    $timeout(function () {
                        $scope.ListarImpressoras();
                    });
                }
            }
        });
    };

    $scope.setarFocus = function (nomeElemento) {
        if ((parseInt(nomeElemento))) {
            $scope.paginaAtiva = parseInt(nomeElemento);
        } else {
            $timeout(function () {
                document.getElementsByName(nomeElemento)[0].focus();
            });

            $timeout(function () {
                $scope.$apply(function () {
                    $('select[name="' + nomeElemento + '"]').chosen({});
                    $('select[name="' + nomeElemento + '"]').trigger("chosen:open");
                });
            });
        }
    };
}]);