﻿newERP.controller('PreVendaController', ['$scope', 'ModalService', 'FuncaoService', 'DadosFormularioService', '$state', '$timeout', function ($scope, ModalService, FuncaoService, DadosFormularioService, $state, $timeout) {

    $scope.filtro = {
        pesquisa: '',
        dias: 14,
        dataInicialSlider: new Date(),
        dataInicial: new Date(),
        dataFinal: new Date(),
        cliente: { Id: null },
        vendedor: { ven_id: null },
        status: []
    }

    $scope.model = {
        cabecalhoPreVenda: {},
        listaPreVendas: [],
        pesquisaAvancada: false,
        itensPreVenda: [],
        eanConferencia: null
    }

    $scope.listaStatusPreVenda = JSON.parse(enumAppService.listaEnum("StatusPreVenda"));

    $scope.statusPadrao = function () {
        if (!!$scope.listaStatusPreVenda.length) {
            $scope.filtro.status.push({
                Key: $scope.listaStatusPreVenda[0].Key,
                Value: $scope.listaStatusPreVenda[0].Value
            });
        }
    };

    $scope.listarPreVendas = function () {
        $scope.model.listaPreVendas = JSON.parse(preVendaAppService.listarTodos($scope.filtro.pesquisa, $scope.filtro.dataInicial, true));
        console.log('$scope.model.listaPreVendas', $scope.model.listaPreVendas);
    }

    $scope.$watchCollection('filtro.dias', function (dia) {
        $scope.filtro.dataInicialSlider = FuncaoService.subtrairDias(new Date(), 14 - dia);
        $scope.model.listaPreVendas = JSON.parse(preVendaAppService.listarTodos($scope.filtro.pesquisa, $scope.filtro.dataInicialSlider, true));
    });

    $scope.aplicarFiltros = function (filtros) {
        if (!!filtros.cliente) {
            filtros.cli_id = filtros.cliente.Id;
        } else {
            filtros.cli_id = null;
        }

        if (!!filtros.vendedor) {
            filtros.ven_id = filtros.vendedor.ven_id;
        } else {
            filtros.ven_id = null;
        }

        delete filtros.pesquisaAvancada;
        delete filtros.cliente;
        delete filtros.vendedor;
        delete filtros.pesquisa;

        var _status = null;
        for (i = 0; i < filtros.status.length; i++) {
            _status += filtros.status[i].Key;
            if ((i + 1) < filtros.status.length) _status += ",";
        }
        filtros.statusPreVenda = _status;
        var status = filtros.status;
        delete filtros.status;
        $scope.model.listaPreVendas = JSON.parse(preVendaAppService.buscar(JSON.stringify(filtros)));
        filtros.status = status;
        $scope.model.pesquisaAvancada = ((!!$scope.model.pesquisaAvancada) ? false : true)
    };

    $scope.abrirConferenciaProduto = function (preVenda) {
        $scope.model.cabecalhoPreVenda = preVenda;
        $scope.model.itensPreVenda = JSON.parse(preVendaAppService.listarItens(preVenda.Id));
        angular.forEach($scope.model.itensPreVenda, function (item) {
            item.numeroItensConferido = 0;
            item.inconsistencia = true;
        })
        $scope.modalConferenciaProduto = ModalService.model($scope, 'views/pdv/varejo/modalConferencia.html', 'lg', true, true, true);
        $scope.setarFocus('eanConferencia');
    };

    $scope.setarFocus = function (idElemento) {
        setTimeout(function () {
            FuncaoService.setarFocus(idElemento);
        }, 300)
    }

    $scope.conferirItem = function (ean) {
        $scope.model.itensPreVenda.map(function (item) {
            if (!!item.prg_ean) {
                if (item.prg_ean == ean) {
                    item.numeroItensConferido += 1;
                    if (item.numeroItensConferido > item.pri_qtde) {
                        item.numeroItensConferido -= 1;
                        var tituloMensagem = "Você já conferiu o item (" + ean + ")!";
                        if (item.pri_qtde > 1) tituloMensagem = "Você já conferiu os " + item.pri_qtde + " itens do produto (" + ean + ")!";
                        setTimeout(function () {
                            swal(tituloMensagem, "", "warning");
                        }, 100)
                    }
                    if (item.numeroItensConferido == item.pri_qtde)
                        item.inconsistencia = false;
                }
            }
        })
        $scope.model.eanConferencia = null;
    };

    $scope.transformarEmVenda = function () {
        var algumaInconsistencia = false;
        angular.forEach($scope.model.itensPreVenda, function (item) {
            if (!!item.inconsistencia)
                algumaInconsistencia = true;
        })

        if (!!algumaInconsistencia) {
            swal({
                title: "Você conferiu todos os itens?",
                text: "",
                type: "warning",
                showCancelButton: true,
                cancelButtonText: "Não",
                confirmButtonClass: "btn-danger",
                confirmButtonText: "Sim, conferi",
                closeOnConfirm: true,
                showLoaderOnConfirm: true
            },
                function (continuar) {
                    if (continuar) {
                        setTimeout(function () {
                            $scope.modalConferenciaProduto.close();
                            abrirVenda();
                        }, 100);
                    }
                });
        } else {
            setTimeout(function () {
                $scope.modalConferenciaProduto.close();
                abrirVenda();
            }, 100);
        }
    };

    var abrirVenda = function () {
        var dadosPreVenda = $scope.model;
        var dadosFormaPagamento = JSON.parse(formaPagamentoAppService.buscarFormaPagamento(dadosPreVenda.cabecalhoPreVenda.fpg_id));
        var dadosCondicaoPagamento = (!!dadosPreVenda.cabecalhoPreVenda.cpg_id) ? JSON.parse(condicaoPagamentoAppService.buscarCondicaoPagamento(dadosPreVenda.cabecalhoPreVenda.cpg_id)) : {};
        var dadosDesconto = {
            baseCalculo: null,
            percentualDesconto: null,
            valorDesconto: null
        }
        var valorPago = dadosPreVenda.cabecalhoPreVenda.pre_valor;
        var percentualDesconto = (dadosPreVenda.cabecalhoPreVenda.pre_valordesconto / dadosPreVenda.cabecalhoPreVenda.pre_valor);
        if (!!dadosPreVenda.cabecalhoPreVenda.pre_valordesconto)
            valorPago = (dadosPreVenda.cabecalhoPreVenda.pre_valor - dadosPreVenda.cabecalhoPreVenda.pre_valordesconto);

        var definicaoParcelamento = [];
        if (!!dadosCondicaoPagamento == true && !!dadosCondicaoPagamento.cpg_id == true) definicaoParcelamento = JSON.parse(condicaoPagamentoAppService.listaParcelasCondicao(dadosCondicaoPagamento.cpg_id));
        if (!(!!!dadosCondicaoPagamento.cpg_descontopadrao) && !(!!!dadosFormaPagamento.fpg_descontopadrao)) {
            dadosDesconto.baseCalculo = dadosPreVenda.cabecalhoPreVenda.pre_valor;
            dadosDesconto.percentualDesconto = percentualDesconto;
            dadosDesconto.valorDesconto = dadosPreVenda.cabecalhoPreVenda.pre_valordesconto;
        }
        var parametrosEmpresa = parametrosEmpresaAppService.retornaDadosParametrosEmpresa();

        var somaParcelas = 0;
        var resto = 0;
        var parcelas = [];
        if (definicaoParcelamento.length > 0) {
            angular.forEach(definicaoParcelamento, function (parcela, indice) {
                var dataAtual = new Date();
                var dataVencimentoParcela = new Date(dataAtual.setDate(dataAtual.getDate() + parcela.pcl_numerodias));
                var parcelaEntrada = false;
                var numeroDias = FuncaoService.diferencaDatas(dataVencimentoParcela, dataAtual);
                if (numeroDias == 0) {
                    parcelaEntrada = true;
                }
              
                var pcl_toleranciaparcela = new Date(dataVencimentoParcela);
                if (!!parametrosEmpresa.par_diastoleranciaparcela) {
                    pcl_toleranciaparcela = new Date(pcl_toleranciaparcela.setDate(dataVencimentoParcela.getDate() + parametrosEmpresa.par_diastoleranciaparcela));
                } else {
                    pcl_toleranciaparcela = new Date(pcl_toleranciaparcela.setDate(pcl_toleranciaparcela.getDate() + 720));
                }

                pcl_toleranciaparcela = FuncaoService.formataDataNormal(pcl_toleranciaparcela);

                var valorParcela = 0;
                valorParcela = ((parcela.pcl_percparcela / 100) * (valorPago)).toFixed(2);
                parcelas.push({
                    prc_numeroparcela: indice + 1,
                    pcl_percparcela: parcela.pcl_percparcela,
                    prc_datavencimento: dataVencimentoParcela,
                    prc_dataprevisao: dataVencimentoParcela,
                    prc_valor: parseFloat(valorParcela),
                    pcl_toleranciaparcela: (!!pcl_toleranciaparcela) ? pcl_toleranciaparcela : null,
                    prc_entrada: parcelaEntrada
                });
                somaParcelas += parseFloat(valorParcela);
                somaParcelas = parseFloat(somaParcelas);
            });
            resto = (valorPago - somaParcelas).toFixed(2);
            resto = parseFloat(resto);
        }
        if (resto != 0) {
            var numeroUltimaParcela = 0;
            if (definicaoParcelamento.length > 0) {
                numeroUltimaParcela = definicaoParcelamento.length - 1;
            } else {
                numeroUltimaParcela = 1;
            }
            var valParcela = parseFloat(parcelas[numeroUltimaParcela].prc_valor);
            var totalParcela = (valParcela + resto).toFixed(2);
            totalParcela = parseFloat(totalParcela);
            parcelas[numeroUltimaParcela].prc_valor = parseFloat(totalParcela);
        }
        console.log('Parcelas', parcelas);
        var dadosVendedor = JSON.parse(vendedorAppService.buscar(dadosPreVenda.cabecalhoPreVenda.ven_id));
        var dados = {
            idPreVenda: dadosPreVenda.cabecalhoPreVenda.Id,
            iniciarVenda: true,
            cli_id: dadosPreVenda.cabecalhoPreVenda.ClienteId,
            pes_cpfcnpj: dadosPreVenda.cabecalhoPreVenda.cli_cpfcnpj,
            pes_nome: dadosPreVenda.cabecalhoPreVenda.cli_nome,
            ven_id: dadosPreVenda.cabecalhoPreVenda.ven_id,
            ven_nome: dadosPreVenda.cabecalhoPreVenda.ven_nome,
            ven_maximodesconto: (!!dadosVendedor) ? dadosVendedor.ven_maximodesconto : null,
            subTotal: 0,
            subTotalBruto: 0,
            totalDescontos: 0,
            subTotalNota: 0,
            totalAcrescimos: 0,
            descontoEmValorOuPercentual: '$',
            acrescimoEmValorOuPercentual: '$',
            listaItens: [],
            pagamento: [
                {
                    formaPagamento: dadosFormaPagamento,
                    condicaoPagamento: dadosCondicaoPagamento,
                    descontoPadrao: dadosDesconto,
                    valorPago: valorPago,
                    parcelas: parcelas,
                    cheques: []
                }
            ]
        };

        for (var i = 0; i < dadosPreVenda.itensPreVenda.length; i++) {
            var item = dadosPreVenda.itensPreVenda[i];
            item.vlrDesconto = 0;
            item.vlrAcrescimo = 0;

            var grade = {};
            if (!!item.prg_id) {
                grade = JSON.parse(produtoAppService.listaGradesProduto(item.pro_id, item.prg_id));
            };

            var temporaria = {
                produto: item.pro_descricao,
                ean: item.pro_ean,
                quantidade: item.pri_qtde,
                pro_codigo: item.pro_id,
                pro_id: item.pro_id,
                vlrUnitario: item.pri_valorunitario,
                totalItem: item.pri_valorunitario * item.pri_qtde,
                valorTotalItem: ((item.pri_valorunitario * item.pri_qtde) - item.pri_valordesconto),
                totalItemDesconto: ((item.pri_valorunitario * item.pri_qtde) - item.pri_valordesconto),
                desconto: (((item.pri_valordesconto * 100) / (item.pri_valorunitario * item.pri_qtde)) / 100),
                vlrAcrescimo: 0,
                acrescimo: 0,
                vlrDesconto: item.pri_valordesconto,
                vlrPrdAnt: item.pri_valorunitario * item.pri_qtde,
                valorUnitario: item.pri_valorunitario,
                vlrDescontoItem : 0,
                vlrOutro: 0,
                vlrFrete: 0,
                prg_id: !!item.prg_id ? item.prg_id : 0,
            };

            if (grade.length > 0) {
                temporaria.grade = grade[0].atributos[0].mgp_descricao;
            } else {
                temporaria.grade = null;
            };

            dados.listaItens.push(temporaria);
        };
        dados.qtdTotalItens = dados.listaItens.length;

        DadosFormularioService.armazenarDados('venda-varejo', dados);
        $state.go('newpdv.venda-varejo');
    };

    $scope.cancelarPreVenda = function (prevenda) {
        swal({
            title: "Deseja Cancelar essa Pré-Venda?",
            text: "",
            type: "warning",
            showCancelButton: true,
            cancelButtonText: "Não",
            confirmButtonClass: "btn-danger",
            confirmButtonText: "Sim!",
            closeOnConfirm: false,
            showLoaderOnConfirm: true
        }, function (acao) {
            if (acao) {
                var retorno = preVendaAppService.cancelarPrevenda(prevenda.Id);
                if (retorno === true) {
                    $timeout(function () {
                        $scope.model.listaPreVendas = JSON.parse(preVendaAppService.listarTodos($scope.filtro.pesquisa, $scope.filtro.dataInicialSlider, true));
                        swal("Pré-Venda Cancelada com Sucesso!", "", "success");
                    }, 50)
                }
            }
        });
    }

}]);