﻿(function () {
    newERP.controller('OrdemCompraController', ['$scope', 'FuncaoService', 'DadosFormularioService', 'ValidarFormularioService', '$state', '$localStorage', '$timeout', 'RelatorioService', 'ModalService', 'growlService', 'NgTableParams', '$filter', function ($scope, FuncaoService, DadosFormularioService, ValidarFormularioService, $state, $localStorage, $timeout, RelatorioService, ModalService, growlService, NgTableParams, $filter) {

        $scope.descricaoBotaoSalvarItem = 'Adicionar Item';
        $scope.descricaoBotaoSalvarItemModalGrade = 'Adicionar Item';

        $scope.filtro = {
            pesquisa: '',
            dataInicial: new Date(),
            dias: 14,
            pesquisaAvancada: false,
            dataFinal: new Date(),
            status: [],
            fornecedor: null,
            transportador: null
        };

        $scope.imprimirEtiquetas = false;
        $scope.dadosFiltros = {
            status: []
        };

        $scope.dadosEtiqueta = {
            met_descricao: null,
            met_comando: null,
            met_imagem: null,
            met_colunas: null,
            met_quantidadecaracteresdescricaoproduto: 15
        };
        $scope.impressoraSelecionada = {};
        $scope.dadosOrdemCompra = {
            fornecedor: null,
            transportador: null,
            itens: [],
            gerarMovimentacaoFinanceira: false,
            orc_datainclusao: new Date()
        };

        $scope.selecionarImpressora = function (impressora) {
            $scope.impressoraSelecionada = impressora;
        };

        $scope.IniciarDadosEditorEtiqueta = function () {
            $scope.dadosEtiqueta = DadosFormularioService.retornaDados('editor-etiqueta', {}).dados;
            $scope.isImportarModelo = DadosFormularioService.retornaDados('editor-etiqueta-importar', {}).dados;

            //importa
            if ($scope.isImportarModelo === true) {
                if (!!$scope.dadosEtiqueta) {
                    $scope.editorEtiqueta = false;
                    $scope.isImportarModelo = true;
                    $scope.dadosEtiqueta.textAreaEditorEtiqueta = $scope.dadosEtiqueta.met_comando;
                };
            } else {
                if (!!$scope.dadosEtiqueta.Id) { // alterar                
                    $scope.dadosEtiqueta.textAreaEditorEtiqueta = $scope.dadosEtiqueta.met_comando;
                } else { // inserir
                    $scope.isImportarModelo = false;
                    $scope.dadosEtiqueta.met_colunas = null;
                    $scope.dadosEtiqueta.met_quantidadecaracteresdescricaoproduto = 15;
                }
            }
        };

        $scope.$watch('filtro.dias', function (dia) {
            $scope.filtro.dataInicial = FuncaoService.subtrairDias(new Date(), 14 - dia);
            $scope.listarOrdemCompra();
        });
        $scope.dadosFiltros.status = JSON.parse(enumAppService.listaEnum('StatusOrdemCompra'));
        $scope.filtro.status = JSON.parse(enumAppService.listaEnum('StatusOrdemCompra'));

        $scope.ordemPadrao = DadosFormularioService.retornaDados('ordemcompra-lista', { campo: '-orc_datainclusao', descricao: 'Data Inclusão decrescente' }).dados;

        $scope.imprimir = function (ordemCompra) {
            RelatorioService.exibirRelatorioPDF("97e3d278-644b-4012-b2d3-8da0a3514f79", [{ 'nome': 'orc_id', 'valor': ordemCompra.orc_id }]);
        };

        $scope.listaOrdemCompra = [];
        $scope.listarOrdemCompra = function () {
            var dataInicial = FuncaoService.formataDataInvertida($scope.filtro.dataInicial);
            var dataFinal = FuncaoService.formataDataInvertida($scope.filtro.dataFinal);

            var status = '';
            for (var i = 0; i < $scope.filtro.status.length; i++) {
                status += $scope.filtro.status[i].Key + ',';
            }
            if ($scope.filtro.status.length > 0) {
                status = status.substring(0, (status.length - 1))
            }

            var fornecedor = null;
            if (!!$scope.filtro.fornecedor) {
                fornecedor = $scope.filtro.fornecedor.for_id;
            };
            var paginas = 10;

            $scope.listaOrdemCompra = JSON.parse(ordemCompraAppService.listar(dataInicial, dataFinal, status, fornecedor, $scope.filtro.pesquisa));
            $scope.tabelaOrdemCompra = new NgTableParams({
                count: paginas,
            }, {
                total: $scope.listaOrdemCompra.length,
                getData: function ($defer, params) {

                    var orderedData = $filter('orderBy')($scope.listaOrdemCompra);
                    $defer.resolve(orderedData.slice((params.page() - 1) * params.count(), params.page() * params.count()));
                }
            });
        };
        $scope.listarOrdemCompra();

        var enumStatus = {
            Nova: 0,
            RecebimentoParcial: 1,
            RecebimentoTotal: 2,
            Cancelada: 3
        };

        $scope.visualizarRelatorio = function (codigoSelecionado) {
            RelatorioService.exibirRelatorio('97e3d278-644b-4012-b2d3-8da0a3514f79', []);
        };

        $scope.abrirOrdemCompra = function () {
            $state.go('newpdv.ordemcompra-lista');
        };

        $scope.lerDadosOrdemCompra = function () {
            $scope.modoExibirPesquisaProduto();
            $scope.efetuandoRecebimento = false;

            $scope.dadosOrdemCompra = DadosFormularioService.retornaDados('ordemCompra-manutencao', '').dados;

            if (!!$scope.dadosOrdemCompra.orc_id) {
                $scope.buscarItensOrdemDeCompra($scope.dadosOrdemCompra.orc_id);
            } else {
                $scope.dadosOrdemCompra.numeroItens = 0;
                $scope.dadosOrdemCompra.orc_status = 0;
                $scope.dadosOrdemCompra.itens = [];
            }

            if (!!$scope.dadosOrdemCompra.for_id) {
                $scope.dadosOrdemCompra.fornecedor = {
                    for_id: $scope.dadosOrdemCompra.for_id,
                    pes_nome: $scope.dadosOrdemCompra.nomeFornecedor
                }
            }

            if (!!$scope.dadosOrdemCompra.trn_id) {
                $scope.dadosOrdemCompra.transportador = {
                    trn_id: $scope.dadosOrdemCompra.trn_id,
                    pes_nome: $scope.dadosOrdemCompra.nomeTransportador
                }
            }

            DadosFormularioService.armazenarDados('ordemCompra-manutencao', $scope.dadosOrdemCompra);
        };

        $scope.setarFocus = function (nomeElemento) {
            $timeout(function () {
                document.getElementsByName(nomeElemento)[0].focus();
            });

            $timeout(function () {
                $scope.$apply(function () {
                    $('select[name="' + nomeElemento + '"]').chosen({});
                    $('select[name="' + nomeElemento + '"]').trigger("chosen:open");
                });
            });
        };

        $scope.listaValidacaoFormularioItem = [
            { nome: 'ocp_quantidade', obrigatorio: 'A Quantidade é Obrigatório', invalido: '' }
        ];


        $scope.voltarListaOrdemCompra = function () {
            DadosFormularioService.limparDados('ordemCompra-manutencao');
            $state.go('newerp.ordemcompra-lista');
        };

        $scope.listaValidacaoFormulario = [
            { nome: 'for_id', obrigatorio: 'O Fornecedor é Obrigatório', invalido: '' }
        ];


        $scope.ListarModelosDeEtiqueta = function () {
            $scope.ListaModelos = JSON.parse(etiquetaAppService.listarTodos($scope.filtro.pesquisa));
        };

        $scope.abrirModalSelecaoModelo = function () {
            if ($scope.visualizarOrdemCompra.itens.length > 0) {
                $scope.ListarModelosDeEtiqueta()
                $scope.modalSelecaoModelo = ModalService.model($scope, 'views/pdv/varejo/ordem_compra/modalSelectModelo.html', 'md', true, true, true);
            } else {
                swal("Nenhum Produto foi selecionado!", "", "warning");
            }
        };

        $scope.ListarImpressoras = function () {
            $scope.ListaImpressoras = JSON.parse(impressoraAppService.listarTodas());
        }

        $scope.selecionarModelo = function (mod) {
            $scope.modeloSelecionado = mod;
        };

        $scope.AbrirModalImpressora = function () {
            $scope.ListarImpressoras();
            $scope.modalSelecaoModelo.close();
            $scope.modalImpressoras = ModalService.model($scope, 'views/pdv/varejo/modalImpressora.html', 'md', true, true, true);
        };

        $scope.ImprimirEtiqueta = function () {
            if (!!$scope.impressoraSelecionada) {
                if (!!$scope.modeloSelecionado) {

                    //VERIFICAR SE POSSUI INFORMAÇÕES ADICIONAIS                
                    var informacaoAdicional = "";
                    if ($scope.dadosEtiqueta.informacaoAdicional) {
                        if ($scope.dadosEtiqueta.possuiEntrada) {
                            informacaoAdicional = $scope.dadosEtiqueta.quantidadeParcelas + "x(1+" + ($scope.dadosEtiqueta.quantidadeParcelas - 1) + ")";
                        } else {
                            informacaoAdicional = $scope.dadosEtiqueta.quantidadeParcelas + "x";
                        };
                    };

                    var dadosImpressao = {
                        codigoImpressora: $scope.impressoraSelecionada.Id,
                        codigoModeloEtiqueta: $scope.modeloSelecionado.Id,
                        informacaoAdicional: informacaoAdicional,
                        quantidadeParcelas: !!$scope.dadosEtiqueta.quantidadeParcelas ? $scope.dadosEtiqueta.quantidadeParcelas : 0,
                        possuiEntrada: $scope.dadosEtiqueta.possuiEntrada,
                        impressoraCompartilhada: $scope.dadosEtiqueta.impressoraCompartilhada,
                        dadosProduto: []
                    };

                    angular.forEach($scope.visualizarOrdemCompra.itens, function (item) {

                        for (var i = 0; i < item.ocp_quantidade; i++) {
                            var valorVenda = (item.lpi_valorvenda) ? item.lpi_valorvenda : item.prg_valorvenda
                            var dadosProduto = {
                                codigoProduto: item.pro_id,
                                precoProduto: FuncaoService.retornaMoney(valorVenda),
                                descricaoProduto: item.pro_descricao,
                                gradeProduto: item.mgp_descricao,
                                numeroCopias: item.ocp_quantidade
                            };

                            if ($scope.dadosEtiqueta.conf_barcode === 'codigoProduto') {
                                dadosProduto.codigoBarras = item.pro_codigo;
                            } else if ($scope.dadosEtiqueta.conf_barcode === 'codigoEtiqueta') {
                                dadosProduto.codigoBarras = item.pro_codigoetiqueta;
                            } else {
                                dadosProduto.codigoBarras = item.pro_ean;
                            }
                            dadosImpressao.dadosProduto.push(dadosProduto);
                        };
                    });
                    etiquetaAppService.imprimirEtiqueta(JSON.stringify(dadosImpressao));
                    $scope.modalImpressoras.close();
                    $scope.modalVisualizarOrdemCompra.close();
                };
            };
        };

        $scope.ImportarModelo = function () {
            var arquivoCarregado = etiquetaAppService.importarModelo();
            if (!!arquivoCarregado) {

                $scope.dadosEtiqueta = {
                    met_descricao: null,
                    met_comando: arquivoCarregado,
                    met_imagem: null,
                    met_colunas: null,
                };

                DadosFormularioService.armazenarDados('editor-etiqueta', $scope.dadosEtiqueta);
                DadosFormularioService.armazenarDados('editor-etiqueta-importar', true);
                $state.go('newpdv.editor-etiqueta');
            }
        };

        $scope.visualizarDetalhesOrdemCompra = function (dadosOrdemCompra) {
            $scope.visualizarOrdemCompra = dadosOrdemCompra;
            $scope.visualizarOrdemCompra.itens = JSON.parse(ordemCompraItemAppService.listarItensOrdemCompra(dadosOrdemCompra.orc_id));


            $scope.modalVisualizarOrdemCompra = ModalService.model($scope, 'views/pdv/varejo/modalDetalhesOrdemCompra.html', 'lg', true, 'static', true);
        };
    }]);
})();