﻿newERP.controller('LoginController', ['$scope', '$state', '$rootScope', 'DadosFormularioService', 'growlService', '$localStorage', function ($scope, $state, $rootScope, DadosFormularioService, growlService, $localStorage) {

    var tipoPdv = {
        mercado: 1,
        varejo: 0
    };

    $scope.pdv = {
        imagem: './img/bg-supermercado.jpg',
        rota: 'newpdv.supermercado-pdv'
    }

    var configPdv = configPdvAppService.retornaConfiguracao();
    if (!!configPdv) {
        if (configPdv.tipoPdv == tipoPdv.varejo) {
            $scope.imagem = '';
            $scope.pdv = {
                imagem: './img/bg-varejo.jpg',
                rota: 'newpdv.venda-varejo'
            }
        }
    }

    $scope.model = {
        email: null,
        senha: null        
    }

    $scope.efetuarLogin = function () {
        var retornoLogin = JSON.parse(loginService.efetuarLogin($scope.model.email, $scope.model.senha));
        if (!!retornoLogin.login) {
            var retornoVerificacaoPdvAtivo = JSON.parse(pdvAppService.verificarPdvAtivo());
            if (retornoVerificacaoPdvAtivo) {
                $scope.salvarDadosLogin();
                
                $localStorage.dadosPDV = pdvAppService.retornaDadosPdv();

                $state.go($scope.pdv.rota);
                $scope.verificaHorarioAcesso();
            } else {
                var dadosPdv = pdvAppService.retornaDadosPdv();
                swal("Atenção!", "Este PDV(Caixa:" + dadosPdv.nroCaixa + ", Id do PDV :" + dadosPdv.dadosPdv+") está Inativo, contate o responsável!", "warning");
            }

        } else {
            $scope.model.erroLogin = retornoLogin.mensagem;
        }
    }

    $scope.salvarDadosLogin = function () {
        if ($scope.salvarLogin) {
            var dadosLogin = {
                email: $scope.model.email,
                senha: $scope.model.senha,
                salvarLogin: $scope.salvarLogin
            };            
            $localStorage.dadosLogin = dadosLogin;
        } else {            
            delete $localStorage.dadosLogin;
        };
    };

    $scope.retornaDadosLogin = function () {        
        var dadosLogin = $localStorage.dadosLogin;
        if (!!dadosLogin) {
            $scope.model.email = dadosLogin.email;
            $scope.model.senha = dadosLogin.senha;
            $scope.salvarLogin = dadosLogin.salvarLogin;
        }
    }

    $scope.iniciarDadosLogin = function () {
        $scope.retornaDadosLogin();
    };

    $scope.mostrarNotificacaoApiDesconectada = function () {
        growlService.growl('Não foi possível realizar a comunicação com a API do NewERP pois não há conexão com a internet.', 'inverse', 'top');
    };

    $scope.verificaHorarioAcesso = function () {
        var retorno = loginService.retornaAcesso();
        if (retorno != "") {
            swal("Atenção!", retorno, "warning");
        }
    };

}]);