﻿newERP.controller('AntecipacaoClienteFornecedorController', ['$scope', 'ModalService', 'ValidarFormularioService', '$timeout', '$state', 'DadosFormularioService', 'FuncaoService', '$window', '$localStorage', 'NgTableParams', '$filter', function ($scope, ModalService, ValidarFormularioService, $timeout, $state, DadosFormularioService, FuncaoService, $window, $localStorage, NgTableParams, $filter) {

    $scope.filtro = {
        pesquisa: null,
        mostrarValeQuitado: false,
        dias: 14,
        diasVale: 14,
        dataInicialSlider: new Date(),
        dataInicial: new Date(),
        dataFinal: new Date(),
    };

    $scope.$watch('filtro.diasVale', function (dia) {
        $scope.filtro.dataInicialSlider = FuncaoService.subtrairDias(new Date(), 14 - dia);
        $scope.filtro.dataInicial = FuncaoService.subtrairDias(new Date(), 14 - dia);
        $scope.listarValePresente($scope.filtro.pesquisa, 10, $scope.filtro.dataInicialSlider, $scope.filtro.dataFinal);
    });

    $scope.$watch('filtro.dias', function (dia) {
        $scope.filtro.dataInicialSlider = FuncaoService.subtrairDias(new Date(), 14 - dia);
        $scope.filtro.dataInicial = FuncaoService.subtrairDias(new Date(), 14 - dia);
        $scope.listarAntecipacao($scope.filtro.pesquisa, 10, $scope.filtro.dataInicialSlider, $scope.filtro.dataFinal);
    });

    $scope.dadosValePresente = {
        faturamento: {
            fpg_id: false,
            cpg_id: false
        }
    };
    var tipoParcelamentoCartao = {
        estabelecimento: 0,
        comprador: 1
    };
    var tipoFormaPagamento = {
        fpDinheiro: 1,
        fpCheque: 2,
        fpCartaoCredito: 3,
        fpCartaoDebito: 4,
        fpCreditoLoja: 5,
        fpValeAlimentacao: 10,
        fpValeRefeicao: 11,
        fpValePresente: 12,
        fpValeCombustivel: 13,
        fpDuplicataMercantil: 14,
        fpBoletoBancario: 15,
        fpDepositoBancario: 16,
        fpPix: 17,
        fpTransferenciaBanacria: 18,
        fpCashback: 19,
        fpSemPagamento: 90,
        fpOutro: 99
    };

    var modeloRelatorioCarne = {
        NaoFiscal: 0,
        Normal: 1
    };

    $scope.desabilitar = false;

    $scope.abrirManutencaoValePresente = function () {
        $state.go('newpdv.valePresente-manutencao');
    };

    $scope.listaValePresente = function () {
        $scope.listarValePresente($scope.filtro.pesquisa, 10, $scope.filtro.dataInicialSlider, $scope.filtro.dataFinal);
    }

    $scope.atualizaDadosAntecipacao = function () {
        antecipacaoClienteFornecedorAppService.atualizarAnteciapacao();
    };

    $scope.listarValePresente = function (filtro, paginas, dataInicial, dataFinal) {
        $scope.listaValePresente = [];
        dataInicial = (!!dataInicial) ? FuncaoService.formataDataInvertida(dataInicial) : "";
        dataFinal = (!!dataFinal) ? FuncaoService.formataDataInvertida(dataFinal) : "";
        filtro = (!!filtro) ? filtro : "";
        $scope.listaValePresente = JSON.parse(antecipacaoClienteFornecedorAppService.listarValePresente(1, dataInicial, dataFinal, $scope.filtro.pesquisa));

        DadosFormularioService.armazenarDados('newpdv.valePresente-lista', $scope.ListaValePresente);
        $scope.tabelaValePresente = new NgTableParams({
            count: paginas,
        }, {
            total: $scope.listaValePresente.length,
            getData: function ($defer, params) {

                var orderedData = $filter('orderBy')($scope.listaValePresente);
                $defer.resolve(orderedData.slice((params.page() - 1) * params.count(), params.page() * params.count()));
            }
        });
    };

    $scope.listarAntecipacao = function (filtro, paginas, dataInicial, dataFinal) {
        $scope.listaAntecipacao = [];
        dataInicial = (!!dataInicial) ? FuncaoService.formataDataInvertida(dataInicial) : "";
        dataFinal = (!!dataFinal) ? FuncaoService.formataDataInvertida(dataFinal) : "";
        filtro = (!!filtro) ? filtro : "";
        $scope.listaAntecipacao = JSON.parse(antecipacaoClienteFornecedorAppService.listarAntecipacoes(0, dataInicial, dataFinal, $scope.filtro.pesquisa));
        console.log('$scope.listaAntecipacao', $scope.listaAntecipacao)
        DadosFormularioService.armazenarDados('newpdv.antecipacao-lista', $scope.listaAntecipacao);
        $scope.tabelaAntecipacao = new NgTableParams({
            count: paginas,
        }, {
            total: $scope.listaAntecipacao.length,
            getData: function ($defer, params) {

                var orderedData = $filter('orderBy')($scope.listaAntecipacao);
                $defer.resolve(orderedData.slice((params.page() - 1) * params.count(), params.page() * params.count()));
            }
        });
    };

    $scope.lerDadosValePresente = function () {
        $scope.dadosValePresente = DadosFormularioService.retornaDados('valePresente-manutencao', { acf_id: null }).dados;

        $scope.dadosValePresente.faturamento = (!!$scope.dadosValePresente.faturamento == true) ? $scope.dadosValePresente.faturamento : [];
        $scope.dadosValePresente.faturamento.listaParcelas = (!!$scope.dadosValePresente.faturamento.listaParcelas == true) ? $scope.dadosValePresente.faturamento.listaParcelas : [];
        $scope.dadosValePresente.faturamento.cheques = (!!$scope.dadosValePresente.faturamento.cheques) ? $scope.dadosValePresente.faturamento.cheques : [];
        $scope.dadosValePresente.acf_datalancamento = new Date();

        /* buscar parametro empresa */
        $scope.dadosParametrosEmpresa = parametrosEmpresaAppService.retornaDadosParametrosEmpresa();
        $scope.dadosValePresente.contaVista = (!!$scope.dadosParametrosEmpresa == true) ? $scope.dadosParametrosEmpresa.par_contagerencialvalepresente : null;
        $scope.dadosValePresente.contaPrazo = (!!$scope.dadosParametrosEmpresa == true) ? $scope.dadosParametrosEmpresa.par_contagervalepresenteprazo : null;
    };

    $scope.listaValidacaoFormulario = [
        { nome: 'acf_datalancamento', obrigatorio: '* A Data do Lançamento é Obrigatória', invalido: '' },
        { nome: 'acf_valor', obrigatorio: '* O Valor do Vale é Obrigatório', invalido: '' },
        { nome: 'acf_nomepresenteado', obrigatorio: 'O nome do destinatário do Vale Presente é Obrigatório', invalido: '' },
    ];

    $scope.validarFormulario = function (formulario) {
        $scope.listaFormularioInvalido = [];
        ValidarFormularioService.listaFormularioInvalido(formulario, $scope.listaValidacaoFormulario).then(function (retorno) {
            $scope.listaFormularioInvalido = retorno.lista;
            $scope.mensagemFormularioInvalido = retorno.mensagem;

            if ($scope.dadosValePresente.acf_valor <= 0) {
                $scope.listaFormularioInvalido.push({ nome: 'acf_valor', mensagem: '* O Valor do Vale é Obrigatório' })
            }
            if (!!$scope.dadosValePresente.faturamento.fpg_id == false) {
                $scope.listaFormularioInvalido.push({ nome: 'fpg_id', mensagem: 'A Forma de Pagamento é Obrigatória' })
            }
            if (!!$scope.dadosValePresente.faturamento.fpg_id) {
                if ($scope.dadosValePresente.faturamento.fpg_id.fpg_tipopagamento != tipoFormaPagamento.fpDinheiro && $scope.dadosValePresente.faturamento.fpg_id.fpg_tipopagamento != tipoFormaPagamento.fpCheque)
                    if (!!$scope.dadosValePresente.faturamento.cpg_id == false) {
                        $scope.listaFormularioInvalido.push({ nome: 'cpg_id', mensagem: 'A Condição de Pagamento é Obrigatória' })
                    }

                if ($scope.dadosValePresente.faturamento.fpg_id.fpg_tipopagamento == tipoFormaPagamento.fpCreditoLoja) {
                    if (!!$scope.dadosValePresente.pessoa == false) {
                        $scope.listaFormularioInvalido.push({ nome: 'pes_id', mensagem: 'Para venda a prazo é obrigatório informar o comprador!' })
                    }
                }
            }
            var podeSalvar = false;
            if ($scope.listaFormularioInvalido.length == 0) {
                if (!!$scope.dadosValePresente.faturamento.fpg_id)
                    if ($scope.dadosValePresente.faturamento.fpg_id.fpg_tipopagamento == tipoFormaPagamento.fpCheque) {
                        if ($scope.dadosValePresente.faturamento.cheques.length == 0) {
                            swal({
                                title: "Você adicionou pagamento em cheque, porem o cheque não foi lançado. O que deseja fazer?",
                                text: "",
                                type: "warning",
                                showCancelButton: true,
                                cancelButtonText: "Lançar o Cheque",
                                confirmButtonClass: "btn-danger",
                                confirmButtonText: "Finalizar o Vale Presente",
                                closeOnConfirm: true
                            },
                                function (isConfirm) {
                                    if (!isConfirm) {
                                        $scope.lancamentoCheque($scope.dadosValePresente.numeroCheques, $scope.dadosValePresente.acf_valor, null, $scope.dadosValePresente.faturamento.fpg_id.fpg_tipopagamento);
                                    } else {
                                        if ($scope.listaFormularioInvalido.length == 0)
                                            $scope.salvarValePresente();
                                    }
                                });
                        } else {
                            podeSalvar = true;
                        }
                    } else if ($scope.dadosValePresente.faturamento.fpg_id.fpg_tipopagamento == tipoFormaPagamento.fpCartaoCredito
                        || $scope.dadosValePresente.faturamento.fpg_id.fpg_tipopagamento == tipoFormaPagamento.fpCartaoDebito
                        || $scope.dadosValePresente.faturamento.fpg_id.fpg_tipopagamento == tipoFormaPagamento.fpPix) {
                        if ($scope.dadosValePresente.faturamento.fpg_id.fpg_tipointegracao != null) {
                            if ($scope.dadosValePresente.faturamento.hasOwnProperty("integrapgto") == false) {
                                gerarParcelasCartaoIntegrado();
                                $scope.verificaIntegracaoPagamentos($scope.dadosValePresente.faturamento);
                                $scope.dadosValePresente.faturamento.integrapgtook = false;
                            }
                        } else if ($scope.dadosValePresente.faturamento.fpg_id.fpg_tipopagamento == tipoFormaPagamento.fpCartaoCredito
                            || $scope.dadosValePresente.faturamento.fpg_id.fpg_tipopagamento == tipoFormaPagamento.fpCartaoDebito) {
                            abrirEscolhaBandeiraCartao($scope.dadosValePresente.faturamento.fpg_id.fpg_tipopagamento);
                        } else {
                            podeSalvar = true;
                        }
                    } else {
                        podeSalvar = true;
                    }
            }

            if ($scope.listaFormularioInvalido.length == 0 && (!!podeSalvar)) {
                console.log("Salvar no Valida FOrmulario");
                $scope.salvarValePresente();
            }
        });
    };


    var abrirEscolhaBandeiraCartao = function (tipoPagamento) {
        $scope.dadosValePresente.faturamento.recebimentoCartao = [];
        $scope.modalBandeirasCartao = ModalService.abrir('views/pdv/modalBandeiraCartao.html', 'lg', true, 'static', true, 'ModalBandeiraCartaoController', { 'tipoPagamento': tipoPagamento });
        $scope.modalBandeirasCartao.result.then(function (retornoDadosBandeiraCartao) {
            if (!!retornoDadosBandeiraCartao == false) {
                $timeout(function () {
                    $scope.desabilitar = false;
                    $scope.dadosValePresente.faturamento.cpg_id = null;
                    //$scope.listarCondicaoPagamento();
                }, 100)
            } else {
                var dadosBandeiraCartaoEmpresa = JSON.parse(bandeiraCartaoEmpresaAppService.retornaDadosBandeiraCartaoEmpresa(retornoDadosBandeiraCartao.bandeira.bce_id));
                var dataAtual = new Date();
                if (!!retornoDadosBandeiraCartao.cartaoCredito) {
                    $scope.dadosValePresente.faturamento.recebimentoCartao = [];
                    if (retornoDadosBandeiraCartao.tipoParcelamento == tipoParcelamentoCartao.estabelecimento) {
                        var numeroDias = parseInt(dadosBandeiraCartaoEmpresa.bce_nrodiasrecebimentocredito);
                        angular.forEach($scope.dadosValePresente.faturamento.listaParcelas, function (parcela) {
                            $scope.dadosValePresente.faturamento.recebimentoCartao.push({
                                tipoParcelamento: tipoParcelamentoCartao.estabelecimento,
                                bce_id: retornoDadosBandeiraCartao.bandeira.bce_id,
                                rcc_parcelarecebimento: parcela.prc_numeroparcela,
                                rcc_valor: parcela.prc_valor,
                                rcc_nsu: retornoDadosBandeiraCartao.nsu,
                                rcc_previsaorecebimento: new Date(dataAtual.setDate(dataAtual.getDate() + numeroDias))
                            });
                        })
                    } else {
                        dataAtual = new Date();
                        $scope.dadosValePresente.faturamento.recebimentoCartao.push({
                            tipoParcelamento: tipoParcelamentoCartao.comprador,
                            bce_id: retornoDadosBandeiraCartao.bandeira.bce_id,
                            rcc_parcelarecebimento: 1,
                            rcc_valor: $scope.dadosValePresente.acf_valor,
                            rcc_nsu: retornoDadosBandeiraCartao.nsu,
                            rcc_previsaorecebimento: new Date(dataAtual.setDate(dataAtual.getDate() + parseInt(dadosBandeiraCartaoEmpresa.bce_nrodiasrecebimentocredito)))
                        });
                    }
                } else {
                    dataAtual = new Date();
                    $scope.dadosValePresente.faturamento.recebimentoCartao.push({
                        tipoParcelamento: null,
                        bce_id: retornoDadosBandeiraCartao.bandeira.bce_id,
                        rcc_parcelarecebimento: 1,
                        rcc_valor: $scope.dadosValePresente.acf_valor,
                        rcc_nsu: retornoDadosBandeiraCartao.nsu,
                        rcc_previsaorecebimento: new Date(dataAtual.setDate(dataAtual.getDate() + parseInt(dadosBandeiraCartaoEmpresa.bce_nrodiasrecebimentodebito)))
                    });
                }

                $scope.salvarValePresente();
            }
        });
    };

    function gerarParcelasCartaoIntegrado() {
        var definicaoParcelamento = [];
        var parcelas = [];
        $scope.dadosValePresente.faturamento.recebimentoCartao = [];
        var dataAtual = new Date();

        if (!!$scope.dadosValePresente.faturamento.cpg_id == true && !!$scope.dadosValePresente.faturamento.cpg_id == true)
            definicaoParcelamento = JSON.parse(condicaoPagamentoAppService.listaParcelasCondicao($scope.dadosValePresente.faturamento.cpg_id.cpg_id));
        var somaParcelas = 0;
        var resto = 0;
        if (definicaoParcelamento.length > 0) {
            angular.forEach(definicaoParcelamento, function (parcela, indice) {
                var valorParcela = 0;
                var dataVencimentoParcela = new Date(dataAtual.setDate(dataAtual.getDate() + parcela.pcl_numerodias));
                valorParcela = ((parcela.pcl_percparcela / 100) * ($scope.dadosValePresente.acf_valor)).toFixed(2);
                parcelas.push({
                    prc_numeroparcela: indice + 1,
                    prc_valor: parseFloat(valorParcela),
                    prc_datavencimento: dataVencimentoParcela
                });
                somaParcelas += parseFloat(valorParcela);
                somaParcelas = parseFloat(somaParcelas);
            });
            resto = ($scope.dadosValePresente.acf_valor - somaParcelas).toFixed(2);
            resto = parseFloat(resto);
        } else {
            var dataVencimentoParcela = new Date(dataAtual.setDate(dataAtual.getDate() + 1));
            parcelas.push({
                prc_numeroparcela: 30,
                prc_valor: parseFloat($scope.dadosValePresente.acf_valor),
                prc_datavencimento: dataVencimentoParcela
            });
        }

        if (resto != 0) {
            var numeroUltimaParcela = 0;
            if (definicaoParcelamento.length > 0) {
                numeroUltimaParcela = definicaoParcelamento.length - 1;
            } else {
                numeroUltimaParcela = 1;
            }
            var valParcela = parseFloat(parcelas[numeroUltimaParcela].prc_valor);
            var totalParcela = (valParcela + resto).toFixed(2);
            totalParcela = parseFloat(totalParcela);
            parcelas[numeroUltimaParcela].prc_valor = parseFloat(totalParcela);
        }

        angular.forEach(parcelas, function (parcela) {
            $scope.dadosValePresente.faturamento.recebimentoCartao.push({
                tipoParcelamento: tipoParcelamentoCartao.estabelecimento,
                bce_id: null,
                rcc_parcelarecebimento: parcela.prc_numeroparcela,
                rcc_valor: parcela.prc_valor,
                rcc_nsu: null,
                rcc_previsaorecebimento: parcela.prc_datavencimento//new Date(dataAtual.setDate(dataAtual.getDate() + numeroDias))
            });
        })
    }

    $scope.salvarValePresente = function () {
        console.log("salvarValePresente", $scope.dadosValePresente);
        if (!!$scope.dadosValePresente.faturamento.listaParcelas) {
            var parcela = {};
            parcela = (!!$scope.dadosValePresente.faturamento.listaParcelas.length > 0) ? $scope.dadosValePresente.faturamento.listaParcelas : [];
        }
        if (!!$scope.dadosValePresente.faturamento.cheques) {
            var cheques = {};
            cheques = (!!$scope.dadosValePresente.faturamento.cheques.length > 0) ? $scope.dadosValePresente.faturamento.cheques[0] : null;
        }
        var dadosValePresente = {
            acf_valor: $scope.dadosValePresente.acf_valor,
            acf_nomepresenteado: $scope.dadosValePresente.acf_nomepresenteado,
            acf_datalancamento: $scope.dadosValePresente.acf_datalancamento,
            fpg_id: $scope.dadosValePresente.faturamento.fpg_id.fpg_id,
            cpg_id: (!!$scope.dadosValePresente.faturamento.cpg_id) ? $scope.dadosValePresente.faturamento.cpg_id.cpg_id : null,
            acf_observacao: $scope.dadosValePresente.acf_observacao,
            ctg_id: $scope.dadosValePresente.ctg_id,
            integrapgto: $scope.dadosValePresente.faturamento.integrapgto,
            recebimentoCartao: $scope.dadosValePresente.faturamento.recebimentoCartao,
            parcelas: parcela,
            cheques: cheques,
            pes_id: (!!$scope.dadosValePresente.pessoa) ? $scope.dadosValePresente.pessoa.pes_id : null,
            idCliente: (!!$scope.dadosValePresente.pessoa) ? $scope.dadosValePresente.pessoa.Id : null
        }
        console.log("dadosValePresente", dadosValePresente)
        var retornoInclusao = antecipacaoClienteFornecedorAppService.incluirValePresente(JSON.stringify(dadosValePresente));
        console.log("retornoInclusao", retornoInclusao);
        if (retornoInclusao) {
            $scope.imprimirValePresenteImpressora(retornoInclusao.acf_codigovalepresente);
            if ($scope.dadosValePresente.faturamento.fpg_id.fpg_tipopagamento == tipoFormaPagamento.fpCreditoLoja) {
                $scope.imprimeCarneValePresente($scope.dadosValePresente, retornoInclusao.acf_codigovalepresente);
            }
        }
        $scope.voltarListaValePresente();
    }


    $scope.verificaIntegracaoPagamentos = function (dadosPagamento, index) {
        if (dadosPagamento.fpg_id.fpg_tipointegracao == 2) {//payer
            var _paymentType = "";
            var _paymentMethodSubType = "";
            var _installments = "";
            var _paymentMethod = "";
            if (dadosPagamento.fpg_id.fpg_tipopagamento == tipoFormaPagamento.fpCartaoCredito) {
                _paymentMethod = "Card";
                _paymentType = "Credit";
                _paymentMethodSubType = "Financed_no_Fees";
                if (dadosPagamento.listaParcelas.length == 1) {
                    _paymentMethodSubType = "Full_Payment";
                } else {
                    _installments = (dadosPagamento.listaParcelas.length).toString();
                }
            }
            if (dadosPagamento.fpg_id.fpg_tipopagamento == tipoFormaPagamento.fpCartaoDebito) {
                if (dadosPagamento.listaParcelas.length >= 1) {
                    if (dadosPagamento.listaParcelas.length == 1) {
                        _paymentMethodSubType = "Predated_Debit";
                    } else {
                        _paymentMethodSubType = "Financed_Debit";
                    }
                    _installments = (dadosPagamento.listaParcelas.length).toString();
                } else {
                    _paymentMethodSubType = "Full_Payment";
                }
                _paymentMethod = "Card";
                _paymentType = "Debit"
            }
            if (dadosPagamento.fpg_id.fpg_tipopagamento == tipoFormaPagamento.fpPix) {
                _paymentType = "Cash";
                _paymentMethod = "Pix";
            }
            var dados = {
                value: $scope.dadosValePresente.acf_valor,
                paymentMethod: _paymentMethod,
                paymentType: _paymentType,
                paymentMethodSubType: _paymentMethodSubType,
                installments: _installments
            };
            try {
                var retornoPayer = payerPagamentoAppService.efetuarPagamento(JSON.stringify(dados));
                console.log(retornoPayer);
                openModalPagamento(dadosPagamento, index);
            } catch (e) {
                console.log(e);
                $scope.desabilitar = false;
                swal("Verifique se o checkout Payer esteja iniciado, caso contrário inicie o mesmo para continuar!", "", "warning");
            }
        } else if (dadosPagamento.fpg_id.fpg_tipointegracao == 1) {//vero
            var tipopgto = 0;
            var metodopgto = 0;
            var submetodopgto = 0;

            if (dadosPagamento.fpg_id.fpg_tipopagamento === tipoFormaPagamento.fpCartaoCredito) {
                tipopgto = 2;
                metodopgto = 1;
                submetodopgto = 4;
                if (dadosPagamento.listaParcelas.length == 1) {
                    submetodopgto = 1
                }
            }
            if (dadosPagamento.fpg_id.fpg_tipopagamento === tipoFormaPagamento.fpCartaoDebito) {
                tipopgto = 3;
                metodopgto = 1;
                submetodopgto = 1;
                if (dadosPagamento.listaParcelas.length >= 1) {
                    submetodopgto = 3
                }
            }
            if (dadosPagamento.fpg_id.fpg_tipopagamento === tipoFormaPagamento.fpPix) {
                tipopgto = 1;
                metodopgto = 3;
                submetodopgto = 1
            }
            dadosIntegracaoPos = {
                imp_valor: $scope.dadosValePresente.acf_valor,
                imp_tipopgto: tipopgto,
                imp_metodopgto: metodopgto,
                imp_submetodopgto: submetodopgto,
                imp_qtdeparcelas: dadosPagamento.listaParcelas.length,
            }
            if (dadosPagamento.hasOwnProperty("integrapgto") == false) {
                dadosPagamento.integrapgtook = false;
                dadosPagamento.integrapgto = integraPagtoAppService.incluir(JSON.stringify(dadosIntegracaoPos));
            }
            else if (dadosPagamento.faturamento.integrapgto == null) {
                dadosPagamento.integrapgtook = false;
                dadosPagamento.integrapgto = integraPagtoAppService.incluir(JSON.stringify(dadosIntegracaoPos));
            }
            dadosPagamento.id = dadosPagamento.integrapgto.id;
            openModalPagamento(dadosPagamento, index);
        }
        else if (dadosPagamento.fpg_id.fpg_tipointegracao == 3) {//TEF
            var tipopgto = 0;
            var metodopgto = 0;
            var submetodopgto = 0;

            if (dadosPagamento.fpg_id.fpg_tipopagamento === tipoFormaPagamento.fpCartaoCredito) {
                tipopgto = 2;
                metodopgto = 1;
                submetodopgto = 4;
                if (dadosPagamento.listaParcelas.length == 1) {
                    submetodopgto = 1
                }
            }
            if (dadosPagamento.fpg_id.fpg_tipopagamento === tipoFormaPagamento.fpCartaoDebito) {
                tipopgto = 3;
                metodopgto = 1;
                submetodopgto = 1;
                if (dadosPagamento.listaParcelas.length >= 1) {
                    submetodopgto = 3
                }
            }
            if (dadosPagamento.fpg_id.fpg_tipopagamento === tipoFormaPagamento.fpPix) {
                tipopgto = 1;
                metodopgto = 3;
                submetodopgto = 1
            }
            dadosTef = {
                imp_valor: $scope.dadosValePresente.acf_valor,
                imp_tipopgto: tipopgto,
                imp_metodopgto: metodopgto,
                imp_submetodopgto: submetodopgto,
                imp_qtdeparcelas: dadosPagamento.listaParcelas.length,
            }
            try {
                var retornoTef = tefAppService.realizarRecebimentoParcelaTransacaoTef(dadosPagamento.fpg_id.fpg_codigofuncaotef, dadosTef.imp_valor.toFixed(2));
                console.log("Retorno TEF", retornoTef);
                if (retornoTef) {
                    if (retornoTef.statusTransacao == 1)// se status pendente de confirmação
                    {
                        $scope.dadosValePresente.faturamento.integrapgto = integraPagtoAppService.incluirDadosTef(JSON.stringify(retornoTef), JSON.stringify(dadosTef));
                        $scope.dadosValePresente.faturamento.integrapgtook = true;
                        $scope.salvarValePresente();
                    } else {
                        if (retornoTef.retInt < 0) {
                            if (retornoTef.retInt == -1) {
                                swal("Módulo não inicializado!", "Cód. Retorno -1", "warning");
                            }
                            else if (retornoTef.retInt == -2) {
                                swal("Operação cancelada pelo Operador!", "Cód. Retorno -2", "warning");
                            }
                            else if (retornoTef.retInt == -5) {
                                swal(" comunicação com o SiTef!", "Cód. Retorno -5", "warning");
                            }
                            else if (retornoTef.retInt == -6) {
                                swal("Operação cancelada pelo usuário (no pinpad)!", "Cód. Retorno -6", "warning");
                            }
                            else if (retornoTef.retInt == -22) {
                                swal("Carteira Digital não habilitada!", "Cód. Retorno -22", "warning");
                            }
                            else if (retornoTef.retInt == -24) {
                                swal("Carteira Digital - Trn. nao habilitada!", "Cód. Retorno -24", "warning");
                            }
                            else if (retornoTef.retInt == -43) {
                                swal("Problema na execução de alguma das rotinas no pinpad!", "Cód. Retorno -43", "warning");
                            }
                            else if (retornoTef.retInt == -100) {
                                swal("Erro interno do módulo!", "Cód. Retorno -100", "warning");
                            }
                            else {
                                swal("Não Foi possível  concluir transação TEF!", "Cód.Retorno" + retornoTef.retInt, "warning");
                            }
                        } else {
                            swal("Não Foi possível  concluir transação TEF!", "Cód.Retorno" + retornoTef.retInt, "warning");
                        }
                    }
                } else {
                    swal("Não Foi possível  concluir transação TEF!", "Cód. Retorno " + retornoTef.retInt, "warning");
                }
            } catch (e) {
                console.log(e);
                swal("Não Foi possível chamar as funções TEF!", "Sem Retorno", "warning");
            }
        }
    };

    function openModalPagamento(dadosPagamento, index) {
        swal({
            title: "Aguardando Pagamento Via Integração!",
            text: "Verifique no Checkout Payer",
            type: "warning",
            showCancelButton: true,
            cancelButtonText: "Cancelar",
            confirmButtonClass: "btn-info",
            confirmButtonText: "Verificar Novamente",
            closeOnConfirm: true
        }, function (isConfirm) {
            if (isConfirm) {
                $scope.verificaPagamento(dadosPagamento, index);
            }
            else {
                $scope.desabilitar = false;
            }
        });
    }

    $scope.verificaPagamento = function (dadosPagamento, index) {
        console.log("verificaPagamento");
        if (dadosPagamento.fpg_id.fpg_tipointegracao == 2) {//payer
            try {
                var ret = payerPagamentoAppService.consultarPagamento();
                $timeout(function () {
                    if (ret.statusTransaction == "PENDING") {
                        openModalPagamento(dadosPagamento, index);
                    } else if (ret.operationType == "PAYMENT" && ret.statusTransaction == "APPROVED") {
                        $scope.dadosValePresente.faturamento.integrapgtook = true;
                        $scope.dadosValePresente.faturamento.integrapgto = ret;
                        console.log("verificaPagamento salvarValePresente ");
                        $scope.salvarValePresente();
                    } else if (ret.statusTransaction == "UNAUTHORIZED") {
                        $scope.verificarFormaPagamentoSelecionada();
                        $scope.desabilitar = false;
                        swal("Efetue o login no checkout Payer!", "", "warning");
                    }
                    else if (ret.statusTransaction == "ABORTED") {
                        $scope.verificarFormaPagamentoSelecionada();
                    }
                }, 1000)
                console.log("Retorno " + ret.statusTransaction, ret);
            } catch (e) {
                $scope.desabilitar = false;
                console.log(e);
                swal("Certifique-se que o checkout Payer esteja iniciado, caso contrário inicie o mesmo para continuar!", "Atenção", "warning");
            }
        }
        else if (dadosPagamento.fpg_id.fpg_tipointegracao == 1) { // Vero
            var ret = integraPagtoAppService.consultaPagamento(dadosPagamento.integrapgto.id);
            console.log(ret)
            $timeout(function () {
                if (ret == null) {
                    swal("Atenção", "Não foi possível consultar dados do pagamento, API encontra-se instável  no momento . Tente Novamente dentro de alguns instantes!!", "warning");
                }
                if (ret.imp_statuspgto == 3) {
                    openModalPagamento(dadosPagamento, index);
                } else if (ret.imp_statuspgto == 1) {
                    $scope.dadosValePresente.faturamento.integrapgtook = true;
                    $scope.dadosValePresente.faturamento.integrapgto = ret;
                    $scope.salvarValePresente();
                } else if (ret.statusTransaction == 7) {
                    $scope.verificarFormaPagamentoSelecionada();
                    swal("Pagamento não autorizado!", "", "warning");
                }
                else if (ret.statusTransaction == 5) {
                    $scope.verificarFormaPagamentoSelecionada();
                    swal("Pagamento não abortado!", "", "warning");
                }
            }, 1000)
        }
    };
    $scope.verificarFormaPagamentoSelecionada = function () {
        console.log("verificarFormaPagamentoSelecionada");
        $scope.validarFormulario($scope.dadosValePresente);
    }

    $scope.voltarListaValePresente = function () {
        DadosFormularioService.limparDados('valePresente-manutencao');
        $state.go('newpdv.valePresente-lista');
    };

    $scope.setarFocus = function (nomeElemento) {
        if ((parseInt(nomeElemento))) {
            $scope.paginaAtiva = parseInt(nomeElemento);
        } else {
            $timeout(function () {
                document.getElementsByName(nomeElemento)[0].focus();
            });

            $timeout(function () {
                $scope.$apply(function () {
                    $('select[name="' + nomeElemento + '"]').chosen({});
                    $('select[name="' + nomeElemento + '"]').trigger("chosen:open");
                });
            });
        }
    };

    $scope.selecionaFormaPagamento = function (idFormaPagamento) {
        if (!!idFormaPagamento)
            $timeout(function () {
                $scope.setarFocus('cpg_id');
            }, 100);
    };

    $scope.imprimirValePresentePDF = function (codigoValePresente) {
        var vale = antecipacaoClienteFornecedorAppService.gerarComprovante(codigoValePresente);
        window.open("data:application/pdf;base64, " + vale);
    };

    $scope.imprimirValePresenteImpressora = function (codigovalepresente) {
        antecipacaoClienteFornecedorAppService.gerarComprovanteParaImpressoraNaoFiscal(codigovalepresente);
    }

    $scope.imprimirValePresenteListagem = function (codigoValePresente) {
        swal({
            title: 'Como deseja Imprimir?',
            text: "",
            type: "warning",
            confirmButtonClass: "btn-info",
            confirmButtonText: " GERAR PDF ",
            closeOnConfirm: true,
            showCancelButton: true,
            cancelButtonText: " IMPRESSORA NÃO FISCAL ",
            cancelButtonClass: "btn-danger"
        }, function (acao) {
            if (acao) {
                /* Gera em PDF */
                $timeout(function () {
                    $scope.imprimirValePresentePDF(codigoValePresente);
                }, 100);
            } else {
                /* Impressora Não Fiscal */
                $scope.imprimirValePresenteImpressora(codigoValePresente);
            }
        });
    }

    $scope.gerarParcelas = function (codigoCondicao) {
        $scope.dadosValePresente.faturamento.listaParcelas = [];

        if (!!codigoCondicao) {
            var retornoCondicao = JSON.parse(condicaoPagamentoAppService.listaParcelasCondicao(codigoCondicao));
            var parametrosEmpresa = parametrosEmpresaAppService.retornaDadosParametrosEmpresa();

            if (retornoCondicao.length > 0) {
                //$scope.lancamentoCheque(retornoCondicao.length, null, null, $scope.dadosValePresente.faturamento.fpg_id.fpg_tipopagamento);
                var dadosFormaPgto = {};
                dadosFormaPgto.forma = $scope.dadosValePresente.faturamento.fpg_id.fpg_descricao;
                dadosFormaPgto.condicao = $scope.dadosValePresente.faturamento.cpg_id.cpg_descricao;
                dadosFormaPgto.cpg_id = $scope.dadosValePresente.faturamento.cpg_id.cpg_id;
                dadosFormaPgto.valorPagamentoCondicaoForma = $scope.dadosValePresente.acf_valor;
                var _parcelas = [];
                var resto = 0;
                var somaParcelas = 0;
                angular.forEach(retornoCondicao, function (retornoParcelas) {
                    var dataAtual = new Date();
                    var multiplas = {};
                    var dataVencimento = new Date(dataAtual.setDate(dataAtual.getDate() + retornoParcelas.pcl_numerodias));

                    var pcl_toleranciaparcela = new Date(dataVencimento);
                    if (!!parametrosEmpresa.par_diastoleranciaparcela) {
                        pcl_toleranciaparcela = new Date(pcl_toleranciaparcela.setDate(dataVencimento.getDate() + parametrosEmpresa.par_diastoleranciaparcela));
                    } else {
                        pcl_toleranciaparcela = new Date(pcl_toleranciaparcela.setDate(pcl_toleranciaparcela.getDate() + 720));
                    }
                    pcl_toleranciaparcela = FuncaoService.formataDataNormal(pcl_toleranciaparcela);

                    multiplas.fpg_id = $scope.dadosValePresente.faturamento.fpg_id.fpg_id;
                    multiplas.fpg_descricao = $scope.dadosValePresente.faturamento.fpg_id.fpg_descricao;
                    multiplas.fpg_tipopagamento = $scope.dadosValePresente.faturamento.fpg_id.fpg_tipopagamento;
                    multiplas.cpg_id = retornoParcelas.cpg_id;
                    multiplas.cpg_descricao = $scope.dadosValePresente.faturamento.cpg_id.cpg_descricao;
                    multiplas.pcl_numerodias = retornoParcelas.pcl_numerodias;
                    multiplas.pcl_percparcela = retornoParcelas.pcl_percparcela;
                    multiplas.prc_numeroparcela = retornoParcelas.pcl_numeroparcela;
                    multiplas.dataVencimento = new Date(dataVencimento);
                    multiplas.prc_datavencimento = new Date(dataVencimento);
                    multiplas.pcl_toleranciaparcela = (!!pcl_toleranciaparcela) ? pcl_toleranciaparcela : null;
                    var valorParcela = ((retornoParcelas.pcl_percparcela / 100) * (dadosFormaPgto.valorPagamentoCondicaoForma)).toFixed(2);
                    multiplas.prc_valor = parseFloat(valorParcela);
                    somaParcelas += multiplas.prc_valor;
                    _parcelas.push(multiplas);

                });
                resto = dadosFormaPgto.valorPagamentoCondicaoForma - somaParcelas;
                if (resto != 0) {
                    var numeroUltimaParcela = retornoCondicao.length - 1;
                    var valParcela = parseFloat(_parcelas[numeroUltimaParcela].prc_valor);
                    var totalParcela = (valParcela + resto).toFixed(2);
                    _parcelas[numeroUltimaParcela].prc_valor = parseFloat(totalParcela);
                }
                $scope.dadosValePresente.faturamento.listaParcelas = _parcelas;

                if ($scope.dadosValePresente.faturamento.listaParcelas.length > 0) {
                    $scope.isOpen = true;
                } else {
                    $scope.isOpen = false;
                }
            }
        }
        else {
            $scope.dadosValePresente.faturamento.valorPagamentoCondicaoForma = null;
        }
    };

    $scope.recalculaParcelas = function () {
        $scope.valorCalculadoParcelas = 0;
        for (var i = 0; i < $scope.dadosValePresente.faturamento.listaParcelas.length; i++) {
            $scope.valorCalculadoParcelas += $scope.dadosValePresente.faturamento.listaParcelas[i].prc_valor;
        }
        var valorParcelas = parseFloat($scope.valorCalculadoParcelas).toFixed(2);

        $scope.diferencaValor = parseFloat(($scope.dadosValePresente.acf_valor - valorParcelas)).toFixed(2);
        var valorFormaPagamento = FuncaoService.retornaMoney($scope.dadosValePresente.acf_valor);
        if ($scope.diferencaValor != 0) {
            swal({
                title: "A soma das parcelas está com uma diferença de  R$ " + $scope.diferencaValor +
                    " do valor declarado para a forma de pagamento R$ " + valorFormaPagamento + "     Deseja que o sistema recalcule as parcelas para você?",
                type: "warning",
                showCancelButton: true,
                cancelButtonText: "Não",
                confirmButtonClass: "btn-danger",
                confirmButtonText: "Sim, quero recalcular",
                closeOnConfirm: true
            },
                function () {
                    $scope.$apply(function () {
                        $scope.gerarParcelas($scope.dadosValePresente.faturamento.cpg_id.cpg_id);
                    });
                })
        }
    };

    $scope.refazParcelas = function (posicao, dadosParcela) {

        var valorTotalFormaPagamento = $scope.dadosValePresente.acf_valor;
        var valorParcial = 0;
        var somaParcelas = 0;
        var resto = 0;
        var percentualParcela = 100 / ($scope.dadosValePresente.faturamento.listaParcelas.length - (posicao + 1));
        for (var i = 0; i < $scope.dadosValePresente.faturamento.listaParcelas.length; i++) {
            if (i <= posicao) {
                valorParcial += $scope.dadosValePresente.faturamento.listaParcelas[i].prc_valor;
            } else {
                var diferenca = (valorTotalFormaPagamento - parseFloat(valorParcial)).toFixed(2);
                var valorParcela = ((percentualParcela / 100) * (parseFloat(diferenca))).toFixed(2);
                $scope.dadosValePresente.faturamento.listaParcelas[i].prc_valor = parseFloat(valorParcela);
            }
            somaParcelas += $scope.dadosValePresente.faturamento.listaParcelas[i].prc_valor;
            somaParcelas = parseFloat(somaParcelas);

        }
        resto = valorTotalFormaPagamento - somaParcelas;
        resto = resto.toFixed(2);
        resto = parseFloat(resto);
        if (resto != 0) {
            var numeroUltimaParcela = $scope.dadosValePresente.faturamento.listaParcelas.length - 1;
            if (posicao == numeroUltimaParcela) {
                var diferencaValor = FuncaoService.retornaMoney(resto);
                swal({
                    title: "A soma das parcelas está com uma diferença de  R$ " + diferencaValor.toFixed(2) +
                        " Deseja ajustar essa diferença na parcela atual ou recalcular automaticamente todas as parcelas anteriores?",
                    type: "warning",
                    showCancelButton: true,
                    cancelButtonText: "Ajustar",
                    confirmButtonClass: "btn-info",
                    confirmButtonText: "Recalcular",
                    closeOnConfirm: true
                }, function (acao) {
                    if (acao) {
                        $timeout(function () {
                            var valorRecalcular = valorTotalFormaPagamento - parseFloat($scope.dadosValePresente.faturamento.listaParcelas[numeroUltimaParcela].prc_valor);
                            var perceParcela = 100 / ($scope.dadosValePresente.faturamento.listaParcelas.length - 1);
                            somaParcelas = 0;
                            resto = 0;
                            somaParcelas = parseFloat($scope.dadosValePresente.faturamento.listaParcelas[numeroUltimaParcela].prc_valor);
                            for (var i = 0; i < $scope.dadosValePresente.faturamento.listaParcelas.length; i++) {
                                if (i < numeroUltimaParcela) {
                                    var valorParcelaRecalculada = ((perceParcela / 100) * (parseFloat(valorRecalcular))).toFixed(2);
                                    $scope.dadosValePresente.faturamento.listaParcelas[i].prc_valor = parseFloat(valorParcelaRecalculada);
                                    somaParcelas += $scope.dadosValePresente.faturamento.listaParcelas[i].prc_valor;
                                    somaParcelas = parseFloat(somaParcelas);
                                }
                            }
                            resto = valorTotalFormaPagamento - somaParcelas;
                            resto = resto.toFixed(2);
                            resto = parseFloat(resto);
                            if (resto != 0) {
                                var valParcela = parseFloat($scope.dadosValePresente.faturamento.listaParcelas[numeroUltimaParcela - 1].prc_valor);
                                var totalParcela = (valParcela + resto).toFixed(2);
                                $scope.dadosValePresente.faturamento.listaParcelas[numeroUltimaParcela - 1].prc_valor = parseFloat(totalParcela);
                            }
                        }, 100);
                    } else {
                        $scope.$apply(function () {
                            var valParcela = parseFloat($scope.dadosValePresente.faturamento.listaParcelas[numeroUltimaParcela].prc_valor);
                            var totalParcela = (valParcela + resto).toFixed(2);
                            $scope.dadosValePresente.faturamento.listaParcelas[numeroUltimaParcela].prc_valor = parseFloat(totalParcela);
                        });
                    }
                });
            } else {
                var valParcela = parseFloat($scope.dadosValePresente.faturamento.listaParcelas[numeroUltimaParcela].prc_valor);
                var totalParcela = (valParcela + resto).toFixed(2);
                $scope.dadosValePresente.faturamento.listaParcelas[numeroUltimaParcela].prc_valor = parseFloat(totalParcela);

            }
        }
    };

    $scope.lancamentoCheque = function (quantidadeCheques, valorTotalCheques, indiceMultiplasFormasPagamento, tipoPagamento) {
        $timeout(function () {
            $scope.dadosValePresente.faturamento.cheques = [];
            var cheque = {};
            cheque = (!!$scope.dadosValePresente.faturamento.cheques.length > 0) ? $scope.dadosValePresente.faturamento.cheques : null;
            valorTotalCheques = $scope.dadosValePresente.acf_valor;
            if (tipoPagamento === tipoFormaPagamento.fpCheque) {
                if (quantidadeCheques === 0) quantidadeCheques = 1;
                var clienteId = null;
                if (!!$scope.dadosValePresente.pessoa)
                    clienteId = (!!$scope.dadosValePresente.pessoa.Id) ? $scope.dadosValePresente.pessoa.Id : null;
                $scope.modalCheque = ModalService.abrir('views/pdv/cheques/modalCheques.html', 'lg', true, 'static', true, 'ModalChequeController', { 'quantidadeCheques': quantidadeCheques, 'valorTotal': valorTotalCheques, 'cli_id': clienteId });
                $scope.modalCheque.result.then(function (dadosCheques) {
                    if (!!dadosCheques) {
                        var cheques = [];
                        angular.forEach(dadosCheques, function (cheque) {
                            cheques.push({
                                ban_id: cheque.ban_id,
                                chq_codigocompensacao: cheque.chq_codigocompensacao,
                                cli_id: cheque.cli_id,
                                pes_id: cheque.pes_id,
                                chq_agencia: cheque.chq_agencia,
                                chq_c1: cheque.chq_c1,
                                chq_contacorrente: cheque.chq_contacorrente,
                                chq_c2: cheque.chq_c2,
                                chq_serie: cheque.chq_serie,
                                chq_numero: cheque.chq_numero,
                                chq_c3: cheque.chq_c3,
                                chq_valor: cheque.chq_valor,
                                linha1: cheque.linha1,
                                ban_descricao: cheque.ban_descricao,
                                chq_cmc7: cheque.chq_cmc7,
                                chq_dataemissao: cheque.chq_dataemissao,
                                chq_bompara: cheque.chq_bompara,
                                chq_emissorclientedesde: cheque.chq_emissorclientedesde,
                                chq_nomeemissor: cheque.chq_nomeemissor,
                                chq_cpfcnpjemissor: cheque.chq_cpfcnpjemissor,
                                chq_telefoneemissor: cheque.chq_telefoneemissor,
                                chq_observacao: cheque.chq_observacao,
                                ClienteId: cheque.ClienteId
                            });
                        })
                        $scope.dadosValePresente.faturamento.cheques.push(cheques);
                    } else {
                        $scope.dadosValePresente.faturamento.fpg_id = null;
                        $scope.dadosValePresente.numeroCheques = null;
                        $scope.dadosValePresente.faturamento.cheques = null;
                        console.log("Dados", $scope.dadosValePresente.faturamento);
                    }
                    $scope.fecharModalCheque();
                });
            }
        }, 100);
    };

    var valorValePresenteAntigo = 0;
    $scope.modificouValorValePresente = function (valor) {
        if (!!$scope.dadosValePresente.faturamento.fpg_id)
            if (valorValePresenteAntigo != valor)
                if ($scope.dadosValePresente.faturamento.fpg_id.fpg_tipopagamento == tipoFormaPagamento.fpCreditoLoja) {
                    if (!!$scope.dadosValePresente.faturamento.cpg_id) {
                        $scope.gerarParcelas($scope.dadosValePresente.faturamento.cpg_id.cpg_id);
                    } else {
                        $scope.gerarParcelas(null);
                    }
                } else if ($scope.dadosValePresente.faturamento.fpg_id.fpg_tipopagamento == tipoFormaPagamento.fpCheque) {
                    if (!!$scope.dadosValePresente.faturamento.cheques.length)
                        swal("Informe o Número de Cheques para esse Vale Presente!", "Preenha os dados do Cheque...", "warning");
                    $scope.dadosValePresente.numeroCheques = null;
                    $scope.dadosValePresente.faturamento.cheques = [];
                }
        valorValePresenteAntigo = valor;
    };

    $scope.imprimeCarneValePresente = function (dados, idValePresente) {
        if (dados.faturamento.fpg_id.fpg_tipopagamento == tipoFormaPagamento.fpCreditoLoja) {
            //imprimir o carnê
            if (!!dados.faturamento.fpg_id.fpg_imprimecarne) {
                var retornoModeloCarne = JSON.parse(carneAppService.imprimirCarneValePresente(idValePresente));
                if (retornoModeloCarne != null && retornoModeloCarne.modelo == modeloRelatorioCarne.Normal) {
                    if (!!retornoModeloCarne.conectadoInternet == false) {
                        swal("O PDV deve estar conectado com a Internet!", "", "warning");
                    } else {
                        RelatorioService.exibirRelatorio(retornoModeloCarne.idRelatorio, retornoModeloCarne.parametros);
                    }
                }
            }
        };
    };

    $scope.fecharModalCheque = function () {
        $scope.modalCheque.close();
    };


    $scope.imprimirAntecipacaoListagem = function (idPessoa, idNota) {
        var codigoPessoa = +idPessoa;
        var codigoNota = +idNota;
        notaFiscalDevolucaoAppService.imprimirComprovanteCredito(codigoPessoa, codigoNota);
    };

}]);


