﻿newERP.controller('VendaRealizadaController', ['$scope', 'ModalService', 'DadosFormularioService', 'FuncaoService', 'NgTableParams', '$filter', '$state', '$timeout', 'RelatorioService', '$localStorage', 'growlService', '$q', function ($scope, ModalService, DadosFormularioService, FuncaoService, NgTableParams, $filter, $state, $timeout, RelatorioService, $localStorage, growlService, $q) {

    $scope.filtro = {
        pesquisa: '',
        dias: 14,
        dataInicialSlider: new Date(),
        dataInicial: new Date(),
        dataFinal: new Date(),
        formaPagamento: null,
        condicaoPagamento: null,
        documentoFiscal: null
    };


    var tipoFormaPagamento = {
        fpDinheiro: 1,
        fpCheque: 2,
        fpCartaoCredito: 3,
        fpCartaoDebito: 4,
        fpCreditoLoja: 5,
        fpValeAlimentacao: 10,
        fpValeRefeicao: 11,
        fpValePresente: 12,
        fpValeCombustivel: 13,
        fpDuplicataMercantil: 14,
        fpBoletoBancario: 15,
        fpDepositoBancario: 16,
        fpPixDinamico: 17,
        fpTransferenciaBancaria: 18,
        fpCashback: 19,
        fpPixEstatico: 20,
        fpCreditoEmLoja: 21,
        fpFalhaDeHardware: 22,
        fpSemPagamento: 90,
        fpOutro: 99
    };

    $scope.userIsSuporte = aplicacaoService.retornaUserIsSuporte();
    $scope.parametrosEmpresa = null;
    console.log($scope.userIsSuporte)



    $scope.finalidadeNota = JSON.parse(enumAppService.listaEnum('FinalidadeNfe'));
    $scope.filtroFinalidade = [];
    angular.forEach($scope.finalidadeNota, function (finalidade) {
        if (finalidade.Key == 1 || finalidade.Key == 4)
            $scope.filtroFinalidade.push(finalidade);
    })
    $scope.filtro.finalidadeNota = $scope.filtroFinalidade;

    $scope.docFiscal = [
        {
            Key: 0,
            Value: 'DAV-LS'
        },
        {
            Key: 1,
            Value: 'NFCe'
        }
    ];

    $scope.filtro.documentoFiscal = $scope.docFiscal;

    $scope.$watch('filtro.dias', function (dia) {
        $scope.filtro.dataInicialSlider = FuncaoService.subtrairDias(new Date(), 14 - dia);
        $scope.filtro.dataInicial = FuncaoService.subtrairDias(new Date(), 14 - dia);
        $scope.listarVendas($scope.filtro.pesquisa, 10, $scope.filtro.dataInicialSlider, $scope.filtro.dataFinal, $scope.filtro.formaPagamento, $scope.filtro.condicaoPagamento, $scope.dadosListaProduto, $scope.filtro.documentoFiscal);
    });

    $scope.reenviarNfce = function (dadosVenda, indiceLista) {
        var retorno = emitirDocumentoFiscalService.reenviarNfce(dadosVenda.ntf_chavenfe);
        var quebrarRetorno = retorno.split('|');
        if (quebrarRetorno[0] == "OK") {
            swal(quebrarRetorno[1], "", "success");

            dadosVenda.ntf_status = 1;
            dadosVenda.statusnota = 'Aprovada';
            $scope.listaVendasRealizadas.splice(indiceLista, 1, dadosVenda);
        } else {
            swal(quebrarRetorno[0], "", "error");
        }
    };

    $scope.enviarTransformarNFCeComoDavLS = function (dadosVenda, indiceLista) {
        var retorno = emitirDocumentoFiscalService.enviarTransformarNFCeComoDavLS(dadosVenda.ntf_chavenfe);
        var quebrarRetorno = retorno.split('|');
        if (quebrarRetorno[0] == "OK") {
            swal(quebrarRetorno[1], "", "success");

            dadosVenda.ntf_status = 1;
            dadosVenda.statusnota = 'Aprovada';
            $scope.listaVendasRealizadas.splice(indiceLista, 1, dadosVenda);
        } else {
            swal(quebrarRetorno[0], "", "error");
        }
    };

    $scope.enviarXmlNfe = function (chave) {
        var retorno = notaFiscalAppService.enviaXmlDocumento(chave);

        if (retorno == true) {
            swal("Xml Enviado para API", "", "success");
        } else {
            swal("Erro ao enviar Xml para API", "", "error");
        }
    };

    $scope.dadosCancelamento = {
        numeroCupom: 0,
        justificativa: ''
    };

    $scope.status = "0";

    $scope.setarFocus = function (nomeElemento) {
        $timeout(function () {
            document.getElementsByName(nomeElemento)[0].focus();
        });
    };

    var impressaoComprovantes = {
        Imprimir: 0,
        PerguntarAoUsuario: 1,
        NaoImprimir: 2
    }

    $scope.abrirCancelamentoVenda = function (dadosVenda, indiceLista) {
        $scope.dadosCancelamento = dadosVenda;
        $scope.dadosCancelamento.indiceLista = indiceLista;
        $scope.dadosCancelamento.numeroCupom = dadosVenda.ntf_numero;
        $scope.dadosCancelamento.chaveNfe = dadosVenda.ntf_chavenfe;
        $scope.dadosCancelamento.protocolonfe = dadosVenda.ntf_protocolonfe;

        if (dadosVenda.ntf_docfiscal == true) {
            $scope.modalCancelamentoVenda = ModalService.model($scope, 'views/pdv/cancelamento_venda/modalCancelamentoVenda.html', '', true, true, true);
        }
        else {
            if (navigator.onLine) {
                $timeout(function () {
                    swal({
                        title: "Cancelar a venda?",
                        text: "Deseja prosseguir com o cancelamento da Venda Nro: " + dadosVenda.ntf_numero,
                        type: "warning",
                        showCancelButton: true,
                        cancelButtonText: "Não",
                        confirmButtonClass: "btn-danger",
                        confirmButtonText: "Sim, quero cancelar",
                        closeOnConfirm: true
                    },
                        function (isConfirm) {
                            if (isConfirm) {
                                $timeout(function () {
                                    var retorno = notaFiscalAppService.cancelarNfLS(dadosVenda.Id);
                                    console.log(retorno);
                                    var quebrarRetorno = retorno.split('|');
                                    if (quebrarRetorno[0] == "OK") {
                                        swal(quebrarRetorno[1], "", "success");

                                        $scope.dadosCancelamento.ntf_status = 2;
                                        $scope.dadosCancelamento.statusnota = 'Cancelada';
                                        $scope.listaVendasRealizadas.splice($scope.dadosCancelamento.indiceLista, 1, $scope.dadosCancelamento);

                                        console.log("INICIO DO CANCELAMENTO");
                                        $scope.verificaCancelamentoIntegracaoPagamentos();
                                    } else {
                                        swal(quebrarRetorno[0], "", "error");
                                        $scope.listarVendas($scope.filtro.pesquisa, 10, $scope.filtro.dataInicial, $scope.filtro.dataFinal, $scope.filtro.formaPagamento, $scope.filtro.condicaoPagamento, $scope.dadosListaProduto);
                                    }
                                }, 100);
                            }
                        });
                }, 100);
            }
            else {
                swal("Não é possivel realizar o cancelamento!", "Para realizar o cancelamento de uma venda você deve estar conectado a internet!", "warning");
            }
        }
    };

    $scope.cancelarVenda = function () {
        if (!!$scope.dadosCancelamento.justificativa) {
            var retorno = emitirDocumentoFiscalService.cancelarVenda($scope.dadosCancelamento.chaveNfe, $scope.dadosCancelamento.protocolonfe, $scope.dadosCancelamento.justificativa);
            var quebrarRetorno = retorno.split('|');
            if (quebrarRetorno[0] == "OK") {

                $scope.dadosCancelamento.ntf_status = 2;
                $scope.dadosCancelamento.statusnota = 'Cancelada';
                $scope.listaVendasRealizadas.splice($scope.dadosCancelamento.indiceLista, 1, $scope.dadosCancelamento);
                $scope.modalCancelamentoVenda.close();

                console.log("INICIO DO CANCELAMENTO");
                $scope.verificaCancelamentoIntegracaoPagamentos();

                swal(quebrarRetorno[1], "", "success");
            } else {
                swal(quebrarRetorno[0], "", "error");
                $scope.listarVendas($scope.filtro.pesquisa, 10, $scope.filtro.dataInicial, $scope.filtro.dataFinal, $scope.filtro.formaPagamento, $scope.filtro.condicaoPagamento, $scope.dadosListaProduto);
            }

        }
    };

    $scope.verificaCancelamentoIntegracaoPagamentos = function () {
        for (var i = 0; i < $scope.dadosCancelamento.formaPgto.length; i++) {
            if ($scope.dadosCancelamento.formaPgto[i].fpg_tipointegracao != null) {
                if ($scope.dadosCancelamento.formaPgto[i].fpg_tipointegracao == 1) {//Vero
                    if ($scope.dadosCancelamento.formaPgto[i].IntegraPagtoId != null) {
                        var retorno = integraPagtoAppService.estornarPagamentoVero($scope.dadosCancelamento.formaPgto[i].IntegraPagtoId);
                        if (retorno == null) {
                            swal("Atenção", "Não foi possível consultar dados do pagamento, API encontra-se instável  no momento . Tente Novamente dentro de alguns instantes!!", "warning");
                            break;
                        }
                        if (retorno.imp_idintegracao == 8) {// pendente de estorno
                            swal("Registro de Estorno enviado para o PinPad, Conclua o estono na maquininha", "success");
                        }
                    }
                } else if ($scope.dadosCancelamento.formaPgto[i].fpg_tipointegracao == 2) {//payer
                    if ($scope.dadosCancelamento.formaPgto[i].IntegraPagtoId != null) {
                        var retorno = integraPagtoAppService.buscaPagamento($scope.dadosCancelamento.formaPgto[i].IntegraPagtoId);
                        if (retorno.imp_idintegracao) {
                            //aprovado
                            if (retorno.imp_statuspgto == 1) {
                                console.log("buscaPagamentoBANCO", retorno);
                                try {
                                    var retornoPayer = payerPagamentoAppService.efetuarCancelamento(retorno.imp_idintegracao);
                                    $timeout(function () {
                                        openModalCancelamento();
                                        console.log("efetuarCancelamento", retornoPayer);
                                    }, 1000);
                                } catch (e) {
                                    console.log(e);
                                    swal("Certifique-se o checkout Payer esteja iniciado, caso contrário inicie o mesmo para continuar!", "", "warning");
                                }
                                break;
                            }
                        }
                    }
                } else if ($scope.dadosCancelamento.formaPgto[i].fpg_tipointegracao == 3) {//TEf
                    var _valorPagamento = FuncaoService.retornaSoNumeros($scope.dadosCancelamento.formaPgto[i].nfp_valor.toFixed(2).toString()).toString();
                    var _valorNumeroDoc = $scope.dadosCancelamento.formaPgto[i].imp_idintegracao.toString();
                    var _data = $scope.dadosCancelamento.ntf_dataemissao.toString();
                    var _hora = $scope.dadosCancelamento.ntf_dataemissao.toString();
                    var _Id = $scope.dadosCancelamento.formaPgto[i].IntegraPagtoId;

                    var retornoTef = tefAppService.cancelarTransacaoTef(_valorPagamento, _valorNumeroDoc, _data, _hora, _Id);
                    console.log("Retorno TEF", retornoTef);

                }
            }
        }
    };


    function openModalCancelamento() {
        swal({
            title: "Aguardando Cancelamento Via Integração!",
            text: "Verifique no Checkout Payer",
            type: "warning",
            showCancelButton: true,
            cancelButtonText: "Cancelar",
            confirmButtonClass: "btn-info",
            confirmButtonText: "Verificar Novamente",
            closeOnConfirm: true
        }, function (isConfirm) {
            if (isConfirm) {
                $timeout(function () {
                    $scope.verificaCancelamento();
                });
            }
            else {

            }
        });
    }
    $scope.verificaCancelamento = function () {
        try {
            var ret = payerPagamentoAppService.consultarCancelamento();
            console.log("verificaCancelamento ret.statusTransaction", $scope.dadosCancelamento.formaPgto);
            $timeout(function () {
                if (ret.statusTransaction == "PENDING") {
                    openModalCancelamento();
                } else if (ret.statusTransaction == "APPROVED") {
                    $scope.verificaCancelamentoIntegracaoPagamentos();
                    swal("Cancelamento do pagamento " + ret.idPayer + " vinculado com sucesso!", "", "success");
                } else if (ret.statusTransaction == "UNAUTHORIZED") {
                    $scope.verificaCancelamentoIntegracaoPagamentos();
                    swal("Efetue o login no checkout Payer!", "", "warning");
                } else if (ret.statusTransaction == "ABORTED") {
                    swal("Cancelamento não efetuado pelo checkout Payer!", "", "warning");
                }
            }, 1000)
        } catch (e) {
            console.log(e);
            swal("Verifique se o checkout Payer esteja iniciado, caso contrário inicie o mesmo para continuar!", "Atenção", "warning");
        }
    };

    $scope.listarVendas = function (filtro, paginas, dataInicial, dataFinal, formaPagamento, condicaoPagamento, dadosListaProduto) {
        dataInicial = (!!dataInicial) ? FuncaoService.formataDataInvertida(dataInicial) : "";
        dataFinal = (!!dataFinal) ? FuncaoService.formataDataInvertida(dataFinal) : "";
        filtro = (!!filtro) ? filtro : "";
        idFormaPagamento = (!!formaPagamento) ? (formaPagamento.fpg_id).toString() : "";
        idCondicaoPagamento = (!!condicaoPagamento) ? (condicaoPagamento.cpg_id).toString() : "";

        var filtroFinalidade = null;
        if (!!$scope.filtro.finalidadeNota.length) {
            for (var i = 0; i < $scope.filtro.finalidadeNota.length; i++) {
                filtroFinalidade += $scope.filtro.finalidadeNota[i].Key;
                if ((i + 1) < $scope.filtro.finalidadeNota.length)
                    filtroFinalidade += ',';
            }
            filtroFinalidade = filtroFinalidade.toString();
        }

        var filtroDocumentoFiscal = null;
        if (!!$scope.filtro.documentoFiscal.length) {
            for (var i = 0; i < $scope.filtro.documentoFiscal.length; i++) {
                filtroDocumentoFiscal += $scope.filtro.documentoFiscal[i].Key;
                if ((i + 1) < $scope.filtro.documentoFiscal.length)
                    filtroDocumentoFiscal += ',';
            }
            filtroDocumentoFiscal = filtroDocumentoFiscal.toString();
        }

        var produtos = null;
        $scope.dadosListaProduto = ($scope.dadosListaProduto) ? $scope.dadosListaProduto : null;
        if (!!$scope.dadosListaProduto) {
            for (var i = 0; i < $scope.dadosListaProduto.length; i++) {
                produtos += $scope.dadosListaProduto[i].pro_id;
                if ((i + 1) < $scope.dadosListaProduto.length)
                    produtos += ',';
            }
            produtos = produtos.toString();
        }

        $scope.listaVendasRealizadas = [];
        $scope.valorTotalCupons = 0;
        $scope.valorPorForma = 0;
        angular.forEach(JSON.parse(notaFiscalAppService.listaVendasRealizadas($scope.status, filtro, dataInicial, dataFinal, idFormaPagamento, idCondicaoPagamento, filtroFinalidade, produtos, filtroDocumentoFiscal)), function (vendas) {
            vendas.ntf_cnpjcpfdest = (!!vendas.ntf_cnpjcpfdest) ? vendas.ntf_cnpjcpfdest : null;
            vendas.diferencaHoras = FuncaoService.retornaDiferencaEmHoras(vendas.ntf_dataemissao);
            if (vendas.ntf_status == 0) {
                vendas.statusnota = 'Em Digitação';
            } else if (vendas.ntf_status == 1) {
                vendas.statusnota = 'Aprovada';
            } else if (vendas.ntf_status == 2) {
                vendas.statusnota = 'Cancelada';
            } else if (vendas.ntf_status == 3) {
                vendas.statusnota = 'Denegada';
            } else if (vendas.ntf_status == 4) {
                vendas.statusnota = 'Rejeitada';
            } else if (vendas.ntf_status == 5) {
                vendas.statusnota = 'Em Contingência';
            } else if (vendas.ntf_status == 6) {
                vendas.statusnota = 'Inutilizada';
            }
            angular.forEach($scope.finalidadeNota, function (finalidadeNota) {
                if (vendas.ntf_finalidade == finalidadeNota.Key) {
                    vendas.finalidadeNota = finalidadeNota.Value;
                }

            });
            if (idFormaPagamento) {
                angular.forEach(vendas.formaPgto, function (forma) {
                    if (idFormaPagamento == forma.fpg_id) {
                        $scope.valorPorForma += forma.nfp_valor;
                        console.log($scope.valorPorForma);
                    }
                });

            }
            if (vendas.ntf_finalidade == 1) {
                $scope.valorTotalCupons += (!!vendas.ntf_valortotal) ? vendas.ntf_valortotal : 0;
            }

            $scope.listaVendasRealizadas.push(vendas);
        });

        $scope.tabelaVendasRealizadas = new NgTableParams({
            count: paginas,
        }, {
            total: $scope.listaVendasRealizadas.length,
            getData: function ($defer, params) {

                var orderedData = $filter('orderBy')($scope.listaVendasRealizadas);
                $defer.resolve(orderedData.slice((params.page() - 1) * params.count(), params.page() * params.count()));
            }
        });
    };

    $scope.imprimirCupom = function (dadosNf) {
        $scope.parametrosEmpresa = parametrosEmpresaAppService.retornaDadosParametrosEmpresa();
        if (dadosNf.ntf_docfiscal == true) {
            if (dadosNf.ntf_finalidade == 1) {
                try {
                    notaFiscalAppService.reImprimirCupom(dadosNf.ntf_chavenfe);
                    ImprimirMeioPagamentoIntegrado(dadosNf)
                        .then(() => ImprimirDemonstrativoVendaAprazo(dadosNf))
                        .then(() => ImprimirCarne(dadosNf))
                } catch (e) {
                    swal("Erro ao Gerar Danfe!", "Ops", "warning");
                    console.log(e);
                }
            } else {
                if (dadosNf.ntf_finalidade == 4) {
                    var urlDanfe = danfeAppService.retornarURLDanfeNewERP();
                    window.open(urlDanfe + "" + dadosNf.ntf_chavenfe, '_blank');
                }
            }
        }
        else {
            if (dadosNf.ntf_finalidade == 1) {
                notaFiscalAppService.imprimirDav(dadosNf.Id);
                ImprimirMeioPagamentoIntegrado(dadosNf)
                    .then(() => ImprimirDemonstrativoVendaAprazo(dadosNf))
                    .then(() => ImprimirCarne(dadosNf))
                    .catch(handleError);
            } else {
                if (navigator.onLine) {
                    RelatorioService.exibirRelatorioJasper(20, [
                        {
                            'nome': 'idNotaFiscal',
                            'valor': dadosNf.ntf_id
                        }
                    ]);
                }
            }
        }
    };

    // Função para lidar com erros
    function handleError(error) {
        swal("Erro!", "Ocorreu um problema durante o processamento.", "warning");
        console.error(error);
    }

    // Imprime demonstrativo de venda a prazo, mesmo que o cupom não seja impresso, usado para o cliente assinar.
    function ImprimirDemonstrativoVendaAprazo(retornoVenda) {
        return new Promise((resolve, reject) => {
            var imprimirDemonstrativoVendaAprazo = false;
            if (!!retornoVenda.Id) {
                angular.forEach(retornoVenda.formaPgto, function (pagamento) {
                    if (!!pagamento) {
                        if (pagamento.fpg_tipopagamento == parseInt(tipoFormaPagamento.fpBoletoBancario) ||
                            pagamento.fpg_tipopagamento == parseInt(tipoFormaPagamento.fpCreditoLoja)) {
                            imprimirDemonstrativoVendaAprazo = true;
                        }
                    }
                });

                $timeout(function () {
                    if (imprimirDemonstrativoVendaAprazo) {
                        try {
                            var impressaoDemonstrativo = JSON.parse(carneAppService.imprimirDemonstrativo(retornoVenda.Id));
                            resolve(impressaoDemonstrativo);
                        } catch (error) {
                            reject(error);
                        }
                    } else {
                        resolve(); // Se não for necessário imprimir, continua o fluxo
                    }
                }, 100);
            } else {
                resolve(); // Caso não tenha idNotaFiscal, continua o fluxo
            }
        });
    }

    // Impressão de carnes com codigo de barras
    function ImprimirCarne(retornoVenda) {
        return new Promise((resolve, reject) => {
            var imprimirCarne = false;
            if (!!retornoVenda.Id) {
                angular.forEach(retornoVenda.formaPgto, function (pagamento) {
                    if (!!pagamento) {
                        if (!!pagamento.fpg_imprimecarne) {
                            imprimirCarne = true;
                        }
                    }
                });

                $timeout(function () {
                    if (imprimirCarne) {
                        if ($scope.parametrosEmpresa == null || $scope.parametrosEmpresa.par_impressaocarne == null) {
                            var retornoModeloCarne = JSON.parse(carneAppService.imprimir(retornoVenda.Id));
                            resolve(retornoModeloCarne);
                        } else {
                            if ($scope.parametrosEmpresa.par_impressaocarne == impressaoComprovantes.Imprimir) {
                                var retornoModeloCarne = JSON.parse(carneAppService.imprimir(retornoVenda.Id));
                                resolve(retornoModeloCarne);
                            } else if ($scope.parametrosEmpresa.par_impressaocarne == impressaoComprovantes.PerguntarAoUsuario) {
                                swal({
                                    title: "Deseja realizar a impressão do comprovante deste Carnê?",
                                    text: "Imprimir Comprovante?",
                                    type: "warning",
                                    allowOutsideClick: false,
                                    showCancelButton: true,
                                    confirmButtonText: "Sim (Enter)",
                                    confirmButtonClass: "btn-success",
                                    cancelButtonText: "Não (Esc)",
                                    cancelButtonClass: "btn-default",
                                }, function (isConfirm) {
                                    if (isConfirm) {
                                        $timeout(function () {
                                            var retornoModeloCarne = JSON.parse(carneAppService.imprimir(retornoVenda.Id));
                                            swal.close(); // Fecha o swal manualmente
                                            resolve(retornoModeloCarne);
                                        });
                                    } else {
                                        $timeout(function () {
                                            swal.close(); // Fecha o swal manualmente
                                            resolve(); // Continua o fluxo sem imprimir
                                        });
                                    }
                                });
                            }
                        }
                    } else {
                        resolve(); // Não há carne para imprimir, continua o fluxo
                    }
                }, 100);
            } else {
                resolve(); // Caso não tenha idNotaFiscal, continua o fluxo
            }
        });
    }

    // Imprime comprovantes Cartões/pix quando integrados com Sitef ou Payer e outros
    function ImprimirMeioPagamentoIntegrado(retornoVenda) {
        return new Promise((resolve, reject) => {
            var imprimirPagamentoIntegrado = false;
            angular.forEach(retornoVenda.formaPgto, function (pagamento) {
                if (pagamento.fpg_tipointegracao) {
                    imprimirPagamentoIntegrado = true;
                }
            });

            $timeout(function () {
                if (imprimirPagamentoIntegrado) {
                    try {
                        if ($scope.parametrosEmpresa == null || $scope.parametrosEmpresa.par_impressaonfce == null) {
                            var retornoComprovanteCartao = JSON.parse(carneAppService.imprimirComprovanteIntegracaoPagamentos(retornoVenda.Id));
                            resolve(retornoComprovanteCartao);
                        } else {
                            if ($scope.parametrosEmpresa.par_impressaonfce == impressaoComprovantes.Imprimir) {
                                var retornoComprovanteCartao = JSON.parse(carneAppService.imprimirComprovanteIntegracaoPagamentos(retornoVenda.Id));
                                resolve(retornoComprovanteCartao);
                            } else if ($scope.parametrosEmpresa.par_impressaonfce == impressaoComprovantes.PerguntarAoUsuario) {
                                swal({
                                    title: "Deseja realizar a impressão do comprovante de pagamento integrado?",
                                    text: "Imprimir Comprovante?",
                                    type: "warning",
                                    allowOutsideClick: false,
                                    showCancelButton: true,
                                    confirmButtonText: "Sim (Enter)",
                                    confirmButtonClass: "btn-success",
                                    cancelButtonText: "Não (Esc)",
                                    cancelButtonClass: "btn-default",
                                }, function (isConfirm) {
                                    if (isConfirm) {
                                        $timeout(function () {
                                            try {
                                                var retornoModeloCarne = JSON.parse(carneAppService.imprimirComprovanteIntegracaoPagamentos(retornoVenda.Id));
                                                swal.close(); // Fecha o swal manualmente
                                                resolve(retornoModeloCarne);
                                            } catch (error) {
                                                swal.close();
                                                reject(error);
                                            }
                                        });
                                    } else {
                                        $timeout(function () {
                                            swal.close(); // Fecha o swal manualmente
                                            resolve(); // Resolve sem erro se o usuário escolher "Não"
                                        });
                                    }
                                });
                            }
                        }
                    } catch (error) {
                        reject(error);
                    }
                } else {
                    resolve(); // Se não for necessário imprimir, continua o fluxo
                }
            }, 100);
        });
    }

    $scope.devolverCupom = function (ntfId) {
        if (!!ntfId) {
            $scope.listarNotaFiscalDevolucao = [];
            devolucao = JSON.parse(notaFiscalDevolucaoAppService.listarNotaFiscalDevolucao(ntfId))
            if (typeof devolucao === 'object') {
                if (devolucao.ntf_finalidade == 4) {
                    swal("Foi selecionada uma nota fiscal com a finalidade de devolução.", "Só podem ser devolvidas notas com finalidade Normal", "warning");
                } else {
                    if (devolucao.ItensNf.length > 0) {
                        DadosFormularioService.armazenarDados('devolucao-venda', devolucao);
                        $state.go('newpdv.devolucao-venda');
                    } else {
                        swal("Esta Nota Fiscal já foi totalmente devolvida.", "", "warning");
                    }
                }
            } else {
                var retorno = devolucao.split("|", 2);
                if (retorno[0] === "warning") {
                    swal(retorno[1], "", retorno[0]);
                }
            }
        } else {
            swal("Esta Nota Fiscal ainda não foi sincronizada com a WEB!", "", "warning");
        }
    };

    $scope.downloadXML = function (ntfChave) {
        if (!!ntfChave) {
            ret = notaFiscalAppService.downloadXML(ntfChave);
            var quebrarRetorno = ret.split('|');
            if (quebrarRetorno[0] == "OK") {
                swal(quebrarRetorno[1], "", "success");
            } else {
                swal(quebrarRetorno[0], "", "error");
            }
        }
    }

    $scope.retornaDescricaoStatus = function () {
        switch ($scope.status) {
            case "0":
                return 'Valor Total está levando em consideração Todos (Aprovados, Cancelados, Em Contingência) os cupons apresentados na lista acima';
                break;
            case "1":
                return 'Valor Total está levando em consideração "Apenas Cupons Aprovados" apresentados na lista acima';
                break;
            case "2":
                return 'Valor Total está levando em consideração "Apenas Cupons Cancelados" apresentados na lista acima';
                break;
            case "5":
                return 'Valor Total está levando em consideração "Apenas Cupons em Contingência" apresentados na lista acima';
                break;
            default:
                return 'Valor Total está levando em consideração Todos (Aprovados, Cancelados, Em Contingência) os cupons apresentados na lista acima';
                break;
        }
    };

    $scope.closeModalCancelamentoVenda = function () {
        $scope.modalCancelamentoVenda.close();
    };

    $scope.retornaDescricaoStatusForma = function (forma) {
        return 'O valor total das vendas no período pode ser maior que o valor efetuado com ' + forma + ', pois algumas vendas podem ser realizadas com multiplas formas de pagamento.'
    }

    $scope.abrirDetalhes = function (venda) {
        var idNota = venda.Id;
        $scope.modalDetalhesNotaFiscal = ModalService.abrir('views/pdv/varejo/modalDetalhesVenda.html', 'lg', true, 'static', true, 'ModalDetalhesVendaController', { 'idNota': idNota });
    };

    $scope.listaProdutos = [];
    $scope.carregaDadosProduto = function (dadosProduto) {

        $scope.listaProdutos.push({ "pro_id": dadosProduto.pro_id, "pro_descricao": dadosProduto.pro_descricao, "descricao": dadosProduto.pro_id + ' - ' + dadosProduto.pro_descricao });
        $scope.dadosListaProduto = $scope.listaProdutos;
    };

    $scope.verificaSenhaGerencial = function (dadosVenda, indiceLista) {
        var dadosPdv = JSON.parse(localAppService.retornaLocalPDV());
        if (dadosPdv != null) {
            if (dadosPdv.loc_senhagerencial) {
                swal({
                    title: "Senha Gerencial para Cancelamento",
                    text: "Para continuar o cancelamento, você deve solicitar a autorização com seu supervisor/gerente.",
                    type: "warning",
                    showCancelButton: true,
                    cancelButtonText: "OK",
                    confirmButtonClass: "btn-success",
                    confirmButtonText: "Solicitar Autorização",
                    allowOutsideClick: false
                }, function (acao) {
                    if (acao) {
                        $timeout(function () {
                            var retorno = permissaoGerencialAppService.solicitarPermissaoGerencial();
                            if (retorno == true) {
                                $scope.abrirCancelamentoVenda(dadosVenda, indiceLista);
                            }
                        }, 100);
                    }
                });
            } else {
                $scope.abrirCancelamentoVenda(dadosVenda, indiceLista);
            };
        } else {
            $scope.abrirCancelamentoVenda(dadosVenda, indiceLista);
        };

    };

    $scope.gerarAntecipacao = function (dadosVenda) {
        if (!!dadosVenda.ntf_id) {
            antecipacao = JSON.parse(notaFiscalAppService.gerarAntecipacao(dadosVenda.ntf_chavenfe));
            if (antecipacao) {
                growlService.growl('Antecipação Gerada!', 'inverse', null, 2500);
            } else {
                swal("Não é possivel gerar a antecipação!", "Já existe na base de dados", "warning");
            }
        } else {
            swal("Não é possivel gerar a antecipação!", "Nota não encontrada na base de dados", "warning");
        }
    };

}]);
