﻿newERP.controller('FinalizarVendaController', ['$scope', 'ModalService', 'hotkeys', '$state', 'DadosFormularioService', '$timeout', 'VendaService', function ($scope, ModalService, hotkeys, $state, DadosFormularioService, $timeout, VendaService) {

  $scope.principaisFormas = JSON.parse(formaPagamentoAppService.listaFormaPagamento());
  $scope.principaisFormasPagamento  = [];
  $scope.outrasFormasPagamento      = [];
  angular.forEach($scope.principaisFormas, function (formaPagamento) {
    if (formaPagamento.fpg_principal == true) {
      var formaPgto = {};
      formaPgto.fpg_id              = formaPagamento.fpg_id;
      formaPgto.fpg_descricao       = formaPagamento.fpg_descricao;
      formaPgto.fpg_tipopagamento   = formaPagamento.fpg_tipopagamento;
      formaPgto.fpg_condicaopadrao  = formaPagamento.fpg_condicaopadrao;
      formaPgto.fpg_principal       = formaPagamento.fpg_principal;
      formaPgto.tef_id              = formaPagamento.tef_id;
      $scope.principaisFormasPagamento.push(formaPgto);
    } else {
      var outrasFormas = {};
      outrasFormas.fpg_id               = formaPagamento.fpg_id;
      outrasFormas.fpg_descricao        = formaPagamento.fpg_descricao;
      outrasFormas.fpg_tipopagamento    = formaPagamento.fpg_tipopagamento;
      outrasFormas.fpg_condicaopadrao   = formaPagamento.fpg_condicaopadrao;
      outrasFormas.fpg_principal        = formaPagamento.fpg_principal;
      outrasFormas.tef_id               = formaPagamento.tef_id;
      if ($scope.principaisFormasPagamento.length < 4) {
        $scope.principaisFormasPagamento.push(outrasFormas);
      } else {
        $scope.outrasFormasPagamento.push(outrasFormas);
      }
    }
  });

  $scope.totalPago = 0;
  $scope.desconto = {
    valor: null,
    percentual: null
  };

  var tabelaFormasPagamento = document.getElementById('tabelaFormasPagamento');

  $scope.CPFNota = function () {
    if ($scope.dadosVenda.restantePagar == 0) {
      $scope.modalCPF = ModalService.model($scope, 'views/pdv/supermercado/modal_cpf/modalCPF.html', '', true, true, true);
      $timeout(function () {
        var elementoCpfCnpj = document.getElementById('cpfCnpj');
        if (elementoCpfCnpj) elementoCpfCnpj.focus();
      }, 100);
    } else {
      swal("Ainda existem valores em aberto!", "Adicione mais formas de pagamento para concluir a transação.", "warning");
    }

  };

  $scope.FreteCompra = function () {
    $scope.modalFrete = ModalService.model($scope, 'views/pdv/supermercado/modal_frete/modalFrete.html', '', true, true, true);
  };

  $scope.ValoresCompra = function (formaPagamento) {
    if ($scope.totalPago < $scope.dadosVenda.valorTotal) {      
      $scope.formaPagamento = {                
        fpg_condicaopadrao  : formaPagamento.fpg_condicaopadrao,
        fpg_descricao       : formaPagamento.fpg_descricao,
        fpg_id              : formaPagamento.fpg_id,
        fpg_principal       : formaPagamento.fpg_principal,
        fpg_tipopagamento   : formaPagamento.fpg_tipopagamento,
        tef_id              : formaPagamento.tef_id,
      };      
      $scope.modalValoresCompra = ModalService.model($scope, 'views/pdv/supermercado/modal_valores/modalValorInformar.html', '', true, true, true);
    }
    else {
      swal("O valor pago já esta cobrindo o valor desta venda!", "Para adicionar outra forma de pagamento remova uma das formas utilizadas.", "warning");
    }
  };
  $scope.keyEnterValorFormaPagamento = function () {   
    if (!!$scope.formaPagamento.valorPagamento) {
      var existeForma = false;
      for (var i = 0; i < $scope.dadosVenda.formasPagamento.length; i++) {
        if ($scope.dadosVenda.formasPagamento[i].fpg_id == $scope.formaPagamento.fpg_id) {          
          var forma = {};
          forma.fpg_id            = $scope.formaPagamento.fpg_id;
          forma.fpg_descricao     = $scope.formaPagamento.fpg_descricao;
          forma.fpg_tipopagamento = $scope.formaPagamento.fpg_tipopagamento;
          forma.tef_id            = $scope.formaPagamento.tef_id;
          forma.valorPagamento    = $scope.formaPagamento.valorPagamento + $scope.dadosVenda.formasPagamento[i].valorPagamento;              
          $scope.dadosVenda.formasPagamento.splice(i, 1, forma);
          existeForma = true;
        }
      };
      if (!existeForma) {
        $scope.dadosVenda.formasPagamento.push($scope.formaPagamento);
        $scope.formaPagamentoCupomSelecionada = $scope.dadosVenda.formasPagamento.length - 1;
      }
      $scope.totalPago += $scope.formaPagamento.valorPagamento;
      $scope.calcularPagamento();
      DadosFormularioService.armazenarDados('supermercado-pdv', $scope.dadosVenda);
      $scope.modalValoresCompra.close();
      tabelaFormasPagamento.scrollTop = tabelaFormasPagamento.scrollHeight + 53;
    }
  }

  $scope.SelecionaFormaPagamento = function () {    
    $scope.formaPagamentoSelecionar = 0;
    $scope.modalFormaPagamento = ModalService.model($scope, 'views/pdv/supermercado/modal_outrasformaspagamento/modalOutrasFormasPgto.html', '', true, true, true);
  };
  $scope.keyDownFormaPagamento = function () {
    if (($scope.formaPagamentoSelecionar + 1) < $scope.outrasFormasPagamento.length) $scope.formaPagamentoSelecionar++;
  }
  $scope.keyUpFormaPagamento = function () {
    if ($scope.formaPagamentoSelecionar > 0) $scope.formaPagamentoSelecionar--;
  }
  $scope.keyEnterFormaPagamento = function () {
    $scope.modalFormaPagamento.close();
    if (!!$scope.outrasFormasPagamento[$scope.formaPagamentoSelecionar]) {
      $scope.ValoresCompra($scope.outrasFormasPagamento[$scope.formaPagamentoSelecionar]);
    }
  }
  $scope.keyEnterRemoveFormaPagamento = function () {
    $scope.removeFormaSelecionada($scope.formaPagamentoCupomSelecionada);
  }
  $scope.RemoverFormaPagamento = function () {
    $scope.formaPagamentoCupomSelecionada = $scope.dadosVenda.formasPagamento.length - 1;
    $scope.modalFormaPagamento = ModalService.model($scope, 'views/pdv/supermercado/modal_cancelar_formaspagamento/modalCancelarFormaPagamento.html', '', true, true, true);
  };
  $scope.keyDownFormaPagamentoCancelar = function () {
    if (($scope.formaPagamentoCupomSelecionada + 1) < $scope.dadosVenda.formasPagamento.length) $scope.formaPagamentoCupomSelecionada++;
  }
  $scope.keyUpFormaPagamentoCancelar = function () {
    if ($scope.formaPagamentoCupomSelecionada > 0) $scope.formaPagamentoCupomSelecionada--;
  }

  $scope.DescontoCompra = function () {
    $scope.modalDesconto = ModalService.model($scope, 'views/pdv/supermercado/modal_desconto/modalDesconto.html', '', true, true, true);
  };
  $scope.keyEnterDesconto = function () {
    $scope.dadosVenda.valorDescontos = $scope.desconto.valor;
    DadosFormularioService.armazenarDados('supermercado-pdv', $scope.dadosVenda);
    $scope.modalDesconto.close();
  };
  $scope.keyDownDesconto = function () {
    var element = window.document.getElementById('percentualDesconto');
    if (element) element.focus();
  };
  $scope.keyUpDesconto = function () {
    var element = window.document.getElementById('valorDesconto');
    if (element) element.focus();
  };
  $scope.keyEscDesconto = function () {
    $scope.desconto = {
      valor: null,
      percentual: null
    };
    $scope.dadosVenda.valorDescontos = 0;
    DadosFormularioService.armazenarDados('supermercado-pdv', $scope.dadosVenda);
    $scope.modalDesconto.close();
    $scope.recalculaPagamento();
  };

  $scope.calculaPercentualDesconto = function () {
    if (parseFloat($scope.desconto.valor) > 0) {
      $scope.desconto.percentual = ((parseFloat($scope.desconto.valor) * 100) / parseFloat($scope.dadosVenda.valorTotal)) / 100;
    }
    else {
      $scope.desconto.percentual = null
    }
  };
  $scope.calculaValorDesconto = function () {
    $scope.desconto.valor = parseFloat($scope.dadosVenda.valorTotal) * parseFloat($scope.desconto.percentual);
  };

  $scope.keyEscCpf = function () {
    $scope.dadosVenda.consumidor = {
      cpfCnpj: ""
    };
    $scope.finalizaVenda($scope.dadosVenda.consumidor.cpfCnpj);
    $scope.modalCPF.close();
  };

  $scope.keyEnterCpf = function () {
    $scope.dadosVenda.cpfCnpj = $scope.dadosVenda.consumidor.cpfCnpj;
    DadosFormularioService.armazenarDados('supermercado-pdv', $scope.dadosVenda);
    $scope.finalizaVenda($scope.dadosVenda.consumidor.cpfCnpj);
  };

  hotkeys.bindTo($scope)
  .add({
    combo: 'f1',
    description: 'Lista de funções do sistema (esta tela)',
    callback: function () {
      hotkeys.toggleCheatSheet();
    }
  })
  .add({
    combo: 'f2',
    description: 'Adicionar Pagamento: ' + $scope.principaisFormasPagamento[0].fpg_descricao.toUpperCase(),
    callback: function () {
      $scope.ValoresCompra($scope.principaisFormasPagamento[0]);
    }
  })
  .add({
    combo: 'f3',
    description: 'Adicionar Pagamento: ' + $scope.principaisFormasPagamento[1].fpg_descricao.toUpperCase(),
    callback: function () {
      $scope.ValoresCompra($scope.principaisFormasPagamento[1]);
    }
  })
  .add({
    combo: 'f4',
    description: 'Adicionar Pagamento: ' + $scope.principaisFormasPagamento[2].fpg_descricao.toUpperCase(),
    callback: function () {
      $scope.ValoresCompra($scope.principaisFormasPagamento[2]);
    }
  })
  .add({
    combo: 'f5',
    description: 'Adicionar Pagamento: ' + $scope.principaisFormasPagamento[3].fpg_descricao.toUpperCase(),
    callback: function () {
      $scope.ValoresCompra($scope.principaisFormasPagamento[3]);
    }
  })
  .add({
    combo: 'f6',
    description: 'Ver Outras Formas de Pagamento',
    callback: function () {
      $scope.SelecionaFormaPagamento();
    }
  })
  .add({
    combo: 'f7',
    description: 'Remover Todas as Formas de Pagamento Adicionadas no Cupom',
    callback: function () {
      $scope.RemoverTodasFormasPagamentos();
    }
  })
  .add({
    combo: 'del',
    description: 'Remover uma Forma de Pagamento Incluída na Venda',
    callback: function () {
      $scope.RemoverFormaPagamento();
    }
  })
  .add({
    combo: 'f8',
    description: 'Voltar aos Itens da Venda',
    callback: function () {
      $state.go('newpdv.supermercado-pdv');
    }
  })
  .add({
    combo: 'f9',
    description: 'Aplicar desconto',
    callback: function () {
      $scope.DescontoCompra();
    }
  })
  .add({
    combo: 'f10',
    description: 'Concluir a Venda',
    callback: function () {
      $scope.CPFNota();
    }
  })
  .add({
    combo: 'f11',
    description: 'Aplicar Frete',
    callback: function () {
      $scope.FreteCompra();
    }
  })
  .add({
    combo: 'f12',
    description: 'Menu Fiscal',    
    callback: function () {
        $scope.ListaMenuFiscal();        
    }
  }).add({
      combo: 'ctrl+f1',      
      description: 'Cancelar Venda',
      callback: function () {             
          $scope.cancelarVenda();
      }
  })

  $scope.RemoverTodasFormasPagamentos = function () {
    swal({
      title: "Você Deseja Realmente Remover TODAS as Formas de Pagamento deste cupom?",
      text: "",
      type: "warning",
      showCancelButton: true,
      cancelButtonText: "Cancelar (ESC)",
      confirmButtonClass: "btn-info",
      confirmButtonText: "SIM, remover (ENTER)",
      closeOnConfirm: true
    }, function (acao) {
          if (acao) {
            $timeout(function () {           
              $scope.dadosVenda.formasPagamento = [];
              $scope.totalPago = 0;
              $scope.dadosVenda.restantePagar = ($scope.dadosVenda.valorTotal + $scope.dadosVenda.valorFrete) - $scope.dadosVenda.valorDescontos;
              $scope.dadosVenda.troco = 0;
              $scope.$digest();
              DadosFormularioService.armazenarDados('supermercado-pdv', $scope.dadosVenda);
            });
          }
      });
  }

  $scope.lerDados = function () {
    $scope.dadosVenda = DadosFormularioService.retornaDados('supermercado-pdv', {
      itens: [],
      formasPagamento: [],
      consumidor: {
        cpfCnpj: '',
        nome: ''
      },
      valorFrete: 0,
      valorDescontos: 0,
      valorTotal: 0
    }).dados;
    if (parseFloat($scope.dadosVenda.valorDescontos) > 0) {
      $scope.desconto.valor = parseFloat($scope.dadosVenda.valorDescontos);
      $scope.calculaPercentualDesconto();
    }
    if ($scope.dadosVenda.formasPagamento.length > 0) {
      angular.forEach($scope.dadosVenda.formasPagamento, function (formaPagamento) {
        $scope.totalPago += formaPagamento.valorPagamento;
      });
      $scope.formaPagamentoCupomSelecionada = $scope.dadosVenda.formasPagamento.length - 1;
      $timeout(function () {
        tabelaFormasPagamento.scrollTop = tabelaFormasPagamento.scrollHeight + 53;
      }, 100);
    }
    if ($scope.dadosVenda.valorTotal != $scope.totalPago) {
      $scope.recalculaPagamento();
    };
  };

  $scope.CancelarFormaPgto = function () {
    $scope.modalCancelarFormaPgto = ModalService.model($scope, 'views/modal_cancelar_formaspagamento/modalCancelarFormaPagamento.html', '', true, true, true);
  };

  $scope.removeFormaSelecionada = function (indice) {
    $timeout(function () {
      swal({
        title: "Remover a Forma de Pagamento?",
        text: "",
        type: "warning",
        showCancelButton: true,
        cancelButtonText: "Não",
        confirmButtonClass: "btn-danger",
        confirmButtonText: "Sim, quero remover",
        closeOnConfirm: true
      },
      function (isConfirm) {
        if (isConfirm){
          $scope.$apply(function () {          
            $scope.modalFormaPagamento.close();
            $scope.dadosVenda.formasPagamento.splice(indice, 1);
            $scope.recalculaPagamento();
          });
        }
      })
    }, 100);
  };

  $scope.calcularPagamento = function () {
    var subtotal  = (!!$scope.dadosVenda.valorTotal)      ? $scope.dadosVenda.valorTotal      : 0;
    var frete     = (!!$scope.dadosVenda.valorFrete)      ? $scope.dadosVenda.valorFrete      : 0;
    var desconto  = (!!$scope.dadosVenda.valorDescontos)  ? $scope.dadosVenda.valorDescontos  : 0;
    var total     = (subtotal + frete) - desconto;

    if ($scope.totalPago > total) {
      if ($scope.dadosVenda.troco === 0) {
        $scope.dadosVenda.troco = $scope.totalPago - total;
      } else {
        $scope.dadosVenda.troco = $scope.totalPago - $scope.dadosVenda.troco;
      }
    }
    else {
      if (!!$scope.dadosVenda.restantePagar) {
        $scope.dadosVenda.restantePagar = $scope.dadosVenda.restantePagar - $scope.formaPagamento.valorPagamento;
      } else {
        $scope.dadosVenda.restantePagar = total - $scope.formaPagamento.valorPagamento;
      }
    }
  };

  $scope.recalculaPagamento = function () {
    var restante          = 0;
    var vlrPago           = 0;
    var vlrDescontoFrete  = 0;
    var vlrSubtotal       = 0;
    var frete    =  (!!$scope.dadosVenda.valorFrete)      ? $scope.dadosVenda.valorFrete      : 0;
    var desconto =  (!!$scope.dadosVenda.valorDescontos)  ? $scope.dadosVenda.valorDescontos  : 0;
    var subtotal =  (!!$scope.dadosVenda.valorTotal)      ? $scope.dadosVenda.valorTotal      : 0;

    var total = (subtotal + frete) - desconto;
    for (var i = 0; i < $scope.dadosVenda.formasPagamento.length; i++) {
      vlrPago += $scope.dadosVenda.formasPagamento[i].valorPagamento;
    }
    vlrDescontoFrete = ($scope.dadosVenda.valorTotal + $scope.dadosVenda.valorFrete) - $scope.dadosVenda.valorDescontos;
    if ($scope.totalPago > total) {
      $scope.dadosVenda.troco = vlrPago - total;
    } else {
      vlrSubtotal = vlrDescontoFrete - vlrPago
      if (vlrSubtotal > 0) {
        $scope.dadosVenda.restantePagar = vlrSubtotal;
      }
    }
    $scope.totalPago = vlrPago;
  };

  $scope.finalizaVenda = function (cpfCnpj) {
    if (!!cpfCnpj) {
      $scope.dadosVenda.cpfCnpj = cpfCnpj;
    };
    if (!!$scope.restantePagar == false) {
      $scope.dadosVenda.dadosCaixa = DadosFormularioService.retornaDados('abertura-caixa').dados;

      angular.forEach($scope.dadosVenda.formasPagamento, function (data) {
        var dadosPagamento = {
          valorPago: data.valorPagamento,
          formaPagamento: data
        }        
        VendaService.aplicarFormaPagamento(JSON.stringify(dadosPagamento));
      });     

      if (VendaService.finalizaVenda(JSON.stringify($scope.dadosVenda.formasPagamento), JSON.stringify($scope.dadosVenda.dadosCaixa), $scope.dadosVenda.cpfCnpj) == true) {
        DadosFormularioService.limparDados('supermercado-pdv');
        $state.go('newpdv.supermercado-pdv');
      };

    } else {
      swal("Ainda existem valores restantes na venda!", "Para adicionar outra forma de pagamento adicione ou altere uma das formas utilizadas.", "warning");
    };
  };

  $scope.cancelarVenda = function () {
      $timeout(function () {
          swal({
              title: "Cancelar a venda?",
              text: "",
              type: "warning",
              showCancelButton: true,
              cancelButtonText: "Não",
              confirmButtonClass: "btn-danger",
              confirmButtonText: "Sim, quero cancelar",
              closeOnConfirm: true
          },
          function (isConfirm) {
              if (isConfirm) {                  
                  DadosFormularioService.limparDados('supermercado-pdv');
                  $scope.dadosVenda = {};
                  $state.go('newpdv.supermercado-pdv');
              }
          })
      }, 100);      
  }

  $scope.voltarItens = function () {
    $state.go('newpdv.supermercado-pdv');
  };
}]);