﻿(function () {
    'use strict';
    newERP.directive('slideToggle', function () {
        return {
            restrict: 'A',
            scope: {
                isOpen: "=slideToggle"
            },
            link: function (scope, element, attr) {
                var slideDuration = parseInt(attr.slideToggleDuration, 0) || 1000;
                if (attr.startShown == "false") {
                    element.hide();
                }
                scope.$watch('isOpen', function (newIsOpenVal, oldIsOpenVal) {
                    if (newIsOpenVal !== oldIsOpenVal) {
                        element.stop().slideToggle(slideDuration);
                    }
                });
            }
        }
    });
})();