﻿newERP.controller('RecebimentoParcelasController', ['$scope', '$filter', '$timeout', 'DadosFormularioService', '$state', 'ModalService', 'FuncaoService', 'hotkeys', function ($scope, $filter, $timeout, DadosFormularioService, $state, ModalService, FuncaoService, hotkeys) {


    $scope.parametrosEmpresa = null;

    $scope.model = {
        monstrarBotaoPagarSelecionadas: false,
        mostrarTelaPagamentoParcela: false,
        mostrarPesquisaCliente: true,
        mostrarPesquisaParcela: false,
        nomeCliente: '',
        senhaGerencial: ''
    };

    $scope.dadosPagamento = {
        dataRecebimento: new Date(),
        parcelas: [],
        cliente: {},
        formaPagamento: {},
        condicaoPagamento: {},
        valorPago: 0,
        valorDesconto: 0,
        valorAReceber: 0,
        valorTotalParcelas: 0,
        valorTotalJuros: 0,
        valorTotalMulta: 0,
    };

    $scope.filtro = {
        codigoBarras: '',
        pesquisa: ''
    };

    $scope.tela = '';

    $scope.mandatory = false;

    var tipoFormaPagamento = {
        fpDinheiro: 1,
        fpCheque: 2,
        fpCartaoCredito: 3,
        fpCartaoDebito: 4,
        fpCreditoLoja: 5,
        fpValeAlimentacao: 10,
        fpValeRefeicao: 11,
        fpValePresente: 12,
        fpValeCombustivel: 13,
        fpDuplicataMercantil: 14,
        fpBoletoBancario: 15,
        fpDepositoBancario: 16,
        fpPixDinamico: 17,
        fpTransferenciaBancaria: 18,
        fpCashback: 19,
        fpPixEstatico: 20,
        fpCreditoEmLoja: 21,
        fpFalhaDeHardware: 22,
        fpSemPagamento: 90,
        fpOutro: 99
    };

    var impressaoComprovantes = {
        Imprimir: 0,
        PerguntarAoUsuario: 1,
        NaoImprimir: 2
    }

    $(document).on('keydown', function (event) {

        if (event.key === 'F5') {
            event.preventDefault();
            $scope.$apply(function () {
                $scope.setarFocus();
            })
        }

        //if (event.key === 'Escape' || event.key === 'Esc' || event.key === 'esc') {
        //    event.preventDefault();
        //    $scope.$apply(function () {
        //        if ($scope.parcelasSelecionadas && $scope.parcelasSelecionadas.length > 0 && $scope.listaClientes && $scope.listaClientes.length > 0) {
        //            $scope.voltarRecebimentoParcela();
        //        }
        //        if ($scope.listaClientes && $scope.listaClientes.length > 0) {
        //            $scope.limparListaClientes();
        //        }
        //        if ($scope.parcelasSelecionadas && $scope.parcelasSelecionadas.length > 0) {
        //            //$scope.cancelarRecebimentos();
        //            $scope.voltarPesquisaParcela();
        //        }
        //        if ($scope.retornaDados && $scope.retornaDados.length > 0) {
        //            $scope.voltarPesquisaParcela();
        //        }
        //        else {
        //            //$scope.model.close();
        //            $scope.close();
        //        }
        //    })
        //}
    });

    $scope.setarFocus = function () {
        $timeout(function () {
            var elementoCodigoBarras = window.document.getElementById('pesquisaNomeCliente');
            if (!!elementoCodigoBarras) elementoCodigoBarras.focus();
        }, 100);
    };

    var caixaAberto = JSON.parse(controleCaixaAppService.listaControleCaixaAberto());
    if (!(!!caixaAberto)) {
        $scope.modalAberturaCaixa = ModalService.model($scope, 'views/pdv/controle_caixa/modalAberturaCaixa.html', 'lg', true, 'static', true);
    }

    $scope.lerDados = function () {
        $scope.dadosPagamento = DadosFormularioService.retornaDados('parcelasAPagar', {}).dados;
        $scope.dadosPagamento.valorTotalAPagar = 0;
        $scope.dadosPagamento.valorTotalParcelas = 0;
        $scope.dadosPagamento.valorTotalJuros = 0;
        $scope.dadosPagamento.valorTotalMulta = 0;
        $scope.listarFormaPagamento();
        $scope.parametrosEmpresa = parametrosEmpresaAppService.retornaDadosParametrosEmpresa();
        $scope.dadosPagamento.dataRecebimento = (!!$scope.dadosPagamento.dataRecebimento) ? $scope.dadosPagamento.dataRecebimento : new Date();
        $scope.calcularTotais();

        $timeout(function () {
            var elementoCodigoBarras = window.document.getElementById('pesquisaCodigoBarras');
            if (!!elementoCodigoBarras) elementoCodigoBarras.focus();
            $scope.mandatory = !$scope.dadosPagamento.condicaoPagamento > 0;
        });
    };

    $scope.zerarJuros = function () {
        var retorno = localAppService.possuiSenhaGerencial();
        if (retorno == true) {
            $scope.tela = 1;
            $scope.modalSenhaGerencial = ModalService.model($scope, 'views/pdv/varejo/modalSenhaGerencial.html', 'sm', true, 'static', true);
        }
    };

    $scope.zerarMulta = function () {
        var retorno = localAppService.possuiSenhaGerencial();
        if (retorno == true) {
            $scope.tela = 3;
            $scope.modalSenhaGerencial = ModalService.model($scope, 'views/pdv/varejo/modalSenhaGerencial.html', 'sm', true, 'static', true);
        }
    };

    $scope.validaSenhaGerencial = function (senha) {
        var senhaValida = localAppService.validarSenhaGerencial(senha);
        if (senhaValida == true) {
            if ($scope.tela == 1) {
                angular.forEach($scope.dadosPagamento.parcelas, function (parcela) {
                    parcela.prc_valor = parseFloat((parcela.prc_valor - parcela.valorJuros).toFixed(2));
                    parcela.valorPago = parcela.prc_valor;
                    $scope.dadosPagamento.valorTotalAPagar -= parcela.valorJuros;
                    parcela.valorJuros = 0;
                });
                $scope.calcularTotais();
                $scope.fecharModalSenhaGerencial();
            }
            if ($scope.tela == 3) {
                angular.forEach($scope.dadosPagamento.parcelas, function (parcela) {
                    parcela.prc_valor = parseFloat((parcela.prc_valor - parcela.valorMulta).toFixed(2));
                    parcela.valorPago = parcela.prc_valor;
                    $scope.dadosPagamento.valorTotalAPagar -= parcela.valorMulta;
                    parcela.valorMulta = 0;
                });
                $scope.calcularTotais();
                $scope.fecharModalSenhaGerencial();
            }

            if ($scope.tela != 3 && $scope.tela != 1) {
                $scope.parc.$edit = !$scope.parc.$edit;
                $scope.fecharModalSenhaGerencial();
            }

        } else {
            $scope.model.senhaGerencial = '';
            swal("Senha incorreta!", "", "warning");
        }
    };

    $scope.alterarParcela = function (parcela, indice) {
        $scope.tela = 2;
        $scope.parc = parcela;
        $scope.idx = indice;
        $scope.modalSenhaGerencial = ModalService.model($scope, 'views/pdv/varejo/modalSenhaGerencial.html', 'sm', true, 'static', true);
    };

    $scope.confirmarAlteracaoParcela = function (parcela, indice) {
        parcela.valorJuros = (!!parcela.valorJuros == false) ? 0 : parcela.valorJuros;
        parcela.valorMulta = (!!parcela.valorMulta == false) ? 0 : parcela.valorMulta;
        parcela.valorDesconto = (!!parcela.valorDesconto == false) ? 0 : parcela.valorDesconto;

        parcela.$edit = !parcela.$edit;
        $scope.calcularTotais();
    };


    $scope.fecharModalSenhaGerencial = function () {
        $scope.model.senhaGerencial = '';
        $scope.modalSenhaGerencial.close();
    }
    $scope.recalcularValorParcela = function (indice) {
        if ($scope.dadosPagamento.parcelas[indice].valorDesconto > $scope.dadosPagamento.parcelas[indice].valorOriginal) {
            $scope.dadosPagamento.parcelas[indice].valorDesconto = $scope.dadosPagamento.parcelas[indice].valorOriginal;
        }
        var valorParcela = parseFloat(($scope.dadosPagamento.parcelas[indice].valorOriginal) - $scope.dadosPagamento.parcelas[indice].valorQuitado);
        $scope.dadosPagamento.parcelas[indice].prc_valor = parseFloat(((valorParcela + $scope.dadosPagamento.parcelas[indice].valorJuros + $scope.dadosPagamento.parcelas[indice].valorMulta) - $scope.dadosPagamento.parcelas[indice].valorDesconto).toFixed(2));
        $scope.dadosPagamento.parcelas[indice].valorPago = $scope.dadosPagamento.parcelas[indice].prc_valor;
    };
    $scope.calcularTotais = function () {
        $scope.dadosPagamento.valorTotalAPagar = 0;
        $scope.dadosPagamento.valorTotalParcelas = 0;
        $scope.dadosPagamento.valorTotalJuros = 0;
        $scope.dadosPagamento.valorTotalMulta = 0;
        $scope.dadosPagamento.valorDesconto = 0;
        $scope.dadosPagamento.valorPago = 0;
        angular.forEach($scope.dadosPagamento.parcelas, function (parcela) {
            $scope.dadosPagamento.valorTotalParcelas += parcela.valorOriginal;
            $scope.dadosPagamento.valorTotalJuros += parcela.valorJuros;
            $scope.dadosPagamento.valorTotalMulta += parcela.valorMulta;
            $scope.dadosPagamento.valorDesconto += parcela.valorDesconto;
            $scope.dadosPagamento.valorTotalAPagar += parcela.prc_valor;
            $scope.dadosPagamento.valorPago += parcela.valorPago;
        });
    };
    $scope.alterarValorRecebido = function () {
        var diferenca = $scope.dadosPagamento.valorTotalAPagar - $scope.dadosPagamento.valorPago;
        if (diferenca > 0) {
            for (var i = $scope.dadosPagamento.parcelas.length - 1; i >= 0; i--) {
                if (diferenca > 0) {
                    if ($scope.dadosPagamento.parcelas[i].prc_valor >= diferenca) {
                        $scope.dadosPagamento.parcelas[i].valorPago = parseFloat(($scope.dadosPagamento.parcelas[i].prc_valor - diferenca).toFixed(2));
                        diferenca -= diferenca;
                    } else {
                        $scope.dadosPagamento.parcelas[i].valorPago = parseFloat(($scope.dadosPagamento.parcelas[i].prc_valor - $scope.dadosPagamento.parcelas[i].prc_valor).toFixed(2));
                        diferenca -= $scope.dadosPagamento.parcelas[i].prc_valor;
                    }
                } else if (diferenca == 0) {
                    $scope.dadosPagamento.parcelas[i].valorPago = $scope.dadosPagamento.parcelas[i].prc_valor;
                }
            }
        } else {
            for (var i = $scope.dadosPagamento.parcelas.length - 1; i >= 0; i--) {
                $scope.dadosPagamento.parcelas[i].valorPago = $scope.dadosPagamento.parcelas[i].prc_valor;
            }
        }
    };
    $scope.recalcularValorPago = function (parcela) {
        if (parcela.valorPago > parcela.prc_valor) {
            parcela.valorPago = parcela.prc_valor
        }
        $scope.dadosPagamento.valorPago = 0;
        angular.forEach($scope.dadosPagamento.parcelas, function (parcela) {
            $scope.dadosPagamento.valorPago += parcela.valorPago;
        });
    };
    $scope.lerDadosParcelas = function () {
        $scope.dadosPagamento = DadosFormularioService.retornaDados('parcelasAPagar', {}).dados;
        if (!!$scope.dadosPagamento.cliente) {
            $scope.listarParcelas($scope.dadosPagamento.cliente);
            $timeout(function () {
                $scope.model.monstrarBotaoPagarSelecionadas = true;
                $scope.model.mostrarPesquisaCliente = false;
                $scope.model.mostrarPesquisaParcela = true;
                $scope.model.mostrarTelaPagamentoParcela = false;
                $scope.model.selecionartodos = false;
                $scope.model.selecionartodosVencidos = false;
            }, 100);
        } else {
            // Buscar novos clientes
            clienteAppService.buscarNovosClientesApi();
            //console.log("teste", clienteAppService);
        }
    };

    $scope.buscarParcelaPorCodigoBarras = function (codigoBarras) {
        if (!!codigoBarras) {
            $scope.dadosPagamento.parcelas = (!!$scope.dadosPagamento.parcelas) ? $scope.dadosPagamento.parcelas : [];
            var parcelaJaAdicionada = $filter('filter')($scope.dadosPagamento.parcelas, { prc_codigobarras: codigoBarras });
            if (parcelaJaAdicionada.length > 0) {
                $timeout(function () {
                    if (!(!!parcelaJaAdicionada[0].pagar)) {
                        parcelaJaAdicionada[0].pagar = true;
                        $scope.dadosPagamento.valorTotalAPagar += parcelaJaAdicionada[0].prc_valor;
                    }
                    swal("A parcela já esta adicionada na lista para pagamento!", "", "warning");
                }, 100)
            } else {
                var retornoParcela = JSON.parse(parcelaAppService.buscarParcelaPorCodigoBarras(codigoBarras));
                if (!!retornoParcela) {
                    if (retornoParcela.prc_status != 2 && retornoParcela.prc_estornado == 0) {
                        if ($scope.dadosPagamento.parcelas.length == 0) {
                            $scope.dadosPagamento.cliente = { pes_id: retornoParcela.pes_id, pes_nome: retornoParcela.pes_nome, cli_id: retornoParcela.cli_id, Id: retornoParcela.ClienteId, pef_cpf: retornoParcela.pef_cpf, pej_cnpj: retornoParcela.pej_cnpj }
                        }
                        if ($scope.dadosPagamento.cliente.pes_id == retornoParcela.pes_id) {
                            retornoParcela.vencida = FuncaoService.compararDatas(retornoParcela.prc_datavencimento);
                            retornoParcela.numeroDiasVencida = 0;
                            retornoParcela.valorJuros = 0;
                            retornoParcela.valorMulta = 0;
                            if (retornoParcela.vencida == true) {
                                retornoParcela.numeroDiasVencida = FuncaoService.diferencaDatas(retornoParcela.prc_datavencimento, new Date());
                                if ($scope.parametrosEmpresa.par_diastoleranciacobrancajuro == null) {
                                    var valorReceber = parseFloat((retornoParcela.prc_valor - retornoParcela.valorQuitado).toFixed(2));
                                    retornoParcela.valorJuros = parseFloat((((valorReceber * ($scope.parametrosEmpresa.par_percjuromesparcelavencida / 30)) / 100) * retornoParcela.numeroDiasVencida).toFixed(2));
                                } else if (retornoParcela.numeroDiasVencida > $scope.parametrosEmpresa.par_diastoleranciacobrancajuro) {
                                    var valorReceber = parseFloat((retornoParcela.prc_valor - retornoParcela.valorQuitado).toFixed(2));
                                    retornoParcela.valorJuros = parseFloat((((valorReceber * ($scope.parametrosEmpresa.par_percjuromesparcelavencida / 30)) / 100) * retornoParcela.numeroDiasVencida).toFixed(2));

                                    if ($scope.parametrosEmpresa.par_tipocalculomulta == 1) {
                                        retornoParcela.valorMulta = parseFloat((!!$scope.parametrosEmpresa.par_multaparcelavencida ? $scope.parametrosEmpresa.par_multaparcelavencida : 0).toFixed(2));
                                    }
                                    if ($scope.parametrosEmpresa.par_tipocalculomulta == 2 && $scope.parametrosEmpresa.par_multaparcelavencida > 0 && $scope.parametrosEmpresa.par_multaparcelavencida != null) {
                                        retornoParcela.valorMulta = parseFloat(((retornoParcela.prc_valor * $scope.parametrosEmpresa.par_multaparcelavencida) / 100).toFixed(2));
                                    }
                                }
                            }
                            retornoParcela.valorDesconto = 0;
                            retornoParcela.valorOriginal = retornoParcela.prc_valor;
                            retornoParcela.valorQuitado = retornoParcela.valorQuitado;
                            retornoParcela.prc_valor = parseFloat(((retornoParcela.prc_valor - retornoParcela.valorQuitado) + retornoParcela.valorJuros + retornoParcela.valorMulta).toFixed(2));
                            retornoParcela.valorPago = retornoParcela.prc_valor;
                            retornoParcela.pagar = true;

                            $scope.dadosPagamento.valorTotalAPagar += retornoParcela.prc_valor;
                            $scope.dadosPagamento.valorTotalJuros += retornoParcela.valorJuros;
                            $scope.dadosPagamento.valorTotalMulta += retornoParcela.valorMulta;
                            $scope.dadosPagamento.valorTotalParcelas += parseFloat((retornoParcela.valorOriginal - retornoParcela.valorQuitado).toFixed(2));
                            $scope.dadosPagamento.valorPago = $scope.dadosPagamento.valorTotalAPagar;
                            $scope.dadosPagamento.parcelas.push(retornoParcela);
                            DadosFormularioService.armazenarDados('parcelasAPagar', $scope.dadosPagamento);
                        } else {
                            $timeout(function () {
                                swal("Parcela não é do cliente " + $scope.dadosPagamento.cliente.pes_nome + "!", "", "warning");
                            }, 200);
                        }
                    } else {
                        if (retornoParcela.prc_status == 2) {
                            $timeout(function () {
                                swal("Esta Parcela já foi totalmente liquidada!", "", "warning");
                            }, 200);
                        }
                        if (retornoParcela.prc_estornado == 1) {
                            $timeout(function () {
                                swal("A Parcela foi estornada!", "", "warning");
                            }, 200);
                        }
                    }
                } else {
                    $timeout(function () {
                        swal("Parcela não encontrada!", "", "warning");
                    }, 200);
                }
            }
            $scope.filtro.codigoBarras = '';
        } else {
            swal("Você deve informar o codigo de barras do carnê.", "", "warning");
        }
    };

    $scope.recalcularValorTotalPagar = function (parcela) {
        if (!!parcela.pagar) $scope.dadosPagamento.valorTotalAPagar += parcela.prc_valor;
        if (!(!!parcela.pagar)) $scope.dadosPagamento.valorTotalAPagar -= parcela.prc_valor;
        //$scope.dadosPagamento.valorTotal = $scope.dadosPagamento.valorTotalAPagar;
    };

    $scope.recalcularValores = function () {
        $scope.dadosPagamento.valorTotalJuros = (!!$scope.dadosPagamento.valorTotalJuros == false) ? 0 : $scope.dadosPagamento.valorTotalJuros;
        $scope.dadosPagamento.valorTotalMulta = (!!$scope.dadosPagamento.valorTotalMulta == false) ? 0 : $scope.dadosPagamento.valorTotalMulta;
        $scope.dadosPagamento.valorDesconto = (!!$scope.dadosPagamento.valorDesconto == false) ? 0 : $scope.dadosPagamento.valorDesconto;
        $scope.dadosPagamento.valorPago = parseFloat(($scope.dadosPagamento.valorTotalParcelas + $scope.dadosPagamento.valorTotalJuros + $scope.dadosPagamento.valorTotalMulta - $scope.dadosPagamento.valorDesconto).toFixed(2));
        //  $scope.dadosPagamento.valorTotal = $scope.dadosPagamento.valorTotalParcelas + $scope.dadosPagamento.valorTotalJuros - $scope.dadosPagamento.valorDesconto;
    };

    $scope.voltarRecebimentoParcela = function (permanecerMesmaRota) {
        if (!!permanecerMesmaRota) {
            $scope.model.mostrarTelaPagamentoParcela = false;
        } else {
            $state.go('newpdv.recebimento-parcelas');
        }
    };
    $scope.voltarPesquisaParcela = function () {
        $state.go('newpdv.localizar-parcelas');
        $scope.dadosPagamento = DadosFormularioService.retornaDados('parcelasAPagar', {}).dados;
        $scope.model.mostrarPesquisaParcela = true;
        $scope.listarParcelas($scope.dadosPagamento.cliente);
        $scope.monstrarBotaoPagarSelecionadas = true;
        $scope.mostrarPesquisaCliente = false;
        $scope.mostrarPesquisaParcela = true;
        $scope.mostrarTelaPagamentoParcela = false;
        $scope.selecionartodos = false;
        $scope.selecionartodosVencidos = false;
    };

    $scope.listarClientes = function (filtro) {
        $scope.listaClientes = [];
        if (!!filtro && filtro.length > 3)
            $scope.listaClientes = JSON.parse(parcelaAppService.listarClientesParcelas(filtro));
    };

    $scope.limparListaClientes = function () {
        $scope.filtro.pesquisa = '';
        $scope.listaClientes = [];
        $scope.limparListaParcelas();
    };

    $scope.listarParcelas = function (cliente) {
        $scope.totalParcelasReceber = 0;
        $scope.modalAguardaProcesso = ModalService.model($scope, 'views/pdv/varejo/modalAguardaProcesso.html', 'md', true, 'static', true);
        $timeout(function () {
            $scope.lerDados();
            $scope.dadosPagamento.cliente = cliente;
            if (!!cliente) {
                var listaContaPagarReceber = JSON.parse(parcelaAppService.listarParcelas((cliente.Id).toString()));
                $scope.listaParcelasEmAberto = [];
                if (listaContaPagarReceber.length > 0) {
                    angular.forEach(listaContaPagarReceber, function (contaPagarReceber) {
                        contaPagarReceber.vencida = FuncaoService.compararDatasParcela(contaPagarReceber.prc_datavencimento);
                        contaPagarReceber.numeroDiasVencida = 0;
                        contaPagarReceber.valorJuros = 0;
                        contaPagarReceber.valorMulta = 0;
                        if (contaPagarReceber.vencida == true) {
                            contaPagarReceber.numeroDiasVencida = FuncaoService.diferencaDatas(contaPagarReceber.prc_datavencimento, new Date());
                            if ($scope.parametrosEmpresa.par_diastoleranciacobrancajuro == null) {
                                var valorReceber = parseFloat((contaPagarReceber.prc_valor - contaPagarReceber.valorQuitado).toFixed(2));
                                contaPagarReceber.valorJuros = parseFloat((((valorReceber * ($scope.parametrosEmpresa.par_percjuromesparcelavencida / 30)) / 100) * contaPagarReceber.numeroDiasVencida).toFixed(2));
                            } else if (contaPagarReceber.numeroDiasVencida > $scope.parametrosEmpresa.par_diastoleranciacobrancajuro) {
                                var valorReceber = parseFloat((contaPagarReceber.prc_valor - contaPagarReceber.valorQuitado).toFixed(2));
                                contaPagarReceber.valorJuros = parseFloat((((valorReceber * ($scope.parametrosEmpresa.par_percjuromesparcelavencida / 30)) / 100) * contaPagarReceber.numeroDiasVencida).toFixed(2));

                                if ($scope.parametrosEmpresa.par_tipocalculomulta == 1) {
                                    contaPagarReceber.valorMulta = parseFloat((!!$scope.parametrosEmpresa.par_multaparcelavencida ? $scope.parametrosEmpresa.par_multaparcelavencida : 0).toFixed(2));
                                }
                                if ($scope.parametrosEmpresa.par_tipocalculomulta == 2 && $scope.parametrosEmpresa.par_multaparcelavencida > 0 && $scope.parametrosEmpresa.par_multaparcelavencida != null) {
                                    contaPagarReceber.valorMulta = parseFloat(((contaPagarReceber.prc_valor * $scope.parametrosEmpresa.par_multaparcelavencida) / 100).toFixed(2));
                                }
                            }
                        }
                        contaPagarReceber.pagar = false;
                        contaPagarReceber.valorDesconto = 0;
                        contaPagarReceber.valorOriginal = contaPagarReceber.prc_valor;
                        contaPagarReceber.valorQuitado = contaPagarReceber.valorQuitado;
                        contaPagarReceber.prc_valor = parseFloat(((contaPagarReceber.prc_valor - contaPagarReceber.valorQuitado) + contaPagarReceber.valorJuros + contaPagarReceber.valorMulta).toFixed(2));
                        contaPagarReceber.valorPago = contaPagarReceber.prc_valor;

                        $scope.totalParcelasReceber += contaPagarReceber.prc_valor;

                        var parcelaJaAdicionada = $filter('filter')($scope.dadosPagamento.parcelas, { parcelaId: contaPagarReceber.parcelaId });
                        if (!!parcelaJaAdicionada)
                            contaPagarReceber.pagar = (parcelaJaAdicionada.length > 0) ? (!!parcelaJaAdicionada[0].pagar) : false;
                    });
                    $scope.listaParcelasEmAberto = listaContaPagarReceber;
                    $scope.monstrarBotaoPagarSelecionadas();
                    DadosFormularioService.armazenarDados('parcelasAPagar', $scope.dadosPagamento);
                } else {
                    swal("Cliente selecionado não possui parcelas em aberto!", "", "warning");
                }

            } else {
                $scope.limparListaParcelas();
                swal("Você deve informar algum filtro para pesquisar.", "", "warning");
            }
            $scope.modalAguardaProcesso.close();
        }, 500);
    };

    $scope.adicionarListaParcelasAPagar = function () {
        $scope.lerDados();
        $scope.dadosPagamento.parcelas = [];
        var listaParcelasSelecionadas = $filter('filter')($scope.listaParcelasEmAberto, { pagar: true });
        angular.forEach(listaParcelasSelecionadas, function (parcela) {
            var parcelaJaAdicionada = $filter('filter')($scope.dadosPagamento.parcelas, { parcelaId: parcela.parcelaId });
            if (parcelaJaAdicionada.length == 0) {
                $scope.dadosPagamento.valorTotalAPagar += parcela.prc_valor;
                parcela.cpr_numeroparcelas = parcela.cpr_numeroparcelas;
                parcela.cpr_numerodocumento = parcela.cpr_numerodocumento;
                parcela.ContaPagarReceberId = parcela.ContaPagarReceberId;
                parcela.notaFiscalId = parcela.notaFiscalId;
                parcela.ntf_id = parcela.ntf_id;
                $scope.dadosPagamento.parcelas.push(parcela);
            }
        });
        $scope.voltarRecebimentoParcela();
    };
    $scope.selecionarTodos = function () {
        if ($scope.model.selecionartodos == true) {
            angular.forEach($scope.listaParcelasEmAberto, function (parcela) {
                parcela.pagar = true;
            });
        } else {
            angular.forEach($scope.listaParcelasEmAberto, function (parcela) {
                parcela.pagar = false;
            });
        };
        $scope.calcularTotalizador();
    };
    $scope.selecionarTodosVencidos = function () {
        if ($scope.model.selecionartodosVencidos == true) {
            var listaParcelasSelecionadas = $filter('filter')($scope.listaParcelasEmAberto, { vencida: true });
            angular.forEach(listaParcelasSelecionadas, function (parcela) {
                parcela.pagar = true;
            });
        } else {
            var listaParcelasSelecionadas = $filter('filter')($scope.listaParcelasEmAberto, { vencida: true });
            angular.forEach(listaParcelasSelecionadas, function (parcela) {
                parcela.pagar = false;
            });
        };
        $scope.calcularTotalizador();
    };
    $scope.cancelarRecebimentos = function () {
        $scope.model.selecionartodos = false;
        $scope.model.selecionartodosVencidos = false;
        $scope.model.mostrarTelaPagamentoParcela = false;
        $scope.dadosPagamento = {
            cliente: {},
            parcelas: [],
            formaPagamento: {},
            condicaoPagamento: {},
            dataRecebimento: new Date(),
            valorPago: 0,
            valorDesconto: 0,
            valorTotal: 0,
            valorTotalAPagar: 0,
            valorTotalParcelas: 0,
            valorTotalJuros: 0,
            valorTotalMulta: 0,
            integrapgtook: false,
            integrapgto: null
        };
        DadosFormularioService.limparDados('parcelasAPagar');
        DadosFormularioService.limparDados('dadosCheque');
        $timeout(function () {
            window.document.getElementById('pesquisaCodigoBarras').focus();
        }, 100);
    };

    $scope.adicionarParcelaAPagar = function (parcela) {
        $scope.lerDados();
        $scope.dadosPagamento.parcelas = (!!$scope.dadosPagamento.parcelas) ? $scope.dadosPagamento.parcelas : [];
        var parcelaJaAdicionada = $filter('filter')($scope.dadosPagamento.parcelas, { prc_id: parcela.prc_id });
        if (parcelaJaAdicionada.length == 0) {
            $scope.dadosPagamento.valorTotalAPagar += parcela.prc_valor;
            $scope.dadosPagamento.valorTotalJuros += parcela.valorJuros;
            $scope.dadosPagamento.valorTotalMulta += parcela.valorMulta;
            $scope.dadosPagamento.valorTotalParcelas += parseFloat((parcela.valorOriginal - parcela.valorQuitado).toFixed(2));
            parcela.pagar = true;
            $scope.dadosPagamento.parcelas.push(parcela);
        } else {
            if (!(!!parcelaJaAdicionada[0].pagar)) {
                $scope.dadosPagamento.valorTotalAPagar += parcelaJaAdicionada[0].prc_valor;
                $scope.dadosPagamento.valorTotalJuros += parcela.valorJuros;
                $scope.dadosPagamento.valorTotalMulta += parcela.valorMulta;
                $scope.dadosPagamento.valorTotalParcelas += parseFloat((parcela.valorOriginal - parcela.valorQuitado).toFixed(2));
                parcelaJaAdicionada[0].pagar = true;
            }
        }
        $scope.voltarRecebimentoParcela();
    };

    $scope.removerParcela = function (parcela, posicao) {
        var valorParcela = FuncaoService.retornaMoney(parcela.prc_valor);
        swal({
            title: "Remover da lista a parcela Nº " + parcela.prc_numeroparcela + " no valor de R$" + valorParcela + "?",
            text: "",
            type: "warning",
            showCancelButton: true,
            cancelButtonText: "Não",
            confirmButtonClass: "btn-danger",
            confirmButtonText: "Sim, quero remover",
            closeOnConfirm: true
        },
            function (acao) {
                if (!!acao) {
                    if (!!parcela.pagar)
                        $scope.dadosPagamento.valorTotalAPagar -= parcela.prc_valor;
                    $scope.dadosPagamento.valorTotalParcelas -= parseFloat((parcela.valorOriginal - parcela.valorQuitado).toFixed(2));
                    $scope.dadosPagamento.valorTotalJuros -= parcela.valorJuros;
                    $scope.dadosPagamento.valorTotalMulta -= parcela.valorMulta;
                    $scope.dadosPagamento.parcelas.splice(posicao, 1);
                    $scope.$apply();
                }
            });
    };

    $scope.monstrarBotaoPagarSelecionadas = function () {
        var parcelasSelecionadas = $filter('filter')($scope.listaParcelasEmAberto, { pagar: true });
        $scope.model.monstrarBotaoPagarSelecionadas = false;
        if (parcelasSelecionadas.length > 0) {
            $scope.model.monstrarBotaoPagarSelecionadas = true;
        }
    };

    $scope.limparListaParcelas = function () {
        $scope.filtro.pesquisa = '';
        $scope.listaParcelasEmAberto = [];
    };

    $scope.listarFormaPagamento = function () {
        $scope.listaFormaPagamento = [];
        $scope.listaFormaPagamento = JSON.parse(formaPagamentoAppService.listaFormaPagamentoRecebimentoParcela());
        if (!!$scope.dadosPagamento.formaPagamento) {
            $scope.listarCondicaoPagamento();
        } else {
            if ($scope.listaFormaPagamento.length == 1) {
                $scope.dadosPagamento.formaPagamento = $scope.listaFormaPagamento[0];
                $scope.listarCondicaoPagamento();
            }
        }
    };

    // $scope.mandatory = false;
    $scope.listarCondicaoPagamento = function () {
        $scope.listaCondicaoPagamento = [];
        $scope.listaCondicaoPagamento = JSON.parse(condicaoPagamentoAppService.listaCondicaoRelacionada($scope.dadosPagamento.formaPagamento.fpg_id));
        if ($scope.listaCondicaoPagamento.length == 1) {
            $scope.dadosPagamento.condicaoPagamento = $scope.listaCondicaoPagamento[0];
            $scope.mandatory = false;
        } else {
            $scope.mandatory = ($scope.dadosPagamento.formaPagamento.fpg_tipopagamento != 1 && $scope.dadosPagamento.formaPagamento.fpg_tipopagamento != 2 && $scope.dadosPagamento.formaPagamento.fpg_tipopagamento != 12);
        }
    };

    $scope.selectedCodicaoPagamento = function () {
        $scope.mandatory = !$scope.dadosPagamento.condicaoPagamento > 0;
    }

    $scope.verificaIntegracaoPagamentos = function (dadosPagamento, index) {
        if (dadosPagamento.formaPagamento.fpg_tipointegracao == 2) {//payer
            var _paymentType = "";
            var _paymentMethodSubType = "";
            var _installments = "";
            var _paymentMethod = "";
            if (dadosPagamento.formaPagamento.fpg_tipopagamento == tipoFormaPagamento.fpCartaoCredito) {
                _paymentMethod = "Card";
                _paymentType = "Credit";
                _paymentMethodSubType = "Financed_no_Fees";
                if (dadosPagamento.recebimentoCartao.length == 1) {
                    _paymentMethodSubType = "Full_Payment";
                } else {
                    _installments = (dadosPagamento.recebimentoCartao.length).toString();
                }
            }
            if ($scope.dadosPagamento.formaPagamento.fpg_tipopagamento == tipoFormaPagamento.fpCartaoDebito) {
                if (dadosPagamento.recebimentoCartao.length >= 1) {
                    if (dadosPagamento.recebimentoCartao.length == 1) {
                        _paymentMethodSubType = "Predated_Debit";
                    } else {
                        _paymentMethodSubType = "Financed_Debit";
                    }
                    _installments = (dadosPagamento.recebimentoCartao.length).toString();
                } else {
                    _paymentMethodSubType = "Full_Payment";
                }
                _paymentMethod = "Card";
                _paymentType = "Debit"
            }
            if (dadosPagamento.formaPagamento.fpg_tipopagamento == tipoFormaPagamento.fpPixDinamico) {
                _paymentType = "Cash";
                _paymentMethod = "Pix";
            }
            var dados = {
                value: dadosPagamento.valorPago,
                paymentMethod: _paymentMethod,
                paymentType: _paymentType,
                paymentMethodSubType: _paymentMethodSubType,
                installments: _installments
            };
            try {
                var retornoPayer = payerPagamentoAppService.efetuarPagamento(JSON.stringify(dados));
                console.log(retornoPayer);
                openModalPagamento(dadosPagamento, index);
            } catch (e) {
                console.log(e);
                $scope.desabilitar = false;
                swal("Verifique se o checkout Payer esteja iniciado, caso contrário inicie o mesmo para continuar!", "", "warning");
            }
        } else if (dadosPagamento.formaPagamento.fpg_tipointegracao == 1) {//vero
            var tipopgto = 0;
            var metodopgto = 0;
            var submetodopgto = 0;

            if (dadosPagamento.formaPagamento.fpg_tipopagamento === tipoFormaPagamento.fpCartaoCredito) {
                tipopgto = 2;
                metodopgto = 1;
                submetodopgto = 4;
                if (dadosPagamento.parcelas.length == 1) {
                    submetodopgto = 1
                }
            }
            if (dadosPagamento.formaPagamento.fpg_tipopagamento === tipoFormaPagamento.fpCartaoDebito) {
                tipopgto = 3;
                metodopgto = 1;
                submetodopgto = 1;
                if (dadosPagamento.parcelas.length >= 1) {
                    submetodopgto = 3
                }
            }
            if (dadosPagamento.formaPagamento.fpg_tipopagamento === tipoFormaPagamento.fpPixDinamico) {
                tipopgto = 1;
                metodopgto = 3;
                submetodopgto = 1
            }
            dadosIntegracaoPos = {
                imp_valor: dadosPagamento.valorPago,
                imp_tipopgto: tipopgto,
                imp_metodopgto: metodopgto,
                imp_submetodopgto: submetodopgto,
                imp_qtdeparcelas: dadosPagamento.parcelas.length,
            }
            if (dadosPagamento.hasOwnProperty("integrapgto") == false) {
                dadosPagamento.integrapgtook = false;
                dadosPagamento.integrapgto = integraPagtoAppService.incluir(JSON.stringify(dadosIntegracaoPos));
            }
            else if (dadosPagamento.integrapgto == null) {
                dadosPagamento.integrapgtook = false;
                dadosPagamento.integrapgto = integraPagtoAppService.incluir(JSON.stringify(dadosIntegracaoPos));
            }
            dadosPagamento.id = dadosPagamento.integrapgto.id;
            openModalPagamento(dadosPagamento, index);
        }
        else if (dadosPagamento.formaPagamento.fpg_tipointegracao == 3) {//TEF
            var tipopgto = 0;
            var metodopgto = 0;
            var submetodopgto = 0;

            if (dadosPagamento.formaPagamento.fpg_tipopagamento === tipoFormaPagamento.fpCartaoCredito) {
                tipopgto = 2;
                metodopgto = 1;
                submetodopgto = 4;
                if (dadosPagamento.parcelas.length == 1) {
                    submetodopgto = 1
                }
            }
            if (dadosPagamento.formaPagamento.fpg_tipopagamento === tipoFormaPagamento.fpCartaoDebito) {
                tipopgto = 3;
                metodopgto = 1;
                submetodopgto = 1;
                if (dadosPagamento.parcelas.length >= 1) {
                    submetodopgto = 3
                }
            }
            if (dadosPagamento.formaPagamento.fpg_tipopagamento === tipoFormaPagamento.fpPixDinamico) {
                tipopgto = 1;
                metodopgto = 3;
                submetodopgto = 1
            }
            dadosTef = {
                imp_valor: dadosPagamento.valorPago,
                imp_tipopgto: tipopgto,
                imp_metodopgto: metodopgto,
                imp_submetodopgto: submetodopgto,
                imp_qtdeparcelas: dadosPagamento.parcelas.length,
            }
            try {
                var retornoTef = tefAppService.realizarRecebimentoParcelaTransacaoTef(dadosPagamento.formaPagamento.fpg_codigofuncaotef, dadosPagamento.valorPago.toFixed(2));
                console.log("Retorno TEF", retornoTef);
                if (retornoTef) {
                    if (retornoTef.statusTransacao == 1)// se status pendente de confirmação
                    {
                        dadosPagamento.integrapgto = integraPagtoAppService.incluirDadosTef(JSON.stringify(retornoTef), JSON.stringify(dadosTef));
                        $scope.dadosPagamento.integrapgtook = true;
                        $scope.efetuarPagamento();
                    } else {
                        if (retornoTef.retInt < 0) {
                            if (retornoTef.retInt == -1) {
                                swal("Módulo não inicializado!", "Cód. Retorno -1", "warning");
                            }
                            else if (retornoTef.retInt == -2) {
                                swal("Operação cancelada pelo Operador!", "Cód. Retorno -2", "warning");
                            }
                            else if (retornoTef.retInt == -5) {
                                swal(" comunicação com o SiTef!", "Cód. Retorno -5", "warning");
                            }
                            else if (retornoTef.retInt == -6) {
                                swal("Operação cancelada pelo usuário (no pinpad)!", "Cód. Retorno -6", "warning");
                            }
                            else if (retornoTef.retInt == -22) {
                                swal("Carteira Digital não habilitada!", "Cód. Retorno -22", "warning");
                            }
                            else if (retornoTef.retInt == -24) {
                                swal("Carteira Digital - Trn. nao habilitada!", "Cód. Retorno -24", "warning");
                            }
                            else if (retornoTef.retInt == -43) {
                                swal("Problema na execução de alguma das rotinas no pinpad!", "Cód. Retorno -43", "warning");
                            }
                            else if (retornoTef.retInt == -100) {
                                swal("Erro interno do módulo!", "Cód. Retorno -100", "warning");
                            }
                            else {
                                swal("Não Foi possível  concluir transação TEF!", "Cód.Retorno" + retornoTef.retInt, "warning");
                            }
                        } else {
                            swal("Não Foi possível  concluir transação TEF!", "Cód.Retorno" + retornoTef.retInt, "warning");
                        }
                    }
                } else {
                    swal("Não Foi possível  concluir transação TEF!", "Cód. Retorno " + retornoTef.retInt, "warning");
                }
            } catch (e) {
                console.log(e);
                swal("Não Foi possível chamar as funções TEF!", "Sem Retorno", "warning");
            }
        }
    };
    function openModalPagamento(dadosPagamento, index) {
        swal({
            title: "Aguardando Pagamento Via Integração!",
            text: "Verifique no Checkout Payer",
            type: "warning",
            showCancelButton: true,
            cancelButtonText: "Cancelar",
            confirmButtonClass: "btn-info",
            confirmButtonText: "Verificar Novamente",
            closeOnConfirm: true
        }, function (isConfirm) {
            if (isConfirm) {
                $scope.verificaPagamento(dadosPagamento, index);
            }
            else {
                $scope.desabilitar = false;
            }
        });
    }
    $scope.verificaPagamento = function (dadosPagamento, index) {
        if (dadosPagamento.formaPagamento.fpg_tipointegracao == 2) {//payer
            try {
                var ret = payerPagamentoAppService.consultarPagamento();
                $timeout(function () {
                    if (ret.statusTransaction == "PENDING") {
                        openModalPagamento(dadosPagamento, index);
                    } else if (ret.operationType == "PAYMENT" && ret.statusTransaction == "APPROVED") {
                        $scope.dadosPagamento.integrapgtook = true;
                        $scope.dadosPagamento.integrapgto = ret;
                        $scope.efetuarPagamento();
                    } else {
                        if (ret && ret.statusTransaction) {
                            var titulo = 'Problema na transação';
                            var mensagemPadrao = '';
                            var rejectionCode = '';
                            var rejectionMessage = '';

                            if (ret.rejectionInfo && typeof ret.rejectionInfo === 'object') {
                                rejectionCode = ret.rejectionInfo.rejectionCode || '';
                                rejectionMessage = ret.rejectionInfo.rejectionMessage || '';
                            }

                            switch (ret.statusTransaction) {
                                case "UNAUTHORIZED":
                                    mensagemPadrao = 'A transação não foi autorizada.';
                                    break;
                                case "REJECTED":
                                    mensagemPadrao = 'A transação foi rejeitada.';
                                    break;
                                case "ABORTED":
                                    mensagemPadrao = 'A transação foi abortada.';
                                    break;
                                case "CANCELLED":
                                    mensagemPadrao = 'A transação foi cancelada.';
                                    break;
                                default:
                                    mensagemPadrao = 'Houve uma falha na transação.';
                                    break;
                            }

                            var corpoMensagem = mensagemPadrao;

                            if (rejectionMessage) {
                                corpoMensagem += '\n\nCódigo: ' + rejectionCode + '\nDetalhes: ' + rejectionMessage;
                            }

                            corpoMensagem += '\n\nSe preferir, troque a forma de pagamento ou tente novamente.';

                            swal(titulo, corpoMensagem, "warning");
                        }
                    }
                }, 1000)
                console.log("Retorno " + ret.statusTransaction, ret);
            } catch (e) {
                $scope.desabilitar = false;
                console.log(e);
                swal("Certifique-se que o checkout Payer esteja iniciado, caso contrário inicie o mesmo para continuar!", "Atenção", "warning");
            }
        }
        else if (dadosPagamento.formaPagamento.fpg_tipointegracao == 1) { // Vero
            var ret = integraPagtoAppService.consultaPagamento(dadosPagamento.integrapgto.id);
            console.log(ret)
            $timeout(function () {
                if (ret == null) {
                    swal("Atenção", "Não foi possível consultar dados do pagamento, API encontra-se instável  no momento . Tente Novamente dentro de alguns instantes!!", "warning");
                }
                if (ret.imp_statuspgto == 3) {
                    openModalPagamento(dadosPagamento, index);
                } else if (ret.imp_statuspgto == 1) {
                    $scope.dadosPagamento.integrapgtook = true;
                    $scope.dadosPagamento.integrapgto = ret;
                    $scope.efetuarPagamento();
                } else if (ret.statusTransaction == 7) {
                    $scope.verificarFormaPagamentoSelecionada();
                    swal("Pagamento não autorizado!", "", "warning");
                }
                else if (ret.statusTransaction == 5) {
                    $scope.verificarFormaPagamentoSelecionada();
                    swal("Pagamento não abortado!", "", "warning");
                }
            }, 1000)
        }
    };

    function gerarParcelasCartaoIntegrado() {
        var definicaoParcelamento = [];
        var parcelas = [];
        $scope.dadosPagamento.recebimentoCartao = [];
        if (!!$scope.dadosPagamento.condicaoPagamento == true && !!$scope.dadosPagamento.condicaoPagamento.cpg_id == true) definicaoParcelamento = JSON.parse(condicaoPagamentoAppService.listaParcelasCondicao($scope.dadosPagamento.condicaoPagamento.cpg_id));
        var somaParcelas = 0;
        var resto = 0;
        if (definicaoParcelamento.length > 0) {
            angular.forEach(definicaoParcelamento, function (parcela, indice) {
                var dataAtual = new Date();
                var numeroDias = parseInt(parcela.pcl_numerodias);
                var dataVencimentoParcela = new Date(dataAtual.setDate(dataAtual.getDate() + numeroDias));
                valorParcela = ((parcela.pcl_percparcela / 100) * ($scope.dadosPagamento.valorPago)).toFixed(2);
                parcelas.push({
                    prc_numeroparcela: indice + 1,
                    prc_valor: parseFloat(valorParcela),
                    prc_datavencimento: dataVencimentoParcela
                });
                somaParcelas += parseFloat(valorParcela);
                somaParcelas = parseFloat(somaParcelas);
            });
            resto = ($scope.dadosPagamento.valorPago - somaParcelas).toFixed(2);
            resto = parseFloat(resto);
        } else {
            var dataAtual = new Date();
            var numeroDias = parseInt(1);
            var dataVencimentoParcela = new Date(dataAtual.setDate(dataAtual.getDate() + numeroDias));
            parcelas.push({
                prc_numeroparcela: 1,
                prc_valor: parseFloat($scope.dadosPagamento.valorPago),
                prc_datavencimento: dataVencimentoParcela
            });
        }

        if (resto != 0) {
            var numeroUltimaParcela = 0;
            if (definicaoParcelamento.length > 0) {
                numeroUltimaParcela = definicaoParcelamento.length - 1;
            } else {
                numeroUltimaParcela = 1;
            }
            var valParcela = parseFloat(parcelas[numeroUltimaParcela].prc_valor);
            var totalParcela = parseFloat((valParcela + resto).toFixed(2));
            totalParcela = parseFloat(totalParcela);
            parcelas[numeroUltimaParcela].prc_valor = parseFloat(totalParcela);
        }

        angular.forEach(parcelas, function (parcela) {
            $scope.dadosPagamento.recebimentoCartao.push({
                tipoParcelamento: tipoParcelamentoCartao.estabelecimento,
                bce_id: null,
                rcc_parcelarecebimento: parcela.prc_numeroparcela,
                rcc_valor: parcela.prc_valor,
                rcc_nsu: null,
                rcc_previsaorecebimento: parcela.prc_datavencimento
            });
        })
    }


    $scope.desabilitar = false;
    $scope.verificarFormaPagamentoSelecionada = function () {
        var possuiParcelaEmEdicao = false;
        angular.forEach($scope.dadosPagamento.parcelas, function (parcela) {
            if (parcela.$edit == true) {
                possuiParcelaEmEdicao = true;
            }
        })
        if (possuiParcelaEmEdicao == true) {
            swal("Você possui parcelas em Edição, Verifique! ", "", "warning");
        } else {
            if (!!$scope.dadosPagamento.formaPagamento.fpg_tipopagamento) {
                switch ($scope.dadosPagamento.formaPagamento.fpg_tipopagamento) {
                    case tipoFormaPagamento.fpDinheiro:
                        $scope.desabilitar = true;
                        $timeout(function () {
                            $scope.efetuarPagamento();
                        }, 100)
                        break;
                    case tipoFormaPagamento.fpCheque:
                        $scope.desabilitar = true;
                        $scope.lancamentoCheque($scope.dadosPagamento.numeroCheques, $scope.dadosPagamento.valorPago);
                        break;
                    case tipoFormaPagamento.fpCartaoDebito:
                        if ($scope.dadosPagamento.formaPagamento.fpg_tipointegracao != null) {
                            gerarParcelasCartaoIntegrado();
                            $scope.dadosPagamento.integrapgtook = false;
                            $scope.verificaIntegracaoPagamentos($scope.dadosPagamento);
                        } else {
                            abrirEscolhaBandeiraCartao(tipoFormaPagamento.fpCartaoDebito);
                        }
                        $scope.desabilitar = true;
                        break;
                    case tipoFormaPagamento.fpCartaoCredito:
                        if ($scope.dadosPagamento.formaPagamento.fpg_tipointegracao != null) {
                            gerarParcelasCartaoIntegrado();
                            $scope.dadosPagamento.integrapgtook = false;
                            $scope.verificaIntegracaoPagamentos($scope.dadosPagamento);
                        } else {

                            abrirEscolhaBandeiraCartao(tipoFormaPagamento.fpCartaoCredito);
                        }
                        $scope.desabilitar = true;
                        break;
                    case tipoFormaPagamento.fpPixDinamico:
                    case tipoFormaPagamento.fpPixEstatico:
                        if ($scope.dadosPagamento.formaPagamento.fpg_tipointegracao != null) {
                            $scope.dadosPagamento.integrapgtook = false;
                            $scope.verificaIntegracaoPagamentos($scope.dadosPagamento);
                        } else {
                            $timeout(function () {
                                $scope.efetuarPagamento();
                            }, 100)
                        }
                        $scope.desabilitar = true;
                        break;
                    case tipoFormaPagamento.fpTransferenciaBancaria:
                    case tipoFormaPagamento.fpDepositoBancario:
                        $timeout(function () {
                            $scope.efetuarPagamento();
                        }, 100)
                        $scope.desabilitar = true;
                        break;
                    default:
                        console.log("verificarFormaPagamentoSelecionada não encontrado tipFormaPagamento... ")
                        $timeout(function () {
                            $scope.efetuarPagamento();
                        }, 100)
                        $scope.desabilitar = true;
                        break;
                }
            }
        }
    };

    var tipoParcelamentoCartao = {
        estabelecimento: 0,
        comprador: 1
    };

    var abrirEscolhaBandeiraCartao = function (tipoPagamento) {
        var definicaoParcelamento = [];
        var parcelas = [];

        if (!!$scope.dadosPagamento.condicaoPagamento == true && !!$scope.dadosPagamento.condicaoPagamento.cpg_id == true) definicaoParcelamento = JSON.parse(condicaoPagamentoAppService.listaParcelasCondicao($scope.dadosPagamento.condicaoPagamento.cpg_id));
        var somaParcelas = 0;
        var resto = 0;
        if (definicaoParcelamento.length > 0) {
            angular.forEach(definicaoParcelamento, function (parcela, indice) {
                var valorParcela = 0;
                valorParcela = ((parcela.pcl_percparcela / 100) * ($scope.dadosPagamento.valorPago)).toFixed(2);
                parcelas.push({
                    prc_numeroparcela: indice + 1,
                    prc_valor: parseFloat(valorParcela),
                });
                somaParcelas += parseFloat(valorParcela);
                somaParcelas = parseFloat(somaParcelas);
            });
            resto = ($scope.dadosPagamento.valorPago - somaParcelas).toFixed(2);
            resto = parseFloat(resto);
        }

        if (resto != 0) {
            var numeroUltimaParcela = 0;
            if (definicaoParcelamento.length > 0) {
                numeroUltimaParcela = definicaoParcelamento.length - 1;
            } else {
                numeroUltimaParcela = 1;
            }
            var valParcela = parseFloat(parcelas[numeroUltimaParcela].prc_valor);
            var totalParcela = (valParcela + resto).toFixed(2);
            totalParcela = parseFloat(totalParcela);
            parcelas[numeroUltimaParcela].prc_valor = parseFloat(totalParcela);
        }

        $scope.dadosPagamento.recebimentoCartao = [];
        $scope.modalBandeirasCartao = ModalService.abrir('views/pdv/modalBandeiraCartao.html', 'lg', true, 'static', true, 'ModalBandeiraCartaoController', { 'tipoPagamento': tipoPagamento });
        $scope.modalBandeirasCartao.result.then(function (retornoDadosBandeiraCartao) {
            if (!!retornoDadosBandeiraCartao == false) {
                $timeout(function () {
                    $scope.desabilitar = false;
                    $scope.dadosPagamento.condicaoPagamento = null;
                    $scope.listarCondicaoPagamento();
                }, 100)
            } else {
                var dadosBandeiraCartaoEmpresa = JSON.parse(bandeiraCartaoEmpresaAppService.retornaDadosBandeiraCartaoEmpresa(retornoDadosBandeiraCartao.bandeira.bce_id));
                var dataAtual = new Date();
                if (!!retornoDadosBandeiraCartao.cartaoCredito) {
                    $scope.dadosPagamento.recebimentoCartao = [];
                    if (retornoDadosBandeiraCartao.tipoParcelamento == tipoParcelamentoCartao.estabelecimento) {
                        var numeroDias = parseInt(dadosBandeiraCartaoEmpresa.bce_nrodiasrecebimentocredito);
                        angular.forEach(parcelas, function (parcela) {
                            $scope.dadosPagamento.recebimentoCartao.push({
                                tipoParcelamento: tipoParcelamentoCartao.estabelecimento,
                                bce_id: retornoDadosBandeiraCartao.bandeira.bce_id,
                                rcc_parcelarecebimento: parcela.prc_numeroparcela,
                                rcc_valor: parcela.prc_valor,
                                rcc_nsu: retornoDadosBandeiraCartao.nsu,
                                rcc_previsaorecebimento: new Date(dataAtual.setDate(dataAtual.getDate() + numeroDias))
                            });
                        })
                    } else {
                        dataAtual = new Date();
                        $scope.dadosPagamento.recebimentoCartao.push({
                            tipoParcelamento: tipoParcelamentoCartao.comprador,
                            bce_id: retornoDadosBandeiraCartao.bandeira.bce_id,
                            rcc_parcelarecebimento: 1,
                            rcc_valor: $scope.dadosPagamento.valorPago,
                            rcc_nsu: retornoDadosBandeiraCartao.nsu,
                            rcc_previsaorecebimento: new Date(dataAtual.setDate(dataAtual.getDate() + parseInt(dadosBandeiraCartaoEmpresa.bce_nrodiasrecebimentocredito)))
                        });
                    }
                } else {
                    dataAtual = new Date();
                    $scope.dadosPagamento.recebimentoCartao.push({
                        tipoParcelamento: null,
                        bce_id: retornoDadosBandeiraCartao.bandeira.bce_id,
                        rcc_parcelarecebimento: 1,
                        rcc_valor: $scope.dadosPagamento.valorPago,
                        rcc_nsu: retornoDadosBandeiraCartao.nsu,
                        rcc_previsaorecebimento: new Date(dataAtual.setDate(dataAtual.getDate() + parseInt(dadosBandeiraCartaoEmpresa.bce_nrodiasrecebimentodebito)))
                    });
                }

                $scope.efetuarPagamento();
            }
        });
    };

    $scope.efetuarPagamento = function () {
        console.log("efetuarPagamento", $scope.dadosPagamento, $scope.dadosPagamento.condicaoPagamento);
        if ($scope.dadosPagamento.formaPagamento.fpg_tipointegracao != null && $scope.dadosPagamento.integrapgtook == false) {
            $scope.verificaIntegracaoPagamentos($scope.dadosPagamento);
        } else {
            $scope.parametrosEmpresa = parametrosEmpresaAppService.retornaDadosParametrosEmpresa();
            ConfirmaImpressaoComprovantes();
        }
    };

    function ConfirmaImpressaoComprovantes() {
        // chama o imprimir
        if ($scope.parametrosEmpresa == null || $scope.parametrosEmpresa.par_impressaocarne == null) {
            $scope.dadosPagamento.imprimirComprovantes = true;
            FinalizarPagamento();
        } else {
            if ($scope.parametrosEmpresa.par_impressaocarne == impressaoComprovantes.Imprimir) {
                $scope.dadosPagamento.imprimirComprovantes = true;
                FinalizarPagamento();
            } else if ($scope.parametrosEmpresa.par_impressaocarne == impressaoComprovantes.PerguntarAoUsuario) {
                swal({
                    title: "Deseja realizar a impressão do comprovante do recebimento desta parcela?",
                    text: "Imprimir Comprovante?",
                    type: "warning",
                    showCancelButton: true,
                    cancelButtonText: "Sim",
                    cancelButtonClass: "btn-success",
                    confirmButtonText: "Não",
                    confirmButtonClass: "btn-default",
                }, function (isConfirm) {
                    if (isConfirm) {
                        $timeout(function () {
                            $scope.dadosPagamento.imprimirComprovantes = false;
                            swal.close(); // Fecha o swal manualmente
                            FinalizarPagamento();
                        });
                    } else {
                        $timeout(function () {
                            $scope.dadosPagamento.imprimirComprovantes = true;
                            swal.close(); // Fecha o swal manualmente
                            FinalizarPagamento();
                        });
                    }
                });
            } else {
                $scope.dadosPagamento.imprimirComprovantes = false;
                FinalizarPagamento();
            }
        }
        //$timeout(function () {

        //}, 100);
    }

    function FinalizarPagamento() {
        console.log("FinalizarPagamento");
        $scope.dadosPagamento.condicaoPagamento = !(!!!$scope.dadosPagamento.condicaoPagamento) ? $scope.dadosPagamento.condicaoPagamento : {};
        var ret = parcelaAppService.confirmarRecebimentoParcela($scope.dadosPagamento)
        console.log(ret);
        $timeout(function () {
            if (!!ret) {
                swal({
                    title: "Parcela(s) liquidada(s) com sucesso!",
                    text: "Deseja continuar na tela com parcelas do cliente ou realizar uma nova pesquisa?",
                    type: "success",
                    showCancelButton: true,
                    cancelButtonText: "Continuar",
                    confirmButtonClass: "btn-danger",
                    confirmButtonText: "Nova Pesquisa"
                }, function (acao) {
                    if (acao) {
                        $scope.model.mostrarTelaPagamentoParcela = false;
                        $scope.dadosPagamento = {
                            cliente: {},
                            parcelas: [],
                            formaPagamento: {},
                            condicaoPagamento: {},
                            valorPago: 0,
                            valorDesconto: 0,
                            valorTotalJuros: 0,
                            valorTotalMulta: 0,
                            valorTotalAPagar: 0,
                            cheques: [],
                            recebimentoCartao: [],
                            integrapgtook: false,
                            integrapgto: null
                        };
                        DadosFormularioService.limparDados('parcelasAPagar');
                        DadosFormularioService.limparDados('dadosCheque');
                        $timeout(function () {
                            window.document.getElementById('pesquisaCodigoBarras').focus();
                        }, 100);
                    } else {
                        $timeout(function () {
                            $scope.dadosPagamento.parcelas = [];
                            $scope.dadosPagamento.recebimentoCartao = [];
                            $scope.dadosPagamento.formaPagamento = {};
                            $scope.dadosPagamento.condicaoPagamento = {};
                            $scope.dadosPagamento.integrapgtook = false;
                            $scope.dadosPagamento.integrapgto = null;
                            $state.go('newpdv.localizar-parcelas');
                            $scope.listarParcelas($scope.dadosPagamento.cliente);
                            $scope.calcularTotalizador();
                        }, 50);
                    }
                });

            } else {
                var mensagemErroRecebimentoParcela = "Tivemos um contratempo no recebimento da parcela.";
                if ($scope.dadosPagamento.parcelas.length < 1) mensagemErroRecebimentoParcela = "Tivemos um contratempo no recebimento das parcelas.";
                swal({
                    title: mensagemErroRecebimentoParcela,
                    text: "Por favor pesquise novamente!",
                    type: "error",
                    confirmButtonClass: "btn-danger",
                    confirmButtonText: "OK"
                }, function (acao) {
                    $scope.dadosPagamento.parcelas = [];
                    $scope.dadosPagamento.recebimentoCartao = [];
                    $scope.dadosPagamento.formaPagamento = {};
                    $scope.dadosPagamento.condicaoPagamento = {};
                    $scope.dadosPagamento.integrapgtook = false;
                    $scope.dadosPagamento.integrapgto = null;
                    $state.go('newpdv.localizar-parcelas');
                    $scope.listarParcelas($scope.dadosPagamento.cliente);
                    $scope.calcularTotalizador();
                }, 100);
            }
        }, 100);
    }

    $scope.lancamentoCheque = function (quantidadeCheques, valorTotalCheques) {
        $timeout(function () {
            $scope.dadosPagamento.cheques = [];
            valorTotalCheques = $scope.dadosPagamento.valorPago;
            if (quantidadeCheques === 0) quantidadeCheques = 1;
            $scope.modalCheque = ModalService.abrir('views/pdv/cheques/modalCheques.html', 'lg', true, 'static', true, 'ModalChequeController', { 'quantidadeCheques': quantidadeCheques, 'valorTotal': valorTotalCheques, 'cli_id': $scope.dadosPagamento.cliente.Id });
            $scope.modalCheque.result.then(function (dadosCheques) {
                if (!!dadosCheques) {
                    var cheques = [];
                    angular.forEach(dadosCheques, function (cheque) {
                        cheques.push({
                            ban_id: cheque.ban_id,
                            chq_codigocompensacao: cheque.chq_codigocompensacao,
                            cli_id: cheque.cli_id,
                            pes_id: cheque.pes_id,
                            chq_agencia: cheque.chq_agencia,
                            chq_c1: cheque.chq_c1,
                            chq_contacorrente: cheque.chq_contacorrente,
                            chq_c2: cheque.chq_c2,
                            chq_serie: cheque.chq_serie,
                            chq_numero: cheque.chq_numero,
                            chq_c3: cheque.chq_c3,
                            chq_valor: cheque.chq_valor,
                            linha1: cheque.linha1,
                            ban_descricao: cheque.ban_descricao,
                            chq_cmc7: cheque.chq_cmc7,
                            chq_dataemissao: cheque.chq_dataemissao,
                            chq_bompara: cheque.chq_bompara,
                            chq_emissorclientedesde: cheque.chq_emissorclientedesde,
                            chq_nomeemissor: cheque.chq_nomeemissor,
                            chq_cpfcnpjemissor: cheque.chq_cpfcnpjemissor,
                            chq_telefoneemissor: cheque.chq_telefoneemissor,
                            chq_observacao: cheque.chq_observacao,
                            ClienteId: cheque.ClienteId
                        });
                    })
                    $scope.dadosPagamento.cheques = cheques;
                    $scope.efetuarPagamento();
                } else {
                    $scope.desabilitar = false;
                }
            });
        }, 100);
    };

    $scope.abrirDetalhesDaNota = function (contaPagarReceber) {
        //Atualiza o id da nota na tabela de contapagarreceber
        var idNota = 0;
        idNota = contaPagarReceber.notaFiscalId;
        if (contaPagarReceber.notaFiscalId == null) {
            idNota = JSON.parse(contaPagarReceberAppService.atualizaIdNotaContaPagarReceber(contaPagarReceber.Id, contaPagarReceber.cpr_id));
        }

        $scope.modalDetalhesNotaFiscal = ModalService.abrir('views/pdv/varejo/modalDetalhesVenda.html', 'lg', true, 'static', true, 'ModalDetalhesVendaController', { 'idNota': idNota });
    };

    $scope.quantidadeParcelasSelecionadas = 0;
    $scope.totalParcelasSelecionadas = 0;
    $scope.totalValorOriginal = 0;
    $scope.totalJuros = 0;
    $scope.totalMulta = 0;
    $scope.calcularTotalizador = function () {
        $scope.totalJuros = 0;
        $scope.totalMulta = 0;
        $scope.totalParcelasSelecionadas = 0;
        $scope.quantidadeParcelasSelecionadas = 0;
        $scope.totalValorOriginal = 0;
        var parcelasSelecionadas = $filter('filter')($scope.listaParcelasEmAberto, { pagar: true });
        angular.forEach(parcelasSelecionadas, function (item) {
            $scope.totalValorOriginal += item.valorOriginal;
            $scope.totalJuros += item.valorJuros
            $scope.totalMulta += item.valorMulta
            $scope.quantidadeParcelasSelecionadas++;
            $scope.totalParcelasSelecionadas += item.prc_valor;
        });
    };

}]);