newERP.controller('EtiquetaController', ['$scope', 'ModalService', 'ValidarFormularioService', '$timeout', '$state', 'DadosFormularioService', 'FuncaoService', function ($scope, ModalService, ValidarFormularioService, $timeout, $state, DadosFormularioService, FuncaoService) {

    $scope.filtro = {
        pesquisa: '',
        pesquisaAvancada: false,
        quantidade: 1
    };

    $scope.dadosEtiqueta = {
        met_descricao: null,
        met_comando: null,
        met_imagem: null,
        met_colunas: null,
        met_quantidadecaracteresdescricaoproduto: 15
    };

    $scope.ListaProdutos = [];
    $scope.modeloSelecionado = {};
    $scope.impressoraSelecionada = {};
    $scope.editorEtiqueta = false;
    $scope.isLinguagemPPLA = false;
    $scope.isLinguagemHTML = false;
    $scope.isImportarModelo = false;

    $scope.ListaProdutosSelecionados = [];

    $scope.abrirGerarEtiquetas = function () {
        $state.go('newpdv.gerar-etiqueta');
    };

    $scope.listarListaDePreco = function () {
        $scope.ListaDePreco = JSON.parse(listaPrecoAppService.listarTodas());
        /* SELECIONA A PRINCIPAL COMO PADRO */
        angular.forEach($scope.ListaDePreco, function (registro) {
            if (registro.ltp_principal) {
                $scope.filtro.listaPreco = registro;
            }
        });
        $scope.ListaProdutos = JSON.parse(produtoAppService.buscaProdutosListaDePrecoSemPaginacao($scope.filtro.listaPreco.ltp_id));
    }

    $scope.ListarModelosDeEtiqueta = function () {
        $scope.ListaModelos = JSON.parse(etiquetaAppService.listarTodos($scope.filtro.pesquisa));
    };

    $scope.IniciarDados = function () {
        $scope.listarListaDePreco();
        var listaArmazenada = DadosFormularioService.retornaDados('produtos-impressao-etiqueta', {}).dados;
        if (listaArmazenada.length > 0) {
            $scope.ListaProdutosSelecionados = listaArmazenada;
        }
    };

    $scope.IniciarDadosEditorEtiqueta = function () {
        $scope.dadosEtiqueta = DadosFormularioService.retornaDados('editor-etiqueta', {}).dados;
        $scope.isImportarModelo = DadosFormularioService.retornaDados('editor-etiqueta-importar', {}).dados;

        //importa
        if ($scope.isImportarModelo === true) {
            if (!!$scope.dadosEtiqueta) {
                $scope.editorEtiqueta = false;
                $scope.isImportarModelo = true;
                $scope.dadosEtiqueta.textAreaEditorEtiqueta = $scope.dadosEtiqueta.met_comando;
            };
        } else {
            if (!!$scope.dadosEtiqueta.Id) { // alterar                
                $scope.dadosEtiqueta.textAreaEditorEtiqueta = $scope.dadosEtiqueta.met_comando;
            } else { // inserir
                $scope.isImportarModelo = false;
                $scope.dadosEtiqueta.met_colunas = null;
                $scope.dadosEtiqueta.met_quantidadecaracteresdescricaoproduto = 15;
            }
        }
    };

    $scope.IniciarDadosListaModelos = function () {
        $scope.ListarModelosDeEtiqueta();
    };

    $scope.CriarEtiqueta = function (impressoraSelecionada) {
        $timeout(function () {
            if (impressoraSelecionada.imp_linguagem === "PPLA") {
                $scope.isLinguagemPPLA = true;
            } else if (impressoraSelecionada.imp_linguagem === "HTML") {
                $scope.isLinguagemHTML = true;
            } else {
                $timeout(function () {
                    $scope.editorEtiqueta = true;
                }, 400)
                $timeout(function () {
                    $scope.isLinguagemPPLA = false;
                    $scope.isLinguagemHTML = false;
                    $scope.isImportarModelo = false;
                    $scope.CriarEditor('editorEtiqueta', impressoraSelecionada.imp_larguraetiqueta, impressoraSelecionada.imp_alturaetiqueta, impressoraSelecionada.imp_dpi);
                }, 500)
            }
        }, 500);
    };

    $scope.alterarModeloEtiqueta = function (modelo) {
        $scope.dadosEtiqueta = DadosFormularioService.armazenarDados('editor-etiqueta', modelo);
        $state.go('newpdv.editor-etiqueta');
    }

    $scope.abrirModalSelecaoModelo = function () {
        if ($scope.ListaProdutosSelecionados.length > 0) {
            $scope.ListarModelosDeEtiqueta()
            $scope.modalSelecaoModelo = ModalService.model($scope, 'views/pdv/varejo/etiqueta/modalSelecaoModelo.html', 'md', true, true, true);
        } else {
            swal("Nenhum Produto foi selecionado!", "", "warning");
        }
    };

    $scope.ListarImpressoras = function () {
        $scope.ListaImpressoras = JSON.parse(impressoraAppService.listarTodas());
    }

    $scope.AbrirModalImpressora = function () {
        $scope.ListarImpressoras();
        $scope.modalSelecaoModelo.close();
        $scope.modalImpressoras = ModalService.model($scope, 'views/pdv/varejo/modalImpressora.html', 'md', true, true, true);
    }

    $scope.voltarListaModelos = function () {
        DadosFormularioService.limparDados('editor-etiqueta');
        $state.go('newpdv.modelo-etiqueta');
    }
    $scope.desabilitar = false;
    $scope.ImprimirEtiqueta = function () {
        if (!!$scope.impressoraSelecionada) {
            if (!!$scope.modeloSelecionado) {
                $scope.desabilitar = true;
                //VERIFICAR SE POSSUI INFORMAES ADICIONAIS                
                var informacaoAdicional = "";
                if ($scope.dadosEtiqueta.informacaoAdicional) {
                    if ($scope.dadosEtiqueta.possuiEntrada) {
                        informacaoAdicional = $scope.dadosEtiqueta.quantidadeParcelas + "x(1+" + ($scope.dadosEtiqueta.quantidadeParcelas - 1) + ")";
                    } else {
                        informacaoAdicional = $scope.dadosEtiqueta.quantidadeParcelas + "x";
                    }
                }

                var dadosImpressao = {
                    codigoImpressora: $scope.impressoraSelecionada.Id,
                    codigoModeloEtiqueta: $scope.modeloSelecionado.Id,
                    informacaoAdicional: informacaoAdicional,
                    quantidadeParcelas: !!$scope.dadosEtiqueta.quantidadeParcelas ? $scope.dadosEtiqueta.quantidadeParcelas : 0,
                    possuiEntrada: $scope.dadosEtiqueta.possuiEntrada,
                    impressoraCompartilhada: $scope.dadosEtiqueta.impressoraCompartilhada,
                    dadosProduto: []
                };

                angular.forEach($scope.ListaProdutosSelecionados, function (item) {
                    var dadosProduto = {
                        codigoProduto: item.codigoProduto,
                        //codigoBarras: item.codigoBarras,
                        precoProduto: FuncaoService.retornaMoney(item.precoProduto),
                        descricaoProduto: item.descricaoProduto,
                        gradeProduto: item.gradeProduto,
                        numeroCopias: item.numeroCopias
                    };

                    if ($scope.dadosEtiqueta.conf_barcode === 'codigoProduto') {
                        dadosProduto.codigoBarras = item.codigoProduto;
                    } else if ($scope.dadosEtiqueta.conf_barcode === 'codigoEtiqueta') {
                        dadosProduto.codigoBarras = item.pro_codigoetiqueta;
                    } else {
                        dadosProduto.codigoBarras = item.codigoBarras;
                    }
                    dadosImpressao.dadosProduto.push(dadosProduto);
                });
                console.log('Dados Impresso: ', dadosImpressao);
                $scope.modalImpressoras.close();
                etiquetaAppService.imprimirEtiqueta(JSON.stringify(dadosImpressao));
            } else {
                $scope.desabilitar = false;
            }
        } else {
            $scope.desabilitar = false;
        }
    };

    $scope.buscarGradeOuPreco = function (dadosProduto) {
        $scope.dadosProduto = {
            pro_codigo: dadosProduto.pro_id,
            pro_descricao: dadosProduto.pro_descricao,
            pro_codigoetiqueta: dadosProduto.pro_codigoetiqueta
        }
        $scope.listaGrades = JSON.parse(produtoAppService.listaGradesProduto(dadosProduto.pro_id));
        $timeout(function () {
            if ($scope.listaGrades.length > 0) {
                $scope.modalGradesVendas = ModalService.model($scope, 'views/pdv/varejo/modalProdutosGradesEtiqueta.html', 'lg', true, true, true);
                jaAbriuModalGradeProduto = true;

                angular.forEach($scope.listaGrades, function (itemGrade) {
                    var retornoEstoque = JSON.parse(estoqueAppService.buscarEstoqueProdutoUnicoApi(dadosProduto.pro_id, itemGrade.prg_id));
                    itemGrade.estoqueAtual = retornoEstoque.valorTotal;
                });
            } else {
                var retornoListaPreco = JSON.parse(produtoAppService.listaPrecoProduto(dadosProduto.pro_id, null, null, null));
                angular.forEach(retornoListaPreco, function (item) {
                    if ($scope.filtro.listaPreco.ltp_id === item.ltp_id) {
                        $scope.filtro.produto.lpi_valorvenda = item.lpi_valorvenda;
                    }
                });

                var retornoEstoque = JSON.parse(estoqueAppService.buscarEstoqueProdutoUnicoApi(dadosProduto.pro_id, null));
                $scope.filtro.estoqueAtual = retornoEstoque.valorTotal;
            };
        }, 500);
    }

    $scope.selecionarGrades = function () {
        var informouGrade = false;
        var dadosProduto = $scope.filtro.produto;
        angular.forEach($scope.listaGrades, function (item) {
            if (item.prg_quantidade > 0) {
                informouGrade = true;
                dadosProduto.grade_valorunitario = item.valorVenda;
                dadosProduto.grade_qtde = item.prg_quantidade;
                dadosProduto.prg_id = item.prg_id;
                dadosProduto.grade_ean = item.ean;
                dadosProduto.grade = "";
                for (var i = 0; i < item.atributos.length; i++) {
                    if (item.atributos[i].mgp_imprimenaetiqueta === true) {
                        var descricaoGrade = item.atributos[i].mgp_descricao;
                        dadosProduto.grade += descricaoGrade;//.slice(0, 5); usar caso ficar muito grande a descricao da grade
                        if (i < item.atributos.length - 1) {
                            dadosProduto.grade += "/"
                        }
                    }
                }

                $scope.dadosProduto = dadosProduto;
                $scope.adicionarProdutoNaImpressao();
            }
        });

        if (!!$scope.modalGradesVendas) {
            $timeout(function () {
                if (!!informouGrade) {
                    $scope.modalGradesVendas.close();
                    jaAbriuModalGradeProduto = false;
                } else {
                    swal("Informe a quantidade em pelo menos um item da grade!", "", "warning");
                }
            }, 100)
        }

        $scope.filtro.produto = null;
    };

    $scope.manutencaoQuantidadeModalGrades = function (posicao, operacao) {
        if (operacao == "+") {
            if ($scope.listaGrades[posicao].valorVenda > 0) {
                $scope.listaGrades[posicao].prg_quantidade += 1;
            } else {
                swal("No sera possivel adicionar o item, pois o valor no foi informado!", "", "warning");
            }
        } else if (operacao == "-") {
            if ($scope.listaGrades[posicao].prg_quantidade == 0) {
                $scope.listaGrades[posicao].prg_quantidade = 0;
            } else {
                $scope.listaGrades[posicao].prg_quantidade -= 1;
            }
        }
    };

    $scope.removerProdutoDaImpressao = function (index) {
        swal({
            title: 'Deseja Remover o Produto da Impressao!',
            text: "",
            type: "warning",
            confirmButtonClass: "btn-danger",
            confirmButtonText: "Sim, quero excluir",
            closeOnConfirm: true,
            cancelButtonText: "NAO",
            showCancelButton: true
        }, function (acao) {
            if (acao) {
                $timeout(function () {
                    $scope.ListaProdutosSelecionados.splice(index, 1);
                    DadosFormularioService.armazenarDados('produtos-impressao-etiqueta', $scope.ListaProdutosSelecionados);
                }, 500)
            }
        });
    };

    $scope.adicionarProdutoNaImpressao = function () {
        if (!$scope.filtro.listaPreco) {
            swal("Selecione uma lista de Preo!", "", "warning");
            return;
        };

        // SE NENHUM PRODUTO FOR SELECIONADO ADICIONA TODOS
        if (!$scope.filtro.produto) {
            $scope.adicionarTodosProdutosNaImpressao();
        } else { // ADICIONA O PRODUTO SELECIONADO NO FILTRO
            var dadosImpressao = {};
            dadosImpressao.codigoReferencia = $scope.filtro.produto.pro_referencia;
            dadosImpressao.codigoProduto = $scope.filtro.produto.pro_codigo;
            dadosImpressao.descricaoProduto = $scope.dadosProduto.pro_descricao;
            dadosImpressao.gradeProduto = (!!$scope.dadosProduto.grade) ? $scope.dadosProduto.grade : null;
            dadosImpressao.precoProduto = (!!$scope.dadosProduto.grade_valorunitario) ? $scope.dadosProduto.grade_valorunitario : $scope.filtro.produto.lpi_valorvenda;
            dadosImpressao.numeroCopias = (!!$scope.dadosProduto.grade_qtde) ? $scope.dadosProduto.grade_qtde : $scope.filtro.quantidade;
            dadosImpressao.codigoBarras = (!!$scope.dadosProduto.grade_ean) ? $scope.dadosProduto.grade_ean : $scope.filtro.produto.pro_ean;
            dadosImpressao.pro_codigoetiqueta = $scope.filtro.produto.pro_codigoetiqueta;

            if (!!$scope.dadosProduto.grade_qtde) {
                for (var i = 0; i < $scope.dadosProduto.grade_qtde; i++) {
                    $scope.ListaProdutosSelecionados.push(dadosImpressao);
                }
            } else {
                for (var i = 0; i < $scope.filtro.quantidade; i++) {
                    $scope.ListaProdutosSelecionados.push(dadosImpressao);
                }
                $scope.filtro.produto = null;
            }
        }
        DadosFormularioService.armazenarDados('produtos-impressao-etiqueta', $scope.ListaProdutosSelecionados);
    };

    $scope.removerProdutosDaImpressao = function () {
        swal({
            title: "Deseja Remover TODOS os Produtos da Impressao!",
            text: "",
            type: "warning",
            confirmButtonClass: "btn-danger",
            confirmButtonText: "Sim, quero Remover",
            closeOnConfirm: true,
            cancelButtonText: "NAO",
            showCancelButton: true
        }, function (acao) {
            if (acao) {
                $timeout(function () {
                    $scope.ListaProdutosSelecionados = [];
                    DadosFormularioService.limparDados('produtos-impressao-etiqueta');
                }, 500)
            }
        });
    }

    $scope.AbrirEditorEtiqueta = function () {
        $state.go('newpdv.editor-etiqueta');
    };

    $scope.selecionarModelo = function (mod) {
        $scope.modeloSelecionado = mod;
    };

    $scope.selecionarImpressora = function (impressora) {
        $scope.impressoraSelecionada = impressora;
    };

    $scope.setarFocus = function (nomeElemento) {
        if ((parseInt(nomeElemento))) {
            $scope.paginaAtiva = parseInt(nomeElemento);
        } else {
            $timeout(function () {
                document.getElementsByName(nomeElemento)[0].focus();
            });

            $timeout(function () {
                $scope.$apply(function () {
                    $('select[name="' + nomeElemento + '"]').chosen({});
                    $('select[name="' + nomeElemento + '"]').trigger("chosen:open");
                });
            });
        }
    };

    $scope.cancelarModalGrade = function () {
        if (!!$scope.modalGradesVendas) {
            if ($scope.modalGradesVendas.opened) {
                jaAbriuModalGradeProduto = false;
                $scope.dadosProduto = null;
                $scope.modalGradesVendas.close();
            }
        }
    };

    $scope.adicionarTodosProdutosNaImpressao = function () {
        swal({
            title: "ATENCAO!",
            text: "Deseja Incluir Todos Produtos? (Esse processo pode demorar um pouco!)",
            type: "warning",
            confirmButtonClass: "btn-danger",
            confirmButtonText: "Sim, adicionar todos!",
            closeOnConfirm: true,
            cancelButtonText: "NAO",
            showCancelButton: true
        }, function (acao) {
            if (acao) {
                $scope.modalAguardaProcesso = ModalService.model($scope, 'views/pdv/varejo/modalAguardaProcesso.html', 'md', true, 'static', true);
                $timeout(function () {
                    angular.forEach($scope.ListaProdutos, function (item) {
                        // BUSCAR GRADE
                        $scope.listaGrades = JSON.parse(produtoAppService.listaGradesProduto(item.pro_id));
                        if ($scope.listaGrades.length > 0) {
                            angular.forEach($scope.listaGrades, function (itemGrade) {
                                var dadosImpressao = {};
                                dadosImpressao.codigoProduto = item.pro_codigo;
                                dadosImpressao.descricaoProduto = item.pro_descricao;
                                dadosImpressao.numeroCopias = $scope.filtro.quantidade;
                                dadosImpressao.precoProduto = itemGrade.valorVenda;
                                dadosImpressao.codigoBarras = itemGrade.ean;
                                dadosImpressao.gradeProduto = ""
                                for (var i = 0; i < itemGrade.atributos.length; i++) {
                                    if (itemGrade.atributos[i].mgp_imprimenaetiqueta === true) {
                                        var descricaoGrade = itemGrade.atributos[i].mgp_descricao;
                                        dadosImpressao.gradeProduto += descricaoGrade;//.slice(0, 5); usar caso ficar muito grande a descricao da grade
                                        if (i < itemGrade.atributos.length - 1) {
                                            dadosImpressao.gradeProduto += "/"
                                        }
                                    }
                                }
                                $scope.ListaProdutosSelecionados.push(dadosImpressao);
                            });
                        } else { // OU PRECO
                            var retorno = JSON.parse(produtoAppService.listaPrecoProduto(item.pro_id, null, null, null));
                            angular.forEach(retorno, function (itemPreco) {
                                if ($scope.filtro.listaPreco.ltp_id === itemPreco.ltp_id) {
                                    var dadosImpressao = {};
                                    dadosImpressao.codigoProduto = item.pro_codigo;
                                    dadosImpressao.descricaoProduto = item.pro_descricao;
                                    dadosImpressao.numeroCopias = $scope.filtro.quantidade;
                                    dadosImpressao.precoProduto = itemPreco.lpi_valorvenda;
                                    dadosImpressao.gradeProduto = "";
                                    dadosImpressao.codigoBarras = item.pro_ean;
                                    $scope.ListaProdutosSelecionados.push(dadosImpressao);
                                }
                            });
                        };
                    });
                    $scope.modalAguardaProcesso.close();
                }, 500)
            }
        });
    }

    $scope.ImportarModelo = function () {
        var arquivoCarregado = etiquetaAppService.importarModelo();
        if (!!arquivoCarregado) {

            $scope.dadosEtiqueta = {
                met_descricao: null,
                met_comando: arquivoCarregado,
                met_imagem: null,
                met_colunas: null,
            };

            DadosFormularioService.armazenarDados('editor-etiqueta', $scope.dadosEtiqueta);
            DadosFormularioService.armazenarDados('editor-etiqueta-importar', true);
            $state.go('newpdv.editor-etiqueta');
        }
    }


    /*        
    *         EDITOR DE ETIQUETAS
    *         https://github.com/teynon/ZPL-Label-Designer
    */

    $scope.listaValidacaoFormulario = [
    { nome: 'met_descricao', obrigatorio: '* A descricao do modelo e obrigatorio!', invalido: '' },
    {
        nome: 'impressora', obrigatorio: '* A impressora e obrigatoria!', invalido: ''
    },
    {
        nome: 'met_colunas', obrigatorio: '* A quantidade de colunas e obrigatoria!', invalido: ''
    }
    ];

    $scope.validarFormulario = function (formulario) {
        $scope.listaFormularioInvalido = [];
        ValidarFormularioService.listaFormularioInvalido(formulario, $scope.listaValidacaoFormulario).then(function (retorno) {
            $scope.listaFormularioInvalido = retorno.lista;
            $scope.mensagemFormularioInvalido = retorno.mensagem;

            if ($scope.listaFormularioInvalido.length == 0) {
                $scope.SalvarModeloEtiqueta();
            }
        });
    }

    $scope.SalvarModeloEtiqueta = function () {
        if ($scope.isLinguagemPPLA || $scope.isImportarModelo || $scope.isLinguagemHTML) {
            var dados = {
                met_descricao: $scope.dadosEtiqueta.met_descricao,
                met_comando: $scope.dadosEtiqueta.textAreaEditorEtiqueta,
                met_imagem: null,
                met_colunas: $scope.dadosEtiqueta.met_colunas,
                met_quantidadecaracteresdescricaoproduto: $scope.dadosEtiqueta.met_quantidadecaracteresdescricaoproduto
            };
        } else {
            /*
            *   PEGAR A IMAGEM DO CANVAS PARA SALVAR NO BANCO
            *   https://stackoverflow.com/questions/10257781/can-i-get-image-from-canvas-element-and-use-it-in-img-src-tag
            */
            var canvasEditorEtiqueta = document.getElementById('editorEtiqueta');
            var imagemEtiqueta = new Image();
            imagemEtiqueta.id = "ImagemEtiqueta"
            imagemEtiqueta.src = canvasEditorEtiqueta.toDataURL();

            new $scope.GerarCodigoEtiqueta(this);
            var dados = {
                met_descricao: $scope.dadosEtiqueta.met_descricao,
                met_comando: $scope.dadosEtiqueta.met_comando.comando,
                met_imagem: imagemEtiqueta.src,
                met_colunas: $scope.dadosEtiqueta.met_colunas,
                met_quantidadecaracteresdescricaoproduto: $scope.dadosEtiqueta.met_quantidadecaracteresdescricaoproduto
            };
        }

        if (!!$scope.dadosEtiqueta.Id) {
            dados.Id = $scope.dadosEtiqueta.Id;
            var retornoAlteracao = JSON.parse(etiquetaAppService.editar(JSON.stringify(dados)));
            if (retornoAlteracao) {
                swal({
                    title: 'Modelo Modificado com Sucesso!',
                    text: "",
                    type: "success",
                    confirmButtonClass: "btn-info",
                    confirmButtonText: "OK",
                    closeOnConfirm: true
                }, function (acao) {
                    if (acao) {
                        DadosFormularioService.limparDados('editor-etiqueta');
                        DadosFormularioService.limparDados('editor-etiqueta-importar');
                        $scope.voltarListaModelos();
                    }
                });
            }
        } else {
            var retornoInclusao = JSON.parse(etiquetaAppService.inserir(JSON.stringify(dados)));
            if (retornoInclusao) {
                swal({
                    title: 'Modelo Adicionado com Sucesso!',
                    text: "",
                    type: "success",
                    confirmButtonClass: "btn-info",
                    confirmButtonText: "OK",
                    closeOnConfirm: true
                }, function (acao) {
                    if (acao) {
                        DadosFormularioService.limparDados('editor-etiqueta');
                        DadosFormularioService.limparDados('editor-etiqueta-importar');
                        $scope.voltarListaModelos();
                    }
                });
            }
        }
    };

    $scope.excluirModeloEtiqueta = function (dadosModeloEtiqueta) {
        swal({
            title: 'Deseja Excluir o Registro!',
            text: "",
            type: "warning",
            confirmButtonClass: "btn-danger",
            confirmButtonText: "Sim, quero excluir",
            closeOnConfirm: false,
            cancelButtonText: "NAO",
            showCancelButton: true
        }, function (acao) {
            if (acao) {
                var retornoExclusao = JSON.parse(etiquetaAppService.excluir(dadosModeloEtiqueta.Id));
                if (retornoExclusao) {
                    swal("Modelo Excluido com Sucesso!", "", "success");
                    $timeout(function () {
                        $scope.ListarModelosDeEtiqueta();
                    });
                }
            }
        });
    };

    HTMLCanvasElement.prototype.RelativeMouse = function (event) {
        var deslocamentoX = 0;
        var deslocamentoY = 0;
        var canvasX = 0;
        var canvasY = 0;
        var currentElement = this;

        do {
            deslocamentoX += currentElement.offsetLeft - currentElement.scrollLeft;
            deslocamentoY += currentElement.offsetTop - currentElement.scrollTop;
        }
        while (currentElement = currentElement.offsetParent)

        canvasX = event.clientX - deslocamentoX;
        canvasY = event.clientY - deslocamentoY;

        return {
            x: canvasX, y: canvasY
        }
    }

    var CP = window.CanvasRenderingContext2D && CanvasRenderingContext2D.prototype;
    if (CP && CP.lineTo) {
        CP.dashedLine = function (x, y, x2, y2, dashArray) {
            if (!dashArray)
                dashArray = [10, 5];
            if (dashLength == 0)
                dashLength = 0.001; // Hack for Safari
            var dashCount = dashArray.length;
            this.moveTo(x, y);
            var dx = (x2 - x), dy = (y2 - y);
            var slope = dx ? dy / dx : 1e15;
            var distRemaining = Math.sqrt(dx * dx + dy * dy);
            var dashIndex = 0, draw = true;
            while (distRemaining >= 0.1) {
                var dashLength = dashArray[dashIndex++ % dashCount];
                if (dashLength > distRemaining)
                    dashLength = distRemaining;
                var xStep = Math.sqrt(dashLength * dashLength / (1 + slope * slope));
                if (dx < 0)
                    xStep = -xStep;
                x += xStep
                y += slope * xStep;
                this[draw ? 'lineTo' : 'moveTo'](x, y);
                distRemaining -= dashLength;
                draw = !draw;
            }

            // Ensure that the last segment is closed for proper stroking
            this.moveTo(0, 0);
        }

        CP.dashedStroke = function (x, y, x2, y2, dashArray) {
            this.beginPath();
            this.dashedLine(x, y, x2, y, dashArray);
            this.dashedLine(x2, y, x2, y2, dashArray);
            this.dashedLine(x2, y2, x, y2, dashArray);
            this.dashedLine(x, y, x, y2, dashArray);
            this.stroke();
        }
    }


    $scope.CriarEditor = function (idCanvas, largura, altura, dpi) {
        this.canvas = document.getElementById(idCanvas);
        this.canvasElement = $(this.canvas);
        this.dpi = dpi;
        //this.labelWidth = (largura * $scope.dadosEtiqueta.met_colunas) * this.dpi; para mais colunas
        this.labelWidth = largura * this.dpi;
        this.labelHeight = altura * this.dpi;

        /*
        *   CRIA A CAIXA DE INSPEO DAS PROPRIEDADES DAS FERRAMENTAS
        */
        if (this.propertyInspector === undefined) {
            this.propertyInspector = new $scope.CriarPropertyInspector(this, this.canvas);
        }

        /*
        *   CRIA A CAIXA DE FERRAMENTAS E ADICIONA AS FERRAMENTAS
        *   TEXTO E CODIGO DE BARRAS
        */
        if (this.toolbar === undefined) {
            this.toolbar = new $scope.CriarPainelDeFerramentas(this, this.canvas);//new com.logicpartners.toolsWindow(this, this.canvas);
            this.toolbar.addTool(new $scope.CriarFerramentaDeTexto());
            this.toolbar.addTool(new $scope.CriarFerramentaDeCodigoDeBarras());
        }

        /*
        *   CRIAR A CAIXA DE INSPEO DAS PROPRIEDADES DA ETIQUETA
        *   ALTURA, LARGURA E DPI
        */
        //this.labelInspector = new $scope.CriarLabelInspector(this, this.canvas);
        //this.labelInspector.addTool(new $scope.ControleDaLabel(this));


        this.drawingContext = this.canvas.getContext("2d");
        this.elements = [];
        this.currentLayer = 0;
        this.activeElement = null;
        this.activeTool = null;

        this.labelX = this.canvas.width / 2 - this.labelWidth / 2;
        this.labelY = 5;

        this.newObject = null;
        this.dragStartPosition = {
            x: 0, y: 0
        };
        this.dragStartTime = 0;
        this.dragLastPosition = {
            x: 0, y: 0
        };
        this.dragElementOffset = {
            x: 0, y: 0
        };
        this.dragAction = 0;
        this.dragging = false;

        var self = this;

        this.updateLabelSize = function (width, height) {
            var xchange = (width * this.dpi + 10) - parseInt(this.canvasElement.prop("width"));

            this.labelWidth = width * this.dpi;
            this.labelHeight = height * this.dpi;

            this.canvasElement.prop("width", this.labelWidth + 10).prop("height", this.labelHeight + 10);
            this.labelX = this.canvas.width / 2 - this.labelWidth / 2;
            this.labelY = 5;
            this.updateCanvas();
        }

        this.canvasElement.on("click", function () {
            self.setActiveElement();
        }).on("mousedown", function () {
            self.dragStartPosition = self.canvas.RelativeMouse(event);
            self.dragLastPosition = self.dragStartPosition;

            if (self.newObject) {
                // Create new object.
                self.elements[self.currentLayer++] = new self.newObject(self.dragStartPosition.x, self.dragStartPosition.y, 1, 1);
                self.dragAction = 8;
                self.activeElement = self.elements[self.currentLayer - 1];
                self.newObjectController.button.removeClass("designerToolbarButtonActive");
                self.newObject = null;
                self.newObjectController = null;
            }
            else {
                self.dragAction = 0;

                self.setActiveElement();

                if (self.activeElement) {
                    self.dragElementOffset = {
                        x: self.activeElement.x - self.dragStartPosition.x,
                        y: self.activeElement.y - self.dragStartPosition.y
                    };

                    self.setActiveHandle(self.dragStartPosition);
                }
            }
            self.dragging = true;
        }).on("mouseup", function () {
            self.dragging = false;
        }).on("mouseout", function () {
            self.dragging = false;
        }).on("mousemove", function () {
            if (self.dragging && self.activeElement) {
                var coords = self.canvas.RelativeMouse(event);
                //console.log(self.dragAction);
                switch (self.dragAction) {
                    case 0:
                        self.move(coords.x + self.dragElementOffset.x, coords.y + self.dragElementOffset.y);
                        break;
                    default:
                        self.resize(coords.x - self.dragLastPosition.x, coords.y - self.dragLastPosition.y, self.dragAction);
                        break;
                }
                self.updateCanvas();
                self.dragLastPosition = coords;
            }
            else if (self.newObject != null) {
                self.canvasElement.css({
                    cursor: "crosshair"
                });
            }
            else if (self.activeElement) {
                var coords = self.canvas.RelativeMouse(event);
                // If cursor is within range of edge, show resize handles
                var location = self.getHandle(coords);
                var style = "default";
                switch (location) {
                    case 0:
                        style = "default";
                        break;
                    case 1:
                        style = "nw-resize";
                        break;
                    case 2:
                        style = "n-resize";
                        break;
                    case 3:
                        style = "ne-resize";
                        break;
                    case 4:
                        style = "w-resize";
                        break;
                    case 5:
                        style = "e-resize";
                        break;
                    case 6:
                        style = "sw-resize";
                        break;
                    case 7:
                        style = "s-resize";
                        break;
                    case 8:
                        style = "se-resize";
                        break;
                }
                self.canvasElement.css({
                    cursor: style
                });
            }
        }).on("keydown", function (event) {
            event = event || window.event;

            var handled = false;
            switch (event.keyCode) {
                case 37: // Left arrow
                    if (self.activeElement)
                        self.activeElement.x -= 1;
                    handled = true;
                    break;
                case 38: // Up arrow
                    if (self.activeElement)
                        self.activeElement.y -= 1;
                    handled = true;
                    break;
                case 39: // Right arrow
                    if (self.activeElement)
                        self.activeElement.x += 1;
                    handled = true;
                    break;
                case 40: // Down arrow
                    if (self.activeElement)
                        self.activeElement.y += 1;
                    handled = true;
                    break;
                case 46:
                    if (self.activeElement) {
                        self.deleteActiveElement();
                        handled = true;
                    }
                    break;
                case 80:
                    if (event.ctrlKey) {
                        self.generateZPL();
                        handled = true;
                    }
                    break;
            }

            if (handled) {
                self.updateCanvas();
                event.preventDefault();
                event.stopPropagation();
            }
        });

        this.addObject = function (object) {
            this.elements[this.currentLayer++] = object;
            this.activeElement = this.elements[this.currentLayer - 1];
            this.updateCanvas();
        }

        this.deleteActiveElement = function () {
            if (this.activeElement) {
                for (var i = 0; i < this.currentLayer; i++) {
                    if (this.elements[i] && this.elements[i] == this.activeElement) {
                        this.elements[i] = null;
                        this.activeElement = null;
                    }
                }
            }
        }

        this.setActiveElement = function () {
            var coordinates = this.canvas.RelativeMouse(event);
            if (!this.activeElement || this.getHandle(coordinates) == 0) {
                this.activeElement = null;
                for (var i = this.currentLayer - 1; i >= 0; i--) {
                    if (this.elements[i] && this.elements[i].hitTest(coordinates)) {
                        this.activeElement = this.elements[i];
                        break;
                    }
                }
            }

            this.updateCanvas();
        }

        /**
         * Parameters: Coordinates on canvas.
         * 
         * Returns: 0 if not on resize zone.
         *          1 top left     2 top     3 top right
         *          4 left                   5 right
         *          6 bottom left  7 bottom  8 bottom right
         */
        this.setActiveHandle = function (coords) {
            this.dragAction = this.getHandle(coords);
        }

        this.getHandle = function (coords) {
            var result = 0;

            var leftEdge = coords.x > this.activeElement.x - 5 && coords.x < this.activeElement.x + 5;
            var rightEdge = coords.x > this.activeElement.x + this.activeElement.getWidth() - 5 && coords.x < this.activeElement.x + this.activeElement.getWidth() + 5;
            var topEdge = coords.y > this.activeElement.y - 5 && coords.y < this.activeElement.y + 5;
            var bottomEdge = coords.y > this.activeElement.y + this.activeElement.getHeight() - 5 && coords.y < this.activeElement.y + this.activeElement.getHeight() + 5;

            var verticalHit = coords.y > this.activeElement.y && coords.y < this.activeElement.y + this.activeElement.getHeight();
            var horizontalHit = coords.x > this.activeElement.x && coords.x < this.activeElement.x + this.activeElement.getWidth();

            if (leftEdge && topEdge)
                result = 1;
            else if (rightEdge && topEdge)
                result = 3;
            else if (leftEdge && bottomEdge)
                result = 6;
            else if (rightEdge && bottomEdge)
                result = 8;
            else if (topEdge && horizontalHit)
                result = 2;
            else if (leftEdge && verticalHit)
                result = 4;
            else if (rightEdge && verticalHit)
                result = 5;
            else if (bottomEdge && horizontalHit)
                result = 7;

            return result;
        }

        this.move = function (x, y) {
            this.activeElement.x = x;
            this.activeElement.y = y;
        }

        this.resize = function (xchange, ychange) {
            switch (this.dragAction) {
                case 1: // Top Left
                    this.activeElement.x += xchange;
                    this.activeElement.y += ychange;
                    this.activeElement.setWidth(this.activeElement.getWidth() - xchange);
                    this.activeElement.setHeight(this.activeElement.getHeight() - ychange);
                    break;
                case 2: // Top
                    this.activeElement.y += ychange;
                    this.activeElement.setHeight(this.activeElement.getHeight() - ychange);
                    break;
                case 3: // Top Right
                    this.activeElement.setWidth(this.activeElement.getWidth() + xchange);
                    this.activeElement.y += ychange;
                    this.activeElement.setHeight(this.activeElement.getHeight() - ychange);
                    break;
                case 4: // Left
                    this.activeElement.x += xchange;
                    this.activeElement.setWidth(this.activeElement.getWidth() - xchange);
                    break;
                case 5: // Right
                    this.activeElement.setWidth(this.activeElement.getWidth() + xchange);
                    break;
                case 6: // Bottom Left
                    this.activeElement.x += xchange;
                    this.activeElement.setWidth(this.activeElement.getWidth() - xchange);
                    this.activeElement.setHeight(this.activeElement.getHeight() + ychange);
                    break;
                case 7: // Bottom
                    this.activeElement.setHeight(this.activeElement.getHeight() + ychange);
                    break;
                case 8: // Bottom Right
                    this.activeElement.setWidth(this.activeElement.getWidth() + xchange);
                    this.activeElement.setHeight(this.activeElement.getHeight() + ychange);
                    break;
            }

            if (this.activeElement.getWidth() == 0) {
                this.activeElement.setWidth(-1);
                this.activeElement.x += 1;
            }

            if (this.activeElement.getHeight() == 0) {
                this.activeElement.setHeight(-1);
                this.activeElement.y += 1;
            }

            if (this.activeElement.width < 0) {
                this.activeElement.x = this.activeElement.x + this.activeElement.getWidth();
                this.activeElement.setWidth(parseInt(this.activeElement.getWidth() * -1));
                this.swapActionHorizontal();
            }

            if (this.activeElement.height < 0) {
                this.activeElement.y = this.activeElement.y + this.activeElement.getHeight();
                this.activeElement.setHeight(this.activeElement.getHeight() * -1);
                this.swapActionVertical();
            }
        }

        this.swapActionVertical = function () {
            switch (this.dragAction) {
                case 1:
                    this.dragAction = 6;
                    break;
                case 2:
                    this.dragAction = 7;
                    break;
                case 3:
                    this.dragAction = 8;
                    break;
                case 6:
                    this.dragAction = 1;
                    break;
                case 7:
                    this.dragAction = 2;
                    break;
                case 8:
                    this.dragAction = 3;
                    break;
            }
        }

        this.swapActionHorizontal = function () {
            switch (this.dragAction) {
                case 1:
                    this.dragAction = 3;
                    break;
                case 3:
                    this.dragAction = 1;
                    break;
                case 4:
                    this.dragAction = 5;
                    break;
                case 5:
                    this.dragAction = 4;
                    break;
                case 6:
                    this.dragAction = 8;
                    break;
                case 8:
                    this.dragAction = 6;
                    break;
            }
        }

        this.update = function () {
            this.propertyInspector.update(this.activeElement);
        }

        this.updateCanvas = function () {
            this.update();

            //this.drawingContext.globalCompositeOperation = "source-over";

            this.drawingContext.fillStyle = "#FFFFFF";
            this.drawingContext.fillRect(0, 0, this.canvas.width, this.canvas.height);

            //this.drawingContext.fillStyle = "rgba(255, 255, 255, 0)";
            //this.drawingContext.fillRect(0, 0, this.canvas.width, this.canvas.height);

            // Draw the boundary.
            this.drawingContext.strokeStyle = "#FF0000";
            this.drawingContext.lineWidth = 2;
            this.drawingContext.strokeRect(this.labelX, this.labelY, this.labelWidth, this.labelHeight);

            this.drawingContext.strokeStyle = "#000000";
            this.drawingContext.fillStyle = "#000000";

            //this.drawingContext.globalCompositeOperation = "difference";

            for (var i = 0; i < this.currentLayer; i++) {
                if (this.elements[i]) {
                    this.elements[i].draw(this.drawingContext, this.canvas.width, this.canvas.height);
                }
            }

            this.drawingContext.strokeStyle = "#FF0000";
            this.drawingContext.lineCap = 'butt';
            this.drawingContext.lineWidth = 2;
            if (this.activeElement)
                this.activeElement.drawActive(this.drawingContext);
        }

        /*
        *   GERA O CODIGO
        */
        this.generateZPL = function () {
            var data = "^XA\r\n" +
                "^CFd0,10,18\r\n" +
                "^PR12\r\n" +
                "^LRY\r\n" +
                "^MD30\r\n" +
                "^PW" + this.labelWidth + "\r\n" +
                "^LL" + this.labelHeight + "\r\n" +
                "^PON\r\n";

            var bufferData = "";

            for (var i = 0; i < this.currentLayer; i++) {
                if (this.elements[i]) {
                    bufferData += this.elements[i].getZPLData();
                    data += this.elements[i].toZPL(this.labelX, this.labelY, this.labelHeight, this.labelWidth);
                }
            }

            data += "^PQ1\r\n" +
                "^XZ\r\n";

            console.log("codigo" + bufferData + data);

            return {
                "data": bufferData, "comando": data
            };
        }

        this.generateEPL2 = function () {
            var bufferData = "";
            var data2 = "I8,A,001\n" +
                "Q" + Math.floor(this.labelHeight) + "\n" +
                "q" + Math.floor(this.labelWidth) + "\n" +
                "rN\n" +
                "S4\n" +
                "D8\n" +
                "ZT\n" +
                "JF\n" +
                "OD\n" +
                "R64,0\n" +
                "f100\n" +
                "N\n";

            // original
            //for (var i = 0; i < this.currentLayer; i++) {
            //    if (this.elements[i]) {

            //        bufferData += this.elements[i].getEPL2Data();
            //        data2 += this.elements[i].toEPL2(Math.floor(this.labelX), Math.floor(this.labelY), this.labelHeight, this.labelWidth) + "\r";
            //    }
            //}

            // ajustar para mais colunas
            for (var i = 0; i < this.currentLayer; i++) {
                if (this.elements[i]) {
                    for (var x = 0; x < $scope.dadosEtiqueta.met_colunas; x++) {
                        bufferData += this.elements[i].getEPL2Data();
                        var somaPosX = 0;
                        if (x > 0) {
                            somaPosX += this.labelWidth;
                        }
                        data2 += this.elements[i].toEPL2(Math.floor(this.labelX) + parseInt(somaPosX), Math.floor(this.labelY), this.labelHeight, this.labelWidth) + "\r";
                    }
                }
            }

            data2 += "P@numeroCopias\r\n";

            return {
                "data": bufferData, "comando": data2
            };
        }

        this.setNewObject = function (controller) {
            if (controller) {
                this.newObject = controller.object;
                this.newObjectController = controller;
            }
            else {
                this.newObject = null;
                this.newObjectController = null;
            }
        }


        this.updateLabelSize(largura, altura);

        this.updateCanvas();
    }

    // PROPRIEDADES DA ETIQUETA TAMANHO E DPI
    $scope.CriarLabelInspector = function (designer, canvas) {
        this.canvas = canvas;
        this.canvasElement = $(canvas);
        this.labelDesigner = designer;
        var self = this;
        this.boundingBox = null;

        this.updatePosition = function (xchange) {
            //this.inspectorWindow.css("width", parseInt(this.inspectorWindow.css("width")) + xchange);
            //this.boundingBox = this.inspectorWindow[0].getBoundingClientRect();
        }

        // Create the property window.
        this.inspectorWindow = $('<div></div>')
            .addClass("designerUtilityToolbar designerUtilityLabelInspector")
            .css({
                //posicao na tela
                "left": this.labelDesigner.toolbar.boundingBox.left,
                "width": "100%",
                "margin-bottom": "1%"
            }).insertAfter(this.canvasElement);


        this.toolsViewContainer = $('<div></div>')
            .addClass("designerLabelContent")
            .appendTo(this.inspectorWindow);


        this.buttonView = $('<div></div>').appendTo(this.toolsViewContainer);

        this.update = function (activeElement) {
        }

        this.addTool = function (controller) {
            //console.log(controller.workspace.html());
            this.buttonView.append(controller.workspace);
        }
    };

    // PROPRIEDADES
    $scope.CriarPropertyInspector = function (designer, canvas) {
        this.canvas = canvas;
        this.canvasElement = $(canvas);
        this.labelDesigner = designer;
        this.activeElement = null;
        this.propertyNodes = {
        };
        this.boundingBox = null;
        var self = this;

        // Create the property window.
        this.propertyInspector = $('<div class="pull-right"></div>')
            .addClass("designerUtilityWindow")
        .css({
            //"left": this.canvas.getBoundingClientRect().right + 5,
            "top": this.canvas.getBoundingClientRect().top,
            //"width": "35%"
            "width": "22%"
        })
            //.draggable({handle: "div.designerPropertyTitle"})
        .insertAfter(this.canvasElement);

        this.updatePosition = function (xchange) {
            this.propertyInspector.css("left", parseInt(this.propertyInspector.css("left")) + xchange);
            this.boundingBox = this.propertyInspector[0].getBoundingClientRect();
        }


        this.propertyViewContainer = $('<div></div>')
            .addClass("designerPropertyContainer")
            //.resizable({
            //	resize: function(event, ui) {
            //		ui.size.width = ui.originalSize.width;
            //	}
            //})
            .appendTo(this.propertyInspector);

        this.titleBar = $('<div>Propriedades</div>')
            .addClass("designerPropertyTitle")
            .prependTo(this.propertyInspector)
            .on("dblclick", function () {
                self.propertyViewContainer.toggle();
            });

        this.propertyView = $('<div></div>')
            .addClass("designerPropertyContent")
            .appendTo(this.propertyViewContainer);

        this.update = function (activeElement) {
            var self = this;
            var getType = {
            };
            var keys = [];

            if (this.activeElement == activeElement) {
                for (var key in activeElement) {
                    if (!activeElement.readonly || key != "readonly" && $.inArray(key, activeElement.readonly) == -1) {
                        if (getType.toString.call(activeElement[key]) != '[object Function]') {
                            this.propertyNodes[key].val(activeElement[key]);
                        }
                    }
                }
            }
            else {
                this.activeElement = activeElement;
                this.propertyView.html('');

                for (var key in activeElement) {
                    if (!keys[key]) {
                        keys[key] = true;

                        if (key != "readonly" && getType.toString.call(activeElement[key]) != '[object Function]') {

                            /* MUDAR NOME DAS PROPRIEDADES */
                            var key2 = null;
                            if (key === "name") {
                                key2 = "Nome";
                            } else if (key === "text") {
                                key2 = "Texto";
                            } else if (key === "x") {
                                key2 = "Pos X";
                            } else if (key === "y") {
                                key2 = "Pos Y";
                            } else if (key === "width") {
                                key2 = "Largura";
                            } else if (key === "height") {
                                key2 = "Altura";
                            } else if (key === "fontSize") {
                                key2 = "Tam. Fonte"
                            } else if (key === "fontType") {
                                key2 = "Tipo Fonte"
                            }


                            var elementKey = $('<div>' + key2 + '</div>')
                                .css({
                                    "width": "75px",
                                    "height": "20px",
                                    "border": "1px solid #AAAAAA",
                                    "float": "left",
                                    "font-size": "12px",
                                    "line-height": "20px",
                                    "border-right": "none",
                                    "text-align": "right",
                                    "padding-right": "5px",
                                    "margin-left": "5px"
                                });

                            /* 
                            * IMPORTANTE
                            * SE FOR DO TIPO TEXT FAZER UM SELECT MOSTRAR AS POSSIVEIS VARIAVEIS
                            * O USUARIO PRECISA ESCOLHER O TIPO DE CAMPO 
                            * POIS ESSE IR MOSTRAR O VALOR NA ETIQUETA
                            */
                            if (key === "text") {
                                var elementValue = $(
                                    '<select id="selectCampos"' +
                                    'name="' + key + '"' +
                                    'value="' + activeElement[key] + '"> ' +
                                        '<option value="@codigoProduto">C&oacute;digo do Produto</option>' +
                                        '<option value="@descricaoProduto">Descri&ccedil;&atilde;o do Produto</option>' +
                                        '<option value="@precoProduto">Pre&ccedil;o do Produto</option>' +
                                        '<option value="@codigoBarras">C&oacute;digo de Barras</option>' +
                                    '</select>')
                                    .css({
                                        "width": "120px",
                                        "float": "left",
                                        "height": "22px",
                                        "line-height": "20px",
                                        "padding-left": "5px"
                                    });


                                elementValue.on("change", {
                                    "objectProperty": key
                                }, function (event) {
                                    var data = self.activeElement[event.data.objectProperty];
                                    self.activeElement[event.data.objectProperty] = (data === parseInt(data, 10)) ? parseInt($(this).val()) : $(this).val();
                                    self.labelDesigner.updateCanvas();
                                });
                            } else {
                                /*
                                * MOSTRAR AS OUTRAS PROPRIEDADES
                                * O USURIO NO PRECISA SABER DESSAS PROPRIEDADES
                                */
                                var elementValue = $('<input type="text" name="' + key + '" value="' + activeElement[key] + '">')
                                    .css({
                                        "width": "120px",
                                        "float": "left",
                                        "height": "22px",
                                        "line-height": "20px",
                                        "padding-left": "5px"
                                    });
                            }

                            if (!activeElement.readonly || $.inArray(key, activeElement.readonly) == -1) {
                                elementValue.on("keyup", {
                                    "objectProperty": key
                                }, function (event) {
                                    var data = self.activeElement[event.data.objectProperty];
                                    self.activeElement[event.data.objectProperty] = (data === parseInt(data, 10)) ? parseInt($(this).val()) : $(this).val();
                                    self.labelDesigner.updateCanvas();
                                });
                            }
                            else {
                                // Draw readonly textbox.
                                elementValue.prop("readonly", true).css({
                                    "background-color": "#DDDDDD", border: "1px solid #AAAAAA"
                                });
                            }

                            this.propertyNodes[key] = elementValue;

                            var elementContainer = $('<div></div>')
                                .css({
                                    "clear": "both",
                                    "padding-top": "2px"
                                })
                                .append(elementKey).append(elementValue);
                            this.propertyView.append(elementContainer);
                        }
                    }
                }
            }
        }

        this.updatePosition(0);
    }

    $scope.ControleDaLabel = function (designer) {
        var self = this;
        this.designer = designer;
        this.workspace = $('<div></div>').addClass("designerLabelControl").attr("title", "Label Size");

        this.widthContainer = $("<div>Largura(inches): </div>").addClass("designerLabelControlContainer").appendTo(this.workspace);
        this.widthController = $("<input type=\"text\" />")
            .addClass("designerLabelControlElement")
            .css({
                width: "50px"
            })
            .val(this.designer.labelWidth / this.designer.dpi)
            .appendTo(this.widthContainer)
            .on("blur", function () {
                self.updateDesigner();
            }).on("keypress", function (e) {
                if (e.which == 13) {
                    e.preventDefault();
                    self.updateDesigner();
                }
            });

        this.heightContainer = $("<div>Altura(inches): </div>").addClass("designerLabelControlContainer").appendTo(this.workspace);
        this.heightController = $("<input type=\"text\" />")
            .addClass("designerLabelControlElement")
            .css({
                width: "50px",
            })
            .val(this.designer.labelHeight / this.designer.dpi)
            .appendTo(this.heightContainer)
            .on("blur", function () {

                self.updateDesigner();
            })
            .on("keypress", function (e) {
                if (e.which == 13) {
                    e.preventDefault();
                    self.updateDesigner();
                }
            });

        this.dpiContainer = $("<div>DPI: </div>").addClass("designerLabelControlContainer").appendTo(this.workspace);
        this.dpiController = $("<input type=\"text\" />")
            .addClass("designerLabelControlElement")
            .css({
                width: "50px"
            })
            .val(this.designer.dpi)
            .appendTo(this.dpiContainer)
            .on("blur", function () {

                self.updateDesigner();
            })
            .on("keypress", function (e) {
                if (e.which == 13) {
                    e.preventDefault();
                    self.updateDesigner();
                }
            });

        this.updateDesigner = function () {
            var dpi = this.designer.dpi;

            if (!isNaN(this.dpiController.val())) dpi = this.dpiController.val();
            this.designer.dpi = dpi;

            var width = this.designer.labelWidth / this.designer.dpi;
            var height = this.designer.labelHeight / this.designer.dpi;

            if (!isNaN(this.widthController.val())) width = this.widthController.val();
            if (!isNaN(this.heightController.val())) height = this.heightController.val();

            this.designer.updateLabelSize(width, height);
            this.widthController.val(width);
            this.heightController.val(height);
        }

        this.update = function () {
            this.widthController.val(this.designer.labelWidth / this.designer.dpi);
            this.heightController.val(this.designer.labelHeight / this.designer.dpi);
        }
    }

    $scope.CriarPainelDeFerramentas = function (designer, canvas) {
        this.canvas = canvas;
        this.canvasElement = $(canvas);
        this.labelDesigner = designer;
        this.boundingBox = null;
        var self = this;

        // Create the property window.
        this.toolsWindow = $('<div></div>')
            .addClass("designerUtilityToolbar")
            .css({
                /* posicao na tela */
                "top": this.canvas.getBoundingClientRect().top,
                "width": "10%",
                "float": "left"
            })
            //.draggable({handle: "div.designerPropertyTitle"})
            .insertAfter(this.canvasElement);


        this.toolsViewContainer = $('<div></div>')
            .addClass("designerToolbarContent")
            .appendTo(this.toolsWindow);

        this.titleBar = $('<div>Ferramentas</div>')
            .addClass("designerPropertyTitle")
            .prependTo(this.toolsWindow)
            .on("dblclick", function () {
                self.toolsViewContainer.toggle();
            });

        this.buttonView = $('<div></div>')
            .appendTo(this.toolsViewContainer);

        this.setTool = function (controller) {
            if (self.labelDesigner.newObjectController == controller) {
                self.labelDesigner.setNewObject(null);
                controller.button.removeClass("designerToolbarButtonActive");
            }
            else {

                if (self.labelDesigner.newObjectController) self.labelDesigner.newObjectController.button.removeClass("designerToolbarButtonActive");
                self.labelDesigner.setNewObject(controller);
                if (controller) {
                    controller.button.addClass("designerToolbarButtonActive");

                    if (controller.activate) controller.activate(this);
                }
            }
        };

        this.addTool = function (controller) {
            var self = this;
            controller.button.on("click", {
                tool: controller
            }, function (event) {
                self.setTool(event.data.tool);
            });

            this.buttonView.append(controller.button);
        }

        this.updatePosition = function (xchange) {
            this.boundingBox = this.toolsWindow[0].getBoundingClientRect();
        }

        this.update = function (activeElement) {
        }

        this.updatePosition(0);
    }

    $scope.CriarFerramentaDeTexto = function () {
        var self = this;
        this.counter = 1;
        this.button = $("<div></div>").addClass("designerToolbarText designerToolbarButton").attr("title", "Campo de Texto").append($("<div></div>"));
        this.object = function (x, y, width, height) {
            this.name = "Textbox " + self.counter++;
            this.text = this.name;
            this.x = x;
            this.y = y;
            this.fontSize = 36;
            this.fontType = "Arial";
            this.width = 100;
            this.height = 0;

            this.readonly = ["width", "height"];

            this.getFontHeight = function () {
                var textMeasure = $("<div></div>").css({
                    "font-size": this.fontSize + "px",
                    "font-family": this.fontType,
                    "opacity": 0,
                }).text("M").appendTo($("body"));

                var height = textMeasure.outerHeight();
                textMeasure.remove();
                return height;
            }

            this.getZPLData = function () {
                return "";
            }

            this.getEPL2Data = function () {
                return "";
            }

            /* 
            *   GERA O CDIGO PARA ZPL
            */
            this.toZPL = function (labelx, labely, labelwidth, labelheight) {
                return "^FO" + (this.x - labelx) + "," + (this.y - labely) + "^FD" + this.text + "^FS";
            }

            /* 
            *   GERA O CDIGO PARA EPL2
            */
            this.toEPL2 = function (labelx, labely, labelwidth, labelheight) {
                //return "A" + (this.x - labelx) + "," + (this.y - labely) + ",0,4,1,2,N," + '"' + this.text + '"' + ""; original
                return "A" + (parseInt(this.x) - parseInt(labelx)) + "," + (parseInt(this.y) - parseInt(labely)) + ",0,4,1,2,N," + '"' + this.text + '"' + "";
            }

            this.draw = function (context) {
                context.font = this.fontSize + "px " + this.fontType;
                var oColor = context.fillStyle;
                context.fillStyle = "white";
                this.height = this.getFontHeight();
                var measuredText = context.measureText(this.text);
                this.width = measuredText.width;
                context.globalCompositeOperation = "difference";
                context.fillText(this.text, this.x, this.y + (this.height * 0.75));
                context.globalCompositeOperation = "source-over";
                context.fillStyle = oColor;
                //context.fillRect(this.x, this.y, this.width, this.height);
            }

            this.setWidth = function (width) {
                //this.width = width;
            }

            this.getWidth = function () {
                return this.width;
            }

            this.setHeight = function (height) {
                //height = height;
            }

            this.getHeight = function () {
                return this.height * 0.75;
            }

            this.setHandle = function (coords) {
                this.handle = this.resizeZone(coords);
            }

            this.getHandle = function () {
                return this.handle;
            }

            this.drawActive = function (context) {
                context.dashedStroke(parseInt(this.x + 1), parseInt(this.y + 1), parseInt(this.x) + parseInt(this.width) - 1, parseInt(this.y) + parseInt(this.height * 0.9) - 1, [2, 2]);
            }

            this.hitTest = function (coords) {
                return (coords.x >= parseInt(this.x) && coords.x <= parseInt(this.x) + parseInt(this.width) && coords.y >= parseInt(this.y) && coords.y <= parseInt(this.y) + parseInt(this.height) * 0.75);
            }
        }
    }

    $scope.CriarFerramentaDeCodigoDeBarras = function () {
        var self = this;
        this.counter = 1;
        this.button = $("<div></div>").addClass("designerToolbarBarcode designerToolbarButton").attr("title", "Codigo de Barras").append($("<div></div>"));
        this.object = function (x, y, width, height) {
            var width = 100;
            var canvasHolder = $("<canvas></canvas>").prop("width", "100").prop("height", "10");
            this.name = "Barcode " + self.counter++;
            this.text = "BARCODE";
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;

            this.getZPLData = function () {
                return "";
            }
            this.getEPL2Data = function () {
                return "";
            }

            /* 
            *   GERA O CDIGO PARA ZPL
            */
            this.toZPL = function (labelx, labely, labelwidth, labelheight) {
                return "^FO" + (this.x - labelx) + "," + (this.y - labely) + "^BY1^B3N,N," + this.height + "N,N^FD" + this.text + "^FS";
            }

            /* 
            *   GERA O CDIGO PARA EPL2
            */
            this.toEPL2 = function (labelx, labely, labelwidth, labelheight) {
                //return "B" + (this.x - labelx) + "," + (this.y - labely) + ",0,1,4,12,68,B, " + '"' + this.text + '"' + ""; original
                return "B" + (parseInt(this.x) - parseInt(labelx)) + "," + (parseInt(this.y) - parseInt(labely)) + ",0,1,4,12,68,B, " + '"' + this.text + '"' + "";
            }

            this.draw = function (context) {
                /* TAMANHOS DO COMPONENTE */
                canvasHolder.JsBarcode(this.text, {
                    width: 2, height: 2
                });
                var cwidth = canvasHolder[0].width;
                var cheight = canvasHolder[0].height;
                var ctx = canvasHolder[0].getContext('2d');
                width = cwidth;

                var cData = ctx.getImageData(0, 0, cwidth, cheight);

                for (var i = 0; i < cwidth; i++) {
                    if (cData.data[i * 4 + 3] == 255) { // Black (barcode = black or white)
                        // Draw a black rectangle at this point.                        
                        context.fillRect(this.x + i, this.y, 1, this.height);
                    }
                }
            }

            this.setWidth = function (width) {
                this.width = width;
            }

            this.getWidth = function () {
                return width;
            }

            this.setHeight = function (height) {
                this.height = height;
            }

            this.getHeight = function () {
                return this.height;
            }

            this.setHandle = function (coords) {
                this.handle = this.resizeZone(coords);
            }

            this.getHandle = function () {
                return this.handle;
            }

            this.drawActive = function (context) {
                context.dashedStroke(parseInt(this.x + 1), parseInt(this.y + 1), parseInt(this.x) + parseInt(width) - 1, parseInt(this.y) + parseInt(this.height) - 1, [2, 2]);
            }

            this.hitTest = function (coords) {
                return (coords.x >= parseInt(this.x) && coords.x <= parseInt(this.x) + parseInt(width) && coords.y >= parseInt(this.y) && coords.y <= parseInt(this.y) + parseInt(this.height));
            }
        }
    };

    $scope.GerarCodigoEtiqueta = function (designer) {
        var self = this;
        this.designer = designer;

        this.workspace = $("<div></div>").addClass("designerLabelControl").attr("title", "Tamanho da Etiqueta").css({
            float: "right"
        });

        //var zpl2 = self.designer.generateZPL();
        //var zpl = self.designer.generateEPL2();       

        if ($scope.dadosEtiqueta.impressora.imp_linguagem === "EPL2") {
            $scope.dadosEtiqueta.met_comando = self.designer.generateEPL2();
        } else {
            $scope.dadosEtiqueta.met_comando = self.designer.generateZPL();
        }

        this.update = function () {
            this.widthController.val(this.designer.labelWidth / this.designer.dpi);
            this.heightController.val(this.designer.labelHeight / this.designer.dpi);
        }
    }

}]);