﻿newERP.controller('EstornoParcelaController', ['$scope', '$filter', '$timeout', 'DadosFormularioService', '$state', 'ModalService', 'FuncaoService', '$localStorage', 'growlService', function ($scope, $filter, $timeout, DadosFormularioService, $state, ModalService, FuncaoService, $localStorage, growlService) {


    $scope.model = {
        senhaGerencial: ''
    };

    var dataAtual = new Date();
    $scope.filtro = {
        dataInicial: new Date(dataAtual.getFullYear(), dataAtual.getMonth(), dataAtual.getDate()),
        dataFinal: new Date(dataAtual.getFullYear(), dataAtual.getMonth() + 1, 0),
        pessoa: null
    };

    $scope.ListaParcelas = [];
    $scope.BuscarParcelas = function (pessoa) {
        $scope.ListaParcelas = JSON.parse(parcelaAppService.listarParcelasQuitadasNewerp(pessoa.Id, $scope.filtro.dataInicial, $scope.filtro.dataFinal));
        console.log('RetornoParcelas: ', $scope.ListaParcelas);
    };

    $scope.estornarRecebimentoParcela = function (parcela) {
        swal({
            title: 'ATENÇÃO!!!',
            text: "Deseja Estornar o Recebimento da Parcela?",
            type: "warning",
            showCancelButton: true,
            cancelButtonText: "Não",
            confirmButtonClass: "btn-danger",
            confirmButtonText: "Sim",
            allowOutsideClick: false
        }, function (acao) {
            if (acao) {
                $timeout(function () {
                    $scope.parcelaSelecionada = parcela; // Armazena a parcela para uso na validação
                    var retorno = $scope.verificaSenhaGerencial(parcela);
                }, 100);
            } else {
                $timeout(function () {
                    $scope.BuscarParcelas($scope.filtro.pessoa, $scope.filtro.dataInicial, $scope.filtro.dataFinal);
                });
            }
        });
    };

    $scope.imprimirComprovante = function (dadosParcela) {
        parcelaAppService.reImprimirComprovantePagamento(dadosParcela);
    };

    $scope.verificaSenhaGerencial = function (parcela) {
        var retorno = localAppService.possuiSenhaGerencial();
        if (retorno == true) {
            $scope.parcelaSelecionada = parcela; // Armazena a parcela para uso na validação
            $scope.modalSenhaGerencial = ModalService.model($scope, 'views/pdv/varejo/modalSenhaGerencial.html', 'sm', true, 'static', true);
        }
    }; 
    $scope.fecharModalSenhaGerencial = function () {
        $scope.model.senhaGerencial = '';
        $scope.modalSenhaGerencial.close();
        $scope.close();
    }

    $scope.validaSenhaGerencial = function (senha) {
        var senhaValida = localAppService.validarSenhaGerencial(senha);
        if (senhaValida == true) {
            var retorno = parcelaAppService.estornarRecebimentoParcela($scope.parcelaSelecionada);
            if (retorno) {
                swal("ATENÇÃO!", "Recebimento Estornado com Sucesso!", "success");
                $timeout(function () {
                    $scope.fecharModalSenhaGerencial();
                    $scope.BuscarParcelas($scope.filtro.pessoa, $scope.filtro.dataInicial, $scope.filtro.dataFinal);
                });
            } else {
                swal("ATENÇÃO!", "Erro ao Estornar Recebimento!", "error");
            }
                $scope.fecharModalSenhaGerencial();

        } else {
            $scope.model.senhaGerencial = '';
            swal("Senha incorreta!", "", "warning");
        }
    };

}]);