(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory(require("fs"), require("path"), require("os"), require("crypto"), require("constants"), require("stream"), require("phantomjs-prebuilt"), require("util"), require("http"), require("child_process"), require("tty"), require("net"), require("assert"), require("string_decoder"), require("events"), require("zlib"), require("https"));
	else if(typeof define === 'function' && define.amd)
		define(["fs", "path", "os", "crypto", "constants", "stream", "phantomjs-prebuilt", "util", "http", "child_process", "tty", "net", "assert", "string_decoder", "events", "zlib", "https"], factory);
	else if(typeof exports === 'object')
		exports["jsreports"] = factory(require("fs"), require("path"), require("os"), require("crypto"), require("constants"), require("stream"), require("phantomjs-prebuilt"), require("util"), require("http"), require("child_process"), require("tty"), require("net"), require("assert"), require("string_decoder"), require("events"), require("zlib"), require("https"));
	else
		root["jsreports"] = factory(root["fs"], root["path"], root["os"], root["crypto"], root["constants"], root["stream"], root["phantomjs-prebuilt"], root["util"], root["http"], root["child_process"], root["tty"], root["net"], root["assert"], root["string_decoder"], root["events"], root["zlib"], root["https"]);
})(this, function(__WEBPACK_EXTERNAL_MODULE_2__, __WEBPACK_EXTERNAL_MODULE_3__, __WEBPACK_EXTERNAL_MODULE_4__, __WEBPACK_EXTERNAL_MODULE_5__, __WEBPACK_EXTERNAL_MODULE_7__, __WEBPACK_EXTERNAL_MODULE_8__, __WEBPACK_EXTERNAL_MODULE_9__, __WEBPACK_EXTERNAL_MODULE_12__, __WEBPACK_EXTERNAL_MODULE_13__, __WEBPACK_EXTERNAL_MODULE_14__, __WEBPACK_EXTERNAL_MODULE_16__, __WEBPACK_EXTERNAL_MODULE_19__, __WEBPACK_EXTERNAL_MODULE_27__, __WEBPACK_EXTERNAL_MODULE_70__, __WEBPACK_EXTERNAL_MODULE_76__, __WEBPACK_EXTERNAL_MODULE_100__, __WEBPACK_EXTERNAL_MODULE_103__) {
return /******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};

/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {

/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId])
/******/ 			return installedModules[moduleId].exports;

/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			exports: {},
/******/ 			id: moduleId,
/******/ 			loaded: false
/******/ 		};

/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);

/******/ 		// Flag the module as loaded
/******/ 		module.loaded = true;

/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}


/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;

/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;

/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";

/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(0);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/***/ function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(__dirname) {'use strict';

	var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

	var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

	var tmp = __webpack_require__(1);
	var fs = __webpack_require__(2);
	var path = __webpack_require__(3);
	var stream = __webpack_require__(8);
	var phantomPath = __webpack_require__(9).path;
	var driver = __webpack_require__(10);
	var es6compile = __webpack_require__(21).compile;
	var csvparse = __webpack_require__(69);
	var logger = __webpack_require__(72);
	var crypto = void 0;
	try {
	  crypto = __webpack_require__(5);
	} catch (err) {
	  throw new Error('jsreports server module requires Node.js crypto support, but crypto support is disabled in this version of Node.js');
	}

	/** Need to include base and reportbuilder utilities here to run in Node context */
	var ditto = __webpack_require__(109);
	__webpack_require__(119)(ditto);

	var productName = ("jsreports") || 'ditto';

	var clientJS = __webpack_require__(121)("./" + productName + '-all-bundle.js');
	var babelPolyfillJS = __webpack_require__(123);
	var fonts = {
	  'Roboto-Bold.ttf': __webpack_require__(124),
	  'Roboto-BoldItalic.ttf': __webpack_require__(125),
	  'Roboto-Italic.ttf': __webpack_require__(126),
	  'Roboto-Regular.ttf': __webpack_require__(127)
	};

	var maxWorkers = 3;
	var availableWorkers = [];
	var busyWorkers = [];
	var phantomStartPort = 11000;
	var maxTasksPerWorker = 50;
	var lastPruneTime = 0;
	var pruneIntervalMs = 10000;
	var taskTimeoutMs = 60000;
	var pendingTasks = [];
	var startingWorkers = 0;

	var phantomJsParams = {
	  'web-security': 'false',
	  'local-to-remote-url-access': 'true',
	  'ignore-ssl-errors': 'true'
	};

	function unpackFile(str, filePrefix, fileExtension) {
	  var file = tmp.fileSync({ prefix: filePrefix, postfix: fileExtension });
	  fs.appendFileSync(file.name, str);
	  return file.name;
	}

	var clientJSPath = unpackFile(clientJS, 'ditto-client-js-', '.js');
	var babelPolyfillJSPath = unpackFile(babelPolyfillJS, 'ditto-babel-polyfill-js-', '.js');

	var libraryPath = tmp.dirSync().name;
	fs.mkdirSync(path.resolve(libraryPath, 'fonts'));
	Object.keys(fonts).forEach(function (fontFilename) {
	  var wstream = fs.createWriteStream(path.resolve(libraryPath, 'fonts', fontFilename));
	  wstream.write(new Buffer(fonts[fontFilename], 'base64'));
	  wstream.end();
	});

	var singleton = null;
	var BASE_FILE_PATH = __dirname;

	var ServerAPI = function ServerAPI(cfg) {
	  if (singleton) throw new Error('Multiple Server instances not supported.');
	  singleton = this;
	  if (!cfg) cfg = {};
	  this.cfg = cfg;
	  if (cfg.maxWorkers) maxWorkers = cfg.maxWorkers;
	  if (cfg.maxTasksPerWorker) maxTasksPerWorker = cfg.maxTasksPerWorker;
	  if (cfg.libraryPath) libraryPath = cfg.libraryPath;
	  if (cfg.logger) {
	    logger = cfg.logger;
	  } else if (cfg.logLevel) {
	    logger.level = cfg.logLevel.toLowerCase();
	  }
	  logger.debug('Using PhantomJS at', phantomPath);
	  if (cfg.baseFilePath) {
	    BASE_FILE_PATH = cfg.baseFilePath;
	  }
	  this.status = 'running';
	};

	function getPhantomInstance(renderCallback) {
	  var me = this;
	  if (new Date() - lastPruneTime > pruneIntervalMs) {
	    pruneWorkers();
	  }
	  if (availableWorkers.length > 0) {
	    logger.debug('Using available worker');
	    return engageWorker(availableWorkers.pop(), renderCallback);
	  }
	  if (busyWorkers.length + startingWorkers < maxWorkers) {
	    logger.debug('No workers available; creating new worker');
	    return newWorker(function (err, worker) {
	      // Server might have been stopped while PhantomJS was starting
	      if (singleton.status !== 'running') {
	        return disposeWorker(worker);
	      }
	      if (err) return renderCallback(err);
	      return engageWorker(worker, renderCallback);
	    });
	  }
	  // No available workers; queue the task
	  logger.debug('All workers busy; queuing task');
	  pendingTasks.unshift(renderCallback);
	}

	function engageWorker(worker, renderCallback) {
	  logger.debug('Engaging worker ' + worker.name + '...');
	  busyWorkers.push(worker);
	  worker.phantom.createPage(function (err, page, phantom) {
	    if (err) {
	      logger.err('Error creating page: ' + err);
	      disposeWorker(worker);
	      return getPhantomInstance(renderCallback);
	    }
	    logger.debug('Engaged worker ' + worker.name);
	    worker.page = page;
	    renderCallback(null, worker);
	  });
	}

	function releaseWorker(worker) {
	  logger.debug('Releasing worker ' + worker.name);
	  if (worker.page) {
	    worker.page.close();
	  }
	  busyWorkers.splice(busyWorkers.indexOf(worker), 1);
	  if (++worker.taskCount >= maxTasksPerWorker) {
	    disposeWorker(worker);
	  } else {
	    availableWorkers.unshift(worker);
	  }
	  if (pendingTasks.length > 0) {
	    getPhantomInstance(pendingTasks.pop());
	  }
	  logger.debug('Released worker ' + worker.name);
	}

	function removeItemIfExists(arr, item) {
	  var ix = arr.indexOf(item);
	  if (ix >= 0) {
	    arr.splice(ix, 1);
	  }
	}

	function disposeWorker(worker) {
	  logger.debug('Dispose worker ' + worker.name);
	  try {
	    worker.phantom.exit();
	  } catch (e) {}
	  removeItemIfExists(busyWorkers, worker);
	  removeItemIfExists(availableWorkers, worker);
	  logger.debug('Disposed worker ' + worker.name);
	}

	function newWorker(callback) {
	  logger.debug('Creating new worker...');
	  startingWorkers++;
	  var worker = {
	    name: crypto.randomBytes(3).toString('hex'),
	    startTime: new Date(),
	    taskCount: 0
	  };
	  driver.create({
	    path: phantomPath,
	    parameters: phantomJsParams,
	    logger: logger
	  }, function (err, phantom) {
	    startingWorkers--;
	    if (err) return callback(err);
	    phantom.onError = function (msg, trace) {
	      var msgStack = ['PHANTOMJS ERROR: ' + msg];
	      if (trace && trace.length) {
	        msgStack.push('TRACE:');
	        trace.forEach(function (t) {
	          msgStack.push(' -> ' + (t.file || t.sourceURL) + ': ' + t.line + (t.function ? ' (in function ' + t.function + ')' : ''));
	        });
	      }
	      logger.error(msgStack.join('\n'));
	      phantom.exit(1);
	    };
	    phantom.process.stderr.on('data', function (data) {
	      logger.error(data);
	      // TODO handle crash
	    });
	    worker.phantom = phantom;
	    logger.debug('Created worker ' + worker.name);
	    callback(null, worker);
	  });
	}

	function pruneWorkers() {
	  var now = new Date();
	  for (var i = busyWorkers.length - 1; i >= 0; i--) {
	    if (now - busyWorkers[i].startTime > taskTimeoutMs) {
	      disposeWorker(busyWorkers[i]);
	      busyWorkers.splice(i, 1);
	    }
	  }
	}

	function requireLeadingSlash(str) {
	  if (str === null) return str;
	  if (str.indexOf('/') === 0) return str;
	  return '/' + str;
	}

	var makeFilePathAbsolute = function makeFilePathAbsolute(relativePath) {
	  return 'file://' + requireLeadingSlash(path.resolve(BASE_FILE_PATH, relativePath).replace('\\', '/'));
	};

	var SERIALIZED_DATASET_FUNCTIONS = ['data', 'postProcess', 'schema'];

	/**
	 * Renders a ditto report on the server.  Accepts the same arguments as ditto.export on the client.
	 * Returns a Node stream to which the PDF or Excel output will be written.
	 *
	 * Required configuration parameters:
	 * dittoJSPath - path to ditto JavaScript file on the server
	 * dittoCSSPath - path to ditto CSS file on the server
	 *
	 * Optional configuration parameters:
	 * otherCSSPaths - array of additional CSS file paths to load when rendering the report
	 */
	ServerAPI.prototype.export = function (cfg, callback) {
	  if (this.status !== 'running') throw new Error('Server is stopped.');
	  var me = this;
	  if (cfg.datasets) {
	    logger.debug('Process datasets...');
	    cfg.datasets = cfg.datasets.map(function (ds) {
	      var newDs = _extends({}, ds);
	      if ((newDs.format || '').toLowerCase() === "csv") {
	        var records = csvparse(fs.readFileSync(path.resolve(BASE_FILE_PATH, newDs.url)), { columns: true });
	        if (newDs.postProcess) {
	          records = newDs.postProcess(records);
	          delete newDs.postProcess;
	        }
	        newDs.data = records;
	        delete newDs.url;
	        delete newDs.format;
	      } else if (newDs.url) {
	        /** If it's not clearly a remote URL, assume it's a local file and fix the path */
	        if (!/^(http:|https:|file:|\/\/)/ig.test(newDs.url)) {
	          newDs.url = makeFilePathAbsolute(newDs.url);
	        }
	      }
	      SERIALIZED_DATASET_FUNCTIONS.map(function (possibleFnKey) {
	        var possibleFn = newDs[possibleFnKey];
	        if (possibleFn && typeof possibleFn === 'function') {
	          newDs['__ditto_serialized_' + possibleFnKey] = es6compile('(' + possibleFn.toString() + ')').code;
	          delete newDs[possibleFnKey];
	        }
	      });
	      return newDs;
	    });
	    logger.debug('Datasets processed');
	  }

	  if (typeof cfg.imageUrlPrefix === 'undefined') {
	    cfg.imageUrlPrefix = 'file://' + path.resolve(BASE_FILE_PATH) + '/';
	  }

	  getPhantomInstance(function (err, worker) {
	    if (err) return callback(err);
	    var page = worker.page;
	    var content = ['<!DOCTYPE html><html><head>', '<script type="text/javascript" src="file://' + requireLeadingSlash(babelPolyfillJSPath) + '"></script>', '<script type="text/javascript" src="file://' + requireLeadingSlash(clientJSPath) + '"></script>', (me.cfg.otherCSSPaths || []).map(function (cssPath) {
	      return '<link rel="stylesheet" href="file://' + requireLeadingSlash(cssPath) + '" />';
	    }).join(''), '</head><body></body></html>'].join('');
	    page.onError = function (err, trace) {
	      logger.error(err);
	      releaseWorker(worker);
	      if (err && (typeof err === 'undefined' ? 'undefined' : _typeof(err)) === 'object') {
	        return callback(err);
	      }
	      if (err.stack) {
	        return callback(new Error(err.stack));
	      }
	      if (typeof err === 'string') {
	        var stack = [err];
	        if (trace && trace.length) {
	          stack = stack.concat(trace.map(function (t) {
	            return ' at  ' + (t.file || t.sourceURL) + ': ' + t.line + (t.function ? ' (in function ' + t.function + ')' : '');
	          }));
	        }
	        return callback(new Error(stack.join('\n')));
	      }
	      return callback(new Error('Unknown error occurred.'));
	    };
	    page.onConsoleMessage = function (msg, lineNum, sourceId) {
	      logger.debug('CONSOLE: ' + msg + ' (from line #' + lineNum + ' in "' + sourceId + '")');
	    };
	    page.onResourceRequested = function (request) {
	      logger.debug('Request', (request[0].url || '').substr(0, 100));
	    };
	    page.onResourceReceived = function (response) {
	      logger.debug('Received', (response.url || '').substr(0, 100), response.stage, response.status, response.statusText);
	    };
	    page.onResourceError = function (err) {
	      logger.debug('Resource error', err.url, err.errorCode);
	    };
	    page.onLoadFinished = function () {
	      page.onCallback = function (b64) {
	        var buf = new Buffer(b64, 'base64');
	        var outStream = new stream.PassThrough();
	        releaseWorker(worker);
	        callback(null, outStream);
	        outStream.end(buf);
	      };
	      page.evaluate(function (exportCfg, libPath, registeredFonts, productName, SERIALIZED_DATASET_FUNCTIONS) {
	        exportCfg.outputHandler = function (blob) {
	          var blobToBase64 = function blobToBase64(blob, cb) {
	            var reader = new FileReader();
	            reader.onload = function () {
	              var dataUrl = reader.result;
	              var base64 = dataUrl.split(',')[1];
	              cb(base64);
	            };
	            reader.readAsDataURL(blob);
	          };
	          blobToBase64(blob, function (base64Str) {
	            window.callPhantom(base64Str);
	          });
	        };
	        var ditto = window[productName];
	        ditto.imageUrlPrefix = exportCfg.imageUrlPrefix;
	        if (libPath) {
	          ditto.libraryPath = 'file://' + libPath;
	        }
	        registeredFonts.forEach(function (fontArgs) {
	          ditto.registerFont.apply(this, fontArgs);
	        });
	        if (exportCfg.datasets) {
	          exportCfg.datasets.map(function (ds) {
	            SERIALIZED_DATASET_FUNCTIONS.map(function (possibleFnKey) {
	              var serializedKey = '__ditto_serialized_' + possibleFnKey;
	              var serializedFn = ds[serializedKey];
	              if (serializedFn) {
	                ds[possibleFnKey] = eval(serializedFn);
	                delete ds[serializedKey];
	              }
	            });
	          });
	        }
	        ditto.export(exportCfg);
	      }, cfg, requireLeadingSlash(libraryPath), registeredFonts, productName, SERIALIZED_DATASET_FUNCTIONS,
	      // Callback for page.evaluate
	      function (err, result) {
	        if (err) {
	          releaseWorker(worker);
	          return callback(err);
	        }
	      });
	    };
	    page.set('content', content);
	  });
	};

	ServerAPI.prototype.isIdle = function () {
	  return busyWorkers.length === 0 && pendingTasks.length === 0;
	};

	ServerAPI.prototype.stop = function () {
	  if (this.status !== 'running') return;
	  logger.debug('Stopping server...');
	  this.status = 'stopped';
	  busyWorkers.concat(availableWorkers).forEach(function (worker) {
	    disposeWorker(worker);
	  });
	  busyWorkers = [];
	  availableWorkers = [];
	  logger.debug('Server stopped');
	};

	ServerAPI.prototype.start = function () {
	  this.status = 'running';
	};

	var registeredFonts = [];
	/** 
	 * Register a font face (a family, and optionally weight and style) for PDF font embedding.
	 *
	 * @param {string} family - The font family, e.g. Helvetica
	 * @param {string} weight - The font weight, one of "normal" or "bold"
	 * @param {string} style - The font style, one of "normal" or "italic"
	 * @param {string} url - The file:// url of the font's .ttf file
	 */
	ServerAPI.prototype.registerFont = function () {
	  for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
	    args[_key] = arguments[_key];
	  }

	  registeredFonts.push(args);
	};

	ServerAPI.get = function () {
	  return singleton;
	};

	ditto.Server = ServerAPI;

	module.exports = ditto;
	/* WEBPACK VAR INJECTION */}.call(exports, "/"))

/***/ },
/* 1 */
/***/ function(module, exports, __webpack_require__) {

	/*!
	 * Tmp
	 *
	 * Copyright (c) 2011-2015 KARASZI Istvan <github@spam.raszi.hu>
	 *
	 * MIT Licensed
	 */

	/**
	 * Module dependencies.
	 */
	var
	  fs     = __webpack_require__(2),
	  path   = __webpack_require__(3),
	  os     = __webpack_require__(4),
	  crypto = __webpack_require__(5),
	  exists = fs.exists || path.exists,
	  existsSync = fs.existsSync || path.existsSync,
	  tmpDir = __webpack_require__(6),
	  _c     = __webpack_require__(7);


	/**
	 * The working inner variables.
	 */
	var
	  // store the actual TMP directory
	  _TMP = tmpDir(),

	  // the random characters to choose from
	  RANDOM_CHARS = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz',

	  TEMPLATE_PATTERN = /XXXXXX/,

	  DEFAULT_TRIES = 3,

	  CREATE_FLAGS = _c.O_CREAT | _c.O_EXCL | _c.O_RDWR,

	  DIR_MODE = 448 /* 0700 */,
	  FILE_MODE = 384 /* 0600 */,

	  // this will hold the objects need to be removed on exit
	  _removeObjects = [],

	  _gracefulCleanup = false,
	  _uncaughtException = false;

	/**
	 * Random name generator based on crypto.
	 * Adapted from http://blog.tompawlak.org/how-to-generate-random-values-nodejs-javascript
	 *
	 * @param {Number} howMany
	 * @return {String}
	 * @api private
	 */
	function _randomChars(howMany) {
	  var
	    value = [],
	    rnd = null;

	  // make sure that we do not fail because we ran out of entropy
	  try {
	    rnd = crypto.randomBytes(howMany);
	  } catch (e) {
	    rnd = crypto.pseudoRandomBytes(howMany);
	  }

	  for (var i = 0; i < howMany; i++) {
	    value.push(RANDOM_CHARS[rnd[i] % RANDOM_CHARS.length]);
	  }

	  return value.join('');
	}

	/**
	 * Checks whether the `obj` parameter is defined or not.
	 *
	 * @param {Object} obj
	 * @return {Boolean}
	 * @api private
	 */
	function _isUndefined(obj) {
	  return typeof obj === 'undefined';
	}

	/**
	 * Parses the function arguments.
	 *
	 * This function helps to have optional arguments.
	 *
	 * @param {Object} options
	 * @param {Function} callback
	 * @api private
	 */
	function _parseArguments(options, callback) {
	  if (typeof options == 'function') {
	    var
	      tmp = options;
	      options = callback || {};
	      callback = tmp;
	  } else if (typeof options == 'undefined') {
	    options = {};
	  }

	  return [options, callback];
	}

	/**
	 * Generates a new temporary name.
	 *
	 * @param {Object} opts
	 * @returns {String}
	 * @api private
	 */
	function _generateTmpName(opts) {
	  if (opts.name) {
	    return path.join(opts.dir || _TMP, opts.name);
	  }

	  // mkstemps like template
	  if (opts.template) {
	    return opts.template.replace(TEMPLATE_PATTERN, _randomChars(6));
	  }

	  // prefix and postfix
	  var name = [
	    opts.prefix || 'tmp-',
	    process.pid,
	    _randomChars(12),
	    opts.postfix || ''
	  ].join('');

	  return path.join(opts.dir || _TMP, name);
	}

	/**
	 * Gets a temporary file name.
	 *
	 * @param {Object} options
	 * @param {Function} callback
	 * @api private
	 */
	function _getTmpName(options, callback) {
	  var
	    args = _parseArguments(options, callback),
	    opts = args[0],
	    cb = args[1],
	    tries = opts.tries || DEFAULT_TRIES;

	  if (isNaN(tries) || tries < 0)
	    return cb(new Error('Invalid tries'));

	  if (opts.template && !opts.template.match(TEMPLATE_PATTERN))
	    return cb(new Error('Invalid template provided'));

	  (function _getUniqueName() {
	    var name = _generateTmpName(opts);

	    // check whether the path exists then retry if needed
	    exists(name, function _pathExists(pathExists) {
	      if (pathExists) {
	        if (tries-- > 0) return _getUniqueName();

	        return cb(new Error('Could not get a unique tmp filename, max tries reached ' + name));
	      }

	      cb(null, name);
	    });
	  }());
	}

	/**
	 * Synchronous version of _getTmpName.
	 *
	 * @param {Object} options
	 * @returns {String}
	 * @api private
	 */
	function _getTmpNameSync(options) {
	  var
	    args = _parseArguments(options),
	    opts = args[0],
	    tries = opts.tries || DEFAULT_TRIES;

	  if (isNaN(tries) || tries < 0)
	    throw new Error('Invalid tries');

	  if (opts.template && !opts.template.match(TEMPLATE_PATTERN))
	    throw new Error('Invalid template provided');

	  do {
	    var name = _generateTmpName(opts);
	    if (!existsSync(name)) {
	      return name;
	    }
	  } while (tries-- > 0);

	  throw new Error('Could not get a unique tmp filename, max tries reached');
	}

	/**
	 * Creates and opens a temporary file.
	 *
	 * @param {Object} options
	 * @param {Function} callback
	 * @api public
	 */
	function _createTmpFile(options, callback) {
	  var
	    args = _parseArguments(options, callback),
	    opts = args[0],
	    cb = args[1];

	    opts.postfix = (_isUndefined(opts.postfix)) ? '.tmp' : opts.postfix;

	  // gets a temporary filename
	  _getTmpName(opts, function _tmpNameCreated(err, name) {
	    if (err) return cb(err);

	    // create and open the file
	    fs.open(name, CREATE_FLAGS, opts.mode || FILE_MODE, function _fileCreated(err, fd) {
	      if (err) return cb(err);

	      cb(null, name, fd, _prepareTmpFileRemoveCallback(name, fd, opts));
	    });
	  });
	}

	/**
	 * Synchronous version of _createTmpFile.
	 *
	 * @param {Object} options
	 * @returns {Object} object consists of name, fd and removeCallback
	 * @api private
	 */
	function _createTmpFileSync(options) {
	  var
	    args = _parseArguments(options),
	    opts = args[0];

	    opts.postfix = opts.postfix || '.tmp';

	  var name = _getTmpNameSync(opts);
	  var fd = fs.openSync(name, CREATE_FLAGS, opts.mode || FILE_MODE);

	  return {
	    name : name,
	    fd : fd,
	    removeCallback : _prepareTmpFileRemoveCallback(name, fd, opts)
	  };
	}

	/**
	 * Removes files and folders in a directory recursively.
	 *
	 * @param {String} root
	 * @api private
	 */
	function _rmdirRecursiveSync(root) {
	  var dirs = [root];

	  do {
	    var
	      dir = dirs.pop(),
	      deferred = false,
	      files = fs.readdirSync(dir);

	    for (var i = 0, length = files.length; i < length; i++) {
	      var
	        file = path.join(dir, files[i]),
	        stat = fs.lstatSync(file); // lstat so we don't recurse into symlinked directories

	      if (stat.isDirectory()) {
	        if (!deferred) {
	          deferred = true;
	          dirs.push(dir);
	        }  
	        dirs.push(file);
	      } else {
	        fs.unlinkSync(file);
	      }
	    }

	    if (!deferred) {
	      fs.rmdirSync(dir);
	    }
	  } while (dirs.length !== 0);
	}

	/**
	 * Creates a temporary directory.
	 *
	 * @param {Object} options
	 * @param {Function} callback
	 * @api public
	 */
	function _createTmpDir(options, callback) {
	  var
	    args = _parseArguments(options, callback),
	    opts = args[0],
	    cb = args[1];

	  // gets a temporary filename
	  _getTmpName(opts, function _tmpNameCreated(err, name) {
	    if (err) return cb(err);

	    // create the directory
	    fs.mkdir(name, opts.mode || DIR_MODE, function _dirCreated(err) {
	      if (err) return cb(err);

	      cb(null, name, _prepareTmpDirRemoveCallback(name, opts));
	    });
	  });
	}

	/**
	 * Synchronous version of _createTmpDir.
	 *
	 * @param {Object} options
	 * @returns {Object} object consists of name and removeCallback
	 * @api private
	 */
	function _createTmpDirSync(options) {
	  var
	    args = _parseArguments(options),
	    opts = args[0];

	  var name = _getTmpNameSync(opts);
	  fs.mkdirSync(name, opts.mode || DIR_MODE);

	  return {
	    name : name,
	    removeCallback : _prepareTmpDirRemoveCallback(name, opts)
	  };
	}

	/**
	 * Prepares the callback for removal of the temporary file.
	 *
	 * @param {String} name
	 * @param {int} fd
	 * @param {Object} opts
	 * @api private
	 * @returns {Function} the callback
	 */
	function _prepareTmpFileRemoveCallback(name, fd, opts) {
	  var removeCallback = _prepareRemoveCallback(function _removeCallback(fdPath) {
	    try {
	      fs.closeSync(fdPath[0]);
	    }
	    catch (e) {
	      // under some node/windows related circumstances, a temporary file 
	      // may have not be created as expected or the file was already closed
	      // by the user, in which case we will simply ignore the error
	      if (e.errno != -_c.EBADF && e.errno != -c.ENOENT) {
	        // reraise any unanticipated error
	        throw e;
	      }
	    }
	    fs.unlinkSync(fdPath[1]);
	  }, [fd, name]);

	  if (!opts.keep) {
	    _removeObjects.unshift(removeCallback);
	  }

	  return removeCallback;
	}

	/**
	 * Prepares the callback for removal of the temporary directory.
	 *
	 * @param {String} name
	 * @param {Object} opts
	 * @returns {Function} the callback
	 * @api private
	 */
	function _prepareTmpDirRemoveCallback(name, opts) {
	  var removeFunction = opts.unsafeCleanup ? _rmdirRecursiveSync : fs.rmdirSync.bind(fs);
	  var removeCallback = _prepareRemoveCallback(removeFunction, name);

	  if (!opts.keep) {
	    _removeObjects.unshift(removeCallback);
	  }

	  return removeCallback;
	}

	/**
	 * Creates a guarded function wrapping the removeFunction call.
	 *
	 * @param {Function} removeFunction
	 * @param {Object} arg
	 * @returns {Function}
	 * @api private
	 */
	function _prepareRemoveCallback(removeFunction, arg) {
	  var called = false;

	  return function _cleanupCallback() {
	    if (called) return;

	    var index = _removeObjects.indexOf(removeFunction);
	    if (index >= 0) {
	      _removeObjects.splice(index, 1);
	    }

	    called = true;
	    removeFunction(arg);
	  };
	}

	/**
	 * The garbage collector.
	 *
	 * @api private
	 */
	function _garbageCollector() {
	  if (_uncaughtException && !_gracefulCleanup) {
	    return;
	  }

	  for (var i = 0, length = _removeObjects.length; i < length; i++) {
	    try {
	      _removeObjects[i].call(null);
	    } catch (e) {
	      // already removed?
	    }
	  }
	}

	function _setGracefulCleanup() {
	  _gracefulCleanup = true;
	}

	var version = process.versions.node.split('.').map(function (value) {
	  return parseInt(value, 10);
	});

	if (version[0] === 0 && (version[1] < 9 || version[1] === 9 && version[2] < 5)) {
	  process.addListener('uncaughtException', function _uncaughtExceptionThrown(err) {
	    _uncaughtException = true;
	    _garbageCollector();

	    throw err;
	  });
	}

	process.addListener('exit', function _exit(code) {
	  if (code) _uncaughtException = true;
	  _garbageCollector();
	});

	// exporting all the needed methods
	module.exports.tmpdir = _TMP;
	module.exports.dir = _createTmpDir;
	module.exports.dirSync = _createTmpDirSync;
	module.exports.file = _createTmpFile;
	module.exports.fileSync = _createTmpFileSync;
	module.exports.tmpName = _getTmpName;
	module.exports.tmpNameSync = _getTmpNameSync;
	module.exports.setGracefulCleanup = _setGracefulCleanup;


/***/ },
/* 2 */
/***/ function(module, exports) {

	module.exports = __WEBPACK_EXTERNAL_MODULE_2__;

/***/ },
/* 3 */
/***/ function(module, exports) {

	module.exports = __WEBPACK_EXTERNAL_MODULE_3__;

/***/ },
/* 4 */
/***/ function(module, exports) {

	module.exports = require("os");

/***/ },
/* 5 */
/***/ function(module, exports) {

	module.exports = require("crypto");

/***/ },
/* 6 */
/***/ function(module, exports) {

	'use strict';
	var isWindows = process.platform === 'win32';
	var trailingSlashRe = isWindows ? /[^:]\\$/ : /.\/$/;

	// https://github.com/nodejs/io.js/blob/3e7a14381497a3b73dda68d05b5130563cdab420/lib/os.js#L25-L43
	module.exports = function () {
		var path;

		if (isWindows) {
			path = process.env.TEMP ||
				process.env.TMP ||
				(process.env.SystemRoot || process.env.windir) + '\\temp';
		} else {
			path = process.env.TMPDIR ||
				process.env.TMP ||
				process.env.TEMP ||
				'/tmp';
		}

		if (trailingSlashRe.test(path)) {
			path = path.slice(0, -1);
		}

		return path;
	};


/***/ },
/* 7 */
/***/ function(module, exports) {

	module.exports = require("constants");

/***/ },
/* 8 */
/***/ function(module, exports) {

	module.exports = require("stream");

/***/ },
/* 9 */
/***/ function(module, exports) {

	module.exports = __WEBPACK_EXTERNAL_MODULE_9__;

/***/ },
/* 10 */
/***/ function(module, exports, __webpack_require__) {

	/*global document*/

	'use strict';


	var HeadlessError   = __webpack_require__(11);
	var http            = __webpack_require__(13);
	var spawn           = __webpack_require__(14).spawn;
	var exec            = __webpack_require__(14).exec;
	var util            = __webpack_require__(12);
	var path            = __webpack_require__(3);
	var debug           = __webpack_require__(15);

	/** Added by jsreports - must bundle raw content in Webpack bundle, can't rely on file being present at runtime */
	var tmpFile         = __webpack_require__(1);
	var fs              = __webpack_require__(2);
	var bridgeJs        = __webpack_require__(20);
	/** End jsreports changes */

	var POLL_INTERVAL   = process.env.POLL_INTERVAL || 500;

	var logger = {
	  debug: debug('node-phantom-simple:debug'),
	  warn: debug('node-phantom-simple:warn'),
	  error: debug('node-phantom-simple:error')
	};

	var queue = function (worker) {
	  var _q = [];
	  var running = false;
	  var q = {
	    push: function (obj) {
	      _q.push(obj);
	      q.process();
	    },
	    process: function () {
	      if (running || _q.length === 0) { return; }
	      running = true;
	      var cb = function () {
	        running = false;
	        q.process();
	      };
	      var task = _q.shift();
	      worker(task, cb);
	    }
	  };

	  return q;
	};

	function callbackOrDummy (callback, poll_func) {
	  if (!callback) { return function () {}; }

	  if (poll_func) {
	    return function () {
	      var args = Array.prototype.slice.call(arguments);

	      poll_func(function (err) {
	        if (err) {
	          // We could send back the original arguments,
	          // but I'm assuming that this error is better.
	          callback(err);
	          return;
	        }

	        callback.apply(null, args);
	      });
	    };
	  }

	  return callback;
	}

	function unwrapArray (arr) {
	  return arr && arr.length === 1 ? arr[0] : arr;
	}

	function wrapArray(arr) {
	  // Ensure that arr is an Array
	  return (arr instanceof Array) ? arr : [ arr ];
	}

	function clone(obj) {
	  if (obj === null || typeof obj !== 'object') {
	    return obj;
	  }

	  var copy = {};

	  for (var attr in obj) {
	    if (obj.hasOwnProperty(attr)) {
	      copy[attr] = clone(obj[attr]);
	    }
	  }

	  return copy;
	}


	var pageEvaluateDeprecatedFn = util.deprecate(function () {}, "Deprecated 'page.evaluate(fn, callback, args...)' syntax - use 'page.evaluate(fn, args..., callback)' instead");
	var createDeprecatedFn = util.deprecate(function () {}, "Deprecated '.create(callback, options)' syntax - use '.create(options, callback)' instead");
	var pageWaitForSelectorDeprecatedFn = util.deprecate(function () {}, "Deprecated 'page.waitForSelector(selector, callback, timeout)' syntax - use 'page.waitForSelector(selector, timeout, callback)' instead");
	var phantomPathDeprecatedFn = util.deprecate(function () {}, "Deprecated 'phantomPath' option - use 'path' instead");


	exports.create = function (options, callback) {
	  if (callback && Object.prototype.toString.call(options) === '[object Function]') {
	    createDeprecatedFn();

	    var tmp = options;

	    options = callback;
	    callback = tmp;
	  }

	  if (!callback) {
	    callback = options;
	    options = {};
	  }

	  if (options.phantomPath) {
	    phantomPathDeprecatedFn();
	    options.path = options.phantomPath;
	  }

	  if (!options.path) {
	    options.path = 'phantomjs';
	  }

	  if (typeof options.parameters === 'undefined') { options.parameters = {}; }

	  function spawnPhantom (callback) {
	    var args = [];

	    if (Array.isArray(options.parameters)) {
	      args = options.parameters;
	    } else {
	      Object.keys(options.parameters).forEach(function (parm) {
	        args.push('--' + parm + '=' + options.parameters[parm]);
	      });
	    }

	    /** Added by jsreports - can't bundle bridge.js as separate file, must generate it here */
	    var bridgeJsFile = tmpFile.fileSync({ prefix: 'jsreports-phantom-bridge-', postfix: '.js' });
	    fs.appendFileSync(bridgeJsFile.name, bridgeJs);
	    args.push(bridgeJsFile.name);
	    /** End jsreports changes */

	    var phantom = spawn(options.path, args);

	    phantom.once('error', function (err) {
	      callback(err);
	    });

	    phantom.stderr.on('data', function (data) {
	      if (options.ignoreErrorPattern && options.ignoreErrorPattern.exec(data)) {
	        return;
	      }
	      logger.error('' + data);
	    });

	    var immediateExit = function(exitCode) {
	      return callback(new HeadlessError('Phantom immediately exited with: ' + exitCode));
	    };

	    phantom.once('exit', immediateExit);

	    // Wait for 'Ready' line
	    phantom.stdout.once('data', function (data) {
	      // setup normal listener now
	      phantom.stdout.on('data', function (data) {
	        logger.debug('' + data);
	      });

	      var matches = data.toString().match(/Ready \[(\d+)\] \[(.+?)\]/);

	      if (!matches) {
	        phantom.kill();
	        callback(new HeadlessError('Unexpected output from PhantomJS: ' + data));
	        return;
	      }

	      phantom.removeListener('exit', immediateExit);

	      var phantom_port = matches[2].indexOf(':') === -1 ? matches[2] : matches[2].split(':')[1];

	      phantom_port = parseInt(phantom_port, 0);

	      if (phantom_port !== 0) {
	        callback(null, phantom, phantom_port);
	        return;
	      }

	      var phantom_pid = parseInt(matches[1], 0);

	      // Now need to figure out what port it's listening on - since
	      // Phantom is busted and can't tell us this we need to use lsof on mac, and netstat on Linux
	      // Note that if phantom could tell you the port it ends up listening
	      // on we wouldn't need to do this - server.port returns 0 when you ask
	      // for port 0 (i.e. random free port). If they ever fix that this will
	      // become much simpler
	      var platform = __webpack_require__(4).platform();
	      var cmd = null;

	      switch (platform) {
	        case 'linux':
	          // Modern distros usually have `iproute2` instead of `net-tools`.
	          // Try `ss` first, then fallback to `netstat`.
	          //
	          // Note:
	          //
	          // - `grep "[,=]%d,"` contains variation, because `ss` output differs
	          //    between versions.
	          // - `ss` can exist but fail in some env (#76).
	          //
	          cmd = 'ss -nlp | grep "[,=]%d," || netstat -nlp | grep "[[:space:]]%d/"';
	          break;

	        case 'darwin':
	          cmd = 'lsof -np %d | grep LISTEN';
	          break;

	        case 'win32':
	          cmd = 'netstat -ano | findstr /R "\\<%d\\>"';
	          break;

	        case 'cygwin':
	          cmd = 'netstat -ano | grep %d';
	          break;

	        case 'freebsd':
	          cmd = 'sockstat | grep %d';
	          break;

	        default:
	          phantom.kill();
	          callback(new HeadlessError('Your OS is not supported yet. Tell us how to get the listening port based on PID'));
	          return;
	      }

	      // We do this twice - first to get ports this process is listening on
	      // and again to get ports phantom is listening on. This is to work
	      // around this bug in libuv: https://github.com/joyent/libuv/issues/962
	      // - this is only necessary when using cluster, but it's here regardless
	      var my_pid_command = cmd.replace(/%d/g, process.pid);

	      exec(my_pid_command, function (err, stdout /*, stderr*/) {
	        if (err !== null) {
	          // This can happen if grep finds no matching lines, so ignore it.
	          stdout = '';
	        }

	        var re = /(?:127\.\d{1,3}\.\d{1,3}\.\d{1,3}|localhost):(\d+)/ig, match;
	        var ports = [];

	        while ((match = re.exec(stdout)) !== null) {
	          ports.push(match[1]);
	        }

	        var phantom_pid_command = cmd.replace(/%d/g, phantom_pid);

	        exec(phantom_pid_command, function (err, stdout /*, stderr*/) {
	          if (err !== null) {
	            phantom.kill();
	            callback(new HeadlessError('Error executing command to extract phantom ports: ' + err));
	            return;
	          }

	          var port;

	          while ((match = re.exec(stdout)) !== null) {
	            if (ports.indexOf(match[1]) === -1) {
	              port = match[1];
	            }
	          }

	          if (!port) {
	            phantom.kill();
	            callback(new HeadlessError('Error extracting port from: ' + stdout));
	            return;
	          }

	          callback(null, phantom, port);
	        });
	      });
	    });
	  }

	  spawnPhantom(function (err, phantom, port) {
	    if (err) {
	      callback(err);
	      return;
	    }

	    var pages = {};

	    var setup_new_page = function (id) {
	      var methods = [
	        'addCookie', 'childFramesCount', 'childFramesName', 'clearCookies', 'close',
	        'currentFrameName', 'deleteCookie', 'evaluateJavaScript',
	        'evaluateAsync', 'getPage', 'go', 'goBack', 'goForward', 'includeJs',
	        'injectJs', 'open', 'openUrl', 'release', 'reload', 'render', 'renderBase64',
	        'sendEvent', 'setContent', 'stop', 'switchToFocusedFrame', 'switchToFrame',
	        'switchToFrame', 'switchToChildFrame', 'switchToChildFrame', 'switchToMainFrame',
	        'switchToParentFrame', 'uploadFile', 'clearMemoryCache'
	      ];

	      var page = {
	        setFn: function (name, fn, cb) {
	          request_queue.push([ [ id, 'setFunction', name, fn.toString() ], callbackOrDummy(cb, poll_func) ]);
	        },

	        get: function (name, cb) {
	          request_queue.push([ [ id, 'getProperty', name ], callbackOrDummy(cb, poll_func) ]);
	        },

	        set: function (name, val, cb) {
	          // Special case for `paperSize.header.contents` property.
	          // Property should be wrapped by `phantom.callback` in bridge.
	          if (name === 'paperSize.header.contents' && val) {
	            val = String(val);
	          } else if (name === 'paperSize.header' && val.contents) {
	            val = clone(val);
	            val.contents = String(val.contents);
	          } else if (name === 'paperSize' && val.header && val.header.contents) {
	            val = clone(val);
	            val.header.contents = String(val.header.contents);
	          }

	          // Special case for `paperSize.footer.contents` property.
	          // Property should be wrapped by `phantom.callback` in bridge.
	          if (name === 'paperSize.footer.contents' && val) {
	            val = String(val);
	          } else if (name === 'paperSize.footer' && val.contents) {
	            val = clone(val);
	            val.contents = String(val.contents);
	          } else if (name === 'paperSize' && val.footer && val.footer.contents) {
	            val = clone(val);
	            val.footer.contents = String(val.footer.contents);
	          }

	          request_queue.push([ [ id, 'setProperty', name, val ], callbackOrDummy(cb, poll_func) ]);
	        },

	        evaluate: function (fn, cb) {
	          var extra_args = [];

	          if (arguments.length > 2) {
	            if (Object.prototype.toString.call(arguments[arguments.length - 1]) === '[object Function]') {
	              extra_args = Array.prototype.slice.call(arguments, 1, -1);
	              cb = arguments[arguments.length - 1];
	            } else {
	              pageEvaluateDeprecatedFn();
	              extra_args = Array.prototype.slice.call(arguments, 2);
	            }
	          }

	          request_queue.push([ [ id, 'evaluate', fn.toString() ].concat(extra_args), callbackOrDummy(cb, poll_func) ]);
	        },

	        waitForSelector: function (selector, timeout, cb) {
	          if (cb && Object.prototype.toString.call(timeout) === '[object Function]') {
	            pageWaitForSelectorDeprecatedFn();

	            var tmp = cb;

	            cb = timeout;
	            timeout = tmp;
	          }

	          if (!cb) {
	            cb = timeout;
	            // Default timeout is 10 sec
	            timeout = 10000;
	          }

	          var startTime = Date.now();
	          var timeoutInterval = 150;
	          // if evaluate succeeds, invokes callback w/ true, if timeout,
	          // invokes w/ false, otherwise just exits
	          var testForSelector = function () {
	            var elapsedTime = Date.now() - startTime;

	            if (elapsedTime > timeout) {
	              cb(new HeadlessError('Timeout waiting for selector: ' + selector));
	              return;
	            }

	            /*eslint-disable handle-callback-err*/
	            page.evaluate(function (selector) {
	              return document.querySelectorAll(selector).length;
	            }, selector, function (err, result) {
	              if (result > 0) { // selector found
	                cb();
	              } else {
	                setTimeout(testForSelector, timeoutInterval);
	              }
	            });
	          };

	          setTimeout(testForSelector, timeoutInterval);
	        }
	      };

	      methods.forEach(function (method) {
	        page[method] = function () {
	          var all_args = Array.prototype.slice.call(arguments);
	          var callback = null;

	          if (all_args.length > 0 && typeof all_args[all_args.length - 1] === 'function') {
	            callback = all_args.pop();
	          }

	          var req_params = [ id, method ];

	          request_queue.push([ req_params.concat(all_args), callbackOrDummy(callback, poll_func) ]);
	        };
	      });

	      pages[id] = page;

	      return page;
	    };

	    var poll_func = setup_long_poll(phantom, port, pages, setup_new_page);

	    var request_queue = queue(function (paramarr, next) {
	      var params = paramarr[0];
	      var callback = paramarr[1];
	      var page = params[0];
	      var method = params[1];
	      var args = params.slice(2);

	      var http_opts = {
	        hostname: 'localhost',
	        port: port,
	        path: '/',
	        method: 'POST'
	      };

	      phantom.POSTING = true;

	      var req = http.request(http_opts, function (res) {
	        var err = res.statusCode === 500 ? true : false;
	        var data = '';

	        res.setEncoding('utf8');

	        res.on('data', function (chunk) {
	          data += chunk;
	        });

	        res.on('end', function () {
	          phantom.POSTING = false;

	          if (!data) {
	            // If method is exit - response may be empty, because server could be stopped while sending
	            if (method === 'exit') {
	              next();
	              callback();
	              return;
	            }

	            next();
	            callback(new HeadlessError('No response body for page.' + method + '()'));
	            return;
	          }

	          var results;

	          try {
	            results = JSON.parse(data).data;
	          } catch (error) {
	            // If method is exit - response may be broken, because server could be stopped while sending
	            if (method === 'exit') {
	              next();
	              callback();
	              return;
	            }

	            next();
	            callback(error);
	            return;
	          }

	          if (err) {
	            next();
	            callback(results);
	            return;
	          }

	          if (method === 'createPage') {
	            var id = results.page_id;
	            var page = setup_new_page(id);

	            next();
	            callback(null, page);
	            return;
	          }

	          // Not createPage - just run the callback
	          next();
	          callback(null, results);
	        });
	      });

	      req.on('error', function (err) {
	        // If phantom already killed by `exit` command - callback without error
	        if (phantom.killed) {
	          next();
	          callback();
	          return;
	        }

	        logger.warn('Request() error evaluating ' + method + '() call: ' + err);
	        callback(new HeadlessError('Request() error evaluating ' + method + '() call: ' + err));
	      });

	      req.setHeader('Content-Type', 'application/json');

	      var json = JSON.stringify({ page: page, method: method, args: args });

	      req.setHeader('Content-Length', Buffer.byteLength(json));
	      req.write(json);
	      req.end();
	    });

	    var proxy = {
	      process: phantom,

	      setProxy: function (ip, port, proxyType, user, password, callback) {
	        request_queue.push([ [ 0, 'setProxy', ip, port, proxyType, user, password ], callbackOrDummy(callback, poll_func) ]);
	      },

	      createPage: function (callback) {
	        request_queue.push([ [ 0, 'createPage' ], callbackOrDummy(callback, poll_func) ]);
	      },

	      injectJs: function (filename, callback) {
	        request_queue.push([ [ 0, 'injectJs', filename ], callbackOrDummy(callback, poll_func) ]);
	      },

	      addCookie: function (cookie, callback) {
	        request_queue.push([ [ 0, 'addCookie', cookie ], callbackOrDummy(callback, poll_func) ]);
	      },

	      clearCookies: function (callback) {
	        request_queue.push([ [ 0, 'clearCookies' ], callbackOrDummy(callback, poll_func) ]);
	      },

	      deleteCookie: function (cookie, callback) {
	        request_queue.push([ [ 0, 'deleteCookie', cookie ], callbackOrDummy(callback, poll_func) ]);
	      },

	      set : function (property, value, callback) {
	        request_queue.push([ [ 0, 'setProperty', property, value ], callbackOrDummy(callback, poll_func) ]);
	      },

	      get : function (property, callback) {
	        request_queue.push([ [ 0, 'getProperty', property ], callbackOrDummy(callback, poll_func) ]);
	      },

	      exit: function (callback) {
	        phantom.kill('SIGTERM');

	        // In case of SlimerJS `kill` will close only wrapper of xulrunner.
	        // We should send `exit` command to process.
	        request_queue.push([ [ 0, 'exit', 0 ], callbackOrDummy(callback) ]);
	      },

	      on: function () {
	        phantom.on.apply(phantom, arguments);
	      }
	    };

	    callback(null, proxy);
	  });
	};


	function setup_long_poll (phantom, port, pages, setup_new_page) {
	  var http_opts = {
	    hostname: 'localhost',
	    port: port,
	    path: '/',
	    method: 'GET'
	  };

	  var dead = false;
	  phantom.once('exit', function () { dead = true; });

	  var poll_func = function (cb) {
	    if (dead) {
	      cb(new HeadlessError('Phantom Process died'));
	      return;
	    }

	    if (phantom.POSTING) {
	      cb();
	      return;
	    }

	    var req = http.get(http_opts, function(res) {
	      res.setEncoding('utf8');
	      var data = '';
	      res.on('data', function (chunk) {
	        data += chunk;
	      });
	      res.on('end', function () {
	        var results;

	        if (dead) {
	          cb(new HeadlessError('Phantom Process died'));
	          return;
	        }

	        try {
	          results = JSON.parse(data).data;
	        } catch (err) {
	          logger.warn('Error parsing JSON from phantom: ' + err);
	          logger.warn('Data from phantom was: ' + data);
	          cb(new HeadlessError('Error parsing JSON from phantom: ' + err
	            + '\nData from phantom was: ' + data));
	          return;
	        }

	        results.forEach(function (r) {
	          var new_page, callbackFunc, cb;

	          if (r.page_id) {
	            if (pages[r.page_id] && r.callback === 'onPageCreated') {
	              new_page = setup_new_page(r.args[0]);

	              if (pages[r.page_id].onPageCreated) {
	                pages[r.page_id].onPageCreated(new_page);
	              }

	            } else if (pages[r.page_id] && pages[r.page_id][r.callback]) {
	              callbackFunc = pages[r.page_id][r.callback];

	              if (callbackFunc.length > 1) {
	                // We use `apply` if the function is expecting multiple args
	                callbackFunc.apply(pages[r.page_id], wrapArray(r.args));
	              } else {
	                // Old `call` behaviour is deprecated
	                callbackFunc.call(pages[r.page_id], unwrapArray(r.args));
	              }
	            }
	          } else {
	            cb = callbackOrDummy(phantom[r.callback]);
	            cb.apply(phantom, r.args);
	          }
	        });

	        cb();
	      });
	    });

	    req.on('error', function (err) {
	      if (dead || phantom.killed) { return; }

	      if (err.code === 'ECONNRESET' || err.code === 'ECONNREFUSED') {
	        try {
	          phantom.kill();
	        } catch (e) {
	          // we don't care
	        }
	        dead = true;
	        cb(new HeadlessError('Phantom Process died'));
	        return;
	      }

	      logger.warn('Poll Request error: ' + err);
	    });
	  };

	  var repeater = function () {
	    // If phantom already killed - stop repeat timer
	    if (dead || phantom.killed) {
	      return;
	    }

	    setTimeout(function () {
	      poll_func(repeater);
	    }, POLL_INTERVAL);
	  };

	  repeater();

	  return poll_func;
	}


/***/ },
/* 11 */
/***/ function(module, exports, __webpack_require__) {

	// Error class
	//
	// Based on:
	// http://stackoverflow.com/questions/8458984/how-do-i-get-a-correct-backtrace-for-a-custom-error-class-in-nodejs
	//
	'use strict';


	var inherits = __webpack_require__(12).inherits;


	function HeadlessError(message) {
	  // Super constructor
	  Error.call(this);

	  // Super helper method to include stack trace in error object
	  Error.captureStackTrace(this, this.constructor);

	  // Set our function’s name as error name
	  this.name = this.constructor.name;

	  // Set the error message
	  this.message = message;
	}


	// Inherit from Error
	inherits(HeadlessError, Error);


	module.exports = HeadlessError;


/***/ },
/* 12 */
/***/ function(module, exports) {

	module.exports = require("util");

/***/ },
/* 13 */
/***/ function(module, exports) {

	module.exports = require("http");

/***/ },
/* 14 */
/***/ function(module, exports) {

	module.exports = __WEBPACK_EXTERNAL_MODULE_14__;

/***/ },
/* 15 */
/***/ function(module, exports, __webpack_require__) {

	
	/**
	 * Module dependencies.
	 */

	var tty = __webpack_require__(16);
	var util = __webpack_require__(12);

	/**
	 * This is the Node.js implementation of `debug()`.
	 *
	 * Expose `debug()` as the module.
	 */

	exports = module.exports = __webpack_require__(17);
	exports.log = log;
	exports.formatArgs = formatArgs;
	exports.save = save;
	exports.load = load;
	exports.useColors = useColors;

	/**
	 * Colors.
	 */

	exports.colors = [6, 2, 3, 4, 5, 1];

	/**
	 * The file descriptor to write the `debug()` calls to.
	 * Set the `DEBUG_FD` env variable to override with another value. i.e.:
	 *
	 *   $ DEBUG_FD=3 node script.js 3>debug.log
	 */

	var fd = parseInt(process.env.DEBUG_FD, 10) || 2;
	var stream = 1 === fd ? process.stdout :
	             2 === fd ? process.stderr :
	             createWritableStdioStream(fd);

	/**
	 * Is stdout a TTY? Colored output is enabled when `true`.
	 */

	function useColors() {
	  var debugColors = (process.env.DEBUG_COLORS || '').trim().toLowerCase();
	  if (0 === debugColors.length) {
	    return tty.isatty(fd);
	  } else {
	    return '0' !== debugColors
	        && 'no' !== debugColors
	        && 'false' !== debugColors
	        && 'disabled' !== debugColors;
	  }
	}

	/**
	 * Map %o to `util.inspect()`, since Node doesn't do that out of the box.
	 */

	var inspect = (4 === util.inspect.length ?
	  // node <= 0.8.x
	  function (v, colors) {
	    return util.inspect(v, void 0, void 0, colors);
	  } :
	  // node > 0.8.x
	  function (v, colors) {
	    return util.inspect(v, { colors: colors });
	  }
	);

	exports.formatters.o = function(v) {
	  return inspect(v, this.useColors)
	    .replace(/\s*\n\s*/g, ' ');
	};

	/**
	 * Adds ANSI color escape codes if enabled.
	 *
	 * @api public
	 */

	function formatArgs() {
	  var args = arguments;
	  var useColors = this.useColors;
	  var name = this.namespace;

	  if (useColors) {
	    var c = this.color;

	    args[0] = '  \u001b[3' + c + ';1m' + name + ' '
	      + '\u001b[0m'
	      + args[0] + '\u001b[3' + c + 'm'
	      + ' +' + exports.humanize(this.diff) + '\u001b[0m';
	  } else {
	    args[0] = new Date().toUTCString()
	      + ' ' + name + ' ' + args[0];
	  }
	  return args;
	}

	/**
	 * Invokes `console.error()` with the specified arguments.
	 */

	function log() {
	  return stream.write(util.format.apply(this, arguments) + '\n');
	}

	/**
	 * Save `namespaces`.
	 *
	 * @param {String} namespaces
	 * @api private
	 */

	function save(namespaces) {
	  if (null == namespaces) {
	    // If you set a process.env field to null or undefined, it gets cast to the
	    // string 'null' or 'undefined'. Just delete instead.
	    delete process.env.DEBUG;
	  } else {
	    process.env.DEBUG = namespaces;
	  }
	}

	/**
	 * Load `namespaces`.
	 *
	 * @return {String} returns the previously persisted debug modes
	 * @api private
	 */

	function load() {
	  return process.env.DEBUG;
	}

	/**
	 * Copied from `node/src/node.js`.
	 *
	 * XXX: It's lame that node doesn't expose this API out-of-the-box. It also
	 * relies on the undocumented `tty_wrap.guessHandleType()` which is also lame.
	 */

	function createWritableStdioStream (fd) {
	  var stream;
	  var tty_wrap = process.binding('tty_wrap');

	  // Note stream._type is used for test-module-load-list.js

	  switch (tty_wrap.guessHandleType(fd)) {
	    case 'TTY':
	      stream = new tty.WriteStream(fd);
	      stream._type = 'tty';

	      // Hack to have stream not keep the event loop alive.
	      // See https://github.com/joyent/node/issues/1726
	      if (stream._handle && stream._handle.unref) {
	        stream._handle.unref();
	      }
	      break;

	    case 'FILE':
	      var fs = __webpack_require__(2);
	      stream = new fs.SyncWriteStream(fd, { autoClose: false });
	      stream._type = 'fs';
	      break;

	    case 'PIPE':
	    case 'TCP':
	      var net = __webpack_require__(19);
	      stream = new net.Socket({
	        fd: fd,
	        readable: false,
	        writable: true
	      });

	      // FIXME Should probably have an option in net.Socket to create a
	      // stream from an existing fd which is writable only. But for now
	      // we'll just add this hack and set the `readable` member to false.
	      // Test: ./node test/fixtures/echo.js < /etc/passwd
	      stream.readable = false;
	      stream.read = null;
	      stream._type = 'pipe';

	      // FIXME Hack to have stream not keep the event loop alive.
	      // See https://github.com/joyent/node/issues/1726
	      if (stream._handle && stream._handle.unref) {
	        stream._handle.unref();
	      }
	      break;

	    default:
	      // Probably an error on in uv_guess_handle()
	      throw new Error('Implement me. Unknown stream file type!');
	  }

	  // For supporting legacy API we put the FD here.
	  stream.fd = fd;

	  stream._isStdio = true;

	  return stream;
	}

	/**
	 * Enable namespaces listed in `process.env.DEBUG` initially.
	 */

	exports.enable(load());


/***/ },
/* 16 */
/***/ function(module, exports) {

	module.exports = require("tty");

/***/ },
/* 17 */
/***/ function(module, exports, __webpack_require__) {

	
	/**
	 * This is the common logic for both the Node.js and web browser
	 * implementations of `debug()`.
	 *
	 * Expose `debug()` as the module.
	 */

	exports = module.exports = debug;
	exports.coerce = coerce;
	exports.disable = disable;
	exports.enable = enable;
	exports.enabled = enabled;
	exports.humanize = __webpack_require__(18);

	/**
	 * The currently active debug mode names, and names to skip.
	 */

	exports.names = [];
	exports.skips = [];

	/**
	 * Map of special "%n" handling functions, for the debug "format" argument.
	 *
	 * Valid key names are a single, lowercased letter, i.e. "n".
	 */

	exports.formatters = {};

	/**
	 * Previously assigned color.
	 */

	var prevColor = 0;

	/**
	 * Previous log timestamp.
	 */

	var prevTime;

	/**
	 * Select a color.
	 *
	 * @return {Number}
	 * @api private
	 */

	function selectColor() {
	  return exports.colors[prevColor++ % exports.colors.length];
	}

	/**
	 * Create a debugger with the given `namespace`.
	 *
	 * @param {String} namespace
	 * @return {Function}
	 * @api public
	 */

	function debug(namespace) {

	  // define the `disabled` version
	  function disabled() {
	  }
	  disabled.enabled = false;

	  // define the `enabled` version
	  function enabled() {

	    var self = enabled;

	    // set `diff` timestamp
	    var curr = +new Date();
	    var ms = curr - (prevTime || curr);
	    self.diff = ms;
	    self.prev = prevTime;
	    self.curr = curr;
	    prevTime = curr;

	    // add the `color` if not set
	    if (null == self.useColors) self.useColors = exports.useColors();
	    if (null == self.color && self.useColors) self.color = selectColor();

	    var args = Array.prototype.slice.call(arguments);

	    args[0] = exports.coerce(args[0]);

	    if ('string' !== typeof args[0]) {
	      // anything else let's inspect with %o
	      args = ['%o'].concat(args);
	    }

	    // apply any `formatters` transformations
	    var index = 0;
	    args[0] = args[0].replace(/%([a-z%])/g, function(match, format) {
	      // if we encounter an escaped % then don't increase the array index
	      if (match === '%%') return match;
	      index++;
	      var formatter = exports.formatters[format];
	      if ('function' === typeof formatter) {
	        var val = args[index];
	        match = formatter.call(self, val);

	        // now we need to remove `args[index]` since it's inlined in the `format`
	        args.splice(index, 1);
	        index--;
	      }
	      return match;
	    });

	    if ('function' === typeof exports.formatArgs) {
	      args = exports.formatArgs.apply(self, args);
	    }
	    var logFn = enabled.log || exports.log || console.log.bind(console);
	    logFn.apply(self, args);
	  }
	  enabled.enabled = true;

	  var fn = exports.enabled(namespace) ? enabled : disabled;

	  fn.namespace = namespace;

	  return fn;
	}

	/**
	 * Enables a debug mode by namespaces. This can include modes
	 * separated by a colon and wildcards.
	 *
	 * @param {String} namespaces
	 * @api public
	 */

	function enable(namespaces) {
	  exports.save(namespaces);

	  var split = (namespaces || '').split(/[\s,]+/);
	  var len = split.length;

	  for (var i = 0; i < len; i++) {
	    if (!split[i]) continue; // ignore empty strings
	    namespaces = split[i].replace(/\*/g, '.*?');
	    if (namespaces[0] === '-') {
	      exports.skips.push(new RegExp('^' + namespaces.substr(1) + '$'));
	    } else {
	      exports.names.push(new RegExp('^' + namespaces + '$'));
	    }
	  }
	}

	/**
	 * Disable debug output.
	 *
	 * @api public
	 */

	function disable() {
	  exports.enable('');
	}

	/**
	 * Returns true if the given mode name is enabled, false otherwise.
	 *
	 * @param {String} name
	 * @return {Boolean}
	 * @api public
	 */

	function enabled(name) {
	  var i, len;
	  for (i = 0, len = exports.skips.length; i < len; i++) {
	    if (exports.skips[i].test(name)) {
	      return false;
	    }
	  }
	  for (i = 0, len = exports.names.length; i < len; i++) {
	    if (exports.names[i].test(name)) {
	      return true;
	    }
	  }
	  return false;
	}

	/**
	 * Coerce `val`.
	 *
	 * @param {Mixed} val
	 * @return {Mixed}
	 * @api private
	 */

	function coerce(val) {
	  if (val instanceof Error) return val.stack || val.message;
	  return val;
	}


/***/ },
/* 18 */
/***/ function(module, exports) {

	/**
	 * Helpers.
	 */

	var s = 1000;
	var m = s * 60;
	var h = m * 60;
	var d = h * 24;
	var y = d * 365.25;

	/**
	 * Parse or format the given `val`.
	 *
	 * Options:
	 *
	 *  - `long` verbose formatting [false]
	 *
	 * @param {String|Number} val
	 * @param {Object} options
	 * @return {String|Number}
	 * @api public
	 */

	module.exports = function(val, options){
	  options = options || {};
	  if ('string' == typeof val) return parse(val);
	  return options.long
	    ? long(val)
	    : short(val);
	};

	/**
	 * Parse the given `str` and return milliseconds.
	 *
	 * @param {String} str
	 * @return {Number}
	 * @api private
	 */

	function parse(str) {
	  str = '' + str;
	  if (str.length > 10000) return;
	  var match = /^((?:\d+)?\.?\d+) *(milliseconds?|msecs?|ms|seconds?|secs?|s|minutes?|mins?|m|hours?|hrs?|h|days?|d|years?|yrs?|y)?$/i.exec(str);
	  if (!match) return;
	  var n = parseFloat(match[1]);
	  var type = (match[2] || 'ms').toLowerCase();
	  switch (type) {
	    case 'years':
	    case 'year':
	    case 'yrs':
	    case 'yr':
	    case 'y':
	      return n * y;
	    case 'days':
	    case 'day':
	    case 'd':
	      return n * d;
	    case 'hours':
	    case 'hour':
	    case 'hrs':
	    case 'hr':
	    case 'h':
	      return n * h;
	    case 'minutes':
	    case 'minute':
	    case 'mins':
	    case 'min':
	    case 'm':
	      return n * m;
	    case 'seconds':
	    case 'second':
	    case 'secs':
	    case 'sec':
	    case 's':
	      return n * s;
	    case 'milliseconds':
	    case 'millisecond':
	    case 'msecs':
	    case 'msec':
	    case 'ms':
	      return n;
	  }
	}

	/**
	 * Short format for `ms`.
	 *
	 * @param {Number} ms
	 * @return {String}
	 * @api private
	 */

	function short(ms) {
	  if (ms >= d) return Math.round(ms / d) + 'd';
	  if (ms >= h) return Math.round(ms / h) + 'h';
	  if (ms >= m) return Math.round(ms / m) + 'm';
	  if (ms >= s) return Math.round(ms / s) + 's';
	  return ms + 'ms';
	}

	/**
	 * Long format for `ms`.
	 *
	 * @param {Number} ms
	 * @return {String}
	 * @api private
	 */

	function long(ms) {
	  return plural(ms, d, 'day')
	    || plural(ms, h, 'hour')
	    || plural(ms, m, 'minute')
	    || plural(ms, s, 'second')
	    || ms + ' ms';
	}

	/**
	 * Pluralization helper.
	 */

	function plural(ms, n, name) {
	  if (ms < n) return;
	  if (ms < n * 1.5) return Math.floor(ms / n) + ' ' + name;
	  return Math.ceil(ms / n) + ' ' + name + 's';
	}


/***/ },
/* 19 */
/***/ function(module, exports) {

	module.exports = require("net");

/***/ },
/* 20 */
/***/ function(module, exports) {

	module.exports = "/*global phantom*/\n/*eslint-disable strict*/\nvar webpage     = require('webpage');\nvar webserver   = require('webserver').create();\nvar system      = require('system');\n\nvar pages  = {};\nvar page_id = 1;\n\nvar callback_stack = [];\n\n// Max interval without requests from master process\nvar WATCHDOG_TIMEOUT = 30000;\n\nphantom.onError = function (msg, trace) {\n  var msgStack = [ 'PHANTOM ERROR: ' + msg ];\n\n  if (trace && trace.length) {\n    msgStack.push('TRACE:');\n    trace.forEach(function(t) {\n      msgStack.push(' -> ' + (t.file || t.sourceURL) + ': ' + t.line + (t.function ? ' (in function ' + t.function + ')' : ''));\n    });\n  }\n\n  system.stderr.writeLine(msgStack.join('\\n'));\n  phantom.exit(1);\n};\n\nvar watchdog_timer_id = null;\n\n// Kill phantom if parent disconnected\nfunction watchdog_clear() {\n  clearTimeout(watchdog_timer_id);\n\n  watchdog_timer_id = setTimeout(function () {\n    phantom.exit(0);\n  }, WATCHDOG_TIMEOUT);\n}\n\nfunction lookup(obj, key, value) {\n  // key can be either string or an array of strings\n  if (!(typeof obj === 'object')) {\n    return null;\n  }\n  if (typeof key === 'string') {\n    key = key.split('.');\n  }\n\n  if (!Array.isArray(key)) {\n    return null;\n  }\n\n  if (arguments.length > 2) {\n    if (key.length === 1) {\n      obj[key[0]] = value;\n    } else {\n      obj[key[0]] = lookup(typeof obj[key[0]] === 'object' ? obj[key[0]] : {}, key.slice(1), value);\n    }\n    return obj;\n  }\n\n  if (key.length === 1) {\n    return obj[key[0]];\n  }\n  return lookup(obj[key[0]], key.slice(1));\n}\n\nfunction page_open (res, page, args) {\n  page.open.apply(page, args.concat(function (success) {\n    res.statusCode = 200;\n    res.setHeader('Content-Type', 'application/json');\n    res.write(JSON.stringify({ data: success }));\n    res.close();\n  }));\n}\n\nfunction include_js (res, page, args) {\n  res.statusCode = 200;\n  res.setHeader('Content-Type', 'application/json');\n  res.write(JSON.stringify({ data: 'success' }));\n\n  page.includeJs.apply(page, args.concat(function () {\n    try {\n      res.write('');\n      res.close();\n    } catch (e) {\n      if (!/cannot call function of deleted QObject/.test(e)) { // Ignore this error\n        page.onError(e);\n      }\n    }\n  }));\n}\n\nwebserver.listen('127.0.0.1:0', function (req, res) {\n  // Update watchdog timer on every request\n  watchdog_clear();\n\n  if (req.method === 'GET') {\n    res.statusCode = 200;\n    res.setHeader('Content-Type', 'application/json');\n    res.write(JSON.stringify({ data: callback_stack }));\n    callback_stack = [];\n    res.close();\n  } else if (req.method === 'POST') {\n    var request, error, output;\n\n    try {\n      request = JSON.parse(req.post);\n    } catch (err) {\n      error = err;\n    }\n\n    if (!error) {\n      if (request.page) {\n        if (request.method === 'open') { // special case this as it's the only one with a callback\n          return page_open(res, pages[request.page], request.args);\n        } else if (request.method === 'includeJs') {\n          return include_js(res, pages[request.page], request.args);\n        }\n        try {\n          output = pages[request.page][request.method].apply(pages[request.page], request.args);\n        } catch (err) {\n          error = err;\n        }\n      } else {\n        try {\n          output = global_methods[request.method].apply(global_methods, request.args);\n        } catch (err) {\n          error = err;\n        }\n      }\n    }\n\n    res.setHeader('Content-Type', 'application/json');\n    if (error) {\n      res.statusCode = 500;\n      res.write(JSON.stringify(error));\n    } else {\n      res.statusCode = 200;\n      res.write(JSON.stringify({ data: output }));\n    }\n    res.close();\n  } else {\n    throw 'Unknown request type!';\n  }\n});\n\nvar callbacks = [\n  'onAlert', 'onCallback', 'onClosing', 'onConfirm', 'onConsoleMessage', 'onError', 'onFilePicker',\n  'onInitialized', 'onLoadFinished', 'onLoadStarted', 'onNavigationRequested',\n  'onPrompt', 'onResourceRequested', 'onResourceReceived', 'onResourceTimeout', 'onResourceError', 'onUrlChanged',\n  // SlimerJS only\n  'onAuthPrompt'\n];\n\nfunction setup_callbacks (id, page) {\n  callbacks.forEach(function (cb) {\n    page[cb] = function (parm) {\n      var args = Array.prototype.slice.call(arguments);\n\n      if ((cb === 'onResourceRequested') && (parm.url.indexOf('data:image') === 0)) {\n        return;\n      }\n\n      if (cb === 'onClosing') { args = []; }\n      callback_stack.push({ 'page_id': id, 'callback': cb, 'args': args });\n    };\n  });\n  // Special case this\n  page.onPageCreated = function (page) {\n    var new_id = setup_page(page);\n    callback_stack.push({ 'page_id': id, 'callback': 'onPageCreated', 'args': [ new_id ] });\n  };\n}\n\nfunction setup_page (page) {\n  var id    = page_id++;\n  page.getProperty = function (prop) {\n    return lookup(page, prop);\n  };\n  page.setProperty = function (prop, val) {\n    // Special case for `paperSize.header.contents` property.\n    if (prop === 'paperSize.header.contents' && val) {\n      val = phantom.callback(eval('(' + val + ')'));\n    } else if (prop === 'paperSize.header' && val.contents) {\n      val.contents = phantom.callback(eval('(' + val.contents + ')'));\n    } else if (prop === 'paperSize' && val.header && val.header.contents) {\n      val.header.contents = phantom.callback(eval('(' + val.header.contents + ')'));\n    }\n\n    // Special case for `paperSize.footer.contents` property.\n    if (prop === 'paperSize.footer.contents' && val) {\n      val = phantom.callback(eval('(' + val + ')'));\n    } else if (prop === 'paperSize.footer' && val.contents) {\n      val.contents = phantom.callback(eval('(' + val.contents + ')'));\n    } else if (prop === 'paperSize' && val.footer && val.footer.contents) {\n      val.footer.contents = phantom.callback(eval('(' + val.footer.contents + ')'));\n    }\n\n    lookup(page, prop, val);\n    return true;\n  };\n  page.setFunction = function (name, fn) {\n    page[name] = eval('(' + fn + ')');\n    return true;\n  };\n  pages[id] = page;\n  setup_callbacks(id, page);\n  return id;\n}\n\nvar global_methods = {\n  setProxy: function (ip, port, proxyType, user, password) {\n    return phantom.setProxy(ip, port, proxyType, user, password);\n  },\n  createPage: function () {\n    var page  = webpage.create();\n    var id = setup_page(page);\n    return { page_id: id };\n  },\n\n  injectJs: function (filename) {\n    return phantom.injectJs(filename);\n  },\n\n  exit: function (code) {\n    return phantom.exit(code);\n  },\n\n  addCookie: function (cookie) {\n    return phantom.addCookie(cookie);\n  },\n\n  clearCookies: function () {\n    return phantom.clearCookies();\n  },\n\n  deleteCookie: function (name) {\n    return phantom.deleteCookie(name);\n  },\n\n  getProperty: function (prop) {\n    return lookup(phantom, prop);\n  },\n\n  setProperty: function (prop, value) {\n    lookup(phantom, prop, value);\n    return true;\n  }\n};\n\n// Start watchdog timer\nwatchdog_clear();\n\n/*eslint-disable no-console*/\nconsole.log('Ready [' + system.pid + '] [' + webserver.port + ']');\n"

/***/ },
/* 21 */
/***/ function(module, exports, __webpack_require__) {

	/* jshint node:true, undef:true, unused:true */
	var through = __webpack_require__(22);
	var recast = __webpack_require__(23);
	var types = recast.types;

	var Visitor = __webpack_require__(61);

	/**
	 * Transform an Esprima AST generated from ES6 by replacing all
	 * ArrowFunctionExpression usages with the non-shorthand FunctionExpression.
	 *
	 * NOTE: The argument may be modified by this function. To prevent modification
	 * of your AST, pass a copy instead of a direct reference:
	 *
	 *   // instead of transform(ast), pass a copy
	 *   transform(JSON.parse(JSON.stringify(ast));
	 *
	 * @param {Object} ast
	 * @return {Object}
	 */
	function transform(ast) {
	  return types.visit(ast, Visitor.visitor);
	}

	/**
	 * Transform JavaScript written using ES6 by replacing all arrow function
	 * usages with the non-shorthand "function" keyword.
	 *
	 *   compile('() => 42'); // 'function() { return 42; };'
	 *
	 * @param {string} source
	 * @param {object} mapOptions
	 * @return {string}
	 */
	function compile(source, mapOptions) {
	  mapOptions = mapOptions || {};

	  var recastOptions = {
	    sourceFileName: mapOptions.sourceFileName,
	    sourceMapName: mapOptions.sourceMapName
	  };

	  var ast = recast.parse(source, recastOptions);
	  return recast.print(transform(ast), recastOptions);
	}

	module.exports = function() {
	  var data = '';
	  return through(write, end);

	  function write(buf) { data += buf; }
	  function end() {
	      this.queue(module.exports.compile(data).code);
	      this.queue(null);
	  }
	};

	module.exports.compile = compile;
	module.exports.transform = transform;


/***/ },
/* 22 */
/***/ function(module, exports, __webpack_require__) {

	var Stream = __webpack_require__(8)

	// through
	//
	// a stream that does nothing but re-emit the input.
	// useful for aggregating a series of changing but not ending streams into one stream)

	exports = module.exports = through
	through.through = through

	//create a readable writable stream.

	function through (write, end, opts) {
	  write = write || function (data) { this.queue(data) }
	  end = end || function () { this.queue(null) }

	  var ended = false, destroyed = false, buffer = [], _ended = false
	  var stream = new Stream()
	  stream.readable = stream.writable = true
	  stream.paused = false

	//  stream.autoPause   = !(opts && opts.autoPause   === false)
	  stream.autoDestroy = !(opts && opts.autoDestroy === false)

	  stream.write = function (data) {
	    write.call(this, data)
	    return !stream.paused
	  }

	  function drain() {
	    while(buffer.length && !stream.paused) {
	      var data = buffer.shift()
	      if(null === data)
	        return stream.emit('end')
	      else
	        stream.emit('data', data)
	    }
	  }

	  stream.queue = stream.push = function (data) {
	//    console.error(ended)
	    if(_ended) return stream
	    if(data === null) _ended = true
	    buffer.push(data)
	    drain()
	    return stream
	  }

	  //this will be registered as the first 'end' listener
	  //must call destroy next tick, to make sure we're after any
	  //stream piped from here.
	  //this is only a problem if end is not emitted synchronously.
	  //a nicer way to do this is to make sure this is the last listener for 'end'

	  stream.on('end', function () {
	    stream.readable = false
	    if(!stream.writable && stream.autoDestroy)
	      process.nextTick(function () {
	        stream.destroy()
	      })
	  })

	  function _end () {
	    stream.writable = false
	    end.call(stream)
	    if(!stream.readable && stream.autoDestroy)
	      stream.destroy()
	  }

	  stream.end = function (data) {
	    if(ended) return
	    ended = true
	    if(arguments.length) stream.write(data)
	    _end() // will emit or queue
	    return stream
	  }

	  stream.destroy = function () {
	    if(destroyed) return
	    destroyed = true
	    ended = true
	    buffer.length = 0
	    stream.writable = stream.readable = false
	    stream.emit('close')
	    return stream
	  }

	  stream.pause = function () {
	    if(stream.paused) return
	    stream.paused = true
	    return stream
	  }

	  stream.resume = function () {
	    if(stream.paused) {
	      stream.paused = false
	      stream.emit('resume')
	    }
	    drain()
	    //may have become paused again,
	    //as drain emits 'data'.
	    if(!stream.paused)
	      stream.emit('drain')
	    return stream
	  }
	  return stream
	}



/***/ },
/* 23 */
/***/ function(module, exports, __webpack_require__) {

	var types = __webpack_require__(24);
	var parse = __webpack_require__(40).parse;
	var Printer = __webpack_require__(60).Printer;

	function print(node, options) {
	    return new Printer(options).print(node);
	}

	function prettyPrint(node, options) {
	    return new Printer(options).printGenerically(node);
	}

	function run(transformer, options) {
	    return runFile(process.argv[2], transformer, options);
	}

	function runFile(path, transformer, options) {
	    __webpack_require__(2).readFile(path, "utf-8", function(err, code) {
	        if (err) {
	            console.error(err);
	            return;
	        }

	        runString(code, transformer, options);
	    });
	}

	function defaultWriteback(output) {
	    process.stdout.write(output);
	}

	function runString(code, transformer, options) {
	    var writeback = options && options.writeback || defaultWriteback;
	    transformer(parse(code, options), function(node) {
	        writeback(print(node, options).code);
	    });
	}

	Object.defineProperties(exports, {
	    /**
	     * Parse a string of code into an augmented syntax tree suitable for
	     * arbitrary modification and reprinting.
	     */
	    parse: {
	        enumerable: true,
	        value: parse
	    },

	    /**
	     * Traverse and potentially modify an abstract syntax tree using a
	     * convenient visitor syntax:
	     *
	     *   recast.visit(ast, {
	     *     names: [],
	     *     visitIdentifier: function(path) {
	     *       var node = path.value;
	     *       this.visitor.names.push(node.name);
	     *       this.traverse(path);
	     *     }
	     *   });
	     */
	    visit: {
	        enumerable: true,
	        value: types.visit
	    },

	    /**
	     * Reprint a modified syntax tree using as much of the original source
	     * code as possible.
	     */
	    print: {
	        enumerable: true,
	        value: print
	    },

	    /**
	     * Print without attempting to reuse any original source code.
	     */
	    prettyPrint: {
	        enumerable: false,
	        value: prettyPrint
	    },

	    /**
	     * Customized version of require("ast-types").
	     */
	    types: {
	        enumerable: false,
	        value: types
	    },

	    /**
	     * Convenient command-line interface (see e.g. example/add-braces).
	     */
	    run: {
	        enumerable: false,
	        value: run
	    }
	});


/***/ },
/* 24 */
/***/ function(module, exports, __webpack_require__) {

	var types = __webpack_require__(25);
	var def = types.Type.def;

	def("File")
	    .bases("Node")
	    .build("program")
	    .field("program", def("Program"));

	types.finalize();

	module.exports = types;


/***/ },
/* 25 */
/***/ function(module, exports, __webpack_require__) {

	var types = __webpack_require__(26);

	// This core module of AST types captures ES5 as it is parsed today by
	// git://github.com/ariya/esprima.git#master.
	__webpack_require__(28);

	// Feel free to add to or remove from this list of extension modules to
	// configure the precise type hierarchy that you need.
	__webpack_require__(30);
	__webpack_require__(31);
	__webpack_require__(32);
	__webpack_require__(33);
	__webpack_require__(34);

	types.finalize();

	exports.Type = types.Type;
	exports.builtInTypes = types.builtInTypes;
	exports.namedTypes = types.namedTypes;
	exports.builders = types.builders;
	exports.defineMethod = types.defineMethod;
	exports.getFieldNames = types.getFieldNames;
	exports.getFieldValue = types.getFieldValue;
	exports.eachField = types.eachField;
	exports.someField = types.someField;
	exports.getSupertypeNames = types.getSupertypeNames;
	exports.astNodesAreEquivalent = __webpack_require__(35);
	exports.finalize = types.finalize;
	exports.NodePath = __webpack_require__(36);
	exports.PathVisitor = __webpack_require__(39);
	exports.visit = exports.PathVisitor.visit;


/***/ },
/* 26 */
/***/ function(module, exports, __webpack_require__) {

	var assert = __webpack_require__(27);
	var Ap = Array.prototype;
	var slice = Ap.slice;
	var map = Ap.map;
	var each = Ap.forEach;
	var Op = Object.prototype;
	var objToStr = Op.toString;
	var funObjStr = objToStr.call(function(){});
	var strObjStr = objToStr.call("");
	var hasOwn = Op.hasOwnProperty;

	// A type is an object with a .check method that takes a value and returns
	// true or false according to whether the value matches the type.

	function Type(check, name) {
	    var self = this;
	    assert.ok(self instanceof Type, self);

	    // Unfortunately we can't elegantly reuse isFunction and isString,
	    // here, because this code is executed while defining those types.
	    assert.strictEqual(objToStr.call(check), funObjStr,
	                       check + " is not a function");

	    // The `name` parameter can be either a function or a string.
	    var nameObjStr = objToStr.call(name);
	    assert.ok(nameObjStr === funObjStr ||
	              nameObjStr === strObjStr,
	              name + " is neither a function nor a string");

	    Object.defineProperties(self, {
	        name: { value: name },
	        check: {
	            value: function(value, deep) {
	                var result = check.call(self, value, deep);
	                if (!result && deep && objToStr.call(deep) === funObjStr)
	                    deep(self, value);
	                return result;
	            }
	        }
	    });
	}

	var Tp = Type.prototype;

	// Throughout this file we use Object.defineProperty to prevent
	// redefinition of exported properties.
	exports.Type = Type;

	// Like .check, except that failure triggers an AssertionError.
	Tp.assert = function(value, deep) {
	    if (!this.check(value, deep)) {
	        var str = shallowStringify(value);
	        assert.ok(false, str + " does not match type " + this);
	        return false;
	    }
	    return true;
	};

	function shallowStringify(value) {
	    if (isObject.check(value))
	        return "{" + Object.keys(value).map(function(key) {
	            return key + ": " + value[key];
	        }).join(", ") + "}";

	    if (isArray.check(value))
	        return "[" + value.map(shallowStringify).join(", ") + "]";

	    return JSON.stringify(value);
	}

	Tp.toString = function() {
	    var name = this.name;

	    if (isString.check(name))
	        return name;

	    if (isFunction.check(name))
	        return name.call(this) + "";

	    return name + " type";
	};

	var builtInTypes = {};
	exports.builtInTypes = builtInTypes;

	function defBuiltInType(example, name) {
	    var objStr = objToStr.call(example);

	    Object.defineProperty(builtInTypes, name, {
	        enumerable: true,
	        value: new Type(function(value) {
	            return objToStr.call(value) === objStr;
	        }, name)
	    });

	    return builtInTypes[name];
	}

	// These types check the underlying [[Class]] attribute of the given
	// value, rather than using the problematic typeof operator. Note however
	// that no subtyping is considered; so, for instance, isObject.check
	// returns false for [], /./, new Date, and null.
	var isString = defBuiltInType("", "string");
	var isFunction = defBuiltInType(function(){}, "function");
	var isArray = defBuiltInType([], "array");
	var isObject = defBuiltInType({}, "object");
	var isRegExp = defBuiltInType(/./, "RegExp");
	var isDate = defBuiltInType(new Date, "Date");
	var isNumber = defBuiltInType(3, "number");
	var isBoolean = defBuiltInType(true, "boolean");
	var isNull = defBuiltInType(null, "null");
	var isUndefined = defBuiltInType(void 0, "undefined");

	// There are a number of idiomatic ways of expressing types, so this
	// function serves to coerce them all to actual Type objects. Note that
	// providing the name argument is not necessary in most cases.
	function toType(from, name) {
	    // The toType function should of course be idempotent.
	    if (from instanceof Type)
	        return from;

	    // The Def type is used as a helper for constructing compound
	    // interface types for AST nodes.
	    if (from instanceof Def)
	        return from.type;

	    // Support [ElemType] syntax.
	    if (isArray.check(from))
	        return Type.fromArray(from);

	    // Support { someField: FieldType, ... } syntax.
	    if (isObject.check(from))
	        return Type.fromObject(from);

	    // If isFunction.check(from), assume that from is a binary predicate
	    // function we can use to define the type.
	    if (isFunction.check(from))
	        return new Type(from, name);

	    // As a last resort, toType returns a type that matches any value that
	    // is === from. This is primarily useful for literal values like
	    // toType(null), but it has the additional advantage of allowing
	    // toType to be a total function.
	    return new Type(function(value) {
	        return value === from;
	    }, isUndefined.check(name) ? function() {
	        return from + "";
	    } : name);
	}

	// Returns a type that matches the given value iff any of type1, type2,
	// etc. match the value.
	Type.or = function(/* type1, type2, ... */) {
	    var types = [];
	    var len = arguments.length;
	    for (var i = 0; i < len; ++i)
	        types.push(toType(arguments[i]));

	    return new Type(function(value, deep) {
	        for (var i = 0; i < len; ++i)
	            if (types[i].check(value, deep))
	                return true;
	        return false;
	    }, function() {
	        return types.join(" | ");
	    });
	};

	Type.fromArray = function(arr) {
	    assert.ok(isArray.check(arr));
	    assert.strictEqual(
	        arr.length, 1,
	        "only one element type is permitted for typed arrays");
	    return toType(arr[0]).arrayOf();
	};

	Tp.arrayOf = function() {
	    var elemType = this;
	    return new Type(function(value, deep) {
	        return isArray.check(value) && value.every(function(elem) {
	            return elemType.check(elem, deep);
	        });
	    }, function() {
	        return "[" + elemType + "]";
	    });
	};

	Type.fromObject = function(obj) {
	    var fields = Object.keys(obj).map(function(name) {
	        return new Field(name, obj[name]);
	    });

	    return new Type(function(value, deep) {
	        return isObject.check(value) && fields.every(function(field) {
	            return field.type.check(value[field.name], deep);
	        });
	    }, function() {
	        return "{ " + fields.join(", ") + " }";
	    });
	};

	function Field(name, type, defaultFn, hidden) {
	    var self = this;

	    assert.ok(self instanceof Field);
	    isString.assert(name);

	    type = toType(type);

	    var properties = {
	        name: { value: name },
	        type: { value: type },
	        hidden: { value: !!hidden }
	    };

	    if (isFunction.check(defaultFn)) {
	        properties.defaultFn = { value: defaultFn };
	    }

	    Object.defineProperties(self, properties);
	}

	var Fp = Field.prototype;

	Fp.toString = function() {
	    return JSON.stringify(this.name) + ": " + this.type;
	};

	Fp.getValue = function(obj) {
	    var value = obj[this.name];

	    if (!isUndefined.check(value))
	        return value;

	    if (this.defaultFn)
	        value = this.defaultFn.call(obj);

	    return value;
	};

	// Define a type whose name is registered in a namespace (the defCache) so
	// that future definitions will return the same type given the same name.
	// In particular, this system allows for circular and forward definitions.
	// The Def object d returned from Type.def may be used to configure the
	// type d.type by calling methods such as d.bases, d.build, and d.field.
	Type.def = function(typeName) {
	    isString.assert(typeName);
	    return hasOwn.call(defCache, typeName)
	        ? defCache[typeName]
	        : defCache[typeName] = new Def(typeName);
	};

	// In order to return the same Def instance every time Type.def is called
	// with a particular name, those instances need to be stored in a cache.
	var defCache = Object.create(null);

	function Def(typeName) {
	    var self = this;
	    assert.ok(self instanceof Def);

	    Object.defineProperties(self, {
	        typeName: { value: typeName },
	        baseNames: { value: [] },
	        ownFields: { value: Object.create(null) },

	        // These two are populated during finalization.
	        allSupertypes: { value: Object.create(null) }, // Includes own typeName.
	        supertypeList: { value: [] }, // Linear inheritance hierarchy.
	        allFields: { value: Object.create(null) }, // Includes inherited fields.
	        fieldNames: { value: [] }, // Non-hidden keys of allFields.

	        type: {
	            value: new Type(function(value, deep) {
	                return self.check(value, deep);
	            }, typeName)
	        }
	    });
	}

	Def.fromValue = function(value) {
	    if (value && typeof value === "object") {
	        var type = value.type;
	        if (typeof type === "string" &&
	            hasOwn.call(defCache, type)) {
	            var d = defCache[type];
	            if (d.finalized) {
	                return d;
	            }
	        }
	    }

	    return null;
	};

	var Dp = Def.prototype;

	Dp.isSupertypeOf = function(that) {
	    if (that instanceof Def) {
	        assert.strictEqual(this.finalized, true);
	        assert.strictEqual(that.finalized, true);
	        return hasOwn.call(that.allSupertypes, this.typeName);
	    } else {
	        assert.ok(false, that + " is not a Def");
	    }
	};

	// Note that the list returned by this function is a copy of the internal
	// supertypeList, *without* the typeName itself as the first element.
	exports.getSupertypeNames = function(typeName) {
	    assert.ok(hasOwn.call(defCache, typeName));
	    var d = defCache[typeName];
	    assert.strictEqual(d.finalized, true);
	    return d.supertypeList.slice(1);
	};

	// Returns an object mapping from every known type in the defCache to the
	// most specific supertype whose name is an own property of the candidates
	// object.
	exports.computeSupertypeLookupTable = function(candidates) {
	    var table = {};
	    var typeNames = Object.keys(defCache);
	    var typeNameCount = typeNames.length;

	    for (var i = 0; i < typeNameCount; ++i) {
	        var typeName = typeNames[i];
	        var d = defCache[typeName];
	        assert.strictEqual(d.finalized, true);
	        for (var j = 0; j < d.supertypeList.length; ++j) {
	            var superTypeName = d.supertypeList[j];
	            if (hasOwn.call(candidates, superTypeName)) {
	                table[typeName] = superTypeName;
	                break;
	            }
	        }
	    }

	    return table;
	};

	Dp.checkAllFields = function(value, deep) {
	    var allFields = this.allFields;
	    assert.strictEqual(this.finalized, true);

	    function checkFieldByName(name) {
	        var field = allFields[name];
	        var type = field.type;
	        var child = field.getValue(value);
	        return type.check(child, deep);
	    }

	    return isObject.check(value)
	        && Object.keys(allFields).every(checkFieldByName);
	};

	Dp.check = function(value, deep) {
	    assert.strictEqual(
	        this.finalized, true,
	        "prematurely checking unfinalized type " + this.typeName);

	    // A Def type can only match an object value.
	    if (!isObject.check(value))
	        return false;

	    var vDef = Def.fromValue(value);
	    if (!vDef) {
	        // If we couldn't infer the Def associated with the given value,
	        // and we expected it to be a SourceLocation or a Position, it was
	        // probably just missing a "type" field (because Esprima does not
	        // assign a type property to such nodes). Be optimistic and let
	        // this.checkAllFields make the final decision.
	        if (this.typeName === "SourceLocation" ||
	            this.typeName === "Position") {
	            return this.checkAllFields(value, deep);
	        }

	        // Calling this.checkAllFields for any other type of node is both
	        // bad for performance and way too forgiving.
	        return false;
	    }

	    // If checking deeply and vDef === this, then we only need to call
	    // checkAllFields once. Calling checkAllFields is too strict when deep
	    // is false, because then we only care about this.isSupertypeOf(vDef).
	    if (deep && vDef === this)
	        return this.checkAllFields(value, deep);

	    // In most cases we rely exclusively on isSupertypeOf to make O(1)
	    // subtyping determinations. This suffices in most situations outside
	    // of unit tests, since interface conformance is checked whenever new
	    // instances are created using builder functions.
	    if (!this.isSupertypeOf(vDef))
	        return false;

	    // The exception is when deep is true; then, we recursively check all
	    // fields.
	    if (!deep)
	        return true;

	    // Use the more specific Def (vDef) to perform the deep check, but
	    // shallow-check fields defined by the less specific Def (this).
	    return vDef.checkAllFields(value, deep)
	        && this.checkAllFields(value, false);
	};

	Dp.bases = function() {
	    var bases = this.baseNames;

	    assert.strictEqual(this.finalized, false);

	    each.call(arguments, function(baseName) {
	        isString.assert(baseName);

	        // This indexOf lookup may be O(n), but the typical number of base
	        // names is very small, and indexOf is a native Array method.
	        if (bases.indexOf(baseName) < 0)
	            bases.push(baseName);
	    });

	    return this; // For chaining.
	};

	// False by default until .build(...) is called on an instance.
	Object.defineProperty(Dp, "buildable", { value: false });

	var builders = {};
	exports.builders = builders;

	// This object is used as prototype for any node created by a builder.
	var nodePrototype = {};

	// Call this function to define a new method to be shared by all AST
	// nodes. The replaced method (if any) is returned for easy wrapping.
	exports.defineMethod = function(name, func) {
	    var old = nodePrototype[name];

	    // Pass undefined as func to delete nodePrototype[name].
	    if (isUndefined.check(func)) {
	        delete nodePrototype[name];

	    } else {
	        isFunction.assert(func);

	        Object.defineProperty(nodePrototype, name, {
	            enumerable: true, // For discoverability.
	            configurable: true, // For delete proto[name].
	            value: func
	        });
	    }

	    return old;
	};

	// Calling the .build method of a Def simultaneously marks the type as
	// buildable (by defining builders[getBuilderName(typeName)]) and
	// specifies the order of arguments that should be passed to the builder
	// function to create an instance of the type.
	Dp.build = function(/* param1, param2, ... */) {
	    var self = this;

	    // Calling Def.prototype.build multiple times has the effect of merely
	    // redefining this property.
	    Object.defineProperty(self, "buildParams", {
	        value: slice.call(arguments),
	        writable: false,
	        enumerable: false,
	        configurable: true
	    });

	    assert.strictEqual(self.finalized, false);
	    isString.arrayOf().assert(self.buildParams);

	    if (self.buildable) {
	        // If this Def is already buildable, update self.buildParams and
	        // continue using the old builder function.
	        return self;
	    }

	    // Every buildable type will have its "type" field filled in
	    // automatically. This includes types that are not subtypes of Node,
	    // like SourceLocation, but that seems harmless (TODO?).
	    self.field("type", self.typeName, function() { return self.typeName });

	    // Override Dp.buildable for this Def instance.
	    Object.defineProperty(self, "buildable", { value: true });

	    Object.defineProperty(builders, getBuilderName(self.typeName), {
	        enumerable: true,

	        value: function() {
	            var args = arguments;
	            var argc = args.length;
	            var built = Object.create(nodePrototype);

	            assert.ok(
	                self.finalized,
	                "attempting to instantiate unfinalized type " + self.typeName);

	            function add(param, i) {
	                if (hasOwn.call(built, param))
	                    return;

	                var all = self.allFields;
	                assert.ok(hasOwn.call(all, param), param);

	                var field = all[param];
	                var type = field.type;
	                var value;

	                if (isNumber.check(i) && i < argc) {
	                    value = args[i];
	                } else if (field.defaultFn) {
	                    // Expose the partially-built object to the default
	                    // function as its `this` object.
	                    value = field.defaultFn.call(built);
	                } else {
	                    var message = "no value or default function given for field " +
	                        JSON.stringify(param) + " of " + self.typeName + "(" +
	                            self.buildParams.map(function(name) {
	                                return all[name];
	                            }).join(", ") + ")";
	                    assert.ok(false, message);
	                }

	                if (!type.check(value)) {
	                    assert.ok(
	                        false,
	                        shallowStringify(value) +
	                            " does not match field " + field +
	                            " of type " + self.typeName
	                    );
	                }

	                // TODO Could attach getters and setters here to enforce
	                // dynamic type safety.
	                built[param] = value;
	            }

	            self.buildParams.forEach(function(param, i) {
	                add(param, i);
	            });

	            Object.keys(self.allFields).forEach(function(param) {
	                add(param); // Use the default value.
	            });

	            // Make sure that the "type" field was filled automatically.
	            assert.strictEqual(built.type, self.typeName);

	            return built;
	        }
	    });

	    return self; // For chaining.
	};

	function getBuilderName(typeName) {
	    return typeName.replace(/^[A-Z]+/, function(upperCasePrefix) {
	        var len = upperCasePrefix.length;
	        switch (len) {
	        case 0: return "";
	        // If there's only one initial capital letter, just lower-case it.
	        case 1: return upperCasePrefix.toLowerCase();
	        default:
	            // If there's more than one initial capital letter, lower-case
	            // all but the last one, so that XMLDefaultDeclaration (for
	            // example) becomes xmlDefaultDeclaration.
	            return upperCasePrefix.slice(
	                0, len - 1).toLowerCase() +
	                upperCasePrefix.charAt(len - 1);
	        }
	    });
	}

	// The reason fields are specified using .field(...) instead of an object
	// literal syntax is somewhat subtle: the object literal syntax would
	// support only one key and one value, but with .field(...) we can pass
	// any number of arguments to specify the field.
	Dp.field = function(name, type, defaultFn, hidden) {
	    assert.strictEqual(this.finalized, false);
	    this.ownFields[name] = new Field(name, type, defaultFn, hidden);
	    return this; // For chaining.
	};

	var namedTypes = {};
	exports.namedTypes = namedTypes;

	// Like Object.keys, but aware of what fields each AST type should have.
	function getFieldNames(object) {
	    var d = Def.fromValue(object);
	    if (d) {
	        return d.fieldNames.slice(0);
	    }

	    if ("type" in object) {
	        assert.ok(
	            false,
	            "did not recognize object of type " +
	                JSON.stringify(object.type)
	        );
	    }

	    return Object.keys(object);
	}
	exports.getFieldNames = getFieldNames;

	// Get the value of an object property, taking object.type and default
	// functions into account.
	function getFieldValue(object, fieldName) {
	    var d = Def.fromValue(object);
	    if (d) {
	        var field = d.allFields[fieldName];
	        if (field) {
	            return field.getValue(object);
	        }
	    }

	    return object[fieldName];
	}
	exports.getFieldValue = getFieldValue;

	// Iterate over all defined fields of an object, including those missing
	// or undefined, passing each field name and effective value (as returned
	// by getFieldValue) to the callback. If the object has no corresponding
	// Def, the callback will never be called.
	exports.eachField = function(object, callback, context) {
	    getFieldNames(object).forEach(function(name) {
	        callback.call(this, name, getFieldValue(object, name));
	    }, context);
	};

	// Similar to eachField, except that iteration stops as soon as the
	// callback returns a truthy value. Like Array.prototype.some, the final
	// result is either true or false to indicates whether the callback
	// returned true for any element or not.
	exports.someField = function(object, callback, context) {
	    return getFieldNames(object).some(function(name) {
	        return callback.call(this, name, getFieldValue(object, name));
	    }, context);
	};

	// This property will be overridden as true by individual Def instances
	// when they are finalized.
	Object.defineProperty(Dp, "finalized", { value: false });

	Dp.finalize = function() {
	    // It's not an error to finalize a type more than once, but only the
	    // first call to .finalize does anything.
	    if (!this.finalized) {
	        var allFields = this.allFields;
	        var allSupertypes = this.allSupertypes;

	        this.baseNames.forEach(function(name) {
	            var def = defCache[name];
	            def.finalize();
	            extend(allFields, def.allFields);
	            extend(allSupertypes, def.allSupertypes);
	        });

	        // TODO Warn if fields are overridden with incompatible types.
	        extend(allFields, this.ownFields);
	        allSupertypes[this.typeName] = this;

	        this.fieldNames.length = 0;
	        for (var fieldName in allFields) {
	            if (hasOwn.call(allFields, fieldName) &&
	                !allFields[fieldName].hidden) {
	                this.fieldNames.push(fieldName);
	            }
	        }

	        // Types are exported only once they have been finalized.
	        Object.defineProperty(namedTypes, this.typeName, {
	            enumerable: true,
	            value: this.type
	        });

	        Object.defineProperty(this, "finalized", { value: true });

	        // A linearization of the inheritance hierarchy.
	        populateSupertypeList(this.typeName, this.supertypeList);
	    }
	};

	function populateSupertypeList(typeName, list) {
	    list.length = 0;
	    list.push(typeName);

	    var lastSeen = Object.create(null);

	    for (var pos = 0; pos < list.length; ++pos) {
	        typeName = list[pos];
	        var d = defCache[typeName];
	        assert.strictEqual(d.finalized, true);

	        // If we saw typeName earlier in the breadth-first traversal,
	        // delete the last-seen occurrence.
	        if (hasOwn.call(lastSeen, typeName)) {
	            delete list[lastSeen[typeName]];
	        }

	        // Record the new index of the last-seen occurrence of typeName.
	        lastSeen[typeName] = pos;

	        // Enqueue the base names of this type.
	        list.push.apply(list, d.baseNames);
	    }

	    // Compaction loop to remove array holes.
	    for (var to = 0, from = to, len = list.length; from < len; ++from) {
	        if (hasOwn.call(list, from)) {
	            list[to++] = list[from];
	        }
	    }

	    list.length = to;
	}

	function extend(into, from) {
	    Object.keys(from).forEach(function(name) {
	        into[name] = from[name];
	    });

	    return into;
	};

	exports.finalize = function() {
	    Object.keys(defCache).forEach(function(name) {
	        defCache[name].finalize();
	    });
	};


/***/ },
/* 27 */
/***/ function(module, exports) {

	module.exports = require("assert");

/***/ },
/* 28 */
/***/ function(module, exports, __webpack_require__) {

	var types = __webpack_require__(26);
	var Type = types.Type;
	var def = Type.def;
	var or = Type.or;
	var builtin = types.builtInTypes;
	var isString = builtin.string;
	var isNumber = builtin.number;
	var isBoolean = builtin.boolean;
	var isRegExp = builtin.RegExp;
	var shared = __webpack_require__(29);
	var defaults = shared.defaults;
	var geq = shared.geq;

	// Abstract supertype of all syntactic entities that are allowed to have a
	// .loc field.
	def("Printable")
	    .field("loc", or(
	        def("SourceLocation"),
	        null
	    ), defaults["null"], true);

	def("Node")
	    .bases("Printable")
	    .field("type", isString)
	    .field("comments", or(
	        [def("Comment")],
	        null
	    ), defaults["null"], true);

	def("SourceLocation")
	    .build("start", "end", "source")
	    .field("start", def("Position"))
	    .field("end", def("Position"))
	    .field("source", or(isString, null), defaults["null"]);

	def("Position")
	    .build("line", "column")
	    .field("line", geq(1))
	    .field("column", geq(0));

	def("Program")
	    .bases("Node")
	    .build("body")
	    .field("body", [def("Statement")]);

	def("Function")
	    .bases("Node")
	    .field("id", or(def("Identifier"), null), defaults["null"])
	    .field("params", [def("Pattern")])
	    .field("body", or(def("BlockStatement"), def("Expression")));

	def("Statement").bases("Node");

	// The empty .build() here means that an EmptyStatement can be constructed
	// (i.e. it's not abstract) but that it needs no arguments.
	def("EmptyStatement").bases("Statement").build();

	def("BlockStatement")
	    .bases("Statement")
	    .build("body")
	    .field("body", [def("Statement")]);

	// TODO Figure out how to silently coerce Expressions to
	// ExpressionStatements where a Statement was expected.
	def("ExpressionStatement")
	    .bases("Statement")
	    .build("expression")
	    .field("expression", def("Expression"));

	def("IfStatement")
	    .bases("Statement")
	    .build("test", "consequent", "alternate")
	    .field("test", def("Expression"))
	    .field("consequent", def("Statement"))
	    .field("alternate", or(def("Statement"), null), defaults["null"]);

	def("LabeledStatement")
	    .bases("Statement")
	    .build("label", "body")
	    .field("label", def("Identifier"))
	    .field("body", def("Statement"));

	def("BreakStatement")
	    .bases("Statement")
	    .build("label")
	    .field("label", or(def("Identifier"), null), defaults["null"]);

	def("ContinueStatement")
	    .bases("Statement")
	    .build("label")
	    .field("label", or(def("Identifier"), null), defaults["null"]);

	def("WithStatement")
	    .bases("Statement")
	    .build("object", "body")
	    .field("object", def("Expression"))
	    .field("body", def("Statement"));

	def("SwitchStatement")
	    .bases("Statement")
	    .build("discriminant", "cases", "lexical")
	    .field("discriminant", def("Expression"))
	    .field("cases", [def("SwitchCase")])
	    .field("lexical", isBoolean, defaults["false"]);

	def("ReturnStatement")
	    .bases("Statement")
	    .build("argument")
	    .field("argument", or(def("Expression"), null));

	def("ThrowStatement")
	    .bases("Statement")
	    .build("argument")
	    .field("argument", def("Expression"));

	def("TryStatement")
	    .bases("Statement")
	    .build("block", "handler", "finalizer")
	    .field("block", def("BlockStatement"))
	    .field("handler", or(def("CatchClause"), null), function() {
	        return this.handlers && this.handlers[0] || null;
	    })
	    .field("handlers", [def("CatchClause")], function() {
	        return this.handler ? [this.handler] : [];
	    }, true) // Indicates this field is hidden from eachField iteration.
	    .field("guardedHandlers", [def("CatchClause")], defaults.emptyArray)
	    .field("finalizer", or(def("BlockStatement"), null), defaults["null"]);

	def("CatchClause")
	    .bases("Node")
	    .build("param", "guard", "body")
	    .field("param", def("Pattern"))
	    .field("guard", or(def("Expression"), null), defaults["null"])
	    .field("body", def("BlockStatement"));

	def("WhileStatement")
	    .bases("Statement")
	    .build("test", "body")
	    .field("test", def("Expression"))
	    .field("body", def("Statement"));

	def("DoWhileStatement")
	    .bases("Statement")
	    .build("body", "test")
	    .field("body", def("Statement"))
	    .field("test", def("Expression"));

	def("ForStatement")
	    .bases("Statement")
	    .build("init", "test", "update", "body")
	    .field("init", or(
	        def("VariableDeclaration"),
	        def("Expression"),
	        null))
	    .field("test", or(def("Expression"), null))
	    .field("update", or(def("Expression"), null))
	    .field("body", def("Statement"));

	def("ForInStatement")
	    .bases("Statement")
	    .build("left", "right", "body", "each")
	    .field("left", or(
	        def("VariableDeclaration"),
	        def("Expression")))
	    .field("right", def("Expression"))
	    .field("body", def("Statement"))
	    .field("each", isBoolean);

	def("DebuggerStatement").bases("Statement").build();

	def("Declaration").bases("Statement");

	def("FunctionDeclaration")
	    .bases("Function", "Declaration")
	    .build("id", "params", "body")
	    .field("id", def("Identifier"));

	def("FunctionExpression")
	    .bases("Function", "Expression")
	    .build("id", "params", "body");

	def("VariableDeclaration")
	    .bases("Declaration")
	    .build("kind", "declarations")
	    .field("kind", or("var", "let", "const"))
	    .field("declarations", [or(
	        def("VariableDeclarator"),
	        def("Identifier") // TODO Esprima deviation.
	    )]);

	def("VariableDeclarator")
	    .bases("Node")
	    .build("id", "init")
	    .field("id", def("Pattern"))
	    .field("init", or(def("Expression"), null));

	// TODO Are all Expressions really Patterns?
	def("Expression").bases("Node", "Pattern");

	def("ThisExpression").bases("Expression").build();

	def("ArrayExpression")
	    .bases("Expression")
	    .build("elements")
	    .field("elements", [or(def("Expression"), null)]);

	def("ObjectExpression")
	    .bases("Expression")
	    .build("properties")
	    .field("properties", [def("Property")]);

	// TODO Not in the Mozilla Parser API, but used by Esprima.
	def("Property")
	    .bases("Node") // Want to be able to visit Property Nodes.
	    .build("kind", "key", "value")
	    .field("kind", or("init", "get", "set"))
	    .field("key", or(def("Literal"), def("Identifier")))
	    // esprima allows Pattern
	    .field("value", or(def("Expression"), def("Pattern")));

	def("SequenceExpression")
	    .bases("Expression")
	    .build("expressions")
	    .field("expressions", [def("Expression")]);

	var UnaryOperator = or(
	    "-", "+", "!", "~",
	    "typeof", "void", "delete");

	def("UnaryExpression")
	    .bases("Expression")
	    .build("operator", "argument", "prefix")
	    .field("operator", UnaryOperator)
	    .field("argument", def("Expression"))
	    // TODO Esprima doesn't bother with this field, presumably because
	    // it's always true for unary operators.
	    .field("prefix", isBoolean, defaults["true"]);

	var BinaryOperator = or(
	    "==", "!=", "===", "!==",
	    "<", "<=", ">", ">=",
	    "<<", ">>", ">>>",
	    "+", "-", "*", "/", "%",
	    "&", // TODO Missing from the Parser API.
	    "|", "^", "in",
	    "instanceof", "..");

	def("BinaryExpression")
	    .bases("Expression")
	    .build("operator", "left", "right")
	    .field("operator", BinaryOperator)
	    .field("left", def("Expression"))
	    .field("right", def("Expression"));

	var AssignmentOperator = or(
	    "=", "+=", "-=", "*=", "/=", "%=",
	    "<<=", ">>=", ">>>=",
	    "|=", "^=", "&=");

	def("AssignmentExpression")
	    .bases("Expression")
	    .build("operator", "left", "right")
	    .field("operator", AssignmentOperator)
	    .field("left", def("Pattern"))
	    .field("right", def("Expression"));

	var UpdateOperator = or("++", "--");

	def("UpdateExpression")
	    .bases("Expression")
	    .build("operator", "argument", "prefix")
	    .field("operator", UpdateOperator)
	    .field("argument", def("Expression"))
	    .field("prefix", isBoolean);

	var LogicalOperator = or("||", "&&");

	def("LogicalExpression")
	    .bases("Expression")
	    .build("operator", "left", "right")
	    .field("operator", LogicalOperator)
	    .field("left", def("Expression"))
	    .field("right", def("Expression"));

	def("ConditionalExpression")
	    .bases("Expression")
	    .build("test", "consequent", "alternate")
	    .field("test", def("Expression"))
	    .field("consequent", def("Expression"))
	    .field("alternate", def("Expression"));

	def("NewExpression")
	    .bases("Expression")
	    .build("callee", "arguments")
	    .field("callee", def("Expression"))
	    // The Mozilla Parser API gives this type as [or(def("Expression"),
	    // null)], but null values don't really make sense at the call site.
	    // TODO Report this nonsense.
	    .field("arguments", [def("Expression")]);

	def("CallExpression")
	    .bases("Expression")
	    .build("callee", "arguments")
	    .field("callee", def("Expression"))
	    // See comment for NewExpression above.
	    .field("arguments", [def("Expression")]);

	def("MemberExpression")
	    .bases("Expression")
	    .build("object", "property", "computed")
	    .field("object", def("Expression"))
	    .field("property", or(def("Identifier"), def("Expression")))
	    .field("computed", isBoolean);

	def("Pattern").bases("Node");

	def("ObjectPattern")
	    .bases("Pattern")
	    .build("properties")
	    // TODO File a bug to get PropertyPattern added to the interfaces API.
	    // esprima uses Property
	    .field("properties", [or(def("PropertyPattern"), def("Property"))]);

	def("PropertyPattern")
	    .bases("Pattern")
	    .build("key", "pattern")
	    .field("key", or(def("Literal"), def("Identifier")))
	    .field("pattern", def("Pattern"));

	def("ArrayPattern")
	    .bases("Pattern")
	    .build("elements")
	    .field("elements", [or(def("Pattern"), null)]);

	def("SwitchCase")
	    .bases("Node")
	    .build("test", "consequent")
	    .field("test", or(def("Expression"), null))
	    .field("consequent", [def("Statement")]);

	def("Identifier")
	    // But aren't Expressions and Patterns already Nodes? TODO Report this.
	    .bases("Node", "Expression", "Pattern")
	    .build("name")
	    .field("name", isString);

	def("Literal")
	    // But aren't Expressions already Nodes? TODO Report this.
	    .bases("Node", "Expression")
	    .build("value")
	    .field("value", or(
	        isString,
	        isBoolean,
	        null, // isNull would also work here.
	        isNumber,
	        isRegExp
	    ));

	// Abstract (non-buildable) comment supertype. Not a Node.
	def("Comment")
	    .bases("Printable")
	    .field("value", isString)
	    // A .leading comment comes before the node, whereas a .trailing
	    // comment comes after it. These two fields should not both be true,
	    // but they might both be false when the comment falls inside a node
	    // and the node has no children for the comment to lead or trail,
	    // e.g. { /*dangling*/ }.
	    .field("leading", isBoolean, defaults["true"])
	    .field("trailing", isBoolean, defaults["false"]);

	// Block comment. The .type really should be BlockComment rather than
	// Block, but that's what we're stuck with for now.
	def("Block")
	    .bases("Comment")
	    .build("value", /*optional:*/ "leading", "trailing");

	// Single line comment. The .type really should be LineComment rather than
	// Line, but that's what we're stuck with for now.
	def("Line")
	    .bases("Comment")
	    .build("value", /*optional:*/ "leading", "trailing");


/***/ },
/* 29 */
/***/ function(module, exports, __webpack_require__) {

	var types = __webpack_require__(26);
	var Type = types.Type;
	var builtin = types.builtInTypes;
	var isNumber = builtin.number;

	// An example of constructing a new type with arbitrary constraints from
	// an existing type.
	exports.geq = function(than) {
	    return new Type(function(value) {
	        return isNumber.check(value) && value >= than;
	    }, isNumber + " >= " + than);
	};

	// Default value-returning functions that may optionally be passed as a
	// third argument to Def.prototype.field.
	exports.defaults = {
	    // Functions were used because (among other reasons) that's the most
	    // elegant way to allow for the emptyArray one always to give a new
	    // array instance.
	    "null": function() { return null },
	    "emptyArray": function() { return [] },
	    "false": function() { return false },
	    "true": function() { return true },
	    "undefined": function() {}
	};

	var naiveIsPrimitive = Type.or(
	    builtin.string,
	    builtin.number,
	    builtin.boolean,
	    builtin.null,
	    builtin.undefined
	);

	exports.isPrimitive = new Type(function(value) {
	    if (value === null)
	        return true;
	    var type = typeof value;
	    return !(type === "object" ||
	             type === "function");
	}, naiveIsPrimitive.toString());


/***/ },
/* 30 */
/***/ function(module, exports, __webpack_require__) {

	__webpack_require__(28);
	var types = __webpack_require__(26);
	var def = types.Type.def;
	var or = types.Type.or;
	var builtin = types.builtInTypes;
	var isBoolean = builtin.boolean;
	var isObject = builtin.object;
	var isString = builtin.string;
	var defaults = __webpack_require__(29).defaults;

	def("Function")
	    .field("generator", isBoolean, defaults["false"])
	    .field("expression", isBoolean, defaults["false"])
	    .field("defaults", [or(def("Expression"), null)], defaults.emptyArray)
	    // TODO This could be represented as a SpreadElementPattern in .params.
	    .field("rest", or(def("Identifier"), null), defaults["null"]);

	def("FunctionDeclaration")
	    .build("id", "params", "body", "generator", "expression");

	def("FunctionExpression")
	    .build("id", "params", "body", "generator", "expression");

	// TODO The Parser API calls this ArrowExpression, but Esprima uses
	// ArrowFunctionExpression.
	def("ArrowFunctionExpression")
	    .bases("Function", "Expression")
	    .build("params", "body", "expression")
	    // The forced null value here is compatible with the overridden
	    // definition of the "id" field in the Function interface.
	    .field("id", null, defaults["null"])
	    // The current spec forbids arrow generators, so I have taken the
	    // liberty of enforcing that. TODO Report this.
	    .field("generator", false, defaults["false"]);

	def("YieldExpression")
	    .bases("Expression")
	    .build("argument", "delegate")
	    .field("argument", or(def("Expression"), null))
	    .field("delegate", isBoolean, defaults["false"]);

	def("GeneratorExpression")
	    .bases("Expression")
	    .build("body", "blocks", "filter")
	    .field("body", def("Expression"))
	    .field("blocks", [def("ComprehensionBlock")])
	    .field("filter", or(def("Expression"), null));

	def("ComprehensionExpression")
	    .bases("Expression")
	    .build("body", "blocks", "filter")
	    .field("body", def("Expression"))
	    .field("blocks", [def("ComprehensionBlock")])
	    .field("filter", or(def("Expression"), null));

	def("ComprehensionBlock")
	    .bases("Node")
	    .build("left", "right", "each")
	    .field("left", def("Pattern"))
	    .field("right", def("Expression"))
	    .field("each", isBoolean);

	def("ModuleSpecifier")
	    .bases("Literal")
	    .build("value")
	    .field("value", isString);

	def("Property")
	    // Esprima extensions not mentioned in the Mozilla Parser API:
	    .field("key", or(def("Literal"), def("Identifier"), def("Expression")))
	    .field("method", isBoolean, defaults["false"])
	    .field("shorthand", isBoolean, defaults["false"])
	    .field("computed", isBoolean, defaults["false"]);

	def("PropertyPattern")
	    .field("key", or(def("Literal"), def("Identifier"), def("Expression")))
	    .field("computed", isBoolean, defaults["false"]);

	def("MethodDefinition")
	    .bases("Declaration")
	    .build("kind", "key", "value")
	    .field("kind", or("init", "get", "set", ""))
	    .field("key", or(def("Literal"), def("Identifier"), def("Expression")))
	    .field("value", def("Function"))
	    .field("computed", isBoolean, defaults["false"]);

	def("SpreadElement")
	    .bases("Node")
	    .build("argument")
	    .field("argument", def("Expression"));

	def("ArrayExpression")
	    .field("elements", [or(def("Expression"), def("SpreadElement"), null)]);

	def("NewExpression")
	    .field("arguments", [or(def("Expression"), def("SpreadElement"))]);

	def("CallExpression")
	    .field("arguments", [or(def("Expression"), def("SpreadElement"))]);

	def("SpreadElementPattern")
	    .bases("Pattern")
	    .build("argument")
	    .field("argument", def("Pattern"));

	def("ArrayPattern")
	    .field("elements", [or(
	        def("Pattern"),
	        null,
	        // used by esprima
	        def("SpreadElement")
	    )]);

	var ClassBodyElement = or(
	    def("MethodDefinition"),
	    def("VariableDeclarator"),
	    def("ClassPropertyDefinition"),
	    def("ClassProperty")
	);

	def("ClassProperty")
	  .bases("Declaration")
	  .build("key")
	  .field("key", or(def("Literal"), def("Identifier"), def("Expression")))
	  .field("computed", isBoolean, defaults["false"]);

	def("ClassPropertyDefinition") // static property
	    .bases("Declaration")
	    .build("definition")
	    // Yes, Virginia, circular definitions are permitted.
	    .field("definition", ClassBodyElement);

	def("ClassBody")
	    .bases("Declaration")
	    .build("body")
	    .field("body", [ClassBodyElement]);

	def("ClassDeclaration")
	    .bases("Declaration")
	    .build("id", "body", "superClass")
	    .field("id", def("Identifier"))
	    .field("body", def("ClassBody"))
	    .field("superClass", or(def("Expression"), null), defaults["null"]);

	def("ClassExpression")
	    .bases("Expression")
	    .build("id", "body", "superClass")
	    .field("id", or(def("Identifier"), null), defaults["null"])
	    .field("body", def("ClassBody"))
	    .field("superClass", or(def("Expression"), null), defaults["null"])
	    .field("implements", [def("ClassImplements")], defaults.emptyArray);

	def("ClassImplements")
	    .bases("Node")
	    .build("id")
	    .field("id", def("Identifier"))
	    .field("superClass", or(def("Expression"), null), defaults["null"]);

	// Specifier and NamedSpecifier are abstract non-standard types that I
	// introduced for definitional convenience.
	def("Specifier").bases("Node");
	def("NamedSpecifier")
	    .bases("Specifier")
	    // Note: this abstract type is intentionally not buildable.
	    .field("id", def("Identifier"))
	    .field("name", or(def("Identifier"), null), defaults["null"]);

	// Like NamedSpecifier, except type:"ExportSpecifier" and buildable.
	// export {<id [as name]>} [from ...];
	def("ExportSpecifier")
	    .bases("NamedSpecifier")
	    .build("id", "name");

	// export <*> from ...;
	def("ExportBatchSpecifier")
	    .bases("Specifier")
	    .build();

	// Like NamedSpecifier, except type:"ImportSpecifier" and buildable.
	// import {<id [as name]>} from ...;
	def("ImportSpecifier")
	    .bases("NamedSpecifier")
	    .build("id", "name");

	// import <* as id> from ...;
	def("ImportNamespaceSpecifier")
	    .bases("Specifier")
	    .build("id")
	    .field("id", def("Identifier"));

	// import <id> from ...;
	def("ImportDefaultSpecifier")
	    .bases("Specifier")
	    .build("id")
	    .field("id", def("Identifier"));

	def("ExportDeclaration")
	    .bases("Declaration")
	    .build("default", "declaration", "specifiers", "source")
	    .field("default", isBoolean)
	    .field("declaration", or(
	        def("Declaration"),
	        def("Expression"), // Implies default.
	        null
	    ))
	    .field("specifiers", [or(
	        def("ExportSpecifier"),
	        def("ExportBatchSpecifier")
	    )], defaults.emptyArray)
	    .field("source", or(def("ModuleSpecifier"), null), defaults["null"]);

	def("ImportDeclaration")
	    .bases("Declaration")
	    .build("specifiers", "source")
	    .field("specifiers", [or(
	        def("ImportSpecifier"),
	        def("ImportNamespaceSpecifier"),
	        def("ImportDefaultSpecifier")
	    )], defaults.emptyArray)
	    .field("source", def("ModuleSpecifier"));

	def("TaggedTemplateExpression")
	    .bases("Expression")
	    .field("tag", def("Expression"))
	    .field("quasi", def("TemplateLiteral"));

	def("TemplateLiteral")
	    .bases("Expression")
	    .build("quasis", "expressions")
	    .field("quasis", [def("TemplateElement")])
	    .field("expressions", [def("Expression")]);

	def("TemplateElement")
	    .bases("Node")
	    .build("value", "tail")
	    .field("value", {"cooked": isString, "raw": isString})
	    .field("tail", isBoolean);


/***/ },
/* 31 */
/***/ function(module, exports, __webpack_require__) {

	__webpack_require__(28);
	var types = __webpack_require__(26);
	var def = types.Type.def;
	var or = types.Type.or;
	var builtin = types.builtInTypes;
	var isBoolean = builtin.boolean;
	var defaults = __webpack_require__(29).defaults;

	def("Function")
	    .field("async", isBoolean, defaults["false"]);

	def("SpreadProperty")
	    .bases("Node")
	    .build("argument")
	    .field("argument", def("Expression"));

	def("ObjectExpression")
	    .field("properties", [or(def("Property"), def("SpreadProperty"))]);

	def("SpreadPropertyPattern")
	    .bases("Pattern")
	    .build("argument")
	    .field("argument", def("Pattern"));

	def("ObjectPattern")
	    .field("properties", [or(
	        def("PropertyPattern"),
	        def("SpreadPropertyPattern"),
	        // used by esprima
	        def("Property"),
	        def("SpreadProperty")
	    )]);

	def("AwaitExpression")
	    .bases("Expression")
	    .build("argument", "all")
	    .field("argument", or(def("Expression"), null))
	    .field("all", isBoolean, defaults["false"]);


/***/ },
/* 32 */
/***/ function(module, exports, __webpack_require__) {

	__webpack_require__(28);
	var types = __webpack_require__(26);
	var def = types.Type.def;
	var or = types.Type.or;
	var geq = __webpack_require__(29).geq;

	def("ForOfStatement")
	    .bases("Statement")
	    .build("left", "right", "body")
	    .field("left", or(
	        def("VariableDeclaration"),
	        def("Expression")))
	    .field("right", def("Expression"))
	    .field("body", def("Statement"));

	def("LetStatement")
	    .bases("Statement")
	    .build("head", "body")
	    // TODO Deviating from the spec by reusing VariableDeclarator here.
	    .field("head", [def("VariableDeclarator")])
	    .field("body", def("Statement"));

	def("LetExpression")
	    .bases("Expression")
	    .build("head", "body")
	    // TODO Deviating from the spec by reusing VariableDeclarator here.
	    .field("head", [def("VariableDeclarator")])
	    .field("body", def("Expression"));

	def("GraphExpression")
	    .bases("Expression")
	    .build("index", "expression")
	    .field("index", geq(0))
	    .field("expression", def("Literal"));

	def("GraphIndexExpression")
	    .bases("Expression")
	    .build("index")
	    .field("index", geq(0));


/***/ },
/* 33 */
/***/ function(module, exports, __webpack_require__) {

	__webpack_require__(28);
	var types = __webpack_require__(26);
	var def = types.Type.def;
	var or = types.Type.or;
	var builtin = types.builtInTypes;
	var isString = builtin.string;
	var isBoolean = builtin.boolean;

	// Note that none of these types are buildable because the Mozilla Parser
	// API doesn't specify any builder functions, and nobody uses E4X anymore.

	def("XMLDefaultDeclaration")
	    .bases("Declaration")
	    .field("namespace", def("Expression"));

	def("XMLAnyName").bases("Expression");

	def("XMLQualifiedIdentifier")
	    .bases("Expression")
	    .field("left", or(def("Identifier"), def("XMLAnyName")))
	    .field("right", or(def("Identifier"), def("Expression")))
	    .field("computed", isBoolean);

	def("XMLFunctionQualifiedIdentifier")
	    .bases("Expression")
	    .field("right", or(def("Identifier"), def("Expression")))
	    .field("computed", isBoolean);

	def("XMLAttributeSelector")
	    .bases("Expression")
	    .field("attribute", def("Expression"));

	def("XMLFilterExpression")
	    .bases("Expression")
	    .field("left", def("Expression"))
	    .field("right", def("Expression"));

	def("XMLElement")
	    .bases("XML", "Expression")
	    .field("contents", [def("XML")]);

	def("XMLList")
	    .bases("XML", "Expression")
	    .field("contents", [def("XML")]);

	def("XML").bases("Node");

	def("XMLEscape")
	    .bases("XML")
	    .field("expression", def("Expression"));

	def("XMLText")
	    .bases("XML")
	    .field("text", isString);

	def("XMLStartTag")
	    .bases("XML")
	    .field("contents", [def("XML")]);

	def("XMLEndTag")
	    .bases("XML")
	    .field("contents", [def("XML")]);

	def("XMLPointTag")
	    .bases("XML")
	    .field("contents", [def("XML")]);

	def("XMLName")
	    .bases("XML")
	    .field("contents", or(isString, [def("XML")]));

	def("XMLAttribute")
	    .bases("XML")
	    .field("value", isString);

	def("XMLCdata")
	    .bases("XML")
	    .field("contents", isString);

	def("XMLComment")
	    .bases("XML")
	    .field("contents", isString);

	def("XMLProcessingInstruction")
	    .bases("XML")
	    .field("target", isString)
	    .field("contents", or(isString, null));


/***/ },
/* 34 */
/***/ function(module, exports, __webpack_require__) {

	__webpack_require__(28);
	var types = __webpack_require__(26);
	var def = types.Type.def;
	var or = types.Type.or;
	var builtin = types.builtInTypes;
	var isString = builtin.string;
	var isBoolean = builtin.boolean;
	var defaults = __webpack_require__(29).defaults;

	def("XJSAttribute")
	    .bases("Node")
	    .build("name", "value")
	    .field("name", or(def("XJSIdentifier"), def("XJSNamespacedName")))
	    .field("value", or(
	        def("Literal"), // attr="value"
	        def("XJSExpressionContainer"), // attr={value}
	        null // attr= or just attr
	    ), defaults["null"]);

	def("XJSIdentifier")
	    .bases("Node")
	    .build("name")
	    .field("name", isString);

	def("XJSNamespacedName")
	    .bases("Node")
	    .build("namespace", "name")
	    .field("namespace", def("XJSIdentifier"))
	    .field("name", def("XJSIdentifier"));

	def("XJSMemberExpression")
	    .bases("MemberExpression")
	    .build("object", "property")
	    .field("object", or(def("XJSIdentifier"), def("XJSMemberExpression")))
	    .field("property", def("XJSIdentifier"))
	    .field("computed", isBoolean, defaults.false);

	var XJSElementName = or(
	    def("XJSIdentifier"),
	    def("XJSNamespacedName"),
	    def("XJSMemberExpression")
	);

	def("XJSSpreadAttribute")
	    .bases("Node")
	    .build("argument")
	    .field("argument", def("Expression"));

	var XJSAttributes = [or(
	    def("XJSAttribute"),
	    def("XJSSpreadAttribute")
	)];

	def("XJSExpressionContainer")
	    .bases("Expression")
	    .build("expression")
	    .field("expression", def("Expression"));

	def("XJSElement")
	    .bases("Expression")
	    .build("openingElement", "closingElement", "children")
	    .field("openingElement", def("XJSOpeningElement"))
	    .field("closingElement", or(def("XJSClosingElement"), null), defaults["null"])
	    .field("children", [or(
	        def("XJSElement"),
	        def("XJSExpressionContainer"),
	        def("XJSText"),
	        def("Literal") // TODO Esprima should return XJSText instead.
	    )], defaults.emptyArray)
	    .field("name", XJSElementName, function() {
	        // Little-known fact: the `this` object inside a default function
	        // is none other than the partially-built object itself, and any
	        // fields initialized directly from builder function arguments
	        // (like openingElement, closingElement, and children) are
	        // guaranteed to be available.
	        return this.openingElement.name;
	    })
	    .field("selfClosing", isBoolean, function() {
	        return this.openingElement.selfClosing;
	    })
	    .field("attributes", XJSAttributes, function() {
	        return this.openingElement.attributes;
	    });

	def("XJSOpeningElement")
	    .bases("Node") // TODO Does this make sense? Can't really be an XJSElement.
	    .build("name", "attributes", "selfClosing")
	    .field("name", XJSElementName)
	    .field("attributes", XJSAttributes, defaults.emptyArray)
	    .field("selfClosing", isBoolean, defaults["false"]);

	def("XJSClosingElement")
	    .bases("Node") // TODO Same concern.
	    .build("name")
	    .field("name", XJSElementName);

	def("XJSText")
	    .bases("Literal")
	    .build("value")
	    .field("value", isString);

	def("XJSEmptyExpression").bases("Expression").build();

	// Type Annotations
	def("Type")
	  .bases("Node");

	def("AnyTypeAnnotation")
	  .bases("Type");

	def("VoidTypeAnnotation")
	  .bases("Type");

	def("NumberTypeAnnotation")
	  .bases("Type");

	def("StringTypeAnnotation")
	  .bases("Type");

	def("StringLiteralTypeAnnotation")
	  .bases("Type")
	  .build("value", "raw")
	  .field("value", isString)
	  .field("raw", isString);

	def("BooleanTypeAnnotation")
	  .bases("Type");

	def("TypeAnnotation")
	  .bases("Node")
	  .build("typeAnnotation")
	  .field("typeAnnotation", def("Type"));

	def("NullableTypeAnnotation")
	  .bases("Type")
	  .build("typeAnnotation")
	  .field("typeAnnotation", def("Type"));

	def("FunctionTypeAnnotation")
	  .bases("Type")
	  .build("params", "returnType", "rest", "typeParameters")
	  .field("params", [def("FunctionTypeParam")])
	  .field("returnType", def("Type"))
	  .field("rest", or(def("FunctionTypeParam"), null))
	  .field("typeParameters", or(def("TypeParameterDeclaration"), null));

	def("FunctionTypeParam")
	  .bases("Node")
	  .build("name", "typeAnnotation", "optional")
	  .field("name", def("Identifier"))
	  .field("typeAnnotation", def("Type"))
	  .field("optional", isBoolean);
	  
	def("ArrayTypeAnnotation")
	  .bases("Type")
	  .build("elementType")
	  .field("elementType", def("Type"));

	def("ObjectTypeAnnotation")
	  .bases("Type")
	  .build("properties")
	  .field("properties", [def("ObjectTypeProperty")])
	  .field("indexers", [def("ObjectTypeIndexer")], defaults.emptyArray)
	  .field("callProperties", [def("ObjectTypeCallProperty")], defaults.emptyArray);

	def("ObjectTypeProperty")
	  .bases("Node")
	  .build("key", "value", "optional")
	  .field("key", or(def("Literal"), def("Identifier")))
	  .field("value", def("Type"))
	  .field("optional", isBoolean);

	def("ObjectTypeIndexer")
	  .bases("Node")
	  .build("id", "key", "value")
	  .field("id", def("Identifier"))
	  .field("key", def("Type"))
	  .field("value", def("Type"));

	def("ObjectTypeCallProperty")
	  .bases("Node")
	  .build("value")
	  .field("value", def("FunctionTypeAnnotation"))
	  .field("static", isBoolean, false);

	def("QualifiedTypeIdentifier")
	  .bases("Node")
	  .build("qualification", "id")
	  .field("qualification", or(def("Identifier"), def("QualifiedTypeIdentifier")))
	  .field("id", def("Identifier"));

	def("GenericTypeAnnotation")
	  .bases("Type")
	  .build("id", "typeParameters")
	  .field("id", or(def("Identifier"), def("QualifiedTypeIdentifier")))
	  .field("typeParameters", or(def("TypeParameterInstantiation"), null));

	def("MemberTypeAnnotation")
	  .bases("Type")
	  .build("object", "property")
	  .field("object", def("Identifier"))
	  .field("property", or(def("MemberTypeAnnotation"), def("GenericTypeAnnotation")));

	def("UnionTypeAnnotation")
	  .bases("Type")
	  .build("types")
	  .field("types", [def("Type")]);

	def("IntersectionTypeAnnotation")
	  .bases("Type")
	  .build("types")
	  .field("types", [def("Type")]);

	def("TypeofTypeAnnotation")
	  .bases("Type")
	  .build("argument")
	  .field("argument", def("Type"));

	def("Identifier")
	  .field("typeAnnotation", or(def("TypeAnnotation"), null), defaults["null"]);

	def("TypeParameterDeclaration")
	  .bases("Node")
	  .build("params")
	  .field("params", [def("Identifier")]);

	def("TypeParameterInstantiation")
	  .bases("Node")
	  .build("params")
	  .field("params", [def("Type")]);

	def("Function")
	  .field("returnType", or(def("TypeAnnotation"), null), defaults["null"])
	  .field("typeParameters", or(def("TypeParameterDeclaration"), null), defaults["null"]);

	def("ClassProperty")
	  .build("key", "typeAnnotation")
	  .field("typeAnnotation", def("TypeAnnotation"))
	  .field("static", isBoolean, false);

	def("ClassImplements")
	  .field("typeParameters", or(def("TypeParameterInstantiation"), null), defaults["null"]);

	def("InterfaceDeclaration")
	  .bases("Statement")
	  .build("id", "body", "extends")
	  .field("id", def("Identifier"))
	  .field("typeParameters", or(def("TypeParameterDeclaration"), null), defaults["null"])
	  .field("body", def("ObjectTypeAnnotation"))
	  .field("extends", [def("InterfaceExtends")]);

	def("InterfaceExtends")
	  .bases("Node")
	  .build("id")
	  .field("id", def("Identifier"))
	  .field("typeParameters", or(def("TypeParameterInstantiation"), null));

	def("TypeAlias")
	  .bases("Statement")
	  .build("id", "typeParameters", "right")
	  .field("id", def("Identifier"))
	  .field("typeParameters", or(def("TypeParameterDeclaration"), null))
	  .field("right", def("Type"));
	  
	def("TypeCastExpression")
	  .bases("Expression")
	  .build("expression", "typeAnnotation")
	  .field("expression", def("Expression"))
	  .field("typeAnnotation", def("TypeAnnotation"));

	def("TupleTypeAnnotation")
	  .bases("Type")
	  .build("types")
	  .field("types", [def("Type")]);

	def("DeclareVariable")
	  .bases("Statement")
	  .build("id")
	  .field("id", def("Identifier"));

	def("DeclareFunction")
	  .bases("Statement")
	  .build("id")
	  .field("id", def("Identifier"));

	def("DeclareClass")
	  .bases("InterfaceDeclaration")
	  .build("id");

	def("DeclareModule")
	  .bases("Statement")
	  .build("id", "body")
	  .field("id", or(def("Identifier"), def("Literal")))
	  .field("body", def("BlockStatement"));


/***/ },
/* 35 */
/***/ function(module, exports, __webpack_require__) {

	var assert = __webpack_require__(27);
	var types = __webpack_require__(25);
	var getFieldNames = types.getFieldNames;
	var getFieldValue = types.getFieldValue;
	var isArray = types.builtInTypes.array;
	var isObject = types.builtInTypes.object;
	var isDate = types.builtInTypes.Date;
	var isRegExp = types.builtInTypes.RegExp;
	var hasOwn = Object.prototype.hasOwnProperty;

	function astNodesAreEquivalent(a, b, problemPath) {
	    if (isArray.check(problemPath)) {
	        problemPath.length = 0;
	    } else {
	        problemPath = null;
	    }

	    return areEquivalent(a, b, problemPath);
	}

	astNodesAreEquivalent.assert = function(a, b) {
	    var problemPath = [];
	    if (!astNodesAreEquivalent(a, b, problemPath)) {
	        if (problemPath.length === 0) {
	            assert.strictEqual(a, b);
	        } else {
	            assert.ok(
	                false,
	                "Nodes differ in the following path: " +
	                    problemPath.map(subscriptForProperty).join("")
	            );
	        }
	    }
	};

	function subscriptForProperty(property) {
	    if (/[_$a-z][_$a-z0-9]*/i.test(property)) {
	        return "." + property;
	    }
	    return "[" + JSON.stringify(property) + "]";
	}

	function areEquivalent(a, b, problemPath) {
	    if (a === b) {
	        return true;
	    }

	    if (isArray.check(a)) {
	        return arraysAreEquivalent(a, b, problemPath);
	    }

	    if (isObject.check(a)) {
	        return objectsAreEquivalent(a, b, problemPath);
	    }

	    if (isDate.check(a)) {
	        return isDate.check(b) && (+a === +b);
	    }

	    if (isRegExp.check(a)) {
	        return isRegExp.check(b) && (
	            a.source === b.source &&
	            a.global === b.global &&
	            a.multiline === b.multiline &&
	            a.ignoreCase === b.ignoreCase
	        );
	    }

	    return a == b;
	}

	function arraysAreEquivalent(a, b, problemPath) {
	    isArray.assert(a);
	    var aLength = a.length;

	    if (!isArray.check(b) || b.length !== aLength) {
	        if (problemPath) {
	            problemPath.push("length");
	        }
	        return false;
	    }

	    for (var i = 0; i < aLength; ++i) {
	        if (problemPath) {
	            problemPath.push(i);
	        }

	        if (i in a !== i in b) {
	            return false;
	        }

	        if (!areEquivalent(a[i], b[i], problemPath)) {
	            return false;
	        }

	        if (problemPath) {
	            assert.strictEqual(problemPath.pop(), i);
	        }
	    }

	    return true;
	}

	function objectsAreEquivalent(a, b, problemPath) {
	    isObject.assert(a);
	    if (!isObject.check(b)) {
	        return false;
	    }

	    // Fast path for a common property of AST nodes.
	    if (a.type !== b.type) {
	        if (problemPath) {
	            problemPath.push("type");
	        }
	        return false;
	    }

	    var aNames = getFieldNames(a);
	    var aNameCount = aNames.length;

	    var bNames = getFieldNames(b);
	    var bNameCount = bNames.length;

	    if (aNameCount === bNameCount) {
	        for (var i = 0; i < aNameCount; ++i) {
	            var name = aNames[i];
	            var aChild = getFieldValue(a, name);
	            var bChild = getFieldValue(b, name);

	            if (problemPath) {
	                problemPath.push(name);
	            }

	            if (!areEquivalent(aChild, bChild, problemPath)) {
	                return false;
	            }

	            if (problemPath) {
	                assert.strictEqual(problemPath.pop(), name);
	            }
	        }

	        return true;
	    }

	    if (!problemPath) {
	        return false;
	    }

	    // Since aNameCount !== bNameCount, we need to find some name that's
	    // missing in aNames but present in bNames, or vice-versa.

	    var seenNames = Object.create(null);

	    for (i = 0; i < aNameCount; ++i) {
	        seenNames[aNames[i]] = true;
	    }

	    for (i = 0; i < bNameCount; ++i) {
	        name = bNames[i];

	        if (!hasOwn.call(seenNames, name)) {
	            problemPath.push(name);
	            return false;
	        }

	        delete seenNames[name];
	    }

	    for (name in seenNames) {
	        problemPath.push(name);
	        break;
	    }

	    return false;
	}

	module.exports = astNodesAreEquivalent;


/***/ },
/* 36 */
/***/ function(module, exports, __webpack_require__) {

	var assert = __webpack_require__(27);
	var types = __webpack_require__(26);
	var n = types.namedTypes;
	var b = types.builders;
	var isNumber = types.builtInTypes.number;
	var isArray = types.builtInTypes.array;
	var Path = __webpack_require__(37);
	var Scope = __webpack_require__(38);

	function NodePath(value, parentPath, name) {
	    assert.ok(this instanceof NodePath);
	    Path.call(this, value, parentPath, name);
	}

	__webpack_require__(12).inherits(NodePath, Path);
	var NPp = NodePath.prototype;

	Object.defineProperties(NPp, {
	    node: {
	        get: function() {
	            Object.defineProperty(this, "node", {
	                configurable: true, // Enable deletion.
	                value: this._computeNode()
	            });

	            return this.node;
	        }
	    },

	    parent: {
	        get: function() {
	            Object.defineProperty(this, "parent", {
	                configurable: true, // Enable deletion.
	                value: this._computeParent()
	            });

	            return this.parent;
	        }
	    },

	    scope: {
	        get: function() {
	            Object.defineProperty(this, "scope", {
	                configurable: true, // Enable deletion.
	                value: this._computeScope()
	            });

	            return this.scope;
	        }
	    }
	});

	NPp.replace = function() {
	    delete this.node;
	    delete this.parent;
	    delete this.scope;
	    return Path.prototype.replace.apply(this, arguments);
	};

	NPp.prune = function() {
	    var remainingNodePath = this.parent;

	    this.replace();

	    return cleanUpNodesAfterPrune(remainingNodePath);
	};

	// The value of the first ancestor Path whose value is a Node.
	NPp._computeNode = function() {
	    var value = this.value;
	    if (n.Node.check(value)) {
	        return value;
	    }

	    var pp = this.parentPath;
	    return pp && pp.node || null;
	};

	// The first ancestor Path whose value is a Node distinct from this.node.
	NPp._computeParent = function() {
	    var value = this.value;
	    var pp = this.parentPath;

	    if (!n.Node.check(value)) {
	        while (pp && !n.Node.check(pp.value)) {
	            pp = pp.parentPath;
	        }

	        if (pp) {
	            pp = pp.parentPath;
	        }
	    }

	    while (pp && !n.Node.check(pp.value)) {
	        pp = pp.parentPath;
	    }

	    return pp || null;
	};

	// The closest enclosing scope that governs this node.
	NPp._computeScope = function() {
	    var value = this.value;
	    var pp = this.parentPath;
	    var scope = pp && pp.scope;

	    if (n.Node.check(value) &&
	        Scope.isEstablishedBy(value)) {
	        scope = new Scope(this, scope);
	    }

	    return scope || null;
	};

	NPp.getValueProperty = function(name) {
	    return types.getFieldValue(this.value, name);
	};

	/**
	 * Determine whether this.node needs to be wrapped in parentheses in order
	 * for a parser to reproduce the same local AST structure.
	 *
	 * For instance, in the expression `(1 + 2) * 3`, the BinaryExpression
	 * whose operator is "+" needs parentheses, because `1 + 2 * 3` would
	 * parse differently.
	 *
	 * If assumeExpressionContext === true, we don't worry about edge cases
	 * like an anonymous FunctionExpression appearing lexically first in its
	 * enclosing statement and thus needing parentheses to avoid being parsed
	 * as a FunctionDeclaration with a missing name.
	 */
	NPp.needsParens = function(assumeExpressionContext) {
	    var pp = this.parentPath;
	    if (!pp) {
	        return false;
	    }

	    var node = this.value;

	    // Only expressions need parentheses.
	    if (!n.Expression.check(node)) {
	        return false;
	    }

	    // Identifiers never need parentheses.
	    if (node.type === "Identifier") {
	        return false;
	    }

	    while (!n.Node.check(pp.value)) {
	        pp = pp.parentPath;
	        if (!pp) {
	            return false;
	        }
	    }

	    var parent = pp.value;

	    switch (node.type) {
	    case "UnaryExpression":
	    case "SpreadElement":
	    case "SpreadProperty":
	        return parent.type === "MemberExpression"
	            && this.name === "object"
	            && parent.object === node;

	    case "BinaryExpression":
	    case "LogicalExpression":
	        switch (parent.type) {
	        case "CallExpression":
	            return this.name === "callee"
	                && parent.callee === node;

	        case "UnaryExpression":
	        case "SpreadElement":
	        case "SpreadProperty":
	            return true;

	        case "MemberExpression":
	            return this.name === "object"
	                && parent.object === node;

	        case "BinaryExpression":
	        case "LogicalExpression":
	            var po = parent.operator;
	            var pp = PRECEDENCE[po];
	            var no = node.operator;
	            var np = PRECEDENCE[no];

	            if (pp > np) {
	                return true;
	            }

	            if (pp === np && this.name === "right") {
	                assert.strictEqual(parent.right, node);
	                return true;
	            }

	        default:
	            return false;
	        }

	    case "SequenceExpression":
	        switch (parent.type) {
	        case "ForStatement":
	            // Although parentheses wouldn't hurt around sequence
	            // expressions in the head of for loops, traditional style
	            // dictates that e.g. i++, j++ should not be wrapped with
	            // parentheses.
	            return false;

	        case "ExpressionStatement":
	            return this.name !== "expression";

	        default:
	            // Otherwise err on the side of overparenthesization, adding
	            // explicit exceptions above if this proves overzealous.
	            return true;
	        }

	    case "YieldExpression":
	        switch (parent.type) {
	        case "BinaryExpression":
	        case "LogicalExpression":
	        case "UnaryExpression":
	        case "SpreadElement":
	        case "SpreadProperty":
	        case "CallExpression":
	        case "MemberExpression":
	        case "NewExpression":
	        case "ConditionalExpression":
	        case "YieldExpression":
	            return true;

	        default:
	            return false;
	        }

	    case "Literal":
	        return parent.type === "MemberExpression"
	            && isNumber.check(node.value)
	            && this.name === "object"
	            && parent.object === node;

	    case "AssignmentExpression":
	    case "ConditionalExpression":
	        switch (parent.type) {
	        case "UnaryExpression":
	        case "SpreadElement":
	        case "SpreadProperty":
	        case "BinaryExpression":
	        case "LogicalExpression":
	            return true;

	        case "CallExpression":
	            return this.name === "callee"
	                && parent.callee === node;

	        case "ConditionalExpression":
	            return this.name === "test"
	                && parent.test === node;

	        case "MemberExpression":
	            return this.name === "object"
	                && parent.object === node;

	        default:
	            return false;
	        }

	    default:
	        if (parent.type === "NewExpression" &&
	            this.name === "callee" &&
	            parent.callee === node) {
	            return containsCallExpression(node);
	        }
	    }

	    if (assumeExpressionContext !== true &&
	        !this.canBeFirstInStatement() &&
	        this.firstInStatement())
	        return true;

	    return false;
	};

	function isBinary(node) {
	    return n.BinaryExpression.check(node)
	        || n.LogicalExpression.check(node);
	}

	function isUnaryLike(node) {
	    return n.UnaryExpression.check(node)
	        // I considered making SpreadElement and SpreadProperty subtypes
	        // of UnaryExpression, but they're not really Expression nodes.
	        || (n.SpreadElement && n.SpreadElement.check(node))
	        || (n.SpreadProperty && n.SpreadProperty.check(node));
	}

	var PRECEDENCE = {};
	[["||"],
	 ["&&"],
	 ["|"],
	 ["^"],
	 ["&"],
	 ["==", "===", "!=", "!=="],
	 ["<", ">", "<=", ">=", "in", "instanceof"],
	 [">>", "<<", ">>>"],
	 ["+", "-"],
	 ["*", "/", "%"]
	].forEach(function(tier, i) {
	    tier.forEach(function(op) {
	        PRECEDENCE[op] = i;
	    });
	});

	function containsCallExpression(node) {
	    if (n.CallExpression.check(node)) {
	        return true;
	    }

	    if (isArray.check(node)) {
	        return node.some(containsCallExpression);
	    }

	    if (n.Node.check(node)) {
	        return types.someField(node, function(name, child) {
	            return containsCallExpression(child);
	        });
	    }

	    return false;
	}

	NPp.canBeFirstInStatement = function() {
	    var node = this.node;
	    return !n.FunctionExpression.check(node)
	        && !n.ObjectExpression.check(node);
	};

	NPp.firstInStatement = function() {
	    return firstInStatement(this);
	};

	function firstInStatement(path) {
	    for (var node, parent; path.parent; path = path.parent) {
	        node = path.node;
	        parent = path.parent.node;

	        if (n.BlockStatement.check(parent) &&
	            path.parent.name === "body" &&
	            path.name === 0) {
	            assert.strictEqual(parent.body[0], node);
	            return true;
	        }

	        if (n.ExpressionStatement.check(parent) &&
	            path.name === "expression") {
	            assert.strictEqual(parent.expression, node);
	            return true;
	        }

	        if (n.SequenceExpression.check(parent) &&
	            path.parent.name === "expressions" &&
	            path.name === 0) {
	            assert.strictEqual(parent.expressions[0], node);
	            continue;
	        }

	        if (n.CallExpression.check(parent) &&
	            path.name === "callee") {
	            assert.strictEqual(parent.callee, node);
	            continue;
	        }

	        if (n.MemberExpression.check(parent) &&
	            path.name === "object") {
	            assert.strictEqual(parent.object, node);
	            continue;
	        }

	        if (n.ConditionalExpression.check(parent) &&
	            path.name === "test") {
	            assert.strictEqual(parent.test, node);
	            continue;
	        }

	        if (isBinary(parent) &&
	            path.name === "left") {
	            assert.strictEqual(parent.left, node);
	            continue;
	        }

	        if (n.UnaryExpression.check(parent) &&
	            !parent.prefix &&
	            path.name === "argument") {
	            assert.strictEqual(parent.argument, node);
	            continue;
	        }

	        return false;
	    }

	    return true;
	}

	/**
	 * Pruning certain nodes will result in empty or incomplete nodes, here we clean those nodes up.
	 */
	function cleanUpNodesAfterPrune(remainingNodePath) {
	    if (n.VariableDeclaration.check(remainingNodePath.node)) {
	        var declarations = remainingNodePath.get('declarations').value;
	        if (!declarations || declarations.length === 0) {
	            return remainingNodePath.prune();
	        }
	    } else if (n.ExpressionStatement.check(remainingNodePath.node)) {
	        if (!remainingNodePath.get('expression').value) {
	            return remainingNodePath.prune();
	        }
	    } else if (n.IfStatement.check(remainingNodePath.node)) {
	        cleanUpIfStatementAfterPrune(remainingNodePath);
	    }

	    return remainingNodePath;
	}

	function cleanUpIfStatementAfterPrune(ifStatement) {
	    var testExpression = ifStatement.get('test').value;
	    var alternate = ifStatement.get('alternate').value;
	    var consequent = ifStatement.get('consequent').value;

	    if (!consequent && !alternate) {
	        var testExpressionStatement = b.expressionStatement(testExpression);

	        ifStatement.replace(testExpressionStatement);
	    } else if (!consequent && alternate) {
	        var negatedTestExpression = b.unaryExpression('!', testExpression, true);

	        if (n.UnaryExpression.check(testExpression) && testExpression.operator === '!') {
	            negatedTestExpression = testExpression.argument;
	        }

	        ifStatement.get("test").replace(negatedTestExpression);
	        ifStatement.get("consequent").replace(alternate);
	        ifStatement.get("alternate").replace();
	    }
	}

	module.exports = NodePath;


/***/ },
/* 37 */
/***/ function(module, exports, __webpack_require__) {

	var assert = __webpack_require__(27);
	var Op = Object.prototype;
	var hasOwn = Op.hasOwnProperty;
	var types = __webpack_require__(26);
	var isArray = types.builtInTypes.array;
	var isNumber = types.builtInTypes.number;
	var Ap = Array.prototype;
	var slice = Ap.slice;
	var map = Ap.map;

	function Path(value, parentPath, name) {
	    assert.ok(this instanceof Path);

	    if (parentPath) {
	        assert.ok(parentPath instanceof Path);
	    } else {
	        parentPath = null;
	        name = null;
	    }

	    // The value encapsulated by this Path, generally equal to
	    // parentPath.value[name] if we have a parentPath.
	    this.value = value;

	    // The immediate parent Path of this Path.
	    this.parentPath = parentPath;

	    // The name of the property of parentPath.value through which this
	    // Path's value was reached.
	    this.name = name;

	    // Calling path.get("child") multiple times always returns the same
	    // child Path object, for both performance and consistency reasons.
	    this.__childCache = null;
	}

	var Pp = Path.prototype;

	function getChildCache(path) {
	    // Lazily create the child cache. This also cheapens cache
	    // invalidation, since you can just reset path.__childCache to null.
	    return path.__childCache || (path.__childCache = Object.create(null));
	}

	function getChildPath(path, name) {
	    var cache = getChildCache(path);
	    var actualChildValue = path.getValueProperty(name);
	    var childPath = cache[name];
	    if (!hasOwn.call(cache, name) ||
	        // Ensure consistency between cache and reality.
	        childPath.value !== actualChildValue) {
	        childPath = cache[name] = new path.constructor(
	            actualChildValue, path, name
	        );
	    }
	    return childPath;
	}

	// This method is designed to be overridden by subclasses that need to
	// handle missing properties, etc.
	Pp.getValueProperty = function getValueProperty(name) {
	    return this.value[name];
	};

	Pp.get = function get(name) {
	    var path = this;
	    var names = arguments;
	    var count = names.length;

	    for (var i = 0; i < count; ++i) {
	        path = getChildPath(path, names[i]);
	    }

	    return path;
	};

	Pp.each = function each(callback, context) {
	    var childPaths = [];
	    var len = this.value.length;
	    var i = 0;

	    // Collect all the original child paths before invoking the callback.
	    for (var i = 0; i < len; ++i) {
	        if (hasOwn.call(this.value, i)) {
	            childPaths[i] = this.get(i);
	        }
	    }

	    // Invoke the callback on just the original child paths, regardless of
	    // any modifications made to the array by the callback. I chose these
	    // semantics over cleverly invoking the callback on new elements because
	    // this way is much easier to reason about.
	    context = context || this;
	    for (i = 0; i < len; ++i) {
	        if (hasOwn.call(childPaths, i)) {
	            callback.call(context, childPaths[i]);
	        }
	    }
	};

	Pp.map = function map(callback, context) {
	    var result = [];

	    this.each(function(childPath) {
	        result.push(callback.call(this, childPath));
	    }, context);

	    return result;
	};

	Pp.filter = function filter(callback, context) {
	    var result = [];

	    this.each(function(childPath) {
	        if (callback.call(this, childPath)) {
	            result.push(childPath);
	        }
	    }, context);

	    return result;
	};

	function emptyMoves() {}
	function getMoves(path, offset, start, end) {
	    isArray.assert(path.value);

	    if (offset === 0) {
	        return emptyMoves;
	    }

	    var length = path.value.length;
	    if (length < 1) {
	        return emptyMoves;
	    }

	    var argc = arguments.length;
	    if (argc === 2) {
	        start = 0;
	        end = length;
	    } else if (argc === 3) {
	        start = Math.max(start, 0);
	        end = length;
	    } else {
	        start = Math.max(start, 0);
	        end = Math.min(end, length);
	    }

	    isNumber.assert(start);
	    isNumber.assert(end);

	    var moves = Object.create(null);
	    var cache = getChildCache(path);

	    for (var i = start; i < end; ++i) {
	        if (hasOwn.call(path.value, i)) {
	            var childPath = path.get(i);
	            assert.strictEqual(childPath.name, i);
	            var newIndex = i + offset;
	            childPath.name = newIndex;
	            moves[newIndex] = childPath;
	            delete cache[i];
	        }
	    }

	    delete cache.length;

	    return function() {
	        for (var newIndex in moves) {
	            var childPath = moves[newIndex];
	            assert.strictEqual(childPath.name, +newIndex);
	            cache[newIndex] = childPath;
	            path.value[newIndex] = childPath.value;
	        }
	    };
	}

	Pp.shift = function shift() {
	    var move = getMoves(this, -1);
	    var result = this.value.shift();
	    move();
	    return result;
	};

	Pp.unshift = function unshift(node) {
	    var move = getMoves(this, arguments.length);
	    var result = this.value.unshift.apply(this.value, arguments);
	    move();
	    return result;
	};

	Pp.push = function push(node) {
	    isArray.assert(this.value);
	    delete getChildCache(this).length
	    return this.value.push.apply(this.value, arguments);
	};

	Pp.pop = function pop() {
	    isArray.assert(this.value);
	    var cache = getChildCache(this);
	    delete cache[this.value.length - 1];
	    delete cache.length;
	    return this.value.pop();
	};

	Pp.insertAt = function insertAt(index, node) {
	    var argc = arguments.length;
	    var move = getMoves(this, argc - 1, index);
	    if (move === emptyMoves) {
	        return this;
	    }

	    index = Math.max(index, 0);

	    for (var i = 1; i < argc; ++i) {
	        this.value[index + i - 1] = arguments[i];
	    }

	    move();

	    return this;
	};

	Pp.insertBefore = function insertBefore(node) {
	    var pp = this.parentPath;
	    var argc = arguments.length;
	    var insertAtArgs = [this.name];
	    for (var i = 0; i < argc; ++i) {
	        insertAtArgs.push(arguments[i]);
	    }
	    return pp.insertAt.apply(pp, insertAtArgs);
	};

	Pp.insertAfter = function insertAfter(node) {
	    var pp = this.parentPath;
	    var argc = arguments.length;
	    var insertAtArgs = [this.name + 1];
	    for (var i = 0; i < argc; ++i) {
	        insertAtArgs.push(arguments[i]);
	    }
	    return pp.insertAt.apply(pp, insertAtArgs);
	};

	function repairRelationshipWithParent(path) {
	    assert.ok(path instanceof Path);

	    var pp = path.parentPath;
	    if (!pp) {
	        // Orphan paths have no relationship to repair.
	        return path;
	    }

	    var parentValue = pp.value;
	    var parentCache = getChildCache(pp);

	    // Make sure parentCache[path.name] is populated.
	    if (parentValue[path.name] === path.value) {
	        parentCache[path.name] = path;
	    } else if (isArray.check(parentValue)) {
	        // Something caused path.name to become out of date, so attempt to
	        // recover by searching for path.value in parentValue.
	        var i = parentValue.indexOf(path.value);
	        if (i >= 0) {
	            parentCache[path.name = i] = path;
	        }
	    } else {
	        // If path.value disagrees with parentValue[path.name], and
	        // path.name is not an array index, let path.value become the new
	        // parentValue[path.name] and update parentCache accordingly.
	        parentValue[path.name] = path.value;
	        parentCache[path.name] = path;
	    }

	    assert.strictEqual(parentValue[path.name], path.value);
	    assert.strictEqual(path.parentPath.get(path.name), path);

	    return path;
	}

	Pp.replace = function replace(replacement) {
	    var results = [];
	    var parentValue = this.parentPath.value;
	    var parentCache = getChildCache(this.parentPath);
	    var count = arguments.length;

	    repairRelationshipWithParent(this);

	    if (isArray.check(parentValue)) {
	        var originalLength = parentValue.length;
	        var move = getMoves(this.parentPath, count - 1, this.name + 1);

	        var spliceArgs = [this.name, 1];
	        for (var i = 0; i < count; ++i) {
	            spliceArgs.push(arguments[i]);
	        }

	        var splicedOut = parentValue.splice.apply(parentValue, spliceArgs);

	        assert.strictEqual(splicedOut[0], this.value);
	        assert.strictEqual(
	            parentValue.length,
	            originalLength - 1 + count
	        );

	        move();

	        if (count === 0) {
	            delete this.value;
	            delete parentCache[this.name];
	            this.__childCache = null;

	        } else {
	            assert.strictEqual(parentValue[this.name], replacement);

	            if (this.value !== replacement) {
	                this.value = replacement;
	                this.__childCache = null;
	            }

	            for (i = 0; i < count; ++i) {
	                results.push(this.parentPath.get(this.name + i));
	            }

	            assert.strictEqual(results[0], this);
	        }

	    } else if (count === 1) {
	        if (this.value !== replacement) {
	            this.__childCache = null;
	        }
	        this.value = parentValue[this.name] = replacement;
	        results.push(this);

	    } else if (count === 0) {
	        delete parentValue[this.name];
	        delete this.value;
	        this.__childCache = null;

	        // Leave this path cached as parentCache[this.name], even though
	        // it no longer has a value defined.

	    } else {
	        assert.ok(false, "Could not replace path");
	    }

	    return results;
	};

	module.exports = Path;


/***/ },
/* 38 */
/***/ function(module, exports, __webpack_require__) {

	var assert = __webpack_require__(27);
	var types = __webpack_require__(26);
	var Type = types.Type;
	var namedTypes = types.namedTypes;
	var Node = namedTypes.Node;
	var Expression = namedTypes.Expression;
	var isArray = types.builtInTypes.array;
	var hasOwn = Object.prototype.hasOwnProperty;
	var b = types.builders;

	function Scope(path, parentScope) {
	    assert.ok(this instanceof Scope);
	    assert.ok(path instanceof __webpack_require__(36));
	    ScopeType.assert(path.value);

	    var depth;

	    if (parentScope) {
	        assert.ok(parentScope instanceof Scope);
	        depth = parentScope.depth + 1;
	    } else {
	        parentScope = null;
	        depth = 0;
	    }

	    Object.defineProperties(this, {
	        path: { value: path },
	        node: { value: path.value },
	        isGlobal: { value: !parentScope, enumerable: true },
	        depth: { value: depth },
	        parent: { value: parentScope },
	        bindings: { value: {} }
	    });
	}

	var scopeTypes = [
	    // Program nodes introduce global scopes.
	    namedTypes.Program,

	    // Function is the supertype of FunctionExpression,
	    // FunctionDeclaration, ArrowExpression, etc.
	    namedTypes.Function,

	    // In case you didn't know, the caught parameter shadows any variable
	    // of the same name in an outer scope.
	    namedTypes.CatchClause
	];

	var ScopeType = Type.or.apply(Type, scopeTypes);

	Scope.isEstablishedBy = function(node) {
	    return ScopeType.check(node);
	};

	var Sp = Scope.prototype;

	// Will be overridden after an instance lazily calls scanScope.
	Sp.didScan = false;

	Sp.declares = function(name) {
	    this.scan();
	    return hasOwn.call(this.bindings, name);
	};

	Sp.declareTemporary = function(prefix) {
	    if (prefix) {
	        assert.ok(/^[a-z$_]/i.test(prefix), prefix);
	    } else {
	        prefix = "t$";
	    }

	    // Include this.depth in the name to make sure the name does not
	    // collide with any variables in nested/enclosing scopes.
	    prefix += this.depth.toString(36) + "$";

	    this.scan();

	    var index = 0;
	    while (this.declares(prefix + index)) {
	        ++index;
	    }

	    var name = prefix + index;
	    return this.bindings[name] = types.builders.identifier(name);
	};

	Sp.injectTemporary = function(identifier, init) {
	    identifier || (identifier = this.declareTemporary());

	    var bodyPath = this.path.get("body");
	    if (namedTypes.BlockStatement.check(bodyPath.value)) {
	        bodyPath = bodyPath.get("body");
	    }

	    bodyPath.unshift(
	        b.variableDeclaration(
	            "var",
	            [b.variableDeclarator(identifier, init || null)]
	        )
	    );

	    return identifier;
	};

	Sp.scan = function(force) {
	    if (force || !this.didScan) {
	        for (var name in this.bindings) {
	            // Empty out this.bindings, just in cases.
	            delete this.bindings[name];
	        }
	        scanScope(this.path, this.bindings);
	        this.didScan = true;
	    }
	};

	Sp.getBindings = function () {
	    this.scan();
	    return this.bindings;
	};

	function scanScope(path, bindings) {
	    var node = path.value;
	    ScopeType.assert(node);

	    if (namedTypes.CatchClause.check(node)) {
	        // A catch clause establishes a new scope but the only variable
	        // bound in that scope is the catch parameter. Any other
	        // declarations create bindings in the outer scope.
	        addPattern(path.get("param"), bindings);

	    } else {
	        recursiveScanScope(path, bindings);
	    }
	}

	function recursiveScanScope(path, bindings) {
	    var node = path.value;

	    if (path.parent &&
	        namedTypes.FunctionExpression.check(path.parent.node) &&
	        path.parent.node.id) {
	        addPattern(path.parent.get("id"), bindings);
	    }

	    if (!node) {
	        // None of the remaining cases matter if node is falsy.

	    } else if (isArray.check(node)) {
	        path.each(function(childPath) {
	            recursiveScanChild(childPath, bindings);
	        });

	    } else if (namedTypes.Function.check(node)) {
	        path.get("params").each(function(paramPath) {
	            addPattern(paramPath, bindings);
	        });

	        recursiveScanChild(path.get("body"), bindings);

	    } else if (namedTypes.VariableDeclarator.check(node)) {
	        addPattern(path.get("id"), bindings);
	        recursiveScanChild(path.get("init"), bindings);

	    } else if (node.type === "ImportSpecifier" ||
	               node.type === "ImportNamespaceSpecifier" ||
	               node.type === "ImportDefaultSpecifier") {
	        addPattern(
	            node.name ? path.get("name") : path.get("id"),
	            bindings
	        );

	    } else if (Node.check(node) && !Expression.check(node)) {
	        types.eachField(node, function(name, child) {
	            var childPath = path.get(name);
	            assert.strictEqual(childPath.value, child);
	            recursiveScanChild(childPath, bindings);
	        });
	    }
	}

	function recursiveScanChild(path, bindings) {
	    var node = path.value;

	    if (!node || Expression.check(node)) {
	        // Ignore falsy values and Expressions.

	    } else if (namedTypes.FunctionDeclaration.check(node)) {
	        addPattern(path.get("id"), bindings);

	    } else if (namedTypes.ClassDeclaration &&
	               namedTypes.ClassDeclaration.check(node)) {
	        addPattern(path.get("id"), bindings);

	    } else if (ScopeType.check(node)) {
	        if (namedTypes.CatchClause.check(node)) {
	            var catchParamName = node.param.name;
	            var hadBinding = hasOwn.call(bindings, catchParamName);

	            // Any declarations that occur inside the catch body that do
	            // not have the same name as the catch parameter should count
	            // as bindings in the outer scope.
	            recursiveScanScope(path.get("body"), bindings);

	            // If a new binding matching the catch parameter name was
	            // created while scanning the catch body, ignore it because it
	            // actually refers to the catch parameter and not the outer
	            // scope that we're currently scanning.
	            if (!hadBinding) {
	                delete bindings[catchParamName];
	            }
	        }

	    } else {
	        recursiveScanScope(path, bindings);
	    }
	}

	function addPattern(patternPath, bindings) {
	    var pattern = patternPath.value;
	    namedTypes.Pattern.assert(pattern);

	    if (namedTypes.Identifier.check(pattern)) {
	        if (hasOwn.call(bindings, pattern.name)) {
	            bindings[pattern.name].push(patternPath);
	        } else {
	            bindings[pattern.name] = [patternPath];
	        }

	    } else if (namedTypes.ObjectPattern &&
	               namedTypes.ObjectPattern.check(pattern)) {
	        patternPath.get('properties').each(function(propertyPath) {
	            var property = propertyPath.value;
	            if (namedTypes.Pattern.check(property)) {
	                addPattern(propertyPath, bindings);
	            } else  if (namedTypes.Property.check(property)) {
	                addPattern(propertyPath.get('value'), bindings);
	            } else if (namedTypes.SpreadProperty &&
	                       namedTypes.SpreadProperty.check(property)) {
	                addPattern(propertyPath.get('argument'), bindings);
	            }
	        });

	    } else if (namedTypes.ArrayPattern &&
	               namedTypes.ArrayPattern.check(pattern)) {
	        patternPath.get('elements').each(function(elementPath) {
	            var element = elementPath.value;
	            if (namedTypes.Pattern.check(element)) {
	                addPattern(elementPath, bindings);
	            } else if (namedTypes.SpreadElement &&
	                       namedTypes.SpreadElement.check(element)) {
	                addPattern(elementPath.get("argument"), bindings);
	            }
	        });

	    } else if (namedTypes.PropertyPattern &&
	               namedTypes.PropertyPattern.check(pattern)) {
	        addPattern(patternPath.get('pattern'), bindings);

	    } else if ((namedTypes.SpreadElementPattern &&
	                namedTypes.SpreadElementPattern.check(pattern)) ||
	               (namedTypes.SpreadPropertyPattern &&
	                namedTypes.SpreadPropertyPattern.check(pattern))) {
	        addPattern(patternPath.get('argument'), bindings);
	    }
	}

	Sp.lookup = function(name) {
	    for (var scope = this; scope; scope = scope.parent)
	        if (scope.declares(name))
	            break;
	    return scope;
	};

	Sp.getGlobalScope = function() {
	    var scope = this;
	    while (!scope.isGlobal)
	        scope = scope.parent;
	    return scope;
	};

	module.exports = Scope;


/***/ },
/* 39 */
/***/ function(module, exports, __webpack_require__) {

	var assert = __webpack_require__(27);
	var types = __webpack_require__(26);
	var NodePath = __webpack_require__(36);
	var Printable = types.namedTypes.Printable;
	var isArray = types.builtInTypes.array;
	var isObject = types.builtInTypes.object;
	var isFunction = types.builtInTypes.function;
	var hasOwn = Object.prototype.hasOwnProperty;
	var undefined;

	function PathVisitor() {
	    assert.ok(this instanceof PathVisitor);

	    // Permanent state.
	    this._reusableContextStack = [];

	    this._methodNameTable = computeMethodNameTable(this);
	    this._shouldVisitComments =
	        hasOwn.call(this._methodNameTable, "Block") ||
	        hasOwn.call(this._methodNameTable, "Line");

	    this.Context = makeContextConstructor(this);

	    // State reset every time PathVisitor.prototype.visit is called.
	    this._visiting = false;
	    this._changeReported = false;
	}

	function computeMethodNameTable(visitor) {
	    var typeNames = Object.create(null);

	    for (var methodName in visitor) {
	        if (/^visit[A-Z]/.test(methodName)) {
	            typeNames[methodName.slice("visit".length)] = true;
	        }
	    }

	    var supertypeTable = types.computeSupertypeLookupTable(typeNames);
	    var methodNameTable = Object.create(null);

	    var typeNames = Object.keys(supertypeTable);
	    var typeNameCount = typeNames.length;
	    for (var i = 0; i < typeNameCount; ++i) {
	        var typeName = typeNames[i];
	        methodName = "visit" + supertypeTable[typeName];
	        if (isFunction.check(visitor[methodName])) {
	            methodNameTable[typeName] = methodName;
	        }
	    }

	    return methodNameTable;
	}

	PathVisitor.fromMethodsObject = function fromMethodsObject(methods) {
	    if (methods instanceof PathVisitor) {
	        return methods;
	    }

	    if (!isObject.check(methods)) {
	        // An empty visitor?
	        return new PathVisitor;
	    }

	    function Visitor() {
	        assert.ok(this instanceof Visitor);
	        PathVisitor.call(this);
	    }

	    var Vp = Visitor.prototype = Object.create(PVp);
	    Vp.constructor = Visitor;

	    extend(Vp, methods);
	    extend(Visitor, PathVisitor);

	    isFunction.assert(Visitor.fromMethodsObject);
	    isFunction.assert(Visitor.visit);

	    return new Visitor;
	};

	function extend(target, source) {
	    for (var property in source) {
	        if (hasOwn.call(source, property)) {
	            target[property] = source[property];
	        }
	    }

	    return target;
	}

	PathVisitor.visit = function visit(node, methods) {
	    return PathVisitor.fromMethodsObject(methods).visit(node);
	};

	var PVp = PathVisitor.prototype;

	var recursiveVisitWarning = [
	    "Recursively calling visitor.visit(path) resets visitor state.",
	    "Try this.visit(path) or this.traverse(path) instead."
	].join(" ");

	PVp.visit = function() {
	    assert.ok(!this._visiting, recursiveVisitWarning);

	    // Private state that needs to be reset before every traversal.
	    this._visiting = true;
	    this._changeReported = false;
	    this._abortRequested = false;

	    var argc = arguments.length;
	    var args = new Array(argc)
	    for (var i = 0; i < argc; ++i) {
	        args[i] = arguments[i];
	    }

	    if (!(args[0] instanceof NodePath)) {
	        args[0] = new NodePath({ root: args[0] }).get("root");
	    }

	    // Called with the same arguments as .visit.
	    this.reset.apply(this, args);

	    try {
	        var root = this.visitWithoutReset(args[0]);
	        var didNotThrow = true;
	    } finally {
	        this._visiting = false;

	        if (!didNotThrow && this._abortRequested) {
	            // If this.visitWithoutReset threw an exception and
	            // this._abortRequested was set to true, return the root of
	            // the AST instead of letting the exception propagate, so that
	            // client code does not have to provide a try-catch block to
	            // intercept the AbortRequest exception.  Other kinds of
	            // exceptions will propagate without being intercepted and
	            // rethrown by a catch block, so their stacks will accurately
	            // reflect the original throwing context.
	            return args[0].value;
	        }
	    }

	    return root;
	};

	PVp.AbortRequest = function AbortRequest() {};
	PVp.abort = function() {
	    var visitor = this;
	    visitor._abortRequested = true;
	    var request = new visitor.AbortRequest();

	    // If you decide to catch this exception and stop it from propagating,
	    // make sure to call its cancel method to avoid silencing other
	    // exceptions that might be thrown later in the traversal.
	    request.cancel = function() {
	        visitor._abortRequested = false;
	    };

	    throw request;
	};

	PVp.reset = function(path/*, additional arguments */) {
	    // Empty stub; may be reassigned or overridden by subclasses.
	};

	PVp.visitWithoutReset = function(path) {
	    if (this instanceof this.Context) {
	        // Since this.Context.prototype === this, there's a chance we
	        // might accidentally call context.visitWithoutReset. If that
	        // happens, re-invoke the method against context.visitor.
	        return this.visitor.visitWithoutReset(path);
	    }

	    assert.ok(path instanceof NodePath);
	    var value = path.value;

	    var methodName = Printable.check(value) && this._methodNameTable[value.type];
	    if (methodName) {
	        var context = this.acquireContext(path);
	        try {
	            return context.invokeVisitorMethod(methodName);
	        } finally {
	            this.releaseContext(context);
	        }

	    } else {
	        // If there was no visitor method to call, visit the children of
	        // this node generically.
	        return visitChildren(path, this);
	    }
	};

	function visitChildren(path, visitor) {
	    assert.ok(path instanceof NodePath);
	    assert.ok(visitor instanceof PathVisitor);

	    var value = path.value;

	    if (isArray.check(value)) {
	        path.each(visitor.visitWithoutReset, visitor);
	    } else if (!isObject.check(value)) {
	        // No children to visit.
	    } else {
	        var childNames = types.getFieldNames(value);

	        // The .comments field of the Node type is hidden, so we only
	        // visit it if the visitor defines visitBlock or visitLine, and
	        // value.comments is defined.
	        if (visitor._shouldVisitComments &&
	            value.comments &&
	            childNames.indexOf("comments") < 0) {
	            childNames.push("comments");
	        }

	        var childCount = childNames.length;
	        var childPaths = [];

	        for (var i = 0; i < childCount; ++i) {
	            var childName = childNames[i];
	            if (!hasOwn.call(value, childName)) {
	                value[childName] = types.getFieldValue(value, childName);
	            }
	            childPaths.push(path.get(childName));
	        }

	        for (var i = 0; i < childCount; ++i) {
	            visitor.visitWithoutReset(childPaths[i]);
	        }
	    }

	    return path.value;
	}

	PVp.acquireContext = function(path) {
	    if (this._reusableContextStack.length === 0) {
	        return new this.Context(path);
	    }
	    return this._reusableContextStack.pop().reset(path);
	};

	PVp.releaseContext = function(context) {
	    assert.ok(context instanceof this.Context);
	    this._reusableContextStack.push(context);
	    context.currentPath = null;
	};

	PVp.reportChanged = function() {
	    this._changeReported = true;
	};

	PVp.wasChangeReported = function() {
	    return this._changeReported;
	};

	function makeContextConstructor(visitor) {
	    function Context(path) {
	        assert.ok(this instanceof Context);
	        assert.ok(this instanceof PathVisitor);
	        assert.ok(path instanceof NodePath);

	        Object.defineProperty(this, "visitor", {
	            value: visitor,
	            writable: false,
	            enumerable: true,
	            configurable: false
	        });

	        this.currentPath = path;
	        this.needToCallTraverse = true;

	        Object.seal(this);
	    }

	    assert.ok(visitor instanceof PathVisitor);

	    // Note that the visitor object is the prototype of Context.prototype,
	    // so all visitor methods are inherited by context objects.
	    var Cp = Context.prototype = Object.create(visitor);

	    Cp.constructor = Context;
	    extend(Cp, sharedContextProtoMethods);

	    return Context;
	}

	// Every PathVisitor has a different this.Context constructor and
	// this.Context.prototype object, but those prototypes can all use the
	// same reset, invokeVisitorMethod, and traverse function objects.
	var sharedContextProtoMethods = Object.create(null);

	sharedContextProtoMethods.reset =
	function reset(path) {
	    assert.ok(this instanceof this.Context);
	    assert.ok(path instanceof NodePath);

	    this.currentPath = path;
	    this.needToCallTraverse = true;

	    return this;
	};

	sharedContextProtoMethods.invokeVisitorMethod =
	function invokeVisitorMethod(methodName) {
	    assert.ok(this instanceof this.Context);
	    assert.ok(this.currentPath instanceof NodePath);

	    var result = this.visitor[methodName].call(this, this.currentPath);

	    if (result === false) {
	        // Visitor methods return false to indicate that they have handled
	        // their own traversal needs, and we should not complain if
	        // this.needToCallTraverse is still true.
	        this.needToCallTraverse = false;

	    } else if (result !== undefined) {
	        // Any other non-undefined value returned from the visitor method
	        // is interpreted as a replacement value.
	        this.currentPath = this.currentPath.replace(result)[0];

	        if (this.needToCallTraverse) {
	            // If this.traverse still hasn't been called, visit the
	            // children of the replacement node.
	            this.traverse(this.currentPath);
	        }
	    }

	    assert.strictEqual(
	        this.needToCallTraverse, false,
	        "Must either call this.traverse or return false in " + methodName
	    );

	    var path = this.currentPath;
	    return path && path.value;
	};

	sharedContextProtoMethods.traverse =
	function traverse(path, newVisitor) {
	    assert.ok(this instanceof this.Context);
	    assert.ok(path instanceof NodePath);
	    assert.ok(this.currentPath instanceof NodePath);

	    this.needToCallTraverse = false;

	    return visitChildren(path, PathVisitor.fromMethodsObject(
	        newVisitor || this.visitor
	    ));
	};

	sharedContextProtoMethods.visit =
	function visit(path, newVisitor) {
	    assert.ok(this instanceof this.Context);
	    assert.ok(path instanceof NodePath);
	    assert.ok(this.currentPath instanceof NodePath);

	    this.needToCallTraverse = false;

	    return PathVisitor.fromMethodsObject(
	        newVisitor || this.visitor
	    ).visitWithoutReset(path);
	};

	sharedContextProtoMethods.reportChanged = function reportChanged() {
	    this.visitor.reportChanged();
	};

	sharedContextProtoMethods.abort = function abort() {
	    this.needToCallTraverse = false;
	    this.visitor.abort();
	};

	module.exports = PathVisitor;


/***/ },
/* 40 */
/***/ function(module, exports, __webpack_require__) {

	var assert = __webpack_require__(27);
	var types = __webpack_require__(24);
	var n = types.namedTypes;
	var b = types.builders;
	var isObject = types.builtInTypes.object;
	var isArray = types.builtInTypes.array;
	var isFunction = types.builtInTypes.function;
	var Patcher = __webpack_require__(41).Patcher;
	var normalizeOptions = __webpack_require__(53).normalize;
	var fromString = __webpack_require__(42).fromString;
	var attachComments = __webpack_require__(59).attach;

	exports.parse = function parse(source, options) {
	    options = normalizeOptions(options);

	    var lines = fromString(source, options);

	    var sourceWithoutTabs = lines.toString({
	        tabWidth: options.tabWidth,
	        reuseWhitespace: false,
	        useTabs: false
	    });

	    var program = options.esprima.parse(sourceWithoutTabs, {
	        loc: true,
	        range: options.range,
	        comment: true,
	        tolerant: options.tolerant,
	        sourceType: 'module'
	    });

	    var comments = program.comments;
	    delete program.comments;

	    // In order to ensure we reprint leading and trailing program
	    // comments, wrap the original Program node with a File node.
	    var file = b.file(program);
	    file.loc = {
	        lines: lines,
	        indent: 0,
	        start: lines.firstPos(),
	        end: lines.lastPos()
	    };

	    // Return a copy of the original AST so that any changes made may be
	    // compared to the original.
	    var copy = new TreeCopier(lines).copy(file);

	    // Attach comments to the copy rather than the original.
	    attachComments(comments, copy, lines);

	    return copy;
	};

	function TreeCopier(lines) {
	    assert.ok(this instanceof TreeCopier);
	    this.lines = lines;
	    this.indent = 0;
	}

	var TCp = TreeCopier.prototype;

	TCp.copy = function(node) {
	    if (isArray.check(node)) {
	        return node.map(this.copy, this);
	    }

	    if (!isObject.check(node)) {
	        return node;
	    }

	    if ((n.MethodDefinition && n.MethodDefinition.check(node)) ||
	        (n.Property.check(node) && (node.method || node.shorthand))) {
	        // If the node is a MethodDefinition or a .method or .shorthand
	        // Property, then the location information stored in
	        // node.value.loc is very likely untrustworthy (just the {body}
	        // part of a method, or nothing in the case of shorthand
	        // properties), so we null out that information to prevent
	        // accidental reuse of bogus source code during reprinting.
	        node.value.loc = null;

	        if (n.FunctionExpression.check(node.value)) {
	            // FunctionExpression method values should be anonymous,
	            // because their .id fields are ignored anyway.
	            node.value.id = null;
	        }
	    }

	    var copy = Object.create(Object.getPrototypeOf(node), {
	        original: { // Provide a link from the copy to the original.
	            value: node,
	            configurable: false,
	            enumerable: false,
	            writable: true
	        }
	    });

	    var loc = node.loc;
	    var oldIndent = this.indent;
	    var newIndent = oldIndent;

	    if (loc) {
	        if (loc.start.line < 1) {
	            loc.start.line = 1;
	        }

	        if (loc.end.line < 1) {
	            loc.end.line = 1;
	        }

	        if (this.lines.isPrecededOnlyByWhitespace(loc.start)) {
	            newIndent = this.indent = loc.start.column;
	        }

	        loc.lines = this.lines;
	        loc.indent = newIndent;
	    }

	    var keys = Object.keys(node);
	    var keyCount = keys.length;
	    for (var i = 0; i < keyCount; ++i) {
	        var key = keys[i];
	        if (key === "loc") {
	            copy[key] = node[key];
	        } else if (key === "comments") {
	            // Handled below.
	        } else {
	            copy[key] = this.copy(node[key]);
	        }
	    }

	    this.indent = oldIndent;

	    if (node.comments) {
	        Object.defineProperty(copy, "comments", {
	            value: node.comments,
	            enumerable: false
	        });
	    }

	    return copy;
	};


/***/ },
/* 41 */
/***/ function(module, exports, __webpack_require__) {

	var assert = __webpack_require__(27);
	var linesModule = __webpack_require__(42);
	var types = __webpack_require__(24);
	var getFieldValue = types.getFieldValue;
	var Node = types.namedTypes.Node;
	var Expression = types.namedTypes.Expression;
	var SourceLocation = types.namedTypes.SourceLocation;
	var util = __webpack_require__(56);
	var comparePos = util.comparePos;
	var FastPath = __webpack_require__(58);
	var isObject = types.builtInTypes.object;
	var isArray = types.builtInTypes.array;
	var isString = types.builtInTypes.string;

	function Patcher(lines) {
	    assert.ok(this instanceof Patcher);
	    assert.ok(lines instanceof linesModule.Lines);

	    var self = this,
	        replacements = [];

	    self.replace = function(loc, lines) {
	        if (isString.check(lines))
	            lines = linesModule.fromString(lines);

	        replacements.push({
	            lines: lines,
	            start: loc.start,
	            end: loc.end
	        });
	    };

	    self.get = function(loc) {
	        // If no location is provided, return the complete Lines object.
	        loc = loc || {
	            start: { line: 1, column: 0 },
	            end: { line: lines.length,
	                   column: lines.getLineLength(lines.length) }
	        };

	        var sliceFrom = loc.start,
	            toConcat = [];

	        function pushSlice(from, to) {
	            assert.ok(comparePos(from, to) <= 0);
	            toConcat.push(lines.slice(from, to));
	        }

	        replacements.sort(function(a, b) {
	            return comparePos(a.start, b.start);
	        }).forEach(function(rep) {
	            if (comparePos(sliceFrom, rep.start) > 0) {
	                // Ignore nested replacement ranges.
	            } else {
	                pushSlice(sliceFrom, rep.start);
	                toConcat.push(rep.lines);
	                sliceFrom = rep.end;
	            }
	        });

	        pushSlice(sliceFrom, loc.end);

	        return linesModule.concat(toConcat);
	    };
	}
	exports.Patcher = Patcher;

	exports.getReprinter = function(path) {
	    assert.ok(path instanceof FastPath);

	    // Make sure that this path refers specifically to a Node, rather than
	    // some non-Node subproperty of a Node.
	    var node = path.getValue();
	    if (!Node.check(node))
	        return;

	    var orig = node.original;
	    var origLoc = orig && orig.loc;
	    var lines = origLoc && origLoc.lines;
	    var reprints = [];

	    if (!lines || !findReprints(path, reprints))
	        return;

	    return function(print) {
	        var patcher = new Patcher(lines);

	        reprints.forEach(function(reprint) {
	            var old = reprint.oldNode;
	            SourceLocation.assert(old.loc, true);
	            patcher.replace(
	                old.loc,
	                print(reprint.newPath).indentTail(old.loc.indent)
	            );
	        });

	        return patcher.get(origLoc).indentTail(-orig.loc.indent);
	    };
	};

	function findReprints(newPath, reprints) {
	    var newNode = newPath.getValue();
	    Node.assert(newNode);

	    var oldNode = newNode.original;
	    Node.assert(oldNode);

	    assert.deepEqual(reprints, []);

	    if (newNode.type !== oldNode.type) {
	        return false;
	    }

	    var oldPath = new FastPath(oldNode);
	    var canReprint = findChildReprints(newPath, oldPath, reprints);

	    if (!canReprint) {
	        // Make absolutely sure the calling code does not attempt to reprint
	        // any nodes.
	        reprints.length = 0;
	    }

	    return canReprint;
	}

	function findAnyReprints(newPath, oldPath, reprints) {
	    var newNode = newPath.getValue();
	    var oldNode = oldPath.getValue();

	    if (newNode === oldNode)
	        return true;

	    if (isArray.check(newNode))
	        return findArrayReprints(newPath, oldPath, reprints);

	    if (isObject.check(newNode))
	        return findObjectReprints(newPath, oldPath, reprints);

	    return false;
	}

	function findArrayReprints(newPath, oldPath, reprints) {
	    var newNode = newPath.getValue();
	    var oldNode = oldPath.getValue();
	    isArray.assert(newNode);
	    var len = newNode.length;

	    if (!(isArray.check(oldNode) &&
	          oldNode.length === len))
	        return false;

	    for (var i = 0; i < len; ++i) {
	        newPath.stack.push(i, newNode[i]);
	        oldPath.stack.push(i, oldNode[i]);
	        var canReprint = findAnyReprints(newPath, oldPath, reprints);
	        newPath.stack.length -= 2;
	        oldPath.stack.length -= 2;
	        if (!canReprint) {
	            return false;
	        }
	    }

	    return true;
	}

	function findObjectReprints(newPath, oldPath, reprints) {
	    var newNode = newPath.getValue();
	    isObject.assert(newNode);

	    if (newNode.original === null) {
	        // If newNode.original node was set to null, reprint the node.
	        return false;
	    }

	    var oldNode = oldPath.getValue();
	    if (!isObject.check(oldNode))
	        return false;

	    if (Node.check(newNode)) {
	        if (!Node.check(oldNode)) {
	            return false;
	        }

	        if (!oldNode.loc) {
	            // If we have no .loc information for oldNode, then we won't
	            // be able to reprint it.
	            return false;
	        }

	        // Here we need to decide whether the reprinted code for newNode
	        // is appropriate for patching into the location of oldNode.

	        if (newNode.type === oldNode.type) {
	            var childReprints = [];

	            if (findChildReprints(newPath, oldPath, childReprints)) {
	                reprints.push.apply(reprints, childReprints);
	            } else {
	                reprints.push({
	                    oldNode: oldNode,
	                    newPath: newPath.copy()
	                });
	            }

	            return true;
	        }

	        if (Expression.check(newNode) &&
	            Expression.check(oldNode)) {

	            // If both nodes are subtypes of Expression, then we should be
	            // able to fill the location occupied by the old node with
	            // code printed for the new node with no ill consequences.
	            reprints.push({
	                oldNode: oldNode,
	                newPath: newPath.copy()
	            });

	            return true;
	        }

	        // The nodes have different types, and at least one of the types
	        // is not a subtype of the Expression type, so we cannot safely
	        // assume the nodes are syntactically interchangeable.
	        return false;
	    }

	    return findChildReprints(newPath, oldPath, reprints);
	}

	// This object is reused in hasOpeningParen and hasClosingParen to avoid
	// having to allocate a temporary object.
	var reusablePos = { line: 1, column: 0 };

	function hasOpeningParen(oldPath) {
	    var oldNode = oldPath.getValue();
	    var loc = oldNode.loc;
	    var lines = loc && loc.lines;

	    if (lines) {
	        var pos = reusablePos;
	        pos.line = loc.start.line;
	        pos.column = loc.start.column;

	        while (lines.prevPos(pos)) {
	            var ch = lines.charAt(pos);

	            if (ch === "(") {
	                // If we found an opening parenthesis but it occurred before
	                // the start of the original subtree for this reprinting, then
	                // we must not return true for hasOpeningParen(oldPath).
	                return comparePos(oldPath.getRootValue().loc.start, pos) <= 0;
	            }

	            if (ch !== " ") {
	                return false;
	            }
	        }
	    }

	    return false;
	}

	function hasClosingParen(oldPath) {
	    var oldNode = oldPath.getValue();
	    var loc = oldNode.loc;
	    var lines = loc && loc.lines;

	    if (lines) {
	        var pos = reusablePos;
	        pos.line = loc.end.line;
	        pos.column = loc.end.column;

	        do {
	            var ch = lines.charAt(pos);

	            if (ch === ")") {
	                // If we found a closing parenthesis but it occurred after the
	                // end of the original subtree for this reprinting, then we
	                // must not return true for hasClosingParen(oldPath).
	                return comparePos(pos, oldPath.getRootValue().loc.end) <= 0;
	            }

	            if (ch !== " ") {
	                return false;
	            }

	        } while (lines.nextPos(pos));
	    }

	    return false;
	}

	function hasParens(oldPath) {
	    // This logic can technically be fooled if the node has parentheses
	    // but there are comments intervening between the parentheses and the
	    // node. In such cases the node will be harmlessly wrapped in an
	    // additional layer of parentheses.
	    return hasOpeningParen(oldPath) && hasClosingParen(oldPath);
	}

	function findChildReprints(newPath, oldPath, reprints) {
	    var newNode = newPath.getValue();
	    var oldNode = oldPath.getValue();

	    isObject.assert(newNode);
	    isObject.assert(oldNode);

	    if (newNode.original === null) {
	        // If newNode.original node was set to null, reprint the node.
	        return false;
	    }

	    // If this type of node cannot come lexically first in its enclosing
	    // statement (e.g. a function expression or object literal), and it
	    // seems to be doing so, then the only way we can ignore this problem
	    // and save ourselves from falling back to the pretty printer is if an
	    // opening parenthesis happens to precede the node.  For example,
	    // (function(){ ... }()); does not need to be reprinted, even though
	    // the FunctionExpression comes lexically first in the enclosing
	    // ExpressionStatement and fails the hasParens test, because the
	    // parent CallExpression passes the hasParens test. If we relied on
	    // the path.needsParens() && !hasParens(oldNode) check below, the
	    // absence of a closing parenthesis after the FunctionExpression would
	    // trigger pretty-printing unnecessarily.
	    if (!newPath.canBeFirstInStatement() &&
	        newPath.firstInStatement() &&
	        !hasOpeningParen(oldPath))
	        return false;

	    // If this node needs parentheses and will not be wrapped with
	    // parentheses when reprinted, then return false to skip reprinting
	    // and let it be printed generically.
	    if (newPath.needsParens(true) && !hasParens(oldPath)) {
	        return false;
	    }

	    for (var k in util.getUnionOfKeys(newNode, oldNode)) {
	        if (k === "loc")
	            continue;

	        newPath.stack.push(k, types.getFieldValue(newNode, k));
	        oldPath.stack.push(k, types.getFieldValue(oldNode, k));
	        var canReprint = findAnyReprints(newPath, oldPath, reprints);
	        newPath.stack.length -= 2;
	        oldPath.stack.length -= 2;

	        if (!canReprint) {
	            return false;
	        }
	    }

	    return true;
	}


/***/ },
/* 42 */
/***/ function(module, exports, __webpack_require__) {

	var assert = __webpack_require__(27);
	var sourceMap = __webpack_require__(43);
	var normalizeOptions = __webpack_require__(53).normalize;
	var secretKey = __webpack_require__(55).makeUniqueKey();
	var types = __webpack_require__(24);
	var isString = types.builtInTypes.string;
	var comparePos = __webpack_require__(56).comparePos;
	var Mapping = __webpack_require__(57);

	// Goals:
	// 1. Minimize new string creation.
	// 2. Keep (de)identation O(lines) time.
	// 3. Permit negative indentations.
	// 4. Enforce immutability.
	// 5. No newline characters.

	function getSecret(lines) {
	    return lines[secretKey];
	}

	function Lines(infos, sourceFileName) {
	    assert.ok(this instanceof Lines);
	    assert.ok(infos.length > 0);

	    if (sourceFileName) {
	        isString.assert(sourceFileName);
	    } else {
	        sourceFileName = null;
	    }

	    Object.defineProperty(this, secretKey, {
	        value: {
	            infos: infos,
	            mappings: [],
	            name: sourceFileName,
	            cachedSourceMap: null
	        }
	    });

	    if (sourceFileName) {
	        getSecret(this).mappings.push(new Mapping(this, {
	            start: this.firstPos(),
	            end: this.lastPos()
	        }));
	    }
	}

	// Exposed for instanceof checks. The fromString function should be used
	// to create new Lines objects.
	exports.Lines = Lines;
	var Lp = Lines.prototype;

	// These properties used to be assigned to each new object in the Lines
	// constructor, but we can more efficiently stuff them into the secret and
	// let these lazy accessors compute their values on-the-fly.
	Object.defineProperties(Lp, {
	    length: {
	        get: function() {
	            return getSecret(this).infos.length;
	        }
	    },

	    name: {
	        get: function() {
	            return getSecret(this).name;
	        }
	    }
	});

	function copyLineInfo(info) {
	    return {
	        line: info.line,
	        indent: info.indent,
	        sliceStart: info.sliceStart,
	        sliceEnd: info.sliceEnd
	    };
	}

	var fromStringCache = {};
	var hasOwn = fromStringCache.hasOwnProperty;
	var maxCacheKeyLen = 10;

	function countSpaces(spaces, tabWidth) {
	    var count = 0;
	    var len = spaces.length;

	    for (var i = 0; i < len; ++i) {
	        switch (spaces.charCodeAt(i)) {
	        case 9: // '\t'
	            assert.strictEqual(typeof tabWidth, "number");
	            assert.ok(tabWidth > 0);

	            var next = Math.ceil(count / tabWidth) * tabWidth;
	            if (next === count) {
	                count += tabWidth;
	            } else {
	                count = next;
	            }

	            break;

	        case 11: // '\v'
	        case 12: // '\f'
	        case 13: // '\r'
	        case 0xfeff: // zero-width non-breaking space
	            // These characters contribute nothing to indentation.
	            break;

	        case 32: // ' '
	        default: // Treat all other whitespace like ' '.
	            count += 1;
	            break;
	        }
	    }

	    return count;
	}
	exports.countSpaces = countSpaces;

	var leadingSpaceExp = /^\s*/;

	/**
	 * @param {Object} options - Options object that configures printing.
	 */
	function fromString(string, options) {
	    if (string instanceof Lines)
	        return string;

	    string += "";

	    var tabWidth = options && options.tabWidth;
	    var tabless = string.indexOf("\t") < 0;
	    var cacheable = !options && tabless && (string.length <= maxCacheKeyLen);

	    assert.ok(tabWidth || tabless, "No tab width specified but encountered tabs in string\n" + string);

	    if (cacheable && hasOwn.call(fromStringCache, string))
	        return fromStringCache[string];

	    var lines = new Lines(string.split("\n").map(function(line) {
	        var spaces = leadingSpaceExp.exec(line)[0];
	        return {
	            line: line,
	            indent: countSpaces(spaces, tabWidth),
	            sliceStart: spaces.length,
	            sliceEnd: line.length
	        };
	    }), normalizeOptions(options).sourceFileName);

	    if (cacheable)
	        fromStringCache[string] = lines;

	    return lines;
	}
	exports.fromString = fromString;

	function isOnlyWhitespace(string) {
	    return !/\S/.test(string);
	}

	Lp.toString = function(options) {
	    return this.sliceString(this.firstPos(), this.lastPos(), options);
	};

	Lp.getSourceMap = function(sourceMapName, sourceRoot) {
	    if (!sourceMapName) {
	        // Although we could make up a name or generate an anonymous
	        // source map, instead we assume that any consumer who does not
	        // provide a name does not actually want a source map.
	        return null;
	    }

	    var targetLines = this;

	    function updateJSON(json) {
	        json = json || {};

	        isString.assert(sourceMapName);
	        json.file = sourceMapName;

	        if (sourceRoot) {
	            isString.assert(sourceRoot);
	            json.sourceRoot = sourceRoot;
	        }

	        return json;
	    }

	    var secret = getSecret(targetLines);
	    if (secret.cachedSourceMap) {
	        // Since Lines objects are immutable, we can reuse any source map
	        // that was previously generated. Nevertheless, we return a new
	        // JSON object here to protect the cached source map from outside
	        // modification.
	        return updateJSON(secret.cachedSourceMap.toJSON());
	    }

	    var smg = new sourceMap.SourceMapGenerator(updateJSON());
	    var sourcesToContents = {};

	    secret.mappings.forEach(function(mapping) {
	        var sourceCursor = mapping.sourceLines.skipSpaces(
	            mapping.sourceLoc.start
	        ) || mapping.sourceLines.lastPos();

	        var targetCursor = targetLines.skipSpaces(
	            mapping.targetLoc.start
	        ) || targetLines.lastPos();

	        while (comparePos(sourceCursor, mapping.sourceLoc.end) < 0 &&
	               comparePos(targetCursor, mapping.targetLoc.end) < 0) {

	            var sourceChar = mapping.sourceLines.charAt(sourceCursor);
	            var targetChar = targetLines.charAt(targetCursor);
	            assert.strictEqual(sourceChar, targetChar);

	            var sourceName = mapping.sourceLines.name;

	            // Add mappings one character at a time for maximum resolution.
	            smg.addMapping({
	                source: sourceName,
	                original: { line: sourceCursor.line,
	                            column: sourceCursor.column },
	                generated: { line: targetCursor.line,
	                             column: targetCursor.column }
	            });

	            if (!hasOwn.call(sourcesToContents, sourceName)) {
	                var sourceContent = mapping.sourceLines.toString();
	                smg.setSourceContent(sourceName, sourceContent);
	                sourcesToContents[sourceName] = sourceContent;
	            }

	            targetLines.nextPos(targetCursor, true);
	            mapping.sourceLines.nextPos(sourceCursor, true);
	        }
	    });

	    secret.cachedSourceMap = smg;

	    return smg.toJSON();
	};

	Lp.bootstrapCharAt = function(pos) {
	    assert.strictEqual(typeof pos, "object");
	    assert.strictEqual(typeof pos.line, "number");
	    assert.strictEqual(typeof pos.column, "number");

	    var line = pos.line,
	        column = pos.column,
	        strings = this.toString().split("\n"),
	        string = strings[line - 1];

	    if (typeof string === "undefined")
	        return "";

	    if (column === string.length &&
	        line < strings.length)
	        return "\n";

	    if (column >= string.length)
	        return "";

	    return string.charAt(column);
	};

	Lp.charAt = function(pos) {
	    assert.strictEqual(typeof pos, "object");
	    assert.strictEqual(typeof pos.line, "number");
	    assert.strictEqual(typeof pos.column, "number");

	    var line = pos.line,
	        column = pos.column,
	        secret = getSecret(this),
	        infos = secret.infos,
	        info = infos[line - 1],
	        c = column;

	    if (typeof info === "undefined" || c < 0)
	        return "";

	    var indent = this.getIndentAt(line);
	    if (c < indent)
	        return " ";

	    c += info.sliceStart - indent;

	    if (c === info.sliceEnd &&
	        line < this.length)
	        return "\n";

	    if (c >= info.sliceEnd)
	        return "";

	    return info.line.charAt(c);
	};

	Lp.stripMargin = function(width, skipFirstLine) {
	    if (width === 0)
	        return this;

	    assert.ok(width > 0, "negative margin: " + width);

	    if (skipFirstLine && this.length === 1)
	        return this;

	    var secret = getSecret(this);

	    var lines = new Lines(secret.infos.map(function(info, i) {
	        if (info.line && (i > 0 || !skipFirstLine)) {
	            info = copyLineInfo(info);
	            info.indent = Math.max(0, info.indent - width);
	        }
	        return info;
	    }));

	    if (secret.mappings.length > 0) {
	        var newMappings = getSecret(lines).mappings;
	        assert.strictEqual(newMappings.length, 0);
	        secret.mappings.forEach(function(mapping) {
	            newMappings.push(mapping.indent(width, skipFirstLine, true));
	        });
	    }

	    return lines;
	};

	Lp.indent = function(by) {
	    if (by === 0)
	        return this;

	    var secret = getSecret(this);

	    var lines = new Lines(secret.infos.map(function(info) {
	        if (info.line) {
	            info = copyLineInfo(info);
	            info.indent += by;
	        }
	        return info
	    }));

	    if (secret.mappings.length > 0) {
	        var newMappings = getSecret(lines).mappings;
	        assert.strictEqual(newMappings.length, 0);
	        secret.mappings.forEach(function(mapping) {
	            newMappings.push(mapping.indent(by));
	        });
	    }

	    return lines;
	};

	Lp.indentTail = function(by) {
	    if (by === 0)
	        return this;

	    if (this.length < 2)
	        return this;

	    var secret = getSecret(this);

	    var lines = new Lines(secret.infos.map(function(info, i) {
	        if (i > 0 && info.line) {
	            info = copyLineInfo(info);
	            info.indent += by;
	        }

	        return info;
	    }));

	    if (secret.mappings.length > 0) {
	        var newMappings = getSecret(lines).mappings;
	        assert.strictEqual(newMappings.length, 0);
	        secret.mappings.forEach(function(mapping) {
	            newMappings.push(mapping.indent(by, true));
	        });
	    }

	    return lines;
	};

	Lp.getIndentAt = function(line) {
	    assert.ok(line >= 1, "no line " + line + " (line numbers start from 1)");
	    var secret = getSecret(this),
	        info = secret.infos[line - 1];
	    return Math.max(info.indent, 0);
	};

	Lp.guessTabWidth = function() {
	    var secret = getSecret(this);
	    if (hasOwn.call(secret, "cachedTabWidth")) {
	        return secret.cachedTabWidth;
	    }

	    var counts = []; // Sparse array.
	    var lastIndent = 0;

	    for (var line = 1, last = this.length; line <= last; ++line) {
	        var info = secret.infos[line - 1];
	        var sliced = info.line.slice(info.sliceStart, info.sliceEnd);

	        // Whitespace-only lines don't tell us much about the likely tab
	        // width of this code.
	        if (isOnlyWhitespace(sliced)) {
	            continue;
	        }

	        var diff = Math.abs(info.indent - lastIndent);
	        counts[diff] = ~~counts[diff] + 1;
	        lastIndent = info.indent;
	    }

	    var maxCount = -1;
	    var result = 2;

	    for (var tabWidth = 1;
	         tabWidth < counts.length;
	         tabWidth += 1) {
	        if (hasOwn.call(counts, tabWidth) &&
	            counts[tabWidth] > maxCount) {
	            maxCount = counts[tabWidth];
	            result = tabWidth;
	        }
	    }

	    return secret.cachedTabWidth = result;
	};

	Lp.isOnlyWhitespace = function() {
	    return isOnlyWhitespace(this.toString());
	};

	Lp.isPrecededOnlyByWhitespace = function(pos) {
	    var secret = getSecret(this);
	    var info = secret.infos[pos.line - 1];
	    var indent = Math.max(info.indent, 0);

	    var diff = pos.column - indent;
	    if (diff <= 0) {
	        // If pos.column does not exceed the indentation amount, then
	        // there must be only whitespace before it.
	        return true;
	    }

	    var start = info.sliceStart;
	    var end = Math.min(start + diff, info.sliceEnd);
	    var prefix = info.line.slice(start, end);

	    return isOnlyWhitespace(prefix);
	};

	Lp.getLineLength = function(line) {
	    var secret = getSecret(this),
	        info = secret.infos[line - 1];
	    return this.getIndentAt(line) + info.sliceEnd - info.sliceStart;
	};

	Lp.nextPos = function(pos, skipSpaces) {
	    var l = Math.max(pos.line, 0),
	        c = Math.max(pos.column, 0);

	    if (c < this.getLineLength(l)) {
	        pos.column += 1;

	        return skipSpaces
	            ? !!this.skipSpaces(pos, false, true)
	            : true;
	    }

	    if (l < this.length) {
	        pos.line += 1;
	        pos.column = 0;

	        return skipSpaces
	            ? !!this.skipSpaces(pos, false, true)
	            : true;
	    }

	    return false;
	};

	Lp.prevPos = function(pos, skipSpaces) {
	    var l = pos.line,
	        c = pos.column;

	    if (c < 1) {
	        l -= 1;

	        if (l < 1)
	            return false;

	        c = this.getLineLength(l);

	    } else {
	        c = Math.min(c - 1, this.getLineLength(l));
	    }

	    pos.line = l;
	    pos.column = c;

	    return skipSpaces
	        ? !!this.skipSpaces(pos, true, true)
	        : true;
	};

	Lp.firstPos = function() {
	    // Trivial, but provided for completeness.
	    return { line: 1, column: 0 };
	};

	Lp.lastPos = function() {
	    return {
	        line: this.length,
	        column: this.getLineLength(this.length)
	    };
	};

	Lp.skipSpaces = function(pos, backward, modifyInPlace) {
	    if (pos) {
	        pos = modifyInPlace ? pos : {
	            line: pos.line,
	            column: pos.column
	        };
	    } else if (backward) {
	        pos = this.lastPos();
	    } else {
	        pos = this.firstPos();
	    }

	    if (backward) {
	        while (this.prevPos(pos)) {
	            if (!isOnlyWhitespace(this.charAt(pos)) &&
	                this.nextPos(pos)) {
	                return pos;
	            }
	        }

	        return null;

	    } else {
	        while (isOnlyWhitespace(this.charAt(pos))) {
	            if (!this.nextPos(pos)) {
	                return null;
	            }
	        }

	        return pos;
	    }
	};

	Lp.trimLeft = function() {
	    var pos = this.skipSpaces(this.firstPos(), false, true);
	    return pos ? this.slice(pos) : emptyLines;
	};

	Lp.trimRight = function() {
	    var pos = this.skipSpaces(this.lastPos(), true, true);
	    return pos ? this.slice(this.firstPos(), pos) : emptyLines;
	};

	Lp.trim = function() {
	    var start = this.skipSpaces(this.firstPos(), false, true);
	    if (start === null)
	        return emptyLines;

	    var end = this.skipSpaces(this.lastPos(), true, true);
	    assert.notStrictEqual(end, null);

	    return this.slice(start, end);
	};

	Lp.eachPos = function(callback, startPos, skipSpaces) {
	    var pos = this.firstPos();

	    if (startPos) {
	        pos.line = startPos.line,
	        pos.column = startPos.column
	    }

	    if (skipSpaces && !this.skipSpaces(pos, false, true)) {
	        return; // Encountered nothing but spaces.
	    }

	    do callback.call(this, pos);
	    while (this.nextPos(pos, skipSpaces));
	};

	Lp.bootstrapSlice = function(start, end) {
	    var strings = this.toString().split("\n").slice(
	            start.line - 1, end.line);

	    strings.push(strings.pop().slice(0, end.column));
	    strings[0] = strings[0].slice(start.column);

	    return fromString(strings.join("\n"));
	};

	Lp.slice = function(start, end) {
	    if (!end) {
	        if (!start) {
	            // The client seems to want a copy of this Lines object, but
	            // Lines objects are immutable, so it's perfectly adequate to
	            // return the same object.
	            return this;
	        }

	        // Slice to the end if no end position was provided.
	        end = this.lastPos();
	    }

	    var secret = getSecret(this);
	    var sliced = secret.infos.slice(start.line - 1, end.line);

	    if (start.line === end.line) {
	        sliced[0] = sliceInfo(sliced[0], start.column, end.column);
	    } else {
	        assert.ok(start.line < end.line);
	        sliced[0] = sliceInfo(sliced[0], start.column);
	        sliced.push(sliceInfo(sliced.pop(), 0, end.column));
	    }

	    var lines = new Lines(sliced);

	    if (secret.mappings.length > 0) {
	        var newMappings = getSecret(lines).mappings;
	        assert.strictEqual(newMappings.length, 0);
	        secret.mappings.forEach(function(mapping) {
	            var sliced = mapping.slice(this, start, end);
	            if (sliced) {
	                newMappings.push(sliced);
	            }
	        }, this);
	    }

	    return lines;
	};

	function sliceInfo(info, startCol, endCol) {
	    var sliceStart = info.sliceStart;
	    var sliceEnd = info.sliceEnd;
	    var indent = Math.max(info.indent, 0);
	    var lineLength = indent + sliceEnd - sliceStart;

	    if (typeof endCol === "undefined") {
	        endCol = lineLength;
	    }

	    startCol = Math.max(startCol, 0);
	    endCol = Math.min(endCol, lineLength);
	    endCol = Math.max(endCol, startCol);

	    if (endCol < indent) {
	        indent = endCol;
	        sliceEnd = sliceStart;
	    } else {
	        sliceEnd -= lineLength - endCol;
	    }

	    lineLength = endCol;
	    lineLength -= startCol;

	    if (startCol < indent) {
	        indent -= startCol;
	    } else {
	        startCol -= indent;
	        indent = 0;
	        sliceStart += startCol;
	    }

	    assert.ok(indent >= 0);
	    assert.ok(sliceStart <= sliceEnd);
	    assert.strictEqual(lineLength, indent + sliceEnd - sliceStart);

	    if (info.indent === indent &&
	        info.sliceStart === sliceStart &&
	        info.sliceEnd === sliceEnd) {
	        return info;
	    }

	    return {
	        line: info.line,
	        indent: indent,
	        sliceStart: sliceStart,
	        sliceEnd: sliceEnd
	    };
	}

	Lp.bootstrapSliceString = function(start, end, options) {
	    return this.slice(start, end).toString(options);
	};

	Lp.sliceString = function(start, end, options) {
	    if (!end) {
	        if (!start) {
	            // The client seems to want a copy of this Lines object, but
	            // Lines objects are immutable, so it's perfectly adequate to
	            // return the same object.
	            return this;
	        }

	        // Slice to the end if no end position was provided.
	        end = this.lastPos();
	    }

	    options = normalizeOptions(options);

	    var infos = getSecret(this).infos;
	    var parts = [];
	    var tabWidth = options.tabWidth;

	    for (var line = start.line; line <= end.line; ++line) {
	        var info = infos[line - 1];

	        if (line === start.line) {
	            if (line === end.line) {
	                info = sliceInfo(info, start.column, end.column);
	            } else {
	                info = sliceInfo(info, start.column);
	            }
	        } else if (line === end.line) {
	            info = sliceInfo(info, 0, end.column);
	        }

	        var indent = Math.max(info.indent, 0);

	        var before = info.line.slice(0, info.sliceStart);
	        if (options.reuseWhitespace &&
	            isOnlyWhitespace(before) &&
	            countSpaces(before, options.tabWidth) === indent) {
	            // Reuse original spaces if the indentation is correct.
	            parts.push(info.line.slice(0, info.sliceEnd));
	            continue;
	        }

	        var tabs = 0;
	        var spaces = indent;

	        if (options.useTabs) {
	            tabs = Math.floor(indent / tabWidth);
	            spaces -= tabs * tabWidth;
	        }

	        var result = "";

	        if (tabs > 0) {
	            result += new Array(tabs + 1).join("\t");
	        }

	        if (spaces > 0) {
	            result += new Array(spaces + 1).join(" ");
	        }

	        result += info.line.slice(info.sliceStart, info.sliceEnd);

	        parts.push(result);
	    }

	    return parts.join("\n");
	};

	Lp.isEmpty = function() {
	    return this.length < 2 && this.getLineLength(1) < 1;
	};

	Lp.join = function(elements) {
	    var separator = this;
	    var separatorSecret = getSecret(separator);
	    var infos = [];
	    var mappings = [];
	    var prevInfo;

	    function appendSecret(secret) {
	        if (secret === null)
	            return;

	        if (prevInfo) {
	            var info = secret.infos[0];
	            var indent = new Array(info.indent + 1).join(" ");
	            var prevLine = infos.length;
	            var prevColumn = Math.max(prevInfo.indent, 0) +
	                prevInfo.sliceEnd - prevInfo.sliceStart;

	            prevInfo.line = prevInfo.line.slice(
	                0, prevInfo.sliceEnd) + indent + info.line.slice(
	                    info.sliceStart, info.sliceEnd);

	            prevInfo.sliceEnd = prevInfo.line.length;

	            if (secret.mappings.length > 0) {
	                secret.mappings.forEach(function(mapping) {
	                    mappings.push(mapping.add(prevLine, prevColumn));
	                });
	            }

	        } else if (secret.mappings.length > 0) {
	            mappings.push.apply(mappings, secret.mappings);
	        }

	        secret.infos.forEach(function(info, i) {
	            if (!prevInfo || i > 0) {
	                prevInfo = copyLineInfo(info);
	                infos.push(prevInfo);
	            }
	        });
	    }

	    function appendWithSeparator(secret, i) {
	        if (i > 0)
	            appendSecret(separatorSecret);
	        appendSecret(secret);
	    }

	    elements.map(function(elem) {
	        var lines = fromString(elem);
	        if (lines.isEmpty())
	            return null;
	        return getSecret(lines);
	    }).forEach(separator.isEmpty()
	               ? appendSecret
	               : appendWithSeparator);

	    if (infos.length < 1)
	        return emptyLines;

	    var lines = new Lines(infos);

	    getSecret(lines).mappings = mappings;

	    return lines;
	};

	exports.concat = function(elements) {
	    return emptyLines.join(elements);
	};

	Lp.concat = function(other) {
	    var args = arguments,
	        list = [this];
	    list.push.apply(list, args);
	    assert.strictEqual(list.length, args.length + 1);
	    return emptyLines.join(list);
	};

	// The emptyLines object needs to be created all the way down here so that
	// Lines.prototype will be fully populated.
	var emptyLines = fromString("");


/***/ },
/* 43 */
/***/ function(module, exports, __webpack_require__) {

	/*
	 * Copyright 2009-2011 Mozilla Foundation and contributors
	 * Licensed under the New BSD license. See LICENSE.txt or:
	 * http://opensource.org/licenses/BSD-3-Clause
	 */
	exports.SourceMapGenerator = __webpack_require__(44).SourceMapGenerator;
	exports.SourceMapConsumer = __webpack_require__(50).SourceMapConsumer;
	exports.SourceNode = __webpack_require__(52).SourceNode;


/***/ },
/* 44 */
/***/ function(module, exports, __webpack_require__) {

	var __WEBPACK_AMD_DEFINE_RESULT__;/* -*- Mode: js; js-indent-level: 2; -*- */
	/*
	 * Copyright 2011 Mozilla Foundation and contributors
	 * Licensed under the New BSD license. See LICENSE or:
	 * http://opensource.org/licenses/BSD-3-Clause
	 */
	if (false) {
	    var define = require('amdefine')(module, require);
	}
	!(__WEBPACK_AMD_DEFINE_RESULT__ = function (require, exports, module) {

	  var base64VLQ = __webpack_require__(45);
	  var util = __webpack_require__(47);
	  var ArraySet = __webpack_require__(48).ArraySet;
	  var MappingList = __webpack_require__(49).MappingList;

	  /**
	   * An instance of the SourceMapGenerator represents a source map which is
	   * being built incrementally. You may pass an object with the following
	   * properties:
	   *
	   *   - file: The filename of the generated source.
	   *   - sourceRoot: A root for all relative URLs in this source map.
	   */
	  function SourceMapGenerator(aArgs) {
	    if (!aArgs) {
	      aArgs = {};
	    }
	    this._file = util.getArg(aArgs, 'file', null);
	    this._sourceRoot = util.getArg(aArgs, 'sourceRoot', null);
	    this._skipValidation = util.getArg(aArgs, 'skipValidation', false);
	    this._sources = new ArraySet();
	    this._names = new ArraySet();
	    this._mappings = new MappingList();
	    this._sourcesContents = null;
	  }

	  SourceMapGenerator.prototype._version = 3;

	  /**
	   * Creates a new SourceMapGenerator based on a SourceMapConsumer
	   *
	   * @param aSourceMapConsumer The SourceMap.
	   */
	  SourceMapGenerator.fromSourceMap =
	    function SourceMapGenerator_fromSourceMap(aSourceMapConsumer) {
	      var sourceRoot = aSourceMapConsumer.sourceRoot;
	      var generator = new SourceMapGenerator({
	        file: aSourceMapConsumer.file,
	        sourceRoot: sourceRoot
	      });
	      aSourceMapConsumer.eachMapping(function (mapping) {
	        var newMapping = {
	          generated: {
	            line: mapping.generatedLine,
	            column: mapping.generatedColumn
	          }
	        };

	        if (mapping.source != null) {
	          newMapping.source = mapping.source;
	          if (sourceRoot != null) {
	            newMapping.source = util.relative(sourceRoot, newMapping.source);
	          }

	          newMapping.original = {
	            line: mapping.originalLine,
	            column: mapping.originalColumn
	          };

	          if (mapping.name != null) {
	            newMapping.name = mapping.name;
	          }
	        }

	        generator.addMapping(newMapping);
	      });
	      aSourceMapConsumer.sources.forEach(function (sourceFile) {
	        var content = aSourceMapConsumer.sourceContentFor(sourceFile);
	        if (content != null) {
	          generator.setSourceContent(sourceFile, content);
	        }
	      });
	      return generator;
	    };

	  /**
	   * Add a single mapping from original source line and column to the generated
	   * source's line and column for this source map being created. The mapping
	   * object should have the following properties:
	   *
	   *   - generated: An object with the generated line and column positions.
	   *   - original: An object with the original line and column positions.
	   *   - source: The original source file (relative to the sourceRoot).
	   *   - name: An optional original token name for this mapping.
	   */
	  SourceMapGenerator.prototype.addMapping =
	    function SourceMapGenerator_addMapping(aArgs) {
	      var generated = util.getArg(aArgs, 'generated');
	      var original = util.getArg(aArgs, 'original', null);
	      var source = util.getArg(aArgs, 'source', null);
	      var name = util.getArg(aArgs, 'name', null);

	      if (!this._skipValidation) {
	        this._validateMapping(generated, original, source, name);
	      }

	      if (source != null && !this._sources.has(source)) {
	        this._sources.add(source);
	      }

	      if (name != null && !this._names.has(name)) {
	        this._names.add(name);
	      }

	      this._mappings.add({
	        generatedLine: generated.line,
	        generatedColumn: generated.column,
	        originalLine: original != null && original.line,
	        originalColumn: original != null && original.column,
	        source: source,
	        name: name
	      });
	    };

	  /**
	   * Set the source content for a source file.
	   */
	  SourceMapGenerator.prototype.setSourceContent =
	    function SourceMapGenerator_setSourceContent(aSourceFile, aSourceContent) {
	      var source = aSourceFile;
	      if (this._sourceRoot != null) {
	        source = util.relative(this._sourceRoot, source);
	      }

	      if (aSourceContent != null) {
	        // Add the source content to the _sourcesContents map.
	        // Create a new _sourcesContents map if the property is null.
	        if (!this._sourcesContents) {
	          this._sourcesContents = {};
	        }
	        this._sourcesContents[util.toSetString(source)] = aSourceContent;
	      } else if (this._sourcesContents) {
	        // Remove the source file from the _sourcesContents map.
	        // If the _sourcesContents map is empty, set the property to null.
	        delete this._sourcesContents[util.toSetString(source)];
	        if (Object.keys(this._sourcesContents).length === 0) {
	          this._sourcesContents = null;
	        }
	      }
	    };

	  /**
	   * Applies the mappings of a sub-source-map for a specific source file to the
	   * source map being generated. Each mapping to the supplied source file is
	   * rewritten using the supplied source map. Note: The resolution for the
	   * resulting mappings is the minimium of this map and the supplied map.
	   *
	   * @param aSourceMapConsumer The source map to be applied.
	   * @param aSourceFile Optional. The filename of the source file.
	   *        If omitted, SourceMapConsumer's file property will be used.
	   * @param aSourceMapPath Optional. The dirname of the path to the source map
	   *        to be applied. If relative, it is relative to the SourceMapConsumer.
	   *        This parameter is needed when the two source maps aren't in the same
	   *        directory, and the source map to be applied contains relative source
	   *        paths. If so, those relative source paths need to be rewritten
	   *        relative to the SourceMapGenerator.
	   */
	  SourceMapGenerator.prototype.applySourceMap =
	    function SourceMapGenerator_applySourceMap(aSourceMapConsumer, aSourceFile, aSourceMapPath) {
	      var sourceFile = aSourceFile;
	      // If aSourceFile is omitted, we will use the file property of the SourceMap
	      if (aSourceFile == null) {
	        if (aSourceMapConsumer.file == null) {
	          throw new Error(
	            'SourceMapGenerator.prototype.applySourceMap requires either an explicit source file, ' +
	            'or the source map\'s "file" property. Both were omitted.'
	          );
	        }
	        sourceFile = aSourceMapConsumer.file;
	      }
	      var sourceRoot = this._sourceRoot;
	      // Make "sourceFile" relative if an absolute Url is passed.
	      if (sourceRoot != null) {
	        sourceFile = util.relative(sourceRoot, sourceFile);
	      }
	      // Applying the SourceMap can add and remove items from the sources and
	      // the names array.
	      var newSources = new ArraySet();
	      var newNames = new ArraySet();

	      // Find mappings for the "sourceFile"
	      this._mappings.unsortedForEach(function (mapping) {
	        if (mapping.source === sourceFile && mapping.originalLine != null) {
	          // Check if it can be mapped by the source map, then update the mapping.
	          var original = aSourceMapConsumer.originalPositionFor({
	            line: mapping.originalLine,
	            column: mapping.originalColumn
	          });
	          if (original.source != null) {
	            // Copy mapping
	            mapping.source = original.source;
	            if (aSourceMapPath != null) {
	              mapping.source = util.join(aSourceMapPath, mapping.source)
	            }
	            if (sourceRoot != null) {
	              mapping.source = util.relative(sourceRoot, mapping.source);
	            }
	            mapping.originalLine = original.line;
	            mapping.originalColumn = original.column;
	            if (original.name != null) {
	              mapping.name = original.name;
	            }
	          }
	        }

	        var source = mapping.source;
	        if (source != null && !newSources.has(source)) {
	          newSources.add(source);
	        }

	        var name = mapping.name;
	        if (name != null && !newNames.has(name)) {
	          newNames.add(name);
	        }

	      }, this);
	      this._sources = newSources;
	      this._names = newNames;

	      // Copy sourcesContents of applied map.
	      aSourceMapConsumer.sources.forEach(function (sourceFile) {
	        var content = aSourceMapConsumer.sourceContentFor(sourceFile);
	        if (content != null) {
	          if (aSourceMapPath != null) {
	            sourceFile = util.join(aSourceMapPath, sourceFile);
	          }
	          if (sourceRoot != null) {
	            sourceFile = util.relative(sourceRoot, sourceFile);
	          }
	          this.setSourceContent(sourceFile, content);
	        }
	      }, this);
	    };

	  /**
	   * A mapping can have one of the three levels of data:
	   *
	   *   1. Just the generated position.
	   *   2. The Generated position, original position, and original source.
	   *   3. Generated and original position, original source, as well as a name
	   *      token.
	   *
	   * To maintain consistency, we validate that any new mapping being added falls
	   * in to one of these categories.
	   */
	  SourceMapGenerator.prototype._validateMapping =
	    function SourceMapGenerator_validateMapping(aGenerated, aOriginal, aSource,
	                                                aName) {
	      if (aGenerated && 'line' in aGenerated && 'column' in aGenerated
	          && aGenerated.line > 0 && aGenerated.column >= 0
	          && !aOriginal && !aSource && !aName) {
	        // Case 1.
	        return;
	      }
	      else if (aGenerated && 'line' in aGenerated && 'column' in aGenerated
	               && aOriginal && 'line' in aOriginal && 'column' in aOriginal
	               && aGenerated.line > 0 && aGenerated.column >= 0
	               && aOriginal.line > 0 && aOriginal.column >= 0
	               && aSource) {
	        // Cases 2 and 3.
	        return;
	      }
	      else {
	        throw new Error('Invalid mapping: ' + JSON.stringify({
	          generated: aGenerated,
	          source: aSource,
	          original: aOriginal,
	          name: aName
	        }));
	      }
	    };

	  /**
	   * Serialize the accumulated mappings in to the stream of base 64 VLQs
	   * specified by the source map format.
	   */
	  SourceMapGenerator.prototype._serializeMappings =
	    function SourceMapGenerator_serializeMappings() {
	      var previousGeneratedColumn = 0;
	      var previousGeneratedLine = 1;
	      var previousOriginalColumn = 0;
	      var previousOriginalLine = 0;
	      var previousName = 0;
	      var previousSource = 0;
	      var result = '';
	      var mapping;

	      var mappings = this._mappings.toArray();

	      for (var i = 0, len = mappings.length; i < len; i++) {
	        mapping = mappings[i];

	        if (mapping.generatedLine !== previousGeneratedLine) {
	          previousGeneratedColumn = 0;
	          while (mapping.generatedLine !== previousGeneratedLine) {
	            result += ';';
	            previousGeneratedLine++;
	          }
	        }
	        else {
	          if (i > 0) {
	            if (!util.compareByGeneratedPositions(mapping, mappings[i - 1])) {
	              continue;
	            }
	            result += ',';
	          }
	        }

	        result += base64VLQ.encode(mapping.generatedColumn
	                                   - previousGeneratedColumn);
	        previousGeneratedColumn = mapping.generatedColumn;

	        if (mapping.source != null) {
	          result += base64VLQ.encode(this._sources.indexOf(mapping.source)
	                                     - previousSource);
	          previousSource = this._sources.indexOf(mapping.source);

	          // lines are stored 0-based in SourceMap spec version 3
	          result += base64VLQ.encode(mapping.originalLine - 1
	                                     - previousOriginalLine);
	          previousOriginalLine = mapping.originalLine - 1;

	          result += base64VLQ.encode(mapping.originalColumn
	                                     - previousOriginalColumn);
	          previousOriginalColumn = mapping.originalColumn;

	          if (mapping.name != null) {
	            result += base64VLQ.encode(this._names.indexOf(mapping.name)
	                                       - previousName);
	            previousName = this._names.indexOf(mapping.name);
	          }
	        }
	      }

	      return result;
	    };

	  SourceMapGenerator.prototype._generateSourcesContent =
	    function SourceMapGenerator_generateSourcesContent(aSources, aSourceRoot) {
	      return aSources.map(function (source) {
	        if (!this._sourcesContents) {
	          return null;
	        }
	        if (aSourceRoot != null) {
	          source = util.relative(aSourceRoot, source);
	        }
	        var key = util.toSetString(source);
	        return Object.prototype.hasOwnProperty.call(this._sourcesContents,
	                                                    key)
	          ? this._sourcesContents[key]
	          : null;
	      }, this);
	    };

	  /**
	   * Externalize the source map.
	   */
	  SourceMapGenerator.prototype.toJSON =
	    function SourceMapGenerator_toJSON() {
	      var map = {
	        version: this._version,
	        sources: this._sources.toArray(),
	        names: this._names.toArray(),
	        mappings: this._serializeMappings()
	      };
	      if (this._file != null) {
	        map.file = this._file;
	      }
	      if (this._sourceRoot != null) {
	        map.sourceRoot = this._sourceRoot;
	      }
	      if (this._sourcesContents) {
	        map.sourcesContent = this._generateSourcesContent(map.sources, map.sourceRoot);
	      }

	      return map;
	    };

	  /**
	   * Render the source map being generated to a string.
	   */
	  SourceMapGenerator.prototype.toString =
	    function SourceMapGenerator_toString() {
	      return JSON.stringify(this);
	    };

	  exports.SourceMapGenerator = SourceMapGenerator;

	}.call(exports, __webpack_require__, exports, module), __WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));


/***/ },
/* 45 */
/***/ function(module, exports, __webpack_require__) {

	var __WEBPACK_AMD_DEFINE_RESULT__;/* -*- Mode: js; js-indent-level: 2; -*- */
	/*
	 * Copyright 2011 Mozilla Foundation and contributors
	 * Licensed under the New BSD license. See LICENSE or:
	 * http://opensource.org/licenses/BSD-3-Clause
	 *
	 * Based on the Base 64 VLQ implementation in Closure Compiler:
	 * https://code.google.com/p/closure-compiler/source/browse/trunk/src/com/google/debugging/sourcemap/Base64VLQ.java
	 *
	 * Copyright 2011 The Closure Compiler Authors. All rights reserved.
	 * Redistribution and use in source and binary forms, with or without
	 * modification, are permitted provided that the following conditions are
	 * met:
	 *
	 *  * Redistributions of source code must retain the above copyright
	 *    notice, this list of conditions and the following disclaimer.
	 *  * Redistributions in binary form must reproduce the above
	 *    copyright notice, this list of conditions and the following
	 *    disclaimer in the documentation and/or other materials provided
	 *    with the distribution.
	 *  * Neither the name of Google Inc. nor the names of its
	 *    contributors may be used to endorse or promote products derived
	 *    from this software without specific prior written permission.
	 *
	 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
	 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
	 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
	 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
	 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
	 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
	 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
	 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
	 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
	 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
	 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
	 */
	if (false) {
	    var define = require('amdefine')(module, require);
	}
	!(__WEBPACK_AMD_DEFINE_RESULT__ = function (require, exports, module) {

	  var base64 = __webpack_require__(46);

	  // A single base 64 digit can contain 6 bits of data. For the base 64 variable
	  // length quantities we use in the source map spec, the first bit is the sign,
	  // the next four bits are the actual value, and the 6th bit is the
	  // continuation bit. The continuation bit tells us whether there are more
	  // digits in this value following this digit.
	  //
	  //   Continuation
	  //   |    Sign
	  //   |    |
	  //   V    V
	  //   101011

	  var VLQ_BASE_SHIFT = 5;

	  // binary: 100000
	  var VLQ_BASE = 1 << VLQ_BASE_SHIFT;

	  // binary: 011111
	  var VLQ_BASE_MASK = VLQ_BASE - 1;

	  // binary: 100000
	  var VLQ_CONTINUATION_BIT = VLQ_BASE;

	  /**
	   * Converts from a two-complement value to a value where the sign bit is
	   * placed in the least significant bit.  For example, as decimals:
	   *   1 becomes 2 (10 binary), -1 becomes 3 (11 binary)
	   *   2 becomes 4 (100 binary), -2 becomes 5 (101 binary)
	   */
	  function toVLQSigned(aValue) {
	    return aValue < 0
	      ? ((-aValue) << 1) + 1
	      : (aValue << 1) + 0;
	  }

	  /**
	   * Converts to a two-complement value from a value where the sign bit is
	   * placed in the least significant bit.  For example, as decimals:
	   *   2 (10 binary) becomes 1, 3 (11 binary) becomes -1
	   *   4 (100 binary) becomes 2, 5 (101 binary) becomes -2
	   */
	  function fromVLQSigned(aValue) {
	    var isNegative = (aValue & 1) === 1;
	    var shifted = aValue >> 1;
	    return isNegative
	      ? -shifted
	      : shifted;
	  }

	  /**
	   * Returns the base 64 VLQ encoded value.
	   */
	  exports.encode = function base64VLQ_encode(aValue) {
	    var encoded = "";
	    var digit;

	    var vlq = toVLQSigned(aValue);

	    do {
	      digit = vlq & VLQ_BASE_MASK;
	      vlq >>>= VLQ_BASE_SHIFT;
	      if (vlq > 0) {
	        // There are still more digits in this value, so we must make sure the
	        // continuation bit is marked.
	        digit |= VLQ_CONTINUATION_BIT;
	      }
	      encoded += base64.encode(digit);
	    } while (vlq > 0);

	    return encoded;
	  };

	  /**
	   * Decodes the next base 64 VLQ value from the given string and returns the
	   * value and the rest of the string via the out parameter.
	   */
	  exports.decode = function base64VLQ_decode(aStr, aOutParam) {
	    var i = 0;
	    var strLen = aStr.length;
	    var result = 0;
	    var shift = 0;
	    var continuation, digit;

	    do {
	      if (i >= strLen) {
	        throw new Error("Expected more digits in base 64 VLQ value.");
	      }
	      digit = base64.decode(aStr.charAt(i++));
	      continuation = !!(digit & VLQ_CONTINUATION_BIT);
	      digit &= VLQ_BASE_MASK;
	      result = result + (digit << shift);
	      shift += VLQ_BASE_SHIFT;
	    } while (continuation);

	    aOutParam.value = fromVLQSigned(result);
	    aOutParam.rest = aStr.slice(i);
	  };

	}.call(exports, __webpack_require__, exports, module), __WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));


/***/ },
/* 46 */
/***/ function(module, exports, __webpack_require__) {

	var __WEBPACK_AMD_DEFINE_RESULT__;/* -*- Mode: js; js-indent-level: 2; -*- */
	/*
	 * Copyright 2011 Mozilla Foundation and contributors
	 * Licensed under the New BSD license. See LICENSE or:
	 * http://opensource.org/licenses/BSD-3-Clause
	 */
	if (false) {
	    var define = require('amdefine')(module, require);
	}
	!(__WEBPACK_AMD_DEFINE_RESULT__ = function (require, exports, module) {

	  var charToIntMap = {};
	  var intToCharMap = {};

	  'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/'
	    .split('')
	    .forEach(function (ch, index) {
	      charToIntMap[ch] = index;
	      intToCharMap[index] = ch;
	    });

	  /**
	   * Encode an integer in the range of 0 to 63 to a single base 64 digit.
	   */
	  exports.encode = function base64_encode(aNumber) {
	    if (aNumber in intToCharMap) {
	      return intToCharMap[aNumber];
	    }
	    throw new TypeError("Must be between 0 and 63: " + aNumber);
	  };

	  /**
	   * Decode a single base 64 digit to an integer.
	   */
	  exports.decode = function base64_decode(aChar) {
	    if (aChar in charToIntMap) {
	      return charToIntMap[aChar];
	    }
	    throw new TypeError("Not a valid base 64 digit: " + aChar);
	  };

	}.call(exports, __webpack_require__, exports, module), __WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));


/***/ },
/* 47 */
/***/ function(module, exports, __webpack_require__) {

	var __WEBPACK_AMD_DEFINE_RESULT__;/* -*- Mode: js; js-indent-level: 2; -*- */
	/*
	 * Copyright 2011 Mozilla Foundation and contributors
	 * Licensed under the New BSD license. See LICENSE or:
	 * http://opensource.org/licenses/BSD-3-Clause
	 */
	if (false) {
	    var define = require('amdefine')(module, require);
	}
	!(__WEBPACK_AMD_DEFINE_RESULT__ = function (require, exports, module) {

	  /**
	   * This is a helper function for getting values from parameter/options
	   * objects.
	   *
	   * @param args The object we are extracting values from
	   * @param name The name of the property we are getting.
	   * @param defaultValue An optional value to return if the property is missing
	   * from the object. If this is not specified and the property is missing, an
	   * error will be thrown.
	   */
	  function getArg(aArgs, aName, aDefaultValue) {
	    if (aName in aArgs) {
	      return aArgs[aName];
	    } else if (arguments.length === 3) {
	      return aDefaultValue;
	    } else {
	      throw new Error('"' + aName + '" is a required argument.');
	    }
	  }
	  exports.getArg = getArg;

	  var urlRegexp = /^(?:([\w+\-.]+):)?\/\/(?:(\w+:\w+)@)?([\w.]*)(?::(\d+))?(\S*)$/;
	  var dataUrlRegexp = /^data:.+\,.+$/;

	  function urlParse(aUrl) {
	    var match = aUrl.match(urlRegexp);
	    if (!match) {
	      return null;
	    }
	    return {
	      scheme: match[1],
	      auth: match[2],
	      host: match[3],
	      port: match[4],
	      path: match[5]
	    };
	  }
	  exports.urlParse = urlParse;

	  function urlGenerate(aParsedUrl) {
	    var url = '';
	    if (aParsedUrl.scheme) {
	      url += aParsedUrl.scheme + ':';
	    }
	    url += '//';
	    if (aParsedUrl.auth) {
	      url += aParsedUrl.auth + '@';
	    }
	    if (aParsedUrl.host) {
	      url += aParsedUrl.host;
	    }
	    if (aParsedUrl.port) {
	      url += ":" + aParsedUrl.port
	    }
	    if (aParsedUrl.path) {
	      url += aParsedUrl.path;
	    }
	    return url;
	  }
	  exports.urlGenerate = urlGenerate;

	  /**
	   * Normalizes a path, or the path portion of a URL:
	   *
	   * - Replaces consequtive slashes with one slash.
	   * - Removes unnecessary '.' parts.
	   * - Removes unnecessary '<dir>/..' parts.
	   *
	   * Based on code in the Node.js 'path' core module.
	   *
	   * @param aPath The path or url to normalize.
	   */
	  function normalize(aPath) {
	    var path = aPath;
	    var url = urlParse(aPath);
	    if (url) {
	      if (!url.path) {
	        return aPath;
	      }
	      path = url.path;
	    }
	    var isAbsolute = (path.charAt(0) === '/');

	    var parts = path.split(/\/+/);
	    for (var part, up = 0, i = parts.length - 1; i >= 0; i--) {
	      part = parts[i];
	      if (part === '.') {
	        parts.splice(i, 1);
	      } else if (part === '..') {
	        up++;
	      } else if (up > 0) {
	        if (part === '') {
	          // The first part is blank if the path is absolute. Trying to go
	          // above the root is a no-op. Therefore we can remove all '..' parts
	          // directly after the root.
	          parts.splice(i + 1, up);
	          up = 0;
	        } else {
	          parts.splice(i, 2);
	          up--;
	        }
	      }
	    }
	    path = parts.join('/');

	    if (path === '') {
	      path = isAbsolute ? '/' : '.';
	    }

	    if (url) {
	      url.path = path;
	      return urlGenerate(url);
	    }
	    return path;
	  }
	  exports.normalize = normalize;

	  /**
	   * Joins two paths/URLs.
	   *
	   * @param aRoot The root path or URL.
	   * @param aPath The path or URL to be joined with the root.
	   *
	   * - If aPath is a URL or a data URI, aPath is returned, unless aPath is a
	   *   scheme-relative URL: Then the scheme of aRoot, if any, is prepended
	   *   first.
	   * - Otherwise aPath is a path. If aRoot is a URL, then its path portion
	   *   is updated with the result and aRoot is returned. Otherwise the result
	   *   is returned.
	   *   - If aPath is absolute, the result is aPath.
	   *   - Otherwise the two paths are joined with a slash.
	   * - Joining for example 'http://' and 'www.example.com' is also supported.
	   */
	  function join(aRoot, aPath) {
	    if (aRoot === "") {
	      aRoot = ".";
	    }
	    if (aPath === "") {
	      aPath = ".";
	    }
	    var aPathUrl = urlParse(aPath);
	    var aRootUrl = urlParse(aRoot);
	    if (aRootUrl) {
	      aRoot = aRootUrl.path || '/';
	    }

	    // `join(foo, '//www.example.org')`
	    if (aPathUrl && !aPathUrl.scheme) {
	      if (aRootUrl) {
	        aPathUrl.scheme = aRootUrl.scheme;
	      }
	      return urlGenerate(aPathUrl);
	    }

	    if (aPathUrl || aPath.match(dataUrlRegexp)) {
	      return aPath;
	    }

	    // `join('http://', 'www.example.com')`
	    if (aRootUrl && !aRootUrl.host && !aRootUrl.path) {
	      aRootUrl.host = aPath;
	      return urlGenerate(aRootUrl);
	    }

	    var joined = aPath.charAt(0) === '/'
	      ? aPath
	      : normalize(aRoot.replace(/\/+$/, '') + '/' + aPath);

	    if (aRootUrl) {
	      aRootUrl.path = joined;
	      return urlGenerate(aRootUrl);
	    }
	    return joined;
	  }
	  exports.join = join;

	  /**
	   * Make a path relative to a URL or another path.
	   *
	   * @param aRoot The root path or URL.
	   * @param aPath The path or URL to be made relative to aRoot.
	   */
	  function relative(aRoot, aPath) {
	    if (aRoot === "") {
	      aRoot = ".";
	    }

	    aRoot = aRoot.replace(/\/$/, '');

	    // XXX: It is possible to remove this block, and the tests still pass!
	    var url = urlParse(aRoot);
	    if (aPath.charAt(0) == "/" && url && url.path == "/") {
	      return aPath.slice(1);
	    }

	    return aPath.indexOf(aRoot + '/') === 0
	      ? aPath.substr(aRoot.length + 1)
	      : aPath;
	  }
	  exports.relative = relative;

	  /**
	   * Because behavior goes wacky when you set `__proto__` on objects, we
	   * have to prefix all the strings in our set with an arbitrary character.
	   *
	   * See https://github.com/mozilla/source-map/pull/31 and
	   * https://github.com/mozilla/source-map/issues/30
	   *
	   * @param String aStr
	   */
	  function toSetString(aStr) {
	    return '$' + aStr;
	  }
	  exports.toSetString = toSetString;

	  function fromSetString(aStr) {
	    return aStr.substr(1);
	  }
	  exports.fromSetString = fromSetString;

	  function strcmp(aStr1, aStr2) {
	    var s1 = aStr1 || "";
	    var s2 = aStr2 || "";
	    return (s1 > s2) - (s1 < s2);
	  }

	  /**
	   * Comparator between two mappings where the original positions are compared.
	   *
	   * Optionally pass in `true` as `onlyCompareGenerated` to consider two
	   * mappings with the same original source/line/column, but different generated
	   * line and column the same. Useful when searching for a mapping with a
	   * stubbed out mapping.
	   */
	  function compareByOriginalPositions(mappingA, mappingB, onlyCompareOriginal) {
	    var cmp;

	    cmp = strcmp(mappingA.source, mappingB.source);
	    if (cmp) {
	      return cmp;
	    }

	    cmp = mappingA.originalLine - mappingB.originalLine;
	    if (cmp) {
	      return cmp;
	    }

	    cmp = mappingA.originalColumn - mappingB.originalColumn;
	    if (cmp || onlyCompareOriginal) {
	      return cmp;
	    }

	    cmp = strcmp(mappingA.name, mappingB.name);
	    if (cmp) {
	      return cmp;
	    }

	    cmp = mappingA.generatedLine - mappingB.generatedLine;
	    if (cmp) {
	      return cmp;
	    }

	    return mappingA.generatedColumn - mappingB.generatedColumn;
	  };
	  exports.compareByOriginalPositions = compareByOriginalPositions;

	  /**
	   * Comparator between two mappings where the generated positions are
	   * compared.
	   *
	   * Optionally pass in `true` as `onlyCompareGenerated` to consider two
	   * mappings with the same generated line and column, but different
	   * source/name/original line and column the same. Useful when searching for a
	   * mapping with a stubbed out mapping.
	   */
	  function compareByGeneratedPositions(mappingA, mappingB, onlyCompareGenerated) {
	    var cmp;

	    cmp = mappingA.generatedLine - mappingB.generatedLine;
	    if (cmp) {
	      return cmp;
	    }

	    cmp = mappingA.generatedColumn - mappingB.generatedColumn;
	    if (cmp || onlyCompareGenerated) {
	      return cmp;
	    }

	    cmp = strcmp(mappingA.source, mappingB.source);
	    if (cmp) {
	      return cmp;
	    }

	    cmp = mappingA.originalLine - mappingB.originalLine;
	    if (cmp) {
	      return cmp;
	    }

	    cmp = mappingA.originalColumn - mappingB.originalColumn;
	    if (cmp) {
	      return cmp;
	    }

	    return strcmp(mappingA.name, mappingB.name);
	  };
	  exports.compareByGeneratedPositions = compareByGeneratedPositions;

	}.call(exports, __webpack_require__, exports, module), __WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));


/***/ },
/* 48 */
/***/ function(module, exports, __webpack_require__) {

	var __WEBPACK_AMD_DEFINE_RESULT__;/* -*- Mode: js; js-indent-level: 2; -*- */
	/*
	 * Copyright 2011 Mozilla Foundation and contributors
	 * Licensed under the New BSD license. See LICENSE or:
	 * http://opensource.org/licenses/BSD-3-Clause
	 */
	if (false) {
	    var define = require('amdefine')(module, require);
	}
	!(__WEBPACK_AMD_DEFINE_RESULT__ = function (require, exports, module) {

	  var util = __webpack_require__(47);

	  /**
	   * A data structure which is a combination of an array and a set. Adding a new
	   * member is O(1), testing for membership is O(1), and finding the index of an
	   * element is O(1). Removing elements from the set is not supported. Only
	   * strings are supported for membership.
	   */
	  function ArraySet() {
	    this._array = [];
	    this._set = {};
	  }

	  /**
	   * Static method for creating ArraySet instances from an existing array.
	   */
	  ArraySet.fromArray = function ArraySet_fromArray(aArray, aAllowDuplicates) {
	    var set = new ArraySet();
	    for (var i = 0, len = aArray.length; i < len; i++) {
	      set.add(aArray[i], aAllowDuplicates);
	    }
	    return set;
	  };

	  /**
	   * Add the given string to this set.
	   *
	   * @param String aStr
	   */
	  ArraySet.prototype.add = function ArraySet_add(aStr, aAllowDuplicates) {
	    var isDuplicate = this.has(aStr);
	    var idx = this._array.length;
	    if (!isDuplicate || aAllowDuplicates) {
	      this._array.push(aStr);
	    }
	    if (!isDuplicate) {
	      this._set[util.toSetString(aStr)] = idx;
	    }
	  };

	  /**
	   * Is the given string a member of this set?
	   *
	   * @param String aStr
	   */
	  ArraySet.prototype.has = function ArraySet_has(aStr) {
	    return Object.prototype.hasOwnProperty.call(this._set,
	                                                util.toSetString(aStr));
	  };

	  /**
	   * What is the index of the given string in the array?
	   *
	   * @param String aStr
	   */
	  ArraySet.prototype.indexOf = function ArraySet_indexOf(aStr) {
	    if (this.has(aStr)) {
	      return this._set[util.toSetString(aStr)];
	    }
	    throw new Error('"' + aStr + '" is not in the set.');
	  };

	  /**
	   * What is the element at the given index?
	   *
	   * @param Number aIdx
	   */
	  ArraySet.prototype.at = function ArraySet_at(aIdx) {
	    if (aIdx >= 0 && aIdx < this._array.length) {
	      return this._array[aIdx];
	    }
	    throw new Error('No element indexed by ' + aIdx);
	  };

	  /**
	   * Returns the array representation of this set (which has the proper indices
	   * indicated by indexOf). Note that this is a copy of the internal array used
	   * for storing the members so that no one can mess with internal state.
	   */
	  ArraySet.prototype.toArray = function ArraySet_toArray() {
	    return this._array.slice();
	  };

	  exports.ArraySet = ArraySet;

	}.call(exports, __webpack_require__, exports, module), __WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));


/***/ },
/* 49 */
/***/ function(module, exports, __webpack_require__) {

	var __WEBPACK_AMD_DEFINE_RESULT__;/* -*- Mode: js; js-indent-level: 2; -*- */
	/*
	 * Copyright 2014 Mozilla Foundation and contributors
	 * Licensed under the New BSD license. See LICENSE or:
	 * http://opensource.org/licenses/BSD-3-Clause
	 */
	if (false) {
	    var define = require('amdefine')(module, require);
	}
	!(__WEBPACK_AMD_DEFINE_RESULT__ = function (require, exports, module) {

	  var util = __webpack_require__(47);

	  /**
	   * Determine whether mappingB is after mappingA with respect to generated
	   * position.
	   */
	  function generatedPositionAfter(mappingA, mappingB) {
	    // Optimized for most common case
	    var lineA = mappingA.generatedLine;
	    var lineB = mappingB.generatedLine;
	    var columnA = mappingA.generatedColumn;
	    var columnB = mappingB.generatedColumn;
	    return lineB > lineA || lineB == lineA && columnB >= columnA ||
	           util.compareByGeneratedPositions(mappingA, mappingB) <= 0;
	  }

	  /**
	   * A data structure to provide a sorted view of accumulated mappings in a
	   * performance conscious manner. It trades a neglibable overhead in general
	   * case for a large speedup in case of mappings being added in order.
	   */
	  function MappingList() {
	    this._array = [];
	    this._sorted = true;
	    // Serves as infimum
	    this._last = {generatedLine: -1, generatedColumn: 0};
	  }

	  /**
	   * Iterate through internal items. This method takes the same arguments that
	   * `Array.prototype.forEach` takes.
	   *
	   * NOTE: The order of the mappings is NOT guaranteed.
	   */
	  MappingList.prototype.unsortedForEach =
	    function MappingList_forEach(aCallback, aThisArg) {
	      this._array.forEach(aCallback, aThisArg);
	    };

	  /**
	   * Add the given source mapping.
	   *
	   * @param Object aMapping
	   */
	  MappingList.prototype.add = function MappingList_add(aMapping) {
	    var mapping;
	    if (generatedPositionAfter(this._last, aMapping)) {
	      this._last = aMapping;
	      this._array.push(aMapping);
	    } else {
	      this._sorted = false;
	      this._array.push(aMapping);
	    }
	  };

	  /**
	   * Returns the flat, sorted array of mappings. The mappings are sorted by
	   * generated position.
	   *
	   * WARNING: This method returns internal data without copying, for
	   * performance. The return value must NOT be mutated, and should be treated as
	   * an immutable borrow. If you want to take ownership, you must make your own
	   * copy.
	   */
	  MappingList.prototype.toArray = function MappingList_toArray() {
	    if (!this._sorted) {
	      this._array.sort(util.compareByGeneratedPositions);
	      this._sorted = true;
	    }
	    return this._array;
	  };

	  exports.MappingList = MappingList;

	}.call(exports, __webpack_require__, exports, module), __WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));


/***/ },
/* 50 */
/***/ function(module, exports, __webpack_require__) {

	var __WEBPACK_AMD_DEFINE_RESULT__;/* -*- Mode: js; js-indent-level: 2; -*- */
	/*
	 * Copyright 2011 Mozilla Foundation and contributors
	 * Licensed under the New BSD license. See LICENSE or:
	 * http://opensource.org/licenses/BSD-3-Clause
	 */
	if (false) {
	    var define = require('amdefine')(module, require);
	}
	!(__WEBPACK_AMD_DEFINE_RESULT__ = function (require, exports, module) {

	  var util = __webpack_require__(47);
	  var binarySearch = __webpack_require__(51);
	  var ArraySet = __webpack_require__(48).ArraySet;
	  var base64VLQ = __webpack_require__(45);

	  /**
	   * A SourceMapConsumer instance represents a parsed source map which we can
	   * query for information about the original file positions by giving it a file
	   * position in the generated source.
	   *
	   * The only parameter is the raw source map (either as a JSON string, or
	   * already parsed to an object). According to the spec, source maps have the
	   * following attributes:
	   *
	   *   - version: Which version of the source map spec this map is following.
	   *   - sources: An array of URLs to the original source files.
	   *   - names: An array of identifiers which can be referrenced by individual mappings.
	   *   - sourceRoot: Optional. The URL root from which all sources are relative.
	   *   - sourcesContent: Optional. An array of contents of the original source files.
	   *   - mappings: A string of base64 VLQs which contain the actual mappings.
	   *   - file: Optional. The generated file this source map is associated with.
	   *
	   * Here is an example source map, taken from the source map spec[0]:
	   *
	   *     {
	   *       version : 3,
	   *       file: "out.js",
	   *       sourceRoot : "",
	   *       sources: ["foo.js", "bar.js"],
	   *       names: ["src", "maps", "are", "fun"],
	   *       mappings: "AA,AB;;ABCDE;"
	   *     }
	   *
	   * [0]: https://docs.google.com/document/d/1U1RGAehQwRypUTovF1KRlpiOFze0b-_2gc6fAH0KY0k/edit?pli=1#
	   */
	  function SourceMapConsumer(aSourceMap) {
	    var sourceMap = aSourceMap;
	    if (typeof aSourceMap === 'string') {
	      sourceMap = JSON.parse(aSourceMap.replace(/^\)\]\}'/, ''));
	    }

	    var version = util.getArg(sourceMap, 'version');
	    var sources = util.getArg(sourceMap, 'sources');
	    // Sass 3.3 leaves out the 'names' array, so we deviate from the spec (which
	    // requires the array) to play nice here.
	    var names = util.getArg(sourceMap, 'names', []);
	    var sourceRoot = util.getArg(sourceMap, 'sourceRoot', null);
	    var sourcesContent = util.getArg(sourceMap, 'sourcesContent', null);
	    var mappings = util.getArg(sourceMap, 'mappings');
	    var file = util.getArg(sourceMap, 'file', null);

	    // Once again, Sass deviates from the spec and supplies the version as a
	    // string rather than a number, so we use loose equality checking here.
	    if (version != this._version) {
	      throw new Error('Unsupported version: ' + version);
	    }

	    // Some source maps produce relative source paths like "./foo.js" instead of
	    // "foo.js".  Normalize these first so that future comparisons will succeed.
	    // See bugzil.la/1090768.
	    sources = sources.map(util.normalize);

	    // Pass `true` below to allow duplicate names and sources. While source maps
	    // are intended to be compressed and deduplicated, the TypeScript compiler
	    // sometimes generates source maps with duplicates in them. See Github issue
	    // #72 and bugzil.la/889492.
	    this._names = ArraySet.fromArray(names, true);
	    this._sources = ArraySet.fromArray(sources, true);

	    this.sourceRoot = sourceRoot;
	    this.sourcesContent = sourcesContent;
	    this._mappings = mappings;
	    this.file = file;
	  }

	  /**
	   * Create a SourceMapConsumer from a SourceMapGenerator.
	   *
	   * @param SourceMapGenerator aSourceMap
	   *        The source map that will be consumed.
	   * @returns SourceMapConsumer
	   */
	  SourceMapConsumer.fromSourceMap =
	    function SourceMapConsumer_fromSourceMap(aSourceMap) {
	      var smc = Object.create(SourceMapConsumer.prototype);

	      smc._names = ArraySet.fromArray(aSourceMap._names.toArray(), true);
	      smc._sources = ArraySet.fromArray(aSourceMap._sources.toArray(), true);
	      smc.sourceRoot = aSourceMap._sourceRoot;
	      smc.sourcesContent = aSourceMap._generateSourcesContent(smc._sources.toArray(),
	                                                              smc.sourceRoot);
	      smc.file = aSourceMap._file;

	      smc.__generatedMappings = aSourceMap._mappings.toArray().slice();
	      smc.__originalMappings = aSourceMap._mappings.toArray().slice()
	        .sort(util.compareByOriginalPositions);

	      return smc;
	    };

	  /**
	   * The version of the source mapping spec that we are consuming.
	   */
	  SourceMapConsumer.prototype._version = 3;

	  /**
	   * The list of original sources.
	   */
	  Object.defineProperty(SourceMapConsumer.prototype, 'sources', {
	    get: function () {
	      return this._sources.toArray().map(function (s) {
	        return this.sourceRoot != null ? util.join(this.sourceRoot, s) : s;
	      }, this);
	    }
	  });

	  // `__generatedMappings` and `__originalMappings` are arrays that hold the
	  // parsed mapping coordinates from the source map's "mappings" attribute. They
	  // are lazily instantiated, accessed via the `_generatedMappings` and
	  // `_originalMappings` getters respectively, and we only parse the mappings
	  // and create these arrays once queried for a source location. We jump through
	  // these hoops because there can be many thousands of mappings, and parsing
	  // them is expensive, so we only want to do it if we must.
	  //
	  // Each object in the arrays is of the form:
	  //
	  //     {
	  //       generatedLine: The line number in the generated code,
	  //       generatedColumn: The column number in the generated code,
	  //       source: The path to the original source file that generated this
	  //               chunk of code,
	  //       originalLine: The line number in the original source that
	  //                     corresponds to this chunk of generated code,
	  //       originalColumn: The column number in the original source that
	  //                       corresponds to this chunk of generated code,
	  //       name: The name of the original symbol which generated this chunk of
	  //             code.
	  //     }
	  //
	  // All properties except for `generatedLine` and `generatedColumn` can be
	  // `null`.
	  //
	  // `_generatedMappings` is ordered by the generated positions.
	  //
	  // `_originalMappings` is ordered by the original positions.

	  SourceMapConsumer.prototype.__generatedMappings = null;
	  Object.defineProperty(SourceMapConsumer.prototype, '_generatedMappings', {
	    get: function () {
	      if (!this.__generatedMappings) {
	        this.__generatedMappings = [];
	        this.__originalMappings = [];
	        this._parseMappings(this._mappings, this.sourceRoot);
	      }

	      return this.__generatedMappings;
	    }
	  });

	  SourceMapConsumer.prototype.__originalMappings = null;
	  Object.defineProperty(SourceMapConsumer.prototype, '_originalMappings', {
	    get: function () {
	      if (!this.__originalMappings) {
	        this.__generatedMappings = [];
	        this.__originalMappings = [];
	        this._parseMappings(this._mappings, this.sourceRoot);
	      }

	      return this.__originalMappings;
	    }
	  });

	  SourceMapConsumer.prototype._nextCharIsMappingSeparator =
	    function SourceMapConsumer_nextCharIsMappingSeparator(aStr) {
	      var c = aStr.charAt(0);
	      return c === ";" || c === ",";
	    };

	  /**
	   * Parse the mappings in a string in to a data structure which we can easily
	   * query (the ordered arrays in the `this.__generatedMappings` and
	   * `this.__originalMappings` properties).
	   */
	  SourceMapConsumer.prototype._parseMappings =
	    function SourceMapConsumer_parseMappings(aStr, aSourceRoot) {
	      var generatedLine = 1;
	      var previousGeneratedColumn = 0;
	      var previousOriginalLine = 0;
	      var previousOriginalColumn = 0;
	      var previousSource = 0;
	      var previousName = 0;
	      var str = aStr;
	      var temp = {};
	      var mapping;

	      while (str.length > 0) {
	        if (str.charAt(0) === ';') {
	          generatedLine++;
	          str = str.slice(1);
	          previousGeneratedColumn = 0;
	        }
	        else if (str.charAt(0) === ',') {
	          str = str.slice(1);
	        }
	        else {
	          mapping = {};
	          mapping.generatedLine = generatedLine;

	          // Generated column.
	          base64VLQ.decode(str, temp);
	          mapping.generatedColumn = previousGeneratedColumn + temp.value;
	          previousGeneratedColumn = mapping.generatedColumn;
	          str = temp.rest;

	          if (str.length > 0 && !this._nextCharIsMappingSeparator(str)) {
	            // Original source.
	            base64VLQ.decode(str, temp);
	            mapping.source = this._sources.at(previousSource + temp.value);
	            previousSource += temp.value;
	            str = temp.rest;
	            if (str.length === 0 || this._nextCharIsMappingSeparator(str)) {
	              throw new Error('Found a source, but no line and column');
	            }

	            // Original line.
	            base64VLQ.decode(str, temp);
	            mapping.originalLine = previousOriginalLine + temp.value;
	            previousOriginalLine = mapping.originalLine;
	            // Lines are stored 0-based
	            mapping.originalLine += 1;
	            str = temp.rest;
	            if (str.length === 0 || this._nextCharIsMappingSeparator(str)) {
	              throw new Error('Found a source and line, but no column');
	            }

	            // Original column.
	            base64VLQ.decode(str, temp);
	            mapping.originalColumn = previousOriginalColumn + temp.value;
	            previousOriginalColumn = mapping.originalColumn;
	            str = temp.rest;

	            if (str.length > 0 && !this._nextCharIsMappingSeparator(str)) {
	              // Original name.
	              base64VLQ.decode(str, temp);
	              mapping.name = this._names.at(previousName + temp.value);
	              previousName += temp.value;
	              str = temp.rest;
	            }
	          }

	          this.__generatedMappings.push(mapping);
	          if (typeof mapping.originalLine === 'number') {
	            this.__originalMappings.push(mapping);
	          }
	        }
	      }

	      this.__generatedMappings.sort(util.compareByGeneratedPositions);
	      this.__originalMappings.sort(util.compareByOriginalPositions);
	    };

	  /**
	   * Find the mapping that best matches the hypothetical "needle" mapping that
	   * we are searching for in the given "haystack" of mappings.
	   */
	  SourceMapConsumer.prototype._findMapping =
	    function SourceMapConsumer_findMapping(aNeedle, aMappings, aLineName,
	                                           aColumnName, aComparator) {
	      // To return the position we are searching for, we must first find the
	      // mapping for the given position and then return the opposite position it
	      // points to. Because the mappings are sorted, we can use binary search to
	      // find the best mapping.

	      if (aNeedle[aLineName] <= 0) {
	        throw new TypeError('Line must be greater than or equal to 1, got '
	                            + aNeedle[aLineName]);
	      }
	      if (aNeedle[aColumnName] < 0) {
	        throw new TypeError('Column must be greater than or equal to 0, got '
	                            + aNeedle[aColumnName]);
	      }

	      return binarySearch.search(aNeedle, aMappings, aComparator);
	    };

	  /**
	   * Compute the last column for each generated mapping. The last column is
	   * inclusive.
	   */
	  SourceMapConsumer.prototype.computeColumnSpans =
	    function SourceMapConsumer_computeColumnSpans() {
	      for (var index = 0; index < this._generatedMappings.length; ++index) {
	        var mapping = this._generatedMappings[index];

	        // Mappings do not contain a field for the last generated columnt. We
	        // can come up with an optimistic estimate, however, by assuming that
	        // mappings are contiguous (i.e. given two consecutive mappings, the
	        // first mapping ends where the second one starts).
	        if (index + 1 < this._generatedMappings.length) {
	          var nextMapping = this._generatedMappings[index + 1];

	          if (mapping.generatedLine === nextMapping.generatedLine) {
	            mapping.lastGeneratedColumn = nextMapping.generatedColumn - 1;
	            continue;
	          }
	        }

	        // The last mapping for each line spans the entire line.
	        mapping.lastGeneratedColumn = Infinity;
	      }
	    };

	  /**
	   * Returns the original source, line, and column information for the generated
	   * source's line and column positions provided. The only argument is an object
	   * with the following properties:
	   *
	   *   - line: The line number in the generated source.
	   *   - column: The column number in the generated source.
	   *
	   * and an object is returned with the following properties:
	   *
	   *   - source: The original source file, or null.
	   *   - line: The line number in the original source, or null.
	   *   - column: The column number in the original source, or null.
	   *   - name: The original identifier, or null.
	   */
	  SourceMapConsumer.prototype.originalPositionFor =
	    function SourceMapConsumer_originalPositionFor(aArgs) {
	      var needle = {
	        generatedLine: util.getArg(aArgs, 'line'),
	        generatedColumn: util.getArg(aArgs, 'column')
	      };

	      var index = this._findMapping(needle,
	                                    this._generatedMappings,
	                                    "generatedLine",
	                                    "generatedColumn",
	                                    util.compareByGeneratedPositions);

	      if (index >= 0) {
	        var mapping = this._generatedMappings[index];

	        if (mapping.generatedLine === needle.generatedLine) {
	          var source = util.getArg(mapping, 'source', null);
	          if (source != null && this.sourceRoot != null) {
	            source = util.join(this.sourceRoot, source);
	          }
	          return {
	            source: source,
	            line: util.getArg(mapping, 'originalLine', null),
	            column: util.getArg(mapping, 'originalColumn', null),
	            name: util.getArg(mapping, 'name', null)
	          };
	        }
	      }

	      return {
	        source: null,
	        line: null,
	        column: null,
	        name: null
	      };
	    };

	  /**
	   * Returns the original source content. The only argument is the url of the
	   * original source file. Returns null if no original source content is
	   * availible.
	   */
	  SourceMapConsumer.prototype.sourceContentFor =
	    function SourceMapConsumer_sourceContentFor(aSource) {
	      if (!this.sourcesContent) {
	        return null;
	      }

	      if (this.sourceRoot != null) {
	        aSource = util.relative(this.sourceRoot, aSource);
	      }

	      if (this._sources.has(aSource)) {
	        return this.sourcesContent[this._sources.indexOf(aSource)];
	      }

	      var url;
	      if (this.sourceRoot != null
	          && (url = util.urlParse(this.sourceRoot))) {
	        // XXX: file:// URIs and absolute paths lead to unexpected behavior for
	        // many users. We can help them out when they expect file:// URIs to
	        // behave like it would if they were running a local HTTP server. See
	        // https://bugzilla.mozilla.org/show_bug.cgi?id=885597.
	        var fileUriAbsPath = aSource.replace(/^file:\/\//, "");
	        if (url.scheme == "file"
	            && this._sources.has(fileUriAbsPath)) {
	          return this.sourcesContent[this._sources.indexOf(fileUriAbsPath)]
	        }

	        if ((!url.path || url.path == "/")
	            && this._sources.has("/" + aSource)) {
	          return this.sourcesContent[this._sources.indexOf("/" + aSource)];
	        }
	      }

	      throw new Error('"' + aSource + '" is not in the SourceMap.');
	    };

	  /**
	   * Returns the generated line and column information for the original source,
	   * line, and column positions provided. The only argument is an object with
	   * the following properties:
	   *
	   *   - source: The filename of the original source.
	   *   - line: The line number in the original source.
	   *   - column: The column number in the original source.
	   *
	   * and an object is returned with the following properties:
	   *
	   *   - line: The line number in the generated source, or null.
	   *   - column: The column number in the generated source, or null.
	   */
	  SourceMapConsumer.prototype.generatedPositionFor =
	    function SourceMapConsumer_generatedPositionFor(aArgs) {
	      var needle = {
	        source: util.getArg(aArgs, 'source'),
	        originalLine: util.getArg(aArgs, 'line'),
	        originalColumn: util.getArg(aArgs, 'column')
	      };

	      if (this.sourceRoot != null) {
	        needle.source = util.relative(this.sourceRoot, needle.source);
	      }

	      var index = this._findMapping(needle,
	                                    this._originalMappings,
	                                    "originalLine",
	                                    "originalColumn",
	                                    util.compareByOriginalPositions);

	      if (index >= 0) {
	        var mapping = this._originalMappings[index];

	        return {
	          line: util.getArg(mapping, 'generatedLine', null),
	          column: util.getArg(mapping, 'generatedColumn', null),
	          lastColumn: util.getArg(mapping, 'lastGeneratedColumn', null)
	        };
	      }

	      return {
	        line: null,
	        column: null,
	        lastColumn: null
	      };
	    };

	  /**
	   * Returns all generated line and column information for the original source
	   * and line provided. The only argument is an object with the following
	   * properties:
	   *
	   *   - source: The filename of the original source.
	   *   - line: The line number in the original source.
	   *
	   * and an array of objects is returned, each with the following properties:
	   *
	   *   - line: The line number in the generated source, or null.
	   *   - column: The column number in the generated source, or null.
	   */
	  SourceMapConsumer.prototype.allGeneratedPositionsFor =
	    function SourceMapConsumer_allGeneratedPositionsFor(aArgs) {
	      // When there is no exact match, SourceMapConsumer.prototype._findMapping
	      // returns the index of the closest mapping less than the needle. By
	      // setting needle.originalColumn to Infinity, we thus find the last
	      // mapping for the given line, provided such a mapping exists.
	      var needle = {
	        source: util.getArg(aArgs, 'source'),
	        originalLine: util.getArg(aArgs, 'line'),
	        originalColumn: Infinity
	      };

	      if (this.sourceRoot != null) {
	        needle.source = util.relative(this.sourceRoot, needle.source);
	      }

	      var mappings = [];

	      var index = this._findMapping(needle,
	                                    this._originalMappings,
	                                    "originalLine",
	                                    "originalColumn",
	                                    util.compareByOriginalPositions);
	      if (index >= 0) {
	        var mapping = this._originalMappings[index];

	        while (mapping && mapping.originalLine === needle.originalLine) {
	          mappings.push({
	            line: util.getArg(mapping, 'generatedLine', null),
	            column: util.getArg(mapping, 'generatedColumn', null),
	            lastColumn: util.getArg(mapping, 'lastGeneratedColumn', null)
	          });

	          mapping = this._originalMappings[--index];
	        }
	      }

	      return mappings.reverse();
	    };

	  SourceMapConsumer.GENERATED_ORDER = 1;
	  SourceMapConsumer.ORIGINAL_ORDER = 2;

	  /**
	   * Iterate over each mapping between an original source/line/column and a
	   * generated line/column in this source map.
	   *
	   * @param Function aCallback
	   *        The function that is called with each mapping.
	   * @param Object aContext
	   *        Optional. If specified, this object will be the value of `this` every
	   *        time that `aCallback` is called.
	   * @param aOrder
	   *        Either `SourceMapConsumer.GENERATED_ORDER` or
	   *        `SourceMapConsumer.ORIGINAL_ORDER`. Specifies whether you want to
	   *        iterate over the mappings sorted by the generated file's line/column
	   *        order or the original's source/line/column order, respectively. Defaults to
	   *        `SourceMapConsumer.GENERATED_ORDER`.
	   */
	  SourceMapConsumer.prototype.eachMapping =
	    function SourceMapConsumer_eachMapping(aCallback, aContext, aOrder) {
	      var context = aContext || null;
	      var order = aOrder || SourceMapConsumer.GENERATED_ORDER;

	      var mappings;
	      switch (order) {
	      case SourceMapConsumer.GENERATED_ORDER:
	        mappings = this._generatedMappings;
	        break;
	      case SourceMapConsumer.ORIGINAL_ORDER:
	        mappings = this._originalMappings;
	        break;
	      default:
	        throw new Error("Unknown order of iteration.");
	      }

	      var sourceRoot = this.sourceRoot;
	      mappings.map(function (mapping) {
	        var source = mapping.source;
	        if (source != null && sourceRoot != null) {
	          source = util.join(sourceRoot, source);
	        }
	        return {
	          source: source,
	          generatedLine: mapping.generatedLine,
	          generatedColumn: mapping.generatedColumn,
	          originalLine: mapping.originalLine,
	          originalColumn: mapping.originalColumn,
	          name: mapping.name
	        };
	      }).forEach(aCallback, context);
	    };

	  exports.SourceMapConsumer = SourceMapConsumer;

	}.call(exports, __webpack_require__, exports, module), __WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));


/***/ },
/* 51 */
/***/ function(module, exports, __webpack_require__) {

	var __WEBPACK_AMD_DEFINE_RESULT__;/* -*- Mode: js; js-indent-level: 2; -*- */
	/*
	 * Copyright 2011 Mozilla Foundation and contributors
	 * Licensed under the New BSD license. See LICENSE or:
	 * http://opensource.org/licenses/BSD-3-Clause
	 */
	if (false) {
	    var define = require('amdefine')(module, require);
	}
	!(__WEBPACK_AMD_DEFINE_RESULT__ = function (require, exports, module) {

	  /**
	   * Recursive implementation of binary search.
	   *
	   * @param aLow Indices here and lower do not contain the needle.
	   * @param aHigh Indices here and higher do not contain the needle.
	   * @param aNeedle The element being searched for.
	   * @param aHaystack The non-empty array being searched.
	   * @param aCompare Function which takes two elements and returns -1, 0, or 1.
	   */
	  function recursiveSearch(aLow, aHigh, aNeedle, aHaystack, aCompare) {
	    // This function terminates when one of the following is true:
	    //
	    //   1. We find the exact element we are looking for.
	    //
	    //   2. We did not find the exact element, but we can return the index of
	    //      the next closest element that is less than that element.
	    //
	    //   3. We did not find the exact element, and there is no next-closest
	    //      element which is less than the one we are searching for, so we
	    //      return -1.
	    var mid = Math.floor((aHigh - aLow) / 2) + aLow;
	    var cmp = aCompare(aNeedle, aHaystack[mid], true);
	    if (cmp === 0) {
	      // Found the element we are looking for.
	      return mid;
	    }
	    else if (cmp > 0) {
	      // aHaystack[mid] is greater than our needle.
	      if (aHigh - mid > 1) {
	        // The element is in the upper half.
	        return recursiveSearch(mid, aHigh, aNeedle, aHaystack, aCompare);
	      }
	      // We did not find an exact match, return the next closest one
	      // (termination case 2).
	      return mid;
	    }
	    else {
	      // aHaystack[mid] is less than our needle.
	      if (mid - aLow > 1) {
	        // The element is in the lower half.
	        return recursiveSearch(aLow, mid, aNeedle, aHaystack, aCompare);
	      }
	      // The exact needle element was not found in this haystack. Determine if
	      // we are in termination case (2) or (3) and return the appropriate thing.
	      return aLow < 0 ? -1 : aLow;
	    }
	  }

	  /**
	   * This is an implementation of binary search which will always try and return
	   * the index of next lowest value checked if there is no exact hit. This is
	   * because mappings between original and generated line/col pairs are single
	   * points, and there is an implicit region between each of them, so a miss
	   * just means that you aren't on the very start of a region.
	   *
	   * @param aNeedle The element you are looking for.
	   * @param aHaystack The array that is being searched.
	   * @param aCompare A function which takes the needle and an element in the
	   *     array and returns -1, 0, or 1 depending on whether the needle is less
	   *     than, equal to, or greater than the element, respectively.
	   */
	  exports.search = function search(aNeedle, aHaystack, aCompare) {
	    if (aHaystack.length === 0) {
	      return -1;
	    }
	    return recursiveSearch(-1, aHaystack.length, aNeedle, aHaystack, aCompare)
	  };

	}.call(exports, __webpack_require__, exports, module), __WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));


/***/ },
/* 52 */
/***/ function(module, exports, __webpack_require__) {

	var __WEBPACK_AMD_DEFINE_RESULT__;/* -*- Mode: js; js-indent-level: 2; -*- */
	/*
	 * Copyright 2011 Mozilla Foundation and contributors
	 * Licensed under the New BSD license. See LICENSE or:
	 * http://opensource.org/licenses/BSD-3-Clause
	 */
	if (false) {
	    var define = require('amdefine')(module, require);
	}
	!(__WEBPACK_AMD_DEFINE_RESULT__ = function (require, exports, module) {

	  var SourceMapGenerator = __webpack_require__(44).SourceMapGenerator;
	  var util = __webpack_require__(47);

	  // Matches a Windows-style `\r\n` newline or a `\n` newline used by all other
	  // operating systems these days (capturing the result).
	  var REGEX_NEWLINE = /(\r?\n)/;

	  // Newline character code for charCodeAt() comparisons
	  var NEWLINE_CODE = 10;

	  // Private symbol for identifying `SourceNode`s when multiple versions of
	  // the source-map library are loaded. This MUST NOT CHANGE across
	  // versions!
	  var isSourceNode = "$$$isSourceNode$$$";

	  /**
	   * SourceNodes provide a way to abstract over interpolating/concatenating
	   * snippets of generated JavaScript source code while maintaining the line and
	   * column information associated with the original source code.
	   *
	   * @param aLine The original line number.
	   * @param aColumn The original column number.
	   * @param aSource The original source's filename.
	   * @param aChunks Optional. An array of strings which are snippets of
	   *        generated JS, or other SourceNodes.
	   * @param aName The original identifier.
	   */
	  function SourceNode(aLine, aColumn, aSource, aChunks, aName) {
	    this.children = [];
	    this.sourceContents = {};
	    this.line = aLine == null ? null : aLine;
	    this.column = aColumn == null ? null : aColumn;
	    this.source = aSource == null ? null : aSource;
	    this.name = aName == null ? null : aName;
	    this[isSourceNode] = true;
	    if (aChunks != null) this.add(aChunks);
	  }

	  /**
	   * Creates a SourceNode from generated code and a SourceMapConsumer.
	   *
	   * @param aGeneratedCode The generated code
	   * @param aSourceMapConsumer The SourceMap for the generated code
	   * @param aRelativePath Optional. The path that relative sources in the
	   *        SourceMapConsumer should be relative to.
	   */
	  SourceNode.fromStringWithSourceMap =
	    function SourceNode_fromStringWithSourceMap(aGeneratedCode, aSourceMapConsumer, aRelativePath) {
	      // The SourceNode we want to fill with the generated code
	      // and the SourceMap
	      var node = new SourceNode();

	      // All even indices of this array are one line of the generated code,
	      // while all odd indices are the newlines between two adjacent lines
	      // (since `REGEX_NEWLINE` captures its match).
	      // Processed fragments are removed from this array, by calling `shiftNextLine`.
	      var remainingLines = aGeneratedCode.split(REGEX_NEWLINE);
	      var shiftNextLine = function() {
	        var lineContents = remainingLines.shift();
	        // The last line of a file might not have a newline.
	        var newLine = remainingLines.shift() || "";
	        return lineContents + newLine;
	      };

	      // We need to remember the position of "remainingLines"
	      var lastGeneratedLine = 1, lastGeneratedColumn = 0;

	      // The generate SourceNodes we need a code range.
	      // To extract it current and last mapping is used.
	      // Here we store the last mapping.
	      var lastMapping = null;

	      aSourceMapConsumer.eachMapping(function (mapping) {
	        if (lastMapping !== null) {
	          // We add the code from "lastMapping" to "mapping":
	          // First check if there is a new line in between.
	          if (lastGeneratedLine < mapping.generatedLine) {
	            var code = "";
	            // Associate first line with "lastMapping"
	            addMappingWithCode(lastMapping, shiftNextLine());
	            lastGeneratedLine++;
	            lastGeneratedColumn = 0;
	            // The remaining code is added without mapping
	          } else {
	            // There is no new line in between.
	            // Associate the code between "lastGeneratedColumn" and
	            // "mapping.generatedColumn" with "lastMapping"
	            var nextLine = remainingLines[0];
	            var code = nextLine.substr(0, mapping.generatedColumn -
	                                          lastGeneratedColumn);
	            remainingLines[0] = nextLine.substr(mapping.generatedColumn -
	                                                lastGeneratedColumn);
	            lastGeneratedColumn = mapping.generatedColumn;
	            addMappingWithCode(lastMapping, code);
	            // No more remaining code, continue
	            lastMapping = mapping;
	            return;
	          }
	        }
	        // We add the generated code until the first mapping
	        // to the SourceNode without any mapping.
	        // Each line is added as separate string.
	        while (lastGeneratedLine < mapping.generatedLine) {
	          node.add(shiftNextLine());
	          lastGeneratedLine++;
	        }
	        if (lastGeneratedColumn < mapping.generatedColumn) {
	          var nextLine = remainingLines[0];
	          node.add(nextLine.substr(0, mapping.generatedColumn));
	          remainingLines[0] = nextLine.substr(mapping.generatedColumn);
	          lastGeneratedColumn = mapping.generatedColumn;
	        }
	        lastMapping = mapping;
	      }, this);
	      // We have processed all mappings.
	      if (remainingLines.length > 0) {
	        if (lastMapping) {
	          // Associate the remaining code in the current line with "lastMapping"
	          addMappingWithCode(lastMapping, shiftNextLine());
	        }
	        // and add the remaining lines without any mapping
	        node.add(remainingLines.join(""));
	      }

	      // Copy sourcesContent into SourceNode
	      aSourceMapConsumer.sources.forEach(function (sourceFile) {
	        var content = aSourceMapConsumer.sourceContentFor(sourceFile);
	        if (content != null) {
	          if (aRelativePath != null) {
	            sourceFile = util.join(aRelativePath, sourceFile);
	          }
	          node.setSourceContent(sourceFile, content);
	        }
	      });

	      return node;

	      function addMappingWithCode(mapping, code) {
	        if (mapping === null || mapping.source === undefined) {
	          node.add(code);
	        } else {
	          var source = aRelativePath
	            ? util.join(aRelativePath, mapping.source)
	            : mapping.source;
	          node.add(new SourceNode(mapping.originalLine,
	                                  mapping.originalColumn,
	                                  source,
	                                  code,
	                                  mapping.name));
	        }
	      }
	    };

	  /**
	   * Add a chunk of generated JS to this source node.
	   *
	   * @param aChunk A string snippet of generated JS code, another instance of
	   *        SourceNode, or an array where each member is one of those things.
	   */
	  SourceNode.prototype.add = function SourceNode_add(aChunk) {
	    if (Array.isArray(aChunk)) {
	      aChunk.forEach(function (chunk) {
	        this.add(chunk);
	      }, this);
	    }
	    else if (aChunk[isSourceNode] || typeof aChunk === "string") {
	      if (aChunk) {
	        this.children.push(aChunk);
	      }
	    }
	    else {
	      throw new TypeError(
	        "Expected a SourceNode, string, or an array of SourceNodes and strings. Got " + aChunk
	      );
	    }
	    return this;
	  };

	  /**
	   * Add a chunk of generated JS to the beginning of this source node.
	   *
	   * @param aChunk A string snippet of generated JS code, another instance of
	   *        SourceNode, or an array where each member is one of those things.
	   */
	  SourceNode.prototype.prepend = function SourceNode_prepend(aChunk) {
	    if (Array.isArray(aChunk)) {
	      for (var i = aChunk.length-1; i >= 0; i--) {
	        this.prepend(aChunk[i]);
	      }
	    }
	    else if (aChunk[isSourceNode] || typeof aChunk === "string") {
	      this.children.unshift(aChunk);
	    }
	    else {
	      throw new TypeError(
	        "Expected a SourceNode, string, or an array of SourceNodes and strings. Got " + aChunk
	      );
	    }
	    return this;
	  };

	  /**
	   * Walk over the tree of JS snippets in this node and its children. The
	   * walking function is called once for each snippet of JS and is passed that
	   * snippet and the its original associated source's line/column location.
	   *
	   * @param aFn The traversal function.
	   */
	  SourceNode.prototype.walk = function SourceNode_walk(aFn) {
	    var chunk;
	    for (var i = 0, len = this.children.length; i < len; i++) {
	      chunk = this.children[i];
	      if (chunk[isSourceNode]) {
	        chunk.walk(aFn);
	      }
	      else {
	        if (chunk !== '') {
	          aFn(chunk, { source: this.source,
	                       line: this.line,
	                       column: this.column,
	                       name: this.name });
	        }
	      }
	    }
	  };

	  /**
	   * Like `String.prototype.join` except for SourceNodes. Inserts `aStr` between
	   * each of `this.children`.
	   *
	   * @param aSep The separator.
	   */
	  SourceNode.prototype.join = function SourceNode_join(aSep) {
	    var newChildren;
	    var i;
	    var len = this.children.length;
	    if (len > 0) {
	      newChildren = [];
	      for (i = 0; i < len-1; i++) {
	        newChildren.push(this.children[i]);
	        newChildren.push(aSep);
	      }
	      newChildren.push(this.children[i]);
	      this.children = newChildren;
	    }
	    return this;
	  };

	  /**
	   * Call String.prototype.replace on the very right-most source snippet. Useful
	   * for trimming whitespace from the end of a source node, etc.
	   *
	   * @param aPattern The pattern to replace.
	   * @param aReplacement The thing to replace the pattern with.
	   */
	  SourceNode.prototype.replaceRight = function SourceNode_replaceRight(aPattern, aReplacement) {
	    var lastChild = this.children[this.children.length - 1];
	    if (lastChild[isSourceNode]) {
	      lastChild.replaceRight(aPattern, aReplacement);
	    }
	    else if (typeof lastChild === 'string') {
	      this.children[this.children.length - 1] = lastChild.replace(aPattern, aReplacement);
	    }
	    else {
	      this.children.push(''.replace(aPattern, aReplacement));
	    }
	    return this;
	  };

	  /**
	   * Set the source content for a source file. This will be added to the SourceMapGenerator
	   * in the sourcesContent field.
	   *
	   * @param aSourceFile The filename of the source file
	   * @param aSourceContent The content of the source file
	   */
	  SourceNode.prototype.setSourceContent =
	    function SourceNode_setSourceContent(aSourceFile, aSourceContent) {
	      this.sourceContents[util.toSetString(aSourceFile)] = aSourceContent;
	    };

	  /**
	   * Walk over the tree of SourceNodes. The walking function is called for each
	   * source file content and is passed the filename and source content.
	   *
	   * @param aFn The traversal function.
	   */
	  SourceNode.prototype.walkSourceContents =
	    function SourceNode_walkSourceContents(aFn) {
	      for (var i = 0, len = this.children.length; i < len; i++) {
	        if (this.children[i][isSourceNode]) {
	          this.children[i].walkSourceContents(aFn);
	        }
	      }

	      var sources = Object.keys(this.sourceContents);
	      for (var i = 0, len = sources.length; i < len; i++) {
	        aFn(util.fromSetString(sources[i]), this.sourceContents[sources[i]]);
	      }
	    };

	  /**
	   * Return the string representation of this source node. Walks over the tree
	   * and concatenates all the various snippets together to one string.
	   */
	  SourceNode.prototype.toString = function SourceNode_toString() {
	    var str = "";
	    this.walk(function (chunk) {
	      str += chunk;
	    });
	    return str;
	  };

	  /**
	   * Returns the string representation of this source node along with a source
	   * map.
	   */
	  SourceNode.prototype.toStringWithSourceMap = function SourceNode_toStringWithSourceMap(aArgs) {
	    var generated = {
	      code: "",
	      line: 1,
	      column: 0
	    };
	    var map = new SourceMapGenerator(aArgs);
	    var sourceMappingActive = false;
	    var lastOriginalSource = null;
	    var lastOriginalLine = null;
	    var lastOriginalColumn = null;
	    var lastOriginalName = null;
	    this.walk(function (chunk, original) {
	      generated.code += chunk;
	      if (original.source !== null
	          && original.line !== null
	          && original.column !== null) {
	        if(lastOriginalSource !== original.source
	           || lastOriginalLine !== original.line
	           || lastOriginalColumn !== original.column
	           || lastOriginalName !== original.name) {
	          map.addMapping({
	            source: original.source,
	            original: {
	              line: original.line,
	              column: original.column
	            },
	            generated: {
	              line: generated.line,
	              column: generated.column
	            },
	            name: original.name
	          });
	        }
	        lastOriginalSource = original.source;
	        lastOriginalLine = original.line;
	        lastOriginalColumn = original.column;
	        lastOriginalName = original.name;
	        sourceMappingActive = true;
	      } else if (sourceMappingActive) {
	        map.addMapping({
	          generated: {
	            line: generated.line,
	            column: generated.column
	          }
	        });
	        lastOriginalSource = null;
	        sourceMappingActive = false;
	      }
	      for (var idx = 0, length = chunk.length; idx < length; idx++) {
	        if (chunk.charCodeAt(idx) === NEWLINE_CODE) {
	          generated.line++;
	          generated.column = 0;
	          // Mappings end at eol
	          if (idx + 1 === length) {
	            lastOriginalSource = null;
	            sourceMappingActive = false;
	          } else if (sourceMappingActive) {
	            map.addMapping({
	              source: original.source,
	              original: {
	                line: original.line,
	                column: original.column
	              },
	              generated: {
	                line: generated.line,
	                column: generated.column
	              },
	              name: original.name
	            });
	          }
	        } else {
	          generated.column++;
	        }
	      }
	    });
	    this.walkSourceContents(function (sourceFile, sourceContent) {
	      map.setSourceContent(sourceFile, sourceContent);
	    });

	    return { code: generated.code, map: map };
	  };

	  exports.SourceNode = SourceNode;

	}.call(exports, __webpack_require__, exports, module), __WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));


/***/ },
/* 53 */
/***/ function(module, exports, __webpack_require__) {

	var defaults = {
	    // If you want to use a different branch of esprima, or any other
	    // module that supports a .parse function, pass that module object to
	    // recast.parse as options.esprima.
	    esprima: __webpack_require__(54),

	    // Number of spaces the pretty-printer should use per tab for
	    // indentation. If you do not pass this option explicitly, it will be
	    // (quite reliably!) inferred from the original code.
	    tabWidth: 4,

	    // If you really want the pretty-printer to use tabs instead of
	    // spaces, make this option true.
	    useTabs: false,

	    // The reprinting code leaves leading whitespace untouched unless it
	    // has to reindent a line, or you pass false for this option.
	    reuseWhitespace: true,

	    // Some of the pretty-printer code (such as that for printing function
	    // parameter lists) makes a valiant attempt to prevent really long
	    // lines. You can adjust the limit by changing this option; however,
	    // there is no guarantee that line length will fit inside this limit.
	    wrapColumn: 74, // Aspirational for now.

	    // Pass a string as options.sourceFileName to recast.parse to tell the
	    // reprinter to keep track of reused code so that it can construct a
	    // source map automatically.
	    sourceFileName: null,

	    // Pass a string as options.sourceMapName to recast.print, and
	    // (provided you passed options.sourceFileName earlier) the
	    // PrintResult of recast.print will have a .map property for the
	    // generated source map.
	    sourceMapName: null,

	    // If provided, this option will be passed along to the source map
	    // generator as a root directory for relative source file paths.
	    sourceRoot: null,

	    // If you provide a source map that was generated from a previous call
	    // to recast.print as options.inputSourceMap, the old source map will
	    // be composed with the new source map.
	    inputSourceMap: null,

	    // If you want esprima to generate .range information (recast only
	    // uses .loc internally), pass true for this option.
	    range: false,

	    // If you want esprima not to throw exceptions when it encounters
	    // non-fatal errors, keep this option true.
	    tolerant: true,
	    
	    // If you want to override the quotes used in string literals, specify
	    // either "single", "double", or "auto" here ("auto" will select the one 
	    // which results in the shorter literal)
	    // Otherwise, the input marks will be preserved
	    quote: null,
	}, hasOwn = defaults.hasOwnProperty;

	// Copy options and fill in default values.
	exports.normalize = function(options) {
	    options = options || defaults;

	    function get(key) {
	        return hasOwn.call(options, key)
	            ? options[key]
	            : defaults[key];
	    }

	    return {
	        tabWidth: +get("tabWidth"),
	        useTabs: !!get("useTabs"),
	        reuseWhitespace: !!get("reuseWhitespace"),
	        wrapColumn: Math.max(get("wrapColumn"), 0),
	        sourceFileName: get("sourceFileName"),
	        sourceMapName: get("sourceMapName"),
	        sourceRoot: get("sourceRoot"),
	        inputSourceMap: get("inputSourceMap"),
	        esprima: get("esprima"),
	        range: get("range"),
	        tolerant: get("tolerant"),
	        quote: get("quote"),
	    };
	};


/***/ },
/* 54 */
/***/ function(module, exports, __webpack_require__) {

	var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/*
	  Copyright (C) 2013 Ariya Hidayat <ariya.hidayat@gmail.com>
	  Copyright (C) 2013 Thaddee Tyl <thaddee.tyl@gmail.com>
	  Copyright (C) 2012 Ariya Hidayat <ariya.hidayat@gmail.com>
	  Copyright (C) 2012 Mathias Bynens <mathias@qiwi.be>
	  Copyright (C) 2012 Joost-Wim Boekesteijn <joost-wim@boekesteijn.nl>
	  Copyright (C) 2012 Kris Kowal <kris.kowal@cixar.com>
	  Copyright (C) 2012 Yusuke Suzuki <utatane.tea@gmail.com>
	  Copyright (C) 2012 Arpad Borsos <arpad.borsos@googlemail.com>
	  Copyright (C) 2011 Ariya Hidayat <ariya.hidayat@gmail.com>

	  Redistribution and use in source and binary forms, with or without
	  modification, are permitted provided that the following conditions are met:

	    * Redistributions of source code must retain the above copyright
	      notice, this list of conditions and the following disclaimer.
	    * Redistributions in binary form must reproduce the above copyright
	      notice, this list of conditions and the following disclaimer in the
	      documentation and/or other materials provided with the distribution.

	  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
	  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
	  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
	  ARE DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
	  DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
	  (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
	  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
	  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
	  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
	  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
	*/

	/*jslint bitwise:true plusplus:true */
	/*global esprima:true, define:true, exports:true, window: true,
	throwErrorTolerant: true,
	throwError: true, generateStatement: true, peek: true,
	parseAssignmentExpression: true, parseBlock: true,
	parseClassExpression: true, parseClassDeclaration: true, parseExpression: true,
	parseDeclareClass: true, parseDeclareFunction: true,
	parseDeclareModule: true, parseDeclareVariable: true,
	parseForStatement: true,
	parseFunctionDeclaration: true, parseFunctionExpression: true,
	parseFunctionSourceElements: true, parseVariableIdentifier: true,
	parseImportSpecifier: true, parseInterface: true,
	parseLeftHandSideExpression: true, parseParams: true, validateParam: true,
	parseSpreadOrAssignmentExpression: true,
	parseStatement: true, parseSourceElement: true, parseConciseBody: true,
	advanceXJSChild: true, isXJSIdentifierStart: true, isXJSIdentifierPart: true,
	scanXJSStringLiteral: true, scanXJSIdentifier: true,
	parseXJSAttributeValue: true, parseXJSChild: true, parseXJSElement: true, parseXJSExpressionContainer: true, parseXJSEmptyExpression: true,
	parseFunctionTypeParam: true,
	parsePrimaryType: true,
	parseTypeAlias: true,
	parseType: true, parseTypeAnnotatableIdentifier: true, parseTypeAnnotation: true,
	parseTypeParameterDeclaration: true,
	parseYieldExpression: true, parseAwaitExpression: true
	*/

	(function (root, factory) {
	    'use strict';

	    // Universal Module Definition (UMD) to support AMD, CommonJS/Node.js,
	    // Rhino, and plain browser loading.

	    /* istanbul ignore next */
	    if (true) {
	        !(__WEBPACK_AMD_DEFINE_ARRAY__ = [exports], __WEBPACK_AMD_DEFINE_FACTORY__ = (factory), __WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ? (__WEBPACK_AMD_DEFINE_FACTORY__.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__)) : __WEBPACK_AMD_DEFINE_FACTORY__), __WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
	    } else if (typeof exports !== 'undefined') {
	        factory(exports);
	    } else {
	        factory((root.esprima = {}));
	    }
	}(this, function (exports) {
	    'use strict';

	    var Token,
	        TokenName,
	        FnExprTokens,
	        Syntax,
	        PropertyKind,
	        Messages,
	        Regex,
	        SyntaxTreeDelegate,
	        XHTMLEntities,
	        ClassPropertyType,
	        source,
	        strict,
	        index,
	        lineNumber,
	        lineStart,
	        length,
	        delegate,
	        lookahead,
	        state,
	        extra;

	    Token = {
	        BooleanLiteral: 1,
	        EOF: 2,
	        Identifier: 3,
	        Keyword: 4,
	        NullLiteral: 5,
	        NumericLiteral: 6,
	        Punctuator: 7,
	        StringLiteral: 8,
	        RegularExpression: 9,
	        Template: 10,
	        XJSIdentifier: 11,
	        XJSText: 12
	    };

	    TokenName = {};
	    TokenName[Token.BooleanLiteral] = 'Boolean';
	    TokenName[Token.EOF] = '<end>';
	    TokenName[Token.Identifier] = 'Identifier';
	    TokenName[Token.Keyword] = 'Keyword';
	    TokenName[Token.NullLiteral] = 'Null';
	    TokenName[Token.NumericLiteral] = 'Numeric';
	    TokenName[Token.Punctuator] = 'Punctuator';
	    TokenName[Token.StringLiteral] = 'String';
	    TokenName[Token.XJSIdentifier] = 'XJSIdentifier';
	    TokenName[Token.XJSText] = 'XJSText';
	    TokenName[Token.RegularExpression] = 'RegularExpression';

	    // A function following one of those tokens is an expression.
	    FnExprTokens = ['(', '{', '[', 'in', 'typeof', 'instanceof', 'new',
	                    'return', 'case', 'delete', 'throw', 'void',
	                    // assignment operators
	                    '=', '+=', '-=', '*=', '/=', '%=', '<<=', '>>=', '>>>=',
	                    '&=', '|=', '^=', ',',
	                    // binary/unary operators
	                    '+', '-', '*', '/', '%', '++', '--', '<<', '>>', '>>>', '&',
	                    '|', '^', '!', '~', '&&', '||', '?', ':', '===', '==', '>=',
	                    '<=', '<', '>', '!=', '!=='];

	    Syntax = {
	        AnyTypeAnnotation: 'AnyTypeAnnotation',
	        ArrayExpression: 'ArrayExpression',
	        ArrayPattern: 'ArrayPattern',
	        ArrayTypeAnnotation: 'ArrayTypeAnnotation',
	        ArrowFunctionExpression: 'ArrowFunctionExpression',
	        AssignmentExpression: 'AssignmentExpression',
	        BinaryExpression: 'BinaryExpression',
	        BlockStatement: 'BlockStatement',
	        BooleanTypeAnnotation: 'BooleanTypeAnnotation',
	        BreakStatement: 'BreakStatement',
	        CallExpression: 'CallExpression',
	        CatchClause: 'CatchClause',
	        ClassBody: 'ClassBody',
	        ClassDeclaration: 'ClassDeclaration',
	        ClassExpression: 'ClassExpression',
	        ClassImplements: 'ClassImplements',
	        ClassProperty: 'ClassProperty',
	        ComprehensionBlock: 'ComprehensionBlock',
	        ComprehensionExpression: 'ComprehensionExpression',
	        ConditionalExpression: 'ConditionalExpression',
	        ContinueStatement: 'ContinueStatement',
	        DebuggerStatement: 'DebuggerStatement',
	        DeclareClass: 'DeclareClass',
	        DeclareFunction: 'DeclareFunction',
	        DeclareModule: 'DeclareModule',
	        DeclareVariable: 'DeclareVariable',
	        DoWhileStatement: 'DoWhileStatement',
	        EmptyStatement: 'EmptyStatement',
	        ExportDeclaration: 'ExportDeclaration',
	        ExportBatchSpecifier: 'ExportBatchSpecifier',
	        ExportSpecifier: 'ExportSpecifier',
	        ExpressionStatement: 'ExpressionStatement',
	        ForInStatement: 'ForInStatement',
	        ForOfStatement: 'ForOfStatement',
	        ForStatement: 'ForStatement',
	        FunctionDeclaration: 'FunctionDeclaration',
	        FunctionExpression: 'FunctionExpression',
	        FunctionTypeAnnotation: 'FunctionTypeAnnotation',
	        FunctionTypeParam: 'FunctionTypeParam',
	        GenericTypeAnnotation: 'GenericTypeAnnotation',
	        Identifier: 'Identifier',
	        IfStatement: 'IfStatement',
	        ImportDeclaration: 'ImportDeclaration',
	        ImportDefaultSpecifier: 'ImportDefaultSpecifier',
	        ImportNamespaceSpecifier: 'ImportNamespaceSpecifier',
	        ImportSpecifier: 'ImportSpecifier',
	        InterfaceDeclaration: 'InterfaceDeclaration',
	        InterfaceExtends: 'InterfaceExtends',
	        IntersectionTypeAnnotation: 'IntersectionTypeAnnotation',
	        LabeledStatement: 'LabeledStatement',
	        Literal: 'Literal',
	        LogicalExpression: 'LogicalExpression',
	        MemberExpression: 'MemberExpression',
	        MethodDefinition: 'MethodDefinition',
	        ModuleSpecifier: 'ModuleSpecifier',
	        NewExpression: 'NewExpression',
	        NullableTypeAnnotation: 'NullableTypeAnnotation',
	        NumberTypeAnnotation: 'NumberTypeAnnotation',
	        ObjectExpression: 'ObjectExpression',
	        ObjectPattern: 'ObjectPattern',
	        ObjectTypeAnnotation: 'ObjectTypeAnnotation',
	        ObjectTypeCallProperty: 'ObjectTypeCallProperty',
	        ObjectTypeIndexer: 'ObjectTypeIndexer',
	        ObjectTypeProperty: 'ObjectTypeProperty',
	        Program: 'Program',
	        Property: 'Property',
	        QualifiedTypeIdentifier: 'QualifiedTypeIdentifier',
	        ReturnStatement: 'ReturnStatement',
	        SequenceExpression: 'SequenceExpression',
	        SpreadElement: 'SpreadElement',
	        SpreadProperty: 'SpreadProperty',
	        StringLiteralTypeAnnotation: 'StringLiteralTypeAnnotation',
	        StringTypeAnnotation: 'StringTypeAnnotation',
	        SwitchCase: 'SwitchCase',
	        SwitchStatement: 'SwitchStatement',
	        TaggedTemplateExpression: 'TaggedTemplateExpression',
	        TemplateElement: 'TemplateElement',
	        TemplateLiteral: 'TemplateLiteral',
	        ThisExpression: 'ThisExpression',
	        ThrowStatement: 'ThrowStatement',
	        TupleTypeAnnotation: 'TupleTypeAnnotation',
	        TryStatement: 'TryStatement',
	        TypeAlias: 'TypeAlias',
	        TypeAnnotation: 'TypeAnnotation',
	        TypeofTypeAnnotation: 'TypeofTypeAnnotation',
	        TypeParameterDeclaration: 'TypeParameterDeclaration',
	        TypeParameterInstantiation: 'TypeParameterInstantiation',
	        UnaryExpression: 'UnaryExpression',
	        UnionTypeAnnotation: 'UnionTypeAnnotation',
	        UpdateExpression: 'UpdateExpression',
	        VariableDeclaration: 'VariableDeclaration',
	        VariableDeclarator: 'VariableDeclarator',
	        VoidTypeAnnotation: 'VoidTypeAnnotation',
	        WhileStatement: 'WhileStatement',
	        WithStatement: 'WithStatement',
	        XJSIdentifier: 'XJSIdentifier',
	        XJSNamespacedName: 'XJSNamespacedName',
	        XJSMemberExpression: 'XJSMemberExpression',
	        XJSEmptyExpression: 'XJSEmptyExpression',
	        XJSExpressionContainer: 'XJSExpressionContainer',
	        XJSElement: 'XJSElement',
	        XJSClosingElement: 'XJSClosingElement',
	        XJSOpeningElement: 'XJSOpeningElement',
	        XJSAttribute: 'XJSAttribute',
	        XJSSpreadAttribute: 'XJSSpreadAttribute',
	        XJSText: 'XJSText',
	        YieldExpression: 'YieldExpression',
	        AwaitExpression: 'AwaitExpression'
	    };

	    PropertyKind = {
	        Data: 1,
	        Get: 2,
	        Set: 4
	    };

	    ClassPropertyType = {
	        'static': 'static',
	        prototype: 'prototype'
	    };

	    // Error messages should be identical to V8.
	    Messages = {
	        UnexpectedToken:  'Unexpected token %0',
	        UnexpectedNumber:  'Unexpected number',
	        UnexpectedString:  'Unexpected string',
	        UnexpectedIdentifier:  'Unexpected identifier',
	        UnexpectedReserved:  'Unexpected reserved word',
	        UnexpectedTemplate:  'Unexpected quasi %0',
	        UnexpectedEOS:  'Unexpected end of input',
	        NewlineAfterThrow:  'Illegal newline after throw',
	        InvalidRegExp: 'Invalid regular expression',
	        UnterminatedRegExp:  'Invalid regular expression: missing /',
	        InvalidLHSInAssignment:  'Invalid left-hand side in assignment',
	        InvalidLHSInFormalsList:  'Invalid left-hand side in formals list',
	        InvalidLHSInForIn:  'Invalid left-hand side in for-in',
	        MultipleDefaultsInSwitch: 'More than one default clause in switch statement',
	        NoCatchOrFinally:  'Missing catch or finally after try',
	        UnknownLabel: 'Undefined label \'%0\'',
	        Redeclaration: '%0 \'%1\' has already been declared',
	        IllegalContinue: 'Illegal continue statement',
	        IllegalBreak: 'Illegal break statement',
	        IllegalDuplicateClassProperty: 'Illegal duplicate property in class definition',
	        IllegalReturn: 'Illegal return statement',
	        IllegalSpread: 'Illegal spread element',
	        StrictModeWith:  'Strict mode code may not include a with statement',
	        StrictCatchVariable:  'Catch variable may not be eval or arguments in strict mode',
	        StrictVarName:  'Variable name may not be eval or arguments in strict mode',
	        StrictParamName:  'Parameter name eval or arguments is not allowed in strict mode',
	        StrictParamDupe: 'Strict mode function may not have duplicate parameter names',
	        ParameterAfterRestParameter: 'Rest parameter must be final parameter of an argument list',
	        DefaultRestParameter: 'Rest parameter can not have a default value',
	        ElementAfterSpreadElement: 'Spread must be the final element of an element list',
	        PropertyAfterSpreadProperty: 'A rest property must be the final property of an object literal',
	        ObjectPatternAsRestParameter: 'Invalid rest parameter',
	        ObjectPatternAsSpread: 'Invalid spread argument',
	        StrictFunctionName:  'Function name may not be eval or arguments in strict mode',
	        StrictOctalLiteral:  'Octal literals are not allowed in strict mode.',
	        StrictDelete:  'Delete of an unqualified identifier in strict mode.',
	        StrictDuplicateProperty:  'Duplicate data property in object literal not allowed in strict mode',
	        AccessorDataProperty:  'Object literal may not have data and accessor property with the same name',
	        AccessorGetSet:  'Object literal may not have multiple get/set accessors with the same name',
	        StrictLHSAssignment:  'Assignment to eval or arguments is not allowed in strict mode',
	        StrictLHSPostfix:  'Postfix increment/decrement may not have eval or arguments operand in strict mode',
	        StrictLHSPrefix:  'Prefix increment/decrement may not have eval or arguments operand in strict mode',
	        StrictReservedWord:  'Use of future reserved word in strict mode',
	        MissingFromClause: 'Missing from clause',
	        NoAsAfterImportNamespace: 'Missing as after import *',
	        InvalidModuleSpecifier: 'Invalid module specifier',
	        IllegalImportDeclaration: 'Illegal import declaration',
	        IllegalExportDeclaration: 'Illegal export declaration',
	        NoUnintializedConst: 'Const must be initialized',
	        ComprehensionRequiresBlock: 'Comprehension must have at least one block',
	        ComprehensionError:  'Comprehension Error',
	        EachNotAllowed:  'Each is not supported',
	        InvalidXJSAttributeValue: 'XJS value should be either an expression or a quoted XJS text',
	        ExpectedXJSClosingTag: 'Expected corresponding XJS closing tag for %0',
	        AdjacentXJSElements: 'Adjacent XJS elements must be wrapped in an enclosing tag',
	        ConfusedAboutFunctionType: 'Unexpected token =>. It looks like ' +
	            'you are trying to write a function type, but you ended up ' +
	            'writing a grouped type followed by an =>, which is a syntax ' +
	            'error. Remember, function type parameters are named so function ' +
	            'types look like (name1: type1, name2: type2) => returnType. You ' +
	            'probably wrote (type1) => returnType'
	    };

	    // See also tools/generate-unicode-regex.py.
	    Regex = {
	        NonAsciiIdentifierStart: new RegExp('[\xaa\xb5\xba\xc0-\xd6\xd8-\xf6\xf8-\u02c1\u02c6-\u02d1\u02e0-\u02e4\u02ec\u02ee\u0370-\u0374\u0376\u0377\u037a-\u037d\u0386\u0388-\u038a\u038c\u038e-\u03a1\u03a3-\u03f5\u03f7-\u0481\u048a-\u0527\u0531-\u0556\u0559\u0561-\u0587\u05d0-\u05ea\u05f0-\u05f2\u0620-\u064a\u066e\u066f\u0671-\u06d3\u06d5\u06e5\u06e6\u06ee\u06ef\u06fa-\u06fc\u06ff\u0710\u0712-\u072f\u074d-\u07a5\u07b1\u07ca-\u07ea\u07f4\u07f5\u07fa\u0800-\u0815\u081a\u0824\u0828\u0840-\u0858\u08a0\u08a2-\u08ac\u0904-\u0939\u093d\u0950\u0958-\u0961\u0971-\u0977\u0979-\u097f\u0985-\u098c\u098f\u0990\u0993-\u09a8\u09aa-\u09b0\u09b2\u09b6-\u09b9\u09bd\u09ce\u09dc\u09dd\u09df-\u09e1\u09f0\u09f1\u0a05-\u0a0a\u0a0f\u0a10\u0a13-\u0a28\u0a2a-\u0a30\u0a32\u0a33\u0a35\u0a36\u0a38\u0a39\u0a59-\u0a5c\u0a5e\u0a72-\u0a74\u0a85-\u0a8d\u0a8f-\u0a91\u0a93-\u0aa8\u0aaa-\u0ab0\u0ab2\u0ab3\u0ab5-\u0ab9\u0abd\u0ad0\u0ae0\u0ae1\u0b05-\u0b0c\u0b0f\u0b10\u0b13-\u0b28\u0b2a-\u0b30\u0b32\u0b33\u0b35-\u0b39\u0b3d\u0b5c\u0b5d\u0b5f-\u0b61\u0b71\u0b83\u0b85-\u0b8a\u0b8e-\u0b90\u0b92-\u0b95\u0b99\u0b9a\u0b9c\u0b9e\u0b9f\u0ba3\u0ba4\u0ba8-\u0baa\u0bae-\u0bb9\u0bd0\u0c05-\u0c0c\u0c0e-\u0c10\u0c12-\u0c28\u0c2a-\u0c33\u0c35-\u0c39\u0c3d\u0c58\u0c59\u0c60\u0c61\u0c85-\u0c8c\u0c8e-\u0c90\u0c92-\u0ca8\u0caa-\u0cb3\u0cb5-\u0cb9\u0cbd\u0cde\u0ce0\u0ce1\u0cf1\u0cf2\u0d05-\u0d0c\u0d0e-\u0d10\u0d12-\u0d3a\u0d3d\u0d4e\u0d60\u0d61\u0d7a-\u0d7f\u0d85-\u0d96\u0d9a-\u0db1\u0db3-\u0dbb\u0dbd\u0dc0-\u0dc6\u0e01-\u0e30\u0e32\u0e33\u0e40-\u0e46\u0e81\u0e82\u0e84\u0e87\u0e88\u0e8a\u0e8d\u0e94-\u0e97\u0e99-\u0e9f\u0ea1-\u0ea3\u0ea5\u0ea7\u0eaa\u0eab\u0ead-\u0eb0\u0eb2\u0eb3\u0ebd\u0ec0-\u0ec4\u0ec6\u0edc-\u0edf\u0f00\u0f40-\u0f47\u0f49-\u0f6c\u0f88-\u0f8c\u1000-\u102a\u103f\u1050-\u1055\u105a-\u105d\u1061\u1065\u1066\u106e-\u1070\u1075-\u1081\u108e\u10a0-\u10c5\u10c7\u10cd\u10d0-\u10fa\u10fc-\u1248\u124a-\u124d\u1250-\u1256\u1258\u125a-\u125d\u1260-\u1288\u128a-\u128d\u1290-\u12b0\u12b2-\u12b5\u12b8-\u12be\u12c0\u12c2-\u12c5\u12c8-\u12d6\u12d8-\u1310\u1312-\u1315\u1318-\u135a\u1380-\u138f\u13a0-\u13f4\u1401-\u166c\u166f-\u167f\u1681-\u169a\u16a0-\u16ea\u16ee-\u16f0\u1700-\u170c\u170e-\u1711\u1720-\u1731\u1740-\u1751\u1760-\u176c\u176e-\u1770\u1780-\u17b3\u17d7\u17dc\u1820-\u1877\u1880-\u18a8\u18aa\u18b0-\u18f5\u1900-\u191c\u1950-\u196d\u1970-\u1974\u1980-\u19ab\u19c1-\u19c7\u1a00-\u1a16\u1a20-\u1a54\u1aa7\u1b05-\u1b33\u1b45-\u1b4b\u1b83-\u1ba0\u1bae\u1baf\u1bba-\u1be5\u1c00-\u1c23\u1c4d-\u1c4f\u1c5a-\u1c7d\u1ce9-\u1cec\u1cee-\u1cf1\u1cf5\u1cf6\u1d00-\u1dbf\u1e00-\u1f15\u1f18-\u1f1d\u1f20-\u1f45\u1f48-\u1f4d\u1f50-\u1f57\u1f59\u1f5b\u1f5d\u1f5f-\u1f7d\u1f80-\u1fb4\u1fb6-\u1fbc\u1fbe\u1fc2-\u1fc4\u1fc6-\u1fcc\u1fd0-\u1fd3\u1fd6-\u1fdb\u1fe0-\u1fec\u1ff2-\u1ff4\u1ff6-\u1ffc\u2071\u207f\u2090-\u209c\u2102\u2107\u210a-\u2113\u2115\u2119-\u211d\u2124\u2126\u2128\u212a-\u212d\u212f-\u2139\u213c-\u213f\u2145-\u2149\u214e\u2160-\u2188\u2c00-\u2c2e\u2c30-\u2c5e\u2c60-\u2ce4\u2ceb-\u2cee\u2cf2\u2cf3\u2d00-\u2d25\u2d27\u2d2d\u2d30-\u2d67\u2d6f\u2d80-\u2d96\u2da0-\u2da6\u2da8-\u2dae\u2db0-\u2db6\u2db8-\u2dbe\u2dc0-\u2dc6\u2dc8-\u2dce\u2dd0-\u2dd6\u2dd8-\u2dde\u2e2f\u3005-\u3007\u3021-\u3029\u3031-\u3035\u3038-\u303c\u3041-\u3096\u309d-\u309f\u30a1-\u30fa\u30fc-\u30ff\u3105-\u312d\u3131-\u318e\u31a0-\u31ba\u31f0-\u31ff\u3400-\u4db5\u4e00-\u9fcc\ua000-\ua48c\ua4d0-\ua4fd\ua500-\ua60c\ua610-\ua61f\ua62a\ua62b\ua640-\ua66e\ua67f-\ua697\ua6a0-\ua6ef\ua717-\ua71f\ua722-\ua788\ua78b-\ua78e\ua790-\ua793\ua7a0-\ua7aa\ua7f8-\ua801\ua803-\ua805\ua807-\ua80a\ua80c-\ua822\ua840-\ua873\ua882-\ua8b3\ua8f2-\ua8f7\ua8fb\ua90a-\ua925\ua930-\ua946\ua960-\ua97c\ua984-\ua9b2\ua9cf\uaa00-\uaa28\uaa40-\uaa42\uaa44-\uaa4b\uaa60-\uaa76\uaa7a\uaa80-\uaaaf\uaab1\uaab5\uaab6\uaab9-\uaabd\uaac0\uaac2\uaadb-\uaadd\uaae0-\uaaea\uaaf2-\uaaf4\uab01-\uab06\uab09-\uab0e\uab11-\uab16\uab20-\uab26\uab28-\uab2e\uabc0-\uabe2\uac00-\ud7a3\ud7b0-\ud7c6\ud7cb-\ud7fb\uf900-\ufa6d\ufa70-\ufad9\ufb00-\ufb06\ufb13-\ufb17\ufb1d\ufb1f-\ufb28\ufb2a-\ufb36\ufb38-\ufb3c\ufb3e\ufb40\ufb41\ufb43\ufb44\ufb46-\ufbb1\ufbd3-\ufd3d\ufd50-\ufd8f\ufd92-\ufdc7\ufdf0-\ufdfb\ufe70-\ufe74\ufe76-\ufefc\uff21-\uff3a\uff41-\uff5a\uff66-\uffbe\uffc2-\uffc7\uffca-\uffcf\uffd2-\uffd7\uffda-\uffdc]'),
	        NonAsciiIdentifierPart: new RegExp('[\xaa\xb5\xba\xc0-\xd6\xd8-\xf6\xf8-\u02c1\u02c6-\u02d1\u02e0-\u02e4\u02ec\u02ee\u0300-\u0374\u0376\u0377\u037a-\u037d\u0386\u0388-\u038a\u038c\u038e-\u03a1\u03a3-\u03f5\u03f7-\u0481\u0483-\u0487\u048a-\u0527\u0531-\u0556\u0559\u0561-\u0587\u0591-\u05bd\u05bf\u05c1\u05c2\u05c4\u05c5\u05c7\u05d0-\u05ea\u05f0-\u05f2\u0610-\u061a\u0620-\u0669\u066e-\u06d3\u06d5-\u06dc\u06df-\u06e8\u06ea-\u06fc\u06ff\u0710-\u074a\u074d-\u07b1\u07c0-\u07f5\u07fa\u0800-\u082d\u0840-\u085b\u08a0\u08a2-\u08ac\u08e4-\u08fe\u0900-\u0963\u0966-\u096f\u0971-\u0977\u0979-\u097f\u0981-\u0983\u0985-\u098c\u098f\u0990\u0993-\u09a8\u09aa-\u09b0\u09b2\u09b6-\u09b9\u09bc-\u09c4\u09c7\u09c8\u09cb-\u09ce\u09d7\u09dc\u09dd\u09df-\u09e3\u09e6-\u09f1\u0a01-\u0a03\u0a05-\u0a0a\u0a0f\u0a10\u0a13-\u0a28\u0a2a-\u0a30\u0a32\u0a33\u0a35\u0a36\u0a38\u0a39\u0a3c\u0a3e-\u0a42\u0a47\u0a48\u0a4b-\u0a4d\u0a51\u0a59-\u0a5c\u0a5e\u0a66-\u0a75\u0a81-\u0a83\u0a85-\u0a8d\u0a8f-\u0a91\u0a93-\u0aa8\u0aaa-\u0ab0\u0ab2\u0ab3\u0ab5-\u0ab9\u0abc-\u0ac5\u0ac7-\u0ac9\u0acb-\u0acd\u0ad0\u0ae0-\u0ae3\u0ae6-\u0aef\u0b01-\u0b03\u0b05-\u0b0c\u0b0f\u0b10\u0b13-\u0b28\u0b2a-\u0b30\u0b32\u0b33\u0b35-\u0b39\u0b3c-\u0b44\u0b47\u0b48\u0b4b-\u0b4d\u0b56\u0b57\u0b5c\u0b5d\u0b5f-\u0b63\u0b66-\u0b6f\u0b71\u0b82\u0b83\u0b85-\u0b8a\u0b8e-\u0b90\u0b92-\u0b95\u0b99\u0b9a\u0b9c\u0b9e\u0b9f\u0ba3\u0ba4\u0ba8-\u0baa\u0bae-\u0bb9\u0bbe-\u0bc2\u0bc6-\u0bc8\u0bca-\u0bcd\u0bd0\u0bd7\u0be6-\u0bef\u0c01-\u0c03\u0c05-\u0c0c\u0c0e-\u0c10\u0c12-\u0c28\u0c2a-\u0c33\u0c35-\u0c39\u0c3d-\u0c44\u0c46-\u0c48\u0c4a-\u0c4d\u0c55\u0c56\u0c58\u0c59\u0c60-\u0c63\u0c66-\u0c6f\u0c82\u0c83\u0c85-\u0c8c\u0c8e-\u0c90\u0c92-\u0ca8\u0caa-\u0cb3\u0cb5-\u0cb9\u0cbc-\u0cc4\u0cc6-\u0cc8\u0cca-\u0ccd\u0cd5\u0cd6\u0cde\u0ce0-\u0ce3\u0ce6-\u0cef\u0cf1\u0cf2\u0d02\u0d03\u0d05-\u0d0c\u0d0e-\u0d10\u0d12-\u0d3a\u0d3d-\u0d44\u0d46-\u0d48\u0d4a-\u0d4e\u0d57\u0d60-\u0d63\u0d66-\u0d6f\u0d7a-\u0d7f\u0d82\u0d83\u0d85-\u0d96\u0d9a-\u0db1\u0db3-\u0dbb\u0dbd\u0dc0-\u0dc6\u0dca\u0dcf-\u0dd4\u0dd6\u0dd8-\u0ddf\u0df2\u0df3\u0e01-\u0e3a\u0e40-\u0e4e\u0e50-\u0e59\u0e81\u0e82\u0e84\u0e87\u0e88\u0e8a\u0e8d\u0e94-\u0e97\u0e99-\u0e9f\u0ea1-\u0ea3\u0ea5\u0ea7\u0eaa\u0eab\u0ead-\u0eb9\u0ebb-\u0ebd\u0ec0-\u0ec4\u0ec6\u0ec8-\u0ecd\u0ed0-\u0ed9\u0edc-\u0edf\u0f00\u0f18\u0f19\u0f20-\u0f29\u0f35\u0f37\u0f39\u0f3e-\u0f47\u0f49-\u0f6c\u0f71-\u0f84\u0f86-\u0f97\u0f99-\u0fbc\u0fc6\u1000-\u1049\u1050-\u109d\u10a0-\u10c5\u10c7\u10cd\u10d0-\u10fa\u10fc-\u1248\u124a-\u124d\u1250-\u1256\u1258\u125a-\u125d\u1260-\u1288\u128a-\u128d\u1290-\u12b0\u12b2-\u12b5\u12b8-\u12be\u12c0\u12c2-\u12c5\u12c8-\u12d6\u12d8-\u1310\u1312-\u1315\u1318-\u135a\u135d-\u135f\u1380-\u138f\u13a0-\u13f4\u1401-\u166c\u166f-\u167f\u1681-\u169a\u16a0-\u16ea\u16ee-\u16f0\u1700-\u170c\u170e-\u1714\u1720-\u1734\u1740-\u1753\u1760-\u176c\u176e-\u1770\u1772\u1773\u1780-\u17d3\u17d7\u17dc\u17dd\u17e0-\u17e9\u180b-\u180d\u1810-\u1819\u1820-\u1877\u1880-\u18aa\u18b0-\u18f5\u1900-\u191c\u1920-\u192b\u1930-\u193b\u1946-\u196d\u1970-\u1974\u1980-\u19ab\u19b0-\u19c9\u19d0-\u19d9\u1a00-\u1a1b\u1a20-\u1a5e\u1a60-\u1a7c\u1a7f-\u1a89\u1a90-\u1a99\u1aa7\u1b00-\u1b4b\u1b50-\u1b59\u1b6b-\u1b73\u1b80-\u1bf3\u1c00-\u1c37\u1c40-\u1c49\u1c4d-\u1c7d\u1cd0-\u1cd2\u1cd4-\u1cf6\u1d00-\u1de6\u1dfc-\u1f15\u1f18-\u1f1d\u1f20-\u1f45\u1f48-\u1f4d\u1f50-\u1f57\u1f59\u1f5b\u1f5d\u1f5f-\u1f7d\u1f80-\u1fb4\u1fb6-\u1fbc\u1fbe\u1fc2-\u1fc4\u1fc6-\u1fcc\u1fd0-\u1fd3\u1fd6-\u1fdb\u1fe0-\u1fec\u1ff2-\u1ff4\u1ff6-\u1ffc\u200c\u200d\u203f\u2040\u2054\u2071\u207f\u2090-\u209c\u20d0-\u20dc\u20e1\u20e5-\u20f0\u2102\u2107\u210a-\u2113\u2115\u2119-\u211d\u2124\u2126\u2128\u212a-\u212d\u212f-\u2139\u213c-\u213f\u2145-\u2149\u214e\u2160-\u2188\u2c00-\u2c2e\u2c30-\u2c5e\u2c60-\u2ce4\u2ceb-\u2cf3\u2d00-\u2d25\u2d27\u2d2d\u2d30-\u2d67\u2d6f\u2d7f-\u2d96\u2da0-\u2da6\u2da8-\u2dae\u2db0-\u2db6\u2db8-\u2dbe\u2dc0-\u2dc6\u2dc8-\u2dce\u2dd0-\u2dd6\u2dd8-\u2dde\u2de0-\u2dff\u2e2f\u3005-\u3007\u3021-\u302f\u3031-\u3035\u3038-\u303c\u3041-\u3096\u3099\u309a\u309d-\u309f\u30a1-\u30fa\u30fc-\u30ff\u3105-\u312d\u3131-\u318e\u31a0-\u31ba\u31f0-\u31ff\u3400-\u4db5\u4e00-\u9fcc\ua000-\ua48c\ua4d0-\ua4fd\ua500-\ua60c\ua610-\ua62b\ua640-\ua66f\ua674-\ua67d\ua67f-\ua697\ua69f-\ua6f1\ua717-\ua71f\ua722-\ua788\ua78b-\ua78e\ua790-\ua793\ua7a0-\ua7aa\ua7f8-\ua827\ua840-\ua873\ua880-\ua8c4\ua8d0-\ua8d9\ua8e0-\ua8f7\ua8fb\ua900-\ua92d\ua930-\ua953\ua960-\ua97c\ua980-\ua9c0\ua9cf-\ua9d9\uaa00-\uaa36\uaa40-\uaa4d\uaa50-\uaa59\uaa60-\uaa76\uaa7a\uaa7b\uaa80-\uaac2\uaadb-\uaadd\uaae0-\uaaef\uaaf2-\uaaf6\uab01-\uab06\uab09-\uab0e\uab11-\uab16\uab20-\uab26\uab28-\uab2e\uabc0-\uabea\uabec\uabed\uabf0-\uabf9\uac00-\ud7a3\ud7b0-\ud7c6\ud7cb-\ud7fb\uf900-\ufa6d\ufa70-\ufad9\ufb00-\ufb06\ufb13-\ufb17\ufb1d-\ufb28\ufb2a-\ufb36\ufb38-\ufb3c\ufb3e\ufb40\ufb41\ufb43\ufb44\ufb46-\ufbb1\ufbd3-\ufd3d\ufd50-\ufd8f\ufd92-\ufdc7\ufdf0-\ufdfb\ufe00-\ufe0f\ufe20-\ufe26\ufe33\ufe34\ufe4d-\ufe4f\ufe70-\ufe74\ufe76-\ufefc\uff10-\uff19\uff21-\uff3a\uff3f\uff41-\uff5a\uff66-\uffbe\uffc2-\uffc7\uffca-\uffcf\uffd2-\uffd7\uffda-\uffdc]'),
	        LeadingZeros: new RegExp('^0+(?!$)')
	    };

	    // Ensure the condition is true, otherwise throw an error.
	    // This is only to have a better contract semantic, i.e. another safety net
	    // to catch a logic error. The condition shall be fulfilled in normal case.
	    // Do NOT use this to enforce a certain condition on any user input.

	    function assert(condition, message) {
	        /* istanbul ignore if */
	        if (!condition) {
	            throw new Error('ASSERT: ' + message);
	        }
	    }

	    function StringMap() {
	        this.$data = {};
	    }

	    StringMap.prototype.get = function (key) {
	        key = '$' + key;
	        return this.$data[key];
	    };

	    StringMap.prototype.set = function (key, value) {
	        key = '$' + key;
	        this.$data[key] = value;
	        return this;
	    };

	    StringMap.prototype.has = function (key) {
	        key = '$' + key;
	        return Object.prototype.hasOwnProperty.call(this.$data, key);
	    };

	    StringMap.prototype['delete'] = function (key) {
	        key = '$' + key;
	        return delete this.$data[key];
	    };

	    function isDecimalDigit(ch) {
	        return (ch >= 48 && ch <= 57);   // 0..9
	    }

	    function isHexDigit(ch) {
	        return '0123456789abcdefABCDEF'.indexOf(ch) >= 0;
	    }

	    function isOctalDigit(ch) {
	        return '01234567'.indexOf(ch) >= 0;
	    }


	    // 7.2 White Space

	    function isWhiteSpace(ch) {
	        return (ch === 32) ||  // space
	            (ch === 9) ||      // tab
	            (ch === 0xB) ||
	            (ch === 0xC) ||
	            (ch === 0xA0) ||
	            (ch >= 0x1680 && '\u1680\u180E\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200A\u202F\u205F\u3000\uFEFF'.indexOf(String.fromCharCode(ch)) > 0);
	    }

	    // 7.3 Line Terminators

	    function isLineTerminator(ch) {
	        return (ch === 10) || (ch === 13) || (ch === 0x2028) || (ch === 0x2029);
	    }

	    // 7.6 Identifier Names and Identifiers

	    function isIdentifierStart(ch) {
	        return (ch === 36) || (ch === 95) ||  // $ (dollar) and _ (underscore)
	            (ch >= 65 && ch <= 90) ||         // A..Z
	            (ch >= 97 && ch <= 122) ||        // a..z
	            (ch === 92) ||                    // \ (backslash)
	            ((ch >= 0x80) && Regex.NonAsciiIdentifierStart.test(String.fromCharCode(ch)));
	    }

	    function isIdentifierPart(ch) {
	        return (ch === 36) || (ch === 95) ||  // $ (dollar) and _ (underscore)
	            (ch >= 65 && ch <= 90) ||         // A..Z
	            (ch >= 97 && ch <= 122) ||        // a..z
	            (ch >= 48 && ch <= 57) ||         // 0..9
	            (ch === 92) ||                    // \ (backslash)
	            ((ch >= 0x80) && Regex.NonAsciiIdentifierPart.test(String.fromCharCode(ch)));
	    }

	    // 7.6.1.2 Future Reserved Words

	    function isFutureReservedWord(id) {
	        switch (id) {
	        case 'class':
	        case 'enum':
	        case 'export':
	        case 'extends':
	        case 'import':
	        case 'super':
	            return true;
	        default:
	            return false;
	        }
	    }

	    function isStrictModeReservedWord(id) {
	        switch (id) {
	        case 'implements':
	        case 'interface':
	        case 'package':
	        case 'private':
	        case 'protected':
	        case 'public':
	        case 'static':
	        case 'yield':
	        case 'let':
	            return true;
	        default:
	            return false;
	        }
	    }

	    function isRestrictedWord(id) {
	        return id === 'eval' || id === 'arguments';
	    }

	    // 7.6.1.1 Keywords

	    function isKeyword(id) {
	        if (strict && isStrictModeReservedWord(id)) {
	            return true;
	        }

	        // 'const' is specialized as Keyword in V8.
	        // 'yield' is only treated as a keyword in strict mode.
	        // 'let' is for compatiblity with SpiderMonkey and ES.next.
	        // Some others are from future reserved words.

	        switch (id.length) {
	        case 2:
	            return (id === 'if') || (id === 'in') || (id === 'do');
	        case 3:
	            return (id === 'var') || (id === 'for') || (id === 'new') ||
	                (id === 'try') || (id === 'let');
	        case 4:
	            return (id === 'this') || (id === 'else') || (id === 'case') ||
	                (id === 'void') || (id === 'with') || (id === 'enum');
	        case 5:
	            return (id === 'while') || (id === 'break') || (id === 'catch') ||
	                (id === 'throw') || (id === 'const') ||
	                (id === 'class') || (id === 'super');
	        case 6:
	            return (id === 'return') || (id === 'typeof') || (id === 'delete') ||
	                (id === 'switch') || (id === 'export') || (id === 'import');
	        case 7:
	            return (id === 'default') || (id === 'finally') || (id === 'extends');
	        case 8:
	            return (id === 'function') || (id === 'continue') || (id === 'debugger');
	        case 10:
	            return (id === 'instanceof');
	        default:
	            return false;
	        }
	    }

	    // 7.4 Comments

	    function skipComment() {
	        var ch, blockComment, lineComment;

	        blockComment = false;
	        lineComment = false;

	        while (index < length) {
	            ch = source.charCodeAt(index);

	            if (lineComment) {
	                ++index;
	                if (isLineTerminator(ch)) {
	                    lineComment = false;
	                    if (ch === 13 && source.charCodeAt(index) === 10) {
	                        ++index;
	                    }
	                    ++lineNumber;
	                    lineStart = index;
	                }
	            } else if (blockComment) {
	                if (isLineTerminator(ch)) {
	                    if (ch === 13) {
	                        ++index;
	                    }
	                    if (ch !== 13 || source.charCodeAt(index) === 10) {
	                        ++lineNumber;
	                        ++index;
	                        lineStart = index;
	                        if (index >= length) {
	                            throwError({}, Messages.UnexpectedToken, 'ILLEGAL');
	                        }
	                    }
	                } else {
	                    ch = source.charCodeAt(index++);
	                    if (index >= length) {
	                        throwError({}, Messages.UnexpectedToken, 'ILLEGAL');
	                    }
	                    // Block comment ends with '*/' (char #42, char #47).
	                    if (ch === 42) {
	                        ch = source.charCodeAt(index);
	                        if (ch === 47) {
	                            ++index;
	                            blockComment = false;
	                        }
	                    }
	                }
	            } else if (ch === 47) {
	                ch = source.charCodeAt(index + 1);
	                // Line comment starts with '//' (char #47, char #47).
	                if (ch === 47) {
	                    index += 2;
	                    lineComment = true;
	                } else if (ch === 42) {
	                    // Block comment starts with '/*' (char #47, char #42).
	                    index += 2;
	                    blockComment = true;
	                    if (index >= length) {
	                        throwError({}, Messages.UnexpectedToken, 'ILLEGAL');
	                    }
	                } else {
	                    break;
	                }
	            } else if (isWhiteSpace(ch)) {
	                ++index;
	            } else if (isLineTerminator(ch)) {
	                ++index;
	                if (ch === 13 && source.charCodeAt(index) === 10) {
	                    ++index;
	                }
	                ++lineNumber;
	                lineStart = index;
	            } else {
	                break;
	            }
	        }
	    }

	    function scanHexEscape(prefix) {
	        var i, len, ch, code = 0;

	        len = (prefix === 'u') ? 4 : 2;
	        for (i = 0; i < len; ++i) {
	            if (index < length && isHexDigit(source[index])) {
	                ch = source[index++];
	                code = code * 16 + '0123456789abcdef'.indexOf(ch.toLowerCase());
	            } else {
	                return '';
	            }
	        }
	        return String.fromCharCode(code);
	    }

	    function scanUnicodeCodePointEscape() {
	        var ch, code, cu1, cu2;

	        ch = source[index];
	        code = 0;

	        // At least, one hex digit is required.
	        if (ch === '}') {
	            throwError({}, Messages.UnexpectedToken, 'ILLEGAL');
	        }

	        while (index < length) {
	            ch = source[index++];
	            if (!isHexDigit(ch)) {
	                break;
	            }
	            code = code * 16 + '0123456789abcdef'.indexOf(ch.toLowerCase());
	        }

	        if (code > 0x10FFFF || ch !== '}') {
	            throwError({}, Messages.UnexpectedToken, 'ILLEGAL');
	        }

	        // UTF-16 Encoding
	        if (code <= 0xFFFF) {
	            return String.fromCharCode(code);
	        }
	        cu1 = ((code - 0x10000) >> 10) + 0xD800;
	        cu2 = ((code - 0x10000) & 1023) + 0xDC00;
	        return String.fromCharCode(cu1, cu2);
	    }

	    function getEscapedIdentifier() {
	        var ch, id;

	        ch = source.charCodeAt(index++);
	        id = String.fromCharCode(ch);

	        // '\u' (char #92, char #117) denotes an escaped character.
	        if (ch === 92) {
	            if (source.charCodeAt(index) !== 117) {
	                throwError({}, Messages.UnexpectedToken, 'ILLEGAL');
	            }
	            ++index;
	            ch = scanHexEscape('u');
	            if (!ch || ch === '\\' || !isIdentifierStart(ch.charCodeAt(0))) {
	                throwError({}, Messages.UnexpectedToken, 'ILLEGAL');
	            }
	            id = ch;
	        }

	        while (index < length) {
	            ch = source.charCodeAt(index);
	            if (!isIdentifierPart(ch)) {
	                break;
	            }
	            ++index;
	            id += String.fromCharCode(ch);

	            // '\u' (char #92, char #117) denotes an escaped character.
	            if (ch === 92) {
	                id = id.substr(0, id.length - 1);
	                if (source.charCodeAt(index) !== 117) {
	                    throwError({}, Messages.UnexpectedToken, 'ILLEGAL');
	                }
	                ++index;
	                ch = scanHexEscape('u');
	                if (!ch || ch === '\\' || !isIdentifierPart(ch.charCodeAt(0))) {
	                    throwError({}, Messages.UnexpectedToken, 'ILLEGAL');
	                }
	                id += ch;
	            }
	        }

	        return id;
	    }

	    function getIdentifier() {
	        var start, ch;

	        start = index++;
	        while (index < length) {
	            ch = source.charCodeAt(index);
	            if (ch === 92) {
	                // Blackslash (char #92) marks Unicode escape sequence.
	                index = start;
	                return getEscapedIdentifier();
	            }
	            if (isIdentifierPart(ch)) {
	                ++index;
	            } else {
	                break;
	            }
	        }

	        return source.slice(start, index);
	    }

	    function scanIdentifier() {
	        var start, id, type;

	        start = index;

	        // Backslash (char #92) starts an escaped character.
	        id = (source.charCodeAt(index) === 92) ? getEscapedIdentifier() : getIdentifier();

	        // There is no keyword or literal with only one character.
	        // Thus, it must be an identifier.
	        if (id.length === 1) {
	            type = Token.Identifier;
	        } else if (isKeyword(id)) {
	            type = Token.Keyword;
	        } else if (id === 'null') {
	            type = Token.NullLiteral;
	        } else if (id === 'true' || id === 'false') {
	            type = Token.BooleanLiteral;
	        } else {
	            type = Token.Identifier;
	        }

	        return {
	            type: type,
	            value: id,
	            lineNumber: lineNumber,
	            lineStart: lineStart,
	            range: [start, index]
	        };
	    }


	    // 7.7 Punctuators

	    function scanPunctuator() {
	        var start = index,
	            code = source.charCodeAt(index),
	            code2,
	            ch1 = source[index],
	            ch2,
	            ch3,
	            ch4;

	        switch (code) {
	        // Check for most common single-character punctuators.
	        case 40:   // ( open bracket
	        case 41:   // ) close bracket
	        case 59:   // ; semicolon
	        case 44:   // , comma
	        case 123:  // { open curly brace
	        case 125:  // } close curly brace
	        case 91:   // [
	        case 93:   // ]
	        case 58:   // :
	        case 63:   // ?
	        case 126:  // ~
	            ++index;
	            if (extra.tokenize) {
	                if (code === 40) {
	                    extra.openParenToken = extra.tokens.length;
	                } else if (code === 123) {
	                    extra.openCurlyToken = extra.tokens.length;
	                }
	            }
	            return {
	                type: Token.Punctuator,
	                value: String.fromCharCode(code),
	                lineNumber: lineNumber,
	                lineStart: lineStart,
	                range: [start, index]
	            };

	        default:
	            code2 = source.charCodeAt(index + 1);

	            // '=' (char #61) marks an assignment or comparison operator.
	            if (code2 === 61) {
	                switch (code) {
	                case 37:  // %
	                case 38:  // &
	                case 42:  // *:
	                case 43:  // +
	                case 45:  // -
	                case 47:  // /
	                case 60:  // <
	                case 62:  // >
	                case 94:  // ^
	                case 124: // |
	                    index += 2;
	                    return {
	                        type: Token.Punctuator,
	                        value: String.fromCharCode(code) + String.fromCharCode(code2),
	                        lineNumber: lineNumber,
	                        lineStart: lineStart,
	                        range: [start, index]
	                    };

	                case 33: // !
	                case 61: // =
	                    index += 2;

	                    // !== and ===
	                    if (source.charCodeAt(index) === 61) {
	                        ++index;
	                    }
	                    return {
	                        type: Token.Punctuator,
	                        value: source.slice(start, index),
	                        lineNumber: lineNumber,
	                        lineStart: lineStart,
	                        range: [start, index]
	                    };
	                default:
	                    break;
	                }
	            }
	            break;
	        }

	        // Peek more characters.

	        ch2 = source[index + 1];
	        ch3 = source[index + 2];
	        ch4 = source[index + 3];

	        // 4-character punctuator: >>>=

	        if (ch1 === '>' && ch2 === '>' && ch3 === '>') {
	            if (ch4 === '=') {
	                index += 4;
	                return {
	                    type: Token.Punctuator,
	                    value: '>>>=',
	                    lineNumber: lineNumber,
	                    lineStart: lineStart,
	                    range: [start, index]
	                };
	            }
	        }

	        // 3-character punctuators: === !== >>> <<= >>=

	        if (ch1 === '>' && ch2 === '>' && ch3 === '>') {
	            index += 3;
	            return {
	                type: Token.Punctuator,
	                value: '>>>',
	                lineNumber: lineNumber,
	                lineStart: lineStart,
	                range: [start, index]
	            };
	        }

	        if (ch1 === '<' && ch2 === '<' && ch3 === '=') {
	            index += 3;
	            return {
	                type: Token.Punctuator,
	                value: '<<=',
	                lineNumber: lineNumber,
	                lineStart: lineStart,
	                range: [start, index]
	            };
	        }

	        if (ch1 === '>' && ch2 === '>' && ch3 === '=') {
	            index += 3;
	            return {
	                type: Token.Punctuator,
	                value: '>>=',
	                lineNumber: lineNumber,
	                lineStart: lineStart,
	                range: [start, index]
	            };
	        }

	        if (ch1 === '.' && ch2 === '.' && ch3 === '.') {
	            index += 3;
	            return {
	                type: Token.Punctuator,
	                value: '...',
	                lineNumber: lineNumber,
	                lineStart: lineStart,
	                range: [start, index]
	            };
	        }

	        // Other 2-character punctuators: ++ -- << >> && ||

	        // Don't match these tokens if we're in a type, since they never can
	        // occur and can mess up types like Map<string, Array<string>>
	        if (ch1 === ch2 && ('+-<>&|'.indexOf(ch1) >= 0) && !state.inType) {
	            index += 2;
	            return {
	                type: Token.Punctuator,
	                value: ch1 + ch2,
	                lineNumber: lineNumber,
	                lineStart: lineStart,
	                range: [start, index]
	            };
	        }

	        if (ch1 === '=' && ch2 === '>') {
	            index += 2;
	            return {
	                type: Token.Punctuator,
	                value: '=>',
	                lineNumber: lineNumber,
	                lineStart: lineStart,
	                range: [start, index]
	            };
	        }

	        if ('<>=!+-*%&|^/'.indexOf(ch1) >= 0) {
	            ++index;
	            return {
	                type: Token.Punctuator,
	                value: ch1,
	                lineNumber: lineNumber,
	                lineStart: lineStart,
	                range: [start, index]
	            };
	        }

	        if (ch1 === '.') {
	            ++index;
	            return {
	                type: Token.Punctuator,
	                value: ch1,
	                lineNumber: lineNumber,
	                lineStart: lineStart,
	                range: [start, index]
	            };
	        }

	        throwError({}, Messages.UnexpectedToken, 'ILLEGAL');
	    }

	    // 7.8.3 Numeric Literals

	    function scanHexLiteral(start) {
	        var number = '';

	        while (index < length) {
	            if (!isHexDigit(source[index])) {
	                break;
	            }
	            number += source[index++];
	        }

	        if (number.length === 0) {
	            throwError({}, Messages.UnexpectedToken, 'ILLEGAL');
	        }

	        if (isIdentifierStart(source.charCodeAt(index))) {
	            throwError({}, Messages.UnexpectedToken, 'ILLEGAL');
	        }

	        return {
	            type: Token.NumericLiteral,
	            value: parseInt('0x' + number, 16),
	            lineNumber: lineNumber,
	            lineStart: lineStart,
	            range: [start, index]
	        };
	    }

	    function scanOctalLiteral(prefix, start) {
	        var number, octal;

	        if (isOctalDigit(prefix)) {
	            octal = true;
	            number = '0' + source[index++];
	        } else {
	            octal = false;
	            ++index;
	            number = '';
	        }

	        while (index < length) {
	            if (!isOctalDigit(source[index])) {
	                break;
	            }
	            number += source[index++];
	        }

	        if (!octal && number.length === 0) {
	            // only 0o or 0O
	            throwError({}, Messages.UnexpectedToken, 'ILLEGAL');
	        }

	        if (isIdentifierStart(source.charCodeAt(index)) || isDecimalDigit(source.charCodeAt(index))) {
	            throwError({}, Messages.UnexpectedToken, 'ILLEGAL');
	        }

	        return {
	            type: Token.NumericLiteral,
	            value: parseInt(number, 8),
	            octal: octal,
	            lineNumber: lineNumber,
	            lineStart: lineStart,
	            range: [start, index]
	        };
	    }

	    function scanNumericLiteral() {
	        var number, start, ch, octal;

	        ch = source[index];
	        assert(isDecimalDigit(ch.charCodeAt(0)) || (ch === '.'),
	            'Numeric literal must start with a decimal digit or a decimal point');

	        start = index;
	        number = '';
	        if (ch !== '.') {
	            number = source[index++];
	            ch = source[index];

	            // Hex number starts with '0x'.
	            // Octal number starts with '0'.
	            // Octal number in ES6 starts with '0o'.
	            // Binary number in ES6 starts with '0b'.
	            if (number === '0') {
	                if (ch === 'x' || ch === 'X') {
	                    ++index;
	                    return scanHexLiteral(start);
	                }
	                if (ch === 'b' || ch === 'B') {
	                    ++index;
	                    number = '';

	                    while (index < length) {
	                        ch = source[index];
	                        if (ch !== '0' && ch !== '1') {
	                            break;
	                        }
	                        number += source[index++];
	                    }

	                    if (number.length === 0) {
	                        // only 0b or 0B
	                        throwError({}, Messages.UnexpectedToken, 'ILLEGAL');
	                    }

	                    if (index < length) {
	                        ch = source.charCodeAt(index);
	                        /* istanbul ignore else */
	                        if (isIdentifierStart(ch) || isDecimalDigit(ch)) {
	                            throwError({}, Messages.UnexpectedToken, 'ILLEGAL');
	                        }
	                    }
	                    return {
	                        type: Token.NumericLiteral,
	                        value: parseInt(number, 2),
	                        lineNumber: lineNumber,
	                        lineStart: lineStart,
	                        range: [start, index]
	                    };
	                }
	                if (ch === 'o' || ch === 'O' || isOctalDigit(ch)) {
	                    return scanOctalLiteral(ch, start);
	                }
	                // decimal number starts with '0' such as '09' is illegal.
	                if (ch && isDecimalDigit(ch.charCodeAt(0))) {
	                    throwError({}, Messages.UnexpectedToken, 'ILLEGAL');
	                }
	            }

	            while (isDecimalDigit(source.charCodeAt(index))) {
	                number += source[index++];
	            }
	            ch = source[index];
	        }

	        if (ch === '.') {
	            number += source[index++];
	            while (isDecimalDigit(source.charCodeAt(index))) {
	                number += source[index++];
	            }
	            ch = source[index];
	        }

	        if (ch === 'e' || ch === 'E') {
	            number += source[index++];

	            ch = source[index];
	            if (ch === '+' || ch === '-') {
	                number += source[index++];
	            }
	            if (isDecimalDigit(source.charCodeAt(index))) {
	                while (isDecimalDigit(source.charCodeAt(index))) {
	                    number += source[index++];
	                }
	            } else {
	                throwError({}, Messages.UnexpectedToken, 'ILLEGAL');
	            }
	        }

	        if (isIdentifierStart(source.charCodeAt(index))) {
	            throwError({}, Messages.UnexpectedToken, 'ILLEGAL');
	        }

	        return {
	            type: Token.NumericLiteral,
	            value: parseFloat(number),
	            lineNumber: lineNumber,
	            lineStart: lineStart,
	            range: [start, index]
	        };
	    }

	    // 7.8.4 String Literals

	    function scanStringLiteral() {
	        var str = '', quote, start, ch, code, unescaped, restore, octal = false;

	        quote = source[index];
	        assert((quote === '\'' || quote === '"'),
	            'String literal must starts with a quote');

	        start = index;
	        ++index;

	        while (index < length) {
	            ch = source[index++];

	            if (ch === quote) {
	                quote = '';
	                break;
	            } else if (ch === '\\') {
	                ch = source[index++];
	                if (!ch || !isLineTerminator(ch.charCodeAt(0))) {
	                    switch (ch) {
	                    case 'n':
	                        str += '\n';
	                        break;
	                    case 'r':
	                        str += '\r';
	                        break;
	                    case 't':
	                        str += '\t';
	                        break;
	                    case 'u':
	                    case 'x':
	                        if (source[index] === '{') {
	                            ++index;
	                            str += scanUnicodeCodePointEscape();
	                        } else {
	                            restore = index;
	                            unescaped = scanHexEscape(ch);
	                            if (unescaped) {
	                                str += unescaped;
	                            } else {
	                                index = restore;
	                                str += ch;
	                            }
	                        }
	                        break;
	                    case 'b':
	                        str += '\b';
	                        break;
	                    case 'f':
	                        str += '\f';
	                        break;
	                    case 'v':
	                        str += '\x0B';
	                        break;

	                    default:
	                        if (isOctalDigit(ch)) {
	                            code = '01234567'.indexOf(ch);

	                            // \0 is not octal escape sequence
	                            if (code !== 0) {
	                                octal = true;
	                            }

	                            /* istanbul ignore else */
	                            if (index < length && isOctalDigit(source[index])) {
	                                octal = true;
	                                code = code * 8 + '01234567'.indexOf(source[index++]);

	                                // 3 digits are only allowed when string starts
	                                // with 0, 1, 2, 3
	                                if ('0123'.indexOf(ch) >= 0 &&
	                                        index < length &&
	                                        isOctalDigit(source[index])) {
	                                    code = code * 8 + '01234567'.indexOf(source[index++]);
	                                }
	                            }
	                            str += String.fromCharCode(code);
	                        } else {
	                            str += ch;
	                        }
	                        break;
	                    }
	                } else {
	                    ++lineNumber;
	                    if (ch ===  '\r' && source[index] === '\n') {
	                        ++index;
	                    }
	                    lineStart = index;
	                }
	            } else if (isLineTerminator(ch.charCodeAt(0))) {
	                break;
	            } else {
	                str += ch;
	            }
	        }

	        if (quote !== '') {
	            throwError({}, Messages.UnexpectedToken, 'ILLEGAL');
	        }

	        return {
	            type: Token.StringLiteral,
	            value: str,
	            octal: octal,
	            lineNumber: lineNumber,
	            lineStart: lineStart,
	            range: [start, index]
	        };
	    }

	    function scanTemplate() {
	        var cooked = '', ch, start, terminated, tail, restore, unescaped, code, octal;

	        terminated = false;
	        tail = false;
	        start = index;

	        ++index;

	        while (index < length) {
	            ch = source[index++];
	            if (ch === '`') {
	                tail = true;
	                terminated = true;
	                break;
	            } else if (ch === '$') {
	                if (source[index] === '{') {
	                    ++index;
	                    terminated = true;
	                    break;
	                }
	                cooked += ch;
	            } else if (ch === '\\') {
	                ch = source[index++];
	                if (!isLineTerminator(ch.charCodeAt(0))) {
	                    switch (ch) {
	                    case 'n':
	                        cooked += '\n';
	                        break;
	                    case 'r':
	                        cooked += '\r';
	                        break;
	                    case 't':
	                        cooked += '\t';
	                        break;
	                    case 'u':
	                    case 'x':
	                        if (source[index] === '{') {
	                            ++index;
	                            cooked += scanUnicodeCodePointEscape();
	                        } else {
	                            restore = index;
	                            unescaped = scanHexEscape(ch);
	                            if (unescaped) {
	                                cooked += unescaped;
	                            } else {
	                                index = restore;
	                                cooked += ch;
	                            }
	                        }
	                        break;
	                    case 'b':
	                        cooked += '\b';
	                        break;
	                    case 'f':
	                        cooked += '\f';
	                        break;
	                    case 'v':
	                        cooked += '\v';
	                        break;

	                    default:
	                        if (isOctalDigit(ch)) {
	                            code = '01234567'.indexOf(ch);

	                            // \0 is not octal escape sequence
	                            if (code !== 0) {
	                                octal = true;
	                            }

	                            /* istanbul ignore else */
	                            if (index < length && isOctalDigit(source[index])) {
	                                octal = true;
	                                code = code * 8 + '01234567'.indexOf(source[index++]);

	                                // 3 digits are only allowed when string starts
	                                // with 0, 1, 2, 3
	                                if ('0123'.indexOf(ch) >= 0 &&
	                                        index < length &&
	                                        isOctalDigit(source[index])) {
	                                    code = code * 8 + '01234567'.indexOf(source[index++]);
	                                }
	                            }
	                            cooked += String.fromCharCode(code);
	                        } else {
	                            cooked += ch;
	                        }
	                        break;
	                    }
	                } else {
	                    ++lineNumber;
	                    if (ch ===  '\r' && source[index] === '\n') {
	                        ++index;
	                    }
	                    lineStart = index;
	                }
	            } else if (isLineTerminator(ch.charCodeAt(0))) {
	                ++lineNumber;
	                if (ch ===  '\r' && source[index] === '\n') {
	                    ++index;
	                }
	                lineStart = index;
	                cooked += '\n';
	            } else {
	                cooked += ch;
	            }
	        }

	        if (!terminated) {
	            throwError({}, Messages.UnexpectedToken, 'ILLEGAL');
	        }

	        return {
	            type: Token.Template,
	            value: {
	                cooked: cooked,
	                raw: source.slice(start + 1, index - ((tail) ? 1 : 2))
	            },
	            tail: tail,
	            octal: octal,
	            lineNumber: lineNumber,
	            lineStart: lineStart,
	            range: [start, index]
	        };
	    }

	    function scanTemplateElement(option) {
	        var startsWith, template;

	        lookahead = null;
	        skipComment();

	        startsWith = (option.head) ? '`' : '}';

	        if (source[index] !== startsWith) {
	            throwError({}, Messages.UnexpectedToken, 'ILLEGAL');
	        }

	        template = scanTemplate();

	        peek();

	        return template;
	    }

	    function scanRegExp() {
	        var str, ch, start, pattern, flags, value, classMarker = false, restore, terminated = false, tmp;

	        lookahead = null;
	        skipComment();

	        start = index;
	        ch = source[index];
	        assert(ch === '/', 'Regular expression literal must start with a slash');
	        str = source[index++];

	        while (index < length) {
	            ch = source[index++];
	            str += ch;
	            if (classMarker) {
	                if (ch === ']') {
	                    classMarker = false;
	                }
	            } else {
	                if (ch === '\\') {
	                    ch = source[index++];
	                    // ECMA-262 7.8.5
	                    if (isLineTerminator(ch.charCodeAt(0))) {
	                        throwError({}, Messages.UnterminatedRegExp);
	                    }
	                    str += ch;
	                } else if (ch === '/') {
	                    terminated = true;
	                    break;
	                } else if (ch === '[') {
	                    classMarker = true;
	                } else if (isLineTerminator(ch.charCodeAt(0))) {
	                    throwError({}, Messages.UnterminatedRegExp);
	                }
	            }
	        }

	        if (!terminated) {
	            throwError({}, Messages.UnterminatedRegExp);
	        }

	        // Exclude leading and trailing slash.
	        pattern = str.substr(1, str.length - 2);

	        flags = '';
	        while (index < length) {
	            ch = source[index];
	            if (!isIdentifierPart(ch.charCodeAt(0))) {
	                break;
	            }

	            ++index;
	            if (ch === '\\' && index < length) {
	                ch = source[index];
	                if (ch === 'u') {
	                    ++index;
	                    restore = index;
	                    ch = scanHexEscape('u');
	                    /* istanbul ignore else */
	                    if (ch) {
	                        flags += ch;
	                        for (str += '\\u'; restore < index; ++restore) {
	                            str += source[restore];
	                        }
	                    } else {
	                        index = restore;
	                        flags += 'u';
	                        str += '\\u';
	                    }
	                    throwErrorTolerant({}, Messages.UnexpectedToken, 'ILLEGAL');
	                } else {
	                    str += '\\';
	                }
	            } else {
	                flags += ch;
	                str += ch;
	            }
	        }

	        tmp = pattern;
	        if (flags.indexOf('u') >= 0) {
	            // Replace each astral symbol and every Unicode code point
	            // escape sequence with a single ASCII symbol to avoid throwing on
	            // regular expressions that are only valid in combination with the
	            // `/u` flag.
	            // Note: replacing with the ASCII symbol `x` might cause false
	            // negatives in unlikely scenarios. For example, `[\u{61}-b]` is a
	            // perfectly valid pattern that is equivalent to `[a-b]`, but it
	            // would be replaced by `[x-b]` which throws an error.
	            tmp = tmp
	                .replace(/\\u\{([0-9a-fA-F]+)\}/g, function ($0, $1) {
	                    if (parseInt($1, 16) <= 0x10FFFF) {
	                        return 'x';
	                    }
	                    throwError({}, Messages.InvalidRegExp);
	                })
	                .replace(/[\uD800-\uDBFF][\uDC00-\uDFFF]/g, 'x');
	        }

	        // First, detect invalid regular expressions.
	        try {
	            value = new RegExp(tmp);
	        } catch (e) {
	            throwError({}, Messages.InvalidRegExp);
	        }

	        // Return a regular expression object for this pattern-flag pair, or
	        // `null` in case the current environment doesn't support the flags it
	        // uses.
	        try {
	            value = new RegExp(pattern, flags);
	        } catch (exception) {
	            value = null;
	        }

	        if (extra.tokenize) {
	            return {
	                type: Token.RegularExpression,
	                value: value,
	                regex: {
	                    pattern: pattern,
	                    flags: flags
	                },
	                lineNumber: lineNumber,
	                lineStart: lineStart,
	                range: [start, index]
	            };
	        }
	        return {
	            literal: str,
	            value: value,
	            regex: {
	                pattern: pattern,
	                flags: flags
	            },
	            range: [start, index]
	        };
	    }

	    function isIdentifierName(token) {
	        return token.type === Token.Identifier ||
	            token.type === Token.Keyword ||
	            token.type === Token.BooleanLiteral ||
	            token.type === Token.NullLiteral;
	    }

	    function advanceSlash() {
	        var prevToken,
	            checkToken;
	        // Using the following algorithm:
	        // https://github.com/mozilla/sweet.js/wiki/design
	        prevToken = extra.tokens[extra.tokens.length - 1];
	        if (!prevToken) {
	            // Nothing before that: it cannot be a division.
	            return scanRegExp();
	        }
	        if (prevToken.type === 'Punctuator') {
	            if (prevToken.value === ')') {
	                checkToken = extra.tokens[extra.openParenToken - 1];
	                if (checkToken &&
	                        checkToken.type === 'Keyword' &&
	                        (checkToken.value === 'if' ||
	                         checkToken.value === 'while' ||
	                         checkToken.value === 'for' ||
	                         checkToken.value === 'with')) {
	                    return scanRegExp();
	                }
	                return scanPunctuator();
	            }
	            if (prevToken.value === '}') {
	                // Dividing a function by anything makes little sense,
	                // but we have to check for that.
	                if (extra.tokens[extra.openCurlyToken - 3] &&
	                        extra.tokens[extra.openCurlyToken - 3].type === 'Keyword') {
	                    // Anonymous function.
	                    checkToken = extra.tokens[extra.openCurlyToken - 4];
	                    if (!checkToken) {
	                        return scanPunctuator();
	                    }
	                } else if (extra.tokens[extra.openCurlyToken - 4] &&
	                        extra.tokens[extra.openCurlyToken - 4].type === 'Keyword') {
	                    // Named function.
	                    checkToken = extra.tokens[extra.openCurlyToken - 5];
	                    if (!checkToken) {
	                        return scanRegExp();
	                    }
	                } else {
	                    return scanPunctuator();
	                }
	                // checkToken determines whether the function is
	                // a declaration or an expression.
	                if (FnExprTokens.indexOf(checkToken.value) >= 0) {
	                    // It is an expression.
	                    return scanPunctuator();
	                }
	                // It is a declaration.
	                return scanRegExp();
	            }
	            return scanRegExp();
	        }
	        if (prevToken.type === 'Keyword') {
	            return scanRegExp();
	        }
	        return scanPunctuator();
	    }

	    function advance() {
	        var ch;

	        if (!state.inXJSChild) {
	            skipComment();
	        }

	        if (index >= length) {
	            return {
	                type: Token.EOF,
	                lineNumber: lineNumber,
	                lineStart: lineStart,
	                range: [index, index]
	            };
	        }

	        if (state.inXJSChild) {
	            return advanceXJSChild();
	        }

	        ch = source.charCodeAt(index);

	        // Very common: ( and ) and ;
	        if (ch === 40 || ch === 41 || ch === 58) {
	            return scanPunctuator();
	        }

	        // String literal starts with single quote (#39) or double quote (#34).
	        if (ch === 39 || ch === 34) {
	            if (state.inXJSTag) {
	                return scanXJSStringLiteral();
	            }
	            return scanStringLiteral();
	        }

	        if (state.inXJSTag && isXJSIdentifierStart(ch)) {
	            return scanXJSIdentifier();
	        }

	        if (ch === 96) {
	            return scanTemplate();
	        }
	        if (isIdentifierStart(ch)) {
	            return scanIdentifier();
	        }

	        // Dot (.) char #46 can also start a floating-point number, hence the need
	        // to check the next character.
	        if (ch === 46) {
	            if (isDecimalDigit(source.charCodeAt(index + 1))) {
	                return scanNumericLiteral();
	            }
	            return scanPunctuator();
	        }

	        if (isDecimalDigit(ch)) {
	            return scanNumericLiteral();
	        }

	        // Slash (/) char #47 can also start a regex.
	        if (extra.tokenize && ch === 47) {
	            return advanceSlash();
	        }

	        return scanPunctuator();
	    }

	    function lex() {
	        var token;

	        token = lookahead;
	        index = token.range[1];
	        lineNumber = token.lineNumber;
	        lineStart = token.lineStart;

	        lookahead = advance();

	        index = token.range[1];
	        lineNumber = token.lineNumber;
	        lineStart = token.lineStart;

	        return token;
	    }

	    function peek() {
	        var pos, line, start;

	        pos = index;
	        line = lineNumber;
	        start = lineStart;
	        lookahead = advance();
	        index = pos;
	        lineNumber = line;
	        lineStart = start;
	    }

	    function lookahead2() {
	        var adv, pos, line, start, result;

	        // If we are collecting the tokens, don't grab the next one yet.
	        /* istanbul ignore next */
	        adv = (typeof extra.advance === 'function') ? extra.advance : advance;

	        pos = index;
	        line = lineNumber;
	        start = lineStart;

	        // Scan for the next immediate token.
	        /* istanbul ignore if */
	        if (lookahead === null) {
	            lookahead = adv();
	        }
	        index = lookahead.range[1];
	        lineNumber = lookahead.lineNumber;
	        lineStart = lookahead.lineStart;

	        // Grab the token right after.
	        result = adv();
	        index = pos;
	        lineNumber = line;
	        lineStart = start;

	        return result;
	    }

	    function rewind(token) {
	        index = token.range[0];
	        lineNumber = token.lineNumber;
	        lineStart = token.lineStart;
	        lookahead = token;
	    }

	    function markerCreate() {
	        if (!extra.loc && !extra.range) {
	            return undefined;
	        }
	        skipComment();
	        return {offset: index, line: lineNumber, col: index - lineStart};
	    }

	    function markerCreatePreserveWhitespace() {
	        if (!extra.loc && !extra.range) {
	            return undefined;
	        }
	        return {offset: index, line: lineNumber, col: index - lineStart};
	    }

	    function processComment(node) {
	        var lastChild,
	            trailingComments,
	            bottomRight = extra.bottomRightStack,
	            last = bottomRight[bottomRight.length - 1];

	        if (node.type === Syntax.Program) {
	            /* istanbul ignore else */
	            if (node.body.length > 0) {
	                return;
	            }
	        }

	        if (extra.trailingComments.length > 0) {
	            if (extra.trailingComments[0].range[0] >= node.range[1]) {
	                trailingComments = extra.trailingComments;
	                extra.trailingComments = [];
	            } else {
	                extra.trailingComments.length = 0;
	            }
	        } else {
	            if (last && last.trailingComments && last.trailingComments[0].range[0] >= node.range[1]) {
	                trailingComments = last.trailingComments;
	                delete last.trailingComments;
	            }
	        }

	        // Eating the stack.
	        if (last) {
	            while (last && last.range[0] >= node.range[0]) {
	                lastChild = last;
	                last = bottomRight.pop();
	            }
	        }

	        if (lastChild) {
	            if (lastChild.leadingComments && lastChild.leadingComments[lastChild.leadingComments.length - 1].range[1] <= node.range[0]) {
	                node.leadingComments = lastChild.leadingComments;
	                delete lastChild.leadingComments;
	            }
	        } else if (extra.leadingComments.length > 0 && extra.leadingComments[extra.leadingComments.length - 1].range[1] <= node.range[0]) {
	            node.leadingComments = extra.leadingComments;
	            extra.leadingComments = [];
	        }

	        if (trailingComments) {
	            node.trailingComments = trailingComments;
	        }

	        bottomRight.push(node);
	    }

	    function markerApply(marker, node) {
	        if (extra.range) {
	            node.range = [marker.offset, index];
	        }
	        if (extra.loc) {
	            node.loc = {
	                start: {
	                    line: marker.line,
	                    column: marker.col
	                },
	                end: {
	                    line: lineNumber,
	                    column: index - lineStart
	                }
	            };
	            node = delegate.postProcess(node);
	        }
	        if (extra.attachComment) {
	            processComment(node);
	        }
	        return node;
	    }

	    SyntaxTreeDelegate = {

	        name: 'SyntaxTree',

	        postProcess: function (node) {
	            return node;
	        },

	        createArrayExpression: function (elements) {
	            return {
	                type: Syntax.ArrayExpression,
	                elements: elements
	            };
	        },

	        createAssignmentExpression: function (operator, left, right) {
	            return {
	                type: Syntax.AssignmentExpression,
	                operator: operator,
	                left: left,
	                right: right
	            };
	        },

	        createBinaryExpression: function (operator, left, right) {
	            var type = (operator === '||' || operator === '&&') ? Syntax.LogicalExpression :
	                        Syntax.BinaryExpression;
	            return {
	                type: type,
	                operator: operator,
	                left: left,
	                right: right
	            };
	        },

	        createBlockStatement: function (body) {
	            return {
	                type: Syntax.BlockStatement,
	                body: body
	            };
	        },

	        createBreakStatement: function (label) {
	            return {
	                type: Syntax.BreakStatement,
	                label: label
	            };
	        },

	        createCallExpression: function (callee, args) {
	            return {
	                type: Syntax.CallExpression,
	                callee: callee,
	                'arguments': args
	            };
	        },

	        createCatchClause: function (param, body) {
	            return {
	                type: Syntax.CatchClause,
	                param: param,
	                body: body
	            };
	        },

	        createConditionalExpression: function (test, consequent, alternate) {
	            return {
	                type: Syntax.ConditionalExpression,
	                test: test,
	                consequent: consequent,
	                alternate: alternate
	            };
	        },

	        createContinueStatement: function (label) {
	            return {
	                type: Syntax.ContinueStatement,
	                label: label
	            };
	        },

	        createDebuggerStatement: function () {
	            return {
	                type: Syntax.DebuggerStatement
	            };
	        },

	        createDoWhileStatement: function (body, test) {
	            return {
	                type: Syntax.DoWhileStatement,
	                body: body,
	                test: test
	            };
	        },

	        createEmptyStatement: function () {
	            return {
	                type: Syntax.EmptyStatement
	            };
	        },

	        createExpressionStatement: function (expression) {
	            return {
	                type: Syntax.ExpressionStatement,
	                expression: expression
	            };
	        },

	        createForStatement: function (init, test, update, body) {
	            return {
	                type: Syntax.ForStatement,
	                init: init,
	                test: test,
	                update: update,
	                body: body
	            };
	        },

	        createForInStatement: function (left, right, body) {
	            return {
	                type: Syntax.ForInStatement,
	                left: left,
	                right: right,
	                body: body,
	                each: false
	            };
	        },

	        createForOfStatement: function (left, right, body) {
	            return {
	                type: Syntax.ForOfStatement,
	                left: left,
	                right: right,
	                body: body
	            };
	        },

	        createFunctionDeclaration: function (id, params, defaults, body, rest, generator, expression,
	                                             isAsync, returnType, typeParameters) {
	            var funDecl = {
	                type: Syntax.FunctionDeclaration,
	                id: id,
	                params: params,
	                defaults: defaults,
	                body: body,
	                rest: rest,
	                generator: generator,
	                expression: expression,
	                returnType: returnType,
	                typeParameters: typeParameters
	            };

	            if (isAsync) {
	                funDecl.async = true;
	            }

	            return funDecl;
	        },

	        createFunctionExpression: function (id, params, defaults, body, rest, generator, expression,
	                                            isAsync, returnType, typeParameters) {
	            var funExpr = {
	                type: Syntax.FunctionExpression,
	                id: id,
	                params: params,
	                defaults: defaults,
	                body: body,
	                rest: rest,
	                generator: generator,
	                expression: expression,
	                returnType: returnType,
	                typeParameters: typeParameters
	            };

	            if (isAsync) {
	                funExpr.async = true;
	            }

	            return funExpr;
	        },

	        createIdentifier: function (name) {
	            return {
	                type: Syntax.Identifier,
	                name: name,
	                // Only here to initialize the shape of the object to ensure
	                // that the 'typeAnnotation' key is ordered before others that
	                // are added later (like 'loc' and 'range'). This just helps
	                // keep the shape of Identifier nodes consistent with everything
	                // else.
	                typeAnnotation: undefined,
	                optional: undefined
	            };
	        },

	        createTypeAnnotation: function (typeAnnotation) {
	            return {
	                type: Syntax.TypeAnnotation,
	                typeAnnotation: typeAnnotation
	            };
	        },

	        createFunctionTypeAnnotation: function (params, returnType, rest, typeParameters) {
	            return {
	                type: Syntax.FunctionTypeAnnotation,
	                params: params,
	                returnType: returnType,
	                rest: rest,
	                typeParameters: typeParameters
	            };
	        },

	        createFunctionTypeParam: function (name, typeAnnotation, optional) {
	            return {
	                type: Syntax.FunctionTypeParam,
	                name: name,
	                typeAnnotation: typeAnnotation,
	                optional: optional
	            };
	        },

	        createNullableTypeAnnotation: function (typeAnnotation) {
	            return {
	                type: Syntax.NullableTypeAnnotation,
	                typeAnnotation: typeAnnotation
	            };
	        },

	        createArrayTypeAnnotation: function (elementType) {
	            return {
	                type: Syntax.ArrayTypeAnnotation,
	                elementType: elementType
	            };
	        },

	        createGenericTypeAnnotation: function (id, typeParameters) {
	            return {
	                type: Syntax.GenericTypeAnnotation,
	                id: id,
	                typeParameters: typeParameters
	            };
	        },

	        createQualifiedTypeIdentifier: function (qualification, id) {
	            return {
	                type: Syntax.QualifiedTypeIdentifier,
	                qualification: qualification,
	                id: id
	            };
	        },

	        createTypeParameterDeclaration: function (params) {
	            return {
	                type: Syntax.TypeParameterDeclaration,
	                params: params
	            };
	        },

	        createTypeParameterInstantiation: function (params) {
	            return {
	                type: Syntax.TypeParameterInstantiation,
	                params: params
	            };
	        },

	        createAnyTypeAnnotation: function () {
	            return {
	                type: Syntax.AnyTypeAnnotation
	            };
	        },

	        createBooleanTypeAnnotation: function () {
	            return {
	                type: Syntax.BooleanTypeAnnotation
	            };
	        },

	        createNumberTypeAnnotation: function () {
	            return {
	                type: Syntax.NumberTypeAnnotation
	            };
	        },

	        createStringTypeAnnotation: function () {
	            return {
	                type: Syntax.StringTypeAnnotation
	            };
	        },

	        createStringLiteralTypeAnnotation: function (token) {
	            return {
	                type: Syntax.StringLiteralTypeAnnotation,
	                value: token.value,
	                raw: source.slice(token.range[0], token.range[1])
	            };
	        },

	        createVoidTypeAnnotation: function () {
	            return {
	                type: Syntax.VoidTypeAnnotation
	            };
	        },

	        createTypeofTypeAnnotation: function (argument) {
	            return {
	                type: Syntax.TypeofTypeAnnotation,
	                argument: argument
	            };
	        },

	        createTupleTypeAnnotation: function (types) {
	            return {
	                type: Syntax.TupleTypeAnnotation,
	                types: types
	            };
	        },

	        createObjectTypeAnnotation: function (properties, indexers, callProperties) {
	            return {
	                type: Syntax.ObjectTypeAnnotation,
	                properties: properties,
	                indexers: indexers,
	                callProperties: callProperties
	            };
	        },

	        createObjectTypeIndexer: function (id, key, value, isStatic) {
	            return {
	                type: Syntax.ObjectTypeIndexer,
	                id: id,
	                key: key,
	                value: value,
	                static: isStatic
	            };
	        },

	        createObjectTypeCallProperty: function (value, isStatic) {
	            return {
	                type: Syntax.ObjectTypeCallProperty,
	                value: value,
	                static: isStatic
	            };
	        },

	        createObjectTypeProperty: function (key, value, optional, isStatic) {
	            return {
	                type: Syntax.ObjectTypeProperty,
	                key: key,
	                value: value,
	                optional: optional,
	                static: isStatic
	            };
	        },

	        createUnionTypeAnnotation: function (types) {
	            return {
	                type: Syntax.UnionTypeAnnotation,
	                types: types
	            };
	        },

	        createIntersectionTypeAnnotation: function (types) {
	            return {
	                type: Syntax.IntersectionTypeAnnotation,
	                types: types
	            };
	        },

	        createTypeAlias: function (id, typeParameters, right) {
	            return {
	                type: Syntax.TypeAlias,
	                id: id,
	                typeParameters: typeParameters,
	                right: right
	            };
	        },

	        createInterface: function (id, typeParameters, body, extended) {
	            return {
	                type: Syntax.InterfaceDeclaration,
	                id: id,
	                typeParameters: typeParameters,
	                body: body,
	                extends: extended
	            };
	        },

	        createInterfaceExtends: function (id, typeParameters) {
	            return {
	                type: Syntax.InterfaceExtends,
	                id: id,
	                typeParameters: typeParameters
	            };
	        },

	        createDeclareFunction: function (id) {
	            return {
	                type: Syntax.DeclareFunction,
	                id: id
	            };
	        },

	        createDeclareVariable: function (id) {
	            return {
	                type: Syntax.DeclareVariable,
	                id: id
	            };
	        },

	        createDeclareModule: function (id, body) {
	            return {
	                type: Syntax.DeclareModule,
	                id: id,
	                body: body
	            };
	        },

	        createXJSAttribute: function (name, value) {
	            return {
	                type: Syntax.XJSAttribute,
	                name: name,
	                value: value || null
	            };
	        },

	        createXJSSpreadAttribute: function (argument) {
	            return {
	                type: Syntax.XJSSpreadAttribute,
	                argument: argument
	            };
	        },

	        createXJSIdentifier: function (name) {
	            return {
	                type: Syntax.XJSIdentifier,
	                name: name
	            };
	        },

	        createXJSNamespacedName: function (namespace, name) {
	            return {
	                type: Syntax.XJSNamespacedName,
	                namespace: namespace,
	                name: name
	            };
	        },

	        createXJSMemberExpression: function (object, property) {
	            return {
	                type: Syntax.XJSMemberExpression,
	                object: object,
	                property: property
	            };
	        },

	        createXJSElement: function (openingElement, closingElement, children) {
	            return {
	                type: Syntax.XJSElement,
	                openingElement: openingElement,
	                closingElement: closingElement,
	                children: children
	            };
	        },

	        createXJSEmptyExpression: function () {
	            return {
	                type: Syntax.XJSEmptyExpression
	            };
	        },

	        createXJSExpressionContainer: function (expression) {
	            return {
	                type: Syntax.XJSExpressionContainer,
	                expression: expression
	            };
	        },

	        createXJSOpeningElement: function (name, attributes, selfClosing) {
	            return {
	                type: Syntax.XJSOpeningElement,
	                name: name,
	                selfClosing: selfClosing,
	                attributes: attributes
	            };
	        },

	        createXJSClosingElement: function (name) {
	            return {
	                type: Syntax.XJSClosingElement,
	                name: name
	            };
	        },

	        createIfStatement: function (test, consequent, alternate) {
	            return {
	                type: Syntax.IfStatement,
	                test: test,
	                consequent: consequent,
	                alternate: alternate
	            };
	        },

	        createLabeledStatement: function (label, body) {
	            return {
	                type: Syntax.LabeledStatement,
	                label: label,
	                body: body
	            };
	        },

	        createLiteral: function (token) {
	            var object = {
	                type: Syntax.Literal,
	                value: token.value,
	                raw: source.slice(token.range[0], token.range[1])
	            };
	            if (token.regex) {
	                object.regex = token.regex;
	            }
	            return object;
	        },

	        createMemberExpression: function (accessor, object, property) {
	            return {
	                type: Syntax.MemberExpression,
	                computed: accessor === '[',
	                object: object,
	                property: property
	            };
	        },

	        createNewExpression: function (callee, args) {
	            return {
	                type: Syntax.NewExpression,
	                callee: callee,
	                'arguments': args
	            };
	        },

	        createObjectExpression: function (properties) {
	            return {
	                type: Syntax.ObjectExpression,
	                properties: properties
	            };
	        },

	        createPostfixExpression: function (operator, argument) {
	            return {
	                type: Syntax.UpdateExpression,
	                operator: operator,
	                argument: argument,
	                prefix: false
	            };
	        },

	        createProgram: function (body) {
	            return {
	                type: Syntax.Program,
	                body: body
	            };
	        },

	        createProperty: function (kind, key, value, method, shorthand, computed) {
	            return {
	                type: Syntax.Property,
	                key: key,
	                value: value,
	                kind: kind,
	                method: method,
	                shorthand: shorthand,
	                computed: computed
	            };
	        },

	        createReturnStatement: function (argument) {
	            return {
	                type: Syntax.ReturnStatement,
	                argument: argument
	            };
	        },

	        createSequenceExpression: function (expressions) {
	            return {
	                type: Syntax.SequenceExpression,
	                expressions: expressions
	            };
	        },

	        createSwitchCase: function (test, consequent) {
	            return {
	                type: Syntax.SwitchCase,
	                test: test,
	                consequent: consequent
	            };
	        },

	        createSwitchStatement: function (discriminant, cases) {
	            return {
	                type: Syntax.SwitchStatement,
	                discriminant: discriminant,
	                cases: cases
	            };
	        },

	        createThisExpression: function () {
	            return {
	                type: Syntax.ThisExpression
	            };
	        },

	        createThrowStatement: function (argument) {
	            return {
	                type: Syntax.ThrowStatement,
	                argument: argument
	            };
	        },

	        createTryStatement: function (block, guardedHandlers, handlers, finalizer) {
	            return {
	                type: Syntax.TryStatement,
	                block: block,
	                guardedHandlers: guardedHandlers,
	                handlers: handlers,
	                finalizer: finalizer
	            };
	        },

	        createUnaryExpression: function (operator, argument) {
	            if (operator === '++' || operator === '--') {
	                return {
	                    type: Syntax.UpdateExpression,
	                    operator: operator,
	                    argument: argument,
	                    prefix: true
	                };
	            }
	            return {
	                type: Syntax.UnaryExpression,
	                operator: operator,
	                argument: argument,
	                prefix: true
	            };
	        },

	        createVariableDeclaration: function (declarations, kind) {
	            return {
	                type: Syntax.VariableDeclaration,
	                declarations: declarations,
	                kind: kind
	            };
	        },

	        createVariableDeclarator: function (id, init) {
	            return {
	                type: Syntax.VariableDeclarator,
	                id: id,
	                init: init
	            };
	        },

	        createWhileStatement: function (test, body) {
	            return {
	                type: Syntax.WhileStatement,
	                test: test,
	                body: body
	            };
	        },

	        createWithStatement: function (object, body) {
	            return {
	                type: Syntax.WithStatement,
	                object: object,
	                body: body
	            };
	        },

	        createTemplateElement: function (value, tail) {
	            return {
	                type: Syntax.TemplateElement,
	                value: value,
	                tail: tail
	            };
	        },

	        createTemplateLiteral: function (quasis, expressions) {
	            return {
	                type: Syntax.TemplateLiteral,
	                quasis: quasis,
	                expressions: expressions
	            };
	        },

	        createSpreadElement: function (argument) {
	            return {
	                type: Syntax.SpreadElement,
	                argument: argument
	            };
	        },

	        createSpreadProperty: function (argument) {
	            return {
	                type: Syntax.SpreadProperty,
	                argument: argument
	            };
	        },

	        createTaggedTemplateExpression: function (tag, quasi) {
	            return {
	                type: Syntax.TaggedTemplateExpression,
	                tag: tag,
	                quasi: quasi
	            };
	        },

	        createArrowFunctionExpression: function (params, defaults, body, rest, expression, isAsync) {
	            var arrowExpr = {
	                type: Syntax.ArrowFunctionExpression,
	                id: null,
	                params: params,
	                defaults: defaults,
	                body: body,
	                rest: rest,
	                generator: false,
	                expression: expression
	            };

	            if (isAsync) {
	                arrowExpr.async = true;
	            }

	            return arrowExpr;
	        },

	        createMethodDefinition: function (propertyType, kind, key, value, computed) {
	            return {
	                type: Syntax.MethodDefinition,
	                key: key,
	                value: value,
	                kind: kind,
	                'static': propertyType === ClassPropertyType.static,
	                computed: computed
	            };
	        },

	        createClassProperty: function (key, typeAnnotation, computed, isStatic) {
	            return {
	                type: Syntax.ClassProperty,
	                key: key,
	                typeAnnotation: typeAnnotation,
	                computed: computed,
	                static: isStatic
	            };
	        },

	        createClassBody: function (body) {
	            return {
	                type: Syntax.ClassBody,
	                body: body
	            };
	        },

	        createClassImplements: function (id, typeParameters) {
	            return {
	                type: Syntax.ClassImplements,
	                id: id,
	                typeParameters: typeParameters
	            };
	        },

	        createClassExpression: function (id, superClass, body, typeParameters, superTypeParameters, implemented) {
	            return {
	                type: Syntax.ClassExpression,
	                id: id,
	                superClass: superClass,
	                body: body,
	                typeParameters: typeParameters,
	                superTypeParameters: superTypeParameters,
	                implements: implemented
	            };
	        },

	        createClassDeclaration: function (id, superClass, body, typeParameters, superTypeParameters, implemented) {
	            return {
	                type: Syntax.ClassDeclaration,
	                id: id,
	                superClass: superClass,
	                body: body,
	                typeParameters: typeParameters,
	                superTypeParameters: superTypeParameters,
	                implements: implemented
	            };
	        },

	        createModuleSpecifier: function (token) {
	            return {
	                type: Syntax.ModuleSpecifier,
	                value: token.value,
	                raw: source.slice(token.range[0], token.range[1])
	            };
	        },

	        createExportSpecifier: function (id, name) {
	            return {
	                type: Syntax.ExportSpecifier,
	                id: id,
	                name: name
	            };
	        },

	        createExportBatchSpecifier: function () {
	            return {
	                type: Syntax.ExportBatchSpecifier
	            };
	        },

	        createImportDefaultSpecifier: function (id) {
	            return {
	                type: Syntax.ImportDefaultSpecifier,
	                id: id
	            };
	        },

	        createImportNamespaceSpecifier: function (id) {
	            return {
	                type: Syntax.ImportNamespaceSpecifier,
	                id: id
	            };
	        },

	        createExportDeclaration: function (isDefault, declaration, specifiers, source) {
	            return {
	                type: Syntax.ExportDeclaration,
	                'default': !!isDefault,
	                declaration: declaration,
	                specifiers: specifiers,
	                source: source
	            };
	        },

	        createImportSpecifier: function (id, name) {
	            return {
	                type: Syntax.ImportSpecifier,
	                id: id,
	                name: name
	            };
	        },

	        createImportDeclaration: function (specifiers, source) {
	            return {
	                type: Syntax.ImportDeclaration,
	                specifiers: specifiers,
	                source: source
	            };
	        },

	        createYieldExpression: function (argument, delegate) {
	            return {
	                type: Syntax.YieldExpression,
	                argument: argument,
	                delegate: delegate
	            };
	        },

	        createAwaitExpression: function (argument) {
	            return {
	                type: Syntax.AwaitExpression,
	                argument: argument
	            };
	        },

	        createComprehensionExpression: function (filter, blocks, body) {
	            return {
	                type: Syntax.ComprehensionExpression,
	                filter: filter,
	                blocks: blocks,
	                body: body
	            };
	        }

	    };

	    // Return true if there is a line terminator before the next token.

	    function peekLineTerminator() {
	        var pos, line, start, found;

	        pos = index;
	        line = lineNumber;
	        start = lineStart;
	        skipComment();
	        found = lineNumber !== line;
	        index = pos;
	        lineNumber = line;
	        lineStart = start;

	        return found;
	    }

	    // Throw an exception

	    function throwError(token, messageFormat) {
	        var error,
	            args = Array.prototype.slice.call(arguments, 2),
	            msg = messageFormat.replace(
	                /%(\d)/g,
	                function (whole, index) {
	                    assert(index < args.length, 'Message reference must be in range');
	                    return args[index];
	                }
	            );

	        if (typeof token.lineNumber === 'number') {
	            error = new Error('Line ' + token.lineNumber + ': ' + msg);
	            error.index = token.range[0];
	            error.lineNumber = token.lineNumber;
	            error.column = token.range[0] - lineStart + 1;
	        } else {
	            error = new Error('Line ' + lineNumber + ': ' + msg);
	            error.index = index;
	            error.lineNumber = lineNumber;
	            error.column = index - lineStart + 1;
	        }

	        error.description = msg;
	        throw error;
	    }

	    function throwErrorTolerant() {
	        try {
	            throwError.apply(null, arguments);
	        } catch (e) {
	            if (extra.errors) {
	                extra.errors.push(e);
	            } else {
	                throw e;
	            }
	        }
	    }


	    // Throw an exception because of the token.

	    function throwUnexpected(token) {
	        if (token.type === Token.EOF) {
	            throwError(token, Messages.UnexpectedEOS);
	        }

	        if (token.type === Token.NumericLiteral) {
	            throwError(token, Messages.UnexpectedNumber);
	        }

	        if (token.type === Token.StringLiteral || token.type === Token.XJSText) {
	            throwError(token, Messages.UnexpectedString);
	        }

	        if (token.type === Token.Identifier) {
	            throwError(token, Messages.UnexpectedIdentifier);
	        }

	        if (token.type === Token.Keyword) {
	            if (isFutureReservedWord(token.value)) {
	                throwError(token, Messages.UnexpectedReserved);
	            } else if (strict && isStrictModeReservedWord(token.value)) {
	                throwErrorTolerant(token, Messages.StrictReservedWord);
	                return;
	            }
	            throwError(token, Messages.UnexpectedToken, token.value);
	        }

	        if (token.type === Token.Template) {
	            throwError(token, Messages.UnexpectedTemplate, token.value.raw);
	        }

	        // BooleanLiteral, NullLiteral, or Punctuator.
	        throwError(token, Messages.UnexpectedToken, token.value);
	    }

	    // Expect the next token to match the specified punctuator.
	    // If not, an exception will be thrown.

	    function expect(value) {
	        var token = lex();
	        if (token.type !== Token.Punctuator || token.value !== value) {
	            throwUnexpected(token);
	        }
	    }

	    // Expect the next token to match the specified keyword.
	    // If not, an exception will be thrown.

	    function expectKeyword(keyword, contextual) {
	        var token = lex();
	        if (token.type !== (contextual ? Token.Identifier : Token.Keyword) ||
	                token.value !== keyword) {
	            throwUnexpected(token);
	        }
	    }

	    // Expect the next token to match the specified contextual keyword.
	    // If not, an exception will be thrown.

	    function expectContextualKeyword(keyword) {
	        return expectKeyword(keyword, true);
	    }

	    // Return true if the next token matches the specified punctuator.

	    function match(value) {
	        return lookahead.type === Token.Punctuator && lookahead.value === value;
	    }

	    // Return true if the next token matches the specified keyword

	    function matchKeyword(keyword, contextual) {
	        var expectedType = contextual ? Token.Identifier : Token.Keyword;
	        return lookahead.type === expectedType && lookahead.value === keyword;
	    }

	    // Return true if the next token matches the specified contextual keyword

	    function matchContextualKeyword(keyword) {
	        return matchKeyword(keyword, true);
	    }

	    // Return true if the next token is an assignment operator

	    function matchAssign() {
	        var op;

	        if (lookahead.type !== Token.Punctuator) {
	            return false;
	        }
	        op = lookahead.value;
	        return op === '=' ||
	            op === '*=' ||
	            op === '/=' ||
	            op === '%=' ||
	            op === '+=' ||
	            op === '-=' ||
	            op === '<<=' ||
	            op === '>>=' ||
	            op === '>>>=' ||
	            op === '&=' ||
	            op === '^=' ||
	            op === '|=';
	    }

	    // Note that 'yield' is treated as a keyword in strict mode, but a
	    // contextual keyword (identifier) in non-strict mode, so we need to
	    // use matchKeyword('yield', false) and matchKeyword('yield', true)
	    // (i.e. matchContextualKeyword) appropriately.
	    function matchYield() {
	        return state.yieldAllowed && matchKeyword('yield', !strict);
	    }

	    function matchAsync() {
	        var backtrackToken = lookahead, matches = false;

	        if (matchContextualKeyword('async')) {
	            lex(); // Make sure peekLineTerminator() starts after 'async'.
	            matches = !peekLineTerminator();
	            rewind(backtrackToken); // Revert the lex().
	        }

	        return matches;
	    }

	    function matchAwait() {
	        return state.awaitAllowed && matchContextualKeyword('await');
	    }

	    function consumeSemicolon() {
	        var line, oldIndex = index, oldLineNumber = lineNumber,
	            oldLineStart = lineStart, oldLookahead = lookahead;

	        // Catch the very common case first: immediately a semicolon (char #59).
	        if (source.charCodeAt(index) === 59) {
	            lex();
	            return;
	        }

	        line = lineNumber;
	        skipComment();
	        if (lineNumber !== line) {
	            index = oldIndex;
	            lineNumber = oldLineNumber;
	            lineStart = oldLineStart;
	            lookahead = oldLookahead;
	            return;
	        }

	        if (match(';')) {
	            lex();
	            return;
	        }

	        if (lookahead.type !== Token.EOF && !match('}')) {
	            throwUnexpected(lookahead);
	        }
	    }

	    // Return true if provided expression is LeftHandSideExpression

	    function isLeftHandSide(expr) {
	        return expr.type === Syntax.Identifier || expr.type === Syntax.MemberExpression;
	    }

	    function isAssignableLeftHandSide(expr) {
	        return isLeftHandSide(expr) || expr.type === Syntax.ObjectPattern || expr.type === Syntax.ArrayPattern;
	    }

	    // 11.1.4 Array Initialiser

	    function parseArrayInitialiser() {
	        var elements = [], blocks = [], filter = null, tmp, possiblecomprehension = true, body,
	            marker = markerCreate();

	        expect('[');
	        while (!match(']')) {
	            if (lookahead.value === 'for' &&
	                    lookahead.type === Token.Keyword) {
	                if (!possiblecomprehension) {
	                    throwError({}, Messages.ComprehensionError);
	                }
	                matchKeyword('for');
	                tmp = parseForStatement({ignoreBody: true});
	                tmp.of = tmp.type === Syntax.ForOfStatement;
	                tmp.type = Syntax.ComprehensionBlock;
	                if (tmp.left.kind) { // can't be let or const
	                    throwError({}, Messages.ComprehensionError);
	                }
	                blocks.push(tmp);
	            } else if (lookahead.value === 'if' &&
	                           lookahead.type === Token.Keyword) {
	                if (!possiblecomprehension) {
	                    throwError({}, Messages.ComprehensionError);
	                }
	                expectKeyword('if');
	                expect('(');
	                filter = parseExpression();
	                expect(')');
	            } else if (lookahead.value === ',' &&
	                           lookahead.type === Token.Punctuator) {
	                possiblecomprehension = false; // no longer allowed.
	                lex();
	                elements.push(null);
	            } else {
	                tmp = parseSpreadOrAssignmentExpression();
	                elements.push(tmp);
	                if (tmp && tmp.type === Syntax.SpreadElement) {
	                    if (!match(']')) {
	                        throwError({}, Messages.ElementAfterSpreadElement);
	                    }
	                } else if (!(match(']') || matchKeyword('for') || matchKeyword('if'))) {
	                    expect(','); // this lexes.
	                    possiblecomprehension = false;
	                }
	            }
	        }

	        expect(']');

	        if (filter && !blocks.length) {
	            throwError({}, Messages.ComprehensionRequiresBlock);
	        }

	        if (blocks.length) {
	            if (elements.length !== 1) {
	                throwError({}, Messages.ComprehensionError);
	            }
	            return markerApply(marker, delegate.createComprehensionExpression(filter, blocks, elements[0]));
	        }
	        return markerApply(marker, delegate.createArrayExpression(elements));
	    }

	    // 11.1.5 Object Initialiser

	    function parsePropertyFunction(options) {
	        var previousStrict, previousYieldAllowed, previousAwaitAllowed,
	            params, defaults, body, marker = markerCreate();

	        previousStrict = strict;
	        previousYieldAllowed = state.yieldAllowed;
	        state.yieldAllowed = options.generator;
	        previousAwaitAllowed = state.awaitAllowed;
	        state.awaitAllowed = options.async;
	        params = options.params || [];
	        defaults = options.defaults || [];

	        body = parseConciseBody();
	        if (options.name && strict && isRestrictedWord(params[0].name)) {
	            throwErrorTolerant(options.name, Messages.StrictParamName);
	        }
	        strict = previousStrict;
	        state.yieldAllowed = previousYieldAllowed;
	        state.awaitAllowed = previousAwaitAllowed;

	        return markerApply(marker, delegate.createFunctionExpression(
	            null,
	            params,
	            defaults,
	            body,
	            options.rest || null,
	            options.generator,
	            body.type !== Syntax.BlockStatement,
	            options.async,
	            options.returnType,
	            options.typeParameters
	        ));
	    }


	    function parsePropertyMethodFunction(options) {
	        var previousStrict, tmp, method;

	        previousStrict = strict;
	        strict = true;

	        tmp = parseParams();

	        if (tmp.stricted) {
	            throwErrorTolerant(tmp.stricted, tmp.message);
	        }

	        method = parsePropertyFunction({
	            params: tmp.params,
	            defaults: tmp.defaults,
	            rest: tmp.rest,
	            generator: options.generator,
	            async: options.async,
	            returnType: tmp.returnType,
	            typeParameters: options.typeParameters
	        });

	        strict = previousStrict;

	        return method;
	    }


	    function parseObjectPropertyKey() {
	        var marker = markerCreate(),
	            token = lex(),
	            propertyKey,
	            result;

	        // Note: This function is called only from parseObjectProperty(), where
	        // EOF and Punctuator tokens are already filtered out.

	        if (token.type === Token.StringLiteral || token.type === Token.NumericLiteral) {
	            if (strict && token.octal) {
	                throwErrorTolerant(token, Messages.StrictOctalLiteral);
	            }
	            return markerApply(marker, delegate.createLiteral(token));
	        }

	        if (token.type === Token.Punctuator && token.value === '[') {
	            // For computed properties we should skip the [ and ], and
	            // capture in marker only the assignment expression itself.
	            marker = markerCreate();
	            propertyKey = parseAssignmentExpression();
	            result = markerApply(marker, propertyKey);
	            expect(']');
	            return result;
	        }

	        return markerApply(marker, delegate.createIdentifier(token.value));
	    }

	    function parseObjectProperty() {
	        var token, key, id, value, param, expr, computed,
	            marker = markerCreate(), returnType, typeParameters;

	        token = lookahead;
	        computed = (token.value === '[' && token.type === Token.Punctuator);

	        if (token.type === Token.Identifier || computed || matchAsync()) {
	            id = parseObjectPropertyKey();

	            if (match(':')) {
	                lex();

	                return markerApply(
	                    marker,
	                    delegate.createProperty(
	                        'init',
	                        id,
	                        parseAssignmentExpression(),
	                        false,
	                        false,
	                        computed
	                    )
	                );
	            }

	            if (match('(') || match('<')) {
	                if (match('<')) {
	                    typeParameters = parseTypeParameterDeclaration();
	                }
	                return markerApply(
	                    marker,
	                    delegate.createProperty(
	                        'init',
	                        id,
	                        parsePropertyMethodFunction({
	                            generator: false,
	                            async: false,
	                            typeParameters: typeParameters
	                        }),
	                        true,
	                        false,
	                        computed
	                    )
	                );
	            }

	            // Property Assignment: Getter and Setter.

	            if (token.value === 'get') {
	                computed = (lookahead.value === '[');
	                key = parseObjectPropertyKey();

	                expect('(');
	                expect(')');
	                if (match(':')) {
	                    returnType = parseTypeAnnotation();
	                }

	                return markerApply(
	                    marker,
	                    delegate.createProperty(
	                        'get',
	                        key,
	                        parsePropertyFunction({
	                            generator: false,
	                            async: false,
	                            returnType: returnType
	                        }),
	                        false,
	                        false,
	                        computed
	                    )
	                );
	            }

	            if (token.value === 'set') {
	                computed = (lookahead.value === '[');
	                key = parseObjectPropertyKey();

	                expect('(');
	                token = lookahead;
	                param = [ parseTypeAnnotatableIdentifier() ];
	                expect(')');
	                if (match(':')) {
	                    returnType = parseTypeAnnotation();
	                }

	                return markerApply(
	                    marker,
	                    delegate.createProperty(
	                        'set',
	                        key,
	                        parsePropertyFunction({
	                            params: param,
	                            generator: false,
	                            async: false,
	                            name: token,
	                            returnType: returnType
	                        }),
	                        false,
	                        false,
	                        computed
	                    )
	                );
	            }

	            if (token.value === 'async') {
	                computed = (lookahead.value === '[');
	                key = parseObjectPropertyKey();

	                if (match('<')) {
	                    typeParameters = parseTypeParameterDeclaration();
	                }

	                return markerApply(
	                    marker,
	                    delegate.createProperty(
	                        'init',
	                        key,
	                        parsePropertyMethodFunction({
	                            generator: false,
	                            async: true,
	                            typeParameters: typeParameters
	                        }),
	                        true,
	                        false,
	                        computed
	                    )
	                );
	            }

	            if (computed) {
	                // Computed properties can only be used with full notation.
	                throwUnexpected(lookahead);
	            }

	            return markerApply(
	                marker,
	                delegate.createProperty('init', id, id, false, true, false)
	            );
	        }

	        if (token.type === Token.EOF || token.type === Token.Punctuator) {
	            if (!match('*')) {
	                throwUnexpected(token);
	            }
	            lex();

	            computed = (lookahead.type === Token.Punctuator && lookahead.value === '[');

	            id = parseObjectPropertyKey();

	            if (match('<')) {
	                typeParameters = parseTypeParameterDeclaration();
	            }

	            if (!match('(')) {
	                throwUnexpected(lex());
	            }

	            return markerApply(marker, delegate.createProperty(
	                'init',
	                id,
	                parsePropertyMethodFunction({
	                    generator: true,
	                    typeParameters: typeParameters
	                }),
	                true,
	                false,
	                computed
	            ));
	        }
	        key = parseObjectPropertyKey();
	        if (match(':')) {
	            lex();
	            return markerApply(marker, delegate.createProperty('init', key, parseAssignmentExpression(), false, false, false));
	        }
	        if (match('(') || match('<')) {
	            if (match('<')) {
	                typeParameters = parseTypeParameterDeclaration();
	            }
	            return markerApply(marker, delegate.createProperty(
	                'init',
	                key,
	                parsePropertyMethodFunction({
	                    generator: false,
	                    typeParameters: typeParameters
	                }),
	                true,
	                false,
	                false
	            ));
	        }
	        throwUnexpected(lex());
	    }

	    function parseObjectSpreadProperty() {
	        var marker = markerCreate();
	        expect('...');
	        return markerApply(marker, delegate.createSpreadProperty(parseAssignmentExpression()));
	    }

	    function getFieldName(key) {
	        var toString = String;
	        if (key.type === Syntax.Identifier) {
	            return key.name;
	        }
	        return toString(key.value);
	    }

	    function parseObjectInitialiser() {
	        var properties = [], property, name, kind, storedKind, map = new StringMap(),
	            marker = markerCreate(), toString = String;

	        expect('{');

	        while (!match('}')) {
	            if (match('...')) {
	                property = parseObjectSpreadProperty();
	            } else {
	                property = parseObjectProperty();

	                if (property.key.type === Syntax.Identifier) {
	                    name = property.key.name;
	                } else {
	                    name = toString(property.key.value);
	                }
	                kind = (property.kind === 'init') ? PropertyKind.Data : (property.kind === 'get') ? PropertyKind.Get : PropertyKind.Set;

	                if (map.has(name)) {
	                    storedKind = map.get(name);
	                    if (storedKind === PropertyKind.Data) {
	                        if (strict && kind === PropertyKind.Data) {
	                            throwErrorTolerant({}, Messages.StrictDuplicateProperty);
	                        } else if (kind !== PropertyKind.Data) {
	                            throwErrorTolerant({}, Messages.AccessorDataProperty);
	                        }
	                    } else {
	                        if (kind === PropertyKind.Data) {
	                            throwErrorTolerant({}, Messages.AccessorDataProperty);
	                        } else if (storedKind & kind) {
	                            throwErrorTolerant({}, Messages.AccessorGetSet);
	                        }
	                    }
	                    map.set(name, storedKind | kind);
	                } else {
	                    map.set(name, kind);
	                }
	            }

	            properties.push(property);

	            if (!match('}')) {
	                expect(',');
	            }
	        }

	        expect('}');

	        return markerApply(marker, delegate.createObjectExpression(properties));
	    }

	    function parseTemplateElement(option) {
	        var marker = markerCreate(),
	            token = scanTemplateElement(option);
	        if (strict && token.octal) {
	            throwError(token, Messages.StrictOctalLiteral);
	        }
	        return markerApply(marker, delegate.createTemplateElement({ raw: token.value.raw, cooked: token.value.cooked }, token.tail));
	    }

	    function parseTemplateLiteral() {
	        var quasi, quasis, expressions, marker = markerCreate();

	        quasi = parseTemplateElement({ head: true });
	        quasis = [ quasi ];
	        expressions = [];

	        while (!quasi.tail) {
	            expressions.push(parseExpression());
	            quasi = parseTemplateElement({ head: false });
	            quasis.push(quasi);
	        }

	        return markerApply(marker, delegate.createTemplateLiteral(quasis, expressions));
	    }

	    // 11.1.6 The Grouping Operator

	    function parseGroupExpression() {
	        var expr;

	        expect('(');

	        ++state.parenthesizedCount;

	        expr = parseExpression();

	        expect(')');

	        return expr;
	    }

	    function matchAsyncFuncExprOrDecl() {
	        var token;

	        if (matchAsync()) {
	            token = lookahead2();
	            if (token.type === Token.Keyword && token.value === 'function') {
	                return true;
	            }
	        }

	        return false;
	    }

	    // 11.1 Primary Expressions

	    function parsePrimaryExpression() {
	        var marker, type, token, expr;

	        type = lookahead.type;

	        if (type === Token.Identifier) {
	            marker = markerCreate();
	            return markerApply(marker, delegate.createIdentifier(lex().value));
	        }

	        if (type === Token.StringLiteral || type === Token.NumericLiteral) {
	            if (strict && lookahead.octal) {
	                throwErrorTolerant(lookahead, Messages.StrictOctalLiteral);
	            }
	            marker = markerCreate();
	            return markerApply(marker, delegate.createLiteral(lex()));
	        }

	        if (type === Token.Keyword) {
	            if (matchKeyword('this')) {
	                marker = markerCreate();
	                lex();
	                return markerApply(marker, delegate.createThisExpression());
	            }

	            if (matchKeyword('function')) {
	                return parseFunctionExpression();
	            }

	            if (matchKeyword('class')) {
	                return parseClassExpression();
	            }

	            if (matchKeyword('super')) {
	                marker = markerCreate();
	                lex();
	                return markerApply(marker, delegate.createIdentifier('super'));
	            }
	        }

	        if (type === Token.BooleanLiteral) {
	            marker = markerCreate();
	            token = lex();
	            token.value = (token.value === 'true');
	            return markerApply(marker, delegate.createLiteral(token));
	        }

	        if (type === Token.NullLiteral) {
	            marker = markerCreate();
	            token = lex();
	            token.value = null;
	            return markerApply(marker, delegate.createLiteral(token));
	        }

	        if (match('[')) {
	            return parseArrayInitialiser();
	        }

	        if (match('{')) {
	            return parseObjectInitialiser();
	        }

	        if (match('(')) {
	            return parseGroupExpression();
	        }

	        if (match('/') || match('/=')) {
	            marker = markerCreate();
	            expr = delegate.createLiteral(scanRegExp());
	            peek();
	            return markerApply(marker, expr);
	        }

	        if (type === Token.Template) {
	            return parseTemplateLiteral();
	        }

	        if (match('<')) {
	            return parseXJSElement();
	        }

	        throwUnexpected(lex());
	    }

	    // 11.2 Left-Hand-Side Expressions

	    function parseArguments() {
	        var args = [], arg;

	        expect('(');

	        if (!match(')')) {
	            while (index < length) {
	                arg = parseSpreadOrAssignmentExpression();
	                args.push(arg);

	                if (match(')')) {
	                    break;
	                } else if (arg.type === Syntax.SpreadElement) {
	                    throwError({}, Messages.ElementAfterSpreadElement);
	                }

	                expect(',');
	            }
	        }

	        expect(')');

	        return args;
	    }

	    function parseSpreadOrAssignmentExpression() {
	        if (match('...')) {
	            var marker = markerCreate();
	            lex();
	            return markerApply(marker, delegate.createSpreadElement(parseAssignmentExpression()));
	        }
	        return parseAssignmentExpression();
	    }

	    function parseNonComputedProperty() {
	        var marker = markerCreate(),
	            token = lex();

	        if (!isIdentifierName(token)) {
	            throwUnexpected(token);
	        }

	        return markerApply(marker, delegate.createIdentifier(token.value));
	    }

	    function parseNonComputedMember() {
	        expect('.');

	        return parseNonComputedProperty();
	    }

	    function parseComputedMember() {
	        var expr;

	        expect('[');

	        expr = parseExpression();

	        expect(']');

	        return expr;
	    }

	    function parseNewExpression() {
	        var callee, args, marker = markerCreate();

	        expectKeyword('new');
	        callee = parseLeftHandSideExpression();
	        args = match('(') ? parseArguments() : [];

	        return markerApply(marker, delegate.createNewExpression(callee, args));
	    }

	    function parseLeftHandSideExpressionAllowCall() {
	        var expr, args, marker = markerCreate();

	        expr = matchKeyword('new') ? parseNewExpression() : parsePrimaryExpression();

	        while (match('.') || match('[') || match('(') || lookahead.type === Token.Template) {
	            if (match('(')) {
	                args = parseArguments();
	                expr = markerApply(marker, delegate.createCallExpression(expr, args));
	            } else if (match('[')) {
	                expr = markerApply(marker, delegate.createMemberExpression('[', expr, parseComputedMember()));
	            } else if (match('.')) {
	                expr = markerApply(marker, delegate.createMemberExpression('.', expr, parseNonComputedMember()));
	            } else {
	                expr = markerApply(marker, delegate.createTaggedTemplateExpression(expr, parseTemplateLiteral()));
	            }
	        }

	        return expr;
	    }

	    function parseLeftHandSideExpression() {
	        var expr, marker = markerCreate();

	        expr = matchKeyword('new') ? parseNewExpression() : parsePrimaryExpression();

	        while (match('.') || match('[') || lookahead.type === Token.Template) {
	            if (match('[')) {
	                expr = markerApply(marker, delegate.createMemberExpression('[', expr, parseComputedMember()));
	            } else if (match('.')) {
	                expr = markerApply(marker, delegate.createMemberExpression('.', expr, parseNonComputedMember()));
	            } else {
	                expr = markerApply(marker, delegate.createTaggedTemplateExpression(expr, parseTemplateLiteral()));
	            }
	        }

	        return expr;
	    }

	    // 11.3 Postfix Expressions

	    function parsePostfixExpression() {
	        var marker = markerCreate(),
	            expr = parseLeftHandSideExpressionAllowCall(),
	            token;

	        if (lookahead.type !== Token.Punctuator) {
	            return expr;
	        }

	        if ((match('++') || match('--')) && !peekLineTerminator()) {
	            // 11.3.1, 11.3.2
	            if (strict && expr.type === Syntax.Identifier && isRestrictedWord(expr.name)) {
	                throwErrorTolerant({}, Messages.StrictLHSPostfix);
	            }

	            if (!isLeftHandSide(expr)) {
	                throwError({}, Messages.InvalidLHSInAssignment);
	            }

	            token = lex();
	            expr = markerApply(marker, delegate.createPostfixExpression(token.value, expr));
	        }

	        return expr;
	    }

	    // 11.4 Unary Operators

	    function parseUnaryExpression() {
	        var marker, token, expr;

	        if (lookahead.type !== Token.Punctuator && lookahead.type !== Token.Keyword) {
	            return parsePostfixExpression();
	        }

	        if (match('++') || match('--')) {
	            marker = markerCreate();
	            token = lex();
	            expr = parseUnaryExpression();
	            // 11.4.4, 11.4.5
	            if (strict && expr.type === Syntax.Identifier && isRestrictedWord(expr.name)) {
	                throwErrorTolerant({}, Messages.StrictLHSPrefix);
	            }

	            if (!isLeftHandSide(expr)) {
	                throwError({}, Messages.InvalidLHSInAssignment);
	            }

	            return markerApply(marker, delegate.createUnaryExpression(token.value, expr));
	        }

	        if (match('+') || match('-') || match('~') || match('!')) {
	            marker = markerCreate();
	            token = lex();
	            expr = parseUnaryExpression();
	            return markerApply(marker, delegate.createUnaryExpression(token.value, expr));
	        }

	        if (matchKeyword('delete') || matchKeyword('void') || matchKeyword('typeof')) {
	            marker = markerCreate();
	            token = lex();
	            expr = parseUnaryExpression();
	            expr = markerApply(marker, delegate.createUnaryExpression(token.value, expr));
	            if (strict && expr.operator === 'delete' && expr.argument.type === Syntax.Identifier) {
	                throwErrorTolerant({}, Messages.StrictDelete);
	            }
	            return expr;
	        }

	        return parsePostfixExpression();
	    }

	    function binaryPrecedence(token, allowIn) {
	        var prec = 0;

	        if (token.type !== Token.Punctuator && token.type !== Token.Keyword) {
	            return 0;
	        }

	        switch (token.value) {
	        case '||':
	            prec = 1;
	            break;

	        case '&&':
	            prec = 2;
	            break;

	        case '|':
	            prec = 3;
	            break;

	        case '^':
	            prec = 4;
	            break;

	        case '&':
	            prec = 5;
	            break;

	        case '==':
	        case '!=':
	        case '===':
	        case '!==':
	            prec = 6;
	            break;

	        case '<':
	        case '>':
	        case '<=':
	        case '>=':
	        case 'instanceof':
	            prec = 7;
	            break;

	        case 'in':
	            prec = allowIn ? 7 : 0;
	            break;

	        case '<<':
	        case '>>':
	        case '>>>':
	            prec = 8;
	            break;

	        case '+':
	        case '-':
	            prec = 9;
	            break;

	        case '*':
	        case '/':
	        case '%':
	            prec = 11;
	            break;

	        default:
	            break;
	        }

	        return prec;
	    }

	    // 11.5 Multiplicative Operators
	    // 11.6 Additive Operators
	    // 11.7 Bitwise Shift Operators
	    // 11.8 Relational Operators
	    // 11.9 Equality Operators
	    // 11.10 Binary Bitwise Operators
	    // 11.11 Binary Logical Operators

	    function parseBinaryExpression() {
	        var expr, token, prec, previousAllowIn, stack, right, operator, left, i,
	            marker, markers;

	        previousAllowIn = state.allowIn;
	        state.allowIn = true;

	        marker = markerCreate();
	        left = parseUnaryExpression();

	        token = lookahead;
	        prec = binaryPrecedence(token, previousAllowIn);
	        if (prec === 0) {
	            return left;
	        }
	        token.prec = prec;
	        lex();

	        markers = [marker, markerCreate()];
	        right = parseUnaryExpression();

	        stack = [left, token, right];

	        while ((prec = binaryPrecedence(lookahead, previousAllowIn)) > 0) {

	            // Reduce: make a binary expression from the three topmost entries.
	            while ((stack.length > 2) && (prec <= stack[stack.length - 2].prec)) {
	                right = stack.pop();
	                operator = stack.pop().value;
	                left = stack.pop();
	                expr = delegate.createBinaryExpression(operator, left, right);
	                markers.pop();
	                marker = markers.pop();
	                markerApply(marker, expr);
	                stack.push(expr);
	                markers.push(marker);
	            }

	            // Shift.
	            token = lex();
	            token.prec = prec;
	            stack.push(token);
	            markers.push(markerCreate());
	            expr = parseUnaryExpression();
	            stack.push(expr);
	        }

	        state.allowIn = previousAllowIn;

	        // Final reduce to clean-up the stack.
	        i = stack.length - 1;
	        expr = stack[i];
	        markers.pop();
	        while (i > 1) {
	            expr = delegate.createBinaryExpression(stack[i - 1].value, stack[i - 2], expr);
	            i -= 2;
	            marker = markers.pop();
	            markerApply(marker, expr);
	        }

	        return expr;
	    }


	    // 11.12 Conditional Operator

	    function parseConditionalExpression() {
	        var expr, previousAllowIn, consequent, alternate, marker = markerCreate();
	        expr = parseBinaryExpression();

	        if (match('?')) {
	            lex();
	            previousAllowIn = state.allowIn;
	            state.allowIn = true;
	            consequent = parseAssignmentExpression();
	            state.allowIn = previousAllowIn;
	            expect(':');
	            alternate = parseAssignmentExpression();

	            expr = markerApply(marker, delegate.createConditionalExpression(expr, consequent, alternate));
	        }

	        return expr;
	    }

	    // 11.13 Assignment Operators

	    // 12.14.5 AssignmentPattern

	    function reinterpretAsAssignmentBindingPattern(expr) {
	        var i, len, property, element;

	        if (expr.type === Syntax.ObjectExpression) {
	            expr.type = Syntax.ObjectPattern;
	            for (i = 0, len = expr.properties.length; i < len; i += 1) {
	                property = expr.properties[i];
	                if (property.type === Syntax.SpreadProperty) {
	                    if (i < len - 1) {
	                        throwError({}, Messages.PropertyAfterSpreadProperty);
	                    }
	                    reinterpretAsAssignmentBindingPattern(property.argument);
	                } else {
	                    if (property.kind !== 'init') {
	                        throwError({}, Messages.InvalidLHSInAssignment);
	                    }
	                    reinterpretAsAssignmentBindingPattern(property.value);
	                }
	            }
	        } else if (expr.type === Syntax.ArrayExpression) {
	            expr.type = Syntax.ArrayPattern;
	            for (i = 0, len = expr.elements.length; i < len; i += 1) {
	                element = expr.elements[i];
	                /* istanbul ignore else */
	                if (element) {
	                    reinterpretAsAssignmentBindingPattern(element);
	                }
	            }
	        } else if (expr.type === Syntax.Identifier) {
	            if (isRestrictedWord(expr.name)) {
	                throwError({}, Messages.InvalidLHSInAssignment);
	            }
	        } else if (expr.type === Syntax.SpreadElement) {
	            reinterpretAsAssignmentBindingPattern(expr.argument);
	            if (expr.argument.type === Syntax.ObjectPattern) {
	                throwError({}, Messages.ObjectPatternAsSpread);
	            }
	        } else {
	            /* istanbul ignore else */
	            if (expr.type !== Syntax.MemberExpression && expr.type !== Syntax.CallExpression && expr.type !== Syntax.NewExpression) {
	                throwError({}, Messages.InvalidLHSInAssignment);
	            }
	        }
	    }

	    // 13.2.3 BindingPattern

	    function reinterpretAsDestructuredParameter(options, expr) {
	        var i, len, property, element;

	        if (expr.type === Syntax.ObjectExpression) {
	            expr.type = Syntax.ObjectPattern;
	            for (i = 0, len = expr.properties.length; i < len; i += 1) {
	                property = expr.properties[i];
	                if (property.type === Syntax.SpreadProperty) {
	                    if (i < len - 1) {
	                        throwError({}, Messages.PropertyAfterSpreadProperty);
	                    }
	                    reinterpretAsDestructuredParameter(options, property.argument);
	                } else {
	                    if (property.kind !== 'init') {
	                        throwError({}, Messages.InvalidLHSInFormalsList);
	                    }
	                    reinterpretAsDestructuredParameter(options, property.value);
	                }
	            }
	        } else if (expr.type === Syntax.ArrayExpression) {
	            expr.type = Syntax.ArrayPattern;
	            for (i = 0, len = expr.elements.length; i < len; i += 1) {
	                element = expr.elements[i];
	                if (element) {
	                    reinterpretAsDestructuredParameter(options, element);
	                }
	            }
	        } else if (expr.type === Syntax.Identifier) {
	            validateParam(options, expr, expr.name);
	        } else if (expr.type === Syntax.SpreadElement) {
	            // BindingRestElement only allows BindingIdentifier
	            if (expr.argument.type !== Syntax.Identifier) {
	                throwError({}, Messages.InvalidLHSInFormalsList);
	            }
	            validateParam(options, expr.argument, expr.argument.name);
	        } else {
	            throwError({}, Messages.InvalidLHSInFormalsList);
	        }
	    }

	    function reinterpretAsCoverFormalsList(expressions) {
	        var i, len, param, params, defaults, defaultCount, options, rest;

	        params = [];
	        defaults = [];
	        defaultCount = 0;
	        rest = null;
	        options = {
	            paramSet: new StringMap()
	        };

	        for (i = 0, len = expressions.length; i < len; i += 1) {
	            param = expressions[i];
	            if (param.type === Syntax.Identifier) {
	                params.push(param);
	                defaults.push(null);
	                validateParam(options, param, param.name);
	            } else if (param.type === Syntax.ObjectExpression || param.type === Syntax.ArrayExpression) {
	                reinterpretAsDestructuredParameter(options, param);
	                params.push(param);
	                defaults.push(null);
	            } else if (param.type === Syntax.SpreadElement) {
	                assert(i === len - 1, 'It is guaranteed that SpreadElement is last element by parseExpression');
	                if (param.argument.type !== Syntax.Identifier) {
	                    throwError({}, Messages.InvalidLHSInFormalsList);
	                }
	                reinterpretAsDestructuredParameter(options, param.argument);
	                rest = param.argument;
	            } else if (param.type === Syntax.AssignmentExpression) {
	                params.push(param.left);
	                defaults.push(param.right);
	                ++defaultCount;
	                validateParam(options, param.left, param.left.name);
	            } else {
	                return null;
	            }
	        }

	        if (options.message === Messages.StrictParamDupe) {
	            throwError(
	                strict ? options.stricted : options.firstRestricted,
	                options.message
	            );
	        }

	        if (defaultCount === 0) {
	            defaults = [];
	        }

	        return {
	            params: params,
	            defaults: defaults,
	            rest: rest,
	            stricted: options.stricted,
	            firstRestricted: options.firstRestricted,
	            message: options.message
	        };
	    }

	    function parseArrowFunctionExpression(options, marker) {
	        var previousStrict, previousYieldAllowed, previousAwaitAllowed, body;

	        expect('=>');

	        previousStrict = strict;
	        previousYieldAllowed = state.yieldAllowed;
	        state.yieldAllowed = false;
	        previousAwaitAllowed = state.awaitAllowed;
	        state.awaitAllowed = !!options.async;
	        body = parseConciseBody();

	        if (strict && options.firstRestricted) {
	            throwError(options.firstRestricted, options.message);
	        }
	        if (strict && options.stricted) {
	            throwErrorTolerant(options.stricted, options.message);
	        }

	        strict = previousStrict;
	        state.yieldAllowed = previousYieldAllowed;
	        state.awaitAllowed = previousAwaitAllowed;

	        return markerApply(marker, delegate.createArrowFunctionExpression(
	            options.params,
	            options.defaults,
	            body,
	            options.rest,
	            body.type !== Syntax.BlockStatement,
	            !!options.async
	        ));
	    }

	    function parseAssignmentExpression() {
	        var marker, expr, token, params, oldParenthesizedCount,
	            backtrackToken = lookahead, possiblyAsync = false;

	        if (matchYield()) {
	            return parseYieldExpression();
	        }

	        if (matchAwait()) {
	            return parseAwaitExpression();
	        }

	        oldParenthesizedCount = state.parenthesizedCount;

	        marker = markerCreate();

	        if (matchAsyncFuncExprOrDecl()) {
	            return parseFunctionExpression();
	        }

	        if (matchAsync()) {
	            // We can't be completely sure that this 'async' token is
	            // actually a contextual keyword modifying a function
	            // expression, so we might have to un-lex() it later by
	            // calling rewind(backtrackToken).
	            possiblyAsync = true;
	            lex();
	        }

	        if (match('(')) {
	            token = lookahead2();
	            if ((token.type === Token.Punctuator && token.value === ')') || token.value === '...') {
	                params = parseParams();
	                if (!match('=>')) {
	                    throwUnexpected(lex());
	                }
	                params.async = possiblyAsync;
	                return parseArrowFunctionExpression(params, marker);
	            }
	        }

	        token = lookahead;

	        // If the 'async' keyword is not followed by a '(' character or an
	        // identifier, then it can't be an arrow function modifier, and we
	        // should interpret it as a normal identifer.
	        if (possiblyAsync && !match('(') && token.type !== Token.Identifier) {
	            possiblyAsync = false;
	            rewind(backtrackToken);
	        }

	        expr = parseConditionalExpression();

	        if (match('=>') &&
	                (state.parenthesizedCount === oldParenthesizedCount ||
	                state.parenthesizedCount === (oldParenthesizedCount + 1))) {
	            if (expr.type === Syntax.Identifier) {
	                params = reinterpretAsCoverFormalsList([ expr ]);
	            } else if (expr.type === Syntax.SequenceExpression) {
	                params = reinterpretAsCoverFormalsList(expr.expressions);
	            }
	            if (params) {
	                params.async = possiblyAsync;
	                return parseArrowFunctionExpression(params, marker);
	            }
	        }

	        // If we haven't returned by now, then the 'async' keyword was not
	        // a function modifier, and we should rewind and interpret it as a
	        // normal identifier.
	        if (possiblyAsync) {
	            possiblyAsync = false;
	            rewind(backtrackToken);
	            expr = parseConditionalExpression();
	        }

	        if (matchAssign()) {
	            // 11.13.1
	            if (strict && expr.type === Syntax.Identifier && isRestrictedWord(expr.name)) {
	                throwErrorTolerant(token, Messages.StrictLHSAssignment);
	            }

	            // ES.next draf 11.13 Runtime Semantics step 1
	            if (match('=') && (expr.type === Syntax.ObjectExpression || expr.type === Syntax.ArrayExpression)) {
	                reinterpretAsAssignmentBindingPattern(expr);
	            } else if (!isLeftHandSide(expr)) {
	                throwError({}, Messages.InvalidLHSInAssignment);
	            }

	            expr = markerApply(marker, delegate.createAssignmentExpression(lex().value, expr, parseAssignmentExpression()));
	        }

	        return expr;
	    }

	    // 11.14 Comma Operator

	    function parseExpression() {
	        var marker, expr, expressions, sequence, coverFormalsList, spreadFound, oldParenthesizedCount;

	        oldParenthesizedCount = state.parenthesizedCount;

	        marker = markerCreate();
	        expr = parseAssignmentExpression();
	        expressions = [ expr ];

	        if (match(',')) {
	            while (index < length) {
	                if (!match(',')) {
	                    break;
	                }

	                lex();
	                expr = parseSpreadOrAssignmentExpression();
	                expressions.push(expr);

	                if (expr.type === Syntax.SpreadElement) {
	                    spreadFound = true;
	                    if (!match(')')) {
	                        throwError({}, Messages.ElementAfterSpreadElement);
	                    }
	                    break;
	                }
	            }

	            sequence = markerApply(marker, delegate.createSequenceExpression(expressions));
	        }

	        if (match('=>')) {
	            // Do not allow nested parentheses on the LHS of the =>.
	            if (state.parenthesizedCount === oldParenthesizedCount || state.parenthesizedCount === (oldParenthesizedCount + 1)) {
	                expr = expr.type === Syntax.SequenceExpression ? expr.expressions : expressions;
	                coverFormalsList = reinterpretAsCoverFormalsList(expr);
	                if (coverFormalsList) {
	                    return parseArrowFunctionExpression(coverFormalsList, marker);
	                }
	            }
	            throwUnexpected(lex());
	        }

	        if (spreadFound && lookahead2().value !== '=>') {
	            throwError({}, Messages.IllegalSpread);
	        }

	        return sequence || expr;
	    }

	    // 12.1 Block

	    function parseStatementList() {
	        var list = [],
	            statement;

	        while (index < length) {
	            if (match('}')) {
	                break;
	            }
	            statement = parseSourceElement();
	            if (typeof statement === 'undefined') {
	                break;
	            }
	            list.push(statement);
	        }

	        return list;
	    }

	    function parseBlock() {
	        var block, marker = markerCreate();

	        expect('{');

	        block = parseStatementList();

	        expect('}');

	        return markerApply(marker, delegate.createBlockStatement(block));
	    }

	    // 12.2 Variable Statement

	    function parseTypeParameterDeclaration() {
	        var marker = markerCreate(), paramTypes = [];

	        expect('<');
	        while (!match('>')) {
	            paramTypes.push(parseVariableIdentifier());
	            if (!match('>')) {
	                expect(',');
	            }
	        }
	        expect('>');

	        return markerApply(marker, delegate.createTypeParameterDeclaration(
	            paramTypes
	        ));
	    }

	    function parseTypeParameterInstantiation() {
	        var marker = markerCreate(), oldInType = state.inType, paramTypes = [];

	        state.inType = true;

	        expect('<');
	        while (!match('>')) {
	            paramTypes.push(parseType());
	            if (!match('>')) {
	                expect(',');
	            }
	        }
	        expect('>');

	        state.inType = oldInType;

	        return markerApply(marker, delegate.createTypeParameterInstantiation(
	            paramTypes
	        ));
	    }

	    function parseObjectTypeIndexer(marker, isStatic) {
	        var id, key, value;

	        expect('[');
	        id = parseObjectPropertyKey();
	        expect(':');
	        key = parseType();
	        expect(']');
	        expect(':');
	        value = parseType();

	        return markerApply(marker, delegate.createObjectTypeIndexer(
	            id,
	            key,
	            value,
	            isStatic
	        ));
	    }

	    function parseObjectTypeMethodish(marker) {
	        var params = [], rest = null, returnType, typeParameters = null;
	        if (match('<')) {
	            typeParameters = parseTypeParameterDeclaration();
	        }

	        expect('(');
	        while (lookahead.type === Token.Identifier) {
	            params.push(parseFunctionTypeParam());
	            if (!match(')')) {
	                expect(',');
	            }
	        }

	        if (match('...')) {
	            lex();
	            rest = parseFunctionTypeParam();
	        }
	        expect(')');
	        expect(':');
	        returnType = parseType();

	        return markerApply(marker, delegate.createFunctionTypeAnnotation(
	            params,
	            returnType,
	            rest,
	            typeParameters
	        ));
	    }

	    function parseObjectTypeMethod(marker, isStatic, key) {
	        var optional = false, value;
	        value = parseObjectTypeMethodish(marker);

	        return markerApply(marker, delegate.createObjectTypeProperty(
	            key,
	            value,
	            optional,
	            isStatic
	        ));
	    }

	    function parseObjectTypeCallProperty(marker, isStatic) {
	        var valueMarker = markerCreate();
	        return markerApply(marker, delegate.createObjectTypeCallProperty(
	            parseObjectTypeMethodish(valueMarker),
	            isStatic
	        ));
	    }

	    function parseObjectType(allowStatic) {
	        var callProperties = [], indexers = [], marker, optional = false,
	            properties = [], property, propertyKey, propertyTypeAnnotation,
	            token, isStatic;

	        expect('{');

	        while (!match('}')) {
	            marker = markerCreate();
	            if (allowStatic && matchContextualKeyword('static')) {
	                token = lex();
	                isStatic = true;
	            }

	            if (match('[')) {
	                indexers.push(parseObjectTypeIndexer(marker, isStatic));
	            } else if (match('(') || match('<')) {
	                callProperties.push(parseObjectTypeCallProperty(marker, allowStatic));
	            } else {
	                if (isStatic && match(':')) {
	                    propertyKey = markerApply(marker, delegate.createIdentifier(token));
	                    throwErrorTolerant(token, Messages.StrictReservedWord);
	                } else {
	                    propertyKey = parseObjectPropertyKey();
	                }
	                if (match('<') || match('(')) {
	                    // This is a method property
	                    properties.push(parseObjectTypeMethod(marker, isStatic, propertyKey));
	                } else {
	                    if (match('?')) {
	                        lex();
	                        optional = true;
	                    }
	                    expect(':');
	                    propertyTypeAnnotation = parseType();
	                    properties.push(markerApply(marker, delegate.createObjectTypeProperty(
	                        propertyKey,
	                        propertyTypeAnnotation,
	                        optional,
	                        isStatic
	                    )));
	                }
	            }

	            if (match(';')) {
	                lex();
	            } else if (!match('}')) {
	                throwUnexpected(lookahead);
	            }
	        }

	        expect('}');

	        return delegate.createObjectTypeAnnotation(
	            properties,
	            indexers,
	            callProperties
	        );
	    }

	    function parseGenericType() {
	        var marker = markerCreate(), returnType = null,
	            typeParameters = null, typeIdentifier,
	            typeIdentifierMarker = markerCreate;

	        typeIdentifier = parseVariableIdentifier();

	        while (match('.')) {
	            expect('.');
	            typeIdentifier = markerApply(marker, delegate.createQualifiedTypeIdentifier(
	                typeIdentifier,
	                parseVariableIdentifier()
	            ));
	        }

	        if (match('<')) {
	            typeParameters = parseTypeParameterInstantiation();
	        }

	        return markerApply(marker, delegate.createGenericTypeAnnotation(
	            typeIdentifier,
	            typeParameters
	        ));
	    }

	    function parseVoidType() {
	        var marker = markerCreate();
	        expectKeyword('void');
	        return markerApply(marker, delegate.createVoidTypeAnnotation());
	    }

	    function parseTypeofType() {
	        var argument, marker = markerCreate();
	        expectKeyword('typeof');
	        argument = parsePrimaryType();
	        return markerApply(marker, delegate.createTypeofTypeAnnotation(
	            argument
	        ));
	    }

	    function parseTupleType() {
	        var marker = markerCreate(), types = [];
	        expect('[');
	        // We allow trailing commas
	        while (index < length && !match(']')) {
	            types.push(parseType());
	            if (match(']')) {
	                break;
	            }
	            expect(',');
	        }
	        expect(']');
	        return markerApply(marker, delegate.createTupleTypeAnnotation(
	            types
	        ));
	    }

	    function parseFunctionTypeParam() {
	        var marker = markerCreate(), name, optional = false, typeAnnotation;
	        name = parseVariableIdentifier();
	        if (match('?')) {
	            lex();
	            optional = true;
	        }
	        expect(':');
	        typeAnnotation = parseType();
	        return markerApply(marker, delegate.createFunctionTypeParam(
	            name,
	            typeAnnotation,
	            optional
	        ));
	    }

	    function parseFunctionTypeParams() {
	        var ret = { params: [], rest: null };
	        while (lookahead.type === Token.Identifier) {
	            ret.params.push(parseFunctionTypeParam());
	            if (!match(')')) {
	                expect(',');
	            }
	        }

	        if (match('...')) {
	            lex();
	            ret.rest = parseFunctionTypeParam();
	        }
	        return ret;
	    }

	    // The parsing of types roughly parallels the parsing of expressions, and
	    // primary types are kind of like primary expressions...they're the
	    // primitives with which other types are constructed.
	    function parsePrimaryType() {
	        var typeIdentifier = null, params = null, returnType = null,
	            marker = markerCreate(), rest = null, tmp,
	            typeParameters, token, type, isGroupedType = false;

	        switch (lookahead.type) {
	        case Token.Identifier:
	            switch (lookahead.value) {
	            case 'any':
	                lex();
	                return markerApply(marker, delegate.createAnyTypeAnnotation());
	            case 'bool':  // fallthrough
	            case 'boolean':
	                lex();
	                return markerApply(marker, delegate.createBooleanTypeAnnotation());
	            case 'number':
	                lex();
	                return markerApply(marker, delegate.createNumberTypeAnnotation());
	            case 'string':
	                lex();
	                return markerApply(marker, delegate.createStringTypeAnnotation());
	            }
	            return markerApply(marker, parseGenericType());
	        case Token.Punctuator:
	            switch (lookahead.value) {
	            case '{':
	                return markerApply(marker, parseObjectType());
	            case '[':
	                return parseTupleType();
	            case '<':
	                typeParameters = parseTypeParameterDeclaration();
	                expect('(');
	                tmp = parseFunctionTypeParams();
	                params = tmp.params;
	                rest = tmp.rest;
	                expect(')');

	                expect('=>');

	                returnType = parseType();

	                return markerApply(marker, delegate.createFunctionTypeAnnotation(
	                    params,
	                    returnType,
	                    rest,
	                    typeParameters
	                ));
	            case '(':
	                lex();
	                // Check to see if this is actually a grouped type
	                if (!match(')') && !match('...')) {
	                    if (lookahead.type === Token.Identifier) {
	                        token = lookahead2();
	                        isGroupedType = token.value !== '?' && token.value !== ':';
	                    } else {
	                        isGroupedType = true;
	                    }
	                }

	                if (isGroupedType) {
	                    type = parseType();
	                    expect(')');

	                    // If we see a => next then someone was probably confused about
	                    // function types, so we can provide a better error message
	                    if (match('=>')) {
	                        throwError({}, Messages.ConfusedAboutFunctionType);
	                    }

	                    return type;
	                }

	                tmp = parseFunctionTypeParams();
	                params = tmp.params;
	                rest = tmp.rest;

	                expect(')');

	                expect('=>');

	                returnType = parseType();

	                return markerApply(marker, delegate.createFunctionTypeAnnotation(
	                    params,
	                    returnType,
	                    rest,
	                    null /* typeParameters */
	                ));
	            }
	            break;
	        case Token.Keyword:
	            switch (lookahead.value) {
	            case 'void':
	                return markerApply(marker, parseVoidType());
	            case 'typeof':
	                return markerApply(marker, parseTypeofType());
	            }
	            break;
	        case Token.StringLiteral:
	            token = lex();
	            if (token.octal) {
	                throwError(token, Messages.StrictOctalLiteral);
	            }
	            return markerApply(marker, delegate.createStringLiteralTypeAnnotation(
	                token
	            ));
	        }

	        throwUnexpected(lookahead);
	    }

	    function parsePostfixType() {
	        var marker = markerCreate(), t = parsePrimaryType();
	        if (match('[')) {
	            expect('[');
	            expect(']');
	            return markerApply(marker, delegate.createArrayTypeAnnotation(t));
	        }
	        return t;
	    }

	    function parsePrefixType() {
	        var marker = markerCreate();
	        if (match('?')) {
	            lex();
	            return markerApply(marker, delegate.createNullableTypeAnnotation(
	                parsePrefixType()
	            ));
	        }
	        return parsePostfixType();
	    }


	    function parseIntersectionType() {
	        var marker = markerCreate(), type, types;
	        type = parsePrefixType();
	        types = [type];
	        while (match('&')) {
	            lex();
	            types.push(parsePrefixType());
	        }

	        return types.length === 1 ?
	                type :
	                markerApply(marker, delegate.createIntersectionTypeAnnotation(
	                    types
	                ));
	    }

	    function parseUnionType() {
	        var marker = markerCreate(), type, types;
	        type = parseIntersectionType();
	        types = [type];
	        while (match('|')) {
	            lex();
	            types.push(parseIntersectionType());
	        }
	        return types.length === 1 ?
	                type :
	                markerApply(marker, delegate.createUnionTypeAnnotation(
	                    types
	                ));
	    }

	    function parseType() {
	        var oldInType = state.inType, type;
	        state.inType = true;

	        type = parseUnionType();

	        state.inType = oldInType;
	        return type;
	    }

	    function parseTypeAnnotation() {
	        var marker = markerCreate(), type;

	        expect(':');
	        type = parseType();

	        return markerApply(marker, delegate.createTypeAnnotation(type));
	    }

	    function parseVariableIdentifier() {
	        var marker = markerCreate(),
	            token = lex();

	        if (token.type !== Token.Identifier) {
	            throwUnexpected(token);
	        }

	        return markerApply(marker, delegate.createIdentifier(token.value));
	    }

	    function parseTypeAnnotatableIdentifier(requireTypeAnnotation, canBeOptionalParam) {
	        var marker = markerCreate(),
	            ident = parseVariableIdentifier(),
	            isOptionalParam = false;

	        if (canBeOptionalParam && match('?')) {
	            expect('?');
	            isOptionalParam = true;
	        }

	        if (requireTypeAnnotation || match(':')) {
	            ident.typeAnnotation = parseTypeAnnotation();
	            ident = markerApply(marker, ident);
	        }

	        if (isOptionalParam) {
	            ident.optional = true;
	            ident = markerApply(marker, ident);
	        }

	        return ident;
	    }

	    function parseVariableDeclaration(kind) {
	        var id,
	            marker = markerCreate(),
	            init = null,
	            typeAnnotationMarker = markerCreate();
	        if (match('{')) {
	            id = parseObjectInitialiser();
	            reinterpretAsAssignmentBindingPattern(id);
	            if (match(':')) {
	                id.typeAnnotation = parseTypeAnnotation();
	                markerApply(typeAnnotationMarker, id);
	            }
	        } else if (match('[')) {
	            id = parseArrayInitialiser();
	            reinterpretAsAssignmentBindingPattern(id);
	            if (match(':')) {
	                id.typeAnnotation = parseTypeAnnotation();
	                markerApply(typeAnnotationMarker, id);
	            }
	        } else {
	            /* istanbul ignore next */
	            id = state.allowKeyword ? parseNonComputedProperty() : parseTypeAnnotatableIdentifier();
	            // 12.2.1
	            if (strict && isRestrictedWord(id.name)) {
	                throwErrorTolerant({}, Messages.StrictVarName);
	            }
	        }

	        if (kind === 'const') {
	            if (!match('=')) {
	                throwError({}, Messages.NoUnintializedConst);
	            }
	            expect('=');
	            init = parseAssignmentExpression();
	        } else if (match('=')) {
	            lex();
	            init = parseAssignmentExpression();
	        }

	        return markerApply(marker, delegate.createVariableDeclarator(id, init));
	    }

	    function parseVariableDeclarationList(kind) {
	        var list = [];

	        do {
	            list.push(parseVariableDeclaration(kind));
	            if (!match(',')) {
	                break;
	            }
	            lex();
	        } while (index < length);

	        return list;
	    }

	    function parseVariableStatement() {
	        var declarations, marker = markerCreate();

	        expectKeyword('var');

	        declarations = parseVariableDeclarationList();

	        consumeSemicolon();

	        return markerApply(marker, delegate.createVariableDeclaration(declarations, 'var'));
	    }

	    // kind may be `const` or `let`
	    // Both are experimental and not in the specification yet.
	    // see http://wiki.ecmascript.org/doku.php?id=harmony:const
	    // and http://wiki.ecmascript.org/doku.php?id=harmony:let
	    function parseConstLetDeclaration(kind) {
	        var declarations, marker = markerCreate();

	        expectKeyword(kind);

	        declarations = parseVariableDeclarationList(kind);

	        consumeSemicolon();

	        return markerApply(marker, delegate.createVariableDeclaration(declarations, kind));
	    }

	    // people.mozilla.org/~jorendorff/es6-draft.html

	    function parseModuleSpecifier() {
	        var marker = markerCreate(),
	            specifier;

	        if (lookahead.type !== Token.StringLiteral) {
	            throwError({}, Messages.InvalidModuleSpecifier);
	        }
	        specifier = delegate.createModuleSpecifier(lookahead);
	        lex();
	        return markerApply(marker, specifier);
	    }

	    function parseExportBatchSpecifier() {
	        var marker = markerCreate();
	        expect('*');
	        return markerApply(marker, delegate.createExportBatchSpecifier());
	    }

	    function parseExportSpecifier() {
	        var id, name = null, marker = markerCreate(), from;
	        if (matchKeyword('default')) {
	            lex();
	            id = markerApply(marker, delegate.createIdentifier('default'));
	            // export {default} from "something";
	        } else {
	            id = parseVariableIdentifier();
	        }
	        if (matchContextualKeyword('as')) {
	            lex();
	            name = parseNonComputedProperty();
	        }

	        return markerApply(marker, delegate.createExportSpecifier(id, name));
	    }

	    function parseExportDeclaration() {
	        var backtrackToken, id, previousAllowKeyword, declaration = null,
	            isExportFromIdentifier,
	            src = null, specifiers = [],
	            marker = markerCreate();

	        expectKeyword('export');

	        if (matchKeyword('default')) {
	            // covers:
	            // export default ...
	            lex();
	            if (matchKeyword('function') || matchKeyword('class')) {
	                backtrackToken = lookahead;
	                lex();
	                if (isIdentifierName(lookahead)) {
	                    // covers:
	                    // export default function foo () {}
	                    // export default class foo {}
	                    id = parseNonComputedProperty();
	                    rewind(backtrackToken);
	                    return markerApply(marker, delegate.createExportDeclaration(true, parseSourceElement(), [id], null));
	                }
	                // covers:
	                // export default function () {}
	                // export default class {}
	                rewind(backtrackToken);
	                switch (lookahead.value) {
	                case 'class':
	                    return markerApply(marker, delegate.createExportDeclaration(true, parseClassExpression(), [], null));
	                case 'function':
	                    return markerApply(marker, delegate.createExportDeclaration(true, parseFunctionExpression(), [], null));
	                }
	            }

	            if (matchContextualKeyword('from')) {
	                throwError({}, Messages.UnexpectedToken, lookahead.value);
	            }

	            // covers:
	            // export default {};
	            // export default [];
	            if (match('{')) {
	                declaration = parseObjectInitialiser();
	            } else if (match('[')) {
	                declaration = parseArrayInitialiser();
	            } else {
	                declaration = parseAssignmentExpression();
	            }
	            consumeSemicolon();
	            return markerApply(marker, delegate.createExportDeclaration(true, declaration, [], null));
	        }

	        // non-default export
	        if (lookahead.type === Token.Keyword) {
	            // covers:
	            // export var f = 1;
	            switch (lookahead.value) {
	            case 'let':
	            case 'const':
	            case 'var':
	            case 'class':
	            case 'function':
	                return markerApply(marker, delegate.createExportDeclaration(false, parseSourceElement(), specifiers, null));
	            }
	        }

	        if (match('*')) {
	            // covers:
	            // export * from "foo";
	            specifiers.push(parseExportBatchSpecifier());

	            if (!matchContextualKeyword('from')) {
	                throwError({}, lookahead.value ?
	                        Messages.UnexpectedToken : Messages.MissingFromClause, lookahead.value);
	            }
	            lex();
	            src = parseModuleSpecifier();
	            consumeSemicolon();

	            return markerApply(marker, delegate.createExportDeclaration(false, null, specifiers, src));
	        }

	        expect('{');
	        if (!match('}')) {
	            do {
	                isExportFromIdentifier = isExportFromIdentifier || matchKeyword('default');
	                specifiers.push(parseExportSpecifier());
	            } while (match(',') && lex());
	        }
	        expect('}');

	        if (matchContextualKeyword('from')) {
	            // covering:
	            // export {default} from "foo";
	            // export {foo} from "foo";
	            lex();
	            src = parseModuleSpecifier();
	            consumeSemicolon();
	        } else if (isExportFromIdentifier) {
	            // covering:
	            // export {default}; // missing fromClause
	            throwError({}, lookahead.value ?
	                    Messages.UnexpectedToken : Messages.MissingFromClause, lookahead.value);
	        } else {
	            // cover
	            // export {foo};
	            consumeSemicolon();
	        }
	        return markerApply(marker, delegate.createExportDeclaration(false, declaration, specifiers, src));
	    }


	    function parseImportSpecifier() {
	        // import {<foo as bar>} ...;
	        var id, name = null, marker = markerCreate();

	        id = parseNonComputedProperty();
	        if (matchContextualKeyword('as')) {
	            lex();
	            name = parseVariableIdentifier();
	        }

	        return markerApply(marker, delegate.createImportSpecifier(id, name));
	    }

	    function parseNamedImports() {
	        var specifiers = [];
	        // {foo, bar as bas}
	        expect('{');
	        if (!match('}')) {
	            do {
	                specifiers.push(parseImportSpecifier());
	            } while (match(',') && lex());
	        }
	        expect('}');
	        return specifiers;
	    }

	    function parseImportDefaultSpecifier() {
	        // import <foo> ...;
	        var id, marker = markerCreate();

	        id = parseNonComputedProperty();

	        return markerApply(marker, delegate.createImportDefaultSpecifier(id));
	    }

	    function parseImportNamespaceSpecifier() {
	        // import <* as foo> ...;
	        var id, marker = markerCreate();

	        expect('*');
	        if (!matchContextualKeyword('as')) {
	            throwError({}, Messages.NoAsAfterImportNamespace);
	        }
	        lex();
	        id = parseNonComputedProperty();

	        return markerApply(marker, delegate.createImportNamespaceSpecifier(id));
	    }

	    function parseImportDeclaration() {
	        var specifiers, src, marker = markerCreate();

	        expectKeyword('import');
	        specifiers = [];

	        if (lookahead.type === Token.StringLiteral) {
	            // covers:
	            // import "foo";
	            src = parseModuleSpecifier();
	            consumeSemicolon();
	            return markerApply(marker, delegate.createImportDeclaration(specifiers, src));
	        }

	        if (!matchKeyword('default') && isIdentifierName(lookahead)) {
	            // covers:
	            // import foo
	            // import foo, ...
	            specifiers.push(parseImportDefaultSpecifier());
	            if (match(',')) {
	                lex();
	            }
	        }
	        if (match('*')) {
	            // covers:
	            // import foo, * as foo
	            // import * as foo
	            specifiers.push(parseImportNamespaceSpecifier());
	        } else if (match('{')) {
	            // covers:
	            // import foo, {bar}
	            // import {bar}
	            specifiers = specifiers.concat(parseNamedImports());
	        }

	        if (!matchContextualKeyword('from')) {
	            throwError({}, lookahead.value ?
	                    Messages.UnexpectedToken : Messages.MissingFromClause, lookahead.value);
	        }
	        lex();
	        src = parseModuleSpecifier();
	        consumeSemicolon();

	        return markerApply(marker, delegate.createImportDeclaration(specifiers, src));
	    }

	    // 12.3 Empty Statement

	    function parseEmptyStatement() {
	        var marker = markerCreate();
	        expect(';');
	        return markerApply(marker, delegate.createEmptyStatement());
	    }

	    // 12.4 Expression Statement

	    function parseExpressionStatement() {
	        var marker = markerCreate(), expr = parseExpression();
	        consumeSemicolon();
	        return markerApply(marker, delegate.createExpressionStatement(expr));
	    }

	    // 12.5 If statement

	    function parseIfStatement() {
	        var test, consequent, alternate, marker = markerCreate();

	        expectKeyword('if');

	        expect('(');

	        test = parseExpression();

	        expect(')');

	        consequent = parseStatement();

	        if (matchKeyword('else')) {
	            lex();
	            alternate = parseStatement();
	        } else {
	            alternate = null;
	        }

	        return markerApply(marker, delegate.createIfStatement(test, consequent, alternate));
	    }

	    // 12.6 Iteration Statements

	    function parseDoWhileStatement() {
	        var body, test, oldInIteration, marker = markerCreate();

	        expectKeyword('do');

	        oldInIteration = state.inIteration;
	        state.inIteration = true;

	        body = parseStatement();

	        state.inIteration = oldInIteration;

	        expectKeyword('while');

	        expect('(');

	        test = parseExpression();

	        expect(')');

	        if (match(';')) {
	            lex();
	        }

	        return markerApply(marker, delegate.createDoWhileStatement(body, test));
	    }

	    function parseWhileStatement() {
	        var test, body, oldInIteration, marker = markerCreate();

	        expectKeyword('while');

	        expect('(');

	        test = parseExpression();

	        expect(')');

	        oldInIteration = state.inIteration;
	        state.inIteration = true;

	        body = parseStatement();

	        state.inIteration = oldInIteration;

	        return markerApply(marker, delegate.createWhileStatement(test, body));
	    }

	    function parseForVariableDeclaration() {
	        var marker = markerCreate(),
	            token = lex(),
	            declarations = parseVariableDeclarationList();

	        return markerApply(marker, delegate.createVariableDeclaration(declarations, token.value));
	    }

	    function parseForStatement(opts) {
	        var init, test, update, left, right, body, operator, oldInIteration,
	            marker = markerCreate();
	        init = test = update = null;
	        expectKeyword('for');

	        // http://wiki.ecmascript.org/doku.php?id=proposals:iterators_and_generators&s=each
	        if (matchContextualKeyword('each')) {
	            throwError({}, Messages.EachNotAllowed);
	        }

	        expect('(');

	        if (match(';')) {
	            lex();
	        } else {
	            if (matchKeyword('var') || matchKeyword('let') || matchKeyword('const')) {
	                state.allowIn = false;
	                init = parseForVariableDeclaration();
	                state.allowIn = true;

	                if (init.declarations.length === 1) {
	                    if (matchKeyword('in') || matchContextualKeyword('of')) {
	                        operator = lookahead;
	                        if (!((operator.value === 'in' || init.kind !== 'var') && init.declarations[0].init)) {
	                            lex();
	                            left = init;
	                            right = parseExpression();
	                            init = null;
	                        }
	                    }
	                }
	            } else {
	                state.allowIn = false;
	                init = parseExpression();
	                state.allowIn = true;

	                if (matchContextualKeyword('of')) {
	                    operator = lex();
	                    left = init;
	                    right = parseExpression();
	                    init = null;
	                } else if (matchKeyword('in')) {
	                    // LeftHandSideExpression
	                    if (!isAssignableLeftHandSide(init)) {
	                        throwError({}, Messages.InvalidLHSInForIn);
	                    }
	                    operator = lex();
	                    left = init;
	                    right = parseExpression();
	                    init = null;
	                }
	            }

	            if (typeof left === 'undefined') {
	                expect(';');
	            }
	        }

	        if (typeof left === 'undefined') {

	            if (!match(';')) {
	                test = parseExpression();
	            }
	            expect(';');

	            if (!match(')')) {
	                update = parseExpression();
	            }
	        }

	        expect(')');

	        oldInIteration = state.inIteration;
	        state.inIteration = true;

	        if (!(opts !== undefined && opts.ignoreBody)) {
	            body = parseStatement();
	        }

	        state.inIteration = oldInIteration;

	        if (typeof left === 'undefined') {
	            return markerApply(marker, delegate.createForStatement(init, test, update, body));
	        }

	        if (operator.value === 'in') {
	            return markerApply(marker, delegate.createForInStatement(left, right, body));
	        }
	        return markerApply(marker, delegate.createForOfStatement(left, right, body));
	    }

	    // 12.7 The continue statement

	    function parseContinueStatement() {
	        var label = null, marker = markerCreate();

	        expectKeyword('continue');

	        // Optimize the most common form: 'continue;'.
	        if (source.charCodeAt(index) === 59) {
	            lex();

	            if (!state.inIteration) {
	                throwError({}, Messages.IllegalContinue);
	            }

	            return markerApply(marker, delegate.createContinueStatement(null));
	        }

	        if (peekLineTerminator()) {
	            if (!state.inIteration) {
	                throwError({}, Messages.IllegalContinue);
	            }

	            return markerApply(marker, delegate.createContinueStatement(null));
	        }

	        if (lookahead.type === Token.Identifier) {
	            label = parseVariableIdentifier();

	            if (!state.labelSet.has(label.name)) {
	                throwError({}, Messages.UnknownLabel, label.name);
	            }
	        }

	        consumeSemicolon();

	        if (label === null && !state.inIteration) {
	            throwError({}, Messages.IllegalContinue);
	        }

	        return markerApply(marker, delegate.createContinueStatement(label));
	    }

	    // 12.8 The break statement

	    function parseBreakStatement() {
	        var label = null, marker = markerCreate();

	        expectKeyword('break');

	        // Catch the very common case first: immediately a semicolon (char #59).
	        if (source.charCodeAt(index) === 59) {
	            lex();

	            if (!(state.inIteration || state.inSwitch)) {
	                throwError({}, Messages.IllegalBreak);
	            }

	            return markerApply(marker, delegate.createBreakStatement(null));
	        }

	        if (peekLineTerminator()) {
	            if (!(state.inIteration || state.inSwitch)) {
	                throwError({}, Messages.IllegalBreak);
	            }

	            return markerApply(marker, delegate.createBreakStatement(null));
	        }

	        if (lookahead.type === Token.Identifier) {
	            label = parseVariableIdentifier();

	            if (!state.labelSet.has(label.name)) {
	                throwError({}, Messages.UnknownLabel, label.name);
	            }
	        }

	        consumeSemicolon();

	        if (label === null && !(state.inIteration || state.inSwitch)) {
	            throwError({}, Messages.IllegalBreak);
	        }

	        return markerApply(marker, delegate.createBreakStatement(label));
	    }

	    // 12.9 The return statement

	    function parseReturnStatement() {
	        var argument = null, marker = markerCreate();

	        expectKeyword('return');

	        if (!state.inFunctionBody) {
	            throwErrorTolerant({}, Messages.IllegalReturn);
	        }

	        // 'return' followed by a space and an identifier is very common.
	        if (source.charCodeAt(index) === 32) {
	            if (isIdentifierStart(source.charCodeAt(index + 1))) {
	                argument = parseExpression();
	                consumeSemicolon();
	                return markerApply(marker, delegate.createReturnStatement(argument));
	            }
	        }

	        if (peekLineTerminator()) {
	            return markerApply(marker, delegate.createReturnStatement(null));
	        }

	        if (!match(';')) {
	            if (!match('}') && lookahead.type !== Token.EOF) {
	                argument = parseExpression();
	            }
	        }

	        consumeSemicolon();

	        return markerApply(marker, delegate.createReturnStatement(argument));
	    }

	    // 12.10 The with statement

	    function parseWithStatement() {
	        var object, body, marker = markerCreate();

	        if (strict) {
	            throwErrorTolerant({}, Messages.StrictModeWith);
	        }

	        expectKeyword('with');

	        expect('(');

	        object = parseExpression();

	        expect(')');

	        body = parseStatement();

	        return markerApply(marker, delegate.createWithStatement(object, body));
	    }

	    // 12.10 The swith statement

	    function parseSwitchCase() {
	        var test,
	            consequent = [],
	            sourceElement,
	            marker = markerCreate();

	        if (matchKeyword('default')) {
	            lex();
	            test = null;
	        } else {
	            expectKeyword('case');
	            test = parseExpression();
	        }
	        expect(':');

	        while (index < length) {
	            if (match('}') || matchKeyword('default') || matchKeyword('case')) {
	                break;
	            }
	            sourceElement = parseSourceElement();
	            if (typeof sourceElement === 'undefined') {
	                break;
	            }
	            consequent.push(sourceElement);
	        }

	        return markerApply(marker, delegate.createSwitchCase(test, consequent));
	    }

	    function parseSwitchStatement() {
	        var discriminant, cases, clause, oldInSwitch, defaultFound, marker = markerCreate();

	        expectKeyword('switch');

	        expect('(');

	        discriminant = parseExpression();

	        expect(')');

	        expect('{');

	        cases = [];

	        if (match('}')) {
	            lex();
	            return markerApply(marker, delegate.createSwitchStatement(discriminant, cases));
	        }

	        oldInSwitch = state.inSwitch;
	        state.inSwitch = true;
	        defaultFound = false;

	        while (index < length) {
	            if (match('}')) {
	                break;
	            }
	            clause = parseSwitchCase();
	            if (clause.test === null) {
	                if (defaultFound) {
	                    throwError({}, Messages.MultipleDefaultsInSwitch);
	                }
	                defaultFound = true;
	            }
	            cases.push(clause);
	        }

	        state.inSwitch = oldInSwitch;

	        expect('}');

	        return markerApply(marker, delegate.createSwitchStatement(discriminant, cases));
	    }

	    // 12.13 The throw statement

	    function parseThrowStatement() {
	        var argument, marker = markerCreate();

	        expectKeyword('throw');

	        if (peekLineTerminator()) {
	            throwError({}, Messages.NewlineAfterThrow);
	        }

	        argument = parseExpression();

	        consumeSemicolon();

	        return markerApply(marker, delegate.createThrowStatement(argument));
	    }

	    // 12.14 The try statement

	    function parseCatchClause() {
	        var param, body, marker = markerCreate();

	        expectKeyword('catch');

	        expect('(');
	        if (match(')')) {
	            throwUnexpected(lookahead);
	        }

	        param = parseExpression();
	        // 12.14.1
	        if (strict && param.type === Syntax.Identifier && isRestrictedWord(param.name)) {
	            throwErrorTolerant({}, Messages.StrictCatchVariable);
	        }

	        expect(')');
	        body = parseBlock();
	        return markerApply(marker, delegate.createCatchClause(param, body));
	    }

	    function parseTryStatement() {
	        var block, handlers = [], finalizer = null, marker = markerCreate();

	        expectKeyword('try');

	        block = parseBlock();

	        if (matchKeyword('catch')) {
	            handlers.push(parseCatchClause());
	        }

	        if (matchKeyword('finally')) {
	            lex();
	            finalizer = parseBlock();
	        }

	        if (handlers.length === 0 && !finalizer) {
	            throwError({}, Messages.NoCatchOrFinally);
	        }

	        return markerApply(marker, delegate.createTryStatement(block, [], handlers, finalizer));
	    }

	    // 12.15 The debugger statement

	    function parseDebuggerStatement() {
	        var marker = markerCreate();
	        expectKeyword('debugger');

	        consumeSemicolon();

	        return markerApply(marker, delegate.createDebuggerStatement());
	    }

	    // 12 Statements

	    function parseStatement() {
	        var type = lookahead.type,
	            marker,
	            expr,
	            labeledBody;

	        if (type === Token.EOF) {
	            throwUnexpected(lookahead);
	        }

	        if (type === Token.Punctuator) {
	            switch (lookahead.value) {
	            case ';':
	                return parseEmptyStatement();
	            case '{':
	                return parseBlock();
	            case '(':
	                return parseExpressionStatement();
	            default:
	                break;
	            }
	        }

	        if (type === Token.Keyword) {
	            switch (lookahead.value) {
	            case 'break':
	                return parseBreakStatement();
	            case 'continue':
	                return parseContinueStatement();
	            case 'debugger':
	                return parseDebuggerStatement();
	            case 'do':
	                return parseDoWhileStatement();
	            case 'for':
	                return parseForStatement();
	            case 'function':
	                return parseFunctionDeclaration();
	            case 'class':
	                return parseClassDeclaration();
	            case 'if':
	                return parseIfStatement();
	            case 'return':
	                return parseReturnStatement();
	            case 'switch':
	                return parseSwitchStatement();
	            case 'throw':
	                return parseThrowStatement();
	            case 'try':
	                return parseTryStatement();
	            case 'var':
	                return parseVariableStatement();
	            case 'while':
	                return parseWhileStatement();
	            case 'with':
	                return parseWithStatement();
	            default:
	                break;
	            }
	        }

	        if (matchAsyncFuncExprOrDecl()) {
	            return parseFunctionDeclaration();
	        }

	        marker = markerCreate();
	        expr = parseExpression();

	        // 12.12 Labelled Statements
	        if ((expr.type === Syntax.Identifier) && match(':')) {
	            lex();

	            if (state.labelSet.has(expr.name)) {
	                throwError({}, Messages.Redeclaration, 'Label', expr.name);
	            }

	            state.labelSet.set(expr.name, true);
	            labeledBody = parseStatement();
	            state.labelSet['delete'](expr.name);
	            return markerApply(marker, delegate.createLabeledStatement(expr, labeledBody));
	        }

	        consumeSemicolon();

	        return markerApply(marker, delegate.createExpressionStatement(expr));
	    }

	    // 13 Function Definition

	    function parseConciseBody() {
	        if (match('{')) {
	            return parseFunctionSourceElements();
	        }
	        return parseAssignmentExpression();
	    }

	    function parseFunctionSourceElements() {
	        var sourceElement, sourceElements = [], token, directive, firstRestricted,
	            oldLabelSet, oldInIteration, oldInSwitch, oldInFunctionBody, oldParenthesizedCount,
	            marker = markerCreate();

	        expect('{');

	        while (index < length) {
	            if (lookahead.type !== Token.StringLiteral) {
	                break;
	            }
	            token = lookahead;

	            sourceElement = parseSourceElement();
	            sourceElements.push(sourceElement);
	            if (sourceElement.expression.type !== Syntax.Literal) {
	                // this is not directive
	                break;
	            }
	            directive = source.slice(token.range[0] + 1, token.range[1] - 1);
	            if (directive === 'use strict') {
	                strict = true;
	                if (firstRestricted) {
	                    throwErrorTolerant(firstRestricted, Messages.StrictOctalLiteral);
	                }
	            } else {
	                if (!firstRestricted && token.octal) {
	                    firstRestricted = token;
	                }
	            }
	        }

	        oldLabelSet = state.labelSet;
	        oldInIteration = state.inIteration;
	        oldInSwitch = state.inSwitch;
	        oldInFunctionBody = state.inFunctionBody;
	        oldParenthesizedCount = state.parenthesizedCount;

	        state.labelSet = new StringMap();
	        state.inIteration = false;
	        state.inSwitch = false;
	        state.inFunctionBody = true;
	        state.parenthesizedCount = 0;

	        while (index < length) {
	            if (match('}')) {
	                break;
	            }
	            sourceElement = parseSourceElement();
	            if (typeof sourceElement === 'undefined') {
	                break;
	            }
	            sourceElements.push(sourceElement);
	        }

	        expect('}');

	        state.labelSet = oldLabelSet;
	        state.inIteration = oldInIteration;
	        state.inSwitch = oldInSwitch;
	        state.inFunctionBody = oldInFunctionBody;
	        state.parenthesizedCount = oldParenthesizedCount;

	        return markerApply(marker, delegate.createBlockStatement(sourceElements));
	    }

	    function validateParam(options, param, name) {
	        if (strict) {
	            if (isRestrictedWord(name)) {
	                options.stricted = param;
	                options.message = Messages.StrictParamName;
	            }
	            if (options.paramSet.has(name)) {
	                options.stricted = param;
	                options.message = Messages.StrictParamDupe;
	            }
	        } else if (!options.firstRestricted) {
	            if (isRestrictedWord(name)) {
	                options.firstRestricted = param;
	                options.message = Messages.StrictParamName;
	            } else if (isStrictModeReservedWord(name)) {
	                options.firstRestricted = param;
	                options.message = Messages.StrictReservedWord;
	            } else if (options.paramSet.has(name)) {
	                options.firstRestricted = param;
	                options.message = Messages.StrictParamDupe;
	            }
	        }
	        options.paramSet.set(name, true);
	    }

	    function parseParam(options) {
	        var marker, token, rest, param, def;

	        token = lookahead;
	        if (token.value === '...') {
	            token = lex();
	            rest = true;
	        }

	        if (match('[')) {
	            marker = markerCreate();
	            param = parseArrayInitialiser();
	            reinterpretAsDestructuredParameter(options, param);
	            if (match(':')) {
	                param.typeAnnotation = parseTypeAnnotation();
	                markerApply(marker, param);
	            }
	        } else if (match('{')) {
	            marker = markerCreate();
	            if (rest) {
	                throwError({}, Messages.ObjectPatternAsRestParameter);
	            }
	            param = parseObjectInitialiser();
	            reinterpretAsDestructuredParameter(options, param);
	            if (match(':')) {
	                param.typeAnnotation = parseTypeAnnotation();
	                markerApply(marker, param);
	            }
	        } else {
	            param =
	                rest
	                ? parseTypeAnnotatableIdentifier(
	                    false, /* requireTypeAnnotation */
	                    false /* canBeOptionalParam */
	                )
	                : parseTypeAnnotatableIdentifier(
	                    false, /* requireTypeAnnotation */
	                    true /* canBeOptionalParam */
	                );

	            validateParam(options, token, token.value);
	        }

	        if (match('=')) {
	            if (rest) {
	                throwErrorTolerant(lookahead, Messages.DefaultRestParameter);
	            }
	            lex();
	            def = parseAssignmentExpression();
	            ++options.defaultCount;
	        }

	        if (rest) {
	            if (!match(')')) {
	                throwError({}, Messages.ParameterAfterRestParameter);
	            }
	            options.rest = param;
	            return false;
	        }

	        options.params.push(param);
	        options.defaults.push(def);
	        return !match(')');
	    }

	    function parseParams(firstRestricted) {
	        var options, marker = markerCreate();

	        options = {
	            params: [],
	            defaultCount: 0,
	            defaults: [],
	            rest: null,
	            firstRestricted: firstRestricted
	        };

	        expect('(');

	        if (!match(')')) {
	            options.paramSet = new StringMap();
	            while (index < length) {
	                if (!parseParam(options)) {
	                    break;
	                }
	                expect(',');
	            }
	        }

	        expect(')');

	        if (options.defaultCount === 0) {
	            options.defaults = [];
	        }

	        if (match(':')) {
	            options.returnType = parseTypeAnnotation();
	        }

	        return markerApply(marker, options);
	    }

	    function parseFunctionDeclaration() {
	        var id, body, token, tmp, firstRestricted, message, generator, isAsync,
	            previousStrict, previousYieldAllowed, previousAwaitAllowed,
	            marker = markerCreate(), typeParameters;

	        isAsync = false;
	        if (matchAsync()) {
	            lex();
	            isAsync = true;
	        }

	        expectKeyword('function');

	        generator = false;
	        if (match('*')) {
	            lex();
	            generator = true;
	        }

	        token = lookahead;

	        id = parseVariableIdentifier();

	        if (match('<')) {
	            typeParameters = parseTypeParameterDeclaration();
	        }

	        if (strict) {
	            if (isRestrictedWord(token.value)) {
	                throwErrorTolerant(token, Messages.StrictFunctionName);
	            }
	        } else {
	            if (isRestrictedWord(token.value)) {
	                firstRestricted = token;
	                message = Messages.StrictFunctionName;
	            } else if (isStrictModeReservedWord(token.value)) {
	                firstRestricted = token;
	                message = Messages.StrictReservedWord;
	            }
	        }

	        tmp = parseParams(firstRestricted);
	        firstRestricted = tmp.firstRestricted;
	        if (tmp.message) {
	            message = tmp.message;
	        }

	        previousStrict = strict;
	        previousYieldAllowed = state.yieldAllowed;
	        state.yieldAllowed = generator;
	        previousAwaitAllowed = state.awaitAllowed;
	        state.awaitAllowed = isAsync;

	        body = parseFunctionSourceElements();

	        if (strict && firstRestricted) {
	            throwError(firstRestricted, message);
	        }
	        if (strict && tmp.stricted) {
	            throwErrorTolerant(tmp.stricted, message);
	        }
	        strict = previousStrict;
	        state.yieldAllowed = previousYieldAllowed;
	        state.awaitAllowed = previousAwaitAllowed;

	        return markerApply(
	            marker,
	            delegate.createFunctionDeclaration(
	                id,
	                tmp.params,
	                tmp.defaults,
	                body,
	                tmp.rest,
	                generator,
	                false,
	                isAsync,
	                tmp.returnType,
	                typeParameters
	            )
	        );
	    }

	    function parseFunctionExpression() {
	        var token, id = null, firstRestricted, message, tmp, body, generator, isAsync,
	            previousStrict, previousYieldAllowed, previousAwaitAllowed,
	            marker = markerCreate(), typeParameters;

	        isAsync = false;
	        if (matchAsync()) {
	            lex();
	            isAsync = true;
	        }

	        expectKeyword('function');

	        generator = false;

	        if (match('*')) {
	            lex();
	            generator = true;
	        }

	        if (!match('(')) {
	            if (!match('<')) {
	                token = lookahead;
	                id = parseVariableIdentifier();

	                if (strict) {
	                    if (isRestrictedWord(token.value)) {
	                        throwErrorTolerant(token, Messages.StrictFunctionName);
	                    }
	                } else {
	                    if (isRestrictedWord(token.value)) {
	                        firstRestricted = token;
	                        message = Messages.StrictFunctionName;
	                    } else if (isStrictModeReservedWord(token.value)) {
	                        firstRestricted = token;
	                        message = Messages.StrictReservedWord;
	                    }
	                }
	            }

	            if (match('<')) {
	                typeParameters = parseTypeParameterDeclaration();
	            }
	        }

	        tmp = parseParams(firstRestricted);
	        firstRestricted = tmp.firstRestricted;
	        if (tmp.message) {
	            message = tmp.message;
	        }

	        previousStrict = strict;
	        previousYieldAllowed = state.yieldAllowed;
	        state.yieldAllowed = generator;
	        previousAwaitAllowed = state.awaitAllowed;
	        state.awaitAllowed = isAsync;

	        body = parseFunctionSourceElements();

	        if (strict && firstRestricted) {
	            throwError(firstRestricted, message);
	        }
	        if (strict && tmp.stricted) {
	            throwErrorTolerant(tmp.stricted, message);
	        }
	        strict = previousStrict;
	        state.yieldAllowed = previousYieldAllowed;
	        state.awaitAllowed = previousAwaitAllowed;

	        return markerApply(
	            marker,
	            delegate.createFunctionExpression(
	                id,
	                tmp.params,
	                tmp.defaults,
	                body,
	                tmp.rest,
	                generator,
	                false,
	                isAsync,
	                tmp.returnType,
	                typeParameters
	            )
	        );
	    }

	    function parseYieldExpression() {
	        var delegateFlag, expr, marker = markerCreate();

	        expectKeyword('yield', !strict);

	        delegateFlag = false;
	        if (match('*')) {
	            lex();
	            delegateFlag = true;
	        }

	        expr = parseAssignmentExpression();

	        return markerApply(marker, delegate.createYieldExpression(expr, delegateFlag));
	    }

	    function parseAwaitExpression() {
	        var expr, marker = markerCreate();
	        expectContextualKeyword('await');
	        expr = parseAssignmentExpression();
	        return markerApply(marker, delegate.createAwaitExpression(expr));
	    }

	    // 14 Classes

	    function validateDuplicateProp(propMap, key, accessor) {
	        var propInfo, reversed, name, isValidDuplicateProp;

	        name = getFieldName(key);

	        if (propMap.has(name)) {
	            propInfo = propMap.get(name);
	            if (accessor === 'data') {
	                isValidDuplicateProp = false;
	            } else {
	                if (accessor === 'get') {
	                    reversed = 'set';
	                } else {
	                    reversed = 'get';
	                }

	                isValidDuplicateProp =
	                    // There isn't already a specified accessor for this prop
	                    propInfo[accessor] === undefined
	                    // There isn't already a data prop by this name
	                    && propInfo.data === undefined
	                    // The only existing prop by this name is a reversed accessor
	                    && propInfo[reversed] !== undefined;
	            }
	            if (!isValidDuplicateProp) {
	                throwError(key, Messages.IllegalDuplicateClassProperty);
	            }
	        } else {
	            propInfo = {
	                get: undefined,
	                set: undefined,
	                data: undefined
	            };
	            propMap.set(name, propInfo);
	        }
	        propInfo[accessor] = true;
	    }

	    function parseMethodDefinition(existingPropNames, key, isStatic, generator, computed) {
	        var token, param, propType, isValidDuplicateProp = false,
	            isAsync, typeParameters, tokenValue, returnType,
	            annotationMarker, propMap;

	        propType = isStatic ? ClassPropertyType.static : ClassPropertyType.prototype;

	        propMap = existingPropNames[propType];

	        if (generator) {
	            return delegate.createMethodDefinition(
	                propType,
	                '',
	                key,
	                parsePropertyMethodFunction({ generator: true }),
	                computed
	            );
	        }

	        tokenValue = key.type === 'Identifier' && key.name;

	        if (tokenValue === 'get' && !match('(')) {
	            key = parseObjectPropertyKey();

	            // It is a syntax error if any other properties have a name
	            // duplicating this one unless they are a setter
	            if (!computed) {
	                validateDuplicateProp(propMap, key, 'get');
	            }

	            expect('(');
	            expect(')');
	            if (match(':')) {
	                returnType = parseTypeAnnotation();
	            }
	            return delegate.createMethodDefinition(
	                propType,
	                'get',
	                key,
	                parsePropertyFunction({ generator: false, returnType: returnType }),
	                computed
	            );
	        }
	        if (tokenValue === 'set' && !match('(')) {
	            key = parseObjectPropertyKey();

	            // It is a syntax error if any other properties have a name
	            // duplicating this one unless they are a getter
	            if (!computed) {
	                validateDuplicateProp(propMap, key, 'set');
	            }

	            expect('(');
	            token = lookahead;
	            param = [ parseTypeAnnotatableIdentifier() ];
	            expect(')');
	            if (match(':')) {
	                returnType = parseTypeAnnotation();
	            }
	            return delegate.createMethodDefinition(
	                propType,
	                'set',
	                key,
	                parsePropertyFunction({
	                    params: param,
	                    generator: false,
	                    name: token,
	                    returnType: returnType
	                }),
	                computed
	            );
	        }

	        if (match('<')) {
	            typeParameters = parseTypeParameterDeclaration();
	        }

	        isAsync = tokenValue === 'async' && !match('(');
	        if (isAsync) {
	            key = parseObjectPropertyKey();
	        }

	        // It is a syntax error if any other properties have the same name as a
	        // non-getter, non-setter method
	        if (!computed) {
	            validateDuplicateProp(propMap, key, 'data');
	        }

	        return delegate.createMethodDefinition(
	            propType,
	            '',
	            key,
	            parsePropertyMethodFunction({
	                generator: false,
	                async: isAsync,
	                typeParameters: typeParameters
	            }),
	            computed
	        );
	    }

	    function parseClassProperty(existingPropNames, key, computed, isStatic) {
	        var typeAnnotation;

	        typeAnnotation = parseTypeAnnotation();
	        expect(';');

	        return delegate.createClassProperty(
	            key,
	            typeAnnotation,
	            computed,
	            isStatic
	        );
	    }

	    function parseClassElement(existingProps) {
	        var computed = false, generator = false, key, marker = markerCreate(),
	            isStatic = false, possiblyOpenBracketToken;
	        if (match(';')) {
	            lex();
	            return;
	        }

	        if (lookahead.value === 'static') {
	            lex();
	            isStatic = true;
	        }

	        if (match('*')) {
	            lex();
	            generator = true;
	        }

	        possiblyOpenBracketToken = lookahead;
	        if (matchContextualKeyword('get') || matchContextualKeyword('set')) {
	            possiblyOpenBracketToken = lookahead2();
	        }

	        if (possiblyOpenBracketToken.type === Token.Punctuator
	                && possiblyOpenBracketToken.value === '[') {
	            computed = true;
	        }

	        key = parseObjectPropertyKey();

	        if (!generator && lookahead.value === ':') {
	            return markerApply(marker, parseClassProperty(existingProps, key, computed, isStatic));
	        }

	        return markerApply(marker, parseMethodDefinition(
	            existingProps,
	            key,
	            isStatic,
	            generator,
	            computed
	        ));
	    }

	    function parseClassBody() {
	        var classElement, classElements = [], existingProps = {}, marker = markerCreate();

	        existingProps[ClassPropertyType.static] = new StringMap();
	        existingProps[ClassPropertyType.prototype] = new StringMap();

	        expect('{');

	        while (index < length) {
	            if (match('}')) {
	                break;
	            }
	            classElement = parseClassElement(existingProps);

	            if (typeof classElement !== 'undefined') {
	                classElements.push(classElement);
	            }
	        }

	        expect('}');

	        return markerApply(marker, delegate.createClassBody(classElements));
	    }

	    function parseClassImplements() {
	        var id, implemented = [], marker, typeParameters;
	        expectContextualKeyword('implements');
	        while (index < length) {
	            marker = markerCreate();
	            id = parseVariableIdentifier();
	            if (match('<')) {
	                typeParameters = parseTypeParameterInstantiation();
	            } else {
	                typeParameters = null;
	            }
	            implemented.push(markerApply(marker, delegate.createClassImplements(
	                id,
	                typeParameters
	            )));
	            if (!match(',')) {
	                break;
	            }
	            expect(',');
	        }
	        return implemented;
	    }

	    function parseClassExpression() {
	        var id, implemented, previousYieldAllowed, superClass = null,
	            superTypeParameters, marker = markerCreate(), typeParameters;

	        expectKeyword('class');

	        if (!matchKeyword('extends') && !matchContextualKeyword('implements') && !match('{')) {
	            id = parseVariableIdentifier();
	        }

	        if (match('<')) {
	            typeParameters = parseTypeParameterDeclaration();
	        }

	        if (matchKeyword('extends')) {
	            expectKeyword('extends');
	            previousYieldAllowed = state.yieldAllowed;
	            state.yieldAllowed = false;
	            superClass = parseLeftHandSideExpressionAllowCall();
	            if (match('<')) {
	                superTypeParameters = parseTypeParameterInstantiation();
	            }
	            state.yieldAllowed = previousYieldAllowed;
	        }

	        if (matchContextualKeyword('implements')) {
	            implemented = parseClassImplements();
	        }

	        return markerApply(marker, delegate.createClassExpression(
	            id,
	            superClass,
	            parseClassBody(),
	            typeParameters,
	            superTypeParameters,
	            implemented
	        ));
	    }

	    function parseClassDeclaration() {
	        var id, implemented, previousYieldAllowed, superClass = null,
	            superTypeParameters, marker = markerCreate(), typeParameters;

	        expectKeyword('class');

	        id = parseVariableIdentifier();

	        if (match('<')) {
	            typeParameters = parseTypeParameterDeclaration();
	        }

	        if (matchKeyword('extends')) {
	            expectKeyword('extends');
	            previousYieldAllowed = state.yieldAllowed;
	            state.yieldAllowed = false;
	            superClass = parseLeftHandSideExpressionAllowCall();
	            if (match('<')) {
	                superTypeParameters = parseTypeParameterInstantiation();
	            }
	            state.yieldAllowed = previousYieldAllowed;
	        }

	        if (matchContextualKeyword('implements')) {
	            implemented = parseClassImplements();
	        }

	        return markerApply(marker, delegate.createClassDeclaration(
	            id,
	            superClass,
	            parseClassBody(),
	            typeParameters,
	            superTypeParameters,
	            implemented
	        ));
	    }

	    // 15 Program

	    function parseSourceElement() {
	        var token;
	        if (lookahead.type === Token.Keyword) {
	            switch (lookahead.value) {
	            case 'const':
	            case 'let':
	                return parseConstLetDeclaration(lookahead.value);
	            case 'function':
	                return parseFunctionDeclaration();
	            case 'export':
	                throwErrorTolerant({}, Messages.IllegalExportDeclaration);
	                return parseExportDeclaration();
	            case 'import':
	                throwErrorTolerant({}, Messages.IllegalImportDeclaration);
	                return parseImportDeclaration();
	            default:
	                return parseStatement();
	            }
	        }

	        if (matchContextualKeyword('type')
	                && lookahead2().type === Token.Identifier) {
	            return parseTypeAlias();
	        }

	        if (matchContextualKeyword('interface')
	                && lookahead2().type === Token.Identifier) {
	            return parseInterface();
	        }

	        if (matchContextualKeyword('declare')) {
	            token = lookahead2();
	            if (token.type === Token.Keyword) {
	                switch (token.value) {
	                case 'class':
	                    return parseDeclareClass();
	                case 'function':
	                    return parseDeclareFunction();
	                case 'var':
	                    return parseDeclareVariable();
	                }
	            } else if (token.type === Token.Identifier
	                    && token.value === 'module') {
	                return parseDeclareModule();
	            }
	        }

	        if (lookahead.type !== Token.EOF) {
	            return parseStatement();
	        }
	    }

	    function parseProgramElement() {
	        if (extra.isModule && lookahead.type === Token.Keyword) {
	            switch (lookahead.value) {
	            case 'export':
	                return parseExportDeclaration();
	            case 'import':
	                return parseImportDeclaration();
	            }
	        }

	        return parseSourceElement();
	    }

	    function parseProgramElements() {
	        var sourceElement, sourceElements = [], token, directive, firstRestricted;

	        while (index < length) {
	            token = lookahead;
	            if (token.type !== Token.StringLiteral) {
	                break;
	            }

	            sourceElement = parseProgramElement();
	            sourceElements.push(sourceElement);
	            if (sourceElement.expression.type !== Syntax.Literal) {
	                // this is not directive
	                break;
	            }
	            directive = source.slice(token.range[0] + 1, token.range[1] - 1);
	            if (directive === 'use strict') {
	                strict = true;
	                if (firstRestricted) {
	                    throwErrorTolerant(firstRestricted, Messages.StrictOctalLiteral);
	                }
	            } else {
	                if (!firstRestricted && token.octal) {
	                    firstRestricted = token;
	                }
	            }
	        }

	        while (index < length) {
	            sourceElement = parseProgramElement();
	            if (typeof sourceElement === 'undefined') {
	                break;
	            }
	            sourceElements.push(sourceElement);
	        }
	        return sourceElements;
	    }

	    function parseProgram() {
	        var body, marker = markerCreate();
	        strict = !!extra.isModule;
	        peek();
	        body = parseProgramElements();
	        return markerApply(marker, delegate.createProgram(body));
	    }

	    // The following functions are needed only when the option to preserve
	    // the comments is active.

	    function addComment(type, value, start, end, loc) {
	        var comment;

	        assert(typeof start === 'number', 'Comment must have valid position');

	        // Because the way the actual token is scanned, often the comments
	        // (if any) are skipped twice during the lexical analysis.
	        // Thus, we need to skip adding a comment if the comment array already
	        // handled it.
	        if (state.lastCommentStart >= start) {
	            return;
	        }
	        state.lastCommentStart = start;

	        comment = {
	            type: type,
	            value: value
	        };
	        if (extra.range) {
	            comment.range = [start, end];
	        }
	        if (extra.loc) {
	            comment.loc = loc;
	        }
	        extra.comments.push(comment);
	        if (extra.attachComment) {
	            extra.leadingComments.push(comment);
	            extra.trailingComments.push(comment);
	        }
	    }

	    function scanComment() {
	        var comment, ch, loc, start, blockComment, lineComment;

	        comment = '';
	        blockComment = false;
	        lineComment = false;

	        while (index < length) {
	            ch = source[index];

	            if (lineComment) {
	                ch = source[index++];
	                if (isLineTerminator(ch.charCodeAt(0))) {
	                    loc.end = {
	                        line: lineNumber,
	                        column: index - lineStart - 1
	                    };
	                    lineComment = false;
	                    addComment('Line', comment, start, index - 1, loc);
	                    if (ch === '\r' && source[index] === '\n') {
	                        ++index;
	                    }
	                    ++lineNumber;
	                    lineStart = index;
	                    comment = '';
	                } else if (index >= length) {
	                    lineComment = false;
	                    comment += ch;
	                    loc.end = {
	                        line: lineNumber,
	                        column: length - lineStart
	                    };
	                    addComment('Line', comment, start, length, loc);
	                } else {
	                    comment += ch;
	                }
	            } else if (blockComment) {
	                if (isLineTerminator(ch.charCodeAt(0))) {
	                    if (ch === '\r') {
	                        ++index;
	                        comment += '\r';
	                    }
	                    if (ch !== '\r' || source[index] === '\n') {
	                        comment += source[index];
	                        ++lineNumber;
	                        ++index;
	                        lineStart = index;
	                        if (index >= length) {
	                            throwError({}, Messages.UnexpectedToken, 'ILLEGAL');
	                        }
	                    }
	                } else {
	                    ch = source[index++];
	                    if (index >= length) {
	                        throwError({}, Messages.UnexpectedToken, 'ILLEGAL');
	                    }
	                    comment += ch;
	                    if (ch === '*') {
	                        ch = source[index];
	                        if (ch === '/') {
	                            comment = comment.substr(0, comment.length - 1);
	                            blockComment = false;
	                            ++index;
	                            loc.end = {
	                                line: lineNumber,
	                                column: index - lineStart
	                            };
	                            addComment('Block', comment, start, index, loc);
	                            comment = '';
	                        }
	                    }
	                }
	            } else if (ch === '/') {
	                ch = source[index + 1];
	                if (ch === '/') {
	                    loc = {
	                        start: {
	                            line: lineNumber,
	                            column: index - lineStart
	                        }
	                    };
	                    start = index;
	                    index += 2;
	                    lineComment = true;
	                    if (index >= length) {
	                        loc.end = {
	                            line: lineNumber,
	                            column: index - lineStart
	                        };
	                        lineComment = false;
	                        addComment('Line', comment, start, index, loc);
	                    }
	                } else if (ch === '*') {
	                    start = index;
	                    index += 2;
	                    blockComment = true;
	                    loc = {
	                        start: {
	                            line: lineNumber,
	                            column: index - lineStart - 2
	                        }
	                    };
	                    if (index >= length) {
	                        throwError({}, Messages.UnexpectedToken, 'ILLEGAL');
	                    }
	                } else {
	                    break;
	                }
	            } else if (isWhiteSpace(ch.charCodeAt(0))) {
	                ++index;
	            } else if (isLineTerminator(ch.charCodeAt(0))) {
	                ++index;
	                if (ch ===  '\r' && source[index] === '\n') {
	                    ++index;
	                }
	                ++lineNumber;
	                lineStart = index;
	            } else {
	                break;
	            }
	        }
	    }

	    // 16 XJS

	    XHTMLEntities = {
	        quot: '\u0022',
	        amp: '&',
	        apos: '\u0027',
	        lt: '<',
	        gt: '>',
	        nbsp: '\u00A0',
	        iexcl: '\u00A1',
	        cent: '\u00A2',
	        pound: '\u00A3',
	        curren: '\u00A4',
	        yen: '\u00A5',
	        brvbar: '\u00A6',
	        sect: '\u00A7',
	        uml: '\u00A8',
	        copy: '\u00A9',
	        ordf: '\u00AA',
	        laquo: '\u00AB',
	        not: '\u00AC',
	        shy: '\u00AD',
	        reg: '\u00AE',
	        macr: '\u00AF',
	        deg: '\u00B0',
	        plusmn: '\u00B1',
	        sup2: '\u00B2',
	        sup3: '\u00B3',
	        acute: '\u00B4',
	        micro: '\u00B5',
	        para: '\u00B6',
	        middot: '\u00B7',
	        cedil: '\u00B8',
	        sup1: '\u00B9',
	        ordm: '\u00BA',
	        raquo: '\u00BB',
	        frac14: '\u00BC',
	        frac12: '\u00BD',
	        frac34: '\u00BE',
	        iquest: '\u00BF',
	        Agrave: '\u00C0',
	        Aacute: '\u00C1',
	        Acirc: '\u00C2',
	        Atilde: '\u00C3',
	        Auml: '\u00C4',
	        Aring: '\u00C5',
	        AElig: '\u00C6',
	        Ccedil: '\u00C7',
	        Egrave: '\u00C8',
	        Eacute: '\u00C9',
	        Ecirc: '\u00CA',
	        Euml: '\u00CB',
	        Igrave: '\u00CC',
	        Iacute: '\u00CD',
	        Icirc: '\u00CE',
	        Iuml: '\u00CF',
	        ETH: '\u00D0',
	        Ntilde: '\u00D1',
	        Ograve: '\u00D2',
	        Oacute: '\u00D3',
	        Ocirc: '\u00D4',
	        Otilde: '\u00D5',
	        Ouml: '\u00D6',
	        times: '\u00D7',
	        Oslash: '\u00D8',
	        Ugrave: '\u00D9',
	        Uacute: '\u00DA',
	        Ucirc: '\u00DB',
	        Uuml: '\u00DC',
	        Yacute: '\u00DD',
	        THORN: '\u00DE',
	        szlig: '\u00DF',
	        agrave: '\u00E0',
	        aacute: '\u00E1',
	        acirc: '\u00E2',
	        atilde: '\u00E3',
	        auml: '\u00E4',
	        aring: '\u00E5',
	        aelig: '\u00E6',
	        ccedil: '\u00E7',
	        egrave: '\u00E8',
	        eacute: '\u00E9',
	        ecirc: '\u00EA',
	        euml: '\u00EB',
	        igrave: '\u00EC',
	        iacute: '\u00ED',
	        icirc: '\u00EE',
	        iuml: '\u00EF',
	        eth: '\u00F0',
	        ntilde: '\u00F1',
	        ograve: '\u00F2',
	        oacute: '\u00F3',
	        ocirc: '\u00F4',
	        otilde: '\u00F5',
	        ouml: '\u00F6',
	        divide: '\u00F7',
	        oslash: '\u00F8',
	        ugrave: '\u00F9',
	        uacute: '\u00FA',
	        ucirc: '\u00FB',
	        uuml: '\u00FC',
	        yacute: '\u00FD',
	        thorn: '\u00FE',
	        yuml: '\u00FF',
	        OElig: '\u0152',
	        oelig: '\u0153',
	        Scaron: '\u0160',
	        scaron: '\u0161',
	        Yuml: '\u0178',
	        fnof: '\u0192',
	        circ: '\u02C6',
	        tilde: '\u02DC',
	        Alpha: '\u0391',
	        Beta: '\u0392',
	        Gamma: '\u0393',
	        Delta: '\u0394',
	        Epsilon: '\u0395',
	        Zeta: '\u0396',
	        Eta: '\u0397',
	        Theta: '\u0398',
	        Iota: '\u0399',
	        Kappa: '\u039A',
	        Lambda: '\u039B',
	        Mu: '\u039C',
	        Nu: '\u039D',
	        Xi: '\u039E',
	        Omicron: '\u039F',
	        Pi: '\u03A0',
	        Rho: '\u03A1',
	        Sigma: '\u03A3',
	        Tau: '\u03A4',
	        Upsilon: '\u03A5',
	        Phi: '\u03A6',
	        Chi: '\u03A7',
	        Psi: '\u03A8',
	        Omega: '\u03A9',
	        alpha: '\u03B1',
	        beta: '\u03B2',
	        gamma: '\u03B3',
	        delta: '\u03B4',
	        epsilon: '\u03B5',
	        zeta: '\u03B6',
	        eta: '\u03B7',
	        theta: '\u03B8',
	        iota: '\u03B9',
	        kappa: '\u03BA',
	        lambda: '\u03BB',
	        mu: '\u03BC',
	        nu: '\u03BD',
	        xi: '\u03BE',
	        omicron: '\u03BF',
	        pi: '\u03C0',
	        rho: '\u03C1',
	        sigmaf: '\u03C2',
	        sigma: '\u03C3',
	        tau: '\u03C4',
	        upsilon: '\u03C5',
	        phi: '\u03C6',
	        chi: '\u03C7',
	        psi: '\u03C8',
	        omega: '\u03C9',
	        thetasym: '\u03D1',
	        upsih: '\u03D2',
	        piv: '\u03D6',
	        ensp: '\u2002',
	        emsp: '\u2003',
	        thinsp: '\u2009',
	        zwnj: '\u200C',
	        zwj: '\u200D',
	        lrm: '\u200E',
	        rlm: '\u200F',
	        ndash: '\u2013',
	        mdash: '\u2014',
	        lsquo: '\u2018',
	        rsquo: '\u2019',
	        sbquo: '\u201A',
	        ldquo: '\u201C',
	        rdquo: '\u201D',
	        bdquo: '\u201E',
	        dagger: '\u2020',
	        Dagger: '\u2021',
	        bull: '\u2022',
	        hellip: '\u2026',
	        permil: '\u2030',
	        prime: '\u2032',
	        Prime: '\u2033',
	        lsaquo: '\u2039',
	        rsaquo: '\u203A',
	        oline: '\u203E',
	        frasl: '\u2044',
	        euro: '\u20AC',
	        image: '\u2111',
	        weierp: '\u2118',
	        real: '\u211C',
	        trade: '\u2122',
	        alefsym: '\u2135',
	        larr: '\u2190',
	        uarr: '\u2191',
	        rarr: '\u2192',
	        darr: '\u2193',
	        harr: '\u2194',
	        crarr: '\u21B5',
	        lArr: '\u21D0',
	        uArr: '\u21D1',
	        rArr: '\u21D2',
	        dArr: '\u21D3',
	        hArr: '\u21D4',
	        forall: '\u2200',
	        part: '\u2202',
	        exist: '\u2203',
	        empty: '\u2205',
	        nabla: '\u2207',
	        isin: '\u2208',
	        notin: '\u2209',
	        ni: '\u220B',
	        prod: '\u220F',
	        sum: '\u2211',
	        minus: '\u2212',
	        lowast: '\u2217',
	        radic: '\u221A',
	        prop: '\u221D',
	        infin: '\u221E',
	        ang: '\u2220',
	        and: '\u2227',
	        or: '\u2228',
	        cap: '\u2229',
	        cup: '\u222A',
	        'int': '\u222B',
	        there4: '\u2234',
	        sim: '\u223C',
	        cong: '\u2245',
	        asymp: '\u2248',
	        ne: '\u2260',
	        equiv: '\u2261',
	        le: '\u2264',
	        ge: '\u2265',
	        sub: '\u2282',
	        sup: '\u2283',
	        nsub: '\u2284',
	        sube: '\u2286',
	        supe: '\u2287',
	        oplus: '\u2295',
	        otimes: '\u2297',
	        perp: '\u22A5',
	        sdot: '\u22C5',
	        lceil: '\u2308',
	        rceil: '\u2309',
	        lfloor: '\u230A',
	        rfloor: '\u230B',
	        lang: '\u2329',
	        rang: '\u232A',
	        loz: '\u25CA',
	        spades: '\u2660',
	        clubs: '\u2663',
	        hearts: '\u2665',
	        diams: '\u2666'
	    };

	    function getQualifiedXJSName(object) {
	        if (object.type === Syntax.XJSIdentifier) {
	            return object.name;
	        }
	        if (object.type === Syntax.XJSNamespacedName) {
	            return object.namespace.name + ':' + object.name.name;
	        }
	        /* istanbul ignore else */
	        if (object.type === Syntax.XJSMemberExpression) {
	            return (
	                getQualifiedXJSName(object.object) + '.' +
	                getQualifiedXJSName(object.property)
	            );
	        }
	        /* istanbul ignore next */
	        throwUnexpected(object);
	    }

	    function isXJSIdentifierStart(ch) {
	        // exclude backslash (\)
	        return (ch !== 92) && isIdentifierStart(ch);
	    }

	    function isXJSIdentifierPart(ch) {
	        // exclude backslash (\) and add hyphen (-)
	        return (ch !== 92) && (ch === 45 || isIdentifierPart(ch));
	    }

	    function scanXJSIdentifier() {
	        var ch, start, value = '';

	        start = index;
	        while (index < length) {
	            ch = source.charCodeAt(index);
	            if (!isXJSIdentifierPart(ch)) {
	                break;
	            }
	            value += source[index++];
	        }

	        return {
	            type: Token.XJSIdentifier,
	            value: value,
	            lineNumber: lineNumber,
	            lineStart: lineStart,
	            range: [start, index]
	        };
	    }

	    function scanXJSEntity() {
	        var ch, str = '', start = index, count = 0, code;
	        ch = source[index];
	        assert(ch === '&', 'Entity must start with an ampersand');
	        index++;
	        while (index < length && count++ < 10) {
	            ch = source[index++];
	            if (ch === ';') {
	                break;
	            }
	            str += ch;
	        }

	        // Well-formed entity (ending was found).
	        if (ch === ';') {
	            // Numeric entity.
	            if (str[0] === '#') {
	                if (str[1] === 'x') {
	                    code = +('0' + str.substr(1));
	                } else {
	                    // Removing leading zeros in order to avoid treating as octal in old browsers.
	                    code = +str.substr(1).replace(Regex.LeadingZeros, '');
	                }

	                if (!isNaN(code)) {
	                    return String.fromCharCode(code);
	                }
	            /* istanbul ignore else */
	            } else if (XHTMLEntities[str]) {
	                return XHTMLEntities[str];
	            }
	        }

	        // Treat non-entity sequences as regular text.
	        index = start + 1;
	        return '&';
	    }

	    function scanXJSText(stopChars) {
	        var ch, str = '', start;
	        start = index;
	        while (index < length) {
	            ch = source[index];
	            if (stopChars.indexOf(ch) !== -1) {
	                break;
	            }
	            if (ch === '&') {
	                str += scanXJSEntity();
	            } else {
	                index++;
	                if (ch === '\r' && source[index] === '\n') {
	                    str += ch;
	                    ch = source[index];
	                    index++;
	                }
	                if (isLineTerminator(ch.charCodeAt(0))) {
	                    ++lineNumber;
	                    lineStart = index;
	                }
	                str += ch;
	            }
	        }
	        return {
	            type: Token.XJSText,
	            value: str,
	            lineNumber: lineNumber,
	            lineStart: lineStart,
	            range: [start, index]
	        };
	    }

	    function scanXJSStringLiteral() {
	        var innerToken, quote, start;

	        quote = source[index];
	        assert((quote === '\'' || quote === '"'),
	            'String literal must starts with a quote');

	        start = index;
	        ++index;

	        innerToken = scanXJSText([quote]);

	        if (quote !== source[index]) {
	            throwError({}, Messages.UnexpectedToken, 'ILLEGAL');
	        }

	        ++index;

	        innerToken.range = [start, index];

	        return innerToken;
	    }

	    /**
	     * Between XJS opening and closing tags (e.g. <foo>HERE</foo>), anything that
	     * is not another XJS tag and is not an expression wrapped by {} is text.
	     */
	    function advanceXJSChild() {
	        var ch = source.charCodeAt(index);

	        // { (123) and < (60)
	        if (ch !== 123 && ch !== 60) {
	            return scanXJSText(['<', '{']);
	        }

	        return scanPunctuator();
	    }

	    function parseXJSIdentifier() {
	        var token, marker = markerCreate();

	        if (lookahead.type !== Token.XJSIdentifier) {
	            throwUnexpected(lookahead);
	        }

	        token = lex();
	        return markerApply(marker, delegate.createXJSIdentifier(token.value));
	    }

	    function parseXJSNamespacedName() {
	        var namespace, name, marker = markerCreate();

	        namespace = parseXJSIdentifier();
	        expect(':');
	        name = parseXJSIdentifier();

	        return markerApply(marker, delegate.createXJSNamespacedName(namespace, name));
	    }

	    function parseXJSMemberExpression() {
	        var marker = markerCreate(),
	            expr = parseXJSIdentifier();

	        while (match('.')) {
	            lex();
	            expr = markerApply(marker, delegate.createXJSMemberExpression(expr, parseXJSIdentifier()));
	        }

	        return expr;
	    }

	    function parseXJSElementName() {
	        if (lookahead2().value === ':') {
	            return parseXJSNamespacedName();
	        }
	        if (lookahead2().value === '.') {
	            return parseXJSMemberExpression();
	        }

	        return parseXJSIdentifier();
	    }

	    function parseXJSAttributeName() {
	        if (lookahead2().value === ':') {
	            return parseXJSNamespacedName();
	        }

	        return parseXJSIdentifier();
	    }

	    function parseXJSAttributeValue() {
	        var value, marker;
	        if (match('{')) {
	            value = parseXJSExpressionContainer();
	            if (value.expression.type === Syntax.XJSEmptyExpression) {
	                throwError(
	                    value,
	                    'XJS attributes must only be assigned a non-empty ' +
	                        'expression'
	                );
	            }
	        } else if (match('<')) {
	            value = parseXJSElement();
	        } else if (lookahead.type === Token.XJSText) {
	            marker = markerCreate();
	            value = markerApply(marker, delegate.createLiteral(lex()));
	        } else {
	            throwError({}, Messages.InvalidXJSAttributeValue);
	        }
	        return value;
	    }

	    function parseXJSEmptyExpression() {
	        var marker = markerCreatePreserveWhitespace();
	        while (source.charAt(index) !== '}') {
	            index++;
	        }
	        return markerApply(marker, delegate.createXJSEmptyExpression());
	    }

	    function parseXJSExpressionContainer() {
	        var expression, origInXJSChild, origInXJSTag, marker = markerCreate();

	        origInXJSChild = state.inXJSChild;
	        origInXJSTag = state.inXJSTag;
	        state.inXJSChild = false;
	        state.inXJSTag = false;

	        expect('{');

	        if (match('}')) {
	            expression = parseXJSEmptyExpression();
	        } else {
	            expression = parseExpression();
	        }

	        state.inXJSChild = origInXJSChild;
	        state.inXJSTag = origInXJSTag;

	        expect('}');

	        return markerApply(marker, delegate.createXJSExpressionContainer(expression));
	    }

	    function parseXJSSpreadAttribute() {
	        var expression, origInXJSChild, origInXJSTag, marker = markerCreate();

	        origInXJSChild = state.inXJSChild;
	        origInXJSTag = state.inXJSTag;
	        state.inXJSChild = false;
	        state.inXJSTag = false;

	        expect('{');
	        expect('...');

	        expression = parseAssignmentExpression();

	        state.inXJSChild = origInXJSChild;
	        state.inXJSTag = origInXJSTag;

	        expect('}');

	        return markerApply(marker, delegate.createXJSSpreadAttribute(expression));
	    }

	    function parseXJSAttribute() {
	        var name, marker;

	        if (match('{')) {
	            return parseXJSSpreadAttribute();
	        }

	        marker = markerCreate();

	        name = parseXJSAttributeName();

	        // HTML empty attribute
	        if (match('=')) {
	            lex();
	            return markerApply(marker, delegate.createXJSAttribute(name, parseXJSAttributeValue()));
	        }

	        return markerApply(marker, delegate.createXJSAttribute(name));
	    }

	    function parseXJSChild() {
	        var token, marker;
	        if (match('{')) {
	            token = parseXJSExpressionContainer();
	        } else if (lookahead.type === Token.XJSText) {
	            marker = markerCreatePreserveWhitespace();
	            token = markerApply(marker, delegate.createLiteral(lex()));
	        } else {
	            token = parseXJSElement();
	        }
	        return token;
	    }

	    function parseXJSClosingElement() {
	        var name, origInXJSChild, origInXJSTag, marker = markerCreate();
	        origInXJSChild = state.inXJSChild;
	        origInXJSTag = state.inXJSTag;
	        state.inXJSChild = false;
	        state.inXJSTag = true;
	        expect('<');
	        expect('/');
	        name = parseXJSElementName();
	        // Because advance() (called by lex() called by expect()) expects there
	        // to be a valid token after >, it needs to know whether to look for a
	        // standard JS token or an XJS text node
	        state.inXJSChild = origInXJSChild;
	        state.inXJSTag = origInXJSTag;
	        expect('>');
	        return markerApply(marker, delegate.createXJSClosingElement(name));
	    }

	    function parseXJSOpeningElement() {
	        var name, attribute, attributes = [], selfClosing = false, origInXJSChild, origInXJSTag, marker = markerCreate();

	        origInXJSChild = state.inXJSChild;
	        origInXJSTag = state.inXJSTag;
	        state.inXJSChild = false;
	        state.inXJSTag = true;

	        expect('<');

	        name = parseXJSElementName();

	        while (index < length &&
	                lookahead.value !== '/' &&
	                lookahead.value !== '>') {
	            attributes.push(parseXJSAttribute());
	        }

	        state.inXJSTag = origInXJSTag;

	        if (lookahead.value === '/') {
	            expect('/');
	            // Because advance() (called by lex() called by expect()) expects
	            // there to be a valid token after >, it needs to know whether to
	            // look for a standard JS token or an XJS text node
	            state.inXJSChild = origInXJSChild;
	            expect('>');
	            selfClosing = true;
	        } else {
	            state.inXJSChild = true;
	            expect('>');
	        }
	        return markerApply(marker, delegate.createXJSOpeningElement(name, attributes, selfClosing));
	    }

	    function parseXJSElement() {
	        var openingElement, closingElement = null, children = [], origInXJSChild, origInXJSTag, marker = markerCreate();

	        origInXJSChild = state.inXJSChild;
	        origInXJSTag = state.inXJSTag;
	        openingElement = parseXJSOpeningElement();

	        if (!openingElement.selfClosing) {
	            while (index < length) {
	                state.inXJSChild = false; // Call lookahead2() with inXJSChild = false because </ should not be considered in the child
	                if (lookahead.value === '<' && lookahead2().value === '/') {
	                    break;
	                }
	                state.inXJSChild = true;
	                children.push(parseXJSChild());
	            }
	            state.inXJSChild = origInXJSChild;
	            state.inXJSTag = origInXJSTag;
	            closingElement = parseXJSClosingElement();
	            if (getQualifiedXJSName(closingElement.name) !== getQualifiedXJSName(openingElement.name)) {
	                throwError({}, Messages.ExpectedXJSClosingTag, getQualifiedXJSName(openingElement.name));
	            }
	        }

	        // When (erroneously) writing two adjacent tags like
	        //
	        //     var x = <div>one</div><div>two</div>;
	        //
	        // the default error message is a bit incomprehensible. Since it's
	        // rarely (never?) useful to write a less-than sign after an XJS
	        // element, we disallow it here in the parser in order to provide a
	        // better error message. (In the rare case that the less-than operator
	        // was intended, the left tag can be wrapped in parentheses.)
	        if (!origInXJSChild && match('<')) {
	            throwError(lookahead, Messages.AdjacentXJSElements);
	        }

	        return markerApply(marker, delegate.createXJSElement(openingElement, closingElement, children));
	    }

	    function parseTypeAlias() {
	        var id, marker = markerCreate(), typeParameters = null, right;
	        expectContextualKeyword('type');
	        id = parseVariableIdentifier();
	        if (match('<')) {
	            typeParameters = parseTypeParameterDeclaration();
	        }
	        expect('=');
	        right = parseType();
	        consumeSemicolon();
	        return markerApply(marker, delegate.createTypeAlias(id, typeParameters, right));
	    }

	    function parseInterfaceExtends() {
	        var marker = markerCreate(), id, typeParameters = null;

	        id = parseVariableIdentifier();
	        if (match('<')) {
	            typeParameters = parseTypeParameterInstantiation();
	        }

	        return markerApply(marker, delegate.createInterfaceExtends(
	            id,
	            typeParameters
	        ));
	    }

	    function parseInterfaceish(marker, allowStatic) {
	        var body, bodyMarker, extended = [], id,
	            typeParameters = null;

	        id = parseVariableIdentifier();
	        if (match('<')) {
	            typeParameters = parseTypeParameterDeclaration();
	        }

	        if (matchKeyword('extends')) {
	            expectKeyword('extends');

	            while (index < length) {
	                extended.push(parseInterfaceExtends());
	                if (!match(',')) {
	                    break;
	                }
	                expect(',');
	            }
	        }

	        bodyMarker = markerCreate();
	        body = markerApply(bodyMarker, parseObjectType(allowStatic));

	        return markerApply(marker, delegate.createInterface(
	            id,
	            typeParameters,
	            body,
	            extended
	        ));
	    }

	    function parseInterface() {
	        var body, bodyMarker, extended = [], id, marker = markerCreate(),
	            typeParameters = null;

	        expectContextualKeyword('interface');
	        return parseInterfaceish(marker, /* allowStatic */false);
	    }

	    function parseDeclareClass() {
	        var marker = markerCreate(), ret;
	        expectContextualKeyword('declare');
	        expectKeyword('class');

	        ret = parseInterfaceish(marker, /* allowStatic */true);
	        ret.type = Syntax.DeclareClass;
	        return ret;
	    }

	    function parseDeclareFunction() {
	        var id, idMarker,
	            marker = markerCreate(), params, returnType, rest, tmp,
	            typeParameters = null, value, valueMarker;

	        expectContextualKeyword('declare');
	        expectKeyword('function');
	        idMarker = markerCreate();
	        id = parseVariableIdentifier();

	        valueMarker = markerCreate();
	        if (match('<')) {
	            typeParameters = parseTypeParameterDeclaration();
	        }
	        expect('(');
	        tmp = parseFunctionTypeParams();
	        params = tmp.params;
	        rest = tmp.rest;
	        expect(')');

	        expect(':');
	        returnType = parseType();

	        value = markerApply(valueMarker, delegate.createFunctionTypeAnnotation(
	            params,
	            returnType,
	            rest,
	            typeParameters
	        ));

	        id.typeAnnotation = markerApply(valueMarker, delegate.createTypeAnnotation(
	            value
	        ));
	        markerApply(idMarker, id);

	        consumeSemicolon();

	        return markerApply(marker, delegate.createDeclareFunction(
	            id
	        ));
	    }

	    function parseDeclareVariable() {
	        var id, marker = markerCreate();
	        expectContextualKeyword('declare');
	        expectKeyword('var');
	        id = parseTypeAnnotatableIdentifier();

	        consumeSemicolon();

	        return markerApply(marker, delegate.createDeclareVariable(
	            id
	        ));
	    }

	    function parseDeclareModule() {
	        var body = [], bodyMarker, id, idMarker, marker = markerCreate(), token;
	        expectContextualKeyword('declare');
	        expectContextualKeyword('module');

	        if (lookahead.type === Token.StringLiteral) {
	            if (strict && lookahead.octal) {
	                throwErrorTolerant(lookahead, Messages.StrictOctalLiteral);
	            }
	            idMarker = markerCreate();
	            id = markerApply(idMarker, delegate.createLiteral(lex()));
	        } else {
	            id = parseVariableIdentifier();
	        }

	        bodyMarker = markerCreate();
	        expect('{');
	        while (index < length && !match('}')) {
	            token = lookahead2();
	            switch (token.value) {
	            case 'class':
	                body.push(parseDeclareClass());
	                break;
	            case 'function':
	                body.push(parseDeclareFunction());
	                break;
	            case 'var':
	                body.push(parseDeclareVariable());
	                break;
	            default:
	                throwUnexpected(lookahead);
	            }
	        }
	        expect('}');

	        return markerApply(marker, delegate.createDeclareModule(
	            id,
	            markerApply(bodyMarker, delegate.createBlockStatement(body))
	        ));
	    }

	    function collectToken() {
	        var start, loc, token, range, value, entry;

	        /* istanbul ignore else */
	        if (!state.inXJSChild) {
	            skipComment();
	        }

	        start = index;
	        loc = {
	            start: {
	                line: lineNumber,
	                column: index - lineStart
	            }
	        };

	        token = extra.advance();
	        loc.end = {
	            line: lineNumber,
	            column: index - lineStart
	        };

	        if (token.type !== Token.EOF) {
	            range = [token.range[0], token.range[1]];
	            value = source.slice(token.range[0], token.range[1]);
	            entry = {
	                type: TokenName[token.type],
	                value: value,
	                range: range,
	                loc: loc
	            };
	            if (token.regex) {
	                entry.regex = {
	                    pattern: token.regex.pattern,
	                    flags: token.regex.flags
	                };
	            }
	            extra.tokens.push(entry);
	        }

	        return token;
	    }

	    function collectRegex() {
	        var pos, loc, regex, token;

	        skipComment();

	        pos = index;
	        loc = {
	            start: {
	                line: lineNumber,
	                column: index - lineStart
	            }
	        };

	        regex = extra.scanRegExp();
	        loc.end = {
	            line: lineNumber,
	            column: index - lineStart
	        };

	        if (!extra.tokenize) {
	            /* istanbul ignore next */
	            // Pop the previous token, which is likely '/' or '/='
	            if (extra.tokens.length > 0) {
	                token = extra.tokens[extra.tokens.length - 1];
	                if (token.range[0] === pos && token.type === 'Punctuator') {
	                    if (token.value === '/' || token.value === '/=') {
	                        extra.tokens.pop();
	                    }
	                }
	            }

	            extra.tokens.push({
	                type: 'RegularExpression',
	                value: regex.literal,
	                regex: regex.regex,
	                range: [pos, index],
	                loc: loc
	            });
	        }

	        return regex;
	    }

	    function filterTokenLocation() {
	        var i, entry, token, tokens = [];

	        for (i = 0; i < extra.tokens.length; ++i) {
	            entry = extra.tokens[i];
	            token = {
	                type: entry.type,
	                value: entry.value
	            };
	            if (entry.regex) {
	                token.regex = {
	                    pattern: entry.regex.pattern,
	                    flags: entry.regex.flags
	                };
	            }
	            if (extra.range) {
	                token.range = entry.range;
	            }
	            if (extra.loc) {
	                token.loc = entry.loc;
	            }
	            tokens.push(token);
	        }

	        extra.tokens = tokens;
	    }

	    function patch() {
	        if (extra.comments) {
	            extra.skipComment = skipComment;
	            skipComment = scanComment;
	        }

	        if (typeof extra.tokens !== 'undefined') {
	            extra.advance = advance;
	            extra.scanRegExp = scanRegExp;

	            advance = collectToken;
	            scanRegExp = collectRegex;
	        }
	    }

	    function unpatch() {
	        if (typeof extra.skipComment === 'function') {
	            skipComment = extra.skipComment;
	        }

	        if (typeof extra.scanRegExp === 'function') {
	            advance = extra.advance;
	            scanRegExp = extra.scanRegExp;
	        }
	    }

	    // This is used to modify the delegate.

	    function extend(object, properties) {
	        var entry, result = {};

	        for (entry in object) {
	            /* istanbul ignore else */
	            if (object.hasOwnProperty(entry)) {
	                result[entry] = object[entry];
	            }
	        }

	        for (entry in properties) {
	            /* istanbul ignore else */
	            if (properties.hasOwnProperty(entry)) {
	                result[entry] = properties[entry];
	            }
	        }

	        return result;
	    }

	    function tokenize(code, options) {
	        var toString,
	            token,
	            tokens;

	        toString = String;
	        if (typeof code !== 'string' && !(code instanceof String)) {
	            code = toString(code);
	        }

	        delegate = SyntaxTreeDelegate;
	        source = code;
	        index = 0;
	        lineNumber = (source.length > 0) ? 1 : 0;
	        lineStart = 0;
	        length = source.length;
	        lookahead = null;
	        state = {
	            allowKeyword: true,
	            allowIn: true,
	            labelSet: new StringMap(),
	            inFunctionBody: false,
	            inIteration: false,
	            inSwitch: false,
	            lastCommentStart: -1
	        };

	        extra = {};

	        // Options matching.
	        options = options || {};

	        // Of course we collect tokens here.
	        options.tokens = true;
	        extra.tokens = [];
	        extra.tokenize = true;
	        // The following two fields are necessary to compute the Regex tokens.
	        extra.openParenToken = -1;
	        extra.openCurlyToken = -1;

	        extra.range = (typeof options.range === 'boolean') && options.range;
	        extra.loc = (typeof options.loc === 'boolean') && options.loc;

	        if (typeof options.comment === 'boolean' && options.comment) {
	            extra.comments = [];
	        }
	        if (typeof options.tolerant === 'boolean' && options.tolerant) {
	            extra.errors = [];
	        }

	        patch();

	        try {
	            peek();
	            if (lookahead.type === Token.EOF) {
	                return extra.tokens;
	            }

	            token = lex();
	            while (lookahead.type !== Token.EOF) {
	                try {
	                    token = lex();
	                } catch (lexError) {
	                    token = lookahead;
	                    if (extra.errors) {
	                        extra.errors.push(lexError);
	                        // We have to break on the first error
	                        // to avoid infinite loops.
	                        break;
	                    } else {
	                        throw lexError;
	                    }
	                }
	            }

	            filterTokenLocation();
	            tokens = extra.tokens;
	            if (typeof extra.comments !== 'undefined') {
	                tokens.comments = extra.comments;
	            }
	            if (typeof extra.errors !== 'undefined') {
	                tokens.errors = extra.errors;
	            }
	        } catch (e) {
	            throw e;
	        } finally {
	            unpatch();
	            extra = {};
	        }
	        return tokens;
	    }

	    function parse(code, options) {
	        var program, toString;

	        toString = String;
	        if (typeof code !== 'string' && !(code instanceof String)) {
	            code = toString(code);
	        }

	        delegate = SyntaxTreeDelegate;
	        source = code;
	        index = 0;
	        lineNumber = (source.length > 0) ? 1 : 0;
	        lineStart = 0;
	        length = source.length;
	        lookahead = null;
	        state = {
	            allowKeyword: false,
	            allowIn: true,
	            labelSet: new StringMap(),
	            parenthesizedCount: 0,
	            inFunctionBody: false,
	            inIteration: false,
	            inSwitch: false,
	            inXJSChild: false,
	            inXJSTag: false,
	            inType: false,
	            lastCommentStart: -1,
	            yieldAllowed: false,
	            awaitAllowed: false
	        };

	        extra = {};
	        if (typeof options !== 'undefined') {
	            extra.range = (typeof options.range === 'boolean') && options.range;
	            extra.loc = (typeof options.loc === 'boolean') && options.loc;
	            extra.attachComment = (typeof options.attachComment === 'boolean') && options.attachComment;

	            if (extra.loc && options.source !== null && options.source !== undefined) {
	                delegate = extend(delegate, {
	                    'postProcess': function (node) {
	                        node.loc.source = toString(options.source);
	                        return node;
	                    }
	                });
	            }

	            if (options.sourceType === 'module') {
	                extra.isModule = true;
	            }
	            if (typeof options.tokens === 'boolean' && options.tokens) {
	                extra.tokens = [];
	            }
	            if (typeof options.comment === 'boolean' && options.comment) {
	                extra.comments = [];
	            }
	            if (typeof options.tolerant === 'boolean' && options.tolerant) {
	                extra.errors = [];
	            }
	            if (extra.attachComment) {
	                extra.range = true;
	                extra.comments = [];
	                extra.bottomRightStack = [];
	                extra.trailingComments = [];
	                extra.leadingComments = [];
	            }
	        }

	        patch();
	        try {
	            program = parseProgram();
	            if (typeof extra.comments !== 'undefined') {
	                program.comments = extra.comments;
	            }
	            if (typeof extra.tokens !== 'undefined') {
	                filterTokenLocation();
	                program.tokens = extra.tokens;
	            }
	            if (typeof extra.errors !== 'undefined') {
	                program.errors = extra.errors;
	            }
	        } catch (e) {
	            throw e;
	        } finally {
	            unpatch();
	            extra = {};
	        }

	        return program;
	    }

	    // Sync with *.json manifests.
	    exports.version = '10001.1.0-dev-harmony-fb';

	    exports.tokenize = tokenize;

	    exports.parse = parse;

	    // Deep copy.
	   /* istanbul ignore next */
	    exports.Syntax = (function () {
	        var name, types = {};

	        if (typeof Object.create === 'function') {
	            types = Object.create(null);
	        }

	        for (name in Syntax) {
	            if (Syntax.hasOwnProperty(name)) {
	                types[name] = Syntax[name];
	            }
	        }

	        if (typeof Object.freeze === 'function') {
	            Object.freeze(types);
	        }

	        return types;
	    }());

	}));
	/* vim: set sw=4 ts=4 et tw=80 : */


/***/ },
/* 55 */
/***/ function(module, exports) {

	"use strict";

	var originalObject = Object;
	var originalDefProp = Object.defineProperty;
	var originalCreate = Object.create;

	function defProp(obj, name, value) {
	  if (originalDefProp) try {
	    originalDefProp.call(originalObject, obj, name, { value: value });
	  } catch (definePropertyIsBrokenInIE8) {
	    obj[name] = value;
	  } else {
	    obj[name] = value;
	  }
	}

	// For functions that will be invoked using .call or .apply, we need to
	// define those methods on the function objects themselves, rather than
	// inheriting them from Function.prototype, so that a malicious or clumsy
	// third party cannot interfere with the functionality of this module by
	// redefining Function.prototype.call or .apply.
	function makeSafeToCall(fun) {
	  if (fun) {
	    defProp(fun, "call", fun.call);
	    defProp(fun, "apply", fun.apply);
	  }
	  return fun;
	}

	makeSafeToCall(originalDefProp);
	makeSafeToCall(originalCreate);

	var hasOwn = makeSafeToCall(Object.prototype.hasOwnProperty);
	var numToStr = makeSafeToCall(Number.prototype.toString);
	var strSlice = makeSafeToCall(String.prototype.slice);

	var cloner = function(){};
	function create(prototype) {
	  if (originalCreate) {
	    return originalCreate.call(originalObject, prototype);
	  }
	  cloner.prototype = prototype || null;
	  return new cloner;
	}

	var rand = Math.random;
	var uniqueKeys = create(null);

	function makeUniqueKey() {
	  // Collisions are highly unlikely, but this module is in the business of
	  // making guarantees rather than safe bets.
	  do var uniqueKey = internString(strSlice.call(numToStr.call(rand(), 36), 2));
	  while (hasOwn.call(uniqueKeys, uniqueKey));
	  return uniqueKeys[uniqueKey] = uniqueKey;
	}

	function internString(str) {
	  var obj = {};
	  obj[str] = true;
	  return Object.keys(obj)[0];
	}

	// External users might find this function useful, but it is not necessary
	// for the typical use of this module.
	defProp(exports, "makeUniqueKey", makeUniqueKey);

	// Object.getOwnPropertyNames is the only way to enumerate non-enumerable
	// properties, so if we wrap it to ignore our secret keys, there should be
	// no way (except guessing) to access those properties.
	var originalGetOPNs = Object.getOwnPropertyNames;
	Object.getOwnPropertyNames = function getOwnPropertyNames(object) {
	  for (var names = originalGetOPNs(object),
	           src = 0,
	           dst = 0,
	           len = names.length;
	       src < len;
	       ++src) {
	    if (!hasOwn.call(uniqueKeys, names[src])) {
	      if (src > dst) {
	        names[dst] = names[src];
	      }
	      ++dst;
	    }
	  }
	  names.length = dst;
	  return names;
	};

	function defaultCreatorFn(object) {
	  return create(null);
	}

	function makeAccessor(secretCreatorFn) {
	  var brand = makeUniqueKey();
	  var passkey = create(null);

	  secretCreatorFn = secretCreatorFn || defaultCreatorFn;

	  function register(object) {
	    var secret; // Created lazily.

	    function vault(key, forget) {
	      // Only code that has access to the passkey can retrieve (or forget)
	      // the secret object.
	      if (key === passkey) {
	        return forget
	          ? secret = null
	          : secret || (secret = secretCreatorFn(object));
	      }
	    }

	    defProp(object, brand, vault);
	  }

	  function accessor(object) {
	    if (!hasOwn.call(object, brand))
	      register(object);
	    return object[brand](passkey);
	  }

	  accessor.forget = function(object) {
	    if (hasOwn.call(object, brand))
	      object[brand](passkey, true);
	  };

	  return accessor;
	}

	defProp(exports, "makeAccessor", makeAccessor);


/***/ },
/* 56 */
/***/ function(module, exports, __webpack_require__) {

	var assert = __webpack_require__(27);
	var getFieldValue = __webpack_require__(24).getFieldValue;
	var sourceMap = __webpack_require__(43);
	var SourceMapConsumer = sourceMap.SourceMapConsumer;
	var SourceMapGenerator = sourceMap.SourceMapGenerator;
	var hasOwn = Object.prototype.hasOwnProperty;

	function getUnionOfKeys() {
	    var result = {};
	    var argc = arguments.length;
	    for (var i = 0; i < argc; ++i) {
	        var keys = Object.keys(arguments[i]);
	        var keyCount = keys.length;
	        for (var j = 0; j < keyCount; ++j) {
	            result[keys[j]] = true;
	        }
	    }
	    return result;
	}
	exports.getUnionOfKeys = getUnionOfKeys;

	function comparePos(pos1, pos2) {
	    return (pos1.line - pos2.line) || (pos1.column - pos2.column);
	}
	exports.comparePos = comparePos;

	exports.composeSourceMaps = function(formerMap, latterMap) {
	    if (formerMap) {
	        if (!latterMap) {
	            return formerMap;
	        }
	    } else {
	        return latterMap || null;
	    }

	    var smcFormer = new SourceMapConsumer(formerMap);
	    var smcLatter = new SourceMapConsumer(latterMap);
	    var smg = new SourceMapGenerator({
	        file: latterMap.file,
	        sourceRoot: latterMap.sourceRoot
	    });

	    var sourcesToContents = {};

	    smcLatter.eachMapping(function(mapping) {
	        var origPos = smcFormer.originalPositionFor({
	            line: mapping.originalLine,
	            column: mapping.originalColumn
	        });

	        var sourceName = origPos.source;
	        if (sourceName === null) {
	            return;
	        }

	        smg.addMapping({
	            source: sourceName,
	            original: {
	                line: origPos.line,
	                column: origPos.column
	            },
	            generated: {
	                line: mapping.generatedLine,
	                column: mapping.generatedColumn
	            },
	            name: mapping.name
	        });

	        var sourceContent = smcFormer.sourceContentFor(sourceName);
	        if (sourceContent && !hasOwn.call(sourcesToContents, sourceName)) {
	            sourcesToContents[sourceName] = sourceContent;
	            smg.setSourceContent(sourceName, sourceContent);
	        }
	    });

	    return smg.toJSON();
	};


/***/ },
/* 57 */
/***/ function(module, exports, __webpack_require__) {

	var assert = __webpack_require__(27);
	var types = __webpack_require__(24);
	var isString = types.builtInTypes.string;
	var isNumber = types.builtInTypes.number;
	var SourceLocation = types.namedTypes.SourceLocation;
	var Position = types.namedTypes.Position;
	var linesModule = __webpack_require__(42);
	var comparePos = __webpack_require__(56).comparePos;

	function Mapping(sourceLines, sourceLoc, targetLoc) {
	    assert.ok(this instanceof Mapping);
	    assert.ok(sourceLines instanceof linesModule.Lines);
	    SourceLocation.assert(sourceLoc);

	    if (targetLoc) {
	        // In certain cases it's possible for targetLoc.{start,end}.column
	        // values to be negative, which technically makes them no longer
	        // valid SourceLocation nodes, so we need to be more forgiving.
	        assert.ok(
	            isNumber.check(targetLoc.start.line) &&
	            isNumber.check(targetLoc.start.column) &&
	            isNumber.check(targetLoc.end.line) &&
	            isNumber.check(targetLoc.end.column)
	        );
	    } else {
	        // Assume identity mapping if no targetLoc specified.
	        targetLoc = sourceLoc;
	    }

	    Object.defineProperties(this, {
	        sourceLines: { value: sourceLines },
	        sourceLoc: { value: sourceLoc },
	        targetLoc: { value: targetLoc }
	    });
	}

	var Mp = Mapping.prototype;
	module.exports = Mapping;

	Mp.slice = function(lines, start, end) {
	    assert.ok(lines instanceof linesModule.Lines);
	    Position.assert(start);

	    if (end) {
	        Position.assert(end);
	    } else {
	        end = lines.lastPos();
	    }

	    var sourceLines = this.sourceLines;
	    var sourceLoc = this.sourceLoc;
	    var targetLoc = this.targetLoc;

	    function skip(name) {
	        var sourceFromPos = sourceLoc[name];
	        var targetFromPos = targetLoc[name];
	        var targetToPos = start;

	        if (name === "end") {
	            targetToPos = end;
	        } else {
	            assert.strictEqual(name, "start");
	        }

	        return skipChars(
	            sourceLines, sourceFromPos,
	            lines, targetFromPos, targetToPos
	        );
	    }

	    if (comparePos(start, targetLoc.start) <= 0) {
	        if (comparePos(targetLoc.end, end) <= 0) {
	            targetLoc = {
	                start: subtractPos(targetLoc.start, start.line, start.column),
	                end: subtractPos(targetLoc.end, start.line, start.column)
	            };

	            // The sourceLoc can stay the same because the contents of the
	            // targetLoc have not changed.

	        } else if (comparePos(end, targetLoc.start) <= 0) {
	            return null;

	        } else {
	            sourceLoc = {
	                start: sourceLoc.start,
	                end: skip("end")
	            };

	            targetLoc = {
	                start: subtractPos(targetLoc.start, start.line, start.column),
	                end: subtractPos(end, start.line, start.column)
	            };
	        }

	    } else {
	        if (comparePos(targetLoc.end, start) <= 0) {
	            return null;
	        }

	        if (comparePos(targetLoc.end, end) <= 0) {
	            sourceLoc = {
	                start: skip("start"),
	                end: sourceLoc.end
	            };

	            targetLoc = {
	                // Same as subtractPos(start, start.line, start.column):
	                start: { line: 1, column: 0 },
	                end: subtractPos(targetLoc.end, start.line, start.column)
	            };

	        } else {
	            sourceLoc = {
	                start: skip("start"),
	                end: skip("end")
	            };

	            targetLoc = {
	                // Same as subtractPos(start, start.line, start.column):
	                start: { line: 1, column: 0 },
	                end: subtractPos(end, start.line, start.column)
	            };
	        }
	    }

	    return new Mapping(this.sourceLines, sourceLoc, targetLoc);
	};

	Mp.add = function(line, column) {
	    return new Mapping(this.sourceLines, this.sourceLoc, {
	        start: addPos(this.targetLoc.start, line, column),
	        end: addPos(this.targetLoc.end, line, column)
	    });
	};

	function addPos(toPos, line, column) {
	    return {
	        line: toPos.line + line - 1,
	        column: (toPos.line === 1)
	            ? toPos.column + column
	            : toPos.column
	    };
	}

	Mp.subtract = function(line, column) {
	    return new Mapping(this.sourceLines, this.sourceLoc, {
	        start: subtractPos(this.targetLoc.start, line, column),
	        end: subtractPos(this.targetLoc.end, line, column)
	    });
	};

	function subtractPos(fromPos, line, column) {
	    return {
	        line: fromPos.line - line + 1,
	        column: (fromPos.line === line)
	            ? fromPos.column - column
	            : fromPos.column
	    };
	}

	Mp.indent = function(by, skipFirstLine, noNegativeColumns) {
	    if (by === 0) {
	        return this;
	    }

	    var targetLoc = this.targetLoc;
	    var startLine = targetLoc.start.line;
	    var endLine = targetLoc.end.line;

	    if (skipFirstLine && startLine === 1 && endLine === 1) {
	        return this;
	    }

	    targetLoc = {
	        start: targetLoc.start,
	        end: targetLoc.end
	    };

	    if (!skipFirstLine || startLine > 1) {
	        var startColumn = targetLoc.start.column + by;
	        targetLoc.start = {
	            line: startLine,
	            column: noNegativeColumns
	                ? Math.max(0, startColumn)
	                : startColumn
	        };
	    }

	    if (!skipFirstLine || endLine > 1) {
	        var endColumn = targetLoc.end.column + by;
	        targetLoc.end = {
	            line: endLine,
	            column: noNegativeColumns
	                ? Math.max(0, endColumn)
	                : endColumn
	        };
	    }

	    return new Mapping(this.sourceLines, this.sourceLoc, targetLoc);
	};

	function skipChars(
	    sourceLines, sourceFromPos,
	    targetLines, targetFromPos, targetToPos
	) {
	    assert.ok(sourceLines instanceof linesModule.Lines);
	    assert.ok(targetLines instanceof linesModule.Lines);
	    Position.assert(sourceFromPos);
	    Position.assert(targetFromPos);
	    Position.assert(targetToPos);

	    var targetComparison = comparePos(targetFromPos, targetToPos);
	    if (targetComparison === 0) {
	        // Trivial case: no characters to skip.
	        return sourceFromPos;
	    }

	    if (targetComparison < 0) {
	        // Skipping forward.

	        var sourceCursor = sourceLines.skipSpaces(sourceFromPos);
	        var targetCursor = targetLines.skipSpaces(targetFromPos);

	        var lineDiff = targetToPos.line - targetCursor.line;
	        sourceCursor.line += lineDiff;
	        targetCursor.line += lineDiff;

	        if (lineDiff > 0) {
	            // If jumping to later lines, reset columns to the beginnings
	            // of those lines.
	            sourceCursor.column = 0;
	            targetCursor.column = 0;
	        } else {
	            assert.strictEqual(lineDiff, 0);
	        }

	        while (comparePos(targetCursor, targetToPos) < 0 &&
	               targetLines.nextPos(targetCursor, true)) {
	            assert.ok(sourceLines.nextPos(sourceCursor, true));
	            assert.strictEqual(
	                sourceLines.charAt(sourceCursor),
	                targetLines.charAt(targetCursor)
	            );
	        }

	    } else {
	        // Skipping backward.

	        var sourceCursor = sourceLines.skipSpaces(sourceFromPos, true);
	        var targetCursor = targetLines.skipSpaces(targetFromPos, true);

	        var lineDiff = targetToPos.line - targetCursor.line;
	        sourceCursor.line += lineDiff;
	        targetCursor.line += lineDiff;

	        if (lineDiff < 0) {
	            // If jumping to earlier lines, reset columns to the ends of
	            // those lines.
	            sourceCursor.column = sourceLines.getLineLength(sourceCursor.line);
	            targetCursor.column = targetLines.getLineLength(targetCursor.line);
	        } else {
	            assert.strictEqual(lineDiff, 0);
	        }

	        while (comparePos(targetToPos, targetCursor) < 0 &&
	               targetLines.prevPos(targetCursor, true)) {
	            assert.ok(sourceLines.prevPos(sourceCursor, true));
	            assert.strictEqual(
	                sourceLines.charAt(sourceCursor),
	                targetLines.charAt(targetCursor)
	            );
	        }
	    }

	    return sourceCursor;
	}


/***/ },
/* 58 */
/***/ function(module, exports, __webpack_require__) {

	var assert = __webpack_require__(27);
	var types = __webpack_require__(24);
	var n = types.namedTypes;
	var Node = n.Node;
	var isArray = types.builtInTypes.array;
	var isNumber = types.builtInTypes.number;

	function FastPath(value) {
	    assert.ok(this instanceof FastPath);
	    this.stack = [value];
	}

	var FPp = FastPath.prototype;
	module.exports = FastPath;

	// Static convenience function for coercing a value to a FastPath.
	FastPath.from = function(obj) {
	    if (obj instanceof FastPath) {
	        // Return a defensive copy of any existing FastPath instances.
	        return obj.copy();
	    }

	    if (obj instanceof types.NodePath) {
	        // For backwards compatibility, unroll NodePath instances into
	        // lightweight FastPath [..., name, value] stacks.
	        var copy = Object.create(FastPath.prototype);
	        var stack = [obj.value];
	        for (var pp; (pp = obj.parentPath); obj = pp)
	            stack.push(obj.name, pp.value);
	        copy.stack = stack.reverse();
	        return copy;
	    }

	    // Otherwise use obj as the value of the new FastPath instance.
	    return new FastPath(obj);
	};

	FPp.copy = function copy() {
	    var copy = Object.create(FastPath.prototype);
	    copy.stack = this.stack.slice(0);
	    return copy;
	};

	// The name of the current property is always the penultimate element of
	// this.stack, and always a String.
	FPp.getName = function getName() {
	    var s = this.stack;
	    var len = s.length;
	    if (len > 1) {
	        return s[len - 2];
	    }
	    // Since the name is always a string, null is a safe sentinel value to
	    // return if we do not know the name of the (root) value.
	    return null;
	};

	// The value of the current property is always the final element of
	// this.stack.
	FPp.getValue = function getValue() {
	    var s = this.stack;
	    return s[s.length - 1];
	};

	FPp.getNode = function getNode() {
	    var s = this.stack;

	    for (var i = s.length - 1; i >= 0; i -= 2) {
	        var value = s[i];
	        if (n.Node.check(value)) {
	            return value;
	        }
	    }

	    return null;
	};

	FPp.getParentNode = function getParentNode() {
	    var s = this.stack;
	    var count = 0;

	    for (var i = s.length - 1; i >= 0; i -= 2) {
	        var value = s[i];
	        if (n.Node.check(value) && count++ > 0) {
	            return value;
	        }
	    }

	    return null;
	};

	// The length of the stack can be either even or odd, depending on whether
	// or not we have a name for the root value. The difference between the
	// index of the root value and the index of the final value is always
	// even, though, which allows us to return the root value in constant time
	// (i.e. without iterating backwards through the stack).
	FPp.getRootValue = function getRootValue() {
	    var s = this.stack;
	    if (s.length % 2 === 0) {
	        return s[1];
	    }
	    return s[0];
	};

	// Temporarily push properties named by string arguments given after the
	// callback function onto this.stack, then call the callback with a
	// reference to this (modified) FastPath object. Note that the stack will
	// be restored to its original state after the callback is finished, so it
	// is probably a mistake to retain a reference to the path.
	FPp.call = function call(callback/*, name1, name2, ... */) {
	    var s = this.stack;
	    var origLen = s.length;
	    var value = s[origLen - 1];
	    var argc = arguments.length;
	    for (var i = 1; i < argc; ++i) {
	        var name = arguments[i];
	        value = value[name];
	        s.push(name, value);
	    }
	    var result = callback(this);
	    s.length = origLen;
	    return result;
	};

	// Similar to FastPath.prototype.call, except that the value obtained by
	// accessing this.getValue()[name1][name2]... should be array-like. The
	// callback will be called with a reference to this path object for each
	// element of the array.
	FPp.each = function each(callback/*, name1, name2, ... */) {
	    var s = this.stack;
	    var origLen = s.length;
	    var value = s[origLen - 1];
	    var argc = arguments.length;

	    for (var i = 1; i < argc; ++i) {
	        var name = arguments[i];
	        value = value[name];
	        s.push(name, value);
	    }

	    for (var i = 0; i < value.length; ++i) {
	        if (i in value) {
	            s.push(i, value[i]);
	            // If the callback needs to know the value of i, call
	            // path.getName(), assuming path is the parameter name.
	            callback(this);
	            s.length -= 2;
	        }
	    }

	    s.length = origLen;
	};

	// Similar to FastPath.prototype.each, except that the results of the
	// callback function invocations are stored in an array and returned at
	// the end of the iteration.
	FPp.map = function map(callback/*, name1, name2, ... */) {
	    var s = this.stack;
	    var origLen = s.length;
	    var value = s[origLen - 1];
	    var argc = arguments.length;

	    for (var i = 1; i < argc; ++i) {
	        var name = arguments[i];
	        value = value[name];
	        s.push(name, value);
	    }

	    var result = new Array(value.length);

	    for (var i = 0; i < value.length; ++i) {
	        if (i in value) {
	            s.push(i, value[i]);
	            result[i] = callback(this, i);
	            s.length -= 2;
	        }
	    }

	    s.length = origLen;

	    return result;
	};

	// Inspired by require("ast-types").NodePath.prototype.needsParens, but
	// more efficient because we're iterating backwards through a stack.
	FPp.needsParens = function(assumeExpressionContext) {
	    var parent = this.getParentNode();
	    if (!parent) {
	        return false;
	    }

	    var name = this.getName();
	    var node = this.getNode();

	    // Only expressions need parentheses.
	    if (!n.Expression.check(node)) {
	        return false;
	    }

	    // Identifiers never need parentheses.
	    if (node.type === "Identifier") {
	        return false;
	    }

	    switch (node.type) {
	    case "UnaryExpression":
	    case "SpreadElement":
	    case "SpreadProperty":
	        return parent.type === "MemberExpression"
	            && name === "object"
	            && parent.object === node;

	    case "BinaryExpression":
	    case "LogicalExpression":
	        switch (parent.type) {
	        case "CallExpression":
	            return name === "callee"
	                && parent.callee === node;

	        case "UnaryExpression":
	        case "SpreadElement":
	        case "SpreadProperty":
	            return true;

	        case "MemberExpression":
	            return name === "object"
	                && parent.object === node;

	        case "BinaryExpression":
	        case "LogicalExpression":
	            var po = parent.operator;
	            var pp = PRECEDENCE[po];
	            var no = node.operator;
	            var np = PRECEDENCE[no];

	            if (pp > np) {
	                return true;
	            }

	            if (pp === np && name === "right") {
	                assert.strictEqual(parent.right, node);
	                return true;
	            }

	        default:
	            return false;
	        }

	    case "SequenceExpression":
	        switch (parent.type) {
	        case "ForStatement":
	            // Although parentheses wouldn't hurt around sequence
	            // expressions in the head of for loops, traditional style
	            // dictates that e.g. i++, j++ should not be wrapped with
	            // parentheses.
	            return false;

	        case "ExpressionStatement":
	            return name !== "expression";

	        default:
	            // Otherwise err on the side of overparenthesization, adding
	            // explicit exceptions above if this proves overzealous.
	            return true;
	        }

	    case "YieldExpression":
	        switch (parent.type) {
	        case "BinaryExpression":
	        case "LogicalExpression":
	        case "UnaryExpression":
	        case "SpreadElement":
	        case "SpreadProperty":
	        case "CallExpression":
	        case "MemberExpression":
	        case "NewExpression":
	        case "ConditionalExpression":
	        case "YieldExpression":
	            return true;

	        default:
	            return false;
	        }

	    case "Literal":
	        return parent.type === "MemberExpression"
	            && isNumber.check(node.value)
	            && name === "object"
	            && parent.object === node;

	    case "AssignmentExpression":
	    case "ConditionalExpression":
	        switch (parent.type) {
	        case "UnaryExpression":
	        case "SpreadElement":
	        case "SpreadProperty":
	        case "BinaryExpression":
	        case "LogicalExpression":
	            return true;

	        case "CallExpression":
	            return name === "callee"
	                && parent.callee === node;

	        case "ConditionalExpression":
	            return name === "test"
	                && parent.test === node;

	        case "MemberExpression":
	            return name === "object"
	                && parent.object === node;

	        default:
	            return false;
	        }

	    default:
	        if (parent.type === "NewExpression" &&
	            name === "callee" &&
	            parent.callee === node) {
	            return containsCallExpression(node);
	        }
	    }

	    if (assumeExpressionContext !== true &&
	        !this.canBeFirstInStatement() &&
	        this.firstInStatement())
	        return true;

	    return false;
	};

	function isBinary(node) {
	    return n.BinaryExpression.check(node)
	        || n.LogicalExpression.check(node);
	}

	function isUnaryLike(node) {
	    return n.UnaryExpression.check(node)
	        // I considered making SpreadElement and SpreadProperty subtypes
	        // of UnaryExpression, but they're not really Expression nodes.
	        || (n.SpreadElement && n.SpreadElement.check(node))
	        || (n.SpreadProperty && n.SpreadProperty.check(node));
	}

	var PRECEDENCE = {};
	[["||"],
	 ["&&"],
	 ["|"],
	 ["^"],
	 ["&"],
	 ["==", "===", "!=", "!=="],
	 ["<", ">", "<=", ">=", "in", "instanceof"],
	 [">>", "<<", ">>>"],
	 ["+", "-"],
	 ["*", "/", "%"]
	].forEach(function(tier, i) {
	    tier.forEach(function(op) {
	        PRECEDENCE[op] = i;
	    });
	});

	function containsCallExpression(node) {
	    if (n.CallExpression.check(node)) {
	        return true;
	    }

	    if (isArray.check(node)) {
	        return node.some(containsCallExpression);
	    }

	    if (n.Node.check(node)) {
	        return types.someField(node, function(name, child) {
	            return containsCallExpression(child);
	        });
	    }

	    return false;
	}

	FPp.canBeFirstInStatement = function() {
	    var node = this.getNode();
	    return !n.FunctionExpression.check(node)
	        && !n.ObjectExpression.check(node);
	};

	FPp.firstInStatement = function() {
	    var s = this.stack;
	    var parentName, parent;
	    var childName, child;

	    for (var i = s.length - 1; i >= 0; i -= 2) {
	        if (n.Node.check(s[i])) {
	            childName = parentName;
	            child = parent;
	            parentName = s[i - 1];
	            parent = s[i];
	        }

	        if (!parent || !child) {
	            continue;
	        }

	        if (n.BlockStatement.check(parent) &&
	            parentName === "body" &&
	            childName === 0) {
	            assert.strictEqual(parent.body[0], child);
	            return true;
	        }

	        if (n.ExpressionStatement.check(parent) &&
	            childName === "expression") {
	            assert.strictEqual(parent.expression, child);
	            return true;
	        }

	        if (n.SequenceExpression.check(parent) &&
	            parentName === "expressions" &&
	            childName === 0) {
	            assert.strictEqual(parent.expressions[0], child);
	            continue;
	        }

	        if (n.CallExpression.check(parent) &&
	            childName === "callee") {
	            assert.strictEqual(parent.callee, child);
	            continue;
	        }

	        if (n.MemberExpression.check(parent) &&
	            childName === "object") {
	            assert.strictEqual(parent.object, child);
	            continue;
	        }

	        if (n.ConditionalExpression.check(parent) &&
	            childName === "test") {
	            assert.strictEqual(parent.test, child);
	            continue;
	        }

	        if (isBinary(parent) &&
	            childName === "left") {
	            assert.strictEqual(parent.left, child);
	            continue;
	        }

	        if (n.UnaryExpression.check(parent) &&
	            !parent.prefix &&
	            childName === "argument") {
	            assert.strictEqual(parent.argument, child);
	            continue;
	        }

	        return false;
	    }

	    return true;
	};


/***/ },
/* 59 */
/***/ function(module, exports, __webpack_require__) {

	var assert = __webpack_require__(27);
	var types = __webpack_require__(24);
	var n = types.namedTypes;
	var isArray = types.builtInTypes.array;
	var isObject = types.builtInTypes.object;
	var linesModule = __webpack_require__(42);
	var fromString = linesModule.fromString;
	var Lines = linesModule.Lines;
	var concat = linesModule.concat;
	var comparePos = __webpack_require__(56).comparePos;
	var childNodesCacheKey = __webpack_require__(55).makeUniqueKey();

	// TODO Move a non-caching implementation of this function into ast-types,
	// and implement a caching wrapper function here.
	function getSortedChildNodes(node, resultArray) {
	    if (!node) {
	        return;
	    }

	    if (resultArray) {
	        if (n.Node.check(node) &&
	            n.SourceLocation.check(node.loc)) {
	            // This reverse insertion sort almost always takes constant
	            // time because we almost always (maybe always?) append the
	            // nodes in order anyway.
	            for (var i = resultArray.length - 1; i >= 0; --i) {
	                if (comparePos(resultArray[i].loc.end,
	                               node.loc.start) <= 0) {
	                    break;
	                }
	            }
	            resultArray.splice(i + 1, 0, node);
	            return;
	        }
	    } else if (node[childNodesCacheKey]) {
	        return node[childNodesCacheKey];
	    }

	    var names;
	    if (isArray.check(node)) {
	        names = Object.keys(node);
	    } else if (isObject.check(node)) {
	        names = types.getFieldNames(node);
	    } else {
	        return;
	    }

	    if (!resultArray) {
	        Object.defineProperty(node, childNodesCacheKey, {
	            value: resultArray = [],
	            enumerable: false
	        });
	    }

	    for (var i = 0, nameCount = names.length; i < nameCount; ++i) {
	        getSortedChildNodes(node[names[i]], resultArray);
	    }

	    return resultArray;
	}

	// As efficiently as possible, decorate the comment object with
	// .precedingNode, .enclosingNode, and/or .followingNode properties, at
	// least one of which is guaranteed to be defined.
	function decorateComment(node, comment) {
	    var childNodes = getSortedChildNodes(node);

	    // Time to dust off the old binary search robes and wizard hat.
	    var left = 0, right = childNodes.length;
	    while (left < right) {
	        var middle = (left + right) >> 1;
	        var child = childNodes[middle];

	        if (comparePos(child.loc.start, comment.loc.start) <= 0 &&
	            comparePos(comment.loc.end, child.loc.end) <= 0) {
	            // The comment is completely contained by this child node.
	            decorateComment(comment.enclosingNode = child, comment);
	            return; // Abandon the binary search at this level.
	        }

	        if (comparePos(child.loc.end, comment.loc.start) <= 0) {
	            // This child node falls completely before the comment.
	            // Because we will never consider this node or any nodes
	            // before it again, this node must be the closest preceding
	            // node we have encountered so far.
	            var precedingNode = child;
	            left = middle + 1;
	            continue;
	        }

	        if (comparePos(comment.loc.end, child.loc.start) <= 0) {
	            // This child node falls completely after the comment.
	            // Because we will never consider this node or any nodes after
	            // it again, this node must be the closest following node we
	            // have encountered so far.
	            var followingNode = child;
	            right = middle;
	            continue;
	        }

	        throw new Error("Comment location overlaps with node location");
	    }

	    if (precedingNode) {
	        comment.precedingNode = precedingNode;
	    }

	    if (followingNode) {
	        comment.followingNode = followingNode;
	    }
	}

	exports.attach = function(comments, ast, lines) {
	    if (!isArray.check(comments)) {
	        return;
	    }

	    var tiesToBreak = [];

	    comments.forEach(function(comment) {
	        comment.loc.lines = lines;
	        decorateComment(ast, comment);

	        var pn = comment.precedingNode;
	        var en = comment.enclosingNode;
	        var fn = comment.followingNode;

	        if (pn && fn) {
	            var tieCount = tiesToBreak.length;
	            if (tieCount > 0) {
	                var lastTie = tiesToBreak[tieCount - 1];

	                assert.strictEqual(
	                    lastTie.precedingNode === comment.precedingNode,
	                    lastTie.followingNode === comment.followingNode
	                );

	                if (lastTie.followingNode !== comment.followingNode) {
	                    breakTies(tiesToBreak, lines);
	                }
	            }

	            tiesToBreak.push(comment);

	        } else if (pn) {
	            // No contest: we have a trailing comment.
	            breakTies(tiesToBreak, lines);
	            Comments.forNode(pn).addTrailing(comment);

	        } else if (fn) {
	            // No contest: we have a leading comment.
	            breakTies(tiesToBreak, lines);
	            Comments.forNode(fn).addLeading(comment);

	        } else if (en) {
	            // The enclosing node has no child nodes at all, so what we
	            // have here is a dangling comment, e.g. [/* crickets */].
	            breakTies(tiesToBreak, lines);
	            Comments.forNode(en).addDangling(comment);

	        } else {
	            throw new Error("AST contains no nodes at all?");
	        }
	    });

	    breakTies(tiesToBreak, lines);
	};

	function breakTies(tiesToBreak, lines) {
	    var tieCount = tiesToBreak.length;
	    if (tieCount === 0) {
	        return;
	    }

	    var pn = tiesToBreak[0].precedingNode;
	    var fn = tiesToBreak[0].followingNode;
	    var gapEndPos = fn.loc.start;

	    // Iterate backwards through tiesToBreak, examining the gaps
	    // between the tied comments. In order to qualify as leading, a
	    // comment must be separated from fn by an unbroken series of
	    // whitespace-only gaps (or other comments).
	    for (var indexOfFirstLeadingComment = tieCount;
	         indexOfFirstLeadingComment > 0;
	         --indexOfFirstLeadingComment) {
	        var comment = tiesToBreak[indexOfFirstLeadingComment - 1];
	        assert.strictEqual(comment.precedingNode, pn);
	        assert.strictEqual(comment.followingNode, fn);

	        var gap = lines.sliceString(comment.loc.end, gapEndPos);
	        if (/\S/.test(gap)) {
	            // The gap string contained something other than whitespace.
	            break;
	        }

	        gapEndPos = comment.loc.start;
	    }

	    while (indexOfFirstLeadingComment <= tieCount &&
	           (comment = tiesToBreak[indexOfFirstLeadingComment]) &&
	           // If the comment is a //-style comment and indented more
	           // deeply than the node itself, reconsider it as trailing.
	           comment.type === "Line" &&
	           comment.loc.start.column > fn.loc.start.column) {
	        ++indexOfFirstLeadingComment;
	    }

	    tiesToBreak.forEach(function(comment, i) {
	        if (i < indexOfFirstLeadingComment) {
	            Comments.forNode(pn).addTrailing(comment);
	        } else {
	            Comments.forNode(fn).addLeading(comment);
	        }
	    });

	    tiesToBreak.length = 0;
	}

	function Comments() {
	    assert.ok(this instanceof Comments);
	    this.leading = [];
	    this.dangling = [];
	    this.trailing = [];
	}

	var Cp = Comments.prototype;

	Comments.forNode = function forNode(node) {
	    var comments = node.comments;
	    if (!comments) {
	        Object.defineProperty(node, "comments", {
	            value: comments = new Comments,
	            enumerable: false
	        });
	    }
	    return comments;
	};

	Cp.forEach = function forEach(callback, context) {
	    this.leading.forEach(callback, context);
	    // this.dangling.forEach(callback, context);
	    this.trailing.forEach(callback, context);
	};

	Cp.addLeading = function addLeading(comment) {
	    this.leading.push(comment);
	};

	Cp.addDangling = function addDangling(comment) {
	    this.dangling.push(comment);
	};

	Cp.addTrailing = function addTrailing(comment) {
	    comment.trailing = true;
	    if (comment.type === "Block") {
	        this.trailing.push(comment);
	    } else {
	        this.leading.push(comment);
	    }
	};

	/**
	 * @param {Object} options - Options object that configures printing.
	 */
	function printLeadingComment(comment, options) {
	    var loc = comment.loc;
	    var lines = loc && loc.lines;
	    var parts = [];

	    if (comment.type === "Block") {
	        parts.push("/*", fromString(comment.value, options), "*/");
	    } else if (comment.type === "Line") {
	        parts.push("//", fromString(comment.value, options));
	    } else assert.fail(comment.type);

	    if (comment.trailing) {
	        // When we print trailing comments as leading comments, we don't
	        // want to bring any trailing spaces along.
	        parts.push("\n");

	    } else if (lines instanceof Lines) {
	        var trailingSpace = lines.slice(
	            loc.end,
	            lines.skipSpaces(loc.end)
	        );

	        if (trailingSpace.length === 1) {
	            // If the trailing space contains no newlines, then we want to
	            // preserve it exactly as we found it.
	            parts.push(trailingSpace);
	        } else {
	            // If the trailing space contains newlines, then replace it
	            // with just that many newlines, with all other spaces removed.
	            parts.push(new Array(trailingSpace.length).join("\n"));
	        }

	    } else {
	        parts.push("\n");
	    }

	    return concat(parts).stripMargin(loc ? loc.start.column : 0);
	}

	/**
	 * @param {Object} options - Options object that configures printing.
	 */
	function printTrailingComment(comment, options) {
	    var loc = comment.loc;
	    var lines = loc && loc.lines;
	    var parts = [];

	    if (lines instanceof Lines) {
	        var fromPos = lines.skipSpaces(loc.start, true) || lines.firstPos();
	        var leadingSpace = lines.slice(fromPos, loc.start);

	        if (leadingSpace.length === 1) {
	            // If the leading space contains no newlines, then we want to
	            // preserve it exactly as we found it.
	            parts.push(leadingSpace);
	        } else {
	            // If the leading space contains newlines, then replace it
	            // with just that many newlines, sans all other spaces.
	            parts.push(new Array(leadingSpace.length).join("\n"));
	        }
	    }

	    if (comment.type === "Block") {
	        parts.push("/*", fromString(comment.value, options), "*/");
	    } else if (comment.type === "Line") {
	        parts.push("//", fromString(comment.value, options), "\n");
	    } else assert.fail(comment.type);

	    return concat(parts).stripMargin(
	        loc ? loc.start.column : 0,
	        true // Skip the first line, in case there were leading spaces.
	    );
	}

	/**
	 * @param {Object} options - Options object that configures printing.
	 */
	exports.printComments = function(comments, innerLines, options) {
	    if (innerLines) {
	        assert.ok(innerLines instanceof Lines);
	    } else {
	        innerLines = fromString("");
	    }

	    if (!comments || !(comments.leading.length +
	                       comments.trailing.length)) {
	        return innerLines;
	    }

	    var parts = [];

	    comments.leading.forEach(function(comment) {
	        parts.push(printLeadingComment(comment, options));
	    });

	    parts.push(innerLines);

	    comments.trailing.forEach(function(comment) {
	        assert.strictEqual(comment.type, "Block");
	        parts.push(printTrailingComment(comment, options));
	    });

	    return concat(parts);
	};


/***/ },
/* 60 */
/***/ function(module, exports, __webpack_require__) {

	var assert = __webpack_require__(27);
	var sourceMap = __webpack_require__(43);
	var printComments = __webpack_require__(59).printComments;
	var linesModule = __webpack_require__(42);
	var fromString = linesModule.fromString;
	var concat = linesModule.concat;
	var normalizeOptions = __webpack_require__(53).normalize;
	var getReprinter = __webpack_require__(41).getReprinter;
	var types = __webpack_require__(24);
	var namedTypes = types.namedTypes;
	var isString = types.builtInTypes.string;
	var isObject = types.builtInTypes.object;
	var FastPath = __webpack_require__(58);
	var util = __webpack_require__(56);

	function PrintResult(code, sourceMap) {
	    assert.ok(this instanceof PrintResult);

	    isString.assert(code);
	    this.code = code;

	    if (sourceMap) {
	        isObject.assert(sourceMap);
	        this.map = sourceMap;
	    }
	}

	var PRp = PrintResult.prototype;
	var warnedAboutToString = false;

	PRp.toString = function() {
	    if (!warnedAboutToString) {
	        console.warn(
	            "Deprecation warning: recast.print now returns an object with " +
	            "a .code property. You appear to be treating the object as a " +
	            "string, which might still work but is strongly discouraged."
	        );

	        warnedAboutToString = true;
	    }

	    return this.code;
	};

	var emptyPrintResult = new PrintResult("");

	function Printer(originalOptions) {
	    assert.ok(this instanceof Printer);

	    var explicitTabWidth = originalOptions && originalOptions.tabWidth;
	    var options = normalizeOptions(originalOptions);
	    assert.notStrictEqual(options, originalOptions);

	    // It's common for client code to pass the same options into both
	    // recast.parse and recast.print, but the Printer doesn't need (and
	    // can be confused by) options.sourceFileName, so we null it out.
	    options.sourceFileName = null;

	    function printWithComments(path) {
	        assert.ok(path instanceof FastPath);
	        return printComments(path.getNode().comments, print(path), options);
	    }

	    function print(path, includeComments) {
	        if (includeComments)
	            return printWithComments(path);

	        assert.ok(path instanceof FastPath);

	        if (!explicitTabWidth) {
	            var oldTabWidth = options.tabWidth;
	            var loc = path.getNode().loc;
	            if (loc && loc.lines && loc.lines.guessTabWidth) {
	                options.tabWidth = loc.lines.guessTabWidth();
	                var lines = maybeReprint(path);
	                options.tabWidth = oldTabWidth;
	                return lines;
	            }
	        }

	        return maybeReprint(path);
	    }

	    function maybeReprint(path) {
	        var reprinter = getReprinter(path);
	        if (reprinter)
	            return maybeAddParens(path, reprinter(maybeReprint));
	        return printRootGenerically(path);
	    }

	    // Print the root node generically, but then resume reprinting its
	    // children non-generically.
	    function printRootGenerically(path) {
	        return genericPrint(path, options, printWithComments);
	    }

	    // Print the entire AST generically.
	    function printGenerically(path) {
	        return genericPrint(path, options, printGenerically);
	    }

	    this.print = function(ast) {
	        if (!ast) {
	            return emptyPrintResult;
	        }

	        var lines = print(FastPath.from(ast), true);

	        return new PrintResult(
	            lines.toString(options),
	            util.composeSourceMaps(
	                options.inputSourceMap,
	                lines.getSourceMap(
	                    options.sourceMapName,
	                    options.sourceRoot
	                )
	            )
	        );
	    };

	    this.printGenerically = function(ast) {
	        if (!ast) {
	            return emptyPrintResult;
	        }

	        var path = FastPath.from(ast);
	        var oldReuseWhitespace = options.reuseWhitespace;

	        // Do not reuse whitespace (or anything else, for that matter)
	        // when printing generically.
	        options.reuseWhitespace = false;
	        var pr = new PrintResult(printGenerically(path).toString(options));
	        options.reuseWhitespace = oldReuseWhitespace;
	        return pr;
	    };
	}

	exports.Printer = Printer;

	function maybeAddParens(path, lines) {
	    return path.needsParens() ? concat(["(", lines, ")"]) : lines;
	}

	function genericPrint(path, options, printPath) {
	    assert.ok(path instanceof FastPath);
	    return maybeAddParens(path, genericPrintNoParens(path, options, printPath));
	}

	function genericPrintNoParens(path, options, print) {
	    var n = path.getValue();

	    if (!n) {
	        return fromString("");
	    }

	    if (typeof n === "string") {
	        return fromString(n, options);
	    }

	    namedTypes.Node.assert(n);

	    switch (n.type) {
	    case "File":
	        return path.call(print, "program");

	    case "Program":
	        return maybeAddSemicolon(path.call(function(bodyPath) {
	            return printStatementSequence(bodyPath, options, print);
	        }, "body"));

	    case "EmptyStatement":
	        return fromString("");

	    case "ExpressionStatement":
	        return concat([path.call(print, "expression"), ";"]);

	    case "BinaryExpression":
	    case "LogicalExpression":
	    case "AssignmentExpression":
	        return fromString(" ").join([
	            path.call(print, "left"),
	            n.operator,
	            path.call(print, "right")
	        ]);

	    case "MemberExpression":
	        var parts = [path.call(print, "object")];

	        if (n.computed)
	            parts.push("[", path.call(print, "property"), "]");
	        else
	            parts.push(".", path.call(print, "property"));

	        return concat(parts);

	    case "Path":
	        return fromString(".").join(n.body);

	    case "Identifier":
	        return fromString(n.name, options);

	    case "SpreadElement":
	    case "SpreadElementPattern":
	    case "SpreadProperty":
	    case "SpreadPropertyPattern":
	        return concat(["...", path.call(print, "argument")]);

	    case "FunctionDeclaration":
	    case "FunctionExpression":
	        var parts = [];

	        if (n.async)
	            parts.push("async ");

	        parts.push("function");

	        if (n.generator)
	            parts.push("*");

	        if (n.id)
	            parts.push(" ", path.call(print, "id"));

	        parts.push(
	            "(",
	            printFunctionParams(path, options, print),
	            ") ",
	            path.call(print, "body")
	        );

	        return concat(parts);

	    case "ArrowFunctionExpression":
	        var parts = [];

	        if (n.async)
	            parts.push("async ");

	        if (n.params.length === 1) {
	            parts.push(path.call(print, "params", 0));
	        } else {
	            parts.push(
	                "(",
	                printFunctionParams(path, options, print),
	                ")"
	            );
	        }

	        parts.push(" => ", path.call(print, "body"));

	        return concat(parts);

	    case "MethodDefinition":
	        var parts = [];

	        if (n.static) {
	            parts.push("static ");
	        }

	        parts.push(printMethod(path, options, print));

	        return concat(parts);

	    case "YieldExpression":
	        var parts = ["yield"];

	        if (n.delegate)
	            parts.push("*");

	        if (n.argument)
	            parts.push(" ", path.call(print, "argument"));

	        return concat(parts);

	    case "AwaitExpression":
	        var parts = ["await"];

	        if (n.all)
	            parts.push("*");

	        if (n.argument)
	            parts.push(" ", path.call(print, "argument"));

	        return concat(parts);

	    case "ModuleDeclaration":
	        var parts = ["module", path.call(print, "id")];

	        if (n.source) {
	            assert.ok(!n.body);
	            parts.push("from", path.call(print, "source"));
	        } else {
	            parts.push(path.call(print, "body"));
	        }

	        return fromString(" ").join(parts);

	    case "ImportSpecifier":
	    case "ExportSpecifier":
	        var parts = [path.call(print, "id")];

	        if (n.name)
	            parts.push(" as ", path.call(print, "name"));

	        return concat(parts);

	    case "ExportBatchSpecifier":
	        return fromString("*");

	    case "ImportNamespaceSpecifier":
	        return concat(["* as ", path.call(print, "id")]);

	    case "ImportDefaultSpecifier":
	        return path.call(print, "id");

	    case "ExportDeclaration":
	        var parts = ["export"];

	        if (n["default"]) {
	            parts.push(" default");

	        } else if (n.specifiers &&
	                   n.specifiers.length > 0) {

	            if (n.specifiers.length === 1 &&
	                n.specifiers[0].type === "ExportBatchSpecifier") {
	                parts.push(" *");
	            } else {
	                parts.push(
	                    " { ",
	                    fromString(", ").join(path.map(print, "specifiers")),
	                    " }"
	                );
	            }

	            if (n.source)
	                parts.push(" from ", path.call(print, "source"));

	            parts.push(";");

	            return concat(parts);
	        }

	        if (n.declaration) {
	            if (!namedTypes.Node.check(n.declaration)) {
	                console.log(JSON.stringify(n, null, 2));
	            }
	            var decLines = path.call(print, "declaration");
	            parts.push(" ", decLines);
	            if (lastNonSpaceCharacter(decLines) !== ";") {
	                parts.push(";");
	            }
	        }

	        return concat(parts);

	    case "ImportDeclaration":
	        var parts = ["import "];

	        if (n.specifiers &&
	            n.specifiers.length > 0) {

	            var foundImportSpecifier = false;

	            path.each(function(specifierPath) {
	                var i = specifierPath.getName();
	                if (i > 0) {
	                    parts.push(", ");
	                }

	                var value = specifierPath.getValue();

	                if (namedTypes.ImportDefaultSpecifier.check(value) ||
	                    namedTypes.ImportNamespaceSpecifier.check(value)) {
	                    assert.strictEqual(foundImportSpecifier, false);
	                } else {
	                    namedTypes.ImportSpecifier.assert(value);
	                    if (!foundImportSpecifier) {
	                        foundImportSpecifier = true;
	                        parts.push("{");
	                    }
	                }

	                parts.push(print(specifierPath));
	            }, "specifiers");

	            if (foundImportSpecifier) {
	                parts.push("}");
	            }

	            parts.push(" from ");
	        }

	        parts.push(path.call(print, "source"), ";");

	        return concat(parts);

	    case "BlockStatement":
	        var naked = path.call(function(bodyPath) {
	            return printStatementSequence(bodyPath, options, print);
	        }, "body");

	        if (naked.isEmpty()) {
	            return fromString("{}");
	        }

	        return concat([
	            "{\n",
	            naked.indent(options.tabWidth),
	            "\n}"
	        ]);

	    case "ReturnStatement":
	        var parts = ["return"];

	        if (n.argument) {
	            var argLines = path.call(print, "argument");
	            if (argLines.length > 1 &&
	                namedTypes.XJSElement &&
	                namedTypes.XJSElement.check(n.argument)) {
	                parts.push(
	                    " (\n",
	                    argLines.indent(options.tabWidth),
	                    "\n)"
	                );
	            } else {
	                parts.push(" ", argLines);
	            }
	        }

	        parts.push(";");

	        return concat(parts);

	    case "CallExpression":
	        return concat([
	            path.call(print, "callee"),
	            printArgumentsList(path, options, print)
	        ]);

	    case "ObjectExpression":
	    case "ObjectPattern":
	        var allowBreak = false,
	            len = n.properties.length,
	            parts = [len > 0 ? "{\n" : "{"];

	        path.map(function(childPath) {
	            var i = childPath.getName();
	            var prop = childPath.getValue();
	            var lines = print(childPath).indent(options.tabWidth);

	            var multiLine = lines.length > 1;
	            if (multiLine && allowBreak) {
	                // Similar to the logic for BlockStatement.
	                parts.push("\n");
	            }

	            parts.push(lines);

	            if (i < len - 1) {
	                // Add an extra line break if the previous object property
	                // had a multi-line value.
	                parts.push(multiLine ? ",\n\n" : ",\n");
	                allowBreak = !multiLine;
	            }
	        }, "properties");

	        parts.push(len > 0 ? "\n}" : "}");

	        return concat(parts);

	    case "PropertyPattern":
	        return concat([
	            path.call(print, "key"),
	            ": ",
	            path.call(print, "pattern")
	        ]);

	    case "Property": // Non-standard AST node type.
	        if (n.method || n.kind === "get" || n.kind === "set") {
	            return printMethod(path, options, print);
	        }

	        if (n.shorthand) {
	            return path.call(print, "key");
	        }

	        return concat([
	            path.call(print, "key"),
	            ": ",
	            path.call(print, "value")
	        ]);

	    case "ArrayExpression":
	    case "ArrayPattern":
	        var elems = n.elements,
	            len = elems.length,
	            parts = ["["];

	        path.each(function(elemPath) {
	            var i = elemPath.getName();
	            var elem = elemPath.getValue();
	            if (!elem) {
	                // If the array expression ends with a hole, that hole
	                // will be ignored by the interpreter, but if it ends with
	                // two (or more) holes, we need to write out two (or more)
	                // commas so that the resulting code is interpreted with
	                // both (all) of the holes.
	                parts.push(",");
	            } else {
	                if (i > 0)
	                    parts.push(" ");
	                parts.push(print(elemPath));
	                if (i < len - 1)
	                    parts.push(",");
	            }
	        }, "elements");

	        parts.push("]");

	        return concat(parts);

	    case "SequenceExpression":
	        return fromString(", ").join(path.map(print, "expressions"));

	    case "ThisExpression":
	        return fromString("this");

	    case "Literal":
	        if (typeof n.value !== "string")
	            return fromString(n.value, options);

	        // intentionally fall through...

	    case "ModuleSpecifier":
	        // A ModuleSpecifier is a string-valued Literal.
	        return fromString(nodeStr(n, options), options);

	    case "UnaryExpression":
	        var parts = [n.operator];
	        if (/[a-z]$/.test(n.operator))
	            parts.push(" ");
	        parts.push(path.call(print, "argument"));
	        return concat(parts);

	    case "UpdateExpression":
	        var parts = [path.call(print, "argument"), n.operator];

	        if (n.prefix)
	            parts.reverse();

	        return concat(parts);

	    case "ConditionalExpression":
	        return concat([
	            "(", path.call(print, "test"),
	            " ? ", path.call(print, "consequent"),
	            " : ", path.call(print, "alternate"), ")"
	        ]);

	    case "NewExpression":
	        var parts = ["new ", path.call(print, "callee")];
	        var args = n.arguments;
	        if (args) {
	            parts.push(printArgumentsList(path, options, print));
	        }

	        return concat(parts);

	    case "VariableDeclaration":
	        var parts = [n.kind, " "];
	        var maxLen = 0;
	        var printed = path.map(function(childPath) {
	            var lines = print(childPath);
	            maxLen = Math.max(lines.length, maxLen);
	            return lines;
	        }, "declarations");

	        if (maxLen === 1) {
	            parts.push(fromString(", ").join(printed));
	        } else if (printed.length > 1 ) {
	            parts.push(
	                fromString(",\n").join(printed)
	                    .indentTail(n.kind.length + 1)
	            );
	        } else {
	            parts.push(printed[0]);
	        }

	        // We generally want to terminate all variable declarations with a
	        // semicolon, except when they are children of for loops.
	        var parentNode = path.getParentNode();
	        if (!namedTypes.ForStatement.check(parentNode) &&
	            !namedTypes.ForInStatement.check(parentNode) &&
	            !(namedTypes.ForOfStatement &&
	              namedTypes.ForOfStatement.check(parentNode))) {
	            parts.push(";");
	        }

	        return concat(parts);

	    case "VariableDeclarator":
	        return n.init ? fromString(" = ").join([
	            path.call(print, "id"),
	            path.call(print, "init")
	        ]) : path.call(print, "id");

	    case "WithStatement":
	        return concat([
	            "with (",
	            path.call(print, "object"),
	            ") ",
	            path.call(print, "body")
	        ]);

	    case "IfStatement":
	        var con = adjustClause(path.call(print, "consequent"), options),
	            parts = ["if (", path.call(print, "test"), ")", con];

	        if (n.alternate)
	            parts.push(
	                endsWithBrace(con) ? " else" : "\nelse",
	                adjustClause(path.call(print, "alternate"), options));

	        return concat(parts);

	    case "ForStatement":
	        // TODO Get the for (;;) case right.
	        var init = path.call(print, "init"),
	            sep = init.length > 1 ? ";\n" : "; ",
	            forParen = "for (",
	            indented = fromString(sep).join([
	                init,
	                path.call(print, "test"),
	                path.call(print, "update")
	            ]).indentTail(forParen.length),
	            head = concat([forParen, indented, ")"]),
	            clause = adjustClause(path.call(print, "body"), options),
	            parts = [head];

	        if (head.length > 1) {
	            parts.push("\n");
	            clause = clause.trimLeft();
	        }

	        parts.push(clause);

	        return concat(parts);

	    case "WhileStatement":
	        return concat([
	            "while (",
	            path.call(print, "test"),
	            ")",
	            adjustClause(path.call(print, "body"), options)
	        ]);

	    case "ForInStatement":
	        // Note: esprima can't actually parse "for each (".
	        return concat([
	            n.each ? "for each (" : "for (",
	            path.call(print, "left"),
	            " in ",
	            path.call(print, "right"),
	            ")",
	            adjustClause(path.call(print, "body"), options)
	        ]);

	    case "ForOfStatement":
	        return concat([
	            "for (",
	            path.call(print, "left"),
	            " of ",
	            path.call(print, "right"),
	            ")",
	            adjustClause(path.call(print, "body"), options)
	        ]);

	    case "DoWhileStatement":
	        var doBody = concat([
	            "do",
	            adjustClause(path.call(print, "body"), options)
	        ]), parts = [doBody];

	        if (endsWithBrace(doBody))
	            parts.push(" while");
	        else
	            parts.push("\nwhile");

	        parts.push(" (", path.call(print, "test"), ");");

	        return concat(parts);

	    case "BreakStatement":
	        var parts = ["break"];
	        if (n.label)
	            parts.push(" ", path.call(print, "label"));
	        parts.push(";");
	        return concat(parts);

	    case "ContinueStatement":
	        var parts = ["continue"];
	        if (n.label)
	            parts.push(" ", path.call(print, "label"));
	        parts.push(";");
	        return concat(parts);

	    case "LabeledStatement":
	        return concat([
	            path.call(print, "label"),
	            ":\n",
	            path.call(print, "body")
	        ]);

	    case "TryStatement":
	        var parts = [
	            "try ",
	            path.call(print, "block")
	        ];

	        path.each(function(handlerPath) {
	            parts.push(" ", print(handlerPath));
	        }, "handlers");

	        if (n.finalizer)
	            parts.push(" finally ", path.call(print, "finalizer"));

	        return concat(parts);

	    case "CatchClause":
	        var parts = ["catch (", path.call(print, "param")];

	        if (n.guard)
	            // Note: esprima does not recognize conditional catch clauses.
	            parts.push(" if ", path.call(print, "guard"));

	        parts.push(") ", path.call(print, "body"));

	        return concat(parts);

	    case "ThrowStatement":
	        return concat(["throw ", path.call(print, "argument"), ";"]);

	    case "SwitchStatement":
	        return concat([
	            "switch (",
	            path.call(print, "discriminant"),
	            ") {\n",
	            fromString("\n").join(path.map(print, "cases")),
	            "\n}"
	        ]);

	        // Note: ignoring n.lexical because it has no printing consequences.

	    case "SwitchCase":
	        var parts = [];

	        if (n.test)
	            parts.push("case ", path.call(print, "test"), ":");
	        else
	            parts.push("default:");

	        if (n.consequent.length > 0) {
	            parts.push("\n", path.call(function(consequentPath) {
	                return printStatementSequence(consequentPath, options, print);
	            }, "consequent").indent(options.tabWidth));
	        }

	        return concat(parts);

	    case "DebuggerStatement":
	        return fromString("debugger;");

	    // XJS extensions below.

	    case "XJSAttribute":
	        var parts = [path.call(print, "name")];
	        if (n.value)
	            parts.push("=", path.call(print, "value"));
	        return concat(parts);

	    case "XJSIdentifier":
	        return fromString(n.name, options);

	    case "XJSNamespacedName":
	        return fromString(":").join([
	            path.call(print, "namespace"),
	            path.call(print, "name")
	        ]);

	    case "XJSMemberExpression":
	        return fromString(".").join([
	            path.call(print, "object"),
	            path.call(print, "property")
	        ]);

	    case "XJSSpreadAttribute":
	        return concat(["{...", path.call(print, "argument"), "}"]);

	    case "XJSExpressionContainer":
	        return concat(["{", path.call(print, "expression"), "}"]);

	    case "XJSElement":
	        var openingLines = path.call(print, "openingElement");

	        if (n.openingElement.selfClosing) {
	            assert.ok(!n.closingElement);
	            return openingLines;
	        }

	        var childLines = concat(
	            path.map(function(childPath) {
	                var child = childPath.getValue();

	                if (namedTypes.Literal.check(child) &&
	                    typeof child.value === "string") {
	                    if (/\S/.test(child.value)) {
	                        return child.value.replace(/^\s+|\s+$/g, "");
	                    } else if (/\n/.test(child.value)) {
	                        return "\n";
	                    }
	                }

	                return print(childPath);
	            }, "children")
	        ).indentTail(options.tabWidth);

	        var closingLines = path.call(print, "closingElement");

	        return concat([
	            openingLines,
	            childLines,
	            closingLines
	        ]);

	    case "XJSOpeningElement":
	        var parts = ["<", path.call(print, "name")];
	        var attrParts = [];

	        path.each(function(attrPath) {
	            attrParts.push(" ", print(attrPath));
	        }, "attributes");

	        var attrLines = concat(attrParts);

	        var needLineWrap = (
	            attrLines.length > 1 ||
	            attrLines.getLineLength(1) > options.wrapColumn
	        );

	        if (needLineWrap) {
	            attrParts.forEach(function(part, i) {
	                if (part === " ") {
	                    assert.strictEqual(i % 2, 0);
	                    attrParts[i] = "\n";
	                }
	            });

	            attrLines = concat(attrParts).indentTail(options.tabWidth);
	        }

	        parts.push(attrLines, n.selfClosing ? " />" : ">");

	        return concat(parts);

	    case "XJSClosingElement":
	        return concat(["</", path.call(print, "name"), ">"]);

	    case "XJSText":
	        return fromString(n.value, options);

	    case "XJSEmptyExpression":
	        return fromString("");

	    case "TypeAnnotatedIdentifier":
	        return concat([
	            path.call(print, "annotation"),
	            " ",
	            path.call(print, "identifier")
	        ]);

	    case "ClassBody":
	        if (n.body.length === 0) {
	            return fromString("{}");
	        }

	        return concat([
	            "{\n",
	            path.call(function(bodyPath) {
	                return printStatementSequence(bodyPath, options, print);
	            }, "body").indent(options.tabWidth),
	            "\n}"
	        ]);

	    case "ClassPropertyDefinition":
	        var parts = ["static ", path.call(print, "definition")];
	        if (!namedTypes.MethodDefinition.check(n.definition))
	            parts.push(";");
	        return concat(parts);

	    case "ClassProperty":
	        return concat([path.call(print, "id"), ";"]);

	    case "ClassDeclaration":
	    case "ClassExpression":
	        var parts = ["class"];

	        if (n.id)
	            parts.push(" ", path.call(print, "id"));

	        if (n.superClass)
	            parts.push(" extends ", path.call(print, "superClass"));

	        parts.push(" ", path.call(print, "body"));

	        return concat(parts);

	    // These types are unprintable because they serve as abstract
	    // supertypes for other (printable) types.
	    case "Node":
	    case "Printable":
	    case "SourceLocation":
	    case "Position":
	    case "Statement":
	    case "Function":
	    case "Pattern":
	    case "Expression":
	    case "Declaration":
	    case "Specifier":
	    case "NamedSpecifier":
	    case "Block": // Block comment.
	    case "Line": // Line comment.
	        throw new Error("unprintable type: " + JSON.stringify(n.type));

	    // Unhandled types below. If encountered, nodes of these types should
	    // be either left alone or desugared into AST types that are fully
	    // supported by the pretty-printer.

	    case "ClassHeritage": // TODO
	    case "ComprehensionBlock": // TODO
	    case "ComprehensionExpression": // TODO
	    case "Glob": // TODO
	    case "TaggedTemplateExpression": // TODO
	    case "TemplateElement": // TODO
	    case "TemplateLiteral": // TODO
	    case "GeneratorExpression": // TODO
	    case "LetStatement": // TODO
	    case "LetExpression": // TODO
	    case "GraphExpression": // TODO
	    case "GraphIndexExpression": // TODO

	    // Type Annotations for Facebook Flow, typically stripped out or
	    // transformed away before printing.
	    case "AnyTypeAnnotation": // TODO
	    case "ArrayTypeAnnotation": // TODO
	    case "BooleanTypeAnnotation": // TODO
	    case "ClassImplements": // TODO
	    case "DeclareClass": // TODO
	    case "DeclareFunction": // TODO
	    case "DeclareModule": // TODO
	    case "DeclareVariable": // TODO
	    case "FunctionTypeAnnotation": // TODO
	    case "FunctionTypeParam": // TODO
	    case "GenericTypeAnnotation": // TODO
	    case "InterfaceDeclaration": // TODO
	    case "InterfaceExtends": // TODO
	    case "IntersectionTypeAnnotation": // TODO
	    case "MemberTypeAnnotation": // TODO
	    case "NullableTypeAnnotation": // TODO
	    case "NumberTypeAnnotation": // TODO
	    case "ObjectTypeAnnotation": // TODO
	    case "ObjectTypeCallProperty": // TODO
	    case "ObjectTypeIndexer": // TODO
	    case "ObjectTypeProperty": // TODO
	    case "QualifiedTypeIdentifier": // TODO
	    case "StringLiteralTypeAnnotation": // TODO
	    case "StringTypeAnnotation": // TODO
	    case "TupleTypeAnnotation": // TODO
	    case "Type": // TODO
	    case "TypeAlias": // TODO
	    case "TypeAnnotation": // TODO
	    case "TypeCastExpression": // TODO
	    case "TypeParameterDeclaration": // TODO
	    case "TypeParameterInstantiation": // TODO
	    case "TypeofTypeAnnotation": // TODO
	    case "UnionTypeAnnotation": // TODO
	    case "VoidTypeAnnotation": // TODO

	    // XML types that nobody cares about or needs to print.
	    case "XMLDefaultDeclaration":
	    case "XMLAnyName":
	    case "XMLQualifiedIdentifier":
	    case "XMLFunctionQualifiedIdentifier":
	    case "XMLAttributeSelector":
	    case "XMLFilterExpression":
	    case "XML":
	    case "XMLElement":
	    case "XMLList":
	    case "XMLEscape":
	    case "XMLText":
	    case "XMLStartTag":
	    case "XMLEndTag":
	    case "XMLPointTag":
	    case "XMLName":
	    case "XMLAttribute":
	    case "XMLCdata":
	    case "XMLComment":
	    case "XMLProcessingInstruction":
	    default:
	        throw new Error("unknown type: " + JSON.stringify(n.type));
	    }

	    return p;
	}

	function printStatementSequence(path, options, print) {
	    var inClassBody =
	        namedTypes.ClassBody &&
	        namedTypes.ClassBody.check(path.getParentNode());

	    var filtered = [];
	    path.each(function(stmtPath) {
	        var i = stmtPath.getName();
	        var stmt = stmtPath.getValue();

	        // Just in case the AST has been modified to contain falsy
	        // "statements," it's safer simply to skip them.
	        if (!stmt) {
	            return;
	        }

	        // Skip printing EmptyStatement nodes to avoid leaving stray
	        // semicolons lying around.
	        if (stmt.type === "EmptyStatement") {
	            return;
	        }

	        if (!inClassBody) {
	            namedTypes.Statement.assert(stmt);
	        }

	        // We can't hang onto stmtPath outside of this function, because
	        // it's just a reference to a mutable FastPath object, so we have
	        // to go ahead and print it here.
	        filtered.push({
	            node: stmt,
	            printed: print(stmtPath)
	        });
	    });

	    var prevTrailingSpace = null;
	    var len = filtered.length;
	    var parts = [];

	    filtered.forEach(function(info, i) {
	        var printed = info.printed;
	        var stmt = info.node;
	        var needSemicolon = true;
	        var multiLine = printed.length > 1;
	        var notFirst = i > 0;
	        var notLast = i < len - 1;
	        var leadingSpace;
	        var trailingSpace;

	        if (inClassBody) {
	            if (namedTypes.MethodDefinition.check(stmt) ||
	                (namedTypes.ClassPropertyDefinition.check(stmt) &&
	                 namedTypes.MethodDefinition.check(stmt.definition))) {
	                needSemicolon = false;
	            }
	        }

	        if (needSemicolon) {
	            // Try to add a semicolon to anything that isn't a method in a
	            // class body.
	            printed = maybeAddSemicolon(printed);
	        }

	        var trueLoc = options.reuseWhitespace && getTrueLoc(stmt);
	        var lines = trueLoc && trueLoc.lines;

	        if (notFirst) {
	            if (lines) {
	                var beforeStart = lines.skipSpaces(trueLoc.start, true);
	                var beforeStartLine = beforeStart ? beforeStart.line : 1;
	                var leadingGap = trueLoc.start.line - beforeStartLine;
	                leadingSpace = Array(leadingGap + 1).join("\n");
	            } else {
	                leadingSpace = multiLine ? "\n\n" : "\n";
	            }
	        } else {
	            leadingSpace = "";
	        }

	        if (notLast) {
	            if (lines) {
	                var afterEnd = lines.skipSpaces(trueLoc.end);
	                var afterEndLine = afterEnd ? afterEnd.line : lines.length;
	                var trailingGap = afterEndLine - trueLoc.end.line;
	                trailingSpace = Array(trailingGap + 1).join("\n");
	            } else {
	                trailingSpace = multiLine ? "\n\n" : "\n";
	            }
	        } else {
	            trailingSpace = "";
	        }

	        parts.push(
	            maxSpace(prevTrailingSpace, leadingSpace),
	            printed
	        );

	        if (notLast) {
	            prevTrailingSpace = trailingSpace;
	        } else if (trailingSpace) {
	            parts.push(trailingSpace);
	        }
	    });

	    return concat(parts);
	}

	function getTrueLoc(node) {
	    // It's possible that node is newly-created (not parsed by Esprima),
	    // in which case it probably won't have a .loc property (or an
	    // .original property for that matter). That's fine; we'll just
	    // pretty-print it as usual.
	    if (!node.loc) {
	        return null;
	    }

	    if (!node.comments) {
	        // If the node has no comments, regard node.loc as true.
	        return node.loc;
	    }

	    var start = node.loc.start;
	    var end = node.loc.end;

	    // If the node has any comments, their locations might contribute to
	    // the true start/end positions of the node.
	    node.comments.forEach(function(comment) {
	        if (comment.loc) {
	            if (util.comparePos(comment.loc.start, start) < 0) {
	                start = comment.loc.start;
	            }

	            if (util.comparePos(end, comment.loc.end) < 0) {
	                end = comment.loc.end;
	            }
	        }
	    });

	    return {
	        lines: node.loc.lines,
	        start: start,
	        end: end
	    };
	}

	function maxSpace(s1, s2) {
	    if (!s1 && !s2) {
	        return fromString("");
	    }

	    if (!s1) {
	        return fromString(s2);
	    }

	    if (!s2) {
	        return fromString(s1);
	    }

	    var spaceLines1 = fromString(s1);
	    var spaceLines2 = fromString(s2);

	    if (spaceLines2.length > spaceLines1.length) {
	        return spaceLines2;
	    }

	    return spaceLines1;
	}

	function printMethod(path, options, print) {
	    var node = path.getNode();
	    var kind = node.kind;
	    var parts = [];

	    namedTypes.FunctionExpression.assert(node.value);

	    if (node.value.async) {
	        parts.push("async ");
	    }

	    if (!kind || kind === "init") {
	        if (node.value.generator) {
	            parts.push("*");
	        }
	    } else {
	        assert.ok(kind === "get" || kind === "set");
	        parts.push(kind, " ");
	    }

	    parts.push(
	        path.call(print, "key"),
	        "(",
	        path.call(function(valuePath) {
	            return printFunctionParams(valuePath, options, print);
	        }, "value"),
	        ") ",
	        path.call(print, "value", "body")
	    );

	    return concat(parts);
	}

	function printArgumentsList(path, options, print) {
	    var printed = path.map(print, "arguments");

	    var joined = fromString(", ").join(printed);
	    if (joined.getLineLength(1) > options.wrapColumn) {
	        joined = fromString(",\n").join(printed);
	        return concat(["(\n", joined.indent(options.tabWidth), "\n)"]);
	    }

	    return concat(["(", joined, ")"]);
	}

	function printFunctionParams(path, options, print) {
	    var fun = path.getValue();
	    namedTypes.Function.assert(fun);

	    var printed = path.map(print, "params");

	    if (fun.defaults) {
	        path.each(function(defExprPath) {
	            var i = defExprPath.getName();
	            var p = printed[i];
	            if (p && defExprPath.getValue()) {
	                printed[i] = concat([p, "=", print(defExprPath)]);
	            }
	        }, "defaults");
	    }

	    if (fun.rest) {
	        printed.push(concat(["...", path.call(print, "rest")]));
	    }

	    var joined = fromString(", ").join(printed);
	    if (joined.length > 1 ||
	        joined.getLineLength(1) > options.wrapColumn) {
	        joined = fromString(",\n").join(printed);
	        return concat(["\n", joined.indent(options.tabWidth)]);
	    }

	    return joined;
	}

	function adjustClause(clause, options) {
	    if (clause.length > 1)
	        return concat([" ", clause]);

	    return concat([
	        "\n",
	        maybeAddSemicolon(clause).indent(options.tabWidth)
	    ]);
	}

	function lastNonSpaceCharacter(lines) {
	    var pos = lines.lastPos();
	    do {
	        var ch = lines.charAt(pos);
	        if (/\S/.test(ch))
	            return ch;
	    } while (lines.prevPos(pos));
	}

	function endsWithBrace(lines) {
	    return lastNonSpaceCharacter(lines) === "}";
	}

	function swapQuotes(str) {
	    return str.replace(/['"]/g, function(m) {
	        return m === '"' ? '\'' : '"';
	    });
	}

	function nodeStr(n, options) {
	    namedTypes.Literal.assert(n);
	    isString.assert(n.value);
	    switch (options.quote) {
	    case "auto":
	        var double = JSON.stringify(n.value);
	        var single = swapQuotes(JSON.stringify(swapQuotes(n.value)));
	        return double.length > single.length ? single : double;
	    case "single":
	        return swapQuotes(JSON.stringify(swapQuotes(n.value)));
	    case "double":
	    default:
	        return JSON.stringify(n.value);
	    }
	}

	function maybeAddSemicolon(lines) {
	    var eoc = lastNonSpaceCharacter(lines);
	    if (!eoc || "\n};".indexOf(eoc) < 0)
	        return concat([lines, ";"]);
	    return lines;
	}


/***/ },
/* 61 */
/***/ function(module, exports, __webpack_require__) {

	var assert = __webpack_require__(27);
	var through = __webpack_require__(22);
	var recast = __webpack_require__(23);
	var types = recast.types;
	var n = types.namedTypes;
	var b = types.builders;
	var PathVisitor = types.PathVisitor;
	var ThisExpressionVisitor = __webpack_require__(62);
	var util = __webpack_require__(63);

	/**
	 * Visits a node of an AST looking for arrow function expressions. This is
	 * intended to be used with the ast-types `visit()` function.
	 *
	 * @constructor
	 * @extends PathVisitor
	 */
	function ArrowFunctionExpressionVisitor() {
	  PathVisitor.call(this);
	}

	ArrowFunctionExpressionVisitor.prototype = Object.create(PathVisitor.prototype);
	ArrowFunctionExpressionVisitor.prototype.constructor = ArrowFunctionExpressionVisitor;

	/**
	 * Visits arrow function expressions and replaces them with normal functions.
	 *
	 * @param {NodePath} path
	 * @return {?Node}
	 */
	ArrowFunctionExpressionVisitor.prototype.visitArrowFunctionExpression = function(path) {
	  // Descend into the body using a specific visitor
	  this.traverse(path, BodyVisitor.visitor);

	  var node = path.node;
	  var hasThisExpression = ThisExpressionVisitor.hasThisExpression(node);

	  // In the future, ArrowFunctionExpression and FunctionExpression nodes may
	  // get new fields (like .async) that we can't anticipate yet, so we simply
	  // switch the type and let all the other fields carry over.
	  node.type = 'FunctionExpression';

	  if (node.expression) {
	    node.expression = false;
	    node.body = b.blockStatement([b.returnStatement(node.body)]);
	  }

	  if (hasThisExpression) {
	    return b.callExpression(
	      b.memberExpression(node, b.identifier('bind'), false),
	      [b.thisExpression()]
	    );
	  }
	};

	/**
	 * Visits the body of an arrow function expressions.
	 *
	 * @constructor
	 * @private
	 * @extends PathVisitor
	 */
	function BodyVisitor() {
	  PathVisitor.call(this);
	}

	BodyVisitor.prototype = Object.create(ArrowFunctionExpressionVisitor.prototype);
	BodyVisitor.prototype.constructor = ArrowFunctionExpressionVisitor;

	/**
	 * Body visitor traverses arrow function bodies with itself.
	 *
	 * @returns {BodyVisitor}
	 */
	BodyVisitor.prototype.getBodyVisitor = function() {
	  return this;
	};

	/**
	 * Ensures that `arguments` directly contained in arrow functions is hoisted.
	 *
	 * @param {NodePath} path
	 * @return {?Node|boolean}
	 */
	BodyVisitor.prototype.visitIdentifier = function(path) {
	  var node = path.node;

	  if (node.name === 'arguments' && util.isReference(path)) {
	    var functionScope = this.associatedFunctionScope(path);
	    if (functionScope) {
	      return util.sharedFor(functionScope, node.name);
	    }
	  }

	  return false;  // nothing else to look at here
	};

	/**
	 * @private
	 * @param {NodePath} path
	 * @return {?Scope} The nearest non-arrow function scope above `path`.
	 */
	BodyVisitor.prototype.associatedFunctionScope = function(path) {
	  var scope = path.scope;
	  while (scope && n.ArrowFunctionExpression.check(scope.path.node)) {
	    scope = scope.parent;
	  }
	  return scope;
	};

	BodyVisitor.visitor = new BodyVisitor();
	ArrowFunctionExpressionVisitor.visitor = new ArrowFunctionExpressionVisitor();
	module.exports = ArrowFunctionExpressionVisitor;


/***/ },
/* 62 */
/***/ function(module, exports, __webpack_require__) {

	var recast = __webpack_require__(23);
	var types = recast.types;
	var n = types.namedTypes;
	var PathVisitor = types.PathVisitor;

	/**
	 * Assists ArrowFunctionExpressionVisitor by finding `this`.
	 *
	 * @extends PathVisitor
	 * @constructor
	 */
	function ThisExpressionVisitor() {
	  PathVisitor.call(this);
	}

	ThisExpressionVisitor.prototype = Object.create(PathVisitor.prototype);
	ThisExpressionVisitor.prototype.constructor = ThisExpressionVisitor;

	/**
	 * Indicates whether this visitor has visited a `this` expression.
	 *
	 * @type {boolean}
	 */
	ThisExpressionVisitor.prototype.hasThisExpression = false;

	/**
	 * Marks this visitor as having seen a `this` expression.
	 *
	 * @param {NodePath} path
	 */
	ThisExpressionVisitor.prototype.visitThisExpression = function(path) {
	  this.visitor.hasThisExpression = true;
	  return false;
	};

	/**
	 * Traverses deeper into arrow functions because they share `this` with their
	 * containing environment, but does not traverse into regular functions.
	 *
	 * @param {NodePath} path
	 * @returns {boolean}
	 */
	ThisExpressionVisitor.prototype.visitFunction = function(path) {
	  if (this.visitor.hasThisExpression) {
	    // Don't bother to look deeper if we already found one.
	    return false;
	  } else if (n.ArrowFunctionExpression.check(path.node)) {
	    this.traverse(path);
	  } else {
	    return false;
	  }
	};

	/**
	 * Convenience method for determining whether the given node has a `this`
	 * referred to at its scope.
	 *
	 * @example
	 *
	 * Given this code, this method would return `true`:
	 *
	 *    ```js
	 *    var a = () => this;
	 *    ```
	 *
	 * But this code would make it return `false`:
	 *
	 *    ```js
	 *    var a = () => function() { return this; };
	 *    ```
	 *
	 * @param node
	 * @returns {boolean}
	 */
	ThisExpressionVisitor.hasThisExpression = function(node) {
	  var visitor = new ThisExpressionVisitor();
	  types.visit(node, visitor);
	  return visitor.hasThisExpression;
	};

	module.exports = ThisExpressionVisitor;


/***/ },
/* 63 */
/***/ function(module, exports, __webpack_require__) {

	/* jshint node:true, undef:true, unused:true */

	var types = __webpack_require__(25);
	var b = types.builders;
	var n = types.namedTypes;
	var NodePath = types.NodePath;

	var getSecret = __webpack_require__(55).makeAccessor();
	var hasOwnProp = Object.prototype.hasOwnProperty;

	var assert = __webpack_require__(27);

	/**
	 * Re-export ast-types for ease of our users.
	 */
	exports.types = types;

	/**
	 * Export the Replacement helper for anything that needs to delay replacement.
	 */
	exports.Replacement = __webpack_require__(64);

	/**
	 * Returns a call to `Array.prototype.slice` with `node` as the context and
	 * `begin` and `end` as the arguments to `slice`.
	 *
	 * @param {Scope} scope
	 * @param {Expression} node
	 * @param {Expression|number=} begin
	 * @param {Expression|number=} end
	 * @return {CallExpression}
	 */
	function callArraySlice(scope, node, begin, end) {
	  if (typeof begin === 'number') {
	    begin = b.literal(begin);
	  }

	  if (typeof end === 'number') {
	    end = b.literal(end);
	  }

	  var args = [];
	  if (begin) { args.push(begin); }
	  if (end) { args.push(end); }

	  return callSharedMethodWithContext(
	    scope,
	    'Array.prototype.slice',
	    node,
	    args
	  );
	}
	exports.callArraySlice = callArraySlice;

	/**
	 * Returns a call to `Function.prototype.bind` using either `call` or `apply`
	 * depending on what the value of `args` is. If `args` is an expression then
	 * `apply` is used. If `args` is an array of expressions, then `call`.
	 *
	 * @param {Scope} scope
	 * @param {Expression} fn
	 * @param {Expression} context
	 * @param {Expression|Array.<Expression>} args
	 * @return {CallExpression}
	 */
	function callFunctionBind(scope, fn, context, args) {
	  var bind = sharedFor(scope, 'Function.prototype.bind');

	  if (n.Expression.check(args)) {
	    return b.callExpression(
	      b.memberExpression(bind, b.identifier('apply'), false),
	      [fn, b.callExpression(
	        b.memberExpression(
	          b.arrayExpression([context]),
	          b.identifier('concat'),
	          false
	        ),
	        [args]
	      )]
	    );
	  } else {
	    return b.callExpression(
	      b.memberExpression(bind, b.identifier('call'), false),
	      [fn, context].concat(args || [])
	    );
	  }
	}
	exports.callFunctionBind = callFunctionBind;

	/**
	 * Gets an iterator for the value representing the given expression.
	 *
	 * @param {Scope} scope
	 * @param {Expression} expression
	 * @return {CallExpression}
	 */
	function callGetIterator(scope, expression) {
	  var getIterator = injectGetIteratorHelper(scope.getGlobalScope());
	  return b.callExpression(getIterator, [expression]);
	}
	exports.callGetIterator = callGetIterator;

	/**
	 * Returns a reference to a shared function that implements the default
	 * `@@iterator` for arrays.
	 *
	 * @private
	 * @param {Scope} scope
	 * @return {CallExpression}
	 */
	function getArrayIterator(scope) {
	  return injectGetArrayIteratorHelper(scope.getGlobalScope());
	}
	exports.getArrayIterator = getArrayIterator;

	/**
	 * return a range of value from an iterator
	 *
	 * @param {Scope} scope
	 * @param {Expression} iterator
	 * @param {Literal} index
	 * @param {Literal} begin
	 * @param {Literal} len
	 * @return {CallExpression}
	 */
	function callGetIteratorRange(scope, iterator, index, begin, len) {
	  var getIteratorRange = injectGetIteratorRangeHelper(scope.getGlobalScope());
	  return b.callExpression(getIteratorRange, [iterator, index, begin, len]);
	}
	exports.callGetIteratorRange = callGetIteratorRange;

	/**
	 * The [[Get]] internal method on objects.
	 *
	 * @param {Scope} scope
	 * @param {Expression} object
	 * @param {Expression} property
	 * @param {Expression} receiver
	 * @return {CallExpression}
	 */
	function callGet(scope, object, property, receiver) {
	  var get = injectGetHelper(scope.getGlobalScope());
	  return b.callExpression(get, [object, property, receiver]);
	}
	exports.callGet = callGet;

	/**
	 * Returns a call to `Object.getOwnPropertyDescriptor` with the given `object`
	 * and `property`.
	 *
	 * @param {Scope} scope
	 * @param {Expression} object
	 * @param {Expression|string} property
	 * @return {CallExpression}
	 */
	function callGetOwnPropertyDescriptor(scope, object, property) {
	  if (typeof property === 'string') {
	    property = b.literal(property);
	  }

	  return callSharedMethod(
	    scope,
	    'Object.getOwnPropertyDescriptor',
	    [object, property]
	  );
	}
	exports.callGetOwnPropertyDescriptor = callGetOwnPropertyDescriptor;

	/**
	 * Returns a call to `Object.getPrototypeOf` with the given `object`.
	 *
	 * @param {Scope} scope
	 * @param {Expression} object
	 * @return {CallExpression}
	 */
	function callGetPrototypeOf(scope, object) {
	  return callSharedMethod(scope, 'Object.getPrototypeOf', [object]);
	}
	exports.callGetPrototypeOf = callGetPrototypeOf;

	/**
	 * Returns a call to `hasOwnProperty` with `node` as the context and `property`
	 * as the property to check.
	 *
	 * @param {Scope} scope
	 * @param {Expression} node
	 * @param {Expression|string} property
	 * @return {CallExpression}
	 */
	function callHasOwnProperty(scope, node, property) {
	  if (typeof property === 'string') {
	    property = b.literal(property);
	  }

	  return callSharedMethodWithContext(
	    scope,
	    'Object.prototype.hasOwnProperty',
	    node,
	    [property]
	  );
	}
	exports.callHasOwnProperty = callHasOwnProperty;

	/**
	 * Returns a call to the given `callee` with `args` as the arguments. If
	 * `callee` is a string then it is treated as a globally-accessible function
	 * such as `Object.defineProperty` which will be stored in a unique temporary
	 * variable. Subsequent calls to this function will re-use the same temporary
	 * variable.
	 *
	 * @param {Scope} scope
	 * @param {Expression|string} callee
	 * @param {Array.<Expression>} args
	 * @return {CallExpression}
	 */
	function callSharedMethod(scope, callee, args) {
	  if (typeof callee === 'string') {
	    callee = sharedFor(scope, callee);
	  }

	  return b.callExpression(callee, args);
	}
	exports.callSharedMethod = callSharedMethod;

	/**
	 * Returns a call to the given `callee` with `context` as the method context
	 * and `args` as the arguments. If `callee` is a string then it is treated as a
	 * globally-accessible function such as `Array.prototype.slice` which will be
	 * stored in a unique temporary variable. Subsequent calls to this function
	 * will re-use the same temporary variable.
	 *
	 * @param {Scope} scope
	 * @param {Expression|string} callee
	 * @param {Expression} context
	 * @param {Array.<Expression>} args
	 * @return {CallExpression}
	 */
	function callSharedMethodWithContext(scope, callee, context, args) {
	  if (typeof callee === 'string') {
	    callee = sharedFor(scope, callee);
	  }

	  return b.callExpression(
	    b.memberExpression(callee, b.identifier('call'), false),
	    [context].concat(args)
	  );
	}
	exports.callSharedMethodWithContext = callSharedMethodWithContext;

	/**
	 * Gets a list of identifiers referencing global variables anywhere within the
	 * given `ast`. Assuming the ast is for this code:
	 *
	 *   var a;
	 *   function b(){ return c; }
	 *   b(d);
	 *
	 * Then `getGlobals` will return two identifiers, `c` and `d`.
	 *
	 * @param {Node} ast
	 * @return {Array.<Identifier>}
	 */
	function getGlobals(ast) {
	  var globals = [];
	  var seen = Object.create(null);

	  types.visit(ast, {
	    visitNode: function(path) {
	      this.traverse(path);
	      var node = path.value;

	      if (isReference(path) && !path.scope.lookup(node.name)) {
	        if (!(node.name in seen)) {
	          seen[node.name] = true;
	          globals.push(node);
	        }
	      }
	    }
	  });

	  return globals;
	}
	exports.getGlobals = getGlobals;

	/**
	 * Generate a safe JavaScript identifier for the given string.
	 *
	 * @param {string} string
	 * @return {string}
	 * @private
	 */
	function identifierForString(string) {
	  // TODO: Verify this regex.
	  return string.replace(/[^\w\d\$_]/g, '$');
	}

	/**
	 * Injects the 'get' pre-built helper.
	 *
	 * @param {Scope} scope
	 * @return {Identifier}
	 */
	function injectGetHelper(scope) {
	  return injectShared(
	    scope,
	    'get',
	    function() {
	      return __webpack_require__(65)(scope);
	    }
	  );
	}

	/**
	 * Injects the 'getArrayIterator' pre-built helper.
	 *
	 * @param {Scope} scope
	 * @return {Identifier}
	 */
	function injectGetArrayIteratorHelper(scope) {
	  return injectShared(
	    scope,
	    'getArrayIterator',
	    function() {
	      return __webpack_require__(66)(scope);
	    }
	  );
	}

	/**
	 * Injects the 'getIterator' pre-built helper.
	 *
	 * @param {Scope} scope
	 * @return {Identifier}
	 */
	function injectGetIteratorHelper(scope) {
	  return injectShared(
	    scope,
	    'getIterator',
	    function() {
	      return __webpack_require__(67)(scope);
	    }
	  );
	}

	/**
	 * Injects the 'getIteratorRange' pre-built helper.
	 *
	 * @param {Scope} scope
	 * @return {Identifier}
	 */
	function injectGetIteratorRangeHelper(scope) {
	  return injectShared(
	    scope,
	    'getIteratorRange',
	    function() {
	      return __webpack_require__(68)(scope);
	    }
	  );
	}

	/**
	 * Injects a shared variable with a unique identifier. Only the first call with
	 * the same `scope` and `name` will result in a variable declaration being
	 * created. The `expression` passed in can either be an AST node or a function
	 * to generate one. This function is generally used to inject repeatedly-used
	 * values and prevent repeated execution.
	 *
	 * @param {Scope} scope
	 * @param {string} name
	 * @param {Expression|function(): Expression} expression
	 * @return {Identifier}
	 */
	function injectShared(scope, name, expression) {
	  var scopeSecret = getSecret(scope);

	  if (!(name in scopeSecret)) {
	    scopeSecret[name] = injectVariable(
	      scope,
	      uniqueIdentifier(scope, name),
	      typeof expression === 'function' ?
	        expression() :
	        expression
	    );
	  }

	  return scopeSecret[name];
	}
	exports.injectShared = injectShared;

	/**
	 * Injects a variable with the given `identifier` into the given `scope` as a
	 * `var` declaration with an optional initial value.
	 *
	 * @param {Scope} scope
	 * @param {Identifier} identifier
	 * @param {Expression=} init
	 * @return {Identifier} Returns the given `identifier`.
	 */
	function injectVariable(scope, identifier, init) {
	  var bodyPath = scope.path.get('body');

	  if (n.BlockStatement.check(bodyPath.value)) {
	    bodyPath = bodyPath.get('body');
	  }

	  var declarationIndex;
	  var bodyStatements = bodyPath.node.body;

	  for (declarationIndex = 0; declarationIndex < bodyStatements.length; declarationIndex++) {
	    var statement = bodyStatements[declarationIndex];
	    if (!isDirectivePrologue(statement)) {
	      break;
	    }
	  }

	  bodyPath.insertAt(
	    declarationIndex,
	    b.variableDeclaration(
	      'var',
	      [b.variableDeclarator(identifier, init || null)]
	    )
	  );

	  // Ensure this identifier counts as used in this scope.
	  var name = identifier.name;
	  var bindings = scope.getBindings();
	  if (!hasOwnProp.call(bindings, name)) {
	    bindings[name] = [];
	  }
	  bindings[name].push(new NodePath(identifier));

	  return identifier;
	}
	exports.injectVariable = injectVariable;

	/**
	 * Determines whether the given statement is a directive prologue, e.g.
	 * "use strict".
	 *
	 * @param {Statement} statement
	 * @returns {boolean}
	 */
	function isDirectivePrologue(statement) {
	  if (n.ExpressionStatement.check(statement)) {
	    var expression = statement.expression;
	    if (n.Literal.check(expression)) {
	      return typeof expression.value === 'string';
	    }
	  }

	  return false;
	}

	/**
	 * Determines whether the given `path` is a value reference. For example, `a`
	 * and `b` are references, but `c` is not:
	 *
	 *    a(b.c);
	 *
	 * Only identifiers count as references.
	 *
	 * @param {NodePath} path
	 * @param {string=} name
	 * @return {boolean}
	 */
	function isReference(path, name) {
	  var node = path.value;
	  assert.ok(n.Node.check(node));

	  if (n.Identifier.check(node)) {
	    if (name && node.name !== name) { return false; }

	    var parent = path.parent.value;
	    if (n.VariableDeclarator.check(parent)) {
	      return parent.init === node;
	    } else if (n.MemberExpression.check(parent)) {
	      return parent.object === node || (
	        parent.computed && parent.property === node
	      );
	    } else if (n.Function.check(parent)) {
	      return parent.id !== node && !parent.params.some(function(param) {
	        return param === node;
	      });
	    } else if (n.ClassDeclaration.check(parent) || n.ClassExpression.check(parent)) {
	      return parent.id !== node;
	    } else if (n.CatchClause.check(parent)) {
	      return parent.param !== node;
	    } else if (n.Property.check(parent)) {
	      return parent.key !== node;
	    } else if (n.MethodDefinition.check(parent)) {
	      return parent.key !== node;
	    } else if (n.ImportSpecifier.check(parent)) {
	      return false;
	    } else if (n.ImportDefaultSpecifier.check(parent)) {
	      return false;
	    } else if (n.ImportNamespaceSpecifier.check(parent)) {
	      return false;
	    } else if (n.LabeledStatement.check(parent)) {
	      return false;
	    } else {
	      return true;
	    }
	  }

	  return false;
	}
	exports.isReference = isReference;

	/**
	 * Determines whether the given `name` should be considered "used" in the given
	 * `scope`. For a name to be used, it should either:
	 *
	 *   1. Be declared in this scope or a parent scope.
	 *   2. Be referenced in this scope, a parent scope, or any child scopes.
	 *
	 * For example, `a`, `b`, and `d` are used in the global scope of this example
	 * while `c` is not:
	 *
	 *   var a;
	 *   function b() {}
	 *
	 *   try {
	 *     a = b(d);
	 *   } catch (c) {
	 *   }
	 *
	 * @param {Scope} scope
	 * @param {string} name
	 * @return {boolean}
	 */
	function isUsed(scope, name) {
	  if (scope.lookup(name)) {
	    return true;
	  }

	  var globalScope = scope.getGlobalScope();
	  var globalScopeSecret = getSecret(globalScope);

	  if (!globalScopeSecret.globals) {
	    globalScopeSecret.globals = getGlobals(globalScope.node);
	  }

	  return globalScopeSecret.globals.some(function(global) {
	    return global.name === name;
	  });
	}
	exports.isUsed = isUsed;

	/**
	 * Injects a shared variable by getting the named value from a dotted path. For
	 * example, this will return an identifier that can be used in place of the
	 * named expression:
	 *
	 *    sharedFor(scope, 'Object.defineProperty')
	 *
	 * Subsequent calls to `sharedFor` in the same scope will return the same
	 * identifier.
	 *
	 * @param {Scope} scope
	 * @param {string} name
	 * @return {Identifier}
	 */
	function sharedFor(scope, name) {
	  return injectShared(
	    scope,
	    name,
	    function() {
	      var parts = name.split('.');
	      var result = b.identifier(parts[0]);

	      for (var i = 1, length = parts.length; i < length; i++) {
	        result = b.memberExpression(
	          result,
	          b.identifier(parts[i]),
	          false
	        );
	      }

	      return result;
	    }
	  );
	}
	exports.sharedFor = sharedFor;

	/**
	 * Generates an identifier guaranteed not to collide with any others in the
	 * given `scope`. This function will also never generate the same identifier
	 * twice for any `scope` whose global scope already got that identifier.
	 *
	 * Called in a scope with no global references and no variables, the first time
	 * this function is called it will return an identifier named `$__0`.
	 *
	 * When called with a name that name will be used with a prefix, "$__", if
	 * possible. If that name is already used then it will append incrementing
	 * numbers until it finds a name that isn't used.
	 *
	 * @param {Scope} scope
	 * @param {string=} name
	 * @return {Identifier}
	 * @see isUsed
	 */
	function uniqueIdentifier(scope, name) {
	  var prefix = '$__' + identifierForString(name ? name : '');
	  var globalScopeSecret = getSecret(scope.getGlobalScope());
	  var n = globalScopeSecret.nextId || 0;
	  var identifier = name ? prefix : null;

	  while (!identifier || isUsed(scope, identifier)) {
	    identifier = prefix + n;
	    n++;
	  }

	  globalScopeSecret.nextId = n;

	  return b.identifier(identifier);
	}
	exports.uniqueIdentifier = uniqueIdentifier;


/***/ },
/* 64 */
/***/ function(module, exports) {

	/* jshint node:true, undef:true, unused:true */

	/**
	 * Represents a replacement of a node path with zero or more nodes.
	 *
	 * @constructor
	 * @param {NodePath} nodePath
	 * @param {Array.<Node>} nodes
	 */
	function Replacement(nodePath, nodes) {
	  this.queue = [];
	  if (nodePath && nodes) {
	    this.queue.push([nodePath, nodes]);
	  }
	}

	/**
	 * Performs the replacement.
	 */
	Replacement.prototype.replace = function() {
	  for (var i = 0, length = this.queue.length; i < length; i++) {
	    var item = this.queue[i];
	    item[0].replace.apply(item[0], item[1]);
	  }
	};

	/**
	 * Incorporates the replacements from the given Replacement into this one.
	 *
	 * @param {Replacement} anotherReplacement
	 */
	Replacement.prototype.and = function(anotherReplacement) {
	  this.queue.push.apply(this.queue, anotherReplacement.queue);
	  return this;
	};

	/**
	 * Constructs a Replacement that, when run, will remove the node from the AST.
	 *
	 * @param {NodePath} nodePath
	 * @returns {Replacement}
	 */
	Replacement.removes = function(nodePath) {
	  return new Replacement(nodePath, []);
	};

	/**
	 * Constructs a Replacement that, when run, will insert the given nodes after
	 * the one in nodePath.
	 *
	 * @param {NodePath} nodePath
	 * @param {Array.<Node>} nodes
	 * @returns {Replacement}
	 */
	Replacement.adds = function(nodePath, nodes) {
	  return new Replacement(nodePath, [nodePath.node].concat(nodes));
	};

	/**
	 * Constructs a Replacement that, when run, swaps the node in nodePath with the
	 * given node or nodes.
	 *
	 * @param {NodePath} nodePath
	 * @param {Node|Array.<Node>} nodes
	 */
	Replacement.swaps = function(nodePath, nodes) {
	  if ({}.toString.call(nodes) !== '[object Array]') {
	    nodes = [nodes];
	  }
	  return new Replacement(nodePath, nodes);
	};

	/**
	 * Build replacements for each of the items in nodePaths by passing them to the
	 * given callback. If the callback returns null for a given node path then no
	 * replacement will be created for that node.
	 *
	 * @param {Array.<NodePath>} nodePaths
	 * @param {function(NodePath): ?Replacement} callback
	 * @returns {Replacement}
	 */
	Replacement.map = function(nodePaths, callback) {
	  var result = new Replacement();

	  nodePaths.each(function(nodePath) {
	    var replacement = callback(nodePath);
	    if (replacement) {
	      result.and(replacement);
	    }
	  });

	  return result;
	};

	module.exports = Replacement;


/***/ },
/* 65 */
/***/ function(module, exports, __webpack_require__) {

	var b = __webpack_require__(25).builders;
	module.exports = function(scope) {
	  return b.functionExpression(
	  b.identifier('get'),
	  [
	    b.identifier('object'),
	    b.identifier('property'),
	    b.identifier('receiver')
	  ],
	  b.blockStatement([
	    b.variableDeclaration(
	      'var',
	      [
	        b.variableDeclarator(
	          b.identifier('desc'),
	          b.callExpression(
	            b.memberExpression(
	              b.identifier('Object'),
	              b.identifier('getOwnPropertyDescriptor'),
	              false
	            ),
	            [
	              b.identifier('object'),
	              b.identifier('property')
	            ]
	          )
	        )
	      ]
	    ),
	    b.ifStatement(
	      b.binaryExpression(
	        '===',
	        b.identifier('desc'),
	        b.unaryExpression(
	          'void',
	          b.literal(0),
	          true
	        )
	      ),
	      b.blockStatement([
	        b.variableDeclaration(
	          'var',
	          [
	            b.variableDeclarator(
	              b.identifier('parent'),
	              b.callExpression(
	                b.memberExpression(
	                  b.identifier('Object'),
	                  b.identifier('getPrototypeOf'),
	                  false
	                ),
	                [b.identifier('object')]
	              )
	            )
	          ]
	        ),
	        b.ifStatement(
	          b.binaryExpression(
	            '===',
	            b.identifier('parent'),
	            b.literal(null)
	          ),
	          b.blockStatement([
	            b.returnStatement(
	              b.unaryExpression(
	                'void',
	                b.literal(0),
	                true
	              )
	            )
	          ]),
	          b.blockStatement([
	            b.returnStatement(
	              b.callExpression(
	                b.identifier('get'),
	                [
	                  b.identifier('parent'),
	                  b.identifier('property'),
	                  b.identifier('receiver')
	                ]
	              )
	            )
	          ])
	        )
	      ]),
	      b.ifStatement(
	        b.logicalExpression(
	          '&&',
	          b.binaryExpression(
	            'in',
	            b.literal('value'),
	            b.identifier('desc')
	          ),
	          b.binaryExpression(
	            'in',
	            b.literal('writable'),
	            b.identifier('desc')
	          )
	        ),
	        b.blockStatement([
	          b.returnStatement(
	            b.memberExpression(
	              b.identifier('desc'),
	              b.identifier('value'),
	              false
	            )
	          )
	        ]),
	        b.blockStatement([
	          b.variableDeclaration(
	            'var',
	            [
	              b.variableDeclarator(
	                b.identifier('getter'),
	                b.memberExpression(
	                  b.identifier('desc'),
	                  b.identifier('get'),
	                  false
	                )
	              )
	            ]
	          ),
	          b.ifStatement(
	            b.binaryExpression(
	              '===',
	              b.identifier('getter'),
	              b.unaryExpression(
	                'void',
	                b.literal(0),
	                true
	              )
	            ),
	            b.blockStatement([
	              b.returnStatement(
	                b.unaryExpression(
	                  'void',
	                  b.literal(0),
	                  true
	                )
	              )
	            ]),
	            null
	          ),
	          b.returnStatement(
	            b.callExpression(
	              b.memberExpression(
	                b.identifier('getter'),
	                b.identifier('call'),
	                false
	              ),
	              [b.identifier('receiver')]
	            )
	          )
	        ])
	      )
	    )
	  ]),
	  false,
	  false
	)};


/***/ },
/* 66 */
/***/ function(module, exports, __webpack_require__) {

	var b = __webpack_require__(25).builders;
	module.exports = function(scope) {
	  return b.functionExpression(
	  null,
	  [b.identifier('array')],
	  b.blockStatement([
	    b.variableDeclaration(
	      'var',
	      [
	        b.variableDeclarator(
	          b.identifier('index'),
	          b.literal(0)
	        )
	      ]
	    ),
	    b.returnStatement(
	      b.objectExpression([
	        b.property(
	          'init',
	          b.identifier('next'),
	          b.functionExpression(
	            null,
	            [],
	            b.blockStatement([
	              b.ifStatement(
	                b.binaryExpression(
	                  '<',
	                  b.identifier('index'),
	                  b.memberExpression(
	                    b.identifier('array'),
	                    b.identifier('length'),
	                    false
	                  )
	                ),
	                b.blockStatement([
	                  b.returnStatement(
	                    b.objectExpression([
	                      b.property(
	                        'init',
	                        b.identifier('done'),
	                        b.literal(false)
	                      ),
	                      b.property(
	                        'init',
	                        b.identifier('value'),
	                        b.memberExpression(
	                          b.identifier('array'),
	                          b.updateExpression(
	                            '++',
	                            b.identifier('index'),
	                            false
	                          ),
	                          true
	                        )
	                      )
	                    ])
	                  )
	                ]),
	                b.blockStatement([
	                  b.returnStatement(
	                    b.objectExpression([
	                      b.property(
	                        'init',
	                        b.identifier('done'),
	                        b.literal(true)
	                      ),
	                      b.property(
	                        'init',
	                        b.identifier('value'),
	                        b.unaryExpression(
	                          'void',
	                          b.literal(0),
	                          true
	                        )
	                      )
	                    ])
	                  )
	                ])
	              )
	            ]),
	            false,
	            false
	          )
	        )
	      ])
	    )
	  ]),
	  false,
	  false
	)};


/***/ },
/* 67 */
/***/ function(module, exports, __webpack_require__) {

	var b = __webpack_require__(25).builders;
	module.exports = function(scope) {
	  var getArrayIterator = __webpack_require__(63).getArrayIterator;

	  return b.functionExpression(
	  null,
	  [b.identifier('iterable')],
	  b.blockStatement([
	    b.variableDeclaration(
	      'var',
	      [
	        b.variableDeclarator(
	          b.identifier('sym'),
	          b.logicalExpression(
	            '||',
	            b.logicalExpression(
	              '&&',
	              b.binaryExpression(
	                '===',
	                b.unaryExpression(
	                  'typeof',
	                  b.identifier('Symbol'),
	                  true
	                ),
	                b.literal('function')
	              ),
	              b.memberExpression(
	                b.identifier('Symbol'),
	                b.identifier('iterator'),
	                false
	              )
	            ),
	            b.literal('@@iterator')
	          )
	        )
	      ]
	    ),
	    b.ifStatement(
	      b.binaryExpression(
	        '===',
	        b.unaryExpression(
	          'typeof',
	          b.memberExpression(
	            b.identifier('iterable'),
	            b.identifier('sym'),
	            true
	          ),
	          true
	        ),
	        b.literal('function')
	      ),
	      b.blockStatement([
	        b.returnStatement(
	          b.callExpression(
	            b.memberExpression(
	              b.identifier('iterable'),
	              b.identifier('sym'),
	              true
	            ),
	            []
	          )
	        )
	      ]),
	      b.ifStatement(
	        b.logicalExpression(
	          '||',
	          b.binaryExpression(
	            '===',
	            b.unaryExpression(
	              'typeof',
	              b.identifier('iterable'),
	              true
	            ),
	            b.literal('object')
	          ),
	          b.binaryExpression(
	            '===',
	            b.unaryExpression(
	              'typeof',
	              b.identifier('iterable'),
	              true
	            ),
	            b.literal('function')
	          )
	        ),
	        b.blockStatement([
	          b.returnStatement(
	            b.callExpression(
	              getArrayIterator(scope),
	              [b.identifier('iterable')]
	            )
	          )
	        ]),
	        b.blockStatement([
	          b.throwStatement(
	            b.newExpression(
	              b.identifier('TypeError'),
	              []
	            )
	          )
	        ])
	      )
	    )
	  ]),
	  false,
	  false
	)};


/***/ },
/* 68 */
/***/ function(module, exports, __webpack_require__) {

	var b = __webpack_require__(25).builders;
	module.exports = function(scope) {
	  return b.functionExpression(
	  null,
	  [
	    b.identifier('iterator'),
	    b.identifier('index'),
	    b.identifier('begin'),
	    b.identifier('len')
	  ],
	  b.blockStatement([
	    b.ifStatement(
	      b.binaryExpression(
	        '>',
	        b.identifier('index'),
	        b.identifier('begin')
	      ),
	      b.blockStatement([
	        b.throwStatement(
	          b.newExpression(
	            b.identifier('RangeError'),
	            []
	          )
	        )
	      ]),
	      null
	    ),
	    b.ifStatement(
	      b.binaryExpression(
	        '===',
	        b.unaryExpression(
	          'typeof',
	          b.identifier('len'),
	          true
	        ),
	        b.literal('undefined')
	      ),
	      b.blockStatement([
	        b.expressionStatement(
	          b.assignmentExpression(
	            '=',
	            b.identifier('len'),
	            b.identifier('Infinity')
	          )
	        )
	      ]),
	      null
	    ),
	    b.variableDeclaration(
	      'var',
	      [
	        b.variableDeclarator(
	          b.identifier('range'),
	          b.arrayExpression([])
	        ),
	        b.variableDeclarator(
	          b.identifier('end'),
	          b.binaryExpression(
	            '+',
	            b.identifier('begin'),
	            b.identifier('len')
	          )
	        )
	      ]
	    ),
	    b.whileStatement(
	      b.binaryExpression(
	        '<',
	        b.identifier('index'),
	        b.identifier('end')
	      ),
	      b.blockStatement([
	        b.variableDeclaration(
	          'var',
	          [
	            b.variableDeclarator(
	              b.identifier('next'),
	              b.callExpression(
	                b.memberExpression(
	                  b.identifier('iterator'),
	                  b.identifier('next'),
	                  false
	                ),
	                []
	              )
	            )
	          ]
	        ),
	        b.ifStatement(
	          b.memberExpression(
	            b.identifier('next'),
	            b.identifier('done'),
	            false
	          ),
	          b.blockStatement([b.breakStatement()]),
	          null
	        ),
	        b.ifStatement(
	          b.binaryExpression(
	            '>=',
	            b.identifier('index'),
	            b.identifier('begin')
	          ),
	          b.blockStatement([
	            b.expressionStatement(
	              b.callExpression(
	                b.memberExpression(
	                  b.identifier('range'),
	                  b.identifier('push'),
	                  false
	                ),
	                [
	                  b.memberExpression(
	                    b.identifier('next'),
	                    b.identifier('value'),
	                    false
	                  )
	                ]
	              )
	            )
	          ]),
	          null
	        ),
	        b.expressionStatement(
	          b.updateExpression(
	            '++',
	            b.identifier('index'),
	            false
	          )
	        )
	      ])
	    ),
	    b.returnStatement(
	      b.objectExpression([
	        b.property(
	          'init',
	          b.identifier('range'),
	          b.identifier('range')
	        ),
	        b.property(
	          'init',
	          b.identifier('index'),
	          b.identifier('index')
	        )
	      ])
	    )
	  ]),
	  false,
	  false
	)};


/***/ },
/* 69 */
/***/ function(module, exports, __webpack_require__) {

	// Generated by CoffeeScript 1.10.0
	var StringDecoder, parse;

	StringDecoder = __webpack_require__(70).StringDecoder;

	parse = __webpack_require__(71);

	module.exports = function(data, options) {
	  var decoder, parser, records;
	  if (options == null) {
	    options = {};
	  }
	  records = options.objname ? {} : [];
	  if (data instanceof Buffer) {
	    decoder = new StringDecoder();
	    data = decoder.write(data);
	  }
	  parser = new parse.Parser(options);
	  parser.push = function(record) {
	    if (options.objname) {
	      return records[record[0]] = record[1];
	    } else {
	      return records.push(record);
	    }
	  };
	  parser.__write(data, false);
	  if (data instanceof Buffer) {
	    parser.__write(data.end(), true);
	  }
	  parser._flush((function() {}));
	  return records;
	};


/***/ },
/* 70 */
/***/ function(module, exports) {

	module.exports = require("string_decoder");

/***/ },
/* 71 */
/***/ function(module, exports, __webpack_require__) {

	// Generated by CoffeeScript 1.10.0
	var Parser, StringDecoder, stream, util;

	stream = __webpack_require__(8);

	util = __webpack_require__(12);

	StringDecoder = __webpack_require__(70).StringDecoder;

	module.exports = function() {
	  var callback, called, chunks, data, options, parser;
	  if (arguments.length === 3) {
	    data = arguments[0];
	    options = arguments[1];
	    callback = arguments[2];
	    if (typeof callback !== 'function') {
	      throw Error("Invalid callback argument: " + (JSON.stringify(callback)));
	    }
	    if (!(typeof data === 'string' || Buffer.isBuffer(arguments[0]))) {
	      return callback(Error("Invalid data argument: " + (JSON.stringify(data))));
	    }
	  } else if (arguments.length === 2) {
	    if (typeof arguments[0] === 'string' || Buffer.isBuffer(arguments[0])) {
	      data = arguments[0];
	    } else {
	      options = arguments[0];
	    }
	    if (typeof arguments[1] === 'function') {
	      callback = arguments[1];
	    } else {
	      options = arguments[1];
	    }
	  } else if (arguments.length === 1) {
	    if (typeof arguments[0] === 'function') {
	      callback = arguments[0];
	    } else {
	      options = arguments[0];
	    }
	  }
	  if (options == null) {
	    options = {};
	  }
	  parser = new Parser(options);
	  if (data != null) {
	    process.nextTick(function() {
	      parser.write(data);
	      return parser.end();
	    });
	  }
	  if (callback) {
	    called = false;
	    chunks = options.objname ? {} : [];
	    parser.on('readable', function() {
	      var chunk, results;
	      results = [];
	      while (chunk = parser.read()) {
	        if (options.objname) {
	          results.push(chunks[chunk[0]] = chunk[1]);
	        } else {
	          results.push(chunks.push(chunk));
	        }
	      }
	      return results;
	    });
	    parser.on('error', function(err) {
	      called = true;
	      return callback(err);
	    });
	    parser.on('end', function() {
	      if (!called) {
	        return callback(null, chunks);
	      }
	    });
	  }
	  return parser;
	};

	Parser = function(options) {
	  var base, base1, base10, base11, base12, base13, base14, base15, base16, base2, base3, base4, base5, base6, base7, base8, base9, k, v;
	  if (options == null) {
	    options = {};
	  }
	  options.objectMode = true;
	  this.options = {};
	  for (k in options) {
	    v = options[k];
	    this.options[k] = v;
	  }
	  stream.Transform.call(this, this.options);
	  if ((base = this.options).rowDelimiter == null) {
	    base.rowDelimiter = null;
	  }
	  if (typeof this.options.rowDelimiter === 'string') {
	    this.options.rowDelimiter = [this.options.rowDelimiter];
	  }
	  if ((base1 = this.options).delimiter == null) {
	    base1.delimiter = ',';
	  }
	  if ((base2 = this.options).quote == null) {
	    base2.quote = '"';
	  }
	  if ((base3 = this.options).escape == null) {
	    base3.escape = '"';
	  }
	  if ((base4 = this.options).columns == null) {
	    base4.columns = null;
	  }
	  if ((base5 = this.options).comment == null) {
	    base5.comment = '';
	  }
	  if ((base6 = this.options).objname == null) {
	    base6.objname = false;
	  }
	  if ((base7 = this.options).trim == null) {
	    base7.trim = false;
	  }
	  if ((base8 = this.options).ltrim == null) {
	    base8.ltrim = false;
	  }
	  if ((base9 = this.options).rtrim == null) {
	    base9.rtrim = false;
	  }
	  if ((base10 = this.options).auto_parse == null) {
	    base10.auto_parse = false;
	  }
	  if ((base11 = this.options).auto_parse_date == null) {
	    base11.auto_parse_date = false;
	  }
	  if ((base12 = this.options).relax == null) {
	    base12.relax = false;
	  }
	  if ((base13 = this.options).relax_column_count == null) {
	    base13.relax_column_count = false;
	  }
	  if ((base14 = this.options).skip_empty_lines == null) {
	    base14.skip_empty_lines = false;
	  }
	  if ((base15 = this.options).max_limit_on_data_read == null) {
	    base15.max_limit_on_data_read = 128000;
	  }
	  if ((base16 = this.options).skip_lines_with_empty_values == null) {
	    base16.skip_lines_with_empty_values = false;
	  }
	  this.lines = 0;
	  this.count = 0;
	  this.skipped_line_count = 0;
	  this.empty_line_count = 0;
	  this.is_int = /^(\-|\+)?([1-9]+[0-9]*)$/;
	  this.is_float = function(value) {
	    return (value - parseFloat(value) + 1) >= 0;
	  };
	  this._ = {};
	  this._.decoder = new StringDecoder();
	  this._.quoting = false;
	  this._.commenting = false;
	  this._.field = null;
	  this._.nextChar = null;
	  this._.closingQuote = 0;
	  this._.line = [];
	  this._.chunks = [];
	  this._.rawBuf = '';
	  this._.buf = '';
	  if (this.options.rowDelimiter) {
	    this._.rowDelimiterLength = Math.max.apply(Math, this.options.rowDelimiter.map(function(v) {
	      return v.length;
	    }));
	  }
	  return this;
	};

	util.inherits(Parser, stream.Transform);

	module.exports.Parser = Parser;

	Parser.prototype._transform = function(chunk, encoding, callback) {
	  var err, error;
	  if (chunk instanceof Buffer) {
	    chunk = this._.decoder.write(chunk);
	  }
	  try {
	    this.__write(chunk, false);
	    return callback();
	  } catch (error) {
	    err = error;
	    return this.emit('error', err);
	  }
	};

	Parser.prototype._flush = function(callback) {
	  var err, error;
	  try {
	    this.__write(this._.decoder.end(), true);
	    if (this._.quoting) {
	      this.emit('error', new Error("Quoted field not terminated at line " + (this.lines + 1)));
	      return;
	    }
	    if (this._.line.length > 0) {
	      this.__push(this._.line);
	    }
	    return callback();
	  } catch (error) {
	    err = error;
	    return this.emit('error', err);
	  }
	};

	Parser.prototype.__push = function(line) {
	  var field, i, j, len, lineAsColumns, rawBuf, row;
	  if (this.options.skip_lines_with_empty_values && line.join('').trim() === '') {
	    return;
	  }
	  row = null;
	  if (this.options.columns === true) {
	    this.options.columns = line;
	    rawBuf = '';
	    return;
	  } else if (typeof this.options.columns === 'function') {
	    this.options.columns = this.options.columns(line);
	    rawBuf = '';
	    return;
	  }
	  if (!this._.line_length && line.length > 0) {
	    this._.line_length = this.options.columns ? this.options.columns.length : line.length;
	  }
	  if (line.length === 1 && line[0] === '') {
	    this.empty_line_count++;
	  } else if (line.length !== this._.line_length) {
	    if (this.options.relax_column_count) {
	      this.skipped_line_count++;
	    } else if (this.options.columns != null) {
	      throw Error("Number of columns on line " + this.lines + " does not match header");
	    } else {
	      throw Error("Number of columns is inconsistent on line " + this.lines);
	    }
	  } else {
	    this.count++;
	  }
	  if (this.options.columns != null) {
	    lineAsColumns = {};
	    for (i = j = 0, len = line.length; j < len; i = ++j) {
	      field = line[i];
	      if (this.options.columns[i] === false) {
	        continue;
	      }
	      lineAsColumns[this.options.columns[i]] = field;
	    }
	    if (this.options.objname) {
	      row = [lineAsColumns[this.options.objname], lineAsColumns];
	    } else {
	      row = lineAsColumns;
	    }
	  } else {
	    row = line;
	  }
	  if (this.count < this.options.from) {
	    return;
	  }
	  if (this.count > this.options.to) {
	    return;
	  }
	  if (this.options.raw) {
	    this.push({
	      raw: this._.rawBuf,
	      row: row
	    });
	    return this._.rawBuf = '';
	  } else {
	    return this.push(row);
	  }
	};

	Parser.prototype.__write = function(chars, end) {
	  var areNextCharsDelimiter, areNextCharsRowDelimiters, auto_parse, char, escapeIsQuote, i, isDelimiter, isEscape, isNextCharAComment, isQuote, isRowDelimiter, isRowDelimiterLength, is_float, is_int, l, ltrim, nextCharPos, ref, ref1, ref2, ref3, ref4, remainingBuffer, results, rowDelimiter, rtrim, wasCommenting;
	  is_int = (function(_this) {
	    return function(value) {
	      if (typeof _this.is_int === 'function') {
	        return _this.is_int(value);
	      } else {
	        return _this.is_int.test(value);
	      }
	    };
	  })(this);
	  is_float = (function(_this) {
	    return function(value) {
	      if (typeof _this.is_float === 'function') {
	        return _this.is_float(value);
	      } else {
	        return _this.is_float.test(value);
	      }
	    };
	  })(this);
	  auto_parse = (function(_this) {
	    return function(value) {
	      var m;
	      if (!_this.options.auto_parse) {
	        return value;
	      }
	      if (is_int(value)) {
	        value = parseInt(value);
	      } else if (is_float(value)) {
	        value = parseFloat(value);
	      } else if (_this.options.auto_parse_date) {
	        m = Date.parse(value);
	        if (!isNaN(m)) {
	          value = new Date(m);
	        }
	      }
	      return value;
	    };
	  })(this);
	  ltrim = this.options.trim || this.options.ltrim;
	  rtrim = this.options.trim || this.options.rtrim;
	  chars = this._.buf + chars;
	  l = chars.length;
	  i = 0;
	  if (this.lines === 0 && 0xFEFF === chars.charCodeAt(0)) {
	    i++;
	  }
	  while (i < l) {
	    if (!end) {
	      remainingBuffer = chars.substr(i, l - i);
	      if ((!this.options.rowDelimiter && i + 3 > l) || (!this._.commenting && l - i < this.options.comment.length && this.options.comment.substr(0, l - i) === remainingBuffer) || (this.options.rowDelimiter && l - i < this._.rowDelimiterLength && this.options.rowDelimiter.some(function(rd) {
	        return rd.substr(0, l - i) === remainingBuffer;
	      })) || (this.options.rowDelimiter && this._.quoting && l - i < (this.options.quote.length + this._.rowDelimiterLength) && this.options.rowDelimiter.some((function(_this) {
	        return function(rd) {
	          return (_this.options.quote + rd).substr(0, l - i) === remainingBuffer;
	        };
	      })(this))) || (l - i <= this.options.delimiter.length && this.options.delimiter.substr(0, l - i) === remainingBuffer) || (l - i <= this.options.escape.length && this.options.escape.substr(0, l - i) === remainingBuffer)) {
	        break;
	      }
	    }
	    char = this._.nextChar ? this._.nextChar : chars.charAt(i);
	    this._.nextChar = l > i + 1 ? chars.charAt(i + 1) : '';
	    if (this.options.raw) {
	      this._.rawBuf += char;
	    }
	    if (this.options.rowDelimiter == null) {
	      nextCharPos = i;
	      rowDelimiter = null;
	      if (!this._.quoting && (char === '\n' || char === '\r')) {
	        rowDelimiter = char;
	        nextCharPos += 1;
	      } else if (!(!this._.quoting && char === this.options.quote) && (this._.nextChar === '\n' || this._.nextChar === '\r')) {
	        rowDelimiter = this._.nextChar;
	        nextCharPos += 2;
	        if (this.raw) {
	          rawBuf += this._.nextChar;
	        }
	      }
	      if (rowDelimiter) {
	        if (rowDelimiter === '\r' && chars.charAt(nextCharPos) === '\n') {
	          rowDelimiter += '\n';
	        }
	        this.options.rowDelimiter = [rowDelimiter];
	        this._.rowDelimiterLength = rowDelimiter.length;
	      }
	    }
	    if (!this._.commenting && char === this.options.escape) {
	      escapeIsQuote = this.options.escape === this.options.quote;
	      isEscape = this._.nextChar === this.options.escape;
	      isQuote = this._.nextChar === this.options.quote;
	      if (!(escapeIsQuote && (this._.field == null) && !this._.quoting) && (isEscape || isQuote)) {
	        i++;
	        char = this._.nextChar;
	        this._.nextChar = chars.charAt(i + 1);
	        if (this._.field == null) {
	          this._.field = '';
	        }
	        this._.field += char;
	        if (this.options.raw) {
	          this._.rawBuf += char;
	        }
	        i++;
	        continue;
	      }
	    }
	    if (!this._.commenting && char === this.options.quote) {
	      if (this._.quoting) {
	        areNextCharsRowDelimiters = this.options.rowDelimiter && this.options.rowDelimiter.some(function(rd) {
	          return chars.substr(i + 1, rd.length) === rd;
	        });
	        areNextCharsDelimiter = chars.substr(i + 1, this.options.delimiter.length) === this.options.delimiter;
	        isNextCharAComment = this._.nextChar === this.options.comment;
	        if (this._.nextChar && !areNextCharsRowDelimiters && !areNextCharsDelimiter && !isNextCharAComment) {
	          if (this.options.relax) {
	            this._.quoting = false;
	            this._.field = "" + this.options.quote + this._.field;
	          } else {
	            throw Error("Invalid closing quote at line " + (this.lines + 1) + "; found " + (JSON.stringify(this._.nextChar)) + " instead of delimiter " + (JSON.stringify(this.options.delimiter)));
	          }
	        } else {
	          this._.quoting = false;
	          this._.closingQuote = this.options.quote.length;
	          i++;
	          if (end && i === l) {
	            this._.line.push(auto_parse(this._.field || ''));
	            this._.field = null;
	          }
	          continue;
	        }
	      } else if (!this._.field) {
	        this._.quoting = true;
	        i++;
	        continue;
	      } else if ((this._.field != null) && !this.options.relax) {
	        throw Error("Invalid opening quote at line " + (this.lines + 1));
	      }
	    }
	    isRowDelimiter = this.options.rowDelimiter && this.options.rowDelimiter.some(function(rd) {
	      return chars.substr(i, rd.length) === rd;
	    });
	    if (isRowDelimiter) {
	      isRowDelimiterLength = this.options.rowDelimiter.filter(function(rd) {
	        return chars.substr(i, rd.length) === rd;
	      })[0].length;
	    }
	    if (isRowDelimiter || (end && i === l - 1)) {
	      this.lines++;
	    }
	    wasCommenting = false;
	    if (!this._.commenting && !this._.quoting && this.options.comment && chars.substr(i, this.options.comment.length) === this.options.comment) {
	      this._.commenting = true;
	    } else if (this._.commenting && isRowDelimiter) {
	      wasCommenting = true;
	      this._.commenting = false;
	    }
	    isDelimiter = chars.substr(i, this.options.delimiter.length) === this.options.delimiter;
	    if (!this._.commenting && !this._.quoting && (isDelimiter || isRowDelimiter)) {
	      if (isRowDelimiter && this._.line.length === 0 && (this._.field == null)) {
	        if (wasCommenting || this.options.skip_empty_lines) {
	          i += isRowDelimiterLength;
	          this._.nextChar = chars.charAt(i);
	          continue;
	        }
	      }
	      if (rtrim) {
	        if (!this._.closingQuote) {
	          this._.field = (ref = this._.field) != null ? ref.trimRight() : void 0;
	        }
	      }
	      this._.line.push(auto_parse(this._.field || ''));
	      this._.closingQuote = 0;
	      this._.field = null;
	      if (isDelimiter) {
	        i += this.options.delimiter.length;
	        this._.nextChar = chars.charAt(i);
	        if (end && !this._.nextChar) {
	          isRowDelimiter = true;
	          this._.line.push('');
	        }
	      }
	      if (isRowDelimiter) {
	        this.__push(this._.line);
	        this._.line = [];
	        i += isRowDelimiterLength;
	        this._.nextChar = chars.charAt(i);
	        continue;
	      }
	    } else if (!this._.commenting && !this._.quoting && (char === ' ' || char === '\t')) {
	      if (this._.field == null) {
	        this._.field = '';
	      }
	      if (!(ltrim && !this._.field)) {
	        this._.field += char;
	      }
	      i++;
	    } else if (!this._.commenting) {
	      if (this._.field == null) {
	        this._.field = '';
	      }
	      this._.field += char;
	      i++;
	    } else {
	      i++;
	    }
	    if (!this._.commenting && ((ref1 = this._.field) != null ? ref1.length : void 0) > this.options.max_limit_on_data_read) {
	      throw Error("Delimiter not found in the file " + (JSON.stringify(this.options.delimiter)));
	    }
	    if (!this._.commenting && ((ref2 = this._.line) != null ? ref2.length : void 0) > this.options.max_limit_on_data_read) {
	      throw Error("Row delimiter not found in the file " + (JSON.stringify(this.options.rowDelimiter)));
	    }
	  }
	  if (end) {
	    if (this._.field != null) {
	      if (rtrim) {
	        if (!this._.closingQuote) {
	          this._.field = (ref3 = this._.field) != null ? ref3.trimRight() : void 0;
	        }
	      }
	      this._.line.push(auto_parse(this._.field || ''));
	      this._.field = null;
	    }
	    if (((ref4 = this._.field) != null ? ref4.length : void 0) > this.options.max_limit_on_data_read) {
	      throw Error("Delimiter not found in the file " + (JSON.stringify(this.options.delimiter)));
	    }
	    if (l === 0) {
	      this.lines++;
	    }
	    if (this._.line.length > this.options.max_limit_on_data_read) {
	      throw Error("Row delimiter not found in the file " + (JSON.stringify(this.options.rowDelimiter)));
	    }
	  }
	  this._.buf = '';
	  results = [];
	  while (i < l) {
	    this._.buf += chars.charAt(i);
	    results.push(i++);
	  }
	  return results;
	};


/***/ },
/* 72 */
/***/ function(module, exports, __webpack_require__) {

	/*
	 * winston.js: Top-level include defining Winston.
	 *
	 * (C) 2010 Charlie Robbins
	 * MIT LICENCE
	 *
	 */

	var winston = exports;

	//
	// use require method for webpack bundle
	//
	winston.version = __webpack_require__(73).version

	//
	// Include transports defined by default by winston
	//
	winston.transports = __webpack_require__(74);

	//
	// Expose utility methods
	//
	var common             = __webpack_require__(77);
	winston.hash           = common.hash;
	winston.clone          = common.clone;
	winston.longestElement = common.longestElement;
	winston.exception      = __webpack_require__(105);
	winston.config         = __webpack_require__(79);
	winston.addColors      = winston.config.addColors;

	//
	// Expose core Logging-related prototypes.
	//
	winston.Container      = __webpack_require__(107).Container;
	winston.Logger         = __webpack_require__(108).Logger;
	winston.Transport      = __webpack_require__(97).Transport;

	//
	// We create and expose a default `Container` to `winston.loggers` so that the
	// programmer may manage multiple `winston.Logger` instances without any additional overhead.
	//
	// ### some-file1.js
	//
	//     var logger = require('winston').loggers.get('something');
	//
	// ### some-file2.js
	//
	//     var logger = require('winston').loggers.get('something');
	//
	winston.loggers = new winston.Container();

	//
	// We create and expose a 'defaultLogger' so that the programmer may do the
	// following without the need to create an instance of winston.Logger directly:
	//
	//     var winston = require('winston');
	//     winston.log('info', 'some message');
	//     winston.error('some error');
	//
	var defaultLogger = new winston.Logger({
	  transports: [new winston.transports.Console()]
	});

	//
	// Pass through the target methods onto `winston`.
	//
	var methods = [
	  'log',
	  'query',
	  'stream',
	  'add',
	  'remove',
	  'clear',
	  'profile',
	  'startTimer',
	  'extend',
	  'cli',
	  'handleExceptions',
	  'unhandleExceptions',
	  'configure'
	];
	common.setLevels(winston, null, defaultLogger.levels);
	methods.forEach(function (method) {
	  winston[method] = function () {
	    return defaultLogger[method].apply(defaultLogger, arguments);
	  };
	});

	//
	// ### function cli ()
	// Configures the default winston logger to have the
	// settings for command-line interfaces: no timestamp,
	// colors enabled, padded output, and additional levels.
	//
	winston.cli = function () {
	  winston.padLevels = true;
	  common.setLevels(winston, defaultLogger.levels, winston.config.cli.levels);
	  defaultLogger.setLevels(winston.config.cli.levels);
	  winston.config.addColors(winston.config.cli.colors);

	  if (defaultLogger.transports.console) {
	    defaultLogger.transports.console.colorize = true;
	    defaultLogger.transports.console.timestamp = false;
	  }

	  return winston;
	};

	//
	// ### function setLevels (target)
	// #### @target {Object} Target levels to use
	// Sets the `target` levels specified on the default winston logger.
	//
	winston.setLevels = function (target) {
	  common.setLevels(winston, defaultLogger.levels, target);
	  defaultLogger.setLevels(target);
	};

	//
	// Define getter / setter for the default logger level
	// which need to be exposed by winston.
	//
	Object.defineProperty(winston, 'level', {
	  get: function () {
	    return defaultLogger.level;
	  },
	  set: function (val) {
	    defaultLogger.level = val;

	    Object.keys(defaultLogger.transports).forEach(function(key) {
	      defaultLogger.transports[key].level = val;
	    });
	  }
	});

	//
	// Define getters / setters for appropriate properties of the
	// default logger which need to be exposed by winston.
	//
	['emitErrs', 'exitOnError', 'padLevels', 'levelLength', 'stripColors'].forEach(function (prop) {
	  Object.defineProperty(winston, prop, {
	    get: function () {
	      return defaultLogger[prop];
	    },
	    set: function (val) {
	      defaultLogger[prop] = val;
	    }
	  });
	});

	//
	// @default {Object}
	// The default transports and exceptionHandlers for
	// the default winston logger.
	//
	Object.defineProperty(winston, 'default', {
	  get: function () {
	    return {
	      transports: defaultLogger.transports,
	      exceptionHandlers: defaultLogger.exceptionHandlers
	    };
	  }
	});


/***/ },
/* 73 */
/***/ function(module, exports) {

	module.exports = {
		"_args": [
			[
				{
					"raw": "winston",
					"scope": null,
					"escapedName": "winston",
					"name": "winston",
					"rawSpec": "",
					"spec": "latest",
					"type": "tag"
				},
				"/private/var/www/jsreports"
			]
		],
		"_from": "winston@latest",
		"_id": "winston@2.3.1",
		"_inCache": true,
		"_location": "/winston",
		"_nodeVersion": "4.7.2",
		"_npmOperationalInternal": {
			"host": "packages-18-east.internal.npmjs.com",
			"tmp": "tmp/winston-2.3.1.tgz_1484937497945_0.36467634653672576"
		},
		"_npmUser": {
			"name": "indexzero",
			"email": "charlie.robbins@gmail.com"
		},
		"_npmVersion": "3.10.5",
		"_phantomChildren": {},
		"_requested": {
			"raw": "winston",
			"scope": null,
			"escapedName": "winston",
			"name": "winston",
			"rawSpec": "",
			"spec": "latest",
			"type": "tag"
		},
		"_requiredBy": [
			"#USER",
			"/"
		],
		"_resolved": "http://registry.npmjs.org/winston/-/winston-2.3.1.tgz",
		"_shasum": "0b48420d978c01804cf0230b648861598225a119",
		"_shrinkwrap": null,
		"_spec": "winston",
		"_where": "/private/var/www/jsreports",
		"author": {
			"name": "Charlie Robbins",
			"email": "charlie.robbins@gmail.com"
		},
		"bugs": {
			"url": "https://github.com/winstonjs/winston/issues"
		},
		"dependencies": {
			"async": "~1.0.0",
			"colors": "1.0.x",
			"cycle": "1.0.x",
			"eyes": "0.1.x",
			"isstream": "0.1.x",
			"stack-trace": "0.0.x"
		},
		"description": "A multi-transport async logging library for Node.js",
		"devDependencies": {
			"cross-spawn-async": "^2.0.0",
			"hock": "1.x.x",
			"std-mocks": "~1.0.0",
			"vows": "0.7.x"
		},
		"directories": {},
		"dist": {
			"shasum": "0b48420d978c01804cf0230b648861598225a119",
			"tarball": "https://registry.npmjs.org/winston/-/winston-2.3.1.tgz"
		},
		"engines": {
			"node": ">= 0.10.0"
		},
		"gitHead": "fba37b44f7875ba7c460df81fad27d6a941ed213",
		"homepage": "https://github.com/winstonjs/winston#readme",
		"keywords": [
			"winston",
			"logging",
			"sysadmin",
			"tools"
		],
		"license": "MIT",
		"main": "./lib/winston",
		"maintainers": [
			{
				"name": "indexzero",
				"email": "charlie.robbins@gmail.com"
			},
			{
				"name": "chjj",
				"email": "chjjeffrey@gmail.com"
			},
			{
				"name": "jcrugzz",
				"email": "jcrugzz@gmail.com"
			},
			{
				"name": "pose",
				"email": "albertopose@gmail.com"
			},
			{
				"name": "v1",
				"email": "info@3rd-Eden.com"
			},
			{
				"name": "3rdeden",
				"email": "npm@3rd-Eden.com"
			}
		],
		"name": "winston",
		"optionalDependencies": {},
		"readme": "ERROR: No README data found!",
		"repository": {
			"type": "git",
			"url": "git+https://github.com/winstonjs/winston.git"
		},
		"scripts": {
			"test": "vows --spec --isolate"
		},
		"version": "2.3.1"
	};

/***/ },
/* 74 */
/***/ function(module, exports, __webpack_require__) {

	/*
	 * transports.js: Set of all transports Winston knows about
	 *
	 * (C) 2010 Charlie Robbins
	 * MIT LICENCE
	 *
	 */

	Object.defineProperty(exports, 'Console', {
	  configurable: true,
	  enumerable: true,
	  get: function () {
	    return __webpack_require__(75).Console;
	  }
	});
	Object.defineProperty(exports, 'File', {
	  configurable: true,
	  enumerable: true,
	  get: function () {
	    return __webpack_require__(98).File;
	  }
	});
	Object.defineProperty(exports, 'Http', {
	  configurable: true,
	  enumerable: true,
	  get: function () {
	    return __webpack_require__(102).Http;
	  }
	});
	Object.defineProperty(exports, 'Memory', {
	  configurable: true,
	  enumerable: true,
	  get: function () {
	    return __webpack_require__(104).Memory;
	  }
	});


/***/ },
/* 75 */
/***/ function(module, exports, __webpack_require__) {

	/*
	 * console.js: Transport for outputting to the console
	 *
	 * (C) 2010 Charlie Robbins
	 * MIT LICENCE
	 *
	 */

	var events = __webpack_require__(76),
	    os = __webpack_require__(4),
	    util = __webpack_require__(12),
	    common = __webpack_require__(77),
	    Transport = __webpack_require__(97).Transport;

	//
	// ### function Console (options)
	// #### @options {Object} Options for this instance.
	// Constructor function for the Console transport object responsible
	// for persisting log messages and metadata to a terminal or TTY.
	//
	var Console = exports.Console = function (options) {
	  Transport.call(this, options);
	  options = options || {};

	  this.json         = options.json        || false;
	  this.colorize     = options.colorize    || false;
	  this.prettyPrint  = options.prettyPrint || false;
	  this.timestamp    = typeof options.timestamp !== 'undefined' ? options.timestamp : false;
	  this.showLevel    = options.showLevel === undefined ? true : options.showLevel;
	  this.label        = options.label       || null;
	  this.logstash     = options.logstash    || false;
	  this.depth        = options.depth       || null;
	  this.align        = options.align       || false;
	  this.stderrLevels = setStderrLevels(options.stderrLevels, options.debugStdout);
	  this.eol          = options.eol   || os.EOL;

	  if (this.json) {
	    this.stringify = options.stringify || function (obj) {
	      return JSON.stringify(obj, null, 2);
	    };
	  }

	  //
	  // Convert stderrLevels into an Object for faster key-lookup times than an Array.
	  //
	  // For backwards compatibility, stderrLevels defaults to ['error', 'debug']
	  // or ['error'] depending on whether options.debugStdout is true.
	  //
	  function setStderrLevels (levels, debugStdout) {
	    var defaultMsg = 'Cannot have non-string elements in stderrLevels Array';
	    if (debugStdout) {
	      if (levels) {
	        //
	        // Don't allow setting both debugStdout and stderrLevels together,
	        // since this could cause behaviour a programmer might not expect.
	        //
	        throw new Error('Cannot set debugStdout and stderrLevels together');
	      }

	      return common.stringArrayToSet(['error'], defaultMsg);
	    }

	    if (!levels) {
	      return common.stringArrayToSet(['error', 'debug'], defaultMsg);
	    } else if (!(Array.isArray(levels))) {
	      throw new Error('Cannot set stderrLevels to type other than Array');
	    }

	    return common.stringArrayToSet(levels, defaultMsg);
	  };
	};

	//
	// Inherit from `winston.Transport`.
	//
	util.inherits(Console, Transport);

	//
	// Expose the name of this Transport on the prototype
	//
	Console.prototype.name = 'console';

	//
	// ### function log (level, msg, [meta], callback)
	// #### @level {string} Level at which to log the message.
	// #### @msg {string} Message to log
	// #### @meta {Object} **Optional** Additional metadata to attach
	// #### @callback {function} Continuation to respond to when complete.
	// Core logging method exposed to Winston. Metadata is optional.
	//
	Console.prototype.log = function (level, msg, meta, callback) {
	  if (this.silent) {
	    return callback(null, true);
	  }

	  var self = this,
	      output;

	  output = common.log({
	    colorize:    this.colorize,
	    json:        this.json,
	    level:       level,
	    message:     msg,
	    meta:        meta,
	    stringify:   this.stringify,
	    timestamp:   this.timestamp,
	    showLevel:   this.showLevel,
	    prettyPrint: this.prettyPrint,
	    raw:         this.raw,
	    label:       this.label,
	    logstash:    this.logstash,
	    depth:       this.depth,
	    formatter:   this.formatter,
	    align:       this.align,
	    humanReadableUnhandledException: this.humanReadableUnhandledException
	  });

	  if (this.stderrLevels[level]) {
	    process.stderr.write(output + this.eol);
	  } else {
	    process.stdout.write(output + this.eol);
	  }

	  //
	  // Emit the `logged` event immediately because the event loop
	  // will not exit until `process.stdout` has drained anyway.
	  //
	  self.emit('logged');
	  callback(null, true);
	};


/***/ },
/* 76 */
/***/ function(module, exports) {

	module.exports = require("events");

/***/ },
/* 77 */
/***/ function(module, exports, __webpack_require__) {

	/*
	 * common.js: Internal helper and utility functions for winston
	 *
	 * (C) 2010 Charlie Robbins
	 * MIT LICENCE
	 *
	 */

	var util = __webpack_require__(12),
	    crypto = __webpack_require__(5),
	    cycle = __webpack_require__(78),
	    fs = __webpack_require__(2),
	    StringDecoder = __webpack_require__(70).StringDecoder,
	    Stream = __webpack_require__(8).Stream,
	    config = __webpack_require__(79);

	//
	// ### function setLevels (target, past, current)
	// #### @target {Object} Object on which to set levels.
	// #### @past {Object} Previous levels set on target.
	// #### @current {Object} Current levels to set on target.
	// Create functions on the target objects for each level
	// in current.levels. If past is defined, remove functions
	// for each of those levels.
	//
	exports.setLevels = function (target, past, current, isDefault) {
	  var self = this;
	  if (past) {
	    Object.keys(past).forEach(function (level) {
	      delete target[level];
	    });
	  }

	  target.levels = current || config.npm.levels;
	  if (target.padLevels) {
	    target.levelLength = exports.longestElement(Object.keys(target.levels));
	  }

	  //
	  //  Define prototype methods for each log level
	  //  e.g. target.log('info', msg) <=> target.info(msg)
	  //
	  Object.keys(target.levels).forEach(function (level) {

	    // TODO Refactor logging methods into a different object to avoid name clashes
	    if (level === 'log') {
	      console.warn('Log level named "log" will clash with the method "log". Consider using a different name.');
	      return;
	    }

	    target[level] = function (msg) {
	      // build argument list (level, msg, ... [string interpolate], [{metadata}], [callback])
	      var args = [level].concat(Array.prototype.slice.call(arguments));
	      target.log.apply(target, args);
	    };
	  });

	  return target;
	};

	//
	// ### function longestElement
	// #### @xs {Array} Array to calculate against
	// Returns the longest element in the `xs` array.
	//
	exports.longestElement = function (xs) {
	  return Math.max.apply(
	    null,
	    xs.map(function (x) { return x.length; })
	  );
	};

	//
	// ### function clone (obj)
	// #### @obj {Object} Object to clone.
	// Helper method for deep cloning pure JSON objects
	// i.e. JSON objects that are either literals or objects (no Arrays, etc)
	//
	exports.clone = function (obj) {
	  //
	  // We only need to clone reference types (Object)
	  //
	  var copy = {};

	  if (obj instanceof Error) {
	    // With potential custom Error objects, this might not be exactly correct,
	    // but probably close-enough for purposes of this lib.
	    copy = { message: obj.message };
	    Object.getOwnPropertyNames(obj).forEach(function (key) {
	      copy[key] = obj[key];
	    });

	    return copy;
	  }
	  else if (!(obj instanceof Object)) {
	    return obj;
	  }
	  else if (obj instanceof Date) {
	    return new Date(obj.getTime());
	  }

	  for (var i in obj) {
	    if (Array.isArray(obj[i])) {
	      copy[i] = obj[i].slice(0);
	    }
	    else if (obj[i] instanceof Buffer) {
	        copy[i] = obj[i].slice(0);
	    }
	    else if (typeof obj[i] != 'function') {
	      copy[i] = obj[i] instanceof Object ? exports.clone(obj[i]) : obj[i];
	    }
	    else if (typeof obj[i] === 'function') {
	      copy[i] = obj[i];
	    }
	  }

	  return copy;
	};

	//
	// ### function log (options)
	// #### @options {Object} All information about the log serialization.
	// Generic logging function for returning timestamped strings
	// with the following options:
	//
	//    {
	//      level:     'level to add to serialized message',
	//      message:   'message to serialize',
	//      meta:      'additional logging metadata to serialize',
	//      colorize:  false, // Colorizes output (only if `.json` is false)
	//      align:     false  // Align message level.
	//      timestamp: true   // Adds a timestamp to the serialized message
	//      label:     'label to prepend the message'
	//    }
	//
	exports.log = function (options) {
	  var timestampFn = typeof options.timestamp === 'function'
	        ? options.timestamp
	        : exports.timestamp,
	      timestamp   = options.timestamp ? timestampFn() : null,
	      showLevel   = options.showLevel === undefined ? true : options.showLevel,
	      meta        = options.meta !== null && options.meta !== undefined && !(options.meta instanceof Error)
	        ? exports.clone(cycle.decycle(options.meta))
	        : options.meta || null,
	      output;

	  //
	  // raw mode is intended for outputing winston as streaming JSON to STDOUT
	  //
	  if (options.raw) {
	    if (typeof meta !== 'object' && meta != null) {
	      meta = { meta: meta };
	    }
	    output         = exports.clone(meta) || {};
	    output.level   = options.level;
	    //
	    // Remark (jcrugzz): This used to be output.message = options.message.stripColors.
	    // I do not know why this is, it does not make sense but im handling that
	    // case here as well as handling the case that does make sense which is to
	    // make the `output.message = options.message`
	    //
	    output.message = options.message.stripColors
	      ? options.message.stripColors
	      : options.message;

	    return JSON.stringify(output);
	  }

	  //
	  // json mode is intended for pretty printing multi-line json to the terminal
	  //
	  if (options.json || true === options.logstash) {
	    if (typeof meta !== 'object' && meta != null) {
	      meta = { meta: meta };
	    }

	    output         = exports.clone(meta) || {};
	    output.level   = options.level;
	    output.message = output.message || '';

	    if (options.label) { output.label = options.label; }
	    if (options.message) { output.message = options.message; }
	    if (timestamp) { output.timestamp = timestamp; }

	    if (options.logstash === true) {
	      // use logstash format
	      var logstashOutput = {};
	      if (output.message !== undefined) {
	        logstashOutput['@message'] = output.message;
	        delete output.message;
	      }

	      if (output.timestamp !== undefined) {
	        logstashOutput['@timestamp'] = output.timestamp;
	        delete output.timestamp;
	      }

	      logstashOutput['@fields'] = exports.clone(output);
	      output = logstashOutput;
	    }

	    if (typeof options.stringify === 'function') {
	      return options.stringify(output);
	    }

	    return JSON.stringify(output, function (key, value) {
	      return value instanceof Buffer
	        ? value.toString('base64')
	        : value;
	    });
	  }

	  //
	  // Remark: this should really be a call to `util.format`.
	  //
	  if (typeof options.formatter == 'function') {
	    options.meta = meta;
	    return String(options.formatter(exports.clone(options)));
	  }

	  output = timestamp ? timestamp + ' - ' : '';
	  if (showLevel) {
	    output += options.colorize === 'all' || options.colorize === 'level' || options.colorize === true
	      ? config.colorize(options.level)
	      : options.level;
	  }

	  output += (options.align) ? '\t' : '';
	  output += (timestamp || showLevel) ? ': ' : '';
	  output += options.label ? ('[' + options.label + '] ') : '';
	  output += options.colorize === 'all' || options.colorize === 'message'
	    ? config.colorize(options.level, options.message)
	    : options.message;

	  if (meta !== null && meta !== undefined) {
	    if (meta && meta instanceof Error && meta.stack) {
	      meta = meta.stack;
	    }

	    if (typeof meta !== 'object') {
	      output += ' ' + meta;
	    }
	    else if (Object.keys(meta).length > 0) {
	      if (typeof options.prettyPrint === 'function') {
	        output += ' ' + options.prettyPrint(meta);
	      } else if (options.prettyPrint) {
	        output += ' ' + '\n' + util.inspect(meta, false, options.depth || null, options.colorize);
	      } else if (
	        options.humanReadableUnhandledException
	          && Object.keys(meta).length === 5
	          && meta.hasOwnProperty('date')
	          && meta.hasOwnProperty('process')
	          && meta.hasOwnProperty('os')
	          && meta.hasOwnProperty('trace')
	          && meta.hasOwnProperty('stack')) {

	        //
	        // If meta carries unhandled exception data serialize the stack nicely
	        //
	        var stack = meta.stack;
	        delete meta.stack;
	        delete meta.trace;
	        output += ' ' + exports.serialize(meta);

	        if (stack) {
	          output += '\n' + stack.join('\n');
	        }
	      } else {
	        output += ' ' + exports.serialize(meta);
	      }
	    }
	  }

	  return output;
	};

	exports.capitalize = function (str) {
	  return str && str[0].toUpperCase() + str.slice(1);
	};

	//
	// ### function hash (str)
	// #### @str {string} String to hash.
	// Utility function for creating unique ids
	// e.g. Profiling incoming HTTP requests on the same tick
	//
	exports.hash = function (str) {
	  return crypto.createHash('sha1').update(str).digest('hex');
	};

	//
	// ### function pad (n)
	// Returns a padded string if `n < 10`.
	//
	exports.pad = function (n) {
	  return n < 10 ? '0' + n.toString(10) : n.toString(10);
	};

	//
	// ### function timestamp ()
	// Returns a timestamp string for the current time.
	//
	exports.timestamp = function () {
	  return new Date().toISOString();
	};

	//
	// ### function serialize (obj, key)
	// #### @obj {Object|literal} Object to serialize
	// #### @key {string} **Optional** Optional key represented by obj in a larger object
	// Performs simple comma-separated, `key=value` serialization for Loggly when
	// logging to non-JSON inputs.
	//
	exports.serialize = function (obj, key) {
	  // symbols cannot be directly casted to strings
	  if (typeof key === 'symbol') {
	    key = key.toString()
	  }
	  if (typeof obj === 'symbol') {
	    obj = obj.toString()
	  }

	  if (obj === null) {
	    obj = 'null';
	  }
	  else if (obj === undefined) {
	    obj = 'undefined';
	  }
	  else if (obj === false) {
	    obj = 'false';
	  }

	  if (typeof obj !== 'object') {
	    return key ? key + '=' + obj : obj;
	  }

	  if (obj instanceof Buffer) {
	    return key ? key + '=' + obj.toString('base64') : obj.toString('base64');
	  }

	  var msg = '',
	      keys = Object.keys(obj),
	      length = keys.length;

	  for (var i = 0; i < length; i++) {
	    if (Array.isArray(obj[keys[i]])) {
	      msg += keys[i] + '=[';

	      for (var j = 0, l = obj[keys[i]].length; j < l; j++) {
	        msg += exports.serialize(obj[keys[i]][j]);
	        if (j < l - 1) {
	          msg += ', ';
	        }
	      }

	      msg += ']';
	    }
	    else if (obj[keys[i]] instanceof Date) {
	      msg += keys[i] + '=' + obj[keys[i]];
	    }
	    else {
	      msg += exports.serialize(obj[keys[i]], keys[i]);
	    }

	    if (i < length - 1) {
	      msg += ', ';
	    }
	  }

	  return msg;
	};

	//
	// ### function tailFile (options, callback)
	// #### @options {Object} Options for tail.
	// #### @callback {function} Callback to execute on every line.
	// `tail -f` a file. Options must include file.
	//
	exports.tailFile = function(options, callback) {
	  var buffer = new Buffer(64 * 1024)
	    , decode = new StringDecoder('utf8')
	    , stream = new Stream
	    , buff = ''
	    , pos = 0
	    , row = 0;

	  if (options.start === -1) {
	    delete options.start;
	  }

	  stream.readable = true;
	  stream.destroy = function() {
	    stream.destroyed = true;
	    stream.emit('end');
	    stream.emit('close');
	  };

	  fs.open(options.file, 'a+', '0644', function(err, fd) {
	    if (err) {
	      if (!callback) {
	        stream.emit('error', err);
	      } else {
	        callback(err);
	      }
	      stream.destroy();
	      return;
	    }

	    (function read() {
	      if (stream.destroyed) {
	        fs.close(fd);
	        return;
	      }

	      return fs.read(fd, buffer, 0, buffer.length, pos, function(err, bytes) {
	        if (err) {
	          if (!callback) {
	            stream.emit('error', err);
	          } else {
	            callback(err);
	          }
	          stream.destroy();
	          return;
	        }

	        if (!bytes) {
	          if (buff) {
	            if (options.start == null || row > options.start) {
	              if (!callback) {
	                stream.emit('line', buff);
	              } else {
	                callback(null, buff);
	              }
	            }
	            row++;
	            buff = '';
	          }
	          return setTimeout(read, 1000);
	        }

	        var data = decode.write(buffer.slice(0, bytes));

	        if (!callback) {
	          stream.emit('data', data);
	        }

	        var data = (buff + data).split(/\n+/)
	          , l = data.length - 1
	          , i = 0;

	        for (; i < l; i++) {
	          if (options.start == null || row > options.start) {
	            if (!callback) {
	              stream.emit('line', data[i]);
	            } else {
	              callback(null, data[i]);
	            }
	          }
	          row++;
	        }

	        buff = data[l];

	        pos += bytes;

	        return read();
	      });
	    })();
	  });

	  if (!callback) {
	    return stream;
	  }

	  return stream.destroy;
	};

	//
	// ### function stringArrayToSet (array)
	// #### @strArray {Array} Array of Set-elements as strings.
	// #### @errMsg {string} **Optional** Custom error message thrown on invalid input.
	// Returns a Set-like object with strArray's elements as keys (each with the value true).
	//
	exports.stringArrayToSet = function (strArray, errMsg) {
	  if (typeof errMsg === 'undefined') {
	    errMsg = 'Cannot make set from Array with non-string elements';
	  }
	  return strArray.reduce(function (set, el) {
	    if (!(typeof el === 'string' || el instanceof String)) {
	      throw new Error(errMsg);
	    }
	    set[el] = true;
	    return set;
	  }, Object.create(null));
	};


/***/ },
/* 78 */
/***/ function(module, exports) {

	/*
	    cycle.js
	    2013-02-19

	    Public Domain.

	    NO WARRANTY EXPRESSED OR IMPLIED. USE AT YOUR OWN RISK.

	    This code should be minified before deployment.
	    See http://javascript.crockford.com/jsmin.html

	    USE YOUR OWN COPY. IT IS EXTREMELY UNWISE TO LOAD CODE FROM SERVERS YOU DO
	    NOT CONTROL.
	*/

	/*jslint evil: true, regexp: true */

	/*members $ref, apply, call, decycle, hasOwnProperty, length, prototype, push,
	    retrocycle, stringify, test, toString
	*/

	var cycle = exports;

	cycle.decycle = function decycle(object) {
	    'use strict';

	// Make a deep copy of an object or array, assuring that there is at most
	// one instance of each object or array in the resulting structure. The
	// duplicate references (which might be forming cycles) are replaced with
	// an object of the form
	//      {$ref: PATH}
	// where the PATH is a JSONPath string that locates the first occurance.
	// So,
	//      var a = [];
	//      a[0] = a;
	//      return JSON.stringify(JSON.decycle(a));
	// produces the string '[{"$ref":"$"}]'.

	// JSONPath is used to locate the unique object. $ indicates the top level of
	// the object or array. [NUMBER] or [STRING] indicates a child member or
	// property.

	    var objects = [],   // Keep a reference to each unique object or array
	        paths = [];     // Keep the path to each unique object or array

	    return (function derez(value, path) {

	// The derez recurses through the object, producing the deep copy.

	        var i,          // The loop counter
	            name,       // Property name
	            nu;         // The new object or array

	// typeof null === 'object', so go on if this value is really an object but not
	// one of the weird builtin objects.

	        if (typeof value === 'object' && value !== null &&
	                !(value instanceof Boolean) &&
	                !(value instanceof Date)    &&
	                !(value instanceof Number)  &&
	                !(value instanceof RegExp)  &&
	                !(value instanceof String)) {

	// If the value is an object or array, look to see if we have already
	// encountered it. If so, return a $ref/path object. This is a hard way,
	// linear search that will get slower as the number of unique objects grows.

	            for (i = 0; i < objects.length; i += 1) {
	                if (objects[i] === value) {
	                    return {$ref: paths[i]};
	                }
	            }

	// Otherwise, accumulate the unique value and its path.

	            objects.push(value);
	            paths.push(path);

	// If it is an array, replicate the array.

	            if (Object.prototype.toString.apply(value) === '[object Array]') {
	                nu = [];
	                for (i = 0; i < value.length; i += 1) {
	                    nu[i] = derez(value[i], path + '[' + i + ']');
	                }
	            } else {

	// If it is an object, replicate the object.

	                nu = {};
	                for (name in value) {
	                    if (Object.prototype.hasOwnProperty.call(value, name)) {
	                        nu[name] = derez(value[name],
	                            path + '[' + JSON.stringify(name) + ']');
	                    }
	                }
	            }
	            return nu;
	        }
	        return value;
	    }(object, '$'));
	};


	cycle.retrocycle = function retrocycle($) {
	    'use strict';

	// Restore an object that was reduced by decycle. Members whose values are
	// objects of the form
	//      {$ref: PATH}
	// are replaced with references to the value found by the PATH. This will
	// restore cycles. The object will be mutated.

	// The eval function is used to locate the values described by a PATH. The
	// root object is kept in a $ variable. A regular expression is used to
	// assure that the PATH is extremely well formed. The regexp contains nested
	// * quantifiers. That has been known to have extremely bad performance
	// problems on some browsers for very long strings. A PATH is expected to be
	// reasonably short. A PATH is allowed to belong to a very restricted subset of
	// Goessner's JSONPath.

	// So,
	//      var s = '[{"$ref":"$"}]';
	//      return JSON.retrocycle(JSON.parse(s));
	// produces an array containing a single element which is the array itself.

	    var px =
	        /^\$(?:\[(?:\d+|\"(?:[^\\\"\u0000-\u001f]|\\([\\\"\/bfnrt]|u[0-9a-zA-Z]{4}))*\")\])*$/;

	    (function rez(value) {

	// The rez function walks recursively through the object looking for $ref
	// properties. When it finds one that has a value that is a path, then it
	// replaces the $ref object with a reference to the value that is found by
	// the path.

	        var i, item, name, path;

	        if (value && typeof value === 'object') {
	            if (Object.prototype.toString.apply(value) === '[object Array]') {
	                for (i = 0; i < value.length; i += 1) {
	                    item = value[i];
	                    if (item && typeof item === 'object') {
	                        path = item.$ref;
	                        if (typeof path === 'string' && px.test(path)) {
	                            value[i] = eval(path);
	                        } else {
	                            rez(item);
	                        }
	                    }
	                }
	            } else {
	                for (name in value) {
	                    if (typeof value[name] === 'object') {
	                        item = value[name];
	                        if (item) {
	                            path = item.$ref;
	                            if (typeof path === 'string' && px.test(path)) {
	                                value[name] = eval(path);
	                            } else {
	                                rez(item);
	                            }
	                        }
	                    }
	                }
	            }
	        }
	    }($));
	    return $;
	};


/***/ },
/* 79 */
/***/ function(module, exports, __webpack_require__) {

	/*
	 * config.js: Default settings for all levels that winston knows about
	 *
	 * (C) 2010 Charlie Robbins
	 * MIT LICENCE
	 *
	 */

	var colors = __webpack_require__(80);

	// Fix colors not appearing in non-tty environments
	colors.enabled = true;

	var config = exports,
	    allColors = exports.allColors = {};

	config.addColors = function (colors) {
	  mixin(allColors, colors);
	};

	config.colorize = function (level, message) {
	  if (typeof message === 'undefined') message = level;

	  var colorized = message;
	  if (allColors[level] instanceof Array) {
	    for (var i = 0, l = allColors[level].length; i < l; ++i) {
	      colorized = colors[allColors[level][i]](colorized);
	    }
	  }
	  else if (allColors[level].match(/\s/)) {
	    var colorArr = allColors[level].split(/\s+/);
	    for (var i = 0; i < colorArr.length; ++i) {
	      colorized = colors[colorArr[i]](colorized);
	    }
	    allColors[level] = colorArr;
	  }
	  else {
	    colorized = colors[allColors[level]](colorized);
	  }

	  return colorized;
	};

	//
	// Export config sets
	//
	config.cli    = __webpack_require__(94);
	config.npm    = __webpack_require__(95);
	config.syslog = __webpack_require__(96);

	//
	// Add colors for pre-defined config sets
	//
	config.addColors(config.cli.colors);
	config.addColors(config.npm.colors);
	config.addColors(config.syslog.colors);

	function mixin (target) {
	  var args = Array.prototype.slice.call(arguments, 1);

	  args.forEach(function (a) {
	    var keys = Object.keys(a);
	    for (var i = 0; i < keys.length; i++) {
	      target[keys[i]] = a[keys[i]];
	    }
	  });
	  return target;
	};


/***/ },
/* 80 */
/***/ function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(module) {//
	// Remark: Requiring this file will use the "safe" colors API which will not touch String.prototype
	//
	//   var colors = require('colors/safe);
	//   colors.red("foo")
	//
	//
	var colors = __webpack_require__(82);
	module['exports'] = colors;
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(81)(module)))

/***/ },
/* 81 */
/***/ function(module, exports) {

	module.exports = function(module) {
		if(!module.webpackPolyfill) {
			module.deprecate = function() {};
			module.paths = [];
			// module.parent = undefined by default
			module.children = [];
			module.webpackPolyfill = 1;
		}
		return module;
	}


/***/ },
/* 82 */
/***/ function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(module) {/*

	The MIT License (MIT)

	Original Library 
	  - Copyright (c) Marak Squires

	Additional functionality
	 - Copyright (c) Sindre Sorhus <sindresorhus@gmail.com> (sindresorhus.com)

	Permission is hereby granted, free of charge, to any person obtaining a copy
	of this software and associated documentation files (the "Software"), to deal
	in the Software without restriction, including without limitation the rights
	to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
	copies of the Software, and to permit persons to whom the Software is
	furnished to do so, subject to the following conditions:

	The above copyright notice and this permission notice shall be included in
	all copies or substantial portions of the Software.

	THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
	IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
	FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
	AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
	LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
	OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
	THE SOFTWARE.

	*/

	var colors = {};
	module['exports'] = colors;

	colors.themes = {};

	var ansiStyles = colors.styles = __webpack_require__(83);
	var defineProps = Object.defineProperties;

	colors.supportsColor = __webpack_require__(84);

	if (typeof colors.enabled === "undefined") {
	  colors.enabled = colors.supportsColor;
	}

	colors.stripColors = colors.strip = function(str){
	  return ("" + str).replace(/\x1B\[\d+m/g, '');
	};


	var stylize = colors.stylize = function stylize (str, style) {
	  return ansiStyles[style].open + str + ansiStyles[style].close;
	}

	var matchOperatorsRe = /[|\\{}()[\]^$+*?.]/g;
	var escapeStringRegexp = function (str) {
	  if (typeof str !== 'string') {
	    throw new TypeError('Expected a string');
	  }
	  return str.replace(matchOperatorsRe,  '\\$&');
	}

	function build(_styles) {
	  var builder = function builder() {
	    return applyStyle.apply(builder, arguments);
	  };
	  builder._styles = _styles;
	  // __proto__ is used because we must return a function, but there is
	  // no way to create a function with a different prototype.
	  builder.__proto__ = proto;
	  return builder;
	}

	var styles = (function () {
	  var ret = {};
	  ansiStyles.grey = ansiStyles.gray;
	  Object.keys(ansiStyles).forEach(function (key) {
	    ansiStyles[key].closeRe = new RegExp(escapeStringRegexp(ansiStyles[key].close), 'g');
	    ret[key] = {
	      get: function () {
	        return build(this._styles.concat(key));
	      }
	    };
	  });
	  return ret;
	})();

	var proto = defineProps(function colors() {}, styles);

	function applyStyle() {
	  var args = arguments;
	  var argsLen = args.length;
	  var str = argsLen !== 0 && String(arguments[0]);
	  if (argsLen > 1) {
	    for (var a = 1; a < argsLen; a++) {
	      str += ' ' + args[a];
	    }
	  }

	  if (!colors.enabled || !str) {
	    return str;
	  }

	  var nestedStyles = this._styles;

	  var i = nestedStyles.length;
	  while (i--) {
	    var code = ansiStyles[nestedStyles[i]];
	    str = code.open + str.replace(code.closeRe, code.open) + code.close;
	  }

	  return str;
	}

	function applyTheme (theme) {
	  for (var style in theme) {
	    (function(style){
	      colors[style] = function(str){
	        return colors[theme[style]](str);
	      };
	    })(style)
	  }
	}

	colors.setTheme = function (theme) {
	  if (typeof theme === 'string') {
	    try {
	      colors.themes[theme] = __webpack_require__(85)(theme);
	      applyTheme(colors.themes[theme]);
	      return colors.themes[theme];
	    } catch (err) {
	      console.log(err);
	      return err;
	    }
	  } else {
	    applyTheme(theme);
	  }
	};

	function init() {
	  var ret = {};
	  Object.keys(styles).forEach(function (name) {
	    ret[name] = {
	      get: function () {
	        return build([name]);
	      }
	    };
	  });
	  return ret;
	}

	var sequencer = function sequencer (map, str) {
	  var exploded = str.split(""), i = 0;
	  exploded = exploded.map(map);
	  return exploded.join("");
	};

	// custom formatter methods
	colors.trap = __webpack_require__(86);
	colors.zalgo = __webpack_require__(87);

	// maps
	colors.maps = {};
	colors.maps.america = __webpack_require__(90);
	colors.maps.zebra = __webpack_require__(93);
	colors.maps.rainbow = __webpack_require__(91);
	colors.maps.random = __webpack_require__(92)

	for (var map in colors.maps) {
	  (function(map){
	    colors[map] = function (str) {
	      return sequencer(colors.maps[map], str);
	    }
	  })(map)
	}

	defineProps(colors, init());
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(81)(module)))

/***/ },
/* 83 */
/***/ function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(module) {/*
	The MIT License (MIT)

	Copyright (c) Sindre Sorhus <sindresorhus@gmail.com> (sindresorhus.com)

	Permission is hereby granted, free of charge, to any person obtaining a copy
	of this software and associated documentation files (the "Software"), to deal
	in the Software without restriction, including without limitation the rights
	to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
	copies of the Software, and to permit persons to whom the Software is
	furnished to do so, subject to the following conditions:

	The above copyright notice and this permission notice shall be included in
	all copies or substantial portions of the Software.

	THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
	IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
	FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
	AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
	LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
	OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
	THE SOFTWARE.

	*/

	var styles = {};
	module['exports'] = styles;

	var codes = {
	  reset: [0, 0],

	  bold: [1, 22],
	  dim: [2, 22],
	  italic: [3, 23],
	  underline: [4, 24],
	  inverse: [7, 27],
	  hidden: [8, 28],
	  strikethrough: [9, 29],

	  black: [30, 39],
	  red: [31, 39],
	  green: [32, 39],
	  yellow: [33, 39],
	  blue: [34, 39],
	  magenta: [35, 39],
	  cyan: [36, 39],
	  white: [37, 39],
	  gray: [90, 39],
	  grey: [90, 39],

	  bgBlack: [40, 49],
	  bgRed: [41, 49],
	  bgGreen: [42, 49],
	  bgYellow: [43, 49],
	  bgBlue: [44, 49],
	  bgMagenta: [45, 49],
	  bgCyan: [46, 49],
	  bgWhite: [47, 49],

	  // legacy styles for colors pre v1.0.0
	  blackBG: [40, 49],
	  redBG: [41, 49],
	  greenBG: [42, 49],
	  yellowBG: [43, 49],
	  blueBG: [44, 49],
	  magentaBG: [45, 49],
	  cyanBG: [46, 49],
	  whiteBG: [47, 49]

	};

	Object.keys(codes).forEach(function (key) {
	  var val = codes[key];
	  var style = styles[key] = [];
	  style.open = '\u001b[' + val[0] + 'm';
	  style.close = '\u001b[' + val[1] + 'm';
	});
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(81)(module)))

/***/ },
/* 84 */
/***/ function(module, exports) {

	/*
	The MIT License (MIT)

	Copyright (c) Sindre Sorhus <sindresorhus@gmail.com> (sindresorhus.com)

	Permission is hereby granted, free of charge, to any person obtaining a copy
	of this software and associated documentation files (the "Software"), to deal
	in the Software without restriction, including without limitation the rights
	to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
	copies of the Software, and to permit persons to whom the Software is
	furnished to do so, subject to the following conditions:

	The above copyright notice and this permission notice shall be included in
	all copies or substantial portions of the Software.

	THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
	IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
	FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
	AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
	LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
	OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
	THE SOFTWARE.

	*/

	var argv = process.argv;

	module.exports = (function () {
	  if (argv.indexOf('--no-color') !== -1 ||
	    argv.indexOf('--color=false') !== -1) {
	    return false;
	  }

	  if (argv.indexOf('--color') !== -1 ||
	    argv.indexOf('--color=true') !== -1 ||
	    argv.indexOf('--color=always') !== -1) {
	    return true;
	  }

	  if (process.stdout && !process.stdout.isTTY) {
	    return false;
	  }

	  if (process.platform === 'win32') {
	    return true;
	  }

	  if ('COLORTERM' in process.env) {
	    return true;
	  }

	  if (process.env.TERM === 'dumb') {
	    return false;
	  }

	  if (/^screen|^xterm|^vt100|color|ansi|cygwin|linux/i.test(process.env.TERM)) {
	    return true;
	  }

	  return false;
	})();

/***/ },
/* 85 */
/***/ function(module, exports, __webpack_require__) {

	var map = {
		"./colors": 82,
		"./colors.js": 82,
		"./custom/trap": 86,
		"./custom/trap.js": 86,
		"./custom/zalgo": 87,
		"./custom/zalgo.js": 87,
		"./extendStringPrototype": 88,
		"./extendStringPrototype.js": 88,
		"./index": 89,
		"./index.js": 89,
		"./maps/america": 90,
		"./maps/america.js": 90,
		"./maps/rainbow": 91,
		"./maps/rainbow.js": 91,
		"./maps/random": 92,
		"./maps/random.js": 92,
		"./maps/zebra": 93,
		"./maps/zebra.js": 93,
		"./styles": 83,
		"./styles.js": 83,
		"./system/supports-colors": 84,
		"./system/supports-colors.js": 84
	};
	function webpackContext(req) {
		return __webpack_require__(webpackContextResolve(req));
	};
	function webpackContextResolve(req) {
		return map[req] || (function() { throw new Error("Cannot find module '" + req + "'.") }());
	};
	webpackContext.keys = function webpackContextKeys() {
		return Object.keys(map);
	};
	webpackContext.resolve = webpackContextResolve;
	module.exports = webpackContext;
	webpackContext.id = 85;


/***/ },
/* 86 */
/***/ function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(module) {module['exports'] = function runTheTrap (text, options) {
	  var result = "";
	  text = text || "Run the trap, drop the bass";
	  text = text.split('');
	  var trap = {
	    a: ["\u0040", "\u0104", "\u023a", "\u0245", "\u0394", "\u039b", "\u0414"],
	    b: ["\u00df", "\u0181", "\u0243", "\u026e", "\u03b2", "\u0e3f"],
	    c: ["\u00a9", "\u023b", "\u03fe"],
	    d: ["\u00d0", "\u018a", "\u0500" , "\u0501" ,"\u0502", "\u0503"],
	    e: ["\u00cb", "\u0115", "\u018e", "\u0258", "\u03a3", "\u03be", "\u04bc", "\u0a6c"],
	    f: ["\u04fa"],
	    g: ["\u0262"],
	    h: ["\u0126", "\u0195", "\u04a2", "\u04ba", "\u04c7", "\u050a"],
	    i: ["\u0f0f"],
	    j: ["\u0134"],
	    k: ["\u0138", "\u04a0", "\u04c3", "\u051e"],
	    l: ["\u0139"],
	    m: ["\u028d", "\u04cd", "\u04ce", "\u0520", "\u0521", "\u0d69"],
	    n: ["\u00d1", "\u014b", "\u019d", "\u0376", "\u03a0", "\u048a"],
	    o: ["\u00d8", "\u00f5", "\u00f8", "\u01fe", "\u0298", "\u047a", "\u05dd", "\u06dd", "\u0e4f"],
	    p: ["\u01f7", "\u048e"],
	    q: ["\u09cd"],
	    r: ["\u00ae", "\u01a6", "\u0210", "\u024c", "\u0280", "\u042f"],
	    s: ["\u00a7", "\u03de", "\u03df", "\u03e8"],
	    t: ["\u0141", "\u0166", "\u0373"],
	    u: ["\u01b1", "\u054d"],
	    v: ["\u05d8"],
	    w: ["\u0428", "\u0460", "\u047c", "\u0d70"],
	    x: ["\u04b2", "\u04fe", "\u04fc", "\u04fd"],
	    y: ["\u00a5", "\u04b0", "\u04cb"],
	    z: ["\u01b5", "\u0240"]
	  }
	  text.forEach(function(c){
	    c = c.toLowerCase();
	    var chars = trap[c] || [" "];
	    var rand = Math.floor(Math.random() * chars.length);
	    if (typeof trap[c] !== "undefined") {
	      result += trap[c][rand];
	    } else {
	      result += c;
	    }
	  });
	  return result;

	}

	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(81)(module)))

/***/ },
/* 87 */
/***/ function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(module) {// please no
	module['exports'] = function zalgo(text, options) {
	  text = text || "   he is here   ";
	  var soul = {
	    "up" : [
	      '̍', '̎', '̄', '̅',
	      '̿', '̑', '̆', '̐',
	      '͒', '͗', '͑', '̇',
	      '̈', '̊', '͂', '̓',
	      '̈', '͊', '͋', '͌',
	      '̃', '̂', '̌', '͐',
	      '̀', '́', '̋', '̏',
	      '̒', '̓', '̔', '̽',
	      '̉', 'ͣ', 'ͤ', 'ͥ',
	      'ͦ', 'ͧ', 'ͨ', 'ͩ',
	      'ͪ', 'ͫ', 'ͬ', 'ͭ',
	      'ͮ', 'ͯ', '̾', '͛',
	      '͆', '̚'
	    ],
	    "down" : [
	      '̖', '̗', '̘', '̙',
	      '̜', '̝', '̞', '̟',
	      '̠', '̤', '̥', '̦',
	      '̩', '̪', '̫', '̬',
	      '̭', '̮', '̯', '̰',
	      '̱', '̲', '̳', '̹',
	      '̺', '̻', '̼', 'ͅ',
	      '͇', '͈', '͉', '͍',
	      '͎', '͓', '͔', '͕',
	      '͖', '͙', '͚', '̣'
	    ],
	    "mid" : [
	      '̕', '̛', '̀', '́',
	      '͘', '̡', '̢', '̧',
	      '̨', '̴', '̵', '̶',
	      '͜', '͝', '͞',
	      '͟', '͠', '͢', '̸',
	      '̷', '͡', ' ҉'
	    ]
	  },
	  all = [].concat(soul.up, soul.down, soul.mid),
	  zalgo = {};

	  function randomNumber(range) {
	    var r = Math.floor(Math.random() * range);
	    return r;
	  }

	  function is_char(character) {
	    var bool = false;
	    all.filter(function (i) {
	      bool = (i === character);
	    });
	    return bool;
	  }
	  

	  function heComes(text, options) {
	    var result = '', counts, l;
	    options = options || {};
	    options["up"] = options["up"] || true;
	    options["mid"] = options["mid"] || true;
	    options["down"] = options["down"] || true;
	    options["size"] = options["size"] || "maxi";
	    text = text.split('');
	    for (l in text) {
	      if (is_char(l)) {
	        continue;
	      }
	      result = result + text[l];
	      counts = {"up" : 0, "down" : 0, "mid" : 0};
	      switch (options.size) {
	      case 'mini':
	        counts.up = randomNumber(8);
	        counts.min = randomNumber(2);
	        counts.down = randomNumber(8);
	        break;
	      case 'maxi':
	        counts.up = randomNumber(16) + 3;
	        counts.min = randomNumber(4) + 1;
	        counts.down = randomNumber(64) + 3;
	        break;
	      default:
	        counts.up = randomNumber(8) + 1;
	        counts.mid = randomNumber(6) / 2;
	        counts.down = randomNumber(8) + 1;
	        break;
	      }

	      var arr = ["up", "mid", "down"];
	      for (var d in arr) {
	        var index = arr[d];
	        for (var i = 0 ; i <= counts[index]; i++) {
	          if (options[index]) {
	            result = result + soul[index][randomNumber(soul[index].length)];
	          }
	        }
	      }
	    }
	    return result;
	  }
	  // don't summon him
	  return heComes(text);
	}

	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(81)(module)))

/***/ },
/* 88 */
/***/ function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(module) {var colors = __webpack_require__(82),
	    styles = __webpack_require__(83);

	module['exports'] = function () {

	  //
	  // Extends prototype of native string object to allow for "foo".red syntax
	  //
	  var addProperty = function (color, func) {
	    String.prototype.__defineGetter__(color, func);
	  };

	  var sequencer = function sequencer (map, str) {
	      return function () {
	        var exploded = this.split(""), i = 0;
	        exploded = exploded.map(map);
	        return exploded.join("");
	      }
	  };

	  var stylize = function stylize (str, style) {
	    return styles[style].open + str + styles[style].close;
	  }

	  addProperty('strip', function () {
	    return colors.strip(this);
	  });

	  addProperty('stripColors', function () {
	    return colors.strip(this);
	  });

	  addProperty("trap", function(){
	    return colors.trap(this);
	  });

	  addProperty("zalgo", function(){
	    return colors.zalgo(this);
	  });

	  addProperty("zebra", function(){
	    return colors.zebra(this);
	  });

	  addProperty("rainbow", function(){
	    return colors.rainbow(this);
	  });

	  addProperty("random", function(){
	    return colors.random(this);
	  });

	  addProperty("america", function(){
	    return colors.america(this);
	  });

	  //
	  // Iterate through all default styles and colors
	  //
	  var x = Object.keys(colors.styles);
	  x.forEach(function (style) {
	    addProperty(style, function () {
	      return stylize(this, style);
	    });
	  });

	  function applyTheme(theme) {
	    //
	    // Remark: This is a list of methods that exist
	    // on String that you should not overwrite.
	    //
	    var stringPrototypeBlacklist = [
	      '__defineGetter__', '__defineSetter__', '__lookupGetter__', '__lookupSetter__', 'charAt', 'constructor',
	      'hasOwnProperty', 'isPrototypeOf', 'propertyIsEnumerable', 'toLocaleString', 'toString', 'valueOf', 'charCodeAt',
	      'indexOf', 'lastIndexof', 'length', 'localeCompare', 'match', 'replace', 'search', 'slice', 'split', 'substring',
	      'toLocaleLowerCase', 'toLocaleUpperCase', 'toLowerCase', 'toUpperCase', 'trim', 'trimLeft', 'trimRight'
	    ];

	    Object.keys(theme).forEach(function (prop) {
	      if (stringPrototypeBlacklist.indexOf(prop) !== -1) {
	        console.log('warn: '.red + ('String.prototype' + prop).magenta + ' is probably something you don\'t want to override. Ignoring style name');
	      }
	      else {
	        if (typeof(theme[prop]) === 'string') {
	          colors[prop] = colors[theme[prop]];
	          addProperty(prop, function () {
	            return colors[theme[prop]](this);
	          });
	        }
	        else {
	          addProperty(prop, function () {
	            var ret = this;
	            for (var t = 0; t < theme[prop].length; t++) {
	              ret = exports[theme[prop][t]](ret);
	            }
	            return ret;
	          });
	        }
	      }
	    });
	  }

	  colors.setTheme = function (theme) {
	    if (typeof theme === 'string') {
	      try {
	        colors.themes[theme] = __webpack_require__(85)(theme);
	        applyTheme(colors.themes[theme]);
	        return colors.themes[theme];
	      } catch (err) {
	        console.log(err);
	        return err;
	      }
	    } else {
	      applyTheme(theme);
	    }
	  };

	};
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(81)(module)))

/***/ },
/* 89 */
/***/ function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(module) {var colors = __webpack_require__(82);
	module['exports'] = colors;

	// Remark: By default, colors will add style properties to String.prototype
	//
	// If you don't wish to extend String.prototype you can do this instead and native String will not be touched
	//
	//   var colors = require('colors/safe);
	//   colors.red("foo")
	//
	//
	var extendStringPrototype = __webpack_require__(88)();
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(81)(module)))

/***/ },
/* 90 */
/***/ function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(module) {var colors = __webpack_require__(82);

	module['exports'] = (function() {
	  return function (letter, i, exploded) {
	    if(letter === " ") return letter;
	    switch(i%3) {
	      case 0: return colors.red(letter);
	      case 1: return colors.white(letter)
	      case 2: return colors.blue(letter)
	    }
	  }
	})();
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(81)(module)))

/***/ },
/* 91 */
/***/ function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(module) {var colors = __webpack_require__(82);

	module['exports'] = (function () {
	  var rainbowColors = ['red', 'yellow', 'green', 'blue', 'magenta']; //RoY G BiV
	  return function (letter, i, exploded) {
	    if (letter === " ") {
	      return letter;
	    } else {
	      return colors[rainbowColors[i++ % rainbowColors.length]](letter);
	    }
	  };
	})();


	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(81)(module)))

/***/ },
/* 92 */
/***/ function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(module) {var colors = __webpack_require__(82);

	module['exports'] = (function () {
	  var available = ['underline', 'inverse', 'grey', 'yellow', 'red', 'green', 'blue', 'white', 'cyan', 'magenta'];
	  return function(letter, i, exploded) {
	    return letter === " " ? letter : colors[available[Math.round(Math.random() * (available.length - 1))]](letter);
	  };
	})();
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(81)(module)))

/***/ },
/* 93 */
/***/ function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(module) {var colors = __webpack_require__(82);

	module['exports'] = function (letter, i, exploded) {
	  return i % 2 === 0 ? letter : colors.inverse(letter);
	};
	/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(81)(module)))

/***/ },
/* 94 */
/***/ function(module, exports) {

	/*
	 * cli-config.js: Config that conform to commonly used CLI logging levels.
	 *
	 * (C) 2010 Charlie Robbins
	 * MIT LICENCE
	 *
	 */

	var cliConfig = exports;

	cliConfig.levels = {
	  error: 0,
	  warn: 1,
	  help: 2,
	  data: 3,
	  info: 4,
	  debug: 5,
	  prompt: 6,
	  verbose: 7,
	  input: 8,
	  silly: 9,
	};

	cliConfig.colors = {
	  error: 'red',
	  warn: 'yellow',
	  help: 'cyan',
	  data: 'grey',
	  info: 'green',
	  debug: 'blue',
	  prompt: 'grey',
	  verbose: 'cyan',
	  input: 'grey',
	  silly: 'magenta'
	};


/***/ },
/* 95 */
/***/ function(module, exports) {

	/*
	 * npm-config.js: Config that conform to npm logging levels.
	 *
	 * (C) 2010 Charlie Robbins
	 * MIT LICENCE
	 *
	 */

	var npmConfig = exports;

	npmConfig.levels = {
	  error: 0,
	  warn: 1,
	  info: 2,
	  verbose: 3,
	  debug: 4,
	  silly: 5
	};

	npmConfig.colors = {
	  error: 'red',
	  warn: 'yellow',
	  info: 'green',
	  verbose: 'cyan',
	  debug: 'blue',
	  silly: 'magenta'
	};


/***/ },
/* 96 */
/***/ function(module, exports) {

	/*
	 * syslog-config.js: Config that conform to syslog logging levels.
	 *
	 * (C) 2010 Charlie Robbins
	 * MIT LICENCE
	 *
	 */

	var syslogConfig = exports;

	syslogConfig.levels = {
	  emerg: 0,
	  alert: 1,
	  crit: 2,
	  error: 3,
	  warning: 4,
	  notice: 5,
	  info: 6,
	  debug: 7
	};

	syslogConfig.colors = {
	  emerg: 'red',
	  alert: 'yellow',
	  crit: 'red',
	  error: 'red',
	  warning: 'red',
	  notice: 'yellow',
	  info: 'green',
	  debug: 'blue'
	};


/***/ },
/* 97 */
/***/ function(module, exports, __webpack_require__) {

	/*
	 * transport.js: Base Transport object for all Winston transports.
	 *
	 * (C) 2010 Charlie Robbins
	 * MIT LICENCE
	 *
	 */

	var events = __webpack_require__(76),
	    util = __webpack_require__(12);

	//
	// ### function Transport (options)
	// #### @options {Object} Options for this instance.
	// Constructor function for the Tranport object responsible
	// base functionality for all winston transports.
	//
	var Transport = exports.Transport = function (options) {
	  events.EventEmitter.call(this);

	  options        = options        || {};
	  this.silent    = options.silent || false;
	  this.raw       = options.raw    || false;
	  this.name      = options.name   || this.name;
	  this.formatter = options.formatter;

	  //
	  // Do not set a default level. When `level` is falsey on any
	  // `Transport` instance, any `Logger` instance uses the
	  // configured level (instead of the Transport level)
	  //
	  this.level = options.level;

	  this.handleExceptions = options.handleExceptions || false;
	  this.exceptionsLevel  = options.exceptionsLevel || 'error';
	  this.humanReadableUnhandledException = options.humanReadableUnhandledException || false;
	};

	//
	// Inherit from `events.EventEmitter`.
	//
	util.inherits(Transport, events.EventEmitter);

	//
	// ### function formatQuery (query)
	// #### @query {string|Object} Query to format
	// Formats the specified `query` Object (or string) to conform
	// with the underlying implementation of this transport.
	//
	Transport.prototype.formatQuery = function (query) {
	  return query;
	};

	//
	// ### function normalizeQuery (query)
	// #### @options {string|Object} Query to normalize
	// Normalize options for query
	//
	Transport.prototype.normalizeQuery = function (options) {
	  //
	  // Use options similar to loggly.
	  // [See Loggly Search API](http://wiki.loggly.com/retrieve_events#optional)
	  //

	  options = options || {};

	  // limit
	  options.rows = options.rows || options.limit || 10;

	  // starting row offset
	  options.start = options.start || 0;

	  // now
	  options.until = options.until || new Date;
	  if (typeof options.until !== 'object') {
	    options.until = new Date(options.until);
	  }

	  // now - 24
	  options.from = options.from || (options.until - (24 * 60 * 60 * 1000));
	  if (typeof options.from !== 'object') {
	    options.from = new Date(options.from);
	  }


	  // 'asc' or 'desc'
	  options.order = options.order || 'desc';

	  // which fields to select
	  options.fields = options.fields;

	  return options;
	};

	//
	// ### function formatResults (results, options)
	// #### @results {Object|Array} Results returned from `.query`.
	// #### @options {Object} **Optional** Formatting options
	// Formats the specified `results` with the given `options` accordinging
	// to the implementation of this transport.
	//
	Transport.prototype.formatResults = function (results, options) {
	  return results;
	};

	//
	// ### function logException (msg, meta, callback)
	// #### @msg {string} Message to log
	// #### @meta {Object} **Optional** Additional metadata to attach
	// #### @callback {function} Continuation to respond to when complete.
	// Logs the specified `msg`, `meta` and responds to the callback once the log
	// operation is complete to ensure that the event loop will not exit before
	// all logging has completed.
	//
	Transport.prototype.logException = function (msg, meta, callback) {
	  var self = this,
	      called;

	  if (this.silent) {
	    return callback();
	  }

	  function onComplete () {
	    if (!called) {
	      called = true;
	      self.removeListener('logged', onComplete);
	      self.removeListener('error', onComplete);
	      callback();
	    }
	  }

	  this.once('logged', onComplete);
	  this.once('error', onComplete);
	  this.log(self.exceptionsLevel, msg, meta, function () { });
	};


/***/ },
/* 98 */
/***/ function(module, exports, __webpack_require__) {

	/*
	 * file.js: Transport for outputting to a local log file
	 *
	 * (C) 2010 Charlie Robbins
	 * MIT LICENCE
	 *
	 */

	var events = __webpack_require__(76),
	    fs = __webpack_require__(2),
	    path = __webpack_require__(3),
	    util = __webpack_require__(12),
	    async = __webpack_require__(99),
	    zlib = __webpack_require__(100),
	    common = __webpack_require__(77),
	    Transport = __webpack_require__(97).Transport,
	    isWritable = __webpack_require__(101).isWritable,
	    Stream = __webpack_require__(8).Stream,
	    os = __webpack_require__(4);

	//
	// ### function File (options)
	// #### @options {Object} Options for this instance.
	// Constructor function for the File transport object responsible
	// for persisting log messages and metadata to one or more files.
	//
	var File = exports.File = function (options) {
	  var self = this;
	  Transport.call(this, options);

	  //
	  // Helper function which throws an `Error` in the event
	  // that any of the rest of the arguments is present in `options`.
	  //
	  function throwIf (target /*, illegal... */) {
	    Array.prototype.slice.call(arguments, 1).forEach(function (name) {
	      if (options[name]) {
	        throw new Error('Cannot set ' + name + ' and ' + target + 'together');
	      }
	    });
	  }

	  if (options.filename || options.dirname) {
	    throwIf('filename or dirname', 'stream');
	    this._basename = this.filename = options.filename
	      ? path.basename(options.filename)
	      : 'winston.log';

	    this.dirname = options.dirname || path.dirname(options.filename);
	    this.options = options.options || { flags: 'a' };

	    //
	    // "24 bytes" is maybe a good value for logging lines.
	    //
	    this.options.highWaterMark = this.options.highWaterMark || 24;
	  }
	  else if (options.stream) {
	    throwIf('stream', 'filename', 'maxsize');
	    this._stream = options.stream;
	    this._isStreams2 = isWritable(this._stream);
	    this._stream.on('error', function(error){
	      self.emit('error', error);
	    });
	    //
	    // We need to listen for drain events when
	    // write() returns false. This can make node
	    // mad at times.
	    //
	    this._stream.setMaxListeners(Infinity);
	  }
	  else {
	    throw new Error('Cannot log to file without filename or stream.');
	  }

	  this.json        = options.json !== false;
	  this.logstash    = options.logstash    || false;
	  this.colorize    = options.colorize    || false;
	  this.maxsize     = options.maxsize     || null;
	  this.rotationFormat = options.rotationFormat || false;
	  this.zippedArchive = options.zippedArchive || false;
	  this.maxFiles    = options.maxFiles    || null;
	  this.prettyPrint = options.prettyPrint || false;
	  this.label       = options.label       || null;
	  this.timestamp   = options.timestamp != null ? options.timestamp : true;
	  this.eol         = options.eol || os.EOL;
	  this.tailable    = options.tailable    || false;
	  this.depth       = options.depth       || null;
	  this.showLevel   = options.showLevel === undefined ? true : options.showLevel;
	  this.maxRetries  = options.maxRetries || 2;

	  if (this.json) {
	    this.stringify = options.stringify;
	  }

	  //
	  // Internal state variables representing the number
	  // of files this instance has created and the current
	  // size (in bytes) of the current logfile.
	  //
	  this._size     = 0;
	  this._created  = 0;
	  this._buffer   = [];
	  this._draining = false;
	  this._opening  = false;
	  this._failures = 0;
	  this._archive = null;
	};

	//
	// Inherit from `winston.Transport`.
	//
	util.inherits(File, Transport);

	//
	// Expose the name of this Transport on the prototype
	//
	File.prototype.name = 'file';

	//
	// ### function log (level, msg, [meta], callback)
	// #### @level {string} Level at which to log the message.
	// #### @msg {string} Message to log
	// #### @meta {Object} **Optional** Additional metadata to attach
	// #### @callback {function} Continuation to respond to when complete.
	// Core logging method exposed to Winston. Metadata is optional.
	//
	File.prototype.log = function (level, msg, meta, callback) {
	  if (this.silent) {
	    return callback(null, true);
	  }

	  //
	  // If failures exceeds maxRetries then we can't access the
	  // stream. In this case we need to perform a noop and return
	  // an error.
	  //
	  if (this._failures >= this.maxRetries) {
	    return callback(new Error('Transport is in a failed state.'));
	  }

	  var self = this;

	  if (typeof msg !== 'string') {
	    msg = '' + msg;
	  }

	  var output = common.log({
	    level:       level,
	    message:     msg,
	    meta:        meta,
	    json:        this.json,
	    logstash:    this.logstash,
	    colorize:    this.colorize,
	    prettyPrint: this.prettyPrint,
	    timestamp:   this.timestamp,
	    showLevel:   this.showLevel,
	    stringify:   this.stringify,
	    label:       this.label,
	    depth:       this.depth,
	    formatter:   this.formatter,
	    humanReadableUnhandledException: this.humanReadableUnhandledException
	  });

	  if (typeof output === 'string') {
	    output += this.eol;
	  }

	  if (!this.filename) {
	    //
	    // If there is no `filename` on this instance then it was configured
	    // with a raw `WriteableStream` instance and we should not perform any
	    // size restrictions.
	    //
	    this._write(output, callback);
	    this._size += output.length;
	    this._lazyDrain();
	  }
	  else {
	    this.open(function (err) {
	      if (err) {
	        //
	        // If there was an error enqueue the message
	        //
	        return self._buffer.push([output, callback]);
	      }

	      self._write(output, callback);
	      self._size += output.length;
	      self._lazyDrain();
	    });
	  }
	};

	//
	// ### function _write (data, cb)
	// #### @data {String|Buffer} Data to write to the instance's stream.
	// #### @cb {function} Continuation to respond to when complete.
	// Write to the stream, ensure execution of a callback on completion.
	//
	File.prototype._write = function(data, callback) {
	  if (this._isStreams2) {
	    this._stream.write(data);
	    return callback && process.nextTick(function () {
	      callback(null, true);
	    });
	  }

	  // If this is a file write stream, we could use the builtin
	  // callback functionality, however, the stream is not guaranteed
	  // to be an fs.WriteStream.
	  var ret = this._stream.write(data);
	  if (!callback) return;
	  if (ret === false) {
	    return this._stream.once('drain', function() {
	      callback(null, true);
	    });
	  }
	  process.nextTick(function () {
	    callback(null, true);
	  });
	};

	//
	// ### function query (options, callback)
	// #### @options {Object} Loggly-like query options for this instance.
	// #### @callback {function} Continuation to respond to when complete.
	// Query the transport. Options object is optional.
	//
	File.prototype.query = function (options, callback) {
	  if (typeof options === 'function') {
	    callback = options;
	    options = {};
	  }

	  var file = path.join(this.dirname, this.filename),
	      options = this.normalizeQuery(options),
	      buff = '',
	      results = [],
	      row = 0;

	  var stream = fs.createReadStream(file, {
	    encoding: 'utf8'
	  });

	  stream.on('error', function (err) {
	    if (stream.readable) {
	      stream.destroy();
	    }
	    if (!callback) return;
	    return err.code !== 'ENOENT'
	      ? callback(err)
	      : callback(null, results);
	  });

	  stream.on('data', function (data) {
	    var data = (buff + data).split(/\n+/),
	        l = data.length - 1,
	        i = 0;

	    for (; i < l; i++) {
	      if (!options.start || row >= options.start) {
	        add(data[i]);
	      }
	      row++;
	    }

	    buff = data[l];
	  });

	  stream.on('close', function () {
	    if (buff) add(buff, true);
	    if (options.order === 'desc') {
	      results = results.reverse();
	    }
	    if (callback) callback(null, results);
	  });

	  function add(buff, attempt) {
	    try {
	      var log = JSON.parse(buff);
	      if (check(log)) push(log);
	    } catch (e) {
	      if (!attempt) {
	        stream.emit('error', e);
	      }
	    }
	  }

	  function push(log) {
	    if (options.rows && results.length >= options.rows
	        && options.order != 'desc') {
	      if (stream.readable) {
	        stream.destroy();
	      }
	      return;
	    }

	    if (options.fields) {
	      var obj = {};
	      options.fields.forEach(function (key) {
	        obj[key] = log[key];
	      });
	      log = obj;
	    }

	    if (options.order === 'desc') {
	      if (results.length >= options.rows) {
	        results.shift();
	      }
	    }
	    results.push(log);
	  }

	  function check(log) {
	    if (!log) return;

	    if (typeof log !== 'object') return;

	    var time = new Date(log.timestamp);
	    if ((options.from && time < options.from)
	        || (options.until && time > options.until)) {
	      return;
	    }

	    return true;
	  }
	};

	//
	// ### function stream (options)
	// #### @options {Object} Stream options for this instance.
	// Returns a log stream for this transport. Options object is optional.
	//
	File.prototype.stream = function (options) {
	  var file = path.join(this.dirname, this.filename),
	      options = options || {},
	      stream = new Stream;

	  var tail = {
	    file: file,
	    start: options.start
	  };

	  stream.destroy = common.tailFile(tail, function (err, line) {

	    if(err){
	      return stream.emit('error',err);
	    }

	    try {
	      stream.emit('data', line);
	      line = JSON.parse(line);
	      stream.emit('log', line);
	    } catch (e) {
	      stream.emit('error', e);
	    }
	  });

	  return stream;
	};

	//
	// ### function open (callback)
	// #### @callback {function} Continuation to respond to when complete
	// Checks to see if a new file needs to be created based on the `maxsize`
	// (if any) and the current size of the file used.
	//
	File.prototype.open = function (callback) {
	  if (this.opening) {
	    //
	    // If we are already attempting to open the next
	    // available file then respond with a value indicating
	    // that the message should be buffered.
	    //
	    return callback(true);
	  }
	  else if (!this._stream || (this.maxsize && this._size >= this.maxsize)) {
	    //
	    // If we dont have a stream or have exceeded our size, then create
	    // the next stream and respond with a value indicating that
	    // the message should be buffered.
	    //
	    callback(true);
	    return this._createStream();
	  }

	  this._archive = this.zippedArchive ? this._stream.path : null;

	  //
	  // Otherwise we have a valid (and ready) stream.
	  //
	  callback();
	};

	//
	// ### function close ()
	// Closes the stream associated with this instance.
	//
	File.prototype.close = function () {
	  var self = this;

	  if (this._stream) {
	    this._stream.end();
	    this._stream.destroySoon();

	    this._stream.once('finish', function () {
	      self.emit('flush');
	      self.emit('closed');
	    });
	  }
	};

	//
	// ### function flush ()
	// Flushes any buffered messages to the current `stream`
	// used by this instance.
	//
	File.prototype.flush = function () {
	  var self = this;

	  // If nothing to flush, there will be no "flush" event from native stream
	  // Thus, the "open" event will never be fired (see _createStream.createAndFlush function)
	  // That means, self.opening will never set to false and no logs will be written to disk
	  if (!this._buffer.length) {
	    return self.emit('flush');
	  }

	  //
	  // Iterate over the `_buffer` of enqueued messaged
	  // and then write them to the newly created stream.
	  //
	  this._buffer.forEach(function (item) {
	    var str = item[0],
	        callback = item[1];

	    process.nextTick(function () {
	      self._write(str, callback);
	      self._size += str.length;
	    });
	  });

	  //
	  // Quickly truncate the `_buffer` once the write operations
	  // have been started
	  //
	  self._buffer.length = 0;

	  //
	  // When the stream has drained we have flushed
	  // our buffer.
	  //
	  self._stream.once('drain', function () {
	    self.emit('flush');
	    self.emit('logged');
	  });
	};

	//
	// ### @private function _createStream ()
	// Attempts to open the next appropriate file for this instance
	// based on the common state (such as `maxsize` and `_basename`).
	//
	File.prototype._createStream = function () {
	  var self = this;
	  this.opening = true;

	  (function checkFile (target) {
	    var fullname = path.join(self.dirname, target);

	    //
	    // Creates the `WriteStream` and then flushes any
	    // buffered messages.
	    //
	    function createAndFlush (size) {
	      if (self._stream) {
	        self._stream.end();
	        self._stream.destroySoon();
	      }

	      self._size = size;
	      self.filename = target;
	      self._stream = fs.createWriteStream(fullname, self.options);
	      self._isStreams2 = isWritable(self._stream);
	      self._stream.on('error', function(error){
	        if (self._failures < self.maxRetries) {
	          self._createStream();
	          self._failures++;
	        }
	        else {
	          self.emit('error', error);
	        }
	      });
	      //
	      // We need to listen for drain events when
	      // write() returns false. This can make node
	      // mad at times.
	      //
	      self._stream.setMaxListeners(Infinity);

	      //
	      // When the current stream has finished flushing
	      // then we can be sure we have finished opening
	      // and thus can emit the `open` event.
	      //
	      self.once('flush', function () {
	        // Because "flush" event is based on native stream "drain" event,
	        // logs could be written inbetween "self.flush()" and here
	        // Therefore, we need to flush again to make sure everything is flushed
	        self.flush();

	        self.opening = false;
	        self.emit('open', fullname);
	      });
	      //
	      // Remark: It is possible that in the time it has taken to find the
	      // next logfile to be written more data than `maxsize` has been buffered,
	      // but for sensible limits (10s - 100s of MB) this seems unlikely in less
	      // than one second.
	      //
	      self.flush();
	      compressFile();
	    }

	    function compressFile() {
	      if (self._archive) {
	        var gzip = zlib.createGzip();

	        var inp = fs.createReadStream(String(self._archive));
	        var out = fs.createWriteStream(self._archive + '.gz');

	        inp.pipe(gzip).pipe(out);

	        fs.unlink(String(self._archive));
	        self._archive = '';
	      }
	    }

	    fs.stat(fullname, function (err, stats) {
	      if (err) {
	        if (err.code !== 'ENOENT') {
	          return self.emit('error', err);
	        }
	        return createAndFlush(0);
	      }

	      if (!stats || (self.maxsize && stats.size >= self.maxsize)) {
	        //
	        // If `stats.size` is greater than the `maxsize` for
	        // this instance then try again
	        //
	        return self._incFile(function() {
	          checkFile(self._getFile());
	        });
	      }

	      createAndFlush(stats.size);
	    });
	  })(this._getFile());
	};


	File.prototype._incFile = function (callback) {
	  var ext = path.extname(this._basename),
	      basename = path.basename(this._basename, ext),
	      oldest,
	      target;

	  if (!this.tailable) {
	    this._created += 1;
	    this._checkMaxFilesIncrementing(ext, basename, callback);
	  }
	  else {
	    this._checkMaxFilesTailable(ext, basename, callback);
	  }
	};

	//
	// ### @private function _getFile ()
	// Gets the next filename to use for this instance
	// in the case that log filesizes are being capped.
	//
	File.prototype._getFile = function () {
	  var ext = path.extname(this._basename),
	      basename = path.basename(this._basename, ext);

	  //
	  // Caveat emptor (indexzero): rotationFormat() was broken by design
	  // when combined with max files because the set of files to unlink
	  // is never stored.
	  //
	  return !this.tailable && this._created
	    ? basename + (this.rotationFormat ? this.rotationFormat() : this._created) + ext
	    : basename + ext;
	};

	//
	// ### @private function _checkMaxFilesIncrementing ()
	// Increment the number of files created or
	// checked by this instance.
	//
	File.prototype._checkMaxFilesIncrementing = function (ext, basename, callback) {
	  var oldest, target,
	    self = this;

	  if (self.zippedArchive) {
	    self._archive = path.join(self.dirname, basename +
	        ((self._created === 1) ? '' : self._created-1) +
	        ext);
	  }


	  // Check for maxFiles option and delete file
	  if (!self.maxFiles || self._created < self.maxFiles) {
	    return callback();
	  }

	  oldest = self._created - self.maxFiles;
	  target = path.join(self.dirname, basename + (oldest !== 0 ? oldest : '') + ext +
	    (self.zippedArchive ? '.gz' : ''));
	  fs.unlink(target, callback);
	};

	//
	// ### @private function _checkMaxFilesTailable ()
	//
	// Roll files forward based on integer, up to maxFiles.
	// e.g. if base if file.log and it becomes oversized, roll
	//    to file1.log, and allow file.log to be re-used. If
	//    file is oversized again, roll file1.log to file2.log,
	//    roll file.log to file1.log, and so on.
	File.prototype._checkMaxFilesTailable = function (ext, basename, callback) {
	  var tasks = [],
	      self = this;

	  if (!this.maxFiles)
	    return;

	  for (var x = this.maxFiles - 1; x > 0; x--) {
	    tasks.push(function (i) {
	      return function (cb) {
	        var tmppath = path.join(self.dirname, basename + (i - 1) + ext +
	          (self.zippedArchive ? '.gz' : ''));
	        fs.exists(tmppath, function (exists) {
	          if (!exists) {
	            return cb(null);
	          }

	          fs.rename(tmppath, path.join(self.dirname, basename + i + ext +
	            (self.zippedArchive ? '.gz' : '')), cb);
	        });
	      };
	    }(x));
	  }

	  if (self.zippedArchive) {
	    self._archive = path.join(self.dirname, basename + 1 + ext);
	  }
	  async.series(tasks, function (err) {
	    fs.rename(
	      path.join(self.dirname, basename + ext),
	      path.join(self.dirname, basename + 1 + ext),
	      callback
	    );
	  });
	};

	//
	// ### @private function _lazyDrain ()
	// Lazily attempts to emit the `logged` event when `this.stream` has
	// drained. This is really just a simple mutex that only works because
	// Node.js is single-threaded.
	//
	File.prototype._lazyDrain = function () {
	  var self = this;

	  if (!this._draining && this._stream) {
	    this._draining = true;

	    this._stream.once('drain', function () {
	      this._draining = false;
	      self.emit('logged');
	    });
	  }
	};


/***/ },
/* 99 */
/***/ function(module, exports, __webpack_require__) {

	var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/*!
	 * async
	 * https://github.com/caolan/async
	 *
	 * Copyright 2010-2014 Caolan McMahon
	 * Released under the MIT license
	 */
	(function () {

	    var async = {};
	    var noop = function () {};

	    // global on the server, window in the browser
	    var root, previous_async;

	    if (typeof window == 'object' && this === window) {
	        root = window;
	    }
	    else if (typeof global == 'object' && this === global) {
	        root = global;
	    }
	    else {
	        root = this;
	    }

	    if (root != null) {
	      previous_async = root.async;
	    }

	    async.noConflict = function () {
	        root.async = previous_async;
	        return async;
	    };

	    function only_once(fn) {
	        var called = false;
	        return function() {
	            if (called) throw new Error("Callback was already called.");
	            called = true;
	            fn.apply(root, arguments);
	        };
	    }

	    //// cross-browser compatiblity functions ////

	    var _toString = Object.prototype.toString;

	    var _isArray = Array.isArray || function (obj) {
	        return _toString.call(obj) === '[object Array]';
	    };

	    var _each = function (arr, iterator) {
	      var index = -1,
	          length = arr.length;

	      while (++index < length) {
	        iterator(arr[index], index, arr);
	      }
	    };

	    var _map = function (arr, iterator) {
	      var index = -1,
	          length = arr.length,
	          result = Array(length);

	      while (++index < length) {
	        result[index] = iterator(arr[index], index, arr);
	      }
	      return result;
	    };

	    var _reduce = function (arr, iterator, memo) {
	        _each(arr, function (x, i, a) {
	            memo = iterator(memo, x, i, a);
	        });
	        return memo;
	    };

	    var _forEachOf = function (object, iterator) {
	        _each(_keys(object), function (key) {
	            iterator(object[key], key);
	        });
	    };

	    var _keys = Object.keys || function (obj) {
	        var keys = [];
	        for (var k in obj) {
	            if (obj.hasOwnProperty(k)) {
	                keys.push(k);
	            }
	        }
	        return keys;
	    };

	    var _baseSlice = function (arr, start) {
	        start = start || 0;
	        var index = -1;
	        var length = arr.length;

	        if (start) {
	          length -= start;
	          length = length < 0 ? 0 : length;
	        }
	        var result = Array(length);

	        while (++index < length) {
	          result[index] = arr[index + start];
	        }
	        return result;
	    };

	    //// exported async module functions ////

	    //// nextTick implementation with browser-compatible fallback ////

	    // capture the global reference to guard against fakeTimer mocks
	    var _setImmediate;
	    if (typeof setImmediate === 'function') {
	        _setImmediate = setImmediate;
	    }

	    if (typeof process === 'undefined' || !(process.nextTick)) {
	        if (_setImmediate) {
	            async.nextTick = function (fn) {
	                // not a direct alias for IE10 compatibility
	                _setImmediate(fn);
	            };
	            async.setImmediate = async.nextTick;
	        }
	        else {
	            async.nextTick = function (fn) {
	                setTimeout(fn, 0);
	            };
	            async.setImmediate = async.nextTick;
	        }
	    }
	    else {
	        async.nextTick = process.nextTick;
	        if (_setImmediate) {
	            async.setImmediate = function (fn) {
	              // not a direct alias for IE10 compatibility
	              _setImmediate(fn);
	            };
	        }
	        else {
	            async.setImmediate = async.nextTick;
	        }
	    }

	    async.each = function (arr, iterator, callback) {
	        callback = callback || noop;
	        if (!arr.length) {
	            return callback();
	        }
	        var completed = 0;
	        _each(arr, function (x) {
	            iterator(x, only_once(done) );
	        });
	        function done(err) {
	          if (err) {
	              callback(err);
	              callback = noop;
	          }
	          else {
	              completed += 1;
	              if (completed >= arr.length) {
	                  callback();
	              }
	          }
	        }
	    };
	    async.forEach = async.each;

	    async.eachSeries = function (arr, iterator, callback) {
	        callback = callback || noop;
	        if (!arr.length) {
	            return callback();
	        }
	        var completed = 0;
	        var iterate = function () {
	            iterator(arr[completed], function (err) {
	                if (err) {
	                    callback(err);
	                    callback = noop;
	                }
	                else {
	                    completed += 1;
	                    if (completed >= arr.length) {
	                        callback();
	                    }
	                    else {
	                        iterate();
	                    }
	                }
	            });
	        };
	        iterate();
	    };
	    async.forEachSeries = async.eachSeries;


	    async.eachLimit = function (arr, limit, iterator, callback) {
	        var fn = _eachLimit(limit);
	        fn.apply(null, [arr, iterator, callback]);
	    };
	    async.forEachLimit = async.eachLimit;

	    var _eachLimit = function (limit) {

	        return function (arr, iterator, callback) {
	            callback = callback || noop;
	            if (!arr.length || limit <= 0) {
	                return callback();
	            }
	            var completed = 0;
	            var started = 0;
	            var running = 0;

	            (function replenish () {
	                if (completed >= arr.length) {
	                    return callback();
	                }

	                while (running < limit && started < arr.length) {
	                    started += 1;
	                    running += 1;
	                    iterator(arr[started - 1], function (err) {
	                        if (err) {
	                            callback(err);
	                            callback = noop;
	                        }
	                        else {
	                            completed += 1;
	                            running -= 1;
	                            if (completed >= arr.length) {
	                                callback();
	                            }
	                            else {
	                                replenish();
	                            }
	                        }
	                    });
	                }
	            })();
	        };
	    };



	    async.forEachOf = async.eachOf = function (object, iterator, callback) {
	        callback = callback || function () {};
	        var size = object.length || _keys(object).length;
	        var completed = 0;
	        if (!size) {
	            return callback();
	        }
	        _forEachOf(object, function (value, key) {
	            iterator(object[key], key, function (err) {
	                if (err) {
	                    callback(err);
	                    callback = function () {};
	                } else {
	                    completed += 1;
	                    if (completed === size) {
	                        callback(null);
	                    }
	                }
	            });
	        });
	    };

	    async.forEachOfSeries = async.eachOfSeries = function (obj, iterator, callback) {
	        callback = callback || function () {};
	        var keys = _keys(obj);
	        var size = keys.length;
	        if (!size) {
	            return callback();
	        }
	        var completed = 0;
	        var iterate = function () {
	            var sync = true;
	            var key = keys[completed];
	            iterator(obj[key], key, function (err) {
	                if (err) {
	                    callback(err);
	                    callback = function () {};
	                }
	                else {
	                    completed += 1;
	                    if (completed >= size) {
	                        callback(null);
	                    }
	                    else {
	                        if (sync) {
	                            async.nextTick(iterate);
	                        }
	                        else {
	                            iterate();
	                        }
	                    }
	                }
	            });
	            sync = false;
	        };
	        iterate();
	    };



	    async.forEachOfLimit = async.eachOfLimit = function (obj, limit, iterator, callback) {
	        _forEachOfLimit(limit)(obj, iterator, callback);
	    };

	    var _forEachOfLimit = function (limit) {

	        return function (obj, iterator, callback) {
	            callback = callback || function () {};
	            var keys = _keys(obj);
	            var size = keys.length;
	            if (!size || limit <= 0) {
	                return callback();
	            }
	            var completed = 0;
	            var started = 0;
	            var running = 0;

	            (function replenish () {
	                if (completed >= size) {
	                    return callback();
	                }

	                while (running < limit && started < size) {
	                    started += 1;
	                    running += 1;
	                    var key = keys[started - 1];
	                    iterator(obj[key], key, function (err) {
	                        if (err) {
	                            callback(err);
	                            callback = function () {};
	                        }
	                        else {
	                            completed += 1;
	                            running -= 1;
	                            if (completed >= size) {
	                                callback();
	                            }
	                            else {
	                                replenish();
	                            }
	                        }
	                    });
	                }
	            })();
	        };
	    };


	    var doParallel = function (fn) {
	        return function () {
	            var args = _baseSlice(arguments);
	            return fn.apply(null, [async.each].concat(args));
	        };
	    };
	    var doParallelLimit = function(limit, fn) {
	        return function () {
	            var args = _baseSlice(arguments);
	            return fn.apply(null, [_eachLimit(limit)].concat(args));
	        };
	    };
	    var doSeries = function (fn) {
	        return function () {
	            var args = _baseSlice(arguments);
	            return fn.apply(null, [async.eachSeries].concat(args));
	        };
	    };


	    var _asyncMap = function (eachfn, arr, iterator, callback) {
	        arr = _map(arr, function (x, i) {
	            return {index: i, value: x};
	        });
	        if (!callback) {
	            eachfn(arr, function (x, callback) {
	                iterator(x.value, function (err) {
	                    callback(err);
	                });
	            });
	        } else {
	            var results = [];
	            eachfn(arr, function (x, callback) {
	                iterator(x.value, function (err, v) {
	                    results[x.index] = v;
	                    callback(err);
	                });
	            }, function (err) {
	                callback(err, results);
	            });
	        }
	    };
	    async.map = doParallel(_asyncMap);
	    async.mapSeries = doSeries(_asyncMap);
	    async.mapLimit = function (arr, limit, iterator, callback) {
	        return _mapLimit(limit)(arr, iterator, callback);
	    };

	    var _mapLimit = function(limit) {
	        return doParallelLimit(limit, _asyncMap);
	    };

	    // reduce only has a series version, as doing reduce in parallel won't
	    // work in many situations.
	    async.reduce = function (arr, memo, iterator, callback) {
	        async.eachSeries(arr, function (x, callback) {
	            iterator(memo, x, function (err, v) {
	                memo = v;
	                callback(err);
	            });
	        }, function (err) {
	            callback(err, memo);
	        });
	    };
	    // inject alias
	    async.inject = async.reduce;
	    // foldl alias
	    async.foldl = async.reduce;

	    async.reduceRight = function (arr, memo, iterator, callback) {
	        var reversed = _map(arr, function (x) {
	            return x;
	        }).reverse();
	        async.reduce(reversed, memo, iterator, callback);
	    };
	    // foldr alias
	    async.foldr = async.reduceRight;

	    var _filter = function (eachfn, arr, iterator, callback) {
	        var results = [];
	        arr = _map(arr, function (x, i) {
	            return {index: i, value: x};
	        });
	        eachfn(arr, function (x, callback) {
	            iterator(x.value, function (v) {
	                if (v) {
	                    results.push(x);
	                }
	                callback();
	            });
	        }, function (err) {
	            callback(_map(results.sort(function (a, b) {
	                return a.index - b.index;
	            }), function (x) {
	                return x.value;
	            }));
	        });
	    };
	    async.filter = doParallel(_filter);
	    async.filterSeries = doSeries(_filter);
	    // select alias
	    async.select = async.filter;
	    async.selectSeries = async.filterSeries;

	    var _reject = function (eachfn, arr, iterator, callback) {
	        var results = [];
	        arr = _map(arr, function (x, i) {
	            return {index: i, value: x};
	        });
	        eachfn(arr, function (x, callback) {
	            iterator(x.value, function (v) {
	                if (!v) {
	                    results.push(x);
	                }
	                callback();
	            });
	        }, function (err) {
	            callback(_map(results.sort(function (a, b) {
	                return a.index - b.index;
	            }), function (x) {
	                return x.value;
	            }));
	        });
	    };
	    async.reject = doParallel(_reject);
	    async.rejectSeries = doSeries(_reject);

	    var _detect = function (eachfn, arr, iterator, main_callback) {
	        eachfn(arr, function (x, callback) {
	            iterator(x, function (result) {
	                if (result) {
	                    main_callback(x);
	                    main_callback = noop;
	                }
	                else {
	                    callback();
	                }
	            });
	        }, function (err) {
	            main_callback();
	        });
	    };
	    async.detect = doParallel(_detect);
	    async.detectSeries = doSeries(_detect);

	    async.some = function (arr, iterator, main_callback) {
	        async.each(arr, function (x, callback) {
	            iterator(x, function (v) {
	                if (v) {
	                    main_callback(true);
	                    main_callback = noop;
	                }
	                callback();
	            });
	        }, function (err) {
	            main_callback(false);
	        });
	    };
	    // any alias
	    async.any = async.some;

	    async.every = function (arr, iterator, main_callback) {
	        async.each(arr, function (x, callback) {
	            iterator(x, function (v) {
	                if (!v) {
	                    main_callback(false);
	                    main_callback = noop;
	                }
	                callback();
	            });
	        }, function (err) {
	            main_callback(true);
	        });
	    };
	    // all alias
	    async.all = async.every;

	    async.sortBy = function (arr, iterator, callback) {
	        async.map(arr, function (x, callback) {
	            iterator(x, function (err, criteria) {
	                if (err) {
	                    callback(err);
	                }
	                else {
	                    callback(null, {value: x, criteria: criteria});
	                }
	            });
	        }, function (err, results) {
	            if (err) {
	                return callback(err);
	            }
	            else {
	                var fn = function (left, right) {
	                    var a = left.criteria, b = right.criteria;
	                    return a < b ? -1 : a > b ? 1 : 0;
	                };
	                callback(null, _map(results.sort(fn), function (x) {
	                    return x.value;
	                }));
	            }
	        });
	    };

	    async.auto = function (tasks, callback) {
	        callback = callback || noop;
	        var keys = _keys(tasks);
	        var remainingTasks = keys.length;
	        if (!remainingTasks) {
	            return callback();
	        }

	        var results = {};

	        var listeners = [];
	        var addListener = function (fn) {
	            listeners.unshift(fn);
	        };
	        var removeListener = function (fn) {
	            for (var i = 0; i < listeners.length; i += 1) {
	                if (listeners[i] === fn) {
	                    listeners.splice(i, 1);
	                    return;
	                }
	            }
	        };
	        var taskComplete = function () {
	            remainingTasks--;
	            _each(listeners.slice(0), function (fn) {
	                fn();
	            });
	        };

	        addListener(function () {
	            if (!remainingTasks) {
	                var theCallback = callback;
	                // prevent final callback from calling itself if it errors
	                callback = noop;

	                theCallback(null, results);
	            }
	        });

	        _each(keys, function (k) {
	            var task = _isArray(tasks[k]) ? tasks[k]: [tasks[k]];
	            var taskCallback = function (err) {
	                var args = _baseSlice(arguments, 1);
	                if (args.length <= 1) {
	                    args = args[0];
	                }
	                if (err) {
	                    var safeResults = {};
	                    _each(_keys(results), function(rkey) {
	                        safeResults[rkey] = results[rkey];
	                    });
	                    safeResults[k] = args;
	                    callback(err, safeResults);
	                    // stop subsequent errors hitting callback multiple times
	                    callback = noop;
	                }
	                else {
	                    results[k] = args;
	                    async.setImmediate(taskComplete);
	                }
	            };
	            var requires = task.slice(0, Math.abs(task.length - 1)) || [];
	            // prevent dead-locks
	            var len = requires.length;
	            var dep;
	            while (len--) {
	                if (!(dep = tasks[requires[len]])) {
	                    throw new Error('Has inexistant dependency');
	                }
	                if (_isArray(dep) && !!~dep.indexOf(k)) {
	                    throw new Error('Has cyclic dependencies');
	                }
	            }
	            var ready = function () {
	                return _reduce(requires, function (a, x) {
	                    return (a && results.hasOwnProperty(x));
	                }, true) && !results.hasOwnProperty(k);
	            };
	            if (ready()) {
	                task[task.length - 1](taskCallback, results);
	            }
	            else {
	                var listener = function () {
	                    if (ready()) {
	                        removeListener(listener);
	                        task[task.length - 1](taskCallback, results);
	                    }
	                };
	                addListener(listener);
	            }
	        });
	    };

	    async.retry = function(times, task, callback) {
	        var DEFAULT_TIMES = 5;
	        var attempts = [];
	        // Use defaults if times not passed
	        if (typeof times === 'function') {
	            callback = task;
	            task = times;
	            times = DEFAULT_TIMES;
	        }
	        // Make sure times is a number
	        times = parseInt(times, 10) || DEFAULT_TIMES;
	        var wrappedTask = function(wrappedCallback, wrappedResults) {
	            var retryAttempt = function(task, finalAttempt) {
	                return function(seriesCallback) {
	                    task(function(err, result){
	                        seriesCallback(!err || finalAttempt, {err: err, result: result});
	                    }, wrappedResults);
	                };
	            };
	            while (times) {
	                attempts.push(retryAttempt(task, !(times-=1)));
	            }
	            async.series(attempts, function(done, data){
	                data = data[data.length - 1];
	                (wrappedCallback || callback)(data.err, data.result);
	            });
	        };
	        // If a callback is passed, run this as a controll flow
	        return callback ? wrappedTask() : wrappedTask;
	    };

	    async.waterfall = function (tasks, callback) {
	        callback = callback || noop;
	        if (!_isArray(tasks)) {
	          var err = new Error('First argument to waterfall must be an array of functions');
	          return callback(err);
	        }
	        if (!tasks.length) {
	            return callback();
	        }
	        var wrapIterator = function (iterator) {
	            return function (err) {
	                if (err) {
	                    callback.apply(null, arguments);
	                    callback = noop;
	                }
	                else {
	                    var args = _baseSlice(arguments, 1);
	                    var next = iterator.next();
	                    if (next) {
	                        args.push(wrapIterator(next));
	                    }
	                    else {
	                        args.push(callback);
	                    }
	                    async.setImmediate(function () {
	                        iterator.apply(null, args);
	                    });
	                }
	            };
	        };
	        wrapIterator(async.iterator(tasks))();
	    };

	    var _parallel = function(eachfn, tasks, callback) {
	        callback = callback || noop;
	        if (_isArray(tasks)) {
	            eachfn.map(tasks, function (fn, callback) {
	                if (fn) {
	                    fn(function (err) {
	                        var args = _baseSlice(arguments, 1);
	                        if (args.length <= 1) {
	                            args = args[0];
	                        }
	                        callback.call(null, err, args);
	                    });
	                }
	            }, callback);
	        }
	        else {
	            var results = {};
	            eachfn.each(_keys(tasks), function (k, callback) {
	                tasks[k](function (err) {
	                    var args = _baseSlice(arguments, 1);
	                    if (args.length <= 1) {
	                        args = args[0];
	                    }
	                    results[k] = args;
	                    callback(err);
	                });
	            }, function (err) {
	                callback(err, results);
	            });
	        }
	    };

	    async.parallel = function (tasks, callback) {
	        _parallel({ map: async.map, each: async.each }, tasks, callback);
	    };

	    async.parallelLimit = function(tasks, limit, callback) {
	        _parallel({ map: _mapLimit(limit), each: _eachLimit(limit) }, tasks, callback);
	    };

	    async.series = function (tasks, callback) {
	        callback = callback || noop;
	        if (_isArray(tasks)) {
	            async.mapSeries(tasks, function (fn, callback) {
	                if (fn) {
	                    fn(function (err) {
	                        var args = _baseSlice(arguments, 1);
	                        if (args.length <= 1) {
	                            args = args[0];
	                        }
	                        callback.call(null, err, args);
	                    });
	                }
	            }, callback);
	        }
	        else {
	            var results = {};
	            async.eachSeries(_keys(tasks), function (k, callback) {
	                tasks[k](function (err) {
	                    var args = _baseSlice(arguments, 1);
	                    if (args.length <= 1) {
	                        args = args[0];
	                    }
	                    results[k] = args;
	                    callback(err);
	                });
	            }, function (err) {
	                callback(err, results);
	            });
	        }
	    };

	    async.iterator = function (tasks) {
	        var makeCallback = function (index) {
	            var fn = function () {
	                if (tasks.length) {
	                    tasks[index].apply(null, arguments);
	                }
	                return fn.next();
	            };
	            fn.next = function () {
	                return (index < tasks.length - 1) ? makeCallback(index + 1): null;
	            };
	            return fn;
	        };
	        return makeCallback(0);
	    };

	    async.apply = function (fn) {
	        var args = _baseSlice(arguments, 1);
	        return function () {
	            return fn.apply(
	                null, args.concat(_baseSlice(arguments))
	            );
	        };
	    };

	    var _concat = function (eachfn, arr, fn, callback) {
	        var r = [];
	        eachfn(arr, function (x, cb) {
	            fn(x, function (err, y) {
	                r = r.concat(y || []);
	                cb(err);
	            });
	        }, function (err) {
	            callback(err, r);
	        });
	    };
	    async.concat = doParallel(_concat);
	    async.concatSeries = doSeries(_concat);

	    async.whilst = function (test, iterator, callback) {
	        if (test()) {
	            iterator(function (err) {
	                if (err) {
	                    return callback(err);
	                }
	                async.whilst(test, iterator, callback);
	            });
	        }
	        else {
	            callback();
	        }
	    };

	    async.doWhilst = function (iterator, test, callback) {
	        iterator(function (err) {
	            if (err) {
	                return callback(err);
	            }
	            var args = _baseSlice(arguments, 1);
	            if (test.apply(null, args)) {
	                async.doWhilst(iterator, test, callback);
	            }
	            else {
	                callback();
	            }
	        });
	    };

	    async.until = function (test, iterator, callback) {
	        if (!test()) {
	            iterator(function (err) {
	                if (err) {
	                    return callback(err);
	                }
	                async.until(test, iterator, callback);
	            });
	        }
	        else {
	            callback();
	        }
	    };

	    async.doUntil = function (iterator, test, callback) {
	        iterator(function (err) {
	            if (err) {
	                return callback(err);
	            }
	            var args = _baseSlice(arguments, 1);
	            if (!test.apply(null, args)) {
	                async.doUntil(iterator, test, callback);
	            }
	            else {
	                callback();
	            }
	        });
	    };

	    async.queue = function (worker, concurrency) {
	        if (concurrency === undefined) {
	            concurrency = 1;
	        }
	        else if(concurrency === 0) {
	            throw new Error('Concurrency must not be zero');
	        }
	        function _insert(q, data, pos, callback) {
	          if (!q.started){
	            q.started = true;
	          }
	          if (!_isArray(data)) {
	              data = [data];
	          }
	          if(data.length === 0) {
	             // call drain immediately if there are no tasks
	             return async.setImmediate(function() {
	                 if (q.drain) {
	                     q.drain();
	                 }
	             });
	          }
	          _each(data, function(task) {
	              var item = {
	                  data: task,
	                  callback: typeof callback === 'function' ? callback : null
	              };

	              if (pos) {
	                q.tasks.unshift(item);
	              } else {
	                q.tasks.push(item);
	              }

	              if (q.saturated && q.tasks.length === q.concurrency) {
	                  q.saturated();
	              }
	              async.setImmediate(q.process);
	          });
	        }

	        var workers = 0;
	        var q = {
	            tasks: [],
	            concurrency: concurrency,
	            saturated: null,
	            empty: null,
	            drain: null,
	            started: false,
	            paused: false,
	            push: function (data, callback) {
	              _insert(q, data, false, callback);
	            },
	            kill: function () {
	              q.drain = null;
	              q.tasks = [];
	            },
	            unshift: function (data, callback) {
	              _insert(q, data, true, callback);
	            },
	            process: function () {
	                if (!q.paused && workers < q.concurrency && q.tasks.length) {
	                    var task = q.tasks.shift();
	                    if (q.empty && q.tasks.length === 0) {
	                        q.empty();
	                    }
	                    workers += 1;
	                    var next = function () {
	                        workers -= 1;
	                        if (task.callback) {
	                            task.callback.apply(task, arguments);
	                        }
	                        if (q.drain && q.tasks.length + workers === 0) {
	                            q.drain();
	                        }
	                        q.process();
	                    };
	                    var cb = only_once(next);
	                    worker(task.data, cb);
	                }
	            },
	            length: function () {
	                return q.tasks.length;
	            },
	            running: function () {
	                return workers;
	            },
	            idle: function() {
	                return q.tasks.length + workers === 0;
	            },
	            pause: function () {
	                if (q.paused === true) { return; }
	                q.paused = true;
	            },
	            resume: function () {
	                if (q.paused === false) { return; }
	                q.paused = false;
	                var resumeCount = Math.min(q.concurrency, q.tasks.length);
	                // Need to call q.process once per concurrent
	                // worker to preserve full concurrency after pause
	                for (var w = 1; w <= resumeCount; w++) {
	                    async.setImmediate(q.process);
	                }
	            }
	        };
	        return q;
	    };

	    async.priorityQueue = function (worker, concurrency) {

	        function _compareTasks(a, b){
	          return a.priority - b.priority;
	        }

	        function _binarySearch(sequence, item, compare) {
	          var beg = -1,
	              end = sequence.length - 1;
	          while (beg < end) {
	            var mid = beg + ((end - beg + 1) >>> 1);
	            if (compare(item, sequence[mid]) >= 0) {
	              beg = mid;
	            } else {
	              end = mid - 1;
	            }
	          }
	          return beg;
	        }

	        function _insert(q, data, priority, callback) {
	          if (!q.started){
	            q.started = true;
	          }
	          if (!_isArray(data)) {
	              data = [data];
	          }
	          if(data.length === 0) {
	             // call drain immediately if there are no tasks
	             return async.setImmediate(function() {
	                 if (q.drain) {
	                     q.drain();
	                 }
	             });
	          }
	          _each(data, function(task) {
	              var item = {
	                  data: task,
	                  priority: priority,
	                  callback: typeof callback === 'function' ? callback : null
	              };

	              q.tasks.splice(_binarySearch(q.tasks, item, _compareTasks) + 1, 0, item);

	              if (q.saturated && q.tasks.length === q.concurrency) {
	                  q.saturated();
	              }
	              async.setImmediate(q.process);
	          });
	        }

	        // Start with a normal queue
	        var q = async.queue(worker, concurrency);

	        // Override push to accept second parameter representing priority
	        q.push = function (data, priority, callback) {
	          _insert(q, data, priority, callback);
	        };

	        // Remove unshift function
	        delete q.unshift;

	        return q;
	    };

	    async.cargo = function (worker, payload) {
	        var working     = false,
	            tasks       = [];

	        var cargo = {
	            tasks: tasks,
	            payload: payload,
	            saturated: null,
	            empty: null,
	            drain: null,
	            drained: true,
	            push: function (data, callback) {
	                if (!_isArray(data)) {
	                    data = [data];
	                }
	                _each(data, function(task) {
	                    tasks.push({
	                        data: task,
	                        callback: typeof callback === 'function' ? callback : null
	                    });
	                    cargo.drained = false;
	                    if (cargo.saturated && tasks.length === payload) {
	                        cargo.saturated();
	                    }
	                });
	                async.setImmediate(cargo.process);
	            },
	            process: function process() {
	                if (working) return;
	                if (tasks.length === 0) {
	                    if(cargo.drain && !cargo.drained) cargo.drain();
	                    cargo.drained = true;
	                    return;
	                }

	                var ts = typeof payload === 'number' ?
	                    tasks.splice(0, payload) :
	                    tasks.splice(0, tasks.length);

	                var ds = _map(ts, function (task) {
	                    return task.data;
	                });

	                if(cargo.empty) cargo.empty();
	                working = true;
	                worker(ds, function () {
	                    working = false;

	                    var args = arguments;
	                    _each(ts, function (data) {
	                        if (data.callback) {
	                            data.callback.apply(null, args);
	                        }
	                    });

	                    process();
	                });
	            },
	            length: function () {
	                return tasks.length;
	            },
	            running: function () {
	                return working;
	            }
	        };
	        return cargo;
	    };

	    var _console_fn = function (name) {
	        return function (fn) {
	            var args = _baseSlice(arguments, 1);
	            fn.apply(null, args.concat([function (err) {
	                var args = _baseSlice(arguments, 1);
	                if (typeof console !== 'undefined') {
	                    if (err) {
	                        if (console.error) {
	                            console.error(err);
	                        }
	                    }
	                    else if (console[name]) {
	                        _each(args, function (x) {
	                            console[name](x);
	                        });
	                    }
	                }
	            }]));
	        };
	    };
	    async.log = _console_fn('log');
	    async.dir = _console_fn('dir');
	    /*async.info = _console_fn('info');
	    async.warn = _console_fn('warn');
	    async.error = _console_fn('error');*/

	    async.memoize = function (fn, hasher) {
	        var memo = {};
	        var queues = {};
	        hasher = hasher || function (x) {
	            return x;
	        };
	        var memoized = function () {
	            var args = _baseSlice(arguments);
	            var callback = args.pop();
	            var key = hasher.apply(null, args);
	            if (key in memo) {
	                async.nextTick(function () {
	                    callback.apply(null, memo[key]);
	                });
	            }
	            else if (key in queues) {
	                queues[key].push(callback);
	            }
	            else {
	                queues[key] = [callback];
	                fn.apply(null, args.concat([function () {
	                    memo[key] = _baseSlice(arguments);
	                    var q = queues[key];
	                    delete queues[key];
	                    for (var i = 0, l = q.length; i < l; i++) {
	                      q[i].apply(null, arguments);
	                    }
	                }]));
	            }
	        };
	        memoized.memo = memo;
	        memoized.unmemoized = fn;
	        return memoized;
	    };

	    async.unmemoize = function (fn) {
	      return function () {
	        return (fn.unmemoized || fn).apply(null, arguments);
	      };
	    };

	    async.times = function (count, iterator, callback) {
	        var counter = [];
	        for (var i = 0; i < count; i++) {
	            counter.push(i);
	        }
	        return async.map(counter, iterator, callback);
	    };

	    async.timesSeries = function (count, iterator, callback) {
	        var counter = [];
	        for (var i = 0; i < count; i++) {
	            counter.push(i);
	        }
	        return async.mapSeries(counter, iterator, callback);
	    };

	    async.seq = function (/* functions... */) {
	        var fns = arguments;
	        return function () {
	            var that = this;
	            var args = _baseSlice(arguments);
	            var callback = args.pop();
	            async.reduce(fns, args, function (newargs, fn, cb) {
	                fn.apply(that, newargs.concat([function () {
	                    var err = arguments[0];
	                    var nextargs = _baseSlice(arguments, 1);
	                    cb(err, nextargs);
	                }]));
	            },
	            function (err, results) {
	                callback.apply(that, [err].concat(results));
	            });
	        };
	    };

	    async.compose = function (/* functions... */) {
	      return async.seq.apply(null, Array.prototype.reverse.call(arguments));
	    };

	    var _applyEach = function (eachfn, fns /*args...*/) {
	        var go = function () {
	            var that = this;
	            var args = _baseSlice(arguments);
	            var callback = args.pop();
	            return eachfn(fns, function (fn, cb) {
	                fn.apply(that, args.concat([cb]));
	            },
	            callback);
	        };
	        if (arguments.length > 2) {
	            var args = _baseSlice(arguments, 2);
	            return go.apply(this, args);
	        }
	        else {
	            return go;
	        }
	    };
	    async.applyEach = doParallel(_applyEach);
	    async.applyEachSeries = doSeries(_applyEach);

	    async.forever = function (fn, callback) {
	        function next(err) {
	            if (err) {
	                if (callback) {
	                    return callback(err);
	                }
	                throw err;
	            }
	            fn(next);
	        }
	        next();
	    };

	    // Node.js
	    if (typeof module !== 'undefined' && module.exports) {
	        module.exports = async;
	    }
	    // AMD / RequireJS
	    else if (true) {
	        !(__WEBPACK_AMD_DEFINE_ARRAY__ = [], __WEBPACK_AMD_DEFINE_RESULT__ = function () {
	            return async;
	        }.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__), __WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
	    }
	    // included directly via <script> tag
	    else {
	        root.async = async;
	    }

	}());


/***/ },
/* 100 */
/***/ function(module, exports) {

	module.exports = require("zlib");

/***/ },
/* 101 */
/***/ function(module, exports, __webpack_require__) {

	var stream = __webpack_require__(8)


	function isStream (obj) {
	  return obj instanceof stream.Stream
	}


	function isReadable (obj) {
	  return isStream(obj) && typeof obj._read == 'function' && typeof obj._readableState == 'object'
	}


	function isWritable (obj) {
	  return isStream(obj) && typeof obj._write == 'function' && typeof obj._writableState == 'object'
	}


	function isDuplex (obj) {
	  return isReadable(obj) && isWritable(obj)
	}


	module.exports            = isStream
	module.exports.isReadable = isReadable
	module.exports.isWritable = isWritable
	module.exports.isDuplex   = isDuplex


/***/ },
/* 102 */
/***/ function(module, exports, __webpack_require__) {

	var util = __webpack_require__(12),
	    winston = __webpack_require__(72),
	    http = __webpack_require__(13),
	    https = __webpack_require__(103),
	    Stream = __webpack_require__(8).Stream,
	    Transport = __webpack_require__(97).Transport;

	//
	// ### function Http (options)
	// #### @options {Object} Options for this instance.
	// Constructor function for the Http transport object responsible
	// for persisting log messages and metadata to a terminal or TTY.
	//
	var Http = exports.Http = function (options) {
	  Transport.call(this, options);
	  options = options || {};

	  this.name = 'http';
	  this.ssl = !!options.ssl;
	  this.host = options.host || 'localhost';
	  this.port = options.port;
	  this.auth = options.auth;
	  this.path = options.path || '';
	  this.agent = options.agent;

	  if (!this.port) {
	    this.port = this.ssl ? 443 : 80;
	  }
	};

	util.inherits(Http, winston.Transport);

	//
	// Expose the name of this Transport on the prototype
	//
	Http.prototype.name = 'http';

	//
	// ### function _request (options, callback)
	// #### @callback {function} Continuation to respond to when complete.
	// Make a request to a winstond server or any http server which can
	// handle json-rpc.
	//
	Http.prototype._request = function (options, callback) {
	  options = options || {};

	  var auth = options.auth || this.auth,
	      path = options.path || this.path || '',
	      req;

	  delete options.auth;
	  delete options.path;

	  // Prepare options for outgoing HTTP request
	  req = (this.ssl ? https : http).request({
	    host: this.host,
	    port: this.port,
	    path: '/' + path.replace(/^\//, ''),
	    method: 'POST',
	    headers: { 'Content-Type': 'application/json' },
	    agent: this.agent,
	    auth: (auth) ? auth.username + ':' + auth.password : ''
	  });

	  req.on('error', callback);
	  req.on('response', function (res) {
	    var body = '';

	    res.on('data', function (chunk) {
	      body += chunk;
	    });

	    res.on('end', function () {
	      callback(null, res, body);
	    });

	    res.resume();
	  });

	  req.end(new Buffer(JSON.stringify(options), 'utf8'));
	};

	//
	// ### function log (level, msg, [meta], callback)
	// #### @level {string} Level at which to log the message.
	// #### @msg {string} Message to log
	// #### @meta {Object} **Optional** Additional metadata to attach
	// #### @callback {function} Continuation to respond to when complete.
	// Core logging method exposed to Winston. Metadata is optional.
	//
	Http.prototype.log = function (level, msg, meta, callback) {
	  var self = this;

	  if (typeof meta === 'function') {
	    callback = meta;
	    meta = {};
	  }

	  var options = {
	    method: 'collect',
	    params: {
	      level: level,
	      message: msg,
	      meta: meta
	    }
	  };

	  if (meta) {
	    if (meta.path) {
	      options.path = meta.path;
	      delete meta.path;
	    }

	    if (meta.auth) {
	      options.auth = meta.auth;
	      delete meta.auth;
	    }
	  }

	  this._request(options, function (err, res) {
	    if (res && res.statusCode !== 200) {
	      err = new Error('HTTP Status Code: ' + res.statusCode);
	    }

	    if (err) return callback(err);

	    // TODO: emit 'logged' correctly,
	    // keep track of pending logs.
	    self.emit('logged');

	    if (callback) callback(null, true);
	  });
	};

	//
	// ### function query (options, callback)
	// #### @options {Object} Loggly-like query options for this instance.
	// #### @callback {function} Continuation to respond to when complete.
	// Query the transport. Options object is optional.
	//
	Http.prototype.query = function (options, callback) {
	  if (typeof options === 'function') {
	    callback = options;
	    options = {};
	  }

	  var self = this,
	      options = this.normalizeQuery(options);

	  options = {
	    method: 'query',
	    params: options
	  };

	  if (options.params.path) {
	    options.path = options.params.path;
	    delete options.params.path;
	  }

	  if (options.params.auth) {
	    options.auth = options.params.auth;
	    delete options.params.auth;
	  }

	  this._request(options, function (err, res, body) {
	    if (res && res.statusCode !== 200) {
	      err = new Error('HTTP Status Code: ' + res.statusCode);
	    }

	    if (err) return callback(err);

	    if (typeof body === 'string') {
	      try {
	        body = JSON.parse(body);
	      } catch (e) {
	        return callback(e);
	      }
	    }

	    callback(null, body);
	  });
	};

	//
	// ### function stream (options)
	// #### @options {Object} Stream options for this instance.
	// Returns a log stream for this transport. Options object is optional.
	//
	Http.prototype.stream = function (options) {
	  options = options || {};
	  
	  var self = this,
	      stream = new Stream,
	      req,
	      buff;

	  stream.destroy = function () {
	    req.destroy();
	  };

	  options = {
	    method: 'stream',
	    params: options
	  };

	  if (options.params.path) {
	    options.path = options.params.path;
	    delete options.params.path;
	  }

	  if (options.params.auth) {
	    options.auth = options.params.auth;
	    delete options.params.auth;
	  }

	  req = this._request(options);
	  buff = '';

	  req.on('data', function (data) {
	    var data = (buff + data).split(/\n+/),
	        l = data.length - 1,
	        i = 0;

	    for (; i < l; i++) {
	      try {
	        stream.emit('log', JSON.parse(data[i]));
	      } catch (e) {
	        stream.emit('error', e);
	      }
	    }

	    buff = data[l];
	  });

	  req.on('error', function (err) {
	    stream.emit('error', err);
	  });

	  return stream;
	};


/***/ },
/* 103 */
/***/ function(module, exports) {

	module.exports = require("https");

/***/ },
/* 104 */
/***/ function(module, exports, __webpack_require__) {

	var events = __webpack_require__(76),
	    util = __webpack_require__(12),
	    common = __webpack_require__(77),
	    Transport = __webpack_require__(97).Transport;

	//
	// ### function Memory (options)
	// #### @options {Object} Options for this instance.
	// Constructor function for the Memory transport object responsible
	// for persisting log messages and metadata to a memory array of messages.
	//
	var Memory = exports.Memory = function (options) {
	  Transport.call(this, options);
	  options = options || {};

	  this.errorOutput = [];
	  this.writeOutput = [];

	  this.json        = options.json        || false;
	  this.colorize    = options.colorize    || false;
	  this.prettyPrint = options.prettyPrint || false;
	  this.timestamp   = typeof options.timestamp !== 'undefined' ? options.timestamp : false;
	  this.showLevel   = options.showLevel === undefined ? true : options.showLevel;
	  this.label       = options.label       || null;
	  this.depth       = options.depth       || null;

	  if (this.json) {
	    this.stringify = options.stringify || function (obj) {
	      return JSON.stringify(obj, null, 2);
	    };
	  }
	};

	//
	// Inherit from `winston.Transport`.
	//
	util.inherits(Memory, Transport);

	//
	// Expose the name of this Transport on the prototype
	//
	Memory.prototype.name = 'memory';

	//
	// ### function log (level, msg, [meta], callback)
	// #### @level {string} Level at which to log the message.
	// #### @msg {string} Message to log
	// #### @meta {Object} **Optional** Additional metadata to attach
	// #### @callback {function} Continuation to respond to when complete.
	// Core logging method exposed to Winston. Metadata is optional.
	//
	Memory.prototype.log = function (level, msg, meta, callback) {
	  if (this.silent) {
	    return callback(null, true);
	  }

	  var self = this,
	      output;

	  output = common.log({
	    colorize:    this.colorize,
	    json:        this.json,
	    level:       level,
	    message:     msg,
	    meta:        meta,
	    stringify:   this.stringify,
	    timestamp:   this.timestamp,
	    prettyPrint: this.prettyPrint,
	    raw:         this.raw,
	    label:       this.label,
	    depth:       this.depth,
	    formatter:   this.formatter,
	    humanReadableUnhandledException: this.humanReadableUnhandledException
	  });

	  if (level === 'error' || level === 'debug') {
	    this.errorOutput.push(output);
	  } else {
	    this.writeOutput.push(output);
	  }

	  self.emit('logged');
	  callback(null, true);
	};

	Memory.prototype.clearLogs = function () {
	  this.errorOutput = [];
	  this.writeOutput = [];
	};


/***/ },
/* 105 */
/***/ function(module, exports, __webpack_require__) {

	/*
	 * exception.js: Utility methods for gathing information about uncaughtExceptions.
	 *
	 * (C) 2010 Charlie Robbins
	 * MIT LICENCE
	 *
	 */

	var os = __webpack_require__(4),
	    stackTrace = __webpack_require__(106);

	var exception = exports;

	exception.getAllInfo = function (err) {
	  return {
	    date:    new Date().toString(),
	    process: exception.getProcessInfo(),
	    os:      exception.getOsInfo(),
	    trace:   exception.getTrace(err),
	    stack:   err.stack && err.stack.split('\n')
	  };
	};

	exception.getProcessInfo = function () {
	  return {
	    pid:         process.pid,
	    uid:         process.getuid ? process.getuid() : null,
	    gid:         process.getgid ? process.getgid() : null,
	    cwd:         process.cwd(),
	    execPath:    process.execPath,
	    version:     process.version,
	    argv:        process.argv,
	    memoryUsage: process.memoryUsage()
	  };
	};

	exception.getOsInfo = function () {
	  return {
	    loadavg: os.loadavg(),
	    uptime:  os.uptime()
	  };
	};

	exception.getTrace = function (err) {
	  var trace = err ? stackTrace.parse(err) : stackTrace.get();
	  return trace.map(function (site) {
	    return {
	      column:   site.getColumnNumber(),
	      file:     site.getFileName(),
	      function: site.getFunctionName(),
	      line:     site.getLineNumber(),
	      method:   site.getMethodName(),
	      native:   site.isNative(),
	    }
	  });
	};


/***/ },
/* 106 */
/***/ function(module, exports) {

	exports.get = function(belowFn) {
	  var oldLimit = Error.stackTraceLimit;
	  Error.stackTraceLimit = Infinity;

	  var dummyObject = {};

	  var v8Handler = Error.prepareStackTrace;
	  Error.prepareStackTrace = function(dummyObject, v8StackTrace) {
	    return v8StackTrace;
	  };
	  Error.captureStackTrace(dummyObject, belowFn || exports.get);

	  var v8StackTrace = dummyObject.stack;
	  Error.prepareStackTrace = v8Handler;
	  Error.stackTraceLimit = oldLimit;

	  return v8StackTrace;
	};

	exports.parse = function(err) {
	  if (!err.stack) {
	    return [];
	  }

	  var self = this;
	  var lines = err.stack.split('\n').slice(1);

	  return lines
	    .map(function(line) {
	      if (line.match(/^\s*[-]{4,}$/)) {
	        return self._createParsedCallSite({
	          fileName: line,
	          lineNumber: null,
	          functionName: null,
	          typeName: null,
	          methodName: null,
	          columnNumber: null,
	          'native': null,
	        });
	      }

	      var lineMatch = line.match(/at (?:(.+)\s+\()?(?:(.+?):(\d+)(?::(\d+))?|([^)]+))\)?/);
	      if (!lineMatch) {
	        return;
	      }

	      var object = null;
	      var method = null;
	      var functionName = null;
	      var typeName = null;
	      var methodName = null;
	      var isNative = (lineMatch[5] === 'native');

	      if (lineMatch[1]) {
	        functionName = lineMatch[1];
	        var methodStart = functionName.lastIndexOf('.');
	        if (functionName[methodStart-1] == '.')
	          methodStart--;
	        if (methodStart > 0) {
	          object = functionName.substr(0, methodStart);
	          method = functionName.substr(methodStart + 1);
	          var objectEnd = object.indexOf('.Module');
	          if (objectEnd > 0) {
	            functionName = functionName.substr(objectEnd + 1);
	            object = object.substr(0, objectEnd);
	          }
	        }
	        typeName = null;
	      }

	      if (method) {
	        typeName = object;
	        methodName = method;
	      }

	      if (method === '<anonymous>') {
	        methodName = null;
	        functionName = null;
	      }

	      var properties = {
	        fileName: lineMatch[2] || null,
	        lineNumber: parseInt(lineMatch[3], 10) || null,
	        functionName: functionName,
	        typeName: typeName,
	        methodName: methodName,
	        columnNumber: parseInt(lineMatch[4], 10) || null,
	        'native': isNative,
	      };

	      return self._createParsedCallSite(properties);
	    })
	    .filter(function(callSite) {
	      return !!callSite;
	    });
	};

	function CallSite(properties) {
	  for (var property in properties) {
	    this[property] = properties[property];
	  }
	}

	var strProperties = [
	  'this',
	  'typeName',
	  'functionName',
	  'methodName',
	  'fileName',
	  'lineNumber',
	  'columnNumber',
	  'function',
	  'evalOrigin'
	];
	var boolProperties = [
	  'topLevel',
	  'eval',
	  'native',
	  'constructor'
	];
	strProperties.forEach(function (property) {
	  CallSite.prototype[property] = null;
	  CallSite.prototype['get' + property[0].toUpperCase() + property.substr(1)] = function () {
	    return this[property];
	  }
	});
	boolProperties.forEach(function (property) {
	  CallSite.prototype[property] = false;
	  CallSite.prototype['is' + property[0].toUpperCase() + property.substr(1)] = function () {
	    return this[property];
	  }
	});

	exports._createParsedCallSite = function(properties) {
	  return new CallSite(properties);
	};


/***/ },
/* 107 */
/***/ function(module, exports, __webpack_require__) {

	/*
	 * container.js: Inversion of control container for winston logger instances
	 *
	 * (C) 2010 Charlie Robbins
	 * MIT LICENCE
	 *
	 */

	var common = __webpack_require__(77),
	    winston = __webpack_require__(72),
	    extend = __webpack_require__(12)._extend;

	//
	// ### function Container (options)
	// #### @options {Object} Default pass-thru options for Loggers
	// Constructor function for the Container object responsible for managing
	// a set of `winston.Logger` instances based on string ids.
	//
	var Container = exports.Container = function (options) {
	  this.loggers = {};
	  this.options = options || {};
	  this.default = {
	    transports: [
	      new winston.transports.Console({
	        level: 'silly',
	        colorize: false
	      })
	    ]
	  }
	};

	//
	// ### function get / add (id, options)
	// #### @id {string} Id of the Logger to get
	// #### @options {Object} **Optional** Options for the Logger instance
	// Retreives a `winston.Logger` instance for the specified `id`. If
	// an instance does not exist, one is created.
	//
	Container.prototype.get = Container.prototype.add = function (id, options) {
	  var self = this,
	      existing;

	  if (!this.loggers[id]) {
	    //
	    // Remark: Simple shallow clone for configuration options in case we pass in
	    // instantiated protoypal objects
	    //
	    options = extend({}, options || this.options || this.default);
	    existing = options.transports || this.options.transports;
	    //
	    // Remark: Make sure if we have an array of transports we slice it to make copies
	    // of those references.
	    //
	    options.transports = existing ? existing.slice() : [];

	    if (options.transports.length === 0 && (!options || !options['console'])) {
	      options.transports.push(this.default.transports[0]);
	    }

	    Object.keys(options).forEach(function (key) {
	      if (key === 'transports') {
	        return;
	      }

	      var name = common.capitalize(key);

	      if (!winston.transports[name]) {
	        throw new Error('Cannot add unknown transport: ' + name);
	      }

	      var namedOptions = options[key];
	      namedOptions.id = id;
	      options.transports.push(new (winston.transports[name])(namedOptions));
	    });

	    options.id = id;
	    this.loggers[id] = new winston.Logger(options);

	    this.loggers[id].on('close', function () {
	        self._delete(id);
	    });
	  }

	  return this.loggers[id];
	};

	//
	// ### function close (id)
	// #### @id {string} **Optional** Id of the Logger instance to find
	// Returns a boolean value indicating if this instance
	// has a logger with the specified `id`.
	//
	Container.prototype.has = function (id) {
	  return !!this.loggers[id];
	};

	//
	// ### function close (id)
	// #### @id {string} **Optional** Id of the Logger instance to close
	// Closes a `Logger` instance with the specified `id` if it exists.
	// If no `id` is supplied then all Loggers are closed.
	//
	Container.prototype.close = function (id) {
	  var self = this;

	  function _close (id) {
	    if (!self.loggers[id]) {
	      return;
	    }

	    self.loggers[id].close();
	    self._delete(id);
	  }

	  return id ? _close(id) : Object.keys(this.loggers).forEach(function (id) {
	    _close(id);
	  });
	};

	//
	// ### @private function _delete (id)
	// #### @id {string} Id of the Logger instance to delete from container
	// Deletes a `Logger` instance with the specified `id`.
	//
	Container.prototype._delete = function (id) {
	    delete this.loggers[id];
	}



/***/ },
/* 108 */
/***/ function(module, exports, __webpack_require__) {

	/*
	 * logger.js: Core logger object used by winston.
	 *
	 * (C) 2010 Charlie Robbins
	 * MIT LICENCE
	 *
	 */

	var events = __webpack_require__(76),
	    util = __webpack_require__(12),
	    async = __webpack_require__(99),
	    config = __webpack_require__(79),
	    common = __webpack_require__(77),
	    exception = __webpack_require__(105),
	    Stream = __webpack_require__(8).Stream;

	var formatRegExp = /%[sdj%]/g;

	//
	// ### function Logger (options)
	// #### @options {Object} Options for this instance.
	// Constructor function for the Logger object responsible
	// for persisting log messages and metadata to one or more transports.
	//
	var Logger = exports.Logger = function (options) {
	  events.EventEmitter.call(this);
	  this.configure(options);
	};

	//
	// Inherit from `events.EventEmitter`.
	//
	util.inherits(Logger, events.EventEmitter);

	//
	// ### function configure (options)
	// This will wholesale reconfigure this instance by:
	// 1. Resetting all transports. Older transports will be removed implicitly.
	// 2. Set all other options including levels, colors, rewriters, filters,
	//    exceptionHandlers, etc.
	//
	Logger.prototype.configure = function (options) {
	  var self = this;

	  //
	  // If we have already been setup with transports
	  // then remove them before proceeding.
	  //
	  if (Array.isArray(this._names) && this._names.length) {
	    this.clear();
	  }

	  options = options || {};
	  this.transports = {};
	  this._names     = [];

	  if (options.transports) {
	    options.transports.forEach(function (transport) {
	      self.add(transport, null, true);
	    });
	  }

	  //
	  // Set Levels and default logging level
	  //
	  this.padLevels = options.padLevels || false;
	  this.setLevels(options.levels);
	  if (options.colors) {
	    config.addColors(options.colors);
	  }

	  //
	  // Hoist other options onto this instance.
	  //
	  this.id          = options.id || null;
	  this.level       = options.level || 'info';
	  this.emitErrs    = options.emitErrs || false;
	  this.stripColors = options.stripColors || false;
	  this.exitOnError = typeof options.exitOnError !== 'undefined'
	    ? options.exitOnError
	    : true;

	  //
	  // Setup internal state as empty Objects even though it is
	  // defined lazily later to ensure a strong existential API contract.
	  //
	  this.exceptionHandlers = {};
	  this.profilers         = {};

	  ['rewriters', 'filters'].forEach(function (kind) {
	    self[kind] = Array.isArray(options[kind])
	      ? options[kind]
	      : [];
	  });

	  if (options.exceptionHandlers) {
	    this.handleExceptions(options.exceptionHandlers);
	  }
	};

	//
	// ### function log (level, msg, [meta], callback)
	// #### @level {string} Level at which to log the message.
	// #### @msg {string} Message to log
	// #### @meta {Object} **Optional** Additional metadata to attach
	// #### @callback {function} Continuation to respond to when complete.
	// Core logging method exposed to Winston. Metadata is optional.
	//
	Logger.prototype.log = function (level) {
	  var args = Array.prototype.slice.call(arguments, 1),
	      self = this,
	      transports;

	  while (args[args.length - 1] === null) {
	    args.pop();
	  }

	  //
	  // Determining what is `meta` and what are arguments for string interpolation
	  // turns out to be VERY tricky. e.g. in the cases like this:
	  //
	  //    logger.info('No interpolation symbols', 'ok', 'why', { meta: 'is-this' });
	  //
	  var callback  = typeof args[args.length - 1] === 'function'
	    ? args.pop()
	    : null;

	  //
	  // Handle errors appropriately.
	  //
	  function onError(err) {
	    if (callback) {
	      callback(err);
	    }
	    else if (self.emitErrs) {
	      self.emit('error', err);
	    }
	  }

	  if (this._names.length === 0) {
	    return onError(new Error('Cannot log with no transports.'));
	  }
	  else if (typeof self.levels[level] === 'undefined') {
	    return onError(new Error('Unknown log level: ' + level));
	  }

	  //
	  // If there are no transports that match the level
	  // then be eager and return. This could potentially be calculated
	  // during `setLevels` for more performance gains.
	  //
	  var targets = this._names.filter(function (name) {
	    var transport = self.transports[name];
	    return (transport.level && self.levels[transport.level] >= self.levels[level])
	      || (!transport.level && self.levels[self.level] >= self.levels[level]);
	  });

	  if (!targets.length) {
	    if (callback) { callback(); }
	    return;
	  }

	  //
	  // Determining what is `meta` and what are arguments for string interpolation
	  // turns out to be VERY tricky. e.g. in the cases like this:
	  //
	  //    logger.info('No interpolation symbols', 'ok', 'why', { meta: 'is-this' });
	  //
	  var msg, meta = {}, validMeta = false;
	  var hasFormat = args && args[0] && args[0].match && args[0].match(formatRegExp) !== null;
	  var tokens = (hasFormat) ? args[0].match(formatRegExp) : [];
	  var ptokens = tokens.filter(function(t) { return t === '%%' });
	  if (((args.length - 1) - (tokens.length - ptokens.length)) > 0 || args.length === 1) {
	    // last arg is meta
	    meta = args[args.length - 1] || args;
	    var metaType = Object.prototype.toString.call(meta);
	    validMeta = metaType === '[object Object]' ||
	      metaType === '[object Error]' || metaType === '[object Array]';
	    meta = validMeta ? args.pop() : {};
	  }
	  msg = util.format.apply(null, args);

	  //
	  // Respond to the callback.
	  //
	  function finish(err) {
	    if (callback) {
	      if (err) return callback(err);
	      callback(null, level, msg, meta);
	    }

	    callback = null;
	    if (!err) {
	      self.emit('logged', level, msg, meta);
	    }
	  }

	  // If we should pad for levels, do so
	  if (this.padLevels) {
	    msg = new Array(this.levelLength - level.length + 1).join(' ') + msg;
	  }

	  this.rewriters.forEach(function (rewriter) {
	    meta = rewriter(level, msg, meta, self);
	  });

	  this.filters.forEach(function(filter) {
	    var filtered = filter(level, msg, meta, self);
	    if (typeof filtered === 'string')
	      msg = filtered;
	    else {
	      msg = filtered.msg;
	      meta = filtered.meta;
	    }
	  });

	  //
	  // For consideration of terminal 'color" programs like colors.js,
	  // which can add ANSI escape color codes to strings, we destyle the
	  // ANSI color escape codes when `this.stripColors` is set.
	  //
	  // see: http://en.wikipedia.org/wiki/ANSI_escape_code
	  //
	  if (this.stripColors) {
	    var code = /\u001b\[(\d+(;\d+)*)?m/g;
	    msg = ('' + msg).replace(code, '');
	  }

	  //
	  // Log for each transport and emit 'logging' event
	  //
	  function transportLog(name, next) {
	    var transport = self.transports[name];
	    transport.log(level, msg, meta, function (err) {
	      if (err) {
	        err.transport = transport;
	        finish(err);
	        return next();
	      }

	      self.emit('logging', transport, level, msg, meta);
	      next();
	    });
	  }

	  async.forEach(targets, transportLog, finish);
	  return this;
	};

	//
	// ### function query (options, callback)
	// #### @options {Object} Query options for this instance.
	// #### @callback {function} Continuation to respond to when complete.
	// Queries the all transports for this instance with the specified `options`.
	// This will aggregate each transport's results into one object containing
	// a property per transport.
	//
	Logger.prototype.query = function (options, callback) {
	  if (typeof options === 'function') {
	    callback = options;
	    options = {};
	  }

	  var self = this,
	      options = options || {},
	      results = {},
	      query = common.clone(options.query) || {},
	      transports;

	  //
	  // Helper function to query a single transport
	  //
	  function queryTransport(transport, next) {
	    if (options.query) {
	      options.query = transport.formatQuery(query);
	    }

	    transport.query(options, function (err, results) {
	      if (err) {
	        return next(err);
	      }

	      next(null, transport.formatResults(results, options.format));
	    });
	  }

	  //
	  // Helper function to accumulate the results from
	  // `queryTransport` into the `results`.
	  //
	  function addResults(transport, next) {
	    queryTransport(transport, function (err, result) {
	      //
	      // queryTransport could potentially invoke the callback
	      // multiple times since Transport code can be unpredictable.
	      //
	      if (next) {
	        result = err || result;
	        if (result) {
	          results[transport.name] = result;
	        }

	        next();
	      }

	      next = null;
	    });
	  }

	  //
	  // If an explicit transport is being queried then
	  // respond with the results from only that transport
	  //
	  if (options.transport) {
	    options.transport = options.transport.toLowerCase();
	    return queryTransport(this.transports[options.transport], callback);
	  }

	  //
	  // Create a list of all transports for this instance.
	  //
	  transports = this._names.map(function (name) {
	    return self.transports[name];
	  }).filter(function (transport) {
	    return !!transport.query;
	  });

	  //
	  // Iterate over the transports in parallel setting the
	  // appropriate key in the `results`
	  //
	  async.forEach(transports, addResults, function () {
	    callback(null, results);
	  });
	};

	//
	// ### function stream (options)
	// #### @options {Object} Stream options for this instance.
	// Returns a log stream for all transports. Options object is optional.
	//
	Logger.prototype.stream = function (options) {
	  var self = this,
	      options = options || {},
	      out = new Stream,
	      streams = [],
	      transports;

	  if (options.transport) {
	    var transport = this.transports[options.transport];
	    delete options.transport;
	    if (transport && transport.stream) {
	      return transport.stream(options);
	    }
	  }

	  out._streams = streams;
	  out.destroy = function () {
	    var i = streams.length;
	    while (i--) streams[i].destroy();
	  };

	  //
	  // Create a list of all transports for this instance.
	  //
	  transports = this._names.map(function (name) {
	    return self.transports[name];
	  }).filter(function (transport) {
	    return !!transport.stream;
	  });

	  transports.forEach(function (transport) {
	    var stream = transport.stream(options);
	    if (!stream) return;

	    streams.push(stream);

	    stream.on('log', function (log) {
	      log.transport = log.transport || [];
	      log.transport.push(transport.name);
	      out.emit('log', log);
	    });

	    stream.on('error', function (err) {
	      err.transport = err.transport || [];
	      err.transport.push(transport.name);
	      out.emit('error', err);
	    });
	  });

	  return out;
	};

	//
	// ### function close ()
	// Cleans up resources (streams, event listeners) for all
	// transports associated with this instance (if necessary).
	//
	Logger.prototype.close = function () {
	  var self = this;

	  this._names.forEach(function (name) {
	    var transport = self.transports[name];
	    if (transport && transport.close) {
	      transport.close();
	    }
	  });

	  this.emit('close');
	};

	//
	// ### function handleExceptions ([tr0, tr1...] || tr0, tr1, ...)
	// Handles `uncaughtException` events for the current process by
	// ADDING any handlers passed in.
	//
	Logger.prototype.handleExceptions = function () {
	  var args = Array.prototype.slice.call(arguments),
	      handlers = [],
	      self = this;

	  args.forEach(function (a) {
	    if (Array.isArray(a)) {
	      handlers = handlers.concat(a);
	    }
	    else {
	      handlers.push(a);
	    }
	  });

	  this.exceptionHandlers = this.exceptionHandlers || {};
	  handlers.forEach(function (handler) {
	    self.exceptionHandlers[handler.name] = handler;
	  });

	  this._hnames = Object.keys(self.exceptionHandlers);

	  if (!this.catchExceptions) {
	    this.catchExceptions = this._uncaughtException.bind(this);
	    process.on('uncaughtException', this.catchExceptions);
	  }
	};

	//
	// ### function unhandleExceptions ()
	// Removes any handlers to `uncaughtException` events
	// for the current process
	//
	Logger.prototype.unhandleExceptions = function () {
	  var self = this;

	  if (this.catchExceptions) {
	    Object.keys(this.exceptionHandlers).forEach(function (name) {
	      var handler = self.exceptionHandlers[name];
	      if (handler.close) {
	        handler.close();
	      }
	    });

	    this.exceptionHandlers = {};
	    Object.keys(this.transports).forEach(function (name) {
	      var transport = self.transports[name];
	      if (transport.handleExceptions) {
	        transport.handleExceptions = false;
	      }
	    })

	    process.removeListener('uncaughtException', this.catchExceptions);
	    this.catchExceptions = false;
	  }
	};

	//
	// ### function add (transport, [options])
	// #### @transport {Transport} Prototype of the Transport object to add.
	// #### @options {Object} **Optional** Options for the Transport to add.
	// #### @instance {Boolean} **Optional** Value indicating if `transport` is already instantiated.
	// Adds a transport of the specified type to this instance.
	//
	Logger.prototype.add = function (transport, options, created) {
	  var instance = created ? transport : (new (transport)(options));

	  if (!instance.name && !instance.log) {
	    throw new Error('Unknown transport with no log() method');
	  }
	  else if (this.transports[instance.name]) {
	    throw new Error('Transport already attached: ' + instance.name + ", assign a different name");
	  }

	  this.transports[instance.name] = instance;
	  this._names = Object.keys(this.transports);

	  //
	  // Listen for the `error` event on the new Transport
	  //
	  instance._onError = this._onError.bind(this, instance)
	  if (!created) {
	    instance.on('error', instance._onError);
	  }

	  //
	  // If this transport has `handleExceptions` set to `true`
	  // and we are not already handling exceptions, do so.
	  //
	  if (instance.handleExceptions && !this.catchExceptions) {
	    this.handleExceptions();
	  }

	  return this;
	};

	//
	// ### function clear ()
	// Remove all transports from this instance
	//
	Logger.prototype.clear = function () {
	  Object.keys(this.transports).forEach(function (name) {
	    this.remove({ name: name });
	  }, this);
	};

	//
	// ### function remove (transport)
	// #### @transport {Transport|String} Transport or Name to remove.
	// Removes a transport of the specified type from this instance.
	//
	Logger.prototype.remove = function (transport) {
	  var name = typeof transport !== 'string'
	    ? transport.name || transport.prototype.name
	    : transport;

	  if (!this.transports[name]) {
	    throw new Error('Transport ' + name + ' not attached to this instance');
	  }

	  var instance = this.transports[name];
	  delete this.transports[name];
	  this._names = Object.keys(this.transports);

	  if (instance.close) {
	    instance.close();
	  }

	  if (instance._onError) {
	    instance.removeListener('error', instance._onError);
	  }
	  return this;
	};

	//
	// ### function startTimer ()
	// Returns an object corresponding to a specific timing. When done
	// is called the timer will finish and log the duration. e.g.:
	//
	//    timer = winston.startTimer()
	//    setTimeout(function(){
	//      timer.done("Logging message");
	//    }, 1000);
	//
	Logger.prototype.startTimer = function () {
	  return new ProfileHandler(this);
	};

	//
	// ### function profile (id, [msg, meta, callback])
	// #### @id {string} Unique id of the profiler
	// #### @msg {string} **Optional** Message to log
	// #### @meta {Object} **Optional** Additional metadata to attach
	// #### @callback {function} **Optional** Continuation to respond to when complete.
	// Tracks the time inbetween subsequent calls to this method
	// with the same `id` parameter. The second call to this method
	// will log the difference in milliseconds along with the message.
	//
	Logger.prototype.profile = function (id) {
	  var now = Date.now(), then, args,
	      msg, meta, callback;

	  if (this.profilers[id]) {
	    then = this.profilers[id];
	    delete this.profilers[id];

	    // Support variable arguments: msg, meta, callback
	    args     = Array.prototype.slice.call(arguments);
	    callback = typeof args[args.length - 1] === 'function' ? args.pop() : null;
	    meta     = typeof args[args.length - 1] === 'object' ? args.pop() : {};
	    msg      = args.length === 2 ? args[1] : id;

	    // Set the duration property of the metadata
	    meta.durationMs = now - then;
	    return this.info(msg, meta, callback);
	  }
	  else {
	    this.profilers[id] = now;
	  }

	  return this;
	};

	//
	// ### function setLevels (target)
	// #### @target {Object} Target levels to use on this instance
	// Sets the `target` levels specified on this instance.
	//
	Logger.prototype.setLevels = function (target) {
	  return common.setLevels(this, this.levels, target);
	};

	//
	// ### function cli ()
	// Configures this instance to have the default
	// settings for command-line interfaces: no timestamp,
	// colors enabled, padded output, and additional levels.
	//
	Logger.prototype.cli = function () {
	  this.padLevels = true;
	  this.setLevels(config.cli.levels);
	  config.addColors(config.cli.colors);

	  if (this.transports.console) {
	    this.transports.console.colorize = this.transports.console.colorize || true;
	    this.transports.console.timestamp = this.transports.console.timestamp || false;
	  }

	  return this;
	};

	//
	// ### @private function _uncaughtException (err)
	// #### @err {Error} Error to handle
	// Logs all relevant information around the `err` and
	// exits the current process.
	//
	Logger.prototype._uncaughtException = function (err) {
	  var self = this,
	      responded = false,
	      info = exception.getAllInfo(err),
	      handlers = this._getExceptionHandlers(),
	      timeout,
	      doExit;

	  //
	  // Calculate if we should exit on this error
	  //
	  doExit = typeof this.exitOnError === 'function'
	    ? this.exitOnError(err)
	    : this.exitOnError;

	  function logAndWait(transport, next) {
	    transport.logException('uncaughtException: ' + (err.message || err), info, next, err);
	  }

	  function gracefulExit() {
	    if (doExit && !responded) {
	      //
	      // Remark: Currently ignoring any exceptions from transports
	      //         when catching uncaught exceptions.
	      //
	      clearTimeout(timeout);
	      responded = true;
	      process.exit(1);
	    }
	  }

	  if (!handlers || handlers.length === 0) {
	    return gracefulExit();
	  }

	  //
	  // Log to all transports and allow the operation to take
	  // only up to `3000ms`.
	  //
	  async.forEach(handlers, logAndWait, gracefulExit);
	  if (doExit) {
	    timeout = setTimeout(gracefulExit, 3000);
	  }
	};

	//
	// ### @private function _getExceptionHandlers ()
	// Returns the list of transports and exceptionHandlers
	// for this instance.
	//
	Logger.prototype._getExceptionHandlers = function () {
	  var self = this;

	  return this._hnames.map(function (name) {
	    return self.exceptionHandlers[name];
	  }).concat(this._names.map(function (name) {
	    return self.transports[name].handleExceptions && self.transports[name];
	  })).filter(Boolean);
	};

	//
	// ### @private function _onError (transport, err)
	// #### @transport {Object} Transport on which the error occured
	// #### @err {Error} Error that occurred on the transport
	// Bubbles the error, `err`, that occured on the specified `transport`
	// up from this instance if `emitErrs` has been set.
	//
	Logger.prototype._onError = function (transport, err) {
	  if (this.emitErrs) {
	    this.emit('error', err, transport);
	  }
	};

	//
	// ### @private ProfileHandler
	// Constructor function for the ProfileHandler instance used by
	// `Logger.prototype.startTimer`. When done is called the timer
	// will finish and log the duration.
	//
	function ProfileHandler(logger) {
	  this.logger = logger;
	  this.start = Date.now();
	}

	//
	// ### function done (msg)
	// Ends the current timer (i.e. ProfileHandler) instance and
	// logs the `msg` along with the duration since creation.
	//
	ProfileHandler.prototype.done = function (msg) {
	  var args     = Array.prototype.slice.call(arguments),
	      callback = typeof args[args.length - 1] === 'function' ? args.pop() : null,
	      meta     = typeof args[args.length - 1] === 'object' ? args.pop() : {};

	  meta.duration = (Date.now()) - this.start + 'ms';
	  return this.logger.info(msg, meta, callback);
	};


/***/ },
/* 109 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

	var _fonts = __webpack_require__(110);

	var _fonts2 = _interopRequireDefault(_fonts);

	var _underscore = __webpack_require__(111);

	var _underscore2 = _interopRequireDefault(_underscore);

	var _EN_US = __webpack_require__(112);

	var _EN_US2 = _interopRequireDefault(_EN_US);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	var merge = __webpack_require__(113);


	if (typeof Object.assign != 'function') {
	    Object.assign = function (target) {
	        'use strict';

	        if (target == null) {
	            throw new TypeError('Cannot convert undefined or null to object');
	        }

	        target = Object(target);
	        for (var index = 1; index < arguments.length; index++) {
	            var source = arguments[index];
	            if (source != null) {
	                for (var key in source) {
	                    if (Object.prototype.hasOwnProperty.call(source, key)) {
	                        target[key] = source[key];
	                    }
	                }
	            }
	        }
	        return target;
	    };
	}

	var ditto = {
	    version: '{{VERSION}}',
	    ToolbarItemPosition: { RIGHT: "right", LEFT: "left" },
	    merge: merge,
	    locales: {
	        EN_US: _EN_US2.default
	    }
	};
	ditto.locale = ditto.locales.EN_US;

	ditto.version_less_than = function (versionA, versionB) {
	    var aParts = (versionA || "0.0.0").split('.').map(function (part) {
	        return parseInt(part, 10);
	    }),
	        bParts = versionB.split('.').map(function (part) {
	        return parseInt(part, 10);
	    });
	    for (var i = 0; i < aParts.length - 1; i++) {
	        if (aParts[i] < bParts[i]) {
	            return true;
	        } else if (aParts[i] > bParts[i]) {
	            return false;
	        }
	    }
	    return aParts[aParts.length - 1] < bParts[aParts.length - 1];
	};

	ditto.isMac = typeof navigator !== 'undefined' && navigator.platform.toLowerCase().indexOf('mac') > -1;

	ditto.defaultReport = {
	    title: "New Report",
	    "default_format": "html",
	    version: '{{VERSION}}',
	    type: 'hierarchical',
	    "page": {
	        units: "inches",
	        paper_size: {
	            id: "letter",
	            inches: ["8.5", "11"],
	            mm: ["216", "279"]
	        },
	        margins: {
	            "top": 0.5,
	            "left": 0.5,
	            "right": 0.5,
	            "bottom": 0.5
	        }
	    },
	    filters: [],
	    inputs: [],
	    header: {
	        height: 1,
	        elements: []
	    },
	    body: {
	        data_source: null,
	        show_detail: true,
	        height: 1.5,
	        elements: [],
	        sublevels: [],
	        column_count: 1,
	        pivot_enabled: false,
	        pivot_expression: "",
	        pivot_column_sort_by: "",
	        pivot_column_bucket_type: "",
	        pivot_value_aggregate: ""
	    },
	    footer: {
	        height: 1,
	        elements: []
	    },
	    page_header: {
	        visible: false,
	        elements: [],
	        height: 1
	    },
	    page_footer: {
	        visible: false,
	        elements: [],
	        height: 1
	    }
	};

	ditto.imageToDataUri = function (imgUrl, format) {
	    var htmlDocument = ditto.window.document;
	    var tmpImage = new Image();
	    tmpImage.src = imgUrl;
	    var naturalWidth = tmpImage.width;
	    var naturalHeight = tmpImage.height;
	    var canvas = htmlDocument.createElement("canvas");
	    htmlDocument.body.appendChild(canvas);
	    canvas.width = naturalWidth;
	    canvas.height = naturalHeight;
	    var context = canvas.getContext("2d");
	    context.fillStyle = "rgb(255,255,255)";
	    context.fillRect(0, 0, naturalWidth, naturalHeight);
	    context.drawImage(tmpImage, 0, 0, naturalWidth, naturalHeight);
	    var imgData = canvas.toDataURL(format || 'image/jpeg');
	    htmlDocument.body.removeChild(canvas);
	    return imgData;
	};

	/** Deep-clone an object, while converting any snake_cased keys to camelCase */
	ditto.camelCaseKeys = function (obj) {
	    if (obj === null) return null;
	    var clone = {};
	    Object.keys(obj).forEach(function (key) {
	        var camel = key.replace(/(_\w)/g, function (m) {
	            return m[1].toUpperCase();
	        });
	        clone[camel] = _typeof(obj[key]) === 'object' ? ditto.camelCaseKeys(obj[key]) : obj[key];
	    });
	    return clone;
	};

	ditto.ns = function (str, root) {
	    var parts = str.split('.');
	    var parent = root || (typeof global !== 'undefined' ? global : window),
	        next;
	    while (next = parts.shift()) {
	        if (!parent[next]) {
	            parent[next] = {};
	        }
	        parent = parent[next];
	    }
	};

	ditto.nsExists = function (nsStr, root) {
	    var parts = nsStr.split('.');
	    var parent = root || (typeof global !== 'undefined' ? global : window),
	        next;
	    while (next = parts.shift()) {
	        if (typeof parent[next] === 'undefined') {
	            return false;
	        }
	        parent = parent[next];
	    }
	    return true;
	};

	ditto.svgToDataUri = function (svgDomEl, widthPx, heightPx, format) {
	    // Select the first svg element
	    var htmlDocument = ditto.window.document;
	    var serializer = new XMLSerializer(),
	        img = new Image(),
	        svgStr = serializer.serializeToString(svgDomEl);
	    if (!widthPx || !heightPx) {
	        widthPx = $(svgDomEl).width();
	        heightPx = $(svgDomEl).height();
	    }
	    // Re-render onto canvas
	    img.src = 'data:image/svg+xml;base64,' + window.btoa(svgStr);
	    var canvas = htmlDocument.createElement("canvas");
	    $(canvas).css('display', 'none');
	    htmlDocument.body.appendChild(canvas);
	    canvas.width = widthPx;
	    canvas.height = heightPx;
	    var context = canvas.getContext("2d");
	    context.fillStyle = "rgb(255,255,255)";
	    context.fillRect(0, 0, widthPx, heightPx);
	    context.fillStyle = "rgb(0,0,0)";
	    context.drawSvg(svgStr, 0, 0, widthPx, heightPx);
	    // context.drawImage(img, 0, 0, widthPx, heightPx);
	    var dataUri = canvas.toDataURL(format === 'jpg' ? 'image/jpeg' : 'image/png');
	    $(canvas).remove();
	    return dataUri;
	};

	ditto.firstDefined = function () {
	    for (var i = 0; i < arguments.length; i++) {
	        if (typeof arguments[i] !== 'undefined') {
	            return arguments[i];
	        }
	    }
	};

	var loadedFonts = {};
	var fontInfo = _underscore2.default.indexBy(_fonts2.default, function (font) {
	    return font.name.trim().toLowerCase();
	});

	var addStylesheet = function addStylesheet(url) {
	    var htmlDocument = ditto.window.document;
	    var link = htmlDocument.createElement('link');
	    link.type = 'text/css';
	    link.rel = 'stylesheet';
	    link.href = url;
	    htmlDocument.head.appendChild(link);
	};

	/** Fetch the named webfont if possible */
	ditto.requireWebFont = function (fontName) {
	    var lower = fontName.trim().toLowerCase();
	    if (loadedFonts[lower]) return;
	    var info = fontInfo[lower];
	    if (!info) return;
	    var urlName = fontName.replace(/\s/g, '+');
	    var stylesheetUrl = 'https://fonts.googleapis.com/css?family=' + urlName + ':400,400i,700,700i&amp;subset=latin-ext';
	    addStylesheet(stylesheetUrl);
	    loadedFonts[lower] = true;
	};

	ditto.setLocale = function (localeObj) {
	    // TODO ship built-in locales and allow selection/loading via string code e.g. EN_GB
	    if ((typeof localeObj === 'undefined' ? 'undefined' : _typeof(localeObj)) === 'object') {
	        // TODO sanity check locale obj
	        ditto.locale = localeObj;
	    } else {
	        console.error('setLocale requires locale object as argument');
	    }
	};

	ditto.translate = function (s, data) {
	    var localized = void 0;
	    if (ditto.locale.translations) {
	        localized = ditto.locale.translations[s];
	    }
	    if (!localized) {
	        console.warn('Missing translation for:', s);
	        return '--';
	    }
	    return (localized || s).replace(/\{(\w*)\}/gi, function (match, g1) {
	        return data[g1] || '';
	    });
	};

	module.exports = ditto;

/***/ },
/* 110 */
/***/ function(module, exports) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

	var fonts = ['Asap', 'Fira Sans', 'Fira Sans Condensed', 'Roboto', 'Open Sans', 'Lato', 'Roboto Condensed', 'Source Sans Pro', { name: 'Merriweather', fallback: 'serif' }, 'Overpass', 'Raleway', 'Rubik', { name: 'Playfair Display', fallback: 'serif' }, { name: 'Crimson Text', fallback: 'serif' }, 'Muli', 'Titillium Web', 'Cabin', 'Merriweather Sans', 'Exo 2', 'Josefin Sans', { name: 'Roboto Mono', fallback: 'monospace' }, { name: 'Alegreya', fallback: 'serif' }, 'Alegreya Sans', { name: 'Josefin Slab', fallback: 'serif' }, { name: 'Cormorant Garamond', fallback: 'serif' }, 'Proza Libre', 'Overlock'].map(function (el) {
	  return (typeof el === 'undefined' ? 'undefined' : _typeof(el)) === 'object' ? el : {
	    name: el,
	    fallback: 'sans-serif',
	    hasLatinExt: true
	  };
	}).sort(function (a, b) {
	  return a.name.localeCompare(b.name);
	});

	exports.default = fonts;

/***/ },
/* 111 */
/***/ function(module, exports, __webpack_require__) {

	var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;//     Underscore.js 1.8.3
	//     http://underscorejs.org
	//     (c) 2009-2015 Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
	//     Underscore may be freely distributed under the MIT license.

	(function() {

	  // Baseline setup
	  // --------------

	  // Establish the root object, `window` in the browser, or `exports` on the server.
	  var root = this;

	  // Save the previous value of the `_` variable.
	  var previousUnderscore = root._;

	  // Save bytes in the minified (but not gzipped) version:
	  var ArrayProto = Array.prototype, ObjProto = Object.prototype, FuncProto = Function.prototype;

	  // Create quick reference variables for speed access to core prototypes.
	  var
	    push             = ArrayProto.push,
	    slice            = ArrayProto.slice,
	    toString         = ObjProto.toString,
	    hasOwnProperty   = ObjProto.hasOwnProperty;

	  // All **ECMAScript 5** native function implementations that we hope to use
	  // are declared here.
	  var
	    nativeIsArray      = Array.isArray,
	    nativeKeys         = Object.keys,
	    nativeBind         = FuncProto.bind,
	    nativeCreate       = Object.create;

	  // Naked function reference for surrogate-prototype-swapping.
	  var Ctor = function(){};

	  // Create a safe reference to the Underscore object for use below.
	  var _ = function(obj) {
	    if (obj instanceof _) return obj;
	    if (!(this instanceof _)) return new _(obj);
	    this._wrapped = obj;
	  };

	  // Export the Underscore object for **Node.js**, with
	  // backwards-compatibility for the old `require()` API. If we're in
	  // the browser, add `_` as a global object.
	  if (true) {
	    if (typeof module !== 'undefined' && module.exports) {
	      exports = module.exports = _;
	    }
	    exports._ = _;
	  } else {
	    root._ = _;
	  }

	  // Current version.
	  _.VERSION = '1.8.3';

	  // Internal function that returns an efficient (for current engines) version
	  // of the passed-in callback, to be repeatedly applied in other Underscore
	  // functions.
	  var optimizeCb = function(func, context, argCount) {
	    if (context === void 0) return func;
	    switch (argCount == null ? 3 : argCount) {
	      case 1: return function(value) {
	        return func.call(context, value);
	      };
	      case 2: return function(value, other) {
	        return func.call(context, value, other);
	      };
	      case 3: return function(value, index, collection) {
	        return func.call(context, value, index, collection);
	      };
	      case 4: return function(accumulator, value, index, collection) {
	        return func.call(context, accumulator, value, index, collection);
	      };
	    }
	    return function() {
	      return func.apply(context, arguments);
	    };
	  };

	  // A mostly-internal function to generate callbacks that can be applied
	  // to each element in a collection, returning the desired result — either
	  // identity, an arbitrary callback, a property matcher, or a property accessor.
	  var cb = function(value, context, argCount) {
	    if (value == null) return _.identity;
	    if (_.isFunction(value)) return optimizeCb(value, context, argCount);
	    if (_.isObject(value)) return _.matcher(value);
	    return _.property(value);
	  };
	  _.iteratee = function(value, context) {
	    return cb(value, context, Infinity);
	  };

	  // An internal function for creating assigner functions.
	  var createAssigner = function(keysFunc, undefinedOnly) {
	    return function(obj) {
	      var length = arguments.length;
	      if (length < 2 || obj == null) return obj;
	      for (var index = 1; index < length; index++) {
	        var source = arguments[index],
	            keys = keysFunc(source),
	            l = keys.length;
	        for (var i = 0; i < l; i++) {
	          var key = keys[i];
	          if (!undefinedOnly || obj[key] === void 0) obj[key] = source[key];
	        }
	      }
	      return obj;
	    };
	  };

	  // An internal function for creating a new object that inherits from another.
	  var baseCreate = function(prototype) {
	    if (!_.isObject(prototype)) return {};
	    if (nativeCreate) return nativeCreate(prototype);
	    Ctor.prototype = prototype;
	    var result = new Ctor;
	    Ctor.prototype = null;
	    return result;
	  };

	  var property = function(key) {
	    return function(obj) {
	      return obj == null ? void 0 : obj[key];
	    };
	  };

	  // Helper for collection methods to determine whether a collection
	  // should be iterated as an array or as an object
	  // Related: http://people.mozilla.org/~jorendorff/es6-draft.html#sec-tolength
	  // Avoids a very nasty iOS 8 JIT bug on ARM-64. #2094
	  var MAX_ARRAY_INDEX = Math.pow(2, 53) - 1;
	  var getLength = property('length');
	  var isArrayLike = function(collection) {
	    var length = getLength(collection);
	    return typeof length == 'number' && length >= 0 && length <= MAX_ARRAY_INDEX;
	  };

	  // Collection Functions
	  // --------------------

	  // The cornerstone, an `each` implementation, aka `forEach`.
	  // Handles raw objects in addition to array-likes. Treats all
	  // sparse array-likes as if they were dense.
	  _.each = _.forEach = function(obj, iteratee, context) {
	    iteratee = optimizeCb(iteratee, context);
	    var i, length;
	    if (isArrayLike(obj)) {
	      for (i = 0, length = obj.length; i < length; i++) {
	        iteratee(obj[i], i, obj);
	      }
	    } else {
	      var keys = _.keys(obj);
	      for (i = 0, length = keys.length; i < length; i++) {
	        iteratee(obj[keys[i]], keys[i], obj);
	      }
	    }
	    return obj;
	  };

	  // Return the results of applying the iteratee to each element.
	  _.map = _.collect = function(obj, iteratee, context) {
	    iteratee = cb(iteratee, context);
	    var keys = !isArrayLike(obj) && _.keys(obj),
	        length = (keys || obj).length,
	        results = Array(length);
	    for (var index = 0; index < length; index++) {
	      var currentKey = keys ? keys[index] : index;
	      results[index] = iteratee(obj[currentKey], currentKey, obj);
	    }
	    return results;
	  };

	  // Create a reducing function iterating left or right.
	  function createReduce(dir) {
	    // Optimized iterator function as using arguments.length
	    // in the main function will deoptimize the, see #1991.
	    function iterator(obj, iteratee, memo, keys, index, length) {
	      for (; index >= 0 && index < length; index += dir) {
	        var currentKey = keys ? keys[index] : index;
	        memo = iteratee(memo, obj[currentKey], currentKey, obj);
	      }
	      return memo;
	    }

	    return function(obj, iteratee, memo, context) {
	      iteratee = optimizeCb(iteratee, context, 4);
	      var keys = !isArrayLike(obj) && _.keys(obj),
	          length = (keys || obj).length,
	          index = dir > 0 ? 0 : length - 1;
	      // Determine the initial value if none is provided.
	      if (arguments.length < 3) {
	        memo = obj[keys ? keys[index] : index];
	        index += dir;
	      }
	      return iterator(obj, iteratee, memo, keys, index, length);
	    };
	  }

	  // **Reduce** builds up a single result from a list of values, aka `inject`,
	  // or `foldl`.
	  _.reduce = _.foldl = _.inject = createReduce(1);

	  // The right-associative version of reduce, also known as `foldr`.
	  _.reduceRight = _.foldr = createReduce(-1);

	  // Return the first value which passes a truth test. Aliased as `detect`.
	  _.find = _.detect = function(obj, predicate, context) {
	    var key;
	    if (isArrayLike(obj)) {
	      key = _.findIndex(obj, predicate, context);
	    } else {
	      key = _.findKey(obj, predicate, context);
	    }
	    if (key !== void 0 && key !== -1) return obj[key];
	  };

	  // Return all the elements that pass a truth test.
	  // Aliased as `select`.
	  _.filter = _.select = function(obj, predicate, context) {
	    var results = [];
	    predicate = cb(predicate, context);
	    _.each(obj, function(value, index, list) {
	      if (predicate(value, index, list)) results.push(value);
	    });
	    return results;
	  };

	  // Return all the elements for which a truth test fails.
	  _.reject = function(obj, predicate, context) {
	    return _.filter(obj, _.negate(cb(predicate)), context);
	  };

	  // Determine whether all of the elements match a truth test.
	  // Aliased as `all`.
	  _.every = _.all = function(obj, predicate, context) {
	    predicate = cb(predicate, context);
	    var keys = !isArrayLike(obj) && _.keys(obj),
	        length = (keys || obj).length;
	    for (var index = 0; index < length; index++) {
	      var currentKey = keys ? keys[index] : index;
	      if (!predicate(obj[currentKey], currentKey, obj)) return false;
	    }
	    return true;
	  };

	  // Determine if at least one element in the object matches a truth test.
	  // Aliased as `any`.
	  _.some = _.any = function(obj, predicate, context) {
	    predicate = cb(predicate, context);
	    var keys = !isArrayLike(obj) && _.keys(obj),
	        length = (keys || obj).length;
	    for (var index = 0; index < length; index++) {
	      var currentKey = keys ? keys[index] : index;
	      if (predicate(obj[currentKey], currentKey, obj)) return true;
	    }
	    return false;
	  };

	  // Determine if the array or object contains a given item (using `===`).
	  // Aliased as `includes` and `include`.
	  _.contains = _.includes = _.include = function(obj, item, fromIndex, guard) {
	    if (!isArrayLike(obj)) obj = _.values(obj);
	    if (typeof fromIndex != 'number' || guard) fromIndex = 0;
	    return _.indexOf(obj, item, fromIndex) >= 0;
	  };

	  // Invoke a method (with arguments) on every item in a collection.
	  _.invoke = function(obj, method) {
	    var args = slice.call(arguments, 2);
	    var isFunc = _.isFunction(method);
	    return _.map(obj, function(value) {
	      var func = isFunc ? method : value[method];
	      return func == null ? func : func.apply(value, args);
	    });
	  };

	  // Convenience version of a common use case of `map`: fetching a property.
	  _.pluck = function(obj, key) {
	    return _.map(obj, _.property(key));
	  };

	  // Convenience version of a common use case of `filter`: selecting only objects
	  // containing specific `key:value` pairs.
	  _.where = function(obj, attrs) {
	    return _.filter(obj, _.matcher(attrs));
	  };

	  // Convenience version of a common use case of `find`: getting the first object
	  // containing specific `key:value` pairs.
	  _.findWhere = function(obj, attrs) {
	    return _.find(obj, _.matcher(attrs));
	  };

	  // Return the maximum element (or element-based computation).
	  _.max = function(obj, iteratee, context) {
	    var result = -Infinity, lastComputed = -Infinity,
	        value, computed;
	    if (iteratee == null && obj != null) {
	      obj = isArrayLike(obj) ? obj : _.values(obj);
	      for (var i = 0, length = obj.length; i < length; i++) {
	        value = obj[i];
	        if (value > result) {
	          result = value;
	        }
	      }
	    } else {
	      iteratee = cb(iteratee, context);
	      _.each(obj, function(value, index, list) {
	        computed = iteratee(value, index, list);
	        if (computed > lastComputed || computed === -Infinity && result === -Infinity) {
	          result = value;
	          lastComputed = computed;
	        }
	      });
	    }
	    return result;
	  };

	  // Return the minimum element (or element-based computation).
	  _.min = function(obj, iteratee, context) {
	    var result = Infinity, lastComputed = Infinity,
	        value, computed;
	    if (iteratee == null && obj != null) {
	      obj = isArrayLike(obj) ? obj : _.values(obj);
	      for (var i = 0, length = obj.length; i < length; i++) {
	        value = obj[i];
	        if (value < result) {
	          result = value;
	        }
	      }
	    } else {
	      iteratee = cb(iteratee, context);
	      _.each(obj, function(value, index, list) {
	        computed = iteratee(value, index, list);
	        if (computed < lastComputed || computed === Infinity && result === Infinity) {
	          result = value;
	          lastComputed = computed;
	        }
	      });
	    }
	    return result;
	  };

	  // Shuffle a collection, using the modern version of the
	  // [Fisher-Yates shuffle](http://en.wikipedia.org/wiki/Fisher–Yates_shuffle).
	  _.shuffle = function(obj) {
	    var set = isArrayLike(obj) ? obj : _.values(obj);
	    var length = set.length;
	    var shuffled = Array(length);
	    for (var index = 0, rand; index < length; index++) {
	      rand = _.random(0, index);
	      if (rand !== index) shuffled[index] = shuffled[rand];
	      shuffled[rand] = set[index];
	    }
	    return shuffled;
	  };

	  // Sample **n** random values from a collection.
	  // If **n** is not specified, returns a single random element.
	  // The internal `guard` argument allows it to work with `map`.
	  _.sample = function(obj, n, guard) {
	    if (n == null || guard) {
	      if (!isArrayLike(obj)) obj = _.values(obj);
	      return obj[_.random(obj.length - 1)];
	    }
	    return _.shuffle(obj).slice(0, Math.max(0, n));
	  };

	  // Sort the object's values by a criterion produced by an iteratee.
	  _.sortBy = function(obj, iteratee, context) {
	    iteratee = cb(iteratee, context);
	    return _.pluck(_.map(obj, function(value, index, list) {
	      return {
	        value: value,
	        index: index,
	        criteria: iteratee(value, index, list)
	      };
	    }).sort(function(left, right) {
	      var a = left.criteria;
	      var b = right.criteria;
	      if (a !== b) {
	        if (a > b || a === void 0) return 1;
	        if (a < b || b === void 0) return -1;
	      }
	      return left.index - right.index;
	    }), 'value');
	  };

	  // An internal function used for aggregate "group by" operations.
	  var group = function(behavior) {
	    return function(obj, iteratee, context) {
	      var result = {};
	      iteratee = cb(iteratee, context);
	      _.each(obj, function(value, index) {
	        var key = iteratee(value, index, obj);
	        behavior(result, value, key);
	      });
	      return result;
	    };
	  };

	  // Groups the object's values by a criterion. Pass either a string attribute
	  // to group by, or a function that returns the criterion.
	  _.groupBy = group(function(result, value, key) {
	    if (_.has(result, key)) result[key].push(value); else result[key] = [value];
	  });

	  // Indexes the object's values by a criterion, similar to `groupBy`, but for
	  // when you know that your index values will be unique.
	  _.indexBy = group(function(result, value, key) {
	    result[key] = value;
	  });

	  // Counts instances of an object that group by a certain criterion. Pass
	  // either a string attribute to count by, or a function that returns the
	  // criterion.
	  _.countBy = group(function(result, value, key) {
	    if (_.has(result, key)) result[key]++; else result[key] = 1;
	  });

	  // Safely create a real, live array from anything iterable.
	  _.toArray = function(obj) {
	    if (!obj) return [];
	    if (_.isArray(obj)) return slice.call(obj);
	    if (isArrayLike(obj)) return _.map(obj, _.identity);
	    return _.values(obj);
	  };

	  // Return the number of elements in an object.
	  _.size = function(obj) {
	    if (obj == null) return 0;
	    return isArrayLike(obj) ? obj.length : _.keys(obj).length;
	  };

	  // Split a collection into two arrays: one whose elements all satisfy the given
	  // predicate, and one whose elements all do not satisfy the predicate.
	  _.partition = function(obj, predicate, context) {
	    predicate = cb(predicate, context);
	    var pass = [], fail = [];
	    _.each(obj, function(value, key, obj) {
	      (predicate(value, key, obj) ? pass : fail).push(value);
	    });
	    return [pass, fail];
	  };

	  // Array Functions
	  // ---------------

	  // Get the first element of an array. Passing **n** will return the first N
	  // values in the array. Aliased as `head` and `take`. The **guard** check
	  // allows it to work with `_.map`.
	  _.first = _.head = _.take = function(array, n, guard) {
	    if (array == null) return void 0;
	    if (n == null || guard) return array[0];
	    return _.initial(array, array.length - n);
	  };

	  // Returns everything but the last entry of the array. Especially useful on
	  // the arguments object. Passing **n** will return all the values in
	  // the array, excluding the last N.
	  _.initial = function(array, n, guard) {
	    return slice.call(array, 0, Math.max(0, array.length - (n == null || guard ? 1 : n)));
	  };

	  // Get the last element of an array. Passing **n** will return the last N
	  // values in the array.
	  _.last = function(array, n, guard) {
	    if (array == null) return void 0;
	    if (n == null || guard) return array[array.length - 1];
	    return _.rest(array, Math.max(0, array.length - n));
	  };

	  // Returns everything but the first entry of the array. Aliased as `tail` and `drop`.
	  // Especially useful on the arguments object. Passing an **n** will return
	  // the rest N values in the array.
	  _.rest = _.tail = _.drop = function(array, n, guard) {
	    return slice.call(array, n == null || guard ? 1 : n);
	  };

	  // Trim out all falsy values from an array.
	  _.compact = function(array) {
	    return _.filter(array, _.identity);
	  };

	  // Internal implementation of a recursive `flatten` function.
	  var flatten = function(input, shallow, strict, startIndex) {
	    var output = [], idx = 0;
	    for (var i = startIndex || 0, length = getLength(input); i < length; i++) {
	      var value = input[i];
	      if (isArrayLike(value) && (_.isArray(value) || _.isArguments(value))) {
	        //flatten current level of array or arguments object
	        if (!shallow) value = flatten(value, shallow, strict);
	        var j = 0, len = value.length;
	        output.length += len;
	        while (j < len) {
	          output[idx++] = value[j++];
	        }
	      } else if (!strict) {
	        output[idx++] = value;
	      }
	    }
	    return output;
	  };

	  // Flatten out an array, either recursively (by default), or just one level.
	  _.flatten = function(array, shallow) {
	    return flatten(array, shallow, false);
	  };

	  // Return a version of the array that does not contain the specified value(s).
	  _.without = function(array) {
	    return _.difference(array, slice.call(arguments, 1));
	  };

	  // Produce a duplicate-free version of the array. If the array has already
	  // been sorted, you have the option of using a faster algorithm.
	  // Aliased as `unique`.
	  _.uniq = _.unique = function(array, isSorted, iteratee, context) {
	    if (!_.isBoolean(isSorted)) {
	      context = iteratee;
	      iteratee = isSorted;
	      isSorted = false;
	    }
	    if (iteratee != null) iteratee = cb(iteratee, context);
	    var result = [];
	    var seen = [];
	    for (var i = 0, length = getLength(array); i < length; i++) {
	      var value = array[i],
	          computed = iteratee ? iteratee(value, i, array) : value;
	      if (isSorted) {
	        if (!i || seen !== computed) result.push(value);
	        seen = computed;
	      } else if (iteratee) {
	        if (!_.contains(seen, computed)) {
	          seen.push(computed);
	          result.push(value);
	        }
	      } else if (!_.contains(result, value)) {
	        result.push(value);
	      }
	    }
	    return result;
	  };

	  // Produce an array that contains the union: each distinct element from all of
	  // the passed-in arrays.
	  _.union = function() {
	    return _.uniq(flatten(arguments, true, true));
	  };

	  // Produce an array that contains every item shared between all the
	  // passed-in arrays.
	  _.intersection = function(array) {
	    var result = [];
	    var argsLength = arguments.length;
	    for (var i = 0, length = getLength(array); i < length; i++) {
	      var item = array[i];
	      if (_.contains(result, item)) continue;
	      for (var j = 1; j < argsLength; j++) {
	        if (!_.contains(arguments[j], item)) break;
	      }
	      if (j === argsLength) result.push(item);
	    }
	    return result;
	  };

	  // Take the difference between one array and a number of other arrays.
	  // Only the elements present in just the first array will remain.
	  _.difference = function(array) {
	    var rest = flatten(arguments, true, true, 1);
	    return _.filter(array, function(value){
	      return !_.contains(rest, value);
	    });
	  };

	  // Zip together multiple lists into a single array -- elements that share
	  // an index go together.
	  _.zip = function() {
	    return _.unzip(arguments);
	  };

	  // Complement of _.zip. Unzip accepts an array of arrays and groups
	  // each array's elements on shared indices
	  _.unzip = function(array) {
	    var length = array && _.max(array, getLength).length || 0;
	    var result = Array(length);

	    for (var index = 0; index < length; index++) {
	      result[index] = _.pluck(array, index);
	    }
	    return result;
	  };

	  // Converts lists into objects. Pass either a single array of `[key, value]`
	  // pairs, or two parallel arrays of the same length -- one of keys, and one of
	  // the corresponding values.
	  _.object = function(list, values) {
	    var result = {};
	    for (var i = 0, length = getLength(list); i < length; i++) {
	      if (values) {
	        result[list[i]] = values[i];
	      } else {
	        result[list[i][0]] = list[i][1];
	      }
	    }
	    return result;
	  };

	  // Generator function to create the findIndex and findLastIndex functions
	  function createPredicateIndexFinder(dir) {
	    return function(array, predicate, context) {
	      predicate = cb(predicate, context);
	      var length = getLength(array);
	      var index = dir > 0 ? 0 : length - 1;
	      for (; index >= 0 && index < length; index += dir) {
	        if (predicate(array[index], index, array)) return index;
	      }
	      return -1;
	    };
	  }

	  // Returns the first index on an array-like that passes a predicate test
	  _.findIndex = createPredicateIndexFinder(1);
	  _.findLastIndex = createPredicateIndexFinder(-1);

	  // Use a comparator function to figure out the smallest index at which
	  // an object should be inserted so as to maintain order. Uses binary search.
	  _.sortedIndex = function(array, obj, iteratee, context) {
	    iteratee = cb(iteratee, context, 1);
	    var value = iteratee(obj);
	    var low = 0, high = getLength(array);
	    while (low < high) {
	      var mid = Math.floor((low + high) / 2);
	      if (iteratee(array[mid]) < value) low = mid + 1; else high = mid;
	    }
	    return low;
	  };

	  // Generator function to create the indexOf and lastIndexOf functions
	  function createIndexFinder(dir, predicateFind, sortedIndex) {
	    return function(array, item, idx) {
	      var i = 0, length = getLength(array);
	      if (typeof idx == 'number') {
	        if (dir > 0) {
	            i = idx >= 0 ? idx : Math.max(idx + length, i);
	        } else {
	            length = idx >= 0 ? Math.min(idx + 1, length) : idx + length + 1;
	        }
	      } else if (sortedIndex && idx && length) {
	        idx = sortedIndex(array, item);
	        return array[idx] === item ? idx : -1;
	      }
	      if (item !== item) {
	        idx = predicateFind(slice.call(array, i, length), _.isNaN);
	        return idx >= 0 ? idx + i : -1;
	      }
	      for (idx = dir > 0 ? i : length - 1; idx >= 0 && idx < length; idx += dir) {
	        if (array[idx] === item) return idx;
	      }
	      return -1;
	    };
	  }

	  // Return the position of the first occurrence of an item in an array,
	  // or -1 if the item is not included in the array.
	  // If the array is large and already in sort order, pass `true`
	  // for **isSorted** to use binary search.
	  _.indexOf = createIndexFinder(1, _.findIndex, _.sortedIndex);
	  _.lastIndexOf = createIndexFinder(-1, _.findLastIndex);

	  // Generate an integer Array containing an arithmetic progression. A port of
	  // the native Python `range()` function. See
	  // [the Python documentation](http://docs.python.org/library/functions.html#range).
	  _.range = function(start, stop, step) {
	    if (stop == null) {
	      stop = start || 0;
	      start = 0;
	    }
	    step = step || 1;

	    var length = Math.max(Math.ceil((stop - start) / step), 0);
	    var range = Array(length);

	    for (var idx = 0; idx < length; idx++, start += step) {
	      range[idx] = start;
	    }

	    return range;
	  };

	  // Function (ahem) Functions
	  // ------------------

	  // Determines whether to execute a function as a constructor
	  // or a normal function with the provided arguments
	  var executeBound = function(sourceFunc, boundFunc, context, callingContext, args) {
	    if (!(callingContext instanceof boundFunc)) return sourceFunc.apply(context, args);
	    var self = baseCreate(sourceFunc.prototype);
	    var result = sourceFunc.apply(self, args);
	    if (_.isObject(result)) return result;
	    return self;
	  };

	  // Create a function bound to a given object (assigning `this`, and arguments,
	  // optionally). Delegates to **ECMAScript 5**'s native `Function.bind` if
	  // available.
	  _.bind = function(func, context) {
	    if (nativeBind && func.bind === nativeBind) return nativeBind.apply(func, slice.call(arguments, 1));
	    if (!_.isFunction(func)) throw new TypeError('Bind must be called on a function');
	    var args = slice.call(arguments, 2);
	    var bound = function() {
	      return executeBound(func, bound, context, this, args.concat(slice.call(arguments)));
	    };
	    return bound;
	  };

	  // Partially apply a function by creating a version that has had some of its
	  // arguments pre-filled, without changing its dynamic `this` context. _ acts
	  // as a placeholder, allowing any combination of arguments to be pre-filled.
	  _.partial = function(func) {
	    var boundArgs = slice.call(arguments, 1);
	    var bound = function() {
	      var position = 0, length = boundArgs.length;
	      var args = Array(length);
	      for (var i = 0; i < length; i++) {
	        args[i] = boundArgs[i] === _ ? arguments[position++] : boundArgs[i];
	      }
	      while (position < arguments.length) args.push(arguments[position++]);
	      return executeBound(func, bound, this, this, args);
	    };
	    return bound;
	  };

	  // Bind a number of an object's methods to that object. Remaining arguments
	  // are the method names to be bound. Useful for ensuring that all callbacks
	  // defined on an object belong to it.
	  _.bindAll = function(obj) {
	    var i, length = arguments.length, key;
	    if (length <= 1) throw new Error('bindAll must be passed function names');
	    for (i = 1; i < length; i++) {
	      key = arguments[i];
	      obj[key] = _.bind(obj[key], obj);
	    }
	    return obj;
	  };

	  // Memoize an expensive function by storing its results.
	  _.memoize = function(func, hasher) {
	    var memoize = function(key) {
	      var cache = memoize.cache;
	      var address = '' + (hasher ? hasher.apply(this, arguments) : key);
	      if (!_.has(cache, address)) cache[address] = func.apply(this, arguments);
	      return cache[address];
	    };
	    memoize.cache = {};
	    return memoize;
	  };

	  // Delays a function for the given number of milliseconds, and then calls
	  // it with the arguments supplied.
	  _.delay = function(func, wait) {
	    var args = slice.call(arguments, 2);
	    return setTimeout(function(){
	      return func.apply(null, args);
	    }, wait);
	  };

	  // Defers a function, scheduling it to run after the current call stack has
	  // cleared.
	  _.defer = _.partial(_.delay, _, 1);

	  // Returns a function, that, when invoked, will only be triggered at most once
	  // during a given window of time. Normally, the throttled function will run
	  // as much as it can, without ever going more than once per `wait` duration;
	  // but if you'd like to disable the execution on the leading edge, pass
	  // `{leading: false}`. To disable execution on the trailing edge, ditto.
	  _.throttle = function(func, wait, options) {
	    var context, args, result;
	    var timeout = null;
	    var previous = 0;
	    if (!options) options = {};
	    var later = function() {
	      previous = options.leading === false ? 0 : _.now();
	      timeout = null;
	      result = func.apply(context, args);
	      if (!timeout) context = args = null;
	    };
	    return function() {
	      var now = _.now();
	      if (!previous && options.leading === false) previous = now;
	      var remaining = wait - (now - previous);
	      context = this;
	      args = arguments;
	      if (remaining <= 0 || remaining > wait) {
	        if (timeout) {
	          clearTimeout(timeout);
	          timeout = null;
	        }
	        previous = now;
	        result = func.apply(context, args);
	        if (!timeout) context = args = null;
	      } else if (!timeout && options.trailing !== false) {
	        timeout = setTimeout(later, remaining);
	      }
	      return result;
	    };
	  };

	  // Returns a function, that, as long as it continues to be invoked, will not
	  // be triggered. The function will be called after it stops being called for
	  // N milliseconds. If `immediate` is passed, trigger the function on the
	  // leading edge, instead of the trailing.
	  _.debounce = function(func, wait, immediate) {
	    var timeout, args, context, timestamp, result;

	    var later = function() {
	      var last = _.now() - timestamp;

	      if (last < wait && last >= 0) {
	        timeout = setTimeout(later, wait - last);
	      } else {
	        timeout = null;
	        if (!immediate) {
	          result = func.apply(context, args);
	          if (!timeout) context = args = null;
	        }
	      }
	    };

	    return function() {
	      context = this;
	      args = arguments;
	      timestamp = _.now();
	      var callNow = immediate && !timeout;
	      if (!timeout) timeout = setTimeout(later, wait);
	      if (callNow) {
	        result = func.apply(context, args);
	        context = args = null;
	      }

	      return result;
	    };
	  };

	  // Returns the first function passed as an argument to the second,
	  // allowing you to adjust arguments, run code before and after, and
	  // conditionally execute the original function.
	  _.wrap = function(func, wrapper) {
	    return _.partial(wrapper, func);
	  };

	  // Returns a negated version of the passed-in predicate.
	  _.negate = function(predicate) {
	    return function() {
	      return !predicate.apply(this, arguments);
	    };
	  };

	  // Returns a function that is the composition of a list of functions, each
	  // consuming the return value of the function that follows.
	  _.compose = function() {
	    var args = arguments;
	    var start = args.length - 1;
	    return function() {
	      var i = start;
	      var result = args[start].apply(this, arguments);
	      while (i--) result = args[i].call(this, result);
	      return result;
	    };
	  };

	  // Returns a function that will only be executed on and after the Nth call.
	  _.after = function(times, func) {
	    return function() {
	      if (--times < 1) {
	        return func.apply(this, arguments);
	      }
	    };
	  };

	  // Returns a function that will only be executed up to (but not including) the Nth call.
	  _.before = function(times, func) {
	    var memo;
	    return function() {
	      if (--times > 0) {
	        memo = func.apply(this, arguments);
	      }
	      if (times <= 1) func = null;
	      return memo;
	    };
	  };

	  // Returns a function that will be executed at most one time, no matter how
	  // often you call it. Useful for lazy initialization.
	  _.once = _.partial(_.before, 2);

	  // Object Functions
	  // ----------------

	  // Keys in IE < 9 that won't be iterated by `for key in ...` and thus missed.
	  var hasEnumBug = !{toString: null}.propertyIsEnumerable('toString');
	  var nonEnumerableProps = ['valueOf', 'isPrototypeOf', 'toString',
	                      'propertyIsEnumerable', 'hasOwnProperty', 'toLocaleString'];

	  function collectNonEnumProps(obj, keys) {
	    var nonEnumIdx = nonEnumerableProps.length;
	    var constructor = obj.constructor;
	    var proto = (_.isFunction(constructor) && constructor.prototype) || ObjProto;

	    // Constructor is a special case.
	    var prop = 'constructor';
	    if (_.has(obj, prop) && !_.contains(keys, prop)) keys.push(prop);

	    while (nonEnumIdx--) {
	      prop = nonEnumerableProps[nonEnumIdx];
	      if (prop in obj && obj[prop] !== proto[prop] && !_.contains(keys, prop)) {
	        keys.push(prop);
	      }
	    }
	  }

	  // Retrieve the names of an object's own properties.
	  // Delegates to **ECMAScript 5**'s native `Object.keys`
	  _.keys = function(obj) {
	    if (!_.isObject(obj)) return [];
	    if (nativeKeys) return nativeKeys(obj);
	    var keys = [];
	    for (var key in obj) if (_.has(obj, key)) keys.push(key);
	    // Ahem, IE < 9.
	    if (hasEnumBug) collectNonEnumProps(obj, keys);
	    return keys;
	  };

	  // Retrieve all the property names of an object.
	  _.allKeys = function(obj) {
	    if (!_.isObject(obj)) return [];
	    var keys = [];
	    for (var key in obj) keys.push(key);
	    // Ahem, IE < 9.
	    if (hasEnumBug) collectNonEnumProps(obj, keys);
	    return keys;
	  };

	  // Retrieve the values of an object's properties.
	  _.values = function(obj) {
	    var keys = _.keys(obj);
	    var length = keys.length;
	    var values = Array(length);
	    for (var i = 0; i < length; i++) {
	      values[i] = obj[keys[i]];
	    }
	    return values;
	  };

	  // Returns the results of applying the iteratee to each element of the object
	  // In contrast to _.map it returns an object
	  _.mapObject = function(obj, iteratee, context) {
	    iteratee = cb(iteratee, context);
	    var keys =  _.keys(obj),
	          length = keys.length,
	          results = {},
	          currentKey;
	      for (var index = 0; index < length; index++) {
	        currentKey = keys[index];
	        results[currentKey] = iteratee(obj[currentKey], currentKey, obj);
	      }
	      return results;
	  };

	  // Convert an object into a list of `[key, value]` pairs.
	  _.pairs = function(obj) {
	    var keys = _.keys(obj);
	    var length = keys.length;
	    var pairs = Array(length);
	    for (var i = 0; i < length; i++) {
	      pairs[i] = [keys[i], obj[keys[i]]];
	    }
	    return pairs;
	  };

	  // Invert the keys and values of an object. The values must be serializable.
	  _.invert = function(obj) {
	    var result = {};
	    var keys = _.keys(obj);
	    for (var i = 0, length = keys.length; i < length; i++) {
	      result[obj[keys[i]]] = keys[i];
	    }
	    return result;
	  };

	  // Return a sorted list of the function names available on the object.
	  // Aliased as `methods`
	  _.functions = _.methods = function(obj) {
	    var names = [];
	    for (var key in obj) {
	      if (_.isFunction(obj[key])) names.push(key);
	    }
	    return names.sort();
	  };

	  // Extend a given object with all the properties in passed-in object(s).
	  _.extend = createAssigner(_.allKeys);

	  // Assigns a given object with all the own properties in the passed-in object(s)
	  // (https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object/assign)
	  _.extendOwn = _.assign = createAssigner(_.keys);

	  // Returns the first key on an object that passes a predicate test
	  _.findKey = function(obj, predicate, context) {
	    predicate = cb(predicate, context);
	    var keys = _.keys(obj), key;
	    for (var i = 0, length = keys.length; i < length; i++) {
	      key = keys[i];
	      if (predicate(obj[key], key, obj)) return key;
	    }
	  };

	  // Return a copy of the object only containing the whitelisted properties.
	  _.pick = function(object, oiteratee, context) {
	    var result = {}, obj = object, iteratee, keys;
	    if (obj == null) return result;
	    if (_.isFunction(oiteratee)) {
	      keys = _.allKeys(obj);
	      iteratee = optimizeCb(oiteratee, context);
	    } else {
	      keys = flatten(arguments, false, false, 1);
	      iteratee = function(value, key, obj) { return key in obj; };
	      obj = Object(obj);
	    }
	    for (var i = 0, length = keys.length; i < length; i++) {
	      var key = keys[i];
	      var value = obj[key];
	      if (iteratee(value, key, obj)) result[key] = value;
	    }
	    return result;
	  };

	   // Return a copy of the object without the blacklisted properties.
	  _.omit = function(obj, iteratee, context) {
	    if (_.isFunction(iteratee)) {
	      iteratee = _.negate(iteratee);
	    } else {
	      var keys = _.map(flatten(arguments, false, false, 1), String);
	      iteratee = function(value, key) {
	        return !_.contains(keys, key);
	      };
	    }
	    return _.pick(obj, iteratee, context);
	  };

	  // Fill in a given object with default properties.
	  _.defaults = createAssigner(_.allKeys, true);

	  // Creates an object that inherits from the given prototype object.
	  // If additional properties are provided then they will be added to the
	  // created object.
	  _.create = function(prototype, props) {
	    var result = baseCreate(prototype);
	    if (props) _.extendOwn(result, props);
	    return result;
	  };

	  // Create a (shallow-cloned) duplicate of an object.
	  _.clone = function(obj) {
	    if (!_.isObject(obj)) return obj;
	    return _.isArray(obj) ? obj.slice() : _.extend({}, obj);
	  };

	  // Invokes interceptor with the obj, and then returns obj.
	  // The primary purpose of this method is to "tap into" a method chain, in
	  // order to perform operations on intermediate results within the chain.
	  _.tap = function(obj, interceptor) {
	    interceptor(obj);
	    return obj;
	  };

	  // Returns whether an object has a given set of `key:value` pairs.
	  _.isMatch = function(object, attrs) {
	    var keys = _.keys(attrs), length = keys.length;
	    if (object == null) return !length;
	    var obj = Object(object);
	    for (var i = 0; i < length; i++) {
	      var key = keys[i];
	      if (attrs[key] !== obj[key] || !(key in obj)) return false;
	    }
	    return true;
	  };


	  // Internal recursive comparison function for `isEqual`.
	  var eq = function(a, b, aStack, bStack) {
	    // Identical objects are equal. `0 === -0`, but they aren't identical.
	    // See the [Harmony `egal` proposal](http://wiki.ecmascript.org/doku.php?id=harmony:egal).
	    if (a === b) return a !== 0 || 1 / a === 1 / b;
	    // A strict comparison is necessary because `null == undefined`.
	    if (a == null || b == null) return a === b;
	    // Unwrap any wrapped objects.
	    if (a instanceof _) a = a._wrapped;
	    if (b instanceof _) b = b._wrapped;
	    // Compare `[[Class]]` names.
	    var className = toString.call(a);
	    if (className !== toString.call(b)) return false;
	    switch (className) {
	      // Strings, numbers, regular expressions, dates, and booleans are compared by value.
	      case '[object RegExp]':
	      // RegExps are coerced to strings for comparison (Note: '' + /a/i === '/a/i')
	      case '[object String]':
	        // Primitives and their corresponding object wrappers are equivalent; thus, `"5"` is
	        // equivalent to `new String("5")`.
	        return '' + a === '' + b;
	      case '[object Number]':
	        // `NaN`s are equivalent, but non-reflexive.
	        // Object(NaN) is equivalent to NaN
	        if (+a !== +a) return +b !== +b;
	        // An `egal` comparison is performed for other numeric values.
	        return +a === 0 ? 1 / +a === 1 / b : +a === +b;
	      case '[object Date]':
	      case '[object Boolean]':
	        // Coerce dates and booleans to numeric primitive values. Dates are compared by their
	        // millisecond representations. Note that invalid dates with millisecond representations
	        // of `NaN` are not equivalent.
	        return +a === +b;
	    }

	    var areArrays = className === '[object Array]';
	    if (!areArrays) {
	      if (typeof a != 'object' || typeof b != 'object') return false;

	      // Objects with different constructors are not equivalent, but `Object`s or `Array`s
	      // from different frames are.
	      var aCtor = a.constructor, bCtor = b.constructor;
	      if (aCtor !== bCtor && !(_.isFunction(aCtor) && aCtor instanceof aCtor &&
	                               _.isFunction(bCtor) && bCtor instanceof bCtor)
	                          && ('constructor' in a && 'constructor' in b)) {
	        return false;
	      }
	    }
	    // Assume equality for cyclic structures. The algorithm for detecting cyclic
	    // structures is adapted from ES 5.1 section 15.12.3, abstract operation `JO`.

	    // Initializing stack of traversed objects.
	    // It's done here since we only need them for objects and arrays comparison.
	    aStack = aStack || [];
	    bStack = bStack || [];
	    var length = aStack.length;
	    while (length--) {
	      // Linear search. Performance is inversely proportional to the number of
	      // unique nested structures.
	      if (aStack[length] === a) return bStack[length] === b;
	    }

	    // Add the first object to the stack of traversed objects.
	    aStack.push(a);
	    bStack.push(b);

	    // Recursively compare objects and arrays.
	    if (areArrays) {
	      // Compare array lengths to determine if a deep comparison is necessary.
	      length = a.length;
	      if (length !== b.length) return false;
	      // Deep compare the contents, ignoring non-numeric properties.
	      while (length--) {
	        if (!eq(a[length], b[length], aStack, bStack)) return false;
	      }
	    } else {
	      // Deep compare objects.
	      var keys = _.keys(a), key;
	      length = keys.length;
	      // Ensure that both objects contain the same number of properties before comparing deep equality.
	      if (_.keys(b).length !== length) return false;
	      while (length--) {
	        // Deep compare each member
	        key = keys[length];
	        if (!(_.has(b, key) && eq(a[key], b[key], aStack, bStack))) return false;
	      }
	    }
	    // Remove the first object from the stack of traversed objects.
	    aStack.pop();
	    bStack.pop();
	    return true;
	  };

	  // Perform a deep comparison to check if two objects are equal.
	  _.isEqual = function(a, b) {
	    return eq(a, b);
	  };

	  // Is a given array, string, or object empty?
	  // An "empty" object has no enumerable own-properties.
	  _.isEmpty = function(obj) {
	    if (obj == null) return true;
	    if (isArrayLike(obj) && (_.isArray(obj) || _.isString(obj) || _.isArguments(obj))) return obj.length === 0;
	    return _.keys(obj).length === 0;
	  };

	  // Is a given value a DOM element?
	  _.isElement = function(obj) {
	    return !!(obj && obj.nodeType === 1);
	  };

	  // Is a given value an array?
	  // Delegates to ECMA5's native Array.isArray
	  _.isArray = nativeIsArray || function(obj) {
	    return toString.call(obj) === '[object Array]';
	  };

	  // Is a given variable an object?
	  _.isObject = function(obj) {
	    var type = typeof obj;
	    return type === 'function' || type === 'object' && !!obj;
	  };

	  // Add some isType methods: isArguments, isFunction, isString, isNumber, isDate, isRegExp, isError.
	  _.each(['Arguments', 'Function', 'String', 'Number', 'Date', 'RegExp', 'Error'], function(name) {
	    _['is' + name] = function(obj) {
	      return toString.call(obj) === '[object ' + name + ']';
	    };
	  });

	  // Define a fallback version of the method in browsers (ahem, IE < 9), where
	  // there isn't any inspectable "Arguments" type.
	  if (!_.isArguments(arguments)) {
	    _.isArguments = function(obj) {
	      return _.has(obj, 'callee');
	    };
	  }

	  // Optimize `isFunction` if appropriate. Work around some typeof bugs in old v8,
	  // IE 11 (#1621), and in Safari 8 (#1929).
	  if (typeof /./ != 'function' && typeof Int8Array != 'object') {
	    _.isFunction = function(obj) {
	      return typeof obj == 'function' || false;
	    };
	  }

	  // Is a given object a finite number?
	  _.isFinite = function(obj) {
	    return isFinite(obj) && !isNaN(parseFloat(obj));
	  };

	  // Is the given value `NaN`? (NaN is the only number which does not equal itself).
	  _.isNaN = function(obj) {
	    return _.isNumber(obj) && obj !== +obj;
	  };

	  // Is a given value a boolean?
	  _.isBoolean = function(obj) {
	    return obj === true || obj === false || toString.call(obj) === '[object Boolean]';
	  };

	  // Is a given value equal to null?
	  _.isNull = function(obj) {
	    return obj === null;
	  };

	  // Is a given variable undefined?
	  _.isUndefined = function(obj) {
	    return obj === void 0;
	  };

	  // Shortcut function for checking if an object has a given property directly
	  // on itself (in other words, not on a prototype).
	  _.has = function(obj, key) {
	    return obj != null && hasOwnProperty.call(obj, key);
	  };

	  // Utility Functions
	  // -----------------

	  // Run Underscore.js in *noConflict* mode, returning the `_` variable to its
	  // previous owner. Returns a reference to the Underscore object.
	  _.noConflict = function() {
	    root._ = previousUnderscore;
	    return this;
	  };

	  // Keep the identity function around for default iteratees.
	  _.identity = function(value) {
	    return value;
	  };

	  // Predicate-generating functions. Often useful outside of Underscore.
	  _.constant = function(value) {
	    return function() {
	      return value;
	    };
	  };

	  _.noop = function(){};

	  _.property = property;

	  // Generates a function for a given object that returns a given property.
	  _.propertyOf = function(obj) {
	    return obj == null ? function(){} : function(key) {
	      return obj[key];
	    };
	  };

	  // Returns a predicate for checking whether an object has a given set of
	  // `key:value` pairs.
	  _.matcher = _.matches = function(attrs) {
	    attrs = _.extendOwn({}, attrs);
	    return function(obj) {
	      return _.isMatch(obj, attrs);
	    };
	  };

	  // Run a function **n** times.
	  _.times = function(n, iteratee, context) {
	    var accum = Array(Math.max(0, n));
	    iteratee = optimizeCb(iteratee, context, 1);
	    for (var i = 0; i < n; i++) accum[i] = iteratee(i);
	    return accum;
	  };

	  // Return a random integer between min and max (inclusive).
	  _.random = function(min, max) {
	    if (max == null) {
	      max = min;
	      min = 0;
	    }
	    return min + Math.floor(Math.random() * (max - min + 1));
	  };

	  // A (possibly faster) way to get the current timestamp as an integer.
	  _.now = Date.now || function() {
	    return new Date().getTime();
	  };

	   // List of HTML entities for escaping.
	  var escapeMap = {
	    '&': '&amp;',
	    '<': '&lt;',
	    '>': '&gt;',
	    '"': '&quot;',
	    "'": '&#x27;',
	    '`': '&#x60;'
	  };
	  var unescapeMap = _.invert(escapeMap);

	  // Functions for escaping and unescaping strings to/from HTML interpolation.
	  var createEscaper = function(map) {
	    var escaper = function(match) {
	      return map[match];
	    };
	    // Regexes for identifying a key that needs to be escaped
	    var source = '(?:' + _.keys(map).join('|') + ')';
	    var testRegexp = RegExp(source);
	    var replaceRegexp = RegExp(source, 'g');
	    return function(string) {
	      string = string == null ? '' : '' + string;
	      return testRegexp.test(string) ? string.replace(replaceRegexp, escaper) : string;
	    };
	  };
	  _.escape = createEscaper(escapeMap);
	  _.unescape = createEscaper(unescapeMap);

	  // If the value of the named `property` is a function then invoke it with the
	  // `object` as context; otherwise, return it.
	  _.result = function(object, property, fallback) {
	    var value = object == null ? void 0 : object[property];
	    if (value === void 0) {
	      value = fallback;
	    }
	    return _.isFunction(value) ? value.call(object) : value;
	  };

	  // Generate a unique integer id (unique within the entire client session).
	  // Useful for temporary DOM ids.
	  var idCounter = 0;
	  _.uniqueId = function(prefix) {
	    var id = ++idCounter + '';
	    return prefix ? prefix + id : id;
	  };

	  // By default, Underscore uses ERB-style template delimiters, change the
	  // following template settings to use alternative delimiters.
	  _.templateSettings = {
	    evaluate    : /<%([\s\S]+?)%>/g,
	    interpolate : /<%=([\s\S]+?)%>/g,
	    escape      : /<%-([\s\S]+?)%>/g
	  };

	  // When customizing `templateSettings`, if you don't want to define an
	  // interpolation, evaluation or escaping regex, we need one that is
	  // guaranteed not to match.
	  var noMatch = /(.)^/;

	  // Certain characters need to be escaped so that they can be put into a
	  // string literal.
	  var escapes = {
	    "'":      "'",
	    '\\':     '\\',
	    '\r':     'r',
	    '\n':     'n',
	    '\u2028': 'u2028',
	    '\u2029': 'u2029'
	  };

	  var escaper = /\\|'|\r|\n|\u2028|\u2029/g;

	  var escapeChar = function(match) {
	    return '\\' + escapes[match];
	  };

	  // JavaScript micro-templating, similar to John Resig's implementation.
	  // Underscore templating handles arbitrary delimiters, preserves whitespace,
	  // and correctly escapes quotes within interpolated code.
	  // NB: `oldSettings` only exists for backwards compatibility.
	  _.template = function(text, settings, oldSettings) {
	    if (!settings && oldSettings) settings = oldSettings;
	    settings = _.defaults({}, settings, _.templateSettings);

	    // Combine delimiters into one regular expression via alternation.
	    var matcher = RegExp([
	      (settings.escape || noMatch).source,
	      (settings.interpolate || noMatch).source,
	      (settings.evaluate || noMatch).source
	    ].join('|') + '|$', 'g');

	    // Compile the template source, escaping string literals appropriately.
	    var index = 0;
	    var source = "__p+='";
	    text.replace(matcher, function(match, escape, interpolate, evaluate, offset) {
	      source += text.slice(index, offset).replace(escaper, escapeChar);
	      index = offset + match.length;

	      if (escape) {
	        source += "'+\n((__t=(" + escape + "))==null?'':_.escape(__t))+\n'";
	      } else if (interpolate) {
	        source += "'+\n((__t=(" + interpolate + "))==null?'':__t)+\n'";
	      } else if (evaluate) {
	        source += "';\n" + evaluate + "\n__p+='";
	      }

	      // Adobe VMs need the match returned to produce the correct offest.
	      return match;
	    });
	    source += "';\n";

	    // If a variable is not specified, place data values in local scope.
	    if (!settings.variable) source = 'with(obj||{}){\n' + source + '}\n';

	    source = "var __t,__p='',__j=Array.prototype.join," +
	      "print=function(){__p+=__j.call(arguments,'');};\n" +
	      source + 'return __p;\n';

	    try {
	      var render = new Function(settings.variable || 'obj', '_', source);
	    } catch (e) {
	      e.source = source;
	      throw e;
	    }

	    var template = function(data) {
	      return render.call(this, data, _);
	    };

	    // Provide the compiled source as a convenience for precompilation.
	    var argument = settings.variable || 'obj';
	    template.source = 'function(' + argument + '){\n' + source + '}';

	    return template;
	  };

	  // Add a "chain" function. Start chaining a wrapped Underscore object.
	  _.chain = function(obj) {
	    var instance = _(obj);
	    instance._chain = true;
	    return instance;
	  };

	  // OOP
	  // ---------------
	  // If Underscore is called as a function, it returns a wrapped object that
	  // can be used OO-style. This wrapper holds altered versions of all the
	  // underscore functions. Wrapped objects may be chained.

	  // Helper function to continue chaining intermediate results.
	  var result = function(instance, obj) {
	    return instance._chain ? _(obj).chain() : obj;
	  };

	  // Add your own custom functions to the Underscore object.
	  _.mixin = function(obj) {
	    _.each(_.functions(obj), function(name) {
	      var func = _[name] = obj[name];
	      _.prototype[name] = function() {
	        var args = [this._wrapped];
	        push.apply(args, arguments);
	        return result(this, func.apply(_, args));
	      };
	    });
	  };

	  // Add all of the Underscore functions to the wrapper object.
	  _.mixin(_);

	  // Add all mutator Array functions to the wrapper.
	  _.each(['pop', 'push', 'reverse', 'shift', 'sort', 'splice', 'unshift'], function(name) {
	    var method = ArrayProto[name];
	    _.prototype[name] = function() {
	      var obj = this._wrapped;
	      method.apply(obj, arguments);
	      if ((name === 'shift' || name === 'splice') && obj.length === 0) delete obj[0];
	      return result(this, obj);
	    };
	  });

	  // Add all accessor Array functions to the wrapper.
	  _.each(['concat', 'join', 'slice'], function(name) {
	    var method = ArrayProto[name];
	    _.prototype[name] = function() {
	      return result(this, method.apply(this._wrapped, arguments));
	    };
	  });

	  // Extracts the result from a wrapped and chained object.
	  _.prototype.value = function() {
	    return this._wrapped;
	  };

	  // Provide unwrapping proxy for some methods used in engine operations
	  // such as arithmetic and JSON stringification.
	  _.prototype.valueOf = _.prototype.toJSON = _.prototype.value;

	  _.prototype.toString = function() {
	    return '' + this._wrapped;
	  };

	  // AMD registration happens at the end for compatibility with AMD loaders
	  // that may not enforce next-turn semantics on modules. Even though general
	  // practice for AMD registration is to be anonymous, underscore registers
	  // as a named module because, like jQuery, it is a base library that is
	  // popular enough to be bundled in a third party lib, but not be part of
	  // an AMD load request. Those cases could generate an error when an
	  // anonymous define() is called outside of a loader request.
	  if (true) {
	    !(__WEBPACK_AMD_DEFINE_ARRAY__ = [], __WEBPACK_AMD_DEFINE_RESULT__ = function() {
	      return _;
	    }.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__), __WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
	  }
	}.call(this));


/***/ },
/* 112 */
/***/ function(module, exports) {

	module.exports = {
		"translations": {
			"ADD_FILTER": "Add filter",
			"ADD_GROUP": "Add level/group",
			"ADD_INPUT": "Add input",
			"ADD_SUBGROUP": "Add sub-level/group",
			"APPEARANCE": "APPEARANCE",
			"A_TO_Z": "A->Z",
			"BOTTOM": "Bottom",
			"CANCEL": "Cancel",
			"COLUMNS": "Columns",
			"COLUMN_FOOTER": "Column Footer",
			"COLUMN_HEADER": "Column Header",
			"CONFIRM_DELETE_GROUP": "This will permanently delete {count} element(s) from the header and footer of this group.  Are you sure you want to remove this group?",
			"CONFIRM_DESIGNER_CANCEL": "Are you sure you want to discard changes to this report?  This action cannot be undone.",
			"DATA": "Data",
			"DATA_SOURCE": "DATA SOURCE",
			"DATA_SOURCE_PLACEHOLDER": "None",
			"DATE": "Date",
			"DEFAULT_FONT": "Default font",
			"DEFAULT_FONT_SIZE": "Default font size",
			"DELETE": "Delete",
			"DETAIL": "Detail",
			"DETAIL_NUMBER": "Detail {index}",
			"DOWNLOAD": "Download",
			"EDIT": "EDIT",
			"EDITING_SUBREPORT": "Editing subreport",
			"ELEMENT_TYPE_NAME_BARCODE": "Barcode",
			"ELEMENT_TYPE_NAME_BOX": "Box",
			"ELEMENT_TYPE_NAME_BREAK": "Page Break",
			"ELEMENT_TYPE_NAME_CHART": "Chart",
			"ELEMENT_TYPE_NAME_CHECKBOX": "Checkbox",
			"ELEMENT_TYPE_NAME_IMAGE": "Image",
			"ELEMENT_TYPE_NAME_LINE": "Line",
			"ELEMENT_TYPE_NAME_SUBREPORT": "Subreport",
			"ELEMENT_TYPE_NAME_TABLE": "Table",
			"ELEMENT_TYPE_NAME_TEXT": "Text",
			"EMBEDDED_SCHEMA": "Embedded schema",
			"ENABLE_PIVOT": "Enable pivot",
			"EXCEL": "Excel",
			"FILTERS": "FILTERS",
			"FILTER_OPERAND_EXAMPLE_ANY": "e.g. Johnson or 42 or 5/14/2017 (m/d/y)",
			"FILTER_OPERAND_EXAMPLE_DATE": "e.g. 5/19/2017 (m/d/y) or 2017-05-19",
			"FILTER_OPERAND_EXAMPLE_NUMBER": "e.g. 42",
			"FILTER_OPERAND_EXAMPLE_ONE_OF": "e.g. 1, 8, 42 or Johnson, Stevens, Smith",
			"FILTER_OPERAND_EXAMPLE_TEXT": "e.g. Johnson",
			"FILTER_OPERATOR_AFTER": "is after",
			"FILTER_OPERATOR_BEFORE": "is before",
			"FILTER_OPERATOR_CONTAINS": "contains",
			"FILTER_OPERATOR_DOES_NOT_CONTAIN": "does not contain",
			"FILTER_OPERATOR_GT": "is greater than",
			"FILTER_OPERATOR_GTE": "is greater than or equal to",
			"FILTER_OPERATOR_IS": "is",
			"FILTER_OPERATOR_IS_NOT": "is not",
			"FILTER_OPERATOR_LT": "is less than",
			"FILTER_OPERATOR_LTE": "is less than or equal to",
			"FILTER_OPERATOR_ON_OR_AFTER": "is on or after",
			"FILTER_OPERATOR_ON_OR_BEFORE": "is on or before",
			"GROUPING": "GROUPING",
			"GROUP_BY_LABEL": "Group by",
			"GROUP_FOOTER_LABEL": "footer",
			"GROUP_HEADER_LABEL": "header",
			"GROUP_N_FOOTER": "Group {index} footer",
			"GROUP_N_HEADER": "Group {index} header",
			"GROUP_ORDER_LABEL": "ordered by",
			"GROUP_RECORDS": "Group records",
			"GROUP_WITH": "with",
			"INCHES": "inches",
			"INPUTS": "Inputs",
			"INPUT_DEFAULT_LABEL": "Initial value",
			"INPUT_DEFAULT_PLACEHOLDER": "enter a value",
			"INPUT_DEFAULT_VALUE_EXAMPLE_DATE": "ex: 5/19/2017, 3 days ago",
			"INPUT_DEFAULT_VALUE_EXAMPLE_NUMBER": "ex: 42",
			"INPUT_DEFAULT_VALUE_EXAMPLE_TEXT": "ex: Smith",
			"INPUT_NAME": "Name",
			"INPUT_NAME_PLACEHOLDER": "Input name",
			"INPUT_TYPE": "Type",
			"LEFT": "Left",
			"MARGINS": "MARGINS",
			"MISSING_SCHEMA": "Data source schema missing",
			"MM": "mm",
			"NONE": "None",
			"NO_REPORT_LOADED": "No report loaded",
			"NUMBER": "Number",
			"OK": "OK",
			"ORDER_DETAIL_BY": "Order detail rows by",
			"PAGE": "Page",
			"PAGE_FOOTER": "Page Footer",
			"PAGE_HEADER": "Page Header",
			"PAGE_HEADER_FOOTER": "PAGE HEADER & FOOTER",
			"PAGE_UNITS": "UNITS",
			"PAGE_UNITS_INCHES": "inches",
			"PAGE_UNITS_MM": "mm",
			"PAPER_SIZE": "PAPER SIZE",
			"PAPER_SIZE_A3": "A3",
			"PAPER_SIZE_A3_LANDSCAPE": "A3 (landscape)",
			"PAPER_SIZE_A4": "A4",
			"PAPER_SIZE_A4_LANDSCAPE": "A4 (landscape)",
			"PAPER_SIZE_LEDGER": "Ledger",
			"PAPER_SIZE_LEGAL": "Legal",
			"PAPER_SIZE_LEGAL_LANDSCAPE": "Legal (landscape)",
			"PAPER_SIZE_LETTER": "Letter",
			"PAPER_SIZE_LETTER_LANDSCAPE": "Letter (landscape)",
			"PAPER_SIZE_TABLOID": "Tabloid",
			"PDF": "PDF",
			"PIVOT": "PIVOT (CROSS-TAB)",
			"PIVOT_BUCKET_DAY": "day",
			"PIVOT_BUCKET_MONTH": "month",
			"PIVOT_BUCKET_NONE": "none",
			"PIVOT_BUCKET_TYPE": "Pivot value bucket type",
			"PIVOT_BUCKET_YEAR": "year",
			"PIVOT_FIELD": "Pivot field",
			"PIVOT_FIELD_PLACEHOLDER": "(none)",
			"REPORT_FOOTER": "Report Footer",
			"REPORT_HEADER": "Report Header",
			"REPORT_HEADER_FOOTER": "REPORT HEADER & FOOTER",
			"RIGHT": "Right",
			"SAVE": "Save",
			"SAVE_SUBREPORT": "Save and return to main report",
			"SECTION_LABEL_GROUP_FOOTER": "Group {index} footer",
			"SECTION_LABEL_GROUP_FOOTER_NAMED": "{group_field} group footer",
			"SECTION_LABEL_GROUP_HEADER": "Group {index} header",
			"SECTION_LABEL_GROUP_HEADER_NAMED": "{group_field} group header",
			"SELECT_FIELD": "select a field",
			"SHOW_DETAIL": "Show detail section",
			"SHOW_PAGE_FOOTER": "Show page footer (PDF only)",
			"SHOW_PAGE_HEADER": "Show page header (PDF only)",
			"SHOW_REPORT_FOOTER": "Show report footer",
			"SHOW_REPORT_HEADER": "Show report header",
			"SUBLEVEL_DATA_SOURCE_LABEL": "Using data",
			"SUBLEVEL_GROUP_BY": "group by",
			"SUBLEVEL_GROUP_BY_FIRST": "Group by",
			"SUBLEVEL_MATCH_CHILD_FIELD_LABEL": "where",
			"SUBLEVEL_MATCH_CHILD_FIELD_PLACEHOLDER": "no filter",
			"SUBLEVEL_MATCH_PARENT_FIELD_LABEL": "equals parent's",
			"TABLE_CELL_TEXT": "Text",
			"TABLE_COLUMNS": "Columns",
			"TABLE_DATA_SOURCE": "Data source",
			"TABLE_HAS_HEADER": "Has header",
			"TABLE_HAS_FOOTER": "Has footer",
			"TEXT": "Text",
			"TOP": "Top",
			"Z_TO_A": "Z->A"
		}
	};

/***/ },
/* 113 */
/***/ function(module, exports, __webpack_require__) {

	/**
	 * lodash (Custom Build) <https://lodash.com/>
	 * Build: `lodash modularize exports="npm" -o ./`
	 * Copyright jQuery Foundation and other contributors <https://jquery.org/>
	 * Released under MIT license <https://lodash.com/license>
	 * Based on Underscore.js 1.8.3 <http://underscorejs.org/LICENSE>
	 * Copyright Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
	 */
	var baseClone = __webpack_require__(114),
	    isPlainObject = __webpack_require__(115),
	    keysIn = __webpack_require__(116),
	    rest = __webpack_require__(117),
	    root = __webpack_require__(118);

	/** Used as the size to enable large array optimizations. */
	var LARGE_ARRAY_SIZE = 200;

	/** Used to stand-in for `undefined` hash values. */
	var HASH_UNDEFINED = '__lodash_hash_undefined__';

	/** Used as references for various `Number` constants. */
	var MAX_SAFE_INTEGER = 9007199254740991;

	/** `Object#toString` result references. */
	var argsTag = '[object Arguments]',
	    arrayTag = '[object Array]',
	    boolTag = '[object Boolean]',
	    dateTag = '[object Date]',
	    errorTag = '[object Error]',
	    funcTag = '[object Function]',
	    genTag = '[object GeneratorFunction]',
	    mapTag = '[object Map]',
	    numberTag = '[object Number]',
	    objectTag = '[object Object]',
	    regexpTag = '[object RegExp]',
	    setTag = '[object Set]',
	    stringTag = '[object String]',
	    weakMapTag = '[object WeakMap]';

	var arrayBufferTag = '[object ArrayBuffer]',
	    dataViewTag = '[object DataView]',
	    float32Tag = '[object Float32Array]',
	    float64Tag = '[object Float64Array]',
	    int8Tag = '[object Int8Array]',
	    int16Tag = '[object Int16Array]',
	    int32Tag = '[object Int32Array]',
	    uint8Tag = '[object Uint8Array]',
	    uint8ClampedTag = '[object Uint8ClampedArray]',
	    uint16Tag = '[object Uint16Array]',
	    uint32Tag = '[object Uint32Array]';

	/**
	 * Used to match `RegExp`
	 * [syntax characters](http://ecma-international.org/ecma-262/6.0/#sec-patterns).
	 */
	var reRegExpChar = /[\\^$.*+?()[\]{}|]/g;

	/** Used to detect host constructors (Safari). */
	var reIsHostCtor = /^\[object .+?Constructor\]$/;

	/** Used to detect unsigned integer values. */
	var reIsUint = /^(?:0|[1-9]\d*)$/;

	/** Used to identify `toStringTag` values of typed arrays. */
	var typedArrayTags = {};
	typedArrayTags[float32Tag] = typedArrayTags[float64Tag] =
	typedArrayTags[int8Tag] = typedArrayTags[int16Tag] =
	typedArrayTags[int32Tag] = typedArrayTags[uint8Tag] =
	typedArrayTags[uint8ClampedTag] = typedArrayTags[uint16Tag] =
	typedArrayTags[uint32Tag] = true;
	typedArrayTags[argsTag] = typedArrayTags[arrayTag] =
	typedArrayTags[arrayBufferTag] = typedArrayTags[boolTag] =
	typedArrayTags[dataViewTag] = typedArrayTags[dateTag] =
	typedArrayTags[errorTag] = typedArrayTags[funcTag] =
	typedArrayTags[mapTag] = typedArrayTags[numberTag] =
	typedArrayTags[objectTag] = typedArrayTags[regexpTag] =
	typedArrayTags[setTag] = typedArrayTags[stringTag] =
	typedArrayTags[weakMapTag] = false;

	/**
	 * A specialized version of `_.forEach` for arrays without support for
	 * iteratee shorthands.
	 *
	 * @private
	 * @param {Array} array The array to iterate over.
	 * @param {Function} iteratee The function invoked per iteration.
	 * @returns {Array} Returns `array`.
	 */
	function arrayEach(array, iteratee) {
	  var index = -1,
	      length = array.length;

	  while (++index < length) {
	    if (iteratee(array[index], index, array) === false) {
	      break;
	    }
	  }
	  return array;
	}

	/**
	 * Checks if `value` is a host object in IE < 9.
	 *
	 * @private
	 * @param {*} value The value to check.
	 * @returns {boolean} Returns `true` if `value` is a host object, else `false`.
	 */
	function isHostObject(value) {
	  // Many host objects are `Object` objects that can coerce to strings
	  // despite having improperly defined `toString` methods.
	  var result = false;
	  if (value != null && typeof value.toString != 'function') {
	    try {
	      result = !!(value + '');
	    } catch (e) {}
	  }
	  return result;
	}

	/** Used for built-in method references. */
	var arrayProto = Array.prototype,
	    objectProto = Object.prototype;

	/** Used to resolve the decompiled source of functions. */
	var funcToString = Function.prototype.toString;

	/** Used to check objects for own properties. */
	var hasOwnProperty = objectProto.hasOwnProperty;

	/**
	 * Used to resolve the
	 * [`toStringTag`](http://ecma-international.org/ecma-262/6.0/#sec-object.prototype.tostring)
	 * of values.
	 */
	var objectToString = objectProto.toString;

	/** Used to detect if a method is native. */
	var reIsNative = RegExp('^' +
	  funcToString.call(hasOwnProperty).replace(reRegExpChar, '\\$&')
	  .replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g, '$1.*?') + '$'
	);

	/** Built-in value references. */
	var propertyIsEnumerable = objectProto.propertyIsEnumerable,
	    splice = arrayProto.splice;

	/* Built-in method references that are verified to be native. */
	var Map = getNative(root, 'Map'),
	    nativeCreate = getNative(Object, 'create');

	/**
	 * Creates a hash object.
	 *
	 * @private
	 * @constructor
	 * @param {Array} [entries] The key-value pairs to cache.
	 */
	function Hash(entries) {
	  var index = -1,
	      length = entries ? entries.length : 0;

	  this.clear();
	  while (++index < length) {
	    var entry = entries[index];
	    this.set(entry[0], entry[1]);
	  }
	}

	/**
	 * Removes all key-value entries from the hash.
	 *
	 * @private
	 * @name clear
	 * @memberOf Hash
	 */
	function hashClear() {
	  this.__data__ = nativeCreate ? nativeCreate(null) : {};
	}

	/**
	 * Removes `key` and its value from the hash.
	 *
	 * @private
	 * @name delete
	 * @memberOf Hash
	 * @param {Object} hash The hash to modify.
	 * @param {string} key The key of the value to remove.
	 * @returns {boolean} Returns `true` if the entry was removed, else `false`.
	 */
	function hashDelete(key) {
	  return this.has(key) && delete this.__data__[key];
	}

	/**
	 * Gets the hash value for `key`.
	 *
	 * @private
	 * @name get
	 * @memberOf Hash
	 * @param {string} key The key of the value to get.
	 * @returns {*} Returns the entry value.
	 */
	function hashGet(key) {
	  var data = this.__data__;
	  if (nativeCreate) {
	    var result = data[key];
	    return result === HASH_UNDEFINED ? undefined : result;
	  }
	  return hasOwnProperty.call(data, key) ? data[key] : undefined;
	}

	/**
	 * Checks if a hash value for `key` exists.
	 *
	 * @private
	 * @name has
	 * @memberOf Hash
	 * @param {string} key The key of the entry to check.
	 * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
	 */
	function hashHas(key) {
	  var data = this.__data__;
	  return nativeCreate ? data[key] !== undefined : hasOwnProperty.call(data, key);
	}

	/**
	 * Sets the hash `key` to `value`.
	 *
	 * @private
	 * @name set
	 * @memberOf Hash
	 * @param {string} key The key of the value to set.
	 * @param {*} value The value to set.
	 * @returns {Object} Returns the hash instance.
	 */
	function hashSet(key, value) {
	  var data = this.__data__;
	  data[key] = (nativeCreate && value === undefined) ? HASH_UNDEFINED : value;
	  return this;
	}

	// Add methods to `Hash`.
	Hash.prototype.clear = hashClear;
	Hash.prototype['delete'] = hashDelete;
	Hash.prototype.get = hashGet;
	Hash.prototype.has = hashHas;
	Hash.prototype.set = hashSet;

	/**
	 * Creates an list cache object.
	 *
	 * @private
	 * @constructor
	 * @param {Array} [entries] The key-value pairs to cache.
	 */
	function ListCache(entries) {
	  var index = -1,
	      length = entries ? entries.length : 0;

	  this.clear();
	  while (++index < length) {
	    var entry = entries[index];
	    this.set(entry[0], entry[1]);
	  }
	}

	/**
	 * Removes all key-value entries from the list cache.
	 *
	 * @private
	 * @name clear
	 * @memberOf ListCache
	 */
	function listCacheClear() {
	  this.__data__ = [];
	}

	/**
	 * Removes `key` and its value from the list cache.
	 *
	 * @private
	 * @name delete
	 * @memberOf ListCache
	 * @param {string} key The key of the value to remove.
	 * @returns {boolean} Returns `true` if the entry was removed, else `false`.
	 */
	function listCacheDelete(key) {
	  var data = this.__data__,
	      index = assocIndexOf(data, key);

	  if (index < 0) {
	    return false;
	  }
	  var lastIndex = data.length - 1;
	  if (index == lastIndex) {
	    data.pop();
	  } else {
	    splice.call(data, index, 1);
	  }
	  return true;
	}

	/**
	 * Gets the list cache value for `key`.
	 *
	 * @private
	 * @name get
	 * @memberOf ListCache
	 * @param {string} key The key of the value to get.
	 * @returns {*} Returns the entry value.
	 */
	function listCacheGet(key) {
	  var data = this.__data__,
	      index = assocIndexOf(data, key);

	  return index < 0 ? undefined : data[index][1];
	}

	/**
	 * Checks if a list cache value for `key` exists.
	 *
	 * @private
	 * @name has
	 * @memberOf ListCache
	 * @param {string} key The key of the entry to check.
	 * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
	 */
	function listCacheHas(key) {
	  return assocIndexOf(this.__data__, key) > -1;
	}

	/**
	 * Sets the list cache `key` to `value`.
	 *
	 * @private
	 * @name set
	 * @memberOf ListCache
	 * @param {string} key The key of the value to set.
	 * @param {*} value The value to set.
	 * @returns {Object} Returns the list cache instance.
	 */
	function listCacheSet(key, value) {
	  var data = this.__data__,
	      index = assocIndexOf(data, key);

	  if (index < 0) {
	    data.push([key, value]);
	  } else {
	    data[index][1] = value;
	  }
	  return this;
	}

	// Add methods to `ListCache`.
	ListCache.prototype.clear = listCacheClear;
	ListCache.prototype['delete'] = listCacheDelete;
	ListCache.prototype.get = listCacheGet;
	ListCache.prototype.has = listCacheHas;
	ListCache.prototype.set = listCacheSet;

	/**
	 * Creates a map cache object to store key-value pairs.
	 *
	 * @private
	 * @constructor
	 * @param {Array} [entries] The key-value pairs to cache.
	 */
	function MapCache(entries) {
	  var index = -1,
	      length = entries ? entries.length : 0;

	  this.clear();
	  while (++index < length) {
	    var entry = entries[index];
	    this.set(entry[0], entry[1]);
	  }
	}

	/**
	 * Removes all key-value entries from the map.
	 *
	 * @private
	 * @name clear
	 * @memberOf MapCache
	 */
	function mapCacheClear() {
	  this.__data__ = {
	    'hash': new Hash,
	    'map': new (Map || ListCache),
	    'string': new Hash
	  };
	}

	/**
	 * Removes `key` and its value from the map.
	 *
	 * @private
	 * @name delete
	 * @memberOf MapCache
	 * @param {string} key The key of the value to remove.
	 * @returns {boolean} Returns `true` if the entry was removed, else `false`.
	 */
	function mapCacheDelete(key) {
	  return getMapData(this, key)['delete'](key);
	}

	/**
	 * Gets the map value for `key`.
	 *
	 * @private
	 * @name get
	 * @memberOf MapCache
	 * @param {string} key The key of the value to get.
	 * @returns {*} Returns the entry value.
	 */
	function mapCacheGet(key) {
	  return getMapData(this, key).get(key);
	}

	/**
	 * Checks if a map value for `key` exists.
	 *
	 * @private
	 * @name has
	 * @memberOf MapCache
	 * @param {string} key The key of the entry to check.
	 * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
	 */
	function mapCacheHas(key) {
	  return getMapData(this, key).has(key);
	}

	/**
	 * Sets the map `key` to `value`.
	 *
	 * @private
	 * @name set
	 * @memberOf MapCache
	 * @param {string} key The key of the value to set.
	 * @param {*} value The value to set.
	 * @returns {Object} Returns the map cache instance.
	 */
	function mapCacheSet(key, value) {
	  getMapData(this, key).set(key, value);
	  return this;
	}

	// Add methods to `MapCache`.
	MapCache.prototype.clear = mapCacheClear;
	MapCache.prototype['delete'] = mapCacheDelete;
	MapCache.prototype.get = mapCacheGet;
	MapCache.prototype.has = mapCacheHas;
	MapCache.prototype.set = mapCacheSet;

	/**
	 * Creates a stack cache object to store key-value pairs.
	 *
	 * @private
	 * @constructor
	 * @param {Array} [entries] The key-value pairs to cache.
	 */
	function Stack(entries) {
	  this.__data__ = new ListCache(entries);
	}

	/**
	 * Removes all key-value entries from the stack.
	 *
	 * @private
	 * @name clear
	 * @memberOf Stack
	 */
	function stackClear() {
	  this.__data__ = new ListCache;
	}

	/**
	 * Removes `key` and its value from the stack.
	 *
	 * @private
	 * @name delete
	 * @memberOf Stack
	 * @param {string} key The key of the value to remove.
	 * @returns {boolean} Returns `true` if the entry was removed, else `false`.
	 */
	function stackDelete(key) {
	  return this.__data__['delete'](key);
	}

	/**
	 * Gets the stack value for `key`.
	 *
	 * @private
	 * @name get
	 * @memberOf Stack
	 * @param {string} key The key of the value to get.
	 * @returns {*} Returns the entry value.
	 */
	function stackGet(key) {
	  return this.__data__.get(key);
	}

	/**
	 * Checks if a stack value for `key` exists.
	 *
	 * @private
	 * @name has
	 * @memberOf Stack
	 * @param {string} key The key of the entry to check.
	 * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
	 */
	function stackHas(key) {
	  return this.__data__.has(key);
	}

	/**
	 * Sets the stack `key` to `value`.
	 *
	 * @private
	 * @name set
	 * @memberOf Stack
	 * @param {string} key The key of the value to set.
	 * @param {*} value The value to set.
	 * @returns {Object} Returns the stack cache instance.
	 */
	function stackSet(key, value) {
	  var cache = this.__data__;
	  if (cache instanceof ListCache && cache.__data__.length == LARGE_ARRAY_SIZE) {
	    cache = this.__data__ = new MapCache(cache.__data__);
	  }
	  cache.set(key, value);
	  return this;
	}

	// Add methods to `Stack`.
	Stack.prototype.clear = stackClear;
	Stack.prototype['delete'] = stackDelete;
	Stack.prototype.get = stackGet;
	Stack.prototype.has = stackHas;
	Stack.prototype.set = stackSet;

	/**
	 * This function is like `assignValue` except that it doesn't assign
	 * `undefined` values.
	 *
	 * @private
	 * @param {Object} object The object to modify.
	 * @param {string} key The key of the property to assign.
	 * @param {*} value The value to assign.
	 */
	function assignMergeValue(object, key, value) {
	  if ((value !== undefined && !eq(object[key], value)) ||
	      (typeof key == 'number' && value === undefined && !(key in object))) {
	    object[key] = value;
	  }
	}

	/**
	 * Assigns `value` to `key` of `object` if the existing value is not equivalent
	 * using [`SameValueZero`](http://ecma-international.org/ecma-262/6.0/#sec-samevaluezero)
	 * for equality comparisons.
	 *
	 * @private
	 * @param {Object} object The object to modify.
	 * @param {string} key The key of the property to assign.
	 * @param {*} value The value to assign.
	 */
	function assignValue(object, key, value) {
	  var objValue = object[key];
	  if (!(hasOwnProperty.call(object, key) && eq(objValue, value)) ||
	      (value === undefined && !(key in object))) {
	    object[key] = value;
	  }
	}

	/**
	 * Gets the index at which the `key` is found in `array` of key-value pairs.
	 *
	 * @private
	 * @param {Array} array The array to search.
	 * @param {*} key The key to search for.
	 * @returns {number} Returns the index of the matched value, else `-1`.
	 */
	function assocIndexOf(array, key) {
	  var length = array.length;
	  while (length--) {
	    if (eq(array[length][0], key)) {
	      return length;
	    }
	  }
	  return -1;
	}

	/**
	 * The base implementation of `_.merge` without support for multiple sources.
	 *
	 * @private
	 * @param {Object} object The destination object.
	 * @param {Object} source The source object.
	 * @param {number} srcIndex The index of `source`.
	 * @param {Function} [customizer] The function to customize merged values.
	 * @param {Object} [stack] Tracks traversed source values and their merged
	 *  counterparts.
	 */
	function baseMerge(object, source, srcIndex, customizer, stack) {
	  if (object === source) {
	    return;
	  }
	  if (!(isArray(source) || isTypedArray(source))) {
	    var props = keysIn(source);
	  }
	  arrayEach(props || source, function(srcValue, key) {
	    if (props) {
	      key = srcValue;
	      srcValue = source[key];
	    }
	    if (isObject(srcValue)) {
	      stack || (stack = new Stack);
	      baseMergeDeep(object, source, key, srcIndex, baseMerge, customizer, stack);
	    }
	    else {
	      var newValue = customizer
	        ? customizer(object[key], srcValue, (key + ''), object, source, stack)
	        : undefined;

	      if (newValue === undefined) {
	        newValue = srcValue;
	      }
	      assignMergeValue(object, key, newValue);
	    }
	  });
	}

	/**
	 * A specialized version of `baseMerge` for arrays and objects which performs
	 * deep merges and tracks traversed objects enabling objects with circular
	 * references to be merged.
	 *
	 * @private
	 * @param {Object} object The destination object.
	 * @param {Object} source The source object.
	 * @param {string} key The key of the value to merge.
	 * @param {number} srcIndex The index of `source`.
	 * @param {Function} mergeFunc The function to merge values.
	 * @param {Function} [customizer] The function to customize assigned values.
	 * @param {Object} [stack] Tracks traversed source values and their merged
	 *  counterparts.
	 */
	function baseMergeDeep(object, source, key, srcIndex, mergeFunc, customizer, stack) {
	  var objValue = object[key],
	      srcValue = source[key],
	      stacked = stack.get(srcValue);

	  if (stacked) {
	    assignMergeValue(object, key, stacked);
	    return;
	  }
	  var newValue = customizer
	    ? customizer(objValue, srcValue, (key + ''), object, source, stack)
	    : undefined;

	  var isCommon = newValue === undefined;

	  if (isCommon) {
	    newValue = srcValue;
	    if (isArray(srcValue) || isTypedArray(srcValue)) {
	      if (isArray(objValue)) {
	        newValue = objValue;
	      }
	      else if (isArrayLikeObject(objValue)) {
	        newValue = copyArray(objValue);
	      }
	      else {
	        isCommon = false;
	        newValue = baseClone(srcValue, true);
	      }
	    }
	    else if (isPlainObject(srcValue) || isArguments(srcValue)) {
	      if (isArguments(objValue)) {
	        newValue = toPlainObject(objValue);
	      }
	      else if (!isObject(objValue) || (srcIndex && isFunction(objValue))) {
	        isCommon = false;
	        newValue = baseClone(srcValue, true);
	      }
	      else {
	        newValue = objValue;
	      }
	    }
	    else {
	      isCommon = false;
	    }
	  }
	  stack.set(srcValue, newValue);

	  if (isCommon) {
	    // Recursively merge objects and arrays (susceptible to call stack limits).
	    mergeFunc(newValue, srcValue, srcIndex, customizer, stack);
	  }
	  stack['delete'](srcValue);
	  assignMergeValue(object, key, newValue);
	}

	/**
	 * The base implementation of `_.property` without support for deep paths.
	 *
	 * @private
	 * @param {string} key The key of the property to get.
	 * @returns {Function} Returns the new accessor function.
	 */
	function baseProperty(key) {
	  return function(object) {
	    return object == null ? undefined : object[key];
	  };
	}

	/**
	 * Copies the values of `source` to `array`.
	 *
	 * @private
	 * @param {Array} source The array to copy values from.
	 * @param {Array} [array=[]] The array to copy values to.
	 * @returns {Array} Returns `array`.
	 */
	function copyArray(source, array) {
	  var index = -1,
	      length = source.length;

	  array || (array = Array(length));
	  while (++index < length) {
	    array[index] = source[index];
	  }
	  return array;
	}

	/**
	 * Copies properties of `source` to `object`.
	 *
	 * @private
	 * @param {Object} source The object to copy properties from.
	 * @param {Array} props The property identifiers to copy.
	 * @param {Object} [object={}] The object to copy properties to.
	 * @param {Function} [customizer] The function to customize copied values.
	 * @returns {Object} Returns `object`.
	 */
	function copyObject(source, props, object, customizer) {
	  object || (object = {});

	  var index = -1,
	      length = props.length;

	  while (++index < length) {
	    var key = props[index];

	    var newValue = customizer
	      ? customizer(object[key], source[key], key, object, source)
	      : source[key];

	    assignValue(object, key, newValue);
	  }
	  return object;
	}

	/**
	 * Creates a function like `_.assign`.
	 *
	 * @private
	 * @param {Function} assigner The function to assign values.
	 * @returns {Function} Returns the new assigner function.
	 */
	function createAssigner(assigner) {
	  return rest(function(object, sources) {
	    var index = -1,
	        length = sources.length,
	        customizer = length > 1 ? sources[length - 1] : undefined,
	        guard = length > 2 ? sources[2] : undefined;

	    customizer = (assigner.length > 3 && typeof customizer == 'function')
	      ? (length--, customizer)
	      : undefined;

	    if (guard && isIterateeCall(sources[0], sources[1], guard)) {
	      customizer = length < 3 ? undefined : customizer;
	      length = 1;
	    }
	    object = Object(object);
	    while (++index < length) {
	      var source = sources[index];
	      if (source) {
	        assigner(object, source, index, customizer);
	      }
	    }
	    return object;
	  });
	}

	/**
	 * Gets the "length" property value of `object`.
	 *
	 * **Note:** This function is used to avoid a
	 * [JIT bug](https://bugs.webkit.org/show_bug.cgi?id=142792) that affects
	 * Safari on at least iOS 8.1-8.3 ARM64.
	 *
	 * @private
	 * @param {Object} object The object to query.
	 * @returns {*} Returns the "length" value.
	 */
	var getLength = baseProperty('length');

	/**
	 * Gets the data for `map`.
	 *
	 * @private
	 * @param {Object} map The map to query.
	 * @param {string} key The reference key.
	 * @returns {*} Returns the map data.
	 */
	function getMapData(map, key) {
	  var data = map.__data__;
	  return isKeyable(key)
	    ? data[typeof key == 'string' ? 'string' : 'hash']
	    : data.map;
	}

	/**
	 * Gets the native function at `key` of `object`.
	 *
	 * @private
	 * @param {Object} object The object to query.
	 * @param {string} key The key of the method to get.
	 * @returns {*} Returns the function if it's native, else `undefined`.
	 */
	function getNative(object, key) {
	  var value = object[key];
	  return isNative(value) ? value : undefined;
	}

	/**
	 * Checks if `value` is a valid array-like index.
	 *
	 * @private
	 * @param {*} value The value to check.
	 * @param {number} [length=MAX_SAFE_INTEGER] The upper bounds of a valid index.
	 * @returns {boolean} Returns `true` if `value` is a valid index, else `false`.
	 */
	function isIndex(value, length) {
	  length = length == null ? MAX_SAFE_INTEGER : length;
	  return !!length &&
	    (typeof value == 'number' || reIsUint.test(value)) &&
	    (value > -1 && value % 1 == 0 && value < length);
	}

	/**
	 * Checks if the given arguments are from an iteratee call.
	 *
	 * @private
	 * @param {*} value The potential iteratee value argument.
	 * @param {*} index The potential iteratee index or key argument.
	 * @param {*} object The potential iteratee object argument.
	 * @returns {boolean} Returns `true` if the arguments are from an iteratee call,
	 *  else `false`.
	 */
	function isIterateeCall(value, index, object) {
	  if (!isObject(object)) {
	    return false;
	  }
	  var type = typeof index;
	  if (type == 'number'
	        ? (isArrayLike(object) && isIndex(index, object.length))
	        : (type == 'string' && index in object)
	      ) {
	    return eq(object[index], value);
	  }
	  return false;
	}

	/**
	 * Checks if `value` is suitable for use as unique object key.
	 *
	 * @private
	 * @param {*} value The value to check.
	 * @returns {boolean} Returns `true` if `value` is suitable, else `false`.
	 */
	function isKeyable(value) {
	  var type = typeof value;
	  return (type == 'string' || type == 'number' || type == 'symbol' || type == 'boolean')
	    ? (value !== '__proto__')
	    : (value === null);
	}

	/**
	 * Converts `func` to its source code.
	 *
	 * @private
	 * @param {Function} func The function to process.
	 * @returns {string} Returns the source code.
	 */
	function toSource(func) {
	  if (func != null) {
	    try {
	      return funcToString.call(func);
	    } catch (e) {}
	    try {
	      return (func + '');
	    } catch (e) {}
	  }
	  return '';
	}

	/**
	 * Performs a
	 * [`SameValueZero`](http://ecma-international.org/ecma-262/6.0/#sec-samevaluezero)
	 * comparison between two values to determine if they are equivalent.
	 *
	 * @static
	 * @memberOf _
	 * @since 4.0.0
	 * @category Lang
	 * @param {*} value The value to compare.
	 * @param {*} other The other value to compare.
	 * @returns {boolean} Returns `true` if the values are equivalent, else `false`.
	 * @example
	 *
	 * var object = { 'user': 'fred' };
	 * var other = { 'user': 'fred' };
	 *
	 * _.eq(object, object);
	 * // => true
	 *
	 * _.eq(object, other);
	 * // => false
	 *
	 * _.eq('a', 'a');
	 * // => true
	 *
	 * _.eq('a', Object('a'));
	 * // => false
	 *
	 * _.eq(NaN, NaN);
	 * // => true
	 */
	function eq(value, other) {
	  return value === other || (value !== value && other !== other);
	}

	/**
	 * Checks if `value` is likely an `arguments` object.
	 *
	 * @static
	 * @memberOf _
	 * @since 0.1.0
	 * @category Lang
	 * @param {*} value The value to check.
	 * @returns {boolean} Returns `true` if `value` is correctly classified,
	 *  else `false`.
	 * @example
	 *
	 * _.isArguments(function() { return arguments; }());
	 * // => true
	 *
	 * _.isArguments([1, 2, 3]);
	 * // => false
	 */
	function isArguments(value) {
	  // Safari 8.1 incorrectly makes `arguments.callee` enumerable in strict mode.
	  return isArrayLikeObject(value) && hasOwnProperty.call(value, 'callee') &&
	    (!propertyIsEnumerable.call(value, 'callee') || objectToString.call(value) == argsTag);
	}

	/**
	 * Checks if `value` is classified as an `Array` object.
	 *
	 * @static
	 * @memberOf _
	 * @since 0.1.0
	 * @type {Function}
	 * @category Lang
	 * @param {*} value The value to check.
	 * @returns {boolean} Returns `true` if `value` is correctly classified,
	 *  else `false`.
	 * @example
	 *
	 * _.isArray([1, 2, 3]);
	 * // => true
	 *
	 * _.isArray(document.body.children);
	 * // => false
	 *
	 * _.isArray('abc');
	 * // => false
	 *
	 * _.isArray(_.noop);
	 * // => false
	 */
	var isArray = Array.isArray;

	/**
	 * Checks if `value` is array-like. A value is considered array-like if it's
	 * not a function and has a `value.length` that's an integer greater than or
	 * equal to `0` and less than or equal to `Number.MAX_SAFE_INTEGER`.
	 *
	 * @static
	 * @memberOf _
	 * @since 4.0.0
	 * @category Lang
	 * @param {*} value The value to check.
	 * @returns {boolean} Returns `true` if `value` is array-like, else `false`.
	 * @example
	 *
	 * _.isArrayLike([1, 2, 3]);
	 * // => true
	 *
	 * _.isArrayLike(document.body.children);
	 * // => true
	 *
	 * _.isArrayLike('abc');
	 * // => true
	 *
	 * _.isArrayLike(_.noop);
	 * // => false
	 */
	function isArrayLike(value) {
	  return value != null && isLength(getLength(value)) && !isFunction(value);
	}

	/**
	 * This method is like `_.isArrayLike` except that it also checks if `value`
	 * is an object.
	 *
	 * @static
	 * @memberOf _
	 * @since 4.0.0
	 * @category Lang
	 * @param {*} value The value to check.
	 * @returns {boolean} Returns `true` if `value` is an array-like object,
	 *  else `false`.
	 * @example
	 *
	 * _.isArrayLikeObject([1, 2, 3]);
	 * // => true
	 *
	 * _.isArrayLikeObject(document.body.children);
	 * // => true
	 *
	 * _.isArrayLikeObject('abc');
	 * // => false
	 *
	 * _.isArrayLikeObject(_.noop);
	 * // => false
	 */
	function isArrayLikeObject(value) {
	  return isObjectLike(value) && isArrayLike(value);
	}

	/**
	 * Checks if `value` is classified as a `Function` object.
	 *
	 * @static
	 * @memberOf _
	 * @since 0.1.0
	 * @category Lang
	 * @param {*} value The value to check.
	 * @returns {boolean} Returns `true` if `value` is correctly classified,
	 *  else `false`.
	 * @example
	 *
	 * _.isFunction(_);
	 * // => true
	 *
	 * _.isFunction(/abc/);
	 * // => false
	 */
	function isFunction(value) {
	  // The use of `Object#toString` avoids issues with the `typeof` operator
	  // in Safari 8 which returns 'object' for typed array and weak map constructors,
	  // and PhantomJS 1.9 which returns 'function' for `NodeList` instances.
	  var tag = isObject(value) ? objectToString.call(value) : '';
	  return tag == funcTag || tag == genTag;
	}

	/**
	 * Checks if `value` is a valid array-like length.
	 *
	 * **Note:** This function is loosely based on
	 * [`ToLength`](http://ecma-international.org/ecma-262/6.0/#sec-tolength).
	 *
	 * @static
	 * @memberOf _
	 * @since 4.0.0
	 * @category Lang
	 * @param {*} value The value to check.
	 * @returns {boolean} Returns `true` if `value` is a valid length,
	 *  else `false`.
	 * @example
	 *
	 * _.isLength(3);
	 * // => true
	 *
	 * _.isLength(Number.MIN_VALUE);
	 * // => false
	 *
	 * _.isLength(Infinity);
	 * // => false
	 *
	 * _.isLength('3');
	 * // => false
	 */
	function isLength(value) {
	  return typeof value == 'number' &&
	    value > -1 && value % 1 == 0 && value <= MAX_SAFE_INTEGER;
	}

	/**
	 * Checks if `value` is the
	 * [language type](http://www.ecma-international.org/ecma-262/6.0/#sec-ecmascript-language-types)
	 * of `Object`. (e.g. arrays, functions, objects, regexes, `new Number(0)`, and `new String('')`)
	 *
	 * @static
	 * @memberOf _
	 * @since 0.1.0
	 * @category Lang
	 * @param {*} value The value to check.
	 * @returns {boolean} Returns `true` if `value` is an object, else `false`.
	 * @example
	 *
	 * _.isObject({});
	 * // => true
	 *
	 * _.isObject([1, 2, 3]);
	 * // => true
	 *
	 * _.isObject(_.noop);
	 * // => true
	 *
	 * _.isObject(null);
	 * // => false
	 */
	function isObject(value) {
	  var type = typeof value;
	  return !!value && (type == 'object' || type == 'function');
	}

	/**
	 * Checks if `value` is object-like. A value is object-like if it's not `null`
	 * and has a `typeof` result of "object".
	 *
	 * @static
	 * @memberOf _
	 * @since 4.0.0
	 * @category Lang
	 * @param {*} value The value to check.
	 * @returns {boolean} Returns `true` if `value` is object-like, else `false`.
	 * @example
	 *
	 * _.isObjectLike({});
	 * // => true
	 *
	 * _.isObjectLike([1, 2, 3]);
	 * // => true
	 *
	 * _.isObjectLike(_.noop);
	 * // => false
	 *
	 * _.isObjectLike(null);
	 * // => false
	 */
	function isObjectLike(value) {
	  return !!value && typeof value == 'object';
	}

	/**
	 * Checks if `value` is a native function.
	 *
	 * @static
	 * @memberOf _
	 * @since 3.0.0
	 * @category Lang
	 * @param {*} value The value to check.
	 * @returns {boolean} Returns `true` if `value` is a native function,
	 *  else `false`.
	 * @example
	 *
	 * _.isNative(Array.prototype.push);
	 * // => true
	 *
	 * _.isNative(_);
	 * // => false
	 */
	function isNative(value) {
	  if (!isObject(value)) {
	    return false;
	  }
	  var pattern = (isFunction(value) || isHostObject(value)) ? reIsNative : reIsHostCtor;
	  return pattern.test(toSource(value));
	}

	/**
	 * Checks if `value` is classified as a typed array.
	 *
	 * @static
	 * @memberOf _
	 * @since 3.0.0
	 * @category Lang
	 * @param {*} value The value to check.
	 * @returns {boolean} Returns `true` if `value` is correctly classified,
	 *  else `false`.
	 * @example
	 *
	 * _.isTypedArray(new Uint8Array);
	 * // => true
	 *
	 * _.isTypedArray([]);
	 * // => false
	 */
	function isTypedArray(value) {
	  return isObjectLike(value) &&
	    isLength(value.length) && !!typedArrayTags[objectToString.call(value)];
	}

	/**
	 * Converts `value` to a plain object flattening inherited enumerable string
	 * keyed properties of `value` to own properties of the plain object.
	 *
	 * @static
	 * @memberOf _
	 * @since 3.0.0
	 * @category Lang
	 * @param {*} value The value to convert.
	 * @returns {Object} Returns the converted plain object.
	 * @example
	 *
	 * function Foo() {
	 *   this.b = 2;
	 * }
	 *
	 * Foo.prototype.c = 3;
	 *
	 * _.assign({ 'a': 1 }, new Foo);
	 * // => { 'a': 1, 'b': 2 }
	 *
	 * _.assign({ 'a': 1 }, _.toPlainObject(new Foo));
	 * // => { 'a': 1, 'b': 2, 'c': 3 }
	 */
	function toPlainObject(value) {
	  return copyObject(value, keysIn(value));
	}

	/**
	 * This method is like `_.assign` except that it recursively merges own and
	 * inherited enumerable string keyed properties of source objects into the
	 * destination object. Source properties that resolve to `undefined` are
	 * skipped if a destination value exists. Array and plain object properties
	 * are merged recursively. Other objects and value types are overridden by
	 * assignment. Source objects are applied from left to right. Subsequent
	 * sources overwrite property assignments of previous sources.
	 *
	 * **Note:** This method mutates `object`.
	 *
	 * @static
	 * @memberOf _
	 * @since 0.5.0
	 * @category Object
	 * @param {Object} object The destination object.
	 * @param {...Object} [sources] The source objects.
	 * @returns {Object} Returns `object`.
	 * @example
	 *
	 * var users = {
	 *   'data': [{ 'user': 'barney' }, { 'user': 'fred' }]
	 * };
	 *
	 * var ages = {
	 *   'data': [{ 'age': 36 }, { 'age': 40 }]
	 * };
	 *
	 * _.merge(users, ages);
	 * // => { 'data': [{ 'user': 'barney', 'age': 36 }, { 'user': 'fred', 'age': 40 }] }
	 */
	var merge = createAssigner(function(object, source, srcIndex) {
	  baseMerge(object, source, srcIndex);
	});

	module.exports = merge;


/***/ },
/* 114 */
/***/ function(module, exports, __webpack_require__) {

	/* WEBPACK VAR INJECTION */(function(module) {/**
	 * lodash (Custom Build) <https://lodash.com/>
	 * Build: `lodash modularize exports="npm" -o ./`
	 * Copyright jQuery Foundation and other contributors <https://jquery.org/>
	 * Released under MIT license <https://lodash.com/license>
	 * Based on Underscore.js 1.8.3 <http://underscorejs.org/LICENSE>
	 * Copyright Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
	 */

	/** Used as the size to enable large array optimizations. */
	var LARGE_ARRAY_SIZE = 200;

	/** Used to stand-in for `undefined` hash values. */
	var HASH_UNDEFINED = '__lodash_hash_undefined__';

	/** Used as references for various `Number` constants. */
	var MAX_SAFE_INTEGER = 9007199254740991;

	/** `Object#toString` result references. */
	var argsTag = '[object Arguments]',
	    arrayTag = '[object Array]',
	    boolTag = '[object Boolean]',
	    dateTag = '[object Date]',
	    errorTag = '[object Error]',
	    funcTag = '[object Function]',
	    genTag = '[object GeneratorFunction]',
	    mapTag = '[object Map]',
	    numberTag = '[object Number]',
	    objectTag = '[object Object]',
	    promiseTag = '[object Promise]',
	    regexpTag = '[object RegExp]',
	    setTag = '[object Set]',
	    stringTag = '[object String]',
	    symbolTag = '[object Symbol]',
	    weakMapTag = '[object WeakMap]';

	var arrayBufferTag = '[object ArrayBuffer]',
	    dataViewTag = '[object DataView]',
	    float32Tag = '[object Float32Array]',
	    float64Tag = '[object Float64Array]',
	    int8Tag = '[object Int8Array]',
	    int16Tag = '[object Int16Array]',
	    int32Tag = '[object Int32Array]',
	    uint8Tag = '[object Uint8Array]',
	    uint8ClampedTag = '[object Uint8ClampedArray]',
	    uint16Tag = '[object Uint16Array]',
	    uint32Tag = '[object Uint32Array]';

	/**
	 * Used to match `RegExp`
	 * [syntax characters](http://ecma-international.org/ecma-262/6.0/#sec-patterns).
	 */
	var reRegExpChar = /[\\^$.*+?()[\]{}|]/g;

	/** Used to match `RegExp` flags from their coerced string values. */
	var reFlags = /\w*$/;

	/** Used to detect host constructors (Safari). */
	var reIsHostCtor = /^\[object .+?Constructor\]$/;

	/** Used to detect unsigned integer values. */
	var reIsUint = /^(?:0|[1-9]\d*)$/;

	/** Used to identify `toStringTag` values supported by `_.clone`. */
	var cloneableTags = {};
	cloneableTags[argsTag] = cloneableTags[arrayTag] =
	cloneableTags[arrayBufferTag] = cloneableTags[dataViewTag] =
	cloneableTags[boolTag] = cloneableTags[dateTag] =
	cloneableTags[float32Tag] = cloneableTags[float64Tag] =
	cloneableTags[int8Tag] = cloneableTags[int16Tag] =
	cloneableTags[int32Tag] = cloneableTags[mapTag] =
	cloneableTags[numberTag] = cloneableTags[objectTag] =
	cloneableTags[regexpTag] = cloneableTags[setTag] =
	cloneableTags[stringTag] = cloneableTags[symbolTag] =
	cloneableTags[uint8Tag] = cloneableTags[uint8ClampedTag] =
	cloneableTags[uint16Tag] = cloneableTags[uint32Tag] = true;
	cloneableTags[errorTag] = cloneableTags[funcTag] =
	cloneableTags[weakMapTag] = false;

	/** Used to determine if values are of the language type `Object`. */
	var objectTypes = {
	  'function': true,
	  'object': true
	};

	/** Detect free variable `exports`. */
	var freeExports = (objectTypes[typeof exports] && exports && !exports.nodeType)
	  ? exports
	  : undefined;

	/** Detect free variable `module`. */
	var freeModule = (objectTypes[typeof module] && module && !module.nodeType)
	  ? module
	  : undefined;

	/** Detect the popular CommonJS extension `module.exports`. */
	var moduleExports = (freeModule && freeModule.exports === freeExports)
	  ? freeExports
	  : undefined;

	/** Detect free variable `global` from Node.js. */
	var freeGlobal = checkGlobal(freeExports && freeModule && typeof global == 'object' && global);

	/** Detect free variable `self`. */
	var freeSelf = checkGlobal(objectTypes[typeof self] && self);

	/** Detect free variable `window`. */
	var freeWindow = checkGlobal(objectTypes[typeof window] && window);

	/** Detect `this` as the global object. */
	var thisGlobal = checkGlobal(objectTypes[typeof this] && this);

	/**
	 * Used as a reference to the global object.
	 *
	 * The `this` value is used if it's the global object to avoid Greasemonkey's
	 * restricted `window` object, otherwise the `window` object is used.
	 */
	var root = freeGlobal ||
	  ((freeWindow !== (thisGlobal && thisGlobal.window)) && freeWindow) ||
	    freeSelf || thisGlobal || Function('return this')();

	/**
	 * Adds the key-value `pair` to `map`.
	 *
	 * @private
	 * @param {Object} map The map to modify.
	 * @param {Array} pair The key-value pair to add.
	 * @returns {Object} Returns `map`.
	 */
	function addMapEntry(map, pair) {
	  // Don't return `Map#set` because it doesn't return the map instance in IE 11.
	  map.set(pair[0], pair[1]);
	  return map;
	}

	/**
	 * Adds `value` to `set`.
	 *
	 * @private
	 * @param {Object} set The set to modify.
	 * @param {*} value The value to add.
	 * @returns {Object} Returns `set`.
	 */
	function addSetEntry(set, value) {
	  set.add(value);
	  return set;
	}

	/**
	 * A specialized version of `_.forEach` for arrays without support for
	 * iteratee shorthands.
	 *
	 * @private
	 * @param {Array} array The array to iterate over.
	 * @param {Function} iteratee The function invoked per iteration.
	 * @returns {Array} Returns `array`.
	 */
	function arrayEach(array, iteratee) {
	  var index = -1,
	      length = array.length;

	  while (++index < length) {
	    if (iteratee(array[index], index, array) === false) {
	      break;
	    }
	  }
	  return array;
	}

	/**
	 * Appends the elements of `values` to `array`.
	 *
	 * @private
	 * @param {Array} array The array to modify.
	 * @param {Array} values The values to append.
	 * @returns {Array} Returns `array`.
	 */
	function arrayPush(array, values) {
	  var index = -1,
	      length = values.length,
	      offset = array.length;

	  while (++index < length) {
	    array[offset + index] = values[index];
	  }
	  return array;
	}

	/**
	 * A specialized version of `_.reduce` for arrays without support for
	 * iteratee shorthands.
	 *
	 * @private
	 * @param {Array} array The array to iterate over.
	 * @param {Function} iteratee The function invoked per iteration.
	 * @param {*} [accumulator] The initial value.
	 * @param {boolean} [initAccum] Specify using the first element of `array` as
	 *  the initial value.
	 * @returns {*} Returns the accumulated value.
	 */
	function arrayReduce(array, iteratee, accumulator, initAccum) {
	  var index = -1,
	      length = array.length;

	  if (initAccum && length) {
	    accumulator = array[++index];
	  }
	  while (++index < length) {
	    accumulator = iteratee(accumulator, array[index], index, array);
	  }
	  return accumulator;
	}

	/**
	 * The base implementation of `_.times` without support for iteratee shorthands
	 * or max array length checks.
	 *
	 * @private
	 * @param {number} n The number of times to invoke `iteratee`.
	 * @param {Function} iteratee The function invoked per iteration.
	 * @returns {Array} Returns the array of results.
	 */
	function baseTimes(n, iteratee) {
	  var index = -1,
	      result = Array(n);

	  while (++index < n) {
	    result[index] = iteratee(index);
	  }
	  return result;
	}

	/**
	 * Checks if `value` is a global object.
	 *
	 * @private
	 * @param {*} value The value to check.
	 * @returns {null|Object} Returns `value` if it's a global object, else `null`.
	 */
	function checkGlobal(value) {
	  return (value && value.Object === Object) ? value : null;
	}

	/**
	 * Checks if `value` is a host object in IE < 9.
	 *
	 * @private
	 * @param {*} value The value to check.
	 * @returns {boolean} Returns `true` if `value` is a host object, else `false`.
	 */
	function isHostObject(value) {
	  // Many host objects are `Object` objects that can coerce to strings
	  // despite having improperly defined `toString` methods.
	  var result = false;
	  if (value != null && typeof value.toString != 'function') {
	    try {
	      result = !!(value + '');
	    } catch (e) {}
	  }
	  return result;
	}

	/**
	 * Converts `map` to its key-value pairs.
	 *
	 * @private
	 * @param {Object} map The map to convert.
	 * @returns {Array} Returns the key-value pairs.
	 */
	function mapToArray(map) {
	  var index = -1,
	      result = Array(map.size);

	  map.forEach(function(value, key) {
	    result[++index] = [key, value];
	  });
	  return result;
	}

	/**
	 * Converts `set` to an array of its values.
	 *
	 * @private
	 * @param {Object} set The set to convert.
	 * @returns {Array} Returns the values.
	 */
	function setToArray(set) {
	  var index = -1,
	      result = Array(set.size);

	  set.forEach(function(value) {
	    result[++index] = value;
	  });
	  return result;
	}

	/** Used for built-in method references. */
	var arrayProto = Array.prototype,
	    objectProto = Object.prototype;

	/** Used to resolve the decompiled source of functions. */
	var funcToString = Function.prototype.toString;

	/** Used to check objects for own properties. */
	var hasOwnProperty = objectProto.hasOwnProperty;

	/**
	 * Used to resolve the
	 * [`toStringTag`](http://ecma-international.org/ecma-262/6.0/#sec-object.prototype.tostring)
	 * of values.
	 */
	var objectToString = objectProto.toString;

	/** Used to detect if a method is native. */
	var reIsNative = RegExp('^' +
	  funcToString.call(hasOwnProperty).replace(reRegExpChar, '\\$&')
	  .replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g, '$1.*?') + '$'
	);

	/** Built-in value references. */
	var Buffer = moduleExports ? root.Buffer : undefined,
	    Symbol = root.Symbol,
	    Uint8Array = root.Uint8Array,
	    getOwnPropertySymbols = Object.getOwnPropertySymbols,
	    objectCreate = Object.create,
	    propertyIsEnumerable = objectProto.propertyIsEnumerable,
	    splice = arrayProto.splice;

	/* Built-in method references for those with the same name as other `lodash` methods. */
	var nativeGetPrototype = Object.getPrototypeOf,
	    nativeKeys = Object.keys;

	/* Built-in method references that are verified to be native. */
	var DataView = getNative(root, 'DataView'),
	    Map = getNative(root, 'Map'),
	    Promise = getNative(root, 'Promise'),
	    Set = getNative(root, 'Set'),
	    WeakMap = getNative(root, 'WeakMap'),
	    nativeCreate = getNative(Object, 'create');

	/** Used to detect maps, sets, and weakmaps. */
	var dataViewCtorString = toSource(DataView),
	    mapCtorString = toSource(Map),
	    promiseCtorString = toSource(Promise),
	    setCtorString = toSource(Set),
	    weakMapCtorString = toSource(WeakMap);

	/** Used to convert symbols to primitives and strings. */
	var symbolProto = Symbol ? Symbol.prototype : undefined,
	    symbolValueOf = symbolProto ? symbolProto.valueOf : undefined;

	/**
	 * Creates a hash object.
	 *
	 * @private
	 * @constructor
	 * @param {Array} [entries] The key-value pairs to cache.
	 */
	function Hash(entries) {
	  var index = -1,
	      length = entries ? entries.length : 0;

	  this.clear();
	  while (++index < length) {
	    var entry = entries[index];
	    this.set(entry[0], entry[1]);
	  }
	}

	/**
	 * Removes all key-value entries from the hash.
	 *
	 * @private
	 * @name clear
	 * @memberOf Hash
	 */
	function hashClear() {
	  this.__data__ = nativeCreate ? nativeCreate(null) : {};
	}

	/**
	 * Removes `key` and its value from the hash.
	 *
	 * @private
	 * @name delete
	 * @memberOf Hash
	 * @param {Object} hash The hash to modify.
	 * @param {string} key The key of the value to remove.
	 * @returns {boolean} Returns `true` if the entry was removed, else `false`.
	 */
	function hashDelete(key) {
	  return this.has(key) && delete this.__data__[key];
	}

	/**
	 * Gets the hash value for `key`.
	 *
	 * @private
	 * @name get
	 * @memberOf Hash
	 * @param {string} key The key of the value to get.
	 * @returns {*} Returns the entry value.
	 */
	function hashGet(key) {
	  var data = this.__data__;
	  if (nativeCreate) {
	    var result = data[key];
	    return result === HASH_UNDEFINED ? undefined : result;
	  }
	  return hasOwnProperty.call(data, key) ? data[key] : undefined;
	}

	/**
	 * Checks if a hash value for `key` exists.
	 *
	 * @private
	 * @name has
	 * @memberOf Hash
	 * @param {string} key The key of the entry to check.
	 * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
	 */
	function hashHas(key) {
	  var data = this.__data__;
	  return nativeCreate ? data[key] !== undefined : hasOwnProperty.call(data, key);
	}

	/**
	 * Sets the hash `key` to `value`.
	 *
	 * @private
	 * @name set
	 * @memberOf Hash
	 * @param {string} key The key of the value to set.
	 * @param {*} value The value to set.
	 * @returns {Object} Returns the hash instance.
	 */
	function hashSet(key, value) {
	  var data = this.__data__;
	  data[key] = (nativeCreate && value === undefined) ? HASH_UNDEFINED : value;
	  return this;
	}

	// Add methods to `Hash`.
	Hash.prototype.clear = hashClear;
	Hash.prototype['delete'] = hashDelete;
	Hash.prototype.get = hashGet;
	Hash.prototype.has = hashHas;
	Hash.prototype.set = hashSet;

	/**
	 * Creates an list cache object.
	 *
	 * @private
	 * @constructor
	 * @param {Array} [entries] The key-value pairs to cache.
	 */
	function ListCache(entries) {
	  var index = -1,
	      length = entries ? entries.length : 0;

	  this.clear();
	  while (++index < length) {
	    var entry = entries[index];
	    this.set(entry[0], entry[1]);
	  }
	}

	/**
	 * Removes all key-value entries from the list cache.
	 *
	 * @private
	 * @name clear
	 * @memberOf ListCache
	 */
	function listCacheClear() {
	  this.__data__ = [];
	}

	/**
	 * Removes `key` and its value from the list cache.
	 *
	 * @private
	 * @name delete
	 * @memberOf ListCache
	 * @param {string} key The key of the value to remove.
	 * @returns {boolean} Returns `true` if the entry was removed, else `false`.
	 */
	function listCacheDelete(key) {
	  var data = this.__data__,
	      index = assocIndexOf(data, key);

	  if (index < 0) {
	    return false;
	  }
	  var lastIndex = data.length - 1;
	  if (index == lastIndex) {
	    data.pop();
	  } else {
	    splice.call(data, index, 1);
	  }
	  return true;
	}

	/**
	 * Gets the list cache value for `key`.
	 *
	 * @private
	 * @name get
	 * @memberOf ListCache
	 * @param {string} key The key of the value to get.
	 * @returns {*} Returns the entry value.
	 */
	function listCacheGet(key) {
	  var data = this.__data__,
	      index = assocIndexOf(data, key);

	  return index < 0 ? undefined : data[index][1];
	}

	/**
	 * Checks if a list cache value for `key` exists.
	 *
	 * @private
	 * @name has
	 * @memberOf ListCache
	 * @param {string} key The key of the entry to check.
	 * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
	 */
	function listCacheHas(key) {
	  return assocIndexOf(this.__data__, key) > -1;
	}

	/**
	 * Sets the list cache `key` to `value`.
	 *
	 * @private
	 * @name set
	 * @memberOf ListCache
	 * @param {string} key The key of the value to set.
	 * @param {*} value The value to set.
	 * @returns {Object} Returns the list cache instance.
	 */
	function listCacheSet(key, value) {
	  var data = this.__data__,
	      index = assocIndexOf(data, key);

	  if (index < 0) {
	    data.push([key, value]);
	  } else {
	    data[index][1] = value;
	  }
	  return this;
	}

	// Add methods to `ListCache`.
	ListCache.prototype.clear = listCacheClear;
	ListCache.prototype['delete'] = listCacheDelete;
	ListCache.prototype.get = listCacheGet;
	ListCache.prototype.has = listCacheHas;
	ListCache.prototype.set = listCacheSet;

	/**
	 * Creates a map cache object to store key-value pairs.
	 *
	 * @private
	 * @constructor
	 * @param {Array} [entries] The key-value pairs to cache.
	 */
	function MapCache(entries) {
	  var index = -1,
	      length = entries ? entries.length : 0;

	  this.clear();
	  while (++index < length) {
	    var entry = entries[index];
	    this.set(entry[0], entry[1]);
	  }
	}

	/**
	 * Removes all key-value entries from the map.
	 *
	 * @private
	 * @name clear
	 * @memberOf MapCache
	 */
	function mapCacheClear() {
	  this.__data__ = {
	    'hash': new Hash,
	    'map': new (Map || ListCache),
	    'string': new Hash
	  };
	}

	/**
	 * Removes `key` and its value from the map.
	 *
	 * @private
	 * @name delete
	 * @memberOf MapCache
	 * @param {string} key The key of the value to remove.
	 * @returns {boolean} Returns `true` if the entry was removed, else `false`.
	 */
	function mapCacheDelete(key) {
	  return getMapData(this, key)['delete'](key);
	}

	/**
	 * Gets the map value for `key`.
	 *
	 * @private
	 * @name get
	 * @memberOf MapCache
	 * @param {string} key The key of the value to get.
	 * @returns {*} Returns the entry value.
	 */
	function mapCacheGet(key) {
	  return getMapData(this, key).get(key);
	}

	/**
	 * Checks if a map value for `key` exists.
	 *
	 * @private
	 * @name has
	 * @memberOf MapCache
	 * @param {string} key The key of the entry to check.
	 * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
	 */
	function mapCacheHas(key) {
	  return getMapData(this, key).has(key);
	}

	/**
	 * Sets the map `key` to `value`.
	 *
	 * @private
	 * @name set
	 * @memberOf MapCache
	 * @param {string} key The key of the value to set.
	 * @param {*} value The value to set.
	 * @returns {Object} Returns the map cache instance.
	 */
	function mapCacheSet(key, value) {
	  getMapData(this, key).set(key, value);
	  return this;
	}

	// Add methods to `MapCache`.
	MapCache.prototype.clear = mapCacheClear;
	MapCache.prototype['delete'] = mapCacheDelete;
	MapCache.prototype.get = mapCacheGet;
	MapCache.prototype.has = mapCacheHas;
	MapCache.prototype.set = mapCacheSet;

	/**
	 * Creates a stack cache object to store key-value pairs.
	 *
	 * @private
	 * @constructor
	 * @param {Array} [entries] The key-value pairs to cache.
	 */
	function Stack(entries) {
	  this.__data__ = new ListCache(entries);
	}

	/**
	 * Removes all key-value entries from the stack.
	 *
	 * @private
	 * @name clear
	 * @memberOf Stack
	 */
	function stackClear() {
	  this.__data__ = new ListCache;
	}

	/**
	 * Removes `key` and its value from the stack.
	 *
	 * @private
	 * @name delete
	 * @memberOf Stack
	 * @param {string} key The key of the value to remove.
	 * @returns {boolean} Returns `true` if the entry was removed, else `false`.
	 */
	function stackDelete(key) {
	  return this.__data__['delete'](key);
	}

	/**
	 * Gets the stack value for `key`.
	 *
	 * @private
	 * @name get
	 * @memberOf Stack
	 * @param {string} key The key of the value to get.
	 * @returns {*} Returns the entry value.
	 */
	function stackGet(key) {
	  return this.__data__.get(key);
	}

	/**
	 * Checks if a stack value for `key` exists.
	 *
	 * @private
	 * @name has
	 * @memberOf Stack
	 * @param {string} key The key of the entry to check.
	 * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
	 */
	function stackHas(key) {
	  return this.__data__.has(key);
	}

	/**
	 * Sets the stack `key` to `value`.
	 *
	 * @private
	 * @name set
	 * @memberOf Stack
	 * @param {string} key The key of the value to set.
	 * @param {*} value The value to set.
	 * @returns {Object} Returns the stack cache instance.
	 */
	function stackSet(key, value) {
	  var cache = this.__data__;
	  if (cache instanceof ListCache && cache.__data__.length == LARGE_ARRAY_SIZE) {
	    cache = this.__data__ = new MapCache(cache.__data__);
	  }
	  cache.set(key, value);
	  return this;
	}

	// Add methods to `Stack`.
	Stack.prototype.clear = stackClear;
	Stack.prototype['delete'] = stackDelete;
	Stack.prototype.get = stackGet;
	Stack.prototype.has = stackHas;
	Stack.prototype.set = stackSet;

	/**
	 * Assigns `value` to `key` of `object` if the existing value is not equivalent
	 * using [`SameValueZero`](http://ecma-international.org/ecma-262/6.0/#sec-samevaluezero)
	 * for equality comparisons.
	 *
	 * @private
	 * @param {Object} object The object to modify.
	 * @param {string} key The key of the property to assign.
	 * @param {*} value The value to assign.
	 */
	function assignValue(object, key, value) {
	  var objValue = object[key];
	  if (!(hasOwnProperty.call(object, key) && eq(objValue, value)) ||
	      (value === undefined && !(key in object))) {
	    object[key] = value;
	  }
	}

	/**
	 * Gets the index at which the `key` is found in `array` of key-value pairs.
	 *
	 * @private
	 * @param {Array} array The array to search.
	 * @param {*} key The key to search for.
	 * @returns {number} Returns the index of the matched value, else `-1`.
	 */
	function assocIndexOf(array, key) {
	  var length = array.length;
	  while (length--) {
	    if (eq(array[length][0], key)) {
	      return length;
	    }
	  }
	  return -1;
	}

	/**
	 * The base implementation of `_.assign` without support for multiple sources
	 * or `customizer` functions.
	 *
	 * @private
	 * @param {Object} object The destination object.
	 * @param {Object} source The source object.
	 * @returns {Object} Returns `object`.
	 */
	function baseAssign(object, source) {
	  return object && copyObject(source, keys(source), object);
	}

	/**
	 * The base implementation of `_.clone` and `_.cloneDeep` which tracks
	 * traversed objects.
	 *
	 * @private
	 * @param {*} value The value to clone.
	 * @param {boolean} [isDeep] Specify a deep clone.
	 * @param {boolean} [isFull] Specify a clone including symbols.
	 * @param {Function} [customizer] The function to customize cloning.
	 * @param {string} [key] The key of `value`.
	 * @param {Object} [object] The parent object of `value`.
	 * @param {Object} [stack] Tracks traversed objects and their clone counterparts.
	 * @returns {*} Returns the cloned value.
	 */
	function baseClone(value, isDeep, isFull, customizer, key, object, stack) {
	  var result;
	  if (customizer) {
	    result = object ? customizer(value, key, object, stack) : customizer(value);
	  }
	  if (result !== undefined) {
	    return result;
	  }
	  if (!isObject(value)) {
	    return value;
	  }
	  var isArr = isArray(value);
	  if (isArr) {
	    result = initCloneArray(value);
	    if (!isDeep) {
	      return copyArray(value, result);
	    }
	  } else {
	    var tag = getTag(value),
	        isFunc = tag == funcTag || tag == genTag;

	    if (isBuffer(value)) {
	      return cloneBuffer(value, isDeep);
	    }
	    if (tag == objectTag || tag == argsTag || (isFunc && !object)) {
	      if (isHostObject(value)) {
	        return object ? value : {};
	      }
	      result = initCloneObject(isFunc ? {} : value);
	      if (!isDeep) {
	        return copySymbols(value, baseAssign(result, value));
	      }
	    } else {
	      if (!cloneableTags[tag]) {
	        return object ? value : {};
	      }
	      result = initCloneByTag(value, tag, baseClone, isDeep);
	    }
	  }
	  // Check for circular references and return its corresponding clone.
	  stack || (stack = new Stack);
	  var stacked = stack.get(value);
	  if (stacked) {
	    return stacked;
	  }
	  stack.set(value, result);

	  if (!isArr) {
	    var props = isFull ? getAllKeys(value) : keys(value);
	  }
	  // Recursively populate clone (susceptible to call stack limits).
	  arrayEach(props || value, function(subValue, key) {
	    if (props) {
	      key = subValue;
	      subValue = value[key];
	    }
	    assignValue(result, key, baseClone(subValue, isDeep, isFull, customizer, key, value, stack));
	  });
	  return result;
	}

	/**
	 * The base implementation of `_.create` without support for assigning
	 * properties to the created object.
	 *
	 * @private
	 * @param {Object} prototype The object to inherit from.
	 * @returns {Object} Returns the new object.
	 */
	function baseCreate(proto) {
	  return isObject(proto) ? objectCreate(proto) : {};
	}

	/**
	 * The base implementation of `getAllKeys` and `getAllKeysIn` which uses
	 * `keysFunc` and `symbolsFunc` to get the enumerable property names and
	 * symbols of `object`.
	 *
	 * @private
	 * @param {Object} object The object to query.
	 * @param {Function} keysFunc The function to get the keys of `object`.
	 * @param {Function} symbolsFunc The function to get the symbols of `object`.
	 * @returns {Array} Returns the array of property names and symbols.
	 */
	function baseGetAllKeys(object, keysFunc, symbolsFunc) {
	  var result = keysFunc(object);
	  return isArray(object) ? result : arrayPush(result, symbolsFunc(object));
	}

	/**
	 * The base implementation of `_.has` without support for deep paths.
	 *
	 * @private
	 * @param {Object} object The object to query.
	 * @param {Array|string} key The key to check.
	 * @returns {boolean} Returns `true` if `key` exists, else `false`.
	 */
	function baseHas(object, key) {
	  // Avoid a bug in IE 10-11 where objects with a [[Prototype]] of `null`,
	  // that are composed entirely of index properties, return `false` for
	  // `hasOwnProperty` checks of them.
	  return hasOwnProperty.call(object, key) ||
	    (typeof object == 'object' && key in object && getPrototype(object) === null);
	}

	/**
	 * The base implementation of `_.keys` which doesn't skip the constructor
	 * property of prototypes or treat sparse arrays as dense.
	 *
	 * @private
	 * @param {Object} object The object to query.
	 * @returns {Array} Returns the array of property names.
	 */
	function baseKeys(object) {
	  return nativeKeys(Object(object));
	}

	/**
	 * The base implementation of `_.property` without support for deep paths.
	 *
	 * @private
	 * @param {string} key The key of the property to get.
	 * @returns {Function} Returns the new accessor function.
	 */
	function baseProperty(key) {
	  return function(object) {
	    return object == null ? undefined : object[key];
	  };
	}

	/**
	 * Creates a clone of  `buffer`.
	 *
	 * @private
	 * @param {Buffer} buffer The buffer to clone.
	 * @param {boolean} [isDeep] Specify a deep clone.
	 * @returns {Buffer} Returns the cloned buffer.
	 */
	function cloneBuffer(buffer, isDeep) {
	  if (isDeep) {
	    return buffer.slice();
	  }
	  var result = new buffer.constructor(buffer.length);
	  buffer.copy(result);
	  return result;
	}

	/**
	 * Creates a clone of `arrayBuffer`.
	 *
	 * @private
	 * @param {ArrayBuffer} arrayBuffer The array buffer to clone.
	 * @returns {ArrayBuffer} Returns the cloned array buffer.
	 */
	function cloneArrayBuffer(arrayBuffer) {
	  var result = new arrayBuffer.constructor(arrayBuffer.byteLength);
	  new Uint8Array(result).set(new Uint8Array(arrayBuffer));
	  return result;
	}

	/**
	 * Creates a clone of `dataView`.
	 *
	 * @private
	 * @param {Object} dataView The data view to clone.
	 * @param {boolean} [isDeep] Specify a deep clone.
	 * @returns {Object} Returns the cloned data view.
	 */
	function cloneDataView(dataView, isDeep) {
	  var buffer = isDeep ? cloneArrayBuffer(dataView.buffer) : dataView.buffer;
	  return new dataView.constructor(buffer, dataView.byteOffset, dataView.byteLength);
	}

	/**
	 * Creates a clone of `map`.
	 *
	 * @private
	 * @param {Object} map The map to clone.
	 * @param {Function} cloneFunc The function to clone values.
	 * @param {boolean} [isDeep] Specify a deep clone.
	 * @returns {Object} Returns the cloned map.
	 */
	function cloneMap(map, isDeep, cloneFunc) {
	  var array = isDeep ? cloneFunc(mapToArray(map), true) : mapToArray(map);
	  return arrayReduce(array, addMapEntry, new map.constructor);
	}

	/**
	 * Creates a clone of `regexp`.
	 *
	 * @private
	 * @param {Object} regexp The regexp to clone.
	 * @returns {Object} Returns the cloned regexp.
	 */
	function cloneRegExp(regexp) {
	  var result = new regexp.constructor(regexp.source, reFlags.exec(regexp));
	  result.lastIndex = regexp.lastIndex;
	  return result;
	}

	/**
	 * Creates a clone of `set`.
	 *
	 * @private
	 * @param {Object} set The set to clone.
	 * @param {Function} cloneFunc The function to clone values.
	 * @param {boolean} [isDeep] Specify a deep clone.
	 * @returns {Object} Returns the cloned set.
	 */
	function cloneSet(set, isDeep, cloneFunc) {
	  var array = isDeep ? cloneFunc(setToArray(set), true) : setToArray(set);
	  return arrayReduce(array, addSetEntry, new set.constructor);
	}

	/**
	 * Creates a clone of the `symbol` object.
	 *
	 * @private
	 * @param {Object} symbol The symbol object to clone.
	 * @returns {Object} Returns the cloned symbol object.
	 */
	function cloneSymbol(symbol) {
	  return symbolValueOf ? Object(symbolValueOf.call(symbol)) : {};
	}

	/**
	 * Creates a clone of `typedArray`.
	 *
	 * @private
	 * @param {Object} typedArray The typed array to clone.
	 * @param {boolean} [isDeep] Specify a deep clone.
	 * @returns {Object} Returns the cloned typed array.
	 */
	function cloneTypedArray(typedArray, isDeep) {
	  var buffer = isDeep ? cloneArrayBuffer(typedArray.buffer) : typedArray.buffer;
	  return new typedArray.constructor(buffer, typedArray.byteOffset, typedArray.length);
	}

	/**
	 * Copies the values of `source` to `array`.
	 *
	 * @private
	 * @param {Array} source The array to copy values from.
	 * @param {Array} [array=[]] The array to copy values to.
	 * @returns {Array} Returns `array`.
	 */
	function copyArray(source, array) {
	  var index = -1,
	      length = source.length;

	  array || (array = Array(length));
	  while (++index < length) {
	    array[index] = source[index];
	  }
	  return array;
	}

	/**
	 * Copies properties of `source` to `object`.
	 *
	 * @private
	 * @param {Object} source The object to copy properties from.
	 * @param {Array} props The property identifiers to copy.
	 * @param {Object} [object={}] The object to copy properties to.
	 * @param {Function} [customizer] The function to customize copied values.
	 * @returns {Object} Returns `object`.
	 */
	function copyObject(source, props, object, customizer) {
	  object || (object = {});

	  var index = -1,
	      length = props.length;

	  while (++index < length) {
	    var key = props[index];

	    var newValue = customizer
	      ? customizer(object[key], source[key], key, object, source)
	      : source[key];

	    assignValue(object, key, newValue);
	  }
	  return object;
	}

	/**
	 * Copies own symbol properties of `source` to `object`.
	 *
	 * @private
	 * @param {Object} source The object to copy symbols from.
	 * @param {Object} [object={}] The object to copy symbols to.
	 * @returns {Object} Returns `object`.
	 */
	function copySymbols(source, object) {
	  return copyObject(source, getSymbols(source), object);
	}

	/**
	 * Creates an array of own enumerable property names and symbols of `object`.
	 *
	 * @private
	 * @param {Object} object The object to query.
	 * @returns {Array} Returns the array of property names and symbols.
	 */
	function getAllKeys(object) {
	  return baseGetAllKeys(object, keys, getSymbols);
	}

	/**
	 * Gets the "length" property value of `object`.
	 *
	 * **Note:** This function is used to avoid a
	 * [JIT bug](https://bugs.webkit.org/show_bug.cgi?id=142792) that affects
	 * Safari on at least iOS 8.1-8.3 ARM64.
	 *
	 * @private
	 * @param {Object} object The object to query.
	 * @returns {*} Returns the "length" value.
	 */
	var getLength = baseProperty('length');

	/**
	 * Gets the data for `map`.
	 *
	 * @private
	 * @param {Object} map The map to query.
	 * @param {string} key The reference key.
	 * @returns {*} Returns the map data.
	 */
	function getMapData(map, key) {
	  var data = map.__data__;
	  return isKeyable(key)
	    ? data[typeof key == 'string' ? 'string' : 'hash']
	    : data.map;
	}

	/**
	 * Gets the native function at `key` of `object`.
	 *
	 * @private
	 * @param {Object} object The object to query.
	 * @param {string} key The key of the method to get.
	 * @returns {*} Returns the function if it's native, else `undefined`.
	 */
	function getNative(object, key) {
	  var value = object[key];
	  return isNative(value) ? value : undefined;
	}

	/**
	 * Gets the `[[Prototype]]` of `value`.
	 *
	 * @private
	 * @param {*} value The value to query.
	 * @returns {null|Object} Returns the `[[Prototype]]`.
	 */
	function getPrototype(value) {
	  return nativeGetPrototype(Object(value));
	}

	/**
	 * Creates an array of the own enumerable symbol properties of `object`.
	 *
	 * @private
	 * @param {Object} object The object to query.
	 * @returns {Array} Returns the array of symbols.
	 */
	function getSymbols(object) {
	  // Coerce `object` to an object to avoid non-object errors in V8.
	  // See https://bugs.chromium.org/p/v8/issues/detail?id=3443 for more details.
	  return getOwnPropertySymbols(Object(object));
	}

	// Fallback for IE < 11.
	if (!getOwnPropertySymbols) {
	  getSymbols = function() {
	    return [];
	  };
	}

	/**
	 * Gets the `toStringTag` of `value`.
	 *
	 * @private
	 * @param {*} value The value to query.
	 * @returns {string} Returns the `toStringTag`.
	 */
	function getTag(value) {
	  return objectToString.call(value);
	}

	// Fallback for data views, maps, sets, and weak maps in IE 11,
	// for data views in Edge, and promises in Node.js.
	if ((DataView && getTag(new DataView(new ArrayBuffer(1))) != dataViewTag) ||
	    (Map && getTag(new Map) != mapTag) ||
	    (Promise && getTag(Promise.resolve()) != promiseTag) ||
	    (Set && getTag(new Set) != setTag) ||
	    (WeakMap && getTag(new WeakMap) != weakMapTag)) {
	  getTag = function(value) {
	    var result = objectToString.call(value),
	        Ctor = result == objectTag ? value.constructor : undefined,
	        ctorString = Ctor ? toSource(Ctor) : undefined;

	    if (ctorString) {
	      switch (ctorString) {
	        case dataViewCtorString: return dataViewTag;
	        case mapCtorString: return mapTag;
	        case promiseCtorString: return promiseTag;
	        case setCtorString: return setTag;
	        case weakMapCtorString: return weakMapTag;
	      }
	    }
	    return result;
	  };
	}

	/**
	 * Initializes an array clone.
	 *
	 * @private
	 * @param {Array} array The array to clone.
	 * @returns {Array} Returns the initialized clone.
	 */
	function initCloneArray(array) {
	  var length = array.length,
	      result = array.constructor(length);

	  // Add properties assigned by `RegExp#exec`.
	  if (length && typeof array[0] == 'string' && hasOwnProperty.call(array, 'index')) {
	    result.index = array.index;
	    result.input = array.input;
	  }
	  return result;
	}

	/**
	 * Initializes an object clone.
	 *
	 * @private
	 * @param {Object} object The object to clone.
	 * @returns {Object} Returns the initialized clone.
	 */
	function initCloneObject(object) {
	  return (typeof object.constructor == 'function' && !isPrototype(object))
	    ? baseCreate(getPrototype(object))
	    : {};
	}

	/**
	 * Initializes an object clone based on its `toStringTag`.
	 *
	 * **Note:** This function only supports cloning values with tags of
	 * `Boolean`, `Date`, `Error`, `Number`, `RegExp`, or `String`.
	 *
	 * @private
	 * @param {Object} object The object to clone.
	 * @param {string} tag The `toStringTag` of the object to clone.
	 * @param {Function} cloneFunc The function to clone values.
	 * @param {boolean} [isDeep] Specify a deep clone.
	 * @returns {Object} Returns the initialized clone.
	 */
	function initCloneByTag(object, tag, cloneFunc, isDeep) {
	  var Ctor = object.constructor;
	  switch (tag) {
	    case arrayBufferTag:
	      return cloneArrayBuffer(object);

	    case boolTag:
	    case dateTag:
	      return new Ctor(+object);

	    case dataViewTag:
	      return cloneDataView(object, isDeep);

	    case float32Tag: case float64Tag:
	    case int8Tag: case int16Tag: case int32Tag:
	    case uint8Tag: case uint8ClampedTag: case uint16Tag: case uint32Tag:
	      return cloneTypedArray(object, isDeep);

	    case mapTag:
	      return cloneMap(object, isDeep, cloneFunc);

	    case numberTag:
	    case stringTag:
	      return new Ctor(object);

	    case regexpTag:
	      return cloneRegExp(object);

	    case setTag:
	      return cloneSet(object, isDeep, cloneFunc);

	    case symbolTag:
	      return cloneSymbol(object);
	  }
	}

	/**
	 * Creates an array of index keys for `object` values of arrays,
	 * `arguments` objects, and strings, otherwise `null` is returned.
	 *
	 * @private
	 * @param {Object} object The object to query.
	 * @returns {Array|null} Returns index keys, else `null`.
	 */
	function indexKeys(object) {
	  var length = object ? object.length : undefined;
	  if (isLength(length) &&
	      (isArray(object) || isString(object) || isArguments(object))) {
	    return baseTimes(length, String);
	  }
	  return null;
	}

	/**
	 * Checks if `value` is a valid array-like index.
	 *
	 * @private
	 * @param {*} value The value to check.
	 * @param {number} [length=MAX_SAFE_INTEGER] The upper bounds of a valid index.
	 * @returns {boolean} Returns `true` if `value` is a valid index, else `false`.
	 */
	function isIndex(value, length) {
	  length = length == null ? MAX_SAFE_INTEGER : length;
	  return !!length &&
	    (typeof value == 'number' || reIsUint.test(value)) &&
	    (value > -1 && value % 1 == 0 && value < length);
	}

	/**
	 * Checks if `value` is suitable for use as unique object key.
	 *
	 * @private
	 * @param {*} value The value to check.
	 * @returns {boolean} Returns `true` if `value` is suitable, else `false`.
	 */
	function isKeyable(value) {
	  var type = typeof value;
	  return (type == 'string' || type == 'number' || type == 'symbol' || type == 'boolean')
	    ? (value !== '__proto__')
	    : (value === null);
	}

	/**
	 * Checks if `value` is likely a prototype object.
	 *
	 * @private
	 * @param {*} value The value to check.
	 * @returns {boolean} Returns `true` if `value` is a prototype, else `false`.
	 */
	function isPrototype(value) {
	  var Ctor = value && value.constructor,
	      proto = (typeof Ctor == 'function' && Ctor.prototype) || objectProto;

	  return value === proto;
	}

	/**
	 * Converts `func` to its source code.
	 *
	 * @private
	 * @param {Function} func The function to process.
	 * @returns {string} Returns the source code.
	 */
	function toSource(func) {
	  if (func != null) {
	    try {
	      return funcToString.call(func);
	    } catch (e) {}
	    try {
	      return (func + '');
	    } catch (e) {}
	  }
	  return '';
	}

	/**
	 * Performs a
	 * [`SameValueZero`](http://ecma-international.org/ecma-262/6.0/#sec-samevaluezero)
	 * comparison between two values to determine if they are equivalent.
	 *
	 * @static
	 * @memberOf _
	 * @since 4.0.0
	 * @category Lang
	 * @param {*} value The value to compare.
	 * @param {*} other The other value to compare.
	 * @returns {boolean} Returns `true` if the values are equivalent, else `false`.
	 * @example
	 *
	 * var object = { 'user': 'fred' };
	 * var other = { 'user': 'fred' };
	 *
	 * _.eq(object, object);
	 * // => true
	 *
	 * _.eq(object, other);
	 * // => false
	 *
	 * _.eq('a', 'a');
	 * // => true
	 *
	 * _.eq('a', Object('a'));
	 * // => false
	 *
	 * _.eq(NaN, NaN);
	 * // => true
	 */
	function eq(value, other) {
	  return value === other || (value !== value && other !== other);
	}

	/**
	 * Checks if `value` is likely an `arguments` object.
	 *
	 * @static
	 * @memberOf _
	 * @since 0.1.0
	 * @category Lang
	 * @param {*} value The value to check.
	 * @returns {boolean} Returns `true` if `value` is correctly classified,
	 *  else `false`.
	 * @example
	 *
	 * _.isArguments(function() { return arguments; }());
	 * // => true
	 *
	 * _.isArguments([1, 2, 3]);
	 * // => false
	 */
	function isArguments(value) {
	  // Safari 8.1 incorrectly makes `arguments.callee` enumerable in strict mode.
	  return isArrayLikeObject(value) && hasOwnProperty.call(value, 'callee') &&
	    (!propertyIsEnumerable.call(value, 'callee') || objectToString.call(value) == argsTag);
	}

	/**
	 * Checks if `value` is classified as an `Array` object.
	 *
	 * @static
	 * @memberOf _
	 * @since 0.1.0
	 * @type {Function}
	 * @category Lang
	 * @param {*} value The value to check.
	 * @returns {boolean} Returns `true` if `value` is correctly classified,
	 *  else `false`.
	 * @example
	 *
	 * _.isArray([1, 2, 3]);
	 * // => true
	 *
	 * _.isArray(document.body.children);
	 * // => false
	 *
	 * _.isArray('abc');
	 * // => false
	 *
	 * _.isArray(_.noop);
	 * // => false
	 */
	var isArray = Array.isArray;

	/**
	 * Checks if `value` is array-like. A value is considered array-like if it's
	 * not a function and has a `value.length` that's an integer greater than or
	 * equal to `0` and less than or equal to `Number.MAX_SAFE_INTEGER`.
	 *
	 * @static
	 * @memberOf _
	 * @since 4.0.0
	 * @category Lang
	 * @param {*} value The value to check.
	 * @returns {boolean} Returns `true` if `value` is array-like, else `false`.
	 * @example
	 *
	 * _.isArrayLike([1, 2, 3]);
	 * // => true
	 *
	 * _.isArrayLike(document.body.children);
	 * // => true
	 *
	 * _.isArrayLike('abc');
	 * // => true
	 *
	 * _.isArrayLike(_.noop);
	 * // => false
	 */
	function isArrayLike(value) {
	  return value != null && isLength(getLength(value)) && !isFunction(value);
	}

	/**
	 * This method is like `_.isArrayLike` except that it also checks if `value`
	 * is an object.
	 *
	 * @static
	 * @memberOf _
	 * @since 4.0.0
	 * @category Lang
	 * @param {*} value The value to check.
	 * @returns {boolean} Returns `true` if `value` is an array-like object,
	 *  else `false`.
	 * @example
	 *
	 * _.isArrayLikeObject([1, 2, 3]);
	 * // => true
	 *
	 * _.isArrayLikeObject(document.body.children);
	 * // => true
	 *
	 * _.isArrayLikeObject('abc');
	 * // => false
	 *
	 * _.isArrayLikeObject(_.noop);
	 * // => false
	 */
	function isArrayLikeObject(value) {
	  return isObjectLike(value) && isArrayLike(value);
	}

	/**
	 * Checks if `value` is a buffer.
	 *
	 * @static
	 * @memberOf _
	 * @since 4.3.0
	 * @category Lang
	 * @param {*} value The value to check.
	 * @returns {boolean} Returns `true` if `value` is a buffer, else `false`.
	 * @example
	 *
	 * _.isBuffer(new Buffer(2));
	 * // => true
	 *
	 * _.isBuffer(new Uint8Array(2));
	 * // => false
	 */
	var isBuffer = !Buffer ? constant(false) : function(value) {
	  return value instanceof Buffer;
	};

	/**
	 * Checks if `value` is classified as a `Function` object.
	 *
	 * @static
	 * @memberOf _
	 * @since 0.1.0
	 * @category Lang
	 * @param {*} value The value to check.
	 * @returns {boolean} Returns `true` if `value` is correctly classified,
	 *  else `false`.
	 * @example
	 *
	 * _.isFunction(_);
	 * // => true
	 *
	 * _.isFunction(/abc/);
	 * // => false
	 */
	function isFunction(value) {
	  // The use of `Object#toString` avoids issues with the `typeof` opera