﻿(function () {
    'use strict';
    newERP.service('ValidarExpressaoRegularService', ['$localStorage', function ($localStorage) {
        var validarExpressaoRegularFactory = {};

        var _isUrlValid = function (userInput) {
            var regexQuery = "^(https?://)?(www\\.)?([-a-z0-9]{1,63}\\.)*?[a-z0-9][-a-z0-9]{0,61}[a-z0-9]\\.[a-z]{2,6}(/[-\\w@\\+\\.~#\\?&/=%]*)?$";
            var url = new RegExp(regexQuery, "i");
            if (url.test(userInput)) {
                return true;
            }
            return false;
        }

        validarExpressaoRegularFactory.isUrlValid = _isUrlValid;

        return validarExpressaoRegularFactory;
    }]);
})();