﻿'use strict';
newERP.service('CalculoICMSService', ['$q', function ($q) {
    var calculoICMSFactory = {};

    var _calculoICMS = function (valorItem, quantidadeItem, valorFrete, valorDespesas, valorIPI, valorDesconto, valorAcrescimo, reducaoICMS, aliquotaICMS) {
        var deferred = $q.defer();
        if (!!valorItem && !!aliquotaICMS) {
            if (valorFrete < 0)
                deferred.resolve({ error: "Valor do frete não pode ser negativo" });
            if (valorDespesas < 0)
                deferred.resolve({ error: "Valor das despesas não pode ser negativo" });
            if (valorIPI < 0)
                deferred.resolve({ error: "Valor do IPI não pode ser negativo" });
            if (valorDesconto < 0)
                deferred.resolve({ error: "Valor do desconto não pode ser negativo" });
            if (reducaoICMS < 0)
                deferred.resolve({ error: "Valor do desconto não pode ser negativo" });
            if (valorItem < 0)
                deferred.resolve({ error: "Valor do item não pode ser negativo" });
            if (quantidadeItem <= 0)
                deferred.resolve({ error: "A quantidade do item não pode ser igual a zero" });
            if (aliquotaICMS < 0)
                deferred.resolve({ error: "A alíquota não pode ser negativa" });

            var resultadoBaseICMS = ((((valorItem * quantidadeItem) + valorFrete + valorDespesas + valorAcrescimo + parseFloat(valorIPI) - valorDesconto) * parseFloat(100 - reducaoICMS)) / 100).toFixed(2);
            var resultadoICMS = (((((valorItem * quantidadeItem) + valorFrete + valorDespesas + valorAcrescimo + parseFloat(valorIPI) - valorDesconto) * (100 - reducaoICMS) / 100) * aliquotaICMS) / 100).toFixed(2);

            deferred.resolve({ baseICMS: resultadoBaseICMS, ICMS: resultadoICMS });
        } else {
            if (!(!!valorItem)) {
                deferred.resolve({ error: "O valor do item não foi informado" });
            }

            if (quantidadeItem == 0) {
                deferred.resolve({ error: "A quantidade do item não foi informada" });
            }

            if (!(!!aliquotaICMS)) {
                deferred.resolve({ error: "A alíquota do ICMS não foi informado" });
            }
        }
        return deferred.promise;
    }

    calculoICMSFactory.calcICMS = _calculoICMS

    return calculoICMSFactory;
}])