﻿(function () {
    'use strict';
    newERP.service('FuncaoService', ['ModalService', '$rootScope', function (ModalService, $rootScope) {
        var funcaoFactory = {};

        function mod(dividend, divisor) {
            return Math.round(dividend - (Math.floor(dividend / divisor) * divisor));
        }

        function module10(str) {
            if (str === undefined || str === null) {
                return 0;
            }
            var size = str.length - 1;
            var result = 0;
            var weight = 2;

            for (var i = size; i >= 0; i--) {
                var total = str.substr(i, 1) * weight;
                if (total > 9) {
                    result = result + 1 + (total - 10);
                } else {
                    result = result + total;
                }
                if (weight == 1) {
                    weight = 2;
                } else {
                    weight = 1;
                }
            }
            var dv = 10 - mod(result, 10);
            if (dv == 10) {
                dv = 0;
            }
            return dv;
        }

        var _validarCMC7 = function (typedValue) {
            if (typedValue === undefined || typedValue === null) {
                return false;
            }
            typedValue = typedValue.replace(/\s/g, "");
            if (!typedValue) {
                return false;
            }

            var pieces = {
                firstPiece: typedValue.substr(0, 7)
                , secondPiece: typedValue.substr(8, 10)
                , thirdPiece: typedValue.substr(19, 10)
            };


            var digits = {
                firstDigit: parseInt(typedValue.substr(7, 1))
                , secondDigit: parseInt(typedValue.substr(18, 1))
                , thirdDigit: parseInt(typedValue.substr(29, 1))
            };

            var calculatedDigits = {
                firstDigit: module10(pieces.firstPiece)
                , secondDigit: module10(pieces.secondPiece)
                , thirdDigit: module10(pieces.thirdPiece)
            };

            if ((calculatedDigits.secondDigit != digits.firstDigit)
                || (calculatedDigits.firstDigit != digits.secondDigit)
                || (calculatedDigits.thirdDigit != digits.thirdDigit)) {
                return false;
            }
            return true;
        }

        var _formatarBytes = function (bytes, decimals) {
            if (bytes == 0) return '0 Byte';
            var k = 1000;
            var dm = decimals + 1 || 3;
            var sizes = ['Bytes', 'KB', 'MB', 'GB', 'TB', 'PB', 'EB', 'ZB', 'YB'];
            var i = Math.floor(Math.log(bytes) / Math.log(k));
            return parseFloat((bytes / Math.pow(k, i)).toFixed(dm)) + ' ' + sizes[i];
        };

        var _validaEnderecoEmail = function (email) {
            var str = email;
            var filtro = /^([\w-]+(?:\.[\w-]+)*)@((?:[\w-]+\.)*\w[\w-]{0,66})\.([a-z]{2,6}(?:\.[a-z]{2})?)$/i;
            if (filtro.test(str)) {
                return true;
            } else {
                return false;
            }
        };

        var _validarEAN = function (eanCodigo) {
            if (!!eanCodigo) {
                fator = 3;
                sum = 0;
                numlen = eanCodigo.length;
                if (numlen == 13) {
                    for (index = eanCodigo.length; index > 0; --index) {
                        if (index != 13) {
                            sum = sum + eanCodigo.substring(index - 1, index) * fator;
                            fator = 4 - fator;
                        }
                    }
                    cc = ((1000 - sum) % 10);
                    ca = eanCodigo.substring(12);
                    if (cc == ca) {
                        return true;
                    }
                    else {
                        return false;
                    }
                }
                if (numlen == 14) {
                    for (index = eanCodigo.length; index > 0; --index) {
                        if (index != 14) {
                            sum = sum + eanCodigo.substring(index - 1, index) * fator;
                            fator = 4 - fator;
                        }
                    }
                    cc = ((1000 - sum) % 10);
                    ca = eanCodigo.substring(13);
                    if (cc == ca) {
                        return true;
                    }
                    else {
                        return false;
                    }
                }
                if (numlen == 8) {
                    for (index = eanCodigo.length; index > 0; --index) {
                        if (index != 8) {
                            sum = sum + eanCodigo.substring(index - 1, index) * fator;
                            fator = 4 - fator;
                        }
                    }
                    cc = ((1000 - sum) % 10);
                    ca = eanCodigo.substring(7);
                    if (cc == ca) {
                        return true
                    }
                    else {
                        return false;
                    }
                }

                if (((numlen != 8) && (numlen != 13) && (numlen != 14) && (numlen != 0))) {
                    return false;
                }
            } else {
                return true;
            }
        };

        var _subtrairDias = function (data, dia) {

            return new Date(data.getTime() - (dia * 24 * 60 * 60 * 1000));

        };

        var _formataDataNormal = function (data) {

            var d = new Date(data || Date.now()),
                dia = '' + d.getDate(),
                mes = '' + (d.getMonth() + 1),
                ano = d.getFullYear();

            if (mes.length < 2) mes = '0' + mes;
            if (dia.length < 2) dia = '0' + dia;

            return [dia, mes, ano].join('/');

        };

        var _formataDataInvertida = function (data) {

            var d = new Date(data || Date.now()),
                dia = '' + d.getDate(),
                mes = '' + (d.getMonth() + 1),
                ano = d.getFullYear();

            if (mes.length < 2) mes = '0' + mes;
            if (dia.length < 2) dia = '0' + dia;

            return [ano, mes, dia].join('-');

        };

        var _formatarCpfCnpj = function (cpfCnpj) {
            if (!!cpfCnpj)
                if (cpfCnpj.length < 11) {
                    var cpfCnpjFormatado = cpfCnpj + '';
                    cpfCnpjFormatado = cpfCnpjFormatado.replace(/\D/g, '');
                    cpfCnpjFormatado = cpfCnpjFormatado.replace(/^(\d{2})(\d)/, '$1.$2');
                    cpfCnpjFormatado = cpfCnpjFormatado.replace(/^(\d{2})\.(\d{3})(\d)/, '$1.$2.$3');
                    cpfCnpjFormatado = cpfCnpjFormatado.replace(/\.(\d{3})(\d)/, '.$1/$2');
                    cpfCnpjFormatado = cpfCnpjFormatado.replace(/(\d{4})(\d)/, '$1-$2');
                } else {
                    var cpfCnpjFormatado = cpfCnpj + '';
                    cpfCnpjFormatado = cpfCnpjFormatado.replace(/\D/g, '');
                    cpfCnpjFormatado = cpfCnpjFormatado.replace(/(\d{3})(\d)/, "$1.$2");
                    cpfCnpjFormatado = cpfCnpjFormatado.replace(/(\d{3})(\d)/, "$1.$2");
                    cpfCnpjFormatado = cpfCnpjFormatado.replace(/(\d{3})(\d{1,2})$/, "$1-$2");
                }
            return cpfCnpjFormatado;
        };

        var _montaMensagemErro = function (parametros) {
            $rootScope.model = {
                retornoApi: (!!parametros.retornoApi) ? parametros.retornoApi : '',
                comoResolver: (!!parametros.comoResolver) ? parametros.comoResolver : '',
                linkResolver: (!!parametros.linkResolver) ? parametros.linkResolver : ''
            };

            if (!!$rootScope.model.retornoApi)
                $rootScope.modelTratamentoRetornoErro = ModalService.abrirModel({
                    animation: true,
                    templateUrl: '/modals/tratamentoRetornoErro.html',
                    scope: $rootScope,
                    size: ($rootScope.model.retornoApi.length > 50) ? 'xs' : 'sm',
                    backdrop: true,
                    keyboard: true
                });
        };

        var _delay = (function () {
            var timer = 0;
            return function (callback, ms) {
                clearTimeout(timer);
                timer = setTimeout(callback, ms);
            };
        })();

        var _retornaDiferencaEmHoras = function (dataHoraComparacao) {
            var dataHoraAtual = new Date();

            var dataHora = dataHoraComparacao.split("T");

            var data = dataHora[0].split("-");
            var hora = dataHora[1].split(":");
            dataHoraComparacao = new Date(data[0], data[1] - 1, data[2], hora[0], hora[1], hora[2], 0);

            var diff = (dataHoraAtual.getTime() - dataHoraComparacao.getTime()) / 1000;
            diff /= (60 * 60);
            return Math.abs(Math.round(diff));
        };

        var _compararDatas = function (dataInicial, dataFinal) {
            dataFinal = (!!dataFinal) ? dataFinal : new Date();
            dataInicial = new Date(dataInicial);
            dataFinal = new Date(dataFinal);
            if (dataInicial >= dataFinal) {
                return false;
            } else {
                return true;
            }
        };
        var _diferencaDatas = function (dataInicial, dataFinal) {
            var d1 = new Date(dataInicial).getTime();
            var d2 = new Date().getTime();
            var df = Math.abs(d1 - d2);
            return Math.round(df / (24 * 60 * 60 * 1000)); //dias
        }

        var _retornaValorPorExtenso = function (valor) {
            var ex = [
                ["zero", "um", "dois", "três", "quatro", "cinco", "seis", "sete", "oito", "nove", "dez", "onze", "doze", "treze", "quatorze", "quinze", "dezesseis", "dezessete", "dezoito", "dezenove"],
                ["dez", "vinte", "trinta", "quarenta", "cinquenta", "sessenta", "setenta", "oitenta", "noventa"],
                ["cem", "cento", "duzentos", "trezentos", "quatrocentos", "quinhentos", "seiscentos", "setecentos", "oitocentos", "novecentos"],
                ["mil", "milhão", "bilhão", "trilhão", "quadrilhão", "quintilhão", "sextilhão", "setilhão", "octilhão", "nonilhão", "decilhão", "undecilhão", "dodecilhão", "tredecilhão", "quatrodecilhão", "quindecilhão", "sedecilhão", "septendecilhão", "octencilhão", "nonencilhão"]
            ];
            valor = valor.toString().replace('.', ',');
            var a, n, v, i, n = valor.toString().replace(valor ? /[^,\d]/g : /\D/g, "").split(","), e = " e ", $ = "real", d = "centavo", sl;
            for (var f = n.length - 1, l, j = -1, r = [], s = [], t = ""; ++j <= f; s = []) {
                j && (n[j] = (("." + n[j]) * 1).toFixed(2).slice(2));
                if (!(a = (v = n[j]).slice((l = v.length) % 3).match(/\d{3}/g), v = l % 3 ? [v.slice(0, l % 3)] : [], v = a ? v.concat(a) : v).length) continue;
                for (a = -1, l = v.length; ++a < l; t = "") {
                    if (!(i = v[a] * 1)) continue;
                    i % 100 < 20 && (t += ex[0][i % 100]) ||
                        i % 100 + 1 && (t += ex[1][(i % 100 / 10 >> 0) - 1] + (i % 10 ? e + ex[0][i % 10] : ""));
                    s.push((i < 100 ? t : !(i % 100) ? ex[2][i == 100 ? 0 : i / 100 >> 0] : (ex[2][i / 100 >> 0] + e + t)) +
                        ((t = l - a - 2) > -1 ? " " + (i > 1 && t > 0 ? ex[3][t].replace("?o", "?es") : ex[3][t]) : ""));
                }
                a = ((sl = s.length) > 1 ? (a = s.pop(), s.join(" ") + e + a) : s.join("") || ((!j && (n[j + 1] * 1 > 0) || r.length) ? "" : ex[0][0]));
                a && r.push(a + (valor ? (" " + (v.join("") * 1 > 1 ? j ? d + "s" : (/0{6,}$/.test(n[0]) ? "de " : "") + $.replace("l", "is") : j ? d : $)) : ""));
            }
            return r.join(e);
        };

        var _setarFocus = function (nomeElemento, tempo) {
            tempo = tempo | 100;
            setTimeout(function () {
                var element = window.document.getElementsByName(nomeElemento);
                if (!!element[0])
                    element[0].focus();
            }, tempo);
        };

        var _retornarDiaInicioDiaFimSemana = function () {
            var hoje = new Date();
            var dia = hoje.getDay();
            var inicioSemana = new Date();
            inicioSemana.setDate(hoje.getDate() - dia);
            if (inicioSemana.getMonth() != hoje.getMonth()) {
                inicioSemana = new Date(hoje.getFullYear(), hoje.getMonth(), 1);
            }

            var finalSemana = new Date();
            finalSemana.setDate(hoje.getDate() + (7 - (dia + 1)));
            if (finalSemana.getMonth() != hoje.getMonth()) {
                finalSemana = new Date(hoje.getFullYear(), hoje.getMonth() + 1, 0);
            }

            return {
                inicio: inicioSemana,
                fim: finalSemana
            }
        };

        var _retornaMoney = function numberParaReal(num) {
            return num.toFixed(2).replace(".", ",").replace(/(\d)(?=(\d{3})+(?!\d))/g, "$1.")
        };

        var _removerCaracteresEspeciais = function (texto) {
            texto = texto.replace(".", "");
            texto = texto.replace("(", "");
            texto = texto.replace(")", "");
            texto = texto.replace("-", "");
            texto = texto.replace("/", "");
            texto = texto.replace(":", "");
            texto = texto.replace(";", "");
            texto = texto.replace(",", "");
            texto = texto.replace("?", "");
            texto = texto.replace("!", "");
            texto = texto.replace("@", "");
            texto = texto.replace("#", "");
            texto = texto.replace("$", "");
            texto = texto.replace("%", "");
            texto = texto.replace("&", "");
            texto = texto.replace("*", "");
            texto = texto.replace("]", "");
            texto = texto.replace("[", "");
            texto = texto.replace("|", "");
            texto = texto.replace("=", "");
            texto = texto.replace("*", "");
            texto = texto.replace(" ", "");
            return texto;
        };

        var _retornaSoLetras = function (texto) {
            return texto.replace(/[^a-zA-Z]/g, '');
        };

        var _retornaSoNumeros = function (texto) {
            return texto.replace(/[^0-9]/g, '');
        };

        var _removerEspacos = function (texto) {
            return texto.replace(/\s/g, '');
        };

        var _removerAcentos = function (texto) {
            if (texto == null) return '';

            var comAcentos = "ÄÅÁÂÀÃäáâàãÉÊËÈéêëèÍÎÏÌíîïìÖÓÔÒÕöóôòõÜÚÛüúûùÇç";
            var semAcentos = "AAAAAAaaaaaEEEEeeeeIIIIiiiiOOOOOoooooUUUuuuuCc";

            var novoTexto = '';
            for (var x = 0; x < texto.length; x++) {
                if (!!comAcentos[comAcentos.indexOf(texto[x])]) {
                    novoTexto += texto[x].toString().replace(comAcentos[comAcentos.indexOf(texto[x])], semAcentos[comAcentos.indexOf(texto[x])]);
                } else {
                    novoTexto += texto[x].toString();
                }
            }
            return novoTexto;
        };

        var _compararDatasParcela = function (dataInicial, dataFinal) {
            dataFinal = (!!dataFinal) ? dataFinal : new Date();
            dataInicial = new Date(dataInicial);
            var diaIni = dataInicial.getDate();
            var mesIni = dataInicial.getMonth();
            var anoIni = dataInicial.getFullYear();
            var dataIni = new Date(anoIni, mesIni, diaIni);
            dataFinal = new Date(dataFinal);
            var diaFim = dataFinal.getDate();
            var mesFim = dataFinal.getMonth();
            var anoFim = dataFinal.getFullYear();
            var dataFim = new Date(anoFim, mesFim, diaFim);
            if (dataIni >= dataFim) {
                return false;
            } else {
                return true;
            }
        };

        var _verificarDataValida = function (strData) {
            return !!new Date(strData).getTime();
        }

        var _validarCPF = function (cpf) {
            if (cpf != '') {
                cpf = cpf.replace(/[^\d]+/g, '');
                // Elimina CPFs invalidos conhecidos    
                if (cpf.length != 11 ||
                    cpf == "00000000000" ||
                    cpf == "11111111111" ||
                    cpf == "22222222222" ||
                    cpf == "33333333333" ||
                    cpf == "44444444444" ||
                    cpf == "55555555555" ||
                    cpf == "66666666666" ||
                    cpf == "77777777777" ||
                    cpf == "88888888888" ||
                    cpf == "99999999999") {
                    return false;
                }
                // Valida 1o digito 
                var add = 0;
                var i;
                for (i = 0; i < 9; i++)
                    add += parseInt(cpf.charAt(i)) * (10 - i);
                var rev = 11 - (add % 11);
                if (rev == 10 || rev == 11)
                    rev = 0;
                if (rev != parseInt(cpf.charAt(9))) {
                    return false;
                }
                // Valida 2o digito 
                add = 0;
                for (i = 0; i < 10; i++)
                    add += parseInt(cpf.charAt(i)) * (11 - i);
                rev = 11 - (add % 11);
                if (rev == 10 || rev == 11)
                    rev = 0;
                if (rev != parseInt(cpf.charAt(10))) {
                    return false;
                }
                return true;
            }
        }

        var _validarCNPJ = function (cnpj) {
            if (cnpj != '') {
                cnpj = cnpj.replace(/[^\d]+/g, '');

                if (cnpj.length != 14) {
                    return false;
                }

                // Elimina CNPJs invalidos conhecidos
                if (cnpj == "00000000000000" ||
                    cnpj == "11111111111111" ||
                    cnpj == "22222222222222" ||
                    cnpj == "33333333333333" ||
                    cnpj == "44444444444444" ||
                    cnpj == "55555555555555" ||
                    cnpj == "66666666666666" ||
                    cnpj == "77777777777777" ||
                    cnpj == "88888888888888" ||
                    cnpj == "99999999999999") {
                    return false;
                }

                // Valida DVs
                var tamanho = cnpj.length - 2
                var numeros = cnpj.substring(0, tamanho);
                var digitos = cnpj.substring(tamanho);
                var soma = 0;
                var pos = tamanho - 7;
                var i;
                for (i = tamanho; i >= 1; i--) {
                    soma += numeros.charAt(tamanho - i) * pos--;
                    if (pos < 2)
                        pos = 9;
                }

                var resultado = soma % 11 < 2 ? 0 : 11 - soma % 11;
                if (resultado != digitos.charAt(0)) {
                    return false;
                }

                tamanho = tamanho + 1;
                numeros = cnpj.substring(0, tamanho);
                soma = 0;
                pos = tamanho - 7;
                for (i = tamanho; i >= 1; i--) {
                    soma += numeros.charAt(tamanho - i) * pos--;
                    if (pos < 2)
                        pos = 9;
                }

                resultado = soma % 11 < 2 ? 0 : 11 - soma % 11;
                if (resultado != digitos.charAt(1)) {
                    return false;
                }

                return true;
            }
        }
        var _round = function (num, places) {
            if (!("" + num).includes("e")) {
                return +(Math.round(num + "e+" + places) + "e-" + places);
            } else {
                let arr = ("" + num).split("e");
                let sig = ""
                if (+arr[1] + places > 0) {
                    sig = "+";
                }

                return +(Math.round(+arr[0] + "e" + sig + (+arr[1] + places)) + "e-" + places);
            }
        }

        var _arredondar  = function arredondar(numero, casasDecimais = 2, limiteArredondamento = 5) {
                var fator = Math.pow(10, casasDecimais);
                var valorArredondado = Math.round(numero * fator) / fator;
                var proximaCasaDecimal = Math.round((numero * fator * 10) % 10);

                // Verifica se a próxima casa decimal é maior que o limite
                if (proximaCasaDecimal >= limiteArredondamento) {
                    // Se for maior, arredonda para cima
                    return Math.ceil(numero * fator) / fator;
                } else {
                    // Se for menor ou igual, arredonda para baixo
                    return Math.floor(numero * fator) / fator;
                }
        }


        funcaoFactory.validarCMC7 = _validarCMC7;
        funcaoFactory.removerAcentos = _removerAcentos;
        funcaoFactory.removerEspacos = _removerEspacos;
        funcaoFactory.retornaSoLetras = _retornaSoLetras;
        funcaoFactory.retornaDiferencaEmHoras = _retornaDiferencaEmHoras;
        funcaoFactory.subtrairDias = _subtrairDias;
        funcaoFactory.formataDataNormal = _formataDataNormal;
        funcaoFactory.formataDataInvertida = _formataDataInvertida;
        funcaoFactory.formatarCpfCnpj = _formatarCpfCnpj;
        funcaoFactory.validarEAN = _validarEAN;
        funcaoFactory.montaMensagemErro = _montaMensagemErro;
        funcaoFactory.formatarBytes = _formatarBytes;
        funcaoFactory.validaEnderecoEmail = _validaEnderecoEmail;
        funcaoFactory.delay = _delay;
        funcaoFactory.compararDatas = _compararDatas;
        funcaoFactory.diferencaDatas = _diferencaDatas;
        funcaoFactory.retornaValorPorExtenso = _retornaValorPorExtenso;
        funcaoFactory.setarFocus = _setarFocus;
        funcaoFactory.retornarDiaInicioDiaFimSemana = _retornarDiaInicioDiaFimSemana;
        funcaoFactory.retornaMoney = _retornaMoney;
        funcaoFactory.removerCaracteresEspeciais = _removerCaracteresEspeciais;
        funcaoFactory.compararDatasParcela = _compararDatasParcela;
        funcaoFactory.verificarDataValida = _verificarDataValida;
        funcaoFactory.validarCPF = _validarCPF;
        funcaoFactory.validarCNPJ = _validarCNPJ;
        funcaoFactory.round = _round;
        funcaoFactory.retornaSoNumeros = _retornaSoNumeros;
        funcaoFactory.arredondar = _arredondar;

        return funcaoFactory;
    }]);
})();