﻿newERP.controller('PedidoController', ['$scope', '$state', 'ValidarFormularioService', '$timeout', 'DadosFormularioService', 'CalculaImpostoPedidoService', 'FuncaoService', 'ModalService', 'RelatorioService', function ($scope, $state, ValidarFormularioService, $timeout, DadosFormularioService, CalculaImpostoPedidoService, FuncaoService, ModalService, RelatorioService) {
    var enums = {
        adicionarItem: '+',
        removerItem: '-'
    }

    $scope.filtro = {
        pesquisa: '',
        dias: 14,
        cliente: { cli_id: null },
        vendedor: { ven_id: null },
        dataInicialSlider: new Date(),
        dataInicial: new Date(),
        dataFinal: new Date()
    }

    $scope.dadosPedido = {
        formaPagamento: {},
        valorTotalPedido: 0,
        totalPagamentos: 0,
        valorSubtotalPedido: 0,
        valorTotalItemPedido: 0,
        totalIPI: 0,
        totalSubstituicaoTributaria: 0
    };

    $scope.model = {
        listaPedidos: [],
        listaProdutos: [],
        listaFormaPagamento: []
    };

    $scope.dadosContribuinte = JSON.parse(dadosContribuinteAppService.buscarDadosContribuinte());

    $scope.exibicaoProduto = 'fa-barcode f-25';
    $scope.modoExibirPesquisaProduto = function (exibicaoProduto) {
        if (!!exibicaoProduto) {
            $scope.exibicaoProduto = (exibicaoProduto === 'fa-barcode f-25') ? 'fa-search' : 'fa-barcode f-25';
            $localStorage.exibicaoProduto = [{ 'modoExibir': $scope.exibicaoProduto }];
        } else {
            if (!!$localStorage.exibicaoProduto) {
                $scope.exibicaoProduto = $localStorage.exibicaoProduto[0].modoExibir;
            } else {
                $scope.exibicaoProduto = 'fa-barcode f-25';
                $localStorage.exibicaoProduto = [{ 'modoExibir': $scope.exibicaoProduto }];
            }
        }
        if ($scope.exibicaoProduto === 'fa-barcode f-25') { $scope.setarFocus('pro_descricao'); } else { $scope.setarFocus('pro_codigo'); }
    };

    $scope.$watch('filtro.dias', function (dia) {
        $scope.filtro.dataInicialSlider = FuncaoService.subtrairDias(new Date(), 14 - dia);
        $scope.model.listaPedidos = JSON.parse(pedidoAppService.listarTodos($scope.filtro.pesquisa, $scope.filtro.dataInicialSlider));
        console.log('$scope.model.listaPedidos', $scope.model.listaPedidos);
    });

    $scope.aplicarFiltros = function (filtros) {
        if (!!filtros.cliente) {
            if (filtros.cliente.Id) {
                filtros.cli_id = filtros.cliente.Id;
            } else {
                filtros.cli_id = null;
            }

        } else {
            filtros.cli_id = null;
        }
        if (!!filtros.vendedor) {
            filtros.ven_id = filtros.vendedor.ven_id;
        } else {
            filtros.ven_id = null;
        }
        delete filtros.cliente;
        delete filtros.vendedor;
        $scope.model.listaPedidos = JSON.parse(pedidoAppService.buscar(JSON.stringify(filtros)));
        console.log('$scope.model.listaPedidos', $scope.model.listaPedidos);
    }

    $scope.listarPedidos = function () {
        $scope.model.listaPedidos = JSON.parse(pedidoAppService.listarTodos($scope.filtro.pesquisa, $scope.filtro.dataInicial));
    };

    $scope.abrirManutencaoPedido = function (dadosPedido) {
        if (dadosPedido !== null) {
            var objPedido = JSON.parse(pedidoAppService.retornaPedido(dadosPedido.Id));
            DadosFormularioService.armazenarDados('pedido-varejo', objPedido);
            $state.go('newpdv.manutencao-pedido');
        } else {
            var objPedido = DadosFormularioService.retornaDados('pedido-varejo', { Id: null, ped_datainclusao: new Date() }).dados;
            DadosFormularioService.armazenarDados('pedido-varejo', objPedido);
            $state.go('newpdv.manutencao-pedido');
        }
    };

    $scope.iniciarDadosListaPedidos = function () {
        $scope.listarPedidos();
    };

    $scope.lerDadosManutencaoPedido = function () {
        var dados = DadosFormularioService.retornaDados('pedido-varejo', { Id: null }).dados;
        if (!!dados.Id) {
            $scope.dadosPedido = dados;
            $scope.dadosPedido.cliente = JSON.parse(clienteAppService.buscar(dados.ClienteId));
            $scope.buscarInformacoesCliente($scope.dadosPedido.cliente);
            $scope.dadosPedido.vendedor = JSON.parse(vendedorAppService.buscar(dados.ven_id));
            $scope.model.listaProdutos = [];
            $scope.dadosPedido.valorTotalItemPedido = 0;
            angular.forEach(dados.itens, function (item) {
                $scope.model.listaProdutos.push({
                    pro_id: item.pro_id,
                    pro_codigo: item.pro_codigo,
                    pro_descricao: item.pro_descricao,
                    pro_ncm: item.pro_ncm,
                    pro_ean: item.pro_ean,
                    ump_id: item.ump_id,
                    ump_casasdecimais: item.ump_casasdecimais,
                    grade: {
                        prg_id: item.prg_id,
                        mgp_descricao: item.mgp_descricao
                    },
                    preco: {
                        ltp_id: item.ltp_id,
                        ltp_nome: item.ltp_nome
                    },
                    quantidade: item.pdi_quantidade,
                    valorUnitario: item.pdi_valorunitario,
                    pdi_valoricms: item.pdi_valoricms,
                    pdi_valoripi: item.pdi_valoripi,
                    valorDescontoItem: item.pdi_valordesconto,
                    valorTotalItem: item.pdi_valortotal,
                    percDesconto: (item.pdi_valordesconto / item.pdi_valortotal),
                    percdesc: (item.pdi_valordesconto / item.pdi_valortotal)
                });

                $scope.dadosPedido.valorTotalItemPedido += item.pdi_valortotal;
                $scope.dadosPedido.totalIPI += item.pdi_valoripi;
                $scope.dadosPedido.totalSubstituicaoTributaria += item.pdi_valoricms;
                $scope.frete.valorFrete += item.pdi_valorfrete;
            })
            $scope.dadosPedido.valorSubtotalPedido = $scope.dadosPedido.valorTotalItemPedido;
            $scope.dadosPedido.valorTotalPedido = $scope.dadosPedido.valorSubtotalPedido + $scope.dadosPedido.totalIPI + $scope.dadosPedido.totalSubstituicaoTributaria + $scope.frete.valorFrete;

            $scope.model.listaFormaPagamento = [];
            $scope.dadosPedido.totalPagamentos = 0;
            angular.forEach(dados.formasPagamento, function (forma) {
                $scope.model.listaFormaPagamento.push({
                    formaPag: {
                        fpg_id: forma.fpg_id,
                        fpg_descricao: forma.fpg_descricao
                    },
                    condPag: {
                        cpg_id: forma.cpg_id,
                        cpg_descricao: forma.cpg_descricao
                    },
                    valorPagamento: forma.pfp_valor
                });
                $scope.dadosPedido.totalPagamentos += forma.pfp_valor;
            })
        } else {
            $scope.dadosPedido.Id = null;
            $scope.dadosPedido.ped_datainclusao = new Date();
        }
    };

    $scope.marcarTexto = function (nomeElemento) {
        document.getElementsByName(nomeElemento)[0].select();
    };

    $scope.buscarGradesProduto = function (codigoProduto) {
        $scope.listaGrades = JSON.parse(produtoAppService.listaGradesProduto(codigoProduto));
        $scope.listarGradeProduto = [];
        for (var i = 0; i < $scope.listaGrades.length; i++) {
            atri = {};
            atri.prg_id = $scope.listaGrades[i].prg_id;
            atri.mgp_id = $scope.listaGrades[i].atributos[0].mgp_id;
            atri.mgp_descricao = $scope.listaGrades[i].atributos[0].mgp_descricao;
            $scope.listarGradeProduto.push(atri);
        }
    }

    $scope.buscarListaPrecoProduto = function (codigoProduto, codigoProdutoGrade, codigoCliente, codigoVendedor) {
        codigoProduto = (!!codigoProduto == true) ? codigoProduto : null;
        codigoCliente = (!!codigoCliente == true) ? codigoCliente : null;
        codigoVendedor = (!!codigoVendedor == true) ? codigoVendedor : null;
        $scope.listaPrecos = JSON.parse(produtoAppService.listaPrecoProduto(codigoProduto, codigoProdutoGrade, codigoCliente, codigoVendedor));
    };

    $scope.carregaPreco = function (preco) {
        if (!!preco) {
            $scope.dadosPedido.produto.quantidade = 1;
            $scope.dadosPedido.produto.valorUnitario = preco.lpi_valorvenda;
            $scope.dadosPedido.produto.valorDescontoItem = null;
            $scope.dadosPedido.produto.percdesc = null;
        }
    };

    $scope.buscarInformacoesCliente = function (dadosCliente) {
        $scope.dadosPedido.cliente.pes_cpfcnpj = (!!dadosCliente.pef_cpf) ? String("00000000000" + dadosCliente.pef_cpf).slice(-11) : String("00000000000000" + dadosCliente.pej_cnpj).slice(-14);
        $scope.dadosPedido.cliente.pej_emailpessoacontato = dadosCliente.pej_emailpessoacontato;
        $scope.listarEnderecos(dadosCliente.Id, dadosCliente.pes_id);
        $scope.listarTelefone(dadosCliente.Id, dadosCliente.pes_id);
    };

    $scope.listarEnderecos = function (codigoCliente, codigoPessoa) {
        $scope.listaEnderecos = JSON.parse(clienteAppService.buscaEnderecoCliente(codigoCliente, codigoPessoa));
        if ($scope.listaEnderecos.length === 1) { $scope.dadosPedido.cliendereco = $scope.listaEnderecos[0]; }
    };

    $scope.listarTelefone = function (codigoCliente, codigoPessoa) {
        $scope.listaTelefone = JSON.parse(clienteAppService.buscaTelefoneCliente(codigoCliente, codigoPessoa));
        if ($scope.listaTelefone.length === 1) { $scope.dadosPedido.clitelefone = $scope.listaTelefone[0]; }
    };

    $scope.buscaInformacoesProduto = function (dadosProduto) {
        $scope.dadosPedido.produto.quantidade = 1;
        $scope.dadosPedido.produto.ump_casasdecimais = unidadeMedidaAppService.retornaCasasDecimais(dadosProduto.ump_id);
        $scope.dadosPedido.produto.pro_descricao = dadosProduto.pro_descricao;
        $scope.dadosPedido.produto.pro_id = dadosProduto.pro_id;
        $scope.dadosPedido.produto.pro_ean = dadosProduto.pro_ean;
        $scope.dadosPedido.produto.pro_ncm = dadosProduto.pro_ncm;
        var precoPadrao = JSON.parse(produtoAppService.retornaPrecoPadraoProduto(dadosProduto.pro_id));
        $scope.dadosPedido.produto.valorUnitario = precoPadrao !== 0 ? precoPadrao : swal("Preço padrão não Informado para o Produto!", "", "warning");

        $scope.buscarGradesProduto(dadosProduto.pro_id);
        var codigoCliente = (!!$scope.dadosPedido.cliente == true) ? $scope.dadosPedido.cliente.Id : null;
        var codigoVendedor = (!!$scope.dadosPedido.vendedor == true) ? $scope.dadosPedido.vendedor.ven_id : null;
        $scope.buscarListaPrecoProduto(dadosProduto.pro_id, dadosProduto.prg_id, codigoCliente, codigoVendedor);
    };

    $scope.calcularValorDesconto = function (perc, valorItem) {
        $scope.dadosPedido.produto.valorDescontoItem = null;
        if (perc * 100 > 100) {
            $scope.dadosPedido.produto.percdesc = null;
            $scope.dadosPedido.produto.valorDescontoItem = null;
        } else {
            if (perc > 0)
                $scope.dadosPedido.produto.valorDescontoItem = (valorItem * perc);
        }
    };

    $scope.calcularPercDesconto = function (desconto, total) {
        $scope.dadosPedido.produto.percdesc = null;
        if (desconto > total) {
            $scope.dadosPedido.produto.percdesc = null;
            $scope.dadosPedido.produto.valorDescontoItem = null;
        } else {
            if (desconto > 0)
                $scope.dadosPedido.produto.percdesc = (desconto / total);
        }
    };

    $scope.calcularTotalItem = function () {
        $scope.dadosPedido.produto.valorTotal = $scope.dadosPedido.produto.valorUnitario * $scope.dadosPedido.produto.quantidade;

    };

    $scope.listaValidacaoFormularioProduto = [
        { nome: 'prodescricao', obrigatorio: 'Produto é Obrigatório', invalido: '' },
        { nome: 'pit_qtde', obrigatorio: 'Quantidade é Obrigatória', invalido: '' },
        { nome: 'pit_valorunitario', obrigatorio: 'Valor Unitário é Obrigatório', invalido: '' }
    ];

    $scope.validarFormularioItemPedido = function (formulario, dadosProduto) {
        $scope.listaFormularioInvalidoProduto = [];

        if ($scope.dadosPedido.cliente === undefined) {
            $scope.listaValidacaoFormularioProduto[3] = { nome: 'cli_descricao', obrigatorio: 'Selecione um Cliente!', invalido: '' };
        } else {
            $scope.listaValidacaoFormularioProduto.splice(3);
        };

        ValidarFormularioService.listaFormularioInvalido(formulario, $scope.listaValidacaoFormularioProduto).then(function (retorno) {
            $scope.listaFormularioInvalidoProduto = retorno.lista;
            $scope.mensagemFormularioInvalidoProduto = retorno.mensagem;

            if ($scope.listaFormularioInvalidoProduto.length === 0) $scope.salvarProdutoPedido(dadosProduto);
        });
    };

    $scope.salvarProdutoPedido = function (dadosProduto) {
        if ($scope.model.listaProdutos.length > 0) {
            var produtoAdicionado = false;
            for (var i = 0; i < $scope.model.listaProdutos.length; i++) {
                if ($scope.model.listaProdutos[i].pro_id === dadosProduto.pro_id) {
                    if ($scope.model.listaProdutos[i].grade.prg_id === dadosProduto.grade.prg_id) {
                        if ($scope.model.listaProdutos[i].preco.ltp_id === dadosProduto.preco.ltp_id) {
                            swal("Produto já adicionado!", "", "warning");
                            produtoAdicionado = true;
                        }
                    }
                }
            }

            if (!produtoAdicionado) {
                $scope.alteracaoProduto = false;
                $scope.calcularTotalItemPedido(dadosProduto, enums.adicionarItem);
                $scope.dadosPedido.produto = null;
            }
        } else {
            $scope.alteracaoProduto = false;
            $scope.calcularTotalItemPedido(dadosProduto, enums.adicionarItem);
            $scope.dadosPedido.produto = null;
        }
    };

    $scope.editarProdutoPedido = function (posicao, dadosProduto) {
        $scope.alteracaoProduto = true;
        $scope.dadosPedido.produto = dadosProduto;

        $scope.buscarGradesProduto(dadosProduto.pro_id);
        var codigoCliente = (!!$scope.dadosPedido.cliente == true) ? $scope.dadosPedido.cliente.Id : null;
        var codigoVendedor = (!!$scope.dadosPedido.vendedor == true) ? $scope.dadosPedido.vendedor.ven_id : null;
        $scope.buscarListaPrecoProduto(dadosProduto.pro_id, dadosProduto.prd_id, codigoCliente, codigoVendedor);

        $scope.model.listaProdutos.splice(posicao, 1);
        $scope.calcularTotalItemPedido(dadosProduto, enums.removerItem);
    };

    $scope.removerProdutoPedido = function (posicao, dadosProduto) {
        swal({
            title: "Remover o item " + dadosProduto.pro_descricao + "?",
            text: "",
            type: "warning",
            showCancelButton: true,
            cancelButtonText: "Não",
            confirmButtonClass: "btn-danger",
            confirmButtonText: "Sim, quero remover"
        }, function (acao) {
            if (acao)
                $timeout(function () {
                    $scope.model.listaProdutos.splice(posicao, 1);
                    $scope.calcularTotalItemPedido(dadosProduto, enums.removerItem);
                }, 100);
        });
    };

    $scope.salvarFormaPagamento = function (dadosFormaPagamento) {
        var frmAdicionada = false;
        if ($scope.model.listaFormaPagamento.length > 0) {
            for (var i = 0; i < $scope.model.listaFormaPagamento.length; i++) {
                if ($scope.model.listaFormaPagamento[i].formaPag.fpg_id === dadosFormaPagamento.formaPag.fpg_id) {
                    swal("Forma de Pagamento já adicionada!", "", "warning");
                    var frmAdicionada = true;
                }
            }

            if (!frmAdicionada) {
                $scope.alteracaoFormaPagamento = false;
                $scope.model.listaFormaPagamento.push(dadosFormaPagamento);
                $scope.dadosPedido.formaPagamento = null;
                $scope.calcularTotalPagamentos(dadosFormaPagamento, enums.adicionarItem);
            }
        } else {
            $scope.alteracaoFormaPagamento = false;
            $scope.model.listaFormaPagamento.push(dadosFormaPagamento);
            $scope.dadosPedido.formaPagamento = null;
            $scope.calcularTotalPagamentos(dadosFormaPagamento, enums.adicionarItem);
        }
    };

    $scope.editarFormaPagamento = function (posicao, dadosFormaPagamento) {
        $scope.alteracaoFormaPagamento = true;
        $scope.dadosPedido.formaPagamento = dadosFormaPagamento;
        $scope.model.listaFormaPagamento.splice(posicao, 1);
        $scope.calcularTotalPagamentos(dadosFormaPagamento, enums.removerItem);
        DadosFormularioService.armazenarDados('pedido-varejo-formaPgto', $scope.model.listaFormaPagamento);
    };

    $scope.removerFormaPagamento = function (posicao, dadosFormaPagamento) {
        swal({
            title: "Remover a forma " + dadosFormaPagamento.formaPag.fpg_descricao + " / " + dadosFormaPagamento.condPag.cpg_descricao + " ?",
            text: "",
            type: "warning",
            showCancelButton: true,
            cancelButtonText: "Não",
            confirmButtonClass: "btn-danger",
            confirmButtonText: "Sim, quero remover"
        }, function (acao) {
            if (acao)
                $timeout(function () {
                    $scope.model.listaFormaPagamento.splice(posicao, 1);
                    $scope.calcularTotalPagamentos(dadosFormaPagamento, enums.removerItem);
                }, 100);
        });
    };

    $scope.listaValidacaoFormularioPedido = [
        { nome: 'cli_descricao', obrigatorio: 'Cliente é Obrigatório', invalido: '' },
        { nome: 'cliendereco', obrigatorio: 'Endereço do cliente é obrigatório', invalido: '' },
        { nome: 'clitelefone', obrigatorio: 'Telefone do cliente é obrigatório', invalido: '' },
        { nome: 'ped_vendedor', obrigatorio: 'Vendedor é obrigatório', invalido: '' },
        { nome: 'ped_datainclusao', obrigatorio: 'Data do Pedido é obrigatória', invalido: '' }
    ];

    $scope.validarFormularioPedido = function (formulario, dadosPedido) {
        $scope.listaValidacaoFormularioInvalidoPedido = [];

        if ((Math.round($scope.dadosPedido.totalPagamentos * 100) / 100) !== (Math.round($scope.dadosPedido.valorTotalPedido * 100) / 100) || $scope.dadosPedido.totalPagamentos === 0) {
            $scope.listaValidacaoFormularioPedido[5] = { nome: 'valorPagamento', obrigatorio: 'Valor Total do Pedido é Zero ou difere do Total de Pagamentos!', invalido: '' };
        } else {
            $scope.listaValidacaoFormularioPedido.splice(5);
        };
        if ($scope.model.listaFormaPagamento.length === 0) {
            $scope.listaValidacaoFormularioPedido[6] = { nome: 'formaPag', obrigatorio: 'Adicione uma Forma de Pagamento!', invalido: '' };
        } else {
            $scope.listaValidacaoFormularioPedido.splice(6);
        };
        if ($scope.model.listaProdutos.length === 0) {
            $scope.listaValidacaoFormularioPedido[7] = { nome: 'prodescricao', obrigatorio: 'Adicione um produto ao Pedido!', invalido: '' };
        } else {
            $scope.listaValidacaoFormularioPedido.splice(7);
        };

        ValidarFormularioService.listaFormularioInvalido(formulario, $scope.listaValidacaoFormularioPedido).then(function (retorno) {
            $scope.listaValidacaoFormularioInvalidoPedido = retorno.lista;
            $scope.mensagemFormularioInvalidoPedido = retorno.mensagem;

            if ($scope.listaValidacaoFormularioInvalidoPedido.length === 0) { $scope.salvarPedido(dadosPedido); };
        });
    };

    $scope.enviarPedidoNewerp = function (dadosPedido) {
        var resultado = false;
        if (navigator.onLine) {
            swal({
                title: "Deseja Enviar os Dados para o Newerp?!",
                text: "",
                type: "warning",
                showCancelButton: true,
                cancelButtonText: "Não",
                confirmButtonClass: "btn-info",
                confirmButtonText: "Enviar"
            }, function (acao) {
                if (acao) {
                    if (pedidoAppService.enviarPedidoNewerp(dadosPedido.Id)) {
                        swal("Dados Enviados com Sucesso!", "", "success");
                    }
                }
            });
        } else {
            swal('Você está sem conexão com internet', "", "warning");
            return;
        }
    };

    $scope.salvarPedido = function (dadosPedido) {
        var pedido = {
            Id: null,
            ped_id: null,
            loc_id: null,
            ped_numero: "",
            cli_id: dadosPedido.cliente.cli_id,
            ClienteId: dadosPedido.cliente.Id,
            ven_id: dadosPedido.vendedor.ven_id,
            ped_datainclusao: dadosPedido.ped_datainclusao,
            ped_dataprevisaoentrega: dadosPedido.ped_datainclusao,
            ped_datavalidade: dadosPedido.ped_datainclusao,
            ped_observacao: dadosPedido.ped_observacao,
            ped_responsavelpedido: "",
            pes_cep: dadosPedido.cliendereco.pee_cep,
            pes_cidade: dadosPedido.cliendereco.pee_cidade,
            pes_uf: dadosPedido.cliendereco.pee_uf,
            pes_bairro: dadosPedido.cliendereco.pee_bairro,
            pes_nroestabelecimento: dadosPedido.cliendereco.pee_numero,
            pes_endereco: dadosPedido.cliendereco.pee_endereco,
            pes_telefone: dadosPedido.clitelefone.psc_numero,
            stp_id: null,
            itens: [],
            formasPagamento: [],
            valorFrete: $scope.frete.valorFrete
        };

        angular.forEach($scope.model.listaProdutos, function (item) {
            pedido.itens.push({
                pro_id: item.pro_id,
                pro_descricao: item.pro_descricao,
                quantidade: item.quantidade,
                valorUnitario: item.valorUnitario,
                valorTotalItem: item.valorTotalItem,
                valorDescontoItem: item.valorDescontoItem,
                pdi_valoripi: item.pdi_valoripi,
                pdi_valoricms: item.pdi_valoricms,
                prg_id: item.grade.prg_id,
                mgp_descricao: item.grade.mgp_descricao
            });
        })

        angular.forEach($scope.model.listaFormaPagamento, function (forma) {
            pedido.formasPagamento.push({
                fpg_id: forma.formaPag.fpg_id,
                fpg_descricao: forma.formaPag.fpg_descricao,
                cpg_id: forma.condPag.cpg_id,
                cpg_descricao: forma.condPag.cpg_descricao,
                valorPagamento: forma.valorPagamento
            });
        })

        pedidoAppService.incluir(JSON.stringify(pedido));
        DadosFormularioService.limparDados('pedido-varejo');
        swal({
            title: 'Pedido Adicionado com Sucesso!',
            text: "",
            type: "success",
            confirmButtonClass: "btn-info",
            confirmButtonText: "OK",
            closeOnConfirm: true
        }, function (acao) {
            if (acao) {
                $timeout(function () {
                    $state.go('newpdv.consulta-pedido');
                }, 100);
            }
        });
    };

    $scope.setarFocus = function (nomeElemento) {
        if ((parseInt(nomeElemento))) {
            $scope.paginaAtiva = parseInt(nomeElemento);
        } else {
            $timeout(function () {
                document.getElementsByName(nomeElemento)[0].focus();
            });

            $timeout(function () {
                $scope.$apply(function () {
                    $('select[name="' + nomeElemento + '"]').chosen({});
                    $('select[name="' + nomeElemento + '"]').trigger("chosen:open");
                });
            });
        };
    };

    $scope.calcularTotalPagamentos = function (dadosFormaPagamento, operacao) {
        var valorPagamento = dadosFormaPagamento.valorPagamento;
        if (operacao === enums.adicionarItem) {
            $scope.dadosPedido.totalPagamentos += valorPagamento;
        } else {
            $scope.dadosPedido.totalPagamentos -= valorPagamento;
        }

        $scope.dadosPedido.formaPagamento = (!!$scope.dadosPedido.formaPagamento) ? $scope.dadosPedido.formaPagamento : {};
        $scope.dadosPedido.formaPagamento.valorPagamento = ($scope.dadosPedido.valorTotalPedido - $scope.dadosPedido.totalPagamentos);
        if (!!$scope.dadosPedido.formaPagamento.valorPagamento)
            $scope.setarFocus('formaPag');
    };

    $scope.calcularTotalItemPedido = function (dadosProduto, operacao) {
        var icmsOrigemDestino = JSON.parse(icmsOrigemDestinoAppService.buscaIcmsOrigemDestinoProduto(dadosProduto.pro_id, $scope.dadosContribuinte[0].loc_uf, $scope.dadosPedido.cliendereco.pee_uf));
        var ncm = JSON.parse(ncmAppService.buscarNcm(dadosProduto.pro_ncm));

        if (ncm === null) {
            swal('Produto Sem NCM cadastrada!', "", "warning");
            return;
        }

        var itemCalculoImposto = {
            pdi_valorunitario: dadosProduto.valorUnitario,
            pdi_qtde: dadosProduto.quantidade,
            ncm_percentual: ncm.ncm_percentual * 100,
            cst_id: icmsOrigemDestino[0].cst_id,
            pdi_valordesconto: (!!dadosProduto.valorDescontoItem) ? dadosProduto.valorDescontoItem : 0,
            iod_percicmsreducaobc: (!!icmsOrigemDestino[0].iod_percicmsreducaobc) ? icmsOrigemDestino[0].iod_percicmsreducaobc : 0,
            iod_percicms: (!!icmsOrigemDestino[0].iod_percicms) ? icmsOrigemDestino[0].iod_percicms : 0,
            mva_percaliquotaicmsreducao: 10,
            mva_percmva: 10,
            mva_percaliquotaicms: 10
        };

        dadosProduto.valorDescontoItem = (!!dadosProduto.valorDescontoItem) ? dadosProduto.valorDescontoItem : 0;
        dadosProduto.valorTotalItem = ((dadosProduto.valorUnitario * dadosProduto.quantidade) - dadosProduto.valorDescontoItem);
        dadosProduto.percDesconto = (dadosProduto.valorDescontoItem / (dadosProduto.valorUnitario * dadosProduto.quantidade));

        CalculaImpostoPedidoService.calculaImpostoPedidoItem(itemCalculoImposto).then(function (retornoItem) {
            if (operacao === enums.adicionarItem) {
                dadosProduto.pdi_valoripi = parseFloat(retornoItem.pdi_valoripi);
                dadosProduto.pdi_valoricms = retornoItem.pdi_valoricmsst;
                $scope.dadosPedido.totalIPI += parseFloat(retornoItem.pdi_valoripi);
                $scope.dadosPedido.totalSubstituicaoTributaria += retornoItem.pdi_valoricmsst;
                $scope.dadosPedido.valorTotalItemPedido += dadosProduto.valorTotalItem;
                $scope.dadosPedido.valorSubtotalPedido = $scope.dadosPedido.valorTotalItemPedido;
                $scope.dadosPedido.valorTotalPedido = $scope.dadosPedido.valorSubtotalPedido + $scope.dadosPedido.totalIPI + $scope.dadosPedido.totalSubstituicaoTributaria + $scope.frete.valorFrete;
                $scope.dadosPedido.formaPagamento.valorPagamento = $scope.dadosPedido.valorTotalPedido;
                $scope.model.listaProdutos.push(dadosProduto);
            } else {
                $scope.dadosPedido.totalIPI -= parseFloat(retornoItem.pdi_valoripi);
                $scope.dadosPedido.totalSubstituicaoTributaria -= retornoItem.pdi_valoricmsst;
                $scope.dadosPedido.valorTotalItemPedido -= dadosProduto.valorTotalItem;
                $scope.dadosPedido.valorSubtotalPedido = $scope.dadosPedido.valorTotalItemPedido;
                $scope.dadosPedido.valorTotalPedido = $scope.dadosPedido.valorSubtotalPedido + $scope.dadosPedido.totalIPI + $scope.dadosPedido.totalSubstituicaoTributaria + $scope.frete.valorFrete;
                $scope.dadosPedido.formaPagamento.valorPagamento = $scope.dadosPedido.valorTotalPedido;
            }
        });
    };

    $scope.calcularValorDescTotal = function (percDesconto, valorTotalPedido) {
        $scope.dadosPedido.percentualAcrescimo = 0;
        $scope.dadosPedido.valorAcrescimo = 0;
        $scope.dadosPedido.valorDesconto = 0;
        if (percDesconto > 0) { $scope.dadosPedido.valorDesconto = (valorTotalPedido * percDesconto); }
        $scope.calcularTotalPedido();
    };

    $scope.calcularPercDescTotal = function (valorDesconto, valorTotalPedido) {
        $scope.dadosPedido.percentualAcrescimo = 0;
        $scope.dadosPedido.valorAcrescimo = 0;
        $scope.dadosPedido.percentualDesconto = 0;
        if (valorDesconto > valorTotalPedido) {
            $scope.dadosPedido.percentualDesconto = 1;
            $scope.dadosPedido.valorDesconto = valorTotalPedido;
        } else {
            if (valorDesconto > 0) {
                $scope.dadosPedido.percentualDesconto = (valorDesconto / valorTotalPedido);
            }
        }
        $scope.calcularTotalPedido();
    };

    $scope.calcularPercAcrescTotal = function (valorAcrescimo, valorTotalPedido) {
        $scope.dadosPedido.valorDesconto = 0;
        $scope.dadosPedido.percentualDesconto = 0;
        $scope.dadosPedido.percentualAcrescimo = 0;
        if (valorAcrescimo > 0) {
            $scope.dadosPedido.percentualAcrescimo = (valorAcrescimo / valorTotalPedido);
        }
        $scope.calcularTotalPedido();
    };

    $scope.calcularValorAcresc = function (percAcrescimo, valorTotalPedido) {
        $scope.dadosPedido.valorDesconto = 0;
        $scope.dadosPedido.percentualDesconto = 0;
        $scope.dadosPedido.valorAcrescimo = 0;
        if (percAcrescimo > 0) {
            $scope.dadosPedido.valorAcrescimo = (valorTotalPedido * percAcrescimo);
        }
        $scope.calcularTotalPedido();
    };

    $scope.calcularTotalPedido = function () {
        var somaValoresImpostos = parseFloat($scope.dadosPedido.totalIPI + $scope.dadosPedido.totalSubstituicaoTributaria);
        var totalFretePedido = $scope.frete.valorFrete
        var valorAcrescimo = (!!$scope.dadosPedido.valorAcrescimo) ? $scope.dadosPedido.valorAcrescimo : 0;
        var valorDesconto = (!!$scope.dadosPedido.valorDesconto) ? $scope.dadosPedido.valorDesconto : 0;
        $scope.dadosPedido.valorTotalPedido = parseFloat(totalFretePedido + $scope.dadosPedido.valorSubtotalPedido + somaValoresImpostos + valorAcrescimo - valorDesconto);
        $scope.dadosPedido.formaPagamento.valorPagamento = $scope.dadosPedido.valorTotalPedido;
    };

    $scope.listaValidacaoFormularioFormaPagamento = [
        { nome: 'formaPag', obrigatorio: 'Forma de Pagamento é Obrigatória', invalido: '' },
        { nome: 'condPag', obrigatorio: 'Condição de Pagamento é Obrigatória', invalido: '' },
        { nome: 'valorPagamento', obrigatorio: 'Valor do Pagamento é Obrigatório', invalido: '' }
    ];

    $scope.validarFormularioFormaPagamento = function (formulario, dadosFormaPagamento) {
        $scope.listaFormularioInvalidoFormaPagamento = [];

        if ($scope.model.listaProdutos.length === 0) {
            $scope.listaValidacaoFormularioFormaPagamento[3] = { nome: 'prodescricao', obrigatorio: 'Adicione um produto ao Pedido!', invalido: '' };
        } else {
            $scope.listaValidacaoFormularioFormaPagamento.splice(3);
        };

        if (!!dadosFormaPagamento && !!dadosFormaPagamento.valorPagamento) {
            if (($scope.dadosPedido.valorTotalPedido - $scope.dadosPedido.totalPagamentos) < dadosFormaPagamento.valorPagamento) {
                $scope.listaValidacaoFormularioFormaPagamento[4] = { nome: 'valorPagamento', obrigatorio: 'O valor do Pagamento não pode ser maior que o total!', invalido: '' };
            } else {
                $scope.listaValidacaoFormularioFormaPagamento.splice(4);
            }
        }

        ValidarFormularioService.listaFormularioInvalido(formulario, $scope.listaValidacaoFormularioFormaPagamento).then(function (retorno) {
            $scope.listaFormularioInvalidoFormaPagamento = retorno.lista;
            $scope.mensagemFormularioInvalidoFormaPagamento = retorno.mensagem;

            if ($scope.listaFormularioInvalidoFormaPagamento.length === 0) {
                $scope.salvarFormaPagamento(dadosFormaPagamento);
            };
        });
    };

    $scope.voltarListaPedido = function () {
        DadosFormularioService.limparDados('pedido-varejo');
        $state.go('newpdv.consulta-pedido');
    };

    $scope.cancelarPedido = function (pedido) {
        swal({
            title: "Deseja realmente Cancelar o pedido Nº " + pedido.ped_numero,
            text: "",
            type: "warning",
            showCancelButton: true,
            cancelButtonText: "Não",
            confirmButtonClass: "btn-danger",
            confirmButtonText: "Sim, quero cancelar",
            closeOnConfirm: true
        }, function (acao) {
            if (acao) {
                if (!!pedidoAppService.cancelar(pedido.Id)) {
                    swal("Pedido cancelado com sucesso!", "", "success");
                    $scope.listarPedidos();
                }
            }
        })
    };

    $scope.duplicarPedido = function (dadosPedido) {
        dadosPedido.Id = null;
        DadosFormularioService.armazenarDados('pedido-varejo', dadosPedido);
        $state.go('newpdv.manutencao-pedido');
    };

    $scope.visualizarRelatorio = function (idPedido) {
        if (navigator.onLine) {
            RelatorioService.exibirRelatorioJasper(29, [
                {
                    'nome': 'idPedido',
                    'valor': idPedido
                }
            ]);
        }
    };

    /** MODAL FRETE **/

    $scope.frete = {
        valorFrete: 0,
        dadosCliente: {}
    };

    $scope.dadosVenda = {
        listaEnderecoDestinatario: {}
    };
    $scope.abrirModalFrete = function () {
        $scope.dadosVenda.listaEnderecoDestinatario = $scope.listaEnderecos;
        $scope.modalFrete = ModalService.model($scope, 'views/pdv/varejo/modalFrete.html', 'lg', true, true, true);
    };
    $scope.montaDadosEndereco = function (dadosEndereco) {
        $scope.frete.dadosCliente.cep = dadosEndereco.pee_cep;
        $scope.frete.dadosCliente.cidade = dadosEndereco.pee_cidade;
        $scope.frete.dadosCliente.uf = dadosEndereco.pee_uf;
        $scope.frete.dadosCliente.endereco = dadosEndereco.pee_endereco;
        $scope.frete.dadosCliente.bairro = dadosEndereco.pee_bairro;
        $scope.frete.dadosCliente.numero = dadosEndereco.pee_numero;
        $scope.frete.dadosCliente.complemento = dadosEndereco.pee_complemento;
    };
    /** MODAL FRETE **/

    $scope.emitirCupom = function (pedidoId) {
        var objPedido;
        if (pedidoId) {
            objPedido = JSON.parse(pedidoAppService.retornaPedido(pedidoId));
        }
        objCliente = JSON.parse(clienteAppService.buscar(objPedido.cli_id, objPedido.cli_id));
        objVendedor = JSON.parse(vendedorAppService.buscar(objPedido.ven_id));


        var dados = {
            iniciarVenda: true,
            pes_id: objPedido.pes_id,
            cli_id: objPedido.cli_id,
            ClienteId: objPedido.ClienteId,
            pes_cpfcnpj: !!objCliente.pef_cpf ? objCliente.pef_cpf : objCliente.pej_cnpj,
            pes_nome: objCliente.pes_nome,
            ven_id: objVendedor == null ? null : objVendedor.ven_id,
            ven_nome: objVendedor == null ? "" : objVendedor.ven_nome,
            idPedido: objPedido.ped_id,
            subTotal: 0,
            subTotalBruto: 0,
            totalDescontos: 0,
            subTotalNota: 0,
            totalAcrescimos: 0,
            descontoEmValorOuPercentual: '$',
            acrescimoEmValorOuPercentual: '$',
            listaItens: [],
            pagamento: [],

        };
        for (var i = 0; i < objPedido.itens.length; i++) {
            var item = objPedido.itens[i];

            /* QUANTOS ITENS SERÃO COMPRADOS */
            if (item.pdi_quantidade > 0) {
                item.vlrDesconto = 0;
                item.vlrAcrescimo = 0;

                var grade = {};
                if (!!item.prg_id) {
                    grade = JSON.parse(produtoAppService.listaGradesProduto(item.pro_id, item.prg_id));
                };

                var temporaria = {
                    produto: item.pro_descricao,
                    ean: item.pro_ean,
                    quantidade: item.pdi_quantidade,
                    pro_codigo: item.pro_id,
                    pro_id: item.pro_id,
                    vlrUnitario: item.pdi_valorunitario,
                    totalItem: item.pdi_valorunitario * item.pdi_quantidade,
                    valorTotalItem: ((item.pdi_valorunitario * item.pdi_quantidade) - item.pdi_valordesconto) + item.pdi_valoracrescimo,
                    totalItemDesconto: ((item.pdi_valorunitario * item.pdi_quantidade) - item.pdi_valordesconto) + item.pdi_valoracrescimo,
                    vlrDescontoItem: 0,
                    desconto: 0,
                    vlrAcrescimo: item.pdi_valoracrescimo,
                    acrescimo: 0,
                    vlrDesconto: item.pdi_valordesconto,
                    desconto: 0,
                    vlrPrdAnt: item.pdi_quantidade * item.pdi_valorunitario,
                    valorUnitario: item.pdi_valorunitario,
                    vlrOutro: item.pdi_valoroutrasdespesas,
                    vlrFrete: item.pdi_valorfrete,
                    prg_id: !!item.prg_id ? item.prg_id : 0,
                    grade: item.mgp_descricao
                };
                dados.listaItens.push(temporaria);
            }
        };
        dados.qtdTotalItens = dados.listaItens.length;

        for (var i = 0; i < objPedido.formasPagamento.length; i++) {
            var fpg = objPedido.formasPagamento[i];
            objFormaPagamento = JSON.parse(formaPagamentoAppService.buscarFormaPagamento(fpg.fpg_id));
            objCondicaoPagamento = JSON.parse(condicaoPagamentoAppService.buscarCondicaoPagamento(fpg.cpg_id));
            var temporariaPagamento = {
                valorPago: fpg.pfp_valor,
                formaPagamento: objFormaPagamento,
                condicaoPagamento: objCondicaoPagamento
            };
            dados.pagamento.push(temporariaPagamento);
        };

        console.log(dados);
        DadosFormularioService.armazenarDados('venda-varejo', dados);
        $state.go('newpdv.venda-varejo');
    };


}]);