﻿newERP.controller('OrcamentoController', ['$scope', 'ModalService', 'FuncaoService', 'DadosFormularioService', '$state', 'ValidarFormularioService', 'growlService', 'RelatorioService', '$timeout', '$localStorage', function ($scope, ModalService, FuncaoService, DadosFormularioService, $state, ValidarFormularioService, growlService, RelatorioService, $timeout, $localStorage) {

    $scope.filtro = {
        pesquisa: '',
        dias: 14,
        dataInicialSlider: new Date(),
        dataInicial: new Date(),
        dataFinal: new Date()
    };

    $scope.model = {
        listaOrcamentos: [],
        pesquisaAvancada: false,
        cpfCnpjCliente: null,
        listaFormaPagamento: []
    };

    $scope.percentualTotal = 0;
    $scope.descricaoBotaoFormaOrcamento = 'Adicionar Forma';
    $scope.mostratipo = '$';
    $scope.dados = {
        produto: {},
        eanProduto: null,
        valorTotalItens: 0,
        dadosEdicaoProduto: null,
        formaPagamento: null,
        valorPagamento: 0,
        valorTotalDesconto: 0,
        orf_numeroparcelas: 1,
        orf_observacoes: "",
        orf_valorfrete: null,
        orf_percdesconto: null,
        orf_valortotal: null,
        orf_pagamento: null

    };

    $scope.abrirModalGradesVendas = function () {
        if (!!$scope.modalGradesVendas) {
            $scope.modalGradesVendas.dismiss();
            delete $scope.modalGradesVendas;
        }

        $scope.modalGradesVendas = ModalService.model($scope, 'views/pdv/varejo/modalProdutosGradesVendas.html', 'lg', true, 'static', true);
        jaAbriuModalGradeProduto = true;
    }

    $scope.listarOrcamentos = function () {
        $scope.model.listaOrcamentos = JSON.parse(orcamentoAppService.listarTodos($scope.filtro.pesquisa, $scope.filtro.dataInicial));
    };

    $scope.$watchCollection('filtro.dias', function (dia) {
        $scope.filtro.dataInicialSlider = FuncaoService.subtrairDias(new Date(), 14 - dia);
        $scope.model.listaOrcamentos = JSON.parse(orcamentoAppService.listarTodos($scope.filtro.pesquisa, $scope.filtro.dataInicialSlider));
    });

    $scope.aplicarFiltros = function (filtros) {
        var filtrosOrcamento = angular.copy(filtros);

        if (!!filtros.cliente) {
            filtrosOrcamento.ClienteId = filtros.cliente.Id;
        } else {
            filtrosOrcamento.ClienteId = null;
        }

        if (!!filtros.vendedor) {
            filtrosOrcamento.ven_id = filtros.vendedor.ven_id;
        } else {
            filtrosOrcamento.ven_id = null;
        }

        delete filtrosOrcamento.pesquisaAvancada;
        delete filtrosOrcamento.cliente;
        delete filtrosOrcamento.vendedor;
        delete filtrosOrcamento.pesquisa;
        $scope.model.listaOrcamentos = JSON.parse(orcamentoAppService.buscar(JSON.stringify(filtrosOrcamento)));
    };

    $scope.cancelarOrcamento = function (dadosOrcamento) {
        swal({
            title: "Deseja realmente Cancelar o orçamento Nº " + dadosOrcamento.orc_numero,
            text: "",
            type: "warning",
            showCancelButton: true,
            cancelButtonText: "Não",
            confirmButtonClass: "btn-danger",
            confirmButtonText: "Sim, quero cancelar",
            closeOnConfirm: true
        }, function (acao) {
            if (acao) {
                if (!!orcamentoAppService.excluir(dadosOrcamento.Id)) {
                    swal("Orçamento cancelado com sucesso!", "", "success");
                    $scope.listarOrcamentos();
                };
            };
        });
    };

    $scope.duplicarOrcamento = function (dadosOrcamento) {
        var orcamento = JSON.parse(orcamentoAppService.retornaOrcamento(dadosOrcamento.Id));
        orcamento.Id = null;
        orcamento.duplicar = true;
        DadosFormularioService.armazenarDados('orcamento-manutencao', orcamento);
        $state.go('newpdv.manutencao-orcamento');
    };

    $scope.abrirManutencaoVenda = function (dadoOrcamento) {
        var dadosOrcamento = JSON.parse(orcamentoAppService.retornaOrcamento(dadoOrcamento.Id));
        dadosOrcamento.itens = (!!dadosOrcamento.itens) ? dadosOrcamento.itens : [];
        dadosOrcamento.formasPagamento = (!!dadosOrcamento.formasPagamento) ? dadosOrcamento.formasPagamento : [];

        var valorTotalItens = 0;
        var valorTotalItensComDesconto = 0;
        var valorTotalDesconto = 0;
        var listaItens = [];
        dadosOrcamento.itens.map(function (item) {
            valorTotalItens += (item.oit_valorunitario * item.oit_qtde);
            valorTotalItensComDesconto += (item.oit_valorunitario * item.oit_qtde) - item.oit_desconto;
            valorTotalDesconto += item.oit_desconto;

            listaItens.push(
                {
                    "quantidade": item.oit_qtde,
                    "ean": null,
                    "produto": item.pro_descricao,
                    "pro_id": item.pro_id,
                    "prg_id": item.prg_id,
                    "mgp_descricao": item.mgp_descricao,
                    "produto": item.pro_descricao,
                    "grade": item.grade,
                    "totalItemDesconto": (item.oit_valorunitario * item.oit_qtde) - item.oit_desconto,
                    "totalItem": (item.oit_valorunitario * item.oit_qtde),
                    "desconto": ((item.oit_desconto * 100) / (item.oit_valorunitario * item.oit_qtde)),
                    "vlrDesconto": item.oit_desconto,
                    "vlrPrdAnt": (item.oit_valorunitario * item.oit_qtde),
                    "valorUnitario": item.oit_valorunitario,
                    "vlrOutro": 0,
                    "vlrFrete": 0
                }
            )
        })

        var pagamento = [];

        if (!!dadosOrcamento.pef_cpf) dadosOrcamento.pes_cpfcnpj = dadosOrcamento.pef_cpf;
        if (!!dadosOrcamento.pej_cnpj) dadosOrcamento.pes_cpfcnpj = dadosOrcamento.pej_cnpj;
        var dadosVenda = {
            "descontoEmValorOuPercentual": "$",
            "acrescimoEmValorOuPercentual": "$",
            "subTotal": valorTotalItens,
            "subTotalNota": valorTotalItensComDesconto,
            "totalDescontos": valorTotalDesconto,
            "totalAcrescimos": 0,
            "totalNota": valorTotalItensComDesconto,
            "cli_id": dadosOrcamento.cli_id,
            "ClienteId": dadosOrcamento.ClienteId,
            "pagamento": pagamento,
            "pes_cpfcnpj": dadosOrcamento.pes_cpfcnpj,
            "pes_nome": dadosOrcamento.pes_nome,
            "ven_id": dadosOrcamento.ven_id,
            "ven_nome": dadosOrcamento.ven_nome,
            "listaItens": listaItens,
            "qtdTotalItens": 1,
            "descontoTotal": valorTotalDesconto,
            "acrescimoTotal": 0,
            "subTotalBruto": valorTotalItens,
            "listaEnderecoDestinatario": [],
            "vlrFrete": 0,
            "cep": null,
            "cidade": null,
            "uf": null,
            "endereco": null,
            "bairro": null,
            "numero": null,
            "complemento": null,
            "observacao": dadosOrcamento.orc_observacao
        };

        dadosVenda.iniciarVenda = true;
        DadosFormularioService.armazenarDados('venda-varejo', dadosVenda);
        $state.go('newpdv.venda-varejo');
    };

    $scope.visualizarRelatorio = function (idOrcamento) {
        var dadosRelatorio = JSON.parse(orcamentoAppService.imprimir(idOrcamento));
        if (!!dadosRelatorio.conectadoInternet == false) {
            swal("O PDV deve estar conectado com a Internet!", "", "warning");
        } else {
            if (dadosRelatorio.parametros[0].nome == "orc_id" && dadosRelatorio.parametros[0].valor == null) {
                swal("O PDV ainda não sincronizou este orçamento!", "Tente novamente", "warning");
            } else {
                RelatorioService.exibirRelatorio(dadosRelatorio.idRelatorio, dadosRelatorio.parametros);
            }
        }
    };

    $scope.abrirManutencaoOrcamento = function (dadosOrcamento) {
        if (dadosOrcamento != null) {
            var orcamento = JSON.parse(orcamentoAppService.retornaOrcamento(dadosOrcamento.Id));
            DadosFormularioService.armazenarDados('orcamento-manutencao', orcamento);
            $state.go('newpdv.manutencao-orcamento');
        } else {
            var datavalidade = new Date();
            datavalidade.setDate(datavalidade.getDate() + 7);
            var objOrcamento = DadosFormularioService.retornaDados('orcamento-manutencao', { Id: null, orc_datainclusao: new Date(), orc_datavalidade: datavalidade }).dados;
            DadosFormularioService.armazenarDados('orcamento-manutencao', objOrcamento);
            $state.go('newpdv.manutencao-orcamento');
        }
    };

    $scope.lerDadosManutencao = function () {
        $scope.dadosOrcamento = DadosFormularioService.retornaDados('orcamento-manutencao', {}).dados;
        $scope.formaPagamentoOrcamentoDTO = $scope.dadosOrcamento.formasPagamento;
        $scope.dadosOrcamento.itens = (!!$scope.dadosOrcamento.itens) ? $scope.dadosOrcamento.itens : [];
        $scope.dadosOrcamento.formasPagamento = [];
        $scope.dadosOrcamento.orf_observacoes = $scope.dadosOrcamento.orf_observacoes;
        if (!(!!$scope.dadosOrcamento.Id) && !(!!$scope.dadosOrcamento.duplicar)) {
            $scope.dadosOrcamento.Id = null;
            $scope.dadosOrcamento.orc_datainclusao = new Date();
            $scope.dadosOrcamento.orc_datavalidade = new Date();
            $scope.dadosOrcamento.orc_datavalidade.setDate($scope.dadosOrcamento.orc_datavalidade.getDate() + 7);
            DadosFormularioService.armazenarDados('orcamento-manutencao', $scope.dadosOrcamento);
        } else {
            $scope.dadosOrcamento.cliente = {
                Id: $scope.dadosOrcamento.ClienteId,
                pes_nome: $scope.dadosOrcamento.pes_nome,
                pef_cpf: $scope.dadosOrcamento.pef_cpf,
                pej_cnpj: $scope.dadosOrcamento.pej_cnpj
            };
            $scope.dadosOrcamento.vendedor = {
                ven_id: $scope.dadosOrcamento.ven_id,
                ven_nome: $scope.dadosOrcamento.ven_nome
            };
            for (var i = 0; i < $scope.formaPagamentoOrcamentoDTO.length; i++) {
                var dadosPgto = [];
                angular.forEach($scope.model.listaFormaPagamento, function (item) {
                    if (item.Key == $scope.formaPagamentoOrcamentoDTO[i].orf_pagamento) {
                        dadosPgto.forma = item.Key;
                        dadosPgto.descricaoForma = item.Value;
                    }
                });
                dadosPgto.parcelasOrcamento = $scope.formaPagamentoOrcamentoDTO[i].orf_numeroparcelas;
                dadosPgto.valorPagamento = $scope.formaPagamentoOrcamentoDTO[i].orf_valortotal;
                dadosPgto.observacao = (!!$scope.formaPagamentoOrcamentoDTO[i].orf_observacoes) ? $scope.formaPagamentoOrcamentoDTO[i].orf_observacoes : null;
                dadosPgto.frete = $scope.formaPagamentoOrcamentoDTO[i].orf_valorfrete;
                dadosPgto.orf_prcdesconto = $scope.formaPagamentoOrcamentoDTO[i].orf_percdesconto;
                dadosPgto.desconto = $scope.formaPagamentoOrcamentoDTO[i].orf_percdesconto;
                $scope.dadosOrcamento.formasPagamento.push(dadosPgto);
            }
        }
        calcularTotalItens();
        calcularTotalDesconto();
        $scope.calcularValorTotal();
    };

    $scope.clienteSelecionado = function (dadosCliente) {
        $scope.model.cpfCnpjCliente = (!!dadosCliente.pef_cpf) ? String("00000000000" + dadosCliente.pef_cpf).slice(-11) : String("00000000000000" + dadosCliente.pej_cnpj).slice(-14);
    };

    $scope.voltarListaOrcamento = function () {
        DadosFormularioService.limparDados('orcamento-manutencao');
        $state.go('newpdv.consulta-orcamento');
    };

    $scope.listaValidacaoFormularioOrcamento = [
        { nome: 'pes_nome', obrigatorio: 'Cliente é Obrigatório', invalido: '' },
        { nome: 'ven_nome', obrigatorio: 'Vendedor é obrigatório', invalido: '' }
    ];

    $scope.validarFormularioOrcamento = function (formulario, dadosOrcamento) {
        $scope.listaFormularioInvalidoOrcamento = [];
        ValidarFormularioService.listaFormularioInvalido(formulario, $scope.listaValidacaoFormularioOrcamento).then(function (retorno) {
            $scope.listaFormularioInvalidoOrcamento = retorno.lista;
            $scope.mensagemFormularioInvalidoOrcamento = retorno.mensagem;

            if (!!!$scope.dadosOrcamento.cliente)
                $scope.listaFormularioInvalidoOrcamento.push({ nome: 'pes_nome', mensagem: 'O Cliente é Obrigatório' });
            if (!!!$scope.dadosOrcamento.vendedor)
                $scope.listaFormularioInvalidoOrcamento.push({ nome: 'ven_nome', mensagem: 'O Vendedor é obrigatório' });

            if ($scope.dadosOrcamento.itens.length == 0) {
                $scope.exibicaoProduto = 'fa-barcode f-25';
                $scope.listaFormularioInvalidoOrcamento.push({ nome: 'produto', mensagem: 'Adicione um produto ao Orçamento' });
            }

            if ($scope.dadosOrcamento.formasPagamento.length == 0) {
                if (!!!$scope.dadosOrcamento.formaPagamento)
                    $scope.listaFormularioInvalidoOrcamento.push({ nome: 'fpg_id', mensagem: 'A Forma de Pagamento é Obrigatória' });
            }
            if ($scope.listaFormularioInvalidoOrcamento.length > 1) {
                $scope.mensagemFormularioItensInvalido = 'Antes de salvar verifique os erros:';
            }

            if ($scope.listaFormularioInvalidoOrcamento.length === 0) {
                $scope.salvarOrcamento(dadosOrcamento);
            };
        });
    };

    $scope.buscarGradesProduto = function (codigoProduto, codigoProdutoGrade) {
        $scope.listaGrades = JSON.parse(produtoAppService.listaGradesProduto(codigoProduto, codigoProdutoGrade));
        if ($scope.listaGrades.length > 0) {
            $scope.abrirModalGradesVendas();
        }
    };

    $scope.selecionarGrades = function () {
        var informouGrade = false;
        var dadosProduto = $scope.dados.produto;
        angular.forEach($scope.listaGrades, function (item) {
            if (item.prg_quantidade > 0) {
                informouGrade = true;
                dadosProduto.oit_valorunitario = item.valorVenda;
                dadosProduto.oit_qtde = item.prg_quantidade;
                dadosProduto.prg_id = item.prg_id;
                dadosProduto.pro_ean = item.ean;
                dadosProduto.grade = "";
                for (var i = 0; i < item.atributos.length; i++) {
                    dadosProduto.grade += item.atributos[i].mgp_descricao;
                    if (i < item.atributos.length - 1) {
                        dadosProduto.grade += "/"
                    }
                }
                $scope.dados.produto = dadosProduto;
                adicionarItem($scope.dados.produto);
            }
        })

        if (!!$scope.modalGradesVendas) {
            $timeout(function () {
                if (!!informouGrade) {
                    $scope.modalGradesVendas.dismiss();
                    delete $scope.modalGradesVendas;
                    jaAbriuModalGradeProduto = false;
                } else {
                    swal("Informe a quantidade em pelo menos um item da grade!", "", "warning");
                }
            }, 100)
        }
    };

    $scope.manutencaoQuantidadeModalGrades = function (posicao, operacao) {
        if (operacao == "+") {
            if ($scope.listaGrades[posicao].valorVenda > 0) {
                $scope.listaGrades[posicao].prg_quantidade += 1;
            } else {
                swal("Não sera possivel adicionar o item, pois o valor não foi informado!", "", "warning");
            }
        } else if (operacao == "-") {
            if ($scope.listaGrades[posicao].prg_quantidade == 0) {
                $scope.listaGrades[posicao].prg_quantidade = 0;
            } else {
                $scope.listaGrades[posicao].prg_quantidade -= 1;
            }
        }
    };


    $scope.salvarOrcamento = function (dadosOrcamento) {
        var formaPagamento = dadosOrcamento.formasPagamento;
        dadosOrcamento.formasPagamento = [];
        if (dadosOrcamento.formasPagamento.length == 0) {
            for (var i = 0; i < formaPagamento.length; i++) {
                dadosOrcamento.formasPagamento.push({
                    orf_pagamento: formaPagamento[i].forma,
                    orf_observacoes: formaPagamento[i].observacao,
                    orf_percdesconto: (!!formaPagamento[i].desconto) ? formaPagamento[i].desconto : 0,
                    orf_valorfrete: (!!formaPagamento[i].frete) ? formaPagamento[i].frete : 0,
                    orf_numeroparcelas: (!!formaPagamento[i].parcelasOrcamento) ? formaPagamento[i].parcelasOrcamento : 1,
                    valorPagamento: formaPagamento[i].valorPagamento,
                    orf_valortotal: formaPagamento[i].valorPagamento
                });
            };
        }
        dadosOrcamento.orf_valortotal = (!!$scope.dados.valorTotalItensComDesconto) ? $scope.dados.valorTotalItensComDesconto : 0;
        dadosOrcamento.orf_valorfrete = (!!$scope.dadosOrcamento.orf_valorfrete) ? $scope.dadosOrcamento.orf_valorfrete : 0;
        if ($scope.dadosOrcamento.orf_percdesconto == 0 && $scope.percentualTotal != 0) {
            dadosOrcamento.orf_percdesconto = $scope.percentualTotal;
        } else {
            dadosOrcamento.orf_percdesconto = $scope.dadosOrcamento.orf_percdesconto;
        }

        dadosOrcamento.orf_observacoes = (!!$scope.dadosOrcamento.orf_observacoes) ? $scope.dadosOrcamento.orf_observacoes : "";
        dadosOrcamento.orf_numeroparcelas = (!!$scope.dadosOrcamento.orf_numeroparcelas) ? $scope.dadosOrcamento.orf_numeroparcelas : 1;
        dadosOrcamento.valorPagamento = (!!$scope.dados.valorTotalItensComDesconto) ? $scope.dados.valorTotalItensComDesconto : 0;

        dadosOrcamento.ClienteId = dadosOrcamento.cliente.Id;
        dadosOrcamento.cli_id = dadosOrcamento.cliente.cli_id;
        delete dadosOrcamento.cliente;

        dadosOrcamento.ven_id = dadosOrcamento.vendedor.ven_id;
        delete dadosOrcamento.vendedor;

        dadosOrcamento.orc_id = null;
        dadosOrcamento.orc_observacao = null;
        dadosOrcamento.orc_responsavelorcamento = null;
        dadosOrcamento.orc_numero = null;

        if (!(!!dadosOrcamento.Id)) {
            var retornoOrcamento = orcamentoAppService.incluir(JSON.stringify(dadosOrcamento));
            if (!!retornoOrcamento) {
                swal({
                    title: "Orçamento adicionado com sucesso!",
                    text: "",
                    type: "success",
                    showCancelButton: true,
                    cancelButtonText: "Ok",
                    confirmButtonClass: "btn-info",
                    confirmButtonText: "Incluir mais um",
                    closeOnConfirm: true
                }, function (acao) {
                    $scope.visualizarRelatorio(retornoOrcamento.id);
                    if (!acao) {
                        DadosFormularioService.limparDados('orcamento-manutencao');
                        $scope.voltarListaOrcamento();
                    } else {
                        DadosFormularioService.limparDados('orcamento-manutencao');
                        var datavalidade = new Date();
                        datavalidade.setDate(datavalidade.getDate() + 7);
                        var objOrcamento = DadosFormularioService.retornaDados('orcamento-manutencao', { orc_id: null, orc_datainclusao: new Date(), orc_datavalidade: datavalidade }).dados;
                        DadosFormularioService.armazenarDados('orcamento-manutencao', objOrcamento);
                        setTimeout(function () {
                            $scope.lerDadosManutencao();
                        }, 100);
                    }
                });
            }
        } else {
            if (!!orcamentoAppService.editar(JSON.stringify(dadosOrcamento))) {
                $scope.visualizarRelatorio(dadosOrcamento.Id);
                swal("Orçamento modificado com sucesso!", "", "success");
                DadosFormularioService.limparDados('orcamento-manutencao');
                $scope.voltarListaOrcamento();
            }
        }
    };

    $scope.buscarInformacoesEanProduto = function (eanProduto) {
        if (!!eanProduto) {
            var dadosProduto = JSON.parse(produtoAppService.listarProdutoCodigo(eanProduto));
            if (dadosProduto.length > 0) {
                $scope.dados.produto = dadosProduto[0];
                $scope.buscaInformacoesProduto($scope.dados.produto);
            } else {
                $timeout(function () {
                    swal("Produto Não Encontrado!", "", "warning");
                })
            }
        }
    };

    var jaAbriuModalGradeProduto = false;
    $scope.buscaInformacoesProduto = function (dadosProduto) {
        $scope.dados.produto.oit_qtde = 1;
        $scope.dados.eanProduto = dadosProduto.pro_ean;
        $scope.dados.produto.oit_valorunitario = JSON.parse(produtoAppService.retornaPrecoPadraoProduto(dadosProduto.pro_id));
        $scope.calcularTotalItem();
        if (!!!jaAbriuModalGradeProduto)
            $scope.buscarGradesProduto(dadosProduto.pro_id, null);
        //if (dadosProduto.prg_id == null) {
        //    if (!!!jaAbriuModalGradeProduto)
        //        $scope.buscarGradesProduto(dadosProduto.pro_id, null);
        //} else {
        //    $scope.listaGrades = JSON.parse(produtoAppService.listaGradesProduto(dadosProduto.pro_id, dadosProduto.prg_id));
        //    var dadosProduto = $scope.dados.produto;
        //    angular.forEach($scope.listaGrades, function (item) {
        //        dadosProduto.oit_valorunitario = item.valorVenda;
        //        dadosProduto.oit_qtde = 1;
        //        dadosProduto.prg_id = item.prg_id;
        //        dadosProduto.pro_ean = item.ean;
        //        dadosProduto.grade = "";
        //        for (var i = 0; i < item.atributos.length; i++) {
        //            dadosProduto.grade += item.atributos[i].mgp_descricao;
        //            if (i < item.atributos.length - 1) {
        //                dadosProduto.grade += "/"
        //            }
        //        }
        //    })
        //}
        $timeout(function () {
            if ($scope.exibicaoProduto != "fa-barcode f-25") {
                adicionarItem($scope.dados.produto);
            }
        }, 100)
    };

    $scope.calcularTotalItem = function () {
        $scope.dados.produto.valorTotal = $scope.dados.produto.oit_valorunitario * $scope.dados.produto.oit_qtde;
    };

    $scope.listaValidacaoFormularioItensOrcamento = [
        { nome: 'produto', obrigatorio: 'Produto é obrigatório', invalido: '' },
        { nome: 'oit_valorunitario', obrigatorio: 'Valor Unitário é Obrigatório', invalido: '' },
        { nome: 'oit_qtde', obrigatorio: 'Quantidade é obrigatório', invalido: '' }
    ];

    $scope.validarFormularioItemOrcamento = function (formulario, dadosItemOrcamento) {
        $scope.listaFormularioItensInvalido = [];

        ValidarFormularioService.listaFormularioInvalido(formulario, $scope.listaValidacaoFormularioItensOrcamento).then(function (retorno) {
            $scope.listaFormularioItensInvalido = retorno.lista;
            $scope.mensagemFormularioItensInvalido = retorno.mensagem;

            if (!!$scope.dados.produto) {
                if (!(!!$scope.dados.produto.pro_id)) {
                    $scope.listaFormularioItensInvalido.push({
                        nome: 'produto', mensagem: 'Produto é Obrigatório'
                    });
                } else {
                    if (!(!!$scope.dados.produto.oit_qtde)) {
                        if (!verificarListaFormulario($scope.listaFormularioItensInvalido, 'oit_qtde')) {
                            $scope.listaFormularioItensInvalido.push({
                                nome: 'oit_qtde', mensagem: 'Quantidade é Obrigatório'
                            });
                        }
                    }

                    if (!(!!$scope.dados.produto.oit_valorunitario)) {
                        if (!verificarListaFormulario($scope.listaFormularioItensInvalido, 'oit_valorunitario')) {
                            $scope.listaFormularioItensInvalido.push({
                                nome: 'oit_valorunitario', mensagem: 'Valor Unitário é Obrigatório'
                            });
                        }
                    }
                }
            } else {
                $scope.listaFormularioItensInvalido.push({
                    nome: 'produto', mensagem: 'Produto é Obrigatório'
                });
            }

            if ($scope.listaFormularioItensInvalido.length > 1) {
                $scope.mensagemFormularioItensInvalido = 'Antes de salvar verifique os erros:';
            }

            if ($scope.listaFormularioItensInvalido.length === 0) {
                adicionarItem(dadosItemOrcamento);
            };
        });
    };

    function verificarListaFormulario(lista, campo) {
        var existe = false;
        lista.map(function (item) {
            if (item.nome === campo)
                existe = true;
        })
        return existe;
    };

    function adicionarItem(dadosItem) {
        $scope.dadosOrcamento.itens.push({
            pro_id: dadosItem.pro_id,
            pro_ean: dadosItem.pro_ean,
            prg_id: (!!dadosItem.prg_id) ? dadosItem.prg_id : null,
            grade: (!!dadosItem.grade) ? dadosItem.grade : null,
            pro_descricao: dadosItem.pro_descricao,
            oit_qtde: dadosItem.oit_qtde,
            oit_valorunitario: dadosItem.oit_valorunitario,
            oit_desconto: 0,
            oit_observacao: null
        });

        $scope.dados.produto = null;
        $scope.dados.eanProduto = null;
        $scope.setarFocus('produto');
        calcularTotalItens();
    };

    $scope.setarFocus = function (nomeElemento, tempo) {
        FuncaoService.setarFocus(nomeElemento, tempo || 300);
    };

    $scope.marcarTexto = function (nomeElemento) {
        setTimeout(function () {
            document.getElementsByName(nomeElemento)[0].select();
        }, 300)
    };

    $scope.removerItemOrcamento = function (posicao, item) {
        swal({
            title: "Remover o item " + item.pro_descricao + "?",
            text: "",
            type: "warning",
            showCancelButton: true,
            cancelButtonText: "Não",
            confirmButtonClass: "btn-danger",
            confirmButtonText: "Sim, quero remover"
        }, function (acao) {
            if (acao) {
                $scope.dadosOrcamento.itens.splice(posicao, 1);
                calcularTotalItens();
                $scope.$digest();
            }
        });
    };

    $scope.editarItemOrcamento = function (posicao, item) {
        $scope.dadosOrcamento.itens.splice(posicao, 1);
        $scope.exibicaoProduto = 'fa-barcode f-25';
        $scope.dados.eanProduto = null;
        $scope.dados.produto = item;
        $scope.dados.produto.edicao = true;
        $scope.dados.dadosEdicaoProduto = {
            pro_id: item.pro_id,
            pro_ean: item.pro_ean,
            prg_id: (!!item.prg_id) ? item.prg_id : null,
            grade: (!!item.grade) ? item.grade : null,
            pro_descricao: item.pro_descricao,
            oit_qtde: item.oit_qtde,
            oit_valorunitario: item.oit_valorunitario,
            oit_desconto: item.oit_desconto,
            oit_observacao: item.oit_observacao,
        };
        $scope.setarFocus('oit_qtde');
        $scope.calcularTotalItem();
    };

    $scope.cancelarItem = function () {
        if (!!$scope.dados.produto.edicao) {
            var dados = $scope.dados.dadosEdicaoProduto;
            $scope.dadosOrcamento.itens.push({
                pro_id: dados.pro_id,
                pro_ean: dados.pro_ean,
                prg_id: (!!dados.grade) ? dados.grade.prg_id : null,
                grade: (!!dados.grade) ? dados.grade : null,
                pro_descricao: dados.pro_descricao,
                oit_qtde: dados.oit_qtde,
                oit_valorunitario: dados.oit_valorunitario,
                oit_desconto: 0,
                oit_observacao: null
            });
        }
        $scope.dados.produto = null;
        $scope.dados.eanProduto = null;
        $scope.dados.dadosEdicaoProduto = null;
        calcularTotalItens();
    };

    function calcularTotalItens() {
        $scope.dados.valorTotalItens = 0;
        $scope.dados.valorTotalItensComDesconto = 0;
        $scope.dadosOrcamento.itens.map(function (item) {
            $scope.dados.valorTotalItens += (item.oit_valorunitario * item.oit_qtde);
            $scope.dados.valorTotalItensComDesconto += (item.oit_valorunitario * item.oit_qtde) - item.oit_desconto;
        })
    };

    function calcularTotalDesconto() {
        $scope.dados.valorTotalDesconto = 0;
        $scope.dadosOrcamento.itens.map(function (item) {
            $scope.dados.valorTotalDesconto += item.oit_desconto;
        })
    };

    $scope.calcularTotalItensSemDesconto = function () {
        var valorTotalItensSemDesconto = 0;
        $scope.dadosOrcamento.itens.map(function (item) {
            valorTotalItensSemDesconto += (item.oit_valorunitario * item.oit_qtde);
        })

        return valorTotalItensSemDesconto;
    };

    $scope.listaValidacaoFormularioFaturamento = [
        { nome: 'fpg_id', obrigatorio: 'A Forma de Pagamento é Obrigatória', invalido: '' },
        { nome: 'valorPagamento', obrigatorio: 'O Valor do Pagamento é Obrigatório', invalido: '' }
    ];

    $scope.validarFormularioFaturamento = function (formulario) {
        $scope.listaFormularioFaturamentoInvalido = [];
        ValidarFormularioService.listaFormularioInvalido(formulario, $scope.listaValidacaoFormularioFaturamento).then(function (retorno) {
            $scope.listaFormularioFaturamentoInvalido = retorno.lista;
            $scope.mensagemFormularioFaturamentoInvalido = retorno.mensagem;

            if (!(!!$scope.dados.valorPagamento)) {
                var adicionarErro = true;
                angular.forEach($scope.listaFormularioInvalido, function (lista) {
                    if (lista.nome == 'valorPagamento')
                        adicionarErro = false;
                });

                if (adicionarErro)
                    $scope.listaFormularioFaturamentoInvalido.push({ nome: 'valorPagamento', mensagem: 'O Valor do Pagamento é Obrigatório' });
            }

            if (!!!$scope.dados.formaPagamento)
                $scope.listaFormularioFaturamentoInvalido.push({ nome: 'fpg_id', mensagem: 'A Forma de Pagamento é Obrigatória' });

            if ($scope.listaFormularioFaturamentoInvalido.length > 1) {
                $scope.mensagemFormularioItensInvalido = 'Antes de salvar verifique os erros:';
            }

            if ($scope.listaFormularioFaturamentoInvalido.length == 0) {
                $scope.adicionarMultiplasFormaPagamento();
            }
        });
    };

    $scope.existeCamposObrigatorios = function () {
        if (!(!!$scope.dadosOrcamento.cliente)) return true;
        if ($scope.dadosOrcamento.itens.length == 0) return true;
        if (!(!!$scope.dadosOrcamento.vendedor)) return true;
        if ($scope.dadosOrcamento.formasPagamento.length == 0) return true;
        return false;
    };

    $scope.aplicarDesconto = function () {
        $scope.listaItensDesconto = [];
        $scope.listaItensDesconto = $scope.dadosOrcamento.itens;
        angular.forEach($scope.listaItensDesconto, function (item) {
            item.mostratipo = '$';
            item.oit_desconto = (!!item.oit_desconto) ? item.oit_desconto : 0;
            item.oit_valortotal = (item.oit_valorunitario * item.oit_qtde);
            item.oit_valortotalComDesconto = ((item.oit_valorunitario * item.oit_qtde) - item.oit_desconto);
            $scope.calcularDesconto(item, '$')
        });
        $scope.modalDescontos = ModalService.model($scope, 'views/pdv/varejo/orcamento/modalDescontos.html', 'lg', true, true, true);
        $timeout(function () {
            $scope.setarFocus('descGeralItem');
        }, 300)
    };

    $scope.calcularDesconto = function (item, tipo) {
        if (tipo == "$") {
            if (item.oit_desconto == "") {
                item.percdesc = "";
            } else if (item.oit_desconto > item.oit_valortotal) {
                item.oit_desconto = item.oit_valortotal * 1;
                item.percdesc = 1;
            } else {
                item.percdesc = (item.oit_desconto) / item.oit_valortotal;
                $scope.percentualTotal += item.percdesc;
            }
        } else {
            if (item.percdesc == "") {
                item.oit_desconto = "";
            } else if (item.percdesc * 100 > 100) {
                item.oit_desconto = item.oit_valortotal * 1;
                item.percdesc = 1;
            } else {
                item.oit_desconto = (item.percdesc * item.oit_valortotal);
            }
        }
        $scope.atualizaDescontos();
    };

    $scope.atualizaDescontos = function () {
        $scope.descontototal = 0;
        angular.forEach($scope.listaItensDesconto, function (item) {
            $scope.descontototal += (!!item.oit_desconto) ? item.oit_desconto : 0;
        });

        $scope.valortotalcomdesconto = $scope.dados.valorTotalItens - $scope.descontototal;
        $scope.descontoItens = null;
    };

    $scope.minmax = function (value, min, max) {
        if (value < min || isNaN(value))
            return 0;
        else if (value > max)
            return 1;
        else return value;
    };

    $scope.descontoTodosItens = function () {
        desc = angular.element('#descGeralItem').val();
        desc = desc.replace(" %", "").replace(",", ".");

        if (desc == "") {
            angular.forEach($scope.listaItensDesconto, function (item) {
                item.oit_desconto = null;
                item.percdesc = null;
            });
        } else {
            angular.forEach($scope.listaItensDesconto, function (item) {
                item.oit_desconto = (desc * item.oit_valortotal) / 100;
                item.percdesc = desc / 100;
                $scope.percentualTotal = item.percdesc;
            });
        }

        $scope.atualizaDescontos();
    };

    $scope.finalizarDesconto = function () {
        $scope.dadosOrcamento.itens = $scope.listaItensDesconto;
        calcularTotalItens();
        calcularTotalDesconto();
    };

    $scope.listarItens = function () {
        $scope.modalItem = ModalService.model($scope, 'views/pdv/varejo/orcamento/modalItens.html', 'lg', true, true, true);
    };



    $scope.model.listaFormaPagamento = JSON.parse(enumAppService.listaEnum("TipoPagamentoOrcamento"));
    $scope.calcularValorTotal = function () {
        var subTotal = $scope.calcularTotalItensSemDesconto();
        var valorFrete = 0;
        if (!!subTotal) {
            if (!!$scope.dadosOrcamento.orf_valorfrete) {
                valorFrete = $scope.dadosOrcamento.orf_valorfrete;
                //$scope.dados.valorTotalItensComDesconto = (valorFrete + subTotal) - $scope.dados.valorTotalDesconto; //$scope.descontoOrcamento
                $scope.dados.valorTotalItensComDesconto = (valorFrete + subTotal) - $scope.descontoOrcamento;
            } else {
                //$scope.dados.valorTotalItensComDesconto = subTotal - $scope.dados.valorTotalDesconto;
                $scope.dados.valorTotalItensComDesconto = subTotal - $scope.descontoOrcamento;
            }
        } else {
            if (!!$scope.dadosOrcamento.orf_valorfrete) {
                valorFrete = $scope.dadosOrcamento.orf_valorfrete;
                $scope.dados.valorTotalItensComDesconto = valorFrete;
            } else {
                $scope.dados.valorTotalItensComDesconto = 0;
            }
        }
    };

    $scope.exibicaoProduto = 'fa-barcode f-25';
    $scope.modoExibirPesquisaProduto = function (exibicaoProduto) {
        if (!!exibicaoProduto) {
            $scope.exibicaoProduto = (exibicaoProduto == 'fa-barcode f-25') ? 'fa-search' : 'fa-barcode f-25';
            $localStorage.exibicaoProduto = [{ 'modoExibir': $scope.exibicaoProduto }];
        } else {
            if (!!$localStorage.exibicaoProduto) {
                $scope.exibicaoProduto = $localStorage.exibicaoProduto[0].modoExibir;
            } else {
                $scope.exibicaoProduto = 'fa-barcode f-25';
                $localStorage.exibicaoProduto = [{ 'modoExibir': $scope.exibicaoProduto }];
            }
        }

        $timeout(function () {
            $scope.setarFocus('produto');
        }, 100)
    };

    $scope.adicionarFormaPagamento = function () {
        $scope.dadosOrcamento.formasPagamento = (!!$scope.dadosOrcamento.formasPagamento) ? $scope.dadosOrcamento.formasPagamento : [];
        var multiplas = {};
        multiplas.forma = $scope.dadosOrcamento.formaPagamento.Key;
        multiplas.descricaoForma = $scope.dadosOrcamento.formaPagamento.Value;
        multiplas.parcelasOrcamento = $scope.dadosOrcamento.orf_numeroparcelas;
        multiplas.frete = $scope.dadosOrcamento.orf_valorfrete;
        multiplas.desconto = $scope.descontoOrcamento;
        multiplas.observacao = (!!$scope.dadosOrcamento.orf_observacoes) ? $scope.dadosOrcamento.orf_observacoes : "";
        if (!!$scope.dadosOrcamento.orf_numeroparcelas) {
            multiplas.observacao += "Parcela(s): " + $scope.dadosOrcamento.orf_numeroparcelas;
        }
        multiplas.valorPagamento = 0;
        multiplas.valorPagamento = $scope.dados.valorTotalItensComDesconto;
        $scope.dadosOrcamento.formasPagamento.push(multiplas);
        $scope.limparCamposFormaPagamento();
    };
    $scope.removerForma = function (formaPagamento, index) {
        swal({
            title: "Remover a Forma de Pagamento " + formaPagamento.descricaoForma + "?",
            text: "",
            type: "warning",
            showCancelButton: true,
            cancelButtonText: "Não",
            confirmButtonClass: "btn-danger",
            confirmButtonText: "Sim, quero remover",
            closeOnConfirm: true
        }, function () {
            $scope.$apply(function () {
                $scope.dadosOrcamento.formasPagamento.splice(index, 1);
            });
        });
    };

    $scope.alterarForma = function (formaPagamento, index) {

        $scope.dadosOrcamento.orf_pagamento = [{
            'key': formaPagamento.forma,
            'value': formaPagamento.descricaoForma
        }][0];

        $scope.dadosOrcamento.valorPagamento = formaPagamento.valorPagamento;
        $scope.dadosOrcamento.orf_observacoes = formaPagamento.observacao;
        $scope.dadosOrcamento.formasPagamento.splice(index, 1);
        $scope.descricaoBotaoFormaOrcamento = 'Salvar Forma';
    };

    $scope.limparCamposFormaPagamento = function () {
        $scope.dadosOrcamento.formaPagamento = null;
        $scope.descricaoBotaoFormaOrcamento = 'Adicionar Forma';
        $scope.dadosOrcamento.valorPagamento = '';
        $scope.dadosOrcamento.orf_numeroparcelas = '';
        $scope.dadosOrcamento.orf_observacoes = '';
        $scope.dados.valorTotalItensComDesconto = $scope.dados.valorTotalItens;
        $scope.descontoOrcamento = '';
        $scope.dadosOrcamento.orf_valorfrete = 0;
        $scope.descontos.percdesc = '';
        $scope.descontos.vlrdesconto = '';
    };

    $scope.descontos = {
        percdesc: '',
        vlrdesconto: ''
    };

    $scope.calcularDescontoTotal = function (subTotal, desc, tipo) {
        if (tipo == "$") {
            if (desc.vlrdesconto == "") {
                desc.percdesc = "";
            } else if (desc.vlrdesconto > subTotal) {
                desc.vlrdesconto = subTotal * 1;
                desc.percdesc = 1;
            } else {
                desc.percdesc = (desc.vlrdesconto) / subTotal;
                $scope.percentualTotal += desc.percdesc;
            }
        } else {
            if (desc.percdesc == "") {
                desc.vlrdesconto = "";
            } else if (desc.percdesc * 100 > 100) {
                desc.vlrdesconto = subTotal * 1;
                desc.percdesc = 1;
            } else {
                desc.vlrdesconto = (desc.percdesc * subTotal);
            }
        }
        $scope.atualizaDescontoTotal(desc);
    };

    $scope.atualizaDescontoTotal = function (desc) {
        $scope.descontototal = 0;
        $scope.descontototal += (desc.vlrdesconto >= 0) ? desc.vlrdesconto : 0;
        $scope.descontoOrcamento = $scope.descontototal;

        if (!!$scope.dadosOrcamento) {
            var valorFrete = (!!$scope.dadosOrcamento.orf_valorfrete == true) ? $scope.dadosOrcamento.orf_valorfrete : 0;
            $scope.dados.valorTotalItensComDesconto = ($scope.dados.valorTotalItens - $scope.descontoOrcamento) + valorFrete;
        }
    };

    $scope.cancelarModalGrade = function () {
        $scope.modalGradesVendas.dismiss();
        delete $scope.modalGradesVendas;
        jaAbriuModalGradeProduto = false;
        $scope.dados.produto = null;
    };

}]);