﻿newERP.controller('LancamentoDespesaController', ['$scope', 'hotkeys', 'FuncaoService', function ($scope, hotkeys, FuncaoService) {

    $scope.dadosCaixa = {
        mcc_datahora: new Date(),
        ctc_id: null,
        ctg: null,
        his: null,
        mcc_numerodocumento: null,
        mcc_valor: 0,
        mcc_complemento: null,
        ctx_id: null,
        pes: null
    };

    $scope.model = {
        saldoAtual: 0,
        exibirHistorico: false
    };

    
    var saldoUltimoFechamento = JSON.parse(controleCaixaAppService.saldoAtual());
    $scope.model.saldoAtual = saldoUltimoFechamento;
    

    var buscarDadosPdv = pdvAppService.retornaDadosPdv();
    if (!!buscarDadosPdv) {
        $scope.dadosCaixa.ctc_id = buscarDadosPdv.ctc_id;
    }

    var dadosCaixaAberto = JSON.parse(controleCaixaAppService.listaControleCaixa())[0];
    $scope.dadosCaixa.ctx_id = dadosCaixaAberto.Id;

    $scope.model.exibirHistorico = JSON.parse(historicoAppService.possuiHistorico());

    hotkeys.bindTo($scope)

    $scope.keyEnterLancDespesa = function () {
        $scope.salvarLancamentoCaixa();
    };

    $scope.keyEscLancDespesa = function () {
        $scope.modalLancamentoDespesa.close();
    };

    $scope.clicouPraLancamentoDespesa = false;
    $scope.salvarLancamentoCaixa = function () {
        if (!!$scope.dadosCaixa.ctg == false) {
            setTimeout(function () {
                swal("É Obrigatório informar a conta gerencial", "", "warning");
                FuncaoService.setarFocus('ctg_id', 300);
            }, 100)
        } else if (!!$scope.dadosCaixa.mcc_valor == false || $scope.dadosCaixa.mcc_valor == 0) {
            setTimeout(function () {
                swal("O Valor do Lançamento é Obrigatório", "", "warning");
                FuncaoService.setarFocus('mcc_valor', 300);
            }, 100)
        } else {
            $scope.clicouPraLancamentoDespesa = true;

            $scope.dadosCaixa.pes_id = (!!$scope.dadosCaixa.pes == false) ? null : $scope.dadosCaixa.pes.pes_id;
            $scope.dadosCaixa.mcc_numerodocumento = (!!$scope.dadosCaixa.mcc_numerodocumento == false) ? null : $scope.dadosCaixa.mcc_numerodocumento;
            $scope.dadosCaixa.mcc_complemento = (!!$scope.dadosCaixa.mcc_complemento == false) ? null : $scope.dadosCaixa.mcc_complemento;

            console.log('dadosCaixa', $scope.dadosCaixa)
            movimentoCaixaAppService.registrarDespesa(JSON.stringify($scope.dadosCaixa));
            setTimeout(function () {
                swal("Despesa registrada com sucesso!", "", "success");
            }, 100)
            $scope.modalLancamentoDespesa.close();
        }
    };

}]);