newERP.controller('FinalizarVendaVarejoController', ['$scope', 'ModalService', 'DadosFormularioService', '$localStorage', 'VendaService', '$state', 'TEFService', '$timeout', '$sce', 'RelatorioService', 'FuncaoService', 'growlService', '$document', '$q', function ($scope, ModalService, DadosFormularioService, $localStorage, VendaService, $state, TEFService, $timeout, $sce, RelatorioService, FuncaoService, growlService, $document, $q) {

    $scope.totalPago = 0;
    $scope.emitirDocFiscal = true;
    $scope.gravandoNota = false;
    $scope.parametrosEmpresa = null;
    $scope.contemAntecipacao = false;
    $scope.modalClienteAberta = false;

    $scope.frete = {
        dadosCliente:
        {
            cep: '',
            cidade: '',
            endereco: '',
            bairro: '',
            numero: '',
            complemento: '',
            uf: ''
        }
    };

    var impressaoComprovantes = {
        Imprimir: 0,
        PerguntarAoUsuario: 1,
        NaoImprimir: 2
    }

    var tipoFormaPagamento = {
        fpDinheiro: 1,
        fpCheque: 2,
        fpCartaoCredito: 3,
        fpCartaoDebito: 4,
        fpCreditoLoja: 5,
        fpValeAlimentacao: 10,
        fpValeRefeicao: 11,
        fpValePresente: 12,
        fpValeCombustivel: 13,
        fpDuplicataMercantil: 14,
        fpBoletoBancario: 15,
        fpDepositoBancario: 16,
        fpPixDinamico: 17,
        fpTransferenciaBancaria: 18,
        fpCashback: 19,
        fpPixEstatico: 20,
        fpCreditoEmLoja: 21,
        fpFalhaDeHardware: 22,
        fpSemPagamento: 90,
        fpOutro: 99
    };

    $scope.valor = {
        $edit: false
    }

    $scope.editarParcelas = {
        $edit: false
    };

    $scope.envioNFCeEmail = {
        enviar: false,
        enderecoDestinatario: ''
    };

    $scope.model = {
        tipoSolicitacao: 0,
        senhaGerencial: ''
    };
    var tipoSolicitacao = {
        parcelasAtrazadas: 1,
        limiteCredito: 2,
        somenteAvista: 3,
        descontoMaximo: 4,
    }

    $(document).on('keydown', function (event) {
        console.log(event.key);
        // Verifica se a tecla pressionada é a tecla PgDn
        if (event.key === 'PageDown') {
            // Impede o comportamento padrão da tecla, se necessário
            event.preventDefault();
            // Chama a função finalizaVenda do escopo
            $scope.$apply(function () {
                if (($scope.dadosVenda.totalNota > $scope.totalPago.toFixed(3)) > 0 || $scope.gravandoNota == false) {
                    $scope.concluirVenda();
                }
            });
        }
        if (event.key === 'F8') {
            event.preventDefault();
            $scope.$apply(function () {
                $scope.cancelarVenda();
            });
        }

        if (event.key === 'F2' && $scope.modalClienteAberta == false) {
            event.preventDefault();
            $scope.$apply(function () {
                $scope.ListaCliente();
            });
        }
        // ESc == 27
        if (event.keyCode === 27) {
            event.preventDefault();
            $scope.$apply(function () {
                $scope.modalClienteAberta = false;
                $scope.modalCliente.close();
            });
        }
    });

    // Remove o evento quando o controlador é destruído para evitar vazamento de memória
    $scope.$on('$destroy', function () {
        $document.off('keydown');
    });


    $scope.lerDados = function () {
        $scope.dadosVenda = DadosFormularioService.retornaDados('venda-varejo').dados;
        $scope.dadosVenda.loc_id = $localStorage.dadosPDV.loc_id;
        $scope.dadosVenda.descontoTotal = 0;
        $scope.dadosVenda.acrescimoTotal = 0;
        $scope.dadosVenda.entregaDomicilio = false;
        $scope.dadosVenda.possuiPessoaAutorizada = false;
        $scope.dadosVenda.codigoAntecipacao = "";
        $scope.dadosVenda.pessoaAutorizada = !(!!!$scope.dadosVenda.pessoaAutorizada) ? $scope.dadosVenda.pessoaAutorizada : {};
        $scope.listarPessoaAutorizada = [];
        if (!!$scope.dadosVenda.ClienteId) {
            $scope.verificaAntecipacoes($scope.dadosVenda.pes_id);
            $scope.listarPessoaAutorizada = JSON.parse(clientePessoaAutorizadaAppService.buscar($scope.dadosVenda.ClienteId));
            if ($scope.listarPessoaAutorizada.length > 0) {
                $scope.dadosVenda.possuiPessoaAutorizada = true;
            }
        }

        $scope.listaStatusParcela = JSON.parse(enumAppService.listaEnum("StatusParcela"));
        $scope.dadosVenda.rateioParcelas = 1;
        $scope.dadosVenda.clienteIdentificado = false;
        if ($scope.dadosVenda.cli_id || $scope.dadosVenda.ClienteId) {
            $scope.dadosVenda.clienteIdentificado = true;
        }
        $scope.dadosVenda.descItem = 0;
        $scope.dadosVenda.acreItem = 0;
        angular.forEach($scope.dadosVenda.listaItens, function (item) {
            $scope.dadosVenda.descontoTotal += (!!item.vlrDesconto) ? item.vlrDesconto : 0;
            $scope.dadosVenda.acrescimoTotal += (!!item.vlrAcrescimo) ? item.vlrAcrescimo : 0;

            $scope.dadosVenda.descItem += (!!item.vlrDesconto) ? item.vlrDesconto : 0;
            $scope.dadosVenda.acreItem += (!!item.vlrAcrescimo) ? item.vlrAcrescimo : 0;
        })
        $scope.dadosVenda.descontoTotal = FuncaoService.arredondar($scope.dadosVenda.descontoTotal);
        $scope.dadosVenda.acrescimoTotal = FuncaoService.arredondar($scope.dadosVenda.acrescimoTotal);
        $scope.dadosVenda.somaDescontoItens = FuncaoService.arredondar($scope.dadosVenda.descontoTotal); // campo destinado a controlar os descontos nos itens, para que seja possível dar desconto no final da venda.

        $scope.dadosVenda.subTotalBruto = FuncaoService.arredondar($scope.dadosVenda.subTotalNota - $scope.dadosVenda.acrescimoTotal + $scope.dadosVenda.descontoTotal);
        //Forrçar desconto e acrescimos em $$ para fechar arredondamento
        if (!!$scope.dadosVenda.descontoTotal) {
            $scope.dadosVenda.descontoTotal = $scope.dadosVenda.descontoTotal;
            $scope.dadosVenda.descontoTotalPercentual = FuncaoService.arredondar($scope.dadosVenda.descontoTotal / $scope.dadosVenda.subTotalBruto, 4);
            $scope.dadosVenda.somaDescontoItens = $scope.dadosVenda.descontoTotal;
        };
        if (!!$scope.dadosVenda.acrescimoTotal) {
            $scope.dadosVenda.acrescimoTotalPercentual = FuncaoService.arredondar($scope.dadosVenda.acrescimoTotal / $scope.dadosVenda.subTotalBruto, 4)
            $scope.dadosVenda.acrescimoTotal = $scope.dadosVenda.acrescimoTotal;
        };

        if (!!$scope.dadosVenda.pagamento && $scope.dadosVenda.pagamento.length > 0) {
            if ($scope.dadosVenda.pagamento[0].formaPagamento.fpg_tipopagamento == parseInt(tipoFormaPagamento.fpCartaoCredito) || $scope.dadosVenda.pagamento[0].formaPagamento.fpg_tipopagamento == parseInt(tipoFormaPagamento.fpCartaoDebito)) {
                if (!!$scope.dadosVenda.pagamento[0].recebimentoCartao == false) {
                    $scope.modalBandeirasCartao = ModalService.abrir('views/pdv/modalBandeiraCartao.html', 'lg', true, 'static', true, 'ModalBandeiraCartaoController', { 'tipoPagamento': $scope.dadosVenda.pagamento[0].formaPagamento.fpg_tipopagamento });
                    $scope.modalBandeirasCartao.result.then(function (retornoDadosBandeiraCartao) {
                        var indexPosicaoPagamento = ($scope.dadosVenda.pagamento.length) - 1;
                        $scope.dadosVenda.pagamento[indexPosicaoPagamento].recebimentoCartao = (!!$scope.dadosVenda.pagamento[indexPosicaoPagamento].recebimentoCartao) ? $scope.dadosVenda.pagamento[indexPosicaoPagamento].recebimentoCartao : [];
                        if (!!retornoDadosBandeiraCartao == false) {
                            var voltarFormaPagamento = $scope.dadosVenda.pagamento[indexPosicaoPagamento].formaPagamento;
                            removerFormaPagamento(indexPosicaoPagamento);
                            $scope.dadosPagamento.formaPagamento = voltarFormaPagamento;
                            $scope.selecionaFormaPagamento();
                        } else {
                            var dadosBandeiraCartaoEmpresa = JSON.parse(bandeiraCartaoEmpresaAppService.retornaDadosBandeiraCartaoEmpresa(retornoDadosBandeiraCartao.bandeira.bce_id));
                            var dataAtual = new Date();
                            if (!!retornoDadosBandeiraCartao.cartaoCredito) {
                                if (retornoDadosBandeiraCartao.tipoParcelamento == tipoParcelamentoCartao.estabelecimento) {
                                    var numeroDias = parseInt(dadosBandeiraCartaoEmpresa.bce_nrodiasrecebimentocredito);
                                    angular.forEach($scope.dadosVenda.pagamento[indexPosicaoPagamento].parcelas, function (parcela) {
                                        $scope.dadosVenda.pagamento[indexPosicaoPagamento].recebimentoCartao.push({
                                            tipoParcelamento: tipoParcelamentoCartao.estabelecimento,
                                            bce_id: retornoDadosBandeiraCartao.bandeira.bce_id,
                                            rcc_parcelarecebimento: parcela.prc_numeroparcela,
                                            rcc_valor: parcela.prc_valor,
                                            rcc_nsu: retornoDadosBandeiraCartao.nsu,
                                            rcc_previsaorecebimento: new Date(dataAtual.setDate(dataAtual.getDate() + numeroDias))
                                        });
                                    })
                                } else {
                                    dataAtual = new Date();
                                    $scope.dadosVenda.pagamento[indexPosicaoPagamento].recebimentoCartao.push({
                                        tipoParcelamento: tipoParcelamentoCartao.comprador,
                                        bce_id: retornoDadosBandeiraCartao.bandeira.bce_id,
                                        rcc_parcelarecebimento: 1,
                                        rcc_valor: $scope.dadosVenda.pagamento[indexPosicaoPagamento].valorPago,
                                        rcc_nsu: retornoDadosBandeiraCartao.nsu,
                                        rcc_previsaorecebimento: new Date(dataAtual.setDate(dataAtual.getDate() + parseInt(dadosBandeiraCartaoEmpresa.bce_nrodiasrecebimentocredito)))
                                    });
                                }
                            } else {
                                dataAtual = new Date();
                                $scope.dadosVenda.pagamento[indexPosicaoPagamento].recebimentoCartao.push({
                                    tipoParcelamento: null,
                                    bce_id: retornoDadosBandeiraCartao.bandeira.bce_id,
                                    rcc_parcelarecebimento: 1,
                                    rcc_valor: $scope.dadosVenda.pagamento[indexPosicaoPagamento].valorPago,
                                    rcc_nsu: retornoDadosBandeiraCartao.nsu,
                                    rcc_previsaorecebimento: new Date(dataAtual.setDate(dataAtual.getDate() + parseInt(dadosBandeiraCartaoEmpresa.bce_nrodiasrecebimentodebito)))
                                });
                            }
                        }
                    });
                }
            }
        }

        $scope.calcularTotaisNota();

        $timeout(function () {
            $scope.dadosPagamento.valorPago = $scope.dadosVenda.totalNota;
            if ($scope.dadosVenda.pagamento) {
                if ($scope.dadosVenda.pagamento.length == 1 && ($scope.dadosVenda.pagamento[0].formaPagamento.fpg_tipopagamento > 2)) {
                    $scope.dadosVenda.pagamento[0].valorPago = $scope.dadosVenda.totalNota;
                    if ($scope.dadosVenda.pagamento[0].parcelas.length > 0) {
                        var valorParcela = parseFloat($scope.dadosVenda.totalNota) / $scope.dadosVenda.pagamento[0].parcelas.length;
                        angular.forEach($scope.dadosVenda.pagamento[0].parcelas, function (parcela, indice) {
                            $scope.dadosVenda.pagamento[0].parcelas[indice].prc_valor = parseFloat(valorParcela);
                        });
                    }
                }
            }

        }, 100);

        if ($scope.dadosVenda.pes_id) {
            $scope.verificaAntecipacoes($scope.dadosVenda.pes_id);
        }
        $scope.dadosVenda.antecipacoes = [];

        $timeout(function () {
            $scope.setarFocus('fpg_id');
        }, 100)
    };

    $scope.ratearValorDesconto = function (padrao) {
        let valorTotalDescontoItem = 0;
        const listaItens = $scope.dadosVenda.listaItens;
        const subTotalBruto = $scope.dadosVenda.subTotalBruto;
        const descontoTotalPercentual = $scope.dadosVenda.descontoTotalPercentual;
        const venMaximoDesconto = $scope.dadosVenda.ven_maximodesconto;

        // Calcula o valor total dos descontos dos itens
        listaItens.forEach(item => {
            valorTotalDescontoItem += item.vlrDescontoItem;
        });

        const numeroUltimoItem = listaItens.length - 1;

        const calcularDescontosItens = (valorTotalDesconto) => {

            let controleValorDesconto = valorTotalDesconto - valorTotalDescontoItem;

            listaItens.forEach((item, index) => {
                const percentagemItemVenda = item.totalItem / subTotalBruto;
                item.vlrDesconto = FuncaoService.arredondar((valorTotalDesconto * percentagemItemVenda) + item.vlrDescontoItem);
                item.desconto = FuncaoService.arredondar(item.vlrDesconto / item.totalItem, 4);
                item.totalItemDesconto = FuncaoService.arredondar(item.totalItem - item.vlrDesconto + item.vlrAcrescimo);

                if (index === numeroUltimoItem) {
                    item.vlrDesconto = item.vlrDescontoItem + controleValorDesconto;
                    item.totalItemDesconto = FuncaoService.arredondar(item.totalItem - item.vlrDesconto + item.vlrAcrescimo);
                }

                controleValorDesconto = FuncaoService.arredondar(controleValorDesconto - (item.vlrDesconto - item.vlrDescontoItem));
                VendaService.editarItem(item.nItem, item);
            });
        };

        if (padrao === '%') {
            const maxDescontoPercentual = venMaximoDesconto || descontoTotalPercentual * 100;
            const valorTotalDesconto = FuncaoService.arredondar(subTotalBruto * descontoTotalPercentual);

            if (descontoTotalPercentual * 100 <= maxDescontoPercentual) {
                calcularDescontosItens(valorTotalDesconto);
            } else {
                swal({
                    title: `Desconto máximo para o vendedor é de ${venMaximoDesconto}%`,
                    text: "Para continuar aplicando o desconto maior que o permitido, você deve solicitar a autorização com seu supervisor/gerente.",
                    type: "warning",
                    showCancelButton: true,
                    cancelButtonText: "OK",
                    confirmButtonClass: "btn-success",
                    confirmButtonText: "Solicitar Autorização"
                }, function (acao) {
                    if (acao) {
                        $timeout(function () {
                            $scope.model.tipoSolicitacao = tipoSolicitacao.descontoMaximo;
                            var retorno = $scope.verificaSenhaGerencial();
                        }, 100);
                    } else {
                        $timeout($scope.calcularDescontoMaximo, 100);
                    }
                });
            }
        } else {
            const valorTotalDesconto = $scope.dadosVenda.descontoTotal;
            const percentualDesconto = FuncaoService.arredondar((valorTotalDesconto * 100) / subTotalBruto, 4);

            if (!venMaximoDesconto || percentualDesconto <= venMaximoDesconto) {
                calcularDescontosItens(valorTotalDesconto);
            } else {
                swal({
                    title: `Desconto máximo para o vendedor é de ${venMaximoDesconto}%`,
                    text: "Para continuar aplicando o desconto maior que o permitido, você deve solicitar a autorização com seu supervisor/gerente.",
                    type: "warning",
                    showCancelButton: true,
                    cancelButtonText: "OK",
                    confirmButtonClass: "btn-success",
                    confirmButtonText: "Solicitar Autorização",
                    allowOutsideClick: false
                }, function (acao) {
                    if (acao) {
                        $timeout(function () {
                            $scope.model.tipoSolicitacao = tipoSolicitacao.descontoMaximo;
                            var retorno = $scope.verificaSenhaGerencial();
                        }, 100);
                    } else {
                        $timeout($scope.calcularDescontoMaximo, 100);
                    }
                });
            }
        }
    };

    $scope.calcularDescontoMaximo = function () {
        let valorTotalDescontoItem = 0;
        const listaItens = $scope.dadosVenda.listaItens;
        const subTotalBruto = $scope.dadosVenda.subTotalBruto;
        const venMaximoDesconto = $scope.dadosVenda.ven_maximodesconto / 100;

        // Calcula o valor total dos descontos dos itens
        listaItens.forEach(item => {
            valorTotalDescontoItem += item.vlrDescontoItem;
        });

        const numeroUltimoItem = listaItens.length - 1;
        const valorTotalDesconto = FuncaoService.arredondar(subTotalBruto * venMaximoDesconto);
        $scope.dadosVenda.descontoTotal = valorTotalDesconto;
        $scope.dadosVenda.descontoTotalPercentual = FuncaoService.arredondar(venMaximoDesconto, 4);

        let controleValorDesconto = valorTotalDesconto - valorTotalDescontoItem;

        listaItens.forEach((item, index) => {
            const percentagemItemVenda = item.totalItem / subTotalBruto;

            item.vlrDesconto = FuncaoService.arredondar((controleValorDesconto * percentagemItemVenda) + item.vlrDescontoItem);
            item.desconto = FuncaoService.arredondar(item.vlrDesconto / item.totalItem, 4);
            item.totalItemDesconto = FuncaoService.arredondar(item.totalItem - item.vlrDesconto + item.vlrAcrescimo);

            // Ajusta o desconto do último item
            if (index === numeroUltimoItem) {
                item.vlrDesconto = controleValorDesconto;
                item.totalItemDesconto = FuncaoService.arredondar(item.totalItem - item.vlrDesconto + item.vlrAcrescimo);
            }

            controleValorDesconto = FuncaoService.arredondar(controleValorDesconto - (item.vlrDesconto - item.vlrDescontoItem));

            // Atualiza o item na venda
            VendaService.editarItem(item.nItem, item);
        });

        // Recalcula os totais da nota após um breve atraso
        $timeout($scope.calcularTotaisNota, 100);
    };

    $scope.ratearValorAcrescimo = function (padrao) {

        const listaItens = $scope.dadosVenda.listaItens;
        const subTotalBruto = $scope.dadosVenda.subTotalBruto;
        const numeroUltimoItem = listaItens.length - 1;

        if (padrao === '%') {
            const acrescimoTotalPercentual = $scope.dadosVenda.acrescimoTotalPercentual;
            const valorTotalAcrescimo = FuncaoService.arredondar(subTotalBruto * acrescimoTotalPercentual);

            $scope.dadosVenda.somaAcrescimoItens = valorTotalAcrescimo;
            let controleValorAcrescimo = valorTotalAcrescimo;

            listaItens.forEach((item, i) => {
                const percentagemItemVenda = item.totalItem / subTotalBruto;
                item.vlrAcrescimo = FuncaoService.arredondar(valorTotalAcrescimo * percentagemItemVenda);
                item.vlrOutro = item.vlrAcrescimo;
                item.acrescimo = FuncaoService.arredondar(item.vlrAcrescimo / item.totalItem, 4);
                item.totalItemDesconto = FuncaoService.arredondar(item.totalItem + item.vlrAcrescimo - item.vlrDesconto);

                if (i === numeroUltimoItem) {
                    item.vlrAcrescimo = controleValorAcrescimo;
                    item.totalItemDesconto = FuncaoService.arredondar(item.totalItem + item.vlrAcrescimo - item.vlrDesconto);
                }

                controleValorAcrescimo = FuncaoService.arredondar(controleValorAcrescimo - item.vlrAcrescimo);
                VendaService.editarItem(item.nItem, item);
            });

        } else {
            const acrescimoTotal = $scope.dadosVenda.acrescimoTotal;
            let controleValorAcrescimo = acrescimoTotal;

            listaItens.forEach((item, i) => {
                const percentagemItemVenda = item.totalItemDesconto / subTotalBruto;
                item.vlrAcrescimo = FuncaoService.arredondar(acrescimoTotal * percentagemItemVenda);
                item.acrescimo = FuncaoService.arredondar(item.vlrAcrescimo / item.totalItem, 4);
                item.vlrOutro = item.vlrAcrescimo;
                item.totalItemDesconto = FuncaoService.arredondar(item.totalItem + item.vlrAcrescimo - item.vlrDesconto);

                if (i === numeroUltimoItem) {
                    item.vlrAcrescimo = controleValorAcrescimo;
                    item.totalItemDesconto = FuncaoService.arredondar(item.totalItem + item.vlrAcrescimo - item.vlrDesconto);
                }

                controleValorAcrescimo = FuncaoService.arredondar(controleValorAcrescimo - item.vlrAcrescimo);
                VendaService.editarItem(item.nItem, item);
            });
        }
    };

    $scope.ratearValorFrete = function () {
        const listaItens = $scope.dadosVenda.listaItens;
        const totalFrete = $scope.dadosVenda.vlrFrete;
        const subTotalBruto = $scope.dadosVenda.subTotalBruto;
        let controleValorFrete = totalFrete;
        const numeroUltimoItem = listaItens.length - 1;

        listaItens.forEach((item, i) => {
            const percentagemItemVenda = item.totalItemDesconto / subTotalBruto;
            item.vlrFrete = FuncaoService.arredondar(totalFrete * percentagemItemVenda);

            if (i === numeroUltimoItem) {
                item.vlrFrete = controleValorFrete;
            }

            controleValorFrete = FuncaoService.arredondar(controleValorFrete - item.vlrFrete);
            VendaService.editarItem(item.nItem, item);
        });
    };

    $scope.ListaFrete = function () {
        $scope.frete.valorFrete = (!!$scope.dadosVenda.vlrFrete) ? $scope.dadosVenda.vlrFrete : 0;
        $scope.frete.dadosCliente.cep = (!!$scope.dadosVenda.cep) ? $scope.dadosVenda.cep : '';
        $scope.frete.dadosCliente.cidade = (!!$scope.dadosVenda.cidade) ? $scope.dadosVenda.cidade : '';
        $scope.frete.dadosCliente.uf = (!!$scope.dadosVenda.uf) ? $scope.dadosVenda.uf : '';
        $scope.frete.dadosCliente.endereco = (!!$scope.dadosVenda.endereco) ? $scope.dadosVenda.endereco : '';
        $scope.frete.dadosCliente.bairro = (!!$scope.dadosVenda.bairro) ? $scope.dadosVenda.bairro : '';
        $scope.frete.dadosCliente.numero = (!!$scope.dadosVenda.numero) ? $scope.dadosVenda.numero : '';
        $scope.frete.dadosCliente.complemento = (!!$scope.dadosVenda.complemento) ? $scope.dadosVenda.complemento : '';

        $scope.modalFrete = ModalService.model($scope, 'views/pdv/varejo/modalFrete.html', 'lg', true, true, true);
        if (!!$scope.dadosVenda.ClienteId) {
            var dadosCliente = JSON.parse(clienteAppService.buscar($scope.dadosVenda.ClienteId));
            $scope.listarEnderecosPessoa(dadosCliente.Id, dadosCliente.pes_id);
        };
        $timeout(function () {
            $scope.setarFocus('valorFrete');
        }, 300)
    };

    $scope.setarFocus = function (nomeElemento) {
        $timeout(function () {
            if (!!document.getElementsByName(nomeElemento)[0])
                document.getElementsByName(nomeElemento)[0].focus();
        });

        $timeout(function () {
            $scope.$apply(function () {
                $('select[name="' + nomeElemento + '"]').chosen({});
                $('select[name="' + nomeElemento + '"]').trigger("chosen:open");
            });
        });
    };

    $scope.DefinirDesconto = function () {
        $scope.modalDesconto = ModalService.model($scope, 'views/pdv/varejo/modalDesconto.html', '', true, true, true);
    };

    $scope.editarParcelas = function (indicePagamento) {
        $scope.listaCondicaoPagamento = JSON.parse(condicaoPagamentoAppService.listaCondicaoRelacionada($scope.dadosVenda.pagamento[indicePagamento].formaPagamento.fpg_id));
        $scope.indicePagamentoAlterarParcelas = indicePagamento;
        $scope.modalParcelas = ModalService.model($scope, 'views/pdv/varejo/modalParcelas.html', '', true, true, true);
    };

    $scope.listarEnderecosPessoa = function (codigoCliente, pessoaId) {
        $scope.dadosVenda.listaEnderecoDestinatario = [];
        if (!!codigoCliente) {
            $scope.dadosVenda.listaEnderecoDestinatario = JSON.parse(clienteAppService.buscaEnderecoCliente(codigoCliente, pessoaId));

            if (!!$scope.frete.dadosCliente.endereco) {
                $scope.frete.endereco = ($scope.dadosVenda.listaEnderecoDestinatario).map(function (key, index) {
                    if ($scope.dadosVenda.listaEnderecoDestinatario[index].pee_endereco == $scope.frete.dadosCliente.endereco)
                        return $scope.dadosVenda.listaEnderecoDestinatario[index];
                });
                if (!!$scope.frete.endereco.length) $scope.frete.endereco = $scope.frete.endereco[0];
            }

            if ($scope.dadosVenda.listaEnderecoDestinatario.length == 1) {
                $scope.montaDadosEndereco($scope.dadosVenda.listaEnderecoDestinatario);
            };
        }
    };

    $scope.montaDadosEndereco = function (endereco) {
        if (!!endereco) {
            $scope.frete.dadosCliente.cep = endereco.pee_cep;
            $scope.frete.dadosCliente.cidade = endereco.pee_cidade;
            $scope.frete.dadosCliente.uf = endereco.pee_uf;
            $scope.frete.dadosCliente.endereco = endereco.pee_endereco;
            $scope.frete.dadosCliente.bairro = endereco.pee_bairro;
            $scope.frete.dadosCliente.numero = endereco.pee_numero;
            $scope.frete.dadosCliente.complemento = endereco.pee_complemento;
        } else {
            $scope.frete.dadosCliente = {};
        }
    }

    $scope.retornaFrete = function (dadosFrete) {
        $scope.dadosVenda.vlrFrete = dadosFrete.valorFrete;
        $scope.dadosVenda.cpfCnpj = dadosFrete.cpfCnpj;
        $scope.dadosVenda.nome = dadosFrete.nome;
        $scope.dadosVenda.cep = (!!dadosFrete.dadosCliente.cep) ? dadosFrete.dadosCliente.cep : '';
        $scope.dadosVenda.cidade = (!!dadosFrete.dadosCliente.cidade) ? dadosFrete.dadosCliente.cidade : '';
        $scope.dadosVenda.uf = (!!dadosFrete.dadosCliente.uf) ? dadosFrete.dadosCliente.uf : '';
        $scope.dadosVenda.endereco = (!!dadosFrete.dadosCliente.endereco) ? dadosFrete.dadosCliente.endereco : '';
        $scope.dadosVenda.bairro = (!!dadosFrete.dadosCliente.bairro) ? dadosFrete.dadosCliente.bairro : '';
        $scope.dadosVenda.numero = (!!dadosFrete.dadosCliente.numero) ? dadosFrete.dadosCliente.numero : '';
        $scope.dadosVenda.complemento = (!!dadosFrete.dadosCliente.complemento) ? dadosFrete.dadosCliente.complemento : '';

        if ($scope.dadosVenda.entregaDomicilio == true) {
            if (!!$scope.dadosVenda.uf && !!$scope.dadosVenda.endereco && !!$scope.dadosVenda.cidade) {
                $scope.calcularTotaisNota();
                $scope.ratearValorFrete();
                $scope.aplicarTransportador(dadosFrete)
                $scope.modalFrete.close();
            } else {
                swal({
                    title: "Atenção!",
                    text: "Para entrega a domicílio é necessario informar o Endereço de Entrega e o Transportador, verifique CPF/CNPJ, Endereço, Cidade e UF para continuar continuar!",
                    type: "warning",
                    showCancelButton: true,
                    cancelButtonText: "Cancelar",
                    confirmButtonClass: "btn-success",
                    confirmButtonText: "Informar Transportador",
                    allowOutsideClick: false
                }, function (acao) {
                    if (acao) {

                    } else {
                        $scope.dadosVenda.entregaDomicilio = false;
                        $scope.calcularTotaisNota();
                        $scope.ratearValorFrete();
                        $scope.modalFrete.close();
                    }
                });
            }
        } else {
            $scope.calcularTotaisNota();
            $scope.ratearValorFrete();
            $scope.aplicarTransportador(dadosFrete)
            $scope.modalFrete.close();
        }
    };

    $scope.aplicarTransportador = function (dadosFrete) {

        var _frete = {
            cpfCnpj: dadosFrete.cpfCnpj,
            nome: (!!dadosFrete.nome) ? dadosFrete.nome : 'O MESMO',
            ie: '',
            endereco: (!!dadosFrete.dadosCliente.endereco) ? dadosFrete.dadosCliente.endereco : '',
            cidade: (!!dadosFrete.dadosCliente.cidade) ? dadosFrete.dadosCliente.cidade : '',
            uf: (!!dadosFrete.dadosCliente.uf) ? dadosFrete.dadosCliente.uf : ''
        }

        var retornoTransportador = VendaService.adicionarTransportador(JSON.stringify(_frete));
    };


    $scope.recalculaParcelas = function (condicaoParcela) {
        $scope.valorCalculadoParcelas = 0;
        for (var i = 0; i < condicaoParcela.parcelas.length; i++) {
            $scope.valorCalculadoParcelas += condicaoParcela.parcelas[i].prc_valor;
        }
        var valorParcelas = FuncaoService.arredondar($scope.valorCalculadoParcelas);
        $scope.diferencaValor = FuncaoService.arredondar(condicaoParcela.valorPago - valorParcelas);
        var valorFormaPagamento = FuncaoService.retornaMoney(condicaoParcela.valorPago);
        if ($scope.diferencaValor != 0) {
            swal({
                title: "A soma das parcelas está com uma diferença de  R$ " + $scope.diferencaValor.toFixed(2) +
                    " do valor declarado para a forma de pagamento R$ " + valorFormaPagamento.toFixed(2) + "     Deseja que o sistema recalcule as parcelas para você?",
                type: "warning",
                showCancelButton: true,
                cancelButtonText: "Não",
                confirmButtonClass: "btn-danger",
                confirmButtonText: "Sim, quero recalcular",
                closeOnConfirm: true
            }, function () {
                $scope.$apply(function () {
                    $scope.gerarParcelas(condicaoParcela.cpg_id);
                });
            })
        }
    };

    $scope.recalculaParcelasValorPagamentoAlterado = function (indicePagamentoValorAlterado) {
        $scope.calcularTotaisNota();
        $scope.indicePagamentoAlterarParcelas = indicePagamentoValorAlterado;
        var somaParcelas = 0;
        var resto = 0;
        if (!!$scope.dadosVenda.pagamento[indicePagamentoValorAlterado].parcelas.length) {
            angular.forEach($scope.dadosVenda.pagamento[indicePagamentoValorAlterado].parcelas, function (parcela) {
                var novoValorParcela = 0;
                novoValorParcela = parseFloat(((parcela.pcl_percparcela / 100) * $scope.dadosVenda.pagamento[indicePagamentoValorAlterado].valorPago).toFixed(2));
                parcela.prc_valor = parseFloat(novoValorParcela);
                somaParcelas += parseFloat(novoValorParcela);
            });
            resto = ($scope.dadosVenda.pagamento[indicePagamentoValorAlterado].valorPago - somaParcelas).toFixed(2);
            resto = parseFloat(resto);
            if (resto != 0) {
                var numeroUltimaParcela = 0;
                if ($scope.dadosVenda.pagamento[indicePagamentoValorAlterado].parcelas.length > 0) {
                    numeroUltimaParcela = $scope.dadosVenda.pagamento[indicePagamentoValorAlterado].parcelas.length - 1;
                } else {
                    numeroUltimaParcela = 1;
                }
                var valParcela = parseFloat($scope.dadosVenda.pagamento[indicePagamentoValorAlterado].parcelas[numeroUltimaParcela].prc_valor);
                var totalParcela = (valParcela + resto).toFixed(2);
                totalParcela = parseFloat(totalParcela);
                $scope.dadosVenda.pagamento[indicePagamentoValorAlterado].parcelas[numeroUltimaParcela].prc_valor = parseFloat(totalParcela);
            }
        }

        //Recalcula os valores do cartao
        if (!!$scope.dadosVenda.pagamento[indicePagamentoValorAlterado].recebimentoCartao.length) {
            var tipoParcelamento = $scope.dadosVenda.pagamento[indicePagamentoValorAlterado].recebimentoCartao[0].tipoParcelamento;
            if (tipoParcelamento == tipoParcelamentoCartao.estabelecimento) {
                for (var i = 0; i < $scope.dadosVenda.pagamento[indicePagamentoValorAlterado].parcelas.length; i++) {
                    $scope.dadosVenda.pagamento[indicePagamentoValorAlterado].recebimentoCartao[i].rcc_valor = $scope.dadosVenda.pagamento[indicePagamentoValorAlterado].parcelas[i].prc_valor;
                }
            } else {
                $scope.dadosVenda.pagamento[indicePagamentoValorAlterado].recebimentoCartao[0].rcc_valor = $scope.dadosVenda.pagamento[indicePagamentoValorAlterado].valorPago;
            }
        }
    };

    $scope.calcularTotaisNota = function () {
        // Inicializando variáveis locais
        let dadosVenda = $scope.dadosVenda;
        let dadosPagamento = $scope.dadosPagamento || {};
        dadosVenda.totalNota = FuncaoService.arredondar(dadosVenda.subTotalBruto);
        // Inicializa totalNota se não estiver definido

        // Calcula o total pago
        $scope.totalPago = 0;
        angular.forEach(dadosVenda.pagamento, function (pagamento) {
            $scope.totalPago += pagamento.valorPago;
        });
        $scope.totalPago = FuncaoService.arredondar($scope.totalPago);

        // Calcula desconto
        if (dadosVenda.descontoEmValorOuPercentual === '$') {
            dadosVenda.descontoTotal = dadosVenda.descontoTotal || 0;
        } else {
            dadosVenda.descontoTotalPercentual = dadosVenda.descontoTotalPercentual || 0;
            dadosVenda.descontoTotal = FuncaoService.arredondar(dadosVenda.subTotalBruto * dadosVenda.descontoTotalPercentual);
        }

        // Calcula acréscimo
        if (dadosVenda.acrescimoEmValorOuPercentual === '$') {
            dadosVenda.acrescimoTotal = dadosVenda.acrescimoTotal || 0;
        } else {
            dadosVenda.acrescimoTotalPercentual = dadosVenda.acrescimoTotalPercentual || 0;
            dadosVenda.acrescimoTotal = FuncaoService.arredondar(dadosVenda.subTotalBruto * dadosVenda.acrescimoTotalPercentual);
        }

        // Inicializa valor do frete
        if (!dadosVenda.vlrFrete) {
            dadosVenda.vlrFrete = dadosVenda.vlrFrete || 0;
        }

        // Ajusta total da nota final
        dadosVenda.totalNota = FuncaoService.arredondar(dadosVenda.totalNota - dadosVenda.descontoTotal + dadosVenda.acrescimoTotal + dadosVenda.vlrFrete);

        // Calcula o valor restante a ser pago
        dadosPagamento.valorPago = FuncaoService.arredondar(dadosVenda.totalNota - $scope.totalPago);

        // Atualiza escopo
        $scope.dadosPagamento = dadosPagamento;
    };

    $scope.aplicarDesconto = function () {
        var _valorRestante = FuncaoService.arredondar($scope.dadosVenda.subTotalBruto - FuncaoService.arredondar($scope.totalPago));
        if (!!$scope.dadosVenda.descontoTotal) {
            if ($scope.dadosVenda.descontoTotal > $scope.dadosVenda.subTotalBruto) {
                swal("Valor do Desconto não pode ser maior que o subtotal da nota!", "", "warning");
                $scope.dadosVenda.descontoTotal = 0;
            }
            else if ($scope.dadosVenda.descontoTotal > _valorRestante) {
                swal("Por favor, adicionar desconto antes de incluir forma de pagamento", "", "warning");
                $scope.dadosVenda.descontoTotal = 0;
            }
        }
        $scope.calcularTotaisNota();
    };

    $scope.aplicarAcrescimo = function () {
        $scope.calcularTotaisNota();
    };

    $scope.alteraPadraoDesconto = function (padrao) {
        $localStorage.padraoDesconto = padrao;
        $scope.dadosVenda.descontoEmValorOuPercentual = padrao;
        if (!!$scope.dadosVenda.descontoTotal) {
            $scope.dadosVenda.subTotalBruto = FuncaoService.arredondar($scope.dadosVenda.subTotalBruto);
            if (padrao == '%') {
                var percentual = (($scope.dadosVenda.descontoTotal * 100) / $scope.dadosVenda.subTotalBruto);
                $scope.dadosVenda.descontoTotalPercentual = FuncaoService.arredondar(percentual / 100, 4);
            }
        } else {
            $scope.dadosVenda.descontoTotalPercentual = 0;
        }
    };

    $scope.alteraPadraoAcrescimo = function (padrao) {
        $localStorage.padraoAcrescimo = padrao;
        $scope.dadosVenda.acrescimoEmValorOuPercentual = padrao;
        if (!!$scope.dadosVenda.acrescimoTotal) {
            $scope.dadosVenda.subTotalBruto = FuncaoService.arredondar($scope.dadosVenda.subTotalBruto);
            if (padrao == '%') {
                var percentual = (($scope.dadosVenda.acrescimoTotal * 100) / $scope.dadosVenda.subTotalBruto);
                $scope.dadosVenda.acrescimoTotalPercentual = FuncaoService.arredondar(percentual / 100, 4);
            }
        } else {
            $scope.dadosVenda.acrescimoTotalPercentual = 0;
        };
    };

    $scope.listarFormaPagamento = function () {
        $scope.listaFormaPagamento = [];
        if (!!!$scope.dadosVenda) {
            $scope.listaFormaPagamento = JSON.parse(formaPagamentoAppService.listaFormaPagamento(null, false));
        }
        else if (!!$scope.dadosVenda.pes_cpfcnpj && !!$scope.dadosVenda.ClienteId) {
            $scope.listaFormaPagamento = JSON.parse(formaPagamentoAppService.listaFormaPagamento());
        } else {
            $scope.listaFormaPagamento = JSON.parse(formaPagamentoAppService.listaFormaPagamento(null, false));
        }
    };

    $scope.listarCondicaoPagamento = function () {
        $scope.listaCondicaoPagamento = [];
        if (!!$scope.dadosPagamento.formaPagamento)
            $scope.listaCondicaoPagamento = JSON.parse(condicaoPagamentoAppService.listaCondicaoRelacionada($scope.dadosPagamento.formaPagamento.fpg_id));
        if ($scope.listaCondicaoPagamento.length == 1) {
            $scope.dadosPagamento.condicaoPagamento = $scope.listaCondicaoPagamento[0];
            $timeout(function () {
                $scope.setarFocus('valorPagamentoCondicaoForma');
                $scope.marcarTexto('valorPagamentoCondicaoForma');
            }, 500)
        } else {
            $scope.setarFocus('cpg_id');
        }
    };

    $scope.marcarTexto = function (nomeElemento) {
        let elemento = document.getElementsByName(nomeElemento)[0];
        if (!!elemento) elemento.select();
    };

    $scope.selecionaFormaPagamento = function () {
        if ($scope.dadosVenda.descontoEmValorOuPercentual == '%') {
            $scope.alteraPadraoDesconto("$");
        }
        if ($scope.dadosVenda.acrescimoEmValorOuPercentual == '%') {
            $scope.alteraPadraoAcrescimo("$");
        }
        $timeout(function () {
            $scope.dadosPagamento.condicaoPagamento = null;

            if (!!$scope.dadosPagamento.descontoPadrao == false) $scope.dadosPagamento.descontoPadrao = {};
            $scope.dadosPagamento.percentualJuros = {};

            if (!(!!!$scope.dadosPagamento.formaPagamento) && $scope.dadosPagamento.formaPagamento.fpg_tipopagamento == 5 && !!$scope.dadosVenda.cli_vendasomenteavista) {
                swal({
                    title: "Este cliente possui uma restrição para vendas apenas com pagamento à vista!",
                    text: "Para continuar com a venda à prazo/crediário, você deve solicitar a autorização de seu supervisor/gerente!",
                    type: "warning",
                    showCancelButton: true,
                    cancelButtonText: "OK",
                    confirmButtonClass: "btn-success",
                    confirmButtonText: "Solicitar Autorização",
                    allowOutsideClick: false
                },
                    function (acao) {
                        if (acao) {
                            $timeout(function () {
                                var retorno = $scope.verificaSenhaGerencial();
                                $scope.model.tipoSolicitacao = tipoSolicitacao.somenteAvista;
                            }, 100);
                        }
                        else {
                            $scope.dadosPagamento.formaPagamento = null;
                        }
                    });
            }
            else {

                if ($scope.dadosPagamento.formaPagamento.fpg_tipopagamento === 2) $scope.dadosVenda.numeroCheques = 1;

                if ((!!$scope.dadosPagamento.formaPagamento == true && $scope.dadosPagamento.formaPagamento.fpg_descontopadrao > 0) && !!$scope.dadosPagamento.descontoPadrao.percentualDesconto == false) {
                    $scope.dadosPagamento.descontoPadrao.percentualDesconto = $scope.dadosPagamento.formaPagamento.fpg_descontopadrao;
                    $scope.dadosPagamento.descontoPadrao.baseCalculo = parseFloat(($scope.dadosVenda.subTotalNota).toFixed(2));
                    $scope.dadosPagamento.descontoPadrao.baseCalculo = parseFloat(($scope.dadosVenda.subTotalBruto - $scope.totalPago - $scope.dadosVenda.descontoTotal + $scope.dadosVenda.acrescimoTotal).toFixed(2));//($scope.dadosVenda.descontoTotal * $scope.dadosVenda.subTotalBruto)).toFixed(2));
                    $scope.dadosPagamento.descontoPadrao.valorDesconto = parseFloat(($scope.dadosPagamento.descontoPadrao.baseCalculo * $scope.dadosPagamento.descontoPadrao.percentualDesconto).toFixed(2));
                }
                else if (!!$scope.dadosPagamento.formaPagamento == true && !!!$scope.dadosPagamento.formaPagamento.fpg_descontopadrao) {
                    $scope.dadosPagamento.descontoPadrao.percentualDesconto = 0;
                    $scope.dadosPagamento.descontoPadrao.baseCalculo = 0;
                    $scope.dadosPagamento.descontoPadrao.valorDesconto = 0;
                }
                else if (!!$scope.dadosPagamento.formaPagamento == false && !!$scope.dadosPagamento.descontoPadrao.percentualDesconto == true) { // forma de pagamento removida....
                    $scope.dadosPagamento.descontoPadrao = {};
                    $scope.dadosPagamento.descontoPadrao.valorDesconto = 0;
                }
                $timeout(function () {

                    if ($scope.dadosPagamento.formaPagamento.fpg_tipopagamento === 1) {
                        $scope.setarFocus('valorPagamentoCondicaoForma');
                        $scope.marcarTexto('valorPagamentoCondicaoForma');
                    }
                }, 100);
                if ($scope.dadosVenda.cli_vendasomenteavista == true && $scope.dadosPagamento.formaPagamento.fpg_tipopagamento == 5) {
                    swal("Venda a Prazo não autorizada!", "", "warning");
                    $scope.dadosPagamento.condicaoPagamento = null;
                    $scope.dadosPagamento.condicaoPagamento = {};
                }
            }

        }, 100);
    };

    $scope.selecionaCondicaoPagamento = function () {
        $timeout(function () {
            if (!!$scope.dadosPagamento.condicaoPagamento) {
                // APLICAR JUROS(ACRESCIMO)
                if (!!$scope.dadosPagamento.percentualJuros == false) $scope.dadosPagamento.percentualJuros = {};
                if (!!$scope.dadosPagamento.condicaoPagamento == true && $scope.dadosPagamento.condicaoPagamento.cpg_percentualjuros > 0) {
                    $scope.dadosPagamento.percentualJuros.percentualJuros = $scope.dadosPagamento.condicaoPagamento.cpg_percentualjuros;
                    $scope.dadosPagamento.percentualJuros.baseCalculo = ($scope.dadosPagamento.valorPago <= ($scope.dadosVenda.totalNota - $scope.totalPago) ? $scope.dadosPagamento.valorPago : ($scope.dadosPagamento.valorPago > ($scope.dadosVenda.totalNota - $scope.totalPago) ? ($scope.dadosVenda.totalNota - $scope.totalPago) : ($scope.dadosVenda.totalNota - $scope.totalPago) - $scope.dadosPagamento.valorPago));
                    $scope.dadosPagamento.percentualJuros.valorJuros = parseFloat(($scope.dadosPagamento.percentualJuros.baseCalculo * $scope.dadosPagamento.percentualJuros.percentualJuros).toFixed(2));
                }
                else if (!!$scope.dadosPagamento.condicaoPagamento == false && !!$scope.dadosPagamento.percentualJuros.percentualJuros == true) { // forma de pagamento removida....
                    $scope.dadosPagamento.percentualJuros = {};
                    $scope.dadosPagamento.percentualJuros.valorJuros = 0;
                } else {
                    $scope.dadosPagamento.percentualJuros.baseCalculo = 0;
                    $scope.dadosPagamento.percentualJuros.percentualJuros = 0;
                    $scope.dadosPagamento.percentualJuros.valorJuros = 0;
                }
                // APLICAR DESCONTOS
                if (!!$scope.dadosPagamento.descontoPadrao == false) $scope.dadosPagamento.descontoPadrao = {};
                if ((!!$scope.dadosPagamento.condicaoPagamento == true && $scope.dadosPagamento.condicaoPagamento.cpg_descontopadrao > 0) && !!$scope.dadosPagamento.descontoPadrao.percentualDesconto == false) {
                    $scope.dadosPagamento.descontoPadrao.percentualDesconto = $scope.dadosPagamento.condicaoPagamento.cpg_descontopadrao;
                    $scope.dadosPagamento.descontoPadrao.baseCalculo = ($scope.dadosPagamento.valorPago <= ($scope.dadosVenda.totalNota - $scope.totalPago) ? $scope.dadosPagamento.valorPago : ($scope.dadosPagamento.valorPago > ($scope.dadosVenda.totalNota - $scope.totalPago) ? ($scope.dadosVenda.totalNota - $scope.totalPago) : ($scope.dadosVenda.totalNota - $scope.totalPago) - $scope.dadosPagamento.valorPago));//$scope.dadosPagamento.descontoPadrao.baseCalculo = ($scope.dadosPagamento.valorPago <= $scope.dadosVenda.totalNota ? $scope.dadosPagamento.valorPago : ($scope.dadosVenda.totalNota - $scope.dadosPagamento.valorPago));
                    $scope.dadosPagamento.descontoPadrao.valorDesconto = parseFloat(($scope.dadosPagamento.descontoPadrao.baseCalculo * $scope.dadosPagamento.descontoPadrao.percentualDesconto).toFixed(2));
                }
                else if (!!$scope.dadosPagamento.condicaoPagamento == false && !!$scope.dadosPagamento.descontoPadrao.percentualDesconto == true) { // forma de pagamento removida....
                    $scope.dadosPagamento.descontoPadrao = {};
                    $scope.dadosPagamento.descontoPadrao.valorDesconto = 0;
                }
                else {
                    $scope.dadosPagamento.descontoPadrao.baseCalculo = 0;
                    $scope.dadosPagamento.descontoPadrao.percentualDesconto = 0;
                    $scope.dadosPagamento.descontoPadrao.valorDesconto = 0;
                }
            } else if (!!$scope.dadosPagamento.condicaoPagamento == false && !!$scope.dadosPagamento.percentualJuros.percentualJuros == true) { // condicao de pagamento removida....
                $scope.dadosVenda.acrescimoTotal -= $scope.dadosPagamento.percentualJuros.valorJuros;
                $scope.dadosPagamento.percentualJuros = {};
            }
            $scope.dadosPagamento.valorPago = parseFloat(($scope.dadosVenda.totalNota - $scope.totalPago - $scope.dadosPagamento.descontoPadrao.valorDesconto + $scope.dadosPagamento.percentualJuros.valorJuros).toFixed(2));
        }, 100);
    };

    $scope.keyEnterAdicionarPagamento = function () {
        if ($scope.dadosPagamento.formaPagamento.fpg_tipopagamento === tipoFormaPagamento.fpPixDinamico && $scope.dadosPagamento.formaPagamento.fpg_tipopagamento === tipoFormaPagamento.fpPixEstatico) {
            if ($scope.dadosPagamento.condicaoPagamento == null) {
                swal("ATENÇÃO!", "Não foi informado condição de pagamento!", "warning");
            } else {
                if ($scope.totalPago < $scope.dadosVenda.totalNota) {
                    $scope.adicionarPagamento($scope.dadosPagamento);
                }
            }
        } else {
            if ($scope.totalPago < $scope.dadosVenda.totalNota) {
                $scope.adicionarPagamento($scope.dadosPagamento);
            }
        }
    };

    // Criado por causa da senha gerencial que foi alterado.
    function _calcularDescontosItens() {
        let valorTotalDescontoItem = 0;
        const listaItens = $scope.dadosVenda.listaItens;
        const subTotalBruto = $scope.dadosVenda.subTotalBruto;
        const descontoTotalPercentual = $scope.dadosVenda.descontoTotalPercentual;
        const valorTotalDesconto = FuncaoService.arredondar(subTotalBruto * descontoTotalPercentual);

        // Calcula o valor total dos descontos dos itens
        listaItens.forEach(item => {
            valorTotalDescontoItem += item.vlrDescontoItem;
        });

        const numeroUltimoItem = listaItens.length - 1;
        let controleValorDesconto = valorTotalDesconto - valorTotalDescontoItem;

        listaItens.forEach((item, index) => {
            const percentagemItemVenda = item.totalItem / subTotalBruto;
            item.vlrDesconto = FuncaoService.arredondar((valorTotalDesconto * percentagemItemVenda) + item.vlrDescontoItem);
            item.desconto = FuncaoService.arredondar(item.vlrDesconto / item.totalItem, 4);
            item.totalItemDesconto = FuncaoService.arredondar(item.totalItem - item.vlrDesconto + item.vlrAcrescimo);

            if (index === numeroUltimoItem) {
                item.vlrDesconto = item.vlrDescontoItem + controleValorDesconto;
                item.totalItemDesconto = FuncaoService.arredondar(item.totalItem - item.vlrDesconto + item.vlrAcrescimo);
            }

            controleValorDesconto = FuncaoService.arredondar(controleValorDesconto - (item.vlrDesconto - item.vlrDescontoItem));
            VendaService.editarItem(item.nItem, item);
        });
    }


    $scope.verificaSenhaGerencial = function () {
        var retorno = localAppService.possuiSenhaGerencial();
        if (retorno == true) {
            $scope.modalSenhaGerencial = ModalService.model($scope, 'views/pdv/varejo/modalSenhaGerencial.html', 'sm', true, 'static', true);
        }
    };
    $scope.validaSenhaGerencial = function (senha) {
        var senhaValida = localAppService.validarSenhaGerencial(senha);
        if (senhaValida == true) {
            if ($scope.model.tipoSolicitacao == tipoSolicitacao.parcelasAtrazadas) {
                $scope.modalParcelasAtraso.close();
                $scope.verificarLimiteCredito();
            }
            if ($scope.model.tipoSolicitacao == tipoSolicitacao.limiteCredito) {
                adicionarPagamento($scope.dadosPagamento);
            }
            if ($scope.model.tipoSolicitacao == tipoSolicitacao.somenteAvista) {
                $scope.dadosVenda.cli_vendasomenteavista = false;
                $scope.selecionaFormaPagamento();
            }
            if ($scope.model.tipoSolicitacao == tipoSolicitacao.descontoMaximo) {
                _calcularDescontosItens();
            }
            $scope.model.tipoSolicitacao = 0;
            $scope.model.senhaGerencial = '';
            $scope.modalSenhaGerencial.close();
        } else {
            swal("Senha incorreta!", "", "warning");
        }
    };

    $scope.fecharModalSenhaGerencial = function () {
        if ($scope.model.tipoSolicitacao == tipoSolicitacao.somenteAvista) {
            $scope.dadosPagamento.formaPagamento = null;
        }
        if ($scope.model.tipoSolicitacao == tipoSolicitacao.descontoMaximo) {
            $scope.calcularDescontoMaximo();
        }
        $scope.model.tipoSolicitacao = 0;
        $scope.model.senhaGerencial = '';
        $scope.modalSenhaGerencial.close();
    };

    $scope.solicitarPermissaoGerencialParcelasAtraso = function () {
        var retorno = $scope.verificaSenhaGerencial();
        $scope.model.tipoSolicitacao = tipoSolicitacao.parcelasAtrazadas;
    };

    $scope.verificarLimiteCredito = function () {
        if (navigator.onLine && $scope.limiteCreditoDisponivel != null) {
            if ($scope.limiteCreditoDisponivel.valorTotal != 0 && $scope.limiteCreditoDisponivel.valorTotal < $scope.dadosPagamento.valorPago) {
                var limiteDisponivel = ($scope.limiteCreditoDisponivel.valorTotal) ? $scope.limiteCreditoDisponivel.valorTotal : 0;
                swal({
                    title: "O limite de crédito ainda disponível para compras à prazo deste cliente é: " + parseFloat(limiteDisponivel).toFixed(2).toString(),
                    text: "Para continuar com a venda à prazo você deve solicitar autorização da operação com seu supervisor/gerente.",
                    type: "warning",
                    showCancelButton: true,
                    cancelButtonText: "OK",
                    confirmButtonClass: "btn-success",
                    confirmButtonText: "Solicitar Autorização",
                    allowOutsideClick: false
                }, function (acao) {
                    if (acao) {
                        $timeout(function () {
                            var retorno = $scope.verificaSenhaGerencial();
                            $scope.model.tipoSolicitacao = tipoSolicitacao.limiteCredito;
                        }, 100);
                    }
                });
            }
            else {
                adicionarPagamento($scope.dadosPagamento);
            }
        } else {
            swal("ATENÇÃO!!!", "Este computador não esta conectado a internet. Desta forma não é possível realizar a consulta de pendencias do cliente e verificar o limite de crédito disponível para realizar a venda no crediário. E recomendável que você fale com seu supervisor/gerente antes de prosseguir com a venda!", "warning");
            adicionarPagamento($scope.dadosPagamento);
        }
    };

    $scope.adicionarPagamento = function (dadosPagamento) {
        if ($scope.dadosVenda.descontoEmValorOuPercentual == '%') {
            $scope.alteraPadraoDesconto("$");
        }
        if ($scope.dadosVenda.acrescimoEmValorOuPercentual == '%') {
            $scope.alteraPadraoAcrescimo("$");
        }

        if (!!$scope.dadosPagamento.descontoPadrao == false) $scope.dadosPagamento.descontoPadrao = {};
        $scope.parcelasAtraso = [];
        var adicionar = true;
        if (dadosPagamento.formaPagamento.fpg_tipopagamento != tipoFormaPagamento.fpDinheiro && dadosPagamento.formaPagamento.fpg_tipopagamento != tipoFormaPagamento.fpPixDinamico && dadosPagamento.formaPagamento.fpg_tipopagamento != tipoFormaPagamento.fpPixEstatico) {
            if (FuncaoService.round($scope.dadosVenda.totalNota - $scope.totalPago, 2) < FuncaoService.round(dadosPagamento.valorPago, 2)) {
                swal("ATENÇÃO!", "Valor informado maior que o valor restante!", "warning");
                return;
            }
        }
        if (dadosPagamento.formaPagamento.fpg_tipopagamento == tipoFormaPagamento.fpCreditoLoja && !!$scope.dadosVenda.cli_id) {
            if (navigator.onLine) {
                angular.forEach($scope.dadosVenda.pagamento, function (formaPagto) {
                    if (formaPagto.formaPagamento.fpg_id == dadosPagamento.formaPagamento.fpg_id && (formaPagto.formaPagamento.fpg_tipopagamento != tipoFormaPagamento.fpCartaoCredito && formaPagto.formaPagamento.fpg_tipopagamento != tipoFormaPagamento.fpCartaoDebito)) {
                        adicionar = false;
                        swal("A forma de pagamento,", formaPagto.formaPagamento.fpg_descricao + " já foi utilizado como forma de pagamento, para o valor R$" + formaPagto.valorPago.toFixed(2), "warning");
                    }
                });
                if (adicionar == true) {
                    $scope.parcelasAtraso = JSON.parse(clienteAppService.verificarParcelasEmAtraso($scope.dadosVenda.pes_id));
                    $scope.limiteCreditoDisponivel = JSON.parse(clienteAppService.limiteCreditoDisponivel($scope.dadosVenda.pes_id));
                    if ($scope.parcelasAtraso == null) {
                        swal("ATENÇÃO!!!", "Este computador não esta conectado a internet. Desta forma não é possível realizar a consulta de pendencias do cliente e verificar o limite de crédito disponível para realizar a vendo no crediário. E recomendável que você fale com seu supervisor/gerente antes de prosseguir com a venda!", "warning");
                        if (adicionar == true) {
                            adicionarPagamento(dadosPagamento);
                        }
                    }
                    else if ($scope.parcelasAtraso.length > 0) {
                        $scope.modalParcelasAtraso = ModalService.model($scope, 'views/pdv/varejo/modalParcelasPendentes.html', 'lg', true, true, true);
                    }
                    else if ($scope.limiteCreditoDisponivel == null) {
                        swal("ATENÇÃO!!!", "Este computador não esta conectado a internet. Desta forma não é possível realizar a consulta de pendencias do cliente e verificar o limite de crédito disponível para realizar a venda no crediário. E recomendável que você fale com seu supervisor/gerente antes de prosseguir com a venda!", "warning");
                        if (adicionar == true) {
                            adicionarPagamento(dadosPagamento);
                        }
                    }
                    else if (!!$scope.limiteCreditoDisponivel.valorTotal && $scope.limiteCreditoDisponivel.valorTotal < dadosPagamento.valorPago) {
                        var limiteDisponivel = ($scope.limiteCreditoDisponivel.valorTotal) ? $scope.limiteCreditoDisponivel.valorTotal : 0;
                        swal({
                            title: "O limite de crédito ainda disponível para compras à prazo deste cliente é: " + parseFloat(limiteDisponivel).toFixed(2).toString(),
                            text: "Para continuar com a venda à prazo você deve solicitar autorização da operação com seu supervisor/gerente.",
                            type: "warning",
                            showCancelButton: true,
                            cancelButtonText: "OK",
                            confirmButtonClass: "btn-success",
                            confirmButtonText: "Solicitar Autorização",
                            allowOutsideClick: false
                        }, function (acao) {
                            if (acao) {
                                $timeout(function () {
                                    if (adicionar == true) {
                                        var retorno = $scope.verificaSenhaGerencial();
                                        $scope.model.tipoSolicitacao = tipoSolicitacao.limiteCredito;
                                    }
                                }, 100);
                            }
                        });
                    }
                    else {
                        if (adicionar == true) {
                            adicionarPagamento(dadosPagamento);
                        }
                    }
                } else {
                    $scope.dadosPagamento.formaPagamento = [];
                    $scope.selecionaFormaPagamento();
                }
            }
            else {
                swal("ATENÇÃO!!!", "Este computador não esta conectado a internet. Desta forma não é possível realizar a consulta de pendencias do cliente e verificar o limite de crédito disponível para realizar a vendo no crediário. E recomendável que você fale com seu supervisor/gerente antes de prosseguir com a venda!", "warning");
                if (adicionar == true) {
                    adicionarPagamento(dadosPagamento);
                }
            }
        }
        else {
            angular.forEach($scope.dadosVenda.pagamento, function (formaPagto) {
                if (formaPagto.formaPagamento.fpg_id == dadosPagamento.formaPagamento.fpg_id && (formaPagto.formaPagamento.fpg_tipopagamento != tipoFormaPagamento.fpCartaoCredito && formaPagto.formaPagamento.fpg_tipopagamento != tipoFormaPagamento.fpCartaoDebito && formaPagto.formaPagamento.fpg_tipopagamento != tipoFormaPagamento.fpValePresente)) {
                    adicionar = false;
                    swal("A forma de pagamento,", formaPagto.formaPagamento.fpg_descricao + " já foi utilizado como forma de pagamento, para o valor R$" + formaPagto.valorPago.toFixed(2), "warning");
                }
            });
            if (adicionar == true) {
                adicionarPagamento(dadosPagamento);
            } else {
                $scope.dadosPagamento.formaPagamento = [];
                $scope.selecionaFormaPagamento();
            }
        }
    };

    var tipoParcelamentoCartao = {
        estabelecimento: 0,
        comprador: 1
    };

    function adicionarPagamento(dadosPagamento) {
        if (!!dadosPagamento.valorPago == false) dadosPagamento.valorPago = $scope.dadosVenda.totalNota;
        $scope.dadosPagamento.valorPago = FuncaoService.arredondar(dadosPagamento.valorPago);
        if ($scope.dadosPagamento.valorPago <= 0) {
            swal("Valor da forma de pagamento não pode ser menor ou igual a R$ 0,00 Verifique e tente novamente!", "Ops", "warning");
            return;
        }
        if ((!!dadosPagamento.formaPagamento == true && dadosPagamento.descontoPadrao.percentualDesconto > 0) && !!dadosPagamento.descontoPadrao.percentualDesconto == true) {
            $scope.calcularDescontoPadraoPagamento();
        }
        if ((!!dadosPagamento.formaPagamento == true && dadosPagamento.percentualJuros.percentualJuros > 0) && !!dadosPagamento.percentualJuros.percentualJuros == true) {
            $scope.calcularAcrescimoPadraoPagamento();
        }
        $scope.dadosVenda.pagamento = (!!$scope.dadosVenda.pagamento) ? $scope.dadosVenda.pagamento : [];
        dadosPagamento.parcelas = [];
        dadosPagamento.cheques = [];
        dadosPagamento.recebimentoCartao = [];
        var definicaoParcelamento = [];

        if (!!dadosPagamento.condicaoPagamento == true && !!dadosPagamento.condicaoPagamento.cpg_id == true) definicaoParcelamento = JSON.parse(condicaoPagamentoAppService.listaParcelasCondicao(dadosPagamento.condicaoPagamento.cpg_id));

        var parametrosEmpresa = parametrosEmpresaAppService.retornaDadosParametrosEmpresa();

        var somaParcelas = 0;
        var resto = 0;
        if (definicaoParcelamento.length > 0) {
            angular.forEach(definicaoParcelamento, function (parcela, indice) {
                var dataAtual = new Date();
                var dataVencimentoParcela = new Date(dataAtual.setDate(dataAtual.getDate() + parcela.pcl_numerodias));

                var pcl_toleranciaparcela = new Date(dataVencimentoParcela);
                if (!!parametrosEmpresa.par_diastoleranciaparcela) {
                    pcl_toleranciaparcela = new Date(pcl_toleranciaparcela.setDate(dataVencimentoParcela.getDate() + parametrosEmpresa.par_diastoleranciaparcela));
                } else {
                    pcl_toleranciaparcela = new Date(pcl_toleranciaparcela.setDate(pcl_toleranciaparcela.getDate() + 720));
                }

                pcl_toleranciaparcela = FuncaoService.formataDataNormal(pcl_toleranciaparcela);

                var valorParcela = 0;
                var entrada = false;
                if (dadosPagamento.formaPagamento.fpg_tipopagamento == tipoFormaPagamento.fpCreditoLoja && parcela.pcl_numerodias == 0) entrada = true;
                valorParcela = FuncaoService.arredondar((parcela.pcl_percparcela / 100) * ($scope.dadosPagamento.valorPago));
                dadosPagamento.parcelas.push({
                    prc_entrada: entrada,
                    prc_numeroparcela: indice + 1,
                    prc_datavencimento: dataVencimentoParcela,
                    prc_dataprevisao: dataVencimentoParcela,
                    prc_valor: FuncaoService.arredondar(valorParcela),
                    pcl_percparcela: parcela.pcl_percparcela,
                    pcl_numerodias: parcela.pcl_numerodias,
                    pcl_toleranciaparcela: (!!pcl_toleranciaparcela) ? pcl_toleranciaparcela : null
                });
                somaParcelas += FuncaoService.arredondar(valorParcela);
                somaParcelas = FuncaoService.arredondar(somaParcelas);
            });
            resto = FuncaoService.arredondar($scope.dadosPagamento.valorPago - somaParcelas);
            resto = FuncaoService.arredondar(resto);
        }

        if (resto != 0) {
            var numeroUltimaParcela = 0;
            if (definicaoParcelamento.length > 0) {
                numeroUltimaParcela = definicaoParcelamento.length - 1;
            } else {
                numeroUltimaParcela = 1;
            }
            var valParcela = FuncaoService.arredondar(dadosPagamento.parcelas[numeroUltimaParcela].prc_valor);
            var totalParcela = FuncaoService.arredondar(valParcela + resto);
            totalParcela = FuncaoService.arredondar(totalParcela);
            dadosPagamento.parcelas[numeroUltimaParcela].prc_valor = FuncaoService.arredondar(totalParcela);
        }

        if (dadosPagamento.formaPagamento.fpg_tipopagamento == parseInt(tipoFormaPagamento.fpValePresente)) {
            dadosPagamento.codigoValePresente = $scope.dadosVenda.codigoValePresente;
        }

        if (!!dadosPagamento.descontoPadrao && dadosPagamento.descontoPadrao.baseCalculo > 0 && dadosPagamento.descontoPadrao.valorDesconto > 0) {
            if ($scope.dadosVenda.subTotalNota === FuncaoService.arredondar(dadosPagamento.descontoPadrao.baseCalculo + $scope.totalPago)) {
                $scope.dadosPagamento.valorPago = FuncaoService.arredondar(dadosPagamento.descontoPadrao.baseCalculo - dadosPagamento.descontoPadrao.valorDesconto);
            }
        }

        if (VendaService.aplicarFormaPagamento(JSON.stringify(dadosPagamento))) {
            $scope.dadosVenda.pagamento.push(angular.copy(dadosPagamento));

            if (dadosPagamento.formaPagamento.fpg_tipopagamento == parseInt(tipoFormaPagamento.fpCheque)) {
                var numeroChequesLancar = $scope.dadosVenda.numeroCheques;
                if (!!numeroChequesLancar == false) numeroChequesLancar = 1;
                $scope.lancamentoCheque(numeroChequesLancar, $scope.dadosPagamento.valorPago, ($scope.dadosVenda.pagamento.length - 1), $scope.dadosPagamento.formaPagamento.fpg_tipopagamento);
            }

            if (dadosPagamento.formaPagamento.fpg_tipointegracao == null) {
                if (dadosPagamento.formaPagamento.fpg_tipopagamento == parseInt(tipoFormaPagamento.fpCartaoCredito) || dadosPagamento.formaPagamento.fpg_tipopagamento == parseInt(tipoFormaPagamento.fpCartaoDebito)) {
                    $scope.modalBandeirasCartao = ModalService.abrir('views/pdv/modalBandeiraCartao.html', 'lg', true, 'static', true, 'ModalBandeiraCartaoController', { 'tipoPagamento': $scope.dadosPagamento.formaPagamento.fpg_tipopagamento });
                    $scope.modalBandeirasCartao.result.then(function (retornoDadosBandeiraCartao) {
                        var indexPosicaoPagamento = ($scope.dadosVenda.pagamento.length) - 1;
                        if (!!retornoDadosBandeiraCartao == false) {
                            var voltarFormaPagamento = $scope.dadosVenda.pagamento[indexPosicaoPagamento].formaPagamento;
                            removerFormaPagamento(indexPosicaoPagamento);
                            $scope.dadosPagamento.formaPagamento = voltarFormaPagamento;
                            $scope.selecionaFormaPagamento();
                        } else {
                            var dadosBandeiraCartaoEmpresa = JSON.parse(bandeiraCartaoEmpresaAppService.retornaDadosBandeiraCartaoEmpresa(retornoDadosBandeiraCartao.bandeira.bce_id));
                            var dataAtual = new Date();
                            if (!!retornoDadosBandeiraCartao.cartaoCredito) {
                                $scope.dadosVenda.pagamento[indexPosicaoPagamento].recebimentoCartao = [];
                                if (retornoDadosBandeiraCartao.tipoParcelamento == tipoParcelamentoCartao.estabelecimento) {
                                    var numeroDias = parseInt(dadosBandeiraCartaoEmpresa.bce_nrodiasrecebimentocredito);
                                    angular.forEach($scope.dadosVenda.pagamento[indexPosicaoPagamento].parcelas, function (parcela) {
                                        $scope.dadosVenda.pagamento[indexPosicaoPagamento].recebimentoCartao.push({
                                            tipoParcelamento: tipoParcelamentoCartao.estabelecimento,
                                            bce_id: retornoDadosBandeiraCartao.bandeira.bce_id,
                                            rcc_parcelarecebimento: parcela.prc_numeroparcela,
                                            rcc_valor: parcela.prc_valor,
                                            rcc_nsu: retornoDadosBandeiraCartao.nsu,
                                            rcc_previsaorecebimento: new Date(dataAtual.setDate(dataAtual.getDate() + numeroDias))
                                        });
                                    });
                                    /* zerar os dados de parcelas apos adicionar os recebimentos por cartao */
                                    $scope.dadosVenda.pagamento[indexPosicaoPagamento].parcelas = [];
                                } else {
                                    dataAtual = new Date();
                                    $scope.dadosVenda.pagamento[indexPosicaoPagamento].recebimentoCartao.push({
                                        tipoParcelamento: tipoParcelamentoCartao.comprador,
                                        bce_id: retornoDadosBandeiraCartao.bandeira.bce_id,
                                        rcc_parcelarecebimento: 1,
                                        rcc_valor: $scope.dadosVenda.pagamento[indexPosicaoPagamento].valorPago,
                                        rcc_nsu: retornoDadosBandeiraCartao.nsu,
                                        rcc_previsaorecebimento: new Date(dataAtual.setDate(dataAtual.getDate() + parseInt(dadosBandeiraCartaoEmpresa.bce_nrodiasrecebimentocredito)))
                                    });
                                }
                            } else {
                                dataAtual = new Date();
                                $scope.dadosVenda.pagamento[indexPosicaoPagamento].recebimentoCartao.push({
                                    tipoParcelamento: null,
                                    bce_id: retornoDadosBandeiraCartao.bandeira.bce_id,
                                    rcc_parcelarecebimento: 1,
                                    rcc_valor: $scope.dadosVenda.pagamento[indexPosicaoPagamento].valorPago,
                                    rcc_nsu: retornoDadosBandeiraCartao.nsu,
                                    rcc_previsaorecebimento: new Date(dataAtual.setDate(dataAtual.getDate() + parseInt(dadosBandeiraCartaoEmpresa.bce_nrodiasrecebimentodebito)))
                                });
                            }
                        }
                    }, function (esc) {
                        var indexPosicaoPagamento = ($scope.dadosVenda.pagamento.length) - 1;
                        var voltarFormaPagamento = $scope.dadosVenda.pagamento[indexPosicaoPagamento].formaPagamento;
                        removerFormaPagamento(indexPosicaoPagamento);
                        $scope.dadosPagamento.formaPagamento = voltarFormaPagamento;
                        $scope.selecionaFormaPagamento();
                    });
                }
            } else {
                var indexPosicaoPagamento = ($scope.dadosVenda.pagamento.length) - 1;
                $scope.dadosVenda.pagamento[indexPosicaoPagamento].integrapgtook = false;
            }

            $scope.calcularTotaisNota();
            $scope.dadosPagamento.valorPago = FuncaoService.arredondar($scope.dadosVenda.totalNota - $scope.totalPago);
            $scope.dadosPagamento.descontoPadrao = {};
            $scope.dadosPagamento.formaPagamento = null;
            $scope.dadosPagamento.condicaoPagamento = null;
        }
        else {
            $scope.pagamentoNaoIncluido = dadosPagamento;
            $scope.modalFalhaPagamento = ModalService.model($scope, 'views/pdv/forma-pagamento/modaFormaPagamentoNaoIncluida.html', 'lg', true, true, true);
        }
    }

    $scope.tipoPagamentoEntrada = function (dadosPagamentoParcela) {
        var definicaoParcelamento = [];
        var parcelas = [];
        if (!!dadosPagamentoParcela.condicaoPagamento == true && !!dadosPagamentoParcela.condicaoPagamento.cpg_id == true) definicaoParcelamento = JSON.parse(condicaoPagamentoAppService.listaParcelasCondicao(dadosPagamentoParcela.condicaoPagamento.cpg_id));

        var somaParcelas = 0;
        var resto = 0;
        if (definicaoParcelamento.length > 0) {
            angular.forEach(definicaoParcelamento, function (parcela, indice) {
                var dataAtual = new Date();
                var dataVencimentoParcela = new Date(dataAtual.setDate(dataAtual.getDate() + parcela.pcl_numerodias));

                var valorParcela = 0;
                var entrada = false;
                if (dadosPagamentoParcela.formaPagamento.fpg_tipopagamento == 5 && parcela.pcl_numerodias == 0) entrada = true;
                valorParcela = ((parcela.pcl_percparcela / 100) * (dadosPagamentoParcela.prc_valor)).toFixed(2);
                parcelas.push({
                    prc_entrada: entrada,
                    prc_numeroparcela: indice + 1,
                    prc_datavencimento: dataVencimentoParcela,
                    prc_dataprevisao: dataVencimentoParcela,
                    prc_valor: parseFloat(valorParcela),
                    pcl_percparcela: parcela.pcl_percparcela,
                    pcl_numerodias: parcela.pcl_numerodias
                });
                somaParcelas += parseFloat(valorParcela);
                somaParcelas = parseFloat(somaParcelas);
            });
            resto = (dadosPagamentoParcela.prc_valor - somaParcelas).toFixed(2);
            resto = parseFloat(resto);
        }

        if (resto != 0) {
            var numeroUltimaParcela = 0;
            if (definicaoParcelamento.length > 0) {
                numeroUltimaParcela = definicaoParcelamento.length - 1;
            } else {
                numeroUltimaParcela = 1;
            }
            var valParcela = parseFloat(parcelas[numeroUltimaParcela].prc_valor);
            var totalParcela = (valParcela + resto).toFixed(2);
            totalParcela = parseFloat(totalParcela);
            parcelas[numeroUltimaParcela].prc_valor = parseFloat(totalParcela);
        }

        if (dadosPagamentoParcela.formaPagamento.fpg_tipopagamento == parseInt(tipoFormaPagamento.fpCartaoCredito) || dadosPagamentoParcela.formaPagamento.fpg_tipopagamento == parseInt(tipoFormaPagamento.fpCartaoDebito)) {
            $scope.modalBandeirasCartao = ModalService.abrir('views/pdv/modalBandeiraCartao.html', 'lg', true, 'static', true, 'ModalBandeiraCartaoController', { 'tipoPagamento': dadosPagamentoParcela.formaPagamento.fpg_tipopagamento });
            $scope.modalBandeirasCartao.result.then(function (retornoDadosBandeiraCartao) {
                var indexPosicaoPagamento = ($scope.dadosVenda.pagamento.length) - 1;
                if (!!retornoDadosBandeiraCartao == false) {
                    dadosPagamentoParcela.recebimentoCartao = [];
                    dadosPagamentoParcela.formaPagamento = null;
                    dadosPagamentoParcela.condicaoPagamento = null;
                } else {
                    var dadosBandeiraCartaoEmpresa = JSON.parse(bandeiraCartaoEmpresaAppService.retornaDadosBandeiraCartaoEmpresa(retornoDadosBandeiraCartao.bandeira.bce_id));
                    var dataAtual = new Date();
                    if (!!retornoDadosBandeiraCartao.cartaoCredito) {
                        dadosPagamentoParcela.recebimentoCartao = [];
                        if (retornoDadosBandeiraCartao.tipoParcelamento == tipoParcelamentoCartao.estabelecimento) {
                            var numeroDias = parseInt(dadosBandeiraCartaoEmpresa.bce_nrodiasrecebimentocredito);
                            angular.forEach(parcelas, function (parcela) {
                                dadosPagamentoParcela.recebimentoCartao.push({
                                    tipoParcelamento: tipoParcelamentoCartao.estabelecimento,
                                    bce_id: retornoDadosBandeiraCartao.bandeira.bce_id,
                                    rcc_parcelarecebimento: parcela.prc_numeroparcela,
                                    rcc_valor: parcela.prc_valor,
                                    rcc_nsu: retornoDadosBandeiraCartao.nsu,
                                    rcc_previsaorecebimento: new Date(dataAtual.setDate(dataAtual.getDate() + numeroDias))
                                });
                            })
                        } else {
                            dataAtual = new Date();
                            dadosPagamentoParcela.recebimentoCartao.push({
                                tipoParcelamento: tipoParcelamentoCartao.comprador,
                                bce_id: retornoDadosBandeiraCartao.bandeira.bce_id,
                                rcc_parcelarecebimento: 1,
                                rcc_valor: dadosPagamentoParcela.prc_valor,
                                rcc_nsu: retornoDadosBandeiraCartao.nsu,
                                rcc_previsaorecebimento: new Date(dataAtual.setDate(dataAtual.getDate() + parseInt(dadosBandeiraCartaoEmpresa.bce_nrodiasrecebimentocredito)))
                            });
                        }
                    } else {
                        dataAtual = new Date();
                        dadosPagamentoParcela.recebimentoCartao = [];
                        dadosPagamentoParcela.recebimentoCartao.push({
                            tipoParcelamento: null,
                            bce_id: retornoDadosBandeiraCartao.bandeira.bce_id,
                            rcc_parcelarecebimento: 1,
                            rcc_valor: dadosPagamentoParcela.prc_valor,
                            rcc_nsu: retornoDadosBandeiraCartao.nsu,
                            rcc_previsaorecebimento: new Date(dataAtual.setDate(dataAtual.getDate() + parseInt(dadosBandeiraCartaoEmpresa.bce_nrodiasrecebimentodebito)))
                        });
                    }
                }
            }, function (esc) {
                dadosPagamentoParcela.recebimentoCartao = [];
                dadosPagamentoParcela.formaPagamento = null;
                dadosPagamentoParcela.condicaoPagamento = null;
            });
        }
    };

    $scope.calcularDescontoPadraoPagamento = function () {
        if ($scope.dadosVenda.descontoEmValorOuPercentual == '$') {
            $scope.dadosPagamento.descontoPadrao.valorDesconto = parseFloat(($scope.dadosPagamento.descontoPadrao.baseCalculo * $scope.dadosPagamento.descontoPadrao.percentualDesconto).toFixed(2));
            $scope.dadosVenda.descontoTotal = parseFloat(($scope.dadosVenda.descontoTotal + $scope.dadosPagamento.descontoPadrao.valorDesconto).toFixed(2));
        } else {
            $scope.dadosPagamento.descontoPadrao.valorDesconto = parseFloat(($scope.dadosPagamento.descontoPadrao.baseCalculo * $scope.dadosPagamento.descontoPadrao.percentualDesconto).toFixed(2));
            $scope.dadosVenda.descontoTotal = parseFloat($scope.dadosVenda.descontoTotal.toFixed(4));
            $scope.dadosVenda.descontoTotal = parseFloat(($scope.dadosVenda.descontoTotal + $scope.dadosPagamento.descontoPadrao.percentualDesconto).toFixed(4));
        }

        $scope.rateioValorDescontoFormaPagamento($scope.dadosPagamento.descontoPadrao);

        $scope.aplicarDesconto();
    };

    $scope.calcularAcrescimoPadraoPagamento = function () {
        if ($scope.dadosVenda.acrescimoEmValorOuPercentual == '$') {
            $scope.dadosPagamento.percentualJuros.valorJuros = parseFloat(($scope.dadosPagamento.percentualJuros.baseCalculo * $scope.dadosPagamento.percentualJuros.percentualJuros).toFixed(2));
            $scope.dadosVenda.acrescimoTotal = parseFloat(($scope.dadosVenda.acrescimoTotal + $scope.dadosPagamento.percentualJuros.valorJuros).toFixed(2));
        } else {
            $scope.dadosPagamento.percentualJuros.valorJuros = parseFloat(($scope.dadosPagamento.percentualJuros.baseCalculo * $scope.dadosPagamento.percentualJuros.percentualJuros).toFixed(2));
            $scope.dadosVenda.acrescimoTotal = parseFloat($scope.dadosVenda.acrescimoTotal.toFixed(4));
            $scope.dadosVenda.acrescimoTotal = parseFloat(($scope.dadosVenda.acrescimoTotal + $scope.dadosPagamento.percentualJuros.percentualJuros).toFixed(4));
        }
        $scope.rateioValorAcrescimoCondicaoPagamento($scope.dadosPagamento.percentualJuros);
    };

    $scope.rateioValorDescontoFormaPagamento = function (dadosPagamento) {
        var numeroUltimoItem = $scope.dadosVenda.listaItens.length - 1;
        var controleValorDesconto = $scope.dadosVenda.descontoTotal;
        var valorTotalDescontoItem = 0;
        for (var i = 0; i < $scope.dadosVenda.listaItens.length; i++) {
            valorTotalDescontoItem += $scope.dadosVenda.listaItens[i].vlrDescontoItem;
        }
        for (var i = 0; i < $scope.dadosVenda.listaItens.length; i++) {
            var percentagemItemVenda = (($scope.dadosVenda.listaItens[i].totalItem - $scope.dadosVenda.listaItens[i].vlrDescontoItem) * 100) / ($scope.dadosVenda.subTotalBruto - valorTotalDescontoItem);
            var valorDescontoItem = (dadosPagamento.valorDesconto * percentagemItemVenda) / 100;
            if (i == numeroUltimoItem) {
                $scope.dadosVenda.listaItens[i].vlrDesconto = controleValorDesconto;
                $scope.dadosVenda.listaItens[i].desconto = FuncaoService.arredondar($scope.dadosVenda.listaItens[i].vlrDesconto / $scope.dadosVenda.listaItens[i].totalItem, 4);
                $scope.dadosVenda.listaItens[i].totalItemDesconto = FuncaoService.arredondar($scope.dadosVenda.listaItens[i].totalItem - $scope.dadosVenda.listaItens[i].vlrDesconto);
            } else {
                $scope.dadosVenda.listaItens[i].vlrDesconto = FuncaoService.arredondar(valorDescontoItem + $scope.dadosVenda.listaItens[i].vlrDescontoItem + ($scope.dadosVenda.listaItens[i].vlrDesconto - $scope.dadosVenda.listaItens[i].vlrDescontoItem));
                $scope.dadosVenda.listaItens[i].desconto = FuncaoService.arredondar($scope.dadosVenda.listaItens[i].vlrDesconto / $scope.dadosVenda.listaItens[i].totalItem, 4);
                $scope.dadosVenda.listaItens[i].totalItemDesconto = FuncaoService.arredondar($scope.dadosVenda.listaItens[i].totalItem - $scope.dadosVenda.listaItens[i].vlrDesconto);
            }
            controleValorDesconto = FuncaoService.arredondar(controleValorDesconto - $scope.dadosVenda.listaItens[i].vlrDesconto);
            VendaService.editarItem($scope.dadosVenda.listaItens[i].nItem, $scope.dadosVenda.listaItens[i]);
        }
    };

    $scope.rateioValorAcrescimoCondicaoPagamento = function (dadosPagamento) {
        var numeroUltimoItem = $scope.dadosVenda.listaItens.length - 1;
        var controleValorAcrescimo = $scope.dadosVenda.acrescimoTotal;
        var valorTotalAcrescimoItem = 0;
        for (var i = 0; i < $scope.dadosVenda.listaItens.length; i++) {
            valorTotalAcrescimoItem += $scope.dadosVenda.listaItens[i].vlrAcrescimo;
        }
        for (var i = 0; i < $scope.dadosVenda.listaItens.length; i++) {
            var percentagemItemVenda = (($scope.dadosVenda.listaItens[i].totalItem - $scope.dadosVenda.listaItens[i].vlrAcrescimo) * 100) / ($scope.dadosVenda.subTotalBruto - valorTotalAcrescimoItem);
            var valorAcrescimoItem = (dadosPagamento.valorJuros * percentagemItemVenda) / 100;
            if (i == numeroUltimoItem) {
                $scope.dadosVenda.listaItens[i].vlrAcrescimo = controleValorAcrescimo;
                $scope.dadosVenda.listaItens[i].acrescimo = parseFloat(($scope.dadosVenda.listaItens[i].vlrAcrescimo / $scope.dadosVenda.listaItens[i].totalItem).toFixed(4));
                $scope.dadosVenda.listaItens[i].totalItemDesconto = parseFloat(($scope.dadosVenda.listaItens[i].totalItem + $scope.dadosVenda.listaItens[i].vlrAcrescimo - $scope.dadosVenda.listaItens[i].vlrDesconto).toFixed(2));
            } else {
                $scope.dadosVenda.listaItens[i].vlrAcrescimo = parseFloat((valorAcrescimoItem + $scope.dadosVenda.listaItens[i].vlrDescontoItem + ($scope.dadosVenda.listaItens[i].vlrAcrescimo - $scope.dadosVenda.listaItens[i].vlrDescontoItem)).toFixed(2));
                $scope.dadosVenda.listaItens[i].acrescimo = parseFloat(($scope.dadosVenda.listaItens[i].vlrAcrescimo / $scope.dadosVenda.listaItens[i].totalItem).toFixed(4));
                $scope.dadosVenda.listaItens[i].totalItemDesconto = parseFloat(($scope.dadosVenda.listaItens[i].totalItem + $scope.dadosVenda.listaItens[i].vlrAcrescimo - $scope.dadosVenda.listaItens[i].vlrDesconto).toFixed(2));
            }
            controleValorAcrescimo = parseFloat((controleValorAcrescimo - $scope.dadosVenda.listaItens[i].vlrAcrescimo).toFixed(2));
            VendaService.editarItem($scope.dadosVenda.listaItens[i].nItem, $scope.dadosVenda.listaItens[i]);
        }
    };

    $scope.removerFormaPagamentoRateioItens = function (valorDesconto) {
        var numeroUltimoItem = $scope.dadosVenda.listaItens.length - 1;
        var controleValorDesconto = valorDesconto;
        for (var i = 0; i < $scope.dadosVenda.listaItens.length; i++) {
            var percentagemItemVenda = ($scope.dadosVenda.listaItens[i].totalItemDesconto * 100) / $scope.dadosVenda.totalNota;
            var valorDescontoItem = parseFloat(((valorDesconto * percentagemItemVenda) / 100).toFixed(2));
            if (i == numeroUltimoItem) {
                $scope.dadosVenda.listaItens[i].vlrDesconto -= controleValorDesconto;
                $scope.dadosVenda.listaItens[i].desconto = parseFloat(($scope.dadosVenda.listaItens[i].vlrDesconto / $scope.dadosVenda.listaItens[i].totalItem).toFixed(4));
                $scope.dadosVenda.listaItens[i].totalItemDesconto = parseFloat(($scope.dadosVenda.listaItens[i].totalItem - $scope.dadosVenda.listaItens[i].vlrDesconto).toFixed(2));
            } else {
                $scope.dadosVenda.listaItens[i].vlrDesconto -= valorDescontoItem;
                $scope.dadosVenda.listaItens[i].desconto = parseFloat(($scope.dadosVenda.listaItens[i].vlrDesconto / $scope.dadosVenda.listaItens[i].totalItem).toFixed(4));
                $scope.dadosVenda.listaItens[i].totalItemDesconto = parseFloat(($scope.dadosVenda.listaItens[i].totalItem - $scope.dadosVenda.listaItens[i].vlrDesconto).toFixed(2));
            }
            controleValorDesconto = parseFloat((controleValorDesconto - valorDescontoItem).toFixed(2));
            VendaService.editarItem($scope.dadosVenda.listaItens[i].nItem, $scope.dadosVenda.listaItens[i]);
        }
    };

    $scope.confirmaAlteracaoValorPagamento = function (forma, indicePagamento) {
        if ($scope.dadosVenda.descontoEmValorOuPercentual == '%') {
            $scope.alteraPadraoDesconto("$");
        }
        if ($scope.dadosVenda.acrescimoEmValorOuPercentual == '%') {
            $scope.alteraPadraoAcrescimo("$");
        }
        if (forma.formaPagamento.fpg_tipopagamento == 12) {
            if (forma.valorPago > $scope.valorValePresente) {
                swal("Valor não pode ser superior ao do Vale!", "", "warning");
                forma.valorPago = $scope.valorValePresente;
            }

            if (forma.valorPago > $scope.valorAnterior && $scope.dadosVenda.totalNota > forma.valorPago) {
                swal("Valor não pode ser superior ao restante a pagar!", "", "warning");
                forma.valorPago = $scope.valorAnterior;
            }
        }

        $timeout(function () {
            $scope.dadosVenda.descontoTotal = parseFloat(($scope.dadosVenda.descontoTotal - $scope.valorFormaModificada + forma.descontoPadrao.valorDesconto).toFixed(2));
            $scope.removerFormaPagamentoRateioItens($scope.valorFormaModificada);
            $scope.rateioValorDescontoFormaPagamento(forma.descontoPadrao);
            $scope.calcularTotaisNota();
            $scope.ajustaValoresCartao();
            VendaService.alteraValorPagamento(forma.valorPago, indicePagamento);
        }, 100);
    };

    $scope.armazenaValorPago = function (dados) {
        $scope.valorAnterior = dados.valorPago;
        $scope.valorFormaModificada = dados.descontoPadrao.valorDesconto;
    };

    $scope.alteraValorPagamento = function (indicePagamento) {
        if ($scope.dadosVenda.descontoEmValorOuPercentual == '%') {
            $scope.alteraPadraoDesconto("$");
        }
        if ($scope.dadosVenda.acrescimoEmValorOuPercentual == '%') {
            $scope.alteraPadraoAcrescimo("$");
        }
        $timeout(function () {
            var dadosPagamento = $scope.dadosVenda.pagamento[indicePagamento];
            if ((!!dadosPagamento.formaPagamento == true && dadosPagamento.formaPagamento.fpg_descontopadrao > 0) || (!!dadosPagamento.condicaoPagamento == true && dadosPagamento.condicaoPagamento.cpg_descontopadrao > 0)) {
                dadosPagamento.descontoPadrao.baseCalculo = (dadosPagamento.valorPago <= ($scope.dadosVenda.totalNota - $scope.totalPago) ? dadosPagamento.valorPago : (dadosPagamento.valorPago > ($scope.dadosVenda.totalNota - $scope.totalPago) ? ($scope.dadosVenda.totalNota - $scope.totalPago) : ($scope.dadosVenda.totalNota - $scope.totalPago) - dadosPagamento.valorPago));
                var valorPago = 0;
                var valorMaxBaseCalculo = 0;
                valorMaxBaseCalculo = $scope.dadosVenda.subTotalBruto;
                if ($scope.dadosVenda.pagamento.length == 1) {
                    dadosPagamento.descontoPadrao.baseCalculo = parseFloat(($scope.dadosVenda.subTotal - ($scope.dadosVenda.descontoTotal - $scope.valorFormaModificada) + $scope.dadosVenda.acrescimoTotal).toFixed(2));
                    var valorDescontoForma = parseFloat((dadosPagamento.descontoPadrao.baseCalculo * dadosPagamento.descontoPadrao.percentualDesconto).toFixed(2));
                    if (dadosPagamento.valorPago < dadosPagamento.descontoPadrao.baseCalculo - valorDescontoForma) {
                        dadosPagamento.descontoPadrao.baseCalculo = dadosPagamento.valorPago;
                    }
                    dadosPagamento.descontoPadrao.percentualDesconto = ((!!dadosPagamento.condicaoPagamento == true && dadosPagamento.condicaoPagamento.cpg_descontopadrao > 0) ? dadosPagamento.condicaoPagamento.cpg_descontopadrao : dadosPagamento.formaPagamento.fpg_descontopadrao);
                    dadosPagamento.descontoPadrao.valorDesconto = dadosPagamento.descontoPadrao.baseCalculo * dadosPagamento.descontoPadrao.percentualDesconto;
                } else {
                    for (var i = 0; i < $scope.dadosVenda.pagamento.length; i++) {
                        valorPago += ($scope.dadosVenda.pagamento[i].valorPago + ($scope.dadosVenda.pagamento[i].valorPago * $scope.dadosVenda.pagamento[i].descontoPadrao.percentualDesconto));
                        if (i != indicePagamento) {
                            valorMaxBaseCalculo = valorMaxBaseCalculo - ($scope.dadosVenda.pagamento[i].valorPago + ($scope.dadosVenda.pagamento[i].valorPago * $scope.dadosVenda.pagamento[i].descontoPadrao.percentualDesconto));
                        }
                    }
                    valorMaxBaseCalculo -= ($scope.dadosVenda.descontoTotal - $scope.valorFormaModificada + $scope.dadosVenda.acrescimoTotal);
                    var validarValorRestante = parseFloat(($scope.dadosVenda.totalNota - $scope.dadosVenda.descontoTotal - dadosPagamento.descontoPadrao.valorDesconto).toFixed(2));

                    if ($scope.dadosVenda.totalNota < valorPago) {
                        dadosPagamento.descontoPadrao.baseCalculo = parseFloat((valorMaxBaseCalculo).toFixed(2));
                    } else {
                        dadosPagamento.descontoPadrao.baseCalculo = (dadosPagamento.valorPago <= $scope.dadosVenda.totalNota ? dadosPagamento.valorPago : ($scope.dadosVenda.totalNota - dadosPagamento.valorPago));
                    }
                    dadosPagamento.descontoPadrao.percentualDesconto = ((!!dadosPagamento.condicaoPagamento == true && dadosPagamento.condicaoPagamento.cpg_descontopadrao > 0) ? dadosPagamento.condicaoPagamento.cpg_descontopadrao : dadosPagamento.formaPagamento.fpg_descontopadrao);
                    dadosPagamento.descontoPadrao.valorDesconto = dadosPagamento.descontoPadrao.baseCalculo * dadosPagamento.descontoPadrao.percentualDesconto;
                }
            } else {
                if (dadosPagamento.formaPagamento.fpg_tipopagamento == tipoFormaPagamento.fpCreditoLoja || dadosPagamento.formaPagamento.fpg_tipopagamento == tipoFormaPagamento.fpCartaoCredito || dadosPagamento.formaPagamento.fpg_tipopagamento == tipoFormaPagamento.fpCartaoDebito) {
                    var valorPago = 0;
                    var valorRestante = 0;
                    valorRestante = $scope.dadosVenda.subTotalBruto;
                    for (var i = 0; i < $scope.dadosVenda.pagamento.length; i++) {
                        valorPago += $scope.dadosVenda.pagamento[i].valorPago;
                        if ($scope.dadosVenda.pagamento.length == 1 && $scope.dadosVenda.pagamento[i].valorPago < valorRestante) {
                            valorRestante = valorRestante - ($scope.dadosVenda.pagamento[i].valorPago);
                        } else {
                            if (i != indicePagamento) {
                                valorRestante = valorRestante - ($scope.dadosVenda.pagamento[i].valorPago);
                            }
                        }
                    }
                    valorRestante -= $scope.dadosVenda.descontoTotal;
                    valorPago += $scope.dadosVenda.descontoTotal;
                    if (valorPago > $scope.dadosVenda.subTotal) {
                        $scope.dadosVenda.pagamento[indicePagamento].valorPago = parseFloat((valorRestante).toFixed(2));
                    }
                    $scope.recalculaParcelasValorPagamentoAlterado(indicePagamento);
                } else if (dadosPagamento.formaPagamento.fpg_tipopagamento == tipoFormaPagamento.fpCheque) {
                    var valorPago = 0;
                    var valorRestante = 0;
                    valorRestante = $scope.dadosVenda.subTotalBruto;
                    for (var i = 0; i < $scope.dadosVenda.pagamento.length; i++) {
                        valorPago += $scope.dadosVenda.pagamento[i].valorPago;
                        if ($scope.dadosVenda.pagamento.length == 1 && $scope.dadosVenda.pagamento[i].valorPago < valorRestante) {
                            valorRestante = valorRestante - ($scope.dadosVenda.pagamento[i].valorPago);
                        } else {
                            if (i != indicePagamento) {
                                valorRestante = valorRestante - ($scope.dadosVenda.pagamento[i].valorPago);
                            }
                        }
                    }
                    valorRestante -= $scope.dadosVenda.descontoTotal;
                    valorPago += $scope.dadosVenda.descontoTotal;
                    if (valorPago > $scope.dadosVenda.subTotal) {
                        $scope.dadosVenda.pagamento[indicePagamento].valorPago = parseFloat((valorRestante).toFixed(2));
                    }

                    var listaCheques = [];
                    var valorCheque = $scope.dadosVenda.pagamento[indicePagamento].valorPago / $scope.dadosVenda.pagamento[indicePagamento].cheques.length;
                    for (var i = 0; i < $scope.dadosVenda.pagamento[indicePagamento].cheques.length; i++) {
                        var cheque = $scope.dadosVenda.pagamento[indicePagamento].cheques[i];
                        if (valorCheque > 0) cheque.chq_valor = parseFloat(valorCheque.toString());
                        cheque.linha1 = FuncaoService.retornaValorPorExtenso(cheque.chq_valor);
                        listaCheques.push(angular.copy(cheque));
                    }
                    $scope.dadosVenda.pagamento[indicePagamento].cheques = listaCheques;
                }
            }
        }, 100);
    };

    $scope.removerPagamento = function (indicePagamento) {
        if ($scope.dadosVenda.descontoEmValorOuPercentual == '%') {
            $scope.alteraPadraoDesconto("$");
        }
        if ($scope.dadosVenda.acrescimoEmValorOuPercentual == '%') {
            $scope.alteraPadraoAcrescimo("$");
        }
        swal({
            title: "Remover a Forma de Pagamento?",
            text: $scope.dadosVenda.pagamento[indicePagamento].formaPagamento.fpg_descricao + ((!!$scope.dadosVenda.pagamento[indicePagamento].condicaoPagamento == true && !!$scope.dadosVenda.pagamento[indicePagamento].condicaoPagamento.cpg_id == true) ? " / " + $scope.dadosVenda.pagamento[indicePagamento].condicaoPagamento.cpg_descricao : '') + " - Valor do Pagamento: R$ " + parseFloat($scope.dadosVenda.pagamento[indicePagamento].valorPago).toFixed(2),
            type: "warning",
            showCancelButton: true,
            cancelButtonText: "Não",
            confirmButtonClass: "btn-danger",
            confirmButtonText: "Sim, quero remover",
            closeOnConfirm: true
        }, function () {
            $scope.$apply(function () {
                removerFormaPagamento(indicePagamento);
            });
        })
    };

    var removerFormaPagamento = function (indicePagamento) {
        if (VendaService.removerFormaPagamento(indicePagamento)) {
            $timeout(function () {
                var dadosPagamento = $scope.dadosVenda.pagamento[indicePagamento];
                if (!!dadosPagamento.percentualJuros && !!dadosPagamento.percentualJuros.valorJuros) {
                    $scope.dadosPagamento.percentualJuros = {
                    };
                    $scope.aplicarAcrescimo();
                    if ($scope.dadosVenda.acrescimoEmValorOuPercentual === "%") {
                        $scope.dadosVenda.acrescimoTotal = parseFloat($scope.dadosVenda.acrescimoTotal.toFixed(4));
                        $scope.dadosVenda.acrescimoTotal = parseFloat($scope.dadosVenda.acrescimoTotal.toFixed(4));
                        var percentual = dadosPagamento.percentualJuros.percentualJuros;
                        $scope.dadosVenda.acrescimoTotal -= percentual;
                        $scope.dadosVenda.acrescimoTotal = parseFloat($scope.dadosVenda.acrescimoTotal.toFixed(4));
                        $scope.ratearValorAcrescimo("$");
                    } else {
                        $scope.dadosVenda.acrescimoTotal = parseFloat($scope.dadosVenda.acrescimoTotal.toFixed(2));
                        if ($scope.dadosVenda.acrescimoTotal > 0) {
                            $scope.dadosVenda.acrescimoTotal -= parseFloat(dadosPagamento.percentualJuros.valorJuros.toFixed(2));
                        }
                        $scope.dadosVenda.acrescimoTotal = parseFloat($scope.dadosVenda.acrescimoTotal.toFixed(2));
                        $scope.ratearValorAcrescimo("$");
                    }
                }

                if (!!dadosPagamento.descontoPadrao == true && !!dadosPagamento.descontoPadrao.valorDesconto) {
                    $scope.dadosPagamento.descontoPadrao = {
                    };
                    $scope.aplicarDesconto();
                    if ($scope.dadosVenda.descontoEmValorOuPercentual == "%") {
                        $scope.dadosVenda.descontoTotal = parseFloat($scope.dadosVenda.descontoTotal.toFixed(4));
                        $scope.dadosVenda.descontoTotal = parseFloat($scope.dadosVenda.descontoTotal.toFixed(4));
                        var percentual = dadosPagamento.descontoPadrao.percentualDesconto; //parseFloat((((parseFloat(dadosPagamento.descontoPadrao.valorDesconto.toFixed(4)) * 100) / $scope.dadosVenda.subTotal) / 100).toFixed(4));
                        $scope.dadosVenda.descontoTotal -= percentual;
                        $scope.dadosVenda.descontoTotal = parseFloat($scope.dadosVenda.descontoTotal.toFixed(4));
                        $scope.removerFormaPagamentoRateioItens(dadosPagamento.descontoPadrao.valorDesconto);
                    } else {
                        $scope.dadosVenda.descontoTotal = parseFloat($scope.dadosVenda.descontoTotal.toFixed(2));
                        if ($scope.dadosVenda.descontoTotal > 0) {
                            $scope.dadosVenda.descontoTotal -= parseFloat(dadosPagamento.descontoPadrao.valorDesconto.toFixed(2));
                        }
                        $scope.dadosVenda.descontoTotal = parseFloat($scope.dadosVenda.descontoTotal.toFixed(2));
                        $scope.removerFormaPagamentoRateioItens(dadosPagamento.descontoPadrao.valorDesconto);
                    }
                }
                $scope.dadosVenda.pagamento.splice(indicePagamento, 1);
                $scope.calcularTotaisNota();
                $scope.calculaValorPagamentoRestante();
            }, 100)
        }
    };

    $scope.voltarItens = function (dadosVenda) {
        if ($scope.dadosVenda.descontoEmValorOuPercentual == '%') {
            $scope.alteraPadraoDesconto("$");
        }
        if ($scope.dadosVenda.acrescimoEmValorOuPercentual == '%') {
            $scope.alteraPadraoAcrescimo("$");
        }
        if (dadosVenda.pagamento) {
            if (dadosVenda.pagamento.length > 0) {
                for (var i = $scope.dadosVenda.pagamento.length; i > 0; i--) {
                    removerFormaPagamento(i - 1);
                    $scope.dadosVenda.pagamento.splice(i - 1, 1);
                    $scope.calcularTotaisNota();
                    $scope.dadosPagamento.valorPago = ($scope.dadosVenda.totalNota - $scope.totalPago);
                }
                if ($scope.dadosVenda.pagamento.length == 0) {
                    $scope.listarFormaPagamento();
                }
            }
        }
        $state.go('newpdv.venda-varejo');
    };

    $scope.aplicarDescontoItens = function (desconto) {
        VendaService.aplicaDescontoVenda(parseFloat(desconto).toFixed(2));
    };

    var modeloRelatorioCarne = {
        NaoFiscal: 0,
        Normal: 1
    };


    $scope.verificaIntegracaoPagamentos = function (dadosPagamento, index) {
        if (dadosPagamento.formaPagamento.fpg_tipointegracao == 2) {//payer
            var _paymentType = "";
            var _paymentMethodSubType = "";
            var _installments = "";
            var _paymentMethod = "";
            if (dadosPagamento.formaPagamento.fpg_tipopagamento == tipoFormaPagamento.fpCartaoCredito) {
                _paymentMethod = "Card";
                _paymentType = "Credit";
                _paymentMethodSubType = "Financed_no_Fees";

                if (dadosPagamento.parcelas.length == 1) {
                    _paymentMethodSubType = "Full_Payment";
                } else {
                    _installments = (dadosPagamento.parcelas.length).toString();
                }
            }
            if (dadosPagamento.formaPagamento.fpg_tipopagamento == tipoFormaPagamento.fpCartaoDebito) {
                if (dadosPagamento.parcelas.length >= 1) {
                    if (dadosPagamento.parcelas.length == 1) {
                        _paymentMethodSubType = "Predated_Debit";
                    } else {
                        _paymentMethodSubType = "Financed_Debit";
                    }
                    _installments = (dadosPagamento.parcelas.length).toString();
                } else {
                    _paymentMethodSubType = "Full_Payment";
                }
                _paymentMethod = "Card";
                _paymentType = "Debit"
            }
            if (dadosPagamento.formaPagamento.fpg_tipopagamento == tipoFormaPagamento.fpPixDinamico) {
                _paymentType = "Cash";
                _paymentMethod = "Pix";
            }
            var dados = {
                value: dadosPagamento.valorPago,
                paymentMethod: _paymentMethod,
                paymentType: _paymentType,
                paymentMethodSubType: _paymentMethodSubType,
                installments: _installments
            };
            try {
                var retornoPayer = payerPagamentoAppService.efetuarPagamento(JSON.stringify(dados));
                console.log("Chama Pagamento Payer :", index, retornoPayer)
                openModalPagamento(dadosPagamento, index);
            } catch (e) {
                console.log(e);
                swal("Verifique se o checkout Payer esteja iniciado, caso contrário inicie o mesmo para continuar!", "", "warning");
            }
        } else if (dadosPagamento.formaPagamento.fpg_tipointegracao == 1) {//vero
            var tipopgto = 0;
            var metodopgto = 0;
            var submetodopgto = 0;

            if (dadosPagamento.formaPagamento.fpg_tipopagamento === tipoFormaPagamento.fpCartaoCredito) {
                tipopgto = 2;
                metodopgto = 1;
                submetodopgto = 4;
                if (dadosPagamento.parcelas.length == 1) {
                    submetodopgto = 1
                }
            }
            if (dadosPagamento.formaPagamento.fpg_tipopagamento === tipoFormaPagamento.fpCartaoDebito) {
                tipopgto = 3;
                metodopgto = 1;
                submetodopgto = 1;
                if (dadosPagamento.parcelas.length >= 1) {
                    submetodopgto = 3
                }
            }
            if (dadosPagamento.formaPagamento.fpg_tipopagamento === tipoFormaPagamento.fpPixDinamico) {
                tipopgto = 1;
                metodopgto = 3;
                submetodopgto = 1
            }
            dadosIntegracaoPos = {
                imp_valor: dadosPagamento.valorPago,
                imp_tipopgto: tipopgto,
                imp_metodopgto: metodopgto,
                imp_submetodopgto: submetodopgto,
                imp_qtdeparcelas: dadosPagamento.parcelas.length,
            }
            if (dadosPagamento.hasOwnProperty("integrapgto") == false) {
                dadosPagamento.integrapgtook = false;
                dadosPagamento.integrapgto = integraPagtoAppService.incluir(JSON.stringify(dadosIntegracaoPos));
            }
            else if (dadosPagamento.integrapgto == null) {
                dadosPagamento.integrapgtook = false;
                dadosPagamento.integrapgto = integraPagtoAppService.incluir(JSON.stringify(dadosIntegracaoPos));
            }
            dadosPagamento.id = dadosPagamento.integrapgto.id;
            openModalPagamento(dadosPagamento, index);
        }
        else if (dadosPagamento.formaPagamento.fpg_tipointegracao == 3) {//TEF
            var tipopgto = 0;
            var metodopgto = 0;
            var submetodopgto = 0;

            if (dadosPagamento.formaPagamento.fpg_tipopagamento === tipoFormaPagamento.fpCartaoCredito) {
                tipopgto = 2;
                metodopgto = 1;
                submetodopgto = 4;
                if (dadosPagamento.parcelas.length == 1) {
                    submetodopgto = 1
                }
            }
            if (dadosPagamento.formaPagamento.fpg_tipopagamento === tipoFormaPagamento.fpCartaoDebito) {
                tipopgto = 3;
                metodopgto = 1;
                submetodopgto = 1;
                if (dadosPagamento.parcelas.length >= 1) {
                    submetodopgto = 3
                }
            }
            if (dadosPagamento.formaPagamento.fpg_tipopagamento === tipoFormaPagamento.fpPixDinamico) {
                tipopgto = 1;
                metodopgto = 3;
                submetodopgto = 1
            }
            dadosTef = {
                imp_valor: dadosPagamento.valorPago,
                imp_tipopgto: tipopgto,
                imp_metodopgto: metodopgto,
                imp_submetodopgto: submetodopgto,
                imp_qtdeparcelas: dadosPagamento.parcelas.length,
            }
            try {
                var retornoTef = tefAppService.realizarTransacaoTef(dadosPagamento.formaPagamento.fpg_codigofuncaotef, dadosPagamento.valorPago.toFixed(2));
                //console.log("Retorno TEF", retornoTef);
                if (retornoTef) {
                    if (retornoTef.statusTransacao == 1)// se status pendente de confirmação
                    {
                        dadosPagamento.integrapgto = integraPagtoAppService.incluirDadosTef(JSON.stringify(retornoTef), JSON.stringify(dadosTef));
                        dadosPagamento.integrapgtook = true;
                        $scope.concluirVenda();
                    } else {
                        if (retornoTef.retInt < 0) {
                            if (retornoTef.retInt == -1) {
                                swal("Módulo não inicializado!", "Cód. Retorno -1", "warning");
                            }
                            else if (retornoTef.retInt == -2) {
                                swal("Operação cancelada pelo Operador!", "Cód. Retorno -2", "warning");
                            }
                            else if (retornoTef.retInt == -5) {
                                swal("Sem comunicação com o SiTef!", "Cód. Retorno -5", "warning");
                            }
                            else if (retornoTef.retInt == -6) {
                                swal("Operação cancelada pelo usuário (no pinpad)!", "Cód. Retorno -6", "warning");
                            }
                            else if (retornoTef.retInt == -22) {
                                swal("Carteira Digital não habilitada!", "Cód. Retorno -22", "warning");
                            }
                            else if (retornoTef.retInt == -24) {
                                swal("Carteira Digital - Trn. nao habilitada!", "Cód. Retorno -24", "warning");
                            }
                            else if (retornoTef.retInt == -43) {
                                swal("Problema na execução de alguma das rotinas no pinpad!", "Cód. Retorno -43", "warning");
                            }
                            else if (retornoTef.retInt == -100) {
                                swal("Erro interno do módulo!", "Cód. Retorno -100", "warning");
                            }
                            else {
                                swal("Não Foi possível  concluir transação TEF!", "Cód.Retorno" + retornoTef.retInt, "warning");
                            }
                        } else {
                            swal("Não Foi possível  concluir transação TEF!", "Cód.Retorno" + retornoTef.retInt, "warning");
                        }
                    }
                } else {
                    swal("Não Foi possível  concluir transação TEF!", "Cód. Retorno " + retornoTef.retInt, "warning");
                }
            } catch (e) {
                console.log(e);
                swal("Não Foi possível chamar as funções TEF!", "Sem Retorno", "warning");
            }
        }

    };

    function openModalPagamento(dadosPagamento, index) {
        swal({
            title: "Aguardando Pagamento Via Integração!",
            text: "Verifique no Checkout/PinPad de pagamento",
            type: "warning",
            showCancelButton: true,
            cancelButtonText: "Cancelar",
            confirmButtonClass: "btn-info",
            confirmButtonText: "Verificar Novamente",
            closeOnConfirm: true
        }, function (isConfirm) {
            if (isConfirm) {
                $timeout(function () {
                    $scope.verificaPagamento(dadosPagamento, index);
                }, 500);
            }
            else {
                $scope.verificaCancelamentoPagamento(dadosPagamento, index);
            }
        });
    }
    $scope.verificaCancelamentoPagamento = function (dadosPagamento, index) {
        if (dadosPagamento.formaPagamento.fpg_tipointegracao == 2) {//payer
            try {
                var ret = payerPagamentoAppService.consultarPagamento();
                dadosPagamento.integrapgto = ret;
                console.log("Consulta Payer(verificaCancelamentoPagamento)", ret);
                if (ret.statusTransaction == "PENDING") {
                    openModalPagamento(dadosPagamento, index);
                    swal("Transação pendente no checkout Payer!", "", "warning");
                } else if (ret.operationType == "PAYMENT" && ret.statusTransaction == "APPROVED") {
                    $scope.cancelamentoPagamento(dadosPagamento, index);
                } else if (ret.statusTransaction == "UNAUTHORIZED") {
                    swal("Efetue o login no checkout Payer!", "", "warning");
                }
                else if (ret.statusTransaction == "ABORTED") {
                    openModalPagamento(dadosPagamento, index);
                    swal("Transação cancelada no checkout Payer!", "", "warning");
                }
            } catch (e) {
                console.log(e);
                swal("Atenção", "Certifique-se que o checkout Payer esteja iniciado, caso contrário inicie o mesmo para continuar!", "warning");
            }
        }
        else if (dadosPagamento.formaPagamento.fpg_tipointegracao == 1) { // Vero

        }
    }
    $scope.cancelamentoPagamento = function (dadosPagamento, index) {
        try {
            var efetuarCancelamento = payerPagamentoAppService.efetuarCancelamento(dadosPagamento.integrapgto.idPayer);

            // Definir uma função interna para consulta recursiva
            var consultarStatus = function () {
                var retornoCancelamento = payerPagamentoAppService.consultarPagamento();

                // Verificar o status do pagamento
                if (retornoCancelamento.statusTransaction === "PENDING") {
                    console.log("Status ainda é pendente...");

                    // Se ainda estiver pendente, agendar outra consulta após 1 segundo
                    $timeout(function () {
                        consultarStatus(); // Chamada recursiva para continuar verificando
                    }, 1000);
                } else if (retornoCancelamento.statusTransaction === "APPROVED") {
                    // Se o pagamento for aprovado, atualizar os dados e exibir uma mensagem de sucesso
                    $scope.dadosVenda.pagamento[index].integrapgtook = false;
                    $scope.dadosVenda.pagamento[index].integrapgto = null;
                    swal("Pagamento Cancelado!", "", "success");
                }
                else if (retornoCancelamento.statusTransaction == "ABORTED") {
                    swal("Transação cancelada no checkout Payer!", "", "warning");
                    openModalPagamento(dadosPagamento, index);
                } else if (retornoCancelamento.statusTransaction == "UNAUTHORIZED") {
                    swal("Efetue o login no checkout Payer!", "", "warning");
                }
            };

            // Iniciar a consulta inicialmente
            consultarStatus();

        } catch (e) {
            console.log(e);
            swal("Certifique-se o checkout Payer esteja iniciado, caso contrário inicie o mesmo para continuar!", "", "warning");
        }
    }

    $scope.verificaPagamento = function (dadosPagamento, index) {
        if (dadosPagamento.formaPagamento.fpg_tipointegracao == 2) {//payer
            try {
                var ret = payerPagamentoAppService.consultarPagamento();
                console.log("Consulta Payer(Modal)", ret);
                if (ret.statusTransaction == "PENDING") {
                    openModalPagamento(dadosPagamento, index);
                } else if (ret.operationType == "PAYMENT" && ret.statusTransaction == "APPROVED") {
                    $scope.dadosVenda.pagamento[index].integrapgtook = true;
                    $scope.dadosVenda.pagamento[index].integrapgto = ret;
                    $scope.concluirVenda();
                } else if (ret.statusTransaction == "UNAUTHORIZED") {
                    $scope.concluirVenda();
                    swal("Efetue o login no checkout Payer!", "", "warning");
                }
                else if (ret.statusTransaction == "ABORTED") {
                    $scope.concluirVenda();
                }
            } catch (e) {
                console.log(e);
                swal("Atenção", "Certifique-se que o checkout Payer esteja iniciado, caso contrário inicie o mesmo para continuar!", "warning");
            }
        } else if (dadosPagamento.formaPagamento.fpg_tipointegracao == 1) { // Vero
            var ret = integraPagtoAppService.consultaPagamento(dadosPagamento.integrapgto.id);
            $timeout(function () {
                if (ret == null) {
                    swal("Atenção", "Não foi possível consultar dados do pagamento, API encontra-se instável  no momento . Tente Novamente dentro de alguns instantes!!", "warning");
                }
                if (ret.imp_statuspgto == 3) {
                    openModalPagamento(dadosPagamento, index);
                } else if (ret.imp_statuspgto == 1) {
                    $scope.dadosVenda.pagamento[index].integrapgtook = true;
                    $scope.dadosVenda.pagamento[index].integrapgto = ret;
                    $scope.concluirVenda();
                } else if (ret.statusTransaction == 7) {
                    $scope.concluirVenda();
                    swal("Pagamento não autorizado!", "", "warning");
                }
                else if (ret.statusTransaction == 5) {
                    $scope.concluirVenda();
                    swal("Pagamento não abortado!", "", "warning");
                }
            }, 1000)
        }
    };

    $scope.alterarIndicadorPresenca = function () {

        if ($scope.dadosVenda.entregaDomicilio == true) {
            swal({
                title: "Atenção!",
                text: "Para entrega a domicílio é necessario informar o Endereço de Entrega e o Transportador, deseja continuar ?",
                type: "warning",
                showCancelButton: true,
                cancelButtonText: "Não",
                confirmButtonClass: "btn-success",
                confirmButtonText: "Informar Transportador",
                allowOutsideClick: false
            }, function (acao) {
                if (acao) {
                    $timeout(function () {
                        $scope.ListaFrete();
                    }, 100);
                } else {
                    $scope.dadosVenda.entregaDomicilio = false;
                }
            });
        }

        var retornoVenda = JSON.parse(VendaService.alterarIndicadorPresenca($scope.dadosVenda.entregaDomicilio));
    }

    $scope.concluirVenda = function () {
        var finalizarVenda = true;
        var pagamentoChequeNaoLancado = [];
        if ($scope.dadosVenda.totalNota - $scope.totalPago > 0) {
            var restanteAPagar = $scope.dadosVenda.totalNota - $scope.totalPago
            restanteAPagar = parseFloat(restanteAPagar).toFixed(2);
            if (restanteAPagar > 0) {
                finalizarVenda = false;
                swal("Você deve informar uma forma de pagamento para o restante do valor da venda!", "R$" + restanteAPagar, "warning");
                return;
            }
        }
        var estado = JSON.parse(estadoAppService.listarEstadoDoEmitente());
        if ($scope.dadosVenda.clienteIdentificado == false && estado.est_valornfcesemconsumidor != null) {
            if ($scope.dadosVenda.totalNota >= estado.est_valornfcesemconsumidor) {
                finalizarVenda = false;
                swal("Você deve identificar um Cliente!", "NFC-e - Valor Limite Total R$( " + parseFloat(estado.est_valornfcesemconsumidor).toFixed(2) + " ) e Valor Com e Sem Identificação do Destinatário para o estado do " + estado.est_sigla, "warning");
            }
        }

        for (var i = 0; i < $scope.dadosVenda.pagamento.length; i++) {
            if (!(!!!$scope.dadosVenda.pessoaAutorizada)) {
                $scope.dadosVenda.pagamento[i].pessoaAutorizada = { pessoaAutorizadaId: $scope.dadosVenda.pessoaAutorizada.Id, pef_cpf: $scope.dadosVenda.pessoaAutorizada.pef_cpf }
            } else {
                $scope.dadosVenda.pagamento[i].pessoaAutorizada = {};
            }
            if ($scope.dadosVenda.pagamento[i].$edit == true) {
                finalizarVenda = false;
                break;
                swal("Você deve confirmar a forma de pagamento " + $scope.dadosVenda.pagamento[i].formaPagamento.fpg_descricao + " para continuar!", "", "warning");
            }
            if ($scope.dadosVenda.pagamento[i].formaPagamento.fpg_tipopagamento == tipoFormaPagamento.fpCreditoLoja) {
                if ($scope.dadosVenda.pagamento[i].parcelas[0].prc_entrada == true && (!!$scope.dadosVenda.pagamento[i].parcelas[0].formaPagamento) == false) {
                    finalizarVenda = false;
                    swal("Você deve informar a forma de pagamento da ENTRADA!", "Forma de Pagamento: " + $scope.dadosVenda.pagamento[i].formaPagamento.fpg_descricao + " - " + $scope.dadosVenda.pagamento[i].condicaoPagamento.cpg_descricao, "warning");
                    break;
                }
                else if ($scope.dadosVenda.pagamento[i].parcelas[0].prc_entrada == true && (!!$scope.dadosVenda.pagamento[i].parcelas[0].formaPagamento) == true && ($scope.dadosVenda.pagamento[i].parcelas[0].formaPagamento.fpg_tipopagamento != tipoFormaPagamento.fpDinheiro && !!$scope.dadosVenda.pagamento[i].parcelas[0].condicaoPagamento == false)) {
                    finalizarVenda = false;
                    swal("Você deve especificar a condicao de pagamento da ENTRADA!", "", "warning");
                    break;
                }
            }
            else if ($scope.dadosVenda.pagamento[i].formaPagamento.fpg_tipopagamento == tipoFormaPagamento.fpCheque) {
                if ($scope.dadosVenda.pagamento[i].cheques.length == 0) {
                    pagamentoChequeNaoLancado.push(i);
                }
            }
            else if ($scope.dadosVenda.pagamento[i].formaPagamento.fpg_tipopagamento == tipoFormaPagamento.fpCartaoCredito
                || $scope.dadosVenda.pagamento[i].formaPagamento.fpg_tipopagamento == tipoFormaPagamento.fpCartaoDebito
                || $scope.dadosVenda.pagamento[i].formaPagamento.fpg_tipopagamento == tipoFormaPagamento.fpPixDinamico) {
                if ($scope.dadosVenda.pagamento[i].formaPagamento.fpg_tipointegracao != null && $scope.dadosVenda.pagamento[i].integrapgtook == false) {
                    console.log("Concluir Venda", $scope.dadosVenda.pagamento[i]);
                    finalizarVenda = false;
                    $scope.verificaIntegracaoPagamentos($scope.dadosVenda.pagamento[i], i);
                    break;
                }
            }
        }

        if (finalizarVenda == true && pagamentoChequeNaoLancado.length == 0) EmitirNFCeOuDav();

        if (finalizarVenda == true && pagamentoChequeNaoLancado.length > 0) {
            swal({
                title: "Você adicionou pagamentos em cheque, porém os cheques não foram lançados. O que deseja fazer?",
                text: "",
                type: "warning",
                showCancelButton: true,
                cancelButtonText: "Lançar os Cheques",
                confirmButtonClass: "btn-danger",
                confirmButtonText: "Finalizar a Venda",
            }, function (isConfirm) {
                if (isConfirm) {
                    $timeout(function () {
                        swal.close(); // Fecha o swal manualmente
                        EmitirNFCeOuDav();
                    });
                }
                else {
                    var indicePagamento = pagamentoChequeNaoLancado[0];
                    $scope.lancamentoCheque($scope.dadosVenda.numeroCheques, $scope.dadosVenda.pagamento[indicePagamento].valorPago, indicePagamento, $scope.dadosVenda.pagamento[indicePagamento].formaPagamento.fpg_tipopagamento, $scope.dadosVenda.parcelas);
                }
            });
        }
    };

    function EmitirNFCeOuDav() {
        //Busca Parametro Empresa.
        $scope.parametrosEmpresa = parametrosEmpresaAppService.retornaDadosParametrosEmpresa();

        var temFormaComIntegracao = $scope.dadosVenda.pagamento.some(function (pagamento) {
            return pagamento.formaPagamento && pagamento.formaPagamento.fpg_tipointegracao != null;
        });
        // Se tem forma de pagamento com integração não fazer esta pergunta e emitir o NFCe diretamente.
        if (temFormaComIntegracao) {
            $scope.emitirDocFiscal = true;
            concluirVenda();
        } else {
            if ($scope.parametrosEmpresa != null && $scope.parametrosEmpresa.par_69 == true) {
                swal({
                    title: "Deseja emitir o cupom fiscal agora?",
                    text: "",
                    type: "warning",
                    allowOutsideClick: false,
                    showCancelButton: true,
                    confirmButtonText: "Sim (Enter)",
                    confirmButtonClass: "btn-success",
                    cancelButtonText: "Não (Esc)",
                    cancelButtonClass: "btn-default",
                }, function (isConfirm) {
                    if (isConfirm) {
                        $scope.emitirDocFiscal = true;
                        $timeout(function () {
                            swal.close(); // Fecha o swal manualmente
                            concluirVenda();
                        });
                    }
                    else {
                        $scope.emitirDocFiscal = false;
                        $timeout(function () {
                            swal.close(); // Fecha o swal manualmente
                            concluirVenda();
                        });
                    }
                });
            } else {
                $scope.emitirDocFiscal = true;
                concluirVenda();
            }
        }
    };

    function concluirVenda() {
        $scope.gravandoNota = true;
        $scope.calcularTotaisNota();
        if ($scope.dadosVenda.pagamento.length > 0) {
            $scope.dadosVenda.pagamento[0].cheques = (!!$scope.dadosVenda.pagamento[0].cheques) ? $scope.dadosVenda.pagamento[0].cheques : [];
        }

        angular.forEach($scope.formasPagamentoNaoIncluidas, function (pagamentoNaoIncluido) {
            $scope.dadosVenda.pagamento[pagamentoNaoIncluido.indice]
        });

        $scope.dadosVenda.observacao = (!!$scope.dadosVenda.observacao) ? $scope.dadosVenda.observacao : '';
        $scope.dadosVenda.cli_id = (!!$scope.dadosVenda.cli_id) ? $scope.dadosVenda.cli_id : null;

        //console.log("Grava dados da venda", $scope.dadosVenda);
        var retornoVenda = JSON.parse(VendaService.finalizaVenda($scope.emitirDocFiscal,
            JSON.stringify($scope.dadosVenda.pagamento),
            $scope.dadosVenda.pes_cpfcnpj,
            $scope.dadosVenda.pes_nome,
            $scope.dadosVenda.ven_id,
            $scope.dadosVenda.pes_idestrangeiro,
            $scope.dadosVenda.cli_id,
            $scope.dadosVenda.observacao,
            false,
            $scope.envioNFCeEmail.enderecoDestinatario));
        //console.log("Retorno", retornoVenda);

        $timeout(function () {
            ImprimirNFCeOuDav(retornoVenda);
        }, 500);
    }

    function ImprimirNFCeOuDav(retornoVenda) {
        if (retornoVenda != null && retornoVenda.idNotaFiscal != null) {
            if ($scope.emitirDocFiscal) {
                if ($scope.parametrosEmpresa == null || $scope.parametrosEmpresa.par_impressaonfce == null) {
                    notaFiscalAppService.imprimirNFCe(retornoVenda.idNotaFiscal);
                    ImprimirMeioPagamentoIntegrado(retornoVenda)
                        .then(() => ImprimirDemonstrativoVendaAprazo(retornoVenda))
                        .then(() => ImprimirCarne(retornoVenda))
                        .then(() => FinalizarVenda(retornoVenda))
                        .catch(handleError);
                } else {
                    if ($scope.parametrosEmpresa.par_impressaonfce == impressaoComprovantes.Imprimir) {
                        notaFiscalAppService.imprimirNFCe(retornoVenda.idNotaFiscal);
                        ImprimirMeioPagamentoIntegrado(retornoVenda)
                            .then(() => ImprimirDemonstrativoVendaAprazo(retornoVenda))
                            .then(() => ImprimirCarne(retornoVenda))
                            .then(() => FinalizarVenda(retornoVenda))
                            .catch(handleError);
                    } else if ($scope.parametrosEmpresa.par_impressaonfce == impressaoComprovantes.PerguntarAoUsuario) {
                        swal({
                            title: "Deseja realizar a impressão do comprovante deste Cupom Fiscal?",
                            text: "Imprimir Comprovante?",
                            type: "warning",
                            allowOutsideClick: false,
                            showCancelButton: true,
                            confirmButtonText: "Sim (Enter)",
                            confirmButtonClass: "btn-success",
                            cancelButtonText: "Não (Esc)",
                            cancelButtonClass: "btn-default",
                        }, function (isConfirm) {
                            if (isConfirm) {
                                $timeout(function () {
                                    swal.close();
                                    notaFiscalAppService.imprimirNFCe(retornoVenda.idNotaFiscal);
                                    ImprimirMeioPagamentoIntegrado(retornoVenda)
                                        .then(() => ImprimirDemonstrativoVendaAprazo(retornoVenda))
                                        .then(() => ImprimirCarne(retornoVenda))
                                        .then(() => FinalizarVenda(retornoVenda))
                                        .catch(handleError);
                                });
                            } else {
                                $timeout(function () {
                                    swal.close();
                                    ImprimirMeioPagamentoIntegrado(retornoVenda)
                                        .then(() => ImprimirDemonstrativoVendaAprazo(retornoVenda))
                                        .then(() => ImprimirCarne(retornoVenda))
                                        .then(() => FinalizarVenda(retornoVenda))
                                        .catch(handleError);
                                });
                            }
                        });
                    } else {
                        ImprimirMeioPagamentoIntegrado(retornoVenda)
                            .then(() => ImprimirDemonstrativoVendaAprazo(retornoVenda))
                            .then(() => ImprimirCarne(retornoVenda))
                            .then(() => FinalizarVenda(retornoVenda))
                            .catch(handleError);
                    }
                }
            } else {
                if ($scope.parametrosEmpresa == null || $scope.parametrosEmpresa.par_impressaodavls == null) {
                    notaFiscalAppService.imprimirDav(retornoVenda.idNotaFiscal);
                    ImprimirMeioPagamentoIntegrado(retornoVenda)
                        .then(() => ImprimirDemonstrativoVendaAprazo(retornoVenda))
                        .then(() => ImprimirCarne(retornoVenda))
                        .then(() => FinalizarVenda(retornoVenda))
                        .catch(handleError);
                } else {
                    if ($scope.parametrosEmpresa.par_impressaodavls == impressaoComprovantes.Imprimir) {
                        notaFiscalAppService.imprimirDav(retornoVenda.idNotaFiscal);
                        ImprimirMeioPagamentoIntegrado(retornoVenda)
                            .then(() => ImprimirDemonstrativoVendaAprazo(retornoVenda))
                            .then(() => ImprimirCarne(retornoVenda))
                            .then(() => FinalizarVenda(retornoVenda))
                            .catch(handleError);
                    } else if ($scope.parametrosEmpresa.par_impressaodavls == impressaoComprovantes.PerguntarAoUsuario) {
                        swal({
                            title: "Deseja realizar a impressão do comprovante desta DAV/LS?",
                            text: "Imprimir Comprovante?",
                            type: "warning",
                            allowOutsideClick: false,
                            showCancelButton: true,
                            confirmButtonText: "Sim (Enter)",
                            confirmButtonClass: "btn-success",
                            cancelButtonText: "Não (Esc)",
                            cancelButtonClass: "btn-default",
                        }, function (isConfirm) {
                            if (isConfirm) {
                                $timeout(function () {
                                    notaFiscalAppService.imprimirDav(retornoVenda.idNotaFiscal);
                                    ImprimirMeioPagamentoIntegrado(retornoVenda)
                                        .then(() => ImprimirDemonstrativoVendaAprazo(retornoVenda))
                                        .then(() => ImprimirCarne(retornoVenda))
                                        .then(() => FinalizarVenda(retornoVenda))
                                        .catch(handleError);
                                    swal.close();
                                });
                            } else {
                                $timeout(function () {
                                    swal.close();
                                    ImprimirMeioPagamentoIntegrado(retornoVenda)
                                        .then(() => ImprimirDemonstrativoVendaAprazo(retornoVenda))
                                        .then(() => ImprimirCarne(retornoVenda))
                                        .then(() => FinalizarVenda(retornoVenda))
                                        .catch(handleError);
                                });
                            }
                        });
                    } else {
                        ImprimirMeioPagamentoIntegrado(retornoVenda)
                            .then(() => ImprimirDemonstrativoVendaAprazo(retornoVenda))
                            .then(() => ImprimirCarne(retornoVenda))
                            .then(() => FinalizarVenda(retornoVenda))
                            .catch(handleError);
                    }
                }
            }
        }

        if (retornoVenda.vendaRealizada == false) {
            $scope.gravandoNota = false;
            swal("Erro ao Efetuar Venda!", retornoVenda.detalhes, "warning");
        }
    }

    // Função para lidar com erros
    function handleError(error) {
        swal("Erro!", "Ocorreu um problema durante o processamento.", "warning");
        console.error(error);
    }

    // Imprime demonstrativo de venda a prazo, mesmo que o cupom não seja impresso, usado para o cliente assinar.
    function ImprimirDemonstrativoVendaAprazo(retornoVenda) {
        return new Promise((resolve, reject) => {
            var imprimirDemonstrativoVendaAprazo = false;
            if (!!retornoVenda.idNotaFiscal) {
                angular.forEach($scope.dadosVenda.pagamento, function (pagamento) {
                    if (!!pagamento.formaPagamento) {
                        if (pagamento.formaPagamento.fpg_tipopagamento == parseInt(tipoFormaPagamento.fpBoletoBancario) ||
                            pagamento.formaPagamento.fpg_tipopagamento == parseInt(tipoFormaPagamento.fpCreditoLoja)) {
                            imprimirDemonstrativoVendaAprazo = true;
                        }
                    }
                });

                $timeout(function () {
                    if (imprimirDemonstrativoVendaAprazo) {
                        try {
                            var impressaoDemonstrativo = JSON.parse(carneAppService.imprimirDemonstrativo(retornoVenda.idNotaFiscal));
                            resolve(impressaoDemonstrativo);
                        } catch (error) {
                            reject(error);
                        }
                    } else {
                        resolve(); // Se não for necessário imprimir, continua o fluxo
                    }
                }, 100);
            } else {
                resolve(); // Caso não tenha idNotaFiscal, continua o fluxo
            }
        });
    }

    // Impressão de carnes com codigo de barras
    function ImprimirCarne(retornoVenda) {
        return new Promise((resolve, reject) => {
            var imprimirCarne = false;
            if (!!retornoVenda.idNotaFiscal) {
                angular.forEach($scope.dadosVenda.pagamento, function (pagamento) {
                    if (!!pagamento.formaPagamento) {
                        $scope.emiteBoleto = definicaoBoletoAppService.verificarDefinicaoBoleto(pagamento.formaPagamento.fpg_id);
                        if (pagamento.formaPagamento.fpg_tipopagamento == parseInt(tipoFormaPagamento.fpBoletoBancario) && $scope.emiteBoleto == true) {
                            var formaPgto = [];
                            formaPgto = pagamento.formaPagamento;
                            $timeout(function () {
                                $scope.dadosBoleto = boletoAppService.gerarBoleto($scope.dadosVenda.pes_cpfcnpj, JSON.stringify(formaPgto), JSON.stringify(pagamento.parcelas));
                            }, 100);
                        }
                        if (!!pagamento.formaPagamento.fpg_imprimecarne) {
                            imprimirCarne = true;
                        }
                    }
                });

                $timeout(function () {
                    if (imprimirCarne) {
                        if ($scope.parametrosEmpresa == null || $scope.parametrosEmpresa.par_impressaocarne == null) {
                            var retornoModeloCarne = JSON.parse(carneAppService.imprimir(retornoVenda.idNotaFiscal));
                            resolve(retornoModeloCarne);
                        } else {
                            if ($scope.parametrosEmpresa.par_impressaocarne == impressaoComprovantes.Imprimir) {
                                var retornoModeloCarne = JSON.parse(carneAppService.imprimir(retornoVenda.idNotaFiscal));
                                resolve(retornoModeloCarne);
                            } else if ($scope.parametrosEmpresa.par_impressaocarne == impressaoComprovantes.PerguntarAoUsuario) {
                                swal({
                                    title: "Deseja realizar a impressão do comprovante deste Carnê?",
                                    text: "Imprimir Comprovante?",
                                    type: "warning",
                                    allowOutsideClick: false,
                                    showCancelButton: true,
                                    confirmButtonText: "Sim (Enter)",
                                    confirmButtonClass: "btn-success",
                                    cancelButtonText: "Não (Esc)",
                                    cancelButtonClass: "btn-default",
                                }, function (isConfirm) {
                                    if (isConfirm) {
                                        $timeout(function () {
                                            var retornoModeloCarne = JSON.parse(carneAppService.imprimir(retornoVenda.idNotaFiscal));
                                            swal.close(); // Fecha o swal manualmente
                                            resolve(retornoModeloCarne);
                                        });
                                    } else {
                                        $timeout(function () {
                                            swal.close(); // Fecha o swal manualmente
                                            resolve(); // Continua o fluxo sem imprimir
                                        });
                                    }
                                });
                            }
                        }
                    } else {
                        resolve(); // Não há carne para imprimir, continua o fluxo
                    }
                }, 100);
            } else {
                resolve(); // Caso não tenha idNotaFiscal, continua o fluxo
            }
        });
    }

    // Imprime comprovantes Cartões/pix quando integrados com Sitef ou Payer e outros
    function ImprimirMeioPagamentoIntegrado(retornoVenda) {
        return new Promise((resolve, reject) => {
            var imprimirPagamentoIntegrado = false;
            angular.forEach($scope.dadosVenda.pagamento, function (pagamento) {
                if (pagamento.formaPagamento.fpg_tipointegracao) {
                    imprimirPagamentoIntegrado = true;
                }
            });

            $timeout(function () {
                if (imprimirPagamentoIntegrado) {
                    try {
                        if ($scope.parametrosEmpresa == null || $scope.parametrosEmpresa.par_impressaonfce == null) {
                            var retornoComprovanteCartao = JSON.parse(carneAppService.imprimirComprovanteIntegracaoPagamentos(retornoVenda.idNotaFiscal));
                            resolve(retornoComprovanteCartao);
                        } else {
                            if ($scope.parametrosEmpresa.par_impressaonfce == impressaoComprovantes.Imprimir) {
                                var retornoComprovanteCartao = JSON.parse(carneAppService.imprimirComprovanteIntegracaoPagamentos(retornoVenda.idNotaFiscal));
                                resolve(retornoComprovanteCartao);
                            } else if ($scope.parametrosEmpresa.par_impressaonfce == impressaoComprovantes.PerguntarAoUsuario) {
                                swal({
                                    title: "Deseja realizar a impressão do comprovante de pagamento integrado?",
                                    text: "Imprimir Comprovante?",
                                    type: "warning",
                                    allowOutsideClick: false,
                                    showCancelButton: true,
                                    confirmButtonText: "Sim (Enter)",
                                    confirmButtonClass: "btn-success",
                                    cancelButtonText: "Não (Esc)",
                                    cancelButtonClass: "btn-default",
                                }, function (isConfirm) {
                                    if (isConfirm) {
                                        $timeout(function () {
                                            try {
                                                var retornoModeloCarne = JSON.parse(carneAppService.imprimirComprovanteIntegracaoPagamentos(retornoVenda.idNotaFiscal));
                                                swal.close(); // Fecha o swal manualmente
                                                resolve(retornoModeloCarne);
                                            } catch (error) {
                                                swal.close();
                                                reject(error);
                                            }
                                        });
                                    } else {
                                        $timeout(function () {
                                            swal.close(); // Fecha o swal manualmente
                                            resolve(); // Resolve sem erro se o usuário escolher "Não"
                                        });
                                    }
                                });
                            } else {
                                resolve();
                            }
                        }
                    } catch (error) {
                        reject(error);
                    }
                } else {
                    resolve(); // Se não for necessário imprimir, continua o fluxo
                }
            }, 100);
        });
    }

    function FinalizarVenda(retornoVenda) {
        if (retornoVenda.vendaRealizada === true) {
            if (!!retornoVenda.idNotaFiscal) {
                /* Imprimir o meio de pagamento integrado */
                //ImprimirMeioPagamentoIntegrado(retornoVenda).then(function () {
                var promises = [];

                /* mudar status da pre-venda apos emitir */
                if ($scope.dadosVenda.idPreVenda != null) {
                    promises.push(preVendaAppService.editarStatus($scope.dadosVenda.idPreVenda, retornoVenda.idNotaFiscal));
                }

                /* mudar status da venda condicional apos emitir */
                if ($scope.dadosVenda.idVendaCondicional != null) {
                    promises.push(vendaCondicionalAppService.editarSituacaoCondicional($scope.dadosVenda.idVendaCondicional, null));
                }

                /* mudar status do pedido apos emitir */
                if ($scope.dadosVenda.idPedido != null) {
                    promises.push(pedidoAppService.editarSituacaoPedidoAposEmissaoNfe($scope.dadosVenda.idPedido));
                }

                // Aguarda todas as promessas serem concluídas
                $q.all(promises).then(function () {
                    $scope.gravandoNota = false;
                    DadosFormularioService.limparDados('venda-varejo');
                    $scope.nome = null;
                    $scope.cpfCnpj = null;
                    growlService.growl('Venda Concluída!', 'inverse', null, 2500);
                    $state.go('newpdv.venda-varejo');
                }).catch(function (error) {
                    console.error('Erro ao finalizar a venda:', error);
                    swal({
                        title: "Erro ao finalizar a venda!",
                        text: "Ocorreu um erro inesperado. Por favor, tente novamente.",
                        type: "error",
                        showCancelButton: false,
                        confirmButtonClass: "btn-danger",
                        confirmButtonText: "OK",
                        closeOnConfirm: true
                    }, function (isConfirm) {
                        if (isConfirm) {
                            $timeout(function () {
                                $scope.gravandoNota = false;
                                DadosFormularioService.limparDados('venda-varejo');
                                $scope.dadosVenda = {};
                                $state.go('newpdv.venda-varejo');
                            });
                        }
                    });
                });
                //  });
            }
        } else {
            swal({
                title: "Erro ao efetuar a Venda!",
                text: retornoVenda.detalhes,
                type: "error",
                showCancelButton: false,
                confirmButtonClass: "btn-danger",
                confirmButtonText: "OK",
                closeOnConfirm: true
            }, function (isConfirm) {
                if (isConfirm) {
                    $timeout(function () {
                        $scope.gravandoNota = false;
                        DadosFormularioService.limparDados('venda-varejo');
                        $scope.dadosVenda = {};
                        $state.go('newpdv.venda-varejo');
                    });
                }
            });
        }
    }


    $scope.apresentaBoleto = function () {
        $scope.modalBoleto = ModalService.model($scope, 'views/pdv/boleto/boleto.html', 'lg', true, true, true);
    };

    $timeout(function () {
        if (VendaService.quantidadeFormasPagamentoCupom() == 0) {
            var indicePagamento = 0;
            angular.forEach($scope.dadosVenda.pagamento, function (dadosPagamento) {
                if (!!dadosPagamento.formaPagamento.tef_id) {
                    $scope.dadosVenda.pagamento.splice(indicePagamento, 1);
                }
                else {
                    VendaService.aplicarFormaPagamento(JSON.stringify(dadosPagamento));
                }
                indicePagamento++;
            });
        }
    }, 50);

    $scope.cancelarVenda = function () {
        $timeout(function () {
            swal({
                title: "Cancelar a venda?",
                text: "",
                type: "warning",
                showCancelButton: true,
                cancelButtonText: "Não",
                confirmButtonClass: "btn-danger",
                confirmButtonText: "Sim, quero cancelar",
                closeOnConfirm: true
            }, function (isConfirm) {
                if (isConfirm) {
                    $timeout(function () {
                        DadosFormularioService.limparDados('venda-varejo');
                        $scope.dadosVenda = {};
                        $scope.gravandoNota = false;
                        VendaService.cancelarEmissaoCupom();
                        $state.go('newpdv.venda-varejo');
                    });
                }
            })
        }, 100);
    }

    if (typeof (w) === "undefined") {
        w = new Worker("js/workers/dataHora.js");
        w.onmessage = function (event) {
            $scope.dataHora = event.data;
            //$scope.$digest(); // trocado pelo metodo abaicho pois fazia com que aparecesse uma tela bugada por causa do delay gerado
            $scope.$applyAsync();
        }
    };

    $scope.$on('$stateChangeStart', function () {
        if (typeof (w) != "undefined") {
            w.terminate();
            w = undefined;
        }
    });

    $scope.refazParcelas = function (posicao, dadosParcela) {
        if (dadosParcela.formaPagamento.fpg_tipopagamento == parseInt(tipoFormaPagamento.fpCartaoCredito) || dadosParcela.formaPagamento.fpg_tipopagamento == parseInt(tipoFormaPagamento.fpCartaoDebito)) {
            dadosParcela.parcelas[posicao].recebimentoCartao = [];
            dadosParcela.parcelas[posicao].formaPagamento = null;
            dadosParcela.parcelas[posicao].condicaoPagamento = null;
        }

        var valorTotalFormaPagamento = dadosParcela.valorPago;
        var valorParcial = 0;
        var somaParcelas = 0;
        var resto = 0;
        var percentualParcela = 100 / (dadosParcela.parcelas.length - (posicao + 1));
        for (var i = 0; i < dadosParcela.parcelas.length; i++) {
            if (dadosParcela.parcelas[i].prc_valor <= 0) {
                dadosParcela.parcelas[i].prc_valor = 0.01;
                var numeroParcela = 1 + i;
                swal("Valor da parcela não pode ser menor ou igual a 0,00 verifique a parcela Nº " + numeroParcela + "!", "", "warning");
            }
            if (i <= posicao) {
                valorParcial += dadosParcela.parcelas[i].prc_valor;
            } else {
                var diferenca = (valorTotalFormaPagamento - parseFloat(valorParcial)).toFixed(2);
                var valorParcela = ((percentualParcela / 100) * (parseFloat(diferenca))).toFixed(2);
                dadosParcela.parcelas[i].prc_valor = parseFloat(valorParcela);
            }
            somaParcelas += dadosParcela.parcelas[i].prc_valor;
            somaParcelas = parseFloat(somaParcelas);

        }
        resto = valorTotalFormaPagamento - somaParcelas;
        resto = resto.toFixed(2);
        resto = parseFloat(resto);
        if (resto != 0) {
            var numeroUltimaParcela = dadosParcela.parcelas.length - 1;
            if (posicao == numeroUltimaParcela) {
                var diferencaValor = FuncaoService.retornaMoney(resto);
                swal({
                    title: "A soma das parcelas está com uma diferença de  R$ " + diferencaValor.toFixed(2) +
                        " Deseja ajustar essa diferença na parcela atual ou recalcular automaticamente todas as parcelas anteriores?",
                    type: "warning",
                    showCancelButton: true,
                    cancelButtonText: "Ajustar",
                    confirmButtonClass: "btn-info",
                    confirmButtonText: "Recalcular",
                    closeOnConfirm: true
                }, function (acao) {
                    if (acao) {
                        $timeout(function () {
                            var valorRecalcular = valorTotalFormaPagamento - parseFloat(dadosParcela.parcelas[numeroUltimaParcela].prc_valor);
                            var perceParcela = 100 / (dadosParcela.parcelas.length - 1);
                            somaParcelas = 0;
                            resto = 0;
                            somaParcelas = parseFloat(dadosParcela.parcelas[numeroUltimaParcela].prc_valor);
                            for (var i = 0; i < dadosParcela.parcelas.length; i++) {
                                if (i < numeroUltimaParcela) {
                                    var valorParcelaRecalculada = ((perceParcela / 100) * (parseFloat(valorRecalcular))).toFixed(2);
                                    dadosParcela.parcelas[i].prc_valor = parseFloat(valorParcelaRecalculada);
                                    somaParcelas += dadosParcela.parcelas[i].prc_valor;
                                    somaParcelas = parseFloat(somaParcelas);
                                }
                            }
                            resto = valorTotalFormaPagamento - somaParcelas;
                            resto = resto.toFixed(2);
                            resto = parseFloat(resto);
                            if (resto != 0) {
                                var valParcela = parseFloat(dadosParcela.parcelas[numeroUltimaParcela - 1].prc_valor);
                                var totalParcela = (valParcela + resto).toFixed(2);
                                dadosParcela.parcelas[numeroUltimaParcela - 1].prc_valor = parseFloat(totalParcela);
                            }
                        }, 100);
                    } else {
                        $scope.$apply(function () {
                            var valParcela = parseFloat(dadosParcela.parcelas[numeroUltimaParcela].prc_valor);
                            var totalParcela = (valParcela + resto).toFixed(2);
                            dadosParcela.parcelas[numeroUltimaParcela].prc_valor = parseFloat(totalParcela);
                        });
                    }
                });
            } else {
                var valParcela = parseFloat(dadosParcela.parcelas[numeroUltimaParcela].prc_valor);
                var totalParcela = (valParcela + resto).toFixed(2);
                dadosParcela.parcelas[numeroUltimaParcela].prc_valor = parseFloat(totalParcela);

            }
        }
    };

    $scope.preencherCep = function (cep) {
        var conectadoInternet = JSON.parse(aplicacaoService.verificarConexao());
        if (conectadoInternet) {
            var cep = JSON.parse(cidadeAppService.buscar(cep));
            if (!!cep) {
                $scope.frete.dadosCliente.cidade = cep.cid_descricao;
                $scope.frete.dadosCliente.uf = cep.est_sigla;
            }
        } else {
            swal("Você não está sem Conexão com Internet!", "", "warning");
            return;
        }
    };

    $scope.ListaCliente = function () {
        // Buscar novos clientes
        $scope.modalClienteAberta = true;

        clienteAppService.buscarNovosClientesApi();

        $scope.DivVisibility = false;
        $scope.modalCliente = ModalService.model($scope, 'views/pdv/varejo/modalBuscarCliente.html', 'lg', true, 'static', true);
        $scope.dadosVenda.pessoaAutorizada = {};
        if (!!$scope.dadosVenda.pes_cpfcnpj) $scope.cpfCnpj = $scope.dadosVenda.pes_cpfcnpj;
        if (!!$scope.dadosVenda.pes_nome) $scope.nome = $scope.dadosVenda.pes_nome;
        if (!!$scope.dadosVenda.idEstrangeiro) $scope.cpfCnpj = $scope.dadosVenda.idEstrangeiro;
        if (!!$scope.dadosVenda.cli_id) $scope.idCliente = $scope.dadosVenda.cli_id;

        /*        $timeout(function () {*/
        $scope.marcarTexto('cpfCnpj');
        /*        }, 100);*/
    };

    $scope.ListaPessoasAutorizadas = function (clienteId) {
        $scope.listarPessoaAutorizada = JSON.parse(clientePessoaAutorizadaAppService.buscar(clienteId));
        $scope.modalPessoaAutorizada = ModalService.model($scope, 'views/pdv/varejo/modalBuscaPessoaAutorizada.html', 'lg', true, 'static', true);
    };

    $scope.LocalizarDigital = function (clienteId) {
        var retornoDigital = JSON.parse(leitorBiometricoAppService.abrirFormLeitorBiometrico(clienteId));
        $scope.dadosVenda.pessoaAutorizada = retornoDigital;
    }

    $scope.cancelarSelecaoPessoaAutorizada = function () {
        $scope.dadosVenda.pessoaAutorizada = {};
        $scope.modalPessoaAutorizada.close();
    };

    $scope.removerPessoaAutorizada = function () {
        $scope.dadosVenda.pessoaAutorizada = {};
    };

    $scope.selecionaPessoaAutorizada = function (pessoa) {
        $scope.dadosVenda.pessoaAutorizada = pessoa;
        $scope.modalPessoaAutorizada.close();
    };

    $scope.cancelaIdentificacaoCliente = function () {
        if (!!$scope.ultimoCpfCnpjInformado) {
            $scope.selecionarCliente($scope.ultimoCpfCnpjInformado, $scope.ultimoNomeInformado);
        } else {
            $scope.cpfCnpj = $scope.dadosVenda.pes_cpfcnpj;
            $scope.nome = $scope.dadosVenda.pes_nome;
            $scope.modalCliente.close();
        }
    };

    $scope.buscaCliente = function (cpfCnpj, nome) {
        nome = (!!nome == true) ? nome : '';
        if (nome == "CONSUMIDOR FINAL") nome = '';
        cpfCnpj = (!!cpfCnpj == true) ? cpfCnpj : '';
        $scope.filtroClienteNome = (!!nome) ? nome : cpfCnpj;

        var listaClientePDV = JSON.parse(clienteAppService.buscaCliente(cpfCnpj, nome));
        var listaClienteNew = JSON.parse(clienteAppService.pesquisaClienteNEW(cpfCnpj, nome));

        Array.prototype.push.apply(listaClientePDV, listaClienteNew);
        var listaClientes = listaClientePDV.reduce(function (rv, x) {
            rv = (!!rv) ? rv : [];
            var clienteAdicionado = rv.filter(function (cliente) {
                return (cliente.pes_nome == x.pes_nome);
            });

            if (!!!clienteAdicionado.length)
                rv.push(x);
            return rv;
        }, []);

        $scope.listarCliente = listaClientes;
    };

    $scope.showDiv = function () {
        $scope.DivVisibility = !$scope.DivVisibility;
    };

    $scope.buscaClientePorCpfCnpj = function (cpfCnpj, cpfValido) {
        if ((!!cpfCnpj) && (!!cpfValido) && $scope.dadosVenda.pes_cpfcnpj != cpfCnpj) {
            var dadosCliente = JSON.parse(clienteAppService.buscaDadosCliente(cpfCnpj));
            if (!!dadosCliente) {
                $scope.nome = dadosCliente.pes_nome;
                $scope.dadosVenda.pes_cpfcnpj = (!!dadosCliente.pef_cpf) ? dadosCliente.pef_cpf : dadosCliente.pej_cnpj;
                $scope.dadosVenda.pes_nome = dadosCliente.pes_nome;
                $scope.dadosVenda.cli_id = dadosCliente.cli_id;
                $scope.dadosVenda.pes_id = dadosCliente.pes_id;
                $scope.dadosVenda.ClienteId = dadosCliente.Id;
                $scope.dadosVenda.pes_idestrangeiro = dadosCliente.pes_idestrangeiro;
                $scope.dadosVenda.clienteIdentificado = true;
                $scope.dadosVenda.cli_vendasomenteavista = dadosCliente.cli_vendasomenteavista;
                if ($scope.dadosVenda.cli_vendasomenteavista == true) {
                    if ($scope.dadosVenda.pagamento) {
                        for (var i = 0; i < $scope.dadosVenda.pagamento.length; i++) {
                            $scope.dadosVenda.descontoTotal = parseFloat($scope.dadosVenda.descontoTotal.toFixed(2));
                            if ($scope.dadosVenda.descontoTotal > 0) {
                                $scope.dadosVenda.descontoTotal -= parseFloat($scope.dadosVenda.pagamento[i].descontoPadrao.valorDesconto.toFixed(2));
                            }
                            $scope.dadosVenda.descontoTotal = parseFloat($scope.dadosVenda.descontoTotal.toFixed(2));
                            $scope.removerFormaPagamentoRateioItens($scope.dadosVenda.pagamento[i].descontoPadrao.valorDesconto);
                            removerFormaPagamento(i);
                            $scope.dadosVenda.pagamento.splice(i, 1);
                            $scope.calcularTotaisNota();
                            $scope.dadosPagamento.valorPago = ($scope.dadosVenda.totalNota - $scope.totalPago);

                        }
                    }
                }
            } else {
                $scope.dadosVenda.pes_nome = null;
                $scope.dadosVenda.cli_id = null;
                $scope.dadosVenda.pes_id = null;
                $scope.dadosVenda.ClienteId = null;
                $scope.nome = null;
                $scope.dadosVenda.clienteIdentificado = false;
                $scope.dadosVenda.cli_vendasomenteavista = false;
            }
        }
    };

    $scope.removerCliente = function () {
        if ($scope.dadosVenda.cli_id || $scope.dadosVenda.ClienteId) {
            $scope.dadosVenda.clienteIdentificado = false;
            if ($scope.dadosVenda.pagamento.length > 0) {
                deleteFormaPagamento();
                $scope.totalPago = 0;
            }
            if (!!$scope.dadosPagamento.valorPago == false) $scope.dadosPagamento.valorPago = $scope.dadosVenda.totalNota;
            $scope.dadosVenda.pes_cpfcnpj = null;
            $scope.dadosVenda.pes_nome = null;
            $scope.dadosVenda.cli_id = null;
            $scope.dadosVenda.pes_id = null;
            $scope.dadosVenda.ClienteId = null;
            $scope.dadosVenda.clienteIdentificado = false;
            $scope.dadosVenda.cli_vendasomenteavista = false;
            $scope.dadosPagamento.formaPagamento = null;
            $scope.dadosPagamento.condicaoPagamento = null;
            $scope.dadosVenda.pessoaAutorizada = {};
            $scope.dadosVenda.possuiPessoaAutorizada = false;
        }
    };

    $scope.cadastrarCliente = function (cpfCnpj, nome) {
        DadosFormularioService.limparDados('cliente-manutencao');
        DadosFormularioService.armazenarDados('cliente-manutencao', {
            voltarParaVenda: true,
            pes_cpfcnpj: (!!cpfCnpj) ? cpfCnpj : null,
            pes_nome: (!!cpfCnpj) ? (!!cpfCnpj.length == 11) ? nome : null : null,
            pej_nomefantasia: (!!cpfCnpj) ? (!!cpfCnpj.length == 14) ? nome : null : null
        });
        $state.go('newpdv.manutencao-cliente');
    };

    $scope.selecionaCliente = function (cliente) {
        $scope.dadosVenda.possuiPessoaAutorizada = false;
        $scope.selecionarCliente((!!cliente.pef_cpf) ? cliente.pef_cpf : cliente.pej_cnpj, cliente.pes_nome, cliente.cli_id);
        $scope.dadosVenda.clienteIdentificado = true;
    };

    $scope.selecionarClienteEnter = function (cpfCnpj) {
        FuncaoService.delay(function () {
            $scope.dadosVenda.possuiPessoaAutorizada = false;
            $scope.selecionarCliente(cpfCnpj, $scope.dadosVenda.pes_nome);
        }, 100);
    };

    $scope.selecionarCliente = function (cpfCnpj, nome, clienteId) {
        if (!!cpfCnpj) {
            var dadosCliente = JSON.parse(clienteAppService.buscaDadosCliente(cpfCnpj));
        } else {
            if (!!clienteId) {
                var dadosCliente = JSON.parse(clienteAppService.buscaClienteId(clienteId));
            }
        }
        if (!!dadosCliente) {
            $scope.dadosVenda.pes_cpfcnpj = cpfCnpj;
            $scope.dadosVenda.pes_nome = (!!nome) ? nome : dadosCliente.pes_nome;
            $scope.dadosVenda.cli_id = dadosCliente.cli_id;
            $scope.dadosVenda.pes_id = dadosCliente.pes_id;
            $scope.dadosVenda.ClienteId = dadosCliente.Id;
            $scope.dadosVenda.ultimoCpfCnpjValidoInformado = cpfCnpj;
            $scope.dadosVenda.ultimoNomeValidoInformado = $scope.dadosVenda.pes_nome;
            $scope.dadosVenda.clienteIdentificado = true;
            $scope.dadosVenda.cli_vendasomenteavista = dadosCliente.cli_vendasomenteavista;

            if (!!dadosCliente.pej_emailpessoacontato) {
                envioNFCeEmail.enviar = true;
                $scope.envioNFCeEmail.enderecoDestinatario = dadosCliente.pej_emailpessoacontato;
            }

            if ($scope.dadosVenda.cli_vendasomenteavista == true && !!$scope.dadosVenda.pagamento == true) {
                for (var i = 0; i < $scope.dadosVenda.pagamento.length; i++) {
                    $scope.dadosVenda.descontoTotal = parseFloat($scope.dadosVenda.descontoTotal.toFixed(2));
                    if ($scope.dadosVenda.descontoTotal > 0) {
                        $scope.dadosVenda.descontoTotal -= parseFloat($scope.dadosVenda.pagamento[i].descontoPadrao.valorDesconto.toFixed(2));
                    }
                    $scope.dadosVenda.descontoTotal = parseFloat($scope.dadosVenda.descontoTotal.toFixed(2));
                    $scope.removerFormaPagamentoRateioItens($scope.dadosVenda.pagamento[i].descontoPadrao.valorDesconto);

                    $scope.calcularTotaisNota();
                    $scope.dadosPagamento.valorPago = ($scope.dadosVenda.totalNota - $scope.totalPago);

                }
                if ($scope.dadosVenda.pagamento.length > 0) {
                    for (var i = 0; i <= $scope.dadosVenda.pagamento.length; i++) {
                        removerFormaPagamento(i);
                        $scope.dadosVenda.pagamento.splice(i, 1);
                        $scope.calcularTotaisNota();
                        $scope.dadosPagamento.valorPago = ($scope.dadosVenda.totalNota - $scope.totalPago);
                    }
                }
                if ($scope.dadosVenda.pagamento.length == 0) {
                    $scope.listarFormaPagamento();
                }
            }
            $scope.listarPessoaAutorizada = JSON.parse(clientePessoaAutorizadaAppService.buscar(dadosCliente.Id));
            if ($scope.listarPessoaAutorizada.length > 0) {
                $scope.dadosVenda.possuiPessoaAutorizada = true;
            }
            $scope.verificaAntecipacoes($scope.dadosVenda.pes_id);
        } else {
            $scope.dadosVenda.possuiPessoaAutorizada = false;
            $scope.dadosVenda.pes_cpfcnpj = (!!cpfCnpj) ? cpfCnpj : null;
            $scope.dadosVenda.pes_nome = (!!nome) ? nome : null;
            $scope.dadosVenda.cli_id = null;
            $scope.dadosVenda.pes_id = null;
            $scope.dadosVenda.ClienteId = null;
            $scope.dadosVenda.clienteIdentificado = false;
            $scope.dadosVenda.cli_vendasomenteavista = false;
            $scope.envioNFCeEmail.enderecoDestinatario = '';
        }

        if (!$scope.validarFormaPagamento()) {
            $scope.selecionarCliente($scope.dadosVenda.ultimoCpfCnpjValidoInformado, $scope.dadosVenda.ultimoNomeValidoInformado);
        } else {
            $scope.cpfCnpj = null;
            $scope.nome = null;
            $scope.ultimoCpfCnpjInformado = $scope.dadosVenda.pes_cpfcnpj;
            $scope.ultimoNomeInformado = $scope.dadosVenda.pes_nome;
            $scope.modalCliente.close();
            $scope.listarFormaPagamento();
        }
    };

    $scope.validarFormaPagamento = function () {
        $scope.dadosVenda.pagamento = (!!$scope.dadosVenda.pagamento) ? $scope.dadosVenda.pagamento : [];
        if (!!!$scope.dadosVenda.ClienteId) {
            for (var i = 0; i < $scope.dadosVenda.pagamento.length; i++) {
                if ($scope.dadosVenda.pagamento[i].formaPagamento.fpg_tipopagamento == tipoFormaPagamento.fpCreditoLoja) {
                    if ($scope.dadosVenda.pagamento.length == 1) {
                        swal("Você já definiu a forma de pagamento!", "Para modificar o cliente, primeiro remova a forma de pagamento!", "warning");
                        return false;
                        break;
                    }
                    if ($scope.dadosVenda.pagamento.length > 1) {
                        swal("Você já definiu as formas de pagamento!", "Para modificar o cliente, primeiro remova as formas de pagamento!", "warning");
                        return false;
                        break;
                    }
                }
            }
        }
        return true;
    };

    function sumAntecipacao() {
        if (!$scope.dadosVenda.hasOwnProperty("antecipacoes"))
            $scope.dadosVenda.antecipacoes = [];
        var soma = 0
        for (var i = 0; i < $scope.dadosVenda.antecipacoes.length; i++) {
            if ($scope.dadosVenda.antecipacoes[i].selecionado == true) {
                soma += $scope.dadosVenda.antecipacoes[i].valorUtilizado;
            }
        };
        return soma;
    }

    $scope.selecionaAntecipacao = function (dadosAntecipacao, item) {

        if (item.selecionado) {
            if (sumAntecipacao() >= $scope.dadosVenda.totalNota) {
                item.selecionado = false;
                swal("Atenção!", "Valor total da antecipação já cobre o valor da nota!", "warning");
                return;
            }
        }

        var somaAntecipacao = 0;
        var somaValorPago = 0;
        $scope.dadosVenda.valorPagar = 0;
        $scope.dadosVenda.valorRatearQuitar = 0;
        $scope.dadosVenda.antecipacoes = [];

        for (var i = 0; i < dadosAntecipacao.length; i++) {
            if (dadosAntecipacao[i].selecionado) {
                somaAntecipacao += (dadosAntecipacao[i].anm_valor) ? dadosAntecipacao[i].anm_valor : dadosAntecipacao[i].acf_valor;
                var antecipacoa = dadosAntecipacao[i];

                var valorItem = (antecipacoa.anm_valor) ? antecipacoa.anm_valor : antecipacoa.acf_valor;

                antecipacoa.valorTotalNota = $scope.dadosVenda.totalNota;
                antecipacoa.valorPago = $scope.dadosVenda.totalNota;

                var restante = valorItem - ($scope.dadosVenda.totalNota - somaValorPago);
                antecipacoa.valorRestante = (restante > 0) ? restante : 0;
                var valorTotalAtencipacao = valorItem + somaValorPago;

                if ($scope.dadosVenda.totalNota >= valorTotalAtencipacao) {
                    antecipacoa.valorUtilizado = valorItem;
                    antecipacoa.valorQuitado = valorItem;
                } else {
                    var valorADescontar = ($scope.dadosVenda.totalNota - somaValorPago);
                    antecipacoa.valorUtilizado = valorADescontar;
                    antecipacoa.valorQuitado = valorADescontar;
                }

                somaValorPago += antecipacoa.valorUtilizado;
                $scope.dadosVenda.antecipacoes.push(antecipacoa);
            };
        };

        if (somaAntecipacao != 0) {
            $scope.dadosVenda.totalAntecipacao = somaAntecipacao;
        };
        if ($scope.dadosVenda.totalAntecipacao > $scope.dadosVenda.totalNota) {
            $scope.dadosVenda.valorRatearQuitar = $scope.dadosVenda.totalNota;
            $scope.dadosVenda.valorPagar = 0;
            $scope.totalPago = $scope.dadosVenda.totalNota;
        } else {
            $scope.dadosVenda.valorRatearQuitar = $scope.dadosVenda.totalAntecipacao;
            var vlrPagar = $scope.dadosVenda.totalNota.toFixed(2) - $scope.dadosVenda.totalAntecipacao.toFixed(2);
            $scope.dadosVenda.valorPagar = parseFloat(vlrPagar.toFixed(2));
        };
    };


    function clearAntacipacoes() {
        $scope.dadosVenda.valorRatearQuitar = 0;
        //$scope.dadosVenda.valorPagar = 0;
        $scope.dadosVenda.totalAntecipacao = 0;
        $scope.dadosVenda.antecipacoes = [];
        $scope.calcularTotaisNota();
    }

    $scope.calculaValorPagamentoRestante = function () {

        if (!!$scope.dadosPagamento.formaPagamento) {
            if ($scope.dadosPagamento.formaPagamento.fpg_tipopagamento == tipoFormaPagamento.fpCreditoLoja) {
                $scope.dadosPagamento.descontoPadrao.baseCalculo = parseFloat(($scope.dadosPagamento.valorPago <= ($scope.dadosVenda.totalNota - $scope.totalPago) ? $scope.dadosPagamento.valorPago : ($scope.dadosPagamento.valorPago > ($scope.dadosVenda.totalNota - $scope.totalPago) ? ($scope.dadosVenda.totalNota - $scope.totalPago) : ($scope.dadosVenda.totalNota - $scope.totalPago) - $scope.dadosPagamento.valorPago)).toFixed(2));
                $scope.dadosPagamento.percentualJuros.baseCalculo = parseFloat(($scope.dadosPagamento.valorPago <= ($scope.dadosVenda.totalNota - $scope.totalPago) ? $scope.dadosPagamento.valorPago : ($scope.dadosPagamento.valorPago > ($scope.dadosVenda.totalNota - $scope.totalPago) ? ($scope.dadosVenda.totalNota - $scope.totalPago) : ($scope.dadosVenda.totalNota - $scope.totalPago) - $scope.dadosPagamento.valorPago)).toFixed(2));
                if ($scope.dadosPagamento.valorPago > $scope.dadosVenda.totalNota - $scope.dadosPagamento.descontoPadrao.valorDesconto) {
                    $scope.dadosPagamento.valorPago = $scope.dadosPagamento.descontoPadrao.baseCalculo - $scope.dadosPagamento.descontoPadrao.valorDesconto;
                } else {
                    $scope.dadosPagamento.valorPago = $scope.dadosPagamento.descontoPadrao.baseCalculo;
                }
            } else {

                $scope.dadosPagamento.descontoPadrao.baseCalculo = parseFloat(($scope.dadosPagamento.valorPago <= ($scope.dadosVenda.totalNota - $scope.totalPago) ? $scope.dadosPagamento.valorPago : ($scope.dadosPagamento.valorPago > ($scope.dadosVenda.totalNota - $scope.totalPago) ? ($scope.dadosVenda.totalNota - $scope.totalPago) : ($scope.dadosVenda.totalNota - $scope.totalPago) - $scope.dadosPagamento.valorPago)).toFixed(2));
                $scope.dadosPagamento.percentualJuros.baseCalculo = parseFloat(($scope.dadosPagamento.valorPago <= ($scope.dadosVenda.totalNota - $scope.totalPago) ? $scope.dadosPagamento.valorPago : ($scope.dadosPagamento.valorPago > ($scope.dadosVenda.totalNota - $scope.totalPago) ? ($scope.dadosVenda.totalNota - $scope.totalPago) : ($scope.dadosVenda.totalNota - $scope.totalPago) - $scope.dadosPagamento.valorPago)).toFixed(2));
                var validarValorRestante = parseFloat(($scope.dadosVenda.totalNota - $scope.dadosVenda.descontoTotal - $scope.dadosPagamento.descontoPadrao.valorDesconto).toFixed(2));
                var valorTotalPago = $scope.totalPago + $scope.dadosPagamento.descontoPadrao.baseCalculo + $scope.dadosPagamento.descontoPadrao.valorDesconto;
                if (validarValorRestante < $scope.dadosPagamento.descontoPadrao.baseCalculo) {
                    $scope.dadosPagamento.descontoPadrao.baseCalculo = $scope.dadosVenda.totalNota;
                    $scope.dadosPagamento.percentualJuros.baseCalculo = $scope.dadosVenda.totalNota;
                }
                if ($scope.dadosVenda.totalNota < valorTotalPago) {
                    $scope.dadosPagamento.descontoPadrao.baseCalculo = $scope.dadosVenda.totalNota - $scope.totalPago;
                    $scope.dadosPagamento.percentualJuros.baseCalculo = $scope.dadosVenda.totalNota - $scope.totalPago;
                }
                if ($scope.dadosPagamento.valorPago > ($scope.dadosVenda.totalNota - $scope.dadosPagamento.valorPago) && ($scope.dadosPagamento.formaPagamento.fpg_tipopagamento > 2 && !$scope.dadosPagamento.valorPago)) {
                    $scope.dadosPagamento.valorPago = ($scope.dadosVenda.totalNota - $scope.dadosPagamento.valorPago);
                    $scope.lancamentoCheque(1, $scope.dadosPagamento.valorPago, (null));
                }
            }
        } else {
            var valorTotalPago = $scope.totalPago;
            if ($scope.dadosVenda.totalNota < valorTotalPago) {
                $scope.dadosPagamento.descontoPadrao.baseCalculo = $scope.dadosVenda.totalNota - $scope.totalPago;
                $scope.dadosPagamento.percentualJuros.baseCalculo = $scope.dadosVenda.totalNota - $scope.totalPago;
            }
            if ($scope.dadosVenda.pagamento.length == 0) $scope.dadosPagamento.valorPago = $scope.dadosVenda.totalNota;
            else
                $scope.dadosPagamento.valorPago = $scope.dadosVenda.totalNota - valorTotalPago;


            //if ($scope.dadosPagamento.valorPago > ($scope.dadosVenda.totalNota - $scope.dadosPagamento.valorPago)) {
            //    $scope.dadosPagamento.valorPago = ($scope.dadosVenda.totalNota - $scope.dadosPagamento.valorPago);
            //}
        }
    };

    $scope.lancamentoCheque = function (quantidadeCheques, valorTotalCheques, indiceMultiplasFormasPagamento, tipoPagamento) {
        $timeout(function () {
            $scope.dadosVenda.pagamento[indiceMultiplasFormasPagamento].cheques = [];
            if (!!valorTotalCheques == false) valorTotalCheques = $scope.dadosPagamento.valorPago;
            if (tipoPagamento === parseInt(tipoFormaPagamento.fpCheque)) {
                if (!!!quantidadeCheques) quantidadeCheques = 1;
                if (quantidadeCheques === 0) quantidadeCheques = 1;
                $scope.modalCheque = ModalService.abrir('views/pdv/cheques/modalCheques.html', 'lg', true, 'static', true, 'ModalChequeController', { 'quantidadeCheques': quantidadeCheques, 'valorTotal': valorTotalCheques, 'cli_id': $scope.dadosVenda.ClienteId });
                $scope.modalCheque.result.then(function (dadosCheques) {
                    if (!!dadosCheques) {
                        var cheques = [];
                        angular.forEach(dadosCheques, function (cheque) {
                            cheques.push({
                                ban_id: cheque.ban_id,
                                chq_codigocompensacao: cheque.chq_codigocompensacao,
                                cli_id: cheque.cli_id,
                                pes_id: cheque.pes_id,
                                chq_agencia: cheque.chq_agencia,
                                chq_c1: cheque.chq_c1,
                                chq_contacorrente: cheque.chq_contacorrente,
                                chq_c2: cheque.chq_c2,
                                chq_serie: cheque.chq_serie,
                                chq_numero: cheque.chq_numero,
                                chq_c3: cheque.chq_c3,
                                chq_valor: cheque.chq_valor,
                                linha1: cheque.linha1,
                                ban_descricao: cheque.ban_descricao,
                                chq_cmc7: cheque.chq_cmc7,
                                chq_dataemissao: cheque.chq_dataemissao,
                                chq_bompara: cheque.chq_bompara,
                                chq_emissorclientedesde: cheque.chq_emissorclientedesde,
                                chq_nomeemissor: cheque.chq_nomeemissor,
                                chq_cpfcnpjemissor: cheque.chq_cpfcnpjemissor,
                                chq_telefoneemissor: cheque.chq_telefoneemissor,
                                chq_observacao: cheque.chq_observacao,
                                ClienteId: cheque.ClienteId,
                                mcc_id: null
                            });
                        })
                        $scope.dadosVenda.pagamento[indiceMultiplasFormasPagamento].cheques = cheques;
                    } else {
                        removerFormaPagamento(indiceMultiplasFormasPagamento);
                    }
                });
            }
        }, 100);
    };

    $scope.buscarValePresente = function (codigoValePresente) {
        var verificarValeUtilizado = JSON.parse(antecipacaoMovimentoAppService.buscarMovimentosAntecipacao(codigoValePresente));
        if (verificarValeUtilizado == false) {
            var retorno = JSON.parse(antecipacaoClienteFornecedorAppService.buscarValePresente(JSON.stringify(codigoValePresente)));
            if (!!retorno) {
                $scope.codigoValePresenteValido = true;
                $scope.valorValePresente = retorno.acf_valor;
                if ($scope.dadosPagamento.valorPago == retorno.acf_valor) {
                    $scope.dadosPagamento.valorPago = retorno.acf_valor;
                }
                else {
                    if ($scope.dadosPagamento.valorPago > retorno.acf_valor) {
                        $scope.dadosPagamento.valorPago = retorno.acf_valor;
                        $scope.calcularTotaisNota();
                    }
                }
                $scope.dadosPagamento.codigoValePresente = codigoValePresente;
            } else {
                $scope.codigoValePresenteValido = false;
                $scope.dadosPagamento.codigoValePresente = "";
                swal("Código Inválido!", "Não foi possível localizar, ou vale presente estornado!", "warning");
            }
        } else {
            var retorno = JSON.parse(antecipacaoClienteFornecedorAppService.buscarValePresente(JSON.stringify(codigoValePresente)));
            if (!!retorno) {
                $scope.dadosPagamento.formaPagamento = [];
                $scope.listarFormaPagamento();
                $scope.dadosPagamento.codigoValePresente = "";
                swal("Vale Utilizado!", "Vale presente já utilizado!", "warning");
            } else {
                $scope.codigoValePresenteValido = false;
                $scope.dadosPagamento.codigoValePresente = "";
                swal("Código Inválido!", "Não foi possível localizar o vale presente!", "warning");
            }

        }
    };

    $scope.validarValorValePresente = function (valorDigitado) {
        if ($scope.dadosPagamento.formaPagamento.fpg_tipopagamento == 12) {
            var restanteNota = $scope.dadosVenda.totalNota - $scope.totalPago;
            if (valorDigitado > $scope.valorValePresente) {
                swal("Valor não pode ser superior ao do Vale!", "", "warning");
                $scope.dadosPagamento.valorPago = $scope.valorValePresente;
            }
            if (valorDigitado > restanteNota) {
                swal("Valor não pode ser superior ao restante a pagar!", "", "warning");
                $scope.dadosPagamento.valorPago = restanteNota;
            }
        }
    };

    $scope.GravarMovimentoAntecipacao = function (dadosMovimento) {
        antecipacaoMovimentoAppService.incluir(JSON.stringify(dadosMovimento));
    };

    $scope.recalculaDataVencimento = function (indice, novaData, dadosParcela) {
        if (!!novaData) {

        }
    };

    $scope.edicaoParcelas = function (parcelas) {
        if ($scope.editarParcelas.$edit == false) {
            $scope.editarParcelas.$edit = true;
        }
        else {
            var concluirEdicao = true;
            for (var i = 0; i < parcelas.length; i++) {
                if (!!parcelas[i].prc_datavencimento == false) concluirEdicao = false;
                if (!!parcelas[i].prc_valor == false) concluirEdicao = false;
            }
            $scope.editarParcelas.$edit = !concluirEdicao;
            if (concluirEdicao == false) {
                swal("Verifique as parcelas", "Antes de continuar verifique as parcelas, informe sua data de vencimento e valor.", "warning");
            }
        }
    }

    $scope.fecharModalAntecipacao = function () {
        clearAntacipacoes();
        $scope.modelSelecionarAntecipacao.close();
    };

    $scope.VerificaValorDigitado = function (valorDigitado) {
        if (valorDigitado > $scope.dadosVenda.totalNota) {
            swal("Verifique o valor a ser utilizado", "Valor a ser utilizado não pode ser maior que o total das parcelas, informe um valor igual ou inferior", "warning");
            $scope.dadosVenda.valorRatearQuitar = $scope.dadosVenda.totalNota;
        } else {
            $scope.dadosVenda.valorRatearQuitar = valorDigitado;
        }
    };

    $scope.quitarRatearAntecipacao = function () {

        var valor = 0;
        for (var i = 0; i < $scope.dadosVenda.antecipacoes.length; i++) {
            if ($scope.dadosVenda.antecipacoes[i].selecionado == true) {
                valor += $scope.dadosVenda.antecipacoes[i].valorUtilizado;
            }
        };

        $timeout(function () {

            var formaPagamento = formaPagamentoAppService.retornoFormaPagamentoAntecipacao();
            formaPagamento.antecipacoes = $scope.dadosVenda.antecipacoes;

            var dadosPagamento = {
                cheques: [],
                condicaoPagamento: null,
                descontoPadrao: {
                    baseCalculo: 0,
                    percentualDesconto: 0,
                    valorDesconto: 0
                },
                formaPagamento: formaPagamento,
                parcelas: [],
                percentualJuros: {},
                recebimentoCartao: [],
                valorPago: valor
            };

            adicionarPagamento(dadosPagamento);

            $scope.fecharModalAntecipacao();

        }, 100);
    };

    $scope.etapaNaoCompleta = [];

    $scope.etapas = function (numeroPagina, adicionar) {
        if (adicionar) {
            if ($scope.etapaNaoCompleta.length == 0) {
                $scope.etapaNaoCompleta.push(numeroPagina);
            } else {
                var add = true;
                for (var i = 0; i < $scope.etapaNaoCompleta.length; i++) {
                    if ($scope.etapaNaoCompleta[i] == numeroPagina) {
                        add = false;
                    }
                }

                if (add)
                    $scope.etapaNaoCompleta.push(numeroPagina);
            }
        } else {
            for (var i = 0; i < $scope.etapaNaoCompleta.length; i++) {
                if (numeroPagina <= $scope.etapaNaoCompleta[i]) {
                    $scope.etapaNaoCompleta.splice(i, 1);
                }
            }
        }
    };

    function verifyAntecipacaoStorage() {
        for (var i in $scope.dadosVenda.pagamento) {
            if ($scope.dadosVenda.pagamento[i].hasOwnProperty("formaPagamento")) {
                if ($scope.dadosVenda.pagamento[i].formaPagamento.fpg_quitacaoantecipacao) {
                    return false;
                }
            }
        }
        return true;
    }

    $scope.verificaAntecipacoes = function (codigoCliente) {
        if (codigoCliente) {
            $scope.dadosVenda.valorRatearQuitar = 0;
            $scope.dadosAntecipacao = JSON.parse(antecipacaoClienteFornecedorAppService.listarAntecipacao(codigoCliente));
            $timeout(function () {
                $scope.contemAntecipacao = $scope.dadosAntecipacao.length > 0;
            });
            if (verifyAntecipacaoStorage()) {

                if ($scope.dadosAntecipacao.length > 0) {
                    if (!$scope.dadosVenda.hasOwnProperty("pagamento"))
                        $scope.dadosVenda.pagamento = [];
                    if ($scope.dadosVenda.pagamento.length == 0) {
                        $scope.dadosVenda.parcelasAntecipacoes = [];
                        swal({
                            title: "O Cliente possui créditos/antecipações",
                            text: "Este cliente possui créditos/antecipações, deseja utilizar elas para esta venda?",
                            type: "warning",
                            showCancelButton: true,
                            cancelButtonText: "Não utilizar",
                            confirmButtonClass: "btn-success",
                            confirmButtonText: "Utilizar Crédito/antecipação",
                            allowOutsideClick: false
                        }, function (acao) {
                            if (acao) {
                                $timeout(function () {
                                    $scope.modelSelecionarAntecipacao = ModalService.model($scope, 'views/pdv/varejo/modalAntecipacoes.html', 'lg', true, 'static', true);
                                }, 100);
                            }
                        });

                    } else {

                        swal({
                            title: "As antecipações devem ser informadas em primeiro momento, para utiliza-las você deve remover as demais formas de pagamento já informadas!",
                            text: "Deseja remover agora?",
                            type: "warning",
                            showCancelButton: true,
                            cancelButtonText: "Não",
                            confirmButtonClass: "btn-danger",
                            confirmButtonText: "Sim, quero remover",
                            allowOutsideClick: false
                        }, function (result) {
                            if (result) {
                                deleteFormaPagamento();
                            }
                        });

                    }
                }
            }
        }
    };

    function deleteFormaPagamento() {
        if ($scope.dadosVenda.hasOwnProperty("pagamento"))
            for (var i = 0; i < $scope.dadosVenda.pagamento.length; i++) {
                removerFormaPagamento(i);
            }
        $scope.dadosVenda.pagamento = [];
    }

    $scope.verificaDataParcela = function (indice, dadosParcela) {
        var temDataErrada = false;
        var numeroParcela = null;
        var dataHoje = new Date();
        var diaHoje = dataHoje.getDate();
        var mesHoje = dataHoje.getMonth() + 1;
        var anoHoje = dataHoje.getFullYear();
        dataHoje = diaHoje + '/' + mesHoje + '/' + anoHoje;
        for (var i = 0; i < $scope.dadosVenda.pagamento[0].parcelas.length; i++) {
            var dataParcela = new Date($scope.dadosVenda.pagamento[0].parcelas[i].prc_datavencimento);
            var dia = dataParcela.getDate();
            var mes = dataParcela.getMonth() + 1;
            var ano = dataParcela.getFullYear();
            dataParcela = dia + '/' + mes + '/' + ano;
            if ($scope.dadosVenda.pagamento[0].parcelas[i].prc_numeroparcela != 1 && dataParcela == dataHoje) {

                temDataErrada = true;
                numeroParcela = $scope.dadosVenda.pagamento[0].parcelas[i].prc_numeroparcela;
                break;

            };
            if (indice != 0) {
                if ($scope.dadosVenda.pagamento[0].parcelas[indice - 1].prc_datavencimento > dadosParcela.prc_datavencimento) {
                    temDataErrada = true;
                    numeroParcela = $scope.dadosVenda.pagamento[0].parcelas[indice].prc_numeroparcela;
                    break;
                };
            }
            if ($scope.dadosVenda.pagamento[0].parcelas[i].prc_numeroparcela == 1 && dataParcela == dataHoje) {
                $scope.dadosVenda.pagamento[0].parcelas[i].prc_entrada = true;
                break;
            }
        }
        if (temDataErrada) {
            swal("Datas Incorretas", "Antes de continuar verifique as datas das parcelas", "warning");
        } else {
            $scope.ajustarDatasParcelas(indice)
        }
    };

    $scope.filtraDadosTabela = function (codigoAntecipacao) {
        for (var i = 0; i < $scope.dadosAntecipacao.length; i++) {
            if ($scope.dadosAntecipacao[i].acf_codigovalepresente == codigoAntecipacao) {
                $scope.dadosAntecipacao[i].selecionado = true;
                break;
            }
        };
        $scope.selecionaAntecipacao($scope.dadosAntecipacao);
    };

    $scope.ajustaValoresCartao = function () {
        if ($scope.dadosVenda.pagamento[0].parcelas.length > 0) {
            if ($scope.dadosVenda.pagamento[0].parcelas[0].formaPagamento.fpg_tipopagamento == parseInt(tipoFormaPagamento.fpCartaoCredito) || $scope.dadosVenda.pagamento[0].parcelas[0].formaPagamento.fpg_tipopagamento == parseInt(tipoFormaPagamento.fpCartaoDebito)) {
                $scope.dadosVenda.pagamento[0].parcelas[0].recebimentoCartao[0].rcc_valor = $scope.dadosVenda.pagamento[0].parcelas[0].prc_valor;
            }
        }
    };

    $scope.ajustarDatasParcelas = function (indice) {
        for (var i = 0; i < $scope.dadosVenda.pagamento.length; i++) {
            if ($scope.dadosVenda.pagamento[i].parcelas.length > 0) {
                var definicaoParcelamento = JSON.parse(condicaoPagamentoAppService.listaParcelasCondicao($scope.dadosVenda.pagamento[i].condicaoPagamento.cpg_id));
                for (var a = indice; a < $scope.dadosVenda.pagamento[i].parcelas.length; a++) {
                    if ($scope.dadosVenda.pagamento[i].parcelas[a + 1] != null) {
                        var qtdDias = 0;
                        if (a > 0) {
                            qtdDias = definicaoParcelamento[a].pcl_numerodias - definicaoParcelamento[a - 1].pcl_numerodias;
                        } else {
                            qtdDias = definicaoParcelamento[a].pcl_numerodias;
                        }
                        $scope.dadosVenda.pagamento[i].parcelas[a + 1].prc_datavencimento = new Date(new Date($scope.dadosVenda.pagamento[i].parcelas[a].prc_datavencimento).setDate(new Date($scope.dadosVenda.pagamento[i].parcelas[a].prc_datavencimento).getDate() + qtdDias));
                    }
                }
            }
        }
    };

    $scope.formatarValorRestante = function (totalNota, totalPago) {
        $scope.valorRestante = parseFloat(totalNota.toFixed(2)) - parseFloat(totalPago.toFixed(2));
        $scope.valorRestante = parseFloat(valorRestante.toFixed(2));
    };
}]);
