﻿newERP.controller('ConfiguracoesPDVController', ['$scope', 'ModalService', '$state', 'ValidarFormularioService', '$timeout', 'DadosFormularioService', 'FuncaoService', '$rootScope', 'hotkeys', function ($scope, ModalService, $state, ValidarFormularioService, $timeout, DadosFormularioService, FuncaoService, $rootScope, hotkeys) {

    $scope.dadosConfiguracoes = {};
    $scope.dadosConfiguracoesTef = {};
    $scope.desabilitarBotaoTeste = false;

    $scope.abreConfiguracoes = function () {
        $scope.dadosConfiguracoes = JSON.parse(setupPdvService.retornaConfiguracaoPdv());
        //$scope.dadosConfiguracoes = DadosFormularioService.retornaDados('dadosConfiguracoesPDV').dados;
        DadosFormularioService.armazenarDados('dadosConfiguracoesPDV', $scope.dadosConfiguracoes);
        $scope.modalConfiguracao = ModalService.model($scope, 'views/pdv/configuracoes/modalConfiguracoesPDV.html', 'sm', true, true, true);
    };

    $scope.closeModalConfiguracoesPDV = function () {
        $scope.modalConfiguracao.close();
    };

    $scope.salvarConfiguracao = function (configuracoes) {
        if (setupPdvService.salvarConfiguracoesPdv(JSON.stringify($scope.dadosConfiguracoes)) == true) {
            swal("Configuração alterada com sucesso!", "", "warning");
            $scope.modalConfiguracao.close();
        }
    };

    // Configurações do TEF
    $scope.abreConfiguracoesTef = function () {
        $scope.dadosConfiguracoesTef = JSON.parse(setupPdvService.retornaConfiguracaoPdvTef());
        if ($scope.dadosConfiguracoesTef == null) {
            $scope.dadosConfiguracoesTef = { tef_mensagempinpad: "*ABASE SISTEMAS* \n TEF GESTOR WEB"}
        }
        DadosFormularioService.armazenarDados('dadosConfiguracoesTef', $scope.dadosConfiguracoesTef);
        $scope.modalConfiguracaoTef = ModalService.model($scope, 'views/pdv/configuracoesTef/modalConfiguracoesTef.html', 'lg', true, 'static', true);
    };

    $scope.salvarConfiguracaoTef = function (dadosConfiguracoesTef) {
        console.log(dadosConfiguracoesTef);
        if (setupPdvService.salvarConfiguracoesTef(JSON.stringify(dadosConfiguracoesTef)) == true) {
            swal("Configuração alterada com sucesso!", "", "warning");
            $scope.desabilitarBotaoTeste = false;
            $scope.modalConfiguracaoTef.close();
        }
    };
    $scope.closeModalConfiguracoesTef = function () {
        $scope.desabilitarBotaoTeste = false;
        $scope.modalConfiguracaoTef.close();
    };
    $scope.teste = function () {
        $scope.desabilitarBotaoTeste = true;
        if (setupPdvService.teste() == true) {
            $scope.desabilitarBotaoTeste = false;
            swal("Feito!", "", "success");
        } else {
            $scope.desabilitarBotaoTeste = false;
            swal("Nada Feito!", "", "warning");
        }
    };

    $scope.MenuAdm = function () {
        $scope.desabilitarBotaoTeste = true;
        try {
            var retornoTef = setupPdvService.menuAdm()
            console.log("Retorno TEF", retornoTef);
            if (retornoTef) {
                if (retornoTef.statusTransacao == 1)// se status pendente de confirmação
                {
                    $scope.desabilitarBotaoTeste = false;
                } else {
                    $scope.desabilitarBotaoTeste = false;
                    if (retornoTef.retInt < 0) {
                        if (retornoTef.retInt == -1) {
                            swal("Módulo não inicializado!", "Cód. Retorno -1", "warning");
                        }
                        else if (retornoTef.retInt == -2) {
                            swal("Operação cancelada pelo Operador!", "Cód. Retorno -2", "warning");
                        }
                        else if (retornoTef.retInt == -5) {
                            swal(" comunicação com o SiTef!", "Cód. Retorno -5", "warning");
                        }
                        else if (retornoTef.retInt == -6) {
                            swal("Operação cancelada pelo usuário (no pinpad)!", "Cód. Retorno -6", "warning");
                        }
                        else if (retornoTef.retInt == -22) {
                            swal("Carteira Digital não habilitada!", "Cód. Retorno -22", "warning");
                        }
                        else if (retornoTef.retInt == -24) {
                            swal("Carteira Digital - Trn. nao habilitada!", "Cód. Retorno -24", "warning");
                        }
                        else if (retornoTef.retInt == -43) {
                            swal("Problema na execução de alguma das rotinas no pinpad!", "Cód. Retorno -43", "warning");
                        }
                        else if (retornoTef.retInt == -100) {
                            swal("Erro interno do módulo!", "Cód. Retorno -100", "warning");
                        }
                        else {
                            swal("Não Foi possível  concluir transação TEF!", "Cód.Retorno" + retornoTef.retInt, "warning");
                        }
                    } else {
                        swal("Não Foi possível  concluir transação TEF!", "Cód.Retorno" + retornoTef.retInt, "warning");
                    }
                }
            } else {
                swal("Não Foi possível  concluir transação TEF!", "Cód. Retorno " + retornoTef.retInt, "warning");
            }
        } catch (e) {
            $scope.desabilitarBotaoTeste = false;
            swal("Erro ao executar função!", "", "warning");
        }
    };

    $scope.TestarConexao = function () {
        $scope.desabilitarBotaoTeste = true;
        if (tefSitefAppService.abreConexaoServidorSiTef() == true) {
            $scope.desabilitarBotaoTeste = false;
            swal("Conectado!", "", "success");
        }
        else {
            $scope.desabilitarBotaoTeste = false;
            swal("Erro ao conectar servidor do TEF!", "", "warning");
        }
    };
    $scope.TestaPinpad = function () {
        $scope.desabilitarBotaoTeste = true;
        if ((tefSitefAppService.verificarPresencaPinPad()) == true) {
            $scope.desabilitarBotaoTeste = false;
            swal("PinPad Conectado!", "", "success");
        } else {
            $scope.desabilitarBotaoTeste = false;
            swal("Erro ao conectar PinPad do TEF!", "", "warning");
        }
    };
}]);
