﻿newERP.controller('AberturaChamadoController', ['$scope', 'ModalService', '$state', 'ValidarFormularioService', '$timeout', 'growlService', 'html2canvas-angular', 'hotkeys', function ($scope, ModalService, $state, ValidarFormularioService, $timeout, growlService, html2canvasAngular, hotkeys) {

    $scope.dadosTicket = {
        descricao: '',
        anexos: []
    };
    $scope.helpdesk = {
        etapaChamado: 1
    };

    $scope.removerAnexoChamado = function (indiceAnexo) {
        $scope.dadosTicket.anexos.splice(indiceAnexo, 1);
    };

    $scope.anexoAdicionado = function (b64Arquivo, nomeArquivo, tipoArquivo) {
        $scope.dadosTicket.anexos.push({
            base64: b64Arquivo,
            tipoArquivo: tipoArquivo,
            nome: nomeArquivo
        });
        var elementoDescricao = document.getElementById('descricao_chamado');
        elementoDescricao.focus();
    };

    hotkeys.bindTo($scope)
        .add({
            combo: 'ctrl+p',
            description: 'Anexar Arquivo',
            allowIn: ['INPUT'],
            callback: function () {
                $scope.capturaTelaHelpDesk();
            }
        })
        .add({
            combo: 'f12',
            description: 'Abertura de Chamado',
            allowIn: ['INPUT'],
            callback: function () {
                $scope.realizarAberturaChamado();
            }
        })
        .add({
            combo: 'f8',
            description: 'Abertura de Chamado',
            allowIn: ['INPUT'],
            callback: function () {
                $scope.close();
            }
        })

    $scope.capturaTelaHelpDesk = function () {
        var elemento = angular.element(document.getElementById('abertura-chamado'));
        elemento.hide();
        $('.modal-backdrop').fadeToggle();

        growlService.growl('Capturando tela, aguarde...', 'info');
        html2canvasAngular.renderBody().then(function (canvas) {
            elemento.show();
            $('.modal-backdrop').fadeToggle();

            var tela = canvas.toDataURL('image/jpeg', 70 / 100);

            $scope.dadosTicket.anexos.push({
                base64: tela,
                tipoArquivo: 'image/jpeg',
                nome: 'Captura de tela.jpg'
            });
        });
    };

    $scope.realizarAberturaChamado = function () {
        if (!!$scope.dadosTicket.descricao) {
            var retorno = JSON.parse(helpDeskAppService.abreChamado(JSON.stringify($scope.dadosTicket)));
            if (!!retorno) {
                $scope.helpdesk.etapaChamado = 2;
                if (retorno.chamadoAberto) {
                    $scope.helpdesk.etapaChamado = 3;
                    $scope.dadosTicket.protocolo = retorno.numeroProtocolo;
                } else {
                    swal({
                        title: "Não foi possível abrir o chamado!",
                        type: "error"
                    }, function (acao) {
                        $timeout(function () {
                            //$scope.closeModalAberturaChamado();
                        }, 50);
                    });
                }
            } else {
                swal({
                    title: "Não foi possível abrir o chamado, Verifique sua Conexão!",
                    type: "error"
                }, function (acao) {
                    $timeout(function () {
                        //$scope.closeModalAberturaChamado();
                    }, 50);
                });
            }
        } else {
            swal({
                title: "Preencha a descrição do chamado!",
                text: "Para realizar a abertura de um chamado, você deve especificar o assunto do mesmo no campo descrição",
                type: "warning"
            }, function (acao) {
                $timeout(function () {
                    var elementoDescricao = document.getElementById('descricao_chamado');
                    elementoDescricao.focus();
                }, 50);
            });
        }
    };

    $scope.closeModalAberturaChamado = function () {
        $scope.dadosTicket = {
            descricao: '',
            anexos: []
        }
        $scope.helpdesk.etapaChamado = 1;
        $scope.modalAberturaChamado.close();
    };

    $scope.IniciarDados = function () {
        $scope.InternetStatus = aplicacaoService.verificarConexao();
    };

    $scope.abrirModalChamado = function () {
        $scope.modalAberturaChamado = ModalService.model($scope, 'views/pdv/abertura-chamado/modalAberturaChamado.html', 'md', true, true, true);
    }

    $timeout(function () {
        var anexo = document.getElementById('anexo');

        var anexoInput = document.getElementById('anexoInput');
        if (!!anexo) anexo.addEventListener("drop", SelecionarAnexo, false);

        if (!!anexoInput) anexoInput.addEventListener("change", SelecionarAnexoInput, false);

        function SelecionarAnexoInput(evt) {
            var filesInput = evt.target.files || evt.dataTransfer.files;
            var arquivosValidos = ["image/gif", "image/jpeg", "image/pjpeg", "image/png", "text/plain", "application/zip", "application/pdf", "application/msword", "text/xml", ""];
            for (var x = 0; x < filesInput.length; x++) {
                (function (fileInput) {
                    if (arquivosValidos.indexOf(fileInput.type) >= 0) {
                        var readerInput = new FileReader();
                        readerInput.onload = function () {
                            $scope.anexoAdicionado(readerInput.result, fileInput.name, evt.target.files[0].type);
                            $scope.$digest();
                            $scope.$apply();
                        }
                        readerInput.readAsDataURL(fileInput);
                    }
                })(filesInput[x]);
            }
        }

        function SelecionarAnexo(e) {
            var files = e.target.files || e.dataTransfer.files;
            var arquivosValidos = ["image/gif", "image/jpeg", "image/pjpeg", "image/png", "text/plain", "application/zip", "application/pdf", "application/msword", "text/xml", ""];
            for (var i = 0; i < files.length; i++) {
                (function (file) {
                    if (arquivosValidos.indexOf(file.type) >= 0) {
                        var reader = new FileReader();
                        reader.onload = function () {
                            $scope.anexoAdicionado(readerInput.result, file.name, evt.target.files[0].type);
                            $scope.$digest();
                            $scope.$apply();
                        }
                        reader.readAsDataURL(file);
                    }
                })(files[i]);
            }
        }
    }, 100);
}]);