﻿(function () {
    'use strict';
    newERP.service('CalculaImpostoPedidoService', ['$http', '$q', 'CalculoICMSService', function ($http, $q, calculoICMS) {

        var calculaImpostoPedidoFactory = {};
        var _calculaImpostoPedidoItem = function (item) {
            var deferred = $q.defer();
            async.waterfall([
                      function (callback) {
                          if (item.cst_id == '00' || item.cst_id == '10' || item.cst_id == '20' || item.cst_id == '70') {
                              calculoICMS.calcICMS(item.pdi_valorunitario, item.pdi_qtde, 0, 0, 0, item.pdi_valordesconto, item.iod_percicmsreducaobc, item.iod_percicms).then(function (retornoICMS) {
                                  if (!!retornoICMS.error) {
                                      callback(null, 0);
                                  } else {
                                      callback(null, retornoICMS);
                                  }
                              })
                          } else {
                              callback(null, 0);
                          }
                      },
                        function (icms, callback) {
                            var dadosItem = item;
                            dadosItem.pdi_basecalculoicms = (!!icms.baseICMS == false) ? 0 : icms.baseICMS;
                            dadosItem.pdi_valoricms = (!!icms.ICMS == false) ? 0 : icms.ICMS;
                            deferred.resolve(dadosItem);
                        }
            ]);
            return deferred.promise;
        };

        var _calculaImpostoPedidoLista = function (itens) {
            var defer = $q.defer();
            var retornaItens = [];
            var i = 1;
            angular.forEach(itens, function (item) {
                _calculaImpostoPedidoItem(item)
                retornaItens.push(item);
                if (itens.length == i)
                    defer.resolve(retornaItens);
                i++;
            });
            return defer.promise;
        };



        calculaImpostoPedidoFactory.calculaImpostoPedidoItem = _calculaImpostoPedidoItem;
        calculaImpostoPedidoFactory.calculaImpostoPedidoLista = _calculaImpostoPedidoLista;

        return calculaImpostoPedidoFactory;
    }]);
})();