﻿(function () {
    'use strict';
    newERP.directive('newSelectLevel', ['$localStorage', '$http', '$timeout', '$sce', '$q', 'FuncaoService', function ($localStorage, $http, $timeout, $sce, $q, FuncaoService) {
        return {
            restrict: 'E',
            templateUrl: 'js/directives/newSelectLevel/newSelectLevel.html',
            scope: {
                placeHolder: '@placeHolder',
                apiDados: '@apiDados',
                metodoApi: '@metodoApi',
                campoCodigo: '@campoCodigo',
                campoDescricao: '@campoDescricao',
                linhasAdicionais: '@linhasAdicionais',
                parametroFiltro: '=parametroFiltro',
                novoRegistro: '=novoRegistro',
                ngModel: '=ngModel',
                comboObrigatoria: '=comboObrigatoria',
                ngChange: "&",
                nomeElemento: '@nomeElemento',
                campoNivel: '@campoNivel',
                campoPodeSelecionar: '@campoPodeSelecionar',
                campoCodigoExibir: '@campoCodigoExibir'
            },
            link: function (scope, element, attrs) {
                scope.comboAberto = false;
                scope.dadosCombo = [];
                scope.itemSelecionado = '';
                scope.textoCombo = scope.placeHolder;
                scope.comboObrigatoria = (!!scope.comboObrigatoria) ? scope.comboObrigatoria : false;
                scope.bordaVermelha = scope.comboObrigatoria;
                scope.linhaSelecionada = -1;

                scope.idInputPesquisa = (!!scope.nomeElemento) ? scope.nomeElemento : scope.campoDescricao;

                scope.retornaSemNumeros = function (campoDescricao) {
                    return campoDescricao.replace(/[^\a-z-A-Z_]+/g, '');
                };

                scope.selecionaLinha = function (linha) {
                    if (linha > scope.dadosCombo.length - 1) {
                        scope.linhaSelecionada = scope.dadosCombo.length - 1;
                    }
                    else if (linha < 0) {
                        scope.linhaSelecionada = 0;
                    }
                    else {
                        scope.linhaSelecionada = linha;
                        scope.mudaCorLinha(linha);
                    }
                }

                scope.$watch('comboObrigatoria', function (newValue, oldValue) {
                    scope.bordaVermelha = newValue;
                }, true);

                scope.$watch('itemSelecionado', function () {
                    scope.bordaVermelha = false;
                    if (scope.comboObrigatoria == true && (!!scope.itemSelecionado) == false) scope.bordaVermelha = true;
                }, true);

                scope.descricaoBotaoNovo = 'Novo Registro';
                if (!!scope.novoRegistro && !!scope.novoRegistro.nome) scope.descricaoBotaoNovo = scope.novoRegistro.nome;

                scope.abreCombo = function () {
                    scope.filtroCombo = '';
                    scope.comboAberto = !scope.comboAberto;
                    if (scope.comboAberto) angular.element('#' + scope.idInputPesquisa + '').trigger('focus');
                    $timeout(function () {
                        scope.mudaCorLinha(0);
                    }, 100);
                }

                scope.fechaCombo = function (evento) {
                    $timeout(function () {
                        if (!!scope.registroSelecionavel) {
                            if (!!evento != true) scope.comboAberto = false;
                            if (scope.comboAberto == true) {
                                $timeout(function () {
                                    scope.comboAberto = false;
                                }, 100)
                            }
                        }
                        scope.registroSelecionavel = true;
                    }, 100)
                }

                scope.naoPodeSelecionar = function () {
                    scope.registroSelecionavel = false;
                    var filtro = scope.filtroCombo;
                    angular.element('#' + scope.idInputPesquisa + '').trigger('focus');
                    $timeout(function () {
                        scope.filtroCombo = filtro;
                    }, 100)
                }

                scope.abrirTelaManutencao = function () {
                    if (!!scope.novoRegistro.pagina && !!scope.novoRegistro.formulario && !!scope.novoRegistro.model) {
                        window.localStorage.setItem('novoRegistro', JSON.stringify({
                            origem: window.location.hash,
                            destino: scope.novoRegistro.pagina,
                            formulario: scope.novoRegistro.formulario,
                            model: scope.novoRegistro.model
                        }));

                        window.location.href = scope.novoRegistro.pagina;
                    }
                }

                scope.mudaCorLinha = function (posicao, podeSelecionar) {
                    scope.linhaSelecionada = posicao;
                    angular.forEach(scope.dadosCombo, function (item) {
                        if (item.classCorLinha != 'active-result result-selected') item.classCorLinha = 'active-result';
                    })
                    if (scope.linhaSelecionada >= 0)
                        if (scope.dadosCombo.length > 0 && (!!podeSelecionar))
                            if (scope.dadosCombo[posicao].classCorLinha != 'active-result result-selected') scope.dadosCombo[posicao].classCorLinha = 'active-result highlighted';
                };

                scope.selecionaRegistro = function (posicao, item) {
                    scope.registroSelecionavel = true;
                    angular.forEach(scope.dadosCombo, function (item) {
                        item.classCorLinha = 'active-result';
                    });
                    if (!!item.codigo) {
                        scope.dadosCombo[posicao].classCorLinha = 'active-result result-selected';
                        scope.ngModel = item.objeto;
                        scope.itemSelecionado = item.descricao;
                        scope.textoCombo = (!!item.codigoExibir) ? item.codigoExibir + " " + item.descricao : item.descricao;
                        scope.comboAberto = false;

                        scope.ngChange({ model: scope.ngModel });
                    }
                    else {
                        scope.filtroCombo = '';
                    }
                };

                scope.removerSelecaoRegistro = function () {
                    angular.forEach(scope.dadosCombo, function (item) {
                        item.classCorLinha = 'active-result';
                    });
                    scope.ngModel = null;
                    scope.ngChange({ model: scope.ngModel });
                    scope.itemSelecionado = '';
                    scope.textoCombo = scope.placeHolder;
                    $timeout(function () {
                        scope.comboAberto = false;
                    });
                }

                scope.$watch('parametroFiltro', function (newValue, oldValue) {
                    if (typeof (scope.parametroFiltro) == 'object')
                        if (!!newValue.equals(oldValue) == false) {
                            scope.dadosCombo = [];
                            scope.filtroCombo = '';

                            scope.buscarDados();
                        }
                }, true)

                scope.marginLeft = function (number) {
                    return { 'margin-left': (10 * number) };
                }

                scope.estiloNaoPodeSelecionar = function (podeSelecionar) {
                    if (!!!podeSelecionar)
                        return { 'cursor': 'no-drop', 'font-weight': 'bold' };
                }

                scope.dadosCombo = [];
                scope.totalRegistros = 0;
                scope.buscarDados = function () {
                    if (!!scope.apiDados) {
                        scope.informacaoAdicional = [];
                        if (!!scope.linhasAdicionais == true) scope.informacaoAdicional = JSON.parse(scope.linhasAdicionais);

                        //scope.montarEnderecoURL();

                        scope.pagina = 1;
                        scope.paginacao = {
                            pagina: scope.pagina,
                            nroRegistros: 10
                        };


                        var metodoAppService = scope.apiDados + "." + scope.metodoApi + "(scope.pagina, scope.paginacao.nroRegistros";
                        for (var i = 0; i < scope.parametroFiltro.length; i++) {
                            if (scope.parametroFiltro[i].nome === 'filtro') {
                                metodoAppService += ", (!!scope.filtroCombo == true ? scope.filtroCombo : '')";
                            } else {
                                metodoAppService += ", (!!scope.parametroFiltro[" + i + "].nome == true ? scope.parametroFiltro[" + i + "].valor : '')";
                            }
                        }
                        metodoAppService += ")";

                        try {
                            var results = JSON.parse(eval(metodoAppService));
                        } catch (e) {
                            var results = {
                                dados: [],
                                total: 0
                            };
                        }

                        scope.dadosCombo = [];
                        scope.totalRegistros = results.total;
                        eval("if (results.dados.length > 0) {" +
                            "var i = 0;" +
                            "angular.forEach(results.dados, function (item) {" +
                            "   var _descricao = item." + scope.retornaSemNumeros(scope.campoDescricao) + ";" +
                            "   _descricao = _descricao.toUpperCase();" +
                            "   angular.forEach(scope.informacaoAdicional, function(inf) {" +
                            "       var informacao = eval('item.' + inf);" +
                            "       if (!!informacao == true) _descricao = _descricao + '<div><small>' + informacao + '</small></div>';" +
                            "   });" +
                            "   if (!!scope.filtroCombo == true) _descricao = _descricao.replace(scope.filtroCombo.toUpperCase(), '<em>' + scope.filtroCombo.toUpperCase() + '</em>');" +
                            "   if(!!scope.campoCodigoExibir) { " +
                            "       scope.dadosCombo.push( { codigo: item." + scope.campoCodigo + ", descricao: item." + scope.retornaSemNumeros(scope.campoDescricao) + ", descricaoHtml: _descricao, objeto: item, codigoExibir: item." + scope.campoCodigoExibir + ", nivel: item." + scope.campoNivel + ", podeSelecionar: item." + scope.campoPodeSelecionar + " } ); " +
                            "   } " +
                            "   else { " +
                            "       scope.dadosCombo.push( { codigo: item." + scope.campoCodigo + ", descricao: item." + scope.retornaSemNumeros(scope.campoDescricao) + ", descricaoHtml: _descricao, objeto: item, codigoExibir: null, nivel: item." + scope.campoNivel + ", podeSelecionar: item." + scope.campoPodeSelecionar + " } ); " +
                            "   } " +
                            "   i++;" +
                            "   if (i == results.dados.length) scope.mudaCorLinha(0);" +
                            "});" +
                            "} else { scope.pagina = 0; scope.dadosCombo = []; scope.dadosCombo.push( { codigo: '', descricao: '', descricaoHtml: 'Nenhum registro encontrado \"" + scope.filtroCombo + "\"', objeto: {} } ); }");
                    }
                }

                scope.numeroPagina;
                scope.buscarDadosScroll = function () {
                    var defer = $q.defer();

                    scope.pagina += 1;

                    async.waterfall([
                        function (callback) {
                            scope.numeroPagina = scope.pagina;
                            scope.paginacao = {
                                pagina: scope.numeroPagina,
                                nroRegistros: 10,
                            };

                            if (scope.totalRegistros == 0 || scope.pagina <= Math.ceil(scope.totalRegistros / 10)) {
                                var metodoAppService = scope.apiDados + "." + scope.metodoApi + "(scope.pagina, scope.paginacao.nroRegistros, scope.paginacao.ordem";
                                for (var i = 0; i < scope.parametroFiltro.length; i++) {
                                    if (scope.parametroFiltro[i].nome === 'filtro') {
                                        metodoAppService += ", (!!scope.filtroCombo == true ? scope.filtroCombo : '')";
                                    } else {
                                        metodoAppService += ", (!!scope.parametroFiltro[" + i + "].nome == true ? scope.parametroFiltro[" + i + "].valor : '')";
                                    }
                                }
                                metodoAppService += ")";

                                var dadosRetorno = JSON.parse(eval(metodoAppService));

                                scope.totalRegistros = dadosRetorno.total;
                                eval("if (http.data.dados.length > 0) {" +
                                    " callback(null, scope.numeroPagina); " +
                                    " var i = 0; " +
                                    " angular.forEach(http.data.dados, function (item) { " +
                                    "   var _descricao = item." + scope.retornaSemNumeros(scope.campoDescricao) + "; " +
                                    "   _descricao = _descricao.toUpperCase(); " +
                                    "   angular.forEach(scope.informacaoAdicional, function(inf) { " +
                                    "       var informacao = eval('item.' + inf); " +
                                    "       if (!!informacao == true) _descricao = _descricao + '<div><small>' + informacao + '</small></div>'; " +
                                    "   }); " +
                                    "   if (!!scope.filtroCombo == true) _descricao = _descricao.replace(scope.filtroCombo.toUpperCase(), '<em>' + scope.filtroCombo.toUpperCase() + '</em>'); " +
                                    "   if(!!scope.campoCodigoExibir) { " +
                                    "       scope.dadosCombo.push( { codigo: item." + scope.campoCodigo + ", descricao: item." + scope.retornaSemNumeros(scope.campoDescricao) + ", descricaoHtml: _descricao, objeto: item, codigoExibir: item." + scope.campoCodigoExibir + ", nivel: item." + scope.campoNivel + ", podeSelecionar: item." + scope.campoPodeSelecionar + " } ); " +
                                    "   } " +
                                    "   else { " +
                                    "       scope.dadosCombo.push( { codigo: item." + scope.campoCodigo + ", descricao: item." + scope.retornaSemNumeros(scope.campoDescricao) + ", descricaoHtml: _descricao, objeto: item, codigoExibir: null, nivel: item." + scope.campoNivel + ", podeSelecionar: item." + scope.campoPodeSelecionar + " } ); " +
                                    "   } " +
                                    " }); " +
                                    " } else { callback(null, null); scope.pagina = 1; scope.dadosCombo = []; scope.dadosCombo.push( { codigo: '', descricao: '', descricaoHtml: 'Nenhum registro encontrado \"" + scope.filtroCombo + "\"', objeto: {} } ); } ");
                            } else {
                                callback(null, null);
                            }
                        },
                        function (nPagina, callback) {
                            if (!!nPagina) scope.numeroPagina = nPagina;
                            defer.resolve({ dadosCombo: scope.dadosCombo.length, total: scope.totalRegistros });
                        }
                    ])

                    return defer.promise;
                }

                scope.transformaHtml = function (dadosHtml) {
                    return $sce.trustAsHtml(dadosHtml);
                }

                scope.$watch('filtroCombo', function (newValue, oldValue) {
                    if (!!newValue) {
                        FuncaoService.delay(function () {
                            scope.refazerBusca();
                        }, 500);
                    } else {
                        scope.refazerBusca();
                    }
                }, true);

                scope.refazerBusca = function () {
                    scope.dadosCombo = [];
                    scope.pagina = 0;
                    scope.totalRegistros = 0;

                    scope.buscarDados();
                }

                scope.$watch('ngModel', function (newValue, oldValue) {
                    if (!!newValue) {
                        if (!!eval("newValue." + scope.retornaSemNumeros(scope.campoDescricao) + "")) {
                            scope.ngModel = newValue;
                            scope.itemSelecionado = eval("newValue." + scope.retornaSemNumeros(scope.campoDescricao) + "");
                            var codigo = eval("newValue." + scope.campoCodigoExibir + "");
                            var descricao = eval("newValue." + scope.retornaSemNumeros(scope.campoDescricao) + "");
                            scope.textoCombo = ((!!codigo) ? codigo : "") + " " + descricao;
                            scope.comboAberto = false;
                        }
                    } else {
                        scope.itemSelecionado = false;
                        scope.textoCombo = scope.placeHolder;
                        if (scope.linhaSelecionada >= 0) scope.dadosCombo[scope.linhaSelecionada].classCorLinha = 'active-result';
                    }
                }, true);
            }
        }
    }]);
})();