﻿(function () {
    'use strict';
    newERP.directive('arquivoDragDrop', function ($parse) {
        return {
            restrict: 'A',
            scope: {
                arquivo: '=',
                nomeArquivo: '=',
                mimeType: '=',
                executarFuncao:'&'
            },
            link: function (scope, element, attrs) {
                var checkSize, isTypeValid, processDragOverOrEnter, validMimeTypes;
                processDragOverOrEnter = function (event) {
                    if (event != null) {
                        event.preventDefault();
                    }
                    event.originalEvent.dataTransfer.effectAllowed = 'copy';
                    return false;
                };
                validMimeTypes = attrs.arquivoDragDrop;

                checkSize = function (size) {
                    var _ref;
                    if (((_ref = attrs.maxFileSize) === (void 0) || _ref === '') || (size / 1024) / 1024 < attrs.maxFileSize) {
                        return true;
                    } else {
                        alert("O arquivo deve conter no máximo " + attrs.maxFileSize + " MB");
                        return false;
                    }
                };
                isTypeValid = function (type) {
                    if ((validMimeTypes === (void 0) || validMimeTypes === '') || validMimeTypes.indexOf(type) > -1) {
                        return true;
                    } else {
                        alert("Tipo de arquivo inválido.  O arquivo deve ser: " + validMimeTypes);
                        return false;
                    }
                };
                element.bind('dragover', processDragOverOrEnter);
                element.bind('dragenter', processDragOverOrEnter);
                return element.bind('drop', function (event) {
                    var file, name, reader, size, type;
                    if (event != null) {
                        event.preventDefault();
                    }
                    reader = new FileReader();
                    reader.onload = function (evt) {
                        if (checkSize(size) && isTypeValid(type)) {
                            return scope.$apply(function () {
                                scope.arquivo = evt.target.result;
                                scope.mimeType = type;
                                if (angular.isString(scope.nomeArquivo)) {
                                    return scope.nomeArquivo = name;
                                }
                                var expressionHandler = scope.executarFuncao();
                                if (!!expressionHandler) {
                                    expressionHandler(evt.target.result, name, type);
                                }
                            });
                        }
                    };
                    file = event.originalEvent.dataTransfer.files[0];
                    name = file.name;
                    type = file.type;
                    size = file.size;
                    reader.readAsDataURL(file);
                    return false;
                });
            }
        };
    });
})();