﻿(function () {
    'use strict';
    newERP.controller('VendaCondicionalController', ['$scope', 'ModalService', '$timeout', 'ValidarFormularioService', 'DadosFormularioService', '$state', 'FuncaoService', '$localStorage', 'growlService', function ($scope, ModalService, $timeout, ValidarFormularioService, DadosFormularioService, $state, FuncaoService, $localStorage, growlService) {

        $scope.parametrosLocal = parametrosLocalAppService.retornaDadosParametrosLocal();

        $scope.dadosVendaCondicional = {
            Id: null,
            listaProdutos: []
        };

        var impressaoComprovantes = {
            Imprimir: 0,
            PerguntarAoUsuario: 1,
            NaoImprimir: 2
        };

        var tipoControleEstoque = {
            avisar: 0,
            avisaPedirSenha: 1,
            bloquear: 2,
        };

        var enums = {
            adicionarItem: '+',
            removerItem: '-'
        };

        $scope.contatosCliente = {
            telefones: [],
            emails: null,
            enderecos: []
        };

        $scope.model = {
            tipoSolicitacao: 0,
            listaProdutos: [],
            dadosDaVendaCondicional: {},
            listaItensComGrade: [],
            senhaGerencial: ''
        };

        var tipoSolicitacao = {
            parcelasAtrazadas: 1,
            limiteCredito: 2,
            somenteAvista: 3,
            estoqueGrade: 4,
            estoque: 5,
        }

        $scope.salvandoCondicional = false;

        $scope.mostrarCampoParaLerCodigoDeBarras = false;
        $scope.solicitarSenhaGerencial = false;
        $scope.sequenciaItem = 1;
        $scope.descricaoBotaoItemCondicional = 'Adicionar Item';
        $scope.listaVendaSituacao = JSON.parse(enumAppService.listaEnum("VendaCondicionalSituacao"));

        var jaAbriuModalGradeProduto = false;
        var situacaoCondicional = { Pendente: 0, EntregueAoCliente: 1, RetornoComVenda: 2, RetornoSemVenda: 3 };

        $scope.filtro = {
            pesquisa: '',
            dias: 14,
            dataInicialSlider: new Date(),
            dataInicial: new Date(),
            dataFinal: new Date(),
            cliente: { Id: null },
            vendedor: { ven_id: null },
            dataRetorno: null,
            situacaoCondicional: [],
            ean: ''
        };

        $scope.abasListaVendaCondicional = [
            {
                titulo: 'Condicional Retirado na Loja',
                pagina: 'views/pdv/varejo/venda_condicional/listarRetiradoLoja.html',
                filtroSituacao: false,
                quantidade: 0
            },
            {
                titulo: 'Condicional Entregue ao Cliente',
                pagina: 'views/pdv/varejo/venda_condicional/listarEntregaCliente.html',
                filtroSituacao: true,
                quantidade: 0
            }
        ];

        $scope.abasListaVendaCondicionalContatos = [
            {
                titulo: 'Telefones',
                pagina: 'views/pdv/varejo/venda_condicional/listarTelefone.html'
            },
            {
                titulo: 'E-mails',
                pagina: 'views/pdv/varejo/venda_condicional/listarEmail.html'
            },
            {
                titulo: 'Endereços',
                pagina: 'views/pdv/varejo/venda_condicional/listarEnderecos.html'
            }
        ];

        $scope.ContatosCliente = function (codigoCliente, codigoPessoa) {
            $scope.contatosCliente.telefones = JSON.parse(clienteAppService.buscaTelefoneCliente(codigoCliente, codigoPessoa, null));
            $scope.contatosCliente.emails = JSON.parse(clienteAppService.buscarEmailCliente(codigoCliente));
            $scope.contatosCliente.enderecos = JSON.parse(clienteAppService.buscaEnderecoCliente(codigoCliente, codigoPessoa));
            $scope.modalTelefone = ModalService.model($scope, 'views/pdv/varejo/venda_condicional/modalContatoCliente.html', 'lg', true, true, true);
        };

        $scope.listarVendas = function (filtro, dataInicial) {
            $scope.listaVendasCondicional = [];
            $scope.listaVendasCondicional = JSON.parse(vendaCondicionalAppService.listarTodos(filtro, dataInicial));
            $scope.abasListaVendaCondicional[0].quantidade = 0;
            $scope.abasListaVendaCondicional[1].quantidade = 0;
            angular.forEach($scope.listaVendasCondicional, function (dado) {
                if (!dado.vnc_levarparacliente) {
                    $scope.abasListaVendaCondicional[0].quantidade++;
                } else {
                    $scope.abasListaVendaCondicional[1].quantidade++;
                }
            });
        };

        $scope.$watch('filtro.dias', function (dia) {
            $scope.filtro.dataInicialSlider = FuncaoService.subtrairDias(new Date(), 14 - dia);
            $scope.listarVendas(null, $scope.filtro.dataInicialSlider);
        });

        $scope.mudouAba = function (abaSelecionada) {
            $scope.model.mostrarFiltroSituacao = abaSelecionada.filtroSituacao
        };

        $scope.exibicaoProduto = 'f-25 fa-barcode';

        $scope.modoExibirPesquisaProduto = function (exibicaoProduto) {
            if (!!exibicaoProduto) {
                $scope.exibicaoProduto = (exibicaoProduto === 'f-25 fa-barcode') ? 'f-18 fa-search' : 'f-25 fa-barcode';
                $localStorage.exibicaoProduto = [{ 'modoExibir': $scope.exibicaoProduto }];
            } else {
                if (!!$localStorage.exibicaoProduto) {
                    $scope.exibicaoProduto = $localStorage.exibicaoProduto[0].modoExibir;
                } else {
                    $scope.exibicaoProduto = 'f-25 fa-barcode';
                    $localStorage.exibicaoProduto = [{ 'modoExibir': $scope.exibicaoProduto }];
                }
            }
            if ($scope.exibicaoProduto === 'f-25 fa-barcode') {
                $scope.setarFocus('pro_descricao');
            } else {
                $scope.setarFocus('pro_codigo');
            }
        };

        $scope.ListaItensVenda = function (dadosVenda) {
            $scope.modalItensCondicional = ModalService.model($scope, 'views/pdv/varejo/venda_condicional/modalQuantidadeItens.html', 'lg', true, true, true);
            $scope.listarDadosModalQuantidadeItens(dadosVenda);
        };

        $scope.devolverProdutoVenda = function (dadosProduto, quantidade) {
            var resultadoDevolucao = JSON.parse(vendaCondicionalItemAppService.devolverItem(dadosProduto.Id, quantidade));
            if (resultadoDevolucao) {
                swal('Item devolvido com Sucesso!', "", "success");
                $scope.modalRetorno.close();
            }
        };

        $scope.abrirModalDevolverProduto = function (posicao, dadosProduto) {
            $scope.dadosProduto = dadosProduto;
            $scope.modalRetorno = ModalService.model($scope, 'views/pdv/varejo/venda_condicional/manutencaoVendaCondicionalRetorno.html', 'md', true, true, true);
        };

        $scope.listarDadosModalQuantidadeItens = function (dadosVenda) {
            dadosVenda.produto = JSON.parse(vendaCondicionalItemAppService.buscar(dadosVenda.vnc_id));
            dadosVenda.cliente = JSON.parse(clienteAppService.buscar(dadosVenda.cli_id));
            dadosVenda.vendedor = JSON.parse(vendedorAppService.buscar(dadosVenda.ven_id));
            $scope.modalVendaCondicional = dadosVenda;
        };

        $scope.atualizaDadosVendaCondicional = function () {
            vendaCondicionalAppService.atualizaDadosCondicional();
            console.log("Busca Novos Condis");
        };

        $scope.iniciarDadosListaVendaCondicional = function () {

            $scope.listarVendas(null, new Date());
        };

        $scope.buscarGradesProduto = function (dadosProduto) {
            if ($scope.exibicaoProduto === 'f-18 fa-search') {
                if (!(!!!dadosProduto.prg_id)) {
                    $scope.listaGrades = JSON.parse(produtoAppService.listaGradesProduto(dadosProduto.pro_id, dadosProduto.prg_id));
                    angular.forEach($scope.listaGrades, function (item) {
                        dadosProduto.vci_valorun = item.valorVenda;
                        dadosProduto.vci_quantidade = 1;
                        dadosProduto.prg_id = item.prg_id;
                        dadosProduto.grade = ""
                        dadosProduto.valorTotal = dadosProduto.vci_quantidade * item.valorVenda;
                        for (var i = 0; i < item.atributos.length; i++) {
                            dadosProduto.grade += item.atributos[i].mgp_descricao;
                            if (i < item.atributos.length - 1) {
                                dadosProduto.grade += " | "
                            }
                        }
                        $scope.dadosVendaCondicional.produto = dadosProduto;
                        $scope.verificarEstoqueProdutoEAdicionaProduto();
                    })
                }
            } else {
                var unidadeMedida = JSON.parse(unidadeMedidaAppService.retornaCasasDecimais(dadosProduto.ump_id));
                dadosProduto.ump_casasdecimais = unidadeMedida;
                $scope.listaGrades = JSON.parse(produtoAppService.listaGradesProduto(dadosProduto.pro_id, null));
                if ($scope.listaGrades.length > 0) {
                    $scope.abrirModalGradesVendas(dadosProduto);
                }
            }
        };

        $scope.abrirModalGradesVendas = function (dadosProduto) {
            if (!!$scope.modalGradesVendas) {
                $scope.modalGradesVendas.dismiss();
                delete $scope.modalGradesVendas;
                delete $scope.dadosProduto;
            }
            $scope.dadosProduto = dadosProduto;
            $scope.modalGradesVendas = ModalService.model($scope, 'views/pdv/varejo/modalProdutosGradesVendas.html', 'lg', true, 'static', false);
            jaAbriuModalGradeProduto = true;
        };

        $scope.manutencaoQuantidadeModalGrades = function (posicao, operacao) {
            if (operacao == "+") {
                if ($scope.listaGrades[posicao].valorVenda > 0) {
                    $scope.listaGrades[posicao].prg_quantidade += 1;
                } else {
                    swal("Não sera possivel adicionar o item, pois o valor não foi informado!", "", "warning");
                }
            } else if (operacao == "-") {
                if ($scope.listaGrades[posicao].prg_quantidade == 0) {
                    $scope.listaGrades[posicao].prg_quantidade = 0;
                } else {
                    $scope.listaGrades[posicao].prg_quantidade -= 1;
                }
            }
        };

        $scope.selecionarGrades = function () {
            var informouGrade = false;
            var listaItensComGrade = [];
            angular.forEach($scope.listaGrades, function (item) {
                if (item.prg_quantidade > 0) {
                    var dadosProduto = angular.copy($scope.dadosProduto);
                    informouGrade = true;
                    dadosProduto.prg_ean = item.ean;
                    dadosProduto.vci_valorun = item.valorVenda;
                    dadosProduto.vci_quantidade = item.prg_quantidade;
                    dadosProduto.prg_id = item.prg_id;
                    dadosProduto.grade = "";
                    dadosProduto.valorTotal = item.prg_quantidade * item.valorVenda;
                    for (var i = 0; i < item.atributos.length; i++) {
                        dadosProduto.grade += item.atributos[i].mgp_descricao;
                        if (i < item.atributos.length - 1) {
                            dadosProduto.grade += " | "
                        }
                    }
                    listaItensComGrade.push(dadosProduto);
                    console.log('Itens de grade', listaItensComGrade);
                }
            })

            $scope.verificaEstoqueItensGrade(listaItensComGrade);

            if (!!$scope.modalGradesVendas) {
                $timeout(function () {
                    if (!!informouGrade) {
                        $scope.modalGradesVendas.dismiss();
                        delete $scope.modalGradesVendas;
                        jaAbriuModalGradeProduto = false;
                    } else {
                        swal("Informe a quantidade em pelo menos um item da grade!", "", "warning");
                    }
                }, 100)
            }
        };

        $scope.verificaEstoqueItensGrade = function (listaItensComGrade) {
            var possuiItensComEstoqueInvalido = false;
            if ($scope.parametrosLocal != null) {
                if ($scope.parametrosLocal.par_avisoestoqueinsuficiente != null) {
                    if (navigator.onLine) {
                        for (let i = 0; i < listaItensComGrade.length; i++) {
                            var item = listaItensComGrade[i];
                            var qtdeItemLancado = $scope.retornaQuantidadeItemLancado(item.pro_id, item.prg_id);
                            var retornoEstoque = JSON.parse(estoqueAppService.buscarEstoqueProdutoUnicoApi(item.pro_id, item.prg_id));
                            if (retornoEstoque == null) {
                                retornoEstoque = { valorTotal: 0 };
                            }
                            var quantidadeControleEstoque = (retornoEstoque.valorTotal - (item.vci_quantidade + qtdeItemLancado));

                            if (retornoEstoque != null && quantidadeControleEstoque < 0) {
                                possuiItensComEstoqueInvalido = true;
                                break;  // Sai do loop antecipadamente
                            }
                        }

                        if (possuiItensComEstoqueInvalido == true) {
                            if ($scope.parametrosLocal.par_avisoestoqueinsuficiente == tipoControleEstoque.avisar) {
                                swal({
                                    title: 'Atenção Sistema de Controle de Estoque!',
                                    text: "Este produto está com estoque insuficiente (Estoque: " + quantidadeControleEstoque + "). Deseja continuar?",
                                    type: "warning",
                                    showCancelButton: false,
                                    confirmButtonText: "Sim, quero Continuar!"
                                }, function (acao) {
                                    if (acao) {
                                        $scope.adicionarItensComGrade(listaItensComGrade);
                                    }
                                });
                            } else if ($scope.parametrosLocal.par_avisoestoqueinsuficiente == tipoControleEstoque.avisaPedirSenha) {
                                swal({
                                    title: 'Atenção Sistema de Controle de Estoque!',
                                    text: "Este produto está com estoque insuficiente (Estoque: " + quantidadeControleEstoque + "). Deseja continuar? Será solicitado uma senha Gerencial!",
                                    type: "warning",
                                    showCancelButton: true,
                                    cancelButtonText: "Não",
                                    confirmButtonClass: "btn-danger",
                                    confirmButtonText: "Sim, quero Continuar!",
                                    allowOutsideClick: false
                                }, function (acao) {
                                    if (acao) {
                                        $timeout(function () {
                                            $scope.model.tipoSolicitacao = tipoSolicitacao.estoqueGrade;
                                            $scope.model.listaItensComGrade = listaItensComGrade;
                                            var retorno = $scope.verificaSenhaGerencial();
                                        }, 100);
                                    } else {
                                        $timeout(function () {
                                            $scope.cancelaManutencaoItem();
                                        });
                                    }
                                });
                            } else if ($scope.parametrosLocal.par_avisoestoqueinsuficiente == tipoControleEstoque.bloquear) {
                                swal("Atenção Sistema de Controle de Estoque!", "Produto com estoque " + quantidadeControleEstoque + ", sistema está configurado para bloquear vendas de produtos sem estoque !", "warning");
                                $scope.cancelaManutencaoItem();
                            }
                        } else {
                            $scope.adicionarItensComGrade(listaItensComGrade);
                        }
                    } else {
                        $scope.adicionarItensComGrade(listaItensComGrade);
                    }
                } else {
                    $scope.adicionarItensComGrade(listaItensComGrade);
                }
            } else {
                $scope.adicionarItensComGrade(listaItensComGrade);
            }
        }

        $scope.adicionarItensComGrade = function (listaItensComGrade) {
            angular.forEach(listaItensComGrade, function (item) {
                $scope.salvarProdutoVendaCondicional(angular.copy(item));
            })
        }

        $scope.cancelarModalGrade = function () {
            $scope.modalGradesVendas.dismiss();
            delete $scope.modalGradesVendas;
            jaAbriuModalGradeProduto = false;
            $scope.dadosVendaCondicional.produto = null;
        };

        $scope.buscarListaPrecoProduto = function (codigoProduto, codigoCliente, codigoVendedor) {
            codigoProduto = (!!codigoProduto == true) ? codigoProduto : null;
            codigoCliente = (!!codigoCliente == true) ? codigoCliente : null;
            codigoVendedor = (!!codigoVendedor == true) ? codigoVendedor : null;
            $scope.listaPrecos = JSON.parse(produtoAppService.listaPrecoProduto(codigoProduto, null, codigoCliente, codigoVendedor));
        };

        $scope.carregaPreco = function (preco) {
            if (!!preco) {
                $scope.dadosVendaCondicional.produto.quantidade = 1;
                $scope.dadosVendaCondicional.produto.vci_valorun = preco.lpi_valorvenda;
                $scope.dadosVendaCondicional.produto.valorTotal = $scope.dadosVendaCondicional.produto.vci_valorun * $scope.dadosVendaCondicional.produto.quantidade;
            }
        };

        function pad2(n) { return n < 10 ? '0' + n : n }

        $scope.abrirManutencaoVendaCondicional = function (dadosVendaCondicional) {
            console.log("$scope.abrirManutencaoVendaCondicional", dadosVendaCondicional)
            if (dadosVendaCondicional !== null) {
                if (dadosVendaCondicional.vnc_id) {
                    if (dadosVendaCondicional.quantidadeItens === 0) {
                        swal("Não foi possível encontrar os itens do condicional, por favor atualize dados locais e tente novamente!", "", "warning");
                    } else {
                        DadosFormularioService.armazenarDados('vendacondicional-manutencao', dadosVendaCondicional);
                        $state.go('newpdv.vendacondicional-manutencao');
                    }
                } else {
                    swal("Condicional ainda não foi sincronizado, não será possível edita-lo!", "", "warning");
                }
            } else {
                var objPedido = DadosFormularioService.retornaDados('vendacondicional-manutencao', { Id: null }).dados;
                DadosFormularioService.armazenarDados('vendacondicional-manutencao', objPedido);
                $state.go('newpdv.vendacondicional-manutencao');
            }
        };

        $scope.imprimirCondicional = function (dadosVendaCodicional) {
            if (!!dadosVendaCodicional) {
                $scope.parametrosEmpresa = parametrosEmpresaAppService.retornaDadosParametrosEmpresa();
                if ($scope.parametrosEmpresa == null || $scope.parametrosEmpresa.par_impressaocondicional == null) {
                    vendaCondicionalAppService.imprimir((dadosVendaCodicional.Id).toString());
                } else {
                    if ($scope.parametrosEmpresa.par_impressaocondicional == impressaoComprovantes.Imprimir) {
                        vendaCondicionalAppService.imprimir((dadosVendaCodicional.Id).toString());
                    } else if ($scope.parametrosEmpresa.par_impressaocondicional == impressaoComprovantes.PerguntarAoUsuario) {
                        swal({
                            title: "Deseja realizar a impressão do comprovante desta condicional??",
                            text: "Imprimir Comprovante?",
                            type: "warning",
                            showCancelButton: true,
                            cancelButtonText: "Sim",
                            cancelButtonClass: "btn-success",
                            confirmButtonText: "Não",
                            confirmButtonClass: "btn-default",
                        }, function (isConfirm) {
                            if (isConfirm) {
                                $timeout(function () {
                                    swal.close(); // Fecha o swal manualmente

                                });
                            } else {
                                $timeout(function () {
                                    swal.close(); // Fecha o swal manualmente
                                    try {
                                        vendaCondicionalAppService.imprimir((dadosVendaCodicional.Id).toString());
                                    } catch (e) {
                                        swal("Erro na Impressão!", "Ops", "warning");
                                        console.log(e);
                                    }
                                });
                            }
                        });
                    } else {
                        vendaCondicionalAppService.imprimir((dadosVendaCodicional.Id).toString());
                    }
                }
            }
        };

        $scope.atualizarConformeApi = function (dadosVendaCodicional) {
            if (!!dadosVendaCodicional.vnc_id) {
                var ret = vendaCondicionalAppService.atualizaDadosCondicionalConformeApi(dadosVendaCodicional.vnc_id);
                if (ret) {
                    swal("Condicional atualizado!", "", "success");
                    $scope.listarVendas(null, new Date());
                } else {
                    swal("Problemas ao atualizar condicional!", "", "warning");
                }
            } else {
                swal("Condicional ainda não foi sincronizado, não é possível atualiza-lo!", "", "warning");
            }
        }

        $scope.lerDadosManutencao = function () {
            console.log("$scope.lerDadosManutencao")
            var dados = DadosFormularioService.retornaDados('vendacondicional-manutencao', { Id: null }).dados;
            $scope.dadosVendaCondicional = dados;
            if (!!dados.Id) {
                $scope.dadosVendaCondicional.cliente = JSON.parse(clienteAppService.buscar(dados.ClienteId, dados.cli_id));
                $scope.listaEnderecos = JSON.parse(clienteAppService.buscaEnderecoCliente(dados.ClienteId, dados.cliente.pes_id));
                $scope.dadosVendaCondicional.clitelefone = $scope.dadosVendaCondicional.vnc_telefonecliente;
                $scope.dadosVendaCondicional.vendedor = JSON.parse(vendedorAppService.buscar(dados.ven_id));
                $scope.model.listaProdutos = JSON.parse(vendaCondicionalItemAppService.buscar(dados.vnc_id));
                $scope.dadosVendaCondicional.valorTotalItemVendaCondicional = dados.valorTotal;

                $scope.quantidadeTotalItensRetorno = 0;
                $scope.quantidadeItensDevolvidos = 0;

                $scope.model.listaProdutos.sort(function (a, b) {
                    return a.vci_sequencia - b.vci_sequencia;
                });

                // Percorre a lista e atribui sequências condicionalmente
                $scope.model.listaProdutos.forEach(function (item) {
                    if (item.vci_devolvido) {
                        $scope.quantidadeItensDevolvidos += item.vci_devolvido;
                    }
                    $scope.quantidadeTotalItensRetorno += item.vci_quantidade;

                    $scope.sequenciaItem = item.vci_sequencia;
                });

                $scope.sequenciaItem++;

                $scope.calcularValorTotalItens();
                if (dados.vnc_levarparacliente) {
                    if (!!$scope.dadosVendaCondicional.vnc_enderecoentrega) {
                        var endereco = $scope.dadosVendaCondicional.vnc_enderecoentrega;
                        endereco = endereco.split(",", 1);
                        $scope.dadosVendaCondicional.vnc_enderecoentrega = [{
                            pee_endereco: endereco[0]
                        }][0];
                    } else {
                        $scope.dadosVendaCondicional.vnc_enderecoentrega = null;
                    }
                }
            } else {

                if ($scope.dadosVendaCondicional != "") {
                    $scope.buscarVendedorVinculadoUsuario();
                }

                var parEmpresa = parametrosEmpresaAppService.retornaDadosParametrosEmpresa();
                var dataRetorno = new Date();

                if (parEmpresa.par_diasretornocondicional) {
                    var dataRet = new Date();
                    dataRetorno.setDate(dataRetorno.getDate() + parEmpresa.par_diasretornocondicional);
                    var diaAtual = dataRet.getDay()
                    if (diaAtual === 6) { //sabado
                        dataRetorno.setDate(dataRetorno.getDate() + 2);
                    } else {
                        if (diaAtual === 7) {
                            dataRetorno.setDate(dataRetorno.getDate() + 1);
                        };
                    };
                } else {
                    var diaAtual = dataRetorno.getDay();
                    if (diaAtual === 6) { //sabado
                        dataRetorno.setDate(dataRetorno.getDate() + 2);
                    } else {
                        dataRetorno.setDate(dataRetorno.getDate() + 1);
                    };

                };
                if ($scope.dadosVendaCondicional != "") {
                    $scope.dadosVendaCondicional.vnc_prazoretorno = dataRetorno;
                } else {
                    $scope.dadosVendaCondicional = {
                        vnc_prazoretorno: dataRetorno,
                        vendedor: JSON.parse(vendedorAppService.buscarVendedorVinculadoAoUsuario())
                    }
                };

            };
            $scope.calcularValorTotalItens();
            console.log("$scope.lerDadosManutencao ITENS", $scope.model.listaProdutos)
        };

        $scope.listarTelefone = function (cliente) {
            $scope.listaTelefone = JSON.parse(clienteAppService.buscaTelefoneCliente(cliente.Id, cliente.pes_id));
            if ($scope.listaTelefone.length === 0) {
                $scope.dadosVendaCondicional.clitelefone = null;
            } else if ($scope.listaTelefone.length >= 1) {
                for (var i = 0; i < $scope.listaTelefone.length; i++) {
                    if ($scope.listaTelefone[i].psc_principal) {
                        $scope.dadosVendaCondicional.clitelefone = $scope.listaTelefone[i].psc_numero;
                    } else {
                        $scope.dadosVendaCondicional.clitelefone = $scope.listaTelefone[i].psc_numero;
                        break;
                    }
                }
            }
        };

        $scope.buscarInformacoesCliente = function (dadosCliente) {
            $scope.listarEnderecos(dadosCliente.Id);
            $scope.listarTelefone(dadosCliente.Id);
        };

        $scope.listarEnderecos = function (cliente) {
            $scope.listaEnderecos = JSON.parse(clienteAppService.buscaEnderecoCliente(cliente.Id, cliente.pes_id));
            if ($scope.listaEnderecos.length === 1) {
                $scope.dadosVendaCondicional.vnc_enderecoentrega = $scope.listaEnderecos[0];
            }
        };


        $scope.buscaDadosProduto = function (dadosProduto) {
            /*PELO CODIGO DE BARRAS*/
            if ($scope.exibicaoProduto === 'f-18 fa-search') {
                if (!!dadosProduto.pro_id) {
                    var produto = JSON.parse(produtoAppService.listarProdutoCodigo(dadosProduto.pro_id.toString()));
                    if (produto != null) {
                        $scope.dadosVendaCondicional.produto = produto;
                        $scope.dadosVendaCondicional.produto.vci_quantidade = 1;
                        $scope.dadosVendaCondicional.produto.vci_valorun = produto.lpi_valorvenda;
                        $scope.calcularTotalItem();

                        $scope.dadosVendaCondicional.produto.ump_casasdecimais = produto.ump_casasdecimais;

                        var codigoCliente = (!!$scope.dadosVendaCondicional.cliente == true) ? $scope.dadosVendaCondicional.cliente.Id : null;
                        var codigoVendedor = (!!$scope.dadosVendaCondicional.vendedor == true) ? $scope.dadosVendaCondicional.vendedor.ven_id : null;

                        $scope.verificarEstoqueProdutoEAdicionaProduto();
                    }
                    else {
                        $timeout(function () {
                            swal("Produto Não Encontrado!", "", "warning");
                        })
                    }
                }
                /* PELA PESQUISA DO PRODUTO */
            } else {

                $scope.dadosVendaCondicional.produto.vci_quantidade = 1;
                $scope.dadosVendaCondicional.produto.vci_valorun = JSON.parse(produtoAppService.retornaPrecoPadraoProduto(dadosProduto.pro_id, dadosProduto.prg_id));
                $scope.calcularTotalItem();

                if (!!!jaAbriuModalGradeProduto)
                    $scope.buscarGradesProduto(dadosProduto);

                var codigoCliente = (!!$scope.dadosVendaCondicional.cliente == true) ? $scope.dadosVendaCondicional.cliente.Id : null;
                var codigoVendedor = (!!$scope.dadosVendaCondicional.vendedor == true) ? $scope.dadosVendaCondicional.vendedor.ven_id : null;
                $scope.buscarListaPrecoProduto(dadosProduto.pro_id, codigoCliente, codigoVendedor);
            }
        };

        $scope.carregaDadosProdutoCodigo = function (codigoProduto) {
            if (!!codigoProduto) {
                var produto = JSON.parse(produtoAppService.listarProdutoCodigo(codigoProduto.toString()));
                if (produto != null) {
                    $scope.dadosVendaCondicional.produto = produto;
                    $scope.dadosVendaCondicional.produto.vci_quantidade = 1;
                    $scope.dadosVendaCondicional.produto.vci_valorun = produto.lpi_valorvenda;

                    if ($scope.dadosVendaCondicional.produto.vci_valorun == 0) {
                        swal("Valor do Produto não encontrado!", " Certifique-se de que o mesmo tenha valor definido no cadastro de produto, se for necessário faça o download dos dados para atualizar as informações dos produtos", "warning");
                    } else {
                        $scope.calcularTotalItem();
                        $scope.dadosVendaCondicional.produto.ump_casasdecimais = produto.ump_casasdecimais;
                        $scope.codigoProduto = null;
                        $scope.verificarEstoqueProdutoEAdicionaProduto();
                    }
                }
                else {
                    $timeout(function () {
                        swal("Produto Não Encontrado!", "", "warning");
                    })
                }
            }
        };

        $scope.retornaQuantidadeItemLancado = function (pro_id, prg_id = null) {
            let quantidadeTotal = 0;

            $scope.model.listaProdutos.forEach(item => {
                if (item.pro_id === pro_id && (prg_id === null || item.prg_id === prg_id)) {
                    quantidadeTotal += item.vci_quantidade;
                }
            });

            return quantidadeTotal;
        };

        $scope.verificarEstoqueProdutoEAdicionaProduto = function () {
            if ($scope.parametrosLocal != null) {
                if ($scope.parametrosLocal.par_avisoestoqueinsuficiente != null) {
                    if (navigator.onLine) {
                        var qtdeItemLancado = $scope.retornaQuantidadeItemLancado($scope.dadosVendaCondicional.produto.pro_id, $scope.dadosVendaCondicional.produto.prg_id);
                        var retornoEstoque = JSON.parse(estoqueAppService.buscarEstoqueProdutoUnicoApi($scope.dadosVendaCondicional.produto.pro_id, $scope.dadosVendaCondicional.produto.prg_id));
                        if (retornoEstoque == null) {
                            retornoEstoque = { valorTotal: 0 };
                        }
                        var quantidadeControleEstoque = (retornoEstoque.valorTotal - ($scope.dadosVendaCondicional.produto.vci_quantidade + qtdeItemLancado));
                        if (retornoEstoque != null && quantidadeControleEstoque < 0) {
                            if ($scope.parametrosLocal.par_avisoestoqueinsuficiente == tipoControleEstoque.avisar) {
                                swal({
                                    title: 'Atenção Sistema de Controle de Estoque!',
                                    text: "Este produto está sem estoque disponível (Estoque: " + quantidadeControleEstoque + "). Deseja continuar?",
                                    type: "warning",
                                    showCancelButton: false,
                                    confirmButtonText: "Sim, quero Continuar!"
                                }, function (acao) {
                                    if (acao) {
                                        $scope.salvarProdutoVendaCondicional(angular.copy($scope.dadosVendaCondicional.produto));
                                    }
                                });
                            } else if ($scope.parametrosLocal.par_avisoestoqueinsuficiente == tipoControleEstoque.avisaPedirSenha) {
                                swal({
                                    title: 'Atenção Sistema de Controle de Estoque!',
                                    text: "Este produto está sem estoque disponível (Estoque: " + quantidadeControleEstoque + "). Deseja continuar? Será solicitado uma senha Gerencial!",
                                    type: "warning",
                                    showCancelButton: true,
                                    cancelButtonText: "Não",
                                    confirmButtonClass: "btn-danger",
                                    confirmButtonText: "Sim, quero Continuar!",
                                    allowOutsideClick: false
                                }, function (acao) {
                                    if (acao) {
                                        $timeout(function () {
                                            $scope.model.tipoSolicitacao = tipoSolicitacao.estoque;
                                            var retorno = $scope.verificaSenhaGerencial();
                                        }, 100);
                                    } else {
                                        $timeout(function () {
                                            $scope.cancelaManutencaoItem();
                                        });
                                    }
                                });
                            } else if ($scope.parametrosLocal.par_avisoestoqueinsuficiente == tipoControleEstoque.bloquear) {
                                swal("Atenção Sistema de Controle de Estoque!", "Produto com estoque " + quantidadeControleEstoque + ", sistema está configurado para bloquear vendas de produtos sem estoque !", "warning");
                                $scope.cancelaManutencaoItem();
                            }
                        } else {
                            $scope.salvarProdutoVendaCondicional(angular.copy($scope.dadosVendaCondicional.produto));
                        }
                    } else {
                        $scope.salvarProdutoVendaCondicional(angular.copy($scope.dadosVendaCondicional.produto));
                    }
                } else {
                    $scope.salvarProdutoVendaCondicional(angular.copy($scope.dadosVendaCondicional.produto));
                }
            } else {
                $scope.salvarProdutoVendaCondicional(angular.copy($scope.dadosVendaCondicional.produto));
            }
        };

        $scope.calcularTotalItem = function () {
            $scope.dadosVendaCondicional.produto.vci_quantidade = (!!$scope.dadosVendaCondicional.produto.vci_quantidade) ? $scope.dadosVendaCondicional.produto.vci_quantidade : 1;
            $scope.dadosVendaCondicional.produto.valorTotal = $scope.dadosVendaCondicional.produto.vci_valorun * $scope.dadosVendaCondicional.produto.vci_quantidade;
        };

        $scope.salvarProdutoVendaCondicional = function (dadosProduto) {
            $scope.descricaoBotaoItemCondicional = 'Adicionar Item';
            if ($scope.posicao != null) {
                $scope.model.listaProdutos.splice($scope.posicao, 1);
            } else {
                dadosProduto.vci_sequencia = $scope.sequenciaItem;
                $scope.sequenciaItem++;
            }
            $scope.dadosVendaCondicional.produto = null;
            $scope.posicao = null;
            $scope.model.listaProdutos.unshift(dadosProduto);
            $scope.calcularValorTotalItens();
        };

        $scope.editarProdutoVendaCondicional = function (posicao, dadosProduto) {
            $scope.setarFocus('vci_quantidade');
            $scope.posicao = posicao;
            $scope.descricaoBotaoItemCondicional = 'Salvar Item';
            $scope.dadosVendaCondicional.produto = dadosProduto;
            $scope.calcularValorTotalItens();
        };

        $scope.cancelaManutencaoItem = function () {
            $scope.posicao = null;
            $scope.dadosVendaCondicional.produto = null;
        };

        $scope.removerProdutoVendaCondicional = function (posicao, dadosProduto) {
            swal({
                title: "Remover o Item Selecionado ?",
                text: "",
                type: "warning",
                showCancelButton: true,
                cancelButtonText: "Não",
                confirmButtonClass: "btn-danger",
                confirmButtonText: "Sim, quero remover"
            }, function (acao) {
                if (acao) {
                    $timeout(function () {
                        $scope.model.listaProdutos.splice(posicao, 1);
                        $scope.calcularValorTotalItens();
                        $scope.calcularItensDevolvidos();
                    }, 100);
                }
            });
        };

        $scope.retornaTotalItensVendaCondicional = function () {
            $scope.quantidadeTotalItensRetorno = 0;
            for (var i = 0; i < $scope.dadosCondicional.itens.length; i++) {
                $scope.quantidadeTotalItensRetorno += $scope.dadosCondicional.itens[i].vci_quantidade;
            }
        };

        $scope.listaValidacaoFormularioVendaCondicional = [
            { nome: 'cliente', obrigatorio: 'Cliente é Obrigatório', invalido: '' },
            { nome: 'vendedor', obrigatorio: 'Vendedor é obrigatório', invalido: '' },
        ];

        $scope.validarFormularioVendaCondicional = function (formulario, dadosVendaCondicional) {
            $scope.listaFormularioInvalidoVendaCondicional = [];

            var valorTotalCondicional = $scope.valorItens;
            if (!!dadosVendaCondicional.cliente) {
                var valorLimiteCredito = JSON.parse(clienteAppService.buscarLimiteCredito(dadosVendaCondicional.cliente.Id, dadosVendaCondicional.cliente.cli_id));
                if (!!valorLimiteCredito) {
                    if (valorLimiteCredito < valorTotalCondicional) {
                        $scope.solicitarSenhaGerencial = true;
                    } else {
                        $scope.solicitarSenhaGerencial = false;
                    }
                }
            }
            ValidarFormularioService.listaFormularioInvalido(formulario, $scope.listaValidacaoFormularioVendaCondicional).then(function (retorno) {
                $scope.listaFormularioInvalidoVendaCondicional = retorno.lista;
                $scope.mensagemFormularioInvalidoVendaCondicional = retorno.mensagem;

                if (dadosVendaCondicional.clitelefone === undefined || dadosVendaCondicional.clitelefone === null) {
                    $scope.listaFormularioInvalidoVendaCondicional.push({ nome: 'clitelefone', mensagem: 'Informe um Telefone!' });
                }

                if (dadosVendaCondicional.vnc_levarparacliente && (dadosVendaCondicional.vnc_enderecoentrega === undefined || dadosVendaCondicional.vnc_enderecoentrega === null || dadosVendaCondicional.vnc_enderecoentrega === "")) {
                    $scope.listaFormularioInvalidoVendaCondicional.push({ nome: 'enderecoentrega', mensagem: 'Selecione um Endereço para Entrega!' });
                };

                if (dadosVendaCondicional.vnc_levarparacliente && ($scope.dadosVendaCondicional.vnc_entregaagendada === undefined || $scope.dadosVendaCondicional.vnc_entregaagendada === null || $scope.dadosVendaCondicional.vnc_entregaagendada === "")) {
                    $scope.listaFormularioInvalidoVendaCondicional.push({ nome: 'dataAgendada', mensagem: 'Selecione uma Data para Entrega!' });
                };

                if ($scope.model.listaProdutos.length === 0) {
                    $scope.listaFormularioInvalidoVendaCondicional.push({ nome: 'produto', mensagem: 'Adicione um produto na Venda Condicional!' });
                };

                if ($scope.validarDataRetorno() === false) {
                    formulario.$error.required.push(formulario.vnc_prazoretorno);
                    $scope.listaFormularioInvalidoVendaCondicional.push({ nome: 'vnc_prazoretorno', mensagem: 'Informe uma data de retorno' });
                }

                if ($scope.listaFormularioInvalidoVendaCondicional.length === 0 && $scope.solicitarSenhaGerencial == false) {
                    $scope.salvarVendaCondicional(dadosVendaCondicional);
                } else if ($scope.listaFormularioInvalidoVendaCondicional.length === 0 && $scope.solicitarSenhaGerencial == true) {
                    swal({
                        title: 'ATENÇÃO!!!',
                        text: "O valor do limite de crédito do cliente é menor que o valor total da Condicional! Deseja Continuar? Será solicitado uma senha Gerencial!",
                        type: "warning",
                        showCancelButton: true,
                        closeOnConfirm: false,
                        cancelButtonText: "Não",
                        confirmButtonClass: "btn-danger",
                        confirmButtonText: "Sim, quero Continuar!",
                        allowOutsideClick: false
                    }, function (acao) {
                        if (acao) {
                            swal.close(); // Fecha o swal manualmente
                            $scope.model.dadosDaVendaCondicional = dadosVendaCondicional;
                            $scope.model.tipoSolicitacao = tipoSolicitacao.limiteCreditoDisponivel;
                            var retorno = $scope.verificaSenhaGerencial();

                        }
                    })
                }
            });
        };

        $scope.devolucaoItens = function (dados) {
            if (dados !== null) {
                if (dados.vnc_id) {
                    if (dados.quantidadeItens === 0) {
                        swal("Não foi possível encontrar os itens do condicional, por favor atualize dados locais e tente novamente!", "", "warning");
                    } else {
                        DadosFormularioService.armazenarDados('vendacondicionalretorno-manutencao', dados);
                        $state.go('newpdv.vendacondicionalretorno-manutencao');
                    }
                } else {
                    swal("Condicional ainda não foi sincronizado, não será possível seguir esse processo!", "", "warning");
                }
            } else {
                swal("Dados do condicional não encontrado!", "", "warning");
            }
        };

        $scope.lerDadosRetornoVendaCondicional = function () {
            $scope.dadosCondicional = DadosFormularioService.retornaDados('vendacondicionalretorno-manutencao', {}).dados;
            $scope.dadosCondicional.cliente = JSON.parse(clienteAppService.buscar($scope.dadosCondicional.ClienteId, $scope.dadosCondicional.cli_id));
            $scope.dadosCondicional.vendedor = JSON.parse(vendedorAppService.buscar($scope.dadosCondicional.ven_id));
            $scope.dadosCondicional.itens = JSON.parse(vendaCondicionalItemAppService.buscar($scope.dadosCondicional.vnc_id));
            $scope.dadosCondicional.retornoVendaCondicional = true;
            if ($scope.dadosCondicional.valorTotal == 0) {
                for (var i = 0; i < $scope.dadosCondicional.itens.length; i++) {
                    var quantidadeDevolvida = (!!!$scope.dadosCondicional.itens[i].vci_devolvido ? 0 : $scope.dadosCondicional.itens[i].vci_devolvido)
                    var quantidade = $scope.dadosCondicional.itens[i].vci_quantidade - quantidadeDevolvida;
                    var valorTotalItem = quantidade * $scope.dadosCondicional.itens[i].vci_valorun;
                    $scope.valorItens += valorTotalItem;
                }
            } else {
                $scope.valorItens = (!!$scope.dadosCondicional.valorTotal) ? $scope.dadosCondicional.valorTotal : 0;
            }

            $scope.retornaTotalItensVendaCondicional();
            $scope.calcularItensDevolvidos();
            $scope.calcularValorTotalItens();
        };

        $scope.calcularValorTotalItens = function () {
            $scope.dadosVendaCondicional.quantidadeTotalItens = 0;
            $scope.valorItens = 0;
            if ($scope.dadosCondicional) {
                for (var i = 0; i < $scope.dadosCondicional.itens.length; i++) {
                    var quantidadeDevolvida = (!!!$scope.dadosCondicional.itens[i].vci_devolvido ? 0 : $scope.dadosCondicional.itens[i].vci_devolvido)
                    var quantidade = $scope.dadosCondicional.itens[i].vci_quantidade - quantidadeDevolvida;
                    var valorTotalItem = quantidade * $scope.dadosCondicional.itens[i].vci_valorun;
                    $scope.valorItens += valorTotalItem;
                    $scope.dadosVendaCondicional.quantidadeTotalItens += $scope.dadosCondicional.itens[i].vci_quantidade;
                }
            } else {
                for (var i = 0; i < $scope.model.listaProdutos.length; i++) {
                    var quantidadeDevolvida = (!!!$scope.model.listaProdutos[i].vci_devolvido ? 0 : $scope.model.listaProdutos[i].vci_devolvido)
                    var quantidade = $scope.model.listaProdutos[i].vci_quantidade - quantidadeDevolvida;
                    var valorTotalItem = quantidade * $scope.model.listaProdutos[i].vci_valorun;
                    $scope.valorItens += valorTotalItem;
                    $scope.dadosVendaCondicional.quantidadeTotalItens += $scope.model.listaProdutos[i].vci_quantidade;
                }
            }

            if ($scope.valorItens > 0) {
                $scope.condicao = false;
            } else {
                $scope.condicao = true;
            }
        };

        $scope.devolucaoTotalItens = function (condicao) {
            if (condicao == true) {
                for (var i = 0; i < $scope.dadosCondicional.itens.length; i++) {
                    $scope.dadosCondicional.itens[i].vci_devolvido = $scope.dadosCondicional.itens[i].vci_quantidade;
                }
            } else {
                for (var i = 0; i < $scope.dadosCondicional.itens.length; i++) {
                    $scope.dadosCondicional.itens[i].vci_devolvido = 0;
                }
            }
            $scope.calcularValorTotalItens();
        };

        $scope.devolverTodos = function (posicao, item) {
            item.vci_devolvido = item.vci_quantidade;
            if ($scope.dadosCondicional) {
                $scope.dadosCondicional.itens.splice(posicao, item);
            } else {
                $scope.model.listaProdutos.splice(posicao, item);
            }
            $scope.calcularValorTotalItens();
        };

        $scope.eanProdutoDevolucao = null;

        $scope.devolverItemComLeitorDeCodigoDeBarras = function (produtoEan) {
            var jaDevolveuEan = false;

            $scope.dadosCondicional.itens.forEach(function (item) {
                if (jaDevolveuEan) return;

                var ean = item.pro_ean || item.prg_ean;

                if (produtoEan === ean) {
                    if (item.vci_quantidade == 1 && item.vci_devolvido == 0) {
                        item.vci_devolvido = item.vci_quantidade;
                        jaDevolveuEan = true;
                    } else if (item.vci_devolvido < item.vci_quantidade) {
                        item.vci_devolvido += 1;
                        jaDevolveuEan = true;
                    }
                }
            });

            if (!jaDevolveuEan) {
                swal("EAN não encontrado ou quantidade insuficiente para devolução.", "", "warning");
            }

            $scope.calcularValorTotalItens();
            $scope.calcularItensDevolvidos();
        };

        $scope.desfazerDevolucao = function (posicao, item) {
            var itemDevolvido = item.vci_devolvido;
            item.vci_devolvido = 0;
            if ($scope.dadosCondicional) {
                $scope.dadosCondicional.itens.splice(posicao, item);
            } else {
                $scope.model.listaProdutos.splice(posicao, item);
            }

            $scope.calcularValorTotalItens();
            $scope.desfazItensDevolvidos(posicao, item, itemDevolvido);
        };

        $scope.salvarRetornoCondicional = function (dadosCondicional) {

            var saldoItensCondicional = 0;
            for (var i = 0; i < dadosCondicional.itens.length; i++) {
                saldoItensCondicional += dadosCondicional.itens[i].vci_quantidade;
                saldoItensCondicional -= dadosCondicional.itens[i].vci_devolvido;
            }

            $scope.dadosVendaCondicional.Id = dadosCondicional.Id;
            $scope.dadosVendaCondicional.vnc_prazoretorno = dadosCondicional.vnc_prazoretorno;
            $scope.dadosVendaCondicional.cliente = dadosCondicional.cliente;
            $scope.dadosVendaCondicional.vendedor = dadosCondicional.vendedor;
            $scope.dadosVendaCondicional.clitelefone = dadosCondicional.vnc_telefonecliente;
            $scope.dadosVendaCondicional.vnc_observacao = dadosCondicional.vnc_observacao;
            $scope.dadosVendaCondicional.produto = dadosCondicional.itens;
            $scope.dadosVendaCondicional.vnc_entregaagendada = dadosCondicional.vnc_entregaagendada;
            $scope.dadosVendaCondicional.vnc_levarparacliente = dadosCondicional.vnc_levarparacliente;
            $scope.dadosVendaCondicional.horarioEntrega = dadosCondicional.horarioEntrega;
            $scope.dadosVendaCondicional.vnc_id = dadosCondicional.vnc_id;
            $scope.dadosVendaCondicional.vnc_numero = dadosCondicional.vnc_numero;
            var ret = vendaCondicionalAppService.editar(JSON.stringify($scope.dadosVendaCondicional));
            console.log(" $scope.salvarRetornoCondicional", $scope.dadosVendaCondicional);
            console.log(ret);
            DadosFormularioService.limparDados('vendacondicionalretorno-manutencao');
            if (ret) {
                if (saldoItensCondicional > 0) {
                    swal({
                        title: "Deseja emitir o cupom fiscal agora?",
                        text: "O retorno de mercadorias desta condicional foi registrado com sucesso no sistema!",
                        type: "success",
                        showCancelButton: true,
                        cancelButtonText: "Não (ESC)",
                        confirmButtonClass: "btn-info",
                        confirmButtonText: "SIM, Emitir Cupom (ENTER)",
                        closeOnConfirm: true
                    }, function (acao) {
                        if (acao) {
                            $scope.emitirCupom(dadosCondicional);
                        }
                        else {
                            $state.go('newpdv.venda-condicional');
                        }
                    });
                }
                else {//devolveu tudo!
                    vendaCondicionalAppService.editarSituacaoCondicional(dadosCondicional.vnc_id, situacaoCondicional.RetornoSemVenda);
                    swal("Devolução de Condicional Registrada!", "", "success");
                    $state.go('newpdv.venda-condicional');
                }
            } else {
                swal("Erro ao Editar condicional!", "", "warning");
            }
        }

        $scope.salvarVendaCondicional = function (dadosVendaCondicional) {
            $scope.salvandoCondicional = true;
            $scope.dadosVendaCondicional.produto = $scope.model.listaProdutos;
            delete dadosVendaCondicional.pee_endereco;
            delete dadosVendaCondicional.valorTotalItemVendaCondicional;

            if (!!$scope.dadosVendaCondicional.vnc_observacao) {
                dadosVendaCondicional.vnc_observacao = $scope.dadosVendaCondicional.vnc_observacao;
            } else {
                dadosVendaCondicional.vnc_observacao = "";
            }

            if (!!$scope.dadosVendaCondicional.vnc_levarparacliente) {
                $scope.dadosVendaCondicional.vnc_levarparacliente = true;
            } else {
                $scope.dadosVendaCondicional.vnc_levarparacliente = false;
                $scope.dadosVendaCondicional.vnc_enderecoentrega = {};
            }

            console.log(JSON.stringify(dadosVendaCondicional));
            var ret = null;
            if (!!dadosVendaCondicional.Id) {
                ret = JSON.parse(vendaCondicionalAppService.editar(JSON.stringify(dadosVendaCondicional)));
                finalizaCondicional();
            } else {
                ret = JSON.parse(vendaCondicionalAppService.incluir(JSON.stringify(dadosVendaCondicional)));

                console.log(ret);
                if (ret) {
                    $scope.parametrosEmpresa = parametrosEmpresaAppService.retornaDadosParametrosEmpresa();
                    if ($scope.parametrosEmpresa == null || $scope.parametrosEmpresa.par_impressaocondicional == null) {
                        vendaCondicionalAppService.imprimir((ret.Id).toString());
                        finalizaCondicional();
                    } else {
                        if ($scope.parametrosEmpresa.par_impressaocondicional == impressaoComprovantes.Imprimir) {
                            vendaCondicionalAppService.imprimir((ret.Id).toString());
                            finalizaCondicional();
                        } else if ($scope.parametrosEmpresa.par_impressaocondicional == impressaoComprovantes.PerguntarAoUsuario) {
                            swal({
                                title: "Deseja realizar a impressão do comprovante desta condicional?",
                                text: "Imprimir Comprovante?",
                                type: "warning",
                                showCancelButton: true,
                                cancelButtonText: "Sim",
                                cancelButtonClass: "btn-success",
                                confirmButtonText: "Não",
                                confirmButtonClass: "btn-default",
                            }, function (isConfirm) {
                                if (isConfirm) {
                                    $timeout(function () {
                                        swal.close(); // Fecha o swal manualmente
                                        finalizaCondicional();
                                    });
                                } else {
                                    $timeout(function () {
                                        swal.close(); // Fecha o swal manualmente
                                        try {
                                            vendaCondicionalAppService.imprimir((ret.Id).toString());

                                        } catch (e) {
                                            swal("Erro na impressão!", "Ops", "warning");
                                            console.log(e);
                                        }
                                        finalizaCondicional();
                                    });
                                }
                            });
                        } else {
                            vendaCondicionalAppService.imprimir((ret.Id).toString());
                            finalizaCondicional();
                        }
                    }
                }
            }
        };

        function finalizaCondicional() {
            DadosFormularioService.limparDados('vendacondicional-manutencao');
            growlService.growl('Venda Condicional salva com Sucesso!', 'inverse', null, 2500);
            $state.go('newpdv.venda-condicional');
        }

        $scope.setarFocus = function (nomeElemento) {
            if ((parseInt(nomeElemento))) {
                $scope.paginaAtiva = parseInt(nomeElemento);
            } else {
                $timeout(function () {
                    if (!!document.getElementsByName(nomeElemento)[0]) document.getElementsByName(nomeElemento)[0].focus();
                });

                $timeout(function () {
                    $scope.$apply(function () {
                        $('select[name="' + nomeElemento + '"]').chosen({});
                        $('select[name="' + nomeElemento + '"]').trigger("chosen:open");
                    });
                });
            };
        };

        $scope.listaValidacaoFormularioProduto = [
            { nome: 'prodescricao', obrigatorio: 'Produto é Obrigatório!', invalido: '' },
            {
                nome: 'vci_quantidade', obrigatorio: 'Quantidade é Obrigatória', invalido: ''
            },
            {
                nome: 'vci_valorun', obrigatorio: 'Valor Unitário é Obrigatório', invalido: ''
            }
        ];

        $scope.validarFormularioItemVendaCondicional = function (formulario, dadosProduto) {
            $scope.listaFormularioInvalidoProduto = [];
            ValidarFormularioService.listaFormularioInvalido(formulario, $scope.listaValidacaoFormularioProduto).then(function (retorno) {
                $scope.listaFormularioInvalidoProduto = retorno.lista;
                $scope.mensagemFormularioInvalidoProduto = retorno.mensagem;

                if ($scope.listaFormularioInvalidoProduto.length === 0) {
                    $scope.verificarEstoqueProdutoEAdicionaProduto();
                };
            });
        };

        $scope.voltarListaVendaCondicional = function () {
            DadosFormularioService.limparDados('vendacondicional-manutencao');
            DadosFormularioService.limparDados('vendacondicionalretorno-manutencao');
            $state.go('newpdv.venda-condicional');
        };

        $scope.comparaQuantidades = function (dadosProduto, quantidadeDevolver) {
            if (dadosProduto.vci_quantidade < quantidadeDevolver) {
                swal({
                    title: 'Não é possível devolver uma quantidade superior que a quatidade retirada!',
                    text: "",
                    type: "warning",
                    confirmButtonClass: "btn-info",
                    confirmButtonText: "OK",
                    closeOnConfirm: true
                }, function (acao) {
                    if (acao) {
                        $timeout(function () {
                            $scope.dadosProduto.quantiaDevolver = 0;
                            return;
                        }, 100);
                    }
                });
            }
        };

        $scope.aplicarFiltros = function (dados) {
            if (!!dados.cliente) {
                dados.cli_id = dados.cliente.Id;
            } else {
                delete dados.cli_id;
            }

            if (!!dados.vendedor) {
                dados.ven_id = dados.vendedor.ven_id;
            } else {
                delete dados.ven_id;
            }

            $scope.listaVendasCondicional = JSON.parse(vendaCondicionalAppService.buscar(JSON.stringify(dados)));

            $scope.abasListaVendaCondicional[0].quantidade = 0;
            $scope.abasListaVendaCondicional[1].quantidade = 0;
            angular.forEach($scope.listaVendasCondicional, function (dado) {
                if (!dado.vnc_levarparacliente) {
                    $scope.abasListaVendaCondicional[0].quantidade++;
                } else {
                    $scope.abasListaVendaCondicional[1].quantidade++;
                }
            });
            $scope.filtro.ean = '';
        };

        $scope.buscarVendedorVinculadoUsuario = function () {
            $scope.dadosVendaCondicional.vendedor = ($scope.dadosVendaCondicional.vendedor) ? $scope.dadosVendaCondicional.vendedor : null;
            if ($scope.dadosVendaCondicional.vendedor === null) {
                var retorno = JSON.parse(vendedorAppService.buscarVendedorVinculadoAoUsuario());
                if (retorno != null) {
                    $scope.dadosVendaCondicional.vendedor = retorno;
                };
            }
        };

        $scope.emitirCupom = function (dadosVendaCondicional) {
            var dados = {
                iniciarVenda: true,
                pes_id: dadosVendaCondicional.pes_id,
                cli_id: dadosVendaCondicional.cliente.cli_id,
                ClienteId: dadosVendaCondicional.ClienteId,
                pes_cpfcnpj: !!dadosVendaCondicional.cliente.pef_cpf ? dadosVendaCondicional.cliente.pef_cpf : dadosVendaCondicional.cliente.pej_cnpj,
                pes_nome: dadosVendaCondicional.cliente.pes_nome,
                ven_id: dadosVendaCondicional.vendedor.ven_id,
                ven_nome: dadosVendaCondicional.vendedor.ven_nome,
                subTotal: 0,
                subTotalBruto: 0,
                totalDescontos: 0,
                subTotalNota: 0,
                totalAcrescimos: 0,
                descontoEmValorOuPercentual: '$',
                acrescimoEmValorOuPercentual: '$',
                listaItens: [],
                vnc_situacao: dadosVendaCondicional.vnc_situacao,
                idVendaCondicional: dadosVendaCondicional.vnc_id
            };
            for (var i = 0; i < dadosVendaCondicional.itens.length; i++) {
                var item = dadosVendaCondicional.itens[i];

                /* QUANTOS ITENS SERÃO COMPRADOS */
                var totalItensComprados = item.vci_quantidade - item.vci_devolvido;

                if (totalItensComprados > 0) {
                    item.vlrDesconto = 0;
                    item.vlrAcrescimo = 0;

                    var grade = {};
                    if (!!item.prg_id) {
                        grade = JSON.parse(produtoAppService.listaGradesProduto(item.pro_id, item.prg_id));
                    };

                    var temporaria = {
                        produto: item.pro_descricao,
                        ean: item.pro_ean || item.prg_ean,
                        quantidade: totalItensComprados,
                        pro_codigo: item.pro_id,
                        pro_id: item.pro_id,
                        vlrUnitario: item.vci_valorun,
                        totalItem: totalItensComprados * item.vci_valorun,
                        valorTotalItem: ((item.vci_valorun * totalItensComprados) - item.vlrDesconto) + item.vlrAcrescimo,
                        totalItemDesconto: item.vci_valorun,
                        vlrDescontoItem: 0,
                        desconto: 0,
                        vlrAcrescimo: 0,
                        acrescimo: 0,
                        vlrDesconto: 0,
                        desconto: 0,
                        vlrPrdAnt: 0,
                        valorUnitario: item.vci_valorun,
                        vlrOutro: 0,
                        vlrFrete: 0,
                        prg_id: !!item.prg_id ? item.prg_id : 0,
                    };

                    if (grade.length > 0) {
                        temporaria.grade = grade[0].atributos[0].mgp_descricao;
                    } else {
                        temporaria.grade = null;
                    };

                    dados.listaItens.push(temporaria);
                }
            };
            dados.qtdTotalItens = dados.listaItens.length;
            DadosFormularioService.armazenarDados('venda-varejo', dados);
            $state.go('newpdv.venda-varejo');
        };

        $scope.atualizarSituacaoCondicional = function (dadosCondicional) {
            var situacaoAtual = dadosCondicional.vnc_situacao;
            dadosCondicional.vnc_situacao = 0;
            if (!!dadosCondicional.entregueAoCliente) {
                dadosCondicional.vnc_situacao = 1;
            }

            if (situacaoAtual != dadosCondicional.vnc_situacao) {
                vendaCondicionalAppService.editarSituacaoCondicional(dadosCondicional.Id, dadosCondicional.vnc_situacao);
            }
        };

        $scope.verificaSenhaGerencial = function () {
            var retorno = localAppService.possuiSenhaGerencial();
            if (retorno == true) {
                $scope.modalSenhaGerencial = ModalService.model($scope, 'views/pdv/varejo/modalSenhaGerencial.html', 'sm', true, 'static', true);
            }
        };
        $scope.validaSenhaGerencial = function (senha) {
            var senhaValida = localAppService.validarSenhaGerencial(senha);
            if (senhaValida == true) {
                if ($scope.model.tipoSolicitacao == tipoSolicitacao.estoqueGrade) {
                    $scope.adicionarItensComGrade($scope.model.listaItensComGrade);
                }
                if ($scope.model.tipoSolicitacao == tipoSolicitacao.estoque) {
                    $scope.salvarProdutoVendaCondicional(angular.copy($scope.dadosVendaCondicional.produto));
                }
                if ($scope.model.tipoSolicitacao == tipoSolicitacao.limiteCredito) {
                }
                if ($scope.model.tipoSolicitacao == tipoSolicitacao.limiteCreditoDisponivel) {
                    $scope.salvarVendaCondicional($scope.model.dadosDaVendaCondicional);
                }
                if ($scope.model.tipoSolicitacao == tipoSolicitacao.parcelasAtrazadas) {
                }
                if ($scope.model.tipoSolicitacao == tipoSolicitacao.somenteAvista) {
                }

                $scope.model.senhaGerencial = '';
                $scope.modalSenhaGerencial.close();
            } else {
                swal("Senha incorreta!", "", "warning");
            }
        };

        $scope.fecharModalSenhaGerencial = function () {
            if ($scope.model.tipoSolicitacao == tipoSolicitacao.estoqueGrade) {
                $scope.cancelaManutencaoItem();
            }
            if ($scope.model.tipoSolicitacao == tipoSolicitacao.estoque) {
                $scope.cancelaManutencaoItem();
            }
            if ($scope.model.tipoSolicitacao == tipoSolicitacao.limiteCredito) {
                $scope.dadosVendaCondicional.cliente = null;
            }
            if ($scope.model.tipoSolicitacao == tipoSolicitacao.limiteCreditoDisponivel) {

            }
            if ($scope.model.tipoSolicitacao == tipoSolicitacao.parcelasAtrazadas) {
                $scope.dadosVendaCondicional.cliente = null;
            }
            if ($scope.model.tipoSolicitacao == tipoSolicitacao.somenteAvista) {
                $scope.dadosVendaCondicional.cliente = null;
            }

            $scope.model.senhaGerencial = '';
            $scope.modalSenhaGerencial.close();
        }

        $scope.verificarLimiteCredito = function (dadosCliente) {
            var parametrosEmpresa = parametrosEmpresaAppService.retornaDadosParametrosEmpresa();
            if (parametrosEmpresa.par_usalimitecredito === true) {
                if (!!dadosCliente.pes_id && navigator.onLine) {
                    var limiteCreditoDisponivel = JSON.parse(clienteAppService.limiteCreditoDisponivel(dadosCliente.pes_id));
                    if (limiteCreditoDisponivel == null) {
                        swal("ATENÇÃO!!!", "Este computador não esta conectado a internet, " +
                            " ou o servidor está off-line." +
                            "Desta forma não é possível realizar a consulta de pendencias do " +
                            "cliente e verificar o limite de crédito disponível para realizar a " +
                            "venda no crediário. E recomendável que você fale com seu supervisor/gerente " +
                            "antes de prosseguir com a venda!", "warning");
                    } else {
                        if (limiteCreditoDisponivel.valorTotal <= 0) {
                            swal({
                                title: 'ATENÇÃO!!!',
                                text: "Este Cliente está sem Limite de Crédito Disponível! Deseja Continuar? Será solicitado uma senha Gerencial!",
                                type: "warning",
                                showCancelButton: true,
                                cancelButtonText: "Não",
                                confirmButtonClass: "btn-danger",
                                confirmButtonText: "Sim, quero Continuar!",
                                allowOutsideClick: false
                            }, function (acao) {
                                if (acao) {
                                    $timeout(function () {
                                        $scope.model.tipoSolicitacao = tipoSolicitacao.limiteCredito;
                                        var retorno = $scope.verificaSenhaGerencial();
                                    }, 100);
                                } else {
                                    $timeout(function () {
                                        $scope.dadosVendaCondicional.cliente = null;
                                    });
                                }
                            });
                        }
                        if (!!!limiteCreditoDisponivel.valorTotal) {
                            swal({
                                title: 'ATENÇÃO!!!',
                                text: "Cliente sem Limite de Crédito Definido! Deseja Continuar? Será solicitado uma senha Gerencial!",
                                type: "warning",
                                showCancelButton: true,
                                cancelButtonText: "Não",
                                confirmButtonClass: "btn-danger",
                                confirmButtonText: "Sim, quero Continuar!",
                                allowOutsideClick: false
                            }, function (acao) {
                                if (acao) {
                                    $timeout(function () {
                                        $scope.model.tipoSolicitacao = tipoSolicitacao.limiteCredito;
                                        var retorno = $scope.verificaSenhaGerencial();
                                    }, 100);
                                } else {
                                    $timeout(function () {
                                        $scope.dadosVendaCondicional.cliente = null;
                                    });
                                }
                            });
                        }
                    }
                }
            }
        };

        $scope.verificarParcelasEmAberto = function (dadosCliente) {
            if (navigator.onLine && !!dadosCliente.pes_id) {
                $scope.parcelasAtraso = JSON.parse(clienteAppService.verificarParcelasEmAtraso(dadosCliente.pes_id));
                if ($scope.parcelasAtraso == null) {
                    swal("ATENÇÃO!!!", "Este computador não esta conectado a internet, ou o servidor está off-line. Desta forma não é " +
                        "possível realizar a consulta de pendencias do cliente e verificar o limite de crédito" +
                        "disponível para realizar a venda no crediário. E recomendável que você fale com seu " +
                        "supervisor/gerente antes de prosseguir com a venda!", "warning");
                }
                if ($scope.parcelasAtraso.length > 0) {
                    //$scope.modalParcelasAtraso = ModalService.model($scope, 'views/pdv/varejo/modalParcelasPendentes.html', 'lg', true, true, true);
                    swal({
                        title: 'ATENÇÃO!!!',
                        text: "Este cliente possui parcelas em atraso!! Deseja Continuar? Será solicitado uma senha Gerencial!",
                        type: "warning",
                        showCancelButton: true,
                        cancelButtonText: "Não",
                        confirmButtonClass: "btn-danger",
                        confirmButtonText: "Sim, quero Continuar!",
                        allowOutsideClick: false
                    }, function (acao) {
                        if (acao) {
                            $timeout(function () {
                                $scope.model.tipoSolicitacao = tipoSolicitacao.parcelasAtrazadas;
                                var retorno = $scope.verificaSenhaGerencial();
                            }, 100);
                        } else {
                            $timeout(function () {
                                $scope.dadosVendaCondicional.cliente = null;
                            })
                        }
                    });
                }
            }
        }

        $scope.verificarVendaSomenteAvista = function (dadosCliente) {
            if (dadosCliente.cli_vendasomenteavista === true) {
                swal({
                    title: 'ATENÇÃO!!!',
                    text: "Só é possível vender a vista para esse cliente! Deseja Continuar? Será solicitado uma senha Gerencial!",
                    type: "warning",
                    showCancelButton: true,
                    cancelButtonText: "Não",
                    confirmButtonClass: "btn-danger",
                    confirmButtonText: "Sim, quero Continuar!",
                    allowOutsideClick: false
                }, function (acao) {
                    if (acao) {
                        $timeout(function () {
                            $scope.model.tipoSolicitacao = tipoSolicitacao.somenteAvista;
                            var retorno = $scope.verificaSenhaGerencial();
                        }, 100);
                    } else {
                        $timeout(function () {
                            $scope.dadosVendaCondicional.cliente = null;
                        });
                    }
                });
            }
        };

        $scope.validarDataRetorno = function () {
            var dataRetorno = $scope.dadosVendaCondicional.vnc_prazoretorno;
            if (dataRetorno === undefined || dataRetorno === null || dataRetorno === "") {
                return false;
            } else {
                var eDataValida = FuncaoService.verificarDataValida(dataRetorno);
                if (!eDataValida) {
                    return false;
                };
            };
            return true;
        };

        $scope.calcularItensDevolvidos = function () {
            $scope.quantidadeItensDevolvidos = 0;
            if ($scope.dadosCondicional) {
                for (var i = 0; i < $scope.dadosCondicional.itens.length; i++) {
                    if ($scope.dadosCondicional.itens[i].vci_devolvido) {
                        $scope.quantidadeItensDevolvidos += $scope.dadosCondicional.itens[i].vci_devolvido;
                    }
                }
            } else {
                for (var i = 0; i < $scope.model.listaProdutos.length; i++) {
                    if ($scope.model.listaProdutos[i].vci_devolvido) {
                        $scope.quantidadeItensDevolvidos += $scope.model.listaProdutos[i].vci_devolvido;
                    }
                }
            }

        };

        $scope.desfazItensDevolvidos = function (posicao, item, itemDevolvido) {
            if (itemDevolvido) {
                $scope.quantidadeItensDevolvidos -= itemDevolvido;
            } else {
                $scope.quantidadeItensDevolvidos -= item.vci_quantidade;
            }
        };

        $scope.exibirDetalhes = function (dadosCondicional) {
            $scope.detalhesVnc = dadosCondicional;
            $scope.detalhesVnc.itens = JSON.parse(vendaCondicionalItemAppService.buscar(dadosCondicional.vnc_id));
            $scope.modalDetalhesCondicional = ModalService.model($scope, 'views/pdv/varejo/venda_condicional/modalDetalhesCondicional.html', 'lg', true, true, true);
        };
    }]);
})();