﻿newERP.controller('SuprimentoSangriaController', ['$scope', 'FuncaoService', function ($scope, FuncaoService) {

    $scope.dadosSuprimentoSangria = {
        mvx_valormovimento: 0,
        contaGerencialSangria: null,
        contaGerencialSuprimento: null,
        observacao: ''
    };

    var dadosContaGerencialSangria = JSON.parse(parametrosEmpresaAppService.retornaContaGerencialSangriaPadrao());
    if (!!dadosContaGerencialSangria) $scope.dadosSuprimentoSangria.contaGerencialSangria = dadosContaGerencialSangria[0];

    var dadosContaGerencialSuprimento = JSON.parse(parametrosEmpresaAppService.retornaContaGerencialSuprimentoPadrao());
    if (!!dadosContaGerencialSuprimento) $scope.dadosSuprimentoSangria.contaGerencialSuprimento = dadosContaGerencialSuprimento[0];

    function montarListaCedulas() {
        $scope.totalCedulasPapel = 0;
        $scope.totalCedulasMoeda = 0;
        $scope.listaCedulasPapel = [];
        $scope.listaCedulasPapel.push({
            descricao: 'R$ 100,00',
            valor: 100,
            quantidade: 0
        });
        $scope.listaCedulasPapel.push({
            descricao: 'R$ 50,00',
            valor: 50,
            quantidade: 0
        });
        $scope.listaCedulasPapel.push({
            descricao: 'R$ 20,00',
            valor: 20,
            quantidade: 0
        });
        $scope.listaCedulasPapel.push({
            descricao: 'R$ 10,00',
            valor: 10,
            quantidade: 0
        });
        $scope.listaCedulasPapel.push({
            descricao: 'R$ 5,00',
            valor: 5,
            quantidade: 0
        });
        $scope.listaCedulasPapel.push({
            descricao: 'R$ 2,00',
            valor: 2,
            quantidade: 0
        });

        $scope.listaCedulasMoeda = [];
        $scope.listaCedulasMoeda.push({
            descricao: 'R$ 1,00',
            valor: 1,
            quantidade: 0
        });
        $scope.listaCedulasMoeda.push({
            descricao: 'R$ 0,50',
            valor: 0.50,
            quantidade: 0
        });
        $scope.listaCedulasMoeda.push({
            descricao: 'R$ 0,25',
            valor: 0.25,
            quantidade: 0
        });
        $scope.listaCedulasMoeda.push({
            descricao: 'R$ 0,10',
            valor: 0.10,
            quantidade: 0
        });
        $scope.listaCedulasMoeda.push({
            descricao: 'R$ 0,05',
            valor: 0.05,
            quantidade: 0
        });
        $scope.listaCedulasMoeda.push({
            descricao: 'R$ 0,01',
            valor: 0.01,
            quantidade: 0
        });
    };
    montarListaCedulas();

    $scope.calcularValorAbertura = function () {
        $scope.totalCedulasPapel = 0;
        $scope.listaCedulasPapel.forEach(function (cedula) {
            $scope.totalCedulasPapel += (cedula.valor * cedula.quantidade);
        })

        $scope.totalCedulasMoeda = 0;
        $scope.listaCedulasMoeda.forEach(function (moeda) {
            $scope.totalCedulasMoeda += (moeda.valor * moeda.quantidade);
        })

        $scope.dadosSuprimentoSangria.mvx_valormovimento = $scope.totalCedulasPapel + $scope.totalCedulasMoeda;
    };

    $scope.setarFocus = function (nomeElemento) {
        FuncaoService.setarFocus(nomeElemento, 300);
    };

    $scope.keyEnterSuprimentoCaixa = function () {
        $scope.realizarSuprimento();
    };

    $scope.keyEscSuprimentoCaixa = function () {
        $scope.modalSuprimentoCaixa.close();
    };

    $scope.keyEnterSangriaCaixa = function () {
        $scope.realizarSangria();
    };

    $scope.keyEscSangriaCaixa = function () {
        $scope.modalSangriaCaixa.close();
    };

    $scope.clicouPraSuprimento = false;
    $scope.realizarSuprimento = function () {
        if (!!$scope.dadosSuprimentoSangria.mvx_valormovimento) {
            $scope.clicouPraSuprimento = true;
            var contaGerencialId = (!!$scope.dadosSuprimentoSangria.contaGerencialSuprimento) ? ($scope.dadosSuprimentoSangria.contaGerencialSuprimento.ctg_id).toString() : '';
            if (!!suprimentoSangriaAppService.suprimento(JSON.stringify($scope.dadosSuprimentoSangria.mvx_valormovimento), contaGerencialId, $scope.dadosSuprimentoSangria.observacao)) {
                $scope.dadosSuprimentoSangria.mvx_valormovimento = 0;
                setTimeout(function () {
                    swal("Suprimento realizado com sucesso!", "", "success");
                }, 100)
                $scope.modalSuprimentoCaixa.close();
            } else {
                swal("Opss", "Tente novamente", "warning");
            }
        } else {
            setTimeout(function () {
                swal("Informe um valor de suprimento para o Caixa.", "", "warning");
                $scope.setarFocus('valor_movimento');
            }, 100)
        }
    };

    $scope.clicouPraSangria = false;
    $scope.realizarSangria = function () {
        if (!!$scope.dadosSuprimentoSangria.mvx_valormovimento) {
            var saldoCaixa = movimentoCaixaAppService.saldoCaixa();
            if ($scope.dadosSuprimentoSangria.mvx_valormovimento > saldoCaixa) {
                setTimeout(function () {
                    swal("O valor de sangria é maior que o saldo disponível no Caixa.", "", "warning");
                }, 100)
                $scope.setarFocus('valor_movimento');
            } else {
                $scope.clicouPraSangria = true;
                var contaGerencialId = (!!$scope.dadosSuprimentoSangria.contaGerencialSangria) ? ($scope.dadosSuprimentoSangria.contaGerencialSangria.ctg_id).toString() : '';
                if (!!suprimentoSangriaAppService.sangria(JSON.stringify($scope.dadosSuprimentoSangria.mvx_valormovimento), contaGerencialId, $scope.dadosSuprimentoSangria.observacao)) {
                    $scope.dadosSuprimentoSangria.mvx_valormovimento = 0;
                    setTimeout(function () {
                        swal("Sangria realizada com sucesso!", "", "success");
                    }, 100)
                    $scope.modalSangriaCaixa.close();
                } else {
                    swal("Opss", "Tente novamente", "warning");
                }
            }
        } else {
            setTimeout(function () {
                swal("Informe um valor de sangria para o Caixa.", "", "warning");
                $scope.setarFocus('valor_movimento');
            }, 100)
        }
    };

}]);