﻿    (function () {
    newERP.controller('ProfileController', ['growlService', '$scope', '$localStorage', 'GeneroService', '$state', '$timeout', function (growlService, $scope, $localStorage, GeneroService, $state, $timeout) {

        $scope.dadosUsuario = {
            usu_id: '',
            usu_nome: '',
            usu_email: '',
            usu_sexo: '',
            usu_datanascimento: '',
            usu_telefone: '',
            usu_avatar: {
                data: '',
                type: ''
            },
            usu_ativo: true
        };

        $scope.abrirTelaProfile = function () {
            $state.go('newpdv.profile');
        }

        $scope.listaUsuario = function () {
            var dados = JSON.parse(usuarioAppService.dadosUsuarioLogado());
            $scope.dadosUsuario = {
                usu_id: dados.codigo,
                usu_nome: dados.nome,
                usu_email: dados.email,
                usu_avatar: {
                    data: '',
                    type: ''
                },
            }
            $scope.verificaGenero(dados.nome);
        };

        $scope.verificaGenero = function (nome) {
            if (!!nome == true) {
                var cliente = nome.split(' ')[0];
                var retorno = GeneroService.Definir(cliente);
                if (retorno == 0) {
                    $scope.dadosUsuario.usu_sexo = 'F';
                } else {
                    $scope.dadosUsuario.usu_sexo = 'M';
                };
            }
        };

        $scope.iniciarDadosProfile = function () {
            $scope.listaUsuario();
            $scope.carregarAvatar();
        };
        $scope.carregarAvatar = function () {
            var retorno = JSON.parse(usuarioAppService.retornarAvatar());
            $scope.avatar = retorno.usu_avatar.data;
            $scope.nomeUsuario = retorno.usu_nome;
        }

        $scope.salvarDadosProfile = function () {
            var resultado = usuarioAppService.editarProfile(JSON.stringify($scope.dadosUsuario));
            if (resultado === true) {
                swal("Dados Salvos com Sucesso!", "", "success");
            }
            //$state.go('newpdv.home-pdv');            
        };

        $scope.cancelar = function () {
            $state.go('newpdv.home-pdv');
        }

        $timeout(function () {

            var ImagemProfile = document.getElementById('ImagemProfile');
            var ImagemProfileInput = document.getElementById('ImagemProfileInput');

            if (!!ImagemProfile) ImagemProfile.addEventListener("drop", SelecionarImagemProfile, false);
            if (!!ImagemProfileInput) ImagemProfileInput.addEventListener("change", SelecionarImagemProfileInput, false);

            function SelecionarImagemProfileInput(evt) {
                var filesInput = evt.target.files || evt.dataTransfer.files;
                var arquivosValidos = ["image/gif", "image/jpeg", "image/pjpeg", "image/png"];
                for (var x = 0; x < filesInput.length; x++) {
                    (function (fileInput) {
                        if (arquivosValidos.indexOf(fileInput.type) >= 0) {
                            var readerInput = new FileReader();
                            readerInput.onload = function () {
                                $scope.dadosUsuario.usu_avatar = {
                                    data: readerInput.result,
                                    type: evt.target.files[0].type
                                }

                                $scope.$digest();
                                $scope.$apply();
                            }
                            readerInput.readAsDataURL(fileInput);
                        }
                    })(filesInput[x]);
                }
            }

            function SelecionarImagemProfile(e) {
                var files = e.target.files || e.dataTransfer.files;
                var arquivosValidos = ["image/gif", "image/jpeg", "image/pjpeg", "image/png"];
                for (var i = 0; i < files.length; i++) {
                    (function (file) {
                        if (arquivosValidos.indexOf(file.type) >= 0) {
                            var reader = new FileReader();
                            reader.onload = function () {
                                $scope.dadosUsuario.usu_avatar = {
                                    data: readerInput.result,
                                    type: evt.target.files[0].type
                                }
                                $scope.$digest();
                                $scope.$apply();
                            }
                            reader.readAsDataURL(file);
                        }
                    })(files[i]);
                }
            }
        }, 100);
    }]);
})()