﻿(function () {
    newERP.controller('ModalBandeiraCartaoController', ['$scope', 'ValidarFormularioService', '$timeout', 'FuncaoService', '$uibModal', '$uibModalInstance', 'param', 'hotkeys', function ($scope, ValidarFormularioService, $timeout, FuncaoService, $uibModal, $uibModalInstance, param, hotkeys) {

        $scope.pagina = {
            bandeira: 0,
            nsu: 1
        };

        $scope.tipoParcelamento = {
            estabelecimento: 0,
            comprador: 1
        };

        var tipoFormaPagamento = {
            fpDinheiro: 1,
            fpCheque: 2,
            fpCartaoCredito: 3,
            fpCartaoDebito: 4,
            fpCreditoLoja: 5,
            fpValeAlimentacao: 10,
            fpValeRefeicao: 11,
            fpValePresente: 12,
            fpValeCombustivel: 13,
            fpOutro: 99
        };

        $scope.model = {
            bandeiras: [],
            bandeiraselecionada: 0,
            telaSelecionada: $scope.pagina.bandeira
        };

        $scope.dadosBandeira = {
            bandeira: {},
            nsu: null,
            tipoParcelamento: $scope.tipoParcelamento.estabelecimento,
            cartaoCredito: false
        };


        $scope.carregarEstruturaBandeiras = function () {
            var parametros = param.dados;
            console.log('parametros', parametros);

            $scope.dadosBandeira.cartaoCredito = false;
            if (parametros.tipoPagamento == parseInt(tipoFormaPagamento.fpCartaoCredito)) {
                $scope.dadosBandeira.cartaoCredito = true;
            }

            $scope.model.bandeiraselecionada = 0;
            $scope.model.bandeiras = JSON.parse(bandeiraCartaoEmpresaAppService.listarAtivos());
        };

        $scope.setarFocus = function (nomeElemento) {
            if (!!nomeElemento) $timeout(function () {
                document.getElementsByName(nomeElemento)[0].focus();
            });
        };

        $scope.closeModalBandeira = function () {
            $scope.cancelandoOperacao = true;
            swal({
                title: "Deseja realmente cancelar o lançamento de Cartão?",
                text: "",
                type: "warning",
                showCancelButton: true,
                cancelButtonText: "Não, continuar lançamento",
                confirmButtonClass: "btn-danger",
                confirmButtonText: "SIM, cancelar a operação",
                closeOnConfirm: true
            },
                function (acao) {
                    if (acao) {
                        $uibModalInstance.close(null);
                    }
                    else {
                        $scope.cancelandoOperacao = false;
                        if ($scope.model.telaSelecionada == $scope.pagina.nsu)
                            $timeout(function () {
                                $scope.setarFocus('nsu');
                            }, 100);
                        $scope.$digest();
                    }
                });
        };

        $scope.voltar = function () {
            $scope.model.telaSelecionada = $scope.pagina.bandeira;
        };

        $scope.keyEnterConfirmar = function () {
            $scope.dadosBandeira.bandeira = $scope.model.bandeiras[$scope.model.bandeiraselecionada];
            $uibModalInstance.close($scope.dadosBandeira);
        };

        $scope.keyEnterBandeiras = function () {
            $scope.dadosBandeira.bandeira = $scope.model.bandeiras[$scope.model.bandeiraselecionada];

            if ($scope.model.telaSelecionada == $scope.pagina.bandeira) {
                $scope.model.telaSelecionada = $scope.pagina.nsu;
                $timeout(function () {
                    $scope.setarFocus('nsu');
                }, 100);
            } else {
                $scope.keyEnterConfirmar();
            }
        };

        $scope.selecionaBandeira = function (index) {
            $scope.model.bandeiraselecionada = index;
        };

        $scope.keyLeftBandeiras = function () {
            if ($scope.model.bandeiraselecionada > 0) $scope.model.bandeiraselecionada--;
        };
        $scope.keyRightBandeiras = function () {
            if (($scope.model.bandeiraselecionada + 1) < $scope.model.bandeiras.length) {
                $scope.model.bandeiraselecionada++;
            }
        };
        $scope.keyUpBandeiras = function () {
            if ($scope.model.bandeiraselecionada >= 6) {
                $scope.model.bandeiraselecionada -= 6;
            }
            else {
                $scope.model.bandeiraselecionada = 0;
            }
        };
        $scope.keyDownBandeiras = function () {
            $scope.model.bandeiraselecionada += 6;
            if ($scope.model.bandeiras.length < $scope.model.bandeiraselecionada) {
                $scope.model.bandeiraselecionada = ($scope.model.bandeiras.length - 1);
            }
        };


        hotkeys.bindTo($scope)
            .add({
                combo: 'enter',
                description: 'Avançar/OK',
                allowIn: ['INPUT'],
                callback: function () {
                    if ($scope.model.telaSelecionada == $scope.pagina.bandeira) {
                        $scope.keyEnterBandeiras();
                    } else {
                        $scope.keyEnterConfirmar();
                    }
                }
            })
    }]);
})();