﻿newERP.controller('DevolucaoVendaPdvController', ['$scope', '$window', 'ModalService', 'DadosFormularioService', 'FuncaoService', 'NgTableParams', '$filter', '$state', 'ValidarFormularioService', 'growlService', '$timeout', 'RelatorioService', function ($scope, $window, ModalService, DadosFormularioService, FuncaoService, NgTableParams, $filter, $state, ValidarFormularioService, growlService, $timeout, RelatorioService) {

    $scope.dadosNfceDevolucao = {};
    $scope.mostraDadosCliente = false;

    $scope.toggleDropdown = function ($event) {
        $event.preventDefault();
        $event.stopPropagation();
        $scope.menuEmitir.exibir = !$scope.menuEmitir.exibir;
    };

    $scope.setarFocus = function (nomeElemento) {
        if ((parseInt(nomeElemento))) {
            $scope.paginaAtiva = parseInt(nomeElemento);
        } else {
            $timeout(function () {
                document.getElementsByName(nomeElemento)[0].focus();
            });

            $timeout(function () {
                $scope.$apply(function () {
                    $('select[name="' + nomeElemento + '"]').chosen({});
                    $('select[name="' + nomeElemento + '"]').trigger("chosen:open");
                });
            });
        }
    };

    $scope.montarNgTable = function (dados) {
        return new NgTableParams({
            count: 4,
        }, {
            total: dados.length,
            getData: function ($defer, params) {
                var orderedData = $filter('orderBy')(dados, "");
                $defer.resolve(orderedData.slice((params.page() - 1) * params.count(), params.page() * params.count()));
            }
        });
    };

    $scope.listaSerie = JSON.parse(serieFiscalAppService.listarSeries("55", 0));
    $scope.listaPais = JSON.parse(paisAppService.listarTodos());
    $scope.pesquisaCepPostmon = function (cep) {
        var retornoCep = {};
        if (!!cep) {
            var _retornoCep = notaFiscalDevolucaoAppService.buscaCidade(cep);
            if (_retornoCep != null) {
                retornoCep = JSON.parse(_retornoCep);

                if (!!retornoCep.cidade) {
                    $scope.dadosNfceDevolucao.dadosDestinatario.endereco.pais = ($scope.dadosNfceDevolucao.dadosDestinatario.endereco.pais) ? $scope.dadosNfceDevolucao.dadosDestinatario.endereco.pais : $scope.paisSelecionado;
                    $scope.dadosNfceDevolucao.dadosDestinatario.endereco.ntf_municipiodest = retornoCep.cidade;
                    $scope.dadosNfceDevolucao.dadosDestinatario.endereco.ntf_ufdest = retornoCep.estado;
                    $scope.dadosNfceDevolucao.dadosDestinatario.endereco.ibge = retornoCep.cidade_info.codigo_ibge;

                } else {
                    growlService.growl('Cep ' + cep + ' não encontrado!', 'inverse');
                    $scope.dadosNfceDevolucao.dadosDestinatario.endereco.ntf_cepdest = '';
                    $scope.dadosNfceDevolucao.dadosDestinatario.endereco.cidade = '';
                };
            } else {
                growlService.growl('Cep ' + cep + ' não encontrado!', 'inverse');
                $scope.dadosNfceDevolucao.dadosDestinatario.endereco.ntf_cepdest = '';
                $scope.dadosNfceDevolucao.dadosDestinatario.endereco.cidade = '';
            }

        }
        //if (!!retornoCep.cidade) {
        //    $scope.dadosNfceDevolucao.dadosDestinatario.endereco.pais = $scope.paisSelecionado;
        //    $scope.dadosNfceDevolucao.dadosDestinatario.endereco.ntf_municipiodest = retornoCep.cidade;
        //    $scope.dadosNfceDevolucao.dadosDestinatario.endereco.ntf_ufdest = retornoCep.estado;
        //    $scope.dadosNfceDevolucao.dadosDestinatario.endereco.ibge = retornoCep.cidade_info.codigo_ibge;

        //} else {
        //    growlService.growl('Cep ' + cep + ' não encontrado!', 'inverse');
        //    $scope.dadosNfceDevolucao.dadosDestinatario.endereco.ntf_cepdest = '';
        //    $scope.dadosNfceDevolucao.dadosDestinatario.endereco.cidade = '';
        //};
    };

    $scope.tipoPagamento = JSON.parse(enumAppService.listaEnum('FormaPagamento'));

    $scope.filtro = {

    };

    $scope.dadosFiltros = {
        statusNota: [],
    }
    $scope.filtro.statusNota = JSON.parse(enumAppService.listaEnum('StatusNFe'));
    $scope.dadosFiltros.statusNota = JSON.parse(enumAppService.listaEnum('StatusNFe'));

    $scope.lerDadosNfceDevolucao = function () {
        $scope.dadosNfceDevolucao = {
            dadosContribuinte: {},
            dadosDestinatario: {},
        };
        $scope.totalItensOriginal;
        $scope.dadosNfceDevolucao = DadosFormularioService.retornaDados('devolucao-venda', { ntf_id: null, ntf_status: 1 }).dados;
        if ($scope.listaSerie.length == 1) {
            if ($scope.dadosNfceDevolucao.ntf_docfiscal == false) {
                $scope.dadosNfceDevolucao.serieFiscal = [];
            } else {
                $scope.dadosNfceDevolucao.serieFiscal = $scope.listaSerie[0];
            }

        }

        $scope.totalItensOriginal = $scope.dadosNfceDevolucao.ItensNf.length;
        if (!!$scope.dadosNfceDevolucao.ntf_cepdest == false || !!$scope.dadosNfceDevolucao.ntf_bairrodest == false || !!$scope.dadosNfceDevolucao.ntf_logradourodest == false || !!$scope.dadosNfceDevolucao.ntf_numeroenderecodest == false) {
            $scope.mostraDadosCliente = true;
        }
        $scope.dadosNfceDevolucao.dadosContribuinte = JSON.parse(dadosContribuinteAppService.buscarDadosContribuinte())[0];
        $scope.dadosNfceDevolucao.ntf_dataemissao = new Date();
        $scope.dadosNfceDevolucao.dataNotaDevolvida = $scope.dadosNfceDevolucao.ntf_dataemissao;
        $scope.dadosNfceDevolucao.dadosDestinatario = (!!$scope.dadosNfceDevolucao.dadosDestinatario) ? $scope.dadosNfceDevolucao.dadosDestinatario : {};
        $scope.dadosNfceDevolucao.dadosDestinatario.endereco = (!!$scope.dadosNfceDevolucao.dadosDestinatario.endereco) ? $scope.dadosNfceDevolucao.dadosDestinatario.endereco : {};
        $scope.dadosNfceDevolucao.dadosDestinatario.cliente = (!!$scope.dadosNfceDevolucao.dadosDestinatario.cliente) ? $scope.dadosNfceDevolucao.dadosDestinatario.cliente : {};
        $scope.dadosNfceDevolucao.dadosDestinatario.telefone = (!!$scope.dadosNfceDevolucao.dadosDestinatario.telefone) ? $scope.dadosNfceDevolucao.dadosDestinatario.telefone : {};

        var pais = $filter('filter')($scope.listaPais, { pse_codigobacen: '1058' });
        $scope.dadosNfceDevolucao.dadosDestinatario.endereco.pais = {
            pse_id: pais[0].pse_id,
            pse_nome: pais[0].pse_nome,
            pse_codigobacen: pais[0].pse_codigobacen
        };
        $scope.dadosNfceDevolucao.dadosDestinatario.endereco.ntf_cepdest = $scope.dadosNfceDevolucao.ntf_cepdest;
        $scope.dadosNfceDevolucao.dadosDestinatario.endereco.ntf_municipiodest = $scope.dadosNfceDevolucao.ntf_municipiodest;
        $scope.dadosNfceDevolucao.dadosDestinatario.endereco.ntf_bairrodest = $scope.dadosNfceDevolucao.ntf_bairrodest;
        $scope.dadosNfceDevolucao.dadosDestinatario.endereco.ntf_logradourodest = $scope.dadosNfceDevolucao.ntf_logradourodest;
        $scope.dadosNfceDevolucao.dadosDestinatario.endereco.ntf_numeroenderecodest = $scope.dadosNfceDevolucao.ntf_numeroenderecodest;
        $scope.dadosNfceDevolucao.dadosDestinatario.endereco.ntf_ufdest = $scope.dadosNfceDevolucao.ntf_ufdest;
        $scope.dadosNfceDevolucao.dadosDestinatario.endereco.ntf_codigoibgemundest = $scope.dadosNfceDevolucao.ntf_codigoibgemundest;
        $scope.dadosNfceDevolucao.dadosDestinatario.endereco.ntf_paisdest = $scope.dadosNfceDevolucao.ntf_paisdest;
        $scope.dadosNfceDevolucao.dadosDestinatario.telefone.psc_numero = $scope.dadosNfceDevolucao.ntf_telefonedest;
        if (!!$scope.dadosNfceDevolucao.ClienteId) {
            var dadosCliente = JSON.parse(clienteAppService.buscar($scope.dadosNfceDevolucao.ClienteId));
            if (!!dadosCliente) {
                $scope.dadosNfceDevolucao.dadosDestinatario.cliente.pes_id = dadosCliente.pes_id;
            } else {
                if (!!$scope.dadosNfceDevolucao.ntf_cnpjcpfdest) {
                    var dadosCli = dadosCliente = JSON.parse(clienteAppService.buscaDadosCliente($scope.dadosNfceDevolucao.ntf_cnpjcpfdest));
                    if (!!dadosCli) {
                        $scope.dadosNfceDevolucao.dadosDestinatario.cliente.pes_id = dadosCli.pes_id;
                    }
                }

            };

        }
        $scope.dadosNfceDevolucao.dadosDestinatario.cliente.ntf_nomedest = $scope.dadosNfceDevolucao.ntf_nomedest;
        $scope.dadosNfceDevolucao.dadosDestinatario.cliente.pes_fisicajuridica = 1; // sempre fisica
        $scope.dadosNfceDevolucao.dadosDestinatario.cliente.ntf_cnpjcpfdest = $scope.dadosNfceDevolucao.ntf_cnpjcpfdest;

        for (var i = 0; i < $scope.dadosNfceDevolucao.ItensNf.length; i++) {
            //var cfop = $scope.dadosNfceDevolucao.ItensNf[i].nfi_cfop;
            //$scope.dadosNfceDevolucao.ItensNf[i].nfi_cfop = correlacaoCFOPAppService.correlacaoCFOP(cfop.toString());

            $scope.dadosNfceDevolucao.ItensNf[i].nps_cstpis = (!!$scope.dadosNfceDevolucao.ItensNf[i].nps_cstpis) ? $scope.buscaPisCofinsDevolucao($scope.dadosNfceDevolucao.ItensNf[i].nps_cstpis) : null;
            $scope.dadosNfceDevolucao.ItensNf[i].nco_cstcofins = (!!$scope.dadosNfceDevolucao.ItensNf[i].nco_cstcofins) ? $scope.buscaPisCofinsDevolucao($scope.dadosNfceDevolucao.ItensNf[i].nco_cstcofins) : null;
            $scope.dadosNfceDevolucao.ItensNf[i].qtdeOriginal = $scope.dadosNfceDevolucao.ItensNf[i].nfi_qtde - $scope.dadosNfceDevolucao.ItensNf[i].qtdeDevolvida;
            $scope.dadosNfceDevolucao.ItensNf[i].qtdeRestante = $scope.dadosNfceDevolucao.ItensNf[i].nfi_qtde - $scope.dadosNfceDevolucao.ItensNf[i].qtdeDevolvida;
        }
    };

    $scope.verificarQuantidade = function (item) {
        if (parseFloat(item.qtdeRestante) > item.qtdeOriginal) {
            item.qtdeRestante = item.qtdeOriginal;
            swal("Quantidade informada maior que quantidade disponível para devolução!", "", "warning");
        }
        if (!!!parseFloat(item.qtdeRestante)) {
            item.qtdeRestante = item.qtdeOriginal;
            swal("Deve-se informar uma Quantidade para a devolução ou remover este item!", "", "warning");
        }
    };

    $scope.buscaPisCofinsDevolucao = function (cstPisCofins) {
        switch (cstPisCofins) {
            case "01":
            case "02":
            case "03":
                pisCofinsCst = "50";
                break;
            case "04":
            case "06":
                pisCofinsCst = "73";
                break;
            case "05":
                pisCofinsCst = "75";
                break;
            case "07":
                pisCofinsCst = "71";
                break;
            case "08":
                pisCofinsCst = "74";
                break;
            case "09":
                pisCofinsCst = "72";
                break;
            case "50":
            case "51":
            case "52":
            case "53":
            case "54":
            case "55":
            case "56":
            case "60":
            case "61":
            case "62":
            case "63":
            case "64":
            case "65":
            case "66":
            case "67":
                pisCofinsCst = "01";
                break;
            case "70":
            case "73":
                pisCofinsCst = "06";
                break;
            case "71":
                pisCofinsCst = "07";
                break;
            case "72":
                pisCofinsCst = "09";
                break;
            case "74":
                pisCofinsCst = "08";
                break;
            case "75":
                pisCofinsCst = "05";
                break;
        }
        return pisCofinsCst;
    }


    $scope.voltarListaNotaFiscal = function () {
        DadosFormularioService.limparDados('devolucao-venda');
        $state.go('newpdv.venda-realizada');
    };

    $scope.listaValidacaoFormulario = [
        { nome: 'ser_id', obrigatorio: 'A Série Fiscal é Obrigatório', invalido: '' },
        { nome: 'ntf_dataemissao', obrigatorio: 'A Data de Emissão é Obrigatório', invalido: '' },
        { nome: 'ntf_cnpjcpfdest', obrigatorio: 'O CPF/CNPJ é Obrigatório', invalido: '' },
        { nome: 'ntf_nomedest', obrigatorio: 'O Nome do Cliente é Obrigatório', invalido: '' },
        { nome: 'pse_id', obrigatorio: 'O País é Obrigatório', invalido: '' },
        { nome: 'ntf_cepdest', obrigatorio: 'O CEP é Obrigatório', invalido: '' },
        { nome: 'ntf_logradourodest', obrigatorio: 'O Logradouro é Obrigatório', invalido: '' },
        { nome: 'ntf_numeroenderecodest', obrigatorio: 'O Número do Logradouro é Obrigatório', invalido: '' },
        { nome: 'ntf_bairrodest', obrigatorio: 'O Bairro é Obrigatório', invalido: '' }
    ];

    $scope.habilitaSalvar = true;
    $scope.validarFormulario = function (formulario) {
        $scope.habilitaSalvar = false;

        $scope.listaFormularioInvalido = [];
        ValidarFormularioService.listaFormularioInvalido(formulario, $scope.listaValidacaoFormulario).then(function (retorno) {
            $scope.listaFormularioInvalido = retorno.lista;
            $scope.mensagemFormularioInvalido = retorno.mensagem;
            $scope.dadosNfceDevolucao.dadosDestinatario.antecipacao = false;
            if ($scope.dadosNfceDevolucao.ItensNf.length === 0) {
                $scope.listaFormularioInvalido.push({ nome: 'item', mensagem: 'É necessário informar pelo menos um item' });
            }
            if ($scope.listaFormularioInvalido.length > 1) {
                $scope.mensagemFormularioInvalido = 'Antes de salvar verifique os erros:';
            }
            if ($scope.totalItensOriginal == $scope.dadosNfceDevolucao.ItensNf.length) {
                devolucaoTotal = true;
            }
            if ($scope.listaFormularioInvalido.length === 0) {
                swal({
                    title: "Deseja gerar antecipação/crédito do valor desta venda para o cliente?",
                    text: "",
                    type: "warning",
                    showCancelButton: true,
                    cancelButtonText: "Não, devolver dinheiro / Estornar Parcelas",
                    confirmButtonClass: "btn-danger",
                    confirmButtonText: "Sim, quero gerar o crédito",
                    closeOnConfirm: false,
                    closeOnCancel: false
                }, function (acao) {
                    if (acao) {
                        $timeout(function () {
                            $scope.dadosNfceDevolucao.dadosDestinatario.antecipacao = true;
                            $scope.salvarNotaDevolucao();
                        });
                    } else {
                        $scope.dadosNfceDevolucao.dadosDestinatario.antecipacao = false;
                        $scope.salvarNotaDevolucao();
                    }
                });
            }
        })
    };

    $scope.salvarNotaDevolucao = function () {
        $scope.dadosNfceDevolucao.emitirNfe = true;
        $scope.notaDevolucaoFinal = {
            serieFiscal: {},
            dadosContribuinte: {},
            itens: [],
            dadosDestinatario: {},
            dadosReferenciada: {}
        };

        $scope.notaDevolucaoFinal.dadosDestinatario.endereco = (!!$scope.dadosNfceDevolucao.dadosDestinatario.endereco) ? $scope.dadosNfceDevolucao.dadosDestinatario.endereco : {};
        $scope.notaDevolucaoFinal.dadosDestinatario.cliente = (!!$scope.dadosNfceDevolucao.dadosDestinatario.cliente) ? $scope.dadosNfceDevolucao.dadosDestinatario.cliente : {};
        $scope.notaDevolucaoFinal.dadosDestinatario.telefone = (!!$scope.dadosNfceDevolucao.dadosDestinatario.telefone) ? $scope.dadosNfceDevolucao.dadosDestinatario.telefone : {};
        $scope.notaDevolucaoFinal.dadosContribuinte = (!!$scope.dadosNfceDevolucao.dadosContribuinte) ? $scope.dadosNfceDevolucao.dadosContribuinte : {};
        $scope.notaDevolucaoFinal.dadosReferenciada = (!!$scope.dadosNfceDevolucao.dadosReferenciada) ? $scope.dadosNfceDevolucao.dadosReferenciada : {};

        $scope.notaDevolucaoFinal.dadosReferenciada.ntf_chavenfe = $scope.dadosNfceDevolucao.ntf_chavenfe;
        $scope.notaDevolucaoFinal.dadosReferenciada.ntf_id = $scope.dadosNfceDevolucao.ntf_id;


        $scope.notaDevolucaoFinal.ntf_id = null;
        $scope.notaDevolucaoFinal.ntf_numero = '';
        $scope.notaDevolucaoFinal.ntf_chavenfe = '';
        $scope.notaDevolucaoFinal.ven_id = $scope.dadosNfceDevolucao.ven_id;
        $scope.notaDevolucaoFinal.ntf_dataemissao = $scope.dadosNfceDevolucao.ntf_dataemissao;
        $scope.notaDevolucaoFinal.ntf_status = $scope.dadosNfceDevolucao.ntf_status;

        $scope.notaDevolucaoFinal.serieFiscal.ser_serie = (!!$scope.dadosNfceDevolucao.serieFiscal) ? $scope.dadosNfceDevolucao.serieFiscal.ser_serie : null;
        $scope.notaDevolucaoFinal.serieFiscal.ser_id = (!!$scope.dadosNfceDevolucao.serieFiscal) ? $scope.dadosNfceDevolucao.serieFiscal.ser_id : null;
        $scope.notaDevolucaoFinal.serieFiscal.ser_numero = (!!$scope.dadosNfceDevolucao.serieFiscal) ? $scope.dadosNfceDevolucao.serieFiscal.ser_numero : null;

        $scope.notaDevolucaoFinal.dadosDestinatario.cliente.pes_id = (!!$scope.dadosNfceDevolucao.dadosDestinatario.cliente.pes_id) ? $scope.dadosNfceDevolucao.dadosDestinatario.cliente.pes_id : null;
        $scope.notaDevolucaoFinal.dadosDestinatario.cliente.ntf_emaildest = $scope.dadosNfceDevolucao.ntf_emaildest;
        $scope.notaDevolucaoFinal.dadosDestinatario.endereco.ntf_cepdest = $scope.dadosNfceDevolucao.dadosDestinatario.endereco.ntf_cepdest;
        $scope.notaDevolucaoFinal.dadosDestinatario.endereco.ntf_municipiodest = $scope.dadosNfceDevolucao.dadosDestinatario.endereco.ntf_municipiodest;
        $scope.notaDevolucaoFinal.dadosDestinatario.endereco.ntf_bairrodest = $scope.dadosNfceDevolucao.dadosDestinatario.endereco.ntf_bairrodest;
        $scope.notaDevolucaoFinal.dadosDestinatario.endereco.ntf_logradourodest = $scope.dadosNfceDevolucao.dadosDestinatario.endereco.ntf_logradourodest;
        $scope.notaDevolucaoFinal.dadosDestinatario.endereco.ntf_numeroenderecodest = $scope.dadosNfceDevolucao.dadosDestinatario.endereco.ntf_numeroenderecodest;
        $scope.notaDevolucaoFinal.dadosDestinatario.endereco.ntf_ufdest = $scope.dadosNfceDevolucao.dadosDestinatario.endereco.ntf_ufdest;
        $scope.notaDevolucaoFinal.dadosDestinatario.endereco.ntf_codigoibgemundest = $scope.dadosNfceDevolucao.dadosDestinatario.endereco.ntf_codigoibgemundest;
        $scope.notaDevolucaoFinal.dadosDestinatario.endereco.ntf_paisdest = $scope.dadosNfceDevolucao.dadosDestinatario.endereco.pais.ntf_paisdest;
        $scope.notaDevolucaoFinal.dadosDestinatario.telefone.psc_numero = $scope.dadosNfceDevolucao.dadosDestinatario.telefone.psc_numero;
        $scope.notaDevolucaoFinal.dadosDestinatario = $scope.dadosNfceDevolucao.dadosDestinatario;

        if (!!$scope.dadosNfceDevolucao.dadosDestinatario.endereco.ntf_cepdest) {
            retornoPostmon = JSON.parse(notaFiscalDevolucaoAppService.buscaCidade($scope.dadosNfceDevolucao.dadosDestinatario.endereco.ntf_cepdest));
            if (retornoPostmon != null) {
                if (!!retornoPostmon.cidade) {
                    $scope.notaDevolucaoFinal.dadosDestinatario.endereco.ntf_paisdest = retornoPostmon.cidade.pais;
                    $scope.dadosNfceDevolucao.dadosDestinatario.endereco.ntf_codigoibgemundest = retornoPostmon.cidade_info.codigo_ibge;
                } else {
                    growlService.growl('Cep ' + cep + ' não encontrado!', 'inverse');
                    $scope.notaDevolucaoFinal.dadosDestinatario.endereco.ntf_paisdest = '';
                    $scope.dadosNfceDevolucao.dadosDestinatario.endereco.ntf_codigoibgemundest = null;
                };
            } else {

            };
        }
        var numeroItem = 0;
        $scope.notaDevolucaoFinal.valorTotal = 0;
        angular.forEach($scope.dadosNfceDevolucao.ItensNf, function (item) {
            item.nfi_numeroitemreferenciada = item.nfi_numeroitem;
            item.nfi_id = null;
            numeroItem = numeroItem + 1
            item.nfi_numeroitem = numeroItem;

            var valorDesconto = item.nfi_valordesconto;
            var valorOutros = item.nfi_valoroutros;
            var valorFrete = item.nfi_valorfrete;
            var valorSeguro = item.nfi_valorseguro;

            if (item.qtdeRestante != item.qtdeOriginal) {
                if (!!valorDesconto) {
                    var descontoPorUnidade = (valorDesconto / item.qtdeOriginal);
                    valorDesconto = (descontoPorUnidade * item.qtdeRestante);
                }
                if (!!valorOutros) {
                    var outrosPorUnidade = (valorOutros / item.qtdeOriginal);
                    valorOutros = (outrosPorUnidade * item.qtdeRestante);
                }
                if (!!valorFrete) {
                    var fretePorUnidade = (valorFrete / item.qtdeOriginal);
                    valorFrete = (fretePorUnidade * item.qtdeRestante);
                }
                if (!!valorSeguro) {
                    var seguroPorUnidade = (valorSeguro / item.qtdeOriginal);
                    valorSeguro = (seguroPorUnidade * item.qtdeRestante);
                }
            }
            $scope.notaDevolucaoFinal.valorTotal += (((item.nfi_valorunitario * item.qtdeRestante) + (valorOutros + valorFrete + valorSeguro)) - valorDesconto);

            $scope.notaDevolucaoFinal.itens.push(item);
        });

        console.log('$scope.notaDevolucaoFinal', $scope.notaDevolucaoFinal);
        var retornoNF = notaFiscalDevolucaoAppService.incluirDevolucao($scope.notaDevolucaoFinal);

        console.log('retornoNF', retornoNF);

        if (retornoNF != null) {
            if (retornoNF.ntf_status == 1 && !!retornoNF.ntf_chavenfe) {
                if (!!retornoNF.ntf_docfiscal) {
                    var urlDanfe = danfeAppService.retornarURLDanfeNewERP();
                    window.open(urlDanfe + "" + retornoNF.ntf_chavenfe, '_blank');
                } else {
                    if (navigator.onLine) {
                        RelatorioService.exibirRelatorioJasper(20, [
                            {
                                'nome': 'idNotaFiscal',
                                'valor': retornoNF.ntf_id
                            }
                        ]);
                    }
                }

            } else {
                $scope.habilitaSalvar = true;
            }

            if (retornoNF.ntf_status == 1 && !!retornoNF.ntf_chavenfe) {
                if ($scope.dadosNfceDevolucao.dadosDestinatario.antecipacao == true) {
                    var idCliente = (retornoNF.clienteId) ? retornoNF.clienteId : null;

                    //var retornoModeloCarne = JSON.parse(notaFiscalDevolucaoAppService.imprimirComprovanteCredito(retornoNF.clienteId, retornoNF.ntf_id));
                    var retornoModeloCarne = JSON.parse(notaFiscalDevolucaoAppService.imprimirComprovanteCredito(idCliente, retornoNF.ntf_id));
                }
            }
        } else {
            $timeout(function () {
                $scope.habilitaSalvar = true;
            }, 1000);

        }
        if (retornoNF != null) {
            swal({
                title: 'Devolução Realizada com Sucesso!',
                text: "",
                type: "success",
                confirmButtonClass: "btn-info",
                confirmButtonText: "OK",
                closeOnConfirm: true
            }, function (acao) {
                if (acao) {
                    $scope.voltarListaNotaFiscal();
                }
            });
        } else {
            swal.close();
        }

        /*verifica as formas de pagamento para alertar o usuario para fazer a devolução na maquina de cartao caso for essa a forma de pagamento*/
        //if ($scope.dadosNfceDevolucao.FormaPgto.length > 1) {
        //    var possuiPagamentoCartao = false;
        //    angular.forEach($scope.dadosNfceDevolucao.FormaPgto, function (forma) {
        //        var tipoPagamento = formaPagamentoAppService.retornaTipoPagamento(forma.fpg_id);
        //        var tipoPagamentoCartaoCredito = $scope.tipoPagamento[2].Key;
        //        if (tipoPagamento === tipoPagamentoCartaoCredito) {
        //            possuiPagamentoCartao = true;
        //        }
        //    });
        //    if (possuiPagamentoCartao) {
        //        swal({
        //            title: "",
        //            text: "Atenção, Lembre-se de realizar a devolução na Máquina do Cartão!",
        //            type: "warning",
        //            showCancelButton: false,
        //            cancelButtonText: "",
        //            confirmButtonClass: "btn-default",
        //            confirmButtonText: "OK",
        //            closeOnConfirm: true
        //        }, function (acao) {
        //            if (acao) {
        //                $scope.voltarListaNotaFiscal();
        //            }
        //        });
        //    } else {
        //        swal.close();
        //    }
        //} else {
        //    var tipoPagamento = formaPagamentoAppService.retornaTipoPagamento($scope.dadosNfceDevolucao.FormaPgto[0].fpg_id);
        //    var tipoPagamentoCartaoCredito = $scope.tipoPagamento[2].Key;
        //    if (tipoPagamento === tipoPagamentoCartaoCredito) {
        //        swal({
        //            title: "",
        //            text: "Atenção, Lembre-se de realizar a devolução na Máquina do Cartão!",
        //            type: "warning",
        //            showCancelButton: false,
        //            cancelButtonText: "",
        //            confirmButtonClass: "btn-default",
        //            confirmButtonText: "OK",
        //            closeOnConfirm: true
        //        }, function (acao) {
        //            if (acao) {
        //                $scope.voltarListaNotaFiscal();
        //            }
        //        });
        //    } else {
        //        swal.close();
        //        $scope.voltarListaNotaFiscal();
        //    }
        //}
    };

    $scope.removeItemNotaFiscal = function (nota, item, posicao) {
        swal({
            title: "Remover o Item Selecionado?",
            text: "",
            type: "warning",
            showCancelButton: true,
            cancelButtonText: "Não",
            confirmButtonClass: "btn-danger",
            confirmButtonText: "Sim, quero remover"
        }, function (acao) {
            if (acao) {
                $timeout(function () {
                    nota.ItensNf.splice(posicao, 1);
                });
            }
        });
    };

    $scope.lerDadosResumoNotaFiscalDevolucao = function () {
        $scope.resumo = {
            valorProduto: 0,
            valorBaseICMS: 0,
            valorICMS: 0,
            valorBaseIPI: 0,
            valorIPI: 0
        };
        angular.forEach($scope.dadosNfceDevolucao.listaNotaDevolucao, function (notas) {
            angular.forEach(notas.itens, function (item) {
                $scope.resumo.valorProduto += (item.nfi_valorunitario * item.qtdeRestante);
                $scope.resumo.valorBaseICMS += (item.nig_valorbc);
                $scope.resumo.valorICMS += (item.nig_valoricms);
            });
            $scope.resumo.valorTotalNotaFiscal = $scope.resumo.valorProduto + $scope.resumo.valorFrete + $scope.resumo.valorOutros + $scope.resumo.valorSeguro + $scope.resumo.valorIPI + $scope.resumo.valorICMSST;
        });
    };

    $scope.verificaClienteCadastrado = function (cpf, status) {
        if (!!cpf) {
            $scope.dadosNfceDevolucao.dadosDestinatario.cliente.ntf_nomedest = "";
            if (status == false) {
                swal({
                    title: "CPF informado inválido!",
                    text: "",
                    type: "warning",
                    showCancelButton: false,
                    confirmButtonClass: "btn-success",
                    confirmButtonText: " OK ",
                    closeOnConfirm: true
                }, function () {
                    $timeout(function () {
                        var campoCpfCnpj = document.getElementById("ntf_cnpjcpfdest");
                        campoCpfCnpj.focus();
                    }, 100);
                });
            } else {
                dadosCliente = JSON.parse(clienteAppService.buscaDadosCliente(cpf));
                if (!!dadosCliente) {
                    $scope.dadosNfceDevolucao.dadosDestinatario.cliente.pes_id = dadosCliente.pes_id;
                    $scope.dadosNfceDevolucao.dadosDestinatario.cliente.ntf_nomedest = dadosCliente.pes_nome;
                    if (!!$scope.dadosNfceDevolucao.ntf_cepdest == false || !!$scope.dadosNfceDevolucao.ntf_bairrodest == false || !!$scope.dadosNfceDevolucao.ntf_logradourodest == false || !!$scope.dadosNfceDevolucao.ntf_numeroenderecodest == false) {
                        dadosEndereco = JSON.parse(clienteAppService.buscaDadosEndereco(dadosCliente.Id));
                        dadosTelefone = JSON.parse(clienteAppService.buscaDadosTelefone(dadosCliente.Id));
                        $scope.dadosNfceDevolucao.dadosDestinatario.endereco.ntf_cepdest = (dadosEndereco.pee_cep) ? dadosEndereco.pee_cep : null;
                        $scope.dadosNfceDevolucao.dadosDestinatario.endereco.ntf_municipiodest = dadosEndereco.pee_cidade;
                        $scope.dadosNfceDevolucao.dadosDestinatario.endereco.ntf_bairrodest = dadosEndereco.pee_bairro;
                        $scope.dadosNfceDevolucao.dadosDestinatario.endereco.ntf_logradourodest = dadosEndereco.pee_endereco;
                        $scope.dadosNfceDevolucao.dadosDestinatario.endereco.ntf_numeroenderecodest = dadosEndereco.pee_numero;
                        $scope.dadosNfceDevolucao.dadosDestinatario.endereco.ntf_ufdest = dadosEndereco.pee_uf;
                        $scope.dadosNfceDevolucao.dadosDestinatario.telefone.psc_numero = (dadosTelefone) ? dadosTelefone.psc_numero : dadosCliente.psc_numero;
                        $scope.dadosNfceDevolucao.ntf_emaildest = dadosCliente.pej_emailpessoacontato;
                        $scope.dadosNfceDevolucao.ntf_bacenpaisdest = '1058';
                        $scope.dadosNfceDevolucao.ntf_bacenpaisemitente = '1058';
                        $scope.habilitaSalvar = true;
                    } else {
                        setTimeout(function () {
                            $scope.mostraDadosCliente = false;
                            $scope.$digest();
                        }, 200);
                    }
                }
            }
        }
    };

    $scope.validaCPF = function () {

    }

    $scope.validaCamposEmBranco = function (conteudoCampo, nomeCampo) {
        if (nomeCampo) {
            //if (nomeCampo == 'ntf_nomedest')
            //    $scope.habilitaSalvar = true;
            //if (nomeCampo == "ntf_cepdest")
            //    $scope.habilitaSalvar = true;
            if (nomeCampo == "ntf_logradourodest") {
                if (conteudoCampo == "") {
                    $scope.habilitaSalvar = true;
                    swal("Logradouro precisa ser informado!", "", "warning");
                }
                else if (conteudoCampo.length <= 3) {
                    $scope.habilitaSalvar = true;
                    swal("Logradouro precisa ter mais de 3 caracteres!", "", "warning");
                }

            }
            //if (nomeCampo == "ntf_numeroenderecodest")
            //    $scope.habilitaSalvar = true;
            //if (nomeCampo == "ntf_bairrodest")
            //    $scope.habilitaSalvar = true;
        }
    }

}]);