﻿newERP.controller('ConfiguracaoController', ['$scope', '$state', '$timeout', function ($scope, $state, $timeout) {

    var etapasConfiguracaoPdv = {
        perfilPdv: 1,
        preVenda: 2,
        balancaCheckOut: 3
    }

    $scope.etapaConfiguracao = etapasConfiguracaoPdv.perfilPdv;
    defineTituloEtapa();

    $scope.configuracoesAvancadasPreVenda = false;
    $scope.possuiBalancaCheckOut = false;
    $scope.balancaCheckOut = {};

    var tipoPdv = {
        varejo: 0,
        supermercado: 1
    }

    var modeloRelatorio = {
        naoFiscal: 0,
        normal: 1
    }

    $scope.listaBalancas = JSON.parse(enumAppService.listaEnum('ModeloBalanca'));

    $scope.configuracoes = {
        TipoPdv: tipoPdv.varejo,
        UtilizaPreVenda: false,
        PortaPreVenda: 8089,
        ModeloBalanca: null,
        PortaBalanca: null,
        VelocidadePortaBalanca: null,
        DigitoInicialBalanca: null,
        TamanhoCodBarrasBalanca: null,
        BalancaCodBarProdutoInicio: null,
        BalancaCodBarProdutoFim: null,
        BalancaCodBarPesoValorInicio: null,
        BalancaCodBarPesoValorFim: null,
        BalancaCodBarPesoOuValor: null,
        BalancaCodBarCasasDecimais: null,
        ModeloRelatorio: modeloRelatorio.naoFiscal,
        RelatorioId: null
    }

    $scope.defineTipoPdv = function(tipo) {
        $scope.configuracoes.TipoPdv = tipo;
    }

    $scope.avancarEtapaConfiguracao = function () {
        if ($scope.etapaConfiguracao == etapasConfiguracaoPdv.balancaCheckOut) {
            $scope.salvarConfiguracao();
        }
        else {
            if ($scope.configuracoes.TipoPdv == tipoPdv.varejo) $scope.etapaConfiguracao += 1;
            else $scope.etapaConfiguracao = etapasConfiguracaoPdv.balancaCheckOut;
            defineTituloEtapa();
        }
    }

    $scope.voltarEtapaConfiguracao = function() {
        if ($scope.etapaConfiguracao > 1) {
            if ($scope.configuracoes.TipoPdv == tipoPdv.varejo) $scope.etapaConfiguracao -= 1;
            else $scope.etapaConfiguracao = etapasConfiguracaoPdv.perfilPdv;
            defineTituloEtapa();
        }
    }

    $scope.salvarConfiguracao = function () {
        swal({
            title: "Confirmar esta Configuração de Ponto de Venda?",
            text: "Você confirma os dados informados neste processo de configuração do PDV?",
            type: "warning",
            showCancelButton: true,
            cancelButtonText: "NÃO, revisar configurações",
            confirmButtonClass: "btn-info",
            confirmButtonText: "SIM! Confirmar esta configuração",
            closeOnConfirm: true
        }, function (acao) {
            if (acao) {
                $timeout(function () {
                    if (setupPdvService.salvarConfiguracoesPdv(JSON.stringify($scope.configuracoes)) == true) {
                        $state.go('confirmacao-configuracao');
                    }
                }, 100);
            }
            else {
                $timeout(function () {
                    $scope.etapaConfiguracao = etapasConfiguracaoPdv.perfilPdv;
                },100);
            }
        });
    }

    $scope.iniciarUso = function () {
        var configPdv = JSON.parse(setupPdvService.retornaConfiguracaoPdv());
        if (configPdv.TipoPdv == tipoPdv.varejo) $state.go('newpdv.venda-varejo');
        if (configPdv.TipoPdv == tipoPdv.supermercado) $state.go('newpdv.supermercado-pdv');
    }

    function defineTituloEtapa() {
        switch ($scope.etapaConfiguracao) {
            case etapasConfiguracaoPdv.perfilPdv:
                $scope.tituloEtapa = "Selecione o perfil deste Ponto de Venda";
                break;
            case etapasConfiguracaoPdv.preVenda:
                $scope.tituloEtapa = "Este PDV irá operar com sistema de registro de Pré-Venda?";
                break;
            case etapasConfiguracaoPdv.balancaCheckOut:
                $scope.tituloEtapa = "Este PDV possui integração com balança de checkout?";
                break;
        }
    }

}]);