/*!
 * angular-qr v0.2.0
 * The MIT License
 * Copyright (c) 2014 Jan Antala <hello@janantala.com>
 */

!function(t){"use strict";angular.module("ja.qr",[]).controller("QrCtrl",["$scope",function(t){t.getTypeNumeber=function(){return t.typeNumber||0},t.getCorrection=function(){var e={L:1,M:0,Q:3,H:2},r=t.correctionLevel||0;return e[r]||0},t.getText=function(){return t.text||""},t.getSize=function(){return t.size||250},t.isNUMBER=function(t){var e=/^[0-9]*$/;return e.test(t)},t.isALPHA_NUM=function(t){var e=/^[0-9A-Z $%*+\-./:]*$/;return e.test(t)},t.is8bit=function(t){for(var e=0;e<t.length;e++){var r=t.charCodeAt(e);if(r>255)return!1}return!0},t.checkInputMode=function(e,r){if("NUMBER"===e&&!t.isNUMBER(r))throw new Error("The `NUMBER` input mode is invalid for text.");if("ALPHA_NUM"===e&&!t.isALPHA_NUM(r))throw new Error("The `ALPHA_NUM` input mode is invalid for text.");if("8bit"===e&&!t.is8bit(r))throw new Error("The `8bit` input mode is invalid for text.");if(!t.is8bit(r))throw new Error("Input mode is invalid for text.");return!0},t.getInputMode=function(e){var r=t.inputMode;return r=r||(t.isNUMBER(e)?"NUMBER":void 0),r=r||(t.isALPHA_NUM(e)?"ALPHA_NUM":void 0),r=r||(t.is8bit(e)?"8bit":""),t.checkInputMode(r,e)?r:""}}]).directive("qr",["$timeout","$window",function(e,r){return{restrict:"E",template:'<canvas ng-hide="image"></canvas><image ng-if="image" ng-src="{{canvasImage}}"/>',scope:{typeNumber:"=",correctionLevel:"=",inputMode:"=",size:"=",text:"=",image:"="},controller:"QrCtrl",link:function(n,i){if(void 0===n.text)throw new Error("The `text` attribute is required.");var o=i.find("canvas")[0],E=!!r.CanvasRenderingContext2D;n.TYPE_NUMBER=n.getTypeNumeber(),n.TEXT=n.getText(),n.CORRECTION=n.getCorrection(),n.SIZE=n.getSize(),n.INPUT_MODE=n.getInputMode(n.TEXT),n.canvasImage="http://lorempixel.com/500/500/";var a=function(t,e,r,n){for(var i=0;r>i;i++)for(var o=0;r>o;o++){var E=Math.ceil((o+1)*n)-Math.floor(o*n),a=Math.ceil((i+1)*n)-Math.floor(i*n);t.fillStyle=e.isDark(i,o)?"#000":"#fff",t.fillRect(Math.round(o*n),Math.round(i*n),E,a)}},u=function(e,r,i,o,u,c){var T=/^\s+|\s+$/g,M=r.replace(T,""),f=new t(i,o,c);f.addData(M),f.make();var N=e.getContext("2d"),d=f.getModuleCount(),s=u/d;e.width=e.height=u,E&&(a(N,f,d,s),n.canvasImage=e.toDataURL())};u(o,n.TEXT,n.TYPE_NUMBER,n.CORRECTION,n.SIZE,n.INPUT_MODE),e(function(){n.$watch("text",function(t,e){t!==e&&(n.TEXT=n.getText(),n.INPUT_MODE=n.getInputMode(n.TEXT),u(o,n.TEXT,n.TYPE_NUMBER,n.CORRECTION,n.SIZE,n.INPUT_MODE))}),n.$watch("correctionLevel",function(t,e){t!==e&&(n.CORRECTION=n.getCorrection(),u(o,n.TEXT,n.TYPE_NUMBER,n.CORRECTION,n.SIZE,n.INPUT_MODE))}),n.$watch("typeNumber",function(t,e){t!==e&&(n.TYPE_NUMBER=n.getTypeNumeber(),u(o,n.TEXT,n.TYPE_NUMBER,n.CORRECTION,n.SIZE,n.INPUT_MODE))}),n.$watch("size",function(t,e){t!==e&&(n.SIZE=n.getSize(),u(o,n.TEXT,n.TYPE_NUMBER,n.CORRECTION,n.SIZE,n.INPUT_MODE))}),n.$watch("inputMode",function(t,e){t!==e&&(n.INPUT_MODE=n.getInputMode(n.TEXT),u(o,n.TEXT,n.TYPE_NUMBER,n.CORRECTION,n.SIZE,n.INPUT_MODE))})})}}}])}(window.QRCode);