﻿(function () {
    'use strict';
    newERP.service('VendaService', function () {
        var vendaFactory = {};

        var _iniciaVenda = function (cpfCnpj, nomeCliente) {
            return emitirDocumentoFiscalService.iniciaVenda(cpfCnpj, nomeCliente);
        };

        var _adicionaItem = function (dadosItem) {
            return emitirDocumentoFiscalService.adicionaItem(dadosItem);
        };

        var _editarItem = function (numeroItem, dadosItem) {
            return emitirDocumentoFiscalService.editarItem(numeroItem, dadosItem);
        }

        var _removerItem = function (nroItemRemover) {
            return emitirDocumentoFiscalService.removerItem(nroItemRemover);
        };
        var _removerItens = function () {
            return emitirDocumentoFiscalService.removerItens();
        };

        var _aplicaDescontoVenda = function (descontoConcedido) {
            return emitirDocumentoFiscalService.aplicaDescontoVenda(descontoConcedido);
        };

        var _aplicarFormaPagamento = function (dadosFormaPgto) {
            return emitirDocumentoFiscalService.aplicarFormaPagamento(dadosFormaPgto);
        }

        var _adicionarTransportador = function (trans) {
            return emitirDocumentoFiscalService.adicionarTransportador(trans);
        }

        var _alterarIndicadorPresenca = function (entregaDomicilio) {
            return emitirDocumentoFiscalService.alterarIndicadorPresenca(entregaDomicilio);
        }


        var _removerFormaPagamento = function (indicePagamento) {
            return emitirDocumentoFiscalService.removerFormaPagamento(indicePagamento);
        }

        var _alteraValorPagamento = function (novoValor, indicePagamento) {
            return emitirDocumentoFiscalService.alteraValorPagamento(novoValor, indicePagamento);
        }

        var _finalizaVenda = function (emitirDocFiscal, dadosFormaPgto, cpfCnpj, nome, vendedorId, idEstrangeiro, idCliente, observacao, contingenciaApi = false, emailEnvioNfe = '') {
            return emitirDocumentoFiscalService.finalizaVenda(emitirDocFiscal, dadosFormaPgto, cpfCnpj, nome, vendedorId, idEstrangeiro, idCliente, observacao, contingenciaApi, emailEnvioNfe);
        };

        var _quantidadeItensCupom = function () {
            return emitirDocumentoFiscalService.quantidadeItensCupom();
        }

        var _quantidadeFormasPagamentoCupom = function () {
            return emitirDocumentoFiscalService.quantidadeFormasPagamentoCupom();
        }

        var _cancelarEmissaoCupom = function () {
            return emitirDocumentoFiscalService.cancelarEmissaoCupom();
        }

        vendaFactory.iniciaVenda = _iniciaVenda;
        vendaFactory.adicionarTransportador = _adicionarTransportador;
        vendaFactory.adicionaItem = _adicionaItem;
        vendaFactory.editarItem = _editarItem;
        vendaFactory.alterarIndicadorPresenca = _alterarIndicadorPresenca;
        vendaFactory.removerItem = _removerItem;
        vendaFactory.removerItens = _removerItens;
        vendaFactory.aplicaDescontoVenda = _aplicaDescontoVenda;
        vendaFactory.aplicarFormaPagamento = _aplicarFormaPagamento;
        vendaFactory.removerFormaPagamento = _removerFormaPagamento;
        vendaFactory.alteraValorPagamento = _alteraValorPagamento;
        vendaFactory.finalizaVenda = _finalizaVenda;
        vendaFactory.quantidadeItensCupom = _quantidadeItensCupom;
        vendaFactory.quantidadeFormasPagamentoCupom = _quantidadeFormasPagamentoCupom;
        vendaFactory.cancelarEmissaoCupom = _cancelarEmissaoCupom;

        return vendaFactory;
    });
})();