﻿newERP.controller('VendaVarejoController', ['$scope', 'ModalService', '$timeout', '$localStorage', 'VendaService', '$state', 'DadosFormularioService', 'growlService', 'hotkeys', 'FuncaoService', '$document', function ($scope, ModalService, $timeout, $localStorage, VendaService, $state, DadosFormularioService, growlService, hotkeys, FuncaoService, $document) {

    $scope.informarValorItem = false;

    $scope.apiNewERP = aplicacaoService.retornaUrlAPI();
    $scope.parametrosLocal = parametrosLocalAppService.retornaDadosParametrosLocal();

    $scope.model = {
        tipoSolicitacao: 0,
        senhaGerencial: ''
    };
    var tipoSolicitacao = {
        estoque: 1,
        descontoMaximoAdicionando: 2,
        descontoMaximoEditando: 3,
    }

    var tipoFormaPagamento = {
        fpDinheiro: 1,
        fpCheque: 2,
        fpCartaoCredito: 3,
        fpCartaoDebito: 4,
        fpCreditoLoja: 5,
        fpValeAlimentacao: 10,
        fpValeRefeicao: 11,
        fpValePresente: 12,
        fpValeCombustivel: 13,
        fpDuplicataMercantil: 14,
        fpBoletoBancario: 15,
        fpDepositoBancario: 16,
        fpPixDinamico: 17,
        fpTransferenciaBancaria: 18,
        fpCashback: 19,
        fpPixEstatico: 20,
        fpCreditoEmLoja: 21,
        fpFalhaDeHardware: 22,
        fpSemPagamento: 90,
        fpOutro: 99
    };
    var tipoControleEstoque = {
        avisar: 0,
        avisaPedirSenha: 1,
        bloquear: 2,
    };

    $scope.dadosItem = {
        ean: '',
        produto: '',
        vlrUnitario: null,
        desconto: null,
        valorTotalItem: null,
        pro_id: null
    };
    // Parou de funcionar o ESC em algumas telas, então foi usado o  hotkeys
    $(document).on('keydown', function (event) {
        // Usa o console.log para depuração
        console.log(event.key);

        // Verifica se a tecla pressionada é a tecla PageDown
        if (event.key === 'PageDown') {
            // Impede o comportamento padrão da tecla, se necessário
            event.preventDefault();
            // Usa $scope.$apply para garantir que o AngularJS detecte as mudanças
            $scope.$apply(function () {
                if ($scope.dadosVenda && $scope.dadosVenda.listaItens && $scope.dadosVenda.listaItens.length > 0) {
                    $scope.finalizaVenda();
                }
            });
        }

        // Verifica se a tecla pressionada é a tecla F7
        if (event.key === 'F8') {
            event.preventDefault();
            $scope.$apply(function () {
                if (typeof $scope.cancelarVenda === 'function') {
                    $scope.cancelarVenda();
                }
            });
        }

        // Verifica se a tecla pressionada é a tecla F5
        if (event.key === 'F5') {
            let modoExibicao = 'fa-search';
            if (!!$localStorage.exibicaoProduto) {
                modoExibicao = $localStorage.exibicaoProduto[0].modoExibir;
            }
            event.preventDefault();
            $scope.$apply(function () {
                if (typeof $scope.modoExibirPesquisaProduto === 'function') {
                    $scope.modoExibirPesquisaProduto(modoExibicao);
                }
            });
        }

        if (event.key === 'F2') {
            event.preventDefault();
            $scope.$apply(function () {
                $scope.ListaCliente();
            })
        }

        if (event.key === 'esc') {
            event.preventDefault();
            $scope.$apply(function () {
                $scope.close();
            })
        }
    });


    // Remove o evento quando o controlador é destruído para evitar vazamento de memória
    $scope.$on('$destroy', function () {
        $(document).off('keydown');
    });

    $scope.verificaAtualizacao = function () {
        growlService.growl('Verificando atualizações...', 'inverse', 'center');
        aplicacaoService.verificarAtualizacoes();
    };

    $scope.abrirModalCheque = function () {
        $scope.modalCheque = ModalService.model($scope, 'views/pdv/cheques/modalCheques.html', 'lg', true, true, true);
    };

    $scope.abrirConsultaEstoque = function () {
        $scope.modalConsultaEstoque = ModalService.model($scope, 'views/pdv/varejo/modalConsultaProduto.html', 'lg', true, true, true);
    };

    $scope.ListaVendedor = function () {
        $scope.modalVendedor = ModalService.model($scope, 'views/pdv/varejo/modalVendedor.html', '', true, true, true);
        $scope.buscaVendedor();
    };

    $scope.ListaCliente = function () {
        if ($scope.dadosVenda.idVendaCondicional) {
            swal("Atenção!", "Esta venda é referente a um Condicional,esta ação não é permitida. Tal ação deve ser efetuada na manutenção de Condicional!", "warning");
        } else {
            // Buscar novos clientes
            clienteAppService.buscarNovosClientesApi();

            $scope.DivVisibility = false;
            $scope.modalCliente = ModalService.model($scope, 'views/pdv/varejo/modalBuscarCliente.html', 'xg', true, 'static', true);
            if (!!$scope.dadosVenda.pes_cpfcnpj) $scope.cpfCnpj = $scope.dadosVenda.pes_cpfcnpj;
            if (!!$scope.dadosVenda.pes_nome) $scope.nome = $scope.dadosVenda.pes_nome;
            if (!!$scope.dadosVenda.pes_id) $scope.pes_id = $scope.dadosVenda.pes_id;
            $timeout(function () {
                $scope.marcarTexto('cpfCnpj');
            }, 100);
        }
    };

    $scope.removerCliente = function () {
        if ($scope.dadosVenda.idVendaCondicional) {
            swal("Atenção!", "Esta venda é referente a um Condicional,esta ação não é permitida. Tal ação deve ser efetuada na manutenção de Condicional!", "warning");
        }
        else {
            if ($scope.dadosVenda.cli_id || $scope.dadosVenda.ClienteId) {
                if (!!$scope.dadosVenda.pagamento) {
                    if ($scope.dadosVenda.pagamento.length > 0) {
                        $scope.dadosVenda.pagamento = [];
                        $scope.totalPago = 0;
                    }
                }
                $scope.dadosVenda.pes_cpfcnpj = null;
                $scope.dadosVenda.pes_nome = null;
                $scope.dadosVenda.cli_id = null;
                $scope.dadosVenda.ClienteId = null;
                $scope.dadosVenda.clienteIdentificado = false;
            }
        }
    };

    $scope.cancelaIdentificacaoCliente = function () {
        if (!!$scope.ultimoCpfCnpjInformado) {
            $scope.selecionarCliente($scope.ultimoCpfCnpjInformado, $scope.ultimoNomeInformado);
        } else {
            $scope.cpfCnpj = '';//$scope.dadosVenda.pes_cpfcnpj;
            $scope.nome = '';//$scope.dadosVenda.pes_nome;
            $scope.dadosVenda.pes_cpfcnpj = '';//(!!dadosCliente.pef_cpf) ? dadosCliente.pef_cpf : dadosCliente.pej_cnpj;
            $scope.dadosVenda.pes_nome = '';//dadosCliente.pes_nome;
            $scope.dadosVenda.cli_id = '';//dadosCliente.cli_id;
            $scope.dadosVenda.ClienteId = '';//dadosCliente.Id;
            $scope.modalCliente.close();
        }
    };

    $scope.abrirModalSuprimentoSangria = function () {
        $scope.modalAberturaChamado = ModalService.model($scope, 'views/pdv/suprimento_sangria_caixa/modalSuprimentoSangriaCaixa.html', 'lg', true, true, true);
    };

    $scope.abrirModalGradesVendas = function () {
        if (!!$scope.modalGradesVendas) {
            $scope.modalGradesVendas.dismiss();
            delete $scope.modalGradesVendas;
        }

        $scope.modalGradesVendas = ModalService.model($scope, 'views/pdv/varejo/modalProdutosGradesVendas.html', 'lg', true, 'static', false);
        jaAbriuModalGradeProduto = true;
    };

    hotkeys.bindTo($scope).add({
        combo: 'ctrl+alt+m',
        description: 'Exibir QRCode para conexão mobile',
        allowIn: ['INPUT'],
        callback: function () {
            ModalService.model($scope, 'views/pdv/acesso-api-pdv/modalAcessoApiPdv.html', 'lg', true, true, true);
        }
    }).add({
        combo: 'ctrl+alt+d',
        description: 'Abrir console do desenvolvedor',
        allowIn: ['INPUT'],
        callback: function () {
            aplicacaoService.abrirConsoleDev();
        }
    }).add({
        combo: 'ctrl+e',
        description: 'Abrir consulta de estoque de produtos',
        allowIn: ['INPUT'],
        callback: function () {
            $scope.abrirConsultaEstoque();
        }
    });

    $scope.modoExibirPesquisaProduto = function (exibicaoProduto) {
        if (!!exibicaoProduto) {
            $scope.exibicaoProduto = (exibicaoProduto == 'fa-barcode') ? 'fa-search' : 'fa-barcode';
            $localStorage.exibicaoProduto = [{ 'modoExibir': $scope.exibicaoProduto }];
        } else {
            if (!!$localStorage.exibicaoProduto) {
                $scope.exibicaoProduto = $localStorage.exibicaoProduto[0].modoExibir;
            } else {
                $scope.exibicaoProduto = 'fa-barcode';
                $localStorage.exibicaoProduto = [{ 'modoExibir': $scope.exibicaoProduto }];
            }
        }
        if ($scope.exibicaoProduto == 'fa-barcode') {
            $timeout(function () {
                $scope.setarFocus('pro_descricao');
            }, 100)
        } else {
            $timeout(function () {
                $scope.setarFocus('pro_codigo');
            }, 100)
        }
    };
    $scope.modoExibirPesquisaProduto();

    $('.spinner').spinner({
        min: 0,
        max: 10
    });

    $scope.setarFocus = function (nomeElemento) {
        $timeout(function () {
            let elemento = document.getElementsByName(nomeElemento)[0];
            if (!!elemento) elemento.focus();
        });

        $timeout(function () {
            $scope.$apply(function () {
                $('select[name="' + nomeElemento + '"]').chosen({});
                $('select[name="' + nomeElemento + '"]').trigger("chosen:open");
            });
        });
    };

    $scope.lerDadosVenda = function () {
        $scope.verificarCaixaAberto();

        $timeout(function () {
            $scope.dadosVenda = DadosFormularioService.retornaDados('venda-varejo', { descontoEmValorOuPercentual: '$', acrescimoEmValorOuPercentual: '$' }).dados;
            if (!(!!$scope.dadosVenda.ven_id)) {
                var vendedorUsuario = vendedorAppService.retornaVendedorUsuarioLogado();
                if (vendedorUsuario != "") {
                    $scope.selecionaVendedor(JSON.parse(vendedorUsuario));
                }
            }

            $localStorage.padraoDesconto = $scope.dadosVenda.descontoEmValorOuPercentual;
            $localStorage.padraoAcrescimo = $scope.dadosVenda.acrescimoEmValorOuPercentual;
            $scope.totaisNota();

            if (!!$scope.dadosVenda.iniciarVenda) {
                VendaService.iniciaVenda($scope.dadosVenda.pes_cpfcnpj, $scope.dadosVenda.pes_nome);
                $scope.dadosVenda.nItem = 1;
            }

            $scope.DivVisibility = false;
            if (!!$scope.dadosVenda.listaItens) {
                if ($scope.dadosVenda.listaItens.length > 0) {
                    if (VendaService.quantidadeItensCupom() == 0) {
                        VendaService.iniciaVenda($scope.dadosVenda.pes_cpfcnpj, $scope.dadosVenda.pes_nome);
                        $scope.dadosVenda.nItem = 1;

                        angular.forEach($scope.dadosVenda.listaItens, function (itens) {
                            itens.edicao = false;
                            itens.nItem = $scope.dadosVenda.nItem;
                            VendaService.adicionaItem(itens);
                            $scope.dadosVenda.nItem++;
                        });
                    }
                };
            }
        }, 200);
    };

    $scope.buscaCliente = function (cpfCnpj, nome) {
        nome = (!!nome == true) ? nome : '';
        if (nome == "CONSUMIDOR FINAL") nome = '';
        cpfCnpj = (!!cpfCnpj == true) ? cpfCnpj : '';
        $scope.filtroClienteNome = (!!nome) ? nome : cpfCnpj;

        var listaClientePDV = JSON.parse(clienteAppService.buscaCliente(cpfCnpj, nome));
        var listaClienteNew = JSON.parse(clienteAppService.pesquisaClienteNEW(cpfCnpj, nome));

        Array.prototype.push.apply(listaClientePDV, listaClienteNew);
        var listaClientes = listaClientePDV.reduce(function (rv, x) {
            rv = (!!rv) ? rv : [];
            var clienteAdicionado = rv.filter(function (cliente) {
                return (cliente.pes_nome == x.pes_nome);
            });

            if (!!!clienteAdicionado.length)
                rv.push(x);
            return rv;
        }, []);

        $scope.listarCliente = listaClientes;
    };

    $scope.showDiv = function () {
        $scope.DivVisibility = !$scope.DivVisibility;
    };

    $scope.buscaClientePorCpfCnpj = function (cpfCnpj, cpfValido) {
        if (cpfCnpj) {
            if (clienteAppService.validarCpfCnpj(cpfCnpj) === true) {
                if ((!!cpfCnpj) && (!!cpfValido)) {
                    $scope.dadosVenda.pes_cpfcnpj = cpfCnpj;
                    $scope.dadosVenda.cli_vendasomenteavista = false;
                    var dadosCliente = JSON.parse(clienteAppService.buscaDadosCliente(cpfCnpj));
                    if (!!dadosCliente) {
                        $scope.nome = dadosCliente.pes_nome;
                        $scope.dadosVenda.pes_cpfcnpj = (!!dadosCliente.pef_cpf) ? dadosCliente.pef_cpf : dadosCliente.pej_cnpj;
                        $scope.dadosVenda.pes_nome = dadosCliente.pes_nome;
                        $scope.dadosVenda.cli_id = dadosCliente.cli_id;
                        $scope.dadosVenda.ClienteId = dadosCliente.Id;

                        $scope.dadosVenda.pes_id = dadosCliente.pes_id;
                        $scope.dadosVenda.pes_idestrangeiro = dadosCliente.pes_idestrangeiro;
                        $scope.dadosVenda.cli_vendasomenteavista = dadosCliente.cli_vendasomenteavista;
                        $scope.dadosVenda.ultimoCpfCnpjValidoInformado = cpfCnpj;
                        $scope.dadosVenda.ultimoNomeValidoInformado = $scope.dadosVenda.pes_nome;
                    } else {
                        $scope.dadosVenda.pes_nome = null;
                        $scope.dadosVenda.cli_id = null;
                        $scope.dadosVenda.ClienteId = null;
                        $scope.nome = null;
                    }
                } else {
                    $scope.dadosVenda.cli_id = null;
                    $scope.dadosVenda.ClienteId = null;
                }
            }
            else {
                swal("CPF/CNPJ inválido!", "O CPF ou CNPJ informado para o cliente é inválido!", "warning");
                $scope.cpfCnpj = null;
                $scope.dadosVenda.pes_cpfcnpj = null;
                $scope.dadosVenda.pes_nome = null;
                $scope.dadosVenda.cli_id = null;
                $scope.dadosVenda.ClienteId = null;
                $scope.nome = null;
            }
        }
    };

    $scope.cadastrarCliente = function (cpfCnpj, nome) {
        DadosFormularioService.limparDados('cliente-manutencao');
        DadosFormularioService.armazenarDados('cliente-manutencao', {
            voltarParaVenda: true,
            pes_cpfcnpj: (!!cpfCnpj) ? cpfCnpj : null,
            pes_nome: (!!cpfCnpj) ? (!!cpfCnpj.length == 11) ? nome : null : null,
            pej_nomefantasia: (!!cpfCnpj) ? (!!cpfCnpj.length == 14) ? nome : null : null
        });
        $state.go('newpdv.manutencao-cliente');
    };

    $scope.selecionaCliente = function (cliente) {
        $scope.selecionarCliente((!!cliente.pef_cpf) ? cliente.pef_cpf : cliente.pej_cnpj, cliente.pes_nome, cliente.pes_idestrangeiro, cliente.cli_id);
    };

    $scope.selecionarClienteEnter = function (cpfCnpj) {
       // FuncaoService.delay(function () {
            $scope.selecionarCliente(cpfCnpj, $scope.dadosVenda.pes_nome);
        //}, 1000);
    };

    $scope.selecionarCliente = function (cpfCnpj, nome, idEstrangeiro, idCliente) {
        $scope.dadosVenda.pes_cpfcnpj = cpfCnpj;
        $scope.dadosVenda.cli_vendasomenteavista = false;
        if (!!idCliente) {
            var dadosCliente = {};
            if (!!cpfCnpj) dadosCliente = JSON.parse(clienteAppService.buscaDadosCliente(cpfCnpj));
            else if (!!idCliente) dadosCliente = JSON.parse(clienteAppService.buscaClienteId(idCliente));
            if (!!dadosCliente) {
                $scope.dadosVenda.pes_cpfcnpj = cpfCnpj;
                $scope.dadosVenda.pes_nome = (!!nome) ? nome : dadosCliente.pes_nome;
                $scope.dadosVenda.cli_id = dadosCliente.cli_id;
                $scope.dadosVenda.pes_id = dadosCliente.pes_id;
                $scope.dadosVenda.cli_vendasomenteavista = dadosCliente.cli_vendasomenteavista;
                $scope.dadosVenda.ClienteId = dadosCliente.Id;
                $scope.dadosVenda.ultimoCpfCnpjValidoInformado = cpfCnpj;
                $scope.dadosVenda.ultimoNomeValidoInformado = $scope.dadosVenda.pes_nome;

                if (navigator.onLine && !!dadosCliente.pes_id) {
                    var parcelasAtrazo = JSON.parse(clienteAppService.verificarParcelasEmAtraso(dadosCliente.pes_id));
                    if (!!parcelasAtrazo == true && parcelasAtrazo.length > 0) {
                        swal("ATENÇÃO!!!", "Este cliente possui parcelas em atraso!", "warning");
                    }
                }

            } else {
                $scope.dadosVenda.pes_nome = (!!nome) ? nome : null;
                $scope.dadosVenda.cli_id = null;
                $scope.dadosVenda.pes_id = null;
                $scope.dadosVenda.ClienteId = null;
            }
        } else {
            $scope.dadosVenda.pes_idestrangeiro = (!!idEstrangeiro) ? idEstrangeiro : null;
            $scope.dadosVenda.pes_id = ($scope.dadosVenda.pes_id) ? $scope.dadosVenda.pes_id : null;
            $scope.dadosVenda.pes_nome = (!!nome) ? nome : null;
            $scope.dadosVenda.cli_id = (!!idCliente) ? idCliente : null;
            $scope.dadosVenda.ClienteId = ($scope.dadosVenda.ClienteId) ? $scope.dadosVenda.ClienteId : null;
        }

        if (!$scope.validarFormaPagamento()) {
            $scope.selecionarCliente($scope.dadosVenda.ultimoCpfCnpjValidoInformado, $scope.dadosVenda.ultimoNomeValidoInformado);
        } else {
            $scope.cpfCnpj = null;
            $scope.nome = null;
            $scope.ultimoCpfCnpjInformado = $scope.dadosVenda.pes_cpfcnpj;
            $scope.ultimoNomeInformado = $scope.dadosVenda.pes_nome;
            $scope.modalCliente.close();
        }
    };

    $scope.buscaVendedor = function () {
        $scope.listarVendedor = JSON.parse(vendedorAppService.listarVendedoresAtivos());
    };

    $scope.selecionaVendedor = function (vendedor) {
        $scope.dadosVenda.ven_maximodesconto = vendedor.ven_maximodesconto;
        $scope.dadosVenda.ven_id = vendedor.ven_id;
        $scope.dadosVenda.ven_nome = vendedor.ven_nome;
        if (!!$scope.modalVendedor) $scope.modalVendedor.close();
    };

    $scope.buscarGradesProduto = function (codigoProduto, codigoProdutoGrade) {
        $scope.listaGrades = JSON.parse(produtoAppService.listaGradesProduto(codigoProduto, codigoProdutoGrade));
        if ($scope.listaGrades.length > 0) {
            $scope.abrirModalGradesVendas();
        }
    };

    $scope.selecionarGrades = function () {
        var informouGrade = false;
        var dadosProduto = $scope.dadosProduto;
        angular.forEach($scope.listaGrades, function (item) {
            if (item.prg_quantidade > 0) {
                informouGrade = true;
                dadosProduto.nfi_valorunitario = item.valorVenda;
                dadosProduto.nfi_qtde = item.prg_quantidade;
                dadosProduto.prg_id = item.prg_id;
                dadosProduto.ump_casasdecimais = item.ump_casasdecimais;
                dadosProduto.prg_id = item.prg_id;
                dadosProduto.pro_ean = item.ean;
                dadosProduto.grade = "";
                for (var i = 0; i < item.atributos.length; i++) {
                    dadosProduto.grade += item.atributos[i].mgp_descricao;
                    if (i < item.atributos.length - 1) {
                        dadosProduto.grade += "/";
                    }
                }
                $scope.dadosProduto = dadosProduto;
                $scope.calculaTotalItem();
                $scope.adicionarItem();
            }
        });

        if (!!$scope.modalGradesVendas) {
            $timeout(function () {
                if (!!informouGrade) {
                    $scope.modalGradesVendas.dismiss();
                    delete $scope.modalGradesVendas;
                    jaAbriuModalGradeProduto = false;
                } else {
                    swal("Informe a quantidade em pelo menos um item da grade!", "", "warning");
                }
            }, 100);
        }
    };

    $scope.manutencaoQuantidadeModalGrades = function (posicao, operacao) {
        if (operacao == "+") {
            if ($scope.listaGrades[posicao].valorVenda > 0) {
                $scope.listaGrades[posicao].prg_quantidade += 1;
            } else {
                swal("Não sera possivel adicionar o item, pois o valor não foi informado!", "", "warning");
            }
        } else if (operacao == "-") {
            if ($scope.listaGrades[posicao].prg_quantidade == 0) {
                $scope.listaGrades[posicao].prg_quantidade = 0;
            } else {
                $scope.listaGrades[posicao].prg_quantidade -= 1;
            }
        }
    };

    $scope.calculaTotalItem = function () {
        $scope.dadosProduto.nfi_qtde = (!!$scope.dadosProduto.nfi_qtde) ? $scope.dadosProduto.nfi_qtde : 1;
        $scope.dadosProduto.totalItem = FuncaoService.arredondar($scope.dadosProduto.nfi_qtde * $scope.dadosProduto.nfi_valorunitario);
        if (!!$scope.dadosProduto.valorDesconto == false) $scope.dadosProduto.valorDesconto = 0;
        if (!!$scope.dadosProduto.valorAcrescimo == false) $scope.dadosProduto.valorAcrescimo = 0;
        if ($scope.dadosProduto.valorDesconto > ($scope.dadosProduto.totalItem + $scope.dadosProduto.valorAcrescimo)) {
            $scope.dadosProduto.valorDesconto = 0;
            $scope.dadosProduto.desconto = 0;
        }

        $scope.dadosProduto.totalItemDesconto = FuncaoService.arredondar(($scope.dadosProduto.totalItem + $scope.dadosProduto.valorAcrescimo) - $scope.dadosProduto.valorDesconto);
    };

    var jaAbriuModalGradeProduto = false;


    $scope.marcarTexto = function (nomeElemento) {
        document.getElementsByName(nomeElemento)[0].select();
    };

    $scope.carregaDadosProdutoCodigo = function (produtoCodigo) {
        if (!!produtoCodigo) {
            var produto = JSON.parse(produtoAppService.listarProdutoCodigo(produtoCodigo));
            if (produto != null) {
                $scope.dadosProduto = produto;
                $scope.dadosProduto.buscaProdutoCodigo = produtoCodigo;
                $scope.carregaDadosProdutoComCodigoBarras(produto);
            }
            else {
                $timeout(function () {
                    swal("Produto Não Encontrado!", "", "warning");
                    $scope.dadosProduto = {};
                    $scope.limparCampos();
                }, 100)
            }
        }
    };
    $scope.carregaDadosProdutoComCodigoBarras = function (produto) {

        $scope.dadosProduto.nfi_qtde = produto.quantidadeProdutoBalanca;
        $scope.dadosProduto.desconto = 0;
        $scope.dadosProduto.valorDesconto = 0;
        $scope.dadosProduto.acrescimo = 0;
        $scope.dadosProduto.valorAcrescimo = 0;
        $scope.dadosProduto.prg_id = produto.prg_id;
        $scope.dadosProduto.grade = (produto.grade) ? produto.grade : '';
        $scope.dadosProduto.preco = produto.lpi_valorvenda;
        $scope.dadosProduto.nfi_valorunitario = produto.lpi_valorvenda;
        $scope.dadosProduto.ump_casasdecimais = produto.ump_casasdecimais;
        $scope.calculaTotalItem();

        codigoCliente = (!!$scope.dadosVenda.cli_id === true) ? $scope.dadosVenda.cli_id : null;
        codigoVendedor = (!!$scope.dadosVenda.ven_id === true) ? $scope.dadosVenda.ven_id : null;

        $scope.informarValorItem = false;
        if ($scope.dadosProduto.pro_kitcomposicao == true)
            $scope.informarValorItem = true;
        $timeout(function () {
            if ($scope.exibicaoProduto != "fa-barcode") {
                if (produto.pro_usabalanca == true) {
                    if (produto.quantidadeProdutoBalanca === 0) {
                        $scope.setarFocus('nfi_qtde');
                        $scope.marcarTexto('nfi_qtde');
                    } else {
                        $scope.verificarEstoqueProdutoEAdicionaProduto();
                    }
                } else {
                    $scope.verificarEstoqueProdutoEAdicionaProduto();
                }
            } else {
                $scope.setarFocus('nfi_qtde');
                $scope.marcarTexto('nfi_qtde');
            }
        }, 100);
    }

    $scope.alteraPadraoDesconto = function (padrao) {
        $localStorage.padraoDesconto = padrao;
        $scope.dadosVenda.descontoEmValorOuPercentual = padrao;
        if (!!$scope.dadosProduto) {
            if (!!$scope.dadosProduto.desconto || !!$scope.dadosProduto.valorDesconto) {
                if (padrao == '%') {
                    var percentualDesconto = FuncaoService.arredondar($scope.dadosProduto.valorDesconto / $scope.dadosProduto.totalItem, 4);
                    $scope.dadosProduto.desconto = percentualDesconto;
                } else {
                    var valorTotalItem = FuncaoService.arredondar($scope.dadosProduto.totalItem);
                    $scope.dadosProduto.valorDesconto = FuncaoService.arredondar($scope.dadosProduto.desconto * valorTotalItem);
                };
            };
        }
    };

    $scope.alteraPadraoAcrescimo = function (padrao) {
        $localStorage.padraoAcrescimo = padrao;
        $scope.dadosVenda.acrescimoEmValorOuPercentual = padrao;
        if (!!$scope.dadosProduto) {
            if (!!$scope.dadosProduto.acrescimo || !!$scope.dadosProduto.valorAcrescimo) {
                if (padrao == '%') {
                    $scope.dadosProduto.acrescimo = FuncaoService.arredondar($scope.dadosProduto.valorAcrescimo / $scope.dadosProduto.totalItem, 4);
                } else {
                    $scope.dadosProduto.valorAcrescimo = FuncaoService.arredondar($scope.dadosProduto.acrescimo * $scope.dadosProduto.totalItem);
                };
            };
        }
    };

    $scope.calculaAcrescimo = function () {
        if ($localStorage.padraoAcrescimo == "$") {
            $scope.dadosProduto.acrescimo = FuncaoService.arredondar($scope.dadosProduto.valorAcrescimo / $scope.dadosProduto.totalItem, 4);
        } else {
            $scope.dadosProduto.valorAcrescimo = FuncaoService.arredondar($scope.dadosProduto.acrescimo * $scope.dadosProduto.totalItem);
        }
        $scope.calculaTotalItem();
    }

    $scope.calculaDesconto = function () {
        const valorTotalItem = FuncaoService.arredondar($scope.dadosProduto.totalItem);
        const maximoDesconto = $scope.dadosVenda.ven_maximodesconto;
        const padraoDesconto = $localStorage.padraoDesconto;

        const calcularValoresDesconto = () => {
            $scope.dadosProduto.valorAcrescimo = $scope.dadosProduto.valorAcrescimo || 0;
            $scope.dadosProduto.totalItemDesconto = FuncaoService.arredondar(valorTotalItem + $scope.dadosProduto.valorAcrescimo - $scope.dadosProduto.valorDesconto)
        };

        const solicitarAutorizacao = (acao) => {
            if (acao) {
                $timeout(() => {
                    $scope.model.tipoSolicitacao = tipoSolicitacao.descontoMaximoAdicionando;
                    var retorno = $scope.verificaSenhaGerencial();
                }, 100);
            } else {
                $timeout(() => {
                    $scope.dadosProduto.desconto = FuncaoService.arredondar(maximoDesconto / 100, 4);
                    $scope.dadosProduto.valorDesconto = FuncaoService.arredondar(valorTotalItem * $scope.dadosProduto.desconto);
                    calcularValoresDesconto();
                }, 100);
            }
        };

        if (maximoDesconto) {
            if (padraoDesconto === "$") {
                const percentualDesconto = FuncaoService.arredondar($scope.dadosProduto.valorDesconto / valorTotalItem, 4);
                if (FuncaoService.arredondar(percentualDesconto * 100) <= maximoDesconto) {
                    $scope.dadosProduto.desconto = percentualDesconto;
                } else {
                    swal({
                        title: `Desconto máximo para o vendedor é de ${maximoDesconto}%`,
                        text: "Para continuar aplicando o desconto maior que o permitido, você deve solicitar a autorização com seu supervisor/gerente.",
                        type: "warning",
                        showCancelButton: true,
                        cancelButtonText: "OK",
                        confirmButtonClass: "btn-success",
                        confirmButtonText: "Solicitar Autorização",
                        allowOutsideClick: false
                    }, function (acao) {
                        if (acao) {
                            solicitarAutorizacao(acao);
                        } else {
                            $timeout(() => {
                                $scope.dadosProduto.desconto = FuncaoService.arredondar(maximoDesconto / 100, 4);
                                $scope.dadosProduto.valorDesconto = FuncaoService.arredondar(valorTotalItem * $scope.dadosProduto.desconto);
                                calcularValoresDesconto();
                            }, 100);
                        }
                    });
                }
            } else {
                if (FuncaoService.arredondar($scope.dadosProduto.desconto * 100) <= maximoDesconto) {
                    $scope.dadosProduto.valorDesconto = FuncaoService.arredondar(valorTotalItem * $scope.dadosProduto.desconto);
                } else {
                    swal({
                        title: `Desconto máximo para o vendedor é de ${maximoDesconto}%`,
                        text: "Para continuar aplicando o desconto maior que o permitido, você deve solicitar a autorização com seu supervisor/gerente.",
                        type: "warning",
                        showCancelButton: true,
                        cancelButtonText: "OK",
                        confirmButtonClass: "btn-success",
                        confirmButtonText: "Solicitar Autorização",
                        allowOutsideClick: false
                    }, function (acao) {
                        if (acao) {
                            solicitarAutorizacao(acao);
                        } else {
                            $timeout(() => {
                                $scope.dadosProduto.desconto = FuncaoService.arredondar(maximoDesconto / 100, 4);
                                $scope.dadosProduto.valorDesconto = FuncaoService.arredondar(valorTotalItem * $scope.dadosProduto.desconto);
                                calcularValoresDesconto();
                            }, 100);
                        }
                    });
                }
            }
        } else {
            if (padraoDesconto === "$") {
                $scope.dadosProduto.desconto = FuncaoService.arredondar($scope.dadosProduto.valorDesconto / valorTotalItem, 4);
            } else {
                $scope.dadosProduto.valorDesconto = FuncaoService.arredondar(valorTotalItem * $scope.dadosProduto.desconto);
            }
        }

        if ($scope.dadosProduto.valorDesconto > FuncaoService.arredondar(valorTotalItem + $scope.dadosProduto.valorAcrescimo)) {
            $scope.dadosProduto.valorDesconto = 0;
            $scope.dadosProduto.desconto = 0;
        }

        calcularValoresDesconto();
    };

    $scope.calculaPrecoItem = function (dados) {
        $scope.dadosProduto.totalItem = FuncaoService.arredondar(dados.nfi_qtde * dados.nfi_valorunitario);
    };

    $scope.cancelarItem = function () {
        $timeout(function () {
            swal({
                title: "Cancelar este item?",
                text: "",
                type: "warning",
                showCancelButton: true,
                cancelButtonText: "Não",
                confirmButtonClass: "btn-danger",
                confirmButtonText: "Sim, quero cancelar",
                closeOnConfirm: true
            }, function (isConfirm) {
                if (isConfirm) {
                    $timeout(function () {
                        $scope.dadosProduto = {};
                        $scope.limparCampos();
                        $scope.modoExibirPesquisaProduto();
                    });
                }
            })
        }, 100);
    }
    $scope.validaDadosProduto = function (pro_id) {
        return icmsOrigemDestinoAppService.validaIcmsOrigemDestinoProduto(pro_id);
    };

    $scope.retornaQuantidadeItemLancado = function (pro_id, prg_id = null) {
        let quantidadeTotal = 0;

        if ($scope.dadosVenda.listaItens) {  // Verifica se listaItens não é undefined ou null
            $scope.dadosVenda.listaItens.forEach(item => {
                if (item.pro_id === pro_id && (prg_id === null || item.prg_id === prg_id)) {
                    quantidadeTotal += item.quantidade;
                }
            });
        }

        return quantidadeTotal;
    };


    $scope.verificarEstoqueProdutoEAdicionaProduto = function () {
        if ($scope.parametrosLocal != null) {
            if ($scope.parametrosLocal.par_avisoestoqueinsuficiente != null) {
                if (navigator.onLine) {
                    var qtdeItemLancado = $scope.retornaQuantidadeItemLancado($scope.dadosProduto.pro_id, $scope.dadosProduto.prg_id);
                    var retornoEstoque = JSON.parse(estoqueAppService.buscarEstoqueProdutoUnicoApi($scope.dadosProduto.pro_id, $scope.dadosProduto.prg_id));
                    if (retornoEstoque == null) {
                        retornoEstoque = { valorTotal: 0 };
                    }
                    var quantidadeControleEstoque = (retornoEstoque.valorTotal - ($scope.dadosProduto.nfi_qtde + qtdeItemLancado));
                    if (retornoEstoque != null && quantidadeControleEstoque < 0) {
                        if ($scope.parametrosLocal.par_avisoestoqueinsuficiente == tipoControleEstoque.avisar) {
                            swal({
                                title: 'Atenção Sistema de Controle de Estoque!',
                                text: "Este produto está com estoque insuficiente (Estoque: " + quantidadeControleEstoque + "). Deseja continuar?",
                                type: "warning",
                                showCancelButton: false,
                                confirmButtonText: "Sim, quero Continuar!"
                            }, function (acao) {
                                if (acao) {
                                    $scope.adicionarItem();
                                }
                            });
                        } else if ($scope.parametrosLocal.par_avisoestoqueinsuficiente == tipoControleEstoque.avisaPedirSenha) {
                            swal({
                                title: 'Atenção Sistema de Controle de Estoque!',
                                text: "Este produto está com estoque insuficiente (Estoque: " + quantidadeControleEstoque + "). Deseja continuar? Será solicitado uma senha Gerencial!",
                                type: "warning",
                                showCancelButton: true,
                                cancelButtonText: "Não",
                                confirmButtonClass: "btn-danger",
                                confirmButtonText: "Sim, quero Continuar!",
                                allowOutsideClick: false
                            }, function (acao) {
                                if (acao) {
                                    $timeout(function () {
                                        $scope.model.tipoSolicitacao = tipoSolicitacao.estoque;
                                        var retorno = $scope.verificaSenhaGerencial();
                                    }, 100);
                                } else {
                                    $timeout(function () {
                                        $scope.limparCampos();
                                    });
                                }
                            });
                        } else if ($scope.parametrosLocal.par_avisoestoqueinsuficiente == tipoControleEstoque.bloquear) {
                            swal("Atenção Sistema de Controle de Estoque!", "Produto com estoque " + quantidadeControleEstoque + ", sistema está configurado para bloquear vendas de produtos com estoque insuficiente !", "warning");
                            $scope.limparCampos();
                        }
                    } else {
                        $scope.adicionarItem();
                    }
                } else {
                    $scope.adicionarItem();
                }
            } else {
                $scope.adicionarItem();
            }
        }
        else {
            $scope.adicionarItem();
        }
    };

    $scope.adicionarItem = function () {
        if (!!$scope.dadosVenda.listaItens == false) $scope.dadosVenda.listaItens = [];
        if ($scope.dadosVenda.listaItens.length === 0) {
            VendaService.iniciaVenda($scope.dadosVenda.pes_cpfcnpj, $scope.dadosVenda.pes_nome);
            $scope.dadosVenda.nItem = 1;
        };
        if ($scope.dadosProduto.pro_id) {
            if ($scope.dadosProduto.pro_kitcomposicao === true) {
                var listaKitsProduto = JSON.parse(produtoAppService.retornaDadosKitComposicao($scope.dadosProduto.pro_id));
                if (listaKitsProduto.length > 0) {
                    var _valorTotalDescontoItem = !!$scope.dadosProduto.valorDesconto ? $scope.dadosProduto.valorDesconto : 0;
                    var _valorTotalAcrescimoItem = !!$scope.dadosProduto.valorAcrescimo ? $scope.dadosProduto.valorAcrescimo : 0;
                    var _percDescontoItem = 0;
                    var _percAcrescimoItem = 0;
                    if (_valorTotalDescontoItem > 0) {
                        _percDescontoItem = _valorTotalDescontoItem / $scope.dadosProduto.nfi_valorunitario;
                    } else if (_valorTotalAcrescimoItem > 0) {
                        _percAcrescimoItem = _valorTotalAcrescimoItem / $scope.dadosProduto.nfi_valorunitario;
                    }

                    angular.forEach(listaKitsProduto, function (item) {
                        var _valorDesconto = _percDescontoItem > 0 ? FuncaoService.arredondar((item.pkc_qtde * item.lpi_valorvenda) * _percDescontoItem) : 0;
                        var _valorAcrescimo = _percAcrescimoItem > 0 ? FuncaoService.arredondar((item.pkc_qtde * item.lpi_valorvenda) * _percAcrescimoItem) : 0;

                        var dadosItem = {
                            grade: item.grade,
                            quantidade: ($scope.dadosProduto.nfi_qtde * item.pkc_qtde),
                            ean: (!!item.pro_ean) ? item.pro_ean : item.prg_ean,
                            produto: item.pro_descricao,
                            pro_id: item.pro_id,
                            prg_id: item.prg_id,
                            pro_codigo: item.pro_codigo,
                            pkc_id: item.pkc_id,
                            pro_idkit: item.pro_idkit,
                            descricaokit: item.descricaokit,
                            nItem: $scope.dadosVenda.nItem,
                            totalItemDesconto: FuncaoService.arredondar((($scope.dadosProduto.nfi_qtde * item.pkc_qtde) * item.lpi_valorvenda) - _valorDesconto + _valorAcrescimo),// possui um valor dentro da tabela kitcomposicao.
                            totalItem: FuncaoService.arredondar(($scope.dadosProduto.nfi_qtde * item.pkc_qtde) * item.lpi_valorvenda),
                            desconto: _percDescontoItem,
                            vlrDesconto: _valorDesconto,
                            descontoItem: _valorDesconto,
                            vlrDescontoItem: _valorDesconto,
                            acrescimo: _percAcrescimoItem,
                            vlrAcrescimo: _valorAcrescimo,
                            vlrPrdAnt: FuncaoService.arredondar(($scope.dadosProduto.nfi_qtde * item.pkc_qtde) * item.lpi_valorvenda),
                            valorUnitario: item.lpi_valorvenda,
                            vlrOutro: _valorAcrescimo,
                            vlrFrete: 0,//(!!$scope.dadosProduto.vlrFrete) ? $scope.dadosProduto.vlrFrete : 0
                        };

                        VendaService.adicionaItem(dadosItem);
                        $scope.dadosVenda.nItem++;
                        $scope.dadosVenda.listaItens.push(angular.copy(dadosItem));
                    })
                }

            } else {
                var retorno = $scope.validaDadosProduto($scope.dadosProduto.pro_id)
                retorno = retorno.split("|", 2);
                if (retorno[0] != "OK") {
                    swal({ title: "Atenção", text: retorno[1], type: retorno[0] });
                } else {
                    if (!!!$scope.dadosProduto.nfi_valorunitario) {
                        $timeout(function () {
                            swal({ title: "Você deve informar o valor unitário do produto!", text: "Para realizar a venda deste produto, informe o valor unitário do mesmo.", type: "warning" }, function () {
                                $scope.setarFocus("nfi_valorunitario");
                            });
                        }, 100);
                    }
                    else {
                        var valorAcrescimo = (!!$scope.dadosProduto.valorAcrescimo) ? $scope.dadosProduto.valorAcrescimo : 0;
                        var dadosItem = {
                            grade: $scope.dadosProduto.grade,
                            quantidade: $scope.dadosProduto.nfi_qtde,
                            ean: (!!$scope.dadosProduto.pro_ean) ? $scope.dadosProduto.pro_ean : $scope.dadosProduto.prg_ean,
                            produto: $scope.dadosProduto.pro_descricao,
                            pro_id: $scope.dadosProduto.pro_id,
                            prg_id: $scope.dadosProduto.prg_id,
                            pro_codigo: $scope.dadosProduto.pro_codigo,
                            pkc_id: null,
                            pro_idkit: null,
                            descricaokit: '',
                            nItem: $scope.dadosVenda.nItem,
                            totalItemDesconto: $scope.dadosProduto.totalItemDesconto,
                            totalItem: $scope.dadosProduto.totalItem,
                            desconto: (!!$scope.dadosProduto.desconto) ? $scope.dadosProduto.desconto : 0,
                            vlrDesconto: (!!$scope.dadosProduto.valorDesconto) ? $scope.dadosProduto.valorDesconto : 0,
                            descontoItem: (!!$scope.dadosProduto.desconto) ? $scope.dadosProduto.desconto : 0,
                            vlrDescontoItem: (!!$scope.dadosProduto.valorDesconto) ? $scope.dadosProduto.valorDesconto : 0,
                            acrescimo: (!!$scope.dadosProduto.acrescimo) ? $scope.dadosProduto.acrescimo : 0,
                            vlrAcrescimo: valorAcrescimo,
                            vlrPrdAnt: FuncaoService.arredondar($scope.dadosProduto.nfi_valorunitario * $scope.dadosProduto.nfi_qtde),
                            valorUnitario: $scope.dadosProduto.nfi_valorunitario,
                            vlrOutro: valorAcrescimo,
                            vlrFrete: (!!$scope.dadosProduto.vlrFrete) ? $scope.dadosProduto.vlrFrete : 0
                        };

                        VendaService.adicionaItem(dadosItem);
                        $scope.dadosVenda.nItem++;
                        $scope.dadosVenda.listaItens.push(angular.copy(dadosItem));
                    }
                }
            }
            $scope.limparCampos();
            $scope.dadosVenda.qtdTotalItens = $scope.dadosVenda.listaItens.length;
            $scope.totaisNota();
            DadosFormularioService.armazenarDados('venda-varejo', $scope.dadosVenda);
            $scope.modoExibirPesquisaProduto();
            $scope.retornaNumeroCupom();

        }
    };
    $scope.carregaDadosProduto = function (produtoId, produtoGradeId, grade, listaPreco, valorVenda) {
        //sincronizarDadosProdutoAppService.atualizarDados(produtoId);

        $scope.dadosProduto.nfi_qtde = 1;
        $scope.dadosProduto.desconto = 0;
        $scope.dadosProduto.valorDesconto = 0;
        $scope.dadosProduto.acrescimo = 0;
        $scope.dadosProduto.valorAcrescimo = 0;
        $scope.dadosProduto.prg_id = (produtoGradeId) ? produtoGradeId : null;
        $scope.dadosProduto.grade = (grade) ? grade : '';
        $scope.dadosProduto.nfi_valorunitario = valorVenda;

        codigoCliente = (!!$scope.dadosVenda.cli_id === true) ? $scope.dadosVenda.cli_id : null;
        codigoVendedor = (!!$scope.dadosVenda.ven_id === true) ? $scope.dadosVenda.ven_id : null;
        var unidadeMedida = JSON.parse(unidadeMedidaAppService.retornaCasasDecimais($scope.dadosProduto.ump_id));
        $scope.dadosProduto.ump_casasdecimais = unidadeMedida;
        $scope.listaPrecos = JSON.parse(produtoAppService.listaPrecoProduto(produtoId, produtoGradeId, codigoCliente, codigoVendedor, listaPreco));
        angular.forEach($scope.listaPrecos, function (value, key) {
            if (value.ltp_principal == true) {
                $scope.dadosProduto.preco = value;
                $scope.dadosProduto.nfi_valorunitario = value.lpi_valorvenda;
                $scope.calculaTotalItem();
            }
            else {
                if (value.ltp_id == listaPreco) {
                    $scope.dadosProduto.preco = value;
                    $scope.dadosProduto.nfi_valorunitario = value.lpi_valorvenda;
                    $scope.calculaTotalItem();
                }
            }
        });
        if (produtoGradeId) {
            $scope.listaGrades = JSON.parse(produtoAppService.listaGradesProduto(produtoId, produtoGradeId, listaPreco));
            angular.forEach($scope.listaGrades, function (item) {
                $scope.dadosProduto.nfi_valorunitario = item.valorVenda;
                $scope.dadosProduto.nfi_qtde = 1;
                $scope.dadosProduto.prg_id = item.prg_id;
                $scope.dadosProduto.pro_ean = item.ean;
                $scope.dadosProduto.grade = "";
                for (var i = 0; i < item.atributos.length; i++) {
                    $scope.dadosProduto.grade += item.atributos[i].mgp_descricao;
                    if (i < item.atributos.length - 1) {
                        $scope.dadosProduto.grade += "/";
                    }
                }
            });
        }
        $scope.informarValorItem = false;
        if ($scope.dadosProduto.pro_kitcomposicao == true)
            $scope.informarValorItem = true;
        $timeout(function () {
            if ($scope.exibicaoProduto != "fa-barcode") {
                $scope.adicionarItem();
            } else {
                $scope.setarFocus('nfi_qtde');
                $scope.marcarTexto('nfi_qtde');
            }
        }, 100);
    };

    $scope.editarItem = function (item, posicao) {
        //if (item.pkc_id) {
        //    swal("Atenção!", "Não é poss ITEM é referente ao Kit " + item.descricaokit + " !", "warning");
        //    return;
        //}

        angular.forEach($scope.dadosVenda.listaItens, function (i) {
            i.edicao = false;
            if (i.nItem == item.nItem)
                i.edicao = true;
        });
        //$scope.dadosVenda.listaItens[posicao].edicao = true;

        $scope.dadosItem.nItem = item.nItem;
        $scope.dadosItem.pro_codigo = item.pro_codigo;
        $scope.dadosItem.ean = item.ean;
        $scope.dadosItem.produto = item.produto;
        $scope.dadosItem.vlrUnitario = item.valorUnitario;
        $scope.dadosItem.desconto = item.desconto;
        $scope.dadosItem.vlrDesconto = item.vlrDesconto;
        $scope.dadosItem.descontoItem = item.descontoItem;
        $scope.dadosItem.vlrDescontoItem = item.vlrDescontoItem;
        $scope.dadosItem.acrescimo = item.acrescimo;
        $scope.dadosItem.vlrAcrescimo = item.vlrAcrescimo;
        $scope.dadosItem.valorTotalItem = FuncaoService.arredondar(((item.valorUnitario * item.quantidade) - item.vlrDesconto) + item.vlrAcrescimo);
        $scope.dadosItem.quantidade = item.quantidade;
        $scope.dadosItem.pro_id = item.pro_id;
        $scope.dadosItem.prg_id = item.prg_id,
            $scope.dadosItem.grade = item.grade,
            $scope.dadosItem.vlrFrete = (!!item.vlrFrete) ? item.vlrFrete : 0;
        $scope.dadosItem.vlrOutro = item.vlrAcrescimo;
    };

    $scope.calculaDescontoItem = function () {
        const valorTotalItem = FuncaoService.arredondar($scope.dadosItem.vlrUnitario * $scope.dadosItem.quantidade);
        const maximoDesconto = $scope.dadosVenda.ven_maximodesconto;
        const padraoDesconto = $localStorage.padraoDesconto;

        const calcularValoresDesconto = () => {
            $scope.dadosItem.vlrAcrescimo = $scope.dadosItem.vlrAcrescimo || 0;
            $scope.dadosItem.valorTotalItem = FuncaoService.arredondar($scope.dadosItem.vlrUnitario * $scope.dadosItem.quantidade) + $scope.dadosItem.vlrAcrescimo - $scope.dadosItem.vlrDesconto
        };

        const solicitarAutorizacao = (acao) => {
            if (acao) {
                $timeout(() => {
                    $scope.model.tipoSolicitacao = tipoSolicitacao.descontoMaximoEditando;
                    var retorno = $scope.verificaSenhaGerencial();
                }, 100);
            } else {
                $timeout(() => {
                    $scope.dadosItem.desconto = FuncaoService.arredondar(maximoDesconto / 100, 4);
                    $scope.dadosItem.vlrDesconto = FuncaoService.arredondar(valorTotalItem * $scope.dadosItem.desconto);
                    calcularValoresDesconto();
                }, 100);
            }
        };

        if (maximoDesconto) {
            if (padraoDesconto === "$") {
                const percentualDesconto = FuncaoService.arredondar($scope.dadosItem.vlrDesconto / valorTotalItem, 4);
                if (FuncaoService.arredondar(percentualDesconto * 100) <= maximoDesconto) {
                    $scope.dadosItem.desconto = percentualDesconto;
                } else {
                    swal({
                        title: `Desconto máximo para o vendedor é de ${maximoDesconto}%`,
                        text: "Para continuar aplicando o desconto maior que o permitido, você deve solicitar a autorização com seu supervisor/gerente.",
                        type: "warning",
                        showCancelButton: true,
                        cancelButtonText: "OK",
                        confirmButtonClass: "btn-success",
                        confirmButtonText: "Solicitar Autorização",
                        allowOutsideClick: false
                    }, function (acao) {
                        if (acao) {
                            solicitarAutorizacao(acao);
                        } else {
                            $timeout(() => {
                                $scope.dadosItem.desconto = FuncaoService.arredondar(maximoDesconto / 100, 4);
                                $scope.dadosItem.vlrDesconto = FuncaoService.arredondar(valorTotalItem * $scope.dadosItem.desconto);
                                calcularValoresDesconto();
                            }, 100);
                        }
                    });
                }
            } else {
                if (FuncaoService.arredondar($scope.dadosItem.desconto * 100) <= maximoDesconto) {
                    $scope.dadosItem.vlrDesconto = FuncaoService.arredondar(valorTotalItem * $scope.dadosItem.desconto);
                } else {
                    swal({
                        title: `Desconto máximo para o vendedor é de ${maximoDesconto}%`,
                        text: "Para continuar aplicando o desconto maior que o permitido, você deve solicitar a autorização com seu supervisor/gerente.",
                        type: "warning",
                        showCancelButton: true,
                        cancelButtonText: "OK",
                        confirmButtonClass: "btn-success",
                        confirmButtonText: "Solicitar Autorização",
                        allowOutsideClick: false
                    }, function (acao) {
                        if (acao) {
                            solicitarAutorizacao(acao);
                        } else {
                            $timeout(() => {
                                $scope.dadosItem.desconto = FuncaoService.arredondar(maximoDesconto / 100, 4);
                                $scope.dadosItem.vlrDesconto = FuncaoService.arredondar(valorTotalItem * $scope.dadosItem.desconto);
                                calcularValoresDesconto();
                            }, 100);
                        }
                    });
                }
            }
        } else {
            if (padraoDesconto === "$") {
                $scope.dadosItem.desconto = FuncaoService.arredondar($scope.dadosItem.vlrDesconto / valorTotalItem, 4);
            } else {
                $scope.dadosItem.vlrDesconto = FuncaoService.arredondar(valorTotalItem * $scope.dadosItem.desconto);
            }
        }

        if ($scope.dadosItem.vlrDesconto > FuncaoService.arredondar(valorTotalItem + $scope.dadosItem.vlrAcrescimo)) {
            $scope.dadosItem.vlrDesconto = 0;
            $scope.dadosItem.desconto = 0;
        }

        calcularValoresDesconto();
    };

    function _calcularValoresDesconto() {
        var item = {};
        if ($scope.model.tipoSolicitacao = tipoSolicitacao.descontoMaximoAdicionando) {
            const valorTotalItem = FuncaoService.arredondar($scope.dadosProduto.totalItem);
            $scope.dadosProduto.valorAcrescimo = $scope.dadosProduto.valorAcrescimo || 0;
            $scope.dadosProduto.totalItemDesconto = FuncaoService.arredondar(valorTotalItem + $scope.dadosProduto.valorAcrescimo - $scope.dadosProduto.valorDesconto)
        }
        if ($scope.model.tipoSolicitacao = tipoSolicitacao.descontoMaximoEditando) {
            $scope.dadosItem.vlrAcrescimo = $scope.dadosItem.vlrAcrescimo || 0;
            $scope.dadosItem.valorTotalItem = FuncaoService.arredondar($scope.dadosItem.vlrUnitario * $scope.dadosItem.quantidade) + $scope.dadosItem.vlrAcrescimo - $scope.dadosItem.vlrDesconto
        }
    };

    $scope.verificaSenhaGerencial = function () {
        var retorno = localAppService.possuiSenhaGerencial();
        if (retorno == true) {
            $scope.modalSenhaGerencial = ModalService.model($scope, 'views/pdv/varejo/modalSenhaGerencial.html', 'sm', true, 'static', true);
        }
    };
    $scope.validaSenhaGerencial = function (senha) {
        const padraoDesconto = $localStorage.padraoDesconto;
        var senhaValida = localAppService.validarSenhaGerencial(senha);
        if (senhaValida == true) {
            if ($scope.model.tipoSolicitacao == tipoSolicitacao.estoque) {
                $scope.adicionarItem();
            }
            if ($scope.model.tipoSolicitacao == tipoSolicitacao.descontoMaximoAdicionando) {
                if (padraoDesconto === "$") {
                    $scope.dadosProduto.desconto = FuncaoService.arredondar($scope.dadosProduto.valorDesconto / $scope.dadosProduto.totalItem, 4);
                } else {
                    $scope.dadosProduto.valorDesconto = FuncaoService.arredondar(FuncaoService.arredondar($scope.dadosProduto.totalItem) * $scope.dadosProduto.desconto);
                }
                _calcularValoresDesconto();
            }
            if ($scope.model.tipoSolicitacao == tipoSolicitacao.descontoMaximoEditando) {
                const valorTotalItem = FuncaoService.arredondar($scope.dadosItem.vlrUnitario * $scope.dadosItem.quantidade);
                if (padraoDesconto === "$") {
                    $scope.dadosItem.desconto = FuncaoService.arredondar($scope.dadosItem.vlrDesconto / valorTotalItem, 4);
                } else {
                    $scope.dadosItem.vlrDesconto = FuncaoService.arredondar(valorTotalItem * $scope.dadosItem.desconto);
                }
                _calcularValoresDesconto();
            }
            $scope.model.tipoSolicitacao = 0;
            $scope.model.senhaGerencial = '';
            $scope.modalSenhaGerencial.close();
            return true;
        } else {
            swal("Senha incorreta!", "", "warning");
        }
    };

    $scope.fecharModalSenhaGerencial = function () {
        if ($scope.model.tipoSolicitacao == tipoSolicitacao.estoque) {
            $scope.limparCampos();
        }
        if ($scope.model.tipoSolicitacao == tipoSolicitacao.descontoMaximoAdicionando) {
            const maximoDesconto = $scope.dadosVenda.ven_maximodesconto;
            $scope.dadosProduto.desconto = FuncaoService.arredondar(maximoDesconto / 100, 4);
            $scope.dadosProduto.valorDesconto = FuncaoService.arredondar($scope.dadosProduto.totalItem * $scope.dadosProduto.desconto);
            _calcularValoresDesconto();
        } if ($scope.model.tipoSolicitacao == tipoSolicitacao.descontoMaximoEditando) {
            const maximoDesconto = $scope.dadosVenda.ven_maximodesconto;
            const valorTotalItem = FuncaoService.arredondar($scope.dadosItem.vlrUnitario * $scope.dadosItem.quantidade);
            $scope.dadosItem.desconto = FuncaoService.arredondar(maximoDesconto / 100, 4);
            $scope.dadosItem.vlrDesconto = FuncaoService.arredondar(valorTotalItem * $scope.dadosItem.desconto);
            _calcularValoresDesconto();
        }
        $scope.model.tipoSolicitacao = 0;
        $scope.model.senhaGerencial = '';
        $scope.modalSenhaGerencial.close();
    };

    $scope.calculaAcrescimoItem = function () {
        const valorTotalItem = FuncaoService.arredondar($scope.dadosItem.vlrUnitario * $scope.dadosItem.quantidade);
        const padraoAcrescimo = $localStorage.padraoAcrescimo;

        if (padraoAcrescimo === "$") {
            $scope.dadosItem.acrescimo = FuncaoService.arredondar((($scope.dadosItem.vlrAcrescimo * 100) / valorTotalItem) / 100, 4);
        } else {
            $scope.dadosItem.vlrAcrescimo = FuncaoService.arredondar(valorTotalItem * $scope.dadosItem.acrescimo);
        }

        $scope.dadosItem.vlrDesconto = $scope.dadosItem.vlrDesconto || 0;
        $scope.dadosItem.valorTotalItem = FuncaoService.arredondar(valorTotalItem + $scope.dadosItem.vlrAcrescimo - $scope.dadosItem.vlrDesconto);
    };

    $scope.alterarItem = function (item) {
        var posicao = $scope.dadosVenda.listaItens.findIndex(function (i) {
            return i.nItem === item.nItem;
        });


        var dadosItem = {
            acrescimo: Number(item.acrescimo),
            vlrAcrescimo: Number(item.vlrAcrescimo),
            desconto: Number(item.desconto),
            vlrDesconto: Number(item.vlrDesconto),
            descontoItem: Number(item.desconto),
            vlrDescontoItem: Number(item.vlrDesconto),
            totalItemDesconto: FuncaoService.arredondar(((item.vlrUnitario * item.quantidade) + Number(item.vlrAcrescimo)) - Number(item.vlrDesconto)),
            quantidade: item.quantidade,
            ean: item.ean,
            produto: item.produto,
            pro_id: item.pro_id,
            pro_codigo: item.pro_codigo,
            prg_id: item.prg_id,
            grade: item.grade,
            pkc_id: null,
            pro_idkit: null,
            nItem: item.nItem,
            descricaokit: '',
            totalItem: FuncaoService.arredondar(item.vlrUnitario * item.quantidade),
            valorUnitario: item.vlrUnitario,
            vlrPrdAnt: FuncaoService.arredondar(item.vlrUnitario * item.quantidade),
            vlrFrete: (!!item.vlrFrete) ? item.vlrFrete : 0,
            vlrOutro: Number(item.vlrAcrescimo),
            edicao: false,
        };

        VendaService.editarItem(item.nItem, dadosItem);
        $scope.dadosVenda.listaItens.splice(posicao, 1, dadosItem);

        $timeout(function () {
            $scope.totaisNota();
        });
    };

    $scope.alteraPadraoDescontoItens = function (padrao) {
        $localStorage.padraoDesconto = padrao;
        $scope.dadosVenda.descontoEmValorOuPercentual = padrao;
        $timeout(function () {
            $scope.setarFocus('descontoItem');
        }, 300)
    };

    $scope.alteraPadraoAcrescimoItens = function (padrao) {
        $localStorage.padraoAcrescimo = padrao;
        $scope.dadosVenda.acrescimoEmValorOuPercentual = padrao;
        $timeout(function () {
            $scope.setarFocus('acrescimoItem');
        }, 300)
    };

    $scope.removeItem = function (item) {
        if ($scope.dadosVenda.idVendaCondicional) {
            swal("Atenção!", "Esta venda é referente a um Condicional,esta ação não é permitida. Tal ação deve ser efetuada na manutenção de Condicional!", "warning");
        }
        //else if (item.pkc_id) {
        //    swal({
        //        title: "O ITEM é referente a um Kit de Produtos, deseja realmente remover todos os itens que fazem parte deste Kit desta venda?",
        //        text: "",
        //        type: "warning",
        //        showCancelButton: true,
        //        cancelButtonText: "Não",
        //        confirmButtonClass: "btn-danger",
        //        confirmButtonText: "Sim, Remover TODOS os Itens",
        //        closeOnConfirm: true
        //    }, function (isConfirm) {
        //        if (isConfirm) {
        //            $scope.removerItensRefKit(item);
        //        }
        //    });
        //} else {
        var posicao = $scope.dadosVenda.listaItens.findIndex(function (i) {
            return i.nItem === item.nItem;
        });

        if (VendaService.removerItem(item.nItem)) {
            $scope.dadosVenda.listaItens.splice(posicao, 1);
            DadosFormularioService.armazenarDados('venda-varejo', $scope.dadosVenda);
            $scope.totaisNota();
        } else {
            swal("Atenção!", "Erro ao remover item " + item.pro_descricao + "!", "warning");
        }
        //}
    };
    $scope.removerItensRefKit = function (item) {
        if ($scope.dadosVenda.listaItens.length > 0) {
            var itemsToRemove = $scope.dadosVenda.listaItens.filter(function (produto) {
                return produto.pro_idkit === item.pro_idkit;
            });

            itemsToRemove.forEach(function (item) {
                if (VendaService.removerItem(item.nItem)) {
                    var index = $scope.dadosVenda.listaItens.indexOf(item);
                    if (index !== -1) {
                        $scope.dadosVenda.listaItens.splice(index, 1);
                    }
                } else {
                    swal("Atenção!", "Erro ao remover item " + item.pro_descricao + "!", "warning");
                }
            });
        }

        $timeout(function () {
            DadosFormularioService.armazenarDados('venda-varejo', $scope.dadosVenda);
            $scope.totaisNota();
            console.log("$scope.dadosVenda", $scope.dadosVenda);
            $scope.lerDadosVenda();
        }, 100);
    };


    $scope.removerItens = function () {
        if ($scope.dadosVenda.idVendaCondicional) {
            swal("Atenção!", "Esta venda é referente a um Condicional,esta ação não é permitida. Tal ação deve ser efetuada na manutenção de Condicional!", "warning");
        } else {
            swal({
                title: "Deseja realmente remover todos os itens desta venda?",
                text: "",
                type: "warning",
                showCancelButton: true,
                cancelButtonText: "Não",
                confirmButtonClass: "btn-danger",
                confirmButtonText: "Sim, Remover TODOS os Itens",
                closeOnConfirm: true
            }, function (isConfirm) {
                if (isConfirm) {
                    $scope.dadosVenda.qtdTotalItens = 0;
                    $scope.dadosVenda.listaItens.splice(0);
                    VendaService.removerItens();
                    DadosFormularioService.armazenarDados('venda-varejo', $scope.dadosVenda);
                    $scope.totaisNota();

                    $scope.lerDadosVenda();
                    console.log("$scope.dadosVenda", $scope.dadosVenda);
                }
            });
        }
    }

    $scope.totaisNota = function () {
        $scope.dadosVenda.subTotal = 0;
        $scope.dadosVenda.subTotalNota = 0;
        $scope.dadosVenda.totalDescontos = 0;
        $scope.dadosVenda.totalAcrescimos = 0;
        $scope.dadosVenda.totalNota = 0;
        if (!!$scope.dadosVenda.listaItens) {
            if ($scope.dadosVenda.listaItens.length > 0) {
                for (var i = 0; i < $scope.dadosVenda.listaItens.length; i++) {
                    $scope.dadosVenda.subTotal += FuncaoService.arredondar($scope.dadosVenda.listaItens[i].totalItem);
                    $scope.dadosVenda.totalDescontos += $scope.dadosVenda.listaItens[i].vlrDesconto;
                    $scope.dadosVenda.totalAcrescimos += (!!$scope.dadosVenda.listaItens[i].vlrAcrescimo) ? $scope.dadosVenda.listaItens[i].vlrAcrescimo : 0;
                }
                $scope.dadosVenda.subTotalNota = FuncaoService.arredondar(($scope.dadosVenda.subTotal + $scope.dadosVenda.totalAcrescimos) - $scope.dadosVenda.totalDescontos);
                $scope.dadosVenda.totalNota = $scope.dadosVenda.subTotalNota;
            };
        }
    };

    $scope.finalizaVenda = function () {
        $localStorage.padraoDesconto = "$";
        $localStorage.padraoAcrescimo = "$";
        $scope.dadosVenda.descontoEmValorOuPercentual = "$";
        $scope.dadosVenda.acrescimoEmValorOuPercentual = "$";
        DadosFormularioService.armazenarDados('venda-varejo', $scope.dadosVenda);
        $state.go('newpdv.finalizar-venda-varejo');
    };

    $scope.limparCampos = function () {
        $scope.listaPrecos = '';
        $scope.buscaCodigo = '';
        $scope.dadosProduto = null;
    };

    $scope.zerarDescontoAcrescimoItem = function (item, tipo) {
        switch (tipo) {
            case 'Editar':
                $scope.dadosItem.vlrDesconto = 0;
                $scope.dadosItem.desconto = 0;
                $scope.dadosItem.vlrAcrescimo = 0;
                $scope.dadosItem.acrescimo = 0;
                $scope.dadosItem.valorTotalItem = FuncaoService.arredondar($scope.dadosItem.vlrUnitario * $scope.dadosItem.quantidade);
                $scope.dadosItem.totalItemDesconto = FuncaoService.arredondar($scope.dadosItem.vlrUnitario * $scope.dadosItem.quantidade);
            case 'Incluir':
                $scope.dadosProduto.totalItem = FuncaoService.arredondar(item.nfi_qtde * item.nfi_valorunitario);
                $scope.dadosProduto.totalItemDesconto = FuncaoService.arredondar(item.nfi_qtde * item.nfi_valorunitario);
                $scope.dadosProduto.valorDesconto = 0;
                $scope.dadosProduto.desconto = 0;
                $scope.dadosProduto.acrescimo = 0;
        }
    };

    $scope.calcularValorItem = function (item, posicao, tipo) {
        $scope.dadosItem.valorTotalItem = Number($scope.dadosItem.valorTotalItem);
        switch (tipo) {
            case '+':
                $scope.dadosItem.valorTotalItem += item.valorUnitario * 1;
                break;
            case '-':
                $scope.dadosItem.valorTotalItem -= item.valorUnitario * 1;
                break;
            default:
                $scope.dadosItem.quantidade = (!!Number($scope.dadosItem.quantidade)) ? Number($scope.dadosItem.quantidade) : 1;
                $scope.dadosItem.valorTotalItem = FuncaoService.arredondar(item.valorUnitario * $scope.dadosItem.quantidade);
                $scope.dadosItem.valorTotalItem -= item.vlrDesconto;
                $scope.dadosItem.valorTotalItem += item.vlrAcrescimo;
                break;
        }
    };

    $scope.cancelarVenda = function () {
        $timeout(function () {
            swal({
                title: "Cancelar a venda?",
                text: "",
                type: "warning",
                showCancelButton: true,
                cancelButtonText: "Não",
                confirmButtonClass: "btn-danger",
                confirmButtonText: "Sim, quero cancelar",
                closeOnConfirm: true
            }, function (isConfirm) {
                if (isConfirm) {
                    $timeout(function () {
                        DadosFormularioService.limparDados('venda-varejo');
                        $scope.lerDadosVenda();
                        $scope.dadosVenda = {};
                        $scope.limparCampos();
                        $scope.dadosVenda.nItem = 1;
                        VendaService.cancelarEmissaoCupom();
                        limparDadosCliente();
                    });
                }
            })
        }, 100);
    };

    var limparDadosCliente = function () {
        $scope.dadosVenda.pes_nome = null;
        $scope.dadosVenda.pes_cpfcnpj = null;
        $scope.dadosVenda.cli_id = null;
        $scope.dadosVenda.ClienteId = null;
        $scope.nome = null;
        $scope.cpfCnpj = null;
    };

    $scope.verificarCaixaAberto = function () {
        $scope.caixaAberto = JSON.parse(controleCaixaAppService.listaControleCaixaAberto());
        if (!(!!$scope.caixaAberto)) {
            $scope.modalAberturaCaixa = ModalService.model($scope, 'views/pdv/controle_caixa/modalAberturaCaixa.html', 'lg', true, 'static', true);
        }
    }

    $scope.validarFormaPagamento = function () {
        $scope.dadosVenda.pagamento = (!!$scope.dadosVenda.pagamento) ? $scope.dadosVenda.pagamento : [];

        if (!!!$scope.dadosVenda.ClienteId) {
            for (var i = 0; i < $scope.dadosVenda.pagamento.length; i++) {
                if ($scope.dadosVenda.pagamento[i].formaPagamento.fpg_tipopagamento == tipoFormaPagamento.fpCreditoLoja) {
                    if ($scope.dadosVenda.pagamento.length == 1) {
                        swal("Você já definiu a forma de pagamento!", "Para modificar o cliente, primeiro remova a forma de pagamento!", "warning");
                        return false;
                        break;
                    }
                    if ($scope.dadosVenda.pagamento.length > 1) {
                        swal("Você já definiu as formas de pagamento!", "Para modificar o cliente, primeiro remova as formas de pagamento!", "warning");
                        return false;
                        break;
                    }
                }
            }
        }
        return true;
    };

    $scope.cancelarModalGrade = function () {
        $scope.modalGradesVendas.dismiss();
        delete $scope.modalGradesVendas;
        jaAbriuModalGradeProduto = false;
        $scope.dadosProduto = null;
    };

    $scope.setarNomeCliente = function (nomeCliente) {
        if (nomeCliente != null) {
            $scope.nome = nomeCliente;
        }
    };

    $scope.removerVendedor = function () {
        if ($scope.dadosVenda.ven_id) {
            $scope.dadosVenda.ven_nome = 'Sem Informação';
            $scope.dadosVenda.ven_id = null;
            $scope.dadosVenda.ven_maximodesconto = null;
        }
    };

    $scope.retornaNumeroCupom = function () {
        $scope.numeroCupom = JSON.parse(notaFiscalAppService.retornaNumeroCupom());
        console.log('numero cupom:', $scope.numeroCupom);
    };

    notificacaoAppService.gerarNotificacaoCertificadoDigitalEmpresa();
}]);