﻿newERP.controller('ModalDetalhesVendaController', ['$scope', 'ModalService', '$uibModalInstance', '$filter', 'param', 'FuncaoService', function ($scope, ModalService, $uibModalInstance, $filter, param, FuncaoService) {

    $scope.arrFinalidade = ["NF-E NORMAL", "NF-E COMPLEMENTAR", "NF-E DE AJUSTE", "DEVOLUÇÃO"];
    $scope.arrStatus = ["EM DIGITAÇÃO", "AUTORIZADA", "CANCELADA", "DENEGADA", "REJEITADA", "CONTINGÊNCIA"];
    $scope.arrAmbiente = ["PRODUÇÃO", "HOMOLOGAÇÃO"];
    $scope.arrOperacao = ["ENTRADA", "SAIDA"];
    $scope.descricaoBotaoDesconto = '%';

    var idNota = param.dados.idNota;
    var retorno = JSON.parse(notaFiscalAppService.buscarVenda(idNota));
    $scope.detalhesNF = retorno[0];

    angular.forEach($scope.detalhesNF.ItensNf, function (item) {
        var totalItemSemDesconto = FuncaoService.arredondar(item.nfi_qtde * item.nfi_valorunitario);
        item.perc_desconto = FuncaoService.arredondar((item.nfi_valordesconto / totalItemSemDesconto) * 100);
        item.valor_item_desconto = totalItemSemDesconto - item.nfi_valordesconto ;
    });

    $scope.mudarDescricaoBotaoDesconto = function () {
        if ($scope.descricaoBotaoDesconto === '%') {
            $scope.descricaoBotaoDesconto = 'R$';
        } else {
            $scope.descricaoBotaoDesconto = '%';
        }
    };

    $scope.closeModal = function () {
        $uibModalInstance.close();
    };
}]);
