﻿newERP.controller('AtivarPdvController', ['$scope', '$state', 'FuncaoService', 'growlService', '$timeout', function ($scope, $state, FuncaoService, growlService, $timeout) {
    $scope.dadosLogin = {
        email: null,
        senha: null,
        erro: null
    };

    $scope.listaEmpresas = [];
    $scope.listaLocais = [];

    $scope.realizandoLogin = false;

    $scope.listarEmpresas = function () {
        $scope.realizandoLogin = true;    
        var retorno = loginNewErpService.geraTokenAutenticacao($scope.dadosLogin);
        $scope.realizandoLogin = false;
        if (retorno === true) {
            $scope.dadosLogin.erro = null;
            if (inicializacaoAppService.pdvRegistrado() == true && inicializacaoAppService.pdvAtivado() == false) {
                $state.go("pdvBloqueado");
            }
            else {
                $scope.listaEmpresas = JSON.parse(loginNewErpService.listaEmpresasUsuario());
                $scope.setarFocus('empresa');
            }
        } else {
            $scope.dadosLogin.erro = "Usuário ou senha inválidos!";
            $scope.setarFocus('usuario');
        }
    };

    $scope.setarFocus = function (nomeElemento) {
        $timeout(function () {
            document.getElementsByName(nomeElemento)[0].focus();
        });

        $timeout(function () {
            $scope.$apply(function () {
                $('select[name="' + nomeElemento + '"]').chosen({});
                $('select[name="' + nomeElemento + '"]').trigger("chosen:open");
            });
        });
    };

    $scope.listarLocalEmpresa = function (codigoEmpresa) {
        var listaLocaisAcesso = JSON.parse(loginNewErpService.listaLocaisUsuario(codigoEmpresa));
        $scope.listaLocais = [];
        angular.forEach(listaLocaisAcesso, function (local) {
            var listaLocal = local;
            listaLocal.loc_descricaoCNPJ = local.loc_descricao + "|CNPJ: " + FuncaoService.formatarCpfCnpj(local.loc_cnpj.numero);
            $scope.listaLocais.push(listaLocal);
        });
        $timeout(function () {
            $scope.setarFocus('local');
        }, 100)
    };

    $scope.realizarAtivacaoLicenca = function () {
        if (setupPdvService.registarPdv($scope.model.empresaSelecionada, $scope.model.localSelecionado, $scope.model.numeroCaixa)) {
            if (inicializacaoAppService.pdvAtivado() == false) {
                $state.go("pdvBloqueado");
            }
            else {
                $scope.verificarLiberacaoPdv();
            }
        }
    };

    $scope.ativarLicenca = function () {
        if (!!$scope.model.numeroCaixa == false) {
            swal({
                title: 'O número do caixa PRECISA ser informado!',
                text: "Você deve informar o número deste caixa para realizar o registro do PDV.",
                type: "warning",
                confirmButtonClass: "btn-info",
                confirmButtonText: "OK",
                closeOnConfirm: true
            }, function (acao) {
                if (acao) {
                    $timeout(function () {
                        $scope.setarFocus('numeroCaixa');
                    }, 100);
                }
            });
        }
        else {
            if (setupPdvService.verificaCaixaExistente($scope.model.localSelecionado.loc_id,$scope.model.numeroCaixa) == false) {
                $scope.realizarAtivacaoLicenca();
            }
            else {
                swal({
                    title: "Este local já possui um caixa definido com o número: " + $scope.model.numeroCaixa + "!",
                    text: "Este local já possui um outro caixa definido com esta numeração. Manter dois caixas em funcionamento com o mesmo número pode gerar problemas de duplicidade de NFC-e por exemplo, impossibilitando a emissão dos documentos.",
                    type: "warning",
                    showCancelButton: true,
                    cancelButtonText: "Alterar Número (ESC)",
                    confirmButtonClass: "btn-info",
                    confirmButtonText: "CONTINUAR mesmo assim (ENTER)",
                    closeOnConfirm: true
                }, function (acao) {
                    if (acao) {
                        $scope.realizarAtivacaoLicenca();
                    }
                    else {
                        $scope.setarFocus('numeroCaixa');
                    }
                });
            }
        }
    };

    $scope.retornaDadosPdv = function () {
        $scope.dadosPdv = setupPdvService.retornaDadosPdv();
    };

    $scope.sairDoApp = function () {
        aplicacaoService.finalizarAplicacao();
    };

    $scope.verificarLiberacaoPdv = function () {
        if (setupPdvService.verificaPdvLiberado()) {
            $state.go("downloadDados");
        }
        else {
            growlService.growl('Este PDV ainda não está liberado para uso!', 'danger', 'center');
        }
    };

}]);