﻿newERP.controller('ApiPdvController', ['$scope', 'ModalService', '$timeout', 'growlService', '$state', function ($scope, ModalService, $timeout, growlService, $state) {
    $scope.mostrarQRCodePreVenda = false;
    $scope.atualizandoDados = false;

    $scope.entidades = [
        { entidade: 'Empresa', descricao: 'Dados da empresa', selecionado: false },
        { entidade: 'Config', descricao: 'Dados de configurações da empresa', selecionado: false },
        { entidade: 'Cliente', descricao: 'Dados de clientes', selecionado: false },
        { entidade: 'Produto', descricao: 'Dados de produtos', selecionado: false },
        { entidade: 'Pedido', descricao: 'Dados de pedidos de clientes', selecionado: false },
        { entidade: 'Condicional', descricao: 'Dados de condicionais', selecionado: false },
        { entidade: 'Orcamento', descricao: 'Dados de orçamentos emitidos para clientes', selecionado: false },
        { entidade: 'Tributacao', descricao: 'Dados de tributações (ICMS, PIS, COFINS...)', selecionado: false },
        { entidade: 'ContasReceber', descricao: 'Dados de contas à receber', selecionado: false }
    ];

    $scope.buscarDados = function () {
        $scope.config = configPdvAppService.retornaConfiguracao();
        $scope.dadosPdv = pdvAppService.retornaDadosPdv();
        if ($scope.config.utilizaPreVenda == true) {
            $scope.mostrarQRCodePreVenda = true;
        }
    };

    $scope.abrirModalQRCodeConfigServidorPreVenda = function () {
        $timeout(function () {
            var urlApi = aplicacaoService.retornaIP() + ':' + $scope.config.portaPreVenda;
            var dadosServidorPreVenda = { "descricao": "Caixa nº: " + $scope.dadosPdv.nroCaixa, "nome_computador": aplicacaoService.retornaNomePC(), "endereco_ip": urlApi };
            $scope.textoQRCode = JSON.stringify(dadosServidorPreVenda);
            $scope.modalCheque = ModalService.model($scope, 'views/pdv/acesso-api-pdv/modalAcessoApiPdv.html', 'md', true, true, true);
        })
    }

    $scope.atualizarTabelaIbpt = function () {
        swal({
            title: "Atualizar Dados da Tabela do IBPT?",
            text: "Este procedimento irá atualizar a tabela do IBPT, utilizada para informar o valor dos tributos aproximados (federal, estadual e municipal) no cupom fiscal. Continuar com o download?",
            type: "warning",
            showCancelButton: true,
            cancelButtonText: "Não (ESC)",
            confirmButtonClass: "btn-info",
            confirmButtonText: "CONTINUAR com a Atualização (ENTER)",
            closeOnConfirm: true
        }, function (acao) {
            if (acao) {
                $scope.modalDownload = ModalService.model($scope, 'views/pdv/download-dados/modalDownloadDados.html', 'lg', true, 'static', true);
                $timeout(function () {
                    ibptAppService.atualizarDadosTabela();
                    $scope.modalDownload.close();
                    swal("Atualização de Dados da tabela do IBPT Concluída!", "", "success");
                }, 300);
            }
        });
    }

    $scope.atualizarDados = function () {

        swal({
            title: "Atualizar Banco de Dados do PDV?",
            text: "Este procedimento irá realizar o download dos dados do NewERP para o PDV. Deseja continuar?",
            type: "warning",
            showCancelButton: true,
            cancelButtonText: "Não (ESC)",
            confirmButtonClass: "btn-info",
            confirmButtonText: "CONTINUAR com o Download (ENTER)",
            closeOnConfirm: true
        }, function (acao) {
            if (acao) {
                $scope.modalDownload = ModalService.model($scope, 'views/pdv/download-dados/modalDownloadDados.html', 'lg', true, 'static', true);
                $timeout(function () {
                    var retorno = sincronizaDadosService.sincronizar();
                    console.log("RETORNO", retorno);
                    retorno = retorno.split("|", 2);
                    //clienteAppService.atualizarIdCliente();
                    //contaPagarReceberAppService.atualizarIdCliente();
                    //vendaCondicionalAppService.atualizarIdCliente();
                    //vendaCondicionalAppService.atualizarIdCondicional();
                    orcamentoAppService.atualizarIdCliente();
                    orcamentoAppService.atualizarIdOrcamento();
                    orcamentoAppService.atualizarIdOrcamentoPgto();
                    $scope.modalDownload.close();
                    $state.go('newpdv.home-pdv');
                    swal(retorno[1], "", retorno[0]);
                }, 300);
            }
        });
    }
    $scope.atualizarProdutos = function () {

        swal({
            title: "Atualizar Dados de Produtos no PDV?",
            text: "Este procedimento irá realizar apenas o download de novos cadastros e/ou atualização de PRODUTOS para o PDV. Deseja continuar?",
            type: "warning",
            showCancelButton: true,
            cancelButtonText: "Não (ESC)",
            confirmButtonClass: "btn-info",
            confirmButtonText: "CONTINUAR com o Download (ENTER)",
            closeOnConfirm: true
        }, function (acao) {
            if (acao) {
                $scope.modalDownload = ModalService.model($scope, 'views/pdv/download-dados/modalDownloadDados.html', 'lg', true, 'static', true);
                $timeout(function () {
                    var retorno = sincronizaDadosService.atualizarDadosProdutos();
                    console.log("RETORNO", retorno);
                    retorno = retorno.split("|", 2);
                    $scope.modalDownload.close();
                    $state.go('newpdv.home-pdv');
                    swal(retorno[1], "", retorno[0]);
                }, 300);
            }
        });
    }

    $scope.zipparXMLs = function () {

        swal({
            title: "Esta opção irá compactar os XMLs do banco. Deseja continuar?",
            type: "warning",
            showCancelButton: true,
            cancelButtonText: "Não (ESC)",
            confirmButtonClass: "btn-info",
            confirmButtonText: "CONTINUAR com o Processo (ENTER)",
            closeOnConfirm: true
        }, function (acao) {
            if (acao) {
                $scope.modalDownload = ModalService.model($scope, 'views/pdv/download-dados/modalDownloadDados.html', 'lg', true, 'static', true);
                $timeout(function () {
                    var retorno = sincronizaDadosService.zipparXMLs();
                    console.log("RETORNO", retorno);
                    if (retorno)
                        swal("Atualização de XML Concluída!", "", "success");
                    else
                        swal("Erro na Atualização de XML Concluída!", "", "warning");

                    $scope.modalDownload.close();
                }, 300);
            }
        });
    }

    $scope.abrirModalFechamentoCaixa = function () {
        ModalService.model($scope, 'views/pdv/controle_caixa/modalFechamentoCaixa.html', 'lg', true, true, true);
    }

    $scope.enviarDadosPendentes = function () {
        var retorno = sincronizaDadosService.enviar();
        growlService.growl(retorno, 'inverse', null, 2500);
    }

}]);