﻿using ACBrFramework.TEFDTeste;
using NewERP.Helpers;
using NewERP.PDV.Desktop.Entidades.TEF;
using NewERP.PDV.Desktop.Entidades.TEF.Events;
using NewERP.PDV.Desktop.Enums;
using NewERP.PDV.Desktop.Enums.TEF;
using QRCoder;
using System;
using System.Drawing;
using System.Text;
using System.Threading;
using System.Windows.Forms;

namespace NewERP.PDV.Desktop.FormsSiTefGestor
{
    public partial class PopupTEF : Form
    {
        // Variável para controle do loop
        private bool _isRunning = true;
        private Button buttonCancel;
        private GroupBox grbOperador;
        public Label lblMensagemOperador;
        private GroupBox grbCliente;
        public Label lblMensagemCliente;
        private PictureBox pictureBox1;
        private Thread _backgroundThread;
        private TEF _tef; // Campo para armazenar o objeto TEF
        int RetInt;
        ComandosSiTef Comando = 0;
        int TipoCampo = 0;
        short TamMin = 0;
        short TamMax = 0;
        int TamBuffer = 0;
        int nContinua = 0;

        private string _valor = "";
        private string _nsuHost = "";
        private string _dataDocumento = "";
        private string _horaDocumento = "";

        ACBrFramework.TEFDTeste.MenuForm menuForm = new ACBrFramework.TEFDTeste.MenuForm();
        ACBrFramework.TEFDTeste.InputForm inputForm = new ACBrFramework.TEFDTeste.InputForm();

        public PopupTEF(TEF tef)
        {
            InitializeComponent();
            this.Load += new EventHandler(Form1_Load); // Associa o evento Load ao método Form1_Load
            _tef = tef; // Atribuir o objeto TEF ao campo

        }

        private void Form1_Load(object sender, EventArgs e)
        {
            // Iniciar o loop em segundo plano ao abrir a tela
            StartBackgroundTask();
            _isRunning = true;
        }

        // Método que inicia o loop em uma thread separada
        private void StartBackgroundTask()
        {
            _backgroundThread = new Thread(BackgroundTask);
            _backgroundThread.IsBackground = true;  // Permite que a thread seja finalizada automaticamente ao fechar a aplicação
            _backgroundThread.Start();
        }

        // O loop que será executado enquanto _isRunning for true
        private void BackgroundTask()
        {
            var buffer = new StringBuilder(2000);
            string TituloList = "";
            TEFSiTefCliObtemCampoEventArgs pars = new TEFSiTefCliObtemCampoEventArgs();
            DialogResult reto = new DialogResult();
            _tef.statusTransacao = (int)StatusTransacao.Iniciado;

            TEFSiTefExibeMenuEventArgs e;
            MenuForm menuForm = new MenuForm();
            string[] menuOptions;
            DialogResult ret;

            do
            {
                RetInt = CliSiTef.ContinuaFuncaoSiTefInterativo(out Comando, out TipoCampo, out TamMin, out TamMax, buffer, TamBuffer, nContinua);
                if (RetInt == 10000)
                {
                    if (Comando == ComandosSiTef.CancelPinPadOperation || Comando == ComandosSiTef.DisplayMessage || Comando == ComandosSiTef.DisplayMessageQrCode)
                        ativaDesativaCancelar(true);
                    else
                        ativaDesativaCancelar(false);

                    switch (Comando)
                    {
                        case ComandosSiTef.Store:
                            switch (TipoCampo)
                            {
                                case (int)TipoCampoSiTef.ModalidadePgto:
                                    RetornaGrupoModalidade(buffer.ToString());
                                    break;
                                case (int)TipoCampoSiTef.ModalidadePgtoDescicao:
                                    _tef.resposta.ModalidadePgtoDescicao = TextoHelper.RemoveEspacoInicioFinal(buffer.ToString());
                                    break;
                                case (int)TipoCampoSiTef.DataHoraTransacao:
                                    _tef.resposta.DataHora = DataHelpers.ConverterParaDateTime(buffer.ToString());
                                    break;
                                case (int)TipoCampoSiTef.ComprovanteCliente:
                                    _tef.viaCliente = buffer.ToString();
                                    break;
                                case (int)TipoCampoSiTef.ComprovanteLoja:
                                    _tef.viaLoja = buffer.ToString();
                                    break;
                                case (int)TipoCampoSiTef.CodigoBandeira:
                                    _tef.resposta.CodigoBandeira = buffer.ToString();
                                    break;
                                case (int)TipoCampoSiTef.NsuSiTef:
                                    _tef.resposta.NSU = buffer.ToString();
                                    break;
                                case (int)TipoCampoSiTef.NsuHostSiTef:
                                    _tef.resposta.NSUHost = buffer.ToString();
                                    break;
                                case (int)TipoCampoSiTef.ValorPagto:
                                    _tef.resposta.ValorTotal = decimal.Parse(buffer.ToString());
                                    break;
                                case (int)TipoCampoSiTef.NomeBandeira:
                                    _tef.resposta.NomeBandeira = TextoHelper.RemoveEspacoInicioFinal(buffer.ToString());
                                    break;
                                case (int)TipoCampoSiTef.CodigoRede:
                                    _tef.resposta.Rede = TextoHelper.RemoveEspacoInicioFinal(buffer.ToString());
                                    break;
                                case (int)TipoCampoSiTef.NumeroPagamentoCupom:
                                    _tef.resposta.NumeroPagamentoCupom = TextoHelper.RemoveEspacoInicioFinal(buffer.ToString());
                                    break;
                                case (int)TipoCampoSiTef.NumeroParcelas:
                                    _tef.resposta.QtdParcelas = int.Parse(TextoHelper.RemoveEspacoInicioFinal(buffer.ToString()));
                                    break;
                                case (int)TipoCampoSiTef.CNPJAutorizacaoNFCe:
                                    _tef.resposta.CNPJAdministradora = TextoHelper.RemoveEspacoInicioFinal(buffer.ToString());
                                    break;
                                case (int)TipoCampoSiTef.NumeroAutorizacaoNFCe:
                                    _tef.resposta.NSU = buffer.ToString();
                                    break;
                                case (int)TipoCampoSiTef.BandeiraNFCe:
                                    _tef.resposta.NomeBandeira = EnumHelper.retornaDescricao((BandeiraPadraoSiTef)TextoHelper.RemoveEspacoInicioFinal(buffer.ToString()).ToInt());
                                    break;
                                case (int)TipoCampoSiTef.EndtoEndId:
                                    _tef.resposta.EndtoEndId = buffer.ToString();
                                    break;
                                default:
                                    break;
                            }

                            break;
                        case ComandosSiTef.DisplayOperatorMessage:
                            exibeMensagemOperador(buffer.ToString());
                            break;
                        case ComandosSiTef.DisplayCustomerMessage:
                            exibeMensagemCliente(buffer.ToString());
                            break;
                        case ComandosSiTef.DisplayMessage:
                            exibeMensagemOperador(buffer.ToString());
                            break;
                        case ComandosSiTef.DisplayMenuHeader:
                            TituloList = buffer.ToString();
                            break;
                        case ComandosSiTef.ClearOperatorMessage:
                            exibeMensagemOperador("");
                            break;
                        case ComandosSiTef.ClearCustomerMessage:
                            exibeMensagemCliente("");
                            break;
                        case ComandosSiTef.ClearMessage:
                            exibeMensagemOperador("");
                            exibeMensagemCliente("");
                            break;
                        case ComandosSiTef.ClearMenuHeader:
                            if (nContinua == 1) nContinua = 0;
                            break;
                        case ComandosSiTef.DisplayHeader:
                            break;
                        case ComandosSiTef.ClearHeader:
                            break;
                        case ComandosSiTef.DisplayConfirm:
                            DialogResult confirm = MessageBox.Show(buffer.ToString(), "Confirmar Operação?", MessageBoxButtons.YesNo, MessageBoxIcon.Question, MessageBoxDefaultButton.Button1, MessageBoxOptions.DefaultDesktopOnly);

                            switch (confirm)
                            {
                                case DialogResult.Yes:
                                    nContinua = 1;
                                    break;
                                case DialogResult.No:
                                    nContinua = 0;
                                    break;
                            }
                            break;
                        case ComandosSiTef.DisplayMenuOptions:
                            menuOptions = TextoHelper.ConverterStringParaArray(buffer.ToString(), ';');
                            e = new TEFSiTefExibeMenuEventArgs(TituloList, menuOptions);
                            menuForm = new MenuForm();
                            menuForm.Initialize(e);
                            ret = menuForm.ShowDialog();
                            switch (ret)
                            {
                                case DialogResult.OK:
                                    e.ItemSelecionado = menuForm.SelectedItem + 1;
                                    buffer.Clear();
                                    buffer.Append(e.ItemSelecionado.ToString());
                                    break;
                                case DialogResult.Cancel:
                                    nContinua = -1; //?
                                    e.VoltarMenu = true; //?
                                    break;
                            }

                            break;
                        case ComandosSiTef.WaitAnyKey:
                            exibeMensagemOperador(buffer.ToString());
                            break;
                        case ComandosSiTef.CancelPinPadOperation:
                            Thread.Sleep(1000);
                            break;
                        case ComandosSiTef.ParameterNeeded:
                            break;
                        case ComandosSiTef.TextInputNeeded:
                            if (TipoCampo == (int)TipoCampoSiTef.SenhaSupervisor)
                            {
                                buffer.Clear();
                                buffer.Append("");
                            }
                            else if (TipoCampo == (int)TipoCampoSiTef.DataCancelamento && !string.IsNullOrEmpty(_dataDocumento))
                            {
                                buffer.Clear();
                                buffer.Append(_dataDocumento);
                            }
                            else if (TipoCampo == (int)TipoCampoSiTef.NumeroDocCancelamento && !string.IsNullOrEmpty(_nsuHost))
                            {
                                buffer.Clear();
                                buffer.Append(_nsuHost);
                            }
                            else
                            {
                                pars.Titulo = buffer.ToString();
                                pars.TamanhoMinimo = TamMin;
                                pars.TamanhoMaximo = TamMax;

                                inputForm.Initialize(pars);
                                reto = inputForm.ShowDialog();

                                switch (reto)
                                {
                                    case DialogResult.OK:
                                        pars.Resposta = inputForm.InputText;
                                        buffer.Clear();
                                        buffer.Append(pars.Resposta);
                                        break;
                                    case DialogResult.Cancel:
                                        pars.VoltarMenu = true; //Voltar?
                                        nContinua = 1; //?
                                        break;
                                }
                            }
                            break;
                        case ComandosSiTef.CheckInputNeeded: break;
                        case ComandosSiTef.MoneyInputNeeded:

                            if (TipoCampo == (int)TipoCampoSiTef.ValorCancelamento && !string.IsNullOrEmpty(_valor))
                            {
                                buffer.Clear();
                                buffer.Append(_valor);
                            }
                            else
                            {
                                pars.Titulo = buffer.ToString();
                                pars.TamanhoMinimo = TamMin;
                                pars.TamanhoMaximo = TamMax;

                                inputForm.Initialize(pars);
                                reto = inputForm.ShowDialog();

                                switch (reto)
                                {
                                    case DialogResult.OK:
                                        pars.Resposta = inputForm.InputText;
                                        buffer.Clear();
                                        buffer.Append(pars.Resposta);
                                        break;
                                    case DialogResult.Cancel:
                                        pars.VoltarMenu = true; //Voltar?
                                        nContinua = 1; //?
                                        break;
                                }
                            }
                            break;
                        case ComandosSiTef.BarcodeInputNeeded:
                            break;
                        case ComandosSiTef.PasswordTextInputNeeded: break;
                        case ComandosSiTef.DisplayIdentifiedMenuOptions:
                            menuOptions = TextoHelper.ConverterStringParaArray(buffer.ToString(), ';');
                            e = new TEFSiTefExibeMenuEventArgs(TituloList, menuOptions);
                            menuForm = new MenuForm();
                            menuForm.Initialize(e);
                            ret = menuForm.ShowDialog();
                            switch (ret)
                            {
                                case DialogResult.OK:
                                    e.ItemSelecionado = menuForm.SelectedItem + 1;
                                    buffer.Clear();
                                    buffer.Append(e.ItemSelecionado.ToString());
                                    break;
                                case DialogResult.Cancel:
                                    nContinua = -1; //?
                                    e.VoltarMenu = true; //?
                                    break;
                            }

                            break;
                        case ComandosSiTef.DisplayQrCode:
                            exibeQrCodeCliente(buffer.ToString());
                            break;
                        case ComandosSiTef.ClearQrCode:
                            // exibeQrCodeCliente("");
                            break;
                        case ComandosSiTef.DisplayMessageQrCode:
                            exibeMensagemOperador(buffer.ToString());
                            break;
                    }

                }
            } while (RetInt == 10000);

            if (RetInt == 0)
                _tef.statusTransacao = (int)StatusTransacao.PendenteParaConfirmacao;
            if (RetInt < 0)
                _tef.RetInt = RetInt;
            if (RetInt > 0)
                _tef.RetInt = RetInt;

            
            _isRunning = false;

            FecharPopup();
        }

        // Método para fechar o formulário
        private void FecharPopup()
        {
            if (this.InvokeRequired)
            {
                this.Invoke(new Action(() => this.Close()));
            }
            else
            {
                this.Close();
            }
        }
        private string RetornaGrupoModalidade(string dados)
        {
            string codGrupo = dados.Substring(0, 2);
            switch (codGrupo)
            {
                case "00":
                    return "Cheque";
                case "01":
                    _tef.resposta.Debito = true;
                    return "Cartão de Débito";
                case "02":
                    _tef.resposta.Credito = true;
                    return "Cartão de Crédito";
                case "03":
                    return "Cartão tipo Voucher";
                case "05":
                    return "Cartão Fidelidade";
                case "98":
                    return "Dinheiro";
                case "99":
                    return "Outro tipo de cartão";
                default:
                    return "";
            }
        }

        // Botão Cancelar - quando clicado, interrompe o loop
        private void btnCancelar_Click(object sender, EventArgs e)
        {
            nContinua = -1;
        }

        private void InitializeComponent()
        {
            this.buttonCancel = new System.Windows.Forms.Button();
            this.grbOperador = new System.Windows.Forms.GroupBox();
            this.lblMensagemOperador = new System.Windows.Forms.Label();
            this.grbCliente = new System.Windows.Forms.GroupBox();
            this.pictureBox1 = new System.Windows.Forms.PictureBox();
            this.lblMensagemCliente = new System.Windows.Forms.Label();
            this.grbOperador.SuspendLayout();
            this.grbCliente.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.pictureBox1)).BeginInit();
            this.SuspendLayout();
            // 
            // buttonCancel
            // 
            this.buttonCancel.Enabled = false;
            this.buttonCancel.Location = new System.Drawing.Point(456, 362);
            this.buttonCancel.Name = "buttonCancel";
            this.buttonCancel.Size = new System.Drawing.Size(75, 30);
            this.buttonCancel.TabIndex = 0;
            this.buttonCancel.Text = "CANCELAR";
            this.buttonCancel.UseVisualStyleBackColor = true;
            this.buttonCancel.Click += new System.EventHandler(this.btnCancelar_Click);
            // 
            // grbOperador
            // 
            this.grbOperador.Controls.Add(this.lblMensagemOperador);
            this.grbOperador.Font = new System.Drawing.Font("Microsoft Sans Serif", 10F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.grbOperador.Location = new System.Drawing.Point(12, 12);
            this.grbOperador.Name = "grbOperador";
            this.grbOperador.Size = new System.Drawing.Size(525, 92);
            this.grbOperador.TabIndex = 2;
            this.grbOperador.TabStop = false;
            this.grbOperador.Text = "Operador";
            // 
            // lblMensagemOperador
            // 
            this.lblMensagemOperador.Font = new System.Drawing.Font("Microsoft Sans Serif", 12F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.lblMensagemOperador.Location = new System.Drawing.Point(6, 16);
            this.lblMensagemOperador.Name = "lblMensagemOperador";
            this.lblMensagemOperador.Size = new System.Drawing.Size(513, 66);
            this.lblMensagemOperador.TabIndex = 0;
            this.lblMensagemOperador.Text = "Aguarde...";
            this.lblMensagemOperador.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
            // 
            // grbCliente
            // 
            this.grbCliente.Controls.Add(this.pictureBox1);
            this.grbCliente.Controls.Add(this.lblMensagemCliente);
            this.grbCliente.Font = new System.Drawing.Font("Microsoft Sans Serif", 10F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.grbCliente.Location = new System.Drawing.Point(12, 110);
            this.grbCliente.Name = "grbCliente";
            this.grbCliente.Size = new System.Drawing.Size(525, 248);
            this.grbCliente.TabIndex = 3;
            this.grbCliente.TabStop = false;
            this.grbCliente.Text = "Cliente";
            // 
            // pictureBox1
            // 
            this.pictureBox1.Location = new System.Drawing.Point(110, 11);
            this.pictureBox1.Name = "pictureBox1";
            this.pictureBox1.Size = new System.Drawing.Size(274, 231);
            this.pictureBox1.TabIndex = 3;
            this.pictureBox1.TabStop = false;
            this.pictureBox1.Visible = false;
            // 
            // lblMensagemCliente
            // 
            this.lblMensagemCliente.Font = new System.Drawing.Font("Microsoft Sans Serif", 12F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.lblMensagemCliente.Location = new System.Drawing.Point(7, 16);
            this.lblMensagemCliente.Name = "lblMensagemCliente";
            this.lblMensagemCliente.Size = new System.Drawing.Size(513, 92);
            this.lblMensagemCliente.TabIndex = 2;
            this.lblMensagemCliente.Text = "....";
            this.lblMensagemCliente.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
            // 
            // PopupTEF
            // 
            this.ClientSize = new System.Drawing.Size(544, 395);
            this.ControlBox = false;
            this.Controls.Add(this.grbCliente);
            this.Controls.Add(this.grbOperador);
            this.Controls.Add(this.buttonCancel);
            this.Name = "PopupTEF";
            this.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen;
            this.TopMost = true;
            this.grbOperador.ResumeLayout(false);
            this.grbCliente.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)(this.pictureBox1)).EndInit();
            this.ResumeLayout(false);

        }

        private void ativaDesativaCancelar(bool ativa)
        {
            if (buttonCancel.InvokeRequired)
            {
                buttonCancel.Invoke(new Action(() => buttonCancel.Enabled = ativa));
            }
            else
            {
                buttonCancel.Enabled = ativa;
            }

        }

        private void exibeMensagemOperador(string mensagem)
        {
            Console.WriteLine("exibeMensagemOperador" + mensagem);
            if (lblMensagemOperador.InvokeRequired)
            {
                lblMensagemOperador.Invoke(new Action(() => lblMensagemOperador.Text = mensagem));
            }
            else
            {
                lblMensagemOperador.Text = mensagem;
            }
        }

        public void exibeMensagemCliente(string mensagem)
        {
            Console.WriteLine("exibeMensagemCliente" + mensagem);
            // Verifica se é necessário usar Invoke
            if (lblMensagemCliente.InvokeRequired)
            {
                lblMensagemCliente.Invoke(new Action(() =>
                {
                    pictureBox1.Visible = false;
                    lblMensagemCliente.Visible = true;
                    lblMensagemCliente.Text = mensagem;
                }));
            }
            else
            {
                pictureBox1.Visible = false;
                lblMensagemCliente.Visible = true;
                lblMensagemCliente.Text = mensagem;
            }
        }

        public void exibeQrCodeCliente(string mensagem)
        {
            Console.WriteLine("exibeQrCodeCliente" + mensagem);

            if (string.IsNullOrWhiteSpace(mensagem))
            {
                if (pictureBox1.InvokeRequired)
                {
                    pictureBox1.Invoke(new Action(() =>
                    {
                        lblMensagemCliente.Visible = false;
                        pictureBox1.Visible = true;

                    }));
                }
            }



            if (pictureBox1.InvokeRequired)
            {
                pictureBox1.Invoke(new Action(() =>
                {
                    lblMensagemCliente.Visible = false;
                    pictureBox1.Visible = true;

                    try
                    {
                        using (QRCodeGenerator qrGenerator = new QRCodeGenerator())
                        {
                            using (QRCodeData qrCodeData = qrGenerator.CreateQrCode(mensagem, QRCodeGenerator.ECCLevel.Q))
                            {
                                using (QRCode qrCode = new QRCode(qrCodeData))
                                {
                                    // Obter a imagem do QR Code com o mesmo tamanho do PictureBox
                                    Bitmap qrCodeImage = qrCode.GetGraphic(20);
                                    Bitmap resizedQrCode = new Bitmap(qrCodeImage, pictureBox1.Size);
                                    pictureBox1.Image = resizedQrCode;
                                }
                            }
                        }
                    }
                    catch (Exception ex)
                    {
                        MessageBox.Show($"Erro ao gerar o QR Code: {ex.Message}");
                    }
                }));
            }
            else
            {
                lblMensagemCliente.Visible = false;
                pictureBox1.Visible = true;

                try
                {
                    using (QRCodeGenerator qrGenerator = new QRCodeGenerator())
                    {
                        using (QRCodeData qrCodeData = qrGenerator.CreateQrCode(mensagem, QRCodeGenerator.ECCLevel.Q))
                        {
                            using (QRCode qrCode = new QRCode(qrCodeData))
                            {
                                // Obter a imagem do QR Code com o mesmo tamanho do PictureBox
                                Bitmap qrCodeImage = qrCode.GetGraphic(20);
                                Bitmap resizedQrCode = new Bitmap(qrCodeImage, pictureBox1.Size);
                                pictureBox1.Image = resizedQrCode;
                            }
                        }
                    }
                }
                catch (Exception ex)
                {
                    MessageBox.Show($"Erro ao gerar o QR Code: {ex.Message}");
                }
            }
        }
    }
}