﻿newERP.controller('TransferenciaController', ['$scope', 'hotkeys', 'FuncaoService', function ($scope, hotkeys, FuncaoService) {

    $scope.dadosTransferencia = {
        mcc_datahora: new Date(),
        ctc_id: null,
        ctg: null,
        ctgDestino: null,
        ctc: null,
        mcc_numerodocumento: null,
        valor: 0,
        mcc_complemento: null,
        ctx_id: null
    };

    $scope.model = {
        saldoAtual: 0,
        exibirHistorico: false,
        localOrigem: null
    };

    $scope.model.localOrigem = JSON.parse(localAppService.retornaLocalPDV());

    var saldoUltimoFechamento = JSON.parse(controleCaixaAppService.saldoAtual());
    $scope.model.saldoAtual = saldoUltimoFechamento;


    var buscarDadosPdv = pdvAppService.retornaDadosPdv();
    if (!!buscarDadosPdv) {
        $scope.dadosTransferencia.ctc_id = buscarDadosPdv.ctc_id;
    }

    var dadosCaixaAberto = JSON.parse(controleCaixaAppService.listaControleCaixa())[0];
    $scope.dadosTransferencia.ctx_id = dadosCaixaAberto.Id;

    hotkeys.bindTo($scope);

    $scope.keyEnterLancDespesa = function () {
        $scope.salvarLancamentoCaixa();
    };

    $scope.keyEscLancDespesa = function () {
        $scope.modalLancamentoDespesa.close();
    };

    $scope.realizandoTransferencia = false;
    $scope.salvarTransferencia = function () {
        if (!!$scope.dadosTransferencia.ctg === false) {
            setTimeout(function () {
                swal("É Obrigatório informar a conta gerencial", "", "warning");
                FuncaoService.setarFocus('ctg_id', 300);
            }, 100);
        }
        else if (!!$scope.dadosTransferencia.ctc === false) {
            setTimeout(function () {
                swal("É Obrigatório informar a conta corrente de destino", "", "warning");
                FuncaoService.setarFocus('ctc_id', 300);
            }, 100);
        }
        else if (!!$scope.dadosTransferencia.ctgDestino === false) {
            setTimeout(function () {
                swal("É Obrigatório informar a conta gerencial para o destino", "", "warning");
                FuncaoService.setarFocus('ctg_idDestino', 300);
            }, 100);
        }
        else if (!!$scope.dadosTransferencia.valor === false || $scope.dadosTransferencia.valor === 0) {
            setTimeout(function () {
                swal("O Valor do Lançamento é Obrigatório", "", "warning");
                FuncaoService.setarFocus('mcc_valor', 300);
            }, 100);
        } else {
            $scope.realizandoTransferencia = true;
            let dadosTransferencia = {};
            dadosTransferencia.ctx_id = $scope.dadosTransferencia.ctx_id;
            dadosTransferencia.locDescricaoDestino = $scope.dadosTransferencia.loc.loc_descricao;
            dadosTransferencia.locIdDestino = $scope.dadosTransferencia.loc.loc_id;
            dadosTransferencia.ctcIdDestino = $scope.dadosTransferencia.ctc.ctc_id;
            dadosTransferencia.ctcDescricaoDestino = $scope.dadosTransferencia.ctc.ctc_descricao;
            dadosTransferencia.ctgorigem = $scope.dadosTransferencia.ctg.ctg_id;
            dadosTransferencia.ctgdestino = $scope.dadosTransferencia.ctgDestino.ctg_id;
            dadosTransferencia.mcc_numerodocumento = $scope.dadosTransferencia.mcc_numerodocumento;
            dadosTransferencia.valor = $scope.dadosTransferencia.valor;
            dadosTransferencia.mcc_complemento = $scope.dadosTransferencia.mcc_complemento;
            
            movimentoCaixaAppService.transferir(JSON.stringify(dadosTransferencia), true);
            setTimeout(function () {
                swal("Transferência realizada com sucesso!", "", "success");
            }, 100);
            $scope.modalTransferencia.close();
        }
    };

}]);