﻿newERP.controller('SupermercadoPdvController', ['$scope', '$timeout', 'ModalService', 'hotkeys', 'VendaService', '$state', 'DadosFormularioService', 'growlService', function ($scope, $timeout, ModalService, hotkeys, VendaService, $state, DadosFormularioService, growlService) {

    $scope.dadosItem = {
        pro_id: null,
        ean: '',
        quantidade: 1,
        unidadeMedida: 'Un',
        valorUnitario: 0,
        totalItem: 0,
        cancelado: false,
        produto: 'Aguardando Produto...'
    }

    $scope.zerarDadosItem = function () {
        $scope.dadosItem = {
            ean: '',
            quantidade: 1,
            valorUnitario: 0,
            totalItem: 0,
            cancelado: false,
            produto: 'Aguardando Produto...'
        }
    }

    $timeout(function () {
        var elementoCodProduto = document.getElementById('codigoEanProduto');
        if (elementoCodProduto) elementoCodProduto.focus();
    }, 100);

    $scope.favoritos = JSON.parse(produtoAppService.listarProdutosFavoritos());

    $scope.lerDados = function () {
        var dadosVenda = DadosFormularioService.retornaDados('supermercado-pdv', {
            itens: [],
            formasPagamento: [],
            consumidor: {
                cpfCnpj: '',
                nome: ''
            },
            valorFrete: 0,
            valorDescontos: 0,
            valorTotal: 0
        }).dados;

        if (!!dadosVenda) {
            $scope.cupomFiscal = dadosVenda;
            if ($scope.cupomFiscal.itens.length > 0) {
                if (VendaService.quantidadeItensCupom() == 0) {
                    VendaService.iniciaVenda($scope.cupomFiscal.consumidor.cpfCnpj);
                    angular.forEach($scope.cupomFiscal.itens, function (item) {
                        VendaService.adicionaItem(item);
                    });
                    swal("Cupom Fiscal Recuperado!!!", "", "info");
                }
            }
        }
    };

    var tabelaItensCancelar = '';
    var tabelaItens = document.getElementById('tabelaItem');

    $scope.ListaFavoritos = function () {
        $scope.favoritoSelecionado = 0;
        $scope.modalFavoritos = ModalService.model($scope, 'views/pdv/supermercado/modal_favoritos/modalFavoritos.html', 'lg', true, true, true);
    };

    $scope.ListarVendasRealizadas = function () {
        $scope.modalVendasRealizadas = ModalService.model($scope, 'views/pdv/supermercado/modal_vendarealizada/modalVendaRealizada.html', 'lg', true, true, true);
    };

    $scope.selecionaFavorito = function (indice) {
        $scope.favoritoSelecionado = indice;
    }

    $scope.keyEnterFavoritos = function () {
        $scope.dadosItem.ean = ""+$scope.favoritos[$scope.favoritoSelecionado].pro_id;
        $timeout(function () {
            $scope.modalFavoritos.close();
            $scope.adicionaItemCupom();
        }, 100);
    };
    $scope.keyLeftFavoritos = function () {
        if ($scope.favoritoSelecionado > 0) $scope.favoritoSelecionado--;
    };
    $scope.keyRightFavoritos = function () {
        if (($scope.favoritoSelecionado + 1) < $scope.favoritos.length) {
            $scope.favoritoSelecionado++;
        }
    };
    $scope.keyUpFavoritos = function () {
        if ($scope.favoritoSelecionado >= 5) {
            $scope.favoritoSelecionado -= 5;
        }
        else {
            $scope.favoritoSelecionado = 0;
        }
    };
    $scope.keyDownFavoritos = function () {
        $scope.favoritoSelecionado += 5;
        if ($scope.favoritos.length < $scope.favoritoSelecionado) {
            $scope.favoritoSelecionado = ($scope.favoritos.length-1);
        }
    };

    $scope.ListaMenuFiscal = function () {
        $scope.modalMenuFiscal = ModalService.model($scope, 'views/pdv/supermercado/modal_menufiscal/modalMenuFiscal.html', 'lg', true, true, true);
    };

    hotkeys.bindTo($scope)
    .add({
        combo: 'f1',
        description: 'Lista de funções do sistema (esta tela)',
        allowIn: ['INPUT'],
        callback: function () {
            hotkeys.toggleCheatSheet();
        }
    })
    .add({
        combo: 'f3',
        description: 'Lista de Vendas Realizadas',
        allowIn: ['INPUT'],
        callback: function () {
            $scope.ListarVendasRealizadas();
        }
    })
    .add({
        combo: 'f4',
        description: 'Lista de Produtos Favoritos',
        allowIn: ['INPUT'],
        callback: function () {
            $scope.ListaFavoritos();
        }
    })
    .add({
        combo: 'del',
        description: 'Remover um Item do Cupom Fiscal',
        allowIn: ['INPUT'],
        callback: function () {
            $scope.ListaItensCancelar();
        }
    })
    .add({
        combo: 'f8',
        description: 'Realizar Fechamento da Venda',
        allowIn: ['INPUT'],
        callback: function () {
            $scope.FecharVenda();
        }
    })
    .add({
        combo: 'ctrl+alt+f5',
        description: 'Verificar atualizações do aplicativo de PDV',
        allowIn: ['INPUT'],
        callback: function () {
            growlService.growl('Verificando atualizações...', 'inverse', 'center');
            aplicacaoService.verificarAtualizacoes();
        }
    })
    .add({
        combo: 'ctrl+alt+m',
        description: 'Exibir QRCode para conexão mobile',
        allowIn: ['INPUT'],
        callback: function () {
            ModalService.model($scope, 'views/pdv/acesso-api-pdv/modalAcessoApiPdv.html', 'lg', true, true, true);
        }
    })
    .add({
        combo: 'f12',
        description: 'Menu Fiscal',
        allowIn: ['INPUT'],
        callback: function () {
            $scope.ListaMenuFiscal();
        }
    })
    //.add({
    //    combo: 'ins',
    //    description: 'Abertura Caixa',
    //    allowIn: ['INPUT'],
    //    callback: function () {
    //        $scope.AbrirCaixa();
    //    }
    //})
    .add({
        combo: 'home',
        description: 'Fechamento de Caixa',
        allowIn: ['INPUT'],
        callback: function () {
            $scope.FecharCaixa();
        }
    }).add({
      combo: 'h',
      description: 'Abrir Chamado',
      allowIn: ['INPUT'],
      callback: function () {
        $scope.AbrirTicket();
      }
    }).add({
        combo: 'ctrl+f1',
        description: 'Cancelar Venda',
        allowIn: ['INPUT'],
        callback: function () {
            $scope.cancelarVenda();
        }
    })
    
    $scope.AbrirTicket = function () {      
      $scope.modalAberturaChamado = ModalService.model($scope, 'views/pdv/abertura-chamado/modalAberturaChamado.html', 'md', true, true, true);
    }

    //$scope.AbrirCaixa = function () {
    //    var controle = JSON.parse(controleCaixaAppService.listaControleCaixa(20));
    //    if (controle.length > 0) {
    //        swal("Já houve uma abertura de caixa!", "", "warning");
    //    } else {
    //        $scope.modalAberturaCaixa = ModalService.model($scope, 'views/pdv/controle_caixa/modalAberturaCaixa.html', 'lg', true, true, true);
    //    }

    //};


    $scope.FecharCaixa = function () {
        var controle = JSON.parse(controleCaixaAppService.listaControleCaixa());
        if (controle.length > 0) {
            $scope.modalFechamentoCaixa = ModalService.model($scope, 'views/pdv/controle_caixa/modalFechamentoCaixa.html', 'lg', true, true, true);
        } else {
            swal("Não existe caixa aberto!", "", "warning");
        }
    }

    if (typeof (w) == "undefined") {
        w = new Worker("js/workers/dataHora.js");
        w.onmessage = function (event) {
            $scope.dataHora = event.data;
            $scope.$digest();
        }
    }

    $scope.adicionaItemCupom = function () {
        if (!!$scope.dadosItem.ean) {
            if ($scope.dadosItem.ean.includes("*")) {
                var dadosProduto = $scope.dadosItem.ean.split('*');
                $scope.dadosItem.quantidade = parseFloat(dadosProduto[0]);
                $scope.dadosItem.ean = dadosProduto[1];
            }
            else {
                $scope.dadosItem.quantidade = 1;
            }
            var produto = JSON.parse(produtoAppService.listarProdutoCodigo($scope.dadosItem.ean));
            if (produto.length === 0) {
                $timeout(function () {
                    swal("Produto Não Encontrado!", "", "warning");
                }, 500)
            }
            else {
                $scope.dadosItem.produto = produto[0].pro_descricao;
                $scope.dadosItem.unidadeMedida = produto[0].ump_id;
                $scope.dadosItem.pro_id = produto[0].pro_id;
                $scope.imagemProduto = produto[0].imagemProduto;
                if (parseFloat(produto[0].valorProdutoBalanca) > 0) {
                    $scope.dadosItem.valorUnitario = parseFloat(produto[0].valorProdutoBalanca);
                }
                else {
                    if (parseFloat(produto[0].quantidadeProdutoBalanca) > 0) $scope.dadosItem.quantidade = parseFloat(produto[0].quantidadeProdutoBalanca);
                    $scope.dadosItem.valorUnitario = parseFloat(produtoAppService.retornaPrecoPadraoProduto(produto[0].pro_id));
                }
                if ($scope.dadosItem.valorUnitario === 0) {
                    $timeout(function () {
                        swal("O PREÇO do Produto: " + $scope.dadosItem.produto + " não foi encontrado.", "Este produto não poderá ser vendido!", "warning");
                        $scope.zerarDadosItem();
                    }, 500)
                }
                else {
                    if ($scope.cupomFiscal.itens.length === 0) {
                        VendaService.iniciaVenda($scope.cupomFiscal.consumidor.cpfCnpj);
                    }
                    if (parseFloat(produto[0].quantidadeProdutoBalanca) == 0 && parseFloat(produto[0].valorProdutoBalanca) == 0 && produto[0].pro_usabalanca == true) {
                        $scope.dadosItem.quantidade = '';
                        $timeout(function () {
                            balancaAppService.ativarBalanca();
                            $scope.modalItensCancelar = ModalService.model($scope, 'views/pdv/supermercado/modal_balanca/modalBalanca.html', 'md', true, true, true);
                        }, 100);
                    }
                    else {
                        $scope.dadosItem.totalItem = $scope.dadosItem.valorUnitario * $scope.dadosItem.quantidade;
                        VendaService.adicionaItem($scope.dadosItem);
                        $scope.cupomFiscal.valorTotal += $scope.dadosItem.totalItem;
                        $scope.cupomFiscal.itens.push(angular.copy($scope.dadosItem));
                        DadosFormularioService.armazenarDados('supermercado-pdv', $scope.cupomFiscal);
                        tabelaItens.scrollTop = tabelaItens.scrollHeight + 50;
                        $scope.dadosItem.ean = '';
                    }
                }
            }
        }
    };

    $scope.adicionaItemBalanca = function () {
        if (parseFloat($scope.dadosItem.quantidade) > 0) {
            balancaAppService.desativarBalanca();
            $scope.dadosItem.totalItem = $scope.dadosItem.valorUnitario * parseFloat($scope.dadosItem.quantidade.replace(",", "."));
            VendaService.adicionaItem($scope.dadosItem);
            $scope.cupomFiscal.valorTotal += $scope.dadosItem.totalItem;
            $scope.cupomFiscal.itens.push(angular.copy($scope.dadosItem));
            DadosFormularioService.armazenarDados('supermercado-pdv', $scope.cupomFiscal);
            tabelaItens.scrollTop = tabelaItens.scrollHeight + 50;
            $scope.dadosItem.ean = '';
        }
        else {
            swal("Você deve informar o peso do produto antes de adicioná-lo à venda atual.", "warning");
        }
    }

    $scope.keyEscBalanca = function () {
        $scope.modalItensCancelar.close();
        $scope.zerarDadosItem();
    }

    $scope.keyEnterBalanca = function () {
        $scope.modalItensCancelar.close();
        $scope.adicionaItemBalanca();
    }

    $scope.FecharVenda = function () {
        if ($scope.cupomFiscal.itens.length > 0) {
            $state.go('newpdv.finalizar-venda');
        }
        else {
            swal("Você não adicionou itens na venda.", "Antes de realizar o fechamento da venda você deve adicionar os produtos!", "warning");
        }
    };

    $scope.ListaItensCancelar = function () {
        $scope.itemCancelar = ($scope.cupomFiscal.itens.length - 1);
        while ($scope.cupomFiscal.itens[$scope.itemCancelar].cancelado == true) {
            $scope.itemCancelar--;
        }
        $scope.modalItensCancelar = ModalService.model($scope, 'views/pdv/supermercado/modal_itens/modalItens.html', 'lg', true, true, true);
        $timeout(function () {
            tabelaItensCancelar = document.getElementById('tabelaItemCancelar');
            tabelaItensCancelar.scrollTop = (tabelaItensCancelar.scrollHeight + 50);
        }, 20);
    };

    $scope.selecionaItemCancelar = function (indice) {
        $scope.itemCancelar = indice;
    };

    $scope.keyEnterCancelar = function () {
        if (VendaService.removerItem(($scope.itemCancelar + 1))) {
            $scope.cupomFiscal.valorTotal -= $scope.cupomFiscal.itens[$scope.itemCancelar].totalItem;
            $scope.cupomFiscal.itens[$scope.itemCancelar].cancelado = true;
            DadosFormularioService.armazenarDados('supermercado-pdv', $scope.cupomFiscal);
            $scope.modalItensCancelar.close();
        }
    };
    $scope.keyUpCancelar = function () {
        if ($scope.itemCancelar > 0) {
            $scope.itemCancelar--;
            if ($scope.cupomFiscal.itens[$scope.itemCancelar].cancelado == true) {
                $scope.keyUpCancelar();
            }
            tabelaItensCancelar.scrollTop = ($scope.itemCancelar * 50);
        }
    };
    $scope.keyDownCancelar = function () {
        if (($scope.itemCancelar+1) < $scope.cupomFiscal.itens.length) {
            $scope.itemCancelar++;
            if (($scope.itemCancelar + 1) == $scope.cupomFiscal.itens.length && $scope.cupomFiscal.itens[$scope.itemCancelar].cancelado == true) {
                $scope.itemCancelar--;
            }
            if ($scope.cupomFiscal.itens[$scope.itemCancelar].cancelado == true) {
                $scope.keyDownCancelar();
            }
            tabelaItensCancelar.scrollTop = ($scope.itemCancelar*50);
        }
    };

    $scope.recebePesoBalanca = function (peso) {
        $scope.dadosItem.quantidade = peso;
        $scope.$digest();
    }


    $scope.cancelarVenda = function () {
        $timeout(function () {
            swal({
                title: "Cancelar a venda?",
                text: "",
                type: "warning",
                showCancelButton: true,
                cancelButtonText: "Não",
                confirmButtonClass: "btn-danger",
                confirmButtonText: "Sim, quero cancelar",
                closeOnConfirm: true
            },
            function (isConfirm) {
                if (isConfirm) {
                    $timeout(function () {
                        DadosFormularioService.limparDados('supermercado-pdv');
                        $scope.zerarDadosItem();
                        $scope.imagemProduto = '';
                        $scope.dadosVenda = {};
                        $scope.lerDados();                        
                    })
                }
            })
        }, 100);
    }

    //    $scope.dadosPdv = JSON.parse(pdvAppService.listaDadosPdv($localStorage.codigoLocal));
    $scope.dadosPdv = JSON.parse(pdvAppService.listaDadosPdv(2));

    //function abreModal () {
        var controle = JSON.parse(controleCaixaAppService.listaControleCaixa());
        if (controle.length == 0) {
            $scope.modalAberturaCaixa = ModalService.model($scope, 'views/pdv/controle_caixa/modalAberturaCaixa.html', 'lg', true, true, true);
        }
    //};
    //abreModal();
}]);